import React, { Component } from 'react';
import { Container, Row, Col } from "react-bootstrap";
import { makeStyles, createMuiTheme, MuiThemeProvider } from '@material-ui/core/styles';
import { Typography } from '@material-ui/core';
import Images from '../../../assets/Images';
import UploadFile from "../../../library/Upload";
import MUIDataTable from "mui-datatables";
import { render } from '@testing-library/react';
import { ExcelRenderer } from 'react-excel-renderer';
import CreatePerusahaan from "./CreateCompany";
import EditPerusahaan from "./EditCompany"
import VisualPerusahaan from "./VisualCompany";
import api from "../../../api";
import ReactTooltip from 'react-tooltip';
import MuiAlert from '@material-ui/lab/Alert';
import { TextField, InputBase, Snackbar, withStyles } from "@material-ui/core";
// import DeletePerusahaan from "./DeletePerusahaan";
import PopUpFailedSave from '../../../library/PopUpFailedSave';
import PopUpDelete from "../../../library/PopUpDelete";
import Constant from '../../../library/Constant';
import { css } from "@emotion/core";
import PropagateLoader from "react-spinners/PropagateLoader"

var ct = require("../../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());
const options = ct.customOptions();
const options2 = ct.customOptions2();

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class Perusahaan extends Component {
    constructor(props) {
        super(props)
        this.state = {
            visibleCreate: false,
            visibleEdit: false,
            visibleVisual: false,
            visibleDelete: false,
            dataTable: [],
            listData: [],
            data: [],
            search: "",
            visiblePerusahaan: true,
            cols: null,
            rows: null,
            dataLoaded: false,
            popupError: false,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            create: false,
            edit: false,
            delete: false,
            load: false,
            judul: '',
            rowData: [],
            companyName: '',
            loading: false

        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                let payload = []
                isi.map((item, index) => {
                    if (item.length > 0) {
                        payload.push({
                            "id": index + 1,
                            "company_name": item[0] === undefined ? "" : item[0],
                            "company_parent": item[1] === undefined ? "" : item[1],
                            "unit_bisnis": item[2] === undefined ? "" : item[2],
                            "currency": item[3] === undefined ? "" :item[3],
                            "default_currency": item[4] === undefined ? "" :item[4],
                            "start_date": item[5] === undefined ? "" : item[5],
                            "end_date": item[6] === undefined ? "" :item[6]
                        })
                    }
                })
                let body = {
                    company: payload
                }
                console.log(resp.rows[1])
                this.setState({ payload: body, buttonError: false, judul: resp.rows[1][0] })
            }
        });
    }

    checkUpload() {
        api.create().checkUploadPerusahaan(this.state.payload).then(response => {
            console.log(response);
            let dataRow = []
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        dataRow = response.data.data.map((item, index) => {
                            return [
                                item.company_name,
                                item.company_parent,
                                item.unit_bisnis,
                                item.currency,
                                item.default_currency,
                                item.start_date,
                                item.end_date,
                                item.error
                            ]
                        })
                        let columns = [
                            {
                                name: "Company Name",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('company_name'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="company_name">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="company_name" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Parent Company",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('company_parent'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="company_parent">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="company_parent" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Business Unit",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('unit_bisnis'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="unit_bisnis">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="unit_bisnis" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Currency",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('currency'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="currency">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="currency" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Default Currency",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('default_currency'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="default_currency">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="default_currency" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid From",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('start_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="startdate">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="startdate" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid To",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('end_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="enddate">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="enddate" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "",
                                options: {
                                    display: false
                                }
                            }
                        ]

                        console.log(dataRow);
                        this.setState({
                            dataLoaded: true,
                            cols: columns,
                            rows: dataRow, visibleUpload: false, 
                            visiblePerusahaan: false
                        });
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    componentDidMount() {
        this.getData()
        this.getPermission()
    }

    getPermission() {
        let payload = {
            menu: "company"
        }
        api.create().getPermission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        create: response.data.data.create,
                        edit: response.data.data.edit,
                        delete: response.data.data.delete,
                        load: true
                    })
                } else {
                    this.setState({
                        load: true
                    })
                }
            }
        })
    }

    getData() {
        this.setState({loading: true})
        api.create().getPerusahaan().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.sort((a, b) => a.company_id - b.company_id).map((item, index) => {
                            return [index, item.company_id, item.company_name, item.parent_name, item.business_unit_name, item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data }, () => {
                            setTimeout(() => {
                              this.setState({loading: false})
                            }, 2000);
                          })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    openPopUp(rowData, type) {
        if (type === 'edit') {
            this.setState({
                rowData: rowData,
                visibleEdit: true
            })
        } else if (type === 'delete') {
            this.setState({
                rowData: rowData,
                companyName: String(rowData[2]),
                visibleDelete: true
            })
        } else {
            this.setState({
                rowData: rowData,
                visibleCreate: true
            })
        }
    }

    handleInputChange(e) {
        this.setState({ search: e })
        let body = {
            "keyword": e
        }
        api.create().searchPerusahaan(body).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.map((item, index) => {
                            return [index, item.company_id, item.company_name, item.parent_name, item.business_unit_name, item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    updatePerusahaan = (payload) => {
        this.setState({ visibleEdit: false })
        api.create().updatePerusahaan(payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    createPerusahaan = (payload) => {
        this.setState({ visibleCreate: false })
        api.create().createPerusahaan(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    updateHierarchy = (payload) => {
        this.setState({ visibleVisual: false, visiblePerusahaan: true })
        api.create().saveVisualisasiPerusahaan(payload).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    downloadFile = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/attachment/download_file?fileName=CompanyTemplate&&fileType=xlsx`
        )
        res = await res.blob()
        console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Company.xlsx';
            a.click();
        }
    }

    downloadDataTable = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/company/export_company`
        )
        res = await res.blob()
        console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Company.xlsx';
            a.click();
        }
    }

    uploadPerusahaan() {
        api.create().uploadPerusahaan(this.state.payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == "success") {
                        this.getData()
                        this.setState({ visiblePerusahaan: true, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    deleteCompany = (payload) => {
        let id = String(payload[1])
        api.create().deletePerusahaan(id).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ visibleDelete: false, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        const columns = [{
            name: "Action",
            options: {
                filter: false,
                sort: false,
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            {this.state.edit && 
                                <span>
                                    <a data-tip={'Edit'} data-for="edit">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent'
                                            }}
                                            // onClick={() => this.setState({ visibleEdit: true, data: tableMeta.rowData })}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'edit')}
                                        >
                                            <div style={{ display: 'flex' }}>
                                                {!tableMeta.rowData[2].includes("PT TRIPUTRA INVESTINDO ARYA") ?
                                                <img src={Images.editCopy} /> :
                                                null
                                                }
                                            </div >
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="edit" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                            {this.state.delete && 
                                <span>
                                    <a data-tip={'Delete'} data-for="delete">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                marginLeft: 10
                                            }}
                                            // onClick={() => this.setState({ visibleEdit: true, data: tableMeta.rowData })}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'delete')}
                                        >                                        
                                            <div style={{ display: 'flex' }}>
                                                {!tableMeta.rowData[2].includes("PT TRIPUTRA INVESTINDO ARYA") ?
                                                <img src={Images.delete} /> :
                                                null
                                                }
                                            </div >
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="delete" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                        </div>
                    );
                }
            }
        }, {
            name: "ID",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[5] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Company Name",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[5] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Parent Company",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[5] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Business Unit",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[5] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Status",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[5] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }]
        const data = [
            ["", "1", "Triputra Agro Persada Group", "Triputra Investindo Arya", "Agrobisnis", "5", "Aktif"],
            ["", "2", "Gawi Bahandep Sawit Mekar", "Triputra Agro Persada Group", "Agrobisnis", "2", "Aktif"],
            ["", "3", "Puninar Group", "Triputra Investindo Arya", "Service", "5", "Aktif"],
            ["", "4", "Puninar Infinite Raya", "Puninar Group", "Service", "5", "Non Aktif"],
            ["", "-", "-", "-", "-", "-"],
        ]
        const loadingComponent = (
            <div style={{position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)'}}>
              <PropagateLoader
                // css={override}
                size={20}
                color={"#274B80"}
                loading={this.state.loading}
              />
            </div>
          );
        return (
            <div style={{ height: this.props.height }}>
                {/* <Row> */}
                <div className={"main-color"} style={{ height: 195, width: '100%' }} />
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {this.state.loading && loadingComponent}
                {this.state.visiblePerusahaan === true ?
                    this.state.load && (
                        <div>
                            <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -181 }}>
                                <label style={{ color: 'white', fontSize: 16, alignSelf: 'center', width: '20%', }}>Master Data - Company</label>
                                {/* <div style={{ color: 'white', width: '50%', height: 37, display: 'flex', backgroundColor: 'white', borderWidth: 2, alignItems: 'center', borderRadius: 6, paddingLeft: 5, paddingRight: 5, alignSelf: 'center' }}>
                                    <img src={Images.searchBlack} style={{ marginRight: 10 }} />
                                    <InputBase
                                        style={{ width: '100%' }}
                                        placeholder="Search"
                                        value={this.state.search}
                                        onChange={(e) => this.handleInputChange(e.target.value)}
                                        inputProps={{ 'aria-label': 'naked' }}
                                    />
                                </div> */}
                                <div style={{ width: '30%', justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                    <a data-tip={'Download Template'} data-for="template">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadFile()}
                                        >
                                            <img src={Images.template} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                    {this.state.create && (
                                        <a data-tip={'Upload'} data-for="upload">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => this.setState({ visibleUpload: true })}
                                            >
                                                <img src={Images.upload} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                    <a data-tip={'Download'} data-for="download">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadDataTable()}
                                        >
                                            <img src={Images.download} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                    <a data-tip={'Visualization'} data-for="visual">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.setState({ visibleVisual: true, visiblePerusahaan: false })}
                                        >
                                            <img src={Images.visualisasi} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="visual" place="bottom" type="light" effect="solid" />
                                    {this.state.create && (
                                        <a data-tip={'Add New'} data-for="create">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5,
                                                    marginRight: 20
                                                }}
                                                onClick={() => this.setState({ visibleCreate: true })}
                                            >
                                                <img src={Images.add} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="create" place="bottom" type="light" effect="solid" />
                                </div>
                            </div>
                            <div style={{ padding: 25 }}>
                                <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        theme={getMuiTheme()}
                                        data={this.state.dataTable}
                                        columns={columns}
                                        options={options}
                                    />
                                </MuiThemeProvider>

                            </div>
                        </div>
                    )
                    :
                    this.state.visibleVisual === true ?
                        <VisualPerusahaan
                            buttonCreate={this.state.create}
                            buttonEdit={this.state.edit}
                            onClickClose={() => this.setState({ visibleVisual: false, visiblePerusahaan: true })}
                            height={this.props.height}
                            updateHierarchy={this.updateHierarchy.bind(this)}
                            handleLoading={() => this.setState({loading: true}, () => console.log('aksdkas'))}
                        />
                        :
                        <div>
                            <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -150 }}>
                                <label style={{ color: 'white', fontSize: 16, alignSelf: 'center' }}>Preview Data</label>
                            </div>
                            <div style={{ padding: 25 }}>
                                {this.state.dataLoaded && (
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            theme={getMuiTheme()}
                                            data={this.state.rows}
                                            columns={this.state.cols}
                                            options={options2}
                                        />
                                    </MuiThemeProvider>
                                )}
                            </div>
                            <div style={{ display: 'flex', width: '100%', placeContent: 'flex-end', padding: 20 }}>
                                <button
                                    type="button"
                                    onClick={() => this.setState({ visiblePerusahaan: true })}
                                    style={{ marginRight: 20 }}
                                >
                                    <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                        <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                    </div>
                                </button>
                                <button
                                    type="button"
                                    disabled={this.state.buttonError == true ? true : false}
                                    onClick={() => this.uploadPerusahaan()}
                                    // onClick={() => this.state.buttonError ? this.setState({ popupError: true }) : this.uploadPerusahaan()}
                                    style={{}}
                                >
                                    <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                        <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                    </div>
                                </button>
                            </div>
                        </div>
                }

                {this.state.visibleCreate && (
                    <CreatePerusahaan
                        onClickClose={() => this.setState({ visibleCreate: false })}
                        type={"create"}
                        createPerusahaan={this.createPerusahaan.bind(this)}
                    />
                )}

                {this.state.visibleEdit && (
                    <CreatePerusahaan
                        type={"edit"}
                        onClickClose={() => this.setState({ visibleEdit: false })}
                        data={this.state.rowData}
                        updatePerusahaan={this.updatePerusahaan.bind(this)}
                    />
                )}

                {/* {this.state.visibleEdit && (
                    <EditPerusahaan
                        type={"edit"}
                        onClickClose={() => this.setState({ visibleEdit: false })}
                        data={this.state.listData[this.state.selectIndex]}
                        updatePerusahaan={this.updatePerusahaan.bind(this)}
                    />
                )} */}

                {/* {this.state.visibleDelete && (
                    <DeletePerusahaan
                        type={"delete"}
                        onClickClose={() => this.setState({ visibleDelete: false })}
                        data={this.state.rowData}
                        deleteCompany={this.deleteCompany.bind(this)}
                    />
                )} */}

                {this.state.popupError && (
                    <PopUpFailedSave onClickClose={() => this.setState({ popupError: false })} />
                )}

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => {
                                    String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("DATA") && String(this.state.judul).includes("COMPANY") ?
                                    this.checkUpload() :
                                    this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning'})
                                }}
                            />
                        </div>
                    </div>
                )}

                {this.state.visibleDelete && (
                    <PopUpDelete
                        rowData={this.state.rowData}
                        name={this.state.companyName}
                        onClickClose={() => this.setState({ visibleDelete: false })}
                        onClickDelete={this.deleteCompany.bind(this)}
                    />
                )}

            </div>
        );
    }
}