import React, { Component } from 'react';
import { Typography, MuiThemeProvider, createMuiTheme, Paper, TextField } from '@material-ui/core';
import MUIDataTable from "mui-datatables";
import Images from '../../assets/Images';
import DonutChart from 'react-d3-donut';
import Constant from '../../library/Constant';
import api from '../../api';
import { Link } from 'react-router-dom';
import { PropagateLoader } from 'react-spinners';
import { titleCase } from '../../library/Utils';
import { format } from 'date-fns';
import Autocomplete from '@material-ui/lab/Autocomplete';
import ReactSpeedometer from 'react-d3-speedometer';

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());

class HomePage extends Component {
    constructor(props) {
        super(props)
        this.state = {
            userData: null,
            listDashboard: [],
            listMasterBudget: [
                { nama: 'Triputra Agro Persada', status: 'complete' },
                { nama: 'Puninar Infinite Raya', status: 'complete' },
                { nama: 'Dharma Group', status: 'overdue' },
                { nama: 'Daya Group', status: 'open' },
            ],
            isApprover: true,
            listSubcoMB: [],
            listSubcoMR: [],
            listSubcoRO: [],
            listSubcoOL: [],
            valueSubmit: 0,
            listdmb: [],
            dataTableMB: [],
            listPeriodeMB: null,
            listPeriodeMR: null,
            listPeriodeRO: null,
            listPeriodeOL: null,
            listMonth: null,
            periodeMB: null,
            periodeMR: null,
            periodeRO: null,
            periodeOL: null,
            month: null,
            monthCAT: null,
            periodeCAT: null,
            loading: false,
            accessMB: false,
            accessMR: false,
            accessRO: false,
            accessOL: false,
            company: [],
            dataDashboardCAT: [],
            loading2: false,
            loading3: false,
            parameterPerfom: [],
            quarterList: [
                { value: 'q1', name: 'Q1' },
                { value: 'q2', name: 'Q2' },
                { value: 'q3', name: 'Q3' },
            ],
            quarter: null
        }
    }

    componentDidMount() {
        this.setState({ loading: true, loading2: true, loading3: true })
        let userId = localStorage.getItem(Constant.USER)
        api.create().getDetailUser(userId).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ userData: response.data.data })
                        // console.log(response.data.data)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
        // api.create().checkApprover().then(response => {
        //     console.log(response);
        //     if (response.data.data.is_approver === true) {
        //         this.setState({ isApprover: true }, () =>
        //             this.getDashboard())
        //     } else {
        //         this.setState({ isApprover: false })
        //     }
        // })
        this.getPermissionMB()
        this.getPermissionMR()
        this.getPermissionRO()
        this.getPermissionOL()
        this.getApprMat()
        // this.getListUserSubco()
        this.getMonth()
    }

    componentDidUpdate() {
        window.onpopstate = e => {
            //your code...
            this.props.selectIndex('Home')
        }
    }

    getPeriode() {
        let currentYear = new Date().getFullYear()
        let MB = []
        let MR = []
        let ROut = []
        let OL = []
        for (var i = 2000; i <= currentYear; i++) {
            MB.push({ name: String(i), value: i })
            MR.push({ name: String(i), value: i })
            ROut.push({ name: String(i), value: i })
            OL.push({ name: String(i), value: i })
            if (i == currentYear) {
                MB.push({ name: String(i + 1), value: i + 1 })
            }
        }

        let defaultPropsMB = {
            options: MB,
            getOptionLabel: (option) => option.name,
        };

        let defaultPropsMR = {
            options: MR,
            getOptionLabel: (option) => option.name,
        };

        let defaultPropsRO = {
            options: ROut,
            getOptionLabel: (option) => option.name,
        };

        let defaultPropsOL = {
            options: OL,
            getOptionLabel: (option) => option.name,
        };
        // console.log(MR[MR.length - 1])
        let dateNow = new Date()
        dateNow.setMonth(dateNow.getMonth() - 1);
        let yearNow = dateNow.getFullYear()
        let indexMonthMR = MR.findIndex((val) => val.value == yearNow)
        let indexMonthRO = ROut.findIndex((val) => val.value == yearNow)
        let indexMonthOL = OL.findIndex((val) => val.value == yearNow)

        let defaultPropsQuarter = {
            options: this.state.quarterList,
            getOptionLabel: (option) => option.name
        }

        this.setState({ listPeriodeMB: defaultPropsMB, 
                        periodeMB: MB[MB.length - 1], 
                        listPeriodeMR: defaultPropsMR, 
                        periodeMR: MR[indexMonthMR], 
                        listPeriodeRO: defaultPropsRO, 
                        periodeRO: ROut[indexMonthRO],
                        listQuarter: defaultPropsQuarter, 
                        quarter: this.state.quarterList[0],
                        listPeriodeOL: defaultPropsOL, 
                        periodeOL: OL[indexMonthOL],
                        listPeriodeCAT: defaultPropsMB, 
                        periodeCAT: MB[indexMonthMR] }, () => {
            this.getParameterGroupPerfom()
        })
    }

    getDashboardCAT() {
        console.log(this.state.company)
        api.create().getListChildDashboardCAT(this.state.periodeCAT.value, this.state.monthCAT.month_id).then((res) => {
            if (res.data) {
                // console.log(res)
                let response = res.data.data.business_unit
                let data = []
                response.map((item, index) => {
                    let arrayChild = []
                    item.category.map((items, indexs) => {
                        if (this.state.company.includes(items.company_id)) {
                            let indexPerform = this.state.parameterPerfom.findIndex((val) => val.company_id == items.company_id)
                            let listPerfomanceDefault = []
                            if (indexPerform == -1) {
                                listPerfomanceDefault = this.state.parameterPerfom.filter((val) => String(val.company_name).toLocaleLowerCase() == "default")
                            } else {
                                listPerfomanceDefault = this.state.parameterPerfom.filter((val) => val.company_id == items.company_id)
                            }
                            let performanceScore = ''
                            let perfomanceScoreColor = '#fff'
                            if (listPerfomanceDefault.length > 0) {
                                listPerfomanceDefault.map((item, index) => {
                                    // console.log(Number(lastTotal))
                                    // console.log(Number(item.min_value))
                                    // console.log(Number(item.max_value))
                                    if (Number(items.current_value).toFixed(2) >= Number(item.min_value) && Number(items.current_value).toFixed(2) <= Number(item.max_value)) {
                                        // console.log('masuk')
                                        performanceScore = item.description
                                        perfomanceScoreColor = item.value
                                    }
                                })
                            }
                            arrayChild.push({ ...items, current_value: Number(items.current_value).toFixed(2), performanceColor: perfomanceScoreColor, performanceScore })
                        }
                    })
                    if (arrayChild.length > 0 && String(item.item_business).toLocaleLowerCase() != 'holding') {
                        data.push({ ...item, category: arrayChild })
                    }
                })
                // console.log(this.state.parameterPerfom)
                console.log(data)
                this.setState({ dataDashboardCAT: data, loading: false, loading2: false }, () => {
                    setTimeout(() => {
                        this.setState({loading3: false})
                    }, 1000);
                })
            }
        })
    }

    getMonth() {
        api.create().getMonthTransaction().then(response => {
            let dateNow = new Date()
            dateNow.setMonth(dateNow.getMonth() - 1);
            let month = format(dateNow, 'MMMM')
            // console.log(month);
            if (response.data) {
                if (response.data.status === "success") {
                    // console.log(response);
                    let data = response.data.data
                    let monthData = data.map((item) => {
                        return {
                            month_id: item.id,
                            month_value: String(item.month_name).substr(0, 3)
                        }
                    })
                    let defaultProps = {
                        options: monthData,
                        getOptionLabel: (option) => option.month_value,
                    };
                    let index = data.findIndex((val) => val.month_name == month)
                    // console.log(month)
                    // console.log(index)
                    this.setState({ listMonth: defaultProps, listMonthCAT: defaultProps, monthCAT: monthData[index], month: index == -1 ? monthData[0] : monthData[index] }, () => {
                        // if (this.state.isApprover === true) {
                        //     if (this.state.submittedOnly) {
                        //         console.log('masuk cuk')
                        //         this.getPeriode()
                        //     } else {
                        //         this.getLastPeriod()
                        //     }
                        this.getPeriode()
                        // } else {
                        // this.getLastPeriod()
                        // this.getPeriode()
                        // }
                    })
                } else {
                    // this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                    //     if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                    //         setTimeout(() => {
                    //             localStorage.removeItem(Constant.TOKEN)
                    //             window.location.reload();
                    //         }, 1000);
                    //     }
                    // })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
            }
        })
    }

    getPermissionMB() {
        let payload = {
            menu: "Master Budget & CAT"
        }
        api.create().getPermission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        btnCreateMB: response.data.data.create,
                        btnEditMB: response.data.data.edit,
                        load: true
                    }, () => {
                        if (this.state.btnCreateMB === true && this.state.btnEditMB === true) {
                            this.setState({ accessMB: true })
                        }
                    })
                } else {
                    this.setState({
                        load: true
                    })
                }
            } else {
                this.setState({ load: true })
            }
        })
    }

    getPermissionMR() {
        let payload = {
            menu: "monthly report"
        }
        api.create().getPermission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        btnCreateMR: response.data.data.create,
                        btnEditMR: response.data.data.edit,
                        load: true
                    }, () => {
                        if (this.state.btnCreateMR === true && this.state.btnEditMR === true) {
                            this.setState({ accessMR: true })
                        }
                    })
                } else {
                    this.setState({
                        load: true
                    })
                }
            } else {
                this.setState({ load: true })
            }
        })
    }

    getPermissionRO() {
        let payload = {
            menu: "rolling outlook & cat revision"
        }
        api.create().getPermission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        btnCreateRO: response.data.data.create,
                        btnEditRO: response.data.data.edit,
                        load: true
                    }, () => {
                        if (this.state.btnCreateRO === true && this.state.btnEditRO === true) {
                            this.setState({ accessRO: true })
                        }
                    })
                } else {
                    this.setState({
                        load: true
                    })
                }
            } else {
                this.setState({ load: true })
            }
        })
    }

    getPermissionOL() {
        let payload = {
            menu: "outlook performance appraisal"
        }
        api.create().getPermission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        btnCreateOL: response.data.data.create,
                        btnEditOL: response.data.data.edit,
                        load: true
                    }, () => {
                        if (this.state.btnCreateOL === true && this.state.btnEditOL === true) {
                            this.setState({ accessOL: true })
                        }
                    })
                } else {
                    this.setState({
                        load: true
                    })
                }
            } else {
                this.setState({ load: true })
            }
        })
    }

    getDetailUser() {
        let userId = localStorage.getItem(Constant.USER)
        api.create().getDetailUser(userId).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ tempData: response.data.data, company: response.data.data.company }, () =>
                            this.getDashboardCAT())
                        // console.log(response.data.data)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getListUserSubcoMB() {
        // console.log(this.state.month.month_id)
        // console.log(this.state.periodeMR.value)
        api.create().getListUserSubcoMB(this.state.periodeMB.value).then((response) => {
            // console.log(response)
            let valueSubmit = 0
            let dataMB = []
            if (response.data) {
                if (response.data.status === "success") {
                    response.data.data.map((item, index) => {
                        if (item.is_submit === true) {
                            valueSubmit += 1
                        }
                        dataMB.push(item)

                    })
                    this.setState({
                        listSubcoMB: dataMB,
                        valueSubmit,
                        loading: false
                    })
                }
            } else {
                this.setState({ loading: false })
            }
        })
    }

    getListUserSubcoMR() {
        // console.log(this.state.month.month_id)
        // console.log(this.state.periodeMR.value)
        api.create().getListUserSubcoMR(this.state.month.month_id, this.state.periodeMR.value).then((response) => {
            let valueSubmitMR = 0
            let dataMR = []
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    response.data.data.map((item, index) => {
                        if (item.is_submit === true) {
                            valueSubmitMR += 1
                        }
                        dataMR.push(item)
                    })
                    this.setState({
                        listSubcoMR: dataMR,
                        valueSubmitMR,
                        loading: false
                    })
                }
            } else {
                this.setState({ loading: false })
            }
        })
    }

    getListUserSubcoRO() {
        // console.log(this.state.month.month_id)
        // console.log(this.state.periodeMR.value)
        api.create().getListUserSubcoRO(this.state.periodeRO.value, this.state.quarter.value).then((response) => {
            let valueSubmitRO = 0
            let dataRO = []
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    response.data.data.map((item, index) => {
                        if (item.is_submit === true) {
                            valueSubmitRO += 1
                        }
                        dataRO.push(item)
                    })
                    this.setState({
                        listSubcoRO: dataRO,
                        valueSubmitRO,
                        loading: false
                    })
                }
            } else {
                this.setState({ loading: false })
            }
        })
    }

    getListUserSubcoOL() {
        // console.log(this.state.month.month_id)
        // console.log(this.state.periodeOL.value)
        api.create().getListUserSubcoOL(this.state.periodeOL.value).then((response) => {
            let valueSubmitOL = 0
            let dataOL = []
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    response.data.data.map((item, index) => {
                        if (item.is_submit === true) {
                            valueSubmitOL += 1
                        }
                        dataOL.push(item)
                    })
                    this.setState({
                        listSubcoOL: dataOL,
                        valueSubmitOL,
                        loading: false
                    })
                }
            } else {
                this.setState({ loading: false })
            }
        })
    }

    getListUserSubco() {
        api.create().getDashboardUser().then(response => {
            // console.log(response);
            let valueSubmit = 0
            let valueSubmitMR = 0
            let dataMB = []
            let dataMR = []
            if (response.data) {
                if (response.data.status === "success") {
                    response.data.data.map((item, index) => {
                        if (item.is_submit === true && item.type === "master_budget") {
                            valueSubmit += 1
                        } else if (item.is_submit === true && item.type === "monthly_report") {
                            valueSubmitMR += 1
                        }

                        if (item.type === "master_budget") {
                            dataMB.push(item)
                        } else {
                            dataMR.push(item)
                        }
                    })
                    this.setState({
                        listSubcoMB: dataMB,
                        listSubcoMR: dataMR,
                        valueSubmit,
                        valueSubmitMR,
                        loading: false
                    })
                }
            }
            // console.log(this.state.listSubcoMB)
            // console.log(this.state.listSubcoMR)
        })
    }

    getDashboard() {
        let listDashboard = []
        let rawData = []
        api.create().getDashboard().then((response) => {
            console.log(response);
            console.log(this.state.isApproverMB);
            console.log(this.state.isApproverMR);
            console.log(this.state.isApproverRO);
            console.log(this.state.isApproverOL);
            if (String(response.data.status).toLocaleLowerCase() == 'success') {
                let data = response.data.data
                data.map((item, index) => {
                    let statusConvert = item.status == 'approval_review' ? 'Waiting For Review' : item.status == 'approval_proccess' ? 'Waiting For Approval' : titleCase(item.status)
                    if (this.state.isApproverMB && this.state.isApproverMR && this.state.isApproverRO && this.state.isApproverOL) {
                        if (String(item.type_report).toLocaleLowerCase().includes("master")) {
                            listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} - ${item.periode}`, item.revision, item.status, statusConvert])
                            rawData.push(item)
                        } else if (String(item.type_report).toLocaleLowerCase().includes("monthly")) {
                            listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} ${item.periode}`, item.revision, item.status, statusConvert])
                            rawData.push(item)
                        } else if (String(item.type_report).toLocaleLowerCase().includes("rolling")) {
                            listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} ${item.periode}`, item.revision, item.status, statusConvert])
                            rawData.push(item)
                        } else if (String(item.type_report).toLocaleLowerCase().includes("pa")) {
                            listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} ${item.periode}`, item.revision, item.status, statusConvert])
                            rawData.push(item)
                        } 
                    } else {
                        if (this.state.isApproverMB) {
                            if (String(item.type_report).toLocaleLowerCase().includes("master")) {
                                listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} - ${item.periode}`, item.revision, item.status, statusConvert])
                                rawData.push(item)
                            }
                        } 
                        if (this.state.isApproverMR) {
                            if (String(item.type_report).toLocaleLowerCase().includes("monthly")) {
                                listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} ${item.periode}`, item.revision, item.status, statusConvert])
                                rawData.push(item)
                            }
                        } 
                        if (this.state.isApproverRO) {
                            if (String(item.type_report).toLocaleLowerCase().includes("rolling")) {
                                listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} ${item.periode}`, item.revision, item.status, statusConvert])
                                rawData.push(item)
                            }
                        }
                        if (this.state.isApproverOL) {
                            if (String(item.type_report).toLocaleLowerCase().includes("pa")) {
                                listDashboard.push([index + 1, item.approval_id, item.company_name, `${item.type_report} ${item.periode}`, item.revision, item.status, statusConvert])
                                rawData.push(item)
                            }
                        }
                    }
                })
                this.setState({ listDashboard, rawData })
            }
        })
    }

    getApprMat() {
        this.setState({ loading: true })
        let isApproverMR = false
        let isApproverMB = false
        let isApproverRO = false
        let isApproverOL = false
        api.create().getAM().then((response) => {
            console.log(response);
            let actAMActive = []
            let actAM = response.data.data.map((item, index) => {
                if (String(item.status).toLocaleLowerCase() == 'active') {
                    actAMActive.push(item)
                    return item
                }
            })
            let userId = localStorage.getItem(Constant.USER)
            // console.log(userId);
            let indexId = actAMActive.findIndex((val) => val.user_id == userId)
            actAMActive.map((item, index) => {
                if (item.approval_type_name === "MONTHLY_REPORT") {
                    isApproverMR = true
                } else if (item.approval_type_name === "MASTER_BUDGET") {
                    isApproverMB = true
                } else if (item.approval_type_name === "ROLLING_OUTLOOK") {
                    isApproverRO = true
                } else if (item.approval_type_name === "OUTLOOK_PA") {
                    isApproverOL = true
                }
            })

            if (indexId === -1) {
                this.setState({ isApprover: false })
                this.getMonth()
                // this.getListUserSubco()
            }
            this.setState({ isApproverMB, isApproverMR, isApproverRO, isApproverOL })
            this.getDashboardMB()
            // this.getDashboardMB()
            this.getDashboard()
            // console.log(actAM)
            this.setState({ loading: false })
        })
    }

    getDashboardMB() {
        api.create().getDashboardMB().then((response) => {
            // console.log(response)
            if (String(response.data.status).toLocaleLowerCase() == 'success') {
                let data = response.data.data
                let listdmb = data.sort((a, b) => a.company_id - b.company_id).map((item, index) => {
                    return [
                        item.company_name,
                        item.master_budget,
                        item.operating_indicator
                    ]
                })
                this.setState({ dataTableMB: listdmb, loading: false })
            }
        })
    }

    handleBackgroundPerform(total) {
        let color = 'white'
        if (total >= 1.00 && total <= 2.00) {
            color = 'red'
        } else if (total >= 2.01 && total <= 2.75) {
            color = 'yellow'
        } else if (total >= 2.76 && total <= 3.00) {
            color = 'lightgreen'
        } else if (total >= 3.01 && total <= 3.75) {
            color = 'yellowgreen'
        } else if (total >= 3.76 && total <= 4.00) {
            color = 'forestgreen'
        } else if (total >= 4.01 && total <= 4.75) {
            color = 'deepskyblue'
        } else if (total >= 4.76 && total <= 5.00) {
            color = 'dodgerblue'
        }
        return color
    }

    getParameterGroupPerfom() {
        api.create().getParameterByGroupName({
            "group_name": "PERFORMANCE_KPI"
        }).then((response) => {
            console.log(response.data)
            if (response.data) {
                this.setState({ parameterPerfom: response.data.data } , () => {
                    this.getListUserSubcoMB()
                    this.getListUserSubcoMR()
                    this.getListUserSubcoRO()
                    this.getListUserSubcoOL()
                    this.getDetailUser()
                })
            } else {
                this.setState({ parameterPerfom: [] } , () => {
                    this.getListUserSubcoMB()
                    this.getListUserSubcoMR()
                    this.getListUserSubcoRO()
                    this.getListUserSubcoOL()
                    this.getDetailUser()
                })
            }
        })
    }

    render() {
        const getDataMonth = (item) => {
            let months = item.months
            let dataMonth = this.state.listMonth.options
            let indexID = dataMonth.findIndex((val) => val.month_id == months)
            // console.log(dataMonth[indexID])
            return dataMonth[indexID]
        }

        const columns = ["#", "ID", "Company", "Report Type", "Revision",
            {
                name: "",
                options: {
                    display: false
                }
            }, 'Status', {
                name: "Action",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        // console.log(tableMeta);
                        // console.log(this.state.rawData);
                        return (
                            <div style={{ display: 'flex' }}>
                                <Link to={{
                                    pathname: String(tableMeta.rowData[3]).toLocaleLowerCase().includes("master") ? `/home/master-budget/` : String(tableMeta.rowData[3]).toLocaleLowerCase().includes("monthly") ? `/home/monthly-report/` : String(tableMeta.rowData[3]).toLocaleLowerCase().includes("rolling") ? `/home/rolling-outlook/` : `/home/outlook-performance/`,
                                    state: {
                                        userType: 'approver',
                                        rawData: {...this.state.rawData[tableMeta.rowIndex], quarter: String(tableMeta.rowData[3]).toLocaleLowerCase().includes("rolling") ? this.state.rawData[tableMeta.rowIndex].quartal : null },
                                        month: String(tableMeta.rowData[3]).toLocaleLowerCase().includes("master") ? null : getDataMonth(this.state.rawData[tableMeta.rowIndex]),
                                        quarter: String(tableMeta.rowData[3]).toLocaleLowerCase().includes("rolling") ? this.state.rawData[tableMeta.rowIndex].quartal : null
                                    }
                                }}>
                                    <button
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            marginRight: 10
                                        }}
                                        onClick={() => null}
                                    >
                                        <img src={Images.editCopy2} />
                                    </button>
                                </Link>
                            </div >
                        );
                    }
                }
            }]
        const data = [
            ["1", "TRIPUTRA AGRO PERSADA", "Laporan Bulanan - September 2020", "1 (20 Oktober 2020)", "Belum Disetujui"],
            ["2", "DAYA GROUP", "Laporan Bulanan - September 2020", "1 (20 Oktober 2020)", "Belum Disetujui"],
            ["3", "PUNINAR INFINITE RAYA", "Budget Tahunan 2021", "0 (20 Oktober 2020)", "Belum Disetujui"],
            ["4", "DHARMA GROUP", "Laporan Bulanan - September 2020", "0 (20 Oktober 2020)", "Belum Disetujui"],
            ["5", "PUNINAR INFINITE RAYA", "Budget Tahunan 2021", "0 (20 Oktober 2020)", "Belum Disetujui"],
        ]
        const options = {
            filter: true,
            sort: false,
            responsive: "scroll",
            print: false,
            download: false,
            selectableRows: false,
            viewColumns: true,
            rowsPerPage: 5,
            search: true
        }

        const columnsMB = ["Company", "Master Budget & CAT", "Operating Indicator"]

        const dataChart = [{
            count: 90,
            color: '#5198ea',
            name: 'My name',
        }, {
            count: 10,
            color: '#ffd600',
            name: 'name',
        }]
        const dataChart2 = [{
            count: 90,
            color: '#f65a4c',
            name: 'My name',
        }, {
            count: 10,
            color: '#5198ea',
            name: 'name',
        }]
        const dataChart3 = [{
            count: 90,
            color: '#4caf51',
            name: 'My name',
        }, {
            count: 10,
            color: '#f65a4c',
            name: 'name',
        }]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );
        let bulan = format(new Date(), 'MMM')
        let tahun = new Date().getFullYear()
        return (
            <div style={{ flex: 1, backgroundColor: '#f8f8f8', minHeight: this.props.height }}>
                {(this.state.loading || this.state.loading2 || this.state.loading3) && loadingComponent}
                {this.state.isApprover === true ?
                    <div>
                        <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                            <Typography style={{ fontSize: '24px', color: 'white' }}>{this.state.userData === null ? '' : `Welcome, ${this.state.userData.fullname} !`}</Typography>
                        </div>
                        <div>
                            <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                <Typography style={{ color: '#656565', fontSize: '16px', fontWeight: 'bold' }}>Dashboard CAT</Typography>
                                <div style={{ display: 'flex' }}>
                                    <Autocomplete
                                        {...this.state.listMonthCAT}
                                        id="monthCAT"
                                        onChange={(event, newInputValue) => this.setState({ monthCAT: newInputValue, loading: true, loading3: true}, () => {
                                            this.getDashboardCAT()
                                            // if (this.state.isApprover === true) {
                                            //     this.getCompanySubmitted()
                                            // } else {
                                            // this.setState({ visibleTableHistory: false })
                                            // this.getRevision()
                                            // }
                                        })}
                                        disableClearable
                                        style={{ minWidth: 250, marginRight: 20 }}
                                        renderInput={(params) => <TextField {...params} label="Month CAT" margin="normal" style={{ marginTop: 7 }} />}
                                        value={this.state.monthCAT}
                                    />
                                    <Autocomplete
                                        {...this.state.listPeriodeCAT}
                                        id="periodeCAT"
                                        onChange={(event, newInputValue) => this.setState({ periodeCAT: newInputValue, loading: true, loading3: true }, () => {
                                            this.getDashboardCAT()
                                            // if (this.state.isApprover === true) {
                                            //         this.getCompanySubmitted()
                                            // } else {
                                            // this.setState({ visibleTableHistory: false })
                                            // this.getRevision()
                                            // }
                                        })}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) => <TextField {...params} label="Periode CAT" margin="normal" style={{ marginTop: 7 }} />}
                                        value={this.state.periodeCAT}
                                    />
                                </div>
                                {this.state.dataDashboardCAT.map((item, index) => {
                                    return (
                                        <div>
                                            <Typography style={{ color: '#656565', fontSize: '16px', marginTop: 20 }}>{item.item_business}</Typography>
                                            <div style={{ display: 'flex', overflowX: 'scroll', width: this.props.width * 0.95 }}>
                                                {item.category.map((items, indexs) => {
                                                    return (
                                                        <Link to={{
                                                            pathname: `/home/cat-dashboard/`,
                                                            state: {
                                                                userType: 'user',
                                                                rawData: { month: this.state.monthCAT.month_id, periode: this.state.periodeCAT.value, companyId: items.company_id }
                                                            }
                                                        }}>
                                                            <div style={{ padding: 10, backgroundColor: '#fff', height: 350, borderRadius: 6, paddingBottom: 20, margin: 10, boxShadow: '0 1px 4px 0 rgba(0, 0, 0, 0.25)', width: 250, marginRight: indexs == item.category.length - 1 ? 25 : 0, marginLeft: indexs == 0 ? 5 : 25 }}>
                                                                {/* <span style={{ fontSize: '17px', color: this.state.selectIndex === index ? '#fff' : '#7e8085', maxWidth: 100 }}>{item.category_name}</span> */}
                                                                <div style={{ fontSize: '17px', width: '100%', height: 25 }}>
                                                                    <Typography style={{ textAlign: 'left', color: '#4b4b4b' }}>{items.category_name}</Typography>
                                                                </div>
                                                                {items.total_kpi != null &&
                                                                    <div style={{ width: '100%', display: 'flex', justifyContent: 'center', marginTop: 10 }}>
                                                                        <span style={{ textAlign: 'center', fontSize: '18px', color: "#fff" }}>{item.total_kpi}</span>
                                                                        {/* <span style={{ textAlign: 'center', fontSize: '11px', color: selectIndex === index ? "#fff" : '#4b4b4b' }}>KPIs</span> */}
                                                                    </div>}
                                                                <div style={{ display: 'flex', justifyContent: 'center', marginTop: items.total_kpi == null ? 50 : 0 }}>
                                                                    <div style={{ backgroundColor: items.performanceColor, textAlign: 'center', display: 'flex', justifyContent: 'center', width: 40, height: 21 }}>
                                                                        <Typography style={{ textAlign: 'center', color: '#4b4b4b' }}>{items.performanceScore}</Typography>
                                                                    </div>
                                                                </div>
                                                                <div style={{ display: 'flex', justifyContent: 'center' }}>
                                                                    <ReactSpeedometer
                                                                        maxSegmentLabels={0}
                                                                        segmentColors={[
                                                                            items.performanceColor,
                                                                            "#d8d8d8"
                                                                        ]}
                                                                        needleColor={"#4b4b4b"}
                                                                        value={Number(items.current_value).toFixed(2)}
                                                                        valueFormat={'.2f'}
                                                                        minValue={Number(items.low)}
                                                                        maxValue={Number(items.high)}
                                                                        customSegmentStops={[0, Number(items.current_value), 5]}
                                                                        width={200}
                                                                        height={140}
                                                                        ringWidth={25}
                                                                        textColor={'#4b4b4b'}
                                                                    />
                                                                </div>
                                                                <div style={{ backgroundColor: 'transparent', display: 'flex', marginTop: 20, placeContent: 'center' }}>
                                                                    {items.is_higher == '-' ?
                                                                        <div style={{ textAlign: '-webkit-center' }}>
                                                                            <Typography style={{ fontSize: 16, color: '#4b4b4b' }}> - </Typography>
                                                                        </div>
                                                                        :
                                                                        <div style={{ textAlign: '-webkit-center' }}>
                                                                            {items.is_higher == 'true' ?
                                                                                <img src={Images.up} /> : <img src={Images.down} />}
                                                                            <Typography style={{ fontSize: 16, color: '#4b4b4b' }}>vs Last Month</Typography>
                                                                        </div>
                                                                    }
                                                                </div>
                                                            </div>
                                                        </Link>
                                                    )
                                                })}
                                            </div>
                                        </div>
                                    )

                                })}
                            </div>
                            <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ color: '#656565', fontSize: '16px', fontWeight: 'bold' }}>Waiting Your Approval</Typography>
                                </div>

                            </div>

                            <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                <div>
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={this.state.listDashboard}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ marginTop: 20 }}>
                                    <Typography style={{ color: '#656565', fontSize: '16px', fontWeight: 'bold' }}>Master Budget & CAT</Typography>
                                    <div style={{ marginTop: 10, width: '100%' }}>
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={this.state.dataTableMB}
                                                columns={columnsMB}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    </div>
                                </div>
                            </div>
                            {/* <div style={{ marginTop: 20 }}>
                                <Typography style={{ color: '#656565', fontSize: '16px', fontWeight: 'bold' }}>Status Laporan</Typography>
                                <div style={{ marginTop: 10, display: 'flex' }}>
                                    <div style={{ width: 280, height: 400, padding: 20, backgroundColor: 'white', borderRadius: 6, border: 'solid 1px #c4c4c4', marginRight: 25 }}>
                                        <Typography style={{ color: '#4b4b4b', fontSize: '24px', fontWeight: 'bold' }}>Budget Tahunan - 2021</Typography>
                                        <div style={{ textAlign: 'center' }}>
                                            <DonutChart
                                                innerRadius={70}
                                                outerRadius={100}
                                                transition={true}
                                                pieClass="pie1"
                                                displayTooltip={true}
                                                strokeWidth={3}
                                                data={dataChart} />
                                        </div>
                                        <div style={{ display: 'flex', width: '100%', marginTop: 10 }}>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>Submit</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>92.8 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.red} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>-0.6%</Typography>
                                                </div>
                                            </div>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>On Time</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>6.1 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.green} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>0.7%</Typography>
                                                </div>

                                            </div>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>Overdue</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>1.1 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.green} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>0.1%</Typography>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div style={{ width: 280, height: 400, padding: 20, backgroundColor: 'white', borderRadius: 6, border: 'solid 1px #c4c4c4', marginRight: 25 }}>
                                        <Typography style={{ color: '#4b4b4b', fontSize: '24px', fontWeight: 'bold' }}>Laporan Bulanan - Oct 2020</Typography>
                                        <div style={{ textAlign: 'center' }}>
                                            <DonutChart
                                                innerRadius={70}
                                                outerRadius={100}
                                                transition={true}
                                                pieClass="pie5"
                                                displayTooltip={true}
                                                strokeWidth={3}
                                                data={dataChart2}
                                            />
                                        </div>
                                        <div style={{ display: 'flex', width: '100%', marginTop: 10 }}>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>Submit</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>92.8 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.red} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>-0.6%</Typography>
                                                </div>
                                            </div>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>On Time</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>6.1 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.green} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>0.7%</Typography>
                                                </div>

                                            </div>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>Overdue</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>1.1 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.green} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>0.1%</Typography>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div style={{ width: 280, height: 400, padding: 20, backgroundColor: 'white', borderRadius: 6, border: 'solid 1px #c4c4c4', }}>
                                        <Typography style={{ color: '#4b4b4b', fontSize: '24px', fontWeight: 'bold', height: 71 }}>Lainnya</Typography>
                                        <div style={{ textAlign: 'center' }}>
                                            <DonutChart
                                                innerRadius={70}
                                                outerRadius={100}
                                                transition={true}
                                                pieClass="pie2"
                                                displayTooltip={true}
                                                strokeWidth={3}
                                                data={dataChart3}
                                            />
                                        </div>
                                        <div style={{ display: 'flex', width: '100%', marginTop: 10 }}>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>Submit</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>92.8 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.red} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>-0.6%</Typography>
                                                </div>
                                            </div>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>On Time</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>6.1 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.green} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>0.7%</Typography>
                                                </div>

                                            </div>
                                            <div style={{ width: '33%' }}>
                                                <Typography style={{ color: '#656565', fontSize: '15px', textAlign: 'left' }}>Overdue</Typography>
                                                <Typography style={{ color: '#656565', fontSize: '20px', textAlign: 'left' }}>1.1 %</Typography>
                                                <div style={{ display: 'flex' }} >
                                                    <img src={Images.green} />
                                                    <Typography style={{ color: '#656565', fontSize: '14px', textAlign: 'left' }}>0.1%</Typography>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> */}
                        </div>
                    </div>
                    :
                    <div>
                        <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                            <Typography style={{ fontSize: '24px', color: 'white' }}>{this.state.userData === null ? '' : `Welcome, ${this.state.userData.fullname} !`}</Typography>
                        </div>
                        <div style={{ flex: 1, padding: 20, width: '100%' }}>
                            <Typography style={{ color: '#656565', fontSize: '16px', fontWeight: 'bold' }}>Dashboard CAT</Typography>
                            <div style={{ display: 'flex' }}>
                                <Autocomplete
                                    {...this.state.listMonthCAT}
                                    id="monthCAT"
                                    onChange={(event, newInputValue) => this.setState({ monthCAT: newInputValue, loading: true, loading3: true }, () => {
                                        this.getDashboardCAT()
                                        // if (this.state.isApprover === true) {
                                        //     this.getCompanySubmitted()
                                        // } else {
                                        // this.setState({ visibleTableHistory: false })
                                        // this.getRevision()
                                        // }
                                    })}
                                    disableClearable
                                    style={{ minWidth: 250, marginRight: 20 }}
                                    renderInput={(params) => <TextField {...params} label="Month CAT" margin="normal" style={{ marginTop: 7 }} />}
                                    value={this.state.monthCAT}
                                />
                                <Autocomplete
                                    {...this.state.listPeriodeCAT}
                                    id="periodeCAT"
                                    onChange={(event, newInputValue) => this.setState({ periodeCAT: newInputValue, loading: true, loading3: true }, () => {
                                        this.getDashboardCAT()
                                        // if (this.state.isApprover === true) {
                                        //         this.getCompanySubmitted()
                                        // } else {
                                        // this.setState({ visibleTableHistory: false })
                                        // this.getRevision()
                                        // }
                                    })}
                                    disableClearable
                                    style={{ width: 250 }}
                                    renderInput={(params) => <TextField {...params} label="Periode CAT" margin="normal" style={{ marginTop: 7 }} />}
                                    value={this.state.periodeCAT}
                                />
                            </div>
                            {this.state.dataDashboardCAT.map((item, index) => {
                                return (
                                    <div>
                                        <Typography style={{ color: '#656565', fontSize: '16px', marginTop: 20 }}>{item.item_business}</Typography>
                                        <div style={{ display: 'flex', overflowX: 'scroll', width: this.props.width * 0.95 }}>
                                            {item.category.map((items, indexs) => {
                                                return (
                                                    <Link to={{
                                                        pathname: `/home/cat-dashboard/`,
                                                        state: {
                                                            userType: 'user',
                                                            rawData: { month: this.state.monthCAT.month_id, periode: this.state.periodeCAT.value, companyId: items.company_id }
                                                        }
                                                    }}>
                                                        <div style={{ padding: 10, backgroundColor: '#fff', height: 350, borderRadius: 6, paddingBottom: 20, margin: 10, boxShadow: '0 1px 4px 0 rgba(0, 0, 0, 0.25)', width: 250, marginRight: indexs == item.category.length - 1 ? 25 : 0, marginLeft: indexs == 0 ? 5 : 25 }}>
                                                            {/* <span style={{ fontSize: '17px', color: this.state.selectIndex === index ? '#fff' : '#7e8085', maxWidth: 100 }}>{item.category_name}</span> */}
                                                            <div style={{ fontSize: '17px', width: '100%', height: 25 }}>
                                                                <Typography style={{ textAlign: 'left', color: '#4b4b4b' }}>{items.category_name}</Typography>
                                                            </div>
                                                            {items.total_kpi != null &&
                                                                <div style={{ width: '100%', display: 'flex', justifyContent: 'center', marginTop: 10 }}>
                                                                    <span style={{ textAlign: 'center', fontSize: '18px', color: "#fff" }}>{items.total_kpi}</span>
                                                                    {/* <span style={{ textAlign: 'center', fontSize: '11px', color: selectIndex === index ? "#fff" : '#4b4b4b' }}>KPIs</span> */}
                                                                </div>}
                                                            <div style={{ display: 'flex', justifyContent: 'center', marginTop: items.total_kpi == null ? 50 : 0 }}>
                                                                <div style={{ backgroundColor: items.performanceColor, textAlign: 'center', display: 'flex', justifyContent: 'center', width: 40, height: 21 }}>
                                                                    <Typography style={{ textAlign: 'center', color: '#4b4b4b' }}>{items.performanceScore}</Typography>
                                                                </div>
                                                            </div>
                                                            {!this.state.loading3 && <div style={{ display: 'flex', justifyContent: 'center' }}>
                                                                <ReactSpeedometer
                                                                    maxSegmentLabels={0}
                                                                    segmentColors={[
                                                                        items.performanceColor,
                                                                        "#d8d8d8"
                                                                    ]}
                                                                    needleColor={"#4b4b4b"}
                                                                    value={Number(items.current_value).toFixed(2)}
                                                                    valueFormat={'.2f'}
                                                                    minValue={Number(items.low)}
                                                                    maxValue={Number(items.high)}
                                                                    customSegmentStops={[0, Number(items.current_value), 5]}
                                                                    width={200}
                                                                    height={140}
                                                                    ringWidth={25}
                                                                    textColor={'#4b4b4b'}
                                                                />
                                                            </div>}
                                                            <div style={{ backgroundColor: 'transparent', display: 'flex', marginTop: 20, placeContent: 'center' }}>
                                                                {items.is_higher == '-' ?
                                                                    <div style={{ textAlign: '-webkit-center' }}>
                                                                        <Typography style={{ fontSize: 16, color: '#4b4b4b' }}> - </Typography>
                                                                    </div>
                                                                    :
                                                                    <div style={{ textAlign: '-webkit-center' }}>
                                                                        {items.is_higher == 'true' ?
                                                                            <img src={Images.up} /> : <img src={Images.down} />}
                                                                        <Typography style={{ fontSize: 16, color: '#4b4b4b' }}>vs Last Month</Typography>
                                                                    </div>
                                                                }
                                                            </div>
                                                        </div>
                                                    </Link>
                                                )
                                            })}
                                        </div>
                                    </div>
                                )

                            })}
                        </div>
                        {(this.state.accessMB || this.state.accessMR || this.state.accessRO || this.state.accessOL ) &&
                            <div style={{ flex: 1, paddingLeft: 20, paddingRight: 20, paddingTop: 20, paddingBottom: 0, width: '100%' }}>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ color: '#656565', fontSize: '16px', fontWeight: 'bold' }}>Tasks to be Completed</Typography>
                                </div>
                            </div>
                        }
                        {(this.state.accessMB === false && this.state.accessMR === false && this.state.accessRO === false && this.state.accessOL === false ) &&
                            <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ color: '#656565', fontSize: '16px', fontWeight: 'bold' }}>You don't have pending task</Typography>
                                </div>
                            </div>
                        }
                        <div style={{ display: 'flex', overflowX: 'scroll', width: this.props.width * 0.95 }}>
                            {this.state.accessMB &&
                                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                    <div style={{ display: 'flex' }}>
                                        <Autocomplete
                                            {...this.state.listPeriodeMB}
                                            id="periodeMB"
                                            onChange={(event, newInputValue) => this.setState({ periodeMB: newInputValue, loading: true }, () => {
                                                // if (this.state.isApprover === true) {
                                                //         this.getCompanySubmitted()
                                                // } else {
                                                // this.setState({ visibleTableHistory: false })
                                                // this.getRevision()
                                                // }\
                                                this.getListUserSubcoMB()
                                            })}
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Periode MB" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.periodeMB}
                                        />
                                    </div>
                                    <Paper style={{ width: 450, padding: 20, borderRadius: 10, marginTop: 5 }}>
                                        <Typography style={{ fontWeight: 'bold', textDecorationLine: 'underline' }}>{`Master Budget ${this.state.valueSubmit}/${this.state.listSubcoMB.length}`}</Typography>
                                        {this.state.listSubcoMB.map((item, index) => {
                                            return (
                                                <div style={{ display: 'flex', justifyContent: 'space-between', marginTop: 10, paddingLeft: 10 }}>
                                                    <div style={{ display: 'flex' }}>
                                                        <img src={item.is_submit === true ? Images.dotDone : item.is_overdue === true ? Images.dotOverdue : Images.dotOpen} />
                                                        <Link to={{
                                                            pathname: `/home/master-budget/`,
                                                            state: {
                                                                userType: 'user',
                                                                rawData: item
                                                            }
                                                        }}>
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    margin: 5,
                                                                    outline: 'none'
                                                                }}>
                                                                <Typography style={{ marginLeft: 10, color: '#5198ea', fontSize: 13 }}>{item.company_name}</Typography>
                                                            </button>
                                                        </Link>
                                                    </div>
                                                    {item.is_submit === false && item.is_overdue && (
                                                        <div style={{ backgroundColor: '#f65a4c', paddingRight: 5, paddingLeft: 5, borderRadius: 5, alignSelf: 'center' }}>
                                                            <Typography style={{ fontSize: 11, color: '#fff' }}>Overdue</Typography>
                                                        </div>
                                                    )}
                                                </div>
                                            )
                                        })}
                                    </Paper>
                                </div>
                            }
                            {this.state.accessMR &&
                                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                    <div style={{ display: 'flex' }}>
                                        <Autocomplete
                                            {...this.state.listMonth}
                                            id="month"
                                            onChange={(event, newInputValue) => this.setState({ month: newInputValue, loading: true }, () => {
                                                this.getListUserSubcoMR()
                                                // if (this.state.isApprover === true) {
                                                //     this.getCompanySubmitted()
                                                // } else {
                                                // this.setState({ visibleTableHistory: false })
                                                // this.getRevision()
                                                // }
                                            })}
                                            disableClearable
                                            style={{ minWidth: 210, marginRight: 20 }}
                                            renderInput={(params) => <TextField {...params} label="Month" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.month}
                                        />
                                        <Autocomplete
                                            {...this.state.listPeriodeMR}
                                            id="periodeMR"
                                            onChange={(event, newInputValue) => this.setState({ periodeMR: newInputValue, loading: true }, () => {
                                                this.getListUserSubcoMR()
                                                // if (this.state.isApprover === true) {
                                                //         this.getCompanySubmitted()
                                                // } else {
                                                // this.setState({ visibleTableHistory: false })
                                                // this.getRevision()
                                                // }
                                            })}
                                            disableClearable
                                            style={{ width: 210 }}
                                            renderInput={(params) => <TextField {...params} label="Periode MR" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.periodeMR}
                                        />
                                    </div>
                                    <Paper style={{ width: 450, padding: 20, borderRadius: 10, marginTop: 5 }}>
                                        {!this.state.loading2 && <Typography style={{ fontWeight: 'bold', textDecorationLine: 'underline' }}>{`Monthly Report - ${this.state.month.month_value} ${this.state.periodeMR.value} ${this.state.valueSubmitMR}/${this.state.listSubcoMR.length}`}</Typography>}
                                        {this.state.listSubcoMR.map((item, index) => {
                                            return (
                                                <div style={{ display: 'flex', justifyContent: 'space-between', marginTop: 10, paddingLeft: 10 }}>
                                                    <div style={{ display: 'flex' }}>
                                                        <img src={item.is_submit === true ? Images.dotDone : item.is_overdue === true ? Images.dotOverdue : Images.dotOpen} />
                                                        <Link to={{
                                                            pathname: `/home/monthly-report/`,
                                                            state: {
                                                                userType: 'user',
                                                                rawData: item,
                                                                month: this.state.month
                                                            }
                                                        }}>
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    margin: 5,
                                                                    outline: 'none'
                                                                }}>
                                                                <Typography style={{ marginLeft: 10, color: '#5198ea', fontSize: 13 }}>{item.company_name}</Typography>
                                                            </button>
                                                        </Link>
                                                    </div>
                                                    {item.is_submit === false && item.is_overdue && (
                                                        <div style={{ backgroundColor: '#f65a4c', paddingRight: 5, paddingLeft: 5, borderRadius: 5, alignSelf: 'center' }}>
                                                            <Typography style={{ fontSize: 11, color: '#fff' }}>Overdue</Typography>
                                                        </div>
                                                    )}
                                                </div>
                                            )
                                        })}
                                    </Paper>
                                </div>
                            }
                            {this.state.accessRO &&
                                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                    <div style={{ display: 'flex' }}>
                                        <Autocomplete
                                            {...this.state.listPeriodeRO}
                                            id="periodeRO"
                                            onChange={(event, newInputValue) => this.setState({ periodeRO: newInputValue, loading: true }, () => {
                                                this.getListUserSubcoRO()
                                                // if (this.state.isApprover === true) {
                                                //         this.getCompanySubmitted()
                                                // } else {
                                                // this.setState({ visibleTableHistory: false })
                                                // this.getRevision()
                                                // }
                                            })}
                                            disableClearable
                                            style={{ minWidth: 210, marginRight: 20 }}
                                            renderInput={(params) => <TextField {...params} label="Periode RO" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.periodeRO}
                                        />
                                        <Autocomplete
                                            {...this.state.listQuarter}
                                            id="quartal"
                                            disabled={this.state.intent === 'Home' ? true : false}
                                            onChange={(event, newInputValue) => this.setState({ quarter: newInputValue, loading: true }, () => {
                                                this.getListUserSubcoRO()
                                                // this.setState({ visibleTableHistory: false })
                                                // if (this.state.listCompany == null) {
                                                //     this.getCompanySubmitted()
                                                // } else {
                                                //     this.getRevision()
                                                // }
                                            })}
                                            disableClearable
                                            style={{ width: 210 }}
                                            renderInput={(params) => <TextField {...params} label="Quarter" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.quarter}
                                        />
                                    </div>
                                    <Paper style={{ width: 450, padding: 20, borderRadius: 10, marginTop: 5 }}>
                                        {!this.state.loading2 && <Typography style={{ fontWeight: 'bold', textDecorationLine: 'underline' }}>{`Rolling Outlook & CAT - ${this.state.periodeRO.value} ${this.state.quarter.value} ${this.state.valueSubmitRO}/${this.state.listSubcoRO.length}`}</Typography>}
                                        {this.state.listSubcoRO.map((item, index) => {
                                            return (
                                                <div style={{ display: 'flex', justifyContent: 'space-between', marginTop: 10, paddingLeft: 10 }}>
                                                    <div style={{ display: 'flex' }}>
                                                        <img src={item.is_submit === true ? Images.dotDone : item.is_overdue === true ? Images.dotOverdue : Images.dotOpen} />
                                                        <Link to={{
                                                            pathname: `/home/rolling-outlook/`,
                                                            state: {
                                                                userType: 'user',
                                                                rawData: {...item, quarter: this.state.quarter.value},
                                                            }
                                                        }}>
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    margin: 5,
                                                                    outline: 'none'
                                                                }}>
                                                                <Typography style={{ marginLeft: 10, color: '#5198ea', fontSize: 13 }}>{item.company_name}</Typography>
                                                            </button>
                                                        </Link>
                                                    </div>
                                                    {item.is_submit === false && item.is_overdue && (
                                                        <div style={{ backgroundColor: '#f65a4c', paddingRight: 5, paddingLeft: 5, borderRadius: 5, alignSelf: 'center' }}>
                                                            <Typography style={{ fontSize: 11, color: '#fff' }}>Overdue</Typography>
                                                        </div>
                                                    )}
                                                </div>
                                            )
                                        })}
                                    </Paper>
                                </div>
                            }
                            {this.state.accessOL &&
                                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                                    <div style={{ display: 'flex' }}>
                                        <Autocomplete
                                            {...this.state.listPeriodeOL}
                                            id="periodeOL"
                                            onChange={(event, newInputValue) => this.setState({ periodeOL: newInputValue, loading: true }, () => {
                                                // if (this.state.isApprover === true) {
                                                //         this.getCompanySubmitted()
                                                // } else {
                                                // this.setState({ visibleTableHistory: false })
                                                // this.getRevision()
                                                // }\
                                                this.getListUserSubcoOL()
                                            })}
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Periode OL" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.periodeOL}
                                        />
                                    </div>
                                    <Paper style={{ width: 450, padding: 20, borderRadius: 10, marginTop: 5 }}>
                                        {!this.state.loading2 && <Typography style={{ fontWeight: 'bold', textDecorationLine: 'underline' }}>{`Outlook Performance Appraisal - ${this.state.periodeOL.value} ${this.state.valueSubmit}/${this.state.listSubcoOL.length}`}</Typography>}
                                        {this.state.listSubcoOL.map((item, index) => {
                                            return (
                                                <div style={{ display: 'flex', justifyContent: 'space-between', marginTop: 10, paddingLeft: 10 }}>
                                                    <div style={{ display: 'flex' }}>
                                                        <img src={item.is_submit === true ? Images.dotDone : item.is_overdue === true ? Images.dotOverdue : Images.dotOpen} />
                                                        <Link to={{
                                                            pathname: `/home/outlook-performance/`,
                                                            state: {
                                                                userType: 'user',
                                                                rawData: item
                                                            }
                                                        }}>
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    margin: 5,
                                                                    outline: 'none'
                                                                }}>
                                                                <Typography style={{ marginLeft: 10, color: '#5198ea', fontSize: 13 }}>{item.company_name}</Typography>
                                                            </button>
                                                        </Link>
                                                    </div>
                                                    {item.is_submit === false && item.is_overdue && (
                                                        <div style={{ backgroundColor: '#f65a4c', paddingRight: 5, paddingLeft: 5, borderRadius: 5, alignSelf: 'center' }}>
                                                            <Typography style={{ fontSize: 11, color: '#fff' }}>Overdue</Typography>
                                                        </div>
                                                    )}
                                                </div>
                                            )
                                        })}
                                    </Paper>
                                </div>
                            }
                        </div>
                    </div>
                }
            </div>
        );

    }
}

export default HomePage;
