import React, { Component } from 'react';
import { Typography, Paper, TextField, MenuItem, Select, FormControlLabel, Snackbar, withStyles, createMuiTheme, MuiThemeProvider, Checkbox, Input } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import Images from '../../assets/Images';
import api from '../../api';
import Autocomplete from '@material-ui/lab/Autocomplete';
import MuiAlert from '@material-ui/lab/Alert';
import { titleCase } from '../../library/Utils';
import { ExcelRenderer } from 'react-excel-renderer';
import UploadFile from "../../library/Upload";
import Constant from '../../library/Constant';
import PropagateLoader from "react-spinners/PropagateLoader"
import { DatePicker } from '@material-ui/pickers';
import moment from 'moment';
import BalanceSheetRO from './BalanceSheetRO';
import ProfitLossRO from './ProfitLossRO';
import TaxPlanningRO from './TaxPlanningRO';
import CorporateAnnualTargetRO from './CorporateAnnualTargetRO';
import CashFlowRO from './CashFlowRO';
import * as R from 'ramda'
import { PhotoSizeSelectLargeTwoTone, ThreeSixty } from '@material-ui/icons';
import { startTransition } from 'react';

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

const CustomCheckbox = withStyles({
    root: {
        color: '#5198ea',
        '&$checked': {
            color: '#5198ea',
        },
    },
    checked: {},
})((props) => <Checkbox color="default" {...props} />);

export default class RollingOutlook extends Component {
    constructor(props) {
        super(props)
        this.state = {
            perusahaan: 'TAP Group',
            listRevision: null,
            revision: null,
            listPeriode: null,
            periode: null,
            listCompany: null,
            company: null,
            report_id: null,
            visibleRollingOutlook: true,
            visibleBS: false,
            visiblePL: false,
            visibleTP: false,
            visibleCAT: false,
            visibleCF: false,
            listAttachment: [],
            visibleUpload: false,
            revisionTable: null,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            rollingOutlookID: null,
            isSubmit: false,
            visibleTableHistory: false,
            isApprover: false,
            lastStatus: "",
            intent: "",
            approverID: null,
            pic: '',
            submitter: false,
            detailRevisiCheck: [],
            lastRevision: "",
            checkApprover: false,
            lastPeriod: '',
            latestPeriode: '',
            minDateRevision: new Date(),
            maxDateRevision: new Date(),
            btnApprove: false,
            listStatus: [],
            selectedStatus: [],
            quarterList: [
                { value: 'q1', name: 'Q1' },
                { value: 'q2', name: 'Q2' },
                { value: 'q3', name: 'Q3' },
                // {value: 'ol_pa', name: 'OL PA'},
            ],
            quarter: null,
            listApprover: null,
            approver: null,
            isAdmin: false,
            selectReport: [],
            isCheckAll: false,
            downloadedFileReportId: null,
            arrayReport: [],
            popupDownload: false,
            defaultCurrency: null,
            dataCurrency: [],
            currency: [],
            visibleAlertSave: false,
            dataCurrency: [
                {
                    "id": 1,
                    "value": "IDR"
                },
                {
                    "id": 2,
                    "value": "USD",
                }
            ]
        }
        this.myRef = React.createRef()
        this.fileHandler = this.fileHandler.bind(this);
    }

    scrollToMyRef = () => window.scrollTo(0, this.myRef.current.offsetTop)

    componentDidMount() {
        this.setState({ loading: true })
        this.props.selectIndex('Rolling Outlook & CAT')
        if (this.props.location.state !== undefined) {
            console.log(this.props);
            this.setState({ userType: this.props.location.state.userType, intent: 'Home', lastPeriod: this.props.location.state.rawData.periode, rawData: this.props.location.state.rawData }, () => {
                this.getPermission()
            })
        } else {
            this.getPermission()
        }
    }

    getPermission() {
        let payload = {
            menu: "rolling outlook & cat revision"
        }
        api.create().getPermission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        btnCreate: response.data.data.create,
                        btnEdit: response.data.data.edit
                    }, () => {
                        this.checkApprover()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    checkApprover() {
        // console.log('tot')
        let listStatus1 = [
            { name: 'Open', value: 'not-yet' },
            { name: 'Submitted', value: 'approval_review' },
            { name: 'Waiting for Review / Approval', value: 'approval_proccess' },
            { name: 'Approved', value: 'approved' },
        ]

        let listStatus2 = [
            { name: 'Open', value: 'not-yet' },
            { name: 'Submitted', value: 'approval_review' },
            { name: 'Approved', value: 'approved' },
        ]

        api.create().getRollingOutlookIsApprover().then(response => {
            // console.log('yuuuu')
            console.log(response);
            if (response.data.data.is_approver === true) {
                this.setState({ isApprover: true, checkApprover: true, listStatus: listStatus1, selectedStatus: listStatus1 }, () =>
                    this.getPeriode())
            } else {
                this.setState({ isApprover: false, checkApprover: false, listStatus: listStatus2, selectedStatus: listStatus2 }, () =>
                    this.getPeriode())
                // this.getDetailUser())
            }
        })
    }

    getCompanySubmitted() {
        let selectedStatus = this.state.selectedStatus.map((item) => {
            return item.value
        })
        let body = {
            "periode": this.state.periode.periode,
            "quartal": this.state.quarter.value,
            "status": selectedStatus
        }
        // this.setState({ isApprovedMB: true })
        api.create().getRollingOutlookCompanySubmitted(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    if (response.data.data.length > 0) {
                        let data = response.data.data
                        let companyData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name,
                            }
                        })

                        let arrayBaru = []
                        this.state.userCompany.map((item, index) => {
                            let indexID = companyData.findIndex((val) => val.company_id == item)
                            if (indexID !== -1) {
                                arrayBaru.push(companyData[indexID])
                            }
                        })

                        if (arrayBaru.length > 0) {
                            arrayBaru = arrayBaru.sort((a, b) => a.company_name.localeCompare(b.company_name))
                        }
                        let defaultProps = {
                            options: arrayBaru,
                            getOptionLabel: (option) => titleCase(option.company_name),
                        }
                        let indexID = null
                        if (this.state.rawData !== undefined) {
                            indexID = arrayBaru.findIndex((val) => val.company_id == this.state.rawData.company_id)
                        }
                        // console.log(response.data.data.length)
                        this.setState({ listCompany: defaultProps, company: indexID == null ? arrayBaru[0] : arrayBaru[indexID], company_submit: defaultProps }, () => {
                            // console.log(response.data.data.length)
                            if (response.data.data.length > 0) {
                                this.getRevision()
                                this.getCurrency(this.state.company.company_id)
                            } else {
                                // console.log(this.state.listCompany)
                                // console.log(this.state.company_submit)
                                this.setState({ listRevision: null, revision: null, dataTable: [], lastRevision: "", visibleTableHistory: false })
                            }
                            //
                        })
                    } else {
                        this.setState({ listRevision: null, revision: null, listCompany: null, company: null, dataTable: [], lastRevision: "", visibleTableHistory: false, loading: false }, () => {
                            document.body.style.overflow = 'unset';
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', listCompany: null, company: null })
            }
        })
    }

    getCurrency(companyID) {
        // console.log(companyID);
        api.create().getDetailPerusahaan(companyID).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        let data = response.data.data
                        let datas = []
                        if (response.data.data.currency.length > 0) {
                            response.data.data.currency.map((item) => {
                                // console.log(item);
                                datas.push({
                                    id: item.currencyId,
                                    value: item.currencyName
                                })

                            })
                        }
                        let index = datas.findIndex((val) => val.id == response.data.data.default_currency)
                        this.setState({
                            defaultCurrencyID: response.data.data.default_currency,
                            currency: datas,
                            defaultCurrency: index == -1 ? null : datas[index]
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }

        })
    }

    getReportAttachment() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "revision": this.state.revision.revision,
            "quartal": this.state.quarter.value
        }
        api.create().getRollingOutlookAttachment(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ listAttachment: response.data.data })
                }
            }
            // console.log(response);
        })
    }

    getReport() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "report_type": "Rolling Outlook",
            "quartal": this.state.quarter.value,
            "currency_id": this.state.defaultCurrency.id
        }
        let dataHardcode = []
        api.create().getRollingOutlookReport(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            item.number,
                            item.report_name,
                            item.revision,
                            this.state.quarter.value == 'q1' && !this.state.isApprovedMB ? "CLOSED" : (this.state.quarter.value != 'q1' && !this.state.isApprovedRO ? "CLOSED" : (this.state.isSubmit === false ? "CLOSED" : item.current_status)),
                            item.report_id,
                            // Number(item.revision) > 0 ? (item.current_status == "not-yet" ? false : item.is_can_upload) : item.is_can_upload,
                            item.report_name === "Cash Flow" ? item.is_can_upload : (Number(item.revision) > 0 ? (item.current_status == "not-yet" ? false : item.is_can_upload) : item.is_can_upload),
                            item.revision
                        ]
                    })
                    let dataTableRevision = []
                    response.data.data.map((item, index) => {
                        if (item.report_name !== 'Cash Flow') {
                            dataTableRevision.push([
                                item.report_id,
                                item.report_name === 'CAT' ? 'Corporate Annual Target' : item.report_name,
                                "",
                                item.number
                            ])
                        }
                    })
                    // console.log(dataTable);
                    this.setState({ dataTable, loading: false, dataTableRevision: dataTableRevision.sort((a, b) => a.number - b.number), dataForRevision: response.data.data })
                }
            } else {
                this.setState({ loading: false })
            }
        })
    }

    getLatestPeriodSubmit() {
        let body = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "is_approver": this.state.isApprover,
            "quartal": this.state.quarter.value
        }
        api.create().getSubmitRollingOutlook(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ isSubmit: response.data.data.is_can_submit }, () => {
                        this.getReport()
                        this.getReportAttachment()
                    })
                }
            }
        })
    }

    getDetailUser() {
        let userId = localStorage.getItem(Constant.USER)
        api.create().getDetailUser(userId).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.getRole(response.data.data.role_id)
                        this.setState({ userCompany: response.data.data.company }, () => {
                            this.getCompanySubmitted()
                        })
                    }
                }
            }
        })
    }

    getRole(id) {
        api.create().getDetailRole(id).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        // this.setState({ tempData: response.data.data, privileges: response.data.data.privileges })
                        console.log(response.data.data)
                        if (String(response.data.data.role_name).toLocaleLowerCase() == 'superadmin') {
                            this.setState({ isAdmin: true })
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getCompanyActive() {
        api.create().getPerusahaanActive().then((response) => {
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    let data = response.data.data
                    let comID = this.state.rawData ? this.state.rawData.company_id : 0
                    let companyData = data.map((item) => {
                        return {
                            company_id: item.company_id,
                            company_name: item.company_name,
                        }
                    })

                    if (companyData.length > 0) {
                        companyData = companyData.sort((a, b) => a.company_name.localeCompare(b.company_name))
                    }

                    let arrayBaru = []
                    this.state.userCompany.map((item, index) => {
                        let indexID = companyData.findIndex((val) => val.company_id == item)
                        if (indexID !== -1) {
                            arrayBaru.push(companyData[indexID])
                        }
                    })

                    if (arrayBaru.length > 0) {
                        arrayBaru = arrayBaru.sort((a, b) => a.company_name.localeCompare(b.company_name))
                    }

                    let defaultProps = {
                        options: arrayBaru,
                        getOptionLabel: (option) => titleCase(option.company_name),
                    };
                    let index = arrayBaru.findIndex((val) => val.company_id == comID)
                    this.setState({ listCompany: defaultProps, company: arrayBaru.length < 1 ? companyData[0] : (index == -1 ? arrayBaru[0] : arrayBaru[index]) }, () => {
                        this.getLastPeriod()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', listCompany: null, company: null })
            }
        })
    }

    getLastPeriod() {
        api.create().getLastPeriod(this.state.company.company_id).then(response => {
            console.log(response);
            if (response.data.status === "success") {
                this.setState({ lastPeriod: response.data.data.last_periode, latestPeriode: response.data.data.latest_periode }, () => {
                    this.getPeriode()
                })
            }
        })
    }

    getPeriode() {
        api.create().getPeriodeTransaction().then(response => {
            console.log(response)
            let currentYear = new Date().getFullYear()
            if (response.data) {
                if (response.data.status === "success") {
                    let data = []
                    response.data.data.map((item) => {
                        if (this.state.isApprover) {
                            if (item >= 2000 && item <= (Number(currentYear))) {
                                data.push(item)
                            }
                        } else {
                            // if ((item >= 2000) && (item == this.state.lastPeriod || item < this.state.lastPeriod)) {
                            //     data.push(item)
                            // }
                            if ((item >= 2000) && (item == currentYear || item <= currentYear)) {
                                data.push(item)
                            }
                        }
                    })
                    let periodeData = data.map((item) => {
                        return {
                            periode: item,
                        }
                    })
                    let defaultProps = {
                        options: periodeData,
                        getOptionLabel: (option) => option.periode,
                    };
                    let periode = (this.state.lastPeriod == "" ? String(Number(currentYear)) : this.state.lastPeriod === undefined ? String(Number(currentYear)) : this.state.lastPeriod)
                    let dateNow = new Date()
                    dateNow.setMonth(dateNow.getMonth() - 1);
                    let yearNow = dateNow.getFullYear()
                    // let indexMonthMR = MR.findIndex((val) => val.value == yearNow)
                    // console.log(yearNow)
                    // let index = data.sort((a, b) => a - b).findIndex((val) => val == yearNow)
                    let index = data.sort((a, b) => a - b).findIndex((val) => val === periode)
                    // console.log(data)
                    // console.log(this.state.lastPeriod)
                    // console.log(periodeData)
                    // console.log(index)
                    let defaultPropsQuarter = {
                        options: this.state.quarterList,
                        getOptionLabel: (option) => option.name
                    }
                    let indexID = null
                    if (this.state.rawData !== undefined) {
                        indexID = this.state.quarterList.findIndex((val) => String(val.value).toLocaleLowerCase() == this.state.rawData.quarter)
                    }
                    this.setState({ listPeriode: defaultProps, listQuarter: defaultPropsQuarter, quarter: indexID == null ? this.state.quarterList[0] : this.state.quarterList[indexID], periode: index === -1 ? periodeData[0] : periodeData[index] }, () => {
                        // if (this.state.isApprover === true && this.state.submittedOnly) {
                        this.getDetailUser()
                        // this.getCompanySubmitted()
                        //     console.log('masuk')
                        // } else {
                        // this.getRevision()
                        // }
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
            }
        })
    }

    getRevision() {
        this.setState({ selectReport: [], isCheckAll: false }, () => {
            let payload = {
                "company_id": this.state.company.company_id,
                "periode": this.state.periode.periode,
                "quartal": this.state.quarter.value
            }
            api.create().getRollingOutlookRevision(payload).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.data.status === "success") {
                        let data = response.data.data
                        let revisionData = data.map((item) => {
                            return {
                                revision: item,
                            }
                        })
                        let defaultProps = {
                            options: revisionData,
                            getOptionLabel: (option) => option.revision,
                        };
                        this.setState({ listRevision: defaultProps, revision: revisionData[0] }, () => {
                            this.getRollingOutlookID()
                        })
                    }
                }
            })
        })
    }

    getRollingOutlookID(type) {
        this.setState({ loading: true })
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "is_approver": this.state.isAdmin && this.state.lastStatus == 'WAITING FOR APPROVAL' ? false : this.state.isApprover,
            "quartal": this.state.quarter.value
        }
        api.create().getRollingOutlookID(payload).then(response => {
            console.log(response)
            if (response) {
                if (response.data.status === "success") {
                    this.setState({
                        rollingOutlookID: response.data.data.rolling_outlook_id,
                        submitter: response.data.data.submitter,
                        approverID: response.data.data.approve_id, pic: response.data.data.approver == null ? '' : response.data.data.approver,
                        lastStatus: response.data.data.last_status === null ? 'SUBMIT' : response.data.data.last_status,
                        loading: false,
                        lastRevision: response.data.data.last_revision,
                        btnApprove: response.data.data.is_submit,
                        isApprovedMB: response.data.data.is_approved_master_budget,
                        isApprovedRO: response.data.data.is_approved_rolling_before,
                        msgApproveMB: response.data.data.message_approval_master_budget,
                        msgApproveRO: response.data.data.message_approval_rolling_outlook
                    }, () => {
                        console.log(this.state.lastStatus);
                        if (this.state.isAdmin) {
                            console.log('masuk')
                            api.create().getListApprover('rolling_outlook', this.state.rollingOutlookID).then((response) => {
                                console.log(response)
                                if (response.data.data) {
                                    let dataListApprover = []
                                    response.data.data.map((item, index) => {
                                        dataListApprover.push({ userId: item.user_id, fullname: item.fullname })
                                    })
                                    let defaultProps = {
                                        options: dataListApprover,
                                        getOptionLabel: (option) => option.fullname,
                                    };
                                    this.setState({ listApprover: defaultProps })
                                }
                            })
                        }
                        this.historyApproval()
                        this.getLatestPeriodSubmit()
                        if (type != undefined && type == 'PL') {
                            // this.getCashFlow(type)
                            this.getPL(type)
                        } else if (type != undefined && type == 'BS') {
                            let bodyRatioBs = {
                                "report": 'ratio',
                                "rollingOutlookId": this.state.rollingOutlookID,
                                "periode": this.state.periode.periode,
                                "companyId": this.state.company.company_id,
                                "quartal": this.state.quarter.value,
                                "currency_id": this.state.defaultCurrency.id
                            }
                            api.create().triggerRatioRO(bodyRatioBs).then((res) => {
                                console.log(res)
                                this.setState({ loading: false })
                            })
                        } else {
                            this.setState({ loading: false })
                        }

                        api.create().getRollingOutlookIsApprover().then(response => {
                            console.log(response);
                            if (response.data.data.is_approver === true) {
                                this.setState({ isApprover: true, checkApprover: true })
                            } else {
                                this.setState({ isApprover: this.state.lastStatus == 'SUBMITTED' ? true : false, checkApprover: false })
                            }

                        })
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ rollingOutlookID: null, loading: false })
            }
        })
    }

    historyApproval() {
        let body = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "quartal": this.state.quarter.value
        }
        api.create().historyApprovalRO(body).then(response => {
            console.log(response);
            if (response.data.data.length > 0) {
                let dataTableHistory = response.data.data.map(item => {
                    return [
                        item.pic,
                        item.status_approval,
                        item.remarks,
                        item.item_revision,
                        item.history_approval_date
                    ]
                })
                this.setState({ dataTableHistory, visibleTableHistory: true })
            }
        })
    }

    async setHeaderTokenSuperadmin(type) {
        let realToken = await localStorage.getItem(Constant.TOKEN)
        api.create().getIdToken(this.state.approver.userId).then((response) => {
            console.log(response.data.data.token)
            localStorage.setItem(Constant.TOKEN, response.data.data.token)
            this.approvalSubmission(type, realToken)
        })
    }

    approvalSubmission(type, realToken) {
        // this.scrollToMyRef()
        // if (this.state.isAdmin && type == 'approve') {
        //     api.create().getIdToken(this.state.approver.userId).then((response) => {
        //         // console.log(realToken)
        //         // console.log(response.data.data.token)
        //         localStorage.setItem(Constant.TOKEN, response.data.data.token)
        //     })
        // }
        this.setState({ loading: true })
        let body = {
            "approval_id": this.props.location.state == undefined ? this.state.approverID : this.state.rawData.approval_id,
            "status": type,
            "detail": this.state.detailRevisiCheck,
            "quartal": this.state.quarter.value,
            "is_superadmin": this.state.isAdmin,
            "currency_id": this.state.defaultCurrency.id,
        }
        let payload = {
            "company_id": this.state.company.company_id,
            "min_periode": moment(this.state.minDateRevision).format('YYYY-MM-DD'),
            "periode": this.state.periode.periode,
            "max_periode": moment(this.state.maxDateRevision).format('YYYY-MM-DD'),
            "currency_id": this.state.defaultCurrency.id,
            "quartal": this.state.quarter.value
        }
        console.log(payload)
        // api.create().approvalRolling(body).then((res) => {
        //     console.log(res)
        //     // this.setState({ loading: false }, () => {
        //         this.getRollingOutlookID()
        //     // })
        //     if (type == 'revision') {
        //         api.create().createPeriodeRevisionRO(payload).then((res) => console.log(res))
        //     }
        // })

        setTimeout(() => {
            api.create().approvalRolling(body).then((res) => {
                console.log(res)
                // this.setState({ loading: false }, () => {
                // })
                if (this.state.isAdmin && type == 'approve') {
                    localStorage.setItem(Constant.TOKEN, realToken)
                    this.setState({ visibleApproveSuperadmin: false })
                }
                setTimeout(() => {
                    if (type == 'revision') {
                        api.create().createPeriodeRevisionRO(payload).then((res))
                    }
                    this.setState({ loading: false }, () => {
                        this.getRollingOutlookID()
                    })
                }, 300);
            })
        }, 100);
    }

    clickDetail(item, id, revision, status) {
        console.log(this.state.dataForRevision);
        this.state.dataForRevision.map(i => {
            if (i.report_name === item) {
                if (i.revision == revision) {
                    this.setState({ prevRevision: true })
                } else {
                    this.setState({ prevRevision: false })
                }
            }
        })
        this.setState({
            report_id: id,
            revisionTable: revision,
            status: status
        }, () => {
            if (item === 'Balance Sheet') {
                this.setState({
                    visibleRollingOutlook: false,
                    visibleBS: true,
                    visiblePL: false,
                    visibleCAT: false,
                    visibleTP: false,
                    visibleCF: false,
                })
            } else if (item === 'Profit Loss') {
                this.setState({
                    visibleRollingOutlook: false,
                    visibleBS: false,
                    visiblePL: true,
                    visibleCAT: false,
                    visibleTP: false,
                    visibleCF: false,
                })
            } else if (item === 'Cash Flow') {
                this.setState({
                    visibleRollingOutlook: false,
                    visibleBS: false,
                    visiblePL: false,
                    visibleCAT: false,
                    visibleTP: false,
                    visibleCF: true,
                })
            } else if (item === 'Tax Planning') {
                this.setState({
                    visibleRollingOutlook: false,
                    visibleBS: false,
                    visiblePL: false,
                    visibleCAT: false,
                    visibleTP: true,
                    visibleCF: false,
                })
            } else if (item === 'CAT') {
                this.setState({
                    visibleRollingOutlook: false,
                    visibleBS: false,
                    visiblePL: false,
                    visibleCAT: true,
                    visibleTP: false,
                    visibleCF: false,
                })
            }
        })
    }

    handleChange(value, tableMeta) {
        let data = this.state.dataTable
        data[tableMeta.rowIndex][tableMeta.columnIndex] = value
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                const formData = new FormData();
                formData.append("revision", Number(this.state.revision.revision));
                formData.append("companyId", this.state.company.company_id);
                formData.append("periode", Number(this.state.periode.periode));
                formData.append("quartal", this.state.quarter.value);
                formData.append("file", event);
                this.setState({ formData })
            }
        })
    }

    uploadAttachment(formData) {
        var object = {};
        formData.forEach(function (value, key) {
            object[key] = value;
        });
        var json = JSON.stringify(object);
        console.log(object)
        console.log(json)
        api.create().uploadAttachmentRO(formData).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ visibleUpload: false }, () => {
                        this.getRollingOutlookID()
                    })
                }
            }
        })
    }

    deleteAttachment(item) {
        api.create().deleteAttachmentRO(item.attachment_id).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.getRollingOutlookID()
                }
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    saveToRollingOutlook(data) {
        this.setState({ loading: true })
        // console.log(JSON.stringify(data));
        api.create('UPLOAD').createSubmitReport(data).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.getRollingOutlookID()
                } else {
                    this.setState({ loading: false }, () => {
                        this.getRollingOutlookID()
                    })
                }
            } else {
                this.setState({ loading: false }, () => {
                    this.getRollingOutlookID()
                })
            }
        })
    }

    async downloadAttachment(fileurl, name) {
        let length = name.split(".").length
        let fileType = name.split(".")[length - 1]
        console.log(fileType);
        // console.log(fileurl);
        let indexStrip = String(fileurl).indexOf("-")
        let fileName = String(fileurl).substr(indexStrip + 1, String(fileurl).length)
        let cobaSplit = String(fileName).split("-")
        let mapSplit = ""
        cobaSplit.map((item, index) => {
            if (item != "") {
                mapSplit += index == 0 ? `${titleCase(item)}` : ` ${item}`
            }
        })
        // console.log(mapSplit);
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_attachment?fileName=${fileurl}&&fileType=${fileType}`
        // console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_attachment?fileName=${fileurl}&&fileType=${fileType}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = "(Rolling Outlook Attachment) - " + mapSplit;
            a.click();
        }
    }

    validate() {
        this.setState({ loading: true })
        let array = []
        let canSubmit = true
        this.state.dataTable.map(item => {
            if (item[1] !== 'Cash Flow') {
                if (item[3] !== "submitted" && item[3] !== 'approved') {
                    canSubmit = false
                    array.push(item[3])
                }
            }
            // if (item[3].includes("not-yet") || item[3].includes("draft")) {
            //     array.push(item[3])
            // } else {
            //     array.push(item[3])
            // }
        })
        if (canSubmit === true) {
            let body = {
                rolling_outlook_id: this.state.rollingOutlookID
            }
            api.create().submitRollingOutlook(body).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.data.status === "success") {
                        this.getRollingOutlookID()
                    }
                }
            })
        } else {
            this.setState({ alert: true, messageAlert: 'Data Is Not Complete', tipeAlert: 'warning', loading: false })
        }
        // if (array.includes("not-yet" || "draft")) {
        //     console.log('gagal');
        // } else {
        //     console.log('masuk');
        // }

    }

    validateRevision() {
        let arrayRevisi = this.state.detailRevisiCheck
        let remarksKosong = 0
        arrayRevisi.map((item, index) => {
            if (item.remarks == "") {
                remarksKosong += 1
            }
        })
        if (remarksKosong > 0) {
            this.setState({ alert: true, messageAlert: 'Remarks Cannot be Empty', tipeAlert: 'error' })
        } else {
            this.setState({ visibleRevision: false }, () => this.approvalSubmission('revision'))
        }
    }

    getPL(type) {
        let PLID = null
        let payloadID = {
            "periode": this.state.periode.periode,
            "company_id": this.state.company.company_id,
            "currency_id": this.state.defaultCurrency.id
        }
        console.log(payloadID);
        api.create().getPLID(payloadID).then(response => {
            console.log(response);
            if (response) {
                PLID = response.data.data == null ? null : response.data.data.profit_loss_id
            } else {
                PLID = null
            }
            this.setState({ PLID }, () => {
                let payload = {
                    "report_id": 28,
                    "revision": Number(this.state.lastRevision),
                    "periode": this.state.periode.periode,
                    "company_id": this.state.company.company_id,
                    "quartal": this.state.quarter.value,
                    "rolling_outlook_id": this.state.PLID,
                    "currency_id": this.state.defaultCurrency.id
                }
                api.create().getHierarkiDBPLRO(payload).then(response => {
                    // console.log(response);
                    let dataTable = []
                    if (response.data) {
                        // let dataTable = []
                        console.log(response)
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_detail_rolling_outlook.total_actual_before === null ? "0" : item.profit_detail_rolling_outlook.total_actual_before === "" ? "0" : item.profit_detail_rolling_outlook.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.january, formula: item.profit_detail_rolling_outlook.january_formula } : item.profit_detail_rolling_outlook.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.february, formula: item.profit_detail_rolling_outlook.february_formula } : item.profit_detail_rolling_outlook.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.march, formula: item.profit_detail_rolling_outlook.march_formula } : item.profit_detail_rolling_outlook.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.april, formula: item.profit_detail_rolling_outlook.april_formula } : item.profit_detail_rolling_outlook.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.may, formula: item.profit_detail_rolling_outlook.may_formula } : item.profit_detail_rolling_outlook.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.june, formula: item.profit_detail_rolling_outlook.june_formula } : item.profit_detail_rolling_outlook.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.july, formula: item.profit_detail_rolling_outlook.july_formula } : item.profit_detail_rolling_outlook.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.august, formula: item.profit_detail_rolling_outlook.august_formula } : item.profit_detail_rolling_outlook.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.september, formula: item.profit_detail_rolling_outlook.september_formula } : item.profit_detail_rolling_outlook.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.october, formula: item.profit_detail_rolling_outlook.october_formula } : item.profit_detail_rolling_outlook.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.november, formula: item.profit_detail_rolling_outlook.november_formula } : item.profit_detail_rolling_outlook.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.december, formula: item.profit_detail_rolling_outlook.december_formula } : item.profit_detail_rolling_outlook.december,
                                item.profit_detail_rolling_outlook.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail_rolling_outlook.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail_rolling_outlook.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.profit_detail_rolling_outlook.forecast_formula == null ? [] : item.profit_detail_rolling_outlook.forecast_formula,
                                item.profit_detail_rolling_outlook.notes
                            ])

                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_detail_rolling_outlook.total_actual_before === null ? "0" : item.profit_detail_rolling_outlook.total_actual_before === "" ? "0" : item.profit_detail_rolling_outlook.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.january, formula: item.profit_detail_rolling_outlook.january_formula } : item.profit_detail_rolling_outlook.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.february, formula: item.profit_detail_rolling_outlook.february_formula } : item.profit_detail_rolling_outlook.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.march, formula: item.profit_detail_rolling_outlook.march_formula } : item.profit_detail_rolling_outlook.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.april, formula: item.profit_detail_rolling_outlook.april_formula } : item.profit_detail_rolling_outlook.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.may, formula: item.profit_detail_rolling_outlook.may_formula } : item.profit_detail_rolling_outlook.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.june, formula: item.profit_detail_rolling_outlook.june_formula } : item.profit_detail_rolling_outlook.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.july, formula: item.profit_detail_rolling_outlook.july_formula } : item.profit_detail_rolling_outlook.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.august, formula: item.profit_detail_rolling_outlook.august_formula } : item.profit_detail_rolling_outlook.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.september, formula: item.profit_detail_rolling_outlook.september_formula } : item.profit_detail_rolling_outlook.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.october, formula: item.profit_detail_rolling_outlook.october_formula } : item.profit_detail_rolling_outlook.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.november, formula: item.profit_detail_rolling_outlook.november_formula } : item.profit_detail_rolling_outlook.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail_rolling_outlook.december, formula: item.profit_detail_rolling_outlook.december_formula } : item.profit_detail_rolling_outlook.december,
                                item.profit_detail_rolling_outlook.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail_rolling_outlook.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail_rolling_outlook.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.profit_detail_rolling_outlook.forecast_formula == null ? [] : item.profit_detail_rolling_outlook.forecast_formula,
                                item.profit_detail_rolling_outlook.notes
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        // console.log(dataTable)
                        this.setState({ dbPL: dataTable }, () => {
                            this.olahDataPL(this.state.dbPL, type)
                        })
                    } else {
                        this.setState({ dbPL: [], previewTable: false, previewDownload: false })
                    }


                })
            })
        })


    }

    handleValueFormulaDBPL = (indexDBCF, value, tableMeta, column, periode, forecast) => {
        let splitFormula = String(tableMeta[3]).split(/([()@])/)
        // let splitFormula = String(tableMeta.rowData[3]).split('@')
        let baru = []
        let anjay = []
        let dataTable2 = this.state.dbPL

        // if (forecast !== undefined) {
        //     console.log(tableMeta)
        // }

        splitFormula.map((item, index) => {
            let items = String(item).substr(Number(String(item).length) - 1, 1)
            let subForm = String(item).substr(0, Number(String(item).length) - 1)
            let re = /^[a-zA-Z0-9_]+$/;
            let asd = ''
            if (item !== "") {
                if (!re.test(items)) {
                    baru.push(subForm)
                    baru.push(items)
                } else {
                    baru.push(String(item))
                }
            }
        })

        baru.map((item, index) => {
            if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                anjay.push(item)
            } else {
                if (String(item).includes('#')) {
                    if (forecast !== undefined) {
                        let forecastt = 0
                        forecast.map((items, index) => {
                            if (items.periode == periode) {
                                forecastt += Number(items.value)
                            }
                        })
                        anjay.push(forecastt)
                    } else {
                        if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let data = column == 7 ? 18 : column - 1
                            let period = data == 18 ? Number(this.state.periode.periode) - 1 : this.state.periode.periode
                            let indexID = tableMeta[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                            if (indexID !== -1) {
                                let valuezz = tableMeta[data].formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            // console.log(item)
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.state.periode.periode))
                            if (indexID !== -1) {
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    }

                } else {
                    let indexID = dataTable2.findIndex((val) => val[22] == item)
                    if (indexID !== -1) {
                        // if (forecast !== undefined) {
                        //     console.log(dataTable2[indexID])
                        //     console.log(column)
                        //     console.log(dataTable2[indexID][column])

                        // }
                        if (forecast != undefined) {
                            // console.log(dataTable2[indexID][column])
                        }
                        let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                        anjay.push(valuezz == "" ? 0 : valuezz)
                    } else {
                        if (item === '(-1)') {
                            anjay.push(-1)
                        }
                    }
                }
            }
        })

        let anjay2 = []
        let kurung = false
        let item1 = []
        anjay.map((item, index) => {
            if (item == "(") {
                kurung = true
            } else if (item == ")") {
                kurung = false
                anjay2.push(item1)
                item1 = []
            } else {
                if (kurung) {
                    item1.push(item)
                } else {
                    anjay2.push(item)
                }
            }
        })

        let total = 0
        let opt = ""
        let totalPrio = 0
        let optPrio = ""
        let prio = false
        anjay2.map((item, index) => {
            if (Array.isArray(item)) {
                prio = true
                item.map((items, indexs) => {
                    if (items == "+") {
                        optPrio = "tambah"
                    } else if (items == "-") {
                        optPrio = "kurang"
                    } else if (items == "*") {
                        optPrio = "kali"
                    } else if (items == "/") {
                        optPrio = "bagi"
                    } else {
                        if (optPrio == "tambah") {
                            totalPrio = Number(totalPrio) + Number(items)
                        } else if (optPrio == "kurang") {
                            totalPrio = Number(totalPrio) - Number(items)
                        } else if (optPrio == "kali") {
                            totalPrio = Number(totalPrio) * Number(items)
                        } else if (optPrio == "bagi") {
                            totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                        } else {
                            totalPrio += Number(items)
                        }
                    }
                })

                if (index == anjay2.length - 1) {
                    if (opt == "tambah") {
                        total = Number(total) + Number(totalPrio)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(totalPrio)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(totalPrio)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                    } else {
                        total += Number(totalPrio)
                    }
                }
            } else {
                // console.log(item.length)
                if (item == "+") {
                    opt = "tambah"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "-") {
                    opt = "kurang"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "*") {
                    opt = "kali"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "/") {
                    opt = "bagi"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            }
        })

        if (String(tableMeta[5]) == "Cost of Goods Sold (COGS)" && column == 20) {
            console.log(splitFormula)
            console.log(baru)
            console.log(anjay)
            console.log(anjay2)
            console.log(total)
        }
        total = R.equals(total, NaN) ? "0.0" : total
        return total
    }

    handleForecastDBPL = (index, tableMeta, periode, column) => {
        let total = 0
        let dataTable2 = this.state.dbPL

        if (tableMeta[3].includes('#PL')) {
            dataTable2[index][25].map((item, index) => {
                if (item.periode == periode) {
                    total += Number(item.value)
                }
            })
        } else {
            total = this.handleValueFormulaDBPL(dataTable2[index][column], tableMeta[column], tableMeta, column, periode, dataTable2[index][25])
        }

        return total
    }

    olahDataPL(dbPL, type) {
        dbPL.map((item, index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                item[7].value = this.handleValueFormulaDBPL(index, item[7], item, 7)
                item[8].value = this.handleValueFormulaDBPL(index, item[8], item, 8)
                item[9].value = this.handleValueFormulaDBPL(index, item[9], item, 9)
                item[10].value = this.handleValueFormulaDBPL(index, item[10], item, 10)
                item[11].value = this.handleValueFormulaDBPL(index, item[11], item, 11)
                item[12].value = this.handleValueFormulaDBPL(index, item[12], item, 12)
                item[13].value = this.handleValueFormulaDBPL(index, item[13], item, 13)
                item[14].value = this.handleValueFormulaDBPL(index, item[14], item, 14)
                item[15].value = this.handleValueFormulaDBPL(index, item[15], item, 15)
                item[16].value = this.handleValueFormulaDBPL(index, item[16], item, 16)
                item[17].value = this.handleValueFormulaDBPL(index, item[17], item, 17)
                item[18].value = this.handleValueFormulaDBPL(index, item[18], item, 18)
                item[20] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 1}`, 20)
                item[21] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 2}`, 21)
            }
        })
        this.setState({ dbPL }, () => {
            this.payloadPL(type)
        })
    }

    payloadPL(type) {
        let listPL = []
        // console.log(this.state.dbPL)
        this.state.dbPL.map((item, index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                // if (item[7].value == "" || item[7].value == 0 || item[7].value == "0.0") {
                item[7].value = this.handleValueFormulaDBPL(index, item[7], item, 7)
                // }  

                // if (item[8].value == "" || item[8].value == 0 || item[8].value == "0.0") {
                item[8].value = this.handleValueFormulaDBPL(index, item[8], item, 8)
                // } 

                // if (item[9].value == "" || item[9].value == 0 || item[9].value == "0.0") {
                item[9].value = this.handleValueFormulaDBPL(index, item[9], item, 9)
                // } 

                // if (item[10].value == "" || item[10].value == 0 || item[10].value == "0.0") {
                item[10].value = this.handleValueFormulaDBPL(index, item[10], item, 10)
                // } 

                // if (item[11].value == "" || item[11].value == 0 || item[11].value == "0.0") {
                item[11].value = this.handleValueFormulaDBPL(index, item[11], item, 11)
                // } 

                // if (item[12].value == "" || item[12].value == 0 || item[12].value == "0.0") {
                item[12].value = this.handleValueFormulaDBPL(index, item[12], item, 12)
                // } 

                // if (item[13].value == "" || item[13].value == 0 || item[13].value == "0.0") {
                item[13].value = this.handleValueFormulaDBPL(index, item[13], item, 13)
                // }

                // if (item[14].value == "" || item[14].value == 0 || item[14].value == "0.0") {
                item[14].value = this.handleValueFormulaDBPL(index, item[14], item, 14)
                // } 

                // if (item[15].value == "" || item[15].value == 0 || item[15].value == "0.0") {
                item[15].value = this.handleValueFormulaDBPL(index, item[15], item, 15)
                // } 

                // if (item[16].value == "" || item[16].value == 0 || item[16].value == "0.0") {
                item[16].value = this.handleValueFormulaDBPL(index, item[16], item, 16)
                // } 

                // if (item[17].value == "" || item[17].value == 0 || item[17].value == "0.0") {
                item[17].value = this.handleValueFormulaDBPL(index, item[17], item, 17)
                // } 

                // if (item[18].value == "" || item[18].value == 0 || item[18].value == "0.0") {
                item[18].value = this.handleValueFormulaDBPL(index, item[18], item, 18)
                // } 

                // if (item[20] == "" || item[20] == 0 || item[20] == "0.0") {
                item[20] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 1}`, 20)
                // } 

                // if (item[21] == "" || item[21] == 0 || item[21] == "0.0") {
                item[21] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 2}`, 21)
                // } 
            }


            listPL.push(
                {
                    "item_report_id": item[1],
                    "january": String(item[7].value == undefined ? item[7] : Number(item[7].value).toFixed(1)),
                    "february": String(item[8].value == undefined ? item[8] : Number(item[8].value).toFixed(1)),
                    "march": String(item[9].value == undefined ? item[9] : Number(item[9].value).toFixed(1)),
                    "april": String(item[10].value == undefined ? item[10] : Number(item[10].value).toFixed(1)),
                    "may": String(item[11].value == undefined ? item[11] : Number(item[11].value).toFixed(1)),
                    "june": String(item[12].value == undefined ? item[12] : Number(item[12].value).toFixed(1)),
                    "july": String(item[13].value == undefined ? item[13] : Number(item[13].value).toFixed(1)),
                    "august": String(item[14].value == undefined ? item[14] : Number(item[14].value).toFixed(1)),
                    "september": String(item[15].value == undefined ? item[15] : Number(item[15].value).toFixed(1)),
                    "october": String(item[16].value == undefined ? item[16] : Number(item[16].value).toFixed(1)),
                    "november": String(item[17].value == undefined ? item[17] : Number(item[17].value).toFixed(1)),
                    "december": String(item[18].value == undefined ? item[18] : Number(item[18].value).toFixed(1)),
                    "total_current_year": String(item[19]),
                    "total_next_year": String(item[20] != '' ? Number(item[20]).toFixed(1) : item[20]),
                    "total_more_year": String(item[21] != '' ? Number(item[21]).toFixed(1) : item[21]),
                    "notes": String(item[26]),
                }
            )

        })

        // console.log(listPL)
        this.setState({ dbPL: listPL }, () => {
            // if (this.state.submissionID != null) {
            //     this.createDBPL()
            // }
            if (type != undefined) {
                if (type == 'PL') {
                    console.log('tarik sis')
                    this.createDBPL()
                }
            }
        })
    }

    createDBPL() {
        let payload = {
            // "submission_id": this.state.submissionID,
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "report_id": 28,
            "status": "submitted",
            "profit_loss_id": this.state.PLID,
            "profit_loss_ro": this.state.dbPL,
            "quartal": this.state.quarter.value,
            "currency_id": this.state.defaultCurrency.id
        }
        console.log(this.state.dbPL)
        // console.log(JSON.stringify(payload))
        api.create().createDBPLRO(payload).then((res) => {
            console.log(res)
            this.setState({ loading: false })
        })
    }

    handleApproveAdmin() {
        this.setState({ visibleApproveSuperadmin: true })
    }

    handleSelectAll(data) {
        if (this.state.isCheckAll) {
            let checkAll = []
            this.setState({ selectReport: checkAll, isCheckAll: false })
        } else {
            let checkAll = this.state.selectReport
            data.map((item) => {
                if (item[5]) {
                    if (!this.state.selectReport.includes(item[4])) {
                        checkAll.push(item[4])
                    }
                }
            })
            console.log(checkAll);
            this.setState({ selectReport: checkAll, isCheckAll: true })
        }
    }

    handleItemChecked(item) {
        let indexID = this.state.selectReport.findIndex((val) => val === item.rowData[4])
        return indexID === -1 ? false : true
    }

    handleItemClick(item) {
        let indexID = this.state.selectReport.findIndex((val) => val === item.rowData[4])
        let selectReport = this.state.selectReport
        if (indexID === -1) {
            selectReport.push(item.rowData[4])
        } else {
            selectReport.splice(indexID, 1)
        }
        let isCheckAll = selectReport.length === this.state.dataTable.length
        this.setState({ selectReport, isCheckAll })
        console.log(selectReport);
    }

    handleDownloadReport(tableMeta) {
        let { selectReport, company, periode, quarter, defaultCurrency } = this.state
        let payload = {
            "company_id": company.company_id,
            "year": periode.periode,
            "report_id": selectReport,
            "month": "",
            "quartal": quarter ? quarter.value : "",
            "type_report_name": "Rolling Outlook",
            "currency_id" : defaultCurrency.id
        }
        console.log(payload);
        api.create().createDownloadFile(payload).then((response) => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        this.setState({ downloadedFileReportId: data.downloadedFileReportId, popupDownload: true }, () => this.handleGenerateReport(tableMeta))
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error'})
                alert(response.problem)
            }
        })
    }

    async handleGenerateReport(data) {
        let { selectReport, rollingOutlookID, company, periode, month, downloadedFileReportId, quarter, defaultCurrency } = this.state
        if (selectReport.length > 0) {
            let result = []
            console.log('mulai hit')
            for (const items of selectReport) {
                let urlReport = items === 14 ? "profit_loss" : items === 15 ? "tax_planning" : items === 16 ? "balance_sheet" : items === 17 ? "cash_flow" : items === 37 ? "cat" : null
                let datas = data.findIndex((val) => val[4] == items)
                let report = data[datas]
                let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/${urlReport}/rolling_outlook/export_rolling_outlook?rolling_outlook_id=${rollingOutlookID}&report_id=${report[4]}&company_id=${company.company_id}&year=${periode.periode}&revision=${report[2]}&quartal=${quarter.value}&download_file_report_id=${downloadedFileReportId}&currency_id=${defaultCurrency.id}`
                console.log(url);

                try {
                    let res = await fetch(
                        `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/${urlReport}/rolling_outlook/export_rolling_outlook?rolling_outlook_id=${rollingOutlookID === null ? "" : rollingOutlookID}&report_id=${report[4]}&company_id=${company.company_id}&year=${periode.periode}&revision=${report[2]}&quartal=${quarter.value}&download_file_report_id=${downloadedFileReportId}&currency_id=${defaultCurrency.id}`
                    )

                    if (res.status === 200) {
                        result = [...result, res];
                        console.log(result);
                    }
                } catch (error) {
                    alert(error)
                }

            }

            console.log('ini result', result);
            // every untuk cek ke setiap result di dalam array
            if (result.every((e) => e.status == 200)) {
                this.handleZip();
            }

        } else {
            alert("Anda harus memilih report yang ingin di download terlebih dahulu!")
        }
    }

    async handleZip() {
        console.log('mulai zip')
        api.create().createZipReport(this.state.downloadedFileReportId).then((response) => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ arrayReport: [] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error'})
                alert(response.problem)
            }
        })
    }

    render() {
        const handleMaxDate = () => {
            let handleDate = Number(moment(this.state.maxDateRevision).format('YYYYMMDD')) - Number(moment(this.state.minDateRevision).format('YYYYMMDD'))
            return handleDate < 0 ? moment(this.state.minDateRevision).format('YYYY/MM/DD') : moment(this.state.maxDateRevision).format('YYYY/MM/DD')
        }
        const columns = ["#", "Report Type",
            {
                name: "Revision",
                options: {
                    customBodyRender: (val, tableMeta, updateValue) => {
                        var list = [];
                        for (var i = 0; i <= tableMeta.rowData[6]; i++) {
                            list.push(i);
                        }
                        return (
                            <div style={{ display: 'flex' }}>
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    value={val}
                                    control={
                                        <Select
                                            value={val}
                                            onChange={event => {
                                                // console.log(event.target)
                                                updateValue(event.target.value)
                                                this.handleChange(event.target.value, tableMeta)
                                            }}
                                            autoWidth
                                        >
                                            {list.map((item, index) =>
                                                <MenuItem key={index} value={item}>{item}</MenuItem>
                                            )}
                                        </Select>
                                    }
                                />
                            </div >
                        );
                    }
                }
            }, {
                name: "Status",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {val === "submitted" || val === "approved" ?
                                    <span>COMPLETED</span> :
                                    val === "draft" ?
                                        <span>DRAFT</span> :
                                        val === "incomplete" ?
                                            <span>INCOMPLETE</span> :
                                            val === "revision" ?
                                                <span>REVISION</span> :
                                                val === "approval_proccess" ?
                                                    <span>APPROVAL PROCCESS</span> :
                                                    val === "approval_review" ?
                                                        <span>APPROVAL REVIEW</span> :
                                                        val === "not-yet" ?
                                                            <span>OPEN</span> :
                                                            val === "CLOSED" ?
                                                                <span>CLOSED</span> :
                                                                <img src={Images.cross} style={{ width: 31, height: 24 }} />
                                }
                            </div >
                        );
                    }
                }
            },
            {
                name: "Action",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        // console.log(tableMeta);
                        return (
                            <div style={{ display: 'flex' }}>
                                <button
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: tableMeta.rowData[5] ? 'pointer' : 'default',
                                        borderColor: 'transparent'
                                    }}
                                    onClick={() =>
                                        tableMeta.rowData[5] == true ?
                                            this.clickDetail(tableMeta.rowData[1], tableMeta.rowData[4], tableMeta.rowData[2], tableMeta.rowData[3])
                                            : null
                                    }
                                >
                                    {/* {this.state.isApprover == true ? 
                                        (tableMeta.rowData[5] ? '#5198ea' : 'GrayText') :
                                        (this.state.lastRevision == 0 ? (tableMeta.rowData[5] ? '#5198ea' : 'GrayText') :
                                        (tableMeta.rowData[3] !== 'submitted' ? '#5198ea' : 'GrayText'))} */}
                                    <Typography style={{ color: tableMeta.rowData[5] ? '#5198ea' : 'GrayText', fontSize: 12, }}>Detail</Typography>
                                </button>
                            </div >
                        );
                    }
                }
            }, {
                name: "Download",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        // console.log(tableMeta);
                        return (
                            <div style={{ display: 'flex' }}>
                                <CustomCheckbox
                                    checked={this.handleItemChecked(tableMeta)}
                                    onChange={() => tableMeta.rowData[5] == true ? this.handleItemClick(tableMeta) : null}
                                    disabled={tableMeta.rowData[5] == true ? false : true}
                                />
                            </div >
                        );
                    }
                }
            }, {
                name: "",
                options: { display: false }
            }, {
                name: "",
                options: { display: false }
            }]

        const columnsHistory = [
            "Name", "Status", "Remarks", "Revision Item", "Date"
        ]

        const columnRevisi = [
            {
                name: "#",
                options: {
                    customBodyRender: (val, tableMeta, updateValue) => {
                        var list = [];
                        for (var i = 0; i <= tableMeta.rowData[6]; i++) {
                            list.push(i);
                        }
                        return (
                            <div style={{ display: 'flex' }}>
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    value={val}
                                    control={
                                        <Checkbox
                                            checked={this.state.detailRevisiCheck.findIndex((val) => val.report_id == tableMeta.rowData[0]) == -1 ? false : true}
                                            onClick={() => handleCheckRevision(tableMeta.rowData)} />
                                    }
                                />
                            </div >
                        );
                    }
                }
            }, "Report Type",
            {
                name: 'Remarks',
                options: {
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'left' }}>
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    // value={value}
                                    control={
                                        <Input
                                            disableUnderline={true}
                                            style={{ fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginTop: -10 }}
                                            type="text"
                                            placeholder=""
                                            defaultValue={value}
                                            color={"#5198ea"}
                                            onBlur={(event) => {
                                                // console.log(event.target.value)
                                                // updateValue(event.target.value)
                                                handleChangeText(event.target.value, tableMeta)
                                                // console.log(dataTable2)
                                            }}
                                        />}
                                />
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: { display: false }
            }
        ]

        const handleChangeText = (value, tableMeta) => {
            let dataTableRevision = this.state.dataTableRevision
            dataTableRevision[tableMeta.rowIndex][tableMeta.columnIndex] = value

            let detailRevisiCheck = this.state.detailRevisiCheck
            let indexId = detailRevisiCheck.findIndex((val) => val.report_id == tableMeta.rowData[0])
            if (indexId !== -1) {
                detailRevisiCheck[indexId].remarks = value
            }

            this.setState({ dataTableRevision, detailRevisiCheck })
        }

        const handleCheckRevision = (value) => {
            let detailRevisiCheck = this.state.detailRevisiCheck
            let payload = {
                report_id: value[0],
                remarks: value[2],
                number: value[3]
            }
            let indexDataRevisi = this.state.dataTableRevision.findIndex((val) => val[3] == value[3])
            let indexId = detailRevisiCheck.sort((a, b) => a.number - b.number).findIndex((val) => val.number == value[3])
            // // console.log(indexId)
            if (indexId == -1) {
                this.state.dataTableRevision.map((item, index) => {
                    if (index > indexDataRevisi) {
                        let indexIds = detailRevisiCheck.findIndex((val) => val.number == item[3])
                        if (indexIds == -1) {
                            let payload2 = {
                                report_id: item[0],
                                remarks: item[2],
                                number: item[3]
                            }
                            detailRevisiCheck.push(payload2)
                        }
                    }
                })
                detailRevisiCheck.push(payload)
            } else {

                let x = 0
                detailRevisiCheck.sort((a, b) => a.number - b.number).map((item, index) => {
                    if (item.number < value[3]) {
                        x += 1
                    }
                })
                if (x < 1) {
                    this.state.dataTableRevision.map((item, index) => {
                        if (index > indexDataRevisi) {
                            let indexIdz = detailRevisiCheck.findIndex((val) => val.number == item[3])
                            if (indexIdz !== -1) {
                                detailRevisiCheck.splice(indexIdz, 1)
                            }
                        }
                    })
                    detailRevisiCheck.splice(indexId, 1)
                }
            }
            this.setState({ detailRevisiCheck: detailRevisiCheck.sort((a, b) => a.number - b.number) })
            console.log(detailRevisiCheck)
        }

        const options = {
            filter: false,
            sort: false,
            responsive: "scroll",
            print: false,
            download: false,
            selectableRows: false,
            viewColumns: false,
            pagination: false,
            search: false
        }
        const optionsRevision = {
            filter: false,
            sort: false,
            responsive: "scroll",
            print: false,
            download: false,
            selectableRows: false,
            viewColumns: false,
            pagination: false,
            search: false
        }
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );
        return (
            <div style={{ flex: 1, backgroundColor: '#f8f8f8' }} ref={this.myRef}>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {this.state.loading && loadingComponent}
                {this.state.visibleRollingOutlook && (
                    <div>
                        <div className={"main-color"} style={{ height: 78, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                            <Typography style={{ fontSize: '16px', color: 'white' }}>Rolling Outlook & CAT Revision</Typography>
                        </div>
                        <div style={{ padding: 20, width: '100%' }}>
                            <Paper style={{ paddingTop: 10 }}>
                                <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                    <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Rolling Outlook & CAT</Typography>
                                </div>
                                <div style={{ padding: 20 }}>
                                    <div style={{ display: 'flex' }}>
                                        <Autocomplete
                                            {...this.state.listPeriode}
                                            id="periode"
                                            onChange={(event, newInputValue) => this.setState({ periode: newInputValue }, () => {
                                                this.setState({ visibleTableHistory: false })
                                                if (this.state.listCompany == null) {
                                                    this.getCompanySubmitted()
                                                } else {
                                                    this.getRevision()
                                                }
                                            })}
                                            disabled={this.state.intent === 'Home' ? true : false}
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) =>
                                                <TextField {...params} label="Period" margin="normal" style={{ marginTop: 7 }}
                                                />}
                                            value={this.state.periode}
                                        />
                                        <Autocomplete
                                            id="tipe"
                                            disableClearable
                                            style={{ width: 250 }}
                                            options={this.state.currency}
                                            getOptionLabel={(option) => option.value}
                                            value={this.state.defaultCurrency}
                                            onChange={(event, newInputValue) => this.setState({ defaultCurrency: newInputValue }, () => {
                                                this.getRevision()
                                            })}
                                            renderInput={(params) =>
                                                <TextField
                                                    {...params}
                                                    variant="standard"
                                                    label="Currency"
                                                    margin="normal"
                                                    style={{ marginLeft: 25, marginTop: 7 }}
                                                />
                                            }

                                        />
                                    </div>
                                    <div style={{ marginTop: 20 }}>
                                        <Autocomplete
                                            {...this.state.listQuarter}
                                            id="company"
                                            disabled={this.state.intent === 'Home' ? true : false}
                                            onChange={(event, newInputValue) => this.setState({ quarter: newInputValue }, () => {
                                                this.setState({ visibleTableHistory: false })
                                                if (this.state.listCompany == null) {
                                                    this.getCompanySubmitted()
                                                } else {
                                                    this.getRevision()
                                                }
                                            })}
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Quarter" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.quarter}
                                        />
                                    </div>
                                    <div style={{ marginTop: 20 }}>
                                        <Autocomplete
                                            multiple
                                            id="tags-standard"
                                            options={this.state.listStatus}
                                            getOptionLabel={(option) => option.name}
                                            style={{ width: 250 }}
                                            onChange={(event, newInputValue) => {
                                                this.setState({ selectedStatus: newInputValue, loading: true }, () => {
                                                    console.log(newInputValue);
                                                    this.getCompanySubmitted()
                                                })
                                            }}
                                            value={this.state.selectedStatus}
                                            renderInput={(params) => <TextField {...params} label="Submission Status" margin="normal" style={{ marginTop: 7 }} />}
                                        />
                                    </div>
                                    <div style={{ marginTop: 20 }}>
                                        <Autocomplete
                                            {...this.state.listCompany}
                                            id="company"
                                            disabled={this.state.intent === 'Home' ? true : false}
                                            onChange={(event, newInputValue) => this.setState({ company: newInputValue }, () => {
                                                this.setState({ visibleTableHistory: false })
                                                this.getRevision()
                                                this.getCurrency(newInputValue.company_id)
                                            })}
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Company" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.company}
                                        />
                                    </div>
                                    <div style={{ marginTop: 20 }}>
                                        {/* <Autocomplete
                                            {...this.state.listRevision}
                                            id="revision"
                                            onChange={(event, newInputValue) => this.setState({ revision: newInputValue }, () => {
                                                this.getReport()
                                                this.getReportAttachment()
                                            })}
                                            disabled={true}
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Revision" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.revision}
                                        /> */}
                                        <TextField disabled={true} label="Revision" margin="normal" style={{ marginTop: 7, width: 250 }} value={this.state.lastRevision} />
                                    </div>

                                    <div style={{ marginTop: 20 }}>
                                        <div style={{ display: 'flex', justifyContent: 'flex-end', margin: '20px 15px' }}>
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => this.handleSelectAll(this.state.dataTable)}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 100, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Check All</Typography>
                                                </div>
                                            </button>
                                            <button
                                                type="button"
                                                disabled={this.state.buttonError}
                                                onClick={() => this.state.selectReport.length > 0 ? this.handleDownloadReport(this.state.dataTable) : alert("Anda harus memilih report yang ingin di download terlebih dahulu!")}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 100, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Download</Typography>
                                                </div>
                                            </button>
                                        </div>
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={this.state.dataTable}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    </div>
                                    <div style={{ display: 'flex', marginTop: 20 }}>
                                        <div style={{ width: '50%' }}>
                                            <Typography style={{ fontSize: '16px', color: '#4b4b4b', fontWeight: 'bold' }}>Attachment: </Typography>
                                        </div>
                                        {!this.state.isApprover && (this.state.lastStatus === 'SUBMIT' || this.state.lastStatus === 'REVISION') && (
                                            <div style={{ width: '50%' }}>
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: this.state.isSubmit === false ? 'default' : 'pointer',
                                                        borderColor: 'transparent',
                                                        outline: 'none'
                                                    }}
                                                    onClick={() => this.state.isSubmit === false ? null : this.setState({ visibleUpload: true })}
                                                >
                                                    <Typography style={{ fontSize: '16px', color: this.state.isSubmit === false ? 'GrayText' : '#5198ea' }}>Upload File</Typography>
                                                </button>
                                            </div>
                                        )}
                                    </div>
                                    <div style={{ display: 'flex', marginTop: 10 }}>
                                        <div style={{ width: '50%', paddingLeft: 20 }}>
                                            {this.state.listAttachment.length > 0 ?
                                                this.state.listAttachment.map((item, index) => {
                                                    return (
                                                        <div style={{ display: 'flex' }}>
                                                            <Typography style={{ fontSize: '13px', color: '#4b4b4b', width: 25 }}>{index + 1}. </Typography>

                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    outline: 'none',
                                                                    display: 'grid'
                                                                }}
                                                                onClick={() => {
                                                                    this.downloadAttachment(item.attachment_url, item.attachment_name)
                                                                }}
                                                            >
                                                                <div>
                                                                    <Typography style={{ fontSize: '13px', color: '#5198ea' }}> {item.attachment_name}</Typography>
                                                                </div>
                                                            </button>
                                                        </div>
                                                    )
                                                })
                                                : null
                                            }
                                        </div>
                                        {!this.state.isApprover && (this.state.lastStatus === 'SUBMIT' || this.state.lastStatus === 'REVISION') && (
                                            <div style={{ width: '50%' }}>
                                                {this.state.listAttachment.length > 0 ?
                                                    this.state.listAttachment.map((item) => {
                                                        return (
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: this.state.isSubmit === false ? 'default' : 'pointer',
                                                                    borderColor: 'transparent',
                                                                    outline: 'none',
                                                                    display: 'grid'
                                                                }}
                                                                onClick={() => this.state.isSubmit === false ? null : this.deleteAttachment(item)}
                                                            >
                                                                <Typography style={{ fontSize: '13px', color: this.state.isSubmit === false ? 'GrayText' : '#ff3939' }}>Delete</Typography>
                                                            </button>
                                                        )
                                                    })
                                                    : null
                                                }
                                            </div>
                                        )}
                                    </div>
                                    {this.state.quarter != null && this.state.quarter.value == 'q1' && this.state.isApprovedMB === false && (
                                        <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                            <span>{this.state.msgApproveMB}</span>
                                        </div>
                                    )}
                                    {this.state.quarter != null && this.state.quarter.value != 'q1' && this.state.isApprovedRO === false && (
                                        <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                            <span>{this.state.msgApproveRO}</span>
                                        </div>
                                    )}
                                    {this.state.checkApprover === true ?
                                        this.state.lastStatus === 'SUBMITTED' ?
                                            <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                <span>{this.state.lastStatus}</span>
                                            </div> : this.state.lastStatus === 'WAITING FOR REVIEW' ?
                                            <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                <span>{this.state.lastStatus}</span>
                                            </div> : this.state.lastStatus === 'WAITING FOR YOUR APPROVAL' ?
                                                <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                    <span>{this.state.lastStatus}</span>
                                                </div> : this.state.lastStatus === 'WAITING FOR APPROVAL' ?
                                                    <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                        <span>{`${this.state.lastStatus} - ${this.state.pic}`}</span>
                                                    </div> : this.state.lastStatus === 'REVISION' ?
                                                        <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                            <span>{this.state.textRevision}</span>
                                                        </div> : this.state.lastStatus === 'APPROVED' ?
                                                            <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                                <span>{`${this.state.lastStatus}`}</span>
                                                            </div> : null
                                        :
                                        this.state.lastStatus === 'SUBMITTED' ?
                                            <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                <span>{this.state.lastStatus}</span>
                                            </div> :
                                            this.state.lastStatus === 'WAITING FOR REVIEW' ?
                                                <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                    <span>{`${this.state.lastStatus} - ${this.state.pic}`}</span>
                                                </div> :
                                                this.state.lastStatus === 'WAITING FOR YOUR APPROVAL' ?
                                                    <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                        <span>{`${this.state.lastStatus} - ${this.state.pic}`}</span>
                                                    </div> :
                                                    this.state.lastStatus === 'WAITING FOR APPROVAL' ?
                                                        <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                            <span>{`${this.state.lastStatus} - ${this.state.pic}`}</span>
                                                        </div> :
                                                        this.state.lastStatus === 'REVISION' ?
                                                            <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                                <span>NEED REVISION</span>
                                                            </div> :
                                                            this.state.lastStatus === 'APPROVED' ?
                                                                <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                                                    <span>APPROVED</span>
                                                                </div> : null
                                    }
                                    {this.state.visibleTableHistory && (
                                        <div style={{ marginTop: 20 }}>
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={this.state.dataTableHistory}
                                                    columns={columnsHistory}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                {this.state.isAdmin && this.state.lastStatus == 'APPROVED' ?
                                    <div className="grid grid-2x" style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', }}>
                                        <div className="col-1" />
                                        <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => this.setState({ visibleRevision: true })}
                                            >
                                                <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Revision</Typography>
                                                </div>
                                            </button>
                                            {/* <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                                onClick={() => this.approvalSubmission('approve')}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Approve</Typography>
                                                </div>
                                            </button> */}
                                        </div>
                                    </div>
                                    :
                                    this.state.isAdmin && (this.state.lastStatus == 'WAITING FOR YOUR APPROVAL' || this.state.lastStatus == 'WAITING FOR APPROVAL') ?
                                        <div className="grid grid-2x" style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', }}>
                                            <div className="col-1" />
                                            <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        outline: 'none',
                                                    }}
                                                    onClick={() => this.handleApproveAdmin()}
                                                >
                                                    <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                        <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Approve</Typography>
                                                    </div>
                                                </button>
                                            </div>
                                        </div>
                                        :
                                        this.state.checkApprover === true ?
                                            this.state.lastStatus === 'WAITING FOR REVIEW' ?
                                                <div style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', display: 'flex', justifyContent: 'flex-end' }} >
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            outline: 'none',
                                                        }}
                                                        onClick={() =>
                                                            this.approvalSubmission('review')
                                                        }
                                                    >
                                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Review</Typography>
                                                        </div>
                                                    </button>
                                                </div> : (this.state.lastStatus === 'WAITING FOR YOUR APPROVAL' && this.state.btnApprove) ?
                                                    <div className="grid grid-2x" style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', }}>
                                                        <div className="col-1">
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    outline: 'none',
                                                                }}
                                                                onClick={() => this.setState({ visibleRevision: true })}
                                                            >
                                                                <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Revision</Typography>
                                                                </div>
                                                            </button>
                                                        </div>
                                                        <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    outline: 'none',
                                                                }}
                                                                onClick={() => this.approvalSubmission('approve')}
                                                            >
                                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Approve</Typography>
                                                                </div>
                                                            </button>
                                                        </div>
                                                    </div> : null
                                            :
                                            (this.state.lastStatus === 'SUBMIT' || this.state.lastStatus === 'REVISION') && this.state.isSubmit === true ?
                                                <div style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', display: 'flex', justifyContent: 'flex-end' }} >
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            outline: 'none',
                                                        }}
                                                        onClick={() => this.validate()}
                                                    >
                                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Submit</Typography>
                                                        </div>
                                                    </button>
                                                </div> :
                                                this.state.lastStatus === 'SUBMITTED' && this.state.submitter ?
                                                    <div style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', display: 'flex', justifyContent: 'flex-end' }} >
                                                        <button
                                                            style={{
                                                                backgroundColor: 'transparent',
                                                                cursor: 'pointer',
                                                                borderColor: 'transparent',
                                                                outline: 'none',
                                                            }}
                                                            onClick={() => this.approvalSubmission('cancel')}
                                                        >
                                                            <div style={{ backgroundColor: 'gray', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Cancel</Typography>
                                                            </div>
                                                        </button>
                                                    </div> : null
                                }
                            </Paper>

                        </div>
                    </div>
                )}

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => this.uploadAttachment(this.state.formData)}
                            />
                        </div>
                    </div>
                )}

                {this.state.visibleBS && (
                    <BalanceSheetRO
                        width={this.props.width}
                        height={this.props.height}
                        open={this.props.open}
                        report_id={this.state.report_id}
                        company={this.state.company}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        revision={this.state.revisionTable}
                        periode={this.state.periode.periode}
                        rollingOutlookID={this.state.rollingOutlookID}
                        refresh={this.getRollingOutlookID.bind(this)}
                        onClickClose={() => this.setState({ visibleBS: false, visibleRollingOutlook: true })}
                        isApprover={this.state.isApprover}
                        quarter={this.state.quarter.value}
                        prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        status={this.state.status}
                        lastStatus={this.state.lastStatus}
                    />
                )}

                {this.state.visiblePL && (
                    <ProfitLossRO
                        width={this.props.width}
                        height={this.props.height}
                        open={this.props.open}
                        report_id={this.state.report_id}
                        company={this.state.company}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        revision={this.state.revisionTable}
                        periode={this.state.periode.periode}
                        rollingOutlookID={this.state.rollingOutlookID}
                        onClickClose={() => this.setState({ visiblePL: false, visibleRollingOutlook: true })}
                        refresh={this.getRollingOutlookID.bind(this)}
                        quarter={this.state.quarter.value}
                        isApprover={this.state.isApprover}
                        prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        status={this.state.status}
                        lastStatus={this.state.lastStatus}
                    />
                )}

                {this.state.visibleTP && (
                    <TaxPlanningRO
                        width={this.props.width}
                        height={this.props.height}
                        open={this.props.open}
                        report_id={this.state.report_id}
                        company={this.state.company}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        revision={this.state.revisionTable}
                        periode={this.state.periode.periode}
                        rollingOutlookID={this.state.rollingOutlookID}
                        onClickClose={() => this.setState({ visibleTP: false, visibleRollingOutlook: true })}
                        refresh={this.getRollingOutlookID.bind(this)}
                        status={this.state.status}
                        lastStatus={this.state.lastStatus}
                        quarter={this.state.quarter.value}
                        isApprover={this.state.isApprover}
                        prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                    />
                )}

                {this.state.visibleCF && (
                    <CashFlowRO
                        width={this.props.width}
                        height={this.props.height}
                        open={this.props.open}
                        report_id={this.state.report_id}
                        company={this.state.company}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        revision={this.state.revisionTable}
                        periode={this.state.periode.periode}
                        rollingOutlookID={this.state.rollingOutlookID}
                        onClickClose={() => this.setState({ visibleCF: false, visibleRollingOutlook: true })}
                        refresh={this.getRollingOutlookID.bind(this)}
                        status={this.state.status}
                        lastStatus={this.state.lastStatus}
                        quarter={this.state.quarter.value}
                        isApprover={this.state.isApprover}
                        prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        PLBSFAMSubmitted={this.state.lastStatus == 'APPROVED' ? true : false}
                    />
                )}

                {this.state.visibleCAT && (
                    <CorporateAnnualTargetRO
                        width={this.props.width}
                        height={this.props.height}
                        open={this.props.open}
                        report_id={this.state.report_id}
                        company={this.state.company}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        revision={this.state.revisionTable}
                        periode={this.state.periode.periode}
                        rollingOutlookID={this.state.rollingOutlookID}
                        onClickClose={() => this.setState({ visibleCAT: false, visibleRollingOutlook: true })}
                        refresh={this.getRollingOutlookID.bind(this)}
                        quarter={this.state.quarter.value}
                        isApprover={this.state.isApprover}
                        prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        status={this.state.status}
                        lastStatus={this.state.lastStatus}
                        PLBSFAMSubmitted={this.state.lastStatus == 'APPROVED' ? true : false}
                    />
                )}


                {this.state.visibleRevision && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Revision</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleRevision: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div className="border-bottom" style={{ padding: 20 }}>
                                <span>You ask your subsidiary to make a revision</span>
                                <div style={{ marginTop: 20 }}>
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={this.state.dataTableRevision}
                                            columns={columnRevisi}
                                            options={optionsRevision}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ marginTop: 20 }}>
                                    <span>Timing duration you give for revision:</span>
                                    <div style={{ display: 'flex', justifyContent: 'space-between', marginTop: 20 }}>
                                        <div>
                                            <DatePicker
                                                margin="normal"
                                                id="startDate"
                                                label="Valid From"
                                                format="dd-MM-yyyy"
                                                onChange={(e) => this.setState({ minDateRevision: moment(e).format('YYYY/MM/DD') }, () => this.setState({ maxDateRevision: handleMaxDate() }))}
                                                value={moment(this.state.minDateRevision).format('YYYY/MM/DD')}
                                                KeyboardButtonProps={{
                                                    'aria-label': 'change date',
                                                }}
                                                inputProps={{
                                                    style: {
                                                        fontSize: 11
                                                    }
                                                }}
                                                InputLabelProps={{
                                                    style: {
                                                        fontSize: 11,
                                                        color: '#7e8085'
                                                    }
                                                }}

                                                style={{ padding: 0, margin: 0, width: '100%' }}
                                            />
                                        </div>
                                        <span style={{ alignSelf: 'center' }}>Until</span>
                                        <div>
                                            <DatePicker
                                                margin="normal"
                                                id="startDate"
                                                label="Valid To"
                                                format="dd-MM-yyyy"
                                                onChange={(e) => this.setState({ maxDateRevision: moment(e).format('YYYY/MM/DD') })}
                                                minDate={moment(this.state.minDateRevision).format('YYYY/MM/DD')}
                                                value={moment(this.state.maxDateRevision).format('YYYY/MM/DD')}
                                                KeyboardButtonProps={{
                                                    'aria-label': 'change date',
                                                }}
                                                inputProps={{
                                                    style: {
                                                        fontSize: 11
                                                    }
                                                }}
                                                InputLabelProps={{
                                                    style: {
                                                        fontSize: 11,
                                                        color: '#7e8085'
                                                    }
                                                }}

                                                style={{ padding: 0, margin: 0, width: '100%' }}
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1" style={{ alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ visibleRevision: false })}
                                    >
                                        <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                        </div>
                                    </button>
                                </div>
                                <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.validateRevision()}
                                    >
                                        <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#fff', fontSize: 11 }}>Revision</span>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

                {this.state.visibleApproveSuperadmin && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Superadmin Approve</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleApproveSuperadmin: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div className="border-bottom" style={{ padding: 20 }}>
                                <span>Choose approver you want</span>
                                <div style={{ marginTop: 20 }}>
                                    <Autocomplete
                                        {...this.state.listApprover}
                                        id="periode"
                                        onChange={(event, newInputValue) => this.setState({ approver: newInputValue })}
                                        disabled={false}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) =>
                                            <TextField {...params} label="Approver" margin="normal" style={{ marginTop: 7 }}
                                            />}
                                        value={this.state.approver}
                                    />
                                </div>
                            </div>
                            <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1" style={{ alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ visibleApproveSuperadmin: false })}
                                    >
                                        <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                        </div>
                                    </button>
                                </div>
                                <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.state.approver == null ? this.setState({ alert: true, messageAlert: 'Approver Cannot be Empty', tipeAlert: 'error' }) : this.setHeaderTokenSuperadmin('approve')}
                                    >
                                        <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#fff', fontSize: 11 }}>Confirm  Approve</span>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

                {this.state.popupDownload && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#D9D9D9', borderRadius: 10, width: 609, height: 276 }}>
                            <div>
                                <div style={{ justifyContent: 'center', fontSize: 20, color: '#33508B', margin: '70px 20px' }}>Download Rolling Outlook {this.state.company.company_name} {this.state.periode.periode} In Progress, silahkan cek status dan unduh report di menu <b>Download Report</b></div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 3
                                        }}
                                        onClick={() => this.setState({ popupDownload: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div >
        );
    }
}
