import React, { Component } from 'react';
import { Typography, AppBar, Tabs, Tab, TextField, Snackbar, Collapse, withStyles, Checkbox, InputAdornment, IconButton } from '@material-ui/core';
import Visibility from '@material-ui/icons/Visibility';
import VisibilityOff from '@material-ui/icons/VisibilityOff';
import MuiAlert from '@material-ui/lab/Alert';
import Images from '../../assets/Images';
import api from '../../api';
import Constant from '../../library/Constant';
import RemoveIcon from '@material-ui/icons/Remove';
import AddIcon from '@material-ui/icons/Add';
import { titleCase } from '../../library/Utils';
import * as R from 'ramda'
import ImageUploader from 'react-images-upload';

const CustomCheckbox = withStyles({
    root: {
        color: '#51c6ea',
        '&$checked': {
            color: '#51c6ea',
        },
    },
    checked: {},
})((props) => <Checkbox color="default" {...props} />);

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class Profile extends Component {
    constructor(props) {
        super(props)
        this.state = {
            tab: 0,
            oldPassword: '',
            password: '',
            confirmPassword: '',
            errorOldPassword: false,
            errorPassword: false,
            errorConfirmPassword: false,
            msgOldPassword: 'Consists of 8 Characters with a Combination of Numbers.',
            msgPassword: 'Consists of 8 Characters with a Combination of Numbers.',
            msgConfirmPassword: 'Consists of 8 Characters with a Combination of Numbers.',
            company: [],
            listCompany: [],
            selectedIndex: 0,
            showPass: false,
            showPass2: false,
            showPass3: false,
            pictures: [],
            name: "",
            alert: false,
            tipeAlert: '',
            messageAlert: ''
        }
        this.onDrop = this.onDrop.bind(this);
    }

    componentDidMount() {
        this.getPerusahaan()
        this.getUser()
    }

    selectTab = (event, newEvent) => {
        this.setState({ tab: newEvent })
    }

    handleChange(e) {
        let data = this.state
        this.setState({ ...data, [e.target.name]: e.target.value })
        // console.log(e.target.name);
        if (e.target.name === "password") {
            this.setState({ errorPassword: false, msgPassword: 'Consists of 8 Characters with a Combination of Numbers.' })
        } else if (e.target.name === "confirmPassword") {
            this.setState({ errorConfirmPassword: false, msgConfirmPassword: 'Consists of 8 Characters with a Combination of Numbers.' })
        } else if (e.target.name === "oldPassword") {
            this.setState({ errorOldPassword: false, msgOldPassword: 'Consists of 8 Characters with a Combination of Numbers.' })
        }
    }

    validasi() {
        if (this.state.oldPassword === "") {
            this.setState({ errorOldPassword: true, msgOldPassword: 'Old Password Cannot be Empty.' })
        } else if (this.state.oldPassword.length < 8) {
            this.setState({ errorOldPassword: true, msgOldPassword: 'Old Password Minimum 8 Characters.' })
        } else if (this.isEmail(this.state.oldPassword)) {
            this.setState({ errorOldPassword: true, msgOldPassword: 'Old Password Format Should Not Use Email.' })
        } else if (!this.isRegex(this.state.oldPassword)) {
            this.setState({ errorOldPassword: true, msgOldPassword: 'Old Password Must be a Combination of Characters, Letters and Numbers.' })
        } else if (this.state.password.trim() === "") {
            this.setState({ errorPassword: true, msgPassword: 'Password Cannot be Empty.' })
        } else if (this.state.password.length < 8) {
            this.setState({ errorPassword: true, msgPassword: 'Password Minimum 8 Characters.' })
        } else if (this.isEmail(this.state.password)) {
            this.setState({ errorPassword: true, msgPassword: 'Password Format Should Not Use Email.' })
        } else if (!this.isRegex(this.state.password)) {
            this.setState({ errorPassword: true, msgPassword: 'Password Must be a Combination of Characters, Letters and Numbers.' })
        } else if (this.state.confirmPassword.trim() === "") {
            this.setState({ errorConfirmPassword: true, msgConfirmPassword: 'Repeat Password Cannot be Empty.' })
        } else if (this.state.password !== this.state.confirmPassword) {
            this.setState({ errorConfirmPassword: true, msgConfirmPassword: 'Password Does Not Match.' })
        } else {
            this.confirmPassword()
        }
    }

    confirmPassword() {
        let body = {
            "old_password": this.state.oldPassword,
            "new_password": this.state.password,
            "confirm_password": this.state.confirmPassword
        }
        api.create().changePassword(body).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                        this.setState({ oldPassword: "", password: "", confirmPassword: "" })
                        localStorage.removeItem(Constant.TOKEN)
                        setTimeout(() => {
                            window.location.reload();
                        }, 1000);
                    } else if (response.data.message === "Old Password is Not Correct") {
                        this.setState({ errorOldPassword: true, msgOldPassword: 'Incorrect password.' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    isRegex(value) {
        // const re = /^(?=.*[0-9])(?=.*[a-zA-Z])([a-zA-Z0-9]+)$/;
        const re = /^(?=.*[A-Za-z])(?=.*\d)(?=.*[@$!%*#?&])[A-Za-z\d@$!%*#?&]{1,}$/;
        return re.test(String(value));
        // return(value)
    }

    isEmail(email) {
        const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(String(email).toLowerCase());
    }

    getUser() {
        let userId = localStorage.getItem(Constant.USER)
        api.create().getDetailUser(userId).then((response) => {
            // console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ company: response.data.data.company, photo: response.data.data.photo, name: response.data.data.fullname })
                        // console.log(response)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getPerusahaan() {
        api.create().getPerusahaanHierarki().then((response) => {
            // console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ listCompany: response.data.data })
                        // console.log(response.data.data)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    handleItemChecked(item) {
        let indexID = this.state.company.findIndex((val) => val === item.id)
        return indexID === -1 ? false : true
    }

    renderChildren = (item, pad) => {
        let padding = null
        if (pad !== undefined) {
            padding = pad
        } else {
            padding = 20
        }
        return (
            <div>
                {item.children.length > 0 && (
                    <ul>
                        {item.children.map((data, index) => {
                            return (
                                // <li>
                                <Collapse key={index} timeout="auto" unmountOnExit in={item.collapse}>
                                    <div style={{ display: 'flex', flexDirection: 'row', alignItems: 'center', justifyContent: 'flex-start', paddingLeft: R.isNil(data.children) ? (padding + 20) : padding }}>
                                        {R.isNil(data.children) ?
                                            null
                                            :
                                            data.children.length < 1 ?
                                                null
                                                :
                                                <span onClick={() => this.handleCollapse(data)} style={{ marginLeft: 7, marginRight: 2 }}>
                                                    {data.collapse ? <RemoveIcon color={'action'} fontSize={'small'} /> : <AddIcon color={'action'} fontSize={'small'} />}
                                                </span>
                                        }
                                        <span>
                                            <CustomCheckbox
                                                checked={this.handleItemChecked(data)}
                                                onChange={() => null}
                                            />
                                        </span>
                                        <Typography style={{ fontSize: 12 }}>{titleCase(data.company_name)}</Typography>
                                    </div>
                                    {!R.isNil(data.children) && this.renderChildren(data, padding + 20)}
                                </Collapse>
                                // </li>
                            )
                        })}
                    </ul>
                )}
            </div>
        )
    }

    handleCollapse(item) {
        let path = this.searchIt({ children: this.state.listCompany }, item.id)
        let listCompany = this.state.listCompany
        let arrayPath = []

        if (path.length > 1) {
            arrayPath = path.split('-');
            arrayPath = arrayPath.map((item) => { return item })
        } else {
            arrayPath.push(path)
        }

        let pathSelect = null
        if (arrayPath.length === 1) {
            pathSelect = listCompany[arrayPath[0]]
        } else if (arrayPath.length === 2) {
            pathSelect = listCompany[arrayPath[0]].children[arrayPath[1]]
        } else if (arrayPath.length === 3) {
            pathSelect = listCompany[arrayPath[0]].children[arrayPath[1]].children[arrayPath[2]]
        } else if (arrayPath.length === 4) {
            pathSelect = listCompany[arrayPath[0]].children[arrayPath[1]].children[arrayPath[2]].children[arrayPath[3]]
        } else if (arrayPath.length === 5) {
            pathSelect = listCompany[arrayPath[0]].children[arrayPath[1]].children[arrayPath[2]].children[arrayPath[3]].children[arrayPath[4]]
        } else if (arrayPath.length === 6) {
            pathSelect = listCompany[arrayPath[0]].children[arrayPath[1]].children[arrayPath[2]].children[arrayPath[3]].children[arrayPath[4]].children[arrayPath[5]]
        } else if (arrayPath.length === 7) {
            pathSelect = listCompany[arrayPath[0]].children[arrayPath[1]].children[arrayPath[2]].children[arrayPath[3]].children[arrayPath[4]].children[arrayPath[5]].children[arrayPath[6]]
        }

        pathSelect.collapse = !pathSelect.collapse
        // console.log(pathSelect.collapse)
        this.setState({ listCompany }, () => console.log(pathSelect))
    }

    searchIt = (node, search, path = '', position = 0) => {
        if (node.id && node.id === search) { return path !== '' ? `${path}-${position}` : position; }
        if (!node.children) { return false }
        const index = node.children.findIndex((x) => x.id && x.id === search);
        if (index >= 0) {
            return path !== '' ? `${path}-${index}` : index;
        }
        for (let i = 0; i < node.children.length; i++) {
            const result = this.searchIt(node.children[i], search, path !== '' ? `${path}-${i}` : i, i);
            if (result) {
                return result;
            }
        }
        return false;
    };

    async onDrop(pictureFiles) {
        console.log(pictureFiles);
        this.setState({ pictures: pictureFiles })
        // console.log(response);
        // console.log(pictureFiles);
        // console.log(pictureDataURLs);
        // this.setState({
        //     pictures: this.state.pictures.concat(pictureFiles),
        // });
    }

    async uploadFoto() {
        let formData = new FormData()
        formData.append('file', this.state.pictures[0])
        api.create().uploadFoto(formData).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.setState({ uploadVisible: false }, () => {
                            this.getUser()
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' }, () => {
                                setTimeout(() => {
                                    window.location.reload()
                                }, 1000);
                            })
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div className={"main-color"} style={{ height: 195, flex: 1, display: 'flex', alignItems: 'flex-end', padding: 20 }}>
                    <div style={{ display: 'flex', alignItems: 'center', justifyContent: 'space-between', width: '100%' }}>
                        <div style={{ display: 'flex', alignItems: 'center' }}>
                            <div style={{ height: 72, width: 72, backgroundColor: 'white', borderRadius: 40, marginRight: 20 }}>
                                <img src={this.state.photo} style={{ width: 72, height: 72, borderRadius: 40 }} />
                            </div>
                            <Typography style={{ fontSize: '24px', color: 'white', fontWeight: 'bold' }}>{this.state.name}</Typography>
                        </div>
                        <div>
                            <button
                                style={{
                                    backgroundColor: 'transparent',
                                    cursor: 'pointer',
                                    borderColor: 'transparent',
                                }}
                                // onClick={() => console.log(tableMeta)}
                                onClick={() => this.setState({ uploadVisible: true })}
                            >
                                {/* <img src={Images.photo} /> */}
                                <div style={{ height: 30, objectFit: 'contain', backgroundColor: '#019ce5', borderRadius: 4, display: 'flex', alignContent: 'center', justifyContent: 'center', paddingLeft: 10, paddingRight: 10 }}>
                                    <img src={Images.camera} />
                                    <Typography style={{ color: '#ffffff', fontSize: 11, fontFamily: 'Nunito Sans, sans-serif', alignSelf: 'center', marginLeft: 5 }}>Change Picture</Typography>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>

                <div>
                    <AppBar position="static">
                        <Tabs indicatorColor="primary" value={this.state.tab} onChange={this.selectTab} aria-label="simple tabs example" style={{ backgroundColor: '#f8f8f8', borderColor: 'transparent' }}>
                            <Tab label="PASSWORD" style={{ color: '#4b4b4b', fontSize: 11 }} />
                            <Tab label="AUTHORIZATION" style={{ color: '#4b4b4b', fontSize: 11 }} />
                        </Tabs>
                    </AppBar>
                    {this.state.tab === 0 ?
                        <form onSubmit={(e) => {
                            e.preventDefault()
                            this.validasi()
                        }}>
                            <div style={{ padding: 20, marginTop: 10, marginBottom: 100 }}>
                                <div style={{ width: 432, borderRadius: 6, boxShadow: '0 1px 4px 0 rgba(0, 0, 0, 0.25)' }}>
                                    <div style={{ width: '100%', height: 64, backgroundColor: '#354960', display: 'flex', paddingLeft: 20, borderTopLeftRadius: 6, borderTopRightRadius: 6, alignItems: 'center' }}>
                                        <Typography style={{ fontSize: '13px', color: 'white', fontWeight: 'bold' }}>Password</Typography>
                                    </div>
                                    <div style={{ padding: 20, justifyContent: 'space-between' }}>
                                        <TextField
                                            style={{ width: '100%' }}
                                            inputProps={{
                                                style: {
                                                    fontSize: 11
                                                }
                                            }}
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    color: '#7e8085'
                                                }
                                            }}
                                            id="filled-required"
                                            name={"oldPassword"}
                                            type={this.state.showPass ? 'text' : 'password'}
                                            label="Old Password"
                                            value={this.state.oldPassword}
                                            variant="outlined"
                                            onChange={(password) => {
                                                this.handleChange(password)
                                            }}
                                            error={this.state.errorOldPassword}
                                            helperText={<Typography style={{ fontSize: 9, marginTop: 4, fontFamily: 'Nunito Sans, sans-serif' }}>{this.state.msgOldPassword}</Typography>}
                                            InputProps={{
                                                endAdornment: <InputAdornment position="end">
                                                    <IconButton
                                                        aria-label="toggle password visibility"
                                                        style={{ color: '#4b4b4b', opacity: 0.5 }}
                                                        onClick={() => this.setState({ showPass: !this.state.showPass })}
                                                        edge="end"
                                                    >
                                                        {this.state.showPass ? <Visibility style={{ fontSize: 18 }} /> : <VisibilityOff style={{ fontSize: 18 }} />}
                                                    </IconButton>
                                                </InputAdornment>,
                                            }}
                                        />
                                        <TextField
                                            style={{ width: '100%', marginTop: 20 }}
                                            inputProps={{
                                                style: {
                                                    fontSize: 11
                                                }
                                            }}
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    color: '#7e8085'
                                                }
                                            }}
                                            id="filled-required"
                                            label="New Password"
                                            name={"password"}
                                            type={this.state.showPass2 ? 'text' : 'password'}
                                            value={this.state.password}
                                            onChange={(password) => {
                                                this.handleChange(password)
                                            }}
                                            error={this.state.errorPassword}
                                            helperText={<Typography style={{ fontSize: 9, marginTop: 4, fontFamily: 'Nunito Sans, sans-serif' }}>{this.state.msgPassword}</Typography>}
                                            variant="outlined"
                                            InputProps={{
                                                endAdornment: <InputAdornment position="end">
                                                    <IconButton
                                                        aria-label="toggle password visibility"
                                                        style={{ color: '#4b4b4b', opacity: 0.5 }}
                                                        onClick={() => this.setState({ showPass2: !this.state.showPass2 })}
                                                        edge="end"
                                                    >
                                                        {this.state.showPass2 ? <Visibility style={{ fontSize: 18 }} /> : <VisibilityOff style={{ fontSize: 18 }} />}
                                                    </IconButton>
                                                </InputAdornment>,
                                            }}
                                        />
                                        <TextField
                                            style={{ width: '100%', marginTop: 20 }}
                                            inputProps={{
                                                style: {
                                                    fontSize: 11
                                                }
                                            }}
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    color: '#7e8085'
                                                }
                                            }}
                                            id="filled-required"
                                            label="Confirm Password"
                                            name={"confirmPassword"}
                                            type={this.state.showPass3 ? 'text' : 'password'}
                                            value={this.state.confirmPassword}
                                            onChange={(confirmPassword) => {
                                                this.handleChange(confirmPassword)
                                            }}
                                            variant="outlined"
                                            error={this.state.errorConfirmPassword}
                                            helperText={<Typography style={{ fontSize: 9, marginTop: 4, fontFamily: 'Nunito Sans, sans-serif' }}>{this.state.msgConfirmPassword}</Typography>}
                                            InputProps={{
                                                endAdornment: <InputAdornment position="end">
                                                    <IconButton
                                                        aria-label="toggle password visibility"
                                                        style={{ color: '#4b4b4b', opacity: 0.5 }}
                                                        onClick={() => this.setState({ showPass3: !this.state.showPass3 })}
                                                        edge="end"
                                                    >
                                                        {this.state.showPass3 ? <Visibility style={{ fontSize: 18 }} /> : <VisibilityOff style={{ fontSize: 18 }} />}
                                                    </IconButton>
                                                </InputAdornment>,
                                            }}
                                        />
                                    </div>
                                    <div style={{ width: '100%', backgroundColor: '#f5f5f5', height: 43, display: 'flex', justifyContent: 'flex-end', padding: 10, borderColor: 'rgba(0, 0, 0, 0.25)', borderWidth: .2, borderStyle: 'dotted' }}>
                                        <button
                                            type="submit"
                                            // onClick={() => this.validasi()}
                                            style={{}}
                                        >
                                            <div style={{ backgroundColor: '#354960', textAlign: 'center', height: 25, width: 64, borderRadius: 3 }}>
                                                <span style={{ color: 'white', fontSize: 11 }}>Save</span>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        :

                        <div style={{ padding: 20, marginTop: 10, marginBottom: 100 }}>
                            <div style={{ width: 432, borderRadius: 6, boxShadow: '0 1px 4px 0 rgba(0, 0, 0, 0.25)' }}>
                                <div style={{ width: '100%', height: 64, backgroundColor: '#354960', display: 'flex', paddingLeft: 20, borderTopLeftRadius: 6, borderTopRightRadius: 6, alignItems: 'center' }}>
                                    <Typography style={{ fontSize: '13px', color: 'white', fontWeight: 'bold' }}>Authorization</Typography>
                                </div>
                                <div style={{ padding: 20, overflow: 'scroll', height: '40vh' }}>
                                    {/* <div style={{ display: 'flex' }}>
                                        <img src={Images.check} style={{ marginRight: 10 }} />
                                        <Typography style={{ fontSize: 14, opacity: .5, color: '#4b4b4b' }}>Agro PersadaTriputra </Typography>
                                    </div>
                                    <div style={{ display: 'flex', marginTop: 20 }}>
                                        <img src={Images.check} style={{ marginRight: 10 }} />
                                        <Typography style={{ fontSize: 14, opacity: .5, color: '#4b4b4b' }}>Dharma Group</Typography>
                                    </div>
                                    <div style={{ display: 'flex', marginTop: 20, paddingLeft: 20 }}>
                                        <img src={Images.check} style={{ marginRight: 10 }} />
                                        <Typography style={{ fontSize: 14, opacity: .5, color: '#4b4b4b' }}>Dharma Polimetal</Typography>
                                    </div>
                                    <div style={{ display: 'flex', marginTop: 20, paddingLeft: 20 }}>
                                        <img src={Images.check} style={{ marginRight: 10 }} />
                                        <Typography style={{ fontSize: 14, opacity: .5, color: '#4b4b4b' }}>Dharma Poliplast</Typography>
                                    </div> */}
                                    {this.state.listCompany.map((item, index) => {
                                        return (
                                            <div>
                                                {/* <ul>
                                                    <li> */}
                                                <div style={{ display: 'flex', flexDirection: 'row', alignItems: 'center', justifyContent: 'flex-start' }}>
                                                    {item.children.length > 0 && <span onClick={() => this.handleCollapse(item)} style={{ marginLeft: 7, marginRight: 2 }}>
                                                        {item.collapse ? <RemoveIcon color={'action'} fontSize={'small'} /> : <AddIcon color={'action'} fontSize={'small'} />}
                                                    </span>}
                                                    <span>
                                                        <CustomCheckbox
                                                            checked={this.handleItemChecked(item)}
                                                            onChange={() => null}
                                                        />
                                                    </span>
                                                    <Typography style={{ fontSize: 12 }}>{titleCase(item.company_name)}</Typography>
                                                </div>
                                                {!R.isNil(item.children) && this.renderChildren(item)}
                                                {/* </li>
                                                </ul> */}
                                            </div>
                                        )
                                    })}
                                </div>
                            </div>
                        </div>
                    }
                </div>
                {this.state.uploadVisible && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ uploadVisible: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <ImageUploader
                                withIcon={true}
                                withPreview
                                buttonStyles={this.state.pictures.length > 0 ? { display: 'none' } : null}
                                buttonText={'Select Picture'}
                                onChange={this.onDrop}
                                imgExtension={['.jpg', '.gif', '.png', '.gif', '.jpeg']}
                                maxFileSize={1000000}
                                label={"Max file size: 1 Mb, accepted: jpg or png"}
                            />
                            {this.state.pictures.length > 0 ?
                                <div style={{ display: 'grid', margin: 20 }}>
                                    <div style={{ justifySelf: 'center' }}>

                                        <span className="main-color" style={{ color: '#fff', padding: 20, paddingBottom: 10, paddingTop: 10, borderRadius: 15, cursor: 'pointer' }} onClick={() => this.uploadFoto()}>Upload</span>
                                    </div>
                                </div> : null
                            }
                        </div>
                    </div>
                )}
            </div>

        );
    }
}
