import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, MuiThemeProvider, TableCell, FormControlLabel, TextField, Input, Tooltip, withStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import api from '../../api';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { Alert, Autocomplete } from '@material-ui/lab';
import * as R from 'ramda';
import Constant from '../../library/Constant';
import { fixNumber, titleCase } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};
const stylenotes = {
    position: "sticky",
    background: "white",
    zIndex: 101,
    left: 350
};

const styleNotesEmpty = {
    position: "sticky",
    background: "white",
    zIndex: 99,
    left: 0
}

export default class ProfitLoss extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            visibleProfitLoss: true,
            disabledSave: true,
            editable: false,
            buttonError: false,
            judulColumn: null,
            updateBy: [],
            buttonDraft: true,
            handleDoubleClick: 0,
            fromUpload: false,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
            previewUpload: false
        }
        this.handleValue = this.handleValue.bind(this)
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getItemHierarki()
        this.getLatestUpdate()
        this.getSettingControlCurrency()
        console.log(this.props);
    }

    getSettingControlCurrency() {
        let body = {
            group: 'CURRENCY_MONEY_FORMAT',
            company_id: this.props.company.company_id,
            type: this.props.defaultCurrency.value,
        }
        console.log(body);

        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            //     // this.setState({
            //     //     minValue: response.data.data[0] ? response.data.data[0].min_value : null,
            //     //     maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
            //     // }, () => {
            //     //     this.getItemHierarki()
            //     // })
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            // "currency_id": this.props.defaultCurrency.id
        }
        api.create().getLastestUpdateMB(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    getItemHierarki() {
        console.log(this.props);
        this.setState({ loading: true, judulColumn: null })
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            "currency_id": this.props.defaultCurrency.id
        }
        api.create().getDetailReportMB(payload).then(response => {
            console.log(response);
            let dataTable = []
            this.setState({ visibleProfitLoss: true })
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                dataTable.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.profit_loss.notes === "" ? null : item.profit_loss.notes,
                                    item.profit_loss.total_actual_before === null ? "0.0" : item.profit_loss.total_actual_before === "" ? "0.0" : item.profit_loss.total_actual_before,
                                    item.profit_loss.january == '0' ? "0.0" : item.profit_loss.january == '' ? "0.0" : item.profit_loss.january,
                                    item.profit_loss.february == '0' ? "0.0" : item.profit_loss.february == '' ? "0.0" : item.profit_loss.february,
                                    item.profit_loss.march == '0' ? "0.0" : item.profit_loss.march == '' ? "0.0" : item.profit_loss.march,
                                    item.profit_loss.april == '0' ? "0.0" : item.profit_loss.april == '' ? "0.0" : item.profit_loss.april,
                                    item.profit_loss.may == '0' ? "0.0" : item.profit_loss.may == '' ? "0.0" : item.profit_loss.may,
                                    item.profit_loss.june == '0' ? "0.0" : item.profit_loss.june == '' ? "0.0" : item.profit_loss.june,
                                    item.profit_loss.july == '0' ? "0.0" : item.profit_loss.july == '' ? "0.0" : item.profit_loss.july,
                                    item.profit_loss.august == '0' ? "0.0" : item.profit_loss.august == '' ? "0.0" : item.profit_loss.august,
                                    item.profit_loss.september == '0' ? "0.0" : item.profit_loss.september == '' ? "0.0" : item.profit_loss.september,
                                    item.profit_loss.october == '0' ? "0.0" : item.profit_loss.october == '' ? "0.0" : item.profit_loss.october,
                                    item.profit_loss.november == '0' ? "0.0" : item.profit_loss.november == '' ? "0.0" : item.profit_loss.november,
                                    item.profit_loss.december == '0' ? "0.0" : item.profit_loss.december == '' ? "0.0" : item.profit_loss.december,
                                    item.profit_loss.total_current_year == '0' ? "0.0" : item.profit_loss.total_current_year == '' ? "0.0" : item.profit_loss.total_current_year,
                                    item.profit_loss.total_next_year == '0' ? "0.0" : item.profit_loss.total_next_year == '' ? "0.0" : item.profit_loss.total_next_year,
                                    item.profit_loss.total_more_year == '0' ? "0.0" : item.profit_loss.total_more_year == '' ? "0.0" : item.profit_loss.total_more_year,
                                    item.order
                                ])
                            }
                            // if (item.id === 20092) {
                            //     console.log(item);
                            //     console.log(dataTable);
                            // }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_loss.notes === "" ? null : item.profit_loss.notes,
                                item.profit_loss.total_actual_before === null ? "0.0" : item.profit_loss.total_actual_before === "" ? "0.0" : item.profit_loss.total_actual_before,
                                item.profit_loss.january == '0' ? "0.0" : item.profit_loss.january == '' ? "0.0" : item.profit_loss.january,
                                item.profit_loss.february == '0' ? "0.0" : item.profit_loss.february == '' ? "0.0" : item.profit_loss.february,
                                item.profit_loss.march == '0' ? "0.0" : item.profit_loss.march == '' ? "0.0" : item.profit_loss.march,
                                item.profit_loss.april == '0' ? "0.0" : item.profit_loss.april == '' ? "0.0" : item.profit_loss.april,
                                item.profit_loss.may == '0' ? "0.0" : item.profit_loss.may == '' ? "0.0" : item.profit_loss.may,
                                item.profit_loss.june == '0' ? "0.0" : item.profit_loss.june == '' ? "0.0" : item.profit_loss.june,
                                item.profit_loss.july == '0' ? "0.0" : item.profit_loss.july == '' ? "0.0" : item.profit_loss.july,
                                item.profit_loss.august == '0' ? "0.0" : item.profit_loss.august == '' ? "0.0" : item.profit_loss.august,
                                item.profit_loss.september == '0' ? "0.0" : item.profit_loss.september == '' ? "0.0" : item.profit_loss.september,
                                item.profit_loss.october == '0' ? "0.0" : item.profit_loss.october == '' ? "0.0" : item.profit_loss.october,
                                item.profit_loss.november == '0' ? "0.0" : item.profit_loss.november == '' ? "0.0" : item.profit_loss.november,
                                item.profit_loss.december == '0' ? "0.0" : item.profit_loss.december == '' ? "0.0" : item.profit_loss.december,
                                item.profit_loss.total_current_year == '0' ? "0.0" : item.profit_loss.total_current_year == '' ? "0.0" : item.profit_loss.total_current_year,
                                item.profit_loss.total_next_year == '0' ? "0.0" : item.profit_loss.total_next_year == '' ? "0.0" : item.profit_loss.total_next_year,
                                item.profit_loss.total_more_year == '0' ? "0.0" : item.profit_loss.total_more_year == '' ? "0.0" : item.profit_loss.total_more_year,
                                item.order
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dataTable)
                        this.setState({ dataTable, loading: false, buttonError: true, editable: true }, () => {
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Connection Timeout, please check your Connection', tipeAlert: 'error', loading: false })
            }

        })
    }

    handleValue(data) {
        let total = 0
        this.state.dataTable.map((item, index) => {
            if (data.rowData[1] == item[2]) {
                total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
            }
        })
        let indexParent = this.state.dataTable.findIndex((val) => val[1] == this.state.dataTable[data.rowIndex][2])
        let a = this.state.dataTable[data.rowIndex][data.columnIndex] = total
        // console.log(indexParent);
        return a
    }

    handleChange(value, tableMeta) {
        console.log(value);
        let val = String(value).split(",").join("")
        let data = this.state.dataTable
        let indexParent = data.findIndex((val) => val[1] == data[tableMeta.rowIndex][2])
        if (indexParent > 0) {
            // console.log(indexParent)
            let a = data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            let jagain = data[indexParent][tableMeta.columnIndex]
            a = data[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
        } else {
            data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
    }

    backToMasterBudget(type) {
        // tambahin currency
        let data = []

        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                notes: i[6] == null || i[6] == "" ? "" : String(i[6]),
                total_actual_before: this.props.defaultCurrency.id == 2 ? String(Number(i[7])) : String(fixNumber(Number(i[7]), 1)),
                january: this.props.defaultCurrency.id == 2 ? String(Number(i[8])) : String(fixNumber(Number(i[8]), 1)),
                february: this.props.defaultCurrency.id == 2 ? String(Number(i[9])) : String(fixNumber(Number(i[9]), 1)),
                march: this.props.defaultCurrency.id == 2 ? String(Number(i[10])) : String(fixNumber(Number(i[10]), 1)),
                april: this.props.defaultCurrency.id == 2 ? String(Number(i[11])) : String(fixNumber(Number(i[11]), 1)),
                may: this.props.defaultCurrency.id == 2 ? String(Number(i[12])) : String(fixNumber(Number(i[12]), 1)),
                june: this.props.defaultCurrency.id == 2 ? String(Number(i[13])) : String(fixNumber(Number(i[13]), 1)),
                july: this.props.defaultCurrency.id == 2 ? String(Number(i[14])) : String(fixNumber(Number(i[14]), 1)),
                august: this.props.defaultCurrency.id == 2 ? String(Number(i[15])) : String(fixNumber(Number(i[15]), 1)),
                september: this.props.defaultCurrency.id == 2 ? String(Number(i[16])) : String(fixNumber(Number(i[16]), 1)),
                october: this.props.defaultCurrency.id == 2 ? String(Number(i[17])) : String(fixNumber(Number(i[17]), 1)),
                november: this.props.defaultCurrency.id == 2 ? String(Number(i[18])) : String(fixNumber(Number(i[18]), 1)),
                december: this.props.defaultCurrency.id == 2 ? String(Number(i[19])) : String(fixNumber(Number(i[19]), 1)),
                total_current_year: this.props.defaultCurrency.id == 2 ? String(Number(i[20])) : String(fixNumber(Number(i[20]), 1)),
                total_next_year: this.props.defaultCurrency.id == 2 ? String(Number(i[21])) : String(fixNumber(Number(i[21]), 1)),
                total_more_year: this.props.defaultCurrency.id == 2 ? String(Number(i[22])) : String(fixNumber(Number(i[22]), 1))
            })
        })
        // if (this.props.defaultCurrency.id == 2) {

        // } else {
        //     this.state.dataTable.map(i => {
        //         data.push({
        //             item_report_id: i[1],
        //             notes: i[6] == null || i[6] == "" ? "" : String(i[6]),
        //             total_actual_before: String(fixNumber(Number(i[7]), 1)),
        //             january: String(fixNumber(Number(i[8]), 1)),
        //             february: String(fixNumber(Number(i[9]), 1)),
        //             march: String(fixNumber(Number(i[10]), 1)),
        //             april: String(fixNumber(Number(i[11]), 1)),
        //             may: String(fixNumber(Number(i[12]), 1)),
        //             june: String(fixNumber(Number(i[13]), 1)),
        //             july: String(fixNumber(Number(i[14]), 1)),
        //             august: String(fixNumber(Number(i[15]), 1)),
        //             september: String(fixNumber(Number(i[16]), 1)),
        //             october: String(fixNumber(Number(i[17]), 1)),
        //             november: String(fixNumber(Number(i[18]), 1)),
        //             december: String(fixNumber(Number(i[19]), 1)),
        //             total_current_year: String(fixNumber(Number(i[20]), 1)),
        //             total_next_year: String(fixNumber(Number(i[21]), 1)),
        //             total_more_year: String(fixNumber(Number(i[22]), 1))
        //         })
        //     })
        // }

        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "status": type,
            "profit_loss": data
        }
        console.log(payload);
        this.setState({ loading: false })
        if (type == 'submitted') {
            this.props.saveToMasterBudget(payload, 'PL')
        } else {
            this.props.saveToMasterBudget(payload, 'DraftPL')
        }
        this.props.onClickClose()
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Master Budget Profit & Loss.xlsx';
            a.click();
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(resp.rows[2]);
                console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            item_report_id: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                            notes: i[2] === undefined ? "" : String(i[2]).trim(),
                            total_actual_before: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[3]).trim(),
                            january: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            february: i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[5]).trim(),
                            march: i[6] === undefined ? "0" : reg.test(String(i[6])) === false ? "0" : String(i[6]).trim(),
                            april: i[7] === undefined ? "0" : reg.test(String(i[7])) === false ? "0" : String(i[7]).trim(),
                            may: i[8] === undefined ? "0" : reg.test(String(i[8])) === false ? "0" : String(i[8]).trim(),
                            june: i[9] === undefined ? "0" : reg.test(String(i[9])) === false ? "0" : String(i[9]).trim(),
                            july: i[10] === undefined ? "0" : reg.test(String(i[10])) === false ? "0" : String(i[10]).trim(),
                            august: i[11] === undefined ? "0" : reg.test(String(i[11])) === false ? "0" : String(i[11]).trim(),
                            september: i[12] === undefined ? "0" : reg.test(String(i[12])) === false ? "0" : String(i[12]).trim(),
                            october: i[13] === undefined ? "0" : reg.test(String(i[13])) === false ? "0" : String(i[13]).trim(),
                            november: i[14] === undefined ? "0" : reg.test(String(i[14])) === false ? "0" : String(i[14]).trim(),
                            december: i[15] === undefined ? "0" : reg.test(String(i[15])) === false ? "0" : String(i[15]).trim(),
                            total_current_year: i[16] === undefined ? "0" : reg.test(String(i[16])) === false ? "0" : String(i[16]).trim(),
                            total_next_year: i[17] === undefined ? "0" : reg.test(String(i[17])) === false ? "0" : String(i[17]).trim(),
                            total_more_year: i[18] === undefined ? "0" : reg.test(String(i[18])) === false ? "0" : String(i[18]).trim()
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    profit_loss: payload,
                    status: 'submitted'
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[2] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkUploadMB(payload).then(response => {
            console.log(response);
            // console.log(JSON.stringify(this.state.payload));
            console.log(this.state.defaultCurrencyUpload.id)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleProfitLoss: false, loading: true })
                    let dataTable = response.data.data.map((item, index) => {
                        if (this.state.defaultCurrencyUpload.id == 2) {
                            return [
                                item.type_report_id,
                                item.item_report_id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.item_report,
                                item.notes,
                                item.total_actual_before == 0 ? "0.0" : item.total_actual_before,
                                item.january == 0 ? "0.0" : item.january,
                                item.february == 0 ? "0.0" : item.february,
                                item.march == 0 ? "0.0" : item.march,
                                item.april == 0 ? "0.0" : item.april,
                                item.may == 0 ? "0.0" : item.may,
                                item.june == 0 ? "0.0" : item.june,
                                item.july == 0 ? "0.0" : item.july,
                                item.august == 0 ? "0.0" : item.august,
                                item.september == 0 ? "0.0" : item.september,
                                item.october == 0 ? "0.0" : item.october,
                                item.november == 0 ? "0.0" : item.november,
                                item.december == 0 ? "0.0" : item.december,
                                item.total_current_year == 0 ? "0.0" : item.total_current_year,
                                item.total_next_year == 0 ? "0.0" : item.total_next_year,
                                item.total_more_year == 0 ? "0.0" : item.total_more_year,
                                item.orders,
                                item.error
                            ]
                        } else {
                            return [
                                item.type_report_id,
                                item.item_report_id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.item_report,
                                item.notes,
                                fixNumber(Number(item.total_actual_before), 1),
                                fixNumber(Number(item.january), 1),
                                fixNumber(Number(item.february), 1),
                                fixNumber(Number(item.march), 1),
                                fixNumber(Number(item.april), 1),
                                fixNumber(Number(item.may), 1),
                                fixNumber(Number(item.june), 1),
                                fixNumber(Number(item.july), 1),
                                fixNumber(Number(item.august), 1),
                                fixNumber(Number(item.september), 1),
                                fixNumber(Number(item.october), 1),
                                fixNumber(Number(item.november), 1),
                                fixNumber(Number(item.december), 1),
                                fixNumber(Number(item.total_current_year), 1),
                                fixNumber(Number(item.total_next_year), 1),
                                fixNumber(Number(item.total_more_year), 1),
                                item.orders,
                                item.error
                            ]
                        }

                    })
                    console.log(dataTable);
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true, fromUpload: true, previewUpload: true }, () => {
                        this.state.dataTable.map(item => {
                            if (item[24].length > 0) {
                                // console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true, editable: true })
                            }
                        })
                        // console.log(this.state.buttonError)
                    })

                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadProfitLoss(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                notes: String(i[6]),
                total_actual_before: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[7])) : String(fixNumber(Number(i[7]), 1)),
                january: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[8])) : String(fixNumber(Number(i[8]), 1)),
                february: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[9])) : String(fixNumber(Number(i[9]), 1)),
                march: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[10])) : String(fixNumber(Number(i[10]), 1)),
                april: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[11])) : String(fixNumber(Number(i[11]), 1)),
                may: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[12])) : String(fixNumber(Number(i[12]), 1)),
                june: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[13])) : String(fixNumber(Number(i[13]), 1)),
                july: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[14])) : String(fixNumber(Number(i[14]), 1)),
                august: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[15])) : String(fixNumber(Number(i[15]), 1)),
                september: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[16])) : String(fixNumber(Number(i[16]), 1)),
                october: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[17])) : String(fixNumber(Number(i[17]), 1)),
                november: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[18])) : String(fixNumber(Number(i[18]), 1)),
                december: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[19])) : String(fixNumber(Number(i[19]), 1)),
                total_current_year: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[20])) : String(fixNumber(Number(i[20]), 1)),
                total_next_year: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[21])) : String(fixNumber(Number(i[21]), 1)),
                total_more_year: this.state.defaultCurrencyUpload.id == 2 ? String(Number(i[22])) : String(fixNumber(Number(i[22]), 1)),
            })
        })

        // if (this.state.defaultCurrencyUpload.id == 2) {

        // } else {
        //     this.state.dataTable.map(i => {
        //         data.push({
        //             item_report_id: i[1],
        //             notes: String(i[6]),
        //             total_actual_before: String(fixNumber(Number(i[7]), 1)),
        //             january: String(fixNumber(Number(i[8]), 1)),
        //             february: String(fixNumber(Number(i[9]), 1)),
        //             march: String(fixNumber(Number(i[10]), 1)),
        //             april: String(fixNumber(Number(i[11]), 1)),
        //             may: String(fixNumber(Number(i[12]), 1)),
        //             june: String(fixNumber(Number(i[13]), 1)),
        //             july: String(fixNumber(Number(i[14]), 1)),
        //             august: String(fixNumber(Number(i[15]), 1)),
        //             september: String(fixNumber(Number(i[16]), 1)),
        //             october: String(fixNumber(Number(i[17]), 1)),
        //             november: String(fixNumber(Number(i[18]), 1)),
        //             december: String(fixNumber(Number(i[19]), 1)),
        //             total_current_year: String(fixNumber(Number(i[20]), 1)),
        //             total_next_year: String(fixNumber(Number(i[21]), 1)),
        //             total_more_year: String(fixNumber(Number(i[22]), 1)),
        //         })
        //     })
        // }

        let body = {
            submission_id: this.props.submissionID,
            company_id: this.props.company.company_id,
            periode: this.props.periode,
            report_id: this.props.report_id,
            currency_id: this.state.defaultCurrencyUpload?.id,
            profit_loss: data,
            status: type
        }
        console.log(body);
        // console.log(this.state.dataTable);
        // console.log(JSON.stringify(body));
        api.create('UPLOAD').uploadMasterBudget(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.props.onClickClose()
                        if (type == 'submitted') {
                            this.props.getReport('PL')
                        } else {
                            this.props.getReport()
                        }
                    } else {
                        if (response.data.message == "Please Set Up Rate Currency First") {
                            this.setState({ visibleAlertSave: true })
                        } else {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                    setTimeout(() => {
                                        localStorage.removeItem(Constant.TOKEN)
                                        window.location.reload();
                                    }, 1000);
                                }
                            })
                        }
                        // alert(response.data.status)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error', loading: false })
            }
        })
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${this.props.submissionID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        let sub_null = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        // console.log(url);
        let res = await fetch(
            this.props.submissionID == null ? sub_null : url
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Master Budget Profit & Loss.xlsx';
            a.click();
        }
    }

    handleValidate() {
        console.log(this.state.dataTable);
        let data = []
        // console.log(JSON.stringify(this.state.dataTable))
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                notes: i[6] == null || i[6] == "" ? "" : String(i[6]),
                total_actual_before: String(i[7]),
                january: i[0] === 3 && i[8] === "" ? "0.0" : String(i[8]),
                february: i[0] === 3 && i[9] === "" ? "0.0" : String(i[9]),
                march: i[0] === 3 && i[10] === "" ? "0.0" : String(i[10]),
                april: i[0] === 3 && i[11] === "" ? "0.0" : String(i[11]),
                may: i[0] === 3 && i[12] === "" ? "0.0" : String(i[12]),
                june: i[0] === 3 && i[13] === "" ? "0.0" : String(i[13]),
                july: i[0] === 3 && i[14] === "" ? "0.0" : String(i[14]),
                august: i[0] === 3 && i[15] === "" ? "0.0" : String(i[15]),
                september: i[0] === 3 && i[16] === "" ? "0.0" : String(i[16]),
                october: i[0] === 3 && i[17] === "" ? "0.0" : String(i[17]),
                november: i[0] === 3 && i[18] === "" ? "0.0" : String(i[18]),
                december: i[0] === 3 && i[19] === "" ? "0.0" : String(i[19]),
                total_current_year: i[0] === 3 && i[20] === "" ? "0.0" : String(i[20]),
                total_next_year: i[0] === 3 && i[21] === "" ? "0.0" : String(i[21]),
                total_more_year: i[0] === 3 && i[22] === "" ? "0.0" : String(i[22])
            })
        })
        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "profit_loss": data,
            "status": "submitted"
        }
        console.log(payload)
        api.create().validateSubmitReport(payload).then((response) => {
            console.log(response)
            if (response.data.data.result) {
                this.setState({ loading: false, buttonError: false, editable: false })
            } else {
                this.setState({ loading: false, buttonError: true, editable: true })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        const handleChange = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
        const handleTotal = (tableMeta) => {
            let total = 0
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index >= 8 && index <= 19) {
                    let valItem = item == undefined || item == "" ? 0 : item
                    total += Number(valItem)
                }
            })
            // if (tableMeta.rowData[1] === 20092) {
            //     console.log(total);
            //     console.log(dataTable2[tableMeta.rowIndex]);
            // }
            let indexParent = dataTable2.findIndex((val) => val[1] == tableMeta.rowData[2])
            if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "sales price") {
                let value = Number(dataTable2[tableMeta.rowIndex - 2][20]) / Number(dataTable2[tableMeta.rowIndex - 1][20])
                dataTable2[tableMeta.rowIndex][20] = R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
                return R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
            } else if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "total man power") {
                let totalTMP = dataTable2[tableMeta.rowIndex][20] = dataTable2[tableMeta.rowIndex][19]
                return totalTMP
            } else if (indexParent !== -1 && String(dataTable2[indexParent][5]).toLocaleUpperCase() == "GROSS PROFIT MARGIN (% OF REVENUE)") {
                return handleFormula(0, tableMeta, 0)
            }
            else {

                dataTable2[tableMeta.rowIndex][20] = total
                return total
            }
            // console.log(total);
        }
        const handleNotes = (value, tableMeta) => {
            // console.log(value)
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
            // console.log(dataTable2[tableMeta.rowIndex]);
        }
        const handleValue = (value, data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] == item[2] && item[5] !== "-") {
                    total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(String(item[data.columnIndex]).includes('-') ? Number(String(item[data.columnIndex]).substr(1, String(item[data.columnIndex]).length)) * -1 : Number(item[data.columnIndex])))
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] == dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex] = Number(total)
            // let a = dataTable2[data.rowIndex][data.columnIndex] = Number(value)
            // console.log(indexParent);
            return a
        }
        const handleFormula = (data, tableMeta, month) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayJumlah = []
            let tambahan = false
            let opet = ""
            arrayFormula.map((item, indexs) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*') {
                    arrayJumlah.push(item)
                } else {
                    let index = dataTable2.findIndex((val) => val[23] == item)
                    if (tambahan) {
                        if (item == '-' || item == '+' || item == '/' || item == '*') {
                            opet = item
                        } else {
                            arrayJumlah.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                            tambahan = false
                            opet = ""
                        }
                    } else {
                        if (index != -1) {
                            if (item === String(tableMeta.rowData[23])) {
                                arrayJumlah.push(0)
                            } else {
                                arrayJumlah.push(dataTable2[index][tableMeta.columnIndex])
                            }
                        }
                    }
                }

                // if (indexs % 2 !== 0) {
                //     operator.push(item)
                // }
            })
            // if (String(tableMeta.rowData[5]) == "Net Income for the year (NPAT)") {
            // console.log(tableMeta.rowData[3])
            // console.log(arrayFormula)
            // console.log(arrayJumlah)
            // }

            let array = arrayJumlah
            let total = 0
            let opt = ""
            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                        console.log();
                    } else if (opt == "bagi") {
                        total = R.equals((Number(total) / Number(item)), NaN) ? '0.0' : (R.equals((Number(total) / Number(item)), Infinity) ? '0.0' : (Number(total) / Number(item) == "-Infinity") ? "0.0" : Number(total) / Number(item))
                    } else {
                        total += Number(item)
                    }
                }
            })
            total = R.equals(total, NaN) ? "0.0" : (R.equals(total, Infinity) ? "0.0" : (total == "-Infinity" ? "0.0" : total))
            // if (String(tableMeta.rowData[5]) == "Net Income for the year (NPAT)") {
            //     console.log(total);
            // }
            // if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] === "" || dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] === undefined || dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] === null) {
            // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total)
            // // }
            // return Number(total)
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total)
            // }
            // return Number(total)
            return Number(total)

        }

        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {tableMeta.rowData[24] ?
                                tableMeta.rowData[24].length > 0 ?
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </LightTooltip>
                                    </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                :
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Notes",
            options: {
                customHeadRender: (columnMeta) => (
                    dataTable2.length > 0 ?
                        <TableCell style={{ ...stylenotes, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> :
                        <TableCell style={{ ...styleNotesEmpty, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                ),
                setCellProps: () => ({
                    style: {
                        position: "sticky",
                        background: "white",
                        zIndex: 101,
                        left: 350
                    }
                }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            <div style={{ flex: 1 }}>
                                {tableMeta.rowData[0] === 4 ? null : tableMeta.rowData[4] === 0 ? null : tableMeta.rowData[4] === 1 ? null :
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        // value={value}
                                        control={
                                            <Input
                                                disableUnderline={true}
                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                defaultValue={value}
                                                onBlur={(event) => {
                                                    // updateValue(event.target.value)
                                                    handleNotes(event.target.value, tableMeta)
                                                    // console.log(dataTable2)
                                                }}
                                            />
                                        }
                                    />}
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.periode) - 1} Actual`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                // //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        ////decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            {/* <div>{value}</div> */}
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            console.log(event);
                                                            handleChange(event.target.value, tableMeta)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 1)), 1)}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 1)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Feb ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 2)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 2)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Mar ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 3)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 3)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Apr ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 4)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 4)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 4)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 4)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `May ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 5)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 5)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 5)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 5)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jun ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 6)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 6)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 6)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 6)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jul ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 7)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 7)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 7)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 7)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Aug ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 8)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 8)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 8)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 8)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Sep ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={Number(fixNumber(Number(handleFormula(value, tableMeta, 9)), 1)) == 0 ? "0.0" : Number(fixNumber(Number(handleFormula(value, tableMeta, 9)), 1))}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={Number(fixNumber(Number(handleFormula(value, tableMeta, 9)), 1)) == 0 ? "0.0" : Number(fixNumber(Number(handleFormula(value, tableMeta, 9)), 1))}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Oct ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 10)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 10)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 10)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 10)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Nov ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 11)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 11)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 11)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 11)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Dec ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 12)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 12)), 1)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 12)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 12)), 1)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Current Total",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ width: 96, textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 4 ?
                                        null : tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span> :
                                            // tableMeta.rowData[0] === 6 ?
                                            //     <NumberFormat
                                            //         thousandSeparator={true}
                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            //         type="text"
                                            //         placeholder=""
                                            //         disabled={true}
                                            //         value={fixNumber(Number(handleFormula(value, tableMeta, 12), 1)}}
                                            //     /> :
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    //  value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                    value={fixNumber(Number(handleTotal(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta)), 1)}
                                                />
                                            </span>}
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.periode) + 1} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 13)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 13)), 1)} ue={handleFormula(value, tableMeta)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 13)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 13)), 1)} ue={handleFormula(value, tableMeta)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.periode) + 2} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                    value={fixNumber(Number(handleValue(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValue(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                        value={fixNumber(Number(handleFormula(value, tableMeta, 14)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 14)), 1)} ue={handleFormula(value, tableMeta)}
                                                    />
                                                    // null
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : (String(value).includes(".") && this.state.previewUpload == true ? String(value).split(".")[1].length : 16)}
                                                            value={fixNumber(Number(handleFormula(value, tableMeta, 14)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(value, tableMeta, 14)), 1)} ue={handleFormula(value, tableMeta)}
                                                        />
                                                        // null
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            // value === "" ?
                                                            //     null :
                                                            //     <NumberFormat
                                                            //         thousandSeparator={true}
                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            //         type="text"
                                                            //         placeholder=""
                                                            //         disabled={true}
                                                            //         value={Number(value)}
                                                            //     />
                                                            null
                                                            :
                                                            null
                            }
                        </div>
                    )
                }
            }
        },
        {
            name: "",
            options: {
                display: false
            }
        },
        {
            name: "",
            options: {
                display: false
            }
        }
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Master Budget Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {/* {this.state.loading && loadingComponent} */}
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleProfitLoss === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Master Budget - Profit & Loss </Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }

                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.state.dataTable.length == 0 ? null : this.props.isApprover == true ?
                                            null
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            // </div> 
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                {((!this.props.truelyApprover) && (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) &&
                                                    <a data-tip={'Download Template'} data-for="template">
                                                        <button
                                                            style={{
                                                                backgroundColor: 'transparent',
                                                                cursor: 'pointer',
                                                                borderColor: 'transparent',
                                                                margin: 5
                                                            }}
                                                            onClick={() => this.downloadTemplate()}
                                                        >
                                                            <img src={Images.template} />
                                                        </button>
                                                    </a>}
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                {((!this.props.truelyApprover) && (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) &&
                                                    <a data-tip={'Upload'} data-for="upload">
                                                        <button
                                                            style={{
                                                                backgroundColor: 'transparent',
                                                                cursor: 'pointer',
                                                                borderColor: 'transparent',
                                                                margin: 5
                                                            }}
                                                            onClick={() => this.setState({ visibleUpload: true })}
                                                        >
                                                            <img src={Images.upload} />
                                                        </button>
                                                    </a>
                                                }
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    {!this.state.loading && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                    <div style={{ color: '#000', marginTop: 10, fontSize: 12 }}>(*) There may be discrepancies in amount due to rounding</div>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.state.dataTable.length == 0 ? null : this.props.isApprover === true ? null :
                                    (!this.props.truelyApprover) && (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ?
                                        <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => {
                                                    this.setState({ loading: true, dataTable: dataTable2, buttonDraft: false }, () => {
                                                        setTimeout(() => {
                                                            this.handleValidate()
                                                        }, 100);
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                                </div>
                                            </button>
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                disabled={this.state.buttonDraft}
                                                onClick={() =>
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.backToMasterBudget('draft')
                                                        })
                                                }

                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                                </div>
                                            </button>
                                            <button
                                                type="button"
                                                disabled={this.state.buttonError}
                                                onClick={() => this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToMasterBudget('submitted')
                                                        })}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                                </div>
                                            </button>
                                        </div> : null
                                }
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode}</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            {!this.state.loading && (
                                                <MuiThemeProvider theme={getMuiTheme()}>
                                                    <MUIDataTable
                                                        data={dataTable2}
                                                        columns={columns}
                                                        options={options}
                                                    />
                                                </MuiThemeProvider>
                                            )}
                                        </div>
                                    )}
                                </div>

                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1">
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, previewUpload: false, dataTable: [], fromUpload: false }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            className="button"
                                            type="button"
                                            disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        this.setState({ loading: false, buttonError: this.state.errorPreview === true ? true : false, editable: false })
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    null :
                                                    this.setState({ loading: true, fromUpload: false }, () =>
                                                        this.state.handleDoubleClick == 1 ? null :
                                                            this.setState({ handleDoubleClick: 1 }, () => {
                                                                setTimeout(() => {
                                                                    this.uploadProfitLoss('draft')
                                                                }, 100);
                                                            })
                                                    )
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    null :
                                                    this.setState({ loading: true, fromUpload: false }, () =>
                                                        this.state.handleDoubleClick == 1 ? null :
                                                            this.setState({ handleDoubleClick: 1 }, () => {
                                                                setTimeout(() => {
                                                                    this.uploadProfitLoss('submitted')
                                                                }, 100);
                                                            })
                                                    )
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>}
                </div>

                {/* {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => {
                                    String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("BUDGET") && String(this.state.judul).includes("PROFIT") && String(this.state.judul).includes("LOSS") ?
                                        this.checkUpload() :
                                        this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                }}
                            />
                            <div style={{ padding: '10px 30px', fontSize: 13}}>Notes: Valid currency for uploading data is <b style={{ color: '#1D2995'}}>{this.props.defaultCurrency.id == 1 ? "IDR" : "USD"}</b></div>
                        </div>
                    </div>
                )} */}

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("BUDGET") && String(this.state.judul).includes("PROFIT") && String(this.state.judul).includes("LOSS") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>

                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

            </div>
        );
    }
}