import React, { Component } from 'react';
import { TextField, Typography, withStyles, Snackbar } from '@material-ui/core';
import * as R from 'ramda'
import { DateTimePicker, KeyboardDatePicker, DatePicker } from "@material-ui/pickers";
import format from "date-fns/format";
import Images from '../../../assets/Images';
import api from '../../../api';
import MuiAlert from '@material-ui/lab/Alert';
import Constant from '../../../library/Constant';

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class CreateUnitBisnis extends Component {
    constructor(props) {
        super(props)
        this.state = {
            id: '',
            status: "",
            name: '',
            startDate: '',
            endDate: '',
            errorName: false,
            errorStartDate: false,
            errorEndDate: false,
            msgErrorName: "",
            msgErrorStartDate: "",
            msgErrorEndDate: "",
            alert: false,
            tipeAlert: '',
            messageAlert: '',
        }
    }
    render() {
        let { type } = this.props
        return type === 'edit' ? this.renderEdit() : this.renderCreate()
    }

    componentDidMount() {
        if (this.props.type === 'edit') {
            this.getDetailUnitBisnis()
            // console.log(this.props.data);
            // this.setState({
            //     id: data[0],
            //     name: data[1],
            //     startDate: data[2],
            //     endDate: data[3]
            // })
        } else {
            let date = format(new Date, 'yyyy-MM-dd')
            // console.log(date);
            this.setState({
                startDate: date,
                endDate: date
            })
        }
    }

    getDetailUnitBisnis() {
        api.create().getDetailUnitBisnis(this.props.data[1]).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        let data = response.data.data
                        this.setState({
                            id: data.business_unit_id,
                            name: data.business_unit_name,
                            startDate: data.start_date,
                            endDate: data.end_date,
                            status: data.status,
                            created: data.created,
                            updated: data.updated === null ? "" : data.updated
                        })
                    }
                    else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({ startDate: format(e, 'yyyy-MM-dd'), endDate: null }, () => {
                this.clearError()
                // console.log(this.state.startDate)
            })
        } else if (isDate && type == 'end_date') {
            this.setState({ endDate: format(e, 'yyyy-MM-dd') }, () => {
                this.clearError()
                // console.log(this.state.endDate)
            })
        } else {
            // this.setState({...data, tempData: {...this.state.tempData, [e.target.name] :  e.target.value}})
        }

    }

    clearError() {
        this.setState({
            errorName: false,
            errorStartDate: false,
            errorEndDate: false,
            msgErrorName: "",
            msgErrorStartDate: "",
            msgErrorEndDate: ""
        })
    }

    validasi() {
        if (R.isEmpty(this.state.name)) {
            this.setState({ errorName: true, msgErrorName: 'Business Unit Cannot be Empty' })
        } else if (R.isEmpty(this.state.startDate)) {
            this.setState({ errorStartDate: true, msgErrorStartDate: 'Valid From Cannot be Empty' })
        } else if (R.isEmpty(this.state.endDate) || this.state.endDate === null) {
            this.setState({ errorEndDate: true, msgErrorEndDate: 'Valid To Cannot be Empty' })
        } else {
            let payload = {
                "business_unit_id": this.state.id,
                "business_unit_name": this.state.name,
                "start_date": this.state.startDate,
                "end_date": this.state.endDate
            }
            this.props.updateUnitBisnis(payload)
        }
    }

    validasiCreate() {
        if (R.isEmpty(this.state.name)) {
            this.setState({ errorName: true, msgErrorName: 'Business Unit Cannot be Empty' })
        } else if (R.isNil(this.state.startDate)) {
            this.setState({ errorStartDate: true, msgErrorStartDate: 'Valid From Cannot be Empty' })
        } else if (R.isNil(this.state.endDate)) {
            this.setState({ errorEndDate: true, msgErrorEndDate: 'Valid To Cannot be Empty' })
        } else {
            let payload = {
                "business_unit_name": this.state.name,
                "start_date": this.state.startDate,
                "end_date": this.state.endDate
            }
            this.props.createUnitBisnis(payload)
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    renderEdit() {
        return (
            <div className="test app-popup-show">
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Edit Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>


                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.id}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.startDate}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorStartDate}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.status}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>

                        <div className="column-2">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="unit"
                                    label="Unit Bisnis"
                                    value={this.state.name}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorName}
                                    helperText={this.state.msgErrorName}
                                    onChange={(e) => this.setState({ name: e.target.value }, () => this.clearError())}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorEndDate}
                                    minDate={this.state.startDate}
                                    value={this.state.endDate}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>

                    </div>

                    <div className="border-bottom margin-top-10px" style={{ padding: '0px 20px 20px 20px', borderRadius: 5 }}>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Created By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.created}</Typography>
                        </div>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Updated By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.updated}</Typography>
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasi()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        )
    }

    renderCreate() {
        return (
            <div className="test app-popup-show" style={{ paddingTop: 100 }}>
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Create Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>


                    <div className="border-bottom grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    // value={this.props.data.business_unit_id}
                                    id="status"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.startDate == "" ? null : this.state.startDate}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorStartDate}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5, backgroundColor: '#e8e8e8', }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    defaultValue={"Active"}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Created By : </Typography>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Updated By : </Typography>
                            </div>
                        </div>

                        <div className="column-2">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="unit"
                                    label="Business Unit"
                                    value={this.state.name}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorName}
                                    helperText={this.state.msgErrorName}
                                    onChange={(e) => this.setState({ name: e.target.value }, () => this.clearError())}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorEndDate}
                                    minDate={this.state.startDate}
                                    value={this.state.endDate == "" ? null : this.state.endDate}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>

                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasiCreate()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div >
        );
    }
}
