import React from 'react';
import { Typography } from '@material-ui/core';

const CustomButton = ({
  children,
  onClick,
  disabled = false,
  type = 'button',
  width = 100,
  height = 25,
  backgroundColor = '#354960',
  textColor = '#fff',
  fontSize = '11px',
  borderRadius = 3,
  // Styling props
  buttonStyle = {},
  textStyle = {},
  wrapperStyle = {},
  // Icon props
  startIcon,
  endIcon,
  // Variants
  variant = 'contained', // 'contained' | 'outlined' | 'text'
  ...props
}) => {
  // Variant styling
  const getVariantStyles = () => {
    switch (variant) {
      case 'outlined':
        return {
          backgroundColor: 'transparent',
          border: `1px solid ${backgroundColor}`,
        };
      case 'text':
        return {
          backgroundColor: 'transparent',
          borderColor: 'transparent',
        };
      default: // contained
        return {
          backgroundColor,
          borderColor: backgroundColor,
        };
    }
  };

  const getTextColor = () => {
    if (variant === 'outlined' || variant === 'text') {
      return backgroundColor;
    }
    return textColor;
  };

  return (
    <button
      type={type}
      disabled={disabled}
      onClick={onClick}
      style={{
        backgroundColor: 'transparent',
        borderColor: 'transparent',
        outline: 'none',
        cursor: disabled ? 'not-allowed' : 'pointer',
        padding: 0,
        ...buttonStyle,
      }}
      {...props}
    >
      <div
        style={{
          backgroundColor: getVariantStyles().backgroundColor,
          border: getVariantStyles().border || 'none',
          width,
          height,
          borderRadius,
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center',
          opacity: disabled ? 0.5 : 1,
          ...wrapperStyle,
        }}
      >
        {startIcon && (
          <span style={{ marginRight: 4, display: 'flex', alignItems: 'center' }}>
            {startIcon}
          </span>
        )}
        
        <Typography
          style={{
            fontSize,
            color: getTextColor(),
            textAlign: 'center',
            ...textStyle,
          }}
        >
          {children}
        </Typography>
        
        {endIcon && (
          <span style={{ marginLeft: 4, display: 'flex', alignItems: 'center' }}>
            {endIcon}
          </span>
        )}
      </div>
    </button>
  );
};

export default CustomButton;