import React, { Component } from 'react';
import { Typography, Paper, TextField, MenuItem, Select, FormControlLabel, createMuiTheme, withStyles, Checkbox, MuiThemeProvider, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import Images from '../../assets/Images';
import OperatingIndicatorDetail from './OperatingIndicatorDetail'
import api from '../../api';
import Autocomplete from '@material-ui/lab/Autocomplete';
import MuiAlert from '@material-ui/lab/Alert';
import { titleCase } from '../../library/Utils';
import { ExcelRenderer } from 'react-excel-renderer';
import UploadFile from "../../library/Upload";
import { format } from 'date-fns';
import Constant from '../../library/Constant';
import OperatingIndicatorMR from '../MonthlyReport/OperatingIndicatorMR';
import OperatingIndicatorRO from '../RollingOutlook/OperatingIndicatorRO';
import { PhotoSizeSelectLargeTwoTone, ThreeSixty } from '@material-ui/icons';
import { startTransition } from 'react';
import { PropagateLoader } from 'react-spinners';

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

const CustomCheckbox = withStyles({
    root: {
        color: '#5198ea',
        '&$checked': {
            color: '#5198ea',
        },
    },
    checked: {},
})((props) => <Checkbox color="default" {...props} />);

export default class OperatingIndicator extends Component {
    constructor(props) {
        super(props)
        this.state = {
            perusahaan: 'TAP Group',
            listRevision: null,
            revision: null,
            visibleOperatingIndicator: true,
            visibleDetailOpt: false,
            visibleDetailMonthly: false,
            visibleDetailRolling: false,
            listPeriode: null,
            periode: null,
            month: null,
            loading: false,
            quartal: null,
            listCompany: null,
            company: null,
            report_id: null,
            listAttachment: [],
            visibleUpload: false,
            operatingIndID: null,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            buttonCreate: true,
            buttonEdit: true,
            buttonDelete: true,
            lastPeriod: '',
            latestPeriode: '',
            statusDetail: '',
            selectReport: [],
            isCheckAll: false,
            downloadedFileReportId: null,
            arrayReport: [],
            popupDownload: false,
            defaultCurrency: null,
            dataCurrency: [],
            currency: [],
            visibleAlertSave: false,
            dataCurrency: [
                {
                    "id": 1,
                    "value": "IDR"
                },
                {
                    "id": 2,
                    "value": "USD",
                }
            ]
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getDetailUser()
        this.getPermission()
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    getPermission() {
        let payload = {
            menu: "operating indicator"
        }
        api.create().getPermission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        buttonCreate: response.data.data.create,
                        buttonEdit: response.data.data.edit,
                        buttonDelete: response.data.data.delete,
                        load: true
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    getLastPeriod() {
        api.create().getLastPeriodOI(this.state.company.company_id).then(response => {
            // console.log(response);
            if (response.data.status === "success") {
                this.setState({ lastPeriod: response.data.data.last_periode, latestPeriode: response.data.data.latest_periode }, () => {
                    this.getPeriode()
                })
            }
        })
    }

    getReportAttachment() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "revision": this.state.revision.revision,
        }
        api.create().getMasterBudgetAtt(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ listAttachment: response.data.data })
                }
            }
            // console.log(response);
        })
    }

    getReport() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "report_type": "operating indicator",
            "currency_id": this.state.defaultCurrency.id
        }
        console.log(payload);
        api.create().getAllOperatingInd(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            item.number,
                            item.report_name,
                            item.current_status === 'closed' ? "CLOSED" : item.current_status,
                            item.report_id,
                            item.is_can_upload
                        ]
                    })
                    // console.log(dataTable);
                    this.setState({ dataTable, dataReport: response.data.data })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    getDetailUser() {
        let userId = localStorage.getItem(Constant.USER)
        api.create().getDetailUser(userId).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ userCompany: response.data.data.company }, () => {
                            this.getCompanyActive()
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                }
            }
        })
    }

    getCompanyActive() {
        api.create().getPerusahaanActive().then((response) => {
            if (response.data) {
                if (response.data.status === 'success') {
                    let data = response.data.data
                    let compActive = []
                    let userCompActive = []
                    this.state.userCompany.map((item, index) => {
                        let indeks = data.findIndex((val) => val.company_id == item)
                        if (indeks !== -1 && String(data[indeks].status).toLocaleLowerCase() == 'active') {
                            userCompActive.push(item)
                        }
                    })

                    data.map((item, index) => {
                        if (String(item.status).toLocaleLowerCase() == 'active') {
                            compActive.push(item)
                        }
                    })

                    if (compActive.length == userCompActive.length) {
                        this.setState({ superUser: false })
                    } else {
                        this.setState({ superUser: true })
                    }

                    let companyData = data.map((item) => {
                        return {
                            company_id: item.company_id,
                            company_name: item.company_name,
                        }
                    })

                    let arrayBaru = []
                    this.state.userCompany.map((item, index) => {
                        let indexID = companyData.findIndex((val) => val.company_id == item)
                        if (indexID !== -1) {
                            arrayBaru.push(companyData[indexID])
                        }
                    })

                    if (arrayBaru.length > 0) {
                        arrayBaru = arrayBaru.sort((a, b) => a.company_name.localeCompare(b.company_name))
                    }

                    let defaultProps = {
                        options: arrayBaru,
                        getOptionLabel: (option) => titleCase(option.company_name),
                    };

                    this.setState({ listCompany: defaultProps, company: arrayBaru.length < 1 ? companyData[0] : arrayBaru[0] }, () => {
                        this.getLastPeriod()
                        this.getCurrency(this.state.company.company_id)
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', listCompany: null, company: null })
            }
        })
    }

    getCurrency(companyID) {
        console.log(companyID);
        api.create().getDetailPerusahaan(companyID).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        let data = response.data.data
                        let datas = []
                        if (response.data.data.currency.length > 0) {
                            response.data.data.currency.map((item) => {
                                // console.log(item);
                                datas.push({
                                    id: item.currencyId,
                                    value: item.currencyName
                                })

                            })
                        }
                        let index = datas.findIndex((val) => val.id == response.data.data.default_currency)
                        this.setState({
                            defaultCurrencyID: response.data.data.default_currency,
                            currency: datas,
                            defaultCurrency: index == -1 ? null : datas[index]
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }

        })
    }

    getPeriode() {
        api.create().getPeriodeTransaction().then(response => {
            let dateNow = new Date
            let year = format(dateNow, 'yyyy')
            let currentYear = new Date().getFullYear()
            if (response.data) {
                if (response.data.status === "success") {
                    let data = []
                    response.data.data.map((item) => {
                        if (this.state.isApprover) {
                            if (item >= 2000 && item <= (Number(currentYear) + 1)) {
                                data.push(item)
                            }
                            // console.log('bibim')
                        } else {
                            if ((item >= 2000) && (item == this.state.lastPeriod || item < this.state.lastPeriod)) {
                                data.push(item)
                            }
                            // console.log('bubum')
                        }
                    })
                    // console.log(this.state.lastPeriod)
                    // console.log(this.state.lastPeriod)
                    // console.log(this.state.isApprover)
                    let periodeData = data.map((item) => {
                        return {
                            periode: item,
                        }
                    })
                    let defaultProps = {
                        options: periodeData,
                        getOptionLabel: (option) => option.periode,
                    };
                    // console.log(defaultProps)
                    let periode = (this.state.lastPeriod == "" ? String(Number(currentYear) + 1) : this.state.lastPeriod)
                    let index = data.sort((a, b) => a - b).findIndex((val) => val === periode)
                    this.setState({ listPeriode: defaultProps, periode: index == -1 ? periodeData[0] : periodeData[index] }, () => {
                        this.getOperatingID()
                    })
                }
            }
        })
    }

    getOperatingID() {
        this.setState({ selectReport: [], isCheckAll: false }, () => {
            let payload = {
                "company_id": this.state.company.company_id,
                "periode": this.state.periode.periode
            }
            api.create().getOpetratingIndID(payload).then(response => {
                console.log(response);
                if (response) {
                    // console.log(response.data.data)
                    this.getLatestPeriodSubmit()
                    if (response.data.data) {
                        this.setState({ operatingIndID: response.data.data.operating_indicator_id, loading: false })
                    } else {
                        this.setState({ operatingIndID: null, loading: false })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            })
        })
    }

    getLatestPeriodSubmit() {
        let body = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode
        }
        api.create().getSubmitOI(body).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ isSubmit: response.data.data.is_can_submit }, () => {
                        this.getReport()
                        // this.getOperatingID()
                    })
                }
            }
        })
    }

    clickDetail(item, id) {
        let index = this.state.dataReport.findIndex((val) => val.report_name == item[1])
        if (index !== -1) {
            // this.setState({
            //     statusDetail: String(item[2]).toLocaleLowerCase(),
            //     dataDetail: { ...this.state.dataReport[index], periode: this.state.periode.periode, operatingIndID: this.state.operatingIndID, company: this.state.company },
            //     visibleOperatingIndicator: false,
            //     visibleDetailOpt: true,
            // })
            if (String(item[1]).toLocaleLowerCase().includes("master budget")) {
                this.setState({
                    statusDetail: String(item[2]).toLocaleLowerCase(),
                    dataDetail: { ...this.state.dataReport[index], periode: this.state.periode.periode, operatingIndID: this.state.operatingIndID, company: this.state.company },
                    visibleOperatingIndicator: false,
                    visibleDetailOpt: true,
                    visibleDetailMonthly: false,
                    visibleDetailRolling: false

                })
            } else if (String(item[1]).toLocaleLowerCase().includes("monthly report")) {
                console.log(item);
                let month = String(item[1]).toLocaleLowerCase().includes('jan') ? 1 :
                    String(item[1]).toLocaleLowerCase().includes('feb') ? 2 :
                        String(item[1]).toLocaleLowerCase().includes('mar') ? 3 :
                            String(item[1]).toLocaleLowerCase().includes('apr') ? 4 :
                                String(item[1]).toLocaleLowerCase().includes('may') ? 5 :
                                    String(item[1]).toLocaleLowerCase().includes('jun') ? 6 :
                                        String(item[1]).toLocaleLowerCase().includes('jul') ? 7 :
                                            String(item[1]).toLocaleLowerCase().includes('aug') ? 8 :
                                                String(item[1]).toLocaleLowerCase().includes('sep') ? 9 :
                                                    String(item[1]).toLocaleLowerCase().includes('oct') ? 10 :
                                                        String(item[1]).toLocaleLowerCase().includes('nov') ? 11 :
                                                            String(item[1]).toLocaleLowerCase().includes('dec') ? 12 : null
                this.setState({
                    statusDetail: String(item[2]).toLocaleLowerCase(),
                    dataDetail: { ...this.state.dataReport[index], periode: this.state.periode.periode, operatingIndID: this.state.operatingIndID, company: this.state.company, status: item[2] },
                    visibleOperatingIndicator: false,
                    visibleDetailOpt: false,
                    visibleDetailMonthly: true,
                    visibleDetailRolling: false,
                    months: month

                })

            } else if (String(item[1]).toLocaleLowerCase().includes("rolling outlook")) {
                let quarter = String(item[1]).toLocaleLowerCase().includes('q1') ? "q1" :
                    String(item[1]).toLocaleLowerCase().includes('q2') ? "q2" :
                        String(item[1]).toLocaleLowerCase().includes('q3') ? "q3" : null
                this.setState({
                    statusDetail: String(item[2]).toLocaleLowerCase(),
                    dataDetail: { ...this.state.dataReport[index], periode: this.state.periode.periode, operatingIndID: this.state.operatingIndID, company: this.state.company, status: item[2] },
                    visibleOperatingIndicator: false,
                    visibleDetailOpt: false,
                    visibleDetailMonthly: false,
                    visibleDetailRolling: true,
                    quartal: quarter

                })
            } else {
                this.setState({
                    statusDetail: String(item[2]).toLocaleLowerCase(),
                    dataDetail: { ...this.state.dataReport[index], periode: this.state.periode.periode, operatingIndID: this.state.operatingIndID, company: this.state.company },
                    visibleOperatingIndicator: false,
                    visibleDetailOpt: false,
                    visibleDetailMonthly: false,
                    visibleDetailRolling: true

                })

            }
        }
    }

    handleChange(value, tableMeta) {
        let data = this.state.dataTable
        data[tableMeta.rowIndex][tableMeta.columnIndex] = value
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                const formData = new FormData();
                formData.append("revision", Number(this.state.revision.revision));
                formData.append("companyId", this.state.company.company_id);
                formData.append("periode", Number(this.state.periode.periode));
                formData.append("file", event);
                this.setState({ formData })
            }
        })
    }

    uploadAttachment(formData) {
        api.create().uploadAttachment(formData).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ visibleUpload: false }, () => {
                        this.getReport()
                        this.getReportAttachment()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
            // console.log(response)
        })
    }

    saveOperatingInd(payload) {
        api.create().createOpetaingInd(payload).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ visibleDetailOpt: false, visibleOperatingIndicator: true, loading: false }, () =>
                        this.getOperatingID(),
                        this.getReport()
                    )
                } else {
                    if (response.data.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true, loading: false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                    }

                }

            } else {
                this.setState({ alert: true, messageAlert: "Error saving data. Please try again", tipeAlert: 'warning', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    saveMonthlyOI(payload) {
        api.create().createMonthlyReportOI(payload).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ visibleDetailMonthly: false, visibleOperatingIndicator: true, loading: false }, () =>
                        this.getOperatingID(),
                        this.getReport()
                    )
                } else {
                    if (response.data.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true, loading: false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                    }

                }

            } else {
                this.setState({ alert: true, messageAlert: "Error saving data. Please try again", tipeAlert: 'warning', loading: false, handleDoubleClick: 0 })
            }
            // this.getReport()
            // this.getOperatingID()
        })
    }

    saveRollingOI(payload) {
        api.create().createRollingOI(payload).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ visibleDetailRolling: false, visibleOperatingIndicator: true, loading: false }, () =>
                        this.getOperatingID(),
                        this.getReport()
                    )
                } else {
                    if (response.data.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true, loading: false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                    }

                }

            } else {
                this.setState({ alert: true, messageAlert: "Error saving data. Please try again", tipeAlert: 'warning', loading: false, handleDoubleClick: 0 })
            }
            // this.getReport()
            // this.getOperatingID()
        })
    }

    handleSelectAll(data) {
        if (this.state.isCheckAll) {
            let checkAll = []
            this.setState({ selectReport: checkAll, isCheckAll: false })
        } else {
            let checkAll = this.state.selectReport
            data.map((item) => {
                if (item[4]) {
                    if (!this.state.selectReport.includes(item[3])) {
                        checkAll.push(item[3])
                    }
                }
            })
            console.log(checkAll);
            this.setState({ selectReport: checkAll, isCheckAll: true })
        }
    }

    handleItemChecked(item) {
        let indexID = this.state.selectReport.findIndex((val) => val === item.rowData[3])
        return indexID === -1 ? false : true
    }

    handleItemClick(item) {
        let indexID = this.state.selectReport.findIndex((val) => val === item.rowData[3])
        let selectReport = this.state.selectReport
        if (indexID === -1) {
            selectReport.push(item.rowData[3])
        } else {
            selectReport.splice(indexID, 1)
        }
        let isCheckAll = selectReport.length === this.state.dataTable.length
        this.setState({ selectReport, isCheckAll })
        console.log(selectReport);
    }

    handleDownloadReport(tableMeta) {
        let { selectReport, company, periode, month, defaultCurrency } = this.state
        let payload = {
            "company_id": company.company_id,
            "year": periode.periode,
            "report_id": selectReport,
            "month": "",
            "quartal": "",
            "type_report_name": "Operating Indicator",
            "currency_id" : defaultCurrency.id
        }
        console.log(payload);
        api.create().createDownloadFile(payload).then((response) => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        this.setState({ downloadedFileReportId: data.downloadedFileReportId, popupDownload: true }, () => this.handleGenerateReport(tableMeta))
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error'})
                alert(response.problem)
            }
        })
    }

    // componentDidUpdate = (prevProps, prevState) => {
    //     if (this.state.selectReport.length > 0 && (this.state.arrayReport.length == this.state.selectReport.length)) {
    //         setTimeout(() => {
    //             this.handleZip()
    //         }, 200);
    //     }
    // }
    handleGenerateReport = async (data) => {
        let { selectReport, operatingIndID, company, periode, downloadedFileReportId, defaultCurrency } = this.state
        if (selectReport.length > 0) {
            let result = []
            console.log('mulai hit')
            for (const items of selectReport) {
                let datas = data.findIndex((val) => val[3] == items)
                let report = data[datas]
                let quarter = String(report[1]).toLocaleLowerCase().includes('q1') ? "q1" :
                    String(report[1]).toLocaleLowerCase().includes('q2') ? "q2" :
                        String(report[1]).toLocaleLowerCase().includes('q3') ? "q3" : null

                let month = String(report[1]).toLocaleLowerCase().includes('jan') ? 1 :
                    String(report[1]).toLocaleLowerCase().includes('feb') ? 2 :
                        String(report[1]).toLocaleLowerCase().includes('mar') ? 3 :
                            String(report[1]).toLocaleLowerCase().includes('apr') ? 4 :
                                String(report[1]).toLocaleLowerCase().includes('may') ? 5 :
                                    String(report[1]).toLocaleLowerCase().includes('jun') ? 6 :
                                        String(report[1]).toLocaleLowerCase().includes('jul') ? 7 :
                                            String(report[1]).toLocaleLowerCase().includes('aug') ? 8 :
                                                String(report[1]).toLocaleLowerCase().includes('sep') ? 9 :
                                                    String(report[1]).toLocaleLowerCase().includes('oct') ? 10 :
                                                        String(report[1]).toLocaleLowerCase().includes('nov') ? 11 :
                                                            String(report[1]).toLocaleLowerCase().includes('dec') ? 12 : null

                if (String(report[1]).toLocaleLowerCase().includes('master budget')) {
                    try {
                        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/master_budget/export_master_budget?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&download_file_report_id=${downloadedFileReportId}&&currency_id=${defaultCurrency.id}`
                        let res = await fetch(
                            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/master_budget/export_master_budget?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&download_file_report_id=${downloadedFileReportId}&&currency_id=${defaultCurrency.id}`
                        )
                        if (res.status === 200) {
                            result = [...result, res];
                        }
                    } catch (e) {
                        alert(e)
                    }


                } else if (String(report[1]).toLocaleLowerCase().includes('monthly report')) {
                    try {
                        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/monthly_report/export_monthly_report?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&months=${month}&&download_file_report_id=${downloadedFileReportId}&&currency_id=${defaultCurrency.id}`
                        let res = await fetch(
                            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/monthly_report/export_monthly_report?operating_indicator_id=${operatingIndID === null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&months=${month}&&download_file_report_id=${downloadedFileReportId}&&currency_id=${defaultCurrency.id}`
                        )

                        if (res.status === 200) {
                            result = [...result, res];
                        }
                    } catch (error) {
                        alert(error)
                    }

                } else if (String(report[1]).toLocaleLowerCase().includes('rolling outlook')) {
                    try {
                        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/rolling_outlook/export_rolling_outlook?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&quartal=${quarter}&&download_file_report_id=${downloadedFileReportId}&&currency_id=${defaultCurrency.id}`
                        let res = await fetch(
                            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/rolling_outlook/export_rolling_outlook?operating_indicator_id=${operatingIndID === null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&quartal=${quarter}&&download_file_report_id=${downloadedFileReportId}&&currency_id=${defaultCurrency.id}`
                        )

                        if (res.status === 200) {
                            result = [...result, res];
                        }
                    } catch (error) {
                        alert(error)
                    }
                }
            }

            console.log('ini result', result);
            // every untuk cek ke setiap result di dalam array
            if (result.every((e) => e.status == 200)) {
                this.handleZip();
            }

            // selectReport.map(async (items) => {
            //     let datas = data.findIndex((val) => val[3] == items)
            //     let report = data[datas]
            //     let quarter = String(report[1]).toLocaleLowerCase().includes('q1') ? "q1" :
            //         String(report[1]).toLocaleLowerCase().includes('q2') ? "q2" :
            //             String(report[1]).toLocaleLowerCase().includes('q3') ? "q3" : null

            //     let month = String(report[1]).toLocaleLowerCase().includes('jan') ? 1 :
            //         String(report[1]).toLocaleLowerCase().includes('feb') ? 2 :
            //             String(report[1]).toLocaleLowerCase().includes('mar') ? 3 :
            //                 String(report[1]).toLocaleLowerCase().includes('apr') ? 4 :
            //                     String(report[1]).toLocaleLowerCase().includes('may') ? 5 :
            //                         String(report[1]).toLocaleLowerCase().includes('jun') ? 6 :
            //                             String(report[1]).toLocaleLowerCase().includes('jul') ? 7 :
            //                                 String(report[1]).toLocaleLowerCase().includes('aug') ? 8 :
            //                                     String(report[1]).toLocaleLowerCase().includes('sep') ? 9 :
            //                                         String(report[1]).toLocaleLowerCase().includes('oct') ? 10 :
            //                                             String(report[1]).toLocaleLowerCase().includes('nov') ? 11 :
            //                                                 String(report[1]).toLocaleLowerCase().includes('dec') ? 12 : null

            //     // console.log(report);

            //     if (String(report[1]).toLocaleLowerCase().includes('master budget')) {
            //         let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/master_budget/export_master_budget?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&download_file_report_id=${downloadedFileReportId}`
            //         let res = await fetch(
            //             `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/master_budget/export_master_budget?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&download_file_report_id=${downloadedFileReportId}`
            //         )
            //         // console.log(url);
            //         console.log(res);
            //         if (res.status === 200) {
            //             this.setState({ arrayReport: [...this.state.arrayReport, items] })
            //         }
            //     } else if (String(report[1]).toLocaleLowerCase().includes('monthly report')) {
            //         let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/monthly_report/export_monthly_report?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&months=${month}&&download_file_report_id=${downloadedFileReportId}`
            //         let res = await fetch(
            //             `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/monthly_report/export_monthly_report?operating_indicator_id=${operatingIndID === null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&months=${month}&&download_file_report_id=${downloadedFileReportId}`
            //         )
            //         // console.log(url);
            //         console.log(res);
            //         if (res.status === 200) {
            //             this.setState({ arrayReport: [...this.state.arrayReport, items] })
            //         }
            //     } else if (String(report[1]).toLocaleLowerCase().includes('rolling outlook')) {
            //         let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/rolling_outlook/export_rolling_outlook?operating_indicator_id=${operatingIndID == null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&quartal=${quarter}&&download_file_report_id=${downloadedFileReportId}`
            //         let res = await fetch(
            //             `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/rolling_outlook/export_rolling_outlook?operating_indicator_id=${operatingIndID === null ? "" : operatingIndID}&&report_id=${report[3]}&&company_id=${company.company_id}&&year=${periode.periode}&&quartal=${quarter}&&download_file_report_id=${downloadedFileReportId}`
            //         )
            //         // console.log(url);
            //         console.log(res);
            //         if (res.status === 200) {
            //             this.setState({ arrayReport: [...this.state.arrayReport, items] })
            //         }
            //     }

            // })
        } else {
            // alert("Anda harus memilih report yang ingin di download terlebih dahulu!")
        }
    }

    async handleZip() {
        console.log('mulai zip')
        api.create().createZipReport(this.state.downloadedFileReportId).then((response) => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ arrayReport: [] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error'})
                alert(response.problem)
            }
        })
    }

    render() {
        const columns = ["#", "Report Type",
            // {
            //     name: "Revision",
            //     options: {
            //         customBodyRender: (val, tableMeta, updateValue) => {
            //             var list = [];
            //             for (var i = 0; i <= tableMeta.rowData[6]; i++) {
            //                 list.push(i);
            //             }
            //             return (
            //                 <div style={{ display: 'flex' }}>
            //                     <FormControlLabel
            //                         style={{ margin: 0 }}
            //                         value={val}
            //                         control={
            //                             <Select
            //                                 value={val}
            //                                 onChange={event => {
            //                                     // console.log(event.target)
            //                                     updateValue(event.target.value)
            //                                     this.handleChange(event.target.value, tableMeta)
            //                                 }}
            //                                 autoWidth
            //                             >
            //                                 {list.map((item, index) =>
            //                                     <MenuItem key={index} value={item}>{item}</MenuItem>
            //                                 )}
            //                             </Select>
            //                         }
            //                     />
            //                 </div >
            //             );
            //         }
            //     }
            // }, 
            {
                name: "Status",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {val === "submitted" || val === "approved" ?
                                    <span>COMPLETED</span> :
                                    val === "draft" ?
                                        <span>DRAFT</span> :
                                        val === "revision" ?
                                            <span>REVISION</span> :
                                            val === "approval_proccess" ?
                                                <span>APPROVAL PROCCESS</span> :
                                                val === "approval_review" ?
                                                    <span>APPROVAL REVIEW</span> :
                                                    val === "not-yet" ?
                                                        <span>OPEN</span> :
                                                        val === "CLOSED" ?
                                                            <span>CLOSED</span> :
                                                            <img src={Images.cross} style={{ width: 31, height: 24 }} />
                                }
                            </div >
                        );
                    }
                }
            },
            {
                name: "Action",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                <button
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: tableMeta.rowData[4] ? 'pointer' : null,
                                        borderColor: 'transparent'
                                    }}
                                    onClick={() =>
                                        tableMeta.rowData[4] ?
                                            this.clickDetail(tableMeta.rowData, tableMeta.rowData[1], tableMeta.rowData[3], tableMeta.rowData[2])
                                            :
                                            null
                                    }
                                >
                                    <Typography style={{ color: tableMeta.rowData[4] ? '#5198ea' : 'GrayText', fontSize: 12, }}>Detail</Typography>
                                </button>
                            </div >
                        );
                    }
                }
            }, {
                name: "Download",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        // console.log(tableMeta);
                        return (
                            <div style={{ display: 'flex' }}>
                                <CustomCheckbox
                                    checked={this.handleItemChecked(tableMeta)}
                                    onChange={() => tableMeta.rowData[4] ? this.handleItemClick(tableMeta) : null}
                                    disabled={tableMeta.rowData[4] ? false : true}
                                />
                            </div >
                        );
                    }
                }
            }, {
                name: "",
                options: { display: false }
            }, {
                name: "",
                options: { display: false }
            }]
        const options = {
            filter: false,
            sort: false,
            responsive: "scroll",
            print: false,
            download: false,
            selectableRows: false,
            viewColumns: false,
            rowsPerPage: 50,
            pagination: false,
            rowsPerPageOptions: [5, 25, 100],
            search: false
        }
        const periode = [
            { value: '2021', label: '2021' },
            { value: '2020', label: '2020' },
            { value: '2019', label: '2019' },
            { value: '2018', label: '2018' },
            { value: '2017', label: '2017' },
            { value: '2016', label: '2016' },
        ]
        const perusahaan = [
            { value: 'TAP Group', label: 'TAP Group' },
            { value: '2019', label: '2019' },
            { value: '2018', label: '2018' },
            { value: '2017', label: '2017' },
            { value: '2016', label: '2016' },
        ]
        const revisi = [
            { value: '0', label: '0' },
            { value: '1', label: '1' },
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );


        return (
            <div style={{ flex: 1, backgroundColor: '#f8f8f8' }}>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {this.state.loading && loadingComponent}
                {this.state.visibleOperatingIndicator && (
                    <div>
                        <div className={"main-color"} style={{ height: 78, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                            <Typography style={{ fontSize: '16px', color: 'white' }}>Operating Indicator Submission</Typography>
                        </div>
                        <div style={{ padding: 20, width: '100%' }}>
                            <Paper style={{ paddingTop: 10 }}>
                                <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                    <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Operating Indicator</Typography>
                                </div>
                                <div style={{ padding: 20 }}>
                                    <div style={{ display: 'flex' }}>
                                        <Autocomplete
                                            {...this.state.listPeriode}
                                            id="periode"
                                            onChange={(event, newInputValue) => this.setState({ periode: newInputValue, loading: true }, () => {
                                                this.getOperatingID()
                                                // this.getReportAttachment()
                                            })}
                                            // debug
                                            clearOnEscape
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Period" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.periode}
                                        />
                                        <Autocomplete
                                            id="tipe"
                                            disableClearable
                                            options={this.state.currency}
                                            getOptionLabel={(option) => option.value}
                                            value={this.state.defaultCurrency}
                                            // onChange={(event, newInputValue) => this.setState({ defaultCurrency: newInputValue })}
                                            onChange={(event, newInputValue) => this.setState({ defaultCurrency: newInputValue, loading: true }, () => {
                                                this.getOperatingID()
                                            })}
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Currency" margin="normal" style={{ marginTop: 7, marginLeft: 20 }} />}

                                        />
                                    </div>
                                    <div style={{ marginTop: 20 }}>
                                        <Autocomplete
                                            {...this.state.listCompany}
                                            id="company"
                                            onChange={(event, newInputValue) => this.setState({ company: newInputValue, loading: true }, () => {
                                                this.getOperatingID()
                                                this.getCurrency(newInputValue.company_id)
                                                // this.getReportAttachment()
                                            })}
                                            clearOnEscape
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) =>
                                                <TextField
                                                    {...params}
                                                    label="Company"
                                                    margin="normal"
                                                    style={{ marginTop: 7 }}
                                                />}
                                            value={this.state.company}
                                        />
                                    </div>
                                    <div style={{ marginTop: 20 }}>
                                        <div style={{ display: 'flex', justifyContent: 'flex-end', margin: '20px 15px' }}>
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => this.handleSelectAll(this.state.dataTable)}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 100, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Check All</Typography>
                                                </div>
                                            </button>
                                            <button
                                                type="button"
                                                disabled={this.state.buttonError}
                                                onClick={() => this.handleDownloadReport(this.state.dataTable)}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 100, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Download</Typography>
                                                </div>
                                            </button>
                                        </div>
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={this.state.dataTable}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    </div>
                                </div>
                                {/* {this.state.isSubmit && (
                                    <div style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', display: 'flex', justifyContent: 'flex-end' }} >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Submit</Typography>
                                        </div>
                                    </div>
                                )} */}
                            </Paper>

                        </div>
                    </div>
                )}

                {this.state.visibleDetailOpt &&
                    <OperatingIndicatorDetail
                        open={this.props.open}
                        data={this.state.dataDetail}
                        height={this.props.height}
                        width={this.props.width}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        onClickClose={() => this.setState({ visibleDetailOpt: false, visibleOperatingIndicator: true }, () => {
                            this.getOperatingID()
                            this.forceUpdate()
                        })}
                        getReport={() => this.getOperatingID()}
                        saveOperatingInd={this.saveOperatingInd.bind(this)}
                        isSubmit={this.state.statusDetail == 'closed' ? false : this.state.isSubmit}
                        permission={{ create: this.state.buttonCreate, edit: this.state.buttonEdit, delete: this.state.buttonDelete }}
                    />
                }
                {this.state.visibleDetailMonthly &&
                    <OperatingIndicatorMR
                        open={this.props.open}
                        data={this.state.dataDetail}
                        height={this.props.height}
                        width={this.props.width}
                        months={this.state.months}
                        company={this.state.company}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        onClickClose={() => this.setState({ visibleDetailMonthly: false, visibleOperatingIndicator: true }, () => {
                            this.getOperatingID()
                            this.forceUpdate()
                        })}
                        getReport={() => this.getOperatingID()}
                        saveMonthlyOI={this.saveMonthlyOI.bind(this)}
                        isSubmit={this.state.statusDetail == 'closed' ? false : this.state.isSubmit}
                        permission={{ create: this.state.buttonCreate, edit: this.state.buttonEdit, delete: this.state.buttonDelete }}
                    />
                }

                {this.state.visibleDetailRolling &&
                    <OperatingIndicatorRO
                        open={this.props.open}
                        data={this.state.dataDetail}
                        height={this.props.height}
                        width={this.props.width}
                        quartal={this.state.quartal}
                        company={this.state.company}
                        defaultCurrency={this.state.defaultCurrency}
                        currency={this.state.currency}
                        onClickClose={() => this.setState({ visibleDetailRolling: false, visibleOperatingIndicator: true }, () => {
                            this.getOperatingID()
                            this.forceUpdate()
                        })}
                        getReport={() => this.getOperatingID()}
                        saveRollingOI={this.saveRollingOI.bind(this)}
                        isSubmit={this.state.statusDetail == 'closed' ? false : this.state.isSubmit}
                        permission={{ create: this.state.buttonCreate, edit: this.state.buttonEdit, delete: this.state.buttonDelete }}
                    />
                }

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => this.uploadAttachment(this.state.formData)}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data is <b>{this.props.defaultCurrency.id == 1 ? "IDR" : "USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.popupDownload && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#D9D9D9', borderRadius: 10, width: 609, height: 276 }}>
                            <div>
                                <div style={{ justifyContent: 'center', fontSize: 20, color: '#33508B', margin: '70px 20px' }}>Download Operating Indicator {this.state.company.company_name} {this.state.periode.periode} In Progress, silahkan cek status dan unduh report di menu <b>Download Report</b></div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 3
                                        }}
                                        onClick={() => this.setState({ popupDownload: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div >
        );
    }
}
