import { createMuiTheme, FormControlLabel, MuiThemeProvider, Paper, Snackbar, TableCell, Tooltip, Typography, withStyles } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import NumberFormat from 'react-number-format';
import ReactTooltip from 'react-tooltip';
import api from '../../api';
import Images from '../../assets/Images';
import * as R from 'ramda'
import { PropagateLoader } from 'react-spinners';
import Constant from '../../library/Constant';
import { Alert, Autocomplete } from '@material-ui/lab';
import { fixNumber } from '../../library/Utils';

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);
export default class CashFlow extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: false,
            minValue: "0",
            maxValue: "0",
            handleDoubleClick: 0,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false
        }
    }

    componentDidMount() {
        this.setState({ loading: true })
        console.log(this.props.PLBSFAMSubmitted)
        this.getSettingControl()
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_CONTROL',
            company_id: this.props.company.company_id,
            type: 'CASH_FLOW',
            currency_id: this.props.defaultCurrency.id,
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            this.setState({
                minValue: response.data.data[0] ? response.data.data[0].min_value : null,
                maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
            }, () => {
                this.getItemHierarki()
            })
        })
    }

    getItemHierarki() {
        this.setState({ loading: true })
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            "currency_id": this.props.defaultCurrency.id
        }
        // console.log(JSON.stringify(payload))
        // if (this.props.status === 'CLOSED') {
        //     api.create().getDetailReportCF(payload).then(response => {
        //         console.log(response);
        //         let dataTable = []
        //         // console.log(response)
        //         if (response.data) {
        //             if (response.ok) {
        //                 if (response.data.status == 'success') {
        //                     let res = response.data.data
        //                     const handlePushChild = (item) => {
        //                         dataTable.push([
        //                             item.type_report_id,
        //                             item.id,
        //                             item.parent,
        //                             item.formula,
        //                             item.level,
        //                             item.description,
        //                             item.cash_flow.total_actual_before === null ? "0" : item.cash_flow.total_actual_before === "" ? "0" : item.cash_flow.total_actual_before,
        //                             item.cash_flow.january,
        //                             item.cash_flow.february,
        //                             item.cash_flow.march,
        //                             item.cash_flow.april,
        //                             item.cash_flow.may,
        //                             item.cash_flow.june,
        //                             item.cash_flow.july,
        //                             item.cash_flow.august,
        //                             item.cash_flow.september,
        //                             item.cash_flow.october,
        //                             item.cash_flow.november,
        //                             item.cash_flow.december,
        //                             item.cash_flow.total_current_year,
        //                             item.cash_flow.total_next_year,
        //                             item.cash_flow.total_more_year,
        //                             item.order,
        //                             item.condition_it_should_be,
        //                             item.condition_if_wrong,
        //                             item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula
        //                         ])

        //                         if (item.children !== null) {
        //                             if (item.children.length > 0) {
        //                                 item.children.map((items, indexs) => {
        //                                     handlePushChild(items)
        //                                 })
        //                             }
        //                         }
        //                     }
        //                     res.map((item, index) => {
        //                         dataTable.push([
        //                             item.type_report_id,
        //                             item.id,
        //                             item.parent,
        //                             item.formula,
        //                             item.level,
        //                             item.description,
        //                             item.cash_flow.total_actual_before === null ? "0" : item.cash_flow.total_actual_before === "" ? "0" : item.cash_flow.total_actual_before,
        //                             item.cash_flow.january,
        //                             item.cash_flow.february,
        //                             item.cash_flow.march,
        //                             item.cash_flow.april,
        //                             item.cash_flow.may,
        //                             item.cash_flow.june,
        //                             item.cash_flow.july,
        //                             item.cash_flow.august,
        //                             item.cash_flow.september,
        //                             item.cash_flow.october,
        //                             item.cash_flow.november,
        //                             item.cash_flow.december,
        //                             item.cash_flow.total_current_year,
        //                             item.cash_flow.total_next_year,
        //                             item.cash_flow.total_more_year,
        //                             item.order,
        //                             item.condition_it_should_be,
        //                             item.condition_if_wrong,
        //                             item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula
        //                         ])
        //                         if (item.children !== null) {
        //                             if (item.children.length > 0) {
        //                                 item.children.map((items, indexs) => {
        //                                     handlePushChild(items)
        //                                 })
        //                             }
        //                         }
        //                     })
        //                     this.setState({ dataTable, loading: false, dataReal: res, editable: true })
        //                 } else {
        //                     this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
        //                         if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
        //                             setTimeout(() => {
        //                                 localStorage.removeItem(Constant.TOKEN)
        //                                 window.location.reload();
        //                             }, 1000);
        //                         }
        //                     })
        //                 }
        //             } else {
        //                 this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
        //             }
        //         } else {
        //             this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
        //         }
        //     })
        // } else {
        api.create().getDetailReportCF(payload).then(response => {
            let dataTable = []
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.cash_flow.total_actual_before === null ? "0" : item.cash_flow.total_actual_before === "" ? "0" : item.cash_flow.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.january, formula: item.cash_flow.january_formula } : item.cash_flow.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.february, formula: item.cash_flow.february_formula } : item.cash_flow.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.march, formula: item.cash_flow.march_formula } : item.cash_flow.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.april, formula: item.cash_flow.april_formula } : item.cash_flow.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.may, formula: item.cash_flow.may_formula } : item.cash_flow.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.june, formula: item.cash_flow.june_formula } : item.cash_flow.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.july, formula: item.cash_flow.july_formula } : item.cash_flow.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.august, formula: item.cash_flow.august_formula } : item.cash_flow.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.september, formula: item.cash_flow.september_formula } : item.cash_flow.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.october, formula: item.cash_flow.october_formula } : item.cash_flow.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.november, formula: item.cash_flow.november_formula } : item.cash_flow.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.december, formula: item.cash_flow.december_formula } : item.cash_flow.december,
                                item.cash_flow.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula
                            ])

                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.cash_flow.total_actual_before === null ? "0" : item.cash_flow.total_actual_before === "" ? "0" : item.cash_flow.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.january, formula: item.cash_flow.january_formula } : item.cash_flow.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.february, formula: item.cash_flow.february_formula } : item.cash_flow.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.march, formula: item.cash_flow.march_formula } : item.cash_flow.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.april, formula: item.cash_flow.april_formula } : item.cash_flow.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.may, formula: item.cash_flow.may_formula } : item.cash_flow.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.june, formula: item.cash_flow.june_formula } : item.cash_flow.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.july, formula: item.cash_flow.july_formula } : item.cash_flow.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.august, formula: item.cash_flow.august_formula } : item.cash_flow.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.september, formula: item.cash_flow.september_formula } : item.cash_flow.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.october, formula: item.cash_flow.october_formula } : item.cash_flow.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.november, formula: item.cash_flow.november_formula } : item.cash_flow.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.december, formula: item.cash_flow.december_formula } : item.cash_flow.december,
                                item.cash_flow.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dataTable);
                        this.setState({ dataTable, loading: false, dataReal: res, editable: true }, () => {
                            this.setState({ loading: true }, () => {
                                setTimeout(() => {
                                    this.setState({ loading: false }, () => {
                                        this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.setState({ loading: false }, () => {
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.setState({ loading: false })
                                                        }, 500);
                                                    })
                                                })
                                            }, 500);
                                        })
                                    })
                                }, 500);
                            })
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Connection Timeout, please check your Connection', tipeAlert: 'error', loading: false })
            }
        })
        // }
    }

    async downloadAllData() {
        // let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${this.props.submissionID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        // console.log(url);
        let resReal = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/master_budget/export_master_budget?submission_id=${this.props.submissionID}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&report_id=${this.props.report_id}`
        let resNull = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/master_budget/export_master_budget?submission_id=&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&report_id=${this.props.report_id}`
        let res = await fetch(
            this.props.submissionID == null ? resNull : resReal
        )
        console.log(this.props.submissionID);
        console.log(resReal)
        console.log(resNull)
        res = await res.blob()
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Master Budget Cash Flow.xlsx';
            a.click();
            this.setState({ loading: false })
        } else {
            this.setState({ loading: false })
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    olahDataCashFlow(dataTable2) {
        console.log(dataTable2)
        let listCF = []
        if (this.props.defaultCurrency.id == 2) {
            dataTable2.map((item, index) => {
                listCF.push(
                    {
                        "item_report_id": item[1],
                        "parent": item[2],
                        "formula": String(item[3]),
                        "item_name": item[5],
                        "january": String(item[7].value == undefined ? item[7] : Number(item[7].value)),
                        "february": String(item[8].value == undefined ? item[8] : Number(item[8].value)),
                        "march": String(item[9].value == undefined ? item[9] : Number(item[9].value)),
                        "april": String(item[10].value == undefined ? item[10] : Number(item[10].value)),
                        "may": String(item[11].value == undefined ? item[11] : Number(item[11].value)),
                        "june": String(item[12].value == undefined ? item[12] : Number(item[12].value)),
                        "july": String(item[13].value == undefined ? item[13] : Number(item[13].value)),
                        "august": String(item[14].value == undefined ? item[14] : Number(item[14].value)),
                        "september": String(item[15].value == undefined ? item[15] : Number(item[15].value)),
                        "october": String(item[16].value == undefined ? item[16] : Number(item[16].value)),
                        "november": String(item[17].value == undefined ? item[17] : Number(item[17].value)),
                        "december": String(item[18].value == undefined ? item[18] : Number(item[18].value)),
                        "total_current_year": String(item[19] != '' ? Number(item[19]) : item[19]),
                        "total_next_year": String(item[20] != '' ? Number(item[20]) : item[20]),
                        "total_more_year": String(item[21] != '' ? Number(item[21]) : item[21]),
                        "kpi_type": "",
                        "max_ach": "",
                        "pic": "",
                        "strategic": "",
                        "total_actual_before": "",
                        "uom": "",
                        "weight": ""
                    }
                )
            })
        } else {
            dataTable2.map((item, index) => {
                listCF.push(
                    {
                        "item_report_id": item[1],
                        "parent": item[2],
                        "formula": String(item[3]),
                        "item_name": item[5],
                        "january": String(item[7].value == undefined ? item[7] : fixNumber(Number(item[7].value), 1)),
                        "february": String(item[8].value == undefined ? item[8] : fixNumber(Number(item[8].value), 1)),
                        "march": String(item[9].value == undefined ? item[9] : fixNumber(Number(item[9].value), 1)),
                        "april": String(item[10].value == undefined ? item[10] : fixNumber(Number(item[10].value), 1)),
                        "may": String(item[11].value == undefined ? item[11] : fixNumber(Number(item[11].value), 1)),
                        "june": String(item[12].value == undefined ? item[12] : fixNumber(Number(item[12].value), 1)),
                        "july": String(item[13].value == undefined ? item[13] : fixNumber(Number(item[13].value), 1)),
                        "august": String(item[14].value == undefined ? item[14] : fixNumber(Number(item[14].value), 1)),
                        "september": String(item[15].value == undefined ? item[15] : fixNumber(Number(item[15].value), 1)),
                        "october": String(item[16].value == undefined ? item[16] : fixNumber(Number(item[16].value), 1)),
                        "november": String(item[17].value == undefined ? item[17] : fixNumber(Number(item[17].value), 1)),
                        "december": String(item[18].value == undefined ? item[18] : fixNumber(Number(item[18].value), 1)),
                        "total_current_year": String(item[19] != '' ? fixNumber(Number(item[19]), 1) : item[19]),
                        "total_next_year": String(item[20] != '' ? fixNumber(Number(item[20]), 1) : item[20]),
                        "total_more_year": String(item[21] != '' ? fixNumber(Number(item[21]), 1) : item[21]),
                        "kpi_type": "",
                        "max_ach": "",
                        "pic": "",
                        "strategic": "",
                        "total_actual_before": "",
                        "uom": "",
                        "weight": ""
                    }
                )
            })
        }

        console.log(listCF)
        this.createCashFlow(listCF)
    }

    createCashFlow(dbcf) {
        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": 6,
            "currency_id": this.props.defaultCurrency.id,
            "status": "submitted",
            "cash_flow": dbcf
        }
        console.log(dbcf)
        console.log(JSON.stringify(payload))
        this.props.createCashFlow(payload)
        // this.props.onClickClose()
    }

    render() {
        let dataTable2 = this.state.dataTable
        let loading = false
        const handleValueFormula = (value, tableMeta, column, periode, forecast) => {
            loading = true
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            // if (tableMeta.rowData[5] == "Cash at the end of the period" && column == 7) {
            //     console.log(splitFormula + " aaa");
            //     splitFormula = String("@2#BS").split(/([()@])/);
            //     console.log(splitFormula + " bbb");
            // }
            let baru = []
            let anjay = []

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            let handledoubleFC = 0
            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (String(item).includes('[M-1]')) {
                            if (forecast !== undefined) {
                                let forecastt = 0
                                if (column == 19) {
                                    let tst = String(item).replace('[M-1]', '')
                                    let data = 18
                                    let period = this.props.periode - 1
                                    let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                                    if (indexID !== -1) {
                                        let valuezz = tableMeta.rowData[data].formula[indexID].value
                                        // if (tableMeta.rowData[5] == "Cash at the beginning period") {
                                        //     // console.log(dataTable2[tableMeta.rowIndex+1])
                                        //     // console.log(dataTable2[tableMeta.rowIndex+1][data].value)
                                        //     let valuezzz = dataTable2[tableMeta.rowIndex][7].value
                                        //     forecastt += Number(valuezzz == "" ? 0 : valuezzz)
                                        // } else {
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                        // }
                                    }
                                }

                                if (column == 20) {
                                    let tst = String(item).replace('[M-1]', '')
                                    let data = 18
                                    let period = this.props.periode
                                    let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                                    if (indexID !== -1) {
                                        let valuezz = tableMeta.rowData[data].formula[indexID].value
                                        // if (tableMeta.rowData[5] == "Cash at the beginning period") {
                                        //     let valuezzz = dataTable2[tableMeta.rowIndex + 1][19]
                                        //     forecastt += Number(valuezzz == "" ? 0 : valuezzz)
                                        // } else {
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                        // }
                                    }
                                }

                                if (column == 21) {
                                    let tst = String(item).replace('[M-1]', '')
                                    let period = Number(this.props.periode) + 1
                                    let indexID = forecast.findIndex((val) => String(val.item_formula).replace('forecast_', '') == String(`@${tst}`) && val.periode == period)
                                    if (indexID !== -1) {
                                        let valuezz = forecast[indexID].value
                                        // if (tableMeta.rowData[5] == "Cash at the beginning period") {
                                        //     let valuezzz = dataTable2[tableMeta.rowIndex + 1][20]
                                        //     forecastt += Number(valuezzz == "" ? 0 : valuezzz)
                                        // } else {
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                        // }
                                    }
                                }

                                anjay.push(forecastt)
                            } else {
                                let tst = String(item).replace('[M-1]', '')
                                let data = column == 7 ? 18 : column - 1
                                let period = data == 18 ? Number(this.props.periode) - 1 : this.props.periode
                                let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                                if (indexID !== -1) {
                                    let valuezz = tableMeta.rowData[5] == "Audit and other adjustment" && column == 7 ? 0 : tableMeta.rowData[data].formula[indexID].value
                                    // if (tableMeta.rowData[5] == "Cash at the beginning period" && column != 7) {
                                    //     // console.log(data)
                                    //     // console.log(dataTable2[tableMeta.rowIndex+1][5])
                                    //     // console.log(dataTable2[tableMeta.rowIndex+1][data])
                                    //     // console.log(dataTable2[tableMeta.rowIndex-1][data].value)
                                    //     // console.log(dataTable2[tableMeta.rowIndex][data].value)
                                    //     // console.log(dataTable2[tableMeta.rowIndex+1][data].value)
                                    //     let valuezzz = dataTable2[tableMeta.rowIndex + 1][data].value
                                    //     anjay.push(valuezzz == "" ? 0 : valuezzz)
                                    // } else {
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                    // }
                                }
                            }
                        } else {
                            if (forecast !== undefined) {
                                let indexID = forecast.findIndex((val) => String(val.item_formula).replace('forecast_', '') == String(`@${item}`) && val.periode == Number(periode))
                                if (indexID !== -1) {
                                    let valuezz = forecast[indexID].value
                                    anjay.push(valuezz == "" ? 0 : Number(valuezz))
                                }
                            } else {
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = value.formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[22] == item)
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                            if (item == dataTable2[tableMeta.rowIndex][22]) {
                                anjay.push(0)
                            } else {
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                        }
                    }
                }
            })

            let anjay2 = []
            let kurung = false
            let item1 = []
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                } else if (item == ")") {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            let optPrev = ""
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    optPrev = opt
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
                // if (String(tableMeta.rowData[5]).toLocaleUpperCase() == "4.0 CASH FLOW MOVEMENT" && column == 7) {
                //     console.log(item)
                //     console.log(totalPrio)
                //     console.log(total)
                // }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            // // total = R.equals(total, NaN) ? "0.0" : total
            // // console.log(dataTable2[tableMeta.rowIndex][22])
            // // console.log(tableMeta.rowData[5])
            // if (tableMeta.rowData[5] == "1.5 Other non-current assets") {
            // if (forecast !== undefined) {
            // if (column == 19) { 
            //     console.log(splitFormula)
            //         console.log(baru)
            //         console.log(anjay)
            //         console.log(anjay2)
            //         console.log(total)
            // }
            // if (String(tableMeta.rowData[5]).toLocaleUpperCase() == "4.0 CASH FLOW MOVEMENT" && column == 7) {
            //     console.log(splitFormula)
            //     console.log(baru)
            //     console.log(anjay)
            //     console.log(anjay2)
            //     console.log(total)
            //     console.log(dataTable2[tableMeta.rowIndex])
            // }
            // }

            if (tableMeta.rowData[5] == "Cash at the end of the period" && column == 7) {
                // console.log(splitFormula)
                // console.log(baru)
                // console.log(anjay)
                // console.log(anjay2)
                // console.log(total)
                // let testttt = dataTable2[tableMeta.rowIndex - 1][8].value
                // console.log(testttt)
                // total = testttt 
            }

            if (dataTable2[tableMeta.rowIndex][column].value == undefined) {
                dataTable2[tableMeta.rowIndex][column] = total
            } else {
                dataTable2[tableMeta.rowIndex][column].value = total
            }
            loading = false
            return total
        }

        const handleForecast = (tableMeta, periode, column) => {
            let total = 0
            total = handleValueFormula(dataTable2[tableMeta.rowIndex][column], tableMeta, column, periode, dataTable2[tableMeta.rowIndex][25])
            return total
        }

        const handleFYTotal = (tableMeta) => {
            let total = 0
            // dataTable2[tableMeta.rowIndex].map((item, index) => {
            //     if (index == 18) {
            //         if (index >= 6 && index <= 17) {
            //             let valItem = item.value == undefined || item.value == "" ? 0 : item.value
            //             total += Number(valItem)
            //         }
            //     }

            // })

            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index >= 7 && index <= 18) {
                    let valItem = item.value == undefined || item.value == "" ? 0 : item.value
                    total += Number(valItem)
                }
            })

            if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "cash at the beginning period") {
                let totalBeginning = dataTable2[tableMeta.rowIndex][19] = dataTable2[tableMeta.rowIndex][7].value
                return totalBeginning
            } else if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "cash at the end of the period") {
                console.log(tableMeta.rowIndex);
                let value = Number(dataTable2[tableMeta.rowIndex - 1][19]) + Number(dataTable2[tableMeta.rowIndex - 2][19])
                return R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
            } else if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "control (should be nil)") {
                let cashOfTheEndFy = Number(dataTable2[tableMeta.rowIndex - 3][19]) + Number(dataTable2[tableMeta.rowIndex - 4][19])
                let cahsOfTheEndDec = Number(dataTable2[tableMeta.rowIndex - 2][19])
                // console.log(cashOfTheEndFy);
                // console.log(cahsOfTheEndDec);
                let value = Number(cashOfTheEndFy) - Number(cahsOfTheEndDec);
                console.log(dataTable2[tableMeta.rowIndex - 2][19]);
                return R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
            } else {
                dataTable2[tableMeta.rowIndex][19] = total
                return total
            }

            // console.log(total);
        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "(In Rupiah million)",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[26] ?
                                    tableMeta.rowData[26].length > 0 ?
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                        :
                                        tableMeta.rowData[4] == 0 ?
                                            <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                            :
                                            <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: `MB ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"1"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"2"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"3"}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"4"}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"5"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"6"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"7"}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"8"}</span>
                                    </div>

                                </div>
                                <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"9"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"10"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{"11"}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                        <span>{"12"}</span>
                                    </div>
                                </div>

                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="grid grid-4x content-center">
                                        <div className="col-1">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[7]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[7]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> 
                                                //     :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1))}
                                                                // value={fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1))}
                                                                    // value={fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1))}
                                                                                // value={fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[7], tableMeta, 7)), 1))}
                                                                                    // value={fixNumber(Number(tableMeta.rowData[7].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7].value), 1)}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-2">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[8]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[8]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[8].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[8].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[8].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[8].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[8].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[8].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[8].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[8].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[8], tableMeta, 8)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-3">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[9]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[9]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[9].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[9].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[9].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[9].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[9].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[9].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[9].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[9].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[9], tableMeta, 9)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-4">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[10]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[10]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[10].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[10].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[10].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[10].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[10].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[10].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[10].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[10].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[10], tableMeta, 10)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                    </div>
                                    <div className="grid grid-4x content-center">
                                        <div className="col-1">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[11]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[11]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[11].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[11].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[11].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[11].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[11].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[11].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[11].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[11].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[11], tableMeta, 11)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-2">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[12]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[12]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[12].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[12].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[12].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[12].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[12].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[12].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[12].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[12].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[12], tableMeta, 12)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-3">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[13]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[13]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[13].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[13].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[13].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[13].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[13], tableMeta, 13)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-4">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[14]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[14]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[14].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[14].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[14].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[14].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[14].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[14].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[14].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[14].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[14], tableMeta, 14)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                    </div>
                                    <div className="grid grid-4x content-center">
                                        <div className="col-1">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[15]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[15]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[15].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[15].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[15].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[15].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[15].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[15].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[15].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[15].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[15], tableMeta, 15)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-2">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[16]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[16]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[16]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[16]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={val}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[16]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[16].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[16].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[16].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[16].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[16].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[16].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[16].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[16].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[16], tableMeta, 16)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-3">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[17]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[17]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[17]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[17]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[17]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[17]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[17].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[17].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[17].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[17].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[17].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[17].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[17].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[17].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[17], tableMeta, 17)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                        <div className="col-4">
                                            {
                                                // this.props.status === 'CLOSED' ?
                                                //     tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                //         null :
                                                //         tableMeta.rowData[0] === 7 ?
                                                //             (Number(tableMeta.rowData[18]).toFixed(1) >= Number(this.state.minValue) && Number(tableMeta.rowData[18]).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //                 <NumberFormat
                                                //                     thousandSeparator={true}
                                                //                     style={{
                                                //                         fontSize: 12,
                                                //                         textAlign: 'right',
                                                //                         borderColor: 'transparent',
                                                //                         margin: 0,
                                                //                         width: 96,
                                                //                         backgroundColor: 'transparent',
                                                //                         color: 'black'
                                                //                     }}
                                                //                     type="text"
                                                //                     placeholder=""
                                                //                     disabled={true}
                                                //                     value={Number(tableMeta.rowData[18]).toFixed(1)}
                                                //                 /> :
                                                //                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{
                                                //                             fontSize: 12,
                                                //                             textAlign: 'right',
                                                //                             borderColor: 'transparent',
                                                //                             margin: 0,
                                                //                             width: 96,
                                                //                             backgroundColor: 'transparent',
                                                //                             color: 'red'
                                                //                         }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(tableMeta.rowData[18]).toFixed(1)}
                                                //                     />
                                                //                 </LightTooltip>
                                                //             :
                                                //             <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //                 <FormControlLabel
                                                //                     style={{ margin: 0 }}
                                                //                     value={Number(tableMeta.rowData[18]).toFixed(1)}
                                                //                     control={
                                                //                         <NumberFormat
                                                //                             thousandSeparator={true}
                                                //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //                             type="text"
                                                //                             placeholder=""
                                                //                             disabled={true}
                                                //                             value={Number(tableMeta.rowData[18]).toFixed(1)}
                                                //                         />
                                                //                     }
                                                //                 />
                                                //             </span> :
                                                tableMeta.rowData[0] === 3 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={value}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={Number(tableMeta).toFixed(1)}
                                                    //                 onBlur={(event) => {
                                                    //                     handleChange(event.target.value, tableMeta)
                                                    //                     console.log(dataTable2)
                                                    //                 }}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    // null
                                                    tableMeta.rowData[0] === 5 ?
                                                        // null
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[18].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[18].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                // null
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[18].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[18].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[0] === 1 ?
                                                                    // value === "" ?
                                                                    //     null :
                                                                    //     <NumberFormat
                                                                    //         thousandSeparator={true}
                                                                    //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    //         type="text"
                                                                    //         placeholder=""
                                                                    //         disabled={true}
                                                                    //         value={Number(value)}
                                                                    //     />
                                                                    null
                                                                    :
                                                                    tableMeta.rowData[0] === 7 ?
                                                                        (Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[18].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[18].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.PLBSFAMSubmitted ? (fixNumber(Number(tableMeta.rowData[18].value), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[18].value), 1)) : (fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(tableMeta.rowData[18], tableMeta, 18)), 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            },
            // {
            //     name: "",
            //     options: {
            //         display: false
            //     }
            // }, 
            // {
            //     name: "",
            //     options: {
            //         display: false,
            //         customHeadRender: (columnMeta) => (
            //             <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
            //                 {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
            //                     <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
            //                 </TableCell> */}
            //                 <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
            //                 <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
            //                     <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
            //                         <span>{"ForeCast"}</span>
            //                     </div>
            //                 </div>
            //             </th>
            //         ),
            //         setCellProps: () => ({ style2 }),
            //         customBodyRender: (value, tableMeta, updateValue) => {
            //             return (
            //                 <div style={{ textAlign: 'right' }}>
            //                     {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
            //                         null
            //                         :
            //                         tableMeta.rowData[0] === 7 ?
            //                             (Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)).toFixed(1) >= Number(this.state.minValue) && Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)).toFixed(1) <= Number(this.state.maxValue)) ?
            //                                 <NumberFormat
            //                                     thousandSeparator={true}
            //                                     style={{
            //                                         fontSize: 12,
            //                                         textAlign: 'right',
            //                                         borderColor: 'transparent',
            //                                         margin: 0,
            //                                         width: 96,
            //                                         backgroundColor: 'transparent',
            //                                         color: 'black'
            //                                     }}
            //                                     type="text"
            //                                     placeholder=""
            //                                     disabled={true}
            //                                     value={Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)).toFixed(1)}
            //                                 /> :
            //                                 <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
            //                                     <NumberFormat
            //                                         thousandSeparator={true}
            //                                         style={{
            //                                             fontSize: 12,
            //                                             textAlign: 'right',
            //                                             borderColor: 'transparent',
            //                                             margin: 0,
            //                                             width: 96,
            //                                             backgroundColor: 'transparent',
            //                                             color: 'red'
            //                                         }}
            //                                         type="text"
            //                                         placeholder=""
            //                                         disabled={true}
            //                                         value={Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)).toFixed(1)}
            //                                     />
            //                                 </LightTooltip>
            //                             :
            //                             <div style={{ flex: 1 }}>
            //                                 <FormControlLabel
            //                                     style={{ margin: 0 }}
            //                                     value={value}
            //                                     control={
            //                                         <NumberFormat
            //                                             thousandSeparator={true}
            //                                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
            //                                             type="text"
            //                                             placeholder=""
            //                                             disabled={true}
            //                                             value={Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)).toFixed(1)}
            //                                         />
            //                                     }
            //                                 />
            //                             </div>}
            //                 </div>
            //             )
            //         }
            //     }
            // }, 
            {
                name: `Current`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"Total"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null
                                    :
                                    // tableMeta.rowData[0] === 7 ?
                                    //     (Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)).toFixed(1) >= Number(this.state.minValue) && Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)).toFixed(1) <= Number(this.state.maxValue)) ?
                                    //         <NumberFormat
                                    //             thousandSeparator={true}
                                    //             style={{
                                    //                 fontSize: 12,
                                    //                 textAlign: 'right',
                                    //                 borderColor: 'transparent',
                                    //                 margin: 0,
                                    //                 width: 96,
                                    //                 backgroundColor: 'transparent',
                                    //                 color: 'black'
                                    //             }}
                                    //             type="text"
                                    //             placeholder=""
                                    //             disabled={true}
                                    //             value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) :  Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20))}
                                    //         /> :
                                    //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                    //             <NumberFormat
                                    //                 thousandSeparator={true}
                                    //                 style={{
                                    //                     fontSize: 12,
                                    //                     textAlign: 'right',
                                    //                     borderColor: 'transparent',
                                    //                     margin: 0,
                                    //                     width: 96,
                                    //                     backgroundColor: 'transparent',
                                    //                     color: 'red'
                                    //                 }}
                                    //                 type="text"
                                    //                 placeholder=""
                                    //                 disabled={true}
                                    //                 value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) :  Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20))}
                                    //             />
                                    //         </LightTooltip>
                                    //     :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(handleFYTotal(tableMeta)).toFixed(1)}
                                                    // value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) :  Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20))}
                                                    // value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                />
                                            }
                                        />
                                    </div>}
                            </div>
                        )
                    }
                }
            },
            {
                name: `${Number(this.props.periode) + 1}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"ForeCast"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null
                                    :
                                    tableMeta.rowData[0] === 7 ?
                                        (fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) <= Number(this.state.maxValue)) ?
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{
                                                    fontSize: 12,
                                                    textAlign: 'right',
                                                    borderColor: 'transparent',
                                                    margin: 0,
                                                    width: 96,
                                                    backgroundColor: 'transparent',
                                                    color: 'black'
                                                }}
                                                type="text"
                                                placeholder=""
                                                disabled={true}
                                                value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1)}
                                            /> :
                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{
                                                        fontSize: 12,
                                                        textAlign: 'right',
                                                        borderColor: 'transparent',
                                                        margin: 0,
                                                        width: 96,
                                                        backgroundColor: 'transparent',
                                                        color: 'red'
                                                    }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1)}
                                                />
                                            </LightTooltip>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`, 20)), 1)}
                                                    />
                                                }
                                            />
                                        </div>}
                            </div>
                        )
                    }
                }
            }, {
                name: `${Number(this.props.periode) + 2}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', fontSize: 13, top: 0, zIndex: 102, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"ForeCast"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null
                                    :
                                    tableMeta.rowData[0] === 7 ?
                                        (fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`, 21)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`, 21)), 1) <= Number(this.state.maxValue)) ?
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{
                                                    fontSize: 12,
                                                    textAlign: 'right',
                                                    borderColor: 'transparent',
                                                    margin: 0,
                                                    width: 96,
                                                    backgroundColor: 'transparent',
                                                    color: 'black'
                                                }}
                                                type="text"
                                                placeholder=""
                                                disabled={true}
                                                value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`, 21)), 1)}
                                            /> :
                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{
                                                        fontSize: 12,
                                                        textAlign: 'right',
                                                        borderColor: 'transparent',
                                                        margin: 0,
                                                        width: 96,
                                                        backgroundColor: 'transparent',
                                                        color: 'red'
                                                    }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`, 21)), 1)}
                                                />
                                            </LightTooltip>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`, 21)), 1)}
                                                    />
                                                }
                                            />
                                        </div>}
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            },
        ]

        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Pengajuan Budget Tahunan</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={3000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                        <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                            <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Budget Tahunan - Cash Flow</Typography>
                        </div>
                        <div style={{ padding: 20 }}>
                            <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                    {this.props.defaultCurrency.id === 1 ?
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                        :
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                    }
                                </div>
                                {/* <div style={{ width: '50%' }}>
                                    <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                        <a data-tip={'Download'} data-for="download">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => this.setState({ loading: true }, () => {
                                                    this.downloadAllData()
                                                    // setTimeout(() => {
                                                    //     this.setState({loading: false})
                                                    // }, 500);
                                                })}
                                            >
                                                <img src={Images.download} />
                                            </button>
                                        </a>
                                        <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                    </div>
                                </div> */}
                            </div>

                            <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                {loading || (this.state.loading && loadingComponent)}
                                {!loading && <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        data={dataTable2}
                                        columns={columns}
                                        options={options}
                                    />
                                </MuiThemeProvider>}
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                    {this.props.isApprover === true || dataTable2.length == 0 ? null :
                                        (!this.props.truelyApprover) && (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ?
                                            <button
                                                type="button"
                                                // disabled={this.state.buttonError}
                                                onClick={() =>
                                                    // this.state.buttonError ?
                                                    //     this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                    //     :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.olahDataCashFlow(dataTable2)
                                                        })}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                                </div>
                                            </button>
                                            : null}
                                </div>
                            </div>
                        </div>
                    </Paper>
                </div>
            </div>
        )
    }
}
