import React, { Component } from 'react';
import { Typography, Paper, TextField, MenuItem, Select, FormControlLabel, Snackbar, withStyles, createMuiTheme, MuiThemeProvider, Checkbox, Input } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import Images from '../../assets/Images';
import BalanceSheet from './BalanceSheet';
import api from '../../api';
import Autocomplete from '@material-ui/lab/Autocomplete';
import MuiAlert from '@material-ui/lab/Alert';
import { titleCase } from '../../library/Utils';
import ProfitLoss from './ProfitLoss';
import TaxPlanning from './TaxPlanning';
import FixedAssetsMovement from './FixedAssetsMovement';
import CorporateAnnualTarget from './CorporateAnnualTarget';
import { ExcelRenderer } from 'react-excel-renderer';
import UploadFile from "../../library/Upload";
import { format } from 'date-fns';
import Constant from '../../library/Constant';
import PropagateLoader from "react-spinners/PropagateLoader"
import CashFlow from './CashFlow';
import { DatePicker } from '@material-ui/pickers';
import moment from 'moment';
import * as R from 'ramda'
import { PhotoSizeSelectLargeTwoTone, ThreeSixty, TripOriginSharp } from '@material-ui/icons';
import { startTransition } from 'react';

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

const CustomCheckbox = withStyles({
    root: {
        color: '#5198ea',
        '&$checked': {
            color: '#5198ea',
        },
    },
    checked: {},
})((props) => <Checkbox color="default" {...props} />);

export default class BudgetTahunan extends Component {
    constructor(props) {
        super(props)
        this.state = {
            perusahaan: 'TAP Group',
            listRevision: null,
            revision: null,
            visibleBudgetTahunan: true,
            visibleBS: false,
            listPeriode: null,
            periode: null,
            listCompany: null,
            company: null,
            report_id: null,
            visiblePL: false,
            visibleFAM: false,
            visibleCAT: false,
            visibleCF: false,
            listAttachment: [],
            visibleUpload: false,
            revisionTable: null,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            submissionID: null,
            isSubmit: false,
            visibleTableHistory: false,
            isApprover: false,
            lastStatus: "",
            intent: "",
            approverID: null,
            pic: '',
            submitter: false,
            detailRevisiCheck: [],
            lastRevision: "",
            checkApprover: false,
            lastPeriod: '',
            latestPeriode: '',
            minDateRevision: new Date(),
            maxDateRevision: new Date(),
            btnApprove: false,
            isAdmin: false,
            btncreate: false,
            loadview: false,
            permissionhandle: false,
            userType: '',
            PLBSFAMSubmitted: false,
            PLID: null,
            FRID: null,
            listApprover: null,
            truelyApprover: false,
            approver: null,
            selectReport: [],
            isCheckAll: false,
            downloadedFileReportId: null,
            arrayReport: [],
            popupDownload: false,
            defaultCurrency: null,
            currency: [],
            visibleAlertSave: false,
            dataCurrency: [
                {
                    "id": 1,
                    "value": "IDR"
                },
                {
                    "id": 2,
                    "value": "USD",
                }
            ],

            dataTableCAT: [],
            dataTableRevisionCAT: [],
            dataForRevisionCAT: [],
            rowDataFinance: [],
            rowDataCAT: [],
            submitterCAT: null,
            approverIDCAT: null,
            picCAT: null,
            btnApproveCAT: false,
            lastStatusCat: null,
            rowData: [],
            dataTableHistoryCAT: [],
            visibleTableHistoryCAT: false,
            isApproverFinance: false,
            isApproverCAT: false,
            currentMasterReportTypeId: null
        }
        this.myRef = React.createRef()
        this.fileHandler = this.fileHandler.bind(this);
    }

    scrollToMyRef = () => window.scrollTo(0, this.myRef.current.offsetTop)

    componentDidMount() {
        this.setState({ loading: true }, () => {
            document.body.style.overflow = 'hidden';
        })
        this.props.selectIndex('Master Budget & CAT')

        console.log(this.props);
        if (this.props.location.state !== undefined) {
            this.setState({ userType: this.props.location.state.userType, intent: 'Home', lastPeriod: this.props.location.state.rawData.periode, rawData: this.props.location.state.rawData }, () => {
                this.getPermission()
                // this.checkApprover()
            })
        } else {
            this.getPermission()
            // this.checkApprover()
        }
    }

    getPermission() {
        let payload = {
            menu: "Master Budget & CAT"
        }
        api.create().getPermission(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        btncreate: response.data.data.create,
                        btnedit: response.data.data.edit,
                        btndelete: response.data.data.delete,
                        // load: true
                    }, () => {
                        this.checkApprover()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getRole(id) {
        api.create().getDetailRole(id).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        // this.setState({ tempData: response.data.data, privileges: response.data.data.privileges })
                        // // // console.log(response.data.data)
                        if (String(response.data.data.role_name).toLocaleLowerCase() == 'superadmin') {
                            this.setState({ isAdmin: true })
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    componentWillUnmount() {
        document.body.style.overflow = 'unset';
    }

    checkApprover() {
        api.create().checkApprover().then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    if (response.data.data.is_approver === true) {
                        this.setState({ truelyApprover: true, isApprover: true, permissionhandle: true, checkApprover: true }, () => {
                            this.getPeriode()
                        })
                    } else {
                        this.setState({ truelyApprover: false, isApprover: false, permissionhandle: false, checkApprover: false }, () =>
                            this.getDetailUser())
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getCompanySubmitted() {
        let body = {
            "periode": this.state.periode.periode
        }
        api.create().getCompanySubmitted(body).then(response => {
            // // // console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    if (response.data.data.length > 0) {
                        let data = response.data.data
                        let companyData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name,
                            }
                        })

                        if (companyData.length > 0) {
                            companyData = companyData.sort((a, b) => a.company_name.localeCompare(b.company_name))
                        }

                        let defaultProps = {
                            options: companyData,
                            getOptionLabel: (option) => titleCase(option.company_name),
                        }
                        let indexID = null
                        if (this.state.rawData !== undefined) {
                            indexID = companyData.findIndex((val) => val.company_id == this.state.rawData.company_id)
                        }

                        this.setState({ listCompany: defaultProps, company: indexID == null ? (this.state.company !== null ? this.state.company : companyData[0]) : companyData[indexID] }, () => {
                            // this.setState({ listCompany: defaultProps, company: indexID == null ? companyData[0] : companyData[indexID] }, () => {
                            if (response.data.data.length > 0) {
                                this.getRevision()
                                this.getCurrency(this.state.company.company_id)
                            } else {
                                this.setState({ listRevision: null, revision: null, dataTable: [], dataTableCAT: [], checkApprover: false, lastRevision: "", visibleTableHistory: false, visibleTableHistoryCAT: false })
                            }
                            //
                        })
                    } else {
                        this.setState({ listRevision: null, revision: null, dataTable: [], dataTableCAT: [], checkApprover: false, lastRevision: "", visibleTableHistory: false, visibleTableHistoryCAT: false, loading: false }, () => {
                            document.body.style.overflow = 'unset';
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', listCompany: null, company: null })
            }
        })
    }

    getReportAttachment() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "revision": this.state.revision.revision,
        }
        api.create().getMasterBudgetAtt(payload).then(response => {
            // // // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ listAttachment: response.data.data })
                }
            }
            // // // console.log(response);
        })
    }

    getReport() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "report_type": "Master Budget",
            "currency_id": this.state.defaultCurrency.id
        }
        api.create().getReportTypeBody(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    const listData = response?.data?.data || []
                    let dataTable = listData.map((item, index) => {
                        let indexC = String(item.current_status).toLocaleUpperCase().indexOf('C')
                        let status_approv = ''
                        if (String(item.current_status).toLocaleUpperCase().includes('CC')) {
                            status_approv = `${String(item.current_status).substr(0, indexC)}${String(item.current_status).substr(indexC + 1, String(item.current_status).length)}`
                        } else {
                            status_approv = String(item.current_status)
                        }
                        const handleOpbal = (item) => {
                            let isUpload = false
                            if (Number(this.state.periode.periode) <= 2020) {
                                isUpload = true
                            } else {
                                isUpload = item
                            }
                            return isUpload
                        }
                        // console.log(this.state.lastStatus);
                        // console.log(this.state.isSubmit);
                        // console.log(status_approv);
                        return [
                            item.number,
                            item.report_name === 'CAT' ? 'Corporate Annual Target' : item.report_name,
                            item.revision,
                            (item?.master_report_type_id === 2 ? this.state.lastStatusCat : this.state.lastStatus) === 'APPROVED' ? 'CLOSED' : this.state.isSubmit === false ? "CLOSED" : status_approv,
                            item.report_id,
                            item.report_name === "Cash Flow" ? handleOpbal(item.is_can_upload) : (Number(item.revision) > 0 ? (item.current_status == "not-yet" ? false : handleOpbal(item.is_can_upload)) : handleOpbal(item.is_can_upload)),
                            item.revision
                        ]
                    })
                    const transformRevision = (rows = []) =>
                        rows
                            .filter(item => item.report_name !== 'Cash Flow')
                            .map(item => [
                                item.report_id,
                                item.report_name === 'CAT'
                                    ? 'Corporate Annual Target'
                                    : item.report_name,
                                '',
                                item.number,
                            ])
                    const [rawCAT, resultDataTableFinance] = (dataTable ?? []).reduce(
                        (acc, item) => {
                            acc[item[1] === 'Corporate Annual Target' ? 0 : 1].push(item)
                            return acc
                        },
                        [[], []]
                    )
                    const [rowDataTableCAT, rowDataTableFinance] = (response?.data?.data ?? []).reduce(
                        (acc, item) => {
                            acc[item.report_name === 'CAT' ? 0 : 1].push(item)
                            return acc
                        },
                        [[], []]
                    )
                    const resultDataTableCAT = rawCAT.map((item, i) => [
                        i + 1,
                        ...item.slice(1),
                    ])

                    const rowDataFinance = listData.filter(
                        item => item.master_report_type_id === 1
                    );

                    const rowDataCAT = listData.filter(
                        item => item.master_report_type_id === 2
                    );
                    const dataTableRevisionCAT = transformRevision(rowDataTableCAT)
                    const dataTableRevision = transformRevision(rowDataTableFinance)
                    // console.log(dataTableRevision);
                    this.setState({
                        loading: false, dataTable: resultDataTableFinance, dataTableCAT: resultDataTableCAT,
                        rowDataFinance,
                        rowDataCAT,
                        rowData: listData,
                        dataTableRevision: dataTableRevision,
                        dataForRevision: rowDataTableFinance,
                        dataTableRevisionCAT: dataTableRevisionCAT,
                        dataForRevisionCAT: rowDataTableCAT,
                    }, () => {
                        document.body.style.overflow = 'unset';
                    })
                }
            } else {
                this.setState({ loading: false }, () => {
                    document.body.style.overflow = 'unset';
                })
            }
        })
    }

    getLatestPeriodSubmit() {
        let body = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode
        }
        api.create().getSubmitMasterBudget(body).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ isSubmit: response.data.data.is_can_submit }, () => {
                        this.getReportAttachment()
                        this.getReport()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    getCurrency(companyID) {
        // console.log(companyID);
        api.create().getDetailPerusahaan(companyID).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        let data = response.data.data
                        let datas = []
                        if (response.data.data.currency.length > 0) {
                            response.data.data.currency.map((item) => {
                                // console.log(item);
                                datas.push({
                                    id: item.currencyId,
                                    value: item.currencyName
                                })

                            })
                        }
                        let index = datas.findIndex((val) => val.id == response.data.data.default_currency)
                        this.setState({
                            defaultCurrencyID: response.data.data.default_currency,
                            currency: datas,
                            defaultCurrency: index == -1 ? null : datas[index]
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }

        })
    }

    getDetailUser() {
        let userId = localStorage.getItem(Constant.USER)
        api.create().getDetailUser(userId).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.getRole(response.data.data.role_id)
                        this.setState({ userCompany: response.data.data.company }, () => {
                            this.getCompanyActive()
                        })
                    }
                }
            }
        })
    }

    getCompanyActive() {
        api.create().getPerusahaanActive().then((response) => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    let data = response.data.data
                    let comID = this.state.rawData ? this.state.rawData.company_id : 0
                    let companyData = data.map((item) => {
                        return {
                            company_id: item.company_id,
                            company_name: item.company_name,
                        }
                    })

                    let arrayBaru = []
                    this.state.userCompany.map((item, index) => {
                        let indexID = companyData.findIndex((val) => val.company_id == item)
                        if (indexID !== -1) {
                            arrayBaru.push(companyData[indexID])
                        }
                    })

                    if (arrayBaru.length > 0) {
                        arrayBaru = arrayBaru.sort((a, b) => a.company_name.localeCompare(b.company_name))
                    }

                    let defaultProps = {
                        options: arrayBaru,
                        getOptionLabel: (option) => titleCase(option.company_name),
                    };
                    let index = arrayBaru.findIndex((val) => val.company_id == comID)
                    this.setState({ listCompany: defaultProps, company: arrayBaru.length < 1 ? companyData[0] : (index == -1 ? arrayBaru[0] : arrayBaru[index]) }, () => {
                        this.getLastPeriod()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', listCompany: null, company: null })
            }
        })
    }

    getLastPeriod() {
        this.setState({ loading: false })
        api.create().getLastPeriod(this.state.company.company_id).then(response => {
            // console.log(response);
            if (response.data.status === "success") {
                this.setState({ lastPeriod: this.state.userType !== '' ? this.state.lastPeriod : response.data.data.last_periode, latestPeriode: response.data.data.latest_periode }, () => {
                    this.getPeriode()
                })
            }
        })
    }

    getPeriode() {
        api.create().getPeriodeTransaction().then(response => {
            // console.log(response);
            // let dateNow = new Date
            // let year = this.state.rawData ? this.state.rawData.periode : format(dateNow, 'yyyy')
            let currentYear = new Date().getFullYear()
            // // // console.log(currentYear)
            if (response.data) {
                if (response.data.status === "success") {
                    let data = []
                    response.data.data.map((item) => {
                        if (this.state.isApprover) {
                            if (item >= 2000 && item <= (Number(currentYear) + 1)) {
                                data.push(item)
                            }
                        } else {
                            if ((item >= 2000) && (item == this.state.lastPeriod || item < this.state.lastPeriod)) {
                                data.push(item)
                            }
                        }
                    })
                    let periodeData = data.map((item) => {
                        return {
                            periode: item,
                        }
                    })
                    let defaultProps = {
                        options: periodeData,
                        getOptionLabel: (option) => option.periode,
                    };
                    // ubah code dibawah ini jika mau mengubah default periode jadi tahun saat ini
                    // let periode = (this.state.lastPeriod == "" ? String(Number(currentYear)) : this.state.lastPeriod)
                    let periode = String(Number(currentYear))
                    let index = data.sort((a, b) => a - b).findIndex((val) => val === periode)
                    // // console.log(this.props.location.state.rawData)
                    // console.log(this.state.lastPeriod)
                    // console.log(periode)
                    // console.log(index)
                    // console.log(periodeData)
                    // // // console.log(index)
                    console.log(this.state.isApprover);
                    this.setState({ listPeriode: defaultProps, periode: index === -1 ? periodeData[0] : periodeData[index] }, () => {
                        if (this.state.isApprover === true) {
                            this.getCompanySubmitted()
                        } else {
                            this.getRevision()
                            this.getCurrency(this.state.company.company_id)
                        }
                    })
                }
            }
        })
    }

    getRevision() {
        this.setState({ selectReport: [], isCheckAll: false }, () => {
            let payload = {
                "company_id": this.state.company.company_id,
                "periode": this.state.periode.periode
            }
            api.create().getRevision(payload).then(response => {
                // // // console.log(response);
                if (response.data) {
                    if (response.data.status === "success") {
                        let data = response.data.data
                        let revisionData = data.map((item) => {
                            return {
                                revision: item,
                            }
                        })
                        let defaultProps = {
                            options: revisionData,
                            getOptionLabel: (option) => option.revision,
                        };
                        this.setState({ listRevision: defaultProps, revision: revisionData[0] }, () => {
                            this.getSubmission()
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', listRevision: null, revision: null })
                }
            })
        })
    }

    getSubmission(type) {
        this.setState({ loading: true }, () => {
            document.body.style.overflow = 'hidden';
        })
        const _lastStatus = this.getLastStatus()
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "is_approver": this.state.isAdmin && _lastStatus == 'WAITING FOR APPROVAL' ? false : (this.state.permissionhandle ? this.state.permissionhandle : this.state.isApprover)
        }
        console.log(payload)
        api.create().getSubmission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    if (type === "CAT" || type === "DraftCAT") {
                        this.setState({ visibleCAT: false, visibleBudgetTahunan: true, loading: false })
                    } else {
                        this.setState({ visibleBudgetTahunan: true, loading: false })
                    }
                    this.setState({
                        submissionID: response.data.data.submission_id,
                        submitter: response.data.data.submitter_finance,
                        submitterCAT: response.data.data.submitter_cat,
                        approverID: response.data.data.finance_approve_id,
                        approverIDCAT: response.data.data.cat_approve_id,
                        pic: response.data.data.approver_finance == null ? '' : response.data.data.approver_finance,
                        picCAT: response.data.data.approver_cat == null ? '' : response.data.data.approver_cat,
                        lastStatus: response.data.data.last_status_finance === null ? 'SUBMIT' : response.data.data.last_status_finance,
                        lastStatusCat: response.data.data.last_status_cat === null ? 'SUBMIT' : response.data.data.last_status_cat,
                        lastRevision: response.data.data.last_revision,
                        btnApprove: response.data.data.is_submit_finance,
                        btnApproveCAT: response.data.data.is_submit_cat,
                        loading: false,
                    }, () => {
                        // // console.log(response.data.data.is_submit);
                        // // console.log(this.state.btnApprove)
                        this.historyApproval()
                        this.getLatestPeriodSubmit()
                        // this.getCashFlow(type)
                        // this.getPL(type)
                        if (this.state.isAdmin) {
                            // console.log('masuk')
                            api.create().getListApprover('master_budget', this.state.submissionID).then((response) => {
                                // console.log(response)
                                if (response.data.data) {
                                    let dataListApprover = []
                                    response.data.data.map((item, index) => {
                                        dataListApprover.push({ userId: item.user_id, fullname: item.fullname })
                                    })
                                    let defaultProps = {
                                        options: dataListApprover,
                                        getOptionLabel: (option) => option.fullname,
                                    };
                                    this.setState({ listApprover: defaultProps })
                                }
                            })
                        }
                        if (type != undefined && type == 'PL') {
                            // this.getCashFlow(type)
                            this.getPL(type)
                        } else if (type != undefined && type == 'BS') {
                            let bodyRatioBs = {
                                "report": 'ratio',
                                "submissionId": this.state.submissionID,
                                "periode": this.state.periode.periode,
                                "companyId": this.state.company.company_id,
                                "currency_id": this.state.defaultCurrency.id,
                            }
                            // console.log(bodyRatioBs);
                            api.create().triggerRatioMB(bodyRatioBs).then((res) => {
                                console.log(res)
                                this.setState({ loading: false })
                            })
                        } else {
                            this.setState({ loading: false })
                        }
                        // this.getFR(type)
                        api.create().checkApprover().then(response => {
                            // console.log(this.state.btnedit)
                            // console.log(this.state.btncreate);
                            // console.log(response);
                            if (this.state.btncreate === true && this.state.btnedit === true) {
                                this.setState({ isApprover: false }, () => {
                                    if (response.data.data.is_approver === true) {
                                        this.setState({ checkApprover: true, isApproverFinance: response.data.data.is_finance, isApproverCAT: response.data.data.is_cat, })
                                    } else {
                                        this.setState({ checkApprover: false, isApproverFinance: false, isApproverCAT: false, })
                                    }
                                })
                            } else {
                                this.setState({ isApprover: true }, () => {
                                    if (response.data.data.is_approver === true) {
                                        this.setState({ checkApprover: true, isApproverFinance: response.data.data.is_finance, isApproverCAT: response.data.data.is_cat, })
                                    } else {
                                        this.setState({ checkApprover: false, isApproverFinance: false, isApproverCAT: false, })
                                    }
                                })
                            }

                        })
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', submissionID: null, loading: false }, () => {
                        document.body.style.overflow = 'unset';
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getCashFlow(type) {
        let payload = {
            "report_id": 6,
            "revision": Number(this.state.lastRevision),
            "periode": this.state.periode.periode,
            "company_id": this.state.company.company_id,
            "currency_id": this.state.defaultCurrency.id,
            "submission_id": this.state.submissionID
        }
        api.create().getDetailReportCF(payload).then(response => {
            // console.log(response);
            let dataTable = []
            if (response.data) {
                let res = response.data.data
                const handlePushChild = (item) => {
                    let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                    if (indexIDzz === -1) {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.cash_flow.total_actual_before === null ? "0" : item.cash_flow.total_actual_before === "" ? "0" : item.cash_flow.total_actual_before,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.january, formula: item.cash_flow.january_formula } : item.cash_flow.january,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.february, formula: item.cash_flow.february_formula } : item.cash_flow.february,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.march, formula: item.cash_flow.march_formula } : item.cash_flow.march,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.april, formula: item.cash_flow.april_formula } : item.cash_flow.april,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.may, formula: item.cash_flow.may_formula } : item.cash_flow.may,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.june, formula: item.cash_flow.june_formula } : item.cash_flow.june,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.july, formula: item.cash_flow.july_formula } : item.cash_flow.july,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.august, formula: item.cash_flow.august_formula } : item.cash_flow.august,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.september, formula: item.cash_flow.september_formula } : item.cash_flow.september,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.october, formula: item.cash_flow.october_formula } : item.cash_flow.october,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.november, formula: item.cash_flow.november_formula } : item.cash_flow.november,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.december, formula: item.cash_flow.december_formula } : item.cash_flow.december,
                            item.cash_flow.total_current_year,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_next_year,
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_more_year,
                            item.order,
                            item.condition_it_should_be,
                            item.condition_if_wrong,
                            item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula
                        ])
                    }
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                }
                res.map((item, index) => {
                    dataTable.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        item.description,
                        item.cash_flow.total_actual_before === null ? "0" : item.cash_flow.total_actual_before === "" ? "0" : item.cash_flow.total_actual_before,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.january, formula: item.cash_flow.january_formula } : item.cash_flow.january,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.february, formula: item.cash_flow.february_formula } : item.cash_flow.february,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.march, formula: item.cash_flow.march_formula } : item.cash_flow.march,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.april, formula: item.cash_flow.april_formula } : item.cash_flow.april,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.may, formula: item.cash_flow.may_formula } : item.cash_flow.may,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.june, formula: item.cash_flow.june_formula } : item.cash_flow.june,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.july, formula: item.cash_flow.july_formula } : item.cash_flow.july,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.august, formula: item.cash_flow.august_formula } : item.cash_flow.august,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.september, formula: item.cash_flow.september_formula } : item.cash_flow.september,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.october, formula: item.cash_flow.october_formula } : item.cash_flow.october,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.november, formula: item.cash_flow.november_formula } : item.cash_flow.november,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.cash_flow.december, formula: item.cash_flow.december_formula } : item.cash_flow.december,
                        item.cash_flow.total_current_year,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_next_year,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.cash_flow.total_more_year,
                        item.order,
                        item.condition_it_should_be,
                        item.condition_if_wrong,
                        item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula,
                    ])
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                })
                // console.log(dataTable)
                this.setState({ dbCF: dataTable }, () => {
                    this.olahDataCashFlow(this.state.dbCF, type)
                })
            } else {
                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                        setTimeout(() => {
                            localStorage.removeItem(Constant.TOKEN)
                            window.location.reload();
                        }, 1000);
                    }
                })
            }
        })
    }

    handleValueFormula = (indexDBCF, value, tableMeta, column, periode, forecast) => {
        let splitFormula = String(tableMeta[3]).split(/([()@])/)
        let baru = []
        let anjay = []
        let dataTable2 = this.state.dbCF

        splitFormula.map((item, index) => {
            let items = String(item).substr(Number(String(item).length) - 1, 1)
            let subForm = String(item).substr(0, Number(String(item).length) - 1)
            let re = /^[a-zA-Z0-9_]+$/;
            if (item !== "" && item !== '@') {
                if (!re.test(items)) {
                    baru.push(subForm)
                    baru.push(items)
                } else {
                    baru.push(String(item))
                }
            }
        })

        baru.map((item, index) => {
            if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                anjay.push(item)
            } else {
                if (String(item).includes('#')) {
                    if (String(item).includes('[M-1]')) {
                        if (forecast !== undefined) {
                            let forecastt = 0
                            if (column == 19) {
                                let tst = String(item).replace('[M-1]', '')
                                let data = 18
                                let period = this.state.periode.periode - 1
                                let indexID = tableMeta[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                                if (indexID !== -1) {
                                    let valuezz = tableMeta[data].formula[indexID].value
                                    if (tableMeta[5] == "Cash at the beginning period") {
                                        // console.log(dataTable2[tableMeta.rowIndex+1])
                                        // console.log(dataTable2[tableMeta.rowIndex+1][data].value)
                                        let valuezzz = dataTable2[indexDBCF + 1][data].value
                                        forecastt += Number(valuezzz == "" ? 0 : valuezzz)
                                    } else {
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                    }
                                }
                            }

                            if (column == 20) {
                                let tst = String(item).replace('[M-1]', '')
                                let data = 18
                                let period = this.state.periode.periode
                                let indexID = tableMeta[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                                if (indexID !== -1) {
                                    let valuezz = tableMeta[data].formula[indexID].value
                                    if (tableMeta[5] == "Cash at the beginning period") {
                                        let valuezzz = dataTable2[indexDBCF + 1][19]
                                        forecastt += Number(valuezzz == "" ? 0 : valuezzz)
                                    } else {
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                    }
                                }
                            }

                            if (column == 21) {
                                let tst = String(item).replace('[M-1]', '')
                                let period = Number(this.state.periode.periode) + 1
                                let indexID = forecast.findIndex((val) => String(val.item_formula).replace('forecast_', '') == String(`@${tst}`) && val.periode == period)
                                if (indexID !== -1) {
                                    let valuezz = forecast[indexID].value
                                    if (tableMeta[5] == "Cash at the beginning period") {
                                        let valuezzz = dataTable2[indexDBCF + 1][20]
                                        forecastt += Number(valuezzz == "" ? 0 : valuezzz)
                                    } else {
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                    }
                                }
                            }

                            anjay.push(forecastt)
                        } else {
                            let tst = String(item).replace('[M-1]', '')
                            let data = column == 7 ? 18 : column - 1
                            let period = data == 18 ? Number(this.state.periode.periode) - 1 : this.state.periode.periode
                            let indexID = tableMeta[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                            if (indexID !== -1) {
                                let valuezz = tableMeta[data].formula[indexID].value
                                if (tableMeta[5] == "Cash at the beginning period" && column != 7) {
                                    let valuezzz = dataTable2[indexDBCF + 1][data].value
                                    anjay.push(valuezzz == "" ? 0 : valuezzz)
                                } else {
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        }
                    } else {
                        if (forecast !== undefined) {
                            let indexID = forecast.findIndex((val) => String(val.item_formula).replace('forecast_', '') == String(`@${item}`) && val.periode == Number(periode))
                            if (indexID !== -1) {
                                let valuezz = forecast[indexID].value
                                anjay.push(valuezz == "" ? 0 : Number(valuezz))
                            }
                        } else {
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.state.periode.periode))
                            if (indexID !== -1) {
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    }
                } else {
                    let indexID = dataTable2.findIndex((val) => val[22] == item)
                    if (indexID !== -1) {
                        let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                        if (item == dataTable2[indexDBCF][22]) {
                            anjay.push(0)
                        } else {
                            anjay.push(valuezz == "" ? 0 : valuezz)
                        }
                    } else {
                        if (item === '(-1)') {
                            anjay.push(-1)
                        }
                    }
                }
            }
        })

        let anjay2 = []
        let kurung = false
        let item1 = []
        anjay.map((item, index) => {
            if (item == "(") {
                kurung = true
            } else if (item == ")") {
                kurung = false
                anjay2.push(item1)
                item1 = []
            } else {
                if (kurung) {
                    item1.push(item)
                } else {
                    anjay2.push(item)
                }
            }
        })

        let total = 0
        let opt = ""
        let totalPrio = 0
        let optPrio = ""
        let prio = false
        let optPrev = ""
        anjay2.map((item, index) => {
            if (Array.isArray(item)) {
                prio = true
                optPrev = opt
                item.map((items, indexs) => {
                    if (items == "+") {
                        optPrio = "tambah"
                    } else if (items == "-") {
                        optPrio = "kurang"
                    } else if (items == "*") {
                        optPrio = "kali"
                    } else if (items == "/") {
                        optPrio = "bagi"
                    } else {
                        if (optPrio == "tambah") {
                            totalPrio = Number(totalPrio) + Number(items)
                        } else if (optPrio == "kurang") {
                            totalPrio = Number(totalPrio) - Number(items)
                        } else if (optPrio == "kali") {
                            totalPrio = Number(totalPrio) * Number(items)
                        } else if (optPrio == "bagi") {
                            totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                        } else {
                            totalPrio += Number(items)
                        }
                    }
                })

                if (index == anjay2.length - 1) {
                    if (opt == "tambah") {
                        total = Number(total) + Number(totalPrio)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(totalPrio)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(totalPrio)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                    } else {
                        total += Number(totalPrio)
                    }
                }
            } else {
                if (item == "+") {
                    opt = "tambah"
                    if (prio) {
                        if (optPrev == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (optPrev == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (optPrev == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (optPrev == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "-") {
                    opt = "kurang"
                    if (prio) {
                        if (optPrev == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (optPrev == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (optPrev == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (optPrev == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "*") {
                    opt = "kali"
                    if (prio) {
                        if (optPrev == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (optPrev == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (optPrev == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (optPrev == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "/") {
                    opt = "bagi"
                    if (prio) {
                        if (optPrev == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (optPrev == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (optPrev == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (optPrev == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            }
        })

        // if(tableMeta[5] == '2.1 Additional fixed assets and CIP' && column == 7) {
        //     console.log(splitFormula)
        //     console.log(baru)
        //     console.log(anjay)
        //     console.log(anjay2)
        //     console.log(total)
        // }

        total = R.equals(total, NaN) ? "0.0" : Number(total).toFixed(1)
        return total
    }

    handleForecast = (index, tableMeta, periode, column) => {
        let total = 0
        let dataTable2 = this.state.dbCF
        // let indexID = dataTable2.findIndex((val) => tableMeta[1] == val[1])
        // if (indexID != -1) {
        total = this.handleValueFormula(index, dataTable2[index][column], tableMeta, column, periode, dataTable2[index][25])
        // }
        return total
    }

    olahDataCashFlow(dbCF, type) {
        dbCF.map((item, index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                item[7].value = this.handleValueFormula(index, item[7], item, 7)
                item[8].value = this.handleValueFormula(index, item[8], item, 8)
                item[9].value = this.handleValueFormula(index, item[9], item, 9)
                item[10].value = this.handleValueFormula(index, item[10], item, 10)
                item[11].value = this.handleValueFormula(index, item[11], item, 11)
                item[12].value = this.handleValueFormula(index, item[12], item, 12)
                item[13].value = this.handleValueFormula(index, item[13], item, 13)
                item[14].value = this.handleValueFormula(index, item[14], item, 14)
                item[15].value = this.handleValueFormula(index, item[15], item, 15)
                item[16].value = this.handleValueFormula(index, item[16], item, 16)
                item[17].value = this.handleValueFormula(index, item[17], item, 17)
                item[18].value = this.handleValueFormula(index, item[18], item, 18)
                item[19] = this.handleForecast(index, item, `${Number(this.state.periode.periode)}`, 19)
                item[20] = this.handleForecast(index, item, `${Number(this.state.periode.periode) + 1}`, 20)
                item[21] = this.handleForecast(index, item, `${Number(this.state.periode.periode) + 2}`, 21)
            }
        })
        // console.log(dbCF)
        this.setState({ dbCF }, () => {
            this.payloadCF(type)
        })
    }

    payloadCF(type) {
        let listCF = []
        this.state.dbCF.map((item, index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                item[7].value = this.handleValueFormula(index, item[7], item, 7)
                item[8].value = this.handleValueFormula(index, item[8], item, 8)
                item[9].value = this.handleValueFormula(index, item[9], item, 9)
                item[10].value = this.handleValueFormula(index, item[10], item, 10)
                item[11].value = this.handleValueFormula(index, item[11], item, 11)
                item[12].value = this.handleValueFormula(index, item[12], item, 12)
                item[13].value = this.handleValueFormula(index, item[13], item, 13)
                item[14].value = this.handleValueFormula(index, item[14], item, 14)
                item[15].value = this.handleValueFormula(index, item[15], item, 15)
                item[16].value = this.handleValueFormula(index, item[16], item, 16)
                item[17].value = this.handleValueFormula(index, item[17], item, 17)
                item[18].value = this.handleValueFormula(index, item[18], item, 18)
                item[19] = this.handleForecast(index, item, `${Number(this.state.periode.periode)}`, 19)
                item[20] = this.handleForecast(index, item, `${Number(this.state.periode.periode) + 1}`, 20)
                item[21] = this.handleForecast(index, item, `${Number(this.state.periode.periode) + 2}`, 21)
            }
            listCF.push(item)
        })

        this.setState({ dbCF: listCF }, () => {
            this.olahDataCashFlowOneMore(listCF, type)
        })
    }

    olahDataCashFlowOneMore(list, type) {
        // console.log(list)
        let listCF = []
        list.map((item, index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                // if (item[7].value == "" || item[7].value == 0 || item[7].value == "0.0") {
                item[7].value = this.handleValueFormula(index, item[7], item, 7)
                // }  

                // if (item[8].value == "" || item[8].value == 0 || item[8].value == "0.0") {
                item[8].value = this.handleValueFormula(index, item[8], item, 8)
                // } 

                // if (item[9].value == "" || item[9].value == 0 || item[9].value == "0.0") {
                item[9].value = this.handleValueFormula(index, item[9], item, 9)
                // } 

                // if (item[10].value == "" || item[10].value == 0 || item[10].value == "0.0") {
                item[10].value = this.handleValueFormula(index, item[10], item, 10)
                // } 

                // if (item[11].value == "" || item[11].value == 0 || item[11].value == "0.0") {
                item[11].value = this.handleValueFormula(index, item[11], item, 11)
                // } 

                // if (item[12].value == "" || item[12].value == 0 || item[12].value == "0.0") {
                item[12].value = this.handleValueFormula(index, item[12], item, 12)
                // } 

                // if (item[13].value == "" || item[13].value == 0 || item[13].value == "0.0") {
                item[13].value = this.handleValueFormula(index, item[13], item, 13)
                // }

                // if (item[14].value == "" || item[14].value == 0 || item[14].value == "0.0") {
                item[14].value = this.handleValueFormula(index, item[14], item, 14)
                // } 

                // if (item[15].value == "" || item[15].value == 0 || item[15].value == "0.0") {
                item[15].value = this.handleValueFormula(index, item[15], item, 15)
                // } 

                // if (item[16].value == "" || item[16].value == 0 || item[16].value == "0.0") {
                item[16].value = this.handleValueFormula(index, item[16], item, 16)
                // } 

                // if (item[17].value == "" || item[17].value == 0 || item[17].value == "0.0") {
                item[17].value = this.handleValueFormula(index, item[17], item, 17)
                // } 

                // if (item[18].value == "" || item[18].value == 0 || item[18].value == "0.0") {
                item[18].value = this.handleValueFormula(index, item[18], item, 18)
                // } 

                item[19] = this.handleForecast(index, item, `${Number(this.state.periode.periode)}`, 19)

                // if (item[20] == "" || item[20] == 0 || item[20] == "0.0") {
                item[20] = this.handleForecast(index, item, `${Number(this.state.periode.periode) + 1}`, 20)
                // } 

                // if (item[21] == "" || item[21] == 0 || item[21] == "0.0") {
                item[21] = this.handleForecast(index, item, `${Number(this.state.periode.periode) + 2}`, 21)
                // } 
            }


            listCF.push(
                {
                    "item_report_id": item[1],
                    "parent": item[2],
                    "formula": String(item[3]),
                    "item_name": item[5],
                    "january": String(item[7].value == undefined ? item[7] : Number(item[7].value).toFixed(1)),
                    "february": String(item[8].value == undefined ? item[8] : Number(item[8].value).toFixed(1)),
                    "march": String(item[9].value == undefined ? item[9] : Number(item[9].value).toFixed(1)),
                    "april": String(item[10].value == undefined ? item[10] : Number(item[10].value).toFixed(1)),
                    "may": String(item[11].value == undefined ? item[11] : Number(item[11].value).toFixed(1)),
                    "june": String(item[12].value == undefined ? item[12] : Number(item[12].value).toFixed(1)),
                    "july": String(item[13].value == undefined ? item[13] : Number(item[13].value).toFixed(1)),
                    "august": String(item[14].value == undefined ? item[14] : Number(item[14].value).toFixed(1)),
                    "september": String(item[15].value == undefined ? item[15] : Number(item[15].value).toFixed(1)),
                    "october": String(item[16].value == undefined ? item[16] : Number(item[16].value).toFixed(1)),
                    "november": String(item[17].value == undefined ? item[17] : Number(item[17].value).toFixed(1)),
                    "december": String(item[18].value == undefined ? item[18] : Number(item[18].value).toFixed(1)),
                    "total_current_year": String(item[19] != '' ? Number(item[19]).toFixed(1) : item[19]),
                    "total_next_year": String(item[20] != '' ? Number(item[20]).toFixed(1) : item[20]),
                    "total_more_year": String(item[21] != '' ? Number(item[21]).toFixed(1) : item[21]),
                    "kpi_type": "",
                    "max_ach": "",
                    "pic": "",
                    "strategic": "",
                    "total_actual_before": "",
                    "uom": "",
                    "weight": ""
                }
            )

        })

        // console.log(listCF)
        this.setState({ dbCF: listCF }, () => {
            // if (this.state.submissionID != null) {
            //     this.createCashFlow()
            // }
            // if (type != undefined) {
            //     if (type == 'BS' || type == 'FAM' || type == 'PL') {
            // console.log('tarik sis')
            // this.createCashFlow()
            //     }
            // }
        })
    }

    createCashFlow(payload) {
        api.create().createReportCF(payload).then((res) => {
            console.log(res)
            // this.getSubmission()
            if (res.data) {
                if (res.data.status === "success") {
                    this.setState({ visibleCF: false, visibleBudgetTahunan: true })
                    this.getSubmission()
                } else {
                    if (res.data.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true })
                    } else {
                        this.setState({ alert: true, messageAlert: res.data.message, tipeAlert: 'warning', loading: false })
                    }
                }
            }
            // if (response.data) {
            //     if (response.data.status === "success") {
            //         this.props.saveToMonthlyReport()
            //     } else {
            //         this.setState({ loading: false }, () => {
            //             this.props.saveToMonthlyReport()
            //         })
            //     }
            // } else {
            //     this.setState({ loading: false }, () => {
            //         // this.getSubmission()
            //         document.body.style.overflow = 'unset';
            //     })
            // }
        })
    }

    getPL(type) {
        let PLID = null
        let payloadID = {
            "periode": this.state.periode.periode,
            "company_id": this.state.company.company_id
        }
        console.log(payloadID);
        api.create().getPLID(payloadID).then(response => {
            // console.log(response);
            if (response) {
                PLID = response.data.data == null ? null : response.data.data.profit_loss_id
            } else {
                PLID = null
            }
            this.setState({ PLID }, () => {
                let payload = {
                    "report_id": 28,
                    "revision": Number(this.state.lastRevision),
                    "periode": this.state.periode.periode,
                    "company_id": this.state.company.company_id,
                    "submission_id": this.state.PLID,
                    "currency_id": this.state.defaultCurrency.id,
                    "months": 0,
                    "quarter": 0,
                }
                api.create().getHierarkiCreateReportPLMB(payload).then(response => {
                    // console.log(response);
                    let dataTable = []
                    if (response.data) {
                        // let dataTable = []
                        // console.log(response)
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_detail.total_actual_before === null ? "0" : item.profit_detail.total_actual_before === "" ? "0" : item.profit_detail.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.january, formula: item.profit_detail.january_formula } : item.profit_detail.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.february, formula: item.profit_detail.february_formula } : item.profit_detail.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.march, formula: item.profit_detail.march_formula } : item.profit_detail.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.april, formula: item.profit_detail.april_formula } : item.profit_detail.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.may, formula: item.profit_detail.may_formula } : item.profit_detail.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.june, formula: item.profit_detail.june_formula } : item.profit_detail.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.july, formula: item.profit_detail.july_formula } : item.profit_detail.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.august, formula: item.profit_detail.august_formula } : item.profit_detail.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.september, formula: item.profit_detail.september_formula } : item.profit_detail.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.october, formula: item.profit_detail.october_formula } : item.profit_detail.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.november, formula: item.profit_detail.november_formula } : item.profit_detail.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.december, formula: item.profit_detail.december_formula } : item.profit_detail.december,
                                item.profit_detail.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.profit_detail.forecast_formula == null ? [] : item.profit_detail.forecast_formula,
                                item.profit_detail.notes
                            ])

                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_detail.total_actual_before === null ? "0" : item.profit_detail.total_actual_before === "" ? "0" : item.profit_detail.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.january, formula: item.profit_detail.january_formula } : item.profit_detail.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.february, formula: item.profit_detail.february_formula } : item.profit_detail.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.march, formula: item.profit_detail.march_formula } : item.profit_detail.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.april, formula: item.profit_detail.april_formula } : item.profit_detail.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.may, formula: item.profit_detail.may_formula } : item.profit_detail.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.june, formula: item.profit_detail.june_formula } : item.profit_detail.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.july, formula: item.profit_detail.july_formula } : item.profit_detail.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.august, formula: item.profit_detail.august_formula } : item.profit_detail.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.september, formula: item.profit_detail.september_formula } : item.profit_detail.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.october, formula: item.profit_detail.october_formula } : item.profit_detail.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.november, formula: item.profit_detail.november_formula } : item.profit_detail.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.december, formula: item.profit_detail.december_formula } : item.profit_detail.december,
                                item.profit_detail.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.profit_detail.forecast_formula == null ? [] : item.profit_detail.forecast_formula,
                                item.profit_detail.notes
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        // console.log(dataTable)
                        this.setState({ dbPL: dataTable }, () => {
                            this.olahDataPL(this.state.dbPL, type)
                        })
                    } else {
                        this.setState({ dbPL: [], previewTable: false, previewDownload: false })
                    }


                })
            })
        })


    }

    handleValueFormulaDBPL = (indexDBCF, value, tableMeta, column, periode, forecast) => {
        let splitFormula = String(tableMeta[3]).split(/([()@])/)
        // let splitFormula = String(tableMeta.rowData[3]).split('@')
        let baru = []
        let anjay = []
        let dataTable2 = this.state.dbPL

        // if (forecast !== undefined) {
        //     console.log(tableMeta)
        // }

        splitFormula.map((item, index) => {
            let items = String(item).substr(Number(String(item).length) - 1, 1)
            let subForm = String(item).substr(0, Number(String(item).length) - 1)
            let re = /^[a-zA-Z0-9_]+$/;
            let asd = ''
            if (item !== "") {
                if (!re.test(items)) {
                    baru.push(subForm)
                    baru.push(items)
                } else {
                    baru.push(String(item))
                }
            }
        })

        baru.map((item, index) => {
            if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                anjay.push(item)
            } else {
                if (String(item).includes('#')) {
                    if (forecast !== undefined) {
                        let forecastt = 0
                        forecast.map((items, index) => {
                            if (items.periode == periode) {
                                forecastt += Number(items.value)
                            }
                        })
                        anjay.push(forecastt)
                    } else {
                        if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let data = column == 7 ? 18 : column - 1
                            let period = data == 18 ? Number(this.state.periode.periode) - 1 : this.state.periode.periode
                            let indexID = tableMeta[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                            if (indexID !== -1) {
                                let valuezz = tableMeta[data].formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            // console.log(item)
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.state.periode.periode))
                            if (indexID !== -1) {
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    }

                } else {
                    let indexID = dataTable2.findIndex((val) => val[22] == item)
                    if (indexID !== -1) {
                        // if (forecast !== undefined) {
                        //     console.log(dataTable2[indexID])
                        //     console.log(column)
                        //     console.log(dataTable2[indexID][column])

                        // }
                        if (forecast != undefined) {
                            // console.log(dataTable2[indexID][column])
                        }
                        let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                        anjay.push(valuezz == "" ? 0 : valuezz)
                    } else {
                        if (item === '(-1)') {
                            anjay.push(-1)
                        }
                    }
                }
            }
        })

        let anjay2 = []
        let kurung = false
        let item1 = []
        anjay.map((item, index) => {
            if (item == "(") {
                kurung = true
            } else if (item == ")") {
                kurung = false
                anjay2.push(item1)
                item1 = []
            } else {
                if (kurung) {
                    item1.push(item)
                } else {
                    anjay2.push(item)
                }
            }
        })

        let total = 0
        let opt = ""
        let totalPrio = 0
        let optPrio = ""
        let prio = false
        anjay2.map((item, index) => {
            if (Array.isArray(item)) {
                prio = true
                item.map((items, indexs) => {
                    if (items == "+") {
                        optPrio = "tambah"
                    } else if (items == "-") {
                        optPrio = "kurang"
                    } else if (items == "*") {
                        optPrio = "kali"
                    } else if (items == "/") {
                        optPrio = "bagi"
                    } else {
                        if (optPrio == "tambah") {
                            totalPrio = Number(totalPrio) + Number(items)
                        } else if (optPrio == "kurang") {
                            totalPrio = Number(totalPrio) - Number(items)
                        } else if (optPrio == "kali") {
                            totalPrio = Number(totalPrio) * Number(items)
                        } else if (optPrio == "bagi") {
                            totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                        } else {
                            totalPrio += Number(items)
                        }
                    }
                })

                if (index == anjay2.length - 1) {
                    if (opt == "tambah") {
                        total = Number(total) + Number(totalPrio)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(totalPrio)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(totalPrio)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                    } else {
                        total += Number(totalPrio)
                    }
                }
            } else {
                // console.log(item.length)
                if (item == "+") {
                    opt = "tambah"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "-") {
                    opt = "kurang"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "*") {
                    opt = "kali"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "/") {
                    opt = "bagi"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            }
        })

        // if (String(tableMeta[5]) == "Cost of Goods Sold (COGS)" && column == 20) {
        //     console.log(splitFormula)
        //     console.log(baru)
        //     console.log(anjay)
        //     console.log(anjay2)
        //     console.log(total)
        // }
        total = R.equals(total, NaN) ? "0.0" : total
        return total
    }

    handleForecastDBPL = (index, tableMeta, periode, column) => {
        let total = 0
        let dataTable2 = this.state.dbPL

        if (tableMeta[3].includes('#PL')) {
            dataTable2[index][25].map((item, index) => {
                if (item.periode == periode) {
                    total += Number(item.value)
                }
            })
        } else {
            total = this.handleValueFormulaDBPL(dataTable2[index][column], tableMeta[column], tableMeta, column, periode, dataTable2[index][25])
        }

        return total
    }

    olahDataPL(dbPL, type) {
        dbPL.map((item, index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                item[7].value = this.handleValueFormulaDBPL(index, item[7], item, 7)
                item[8].value = this.handleValueFormulaDBPL(index, item[8], item, 8)
                item[9].value = this.handleValueFormulaDBPL(index, item[9], item, 9)
                item[10].value = this.handleValueFormulaDBPL(index, item[10], item, 10)
                item[11].value = this.handleValueFormulaDBPL(index, item[11], item, 11)
                item[12].value = this.handleValueFormulaDBPL(index, item[12], item, 12)
                item[13].value = this.handleValueFormulaDBPL(index, item[13], item, 13)
                item[14].value = this.handleValueFormulaDBPL(index, item[14], item, 14)
                item[15].value = this.handleValueFormulaDBPL(index, item[15], item, 15)
                item[16].value = this.handleValueFormulaDBPL(index, item[16], item, 16)
                item[17].value = this.handleValueFormulaDBPL(index, item[17], item, 17)
                item[18].value = this.handleValueFormulaDBPL(index, item[18], item, 18)
                item[20] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 1}`, 20)
                item[21] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 2}`, 21)
            }
        })
        this.setState({ dbPL }, () => {
            this.payloadPL(type)
        })
    }

    payloadPL(type) {
        let listPL = []
        // console.log(this.state.dbPL)
        this.state.dbPL.map((item, index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                // if (item[7].value == "" || item[7].value == 0 || item[7].value == "0.0") {
                item[7].value = this.handleValueFormulaDBPL(index, item[7], item, 7)
                // }  

                // if (item[8].value == "" || item[8].value == 0 || item[8].value == "0.0") {
                item[8].value = this.handleValueFormulaDBPL(index, item[8], item, 8)
                // } 

                // if (item[9].value == "" || item[9].value == 0 || item[9].value == "0.0") {
                item[9].value = this.handleValueFormulaDBPL(index, item[9], item, 9)
                // } 

                // if (item[10].value == "" || item[10].value == 0 || item[10].value == "0.0") {
                item[10].value = this.handleValueFormulaDBPL(index, item[10], item, 10)
                // } 

                // if (item[11].value == "" || item[11].value == 0 || item[11].value == "0.0") {
                item[11].value = this.handleValueFormulaDBPL(index, item[11], item, 11)
                // } 

                // if (item[12].value == "" || item[12].value == 0 || item[12].value == "0.0") {
                item[12].value = this.handleValueFormulaDBPL(index, item[12], item, 12)
                // } 

                // if (item[13].value == "" || item[13].value == 0 || item[13].value == "0.0") {
                item[13].value = this.handleValueFormulaDBPL(index, item[13], item, 13)
                // }

                // if (item[14].value == "" || item[14].value == 0 || item[14].value == "0.0") {
                item[14].value = this.handleValueFormulaDBPL(index, item[14], item, 14)
                // } 

                // if (item[15].value == "" || item[15].value == 0 || item[15].value == "0.0") {
                item[15].value = this.handleValueFormulaDBPL(index, item[15], item, 15)
                // } 

                // if (item[16].value == "" || item[16].value == 0 || item[16].value == "0.0") {
                item[16].value = this.handleValueFormulaDBPL(index, item[16], item, 16)
                // } 

                // if (item[17].value == "" || item[17].value == 0 || item[17].value == "0.0") {
                item[17].value = this.handleValueFormulaDBPL(index, item[17], item, 17)
                // } 

                // if (item[18].value == "" || item[18].value == 0 || item[18].value == "0.0") {
                item[18].value = this.handleValueFormulaDBPL(index, item[18], item, 18)
                // } 

                // if (item[20] == "" || item[20] == 0 || item[20] == "0.0") {
                item[20] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 1}`, 20)
                // } 

                // if (item[21] == "" || item[21] == 0 || item[21] == "0.0") {
                item[21] = this.handleForecastDBPL(index, item, `${Number(this.state.periode.periode) + 2}`, 21)
                // } 
            }


            listPL.push(
                {
                    "item_report_id": item[1],
                    "january": String(item[7].value == undefined ? item[7] : Number(item[7].value).toFixed(1)),
                    "february": String(item[8].value == undefined ? item[8] : Number(item[8].value).toFixed(1)),
                    "march": String(item[9].value == undefined ? item[9] : Number(item[9].value).toFixed(1)),
                    "april": String(item[10].value == undefined ? item[10] : Number(item[10].value).toFixed(1)),
                    "may": String(item[11].value == undefined ? item[11] : Number(item[11].value).toFixed(1)),
                    "june": String(item[12].value == undefined ? item[12] : Number(item[12].value).toFixed(1)),
                    "july": String(item[13].value == undefined ? item[13] : Number(item[13].value).toFixed(1)),
                    "august": String(item[14].value == undefined ? item[14] : Number(item[14].value).toFixed(1)),
                    "september": String(item[15].value == undefined ? item[15] : Number(item[15].value).toFixed(1)),
                    "october": String(item[16].value == undefined ? item[16] : Number(item[16].value).toFixed(1)),
                    "november": String(item[17].value == undefined ? item[17] : Number(item[17].value).toFixed(1)),
                    "december": String(item[18].value == undefined ? item[18] : Number(item[18].value).toFixed(1)),
                    "total_current_year": String(item[19]),
                    "total_next_year": String(item[20] != '' ? Number(item[20]).toFixed(1) : item[20]),
                    "total_more_year": String(item[21] != '' ? Number(item[21]).toFixed(1) : item[21]),
                    "notes": String(item[26]),
                }
            )

        })

        // console.log(listPL)
        this.setState({ dbPL: listPL }, () => {
            // if (this.state.submissionID != null) {
            //     this.createDBPL()
            // }
            if (type != undefined) {
                if (type == 'PL') {
                    // console.log('tarik sis')
                    this.createDBPL()
                }
            }
        })
    }

    createDBPL() {
        let payload = {
            // "submission_id": this.state.submissionID,
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "report_id": 28,
            "status": "submitted",
            "profit_loss_id": this.state.PLID,
            "currency_id": this.state.defaultCurrency.id,
            "profit_loss_mb": this.state.dbPL,
            "months": 0,
        }
        // console.log(this.state.dbCF)
        // console.log(JSON.stringify(payload))
        api.create().createReportPLMB(payload).then((res) => {
            // console.log(res)
            this.setState({ loading: false })
            // if (response.data) {
            //     if (response.data.status === "success") {
            //         this.props.saveToMonthlyReport()
            //     } else {
            //         this.setState({ loading: false }, () => {
            //             this.props.saveToMonthlyReport()
            //         })
            //     }
            // } else {
            //     this.setState({ loading: false }, () => {
            //         // this.getSubmission()
            //         document.body.style.overflow = 'unset';
            //     })
            // }
        })
    }

    getFR(type) {
        // console.log("get FR");
        let FRID = null
        let payloadID = {
            "periode": this.state.periode.periode,
            "company_id": this.state.company.company_id
        }
        // console.log(payloadID);
        api.create().getFRID(payloadID).then(response => {
            // console.log(response);
            if (response) {
                FRID = response.data.data == null ? null : response.data.data.ratio_id
            } else {
                FRID = null
            }
            this.setState({ FRID }, () => {
                let payload = {
                    "report_id": 29,
                    "revision": Number(this.state.lastRevision),
                    "periode": this.state.periode.periode,
                    "company_id": this.state.company.company_id,
                    "currency_id": this.state.defaultCurrency.id,
                    "submission_id": this.state.submissionID,
                }
                api.create().getHierarkiCreateReportFRMB(payload).then(response => {
                    // console.log(response);
                    let dataTable = []
                    if (response.data) {
                        // let dataTable = []
                        // console.log(response)
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            if (item.description == 'Return on Invested Capital - YTD (ROIC)') {
                                // console.log(item.ratio.january)
                            }
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.uom,
                                // "",
                                // item.ratio.total_actual_before === null ? "0.0" : item.ratio.total_actual_before === "" ? "0.0" : item.ratio.total_actual_before,
                                Number(item.ratio.january).toFixed(2),
                                Number(item.ratio.february).toFixed(2),
                                Number(item.ratio.march).toFixed(2),
                                Number(item.ratio.april).toFixed(2),
                                Number(item.ratio.may).toFixed(2),
                                Number(item.ratio.june).toFixed(2),
                                Number(item.ratio.july).toFixed(2),
                                Number(item.ratio.august).toFixed(2),
                                Number(item.ratio.september).toFixed(2),
                                Number(item.ratio.october).toFixed(2),
                                Number(item.ratio.november).toFixed(2),
                                Number(item.ratio.december).toFixed(2),
                                Number(item.ratio.total_next_year).toFixed(2),
                                Number(item.ratio.total_more_year).toFixed(2),
                            ])

                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.uom,
                                // "",
                                // item.ratio.total_actual_before === null ? "0.0" : item.ratio.total_actual_before === "" ? "0.0" : item.ratio.total_actual_before,
                                Number(item.ratio.january).toFixed(2),
                                Number(item.ratio.february).toFixed(2),
                                Number(item.ratio.march).toFixed(2),
                                Number(item.ratio.april).toFixed(2),
                                Number(item.ratio.may).toFixed(2),
                                Number(item.ratio.june).toFixed(2),
                                Number(item.ratio.july).toFixed(2),
                                Number(item.ratio.august).toFixed(2),
                                Number(item.ratio.september).toFixed(2),
                                Number(item.ratio.october).toFixed(2),
                                Number(item.ratio.november).toFixed(2),
                                Number(item.ratio.december).toFixed(2),
                                Number(item.ratio.total_next_year).toFixed(2),
                                Number(item.ratio.total_more_year).toFixed(2),
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        this.setState({ dbFR: dataTable, loading: false }, () => {
                            // console.log(this.state.dbFR)
                            this.olahDataFR(this.state.dbFR, type)
                        })
                    } else {
                        this.setState({ dbFR: [], previewTable: false, loading: false, previewDownload: false })
                    }


                })
            })
        })


    }

    handleFormulaRatio = (value, tableMeta, month) => {
        // console.log(dataTable2)
        let dataTable2 = this.state.dbFR
        let total = 0
        if (month > 12) {
            total = Number(dataTable2[35][6 + month])
        } else {
            for (let index = 0; index < month; index++) {
                total += Number(dataTable2[35][7 + index])
                // console.log(index);
            }
            total = total / month
        }
        let hasil = Number(value) / total
        // console.log(value)
        // console.log(total)
        // console.log(hasil, value, total);
        return Number(hasil).toFixed(2)
    }

    olahDataFR(dbFR, type) {
        // let totalCY = 0
        dbFR.map((item, index) => {
            if (item[0] != 4 || item[0] != 1) {
                if (item[5] === "Return on Invested Capital - YTD (ROIC)") {
                    item[7] = this.handleFormulaRatio(item[7], item, 1)
                    item[8] = this.handleFormulaRatio(item[8], item, 2)
                    item[9] = this.handleFormulaRatio(item[9], item, 3)
                    item[10] = this.handleFormulaRatio(item[10], item, 4)
                    item[11] = this.handleFormulaRatio(item[11], item, 5)
                    item[12] = this.handleFormulaRatio(item[12], item, 6)
                    item[13] = this.handleFormulaRatio(item[13], item, 7)
                    item[14] = this.handleFormulaRatio(item[14], item, 8)
                    item[15] = this.handleFormulaRatio(item[15], item, 9)
                    item[16] = this.handleFormulaRatio(item[16], item, 10)
                    item[17] = this.handleFormulaRatio(item[17], item, 11)
                    item[18] = this.handleFormulaRatio(item[18], item, 12)
                    item[19] = this.handleFormulaRatio(item[19], item, 13)
                    item[20] = this.handleFormulaRatio(item[20], item, 14)
                    // totalCY = Number(item[7]) + Number(item[8]) + Number(item[9]) + Number(item[10]) + Number(item[11]) + Number(item[12]) + Number(item[13]) + Number(item[14]) + Number(item[15]) + Number(item[16]) + Number(item[17]) + Number(item[18])
                }
            }
        })
        this.setState({ dbFR }, () => {
            this.payloadFR(type)
        })
    }

    payloadFR(type) {
        let listFR = []
        // console.log(this.state.dbFR)
        let totalCY = 0
        this.state.dbFR.map((item, index) => {
            if (item[0] != 4 || item[0] != 1) {
                if (item[5] === "Return on Invested Capital - YTD (ROIC)") {
                    // item[7] = this.handleFormulaRatio(item[7],item,1)
                    // item[8] = this.handleFormulaRatio(item[8],item,2)
                    // item[9] = this.handleFormulaRatio(item[9],item,3)
                    // item[10] = this.handleFormulaRatio(item[10],item,4)
                    // item[11] = this.handleFormulaRatio(item[11],item,5)
                    // item[12] = this.handleFormulaRatio(item[12],item,6)
                    // item[13] = this.handleFormulaRatio(item[13],item,7)
                    // item[14] = this.handleFormulaRatio(item[14],item,8)
                    // item[15] = this.handleFormulaRatio(item[15],item,9)
                    // item[16] = this.handleFormulaRatio(item[16],item,10)
                    // item[17] = this.handleFormulaRatio(item[17],item,11)
                    // item[18] = this.handleFormulaRatio(item[18],item,12)
                    // item[19] = this.handleFormulaRatio(item[19],item,13)
                    // item[20] = this.handleFormulaRatio(item[20],item,14)
                }
                totalCY = Number(item[7]) + Number(item[8]) + Number(item[9]) + Number(item[10]) + Number(item[11]) + Number(item[12]) + Number(item[13]) + Number(item[14]) + Number(item[15]) + Number(item[16]) + Number(item[17]) + Number(item[18])
            }

            listFR.push(
                {
                    "item_report_id": item[1],
                    "january": String(item[7] == undefined || item[7] == 'Infinity' || item[7] == '-Infinity' ? "0.0" : Number(item[7]).toFixed(2)),
                    "february": String(item[8] == undefined || item[8] == 'Infinity' || item[8] == '-Infinity' ? "0.0" : Number(item[8]).toFixed(2)),
                    "march": String(item[9] == undefined || item[9] == 'Infinity' || item[9] == '-Infinity' ? "0.0" : Number(item[9]).toFixed(2)),
                    "april": String(item[10] == undefined || item[10] == 'Infinity' || item[10] == '-Infinity' ? "0.0" : Number(item[10]).toFixed(2)),
                    "may": String(item[11] == undefined || item[11] == 'Infinity' || item[11] == '-Infinity' ? "0.0" : Number(item[11]).toFixed(2)),
                    "june": String(item[12] == undefined || item[12] == 'Infinity' || item[12] == '-Infinity' ? "0.0" : Number(item[12]).toFixed(2)),
                    "july": String(item[13] == undefined || item[13] == 'Infinity' || item[13] == '-Infinity' ? "0.0" : Number(item[13]).toFixed(2)),
                    "august": String(item[14] == undefined || item[14] == 'Infinity' || item[14] == '-Infinity' ? "0.0" : Number(item[14]).toFixed(2)),
                    "september": String(item[15] == undefined || item[15] == 'Infinity' || item[15] == '-Infinity' ? "0.0" : Number(item[15]).toFixed(2)),
                    "october": String(item[16] == undefined || item[16] == 'Infinity' || item[16] == '-Infinity' ? "0.0" : Number(item[16]).toFixed(2)),
                    "november": String(item[17] == undefined || item[17] == 'Infinity' || item[17] == '-Infinity' ? "0.0" : Number(item[17]).toFixed(2)),
                    "december": String(item[18] == undefined || item[18] == 'Infinity' || item[18] == '-Infinity' ? "0.0" : Number(item[18]).toFixed(2)),
                    "total_current_year": String(totalCY == undefined || totalCY == 'Infinity' || totalCY == '-Infinity' ? "0.0" : Number(totalCY).toFixed(2)),
                    "total_next_year": String(item[19] != '' || item[19] != 'Infinity' || item[19] != '-Infinity' ? Number(item[19]).toFixed(2) : item[19]),
                    "total_more_year": String(item[20] != '' || item[20] != 'Infinity' || item[20] != '-Infinity' ? Number(item[20]).toFixed(2) : item[20]),
                }
            )

        })

        // console.log(listFR)
        // console.log('subOD', this.state.submissionID)
        this.setState({ dbFR: listFR }, () => {
            if (this.state.submissionID != null) {
                this.createDBFR()
            }
        })
    }

    createDBFR() {
        // console.log("create FR");
        let payload = {
            // "submission_id": this.state.submissionID,
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "report_id": 29,
            "status": "submitted",
            "ratio_id": this.state.FRID,
            "currency_id": this.state.defaultCurrency.id,
            "ratio_mb": this.state.dbFR,
            "months": 0,
        }
        // console.log(this.state.dbCF)
        // console.log(JSON.stringify(payload))
        api.create().createReportFRMB(payload).then((res) => {
            // console.log(res)
            // if (response.data) {
            //     if (response.data.status === "success") {
            //         this.props.saveToMonthlyReport()
            //     } else {
            //         this.setState({ loading: false }, () => {
            //             this.props.saveToMonthlyReport()
            //         })
            //     }
            // } else {
            //     this.setState({ loading: false }, () => {
            //         // this.getSubmission()
            //         document.body.style.overflow = 'unset';
            //     })
            // }
        })
    }

    historyApproval() {
        const uniqueTypeIds =
            this.state.rowData?.length
                ? [...new Set(this.state.rowData.map(item => item.master_report_type_id))]
                : [1, 2];

        uniqueTypeIds.forEach((master_report_type_id) => {
            let body = {
                "company_id": this.state.company.company_id,
                "periode": this.state.periode.periode,
                master_report_type_id
            }
            api.create().historyApproval(body).then(response => {
                if (response.data.data.length > 0) {
                    const dataTable = response.data.data.map(item => {
                        let indexC = String(item.status_approval).toLocaleUpperCase().indexOf('C')
                        let status_approv = ''
                        if (String(item.status_approval).toLocaleUpperCase().includes('CC')) {
                            status_approv = `${String(item.status_approval).substr(0, indexC)}${String(item.status_approval).substr(indexC + 1, String(item.status_approval).length)}`
                        } else {
                            status_approv = String(item.status_approval)
                        }
                        return [
                            item.pic,
                            status_approv,
                            item.remarks,
                            item.item_revision,
                            item.history_approval_date
                        ]
                    })
                    if (master_report_type_id === 2) {
                        this.setState({ dataTableHistoryCAT: dataTable, visibleTableHistoryCAT: true })
                    } else {
                        this.setState({ dataTableHistory: dataTable, visibleTableHistory: true })
                    }
                }
            })
        });
    }

    async setHeaderTokenSuperadmin(type, master_report_type_id) {
        let realToken = await localStorage.getItem(Constant.TOKEN)
        api.create().getIdToken(this.state.approver.userId).then((response) => {
            // console.log(response.data.data.token)
            localStorage.setItem(Constant.TOKEN, response.data.data.token)
            this.approvalSubmission(type, master_report_type_id, realToken)
        })
    }

    approvalSubmission(type, master_report_type_id, realToken) {
        // this.scrollToMyRef()
        // let realToken = await localStorage.getItem(Constant.TOKEN)
        // if (this.state.isAdmin && type == 'approve') {
        //     api.create().getIdToken(this.state.approver.userId).then((response) => {
        //         console.log(response.data.data.token)
        //         console.log(realToken)
        //         localStorage.setItem(Constant.TOKEN, response.data.data.token)
        //     })
        // }
        this.setState({ loading: true }, () => {
            document.body.style.overflow = 'hidden';
        })
        let body = {
            "approval_id": this.state.approverID,
            "status": type,
            "detail": this.state.detailRevisiCheck,
            "is_superadmin": this.state.isAdmin,
            "currency_id": this.state.defaultCurrency.id,
            master_report_type_id
        }
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "min_periode": moment(this.state.minDateRevision).format('YYYY-MM-DD'),
            "max_periode": moment(this.state.maxDateRevision).format('YYYY-MM-DD'),
        }
        // console.log(payload)
        // // console.log(this.props.location);
        // console.log(body)
        setTimeout(() => {
            api.create().approvalSubmission(body).then((res) => {
                // console.log(res)
                // this.setState({ loading: false }, () => {
                // })
                if (this.state.isAdmin && type == 'approve') {
                    localStorage.setItem(Constant.TOKEN, realToken)
                    this.setState({ visibleApproveSuperadmin: false, currentMasterReportTypeId: null })
                }
                setTimeout(() => {
                    if (type == 'revision') {
                        api.create().createPeriodeRevision(payload).then((res))
                    }
                    this.getSubmission()
                }, 400);
            })
        }, 200);
    }

    clickDetail(item, id, revision, status, tableKey) {
        let items = ''
        if (item === 'Corporate Annual Target') {
            items = 'CAT'
        } else {
            items = item
        }
        let PLBSFAMSubmitted = 0
        const listTable = tableKey == 'CAT' ? this.state.dataForRevisionCAT : this.state.dataForRevision
        // // // console.log(this.state.dataForRevision);
        listTable.map(i => {
            if (i.report_name === items) {
                if (i.revision !== revision) {
                    this.setState({ prevRevision: true })
                } else {
                    this.setState({ prevRevision: false })
                }
            }
            if (String(i.report_name).toLocaleLowerCase() == "profit loss" || String(i.report_name).toLocaleLowerCase() == "balance sheet" || String(i.report_name).toLocaleLowerCase() == "fixed assets movement") {
                if (String(i.current_status).toLocaleLowerCase() == "submitted") {
                    PLBSFAMSubmitted += 1
                }
            }
        })
        this.setState({
            report_id: id,
            revisionTable: revision,
            status: status,
            tableKey
        }, () => {
            if (item === 'Balance Sheet') {
                this.setState({
                    visibleBudgetTahunan: false,
                    visibleBS: true,
                    visiblePL: false,
                    visibleCAT: false,
                    visibleFAM: false,
                    visibleTP: false,
                    visibleCF: false,
                })
            } else if (item === 'Profit Loss') {
                this.setState({
                    visibleBudgetTahunan: false,
                    visibleBS: false,
                    visiblePL: true,
                    visibleCAT: false,
                    visibleFAM: false,
                    visibleTP: false,
                    visibleCF: false,
                })
            } else if (item === 'Tax Planning') {
                this.setState({
                    visibleBudgetTahunan: false,
                    visibleBS: false,
                    visiblePL: false,
                    visibleCAT: false,
                    visibleFAM: false,
                    visibleTP: true,
                    visibleCF: false,
                })
            } else if (item === 'Fixed Assets Movement') {
                this.setState({
                    visibleBudgetTahunan: false,
                    visibleBS: false,
                    visiblePL: false,
                    visibleCAT: false,
                    visibleFAM: true,
                    visibleTP: false,
                    visibleCF: false,
                })
            } else if (item === 'Corporate Annual Target') {
                this.setState({
                    visibleBudgetTahunan: false,
                    visibleBS: false,
                    visiblePL: false,
                    visibleCAT: true,
                    visibleFAM: false,
                    visibleTP: false,
                    visibleCF: false,
                })
            } else if (item === "Cash Flow") {
                this.setState({
                    visibleBudgetTahunan: false,
                    visibleBS: false,
                    visiblePL: false,
                    visibleCAT: false,
                    visibleFAM: false,
                    visibleTP: false,
                    visibleCF: true,
                    PLBSFAMSubmitted: PLBSFAMSubmitted == 3 ? true : false
                })
            }
        })
    }

    handleChange(value, tableMeta) {
        let data = this.state.dataTable
        data[tableMeta.rowIndex][tableMeta.columnIndex] = value
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // // // console.log(resp)
            if (err) {
                // // // console.log(err);
            }
            else {
                const formData = new FormData();
                formData.append("revision", Number(this.state.lastRevision));
                formData.append("companyId", this.state.company.company_id);
                formData.append("periode", Number(this.state.periode.periode));
                formData.append("file", event);
                this.setState({ formData })
            }
        })
    }

    uploadAttachment(formData) {
        api.create().uploadAttachment(formData).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({ visibleUpload: false }, () => {
                        this.getSubmission()
                    })
                }
            }
        })
    }

    deleteAttachment(item) {
        api.create().deleteAttachment(item.attachment_id).then(response => {
            // // // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.getSubmission()
                }
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    saveToMasterBudget(data, type) {
        this.setState({ loading: true }, () => {
            document.body.style.overflow = 'hidden';
        })
        console.log(type);
        // // console.log(JSON.stringify(data));
        api.create('UPLOAD').createSubmitReport(data).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        if (type === "PL" || type === "DraftPL") {
                            this.setState({ visiblePL: false, visibleBudgetTahunan: true, loading: false })
                        } else if (type === "TP" || type === "DraftTP") {
                            this.setState({ visibleTP: false, visibleBudgetTahunan: true, loading: false })
                        } else if (type === "BS" || type === "DraftBS") {
                            this.setState({ visibleBS: false, visibleBudgetTahunan: true, loading: false })
                        } else if (type === "FAM" || type === "DraftFAM") {
                            this.setState({ visibleFAM: false, visibleBudgetTahunan: true, loading: false })
                        } else if (type === "CAT" || type === "DraftCAT") {
                            this.setState({ visibleCF: false, visibleBudgetTahunan: true, loading: false })
                        } else {
                            this.setState({ visibleBudgetTahunan: true, visiblePL: false, visibleTP: false, visibleBS: false, visibleFAM: false, visibleCAT: false, loading: false })
                        }
                        this.getSubmission(type)
                    } else {
                        console.log(response.data);
                        if (response.data.message == "Please Set Up Rate Currency First") {
                            this.setState({ visibleAlertSave: true })
                        } else {
                            // this.setState({ loading: false }, () => {
                            this.getSubmission()
                            document.body.style.overflow = 'unset';
                        }
                        // })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false }, () => {
                        this.getSubmission()
                        document.body.style.overflow = 'unset';
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error', loading: false }, () => {
                    this.getSubmission()
                    document.body.style.overflow = 'unset';
                })
            }
        })
    }

    async downloadAttachment(fileurl, name) {
        let length = name.split(".").length
        let fileType = name.split(".")[length - 1]
        // // // console.log(fileType);
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_attachment?fileName=${fileurl}&&fileType=${fileType}`
        // // // console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_attachment?fileName=${fileurl}&&fileType=${fileType}`
        )
        res = await res.blob()
        this.setState({ loading: false }, () => {
            document.body.style.overflow = 'unset';
        })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Master Budget Attachment.xlsx';
            a.click();
        }
    }

    validate(master_report_type_id) {
        this.setState({ loading: true }, () => {
            document.body.style.overflow = 'hidden';
        })
        let array = []
        let canSubmit = true
        const listTable = master_report_type_id == 1 ? this.state.dataTable : this.state.dataTableCAT
        listTable.map(item => {
            // if (item[1] !== 'Cash Flow') {
            if (item[3] !== "submitted" && item[3] !== 'approved') {
                canSubmit = false
                array.push(item[3])
            }
            // }
            // if (item[3].includes("not-yet") || item[3].includes("draft")) {
            //     array.push(item[3])
            // } else {
            //     array.push(item[3])
            // }
        })
        if (canSubmit === true) {
            let body = {
                submission_id: this.state.submissionID,
                master_report_type_id
            }
            api.create().submitMasterBudget(body).then(response => {
                // // // console.log(response);
                if (response.data) {
                    if (response.data.status === "success") {
                        this.getSubmission()
                    }
                }
            })
        } else {
            this.setState({ alert: true, messageAlert: 'Data Is Not Complete', tipeAlert: 'warning', loading: false }, () => {
                document.body.style.overflow = 'unset';
            })
        }
        // if (array.includes("not-yet" || "draft")) {
        //     // // console.log('gagal');
        // } else {
        //     // // console.log('masuk');
        // }

    }

    validateRevision(master_report_type_id) {
        // this.scrollToMyRef()
        let arrayRevisi = this.state.detailRevisiCheck
        let remarksKosong = 0
        arrayRevisi.map((item, index) => {
            if (item.remarks == "") {
                remarksKosong += 1
            }
        })
        // // console.log(arrayRevisi)
        if (arrayRevisi.length == 0 || remarksKosong > 0) {
            this.setState({ alert: true, messageAlert: 'Remarks Cannot be Empty', tipeAlert: 'error' })
        } else {
            this.setState({ visibleRevision: false, currentMasterReportTypeId: null }, () => this.approvalSubmission('revision', master_report_type_id))
        }
    }

    handleApproveAdmin(master_report_type_id) {
        this.setState({ visibleApproveSuperadmin: true, currentMasterReportTypeId: master_report_type_id })
    }

    handleSelectAll(data) {
        // console.log(this.state.isCheckAll);
        if (this.state.isCheckAll) {
            let checkAll = []
            this.setState({ selectReport: checkAll, isCheckAll: false })
        } else {
            let checkAll = this.state.selectReport
            let isAllDetail = true
            data.map((item, index) => {
                if (item[5] === true) {
                    if (!this.state.selectReport.includes(item[4])) {
                        checkAll.push(item[4])
                    }
                } else {
                    isAllDetail = false
                    checkAll.splice(index, 1)
                }
            })
            // console.log(checkAll);
            this.setState({ selectReport: checkAll, isCheckAll: isAllDetail })
        }
    }

    handleItemChecked(item) {
        let indexID = this.state.selectReport.findIndex((val) => val === item.rowData[4])
        return indexID === -1 ? false : true
    }

    handleItemClick(item) {
        let indexID = this.state.selectReport.findIndex((val) => val === item.rowData[4])
        let selectReport = this.state.selectReport
        if (indexID === -1) {
            selectReport.push(item.rowData[4])
        } else {
            selectReport.splice(indexID, 1)
        }
        let isCheckAll = selectReport.length === this.state.dataTable.length
        this.setState({ selectReport, isCheckAll })
        // console.log(selectReport);
    }

    handleDownloadReport(tableMeta) {
        let { selectReport, company, periode, month, defaultCurrency } = this.state
        let payload = {
            "company_id": company.company_id,
            "year": periode.periode,
            "report_id": selectReport,
            "month": "",
            "quartal": "",
            "type_report_name": "Master Budget",
            "currency_id": defaultCurrency.id
        }
        // console.log(payload);
        api.create().createDownloadFile(payload).then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        this.setState({ downloadedFileReportId: data.downloadedFileReportId, popupDownload: true }, () => this.handleGenerateReport(tableMeta))
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error'})
                alert(response.problem)
            }
        })
    }

    // componentDidUpdate = (prevProps, prevState) => {
    //     console.log(this.state.arrayReport);
    //     if (this.state.selectReport.length > 0 && (this.state.arrayReport.length == this.state.selectReport.length)) {
    //         setTimeout(() => {
    //             this.handleZip()
    //         }, 200);
    //     }
    // }

    async handleGenerateReport(data) {
        let { selectReport, submissionID, company, periode, month, downloadedFileReportId, defaultCurrency } = this.state
        if (selectReport.length > 0) {
            let result = []
            // console.log('mulai hit')
            for (const items of selectReport) {
                let datas = data.findIndex((val) => val[4] == items)
                let report = data[datas]
                if (items === 6) {
                    try {
                        let resReal = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/master_budget/export_master_budget?submission_id=${submissionID}&company_id=${company.company_id}&year=${periode.periode}&revision=${report[2]}&report_id=${report[4]}&download_file_report_id=${downloadedFileReportId}&currency_id=${defaultCurrency.id}`
                        let resNull = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/master_budget/export_master_budget?submission_id=&&company_id=${company.company_id}&year=${periode.periode}&revision=${report[2]}&report_id=${report[4]}&download_file_report_id=${downloadedFileReportId}&currency_id=${defaultCurrency.id}`

                        let res = await fetch(
                            submissionID == null ? resNull : resReal
                        )
                        if (res.size > 0) {
                            let url = window.URL.createObjectURL(res);
                            let a = document.createElement('a');
                            a.href = url;
                        }
                        if (res.status === 200) {
                            result = [...result, res];
                        }
                    } catch (error) {
                        alert(error)
                    }

                } else {
                    try {
                        let resReal = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${submissionID}&report_id=${report[4]}&company_id=${company.company_id}&year=${periode.periode}&revision=${report[2]}&download_file_report_id=${downloadedFileReportId}&currency_id=${defaultCurrency.id}`
                        let resNull = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=&report_id=${report[4]}&company_id=${company.company_id}&year=${periode.periode}&revision=${report[2]}&download_file_report_id=${downloadedFileReportId}&currency_id=${defaultCurrency.id}`

                        let res = await fetch(
                            submissionID == null ? resNull : resReal
                        )
                        if (res.size > 0) {
                            let url = window.URL.createObjectURL(res);
                            let a = document.createElement('a');
                            a.href = url;
                        }
                        if (res.status === 200) {
                            result = [...result, res];
                        }
                    } catch (error) {
                        alert(error)
                    }
                }
            }

            // console.log('ini result', result);
            // every untuk cek ke setiap result di dalam array
            if (result.every((e) => e.status == 200)) {
                this.handleZip();
            }
            // Promise untuk ngumpulin semua result yg statusnya 200
            // const result = await Promise.all(selectReport.map(async (items) => {
            //     let datas = data.findIndex((val) => val[4] == items)
            //     let report = data[datas]
            //     if (items === 6) {
            //         let resReal = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/master_budget/export_master_budget?submission_id=${submissionID}&&company_id=${company.company_id}&&year=${periode.periode}&&revision=${report[2]}&&report_id=${report[4]}&&download_file_report_id=${downloadedFileReportId}`
            //         let resNull = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/master_budget/export_master_budget?submission_id=&&company_id=${company.company_id}&&year=${periode.periode}&&revision=${report[2]}&&report_id=${report[4]}&&download_file_report_id=${downloadedFileReportId}`
            //         // console.log('cash_flow start', Date.now())
            //         let res = await fetch(
            //             this.props.submissionID == null ? resNull : resReal
            //         )
            //         // console.log('cash_flow end', Date.now())
            //         // console.log(res);
            //         if (res.status === 200) {
            //             // this.setState({ arrayReport: [...this.state.arrayReport, items] })
            //             return res;
            //         }
            //     } else {
            //         let resReal = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${submissionID}&&report_id=${report[4]}&&company_id=${company.company_id}&&year=${periode.periode}&&revision=${report[2]}&&download_file_report_id=${downloadedFileReportId}`
            //         let resNull = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=&&report_id=${report[4]}&&company_id=${company.company_id}&&year=${periode.periode}&&revision=${report[2]}&&download_file_report_id=${downloadedFileReportId}`

            //         // console.log('master_budget start', Date.now())
            //         let res = await fetch(
            //             this.props.submissionID == null ? resNull : resReal
            //         )
            //         // console.log('master_budget end', Date.now())
            //         // console.log(res);
            //         if (res.status === 200) {
            //             // this.setState({ arrayReport: [...this.state.arrayReport, items] })
            //             return res;
            //         }
            //     }

        } else {
            alert("Anda harus memilih report yang ingin di download terlebih dahulu!")
        }
    }

    async handleZip() {
        // console.log('mulai zip')
        api.create().createZipReport(this.state.downloadedFileReportId).then((response) => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ arrayReport: [] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error'})
                alert(response.problem)
            }
        })
    }

    getLastStatus = () => {
        const { tableKey, lastStatus, lastStatusCat } = this.state
        return tableKey === 'CAT' ? lastStatusCat : lastStatus
    }

    getSubmissionObj = (tableKeyParam) => {
        const {
            tableKey,
            btnApprove,
            btnApproveCAT,
            lastStatus,
            lastStatusCat,
            submitter,
            submitterCAT,
        } = this.state;

        const key = tableKeyParam ?? tableKey;

        return key === 2
            ? { btnApprove: btnApproveCAT, lastStatus: lastStatusCat, submitter: submitterCAT }
            : { btnApprove, lastStatus, submitter };
    };

    renderFilter = () => {
        return (
            <div>
                <div style={{ display: "flex" }}>
                    <div style={{ marginRight: 50 }}>
                        <Autocomplete
                            {...this.state.listPeriode}
                            id="periode"
                            onChange={(event, newInputValue) => this.setState({ periode: newInputValue }, () => {
                                if (this.state.isApprover === true) {
                                    this.getCompanySubmitted()
                                } else {
                                    this.setState({ visibleTableHistory: false, visibleTableHistoryCAT: false })
                                    this.getRevision()
                                }
                            })}
                            disabled={this.state.intent === 'Home' ? true : false}
                            disableClearable
                            style={{ width: 250 }}
                            renderInput={(params) =>
                                <TextField {...params} label="Period" margin="normal" style={{ marginTop: 7 }}
                                />}
                            value={this.state.periode}
                        />
                    </div>
                    <div style={{ width: 255 }}>
                        <Autocomplete
                            id="tipe"
                            disableClearable
                            options={this.state.currency}
                            getOptionLabel={(option) => option.value}
                            value={this.state.defaultCurrency}
                            // onChange={(event, newInputValue) => this.setState({ defaultCurrency: newInputValue })}
                            onChange={(event, newInputValue) => this.setState({ defaultCurrency: newInputValue }, () => {
                                this.getRevision()
                            })}
                            renderInput={(params) =>
                                <TextField
                                    {...params}
                                    variant="standard"
                                    label="Currency"
                                    margin="normal"
                                    style={{ marginTop: 6 }}
                                // InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                // InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                />
                            }

                        />
                        {/* <Autocomplete
                                                options={this.state.dataCurrency}
                                                getOptionLabel={(option) => option.value}
                                                onChange={(event, newInputValue) => this.setState({ currency: newInputValue })}
                                                renderInput={(params) => (
                                                    <TextField
                                                        {...params}
                                                        variant="standard"
                                                        label="Currency"
                                                        margin="normal"
                                                        style={{ marginTop: 0 }}
                                                        InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                        InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                    />
                                                )}
                                                value={this.state.currency == null ? "IDR" : this.state.currency}
                                            /> */}
                    </div>
                </div>

                <div style={{ marginTop: 20 }}>
                    <Autocomplete
                        {...this.state.listCompany}
                        id="company"
                        disabled={this.state.listCompany === null ? true : this.state.intent === 'Home' ? true : false}
                        onChange={(event, newInputValue) => this.setState({ company: newInputValue }, () => {
                            this.setState({ visibleTableHistory: false, visibleTableHistoryCAT: false })
                            this.getLastPeriod()
                            this.getCurrency(newInputValue.company_id)
                            this.getRevision()
                        })}
                        disableClearable
                        style={{ width: 250 }}
                        renderInput={(params) => <TextField {...params} label="Company" margin="normal" style={{ marginTop: 7 }} />}
                        value={this.state.company}
                    />
                </div>
                <div style={{ marginTop: 20 }}>
                    {/* <Autocomplete
                                            {...this.state.listRevision}
                                            id="revision"
                                            onChange={(event, newInputValue) => this.setState({ revision: newInputValue }, () => {
                                                this.getReport()
                                                this.getReportAttachment()
                                            })}
                                            disabled={true}
                                            disableClearable
                                            style={{ width: 250 }}
                                            renderInput={(params) => <TextField {...params} label="Revision" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.revision}
                                        /> */}
                    <TextField disabled={true} label="Revision" margin="normal" style={{ marginTop: 7, width: 250 }} value={this.state.lastRevision} />
                </div>
            </div>
        )
    }

    renderAttachment = () => {
        const _lastStatus = this.getLastStatus()
        return (
            <>
                <div style={{ display: 'flex', marginTop: 20 }}>
                    <div style={{ width: '50%' }}>
                        <Typography style={{ fontSize: '16px', color: '#4b4b4b', fontWeight: 'bold' }}>Attachment: </Typography>
                    </div>
                    {!this.state.isApprover && (_lastStatus === 'SUBMIT' || _lastStatus === 'REVISION') && (
                        <div style={{ width: '50%' }}>
                            <button
                                style={{
                                    backgroundColor: 'transparent',
                                    cursor: this.state.isSubmit === false ? 'default' : 'pointer',
                                    borderColor: 'transparent',
                                    outline: 'none'
                                }}
                                onClick={() => this.setState({ visibleUpload: true })}
                            >
                                <Typography style={{ fontSize: '16px', color: this.state.isSubmit === false ? 'GrayText' : '#5198ea' }}>Upload File</Typography>
                            </button>
                        </div>
                    )}
                </div>
                <div style={{ display: 'flex', marginTop: 10 }}>
                    <div style={{ width: '50%', paddingLeft: 20 }}>
                        {this.state.listAttachment.length > 0 ?
                            this.state.listAttachment.map((item, index) => {
                                return (
                                    <div style={{ display: 'flex' }}>
                                        <Typography style={{ fontSize: '13px', color: '#4b4b4b', width: 25 }}>{index + 1}. </Typography>

                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                display: 'grid'
                                            }}
                                            onClick={() => {
                                                this.downloadAttachment(item.attachment_url, item.attachment_name)
                                            }}
                                        >
                                            <div>
                                                <Typography style={{ fontSize: '13px', color: '#5198ea' }}> {item.attachment_name}</Typography>
                                            </div>
                                        </button>
                                    </div>
                                )
                            })
                            : null
                        }
                    </div>
                    {!this.state.isApprover && (_lastStatus === 'SUBMIT' || _lastStatus === 'REVISION') && (
                        <div style={{ width: '50%' }}>
                            {
                                this.state.listAttachment.length > 0 ?
                                    this.state.listAttachment.map((item) => {
                                        return (
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.isSubmit === false ? 'default' : 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    display: 'grid'
                                                }}
                                                onClick={() => this.state.isSubmit === false ? null : this.deleteAttachment(item)}
                                            >
                                                <Typography style={{ fontSize: '13px', color: this.state.isSubmit === false ? 'GrayText' : '#ff3939' }}>Delete</Typography>
                                            </button>
                                        )
                                    })
                                    : null
                            }
                        </div>
                    )}
                </div>
            </>
        )
    }

    renderHistoryInfo = (master_report_type_id) => {
        const obj = this.getSubmissionObj(master_report_type_id)
        return (
            this.state.checkApprover === true ?
                obj.lastStatus === 'WAITING FOR REVIEW' ?
                    <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                        <span>{obj.lastStatus}</span>
                    </div> : obj.lastStatus === 'WAITING FOR YOUR APPROVAL' ?
                        <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                            <span>{obj.lastStatus}</span>
                        </div> : obj.lastStatus === 'WAITING FOR APPROVAL' ?
                            <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                <span>{`${obj.lastStatus} - ${this.state.pic}`}</span>
                            </div> : obj.lastStatus === 'APPROVED' ?
                                <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                    <span>{`${obj.lastStatus}`}</span>
                                </div> : null
                :
                obj.lastStatus === 'SUBMITTED' ?
                    <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                        <span>{obj.lastStatus}</span>
                    </div> :
                    obj.lastStatus === 'WAITING FOR APPROVAL' ?
                        <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                            <span>{`${obj.lastStatus} - ${this.state.pic}`}</span>
                        </div> :
                        obj.lastStatus === 'REVISION' ?
                            <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                <span>NEED REVISION</span>
                            </div> :
                            obj.lastStatus === 'APPROVED' ?
                                <div style={{ width: '100%', padding: '10px 20px', backgroundColor: 'yellow', textAlign: 'center', marginTop: 20 }}>
                                    <span>APPROVED</span>
                                </div> : null

        )
    }

    renderBtnSubmit = (master_report_type_id) => {
        const obj = this.getSubmissionObj(master_report_type_id)
        return (
            this.state.isAdmin && obj.lastStatus == 'APPROVED' ?
                <div className="grid grid-2x" style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', }}>
                    <div className="col-1" />
                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                        <button
                            style={{
                                backgroundColor: 'transparent',
                                cursor: 'pointer',
                                borderColor: 'transparent',
                                outline: 'none',
                                marginRight: 20
                            }}
                            onClick={() => this.setState({ visibleRevision: true, currentMasterReportTypeId: master_report_type_id })}
                        >
                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Revision</Typography>
                            </div>
                        </button>
                        {/* <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                                onClick={() => this.approvalSubmission('approve')}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Approve</Typography>
                                                </div>
                                            </button> */}
                    </div>
                </div>
                :
                this.state.isAdmin && (obj.lastStatus === 'WAITING FOR YOUR APPROVAL' || obj.lastStatus === 'WAITING FOR APPROVAL') ?
                    <div className="grid grid-2x" style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', }}>
                        <div className="col-1" />
                        <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                            <button
                                style={{
                                    backgroundColor: 'transparent',
                                    cursor: 'pointer',
                                    borderColor: 'transparent',
                                    outline: 'none',
                                }}
                                onClick={() => this.handleApproveAdmin(master_report_type_id)}
                            >
                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Approve</Typography>
                                </div>
                            </button>
                        </div>
                    </div>
                    :
                    this.state.checkApprover === true ?
                        obj.lastStatus === 'WAITING FOR REVIEW' ?
                            <div style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', display: 'flex', justifyContent: 'flex-end' }} >
                                <button
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: 'pointer',
                                        borderColor: 'transparent',
                                        outline: 'none',
                                    }}
                                    onClick={() =>
                                        this.approvalSubmission('review', master_report_type_id)
                                    }
                                >
                                    <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                        <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Review</Typography>
                                    </div>
                                </button>
                            </div> : (obj.lastStatus === 'WAITING FOR YOUR APPROVAL' && obj.btnApprove) ?
                                <div className="grid grid-2x" style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', }}>
                                    <div className="col-1" />
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => this.setState({ visibleRevision: true, currentMasterReportTypeId: master_report_type_id })}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Revision</Typography>
                                            </div>
                                        </button>
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                            onClick={() => this.approvalSubmission('approve', master_report_type_id)}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Approve</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div> : null
                        :
                        (obj.lastStatus === 'SUBMIT' || obj.lastStatus === 'REVISION') && this.state.isSubmit === true ?
                            <div style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', display: 'flex', justifyContent: 'flex-end' }} >
                                <button
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: 'pointer',
                                        borderColor: 'transparent',
                                        outline: 'none',
                                    }}
                                    onClick={() => this.validate(master_report_type_id)}
                                >
                                    <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                        <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Submit</Typography>
                                    </div>
                                </button>
                            </div> :
                            obj.lastStatus === 'SUBMITTED' && obj.submitter ?
                                <div style={{ borderTop: 'solid 1px #c4c4c4', padding: 10, backgroundColor: '#f5f5f5', width: '100%', display: 'flex', justifyContent: 'flex-end' }} >
                                    <button
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                        onClick={() => this.approvalSubmission('cancel', master_report_type_id)}
                                    >
                                        <div style={{ backgroundColor: 'gray', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Cancel</Typography>
                                        </div>
                                    </button>
                                </div> : null
        )
    }

    render() {
        const handleMaxDate = () => {
            let handleDate = Number(moment(this.state.maxDateRevision).format('YYYYMMDD')) - Number(moment(this.state.minDateRevision).format('YYYYMMDD'))
            return handleDate < 0 ? moment(this.state.minDateRevision).format('YYYY/MM/DD') : moment(this.state.maxDateRevision).format('YYYY/MM/DD')
        }
        const columns = (tableKey) => ["#", "Report Type",
            {
                name: "Revision",
                options: {
                    customBodyRender: (val, tableMeta, updateValue) => {
                        var list = [];
                        for (var i = 0; i <= tableMeta.rowData[6]; i++) {
                            list.push(i);
                        }
                        return (
                            <div style={{ display: 'flex' }}>
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    value={val}
                                    control={
                                        <Select
                                            value={val}
                                            onChange={event => {
                                                // // // console.log(event.target)
                                                updateValue(event.target.value)
                                                this.handleChange(event.target.value, tableMeta)
                                            }}
                                            autoWidth
                                        >
                                            {list.map((item, index) =>
                                                <MenuItem key={index} value={item}>{item}</MenuItem>
                                            )}
                                        </Select>
                                    }
                                />
                            </div >
                        );
                    }
                }
            }, {
                name: "Status",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {val === "submitted" || val === "approved" ?
                                    <span>COMPLETED</span> :
                                    val === "draft" ?
                                        <span>DRAFT</span> :
                                        val === "incomplete" ?
                                            <span>INCOMPLETE</span> :
                                            val === "revision" ?
                                                <span>REVISION</span> :
                                                val === "approval_process" ?
                                                    <span>APPROVAL PROCCESS</span> :
                                                    val === "approval_review" ?
                                                        <span>APPROVAL REVIEW</span> :
                                                        val === "not-yet" ?
                                                            <span>OPEN</span> :
                                                            val === "CLOSED" ?
                                                                <span>CLOSED</span> :
                                                                <img src={Images.cross} style={{ width: 31, height: 24 }} />
                                }
                            </div >
                        );
                    }
                }
            },
            {
                name: "Action",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                <button
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: tableMeta.rowData[5] ? 'pointer' : 'default',
                                        borderColor: 'transparent'
                                    }}
                                    onClick={() =>
                                        tableMeta.rowData[5] == true ?
                                            this.clickDetail(tableMeta.rowData[1], tableMeta.rowData[4], tableMeta.rowData[2], tableMeta.rowData[3], tableKey)
                                            : null
                                    }
                                >
                                    {/* {this.state.isApprover == true ?
                                        (tableMeta.rowData[5] ? '#5198ea' : 'GrayText') :
                                        (this.state.lastRevision == 0 ? (tableMeta.rowData[5] ? '#5198ea' : 'GrayText') :
                                        (tableMeta.rowData[3] !== 'submitted' ? '#5198ea' : 'GrayText'))} */}
                                    <Typography style={{ color: tableMeta.rowData[5] ? '#5198ea' : 'GrayText', fontSize: 12, }}>Detail</Typography>
                                </button>
                            </div >
                        );
                    }
                }
            }, {
                name: "Download",
                options: {
                    customBodyRender: (val, tableMeta) => {
                        // console.log(tableMeta);
                        return (
                            <div style={{ display: 'flex' }}>
                                <CustomCheckbox
                                    checked={this.handleItemChecked(tableMeta)}
                                    onChange={() => tableMeta.rowData[5] == true ? this.handleItemClick(tableMeta) : null}
                                    disabled={tableMeta.rowData[5] == true ? false : true}
                                />
                            </div >
                        );
                    }
                }
            }, {
                name: "",
                options: { display: false }
            }, {
                name: "",
                options: { display: false }
            }
        ]

        const columnsHistory = [
            "Name", "Status", "Remarks", "Revision Item", "Date"
        ]

        const columnRevisi = (master_report_type_id) => [
            {
                name: "#",
                options: {
                    customBodyRender: (val, tableMeta, updateValue) => {
                        var list = [];
                        for (var i = 0; i <= tableMeta.rowData[6]; i++) {
                            list.push(i);
                        }
                        return (
                            <div style={{ display: 'flex' }}>
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    value={val}
                                    control={
                                        <Checkbox
                                            checked={this.state.detailRevisiCheck.findIndex((val) => val.report_id == tableMeta.rowData[0]) == -1 ? false : true}
                                            onClick={() => handleCheckRevision(tableMeta.rowData, master_report_type_id)} />
                                    }
                                />
                            </div >
                        );
                    }
                }
            }, "Report Type",
            {
                name: 'Remarks',
                options: {
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'left' }}>
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    // value={value}
                                    control={
                                        <Input
                                            disableUnderline={true}
                                            style={{ fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginTop: -10 }}
                                            type="text"
                                            placeholder=""
                                            defaultValue={value}
                                            color={"#5198ea"}
                                            onBlur={(event) => {
                                                // // // console.log(event.target.value)
                                                // updateValue(event.target.value)
                                                handleChangeText(event.target.value, tableMeta, master_report_type_id)
                                                // // // console.log(dataTable2)
                                            }}
                                        />}
                                />
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: { display: false }
            }
        ]

        const handleChangeText = (value, tableMeta, master_report_type_id) => {
            const listTableRevision = master_report_type_id === 2 ? this.state.dataTableRevisionCAT : this.state.dataTableRevision
            listTableRevision[tableMeta.rowIndex][tableMeta.columnIndex] = value

            let detailRevisiCheck = this.state.detailRevisiCheck
            let indexId = detailRevisiCheck.findIndex((val) => val.report_id == tableMeta.rowData[0])
            if (indexId !== -1) {
                detailRevisiCheck[indexId].remarks = value
            }

            this.setState({ [master_report_type_id === 2 ? "dataTableRevisionCAT" : "dataTableRevision"]: listTableRevision, detailRevisiCheck })
        }

        const handleCheckRevision = (value, master_report_type_id) => {
            const listTableRevision = master_report_type_id === 2 ? this.state.dataTableRevisionCAT : this.state.dataTableRevision
            let detailRevisiCheck = this.state.detailRevisiCheck
            let payload = {
                report_id: value[0],
                remarks: value[2],
                number: value[3]
            }
            let indexDataRevisi = listTableRevision.findIndex((val) => val[3] == value[3])
            let indexId = detailRevisiCheck.sort((a, b) => a.number - b.number).findIndex((val) => val.number == value[3])
            // // console.log(indexId)
            if (indexId == -1) {
                listTableRevision.map((item, index) => {
                    if (index > indexDataRevisi) {
                        let indexIds = detailRevisiCheck.findIndex((val) => val.number == item[3])
                        if (indexIds == -1) {
                            let payload2 = {
                                report_id: item[0],
                                remarks: item[2],
                                number: item[3]
                            }
                            detailRevisiCheck.push(payload2)
                        }
                    }
                })
                detailRevisiCheck.push(payload)
            } else {

                let x = 0
                detailRevisiCheck.sort((a, b) => a.number - b.number).map((item, index) => {
                    if (item.number < value[3]) {
                        x += 1
                    }
                })
                if (x < 1) {
                    listTableRevision.map((item, index) => {
                        if (index > indexDataRevisi) {
                            let indexIdz = detailRevisiCheck.findIndex((val) => val.number == item[3])
                            if (indexIdz !== -1) {
                                detailRevisiCheck.splice(indexIdz, 1)
                            }
                        }
                    })
                    detailRevisiCheck.splice(indexId, 1)
                }
            }
            this.setState({ detailRevisiCheck: detailRevisiCheck.sort((a, b) => a.number - b.number) })
            // // console.log(detailRevisiCheck)
        }

        const options = {
            filter: false,
            sort: false,
            responsive: "scroll",
            print: false,
            download: false,
            selectableRows: false,
            viewColumns: false,
            pagination: false,
            search: false
        }
        const optionsHistory = {
            filter: false,
            sort: false,
            responsive: "scroll",
            print: false,
            download: false,
            selectableRows: false,
            viewColumns: false,
            pagination: true,
            search: false,
            rowsPerPage: 5
        }

        const optionsRevision = {
            filter: false,
            sort: false,
            responsive: "scroll",
            print: false,
            download: false,
            selectableRows: false,
            viewColumns: false,
            pagination: false,
            search: false
        }
        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );
        const mstIdFinance = this.state?.rowDataFinance?.length > 0 && this.state.rowDataFinance[0]?.master_report_type_id
        const mstIdCAT = this.state?.rowDataCAT?.length > 0 && this.state.rowDataCAT[0]?.master_report_type_id
        return (
            <div style={{ flex: 1, backgroundColor: '#f8f8f8' }} >
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {this.state.loading && loadingComponent}
                {this.state.visibleBudgetTahunan && (
                    <div>
                        <div className={"main-color"} style={{ height: 78, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                            <Typography style={{ fontSize: '16px', color: 'white' }}>Master Budget & CAT Submission</Typography>
                        </div>
                        <div style={{ padding: 20, width: '100%' }}>
                            <Paper style={{ paddingTop: 10 }}>
                                <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                    <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Master Budget</Typography>
                                </div>
                                <div style={{ padding: 20 }}>
                                    {this.renderFilter()}

                                    <div style={{ marginTop: 20 }}>
                                        <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '16px', color: '#4b4b4b', fontWeight: 'bold' }}>Report Finance</Typography>
                                            <div style={{ display: 'flex', margin: '24px 5px' }}>
                                                <button
                                                    className="button"
                                                    type="button"
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        outline: 'none',
                                                        marginRight: 20
                                                    }}
                                                    onClick={() => this.handleSelectAll(this.state.dataTable)}
                                                >
                                                    <div style={{ backgroundColor: '#fff', width: 100, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                        <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Check All</Typography>
                                                    </div>
                                                </button>
                                                <button
                                                    type="button"
                                                    disabled={this.state.buttonError}
                                                    onClick={() => this.state.selectReport.length > 0 ? this.handleDownloadReport(this.state.dataTable) : alert("Anda harus memilih report yang ingin di download terlebih dahulu!")}
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        borderColor: 'transparent',
                                                        outline: 'none',
                                                    }}
                                                >
                                                    <div style={{ backgroundColor: '#354960', width: 100, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                        <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Download</Typography>
                                                    </div>
                                                </button>
                                            </div>
                                        </div>
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={this.state.dataTable}
                                                columns={columns('FINANCE')}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    </div>
                                    {this.renderAttachment()}
                                    {this.renderHistoryInfo(mstIdFinance)}
                                    {this.state.visibleTableHistory && (
                                        <div style={{ marginTop: 20 }}>
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={this.state.dataTableHistory}
                                                    columns={columnsHistory}
                                                    options={optionsHistory}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                {this.state.checkApprover && this.state.isApproverFinance && this.renderBtnSubmit(mstIdFinance)}
                                <div style={{ padding: '0 20px 20px' }}>
                                    <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
                                        <Typography style={{ fontSize: '16px', color: '#4b4b4b', fontWeight: 'bold' }}>Report CAT</Typography>
                                        <div style={{ display: 'flex', margin: '24px 5px' }}>
                                            <button
                                                type="button"
                                                disabled={this.state.buttonError}
                                                onClick={() => this.state.selectReport.length > 0 ? this.handleDownloadReport(this.state.dataTableCAT) : alert("Anda harus memilih report yang ingin di download terlebih dahulu!")}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 100, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Download</Typography>
                                                </div>
                                            </button>
                                        </div>
                                    </div>
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={this.state.dataTableCAT}
                                            columns={columns('CAT')}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                    {this.renderAttachment()}
                                    {this.renderHistoryInfo(mstIdCAT)}
                                    {this.state.visibleTableHistoryCAT && (
                                        <div style={{ marginTop: 20 }}>
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={this.state.dataTableHistoryCAT}
                                                    columns={columnsHistory}
                                                    options={optionsHistory}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                {this.state.checkApprover && this.state.isApproverCAT && this.renderBtnSubmit(mstIdCAT)}
                            </Paper>
                        </div>
                    </div>
                )
                }

                {
                    this.state.visibleUpload && (
                        <div className="test app-popup-show">
                            <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                                <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                    <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                        <div className="popup-title">
                                            <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                        </div>
                                    </div>
                                    <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                        <button
                                            type="button"
                                            className="btn btn-circle btn-white"
                                            onClick={() => this.setState({ visibleUpload: false })}
                                        >
                                            <img src={Images.close} />
                                        </button>
                                    </div>
                                </div>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => this.uploadAttachment(this.state.formData)}
                                />
                            </div>
                        </div>
                    )
                }

                {
                    this.state.visibleBS && (
                        <BalanceSheet
                            open={this.props.open}
                            report_id={this.state.report_id}
                            height={this.props.height}
                            width={this.props.width}
                            company={this.state.company}
                            defaultCurrency={this.state.defaultCurrency}
                            currency={this.state.currency}
                            revision={this.state.revisionTable}
                            periode={this.state.periode.periode}
                            submissionID={this.state.submissionID}
                            saveToMasterBudget={this.saveToMasterBudget.bind(this)}
                            onClickClose={() => this.setState({ visibleBS: false, visibleBudgetTahunan: true })}
                            getReport={this.getSubmission.bind(this)}
                            isApprover={this.state.isApprover}
                            truelyApprover={this.state.truelyApprover}
                            lastStatus={this.getLastStatus()}
                            prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                            status={this.state.status}
                        />
                    )
                }
                {
                    this.state.visiblePL && (
                        <ProfitLoss
                            open={this.props.open}
                            report_id={this.state.report_id}
                            height={this.props.height}
                            width={this.props.width}
                            company={this.state.company}
                            defaultCurrency={this.state.defaultCurrency}
                            currency={this.state.currency}
                            revision={this.state.revisionTable}
                            periode={this.state.periode.periode}
                            submissionID={this.state.submissionID}
                            saveToMasterBudget={this.saveToMasterBudget.bind(this)}
                            onClickClose={() => this.setState({ visiblePL: false, visibleBudgetTahunan: true })}
                            getReport={this.getSubmission.bind(this)}
                            status={this.state.status}
                            isApprover={this.state.isApprover}
                            truelyApprover={this.state.truelyApprover}
                            lastStatus={this.getLastStatus()}
                            prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        />
                    )
                }
                {
                    this.state.visibleTP && (
                        <TaxPlanning
                            open={this.props.open}
                            report_id={this.state.report_id}
                            height={this.props.height}
                            width={this.props.width}
                            company={this.state.company}
                            defaultCurrency={this.state.defaultCurrency}
                            currency={this.state.currency}
                            revision={this.state.revisionTable}
                            periode={this.state.periode.periode}
                            submissionID={this.state.submissionID}
                            saveToMasterBudget={this.saveToMasterBudget.bind(this)}
                            onClickClose={() => this.setState({ visibleTP: false, visibleBudgetTahunan: true })}
                            getReport={this.getSubmission.bind(this)}
                            status={this.state.status}
                            isApprover={this.state.isApprover}
                            truelyApprover={this.state.truelyApprover}
                            lastStatus={this.getLastStatus()}
                            prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        />
                    )
                }
                {
                    this.state.visibleFAM && (
                        <FixedAssetsMovement
                            open={this.props.open}
                            report_id={this.state.report_id}
                            height={this.props.height}
                            width={this.props.width}
                            company={this.state.company}
                            defaultCurrency={this.state.defaultCurrency}
                            currency={this.state.currency}
                            revision={this.state.revisionTable}
                            periode={this.state.periode.periode}
                            submissionID={this.state.submissionID}
                            saveToMasterBudget={this.saveToMasterBudget.bind(this)}
                            onClickClose={() => this.setState({ visibleFAM: false, visibleBudgetTahunan: true })}
                            getReport={this.getSubmission.bind(this)}
                            status={this.state.status}
                            isApprover={this.state.isApprover}
                            truelyApprover={this.state.truelyApprover}
                            lastStatus={this.getLastStatus()}
                            prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        />
                    )
                }
                {
                    this.state.visibleCAT && (
                        <CorporateAnnualTarget
                            open={this.props.open}
                            report_id={this.state.report_id}
                            height={this.props.height}
                            width={this.props.width}
                            company={this.state.company}
                            defaultCurrency={this.state.defaultCurrency}
                            currency={this.state.currency}
                            revision={this.state.revisionTable}
                            periode={this.state.periode.periode}
                            submissionID={this.state.submissionID}
                            saveToMasterBudget={this.saveToMasterBudget.bind(this)}
                            onClickClose={() => this.setState({ visibleCAT: false, visibleBudgetTahunan: true })}
                            getReport={this.getSubmission.bind(this)}
                            isApprover={this.state.isApprover}
                            truelyApprover={this.state.truelyApprover}
                            status={this.state.status}
                            // status={'not-yet'}
                            lastStatus={this.getLastStatus()}
                            // lastStatus={'SUBMIT'}
                            // prevRevision={false}
                            prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                        />
                    )
                }
                {
                    this.state.visibleCF && (
                        <CashFlow
                            open={this.props.open}
                            report_id={this.state.report_id}
                            height={this.props.height}
                            width={this.props.width}
                            company={this.state.company}
                            defaultCurrency={this.state.defaultCurrency}
                            currency={this.state.currency}
                            revision={this.state.revisionTable}
                            periode={this.state.periode.periode}
                            submissionID={this.state.submissionID}
                            saveToMasterBudget={this.saveToMasterBudget.bind(this)}
                            onClickClose={() => this.setState({ visibleCF: false, visibleBudgetTahunan: true })}
                            getReport={this.getSubmission.bind(this)}
                            isApprover={this.state.isApprover}
                            truelyApprover={this.state.truelyApprover}
                            status={this.state.status}
                            lastStatus={this.getLastStatus()}
                            prevRevision={this.state.isSubmit ? this.state.prevRevision : true}
                            // PLBSFAMSubmitted={false}
                            PLBSFAMSubmitted={this.getLastStatus() == 'APPROVED' ? true : false}
                            createCashFlow={this.createCashFlow.bind(this)}
                        />
                    )
                }

                {
                    this.state.visibleRevision && (
                        <div className="test app-popup-show">
                            <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                                <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                    <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                        <div className="popup-title">
                                            <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Revision</span>
                                        </div>
                                    </div>
                                    <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                        <button
                                            type="button"
                                            className="btn btn-circle btn-white"
                                            onClick={() => this.setState({ visibleRevision: false, currentMasterReportTypeId: null })}
                                        >
                                            <img src={Images.close} />
                                        </button>
                                    </div>
                                </div>
                                <div className="border-bottom" style={{ padding: 20 }}>
                                    <span>You ask your subsidiary to make a revision</span>
                                    <div style={{ marginTop: 20 }}>
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={this.state.currentMasterReportTypeId === 2 ? this.state.dataTableRevisionCAT : this.state.dataTableRevision}
                                                columns={columnRevisi(this.state.currentMasterReportTypeId)}
                                                options={optionsRevision}
                                            />
                                        </MuiThemeProvider>
                                    </div>
                                    <div style={{ marginTop: 20 }}>
                                        <span>Timing duration you give for revision:</span>
                                        <div style={{ display: 'flex', justifyContent: 'space-between', marginTop: 20 }}>
                                            <div>
                                                <DatePicker
                                                    margin="normal"
                                                    id="startDate"
                                                    label="Valid From"
                                                    format="dd-MM-yyyy"
                                                    onChange={(e) => this.setState({ minDateRevision: moment(e).format('YYYY/MM/DD') }, () => this.setState({ maxDateRevision: handleMaxDate() }))}
                                                    value={moment(this.state.minDateRevision).format('YYYY/MM/DD')}
                                                    KeyboardButtonProps={{
                                                        'aria-label': 'change date',
                                                    }}
                                                    inputProps={{
                                                        style: {
                                                            fontSize: 11
                                                        }
                                                    }}
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            color: '#7e8085'
                                                        }
                                                    }}

                                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                                />
                                            </div>
                                            <span style={{ alignSelf: 'center' }}>Until</span>
                                            <div>
                                                <DatePicker
                                                    margin="normal"
                                                    id="startDate"
                                                    label="Valid To"
                                                    format="dd-MM-yyyy"
                                                    onChange={(e) => this.setState({ maxDateRevision: moment(e).format('YYYY/MM/DD') })}
                                                    minDate={moment(this.state.minDateRevision).format('YYYY/MM/DD')}
                                                    value={moment(this.state.maxDateRevision).format('YYYY/MM/DD')}
                                                    KeyboardButtonProps={{
                                                        'aria-label': 'change date',
                                                    }}
                                                    inputProps={{
                                                        style: {
                                                            fontSize: 11
                                                        }
                                                    }}
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            color: '#7e8085'
                                                        }
                                                    }}

                                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                                />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                                    <div className="column-1" style={{ alignSelf: 'center' }}>
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ visibleRevision: false, currentMasterReportTypeId: null })}
                                        >
                                            <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                                        <button
                                            type="button"
                                            onClick={() => this.validateRevision(this.state.currentMasterReportTypeId)}
                                        >
                                            <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                <span style={{ color: '#fff', fontSize: 11 }}>Revision</span>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }

                {this.state.visibleApproveSuperadmin && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Superadmin Approve</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleApproveSuperadmin: false, currentMasterReportTypeId: null })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div className="border-bottom" style={{ padding: 20 }}>
                                <span>Choose approver you want</span>
                                <div style={{ marginTop: 20 }}>
                                    <Autocomplete
                                        {...this.state.listApprover}
                                        id="periode"
                                        onChange={(event, newInputValue) => this.setState({ approver: newInputValue })}
                                        disabled={false}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) =>
                                            <TextField {...params} label="Approver" margin="normal" style={{ marginTop: 7 }}
                                            />}
                                        value={this.state.approver}
                                    />
                                </div>
                            </div>
                            <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1" style={{ alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ visibleApproveSuperadmin: false, currentMasterReportTypeId: null })}
                                    >
                                        <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                        </div>
                                    </button>
                                </div>
                                <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.state.approver == null ? this.setState({ alert: true, messageAlert: 'Approver Cannot be Empty', tipeAlert: 'error' }) : this.setHeaderTokenSuperadmin('approve', this.state.currentMasterReportTypeId)}
                                    >
                                        <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#fff', fontSize: 11 }}>Confirm  Approve</span>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

                {this.state.popupDownload && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#D9D9D9', borderRadius: 10, width: 609, height: 276 }}>
                            <div>
                                <div style={{ justifyContent: 'center', fontSize: 20, color: '#33508B', margin: '70px 20px' }}>Download Master Budget {this.state.company.company_name} {this.state.periode.periode} In Progress, silahkan cek status dan unduh report di menu <b>Download Report</b></div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 3
                                        }}
                                        onClick={() => this.setState({ popupDownload: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div >
        );
    }
}