import React, { Component } from 'react';
import Images from '../../../assets/Images';
import { Typography } from '@material-ui/core';
import api from "../../../api";
import Constant from '../../../library/Constant';

export default class DeletePerusahaan extends Component {
    constructor(props) {
        super(props)
        this.state = {
            companyID: '',
            company: null,
        }
    }

    componentDidMount() {
        if (this.props.type === 'delete') {
            this.getDetailPerusahaan()
        }
    }

    getDetailPerusahaan() {
        api.create().getDetailPerusahaan(this.props.data[1]).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        let data = response.data.data
                        this.setState({
                            companyID: data.company_id,
                            company: data.company_name,
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }   
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }            
        })
    }

    delete() {
        if (this.props.type == 'delete') {
            let payload = this.state.id
            this.props.deleteCompany(payload)
        }
    }
    
    render() {
        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8, padding: 50 }}>
                    <div style={{ display: 'flex', justifyContent: 'center' }}>
                        <img src={Images.failedCopy} />
                    </div>
                    <div style={{ display: 'grid', justifyContent: 'center', marginTop: 20 }}>
                        <span style={{ textAlign: 'center', fontSize: 14, fontWeight: 'bold' }}>
                            Delete {this.state.company} ?
                        </span>
                    </div>
                    <div style={{ display: 'flex', justifyContent: 'center', marginTop: 24 }}>
                        <button
                            className={"btn-save"}
                            onClick={()=> this.props.onClickClose()}
                        >
                            <span style={{ color: 'white' }}>Cancel</span>
                        </button>
                        <button
                            className={"btn-save"}
                            style={{ marginLeft: 50}}
                            onClick={()=> this.delete()}
                        >
                            <span style={{ color: 'white' }}>Delete</span>
                        </button>
                    </div>
                </div>
            </div>
        );
    }
}
