import React, { Component } from 'react';
import { Container, Row, Col } from "react-bootstrap";
import { makeStyles, createMuiTheme, MuiThemeProvider } from '@material-ui/core/styles';
import { TextField, InputBase, Snackbar, withStyles, Tooltip } from "@material-ui/core";
import { ExcelRenderer } from 'react-excel-renderer';
import Images from '../../assets/Images';
import MUIDataTable from "mui-datatables";
import ReactTooltip from 'react-tooltip';
import MuiAlert from '@material-ui/lab/Alert';
import UploadFile from "../../library/Upload";
import CreateApprovalMatrix from "./CreateApprovalMatrix";
import EditApprovalMatrix from "./EditApprovalMatrix";
import VisualisasiAM from "./VisualisasiAM";
import DeleteApprovalMatrix from "./DeleteApprovalMatrix";
import PopUpFailedSave from "../../library/PopUpFailedSave";
import api from "../../api";
import Constant from '../../library/Constant';
import { css } from "@emotion/core";
import PropagateLoader from "react-spinners/PropagateLoader"

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());
const options = ct.customOptions();
const options2 = ct.customOptions2();

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class ApprovalMatrix extends Component {
    constructor(props) {
        super(props)
        this.state = {
            visibleAM: true,
            visibleCreate: false,
            visibleEdit: false,
            visibleVisual: false,
            dataTable: [],
            listData: [],
            data: [],
            search: "",
            cols: null,
            rows: null,
            dataLoaded: false,
            popupError: false,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            btncreate: false,
            btnedit: false,
            btndelete: false,
            load: false,
            judul: '',
            popupDel: false,
            loading: false
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                let payload = []
                isi.map((item, index) => {
                    if (item.length > 0) {
                        payload.push({
                            id: index + 1,
                            approval_type_name: item[0] === undefined ? "" : item[0],
                            orders: item[1] === undefined ? null: item[1],
                            email: item[2] === undefined ? "" : item[2],
                            // fullname: item[2] === undefined ? "" : item[2],
                            operator_type_name: item[3] === undefined ? "" : item[3],
                            start_date: item[4] === undefined ? "" : item[4],
                            end_date: item[5] === undefined ? "" : item[5],
                        })
                    }
                })
                let body = {
                    approval_matrix: payload
                }
                this.setState({ payload: body, buttonError: false, judul: resp.rows[1][0] })
                // console.log(this.state.payload)
            }
        });
    }

    checkUpload(){
        api.create().checkUploadAM(this.state.payload).then(response => {
            // console.log(response)
            let dataRow = []
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        dataRow = response.data.data.map((item, index) => {
                            return [
                                item.approval_type_name,
                                item.orders,
                                item.email,
                                item.fullname,
                                item.operator_type_name,
                                item.start_date,
                                item.end_date,
                                item.error
                            ]
                        })
                        let columns = [
                            {
                                name: "Approval Type",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('approval_type_name'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="approvaltype">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="approvaltype" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Order",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('orders'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <a data-tip={tableMeta.rowData[7][check].message} data-for="order">
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === null ? "Empty" : val}</span>
                                                    </a> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === null ? "Empty" : val}</span>
                                                }
                                                <ReactTooltip border={true} id="order" place="bottom" type="light" effect="solid" />
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Approver Email",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('email'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[7][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Approver Name",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('fullname'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[7][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Operator",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('operator_type_name'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[7][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid From",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('start_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[7][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid To",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[7] != null) {
                                            check = tableMeta.rowData[7].findIndex((val) => val.field.includes('end_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[7] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[7][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "",
                                options: {
                                    display: false
                                }
                            }
                        ]

                        // console.log(dataRow);
                        this.setState({
                            dataLoaded: true,
                            cols: columns,
                            rows: dataRow, visibleUpload: false, 
                            visibleAM: false
                        });
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({
                    dataLoaded: false,
                    alert: true, messageAlert: response.problem, tipeAlert: 'error'
                });
            }
        })
    }

    componentDidMount() {
        this.getData()
        this.getPermission()
    }

    getPermission() {
        let payload = {
            menu: "approval matrix"
        }
        api.create().getPermission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        btncreate: response.data.data.create,
                        btnedit: response.data.data.edit,
                        btndelete: response.data.data.delete,
                        load: true
                    })
                } else {
                    this.setState({
                        load: true
                    })
                }
            } else {
                this.setState({ load: true })
            }
        })
    }

    getData() {
        this.setState({loading: true})
        api.create().getAM().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.sort((a, b) => a.approval_matrix_id - b.approval_matrix_id).map((item, index) => {
                            return [index, item.approval_matrix_id, item.approval_type_name, item.orders, item.fullname, item.operator_type_name, item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data }, () => {
                            setTimeout(() => {
                              this.setState({loading: false})
                            }, 2000);
                          })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    openPopUp(index, type) {
        if (type === 'edit') {
            this.setState({
                rowData: index,
                visibleEdit: true
            })
        } else if (type === 'delete') {
            this.setState({
                rowData: index,
                popupDel: true
            })
        }
        else {
            this.setState({
                visibleCreate: true
            })
        }
    }

    handleInputChange(e) {
        this.setState({ search: e })
        let body = {
            "keyword": e
        }
        api.create().searchAM(body).then(response => {
            // console.log(response.data);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.map((item, index) => {
                            return [index, item.approval_matrix_id, item.approval_type_name, item.orders, item.fullname, item.operator_type_name, item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    createAM = (payload) => {
        this.setState({ visibleCreate: false })
        api.create().createAM(payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    updateAM = (payload) => {
        this.setState({ visibleEdit: false })
        api.create().updateAM(payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    updateVAM = (payload) => {
        this.setState({ visibleVisual: false, visibleAM: true })
        api.create().updateVAM(payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    downloadFile = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/attachment/download_file?fileName=ApprovalMatrixTemplate&&fileType=xlsx`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Approval Matrix.xlsx';
            a.click();
        }
    }

    downloadDataTable = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/approval_matrix/export_approval_matrix`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Approval Matrix.xlsx';
            a.click();
        }
    }

    uploadAM() {
        api.create().uploadAM(this.state.payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.getData()
                        this.setState({ visibleAM: true, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    deleteAM = (payload) => {
        this.setState({ popupDel: false })
        api.create().deleteAM(payload).then(response => {
            // console.log(response.data)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    render() {
        const columns = [{
            name: "Action",
            options: {
                filter: false,
                sort: false,
                customBodyRender: (val, tableMeta) => {
                    // console.log(tableMeta)
                    return (
                        <div style={{ display: 'flex' }}>
                            {this.state.btnedit && <span>
                                <a data-tip={'Edit'} data-for="edit">
                                <button
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: 'pointer',
                                        borderColor: 'transparent',
                                        marginRight: 15
                                    }}
                                    // onClick={() => console.log(tableMeta)}
                                    onClick={() => this.openPopUp(tableMeta.rowData, 'edit')}
                                    >
                                        <img src={Images.editCopy} />
                                    </button>
                                </a>
                                <ReactTooltip border={true} id="edit" place="bottom" type="light" effect="solid" />
                            </span>}
                            {this.state.btndelete && <span>
                                <a data-tip={'Delete'} data-for="delete">
                                <button
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: 'pointer',
                                        borderColor: 'transparent',
                                    }}
                                    // onClick={() => console.log(tableMeta)}
                                    onClick={() => this.openPopUp(tableMeta.rowData, 'delete')}
                                    >
                                        <img src={Images.delete} />
                                    </button>
                                </a>
                                <ReactTooltip border={true} id="delete" place="bottom" type="light" effect="solid" />
                            </span>}
                        </div >
                    );
                }
            }
        },
        {
            name: "ID",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[6] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Approval Type",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[6] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Order",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[6] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Approver Name",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[6] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Operator",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[6] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Status",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[6] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }]
        const loadingComponent = (
            <div style={{position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)'}}>
              <PropagateLoader
                // css={override}
                size={20}
                color={"#274B80"}
                loading={this.state.loading}
              />
            </div>
          );
        return (
            <div>
                {this.state.visibleAM === true ?
                    this.state.load && (
                    <div style={{ height: this.props.height }}>
                        <div className={"main-color"} style={{ height: 195, width: '100%' }} />
                        <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                            <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                                {this.state.messageAlert}
                            </Alert>
                        </Snackbar>
                        <div>
                            <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -182 }}>
                                <label style={{ width: '50%', color: 'white', fontSize: 16, alignSelf: 'center' }}>Master Data - Approval Matrix</label>
                                {/* <div style={{ color: 'white', width: '50%', height: 37, display: 'flex', backgroundColor: 'white', borderWidth: 2, alignItems: 'center', borderRadius: 6, paddingLeft: 5, paddingRight: 5, alignSelf: 'center' }}>
                                    <img src={Images.searchBlack} style={{ marginRight: 10 }} />
                                    <InputBase
                                        style={{ width: '100%' }}
                                        placeholder="Search"
                                        value={this.state.search}
                                        onChange={(e) => this.handleInputChange(e.target.value)}
                                        inputProps={{ 'aria-label': 'naked' }}
                                    />
                                </div> */}
                                <div style={{ width: '50%', justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                    <a data-tip={'Download Template'} data-for="template">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadFile()}
                                        >
                                            <img src={Images.template} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                    {this.state.btncreate && (
                                        <a data-tip={'Upload'} data-for="upload">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => this.setState({ visibleUpload: true })}
                                            >
                                                <img src={Images.upload} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                    <a data-tip={'Download'} data-for="download">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadDataTable()}
                                        >
                                            <img src={Images.download} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                        <a data-tip={'Visualization'} data-for="visualisasi">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => this.setState({ visibleVisual: true, visibleAM: false })}
                                            >
                                                <img src={Images.visualisasi} />
                                            </button>
                                        </a>
                                    <ReactTooltip border={true} id="visualisasi" place="bottom" type="light" effect="solid" />
                                    {this.state.btncreate && (
                                        <a data-tip={'Add New'} data-for="create">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5,
                                                    marginRight: 20
                                                }}
                                                onClick={() => this.setState({ visibleCreate: true })}
                                            >
                                                <img src={Images.add} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="create" place="bottom" type="light" effect="solid" />
                                </div >
                            </div>
                            <div style={{ padding: 25, width: '100%' }}>
                                {this.state.loading && loadingComponent}
                                <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        theme={getMuiTheme()}
                                        data={this.state.dataTable}
                                        columns={columns}
                                        options={options}
                                    />
                                </MuiThemeProvider>
                            </div>
                        </div>
                    </div>
                    )
                    :
                    this.state.visibleVisual == true ?
                        <VisualisasiAM
                            btncreate={this.state.btncreate}
                            btnedit={this.state.btnedit}
                            onClickClose={() => this.setState({ visibleVisual: false, visibleAM: true })}
                            height={this.props.height}
                            updateVAM={this.updateVAM.bind(this)}
                        />
                    :
                        <div style={{ height: this.props.height }}>
                            <div class="main-color" style={{ height: 195, width: '100%' }} />
                            <div>
                                <div>
                                    <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -165 }}>
                                        <label style={{ color: 'white', fontSize: 16, alignSelf: 'center' }}>Preview Data</label>
                                    </div>
                                    <div style={{ padding: 25 }}>
                                        {this.state.dataLoaded && (
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    theme={getMuiTheme()}
                                                    data={this.state.rows}
                                                    columns={this.state.cols}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        )}
                                    </div>
                                    <div style={{ display: 'flex', width: '100%', placeContent: 'flex-end', padding: 20 }}>
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ visibleAM: true })}
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError == true ? { buttonError: true, cursor: 'none' } : false}
                                            disabled={this.state.buttonError == true ? true : false}
                                            // onClick={() => this.state.buttonError ? this.setState({ popupError: true }) : this.uploadAM()}
                                            onClick={() => this.uploadAM()}
                                            style={{}}
                                        >
                                            <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                }

                {this.state.visibleCreate && (
                    <CreateApprovalMatrix
                        onClickClose={() => this.setState({ visibleCreate: false })}
                        data={this.state.listData}
                        createAM={this.createAM.bind(this)}
                    />
                )}
                {this.state.visibleEdit && (
                    <EditApprovalMatrix
                        type={"edit"}
                        onClickClose={() => this.setState({ visibleEdit: false })}
                        data={this.state.rowData}
                        updateAM={this.updateAM.bind(this)}
                    />
                )}
                {this.state.popupDel && (
                    <DeleteApprovalMatrix
                        type={"delete"}
                        onClickClose={() => this.setState({ popupDel: false })}
                        data={this.state.rowData}
                        // getList={() => this.getData.bind(this)}
                        deleteAM={this.deleteAM.bind(this)}
                    />
                )}
                {this.state.popupError && (
                    <PopUpFailedSave onClickClose={() => this.setState({ popupError: false })} />
                )}
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                // onUpload={() => this.setState({ visibleUpload: false, visibleAM: false })}
                                onUpload={() => {
                                    String(this.state.judul).includes("APPROVAL") && String(this.state.judul).includes("MATRIX") ?
                                        this.checkUpload() :
                                        this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                }}
                            />
                        </div>
                    </div>
                )}
            </div>
        );
    }
}
