import React, { Component } from 'react';
import { TextField, Typography } from '@material-ui/core';
import { DateTimePicker, KeyboardDatePicker, DatePicker } from "@material-ui/pickers";
import Autocomplete from '@material-ui/lab/Autocomplete';
import * as R from 'ramda'
import format from "date-fns/format";
import localeID from "date-fns/locale/id"
import api from "../../api";
import Images from '../../assets/Images';
import Constant from '../../library/Constant';
import AutocompleteField from '../../library/AutocompleteField';
import { fetchMasterReportType } from '../../utils/services';

export default class CreateApprovalMatrix extends Component {
    constructor(props) {
        super(props)
        this.state = {
            userId: null,
            typeId: null,
            operatorId: null,
            order: '',
            approvedBy: null,
            types: null,
            operators: null,
            startDate: null,
            endDate: null,
            userData: [],
            value: null,
            date: new Date(),
            errorOrder: false,
            msgErrOrder: '',
            errorType: false,
            msgErrType: '',
            errorApproved: false,
            msgErrApproved: '',
            errorOperator: false,
            msgErrOperator: '',
            errorStartDate: false,
            errorEndDate: false,
            msgErrorStartDate: "",
            msgErrorEndDate: "",

            master_report_type_id: null,
            listMasterReportType: [],
            errorMasterReportTypeId: false,
            msgErrMasterReportTypeId: '',
        }
    }

    componentDidMount() {
        this.getUserData()
        this.getTypeData()
        this.getOperatorData()
        this.getMasterBudgetType()
        let date = format(new Date, 'yyyy-MM-dd')
        this.setState({
            startDate: date,
            endDate: date
        })
    }

    getMasterBudgetType = async () => {
        const { data } = await fetchMasterReportType();

        if (data) {
            const list = data.map((item) => ({
                id: item.master_report_type_id,
                name: item.master_report_type_name
            }));
            this.setState({ listMasterReportType: list });
        } else {
            this.setState({ listMasterReportType: [] });
        }
    }

    getUserData() {
        api.create().getApprovedByAM().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let userData = data.map((item) => {
                            return {
                                user_id: item.user_id,
                                fullname: item.fullname == null ? "(NO_NAME)" : item.fullname
                            }
                        })
                        let defaultProps = {
                            options: userData,
                            getOptionLabel: (option) => option.fullname,
                        };
                        this.setState({ approvedBy: defaultProps, userData: response.data.data })
                    } else {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            })
                        } else {
                            this.setState({ alert: true, messageAlert: 'Approver Name: ' + response.data.message, tipeAlert: 'error' })
                        }
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getTypeData() {
        api.create().getTypeAM().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                approval_type_id: item.approval_type_id,
                                approval_type_name: item.approval_type_name
                            }
                        })
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.approval_type_name,
                        };
                        this.setState({ types: typeProps, typeData: response.data.data })
                    } else {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            })
                        } else {
                            this.setState({ alert: true, messageAlert: 'Approval Type: ' + response.data.message, tipeAlert: 'warning' })
                        }
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getOperatorData() {
        api.create().getOperatorAM().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let operatorData = data.map((item) => {
                            return {
                                operator_type_id: item.operator_type_id,
                                operator_type_name: item.operator_type_name
                            }
                        })
                        let operatorProps = {
                            options: operatorData,
                            getOptionLabel: (option) => option.operator_type_name,
                        };
                        this.setState({ operators: operatorProps, operatorData: response.data.data })
                    } else {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            })
                        } else {
                            this.setState({ alert: true, messageAlert: 'Operator: ' + response.data.message, tipeAlert: 'warning' })
                        }
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({ startDate: format(e, 'yyyy-MM-dd'), endDate: null }, () => {
                this.clearError()
                // console.log(this.state.startDate)
            })
        } else if (isDate && type == 'end_date') {
            this.setState({ endDate: format(e, 'yyyy-MM-dd') }, () => {
                this.clearError()
                // console.log(this.state.endDate)
            })
        } else {
            // this.setState({...data, tempData: {...this.state.tempData, [e.target.name] :  e.target.value}})
        }

    }

    handleChangeDropdown = (newValue, name) => {
        this.setState(prevState => ({
            ...prevState,
            [name]: newValue,
        }), () => {
            this.clearError();
        })
    }

    clearError() {
        this.setState({
            errorOrder: false,
            msgErrOrder: "",
            errorType: false,
            msgErrType: '',
            errorApproved: false,
            msgErrApproved: '',
            errorOperator: false,
            msgErrOperator: '',
            errorStartDate: false,
            errorEndDate: false,
            msgErrorStartDate: "",
            msgErrorEndDate: "",
            errorMasterReportTypeId: false,
            msgErrMasterReportTypeId: '',
        })
    }

    validasi() {
        if (R.isNil(this.state.typeId)) {
            this.setState({ errorType: true, msgErrType: 'Approval Type Cannot be Empty' })
        }
        else if (R.isEmpty(this.state.order)) {
            this.setState({ errorOrder: true, msgErrOrder: 'Order Cannot be Empty' })
        }
        else if (R.isNil(this.state.userId)) {
            this.setState({ errorApproved: true, msgErrApproved: 'Approver Name Cannot be Empty' })
        }
        else if (R.isNil(this.state.operatorId)) {
            this.setState({ errorOperator: true, msgErrOperator: 'Operator Cannot be Empty. Please Choose - Option' })
        }
        else if (R.isNil(this.state.master_report_type_id)) {
            this.setState({ errorMasterReportTypeId: true, msgErrMasterReportTypeId: 'Master Report Type Cannot be Empty. Please Choose - Option' })
        }
        else if (R.isNil(this.state.startDate)) {
            this.setState({ errorStartDate: true, msgErrorStartDate: 'Valid From Cannot be Empty' })
        } else if (R.isNil(this.state.endDate)) {
            this.setState({ errorEndDate: true, msgErrorEndDate: 'Valid To Cannot be Empty' })
        } else {
            let payload = {
                "approval_type_id": this.state.typeId.approval_type_id,
                "orders": this.state.order,
                "user_id": this.state.userId.user_id,
                "operator_type_id": this.state.operatorId.operator_type_id,
                "master_report_type_id": this.state.master_report_type_id?.id ?? null,
                "start_date": this.state.startDate,
                "end_date": this.state.endDate
            }
            this.props.createAM(payload)
        }
    }

    render() {
        return (
            <div className="test app-popup-show" style={{ paddingTop: 100 }}>
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Create Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>

                    <div className="border-bottom" style={{ padding: 20 }}>
                        <div className="grid grid-2x grid-mobile-none gap-15px">
                            <div className="column-1">
                                <div className="" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                    <TextField
                                        style={{ width: '100%', height: '90%' }}
                                        id="id"
                                        label="ID"
                                        disabled
                                        inputProps={{
                                            style: {
                                                fontSize: 11
                                            }
                                        }}
                                        InputLabelProps={{
                                            style: {
                                                fontSize: 11,
                                                color: '#7e8085'
                                            }
                                        }}
                                    >
                                    </TextField>
                                </div>
                            </div>
                            <div className="column-2">
                                <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.types}
                                        id="tipe"
                                        onChange={(event, newInputValue) => this.setState({ typeId: newInputValue }, () => this.clearError())}
                                        debug
                                        renderInput={(params) =>
                                            <TextField
                                                {...params}
                                                label="Approval Type"
                                                onChange={(e) => this.handleChange(e, '')}
                                                error={this.state.errorType}
                                                helperText={this.state.msgErrType}
                                                InputLabelProps={{
                                                    style: {
                                                        fontSize: 11,
                                                        fontFamily: 'Nunito Sans, sans-serif',
                                                        color: '#7e8085'
                                                    }
                                                }}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                            />
                                        }
                                        value={this.state.typeId}
                                    />
                                </div>
                            </div>
                        </div>
                        <div className="grid grid-2x grid-mobile-none gap-15px">
                            <div className="column-1">
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <TextField
                                        style={{ width: '100%' }}
                                        id="order"
                                        label="Order"
                                        // type={"number"}
                                        value={this.state.order === null ? '' : this.state.order}
                                        error={this.state.errorOrder}
                                        helperText={this.state.msgErrOrder}
                                        // onChange={(e) => this.setState({ order: e.target.value }, () => this.clearError())}
                                        onChange={(e) => {
                                            let coba = String(e.target.value).replace(/[^\d]/g, '');
                                            this.setState({
                                                order: coba
                                            },
                                                () => this.clearError())
                                        }
                                            // this.handleChange(coba, 'value')}
                                        }
                                        inputProps={{
                                            style: {
                                                fontSize: 11
                                            }
                                        }}
                                        InputLabelProps={{
                                            style: {
                                                fontSize: 11,
                                                color: '#7e8085'
                                            }
                                        }}
                                    >
                                    </TextField>
                                </div>
                            </div>
                            <div className="column-2">
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.approvedBy}
                                        id="approvedby"
                                        onChange={(event, newInputValue) => this.setState({ userId: newInputValue }, () => this.clearError())}
                                        // disableClearable
                                        debug
                                        renderInput={(params) =>
                                            <TextField {...params}
                                                label="Approver Name"
                                                onChange={(e) => this.handleChange(e, '')}
                                                error={this.state.errorApproved}
                                                helperText={this.state.msgErrApproved}
                                                InputLabelProps={{
                                                    style: {
                                                        fontSize: 11,
                                                        color: '#7e8085'
                                                    }
                                                }}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            />}
                                        value={this.state.userId}
                                    />
                                </div>
                            </div>
                        </div>
                        <div className="grid grid-2x grid-mobile-none gap-15px">
                            <div className="column-1">
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.operators}
                                        id="operator"
                                        // disableClearable
                                        debug
                                        onChange={(event, newInputValue) => this.setState({ operatorId: newInputValue }, () => this.clearError())}
                                        renderInput={(params) =>
                                            <TextField {...params}
                                                label="Operator"
                                                onChange={(e) => this.handleChange(e, '')}
                                                error={this.state.errorOperator}
                                                helperText={this.state.msgErrOperator}
                                                InputLabelProps={{
                                                    style: {
                                                        fontSize: 11,
                                                        color: '#7e8085'
                                                    }
                                                }}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            />}
                                        value={this.state.operatorId}
                                    />
                                </div>
                            </div>
                            <div className="column-2">
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <AutocompleteField
                                        options={this.state.listMasterReportType}
                                        value={this.state.master_report_type_id}
                                        onChange={(event, newValue) => this.handleChangeDropdown(newValue, 'master_report_type_id')}
                                        label="Master Report Type"
                                        minSizeBox={true}
                                        error={this.state.errorMasterReportTypeId}
                                        helperText={this.state.msgErrMasterReportTypeId}
                                        disableClearable={false}
                                    />
                                </div>
                            </div>
                        </div>
                        <div className="grid grid-2x grid-mobile-none gap-15px">
                            <div className="column-1">
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <DatePicker
                                        margin="normal"
                                        id="startDate"
                                        label="Valid From"
                                        format="dd MMMM yyyy"
                                        value={this.state.startDate == "" ? null : this.state.startDate}
                                        onChange={(e) => this.handleChange(e, 'start_date')}
                                        KeyboardButtonProps={{
                                            'aria-label': 'change date',
                                        }}
                                        inputProps={{
                                            style: {
                                                fontSize: 11
                                            }
                                        }}
                                        InputLabelProps={{
                                            style: {
                                                fontSize: 11,
                                                color: '#7e8085'
                                            }
                                        }}
                                        error={this.state.errorStartDate}
                                        helperText={this.state.msgErrorStartDate}
                                        style={{ padding: 0, margin: 0, width: '100%' }}
                                    />
                                </div>
                            </div>
                            <div className="column-2">
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <DatePicker
                                        margin="normal"
                                        id="endDate"
                                        label="Valid To"
                                        format="dd MMMM yyyy"
                                        value={this.state.endDate == "" ? null : this.state.endDate}
                                        error={this.state.errorEndDate}
                                        helperText={this.state.msgErrorEndDate}
                                        onChange={(e) => this.handleChange(e, 'end_date')}
                                        minDate={this.state.startDate}
                                        KeyboardButtonProps={{
                                            'aria-label': 'change date',
                                        }}
                                        inputProps={{
                                            style: {
                                                fontSize: 11
                                            }
                                        }}
                                        InputLabelProps={{
                                            style: {
                                                fontSize: 11,
                                                color: '#7e8085'
                                            }
                                        }}
                                        style={{ padding: 0, margin: 0, width: '100%' }}
                                    />
                                </div>
                            </div>
                        </div>
                        <div className="grid grid-2x grid-mobile-none gap-15px">
                            <div className="column-1">
                                <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                    <TextField
                                        style={{ width: '100%' }}
                                        id="status"
                                        label="Status"
                                        disabled
                                        defaultValue={"Active"}
                                        inputProps={{
                                            style: {
                                                fontSize: 11
                                            }
                                        }}
                                        InputLabelProps={{
                                            style: {
                                                fontSize: 11,
                                                color: '#7e8085'
                                            }
                                        }}
                                    >
                                    </TextField>
                                </div>
                            </div>
                            {/* <div className="column-2">
                                <div className="margin-top-10px" style={{ marginTop: 8 }}>
                                    <TextField
                                        style={{ width: '100%' }}
                                        id="max-value"
                                        label="Max Value"
                                        // value={this.state.periode}
                                    >
                                    </TextField>
                                </div>
                            </div> */}
                        </div>
                        <div className="margin-top-10px" style={{ paddingTop: 10, paddingBottom: 10, paddingLeft: 10, paddingRight: 30 }}>
                            <Typography style={{ fontSize: 11 }}>{`Created By : `}</Typography>
                            <Typography style={{ fontSize: 11 }}>{`Updated By :`}</Typography>
                        </div>
                    </div>
                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <div onClick={() => this.props.onClickClose()} style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center', cursor: "pointer" }}>
                                <span style={{ color: '#354960', fontSize: 11 }} >Cancel</span>
                            </div>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <div onClick={() => this.validasi()} style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center', cursor: "pointer" }}>
                                <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}
