export function titleCase(text) {
	var value = String(text).replace(/\./g, ' ')
		.replace(/\s/g, ' ')
		.replace(/^(.)/, function ($1) { return $1.toUpperCase(); })
	// .replace(/\s(.)/g, function($1) { return $1.toUpperCase(); })

	return value
}

export function roundMath(number, decimalPlaces) {
	const factorOfTen = Math.pow(10, decimalPlaces)
	return Math.round(number * factorOfTen) / factorOfTen
}

export function fixNumber(num, decimalCount = 2) {
	const output = Math.round((num + Number.EPSILON) * (Math.pow(10, decimalCount))) / (Math.pow(10, decimalCount))
	return output
}

export function downloadFileBlob(fileName, blobData) {
	const url = window.URL.createObjectURL(blobData)
	const a = document.createElement('a')
	a.href = url
	a.download = fileName
	document.body.appendChild(a)
	a.click()
	a.remove()
	window.URL.revokeObjectURL(url)
}