import React from 'react';
import { Typography } from '@material-ui/core';

const SectionHeader = ({
    title,
    subtitle,
    // Styling props
    border = true,
    borderColor = '#c4c4c4',
    borderWidth = '1px',
    borderStyle = 'solid',

    // Typography styling
    titleFontSize = '12px',
    titleColor = '#4b4b4b',
    titleMargin = '10px',
    titleFontWeight = 'normal',

    subtitleFontSize = '10px',
    subtitleColor = '#666',
    subtitleMargin = '5px 10px',

    // Container styling
    containerStyle = {},
    titleStyle = {},
    subtitleStyle = {},

    // Children
    children,
}) => {
    borderStyle = border
        ? {
            borderBottom: `${borderWidth} ${borderStyle} ${borderColor}`,
        }
        : {};

    return (
        <div style={{ ...borderStyle, ...containerStyle }}>
            {/* Title */}
            {title && (
                <Typography
                    style={{
                        fontSize: titleFontSize,
                        color: titleColor,
                        margin: titleMargin,
                        fontWeight: titleFontWeight,
                        ...titleStyle,
                    }}
                >
                    {title}
                </Typography>
            )}

            {/* Subtitle */}
            {subtitle && (
                <Typography
                    style={{
                        fontSize: subtitleFontSize,
                        color: subtitleColor,
                        margin: subtitleMargin,
                        ...subtitleStyle,
                    }}
                >
                    {subtitle}
                </Typography>
            )}

            {/* Custom children */}
            {children}
        </div>
    );
};

export default SectionHeader;