import React, { Component } from "react";
import { createMuiTheme, MuiThemeProvider } from '@material-ui/core/styles';
import Images from "../../../assets/Images";
import MUIDataTable from "mui-datatables";
import { InputBase, Snackbar, Tooltip, withStyles } from "@material-ui/core";
import { ExcelRenderer } from 'react-excel-renderer';
import UploadFile from "../../../library/Upload";
import MuiAlert from '@material-ui/lab/Alert';
import CreateReportItems from "./CreateReportItems";
import EditReportItems from "./EditReportItems";
import VisualReportItems from "./VisualReportItems";
import api from "../../../api";
import ReactTooltip from "react-tooltip";
import PopUpFailedSave from "../../../library/PopUpFailedSave";
import Constant from "../../../library/Constant";
import PopUpDelete from "../../../library/PopUpDelete";
import { css } from "@emotion/core";
import PropagateLoader from "react-spinners/PropagateLoader"

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());
const options = ct.customOptions();
const options2 = ct.customOptions2();

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class ReportItems extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            listData: [],
            data: [],
            search: "",
            itemReport: true,
            visualisasi: false,
            add: false,
            edit: false,
            dataLoaded: false,
            cols: null,
            rows: null,
            popupError: false,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            buttonCreate: false,
            buttonEdit: false,
            buttonDelete: false,
            load: false,
            judul: '',
            reportNameDelete: '',
            visibleDelete: false,
            invalidTemplate: false,
            loading: false
        }
        this.myRef = React.createRef()
        this.fileHandler = this.fileHandler.bind(this);
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                let payload = []
                isi.map((item, index) => {
                    if (item.length > 0) {
                        payload.push({
                            id: index + 1,
                            report: item[0] === undefined ? "" : item[0],
                            company: item[1] === undefined ? "" : item[1],
                            orders: item[2] === undefined ? "" : item[2],
                            description: item[3] === undefined ? "" : item[3],
                            parent: item[4] === undefined ? 0 : item[4],
                            uom: item[5] === undefined ? "" : item[5],
                            weight: item[6] === undefined ? "" : item[6],
                            type_report: item[7] === undefined ? "" : item[7],
                            formula: item[8] === undefined ? "" : item[8],
                            condition_it_should_be: item[9] === undefined ? "" : item[9],
                            condition_if_wrong: item[10] === undefined ? "" : item[10],
                            kpi_type: item[11] === undefined ? "" : item[11],
                            max_ach: item[12] === undefined ? "" : item[12],
                            formula_ytd: item[13] === undefined ? "" : item[13],
                            start_date: item[14] === undefined ? "" : item[14],
                            end_date: item[15] === undefined ? "" : item[15],
                            is_can_convert_value: item[16] === undefined ? "" : item[16] === "Yes" || item[16] === "yes" || item[16] === "YES" ? 1 : 0,
                        })
                    }
                })
                console.log(payload);
                let body = {
                    item_report: payload
                }

                if (resp.rows[2].length !== 17) {
                    this.setState({ invalidTemplate: true })
                } else {
                    this.setState({ invalidTemplate: false })
                }

                console.log(resp.rows[1])
                this.setState({ payload: body, buttonError: false, judul: resp.rows[1][0] })
            }
        });
    }

    checkUpload() {
        api.create().checkUploadReportItems(this.state.payload).then(response => {
            console.log(response)
            let dataRow = []
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        dataRow = response.data.data.map((item, index) => {
                            return [
                                item.report,
                                item.company,
                                item.orders,
                                item.description,
                                item.parent,
                                item.uom,
                                item.weight,
                                item.type_report,
                                item.formula,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.kpi_type,
                                item.max_ach,
                                item.formula_ytd,
                                item.start_date,
                                item.end_date,
                                item.is_can_convert_value == 1 ? "Yes" : "No",
                                item.error,
                            ]
                        })
                        let columns = [
                            {
                                name: "Report Type",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('report_type'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Company Name",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('company'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Order",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('orders'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === null ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Description",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('description'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Parent ID",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('parent'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "UOM",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('uom'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Weight",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('weight'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Data Type",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('type_report'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Formula",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('formula'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "True Value",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('condition_it_should_be'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "False Condition",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('condition_if_wrong'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "KPI Type",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('kpi_type'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Max Achievement",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('max_ach'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Formula YTD",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('formula_ytd'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid From",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('start_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid To",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('end_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Convertible",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[17] != null) {
                                            check = tableMeta.rowData[17].findIndex((val) => val.field.includes('is_can_convert_value'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[17] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[17][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "",
                                options: {
                                    display: false
                                }
                            }
                        ]

                        // console.log(dataRow);
                        this.setState({
                            dataLoaded: true,
                            cols: columns,
                            rows: dataRow, visibleUpload: false,
                            itemReport: false
                        });
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({
                    dataLoaded: false,
                    alert: true, messageAlert: response.problem, tipeAlert: 'error'
                });
            }
        })
    }

    componentDidMount() {
        this.getData()
        this.getPermission()
    }

    getPermission() {
        let payload = {
            menu: "report items"
        }
        api.create().getPermission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        buttonCreate: response.data.data.create,
                        buttonEdit: response.data.data.edit,
                        buttonDelete: response.data.data.delete,
                        load: true
                    })
                } else {
                    this.setState({ load: true })
                }
            }
        })
    }

    getData() {
        this.setState({ loading: true })
        api.create().getReportItems().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.sort((a, b) => a.item_report_id - b.item_report_id).map((item, index) => {
                            return [
                                index, 
                                item.item_report_id, 
                                item.report_name, 
                                item.company_name, 
                                item.order, 
                                item.description, 
                                item.parent !== null ? `${item.parent} - ${item.parent_name}` : "" , 
                                item.uom, 
                                item.weight, 
                                item.type_item_report_name, 
                                item.kpi_type, 
                                item.max_ach, 
                                item.formula_ytd, 
                                item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data }, () => {
                            setTimeout(() => {
                                this.setState({ loading: false })
                            }, 2000);
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    deleteReport(payload) {
        // console.log(payload);
        let id = String(payload[1])
        api.create().deleteReportItems(id).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.getData()
                        this.setState({ visibleDelete: false, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    openPopUp(index, type) {
        if (type === 'edit') {
            this.setState({
                rowData: index,
                edit: true
            })
        } else if (type === 'delete') {
            this.setState({
                rowData: index,
                reportNameDelete: "[" + String(index[2]) + " - " + String(index[3]) + " - " + String(index[5]) + "]",
                visibleDelete: true
            })
        } else {
            this.setState({
                add: true
            })
        }
    }

    handleInputChange(e) {
        this.setState({ search: e })
        let body = {
            "keyword": e
        }
        api.create().searchReportItems(body).then(response => {
            // console.log(response.data);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.map((item, index) => {
                            return [index, item.item_report_id, item.report_name, item.company_name, item.order, item.description, item.parent, item.uom, item.weight, item.type_item_report_name, item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    createReportItems = (payload) => {
        this.setState({ add: false })
        api.create().createReportItems(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    downloadFile = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/attachment/download_file?fileName=ItemReportTemplate&&fileType=xlsx`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Report Item.xlsx';
            a.click();
        }
    }

    downloadDataTable = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/item_report/export_item_report`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Report Items.xlsx';
            a.click();
        }
    }

    updateReportItems = (payload) => {
        this.setState({ edit: false })
        api.create().updateReportItems(payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    uploadReportItems() {
        api.create().uploadReportItems(this.state.payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        // alert(response.data.message)
                        this.getData()
                        this.setState({ itemReport: true, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    scrollToMyRef = () => window.scrollTo(0, this.myRef.current.offsetTop)

    render() {
        const columns = [{
            name: "Action",
            options: {
                sort: false,
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            {this.state.buttonEdit &&
                                <span>
                                    <a data-tip={'Edit'} data-for="edit">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent'
                                            }}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'edit')}

                                        >
                                            <img src={Images.editCopy} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="edit" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                            {this.state.buttonDelete &&
                                <span>
                                    <a data-tip={'Delete'} data-for="delete">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                marginLeft: 15
                                            }}
                                            // onClick={() => console.log(tableMeta)}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'delete')}
                                        >
                                            <img src={Images.delete} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="delete" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                        </div >
                    );
                }
            }
        },
        {
            name: "ID",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Report Type",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Company Name",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Order",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Description",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Parent ID",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "UOM",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Weight",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Data Type",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "KPI Type",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Max Achievement",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Formula YTD",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        },
        {
            name: "Status",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[13] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }
        ]
        const data = [
            ["", "1", "KPI", "TIA", "1", "Financial Perspective", "0", "-", "35%", "Formula", "Aktif"],
            ["", "2", "KPI", "TIA", "2", "Trading Profit", "1", "Rp Bio", "35%", "Formula", "Aktif"],
            ["", "3", "KPI", "TIA", "3", "Revenue", "1", "Rp Bio", "0%", "Formula", "Aktif"],
            ["", "4", "KPI", "TIA", "4", "EBITDA", "1", "Rp Bio", "0%", "Formula", "Non Aktif"],
            ["", "-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );
        return (
            <div style={{ height: this.props.height }} ref={this.myRef}>
                {/* <Row> */}
                <div className={"main-color"} style={{ height: 195, width: '100%' }} />
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {this.state.loading && loadingComponent}
                {this.state.itemReport === true ?
                    this.state.load && (
                        <div>
                            <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -182 }}>
                                <label style={{ color: 'white', fontSize: 16, alignSelf: 'center', width: '50%', }}>Master Data - Report Items</label>
                                {/* <div style={{ color: 'white', width: '50%', height: 37, display: 'flex', backgroundColor: 'white', borderWidth: 2, alignItems: 'center', borderRadius: 6, paddingLeft: 5, paddingRight: 5, alignSelf: 'center' }}>
                                        <img src={Images.searchBlack} style={{ marginRight: 10 }} />
                                        <InputBase
                                            style={{ width: '100%' }}
                                            placeholder="Search"
                                            value={this.state.search}
                                            onChange={(e) => this.handleInputChange(e.target.value)}
                                            inputProps={{ 'aria-label': 'naked' }}
                                        />
                                    </div> */}
                                <div style={{ width: '50%', justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                    <a data-tip={'Download Template'} data-for="template">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadFile()}
                                        >
                                            <img src={Images.template} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                    {this.state.buttonCreate && (
                                        <a data-tip={'Upload'} data-for="upload">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => null}
                                            >
                                                <img src={Images.upload} onClick={() => this.setState({ visibleUpload: true })} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                    <a data-tip={'Download'} data-for="download">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadDataTable()}
                                        >
                                            <img src={Images.download} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                    <a data-tip={'Visualization'} data-for="visualisasi">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.setState({ visualisasi: true, itemReport: false })}
                                        >
                                            <img src={Images.visualisasi} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="visualisasi" place="bottom" type="light" effect="solid" />
                                    {this.state.buttonCreate && (
                                        <a data-tip={'Add New'} data-for="tambah">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5,
                                                    marginRight: 20
                                                }}
                                            >
                                                <img src={Images.add} onClick={() => this.setState({ add: true })} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="tambah" place="bottom" type="light" effect="solid" />
                                </div>
                            </div>
                            <div style={{ padding: 25 }}>
                                <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        theme={getMuiTheme()}
                                        data={this.state.dataTable}
                                        columns={columns}
                                        options={options}
                                    />
                                </MuiThemeProvider>

                            </div>
                        </div>
                    )
                    :
                    this.state.visualisasi == true ?
                        <VisualReportItems
                            buttonCreate={this.state.buttonCreate}
                            buttonEdit={this.state.buttonEdit}
                            onClickClose={() => this.setState({ visualisasi: false, itemReport: true }, () => this.getData())}
                            height={this.props.height}
                            handleLoading={() => this.setState({ loading: true })}
                            scrollToTop={() => this.scrollToMyRef()}
                        />
                        :
                        <div>
                            <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -150 }}>
                                <label style={{ color: 'white', fontSize: 16, alignSelf: 'center' }}>Preview Data</label>
                            </div>
                            <div style={{ padding: 25 }}>
                                <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        theme={getMuiTheme()}
                                        data={this.state.rows}
                                        columns={this.state.cols}
                                        options={options}
                                    />
                                </MuiThemeProvider>
                            </div>
                            <div style={{ display: 'flex', width: '100%', placeContent: 'flex-end', padding: 20 }}>
                                <button
                                    type="button"
                                    onClick={() => this.setState({ itemReport: true })}
                                    style={{ marginRight: 20 }}
                                >
                                    <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                        <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                    </div>
                                </button>
                                <button
                                    type="button"
                                    disabled={this.state.buttonError == true ? true : false}
                                    onClick={() => this.uploadReportItems()}
                                    style={{}}
                                >
                                    <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                        <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                    </div>
                                </button>
                            </div>
                        </div>
                }
                {this.state.add && (
                    <CreateReportItems
                        onClickClose={() => this.setState({ add: false })}
                        data={this.state.listData}
                        refresh={this.getData.bind(this)}
                        createReportItems={this.createReportItems.bind(this)}
                    />
                )}
                {this.state.edit && (
                    <EditReportItems
                        onClickClose={() => this.setState({ edit: false })}
                        data={this.state.rowData}
                        refresh={this.getData.bind(this)}
                        updateReportItems={this.updateReportItems.bind(this)}
                    />
                )}
                {this.state.popupError && (
                    <PopUpFailedSave onClickClose={() => this.setState({ popupError: false })} />
                )}
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => {
                                    String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("DATA") && String(this.state.judul).includes("REPORT") && String(this.state.judul).includes("ITEMS") && !this.state.invalidTemplate ?
                                        this.checkUpload() :
                                        this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                }}

                            />
                        </div>
                    </div>
                )}
                {this.state.visibleDelete && (
                    <PopUpDelete
                        rowData={this.state.rowData}
                        name={this.state.reportNameDelete}
                        onClickClose={() => this.setState({ visibleDelete: false })}
                        onClickDelete={this.deleteReport.bind(this)}
                    />
                )}
            </div>
        );
    }
}
