import React, { Component } from 'react'
import api from '../api'
import * as R from 'ramda'

export default class ShadwoScreen extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataCompPL: [],
            dataCompCF: [],
            dataCompRatio: [],
            dbPL: [],
            dbCF: [],
            dbFR: [],
            PLID: null,
            FRID: null
        }
    }

    componentDidMount() {
        if (this.props.match.params.type == 'mb' || this.props.match.params.type == 'mr') {
            this.getHierarki(this.props.match.params.type)
        }
    }  

    getHierarki(){
        if (this.props.match.params.type == 'mb') {
            api.create().getHierarkiCronJobMBPL().then((res) => {
                if (res.data) {
                    this.setState({dataCompPL: res.data.data.master_budget}, () => {
                        this.state.dataCompPL.map((item,index) => {
                            this.getPL(item)
                        })
                    })
                }
            })
            api.create().getHierarkiCronJobMBCF().then((res) => {
                if (res.data) {
                    this.setState({dataCompCF: res.data.data})
                }
            })
            api.create().getHierarkiCronJobMBRatio().then((res) => {
                if (res.data) {
                    this.setState({dataCompRatio: res.data.data})
                }
            })
        } else {
            api.create().getHierarkiCronJobMRPL().then((res) => {
                if (res.data) {
                    this.setState({dataCompPL: res.data.data})
                }
            })
            api.create().getHierarkiCronJobMRCF().then((res) => {
                if (res.data) {
                    this.setState({dataCompCF: res.data.data})
                }
            })
            api.create().getHierarkiCronJobMRRatio().then((res) => {
                if (res.data) {
                    this.setState({dataCompRatio: res.data.data})
                }
            })
        }
    }

    getPL(value) {
        console.log(value)
        let PLID = null
        let payloadID = {
            "periode": value.periode,
            "company_id": value.company_id  
        }
        // console.log(payloadID);
        api.create().getPLID(payloadID).then(response => {
            // console.log(response);
            if (response) {
                PLID = response.data.data == null ? null : response.data.data.profit_loss_id 
            } else {
                PLID = null
            }
            // this.setState({ PLID }, () => {
                let payload = {
                    "report_id": value.report_id,
                    "revision": value.revision,
                    "periode": value.periode,
                    "company_id": value.company_id,
                    "submission_id": PLID,
                    "months": 0,
                    "quarter": 0,
                }
                api.create().getHierarkiCreateReportPLMB(payload).then(response => {
                    // console.log(response);
                    let dataTable = []
                    if (response.data) {
                        // let dataTable = []
                        // console.log(response)
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_detail.total_actual_before === null ? "0" : item.profit_detail.total_actual_before === "" ? "0" : item.profit_detail.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.january, formula: item.profit_detail.january_formula } : item.profit_detail.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.february, formula: item.profit_detail.february_formula } : item.profit_detail.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.march, formula: item.profit_detail.march_formula } : item.profit_detail.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.april, formula: item.profit_detail.april_formula } : item.profit_detail.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.may, formula: item.profit_detail.may_formula } : item.profit_detail.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.june, formula: item.profit_detail.june_formula } : item.profit_detail.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.july, formula: item.profit_detail.july_formula } : item.profit_detail.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.august, formula: item.profit_detail.august_formula } : item.profit_detail.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.september, formula: item.profit_detail.september_formula } : item.profit_detail.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.october, formula: item.profit_detail.october_formula } : item.profit_detail.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.november, formula: item.profit_detail.november_formula } : item.profit_detail.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.december, formula: item.profit_detail.december_formula } : item.profit_detail.december,
                                item.profit_detail.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.profit_detail.forecast_formula == null ? [] : item.profit_detail.forecast_formula,
                                item.profit_detail.notes
                            ])
        
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_detail.total_actual_before === null ? "0" : item.profit_detail.total_actual_before === "" ? "0" : item.profit_detail.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.january, formula: item.profit_detail.january_formula } : item.profit_detail.january,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.february, formula: item.profit_detail.february_formula } : item.profit_detail.february,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.march, formula: item.profit_detail.march_formula } : item.profit_detail.march,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.april, formula: item.profit_detail.april_formula } : item.profit_detail.april,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.may, formula: item.profit_detail.may_formula } : item.profit_detail.may,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.june, formula: item.profit_detail.june_formula } : item.profit_detail.june,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.july, formula: item.profit_detail.july_formula } : item.profit_detail.july,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.august, formula: item.profit_detail.august_formula } : item.profit_detail.august,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.september, formula: item.profit_detail.september_formula } : item.profit_detail.september,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.october, formula: item.profit_detail.october_formula } : item.profit_detail.october,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.november, formula: item.profit_detail.november_formula } : item.profit_detail.november,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.december, formula: item.profit_detail.december_formula } : item.profit_detail.december,
                                item.profit_detail.total_current_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_next_year,
                                item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? 0 : item.profit_detail.total_more_year,
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.profit_detail.forecast_formula == null ? [] : item.profit_detail.forecast_formula,
                                item.profit_detail.notes
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        // console.log(dataTable)
                        // this.setState({ dbPL: dataTable }, () => {
                            this.olahDataPL(dataTable, value, PLID)    
                        // })
                    } else {
                        // this.setState({ dbPL: [] })
                    }
                })
            // })
        })
    }

    handleValueFormulaDBPL = (valueItem, datatable, value, tableMeta, column, periode, forecast) => {
        let splitFormula = String(tableMeta[3]).split(/([()@])/)
        let baru = []
        let anjay = []
        let dataTable2 = datatable
        // console.log(datatable)
        splitFormula.map((item, index) => {
            let items = String(item).substr(Number(String(item).length) - 1, 1)
            let subForm = String(item).substr(0, Number(String(item).length) - 1)
            let re = /^[a-zA-Z0-9_]+$/;
            let asd = ''
            if (item !== "") {
                if (!re.test(items)) {
                    baru.push(subForm)
                    baru.push(items)
                } else {
                    baru.push(String(item))
                }
            }
        })

        baru.map((item, index) => {
            if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                anjay.push(item)
            } else {
                if (String(item).includes('#')) {
                    if (forecast !== undefined) {
                        let forecastt = 0
                        forecast.map((items, index) => {
                            if (items.periode == periode) {
                                forecastt += Number(items.value)
                            }
                        })
                        anjay.push(forecastt)
                    } else {
                        if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let data = column == 7 ? 18 : column - 1
                            let period = data == 18 ? Number(valueItem.periode) - 1 : valueItem.periode
                            let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                            if (indexID !== -1) {
                                let valuezz = tableMeta.rowData[data].formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(valueItem.periode))
                            if (indexID !== -1) {
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    }

                } else {
                    let indexID = dataTable2.findIndex((val) => val[22] == item)
                    if (indexID !== -1) {
                        if (forecast != undefined) {
                            // console.log(dataTable2[indexID][column])
                        }
                        let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                        anjay.push(valuezz == "" ? 0 : valuezz)
                    } else {
                        if (item === '(-1)') {
                            anjay.push(-1)
                        }
                    }
                }
            }
        })

        let anjay2 = []
        let kurung = false
        let item1 = []
        anjay.map((item, index) => {
            if (item == "(") {
                kurung = true
            } else if (item == ")") {
                kurung = false
                anjay2.push(item1)
                item1 = []
            } else {
                if (kurung) {
                    item1.push(item)
                } else {
                    anjay2.push(item)
                }
            }
        })
        
        let total = 0
        let opt = ""
        let totalPrio = 0
        let optPrio = ""
        let prio = false
        anjay2.map((item, index) => {
            if (Array.isArray(item)) {
                prio = true
                item.map((items, indexs) => {
                    if (items == "+") {
                        optPrio = "tambah"
                    } else if (items == "-") {
                        optPrio = "kurang"
                    } else if (items == "*") {
                        optPrio = "kali"
                    } else if (items == "/") {
                        optPrio = "bagi"
                    } else {
                        if (optPrio == "tambah") {
                            totalPrio = Number(totalPrio) + Number(items)
                        } else if (optPrio == "kurang") {
                            totalPrio = Number(totalPrio) - Number(items)
                        } else if (optPrio == "kali") {
                            totalPrio = Number(totalPrio) * Number(items)
                        } else if (optPrio == "bagi") {
                            totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                        } else {
                            totalPrio += Number(items)
                        }
                    }
                })  

                if (index == anjay2.length - 1) {
                    if (opt == "tambah") {
                        total = Number(total) + Number(totalPrio)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(totalPrio)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(totalPrio)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                    } else {
                        total += Number(totalPrio)
                    }
                }
            } else {
                if (item == "+") {
                    opt = "tambah"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "-") {
                    opt = "kurang"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "*") {
                    opt = "kali"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else if (item == "/") {
                    opt = "bagi"
                    if (prio) {
                        total = Number(Number(totalPrio) + Number(total))
                        prio = false
                        totalPrio = 0
                        optPrio = ""
                    }
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            }
        })

        total = R.equals(total, NaN) ? "0.0" : total
        return total
    }

    handleForecastDBPL = (value, datatable, index, tableMeta, periode, column) => {
        let total = 0
        let dataTable2 = datatable

        if (tableMeta[3].includes('#PL')) {
            dataTable2[index][25].map((item, index) => {
                if (item.periode == periode) {
                    total += Number(item.value)
                }
            })
        } else {
            total = this.handleValueFormulaDBPL(value, dataTable2, tableMeta, column, periode, dataTable2[index][25])
        }

        return total
    }

    olahDataPL(dbPL, value, PLID) {
        console.log('masuk')
        dbPL.map((item,index) => {
            if(item[0] == 5 || item[0] == 6 || item[0] == 7) {
                item[7].value = this.handleValueFormulaDBPL(value,dbPL,item[7],item,7)
                item[8].value = this.handleValueFormulaDBPL(value,dbPL,item[8],item,8)
                item[9].value = this.handleValueFormulaDBPL(value,dbPL,item[9],item,9)
                item[10].value = this.handleValueFormulaDBPL(value,dbPL,item[10],item,10)
                item[12].value = this.handleValueFormulaDBPL(value,dbPL,item[12],item,12)
                item[13].value = this.handleValueFormulaDBPL(value,dbPL,item[13],item,13)
                item[14].value = this.handleValueFormulaDBPL(value,dbPL,item[14],item,14)
                item[11].value = this.handleValueFormulaDBPL(value,dbPL,item[11],item,11)
                item[15].value = this.handleValueFormulaDBPL(value,dbPL,item[15],item,15)
                item[16].value = this.handleValueFormulaDBPL(value,dbPL,item[16],item,16)
                item[17].value = this.handleValueFormulaDBPL(value,dbPL,item[17],item,17)
                item[18].value = this.handleValueFormulaDBPL(value,dbPL,item[18],item,18)
                item[20] = this.handleForecastDBPL(value, dbPL, index, item, `${Number(value.periode) + 1}`, 20)
                item[21] = this.handleForecastDBPL(value, dbPL, index, item, `${Number(value.periode) + 2}`, 21)
            }
        })
        // this.setState({dbPL}, () => {
            this.payloadPL(dbPL, value, PLID)
        // })
    }

    payloadPL(dbPL, value, PLID) {
        let listPL = []
        // console.log(dbPL)
        dbPL.map((item,index) => {
            if (item[0] == 5 || item[0] == 6 || item[0] == 7) {
                item[7].value = this.handleValueFormulaDBPL(value,dbPL,item[7],item,7)
                item[8].value = this.handleValueFormulaDBPL(value,dbPL,item[8],item,8)
                item[9].value = this.handleValueFormulaDBPL(value,dbPL,item[9],item,9)
                item[10].value = this.handleValueFormulaDBPL(value,dbPL,item[10],item,10)
                item[11].value = this.handleValueFormulaDBPL(value,dbPL,item[11],item,11)
                item[12].value = this.handleValueFormulaDBPL(value,dbPL,item[12],item,12)
                item[13].value = this.handleValueFormulaDBPL(value,dbPL,item[13],item,13)
                item[14].value = this.handleValueFormulaDBPL(value,dbPL,item[14],item,14)
                item[15].value = this.handleValueFormulaDBPL(value,dbPL,item[15],item,15)
                item[16].value = this.handleValueFormulaDBPL(value,dbPL,item[16],item,16)
                item[17].value = this.handleValueFormulaDBPL(value,dbPL,item[17],item,17)
                item[18].value = this.handleValueFormulaDBPL(value,dbPL,item[18],item,18)
                item[20] = this.handleForecastDBPL(value, dbPL, index, item, `${Number(value.periode) + 1}`, 20)
                item[21] = this.handleForecastDBPL(value, dbPL, index, item, `${Number(value.periode) + 2}`, 21)
            }

            listPL.push(
                {
                    "item_report_id": item[1],
                    "january": String(item[7].value == undefined? item[7] : Number(item[7].value).toFixed(1)),
                    "february": String(item[8].value == undefined? item[8] : Number(item[8].value).toFixed(1)),
                    "march": String(item[9].value == undefined? item[9] : Number(item[9].value).toFixed(1)),
                    "april": String(item[10].value == undefined? item[10] : Number(item[10].value).toFixed(1)),
                    "may": String(item[11].value == undefined? item[11] : Number(item[11].value).toFixed(1)),
                    "june": String(item[12].value == undefined? item[12] : Number(item[12].value).toFixed(1)),
                    "july": String(item[13].value == undefined? item[13] : Number(item[13].value).toFixed(1)),
                    "august": String(item[14].value == undefined? item[14] : Number(item[14].value).toFixed(1)),
                    "september": String(item[15].value == undefined? item[15] : Number(item[15].value).toFixed(1)),
                    "october": String(item[16].value == undefined? item[16] : Number(item[16].value).toFixed(1)),
                    "november": String(item[17].value == undefined? item[17] : Number(item[17].value).toFixed(1)),
                    "december": String(item[18].value == undefined? item[18] : Number(item[18].value).toFixed(1)),
                    "total_current_year": String(item[19]),
                    "total_next_year": String(item[20] != ''? Number(item[20]).toFixed(1) : item[20]),
                    "total_more_year": String(item[21] != ''? Number(item[21]).toFixed(1) : item[21]),
                    "notes": String(item[26]),
                  }
            )
            
        })
        // this.setState({dbPL: listPL} , () => {
            this.createDBPL(value, listPL, PLID)
        // })
    }

    createDBPL(value, listPL, PLID) {
        // console.log('masuk', value)
        let payload = {
            "company_id": value.company_id,
            "periode": value.periode,
            "report_id": value.report_id,
            "status": "submitted",
            "profit_loss_id": PLID,
            "profit_loss_mb": listPL,
            "months": 0,
        }
        // console.log(JSON.stringify(payload))
        api.create().createReportPLMB(payload).then((res) => {
            // console.log(res)
        })
    }

    render() {
        return (
            <div></div>
        )
    }
}