import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, MuiThemeProvider, TableCell, FormControlLabel, Tooltip, withStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import { Alert } from '@material-ui/lab';


var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class SummaryFR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: false,
        }
    }

    componentDidMount() {
        // this.getItemHierarki()
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        const columnSummaryFR = [
        {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Unit",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', borderRight: '1px solid #fff', borderLeft: '1px solid #fff' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ width: 90, textAlign: 'center' }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 4 ?
                                null :
                                <div>
                                    <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : value}</span>
                                </div>
                            }
                        </div>
                    )
                }
            }
        },{
            name: `MTD ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-4x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            {/* <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}> */}
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"Actual"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"MB"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"% of MB"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"Last Year"}</span>
                                </div>
                            {/* </div> */}
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            {/* <div className="grid grid-3x content-center"> */}
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            {/* </div> */}
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) + 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[20]).toFixed(1)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) + 2}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', fontSize: 13, top: 0, zIndex: 102, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[21]).toFixed(1)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, 
        ]

        let datas = [
            ["ABCD", "test unit", { a: "2", b: "3", c: "4", d: "5" }, { a: "2", b: "3", c: "4", d: "5" }, { a: "2", b: "3", c: "4", d: "5" }, { a: "2", b: "3", c: "4", d: "5" }, { a: "2", b: "3", c: "4", d: "5" }, { a: "2", b: "3", c: "4", d: "5" }],
            ["Total Assets", "unit try", { a: "6", b: "7", c: "8", d: "9" }, { a: "6", b: "7", c: "8", d: "9" }, { a: "6", b: "7", c: "8", d: "9" }, { a: "6", b: "7", c: "8", d: "9" }, { a: "6", b: "7", c: "8", d: "9" }, { a: "6", b: "7", c: "8", d: "9" }]
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>FINANCIAL SUMMARY OF TRIPUTRA GROUP</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {/* {this.state.loading && loadingComponent} */}
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {/* {this.state.visibleTP === true ? */}
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Sub Holding Report</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Tax Planning - Monthly (Database)</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : 2021 </Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.state.dataTable.length == 0 ? null : this.props.isApprover == true ?
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            </div> :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                {((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && (
                                                    <div>
                                                        <a data-tip={'Download Template'} data-for="template">
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    margin: 5
                                                                }}
                                                                onClick={() => this.downloadTemplate()}
                                                            >
                                                                <img src={Images.template} />
                                                            </button>
                                                        </a>
                                                        <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                    </div>
                                                )}
                                                {((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && (
                                                    <div>
                                                        <a data-tip={'Upload'} data-for="upload">
                                                            <button
                                                                style={{
                                                                    backgroundColor: 'transparent',
                                                                    cursor: 'pointer',
                                                                    borderColor: 'transparent',
                                                                    margin: 5
                                                                }}
                                                                onClick={() => this.setState({ visibleUpload: true })}
                                                            >
                                                                <img src={Images.upload} />
                                                            </button>
                                                        </a>
                                                        <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                    </div>
                                                )}
                                                <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={datas}
                                            columns={columnSummaryFR}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : {this.state.updateBy}</Typography>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Cancel</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                    (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ?
                                <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => {
                                            // this.forceUpdate()
                                            this.setState({ loading: true, buttonDraft: false }, () => {
                                                setTimeout(() => {
                                                    // this.setState({ loading: false, buttonError: false, editable: true })
                                                    this.handleValidate()
                                                }, 100);
                                            })
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>
                                    <button
                                        className="button"
                                        type="button"
                                        onClick={() =>
                                            this.state.saveDraft === true ?
                                                null :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.backToMasterBudget('draft')
                                                        }, 100);
                                                    })
                                        }
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: this.state.saveDraft !== true ? 'pointer' : 'default',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>
                                    <button
                                        type="button"
                                        disabled={this.state.buttonError}
                                        onClick={() => this.state.buttonError ?
                                            this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                            :
                                            this.state.handleDoubleClick == 1 ? null :
                                                this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                    setTimeout(() => {
                                                        this.backToMasterBudget('submitted')
                                                    }, 100);
                                                })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 20 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>
                                </div>
                                : null }
                            </div>
                        </Paper>
                </div>
            </div>
        );
    }
}
