import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, ThemeProvider, MuiThemeProvider, TableCell, FormControlLabel, TextField, Input, withStyles, makeStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import api from '../../api';
import AddIcon from '@material-ui/icons/Add';
import { values } from 'ramda';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import Tooltip from '@material-ui/core/Tooltip';
import Constant from '../../library/Constant';
import { Alert, Autocomplete } from '@material-ui/lab';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import * as R from 'ramda';
import { fixNumber, titleCase } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);
var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};

const theme = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea'
            }
        }
    },
});

export default class CorporateAnnualTarget extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [
                // ["FINANCIAL PERSPECTIVE", "9,884,181", "9,884,181", "9,884,181", "9,884,181", "9,884,181", "9,884,181", "9,884,181", "9,884,181", "9,884,181", "9,884,181"],
                // ["Control", "-", "-"],
                // ["Accumulated Depreciation (negative value)", "2,647,647", "2,058,898"],
                // ["Control", "-", "-"],
                // ["Gain / (Loss) on Fixed Assets", "-", "-"],
                // ["Control", "-", "-"]
            ],
            loading: false,
            uomList: [],
            formulaYtdList: {
                options: [{ value: 'SUM' }, { value: 'AVG' }, { value: 'LAST' }, { value: 'FORMULA' }],
                getOptionLabel: (option) => titleCase(option.value),
            },
            kpiTypeList: [],
            maxAchList: [],
            visibleCAT: true,
            buttonError: true,
            // formulaYTDList: null,,
            dataDelete: [],
            dataReal: [],
            buttonDraft: true,
            updateBy: [],
            handleDoubleClick: 0,
            editable: false,
            dataCustomerPrs: [],
            dataInternalBsn: [],
            dataFin: [],
            dataLearn: [],
            handleDataSalah: false,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
        }
        this.fileHandler = this.fileHandler.bind(this);

    }

    componentDidMount() {
        this.getKPIType()
        this.getMaxAch()
        this.getLatestUpdate()
        // // // console.log(this.props.status)
        // // // // console.log(this.props.lastStatus);
    }

    getItemHierarki() {
        this.setState({ loading: true })
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            "currency_id": this.props.defaultCurrency.id
        }
        console.log(JSON.stringify(payload))
        api.create().getDetailReportMB(payload).then(response => {
            let dataTable = []
            let dataCustomerPrs = []
            let dataInternalBsn = []
            let dataFin = []
            let dataLearn = []
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                let parentTrue = item.parent_name == 'INTERNAL BUSINESS PROCESS PERSPECTIVE' || item.parent_name == 'CUSTOMER PERSPECTIVE'

                                if (item.parent_name == 'INTERNAL BUSINESS PROCESS PERSPECTIVE') {
                                    if (item.type_report_id !== 4) {
                                        dataInternalBsn.push({
                                            id: item.id,
                                            name: item.description,
                                            check: false
                                        })
                                    }
                                }

                                if (item.parent_name == 'CUSTOMER PERSPECTIVE') {
                                    if (item.type_report_id !== 4) {
                                        dataCustomerPrs.push({
                                            id: item.id,
                                            name: item.description,
                                            check: false
                                        })
                                    }
                                }

                                if (item.parent_name == 'FINANCIAL PERSPECTIVE') {
                                    if (item.type_report_id !== 4) {
                                        dataFin.push({
                                            id: item.id,
                                            name: item.description,
                                            check: false
                                        })
                                    }
                                }

                                if (item.parent_name == 'LEARNING & GROWTH PERSPECTIVE') {
                                    if (item.type_report_id !== 4) {
                                        dataLearn.push({
                                            id: item.id,
                                            name: item.description,
                                            check: false
                                        })
                                    }
                                }

                                dataTable.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    "",
                                    item.description,
                                    item.type_report_id == 1 ? `${fixNumber(Number(item.weight) * 100)}%` : (String(item.cat.weight).includes('%') ? (String(Number(String(item.cat.weight).substr(0, String(item.cat.weight).length - 1))) + '%') : ((String(Number(item.cat.weight)) + '%'))),
                                    parentTrue ? item.cat.uom : item.uom,
                                    parentTrue ? item.cat.kpi_type == "" ? null : { value: item.cat.kpi_type } : item.kpi_type == "" ? null : { value: item.kpi_type },
                                    parentTrue ? item.cat.max_ach == "" ? null : { value: titleCase(item.cat.max_ach) } : item.max_ach == "" ? null : { value: titleCase(item.max_ach) },
                                    parentTrue ? item.cat.formula == "" ? null : { value: item.cat.formula } : item.formula_ytd == "" ? null : { value: item.formula_ytd },
                                    item.cat.total_actual_before == "" ? item.cat.total_actual_before : String(item.cat.total_actual_before).indexOf(".") == -1 ? Number(item.cat.total_actual_before) : Number(item.cat.total_actual_before),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.january == "" ? item.cat.january : String(item.cat.january).indexOf(".") == -1 ? Number(item.cat.january) : Number(item.cat.january)) : { value: item.cat.january, formula: item.cat.january_formula } : (item.cat.january == "" ? item.cat.january : String(item.cat.january).indexOf(".") == -1 ? Number(item.cat.january) : Number(item.cat.january)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.february == "" ? item.cat.february : String(item.cat.february).indexOf(".") == -1 ? Number(item.cat.february) : Number(item.cat.february)) : { value: item.cat.february, formula: item.cat.february_formula } : (item.cat.february == "" ? item.cat.february : String(item.cat.february).indexOf(".") == -1 ? Number(item.cat.february) : Number(item.cat.february)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.march == "" ? item.cat.march : String(item.cat.march).indexOf(".") == -1 ? Number(item.cat.march) : Number(item.cat.march)) : { value: item.cat.march, formula: item.cat.march_formula } : (item.cat.march == "" ? item.cat.march : String(item.cat.march).indexOf(".") == -1 ? Number(item.cat.march) : Number(item.cat.march)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.april == "" ? item.cat.april : String(item.cat.april).indexOf(".") == -1 ? Number(item.cat.april) : Number(item.cat.april)) : { value: item.cat.april, formula: item.cat.april_formula } : (item.cat.april == "" ? item.cat.april : String(item.cat.april).indexOf(".") == -1 ? Number(item.cat.april) : Number(item.cat.april)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.may == "" ? item.cat.may : String(item.cat.may).indexOf(".") == -1 ? Number(item.cat.may) : Number(item.cat.may)) : { value: item.cat.may, formula: item.cat.may_formula } : (item.cat.may == "" ? item.cat.may : String(item.cat.may).indexOf(".") == -1 ? Number(item.cat.may) : Number(item.cat.may)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.june == "" ? item.cat.june : String(item.cat.june).indexOf(".") == -1 ? Number(item.cat.june) : Number(item.cat.june)) : { value: item.cat.june, formula: item.cat.june_formula } : (item.cat.june == "" ? item.cat.june : String(item.cat.june).indexOf(".") == -1 ? Number(item.cat.june) : Number(item.cat.june)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.july == "" ? item.cat.july : String(item.cat.july).indexOf(".") == -1 ? Number(item.cat.july) : Number(item.cat.july)) : { value: item.cat.july, formula: item.cat.july_formula } : (item.cat.july == "" ? item.cat.july : String(item.cat.july).indexOf(".") == -1 ? Number(item.cat.july) : Number(item.cat.july)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.august == "" ? item.cat.august : String(item.cat.august).indexOf(".") == -1 ? Number(item.cat.august) : Number(item.cat.august)) : { value: item.cat.august, formula: item.cat.august_formula } : (item.cat.august == "" ? item.cat.august : String(item.cat.august).indexOf(".") == -1 ? Number(item.cat.august) : Number(item.cat.august)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.september == "" ? item.cat.september : String(item.cat.september).indexOf(".") == -1 ? Number(item.cat.september) : Number(item.cat.september)) : { value: item.cat.september, formula: item.cat.september_formula } : (item.cat.september == "" ? item.cat.september : String(item.cat.september).indexOf(".") == -1 ? Number(item.cat.september) : Number(item.cat.september)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.october == "" ? item.cat.october : String(item.cat.october).indexOf(".") == -1 ? Number(item.cat.october) : Number(item.cat.october)) : { value: item.cat.october, formula: item.cat.october_formula } : (item.cat.october == "" ? item.cat.october : String(item.cat.october).indexOf(".") == -1 ? Number(item.cat.october) : Number(item.cat.october)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.november == "" ? item.cat.november : String(item.cat.november).indexOf(".") == -1 ? Number(item.cat.november) : Number(item.cat.november)) : { value: item.cat.november, formula: item.cat.november_formula } : (item.cat.november == "" ? item.cat.november : String(item.cat.november).indexOf(".") == -1 ? Number(item.cat.november) : Number(item.cat.november)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 || this.props.status === 'CLOSED' ? (item.cat.december == "" ? item.cat.december : String(item.cat.december).indexOf(".") == -1 ? Number(item.cat.december) : Number(item.cat.december)) : { value: item.cat.december, formula: item.cat.december_formula } : (item.cat.december == "" ? item.cat.december : String(item.cat.december).indexOf(".") == -1 ? Number(item.cat.december) : Number(item.cat.december)),
                                    item.cat.total_current_year == "" ? 0 : String(item.cat.total_current_year).indexOf(".") == -1 ? Number(item.cat.total_current_year) : Number(item.cat.total_current_year),
                                    item.cat.total_next_year == "" ? item.cat.total_next_year : String(item.cat.total_next_year).indexOf(".") == -1 ? Number(item.cat.total_next_year) : Number(item.cat.total_next_year),
                                    item.cat.total_more_year == "" ? item.cat.total_more_year : String(item.cat.total_more_year).indexOf(".") == -1 ? Number(item.cat.total_more_year) : Number(item.cat.total_more_year),
                                    item.cat.strategic,
                                    item.cat.pic,
                                    item.cat.forecast_formula,
                                    item.order
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                "",
                                item.description,
                                item.type_report_id == 1 ? (`${String(item.weight).includes('%') ? String(item.weight) : String(fixNumber((Number(item.weight) * 100)) + '% ')}`) : (String(Number(String(item.cat.weight).substr(0, String(item.cat.weight).length - 1))) + '%'),
                                item.cat.uom,
                                item.kpi_type == "" ? null : { value: item.kpi_type },
                                item.max_ach == "" ? null : { value: titleCase(item.max_ach) },
                                item.formula == "" ? null : { value: item.formula_ytd },
                                item.cat.total_actual_before == "" ? item.cat.total_actual_before : String(item.cat.total_actual_before).indexOf(".") == -1 ? Number(item.cat.total_actual_before) : Number(item.cat.total_actual_before),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.january, formula: item.cat.january_formula } : (item.cat.january == "" ? item.cat.january : String(item.cat.january).indexOf(".") == -1 ? Number(item.cat.january) : Number(item.cat.january)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.february, formula: item.cat.february_formula } : (item.cat.february == "" ? item.cat.february : String(item.cat.february).indexOf(".") == -1 ? Number(item.cat.february) : Number(item.cat.february)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.march, formula: item.cat.march_formula } : (item.cat.march == "" ? item.cat.march : String(item.cat.march).indexOf(".") == -1 ? Number(item.cat.march) : Number(item.cat.march)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.april, formula: item.cat.april_formula } : (item.cat.april == "" ? item.cat.april : String(item.cat.april).indexOf(".") == -1 ? Number(item.cat.april) : Number(item.cat.april)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.may, formula: item.cat.may_formula } : (item.cat.may == "" ? item.cat.may : String(item.cat.may).indexOf(".") == -1 ? Number(item.cat.may) : Number(item.cat.may)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.june, formula: item.cat.june_formula } : (item.cat.june == "" ? item.cat.june : String(item.cat.june).indexOf(".") == -1 ? Number(item.cat.june) : Number(item.cat.june)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.july, formula: item.cat.july_formula } : (item.cat.july == "" ? item.cat.july : String(item.cat.july).indexOf(".") == -1 ? Number(item.cat.july) : Number(item.cat.july)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.august, formula: item.cat.august_formula } : (item.cat.august == "" ? item.cat.august : String(item.cat.august).indexOf(".") == -1 ? Number(item.cat.august) : Number(item.cat.august)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.september, formula: item.cat.september_formula } : (item.cat.september == "" ? item.cat.september : String(item.cat.september).indexOf(".") == -1 ? Number(item.cat.september) : Number(item.cat.september)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.october, formula: item.cat.october_formula } : (item.cat.october == "" ? item.cat.october : String(item.cat.october).indexOf(".") == -1 ? Number(item.cat.october) : Number(item.cat.october)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.november, formula: item.cat.november_formula } : (item.cat.november == "" ? item.cat.november : String(item.cat.november).indexOf(".") == -1 ? Number(item.cat.november) : Number(item.cat.november)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.december, formula: item.cat.december_formula } : (item.cat.december == "" ? item.cat.december : String(item.cat.december).indexOf(".") == -1 ? Number(item.cat.december) : Number(item.cat.december)),
                                item.cat.total_current_year == "" ? 0 : String(item.cat.total_current_year).indexOf(".") == -1 ? Number(item.cat.total_current_year) : Number(item.cat.total_current_year),
                                item.cat.total_next_year == "" ? item.cat.total_next_year : String(item.cat.total_next_year).indexOf(".") == -1 ? Number(item.cat.total_next_year) : Number(item.cat.total_next_year),
                                item.cat.total_more_year == "" ? item.cat.total_more_year : String(item.cat.total_more_year).indexOf(".") == -1 ? Number(item.cat.total_more_year) : Number(item.cat.total_more_year),
                                item.cat.strategic,
                                item.cat.pic,
                                item.cat.forecast_formula,
                                item.order
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dataTable)
                        this.setState({ dataTable, loading: false, dataReal: res, editable: true, dataCustomerPrs, dataInternalBsn, dataFin, dataLearn }, () => {
                            // // // console.log(dataCustomerPrs)
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    };
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Connection Timeout, please check your Connection', tipeAlert: 'error', loading: false })
            }


        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // // // // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Master Budget CAT.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        // // // // console.log('masuk')
        let bram = [this.props.submissionID, this.props.report_id, this.props.company.company_id, this.props.periode, this.props.revision]
        // // // // console.log(bram)
        let resReal = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${this.props.submissionID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        let resNull = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        let res = await fetch(
            this.props.submissionID == null ? resNull : resReal
        )
        res = await res.blob()
        // // // // console.log(res)
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Master Budget CAT.xlsx';
            a.click();
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // // // // // console.log(resp)
            if (err) {
                // // // // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // // console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                let newValidate = false
                isi.map((i, index) => {
                    if (i.length > 0) {
                        let total = 0
                        let lastValz = 0
                        let nilaiTotal = 0
                        if (i[6] !== undefined) {
                            if (i[6] == 'SUM' || i[6] == 'AVG' || i[6] == 'LAST') {
                                i.map((items, indexs) => {
                                    if (indexs >= 8 && indexs <= 19) {
                                        let valItem = items == undefined || items == "" ? 0 : items
                                        total += Number(valItem)
                                        if (index == 19) {
                                            lastValz += Number(valItem)
                                        }
                                    }
                                })
                            }
                            nilaiTotal = i[6] == 'SUM' ? total : i[6] == 'AVG' ? total / 12 : lastValz
                        }

                        if (String(i[1]).trim().toLocaleUpperCase() == "CUSTOMER PERSPECTIVE") {
                            newValidate = true
                        }

                        if (String(i[1]).trim().toLocaleUpperCase() == "LEARNING & GROWTH PERSPECTIVE") {
                            newValidate = false
                        }

                        if (i[0] === undefined || i[0] === null) {
                            if (newValidate) {
                                payload.push({
                                    item_report_id: i[0] === undefined ? 0 : reg.test(String(i[0])) === false ? 0 : String(i[0]).trim(),
                                    item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                                    weight: i[2] === undefined ? "" : (String(i[2]).includes('%') ? Number(String(i[2]).substr(0, String(i[2]).length - 1)) : String(Number(i[2] * 100)) + '%'),
                                    uom: i[3] === undefined ? "" : String(i[3]).trim(),
                                    kpi_type: i[4] === undefined ? "" : String(i[4]).trim(),
                                    max_ach: i[5] === undefined ? "" : String(i[5]).toLocaleLowerCase() !== 'unlimited' ? (String(i[5]).includes('%') ? String(i[5].trim()) : String(Number(i[5] * 100) + '%')) : String(i[5]).trim(),
                                    formula: i[6] === undefined ? "" : String(i[6]).trim(),
                                    total_actual_before: i[7] === undefined ? "0.0" : reg.test(String(i[7])) === false ? "0.0" : String(Number(i[7])).trim(),
                                    january: i[8] === undefined ? "0.0" : reg.test(String(i[8])) === false ? "0.0" : String(Number(i[8])).trim(),
                                    february: i[9] === undefined ? "0.0" : reg.test(String(i[9])) === false ? "0.0" : String(Number(i[9])).trim(),
                                    march: i[10] === undefined ? "0.0" : reg.test(String(i[10])) === false ? "0.0" : String(Number(i[10])).trim(),
                                    april: i[11] === undefined ? "0.0" : reg.test(String(i[11])) === false ? "0.0" : String(Number(i[11])).trim(),
                                    may: i[12] === undefined ? "0.0" : reg.test(String(i[12])) === false ? "0.0" : String(Number(i[12])).trim(),
                                    june: i[13] === undefined ? "0.0" : reg.test(String(i[13])) === false ? "0.0" : String(Number(i[13])).trim(),
                                    july: i[14] === undefined ? "0.0" : reg.test(String(i[14])) === false ? "0.0" : String(Number(i[14])).trim(),
                                    august: i[15] === undefined ? "0.0" : reg.test(String(i[15])) === false ? "0.0" : String(Number(i[15])).trim(),
                                    september: i[16] === undefined ? "0.0" : reg.test(String(i[16])) === false ? "0.0" : String(Number(i[16])).trim(),
                                    october: i[17] === undefined ? "0.0" : reg.test(String(i[17])) === false ? "0.0" : String(Number(i[17])).trim(),
                                    november: i[18] === undefined ? "0.0" : reg.test(String(i[18])) === false ? "0.0" : String(Number(i[18])).trim(),
                                    december: i[19] === undefined ? "0.0" : reg.test(String(i[19])) === false ? "0.0" : String(Number(i[19])).trim(),
                                    total_current_year: i[20] == 0 ? "0.0" : String(Number(i[20])).trim(),
                                    total_next_year: i[21] === undefined ? "0.0" : reg.test(String(i[21])) === false ? "0.0" : String(Number(i[21])).trim(),
                                    total_more_year: i[22] === undefined ? "0.0" : reg.test(String(i[22])) === false ? "0.0" : String(Number(i[22])).trim(),
                                    strategic: i[23] === undefined ? "" : String(i[23]).trim(),
                                    pic: i[24] === undefined ? "" : String(i[24]).trim()
                                })
                            }
                        } else {
                            payload.push({
                                item_report_id: i[0] === undefined ? 0 : reg.test(String(i[0])) === false ? 0 : String(i[0]).trim(),
                                item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                                weight: i[2] === undefined ? "" : (String(i[2]).includes('%') ? Number(String(i[2]).substr(0, String(i[2]).length - 1)) : String(Number(i[2] * 100)) + '%'),
                                uom: i[3] === undefined ? "" : String(i[3]).trim(),
                                kpi_type: i[4] === undefined ? "" : String(i[4]).trim(),
                                max_ach: i[5] === undefined ? "" : String(i[5]).toLocaleLowerCase() !== 'unlimited' ? (String(i[5]).includes('%') ? String(i[5].trim()) : String(Number(i[5] * 100) + '%')) : String(i[5]).trim(),
                                formula: i[6] === undefined ? "" : String(i[6]).trim(),
                                total_actual_before: i[7] === undefined ? "0.0" : reg.test(String(i[7])) === false ? "0.0" : String(Number(i[7])).trim(),
                                january: i[8] === undefined ? "0.0" : reg.test(String(i[8])) === false ? "0.0" : String(Number(i[8])).trim(),
                                february: i[9] === undefined ? "0.0" : reg.test(String(i[9])) === false ? "0.0" : String(Number(i[9])).trim(),
                                march: i[10] === undefined ? "0.0" : reg.test(String(i[10])) === false ? "0.0" : String(Number(i[10])).trim(),
                                april: i[11] === undefined ? "0.0" : reg.test(String(i[11])) === false ? "0.0" : String(Number(i[11])).trim(),
                                may: i[12] === undefined ? "0.0" : reg.test(String(i[12])) === false ? "0.0" : String(Number(i[12])).trim(),
                                june: i[13] === undefined ? "0.0" : reg.test(String(i[13])) === false ? "0.0" : String(Number(i[13])).trim(),
                                july: i[14] === undefined ? "0.0" : reg.test(String(i[14])) === false ? "0.0" : String(Number(i[14])).trim(),
                                august: i[15] === undefined ? "0.0" : reg.test(String(i[15])) === false ? "0.0" : String(Number(i[15])).trim(),
                                september: i[16] === undefined ? "0.0" : reg.test(String(i[16])) === false ? "0.0" : String(Number(i[16])).trim(),
                                october: i[17] === undefined ? "0.0" : reg.test(String(i[17])) === false ? "0.0" : String(Number(i[17])).trim(),
                                november: i[18] === undefined ? "0.0" : reg.test(String(i[18])) === false ? "0.0" : String(Number(i[18])).trim(),
                                december: i[19] === undefined ? "0.0" : reg.test(String(i[19])) === false ? "0.0" : String(Number(i[19])).trim(),
                                total_current_year: i[20] == 0 ? "0.0" : String(Number(i[20])).trim(),
                                total_next_year: i[21] === undefined ? "0.0" : reg.test(String(i[21])) === false ? "0.0" : String(Number(i[21])).trim(),
                                total_more_year: i[22] === undefined ? "0.0" : reg.test(String(i[22])) === false ? "0.0" : String(Number(i[22])).trim(),
                                strategic: i[23] === undefined ? "" : String(i[23]).trim(),
                                pic: i[24] === undefined ? "" : String(i[24]).trim()
                            })
                        }
                        // // console.log(i[2])
                        // // // console.log(Number(i[2] * 100))
                        // // // // // console.log(i[2] === undefined ? "" : String(Number(i[2]*100)).length > 3? String(Number(i[2]*100).toFixed(0) + '%') : String(Number(i[2]*100)) + '%')

                    }
                })

                // // console.log(payload)
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    status: '',
                    cat: payload,
                    status: 'submitted'
                }
                // // // // console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        this.setState({ loading: true, dataTable: [] })
        let dataDelete = this.state.dataDelete
        api.create().getIdDeleteFromExcel(payload).then((response) => {
            if (response.data) {
                // // // // // console.log(response.data)
                let idDelete = response.data.data.item_report_id
                if (idDelete.length > 0) {
                    idDelete.map((item, index) => {
                        dataDelete.push(item)
                    })
                    this.setState({ dataDelete })
                }
            }
        })
        console.log(payload)
        api.create().checkUploadMB(payload).then(response => {
            // // console.log(JSON.stringify(this.state.payload));
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        // this.setState({ visibleUpload: false, visibleCAT: false })
                        this.setState({ visibleUpload: false, visibleCAT: false })
                        let dataTable = []
                        let custoId = 0
                        let bisnsId = 0
                        let dataDelete = this.state.dataDelete
                        let dataFin = this.state.dataFin
                        let dataLearn = this.state.dataLearn
                        let newValidate = false
                        response.data.data.map((item, index) => {
                            if (item.item_report == 'CUSTOMER PERSPECTIVE') {
                                custoId = item.item_report_id
                            }

                            if (item.item_report == 'INTERNAL BUSINESS PROCESS PERSPECTIVE') {
                                bisnsId = item.item_report_id
                            }

                            if (String(item.item_report).trim().toLocaleUpperCase() == "CUSTOMER PERSPECTIVE") {
                                newValidate = true
                            }

                            if (String(item.item_report).trim().toLocaleUpperCase() == "LEARNING & GROWTH PERSPECTIVE") {
                                newValidate = false
                            }

                            if (item.type_report_id !== 4 && item.parent !== null && (item.parent == custoId || item.parent == bisnsId)) {
                                let indexCust = this.state.dataCustomerPrs.findIndex((val) => val.name == item.item_report)
                                let indexBisn = this.state.dataInternalBsn.findIndex((val) => val.name == item.item_report)
                                if (indexCust !== -1 && item.item_report_id == 0) {
                                    dataDelete.push(this.state.dataCustomerPrs[indexCust].id)
                                }

                                if (indexBisn !== -1 && item.item_report_id == 0) {
                                    dataDelete.push(this.state.dataInternalBsn[indexBisn].id)
                                }
                            }

                            if (newValidate == false) {
                                let indexIDx = dataFin.findIndex((val) => String(val.name).toLocaleLowerCase() == String(item.item_report).toLocaleLowerCase())
                                let indexIDz = dataLearn.findIndex((val) => String(val.name).toLocaleLowerCase() == String(item.item_report).toLocaleLowerCase())
                                if (indexIDx != -1) {
                                    dataFin[indexIDx].check = true
                                }
                                if (indexIDz != -1) {
                                    dataLearn[indexIDz].check = true
                                }
                            }

                            dataTable.push([
                                item.type_report_id,
                                item.item_report_id,
                                item.parent,
                                item.formula,
                                item.level == null ? 1 : item.level,
                                "",
                                item.item_report,
                                item.type_report_id == 1 ? (`${String(item.weight).includes('%') ? String(item.weight) : String((Number(item.weight) * 100) + '% ')}`) : (String(item.weight)),
                                item.uom,
                                item.kpi_type == "" || item.kpi_type == null ? null : { value: item.kpi_type },
                                item.max_ach == "" || item.max_ach == null ? null : { value: titleCase(item.max_ach) },
                                item.formula_ytd == "" || item.formula_ytd == null ? null : { value: item.formula_ytd },
                                item.total_actual_before == "" ? item.total_actual_before : String(item.total_actual_before).indexOf(".") == -1 ? Number(item.total_actual_before) : Number(item.total_actual_before),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.january) : { value: item.january, formula: item.january_formula } : item.january == "" ? item.january : String(item.january).indexOf(".") == -1 ? Number(item.january) : Number(item.january),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.february) : { value: item.february, formula: item.february_formula } : item.february == "" ? item.february : String(item.february).indexOf(".") == -1 ? Number(item.february) : Number(item.february),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.march) : { value: item.march, formula: item.march_formula } : item.march == "" ? item.march : String(item.march).indexOf(".") == -1 ? Number(item.march) : Number(item.march),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.april) : { value: item.april, formula: item.april_formula } : item.april == "" ? item.april : String(item.april).indexOf(".") == -1 ? Number(item.april) : Number(item.april),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.may) : { value: item.may, formula: item.may_formula } : item.may == "" ? item.may : String(item.may).indexOf(".") == -1 ? Number(item.may) : Number(item.may),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.june) : { value: item.june, formula: item.june_formula } : item.june == "" ? item.june : String(item.june).indexOf(".") == -1 ? Number(item.june) : Number(item.june),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.july) : { value: item.july, formula: item.july_formula } : item.july == "" ? item.july : String(item.july).indexOf(".") == -1 ? Number(item.july) : Number(item.july),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.august) : { value: item.august, formula: item.august_formula } : item.august == "" ? item.august : String(item.august).indexOf(".") == -1 ? Number(item.august) : Number(item.august),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.september) : { value: item.september, formula: item.september_formula } : item.september == "" ? item.september : String(item.september).indexOf(".") == -1 ? Number(item.september) : Number(item.september),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.october) : { value: item.october, formula: item.october_formula } : item.october == "" ? item.october : String(item.october).indexOf(".") == -1 ? Number(item.october) : Number(item.october),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.november) : { value: item.november, formula: item.november_formula } : item.november == "" ? item.november : String(item.november).indexOf(".") == -1 ? Number(item.november) : Number(item.november),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.december) : { value: item.december, formula: item.december_formula } : item.december == "" ? item.december : String(item.december).indexOf(".") == -1 ? Number(item.december) : Number(item.december),
                                item.total_current_year === "NaN" ? "0.0" : item.total_current_year == "" ? item.total_current_year : String(item.total_current_year).indexOf(".") == -1 ? Number(item.total_current_year) : Number(item.total_current_year),
                                item.total_next_year == "" ? item.total_next_year : String(item.total_next_year).indexOf(".") == -1 ? Number(item.total_next_year) : Number(item.total_next_year),
                                item.total_more_year == "" ? item.total_more_year : String(item.total_more_year).indexOf(".") == -1 ? Number(item.total_more_year) : Number(item.total_more_year),
                                item.strategic,
                                item.pic,
                                item.forecast_formula,
                                item.orders,
                                item.error
                            ])
                        })
                        let checkDataFin = dataFin.filter((val) => val.check == false)
                        let checkDataLearn = dataLearn.filter((val) => val.check == false)
                        let handleDataSalah = this.state.handleDataSalah

                        if (checkDataFin.length > 0 || checkDataLearn.length > 0) {
                            handleDataSalah = true
                        }
                        // // console.log(indexCheck)
                        // // // // console.log(this.state.buttonError)
                        console.log(dataTable)
                        this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true, dataDelete, handleDataSalah }, () => {
                            this.state.dataTable.map(item => {
                                if (item[30].length > 0) {
                                    // // // // console.log('masuk')
                                    this.setState({ buttonError: true, errorPreview: true, editable: true })
                                }
                            })
                            // // // // // console.log(this.state.dataTable);
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    uploadCAT(type) {
        // let dataDelete = this.state.dataDelete
        // // // // console.log(dataDelete)
        let payload = { "item_report_id": this.state.dataDelete }
        if (this.state.dataDelete.length > 0) {
            api.create().deleteAllItemReport(payload).then((response) => {
                this.functionUpload(type)
            })
        } else {
            this.functionUpload(type)
        }

    }

    functionUpload(type) {
        let data = []
        let stateFR = false
        // // // console.log(this.state.dataTable)
        this.state.dataTable.map(i => {
            if (i[2] !== null) {
                let indexID = this.state.dataTable.findIndex((val) => val[1] == i[2])
                if (indexID !== -1) {
                    if (this.state.dataTable[indexID][6] === 'FINANCIAL PERSPECTIVE') {
                        stateFR = true
                    } else {
                        stateFR = false
                    }
                }
            } else {
                stateFR = false
            }
            // if (this.state.defaultCurrencyUpload?.id == 2) {
            data.push({
                "item_report_id": i[1] == "" || i[1] == null ? 0 : i[1],
                "item_report": String(i[6]),
                "weight": String(i[7]),
                "uom": String(i[8]),
                "kpi_type": i[9] == null ? "" : i[9].value,
                "max_ach": i[10] == null ? "" : i[10].value,
                "formula": i[11] == null ? "" : i[11].value,
                "total_actual_before": String(i[12]) == "" ? "0.0" : String(i[12]),
                "january": i[13].value != undefined ? String(Number(i[13].formula[0].value)/1000) : String(i[13]),
                "february": i[14].value != undefined ? String(Number(i[14].formula[0].value)/1000) : String(i[14]),
                "march": i[15].value != undefined ? String(Number(i[15].formula[0].value)/1000) : String(i[15]),
                "april": i[16].value != undefined ? String(Number(i[16].formula[0].value)/1000) : String(i[16]),
                "may": i[17].value != undefined ? String(Number(i[17].formula[0].value)/1000) : String(i[17]),
                "june": i[18].value != undefined ? String(Number(i[18].formula[0].value)/1000) : String(i[18]),
                "july": i[19].value != undefined ? String(Number(i[19].formula[0].value)/1000) : String(i[19]),
                "august": i[20].value != undefined ? String(Number(i[20].formula[0].value)/1000) : String(i[20]),
                "september": i[21].value != undefined ? String(Number(i[21].formula[0].value)/1000) : String(i[21]),
                "october": i[22].value != undefined ? String(Number(i[22].formula[0].value)/1000) : String(i[22]),
                "november": i[23].value != undefined ? String(Number(i[23].formula[0].value)/1000) : String(i[23]),
                "december": i[24].value != undefined ? String(Number(i[24].formula[1].value)/1000) : String(i[24]),
                "total_current_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][2]?.value)/1000) : String(i[25]),
                "total_next_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][0]?.value)/1000) : String(i[26]),
                "total_more_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][1]?.value)/1000) : String(i[27]),
                "strategic": String(i[28]),
                "pic": String(i[29])
            })
            // } else {
            //     data.push({
            //         "item_report_id": i[1] == "" || i[1] == null ? 0 : i[1],
            //         "item_report": String(i[6]),
            //         "weight": String(i[7]),
            //         "uom": String(i[8]),
            //         "kpi_type": i[9] == null ? "" : i[9].value,
            //         "max_ach": i[10] == null ? "" : i[10].value,
            //         "formula": i[11] == null ? "" : i[11].value,
            //         "total_actual_before": String(i[12]) == "" ? "0.0" : String(i[12]),
            //         "january": i[13].value != undefined ? String(fixNumber(Number(i[13].value), 1)) : String(i[13]),
            //         "february": i[14].value != undefined ? String(fixNumber(Number(i[14].value), 1)) : String(i[14]),
            //         "march": i[15].value != undefined ? String(fixNumber(Number(i[15].value), 1)) : String(i[15]),
            //         "april": i[16].value != undefined ? String(fixNumber(Number(i[16].value), 1)) : String(i[16]),
            //         "may": i[17].value != undefined ? String(fixNumber(Number(i[17].value), 1)) : String(i[17]),
            //         "june": i[18].value != undefined ? String(fixNumber(Number(i[18].value), 1)) : String(i[18]),
            //         "july": i[19].value != undefined ? String(fixNumber(Number(i[19].value), 1)) : String(i[19]),
            //         "august": i[20].value != undefined ? String(fixNumber(Number(i[20].value), 1)) : String(i[20]),
            //         "september": i[21].value != undefined ? String(fixNumber(Number(i[21].value), 1)) : String(i[21]),
            //         "october": i[22].value != undefined ? String(fixNumber(Number(i[22].value), 1)) : String(i[22]),
            //         "november": i[23].value != undefined ? String(fixNumber(Number(i[23].value), 1)) : String(i[23]),
            //         "december": i[24].value != undefined ? String(fixNumber(Number(i[24].value), 1)) : String(i[24]),
            //         "total_current_year": String(fixNumber(Number(i[25]), 1)) == "" ? "0.0" : String(fixNumber(Number(i[25]), 1)),
            //         "total_next_year": String(fixNumber(Number(i[26]), 1)) == "" ? "0.0" : String(fixNumber(Number(i[26]), 1)),
            //         "total_more_year": String(fixNumber(Number(i[27]), 1)) == "" ? "0.0" : String(fixNumber(Number(i[27]), 1)),
            //         "strategic": String(i[28]),
            //         "pic": String(i[29])
            //     })
            // }

        })
        let body = {
            "report_id": this.props.report_id,
            // "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            "currency_id": this.state.defaultCurrencyUpload?.id,
            "status": type,
            "cat": data
        }
        // // console.log(data);
        // // console.log(JSON.stringify(body))
        api.create('UPLOAD').uploadMasterBudget(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        if (type == 'submitted') {
                            this.props.getReport(body, 'CAT')
                        } else {
                            this.props.getReport(body, 'DraftCAT')
                        }
                        this.setState({ loading: false })
                        this.props.onClickClose()
                        // this.props.getReport()
                    } else {
                        if (response.data?.message == "Please Set Up Rate Currency First") {
                            this.setState({ visibleAlertSave: true, loading: false })
                        } else {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                    setTimeout(() => {
                                        localStorage.removeItem(Constant.TOKEN)
                                        window.location.reload();
                                    }, 1000);
                                }
                            })
                        }
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error', loading: false })
            }
        })
    }

    handleValidate() {
        let data = []
        // // // console.log(this.state.dataTable)
        let totalWeight = 0
        let dataTableBaru = this.state.dataTable
        let dataTampung = []
        let weightReal = null
        let handleKosongKPIMAXYTD = false
        let stateFR = false
        console.log(this.state.dataTable)
        this.state.dataTable.map((i, index) => {
            if (i[0] == 1) {
                dataTampung.push({
                    id: i[1],
                    maxValue: i[7],
                    valChild: 0
                })
            }

            if (i[0] !== 1 && i[0] !== 4) {
                totalWeight += Number(i[7] == "" || i[7] == undefined ? 0 : i[7].replace('%', ''))
            }

            if (i[2] !== null) {
                let indexID = this.state.dataTable.findIndex((val) => val[1] == i[2])
                // // // // console.log(indexID)
                // // // // console.log(i[2])
                if (indexID !== -1) {
                    // // // // console.log(dataTableBaru[indexID][6])
                    if (dataTableBaru[indexID][6] == 'INTERNAL BUSINESS PROCESS PERSPECTIVE' || dataTableBaru[indexID][6] == 'CUSTOMER PERSPECTIVE') {
                        if (i[6] == "" || i[7] == "" || i[9] == null || i[10] == null || i[11] == null) {
                            handleKosongKPIMAXYTD = true
                            // // // // console.log(handleKosongKPIMAXYTD)
                        }
                    } else if (dataTableBaru[indexID][6] === 'FINANCIAL PERSPECTIVE') {
                        stateFR = true
                    } else {
                        stateFR = false
                    }
                }
            }

            // if (i[0] == null && i[2] == null) {
            //     if (i[6] == "" || i[7] == "" || i[9] == null || i[10] == null || i[11] == null) {
            //         handleKosongKPIMAXYTD = true
            //         // // // // console.log(handleKosongKPIMAXYTD)
            //     }
            // }

            if (i[2] !== null) {
                let indexID = dataTampung.findIndex((val) => val.id == i[2])
                if (indexID !== -1) {
                    let weightParent = Number(dataTampung[indexID].maxValue == "" || dataTampung[indexID].maxValue == undefined ? 0 : dataTampung[indexID].maxValue.replace('%', ''))
                    let valChild = Number(dataTampung[indexID].valChild)
                    let valReal = Number(i[7] == "" || i[7] == undefined ? 0 : i[7].replace('%', ''))
                    let totalBaru = valChild + valReal
                    if (totalBaru > weightParent) {
                        dataTableBaru[index][7] = `${this.props.defaultCurrency.id == 1 ? String(fixNumber(Number(weightParent - valChild), 1)) : String(Number(weightParent - valChild)) + '%'}`
                        dataTampung[indexID].valChild = dataTampung[indexID].valChild + weightParent - valChild
                        weightReal = `${this.props.defaultCurrency.id == 1 ? String(fixNumber(Number(weightParent - valChild), 1)) : String(Number(weightParent - valChild)) + '%'}`
                    } else {
                        dataTableBaru[index][7] = i[7]
                        weightReal = i[7]
                        dataTampung[indexID].valChild = dataTampung[indexID].valChild + Number(i[7] == "" || i[7] == undefined ? 0 : i[7].replace('%', ''))
                    }
                    // // // // console.log(weightReal)
                    // console.log(dataTableBaru[index][7])
                    // console.log(dataTampung[indexID].valChild)
                }
            }
            // // console.log(String(weightReal).substr(0,String(weightReal).length-1))
            // // console.log(Number(String(weightReal).substr(0,String(weightReal).length-1)).toFixed(1));
            // console.log(weightReal)
            // console.log(i[7])
            let b = []
            // console.log(i[13].value == undefined? 'Y' : 'N')

            if (String(i[6]) == "Revenue"){
                console.log(Number(i[30]))
                console.log(String(Number(i[30][2]?.value)/1000))
            }

            data.push({
                "item_report_id": i[1] == "" || i[1] == null ? 0 : i[1],
                "item_name": String(i[6]),
                "parent": i[2] == "" ? null : i[2],
                "weight": weightReal == null ? String(i[7]) : weightReal,
                "uom": String(i[8]),
                "kpi_type": i[9] == null ? "" : i[9].value,
                "max_ach": i[10] == null ? "" : i[10].value,
                "formula": i[11] == null ? "" : i[11].value,
                "total_actual_before": String(i[12]) == "" ? "0.0" : String(i[12]),
                "january": i[13].value == undefined ? (String(i[13]) == '' ? "0.0" : String(i[13])) : String(i[13].formula[0].value/1000),
                // "january": stateFR ? String(i[13].value) : String(i[13]) == "" ? "0.0" : String(i[13]),
                "february": i[14].value == undefined ? (String(i[14]) == '' ? "0.0" : String(i[14])) : String(i[14].formula[0].value/1000),
                "march": i[15].value == undefined ? (String(i[15]) == '' ? "0.0" : String(i[15])) : String(i[15].formula[0].value/1000),
                "april": i[16].value == undefined ? (String(i[16]) == '' ? "0.0" : String(i[16])) : String(i[16].formula[0].value/1000),
                "may": i[17].value == undefined ? (String(i[17]) == '' ? "0.0" : String(i[17])) : String(i[17].formula[0].value/1000),
                "june": i[18].value == undefined ? (String(i[18]) == '' ? "0.0" : String(i[18])) : String(i[18].formula[0].value/1000),
                "july": i[19].value == undefined ? (String(i[19]) == '' ? "0.0" : String(i[19])) : String(i[19].formula[0].value/1000),
                "august": i[20].value == undefined ? (String(i[20]) == '' ? "0.0" : String(i[20])) : String(i[20].formula[0].value/1000),
                "september": i[21].value == undefined ? (String(i[21]) == '' ? "0.0" : String(i[21])) : String(i[21].formula[0].value/1000),
                "october": i[22].value == undefined ? (String(i[22]) == '' ? "0.0" : String(i[22])) : String(i[22].formula[0].value/1000),
                "november": i[23].value == undefined ? (String(i[23]) == '' ? "0.0" : String(i[23])) : String(i[23].formula[0].value/1000),
                "december": i[24].value == undefined ? (String(i[24]) == '' ? "0.0" : String(i[24])) : String(i[24].formula[1].value/1000),
                "total_current_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][2]?.value)/1000) : String(i[25]),
                "total_next_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][0]?.value)/1000) : String(i[26]),
                "total_more_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][1]?.value)/1000) : String(i[27]),
                "strategic": String(i[28]),
                "pic": String(i[29])
            })
            stateFR = false
        })

        // // // // console.log(dataTableBaru)
        // // // // console.log(JSON.stringify(data))
        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "status": "submitted",
            "cat": data
        }
        console.log(fixNumber(totalWeight))
        // this.setState({dataTable: dataTampung})
        if (handleKosongKPIMAXYTD) {
            this.setState({ alert: true, messageAlert: 'KPI / Weight / KPI Type / Max Ach / Formula YTD / Cannot be Empty', tipeAlert: 'warning', loading: false, editable: true })
        } else if (fixNumber(totalWeight) < 100 && fixNumber(totalWeight) > 0) {
            this.setState({ alert: true, messageAlert: 'Total weight less than 100%', tipeAlert: 'warning', loading: false, editable: true })
        } else {
            console.log(JSON.stringify(payload))
            api.create().validateSubmitReport(payload).then((response) => {
                console.log(response)
                if (response.data.data.result) {
                    this.setState({ loading: false, buttonError: false, editable: false, buttonDraft: false })
                } else {
                    this.setState({ loading: false, buttonError: true, editable: true, buttonDraft: true })
                }
            })
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    backToMasterBudget(type) {
        let data = []
        let stateFR = false
        console.log(this.state.dataTable)
        this.state.dataTable.map(i => {
            if (i[2] !== null) {
                let indexID = this.state.dataTable.findIndex((val) => val[1] == i[2])
                // // // // console.log(indexID)
                // // // // console.log(i[2])
                if (indexID !== -1) {
                    // // // // console.log(dataTableBaru[indexID][6])
                    if (this.state.dataTable[indexID][6] === 'FINANCIAL PERSPECTIVE') {
                        stateFR = true
                    } else {
                        stateFR = false
                    }
                }
            } else {
                stateFR = false
            }
            if (i[13]?.formula != undefined){
                i[13].formula.map((item) =>{
                    console.log(item.value)
                })
            }
            if (i[13]?.formula != undefined){
                console.log(i[13]?.formula[0].value)
            }


            // // // // // console.log(i[9] == null? "" : i[9].value)
            if (this.props.defaultCurrency.id == 2) {
                data.push({
                    "item_report_id": i[1] == "" || i[1] == null ? 0 : i[1],
                    "item_name": String(i[6]),
                    "parent": i[2] == "" ? null : i[2],
                    "weight": String(i[7]),
                    "uom": String(i[8]),
                    "kpi_type": i[9] == null ? "" : i[9].value,
                    "max_ach": i[10] == null ? "" : i[10].value,
                    "formula": i[11] == null ? "" : i[11].value,
                    "total_actual_before": String(i[12]) == "" ? "0.0" : String(i[12]),
                    "january": i[13].formula != undefined ? String((Number(i[13]?.formula[0].value))/1000) : String(i[13]),
                    "february": i[14].formula != undefined ? String((Number(i[14]?.formula[0].value))/1000) : String(i[14]),
                    "march": i[15].formula != undefined ? String((Number(i[15]?.formula[0].value))/1000) : String(i[15]),
                    "april": i[16].formula != undefined ? String((Number(i[16]?.formula[0].value))/1000) : String(i[16]),
                    "may": i[17].formula != undefined ? String((Number(i[17]?.formula[0].value))/1000) : String(i[17]),
                    "june": i[18].formula != undefined ? String((Number(i[18]?.formula[0].value))/1000) : String(i[18]),
                    "july": i[19].formula != undefined ? String((Number(i[19]?.formula[0].value))/1000) : String(i[19]),
                    "august": i[20].formula != undefined ? String((Number(i[20]?.formula[0].value))/1000) : String(i[20]),
                    "september": i[21].formula != undefined ? String((Number(i[21]?.formula[0].value))/1000) : String(i[21]),
                    "october": i[22].formula != undefined ? String((Number(i[22]?.formula[0].value))/1000) : String(i[22]),
                    "november": i[23].formula != undefined ? String((Number(i[23]?.formula[0].value))/1000) : String(i[23]),
                    "december": i[24].formula != undefined ? String((Number(i[24]?.formula[1].value))/1000) : String(i[24]),
                    "total_current_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][2]?.value)/1000) : String(i[25]),
                    "total_next_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][0]?.value)/1000) : String(i[26]),
                    "total_more_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][1]?.value)/1000) : String(i[27]),
                    "strategic": String(i[28]),
                    "pic": String(i[29])
                })
            } else {
                data.push({
                    "item_report_id": i[1] == "" || i[1] == null ? 0 : i[1],
                    "item_name": String(i[6]),
                    "parent": i[2] == "" ? null : i[2],
                    "weight": String(i[7]),
                    "uom": String(i[8]),
                    "kpi_type": i[9] == null ? "" : i[9].value,
                    "max_ach": i[10] == null ? "" : i[10].value,
                    "formula": i[11] == null ? "" : i[11].value,
                    "total_actual_before": String(i[12]) == "" ? "0.0" : String(i[12]),
                    "january": i[13].formula != undefined ? String((Number(i[13]?.formula[0].value))/1000) : String(i[13]),
                    "february": i[14].formula != undefined ? String((Number(i[14]?.formula[0].value))/1000) : String(i[14]),
                    "march": i[15].formula != undefined ? String((Number(i[15]?.formula[0].value))/1000) : String(i[15]),
                    "april": i[16].formula != undefined ? String((Number(i[16]?.formula[0].value))/1000) : String(i[16]),
                    "may": i[17].formula != undefined ? String((Number(i[17]?.formula[0].value))/1000) : String(i[17]),
                    "june": i[18].formula != undefined ? String((Number(i[18]?.formula[0].value))/1000) : String(i[18]),
                    "july": i[19].formula != undefined ? String((Number(i[19]?.formula[0].value))/1000) : String(i[19]),
                    "august": i[20].formula != undefined ? String((Number(i[20]?.formula[0].value))/1000) : String(i[20]),
                    "september": i[21].formula != undefined ? String((Number(i[21]?.formula[0].value))/1000) : String(i[21]),
                    "october": i[22].formula != undefined ? String((Number(i[22]?.formula[0].value))/1000) : String(i[22]),
                    "november": i[23].formula != undefined ? String((Number(i[23]?.formula[0].value))/1000) : String(i[23]),
                    "december": i[24].formula != undefined ? String((Number(i[24]?.formula[1].value))/1000) : String(i[24]),
                    "total_current_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : String(Number(i[30].length)) > 0 ? String(Number(i[30][2]?.value)/1000) : String(i[25]),
                    "total_next_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][0]?.value)/1000) : String(i[26]),
                    "total_more_year": i[30] == undefined || String(Number(i[30])) == "" ? "0.0" : (Number(i[30].length)) > 0 ? String(Number(i[30][1]?.value)/1000) : String(i[27]),
                    "strategic": String(i[28]),
                    "pic": String(i[29])
                })
            }

        })
        // // // console.log(JSON.stringify(data))
        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "status": type,
            "cat": data
        }
        console.log(JSON.stringify(payload));
        this.deleteReport(payload, type)
    }

    deleteReport(payloadBro, type) {
        let payload = { "item_report_id": this.state.dataDelete }

        if (this.state.dataDelete.length > 0) {
            api.create().deleteAllItemReport(payload).then((response) => {
                console.log(response)

                // api.create().validateSubmitReport(payloadBro).then((response) => {
                //     // // // // console.log(response)
                //     if (response.data.data.result) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.saveToMasterBudget(payloadBro, 'CAT')
                        // this.props.onClickClose()
                    } else {
                        this.props.saveToMasterBudget(payloadBro, 'DraftCAT')
                        // this.props.onClickClose()
                    }
                } else {
                    if (response.data?.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                }

                // this.props.saveToMasterBudget(payloadBro)
                // this.props.onClickClose()
                //     } else {

                //     }
                // })
            })
        } else {
            console.log("kesini bukan?");
            // // // // // console.log('sini jing')
            // api.create().validateSubmitReport(payloadBro).then((response) => {
            //     // // // // console.log(response)
            //     if (response.data.data.result) {
            this.props.saveToMasterBudget(payloadBro, 'CAT')
            this.props.onClickClose()
            //     } else {

            //     }
            // })
        }
    }


    getKPIType() {
        let body = {
            group: 'CAT',
            company_id: this.props.company.company_id,
            type: 'KPI_TYPE'
        }
        api.create().getAllSettingByType(body).then(response => {
            // // // // // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        // // // // console.log(data)
                        let inputKPI = []

                        data.map((item) => {
                            inputKPI.push({
                                value: item.value
                            })
                        })
                        let defaultProps = {
                            options: inputKPI,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // // // // console.log(defaultProps)
                        this.setState({ kpiTypeList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getMaxAch() {
        let body = {
            group: 'CAT',
            company_id: this.props.company.company_id,
            type: 'MAX_ACHIEVEMENT'
        }
        api.create().getAllSettingByType(body).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputMaxAch = data.map((item) => {
                            return {
                                value: item.value
                            }
                        })
                        let defaultProps = {
                            options: inputMaxAch,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // setTimeout(() => {
                        this.setState({ maxAchList: defaultProps })
                        // }, 300);
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
            this.getItemHierarki()
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
        }
        api.create().getLastestUpdateMB(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? '-' : response.data.data.detail
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    render() {
        let dataTable2 = this.state.dataTable
        let dataDelete = this.state.dataDelete
        const handleChange = (value, tableMeta) => {
            let val = String(value).split(",").join("")
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }

        const handleValueFormula = (value, tableMeta, column, periode, forecast) => {
            // loading = true
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else if (item == '' || item == '@') {

                } else if (item == "CurrMonth") {
                    anjay.push(String(column))
                } else if (item.includes('[CM]SUM')) {
                    let columnStart = 13
                    let indexX = String(item).indexOf('[')
                    let formulaAwal = String(item).substr(0, indexX)
                    let columnEnd = 24
                    let month = column - 1
                    let total = 0
                    // // // console.log(formulaAwal)
                    if (forecast == undefined) {
                        dataTable2[tableMeta.rowIndex].map((itemz, indexz) => {
                            if (indexz >= columnStart && indexz <= columnStart + month) {
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${formulaAwal}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = Number(value.formula[indexID].value)
                                    total += valuezz
                                }
                            }
                        })
                    } else {

                    }
                    anjay.push(String(total))
                } else if (item.includes('[CM]AVG')) {
                    if (forecast == undefined) {
                        anjay.push('/')
                        anjay.push(column)
                    }
                } else if (item.includes('X')) {
                    let indexX = String(item).indexOf('X')
                    // console.log(item)
                    if (indexX == 0) {
                        anjay.push(String(item).substr(1, String(item).length))
                    } else {
                        let formulaAwal = String(item).substr(0, indexX - 1)
                        let operatorX = String(item).substr(indexX - 1, 1)
                        let nilaiX = String(item).substr(indexX + 1, String(item).length)

                        if (forecast == undefined) {
                            let convertID = -1
                            if (tableMeta.rowData[11].value == 'FORMULA') {
                                let indexIDReport = dataTable2.findIndex((val) => val[1] == formulaAwal)
                                convertID = dataTable2[indexIDReport][31]
                                let indexID = dataTable2.findIndex((val) => val[31] == (convertID == -1 ? item : convertID))
                                let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            } else {
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${formulaAwal}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = value.formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        } else {
                            let convertID = -1
                            if (tableMeta.rowData[11].value == 'FORMULA') {
                                let indexIDReport = dataTable2.findIndex((val) => val[1] == formulaAwal)
                                convertID = dataTable2[indexIDReport][31]
                                let indexID = dataTable2.findIndex((val) => val[31] == (convertID == -1 ? item : convertID))
                                let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            } else {
                                // // // console.log(dataTable2[tableMeta.rowIndex][30])
                                let array = dataTable2[tableMeta.rowIndex][30].filter((val) => val.periode == Number(column))
                                if (array.length > 0 && array[0] != undefined) {
                                    let valuezz = array[0].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                                // // // console.log(valuezz)
                            }

                            // let indexID = dataTable2[tableMeta.rowIndex][30].findIndex((val) => val.periode == Number(this.props.periode))
                            // if (indexID !== -1) {
                            //     let valuezz = value.formula[indexID].value
                            //     anjay.push(valuezz == "" ? 0 : valuezz)
                            // }
                        }

                        anjay.push(operatorX)
                        anjay.push(nilaiX)
                    }
                } else {
                    if (String(item).includes('#')) {
                        if (forecast == undefined) {
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                            if (indexID !== -1) {
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" || valuezz == null ? "0" : valuezz)
                            }
                        } else {
                            let array = dataTable2[tableMeta.rowIndex][30].filter((val) => val.periode == Number(column))
                            let valuezz = array[0].value
                            anjay.push(valuezz == "" ? 0 : valuezz)
                        }
                    } else {
                        let convertID = -1
                        if (tableMeta.rowData[11].value == 'FORMULA') {
                            let indexIDReport = dataTable2.findIndex((val) => val[1] == item)
                            // console.log(indexIDReport);
                            if (indexIDReport != -1) {
                                convertID = dataTable2[indexIDReport][31]
                            }
                        }
                        let indexID = dataTable2.findIndex((val) => val[31] == (convertID == -1 ? item : convertID))
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                            if (item == dataTable2[tableMeta.rowIndex][31]) {
                                anjay.push(0)
                            } else {
                                anjay.push(valuezz == "" ? "0" : valuezz)
                            }
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                        }
                    }
                }
            })
            // if (tableMeta.rowData[11].value == 'FORMULA') {
            //     console.log(anjay)
            //     console.log(column)

            // }

            let anjay2 = []
            let kurung = false
            let item1 = []
            let brpKurung = 0
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                    // brpKurung += 1
                } else if (item == ")") {
                    // brpKurung -= 1
                    // if (brpKurung == 0) {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                    // }
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })
            // if (dataTable2[tableMeta.rowIndex][6] == "NPAT" && forecast !== undefined) {
            //     // // console.log(tableMeta.rowData[3])
            //     // // console.log(splitFormula)
            //     // // console.log(baru)
            //     // // console.log(anjay)
            //     // // // console.log(item1)
            //     // // console.log(anjay2)
            //     // // console.log(total)
            // }
            // // // console.log(tableMeta.rowData[3])
            // // // console.log(splitFormula)
            // // // console.log(baru)
            // // // console.log(anjay)
            // // // console.log(item1)
            // // // console.log(anjay2)
            // // // console.log(total)

            total = R.equals(total, NaN) ? "0.0" : total
            // console.log(total);
            // if (dataTable2[tableMeta.rowIndex][6] == "ROIC") {
            //     if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
            //         dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = "0"
            //     } else {
            //         dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = "0"
            //     }
            // } else {
            if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
            }
            // }

            return total
        }

        const handleValueForecast = (value, tableMeta, periode) => {
            return handleValueFormula(value, tableMeta, periode, periode, 'forecast')
        }

        const handleChangeDropdown = (value, tableMeta) => {
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
            let valz = value.value
            let total = 0
            let lastValz = 0
            if (valz == 'SUM' || valz == 'AVG' || valz == 'LAST' || valz == 'FORMULA') {
                dataTable2[tableMeta.rowIndex].map((item, index) => {
                    if (index >= 13 && index <= 24) {
                        let valItem = item == undefined || item == "" ? 0 : item
                        total += Number(valItem)
                        if (index == 24) {
                            lastValz += Number(valItem)
                        }
                    }
                })
                if (valz == 'FORMULA') {
                    dataTable2[tableMeta.rowIndex][0] = 5
                } else {
                    dataTable2[tableMeta.rowIndex][0] = 3
                }
                dataTable2[tableMeta.rowIndex][25] = valz == 'FORMULA' ? 0 : ((valz == 'SUM' ? total : (valz == 'AVG' ? (total / 12) : lastValz)))
            }
        }
        const handleValueDropdown = (value, type, tableMeta) => {
            let data = type == 'KPI' ? this.state.kpiTypeList.options : (type == 'MAX' ? this.state.maxAchList.options : this.state.formulaYtdList.options)
            let index = 0
            if (value == null) {
                index = -1
            } else {
                index = data.findIndex((val) => val.value == value.value)
            }
            if (index == -1) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = null
                return null
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
                return value
            }
        }

        const handleChangePercentage = (value, tableMeta) => {
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value

        }

        const handleChangeText = (value, tableMeta) => {
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
        }

        const handleAction = (idParent, typeReport, tableMeta) => {
            if (this.props.isApprover) {
                return false
            } else {
                if ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) {
                    if (idParent !== null) {
                        let indexsss = dataTable2.findIndex((val) => val[1] == idParent)
                        if (dataTable2[indexsss][6] == 'CUSTOMER PERSPECTIVE' || dataTable2[indexsss][6] == 'INTERNAL BUSINESS PROCESS PERSPECTIVE') {
                            return true
                        } else {
                            return false
                        }
                    } else {
                        if (typeReport == null || typeReport == 3) {
                            return true
                        } else if (tableMeta !== undefined && tableMeta.rowData[0] == 1) {
                            let indexID = dataTable2.findIndex((val) => val[2] == tableMeta.rowData[1])
                            if (indexID !== -1) {
                                return false
                            } else {
                                return true
                            }
                        } else {
                            return false
                        }
                    }
                } else {
                    return false
                }
            }

        }

        const handleReturnFormula = (idParent, tableMeta) => {
            if (idParent !== null) {
                let indexsss = dataTable2.findIndex((val) => val[1] == idParent)
                if (dataTable2[indexsss][6] == 'FINANCIAL PERSPECTIVE') {
                    if (tableMeta.rowData[0] == 3) {
                        return false
                    } else {
                        return true
                    }
                } else {
                    return false
                }
            } else {
                return false
            }
        }

        const handleTambah = (data, rowIndex) => {
            // // // console.log(dataTable2)
            let newData = []
            dataTable2.map((item, index) => {
                newData.push(item)
                if (index == rowIndex) {
                    newData.push([
                        null,
                        "",
                        item[2] == null || item[2] == "" ? item[1] : item[2],
                        item[3],
                        item[4],
                        "",
                        "",
                        "",
                        "",
                        null,
                        null,
                        null,
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        ""
                    ])

                }
            })
            dataTable2 = newData
            this.setState({ dataTable: dataTable2 }, () => {
                setTimeout(() => {
                    this.setState({ loading: false })
                    // // // console.log(dataTable2)
                }, 500)
            })
        }

        const handleDelete = (index) => {
            if (dataTable2[index][1] !== "") {
                dataDelete.push(dataTable2[index][1])
            }
            dataTable2.splice(index, 1)
            this.setState({ dataTable: dataTable2, dataDelete }, () => {
                setTimeout(() => {
                    this.setState({ loading: false })
                }, 100)
            })
        }

        const handleTotal = (tableMeta, type) => {
            // let val = String(value).split(",").join("")
            let total = 0
            let lastValz = 0
            // if (type === 'roic') {
            //     dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = tableMeta.rowData[24]
            //     total = Number(tableMeta.rowData[24])
            //     return total
            // } else {
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index >= 13 && index <= 24) {
                    let valItem = item == undefined || item == "" ? 0 : item
                    total += Number(valItem)
                    if (index == 24) {
                        lastValz += Number(valItem)
                    }
                }
            })
            let valz = dataTable2[tableMeta.rowIndex][11] == null ? 'SUM' : dataTable2[tableMeta.rowIndex][11].value
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = (valz == 'SUM' ? total : (valz == 'AVG' ? (total / 12) : lastValz))
            return (valz == 'SUM' ? total : (valz == 'AVG' ? (total / 12) : lastValz))
            // }
        }
        // console.log(dataTable2)

        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                filter: false,
                display: this.props.isApprover ? false : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? true : false),
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#dbdbdb' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (val, tableMeta) => {
                    return (
                        // handleAction(tableMeta.rowData[2]) &&
                        <div style={{ display: 'flex' }}>
                            {/* {tableMeta.rowData[6] === "Active" ? */}
                            {handleAction(tableMeta.rowData[2], tableMeta.rowData[0], tableMeta) && <span>
                                <LightTooltip title={'Add'} arrow>
                                    <button
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                        }}
                                        // onClick={() => // // // // console.log(tableMeta.rowData[1])}
                                        onClick={() => {
                                            this.setState({ loading: true })
                                            handleTambah(tableMeta.rowData[1], tableMeta.rowIndex)
                                        }}
                                    >
                                        <img src={Images.add} />
                                    </button>
                                </LightTooltip>
                            </span>}
                            {handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) && <span>
                                <LightTooltip title={'Delete'} arrow>
                                    <button
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            marginLeft: 5
                                        }}
                                        onClick={() => {
                                            this.setState({ loading: true })
                                            handleDelete(tableMeta.rowIndex)
                                        }}
                                    >
                                        <img src={Images.delete} />
                                    </button>
                                </LightTooltip>
                            </span>}
                        </div >
                    );
                }
            }
        }, {
            name: "Key Performance Indicator",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        handleAction(tableMeta.rowData[2], tableMeta.rowData[0], tableMeta) && (tableMeta.rowData[1] == "" || String(this.props.status).toLocaleLowerCase() == 'draft' || String(this.props.status).toLocaleLowerCase() == 'submitted' || String(this.props.status).toLocaleLowerCase() == 'revision') ?
                            <div style={{ textAlign: 'left', paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                {!this.state.loading && <FormControlLabel
                                    style={{ margin: 0 }}
                                    control={
                                        <Input
                                            disableUnderline={true}
                                            style={{ color: tableMeta.rowData[1] == "" ? "#5198ea" : "black", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            defaultValue={val}
                                            // disabled={!handleAction(tableMeta.rowData[2])}
                                            onBlur={(event) => {
                                                // // // // console.log(event.target.value)
                                                handleChangeText(event.target.value, tableMeta)
                                                // // // console.log(dataTable2)
                                            }}
                                        />
                                    }
                                />}
                            </div>
                            :
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[32] ?
                                    tableMeta.rowData[32].length > 0 ?
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                        :
                                        tableMeta.rowData[4] == 0 ?
                                            <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                            :
                                            tableMeta.rowData[1] == null ?
                                                <div style={{ paddingLeft: 20 }}>
                                                    <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                                </div>
                                                :
                                                <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                    <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                                </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        tableMeta.rowData[1] == null ?
                                            <div style={{ paddingLeft: 20 }}>
                                                <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </div>
                                            :
                                            <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </div>
                                }
                            </div>
                    )
                }
            }
        }, {
            name: "Weight",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                tableMeta.rowData[0] === 1 ?
                                    value
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    suffix="%"
                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={value}
                                                    disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                    maxLength={5}
                                                    onBlur={(event) => {
                                                        // updateValue(some)
                                                        handleChangePercentage(event.target.value, tableMeta)
                                                    }}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "UOM",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    // value={value}
                                    control={
                                        !handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) ?
                                            <Input
                                                disableUnderline={true}
                                                style={{ fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginTop: -10 }}
                                                type="text"
                                                placeholder=""
                                                defaultValue={value}
                                                color={"#5198ea"}
                                                disabled={true}
                                                onBlur={(event) => {
                                                    // // // // console.log(event.target.value)
                                                    // updateValue(event.target.value)
                                                    handleChangeText(event.target.value, tableMeta)
                                                    // // // // console.log(dataTable2)
                                                }}
                                            /> :
                                            <ThemeProvider theme={theme}>
                                                <Input
                                                    disableUnderline={true}
                                                    style={{ fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginBottom: -5 }}
                                                    type="text"
                                                    placeholder=""
                                                    defaultValue={value}
                                                    color={"#5198ea"}
                                                    // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false ? false : !handleAction(tableMeta.rowData[2]))}
                                                    onBlur={(event) => {
                                                        // // // // console.log(event.target.value)
                                                        // updateValue(event.target.value)
                                                        handleChangeText(event.target.value, tableMeta)
                                                        // // // // console.log(dataTable2)
                                                    }}
                                                />
                                            </ThemeProvider>
                                    }
                                />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "KPI Type",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <Autocomplete
                                    {...this.state.kpiTypeList}
                                    id="kpiType"
                                    onChange={(event, newInputValue) => handleChangeDropdown(newInputValue, tableMeta)}
                                    debug
                                    disableClearable
                                    disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                    value={handleValueDropdown(val, 'KPI', tableMeta)}
                                    style={{ padding: 0, margin: 0 }}
                                    renderInput={(params) =>
                                        <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                            <input style={{ borderColor: 'white', width: 96, textAlign: 'center', padding: 0, margin: 0, color: handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) ? "#5198ea" : "black" }} type="text" {...params.inputProps} />
                                        </div>
                                    }
                                />
                            }

                        </div>
                    )
                }
            }
        }, {
            name: "Max Ach.",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <Autocomplete
                                    {...this.state.maxAchList}
                                    id="maxAchList"
                                    onChange={(event, newInputValue) => handleChangeDropdown(newInputValue, tableMeta)}
                                    debug
                                    disableClearable
                                    value={handleValueDropdown(val, 'MAX', tableMeta)}
                                    style={{ padding: 0, margin: 0 }}
                                    disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                    renderInput={(params) =>
                                        <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                            <input style={{ borderColor: 'white', width: 96, textAlign: 'center', padding: 0, margin: 0, color: handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) ? "#5198ea" : "black" }} type="text" {...params.inputProps} />
                                        </div>
                                    }
                                    // value={this.state.parent}
                                />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Formula YTD",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div style={{ width: 105 }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <Autocomplete
                                    {...this.state.formulaYtdList}
                                    id="formulaYtdList"
                                    onChange={(event, newInputValue) => {
                                        // updateValue(newInputValue)
                                        handleChangeDropdown(newInputValue, tableMeta)
                                    }
                                    }
                                    debug
                                    disableClearable
                                    value={handleValueDropdown(val, 'FORMULA', tableMeta)}
                                    disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                    style={{ padding: 0, margin: 0 }}
                                    renderInput={(params) =>
                                        <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                            <input style={{ borderColor: 'white', width: 105, textAlign: 'center', padding: 0, margin: 0, color: handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) ? "#5198ea" : "black" }} type="text" {...params.inputProps} />
                                        </div>
                                    }
                                    // value={this.state.parent}
                                />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) - 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null
                                :
                                <div style={{ flex: 1 }}>
                                    {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && tableMeta.rowData[11].value == 'FORMULA' ?
                                        // null
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 2)}
                                                    disabled
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    onBlur={(event) => {
                                                        // updateValue(event.target.value)
                                                        handleChange(event.target.value, tableMeta)
                                                        // // // // console.log(tableMeta.rowData[0])
                                                    }}
                                                />
                                            }
                                        />
                                        :
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                    disabled={true}
                                                    //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    onBlur={(event) => {
                                                        // updateValue(event.target.value)
                                                        handleChange(event.target.value, tableMeta)
                                                        // // // // console.log(dataTable2)
                                                    }}
                                                />
                                            }
                                        />}
                                </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    // // // // console.log(tableMeta.rowData[0])
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 2)}
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // // // console.log(tableMeta.rowData[0])
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                // null
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 2)}
                                                            disabled
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                                :
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                            disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            }
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Feb ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 2)}
                                                        disabled={true}
                                                        //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // // // console.log(tableMeta.rowData[0])
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                // null
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 2)}
                                                            disabled
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                                :
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                            disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            }
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Mar ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Apr ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 4)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 4)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 4)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 4)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `May ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 5)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 5)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 5)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 5)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jun ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 6)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 6)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 6)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 6)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jul ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 7)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 7)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 7)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 7)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Aug ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 8)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 8)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 8)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 8)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Sep ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 9)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 9)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 9)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 9)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Oct ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 10)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 10)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 10)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 10)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Nov ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 11)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 11)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 11)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 11)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Dec ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 12)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 12)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 12)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 12)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${this.props.periode} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <div style={{ flex: 1 }}>
                                //         <FormControlLabel
                                //             style={{ margin: 0 }}
                                //             value={value}
                                //             control={
                                //                 <NumberFormat
                                //                     thousandSeparator={true}
                                //                     style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                     type="text"
                                //                     placeholder=""
                                //                     value={Number(handleTotal(tableMeta, 'roic')).toFixed(1)}
                                //                     disabled={true}
                                //                     onBlur={(event) => {
                                //                         // updateValue(event.target.value)
                                //                         handleChange(event.target.value, tableMeta)
                                //                         // // // // console.log(tableMeta.rowData[0])
                                //                     }}
                                //                 />
                                //             }
                                //         />
                                //     </div> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueForecast(value, tableMeta, this.props.periode)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueForecast(value, tableMeta, this.props.periode)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 13)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 13)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleTotal(tableMeta)), 2) == 0 ? "0.00" : fixNumber(Number(handleTotal(tableMeta)), 2)}
                                                                disabled={true}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) + 1} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueForecast(value, tableMeta, Number(this.props.periode) + 1)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueForecast(value, tableMeta, Number(this.props.periode) + 1)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 14)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 14)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={false}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) + 2} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                // tableMeta.rowData[6] === 'ROIC' ?
                                //     <FormControlLabel
                                //         style={{ margin: 0 }}
                                //         value={value}
                                //         control={
                                //             <NumberFormat
                                //                 thousandSeparator={true}
                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                //                 type="text"
                                //                 placeholder=""
                                //                 value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                //                 disabled={true}
                                //                 onBlur={(event) => {
                                //                     // updateValue(event.target.value)
                                //                     handleChange(event.target.value, tableMeta)
                                //                     // // // // console.log(tableMeta.rowData[0])
                                //                 }}
                                //             />
                                //         }
                                //     /> :
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    (handleReturnFormula(tableMeta.rowData[2], tableMeta) && this.props.status !== 'CLOSED' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={fixNumber(Number(handleValueForecast(value, tableMeta, Number(this.props.periode) + 2)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueForecast(value, tableMeta, Number(this.props.periode) + 2)), 2)}
                                                            disabled={true}
                                                            //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // // // // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {(tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7) && this.props.status !== 'CLOSED' ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(handleValueFormula(value, tableMeta, 16)), 2) == 0 ? "0.00" : fixNumber(Number(handleValueFormula(value, tableMeta, 16)), 2)}
                                                                disabled
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={fixNumber(Number(value), 2) == 0 ? "0.00" : fixNumber(Number(value), 2)}
                                                                disabled={false}
                                                                //decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // // // // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                    )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Strategic Initiative",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    control={
                                        <ThemeProvider theme={theme}>
                                            <Input
                                                disableUnderline={true}
                                                style={{ fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginBottom: -5 }}
                                                type="text"
                                                placeholder=""
                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                defaultValue={value}
                                                onBlur={(event) => {
                                                    // // // // console.log(event.target.value)
                                                    handleChangeText(event.target.value, tableMeta)
                                                    // // // // console.log(dataTable2)
                                                }}
                                            />
                                        </ThemeProvider>

                                    }
                                />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "PIC",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    // value={value}
                                    control={
                                        <ThemeProvider theme={theme}>
                                            <Input
                                                disableUnderline={true}
                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginBottom: -5 }}
                                                type="text"
                                                placeholder=""
                                                disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                defaultValue={value}
                                                onBlur={(event) => {
                                                    // // // // console.log(event.target.value)
                                                    // updateValue(event.target.value)
                                                    handleChangeText(event.target.value, tableMeta)
                                                    // // // // console.log(dataTable2)
                                                }}
                                            />
                                        </ThemeProvider>

                                    }
                                />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        },
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 1500, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Master Budget Submission</Typography>
                </div>
                {/* {this.state.loading && loadingComponent} */}
                <Snackbar open={this.state.alert} autoHideDuration={3000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleCAT ? <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Master Budget - Corporate Annual Target</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR bio</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD mio</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.state.dataTable.length == 0 ? null : this.props.isApprover == true ?
                                            null
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                {((!this.props.truelyApprover) && (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.downloadTemplate()}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>}
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                {((!this.props.truelyApprover) && (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true, buttonDraft: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>}
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() =>
                                                        // this.setState({ loading: true }, () => {
                                                        //     setTimeout(() => {
                                                        this.downloadAllData()}
                                                //     }, 100);
                                                // })}
                                                >
                                                    <img src={Images.download} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                    return (
                                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                    )
                                                }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                            </div>
                            <div className="grid grid-2x">
                                <div className="col-1">
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                        }}
                                        onClick={() =>
                                            this.setState({ loading: true }, () => {
                                                setTimeout(() => {
                                                    this.props.onClickClose()
                                                }, 100)
                                            })}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {!this.props.isApprover && <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                    {((!this.props.truelyApprover) && (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() =>
                                            this.setState({ loading: true, dataTable: dataTable2, buttonDraft: false }, () => {
                                                setTimeout(() => {
                                                    this.handleValidate()
                                                }, 100);
                                            })
                                        }
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>}
                                    {((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: this.state.editable !== true ? 'pointer' : 'default',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        disabled={this.state.buttonDraft}
                                        onClick={() =>
                                            this.state.editable === true ?
                                                this.setState({ alert: true }) :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1 }, () => {
                                                        this.backToMasterBudget('draft')
                                                    })
                                        }
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>}
                                    {((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && <button
                                        type="button"
                                        disabled={this.state.buttonDraft}
                                        onClick={() =>
                                            this.state.editable ? this.setState({ alert: true }) :
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.backToMasterBudget('submitted')
                                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>}
                                </div>}
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode}</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR bio</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD mio</Typography>
                                        }
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                <div className="grid grid-2x">
                                    <div className="col-1">
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                            }}
                                            onClick={() =>
                                                this.setState({ loading: true, visibleCAT: true, dataTable: [] }, () => {
                                                    setTimeout(() => {
                                                        this.getItemHierarki()
                                                    }, 100)
                                                })}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    {!this.props.isApprover && <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        {(this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && <button
                                            type="button"
                                            onClick={() =>
                                                this.setState({ loading: true, dataTable: dataTable2, buttonDraft: false }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                        this.setState({ loading: false, buttonError: this.state.errorPreview === true ? true : false })
                                                    }, 100)
                                                })
                                            }
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {(this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && <button
                                            className="button"
                                            type="button"
                                            disabled={this.state.buttonDraft ? true : this.state.handleDataSalah ? true : false}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable === true ? 'default' : this.state.handleDataSalah ? 'default' : 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => this.state.editable ?
                                                this.setState({ alert: true }) : (this.state.handleDataSalah ? null : this.setState({ loading: true }, () =>
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            setTimeout(() => {
                                                                this.uploadCAT("draft")
                                                            }, 100);
                                                        })
                                                ))
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {(this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && <button
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable === true ? 'default' : this.state.handleDataSalah ? 'default' : 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                            disabled={this.state.buttonDraft ? true : this.state.handleDataSalah ? true : false}
                                            onClick={() =>
                                                this.state.editable ? this.setState({ alert: true }) :
                                                    this.state.buttonError === true ?
                                                        this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' }) : (this.state.handleDataSalah ? null : this.setState({ loading: true }, () =>
                                                            this.state.handleDoubleClick == 1 ? null :
                                                                this.setState({ handleDoubleClick: 1 }, () => {
                                                                    setTimeout(() => {
                                                                        this.uploadCAT("submitted")
                                                                    }, 100);
                                                                })
                                                        ))
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>}
                                </div>
                            </div>
                        </Paper>}
                </div>

                {
                    this.state.visibleUpload && (
                        <div className="test app-popup-show">
                            <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                                <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                    <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                        <div className="popup-title">
                                            <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                        </div>
                                    </div>
                                    <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                        <button
                                            type="button"
                                            className="btn btn-circle btn-white"
                                            onClick={() => this.setState({ visibleUpload: false })}
                                        >
                                            <img src={Images.close} />
                                        </button>
                                    </div>
                                </div>
                                <div style={{ padding: '25px 30px' }}>
                                    <UploadFile
                                        type={this.state.uploadStatus}
                                        percentage={this.state.percentage}
                                        result={this.state.result}
                                        acceptedFiles={["xlsx"]}
                                        onHandle={(dt) => {
                                            this.fileHandler(dt)
                                            this.setState({ uploadStatus: 'idle', percentage: '0' })
                                        }}
                                        onUpload={() => {
                                            String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("BUDGET") && String(this.state.judul).includes("CAT") ?
                                                this.checkUpload() :
                                                this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                        }}
                                    />
                                </div>
                                <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>

                            </div>
                        </div>
                    )
                }

                {
                    this.state.visibleAlertSave && (
                        <div className="test app-popup-show">
                            <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                                <div style={{ margin: 30 }}>
                                    <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                        <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                            <img src={Images.warning} />
                                        </div>
                                        <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                            <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                background: '#F6F7F9',
                                                cursor: 'pointer',
                                                border: '1px solid #3549609e',
                                                outline: 'none',
                                                marginRight: 20,
                                                borderRadius: 9
                                            }}
                                            onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                                <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            </div >
        );
    }
}
