import { createMuiTheme, FormControlLabel, MuiThemeProvider, TableCell, Typography } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import NumberFormat from 'react-number-format';
import Constant from '../../library/Constant';


var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};
export default class TableSummaryTriputra extends Component {

    getInputColor = ({ val, column }) => {
        // const COLUMN_INDEX = {
        //     MTD: 37,
        //     YTD: 45,
        //     CPSM: 49,
        // };
        // if (val[2] === 0 || val[2] === 1) {
        //     return Constant.COLORS_TEXT_COLUMNS.disabled;
        // }

        // const idx = COLUMN_INDEX[column];
        // if (idx === undefined) {
        //     return Constant.COLORS_TEXT_COLUMNS.disabled;
        // }

        // return val[idx]
        //     ? Constant.COLORS_TEXT_COLUMNS.disabled
        //     : Constant.COLORS_TEXT_COLUMNS.active;
        return Constant.COLORS_TEXT_COLUMNS.disabled
    };


    formattingNumber = (v, decimal = 1) => {
        if (v === null || v === undefined || v === '') return '';

        const str = String(v).trim();
        const isPercent = str.endsWith('%');

        const num = parseFloat(str.replace('%', ''));

        if (!Number.isFinite(num)) return '';

        const result = num.toFixed(decimal);
        return isPercent ? `${result}%` : result;
    };


    render() {
        let dataTable2 = this.props.dataTable

        const columnMTD = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {
                                    tableMeta.rowData[2] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[2]) }}>
                                            <span style={{ fontSize: 12 }}>{val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `MTD ${Number(this.props.periode)}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-4x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"Revenue"}</span>
                                    </div>
                                    <div className="grid grid-3x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"EBITDA"}</span>
                                    </div>
                                    <div className="grid grid-3x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"TPAT"}</span>
                                    </div>
                                    <div className="grid grid-3x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"NPAT"}</span>
                                    </div>
                                    <div className="grid grid-3x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // if (tableMeta.rowData[3] == "ABA" ) {
                        //     console.log(tableMeta.rowData);
                        // }
                        return (
                            <div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        <div className="grid grid-3x content-center">
                                            <div className="col-1" style={{ padding: 0, left: -15 }} >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[4])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[5])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={'%'}
                                                                value={this.formattingNumber(tableMeta.rowData[6])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div className="grid grid-3x content-center">
                                            <div className="col-1">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[7])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[8])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[9])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div className="grid grid-3x content-center">
                                            <div className="col-1">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[10])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[11])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[12])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-4">
                                        <div className="grid grid-3x content-center">
                                            <div className="col-1">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[13])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[14])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[15])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                },
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `MTD ${Number(this.props.periode)} (OPTIONAL)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="column-5" style={{ ...style2, display: 'flex', backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65, width: 685 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"Cash Flow"}</span>
                                    </div>
                                    <div className="grid grid-4x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CFO"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CFI"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CFF"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Net CF"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65, width: 685 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25, color: '#000000c4' }}>
                                        <span>{"OS Bank Loan"}</span>
                                    </div>
                                    <div className="grid grid-4x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"KI"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"WC"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Others"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Total"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', width: 200, alignItems: 'center', backgroundColor: '#07a7d0', height: 65 }}>
                                    <span>{"OS SHL"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65, width: 685 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25, color: '#000000c4' }}>
                                        <span>{"Balance Sheet"}</span>
                                    </div>
                                    <div className="grid grid-4x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Cash & Bank"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CA"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CL"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Equity"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65, width: 887 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25, color: '#000000c4' }}>
                                        <span>{"Financial Ratio"}</span>
                                    </div>
                                    <div className="grid grid-2x" style={{ height: 25 }}>
                                        <div className="column-1 grid grid-4x" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0' }}>
                                            <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"CR"}</span>
                                            </div>
                                            <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"DER"}</span>
                                            </div>
                                            <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"Debt to EBITDA"}</span>
                                            </div>
                                            <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"to Interest"}</span>
                                            </div>
                                        </div>
                                        <div className="column-2 grid grid-4x" style={{ justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0' }}>
                                            <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"AR Days"}</span>
                                            </div>
                                            <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"Inv Days"}</span>
                                            </div>
                                            <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"AP Days"}</span>
                                            </div>
                                            <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"CCC"}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[16])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[17])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[18])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[19])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[20])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[21])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[22])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[23])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'grid', width: 150 }}>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[24])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[25])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[26])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[27])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[28])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', width: 860, justifyContent: 'space-between' }}>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[29])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[30])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[31])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[32])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[33])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[34])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[35])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[36])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                },
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }
        ]

        const columnYTD = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {
                                    tableMeta.rowData[2] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[2]) }}>
                                            <span style={{ fontSize: 12 }}>{val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Revenue`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{`YTD ${this.props.periode}`}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"FY"}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`OL ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`MB ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1" style={{ padding: 0, left: -15 }} >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[4])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2" >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[5])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3" >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[6])}
                                                            // value={Number(String(tableMeta.rowData[6]).substr(0, String(tableMeta.rowData[6]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4" >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[7])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5" >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[8])}
                                                            // value={Number(String(tableMeta.rowData[8]).substr(0, String(tableMeta.rowData[8]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[9])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[10])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[11])}
                                                            // value={Number(String(tableMeta.rowData[11]).substr(0, String(tableMeta.rowData[11]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[12])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[13])}
                                                            // value={Number(String(tableMeta.rowData[13]).substr(0, String(tableMeta.rowData[13]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `EBITDA`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{`YTD ${Number(this.props.periode)}`}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"FY"}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`OL ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`MB ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1" style={{ padding: 0, left: -15 }} >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[14])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[15])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[16])}
                                                            // value={Number(String(tableMeta.rowData[16]).substr(0, String(tableMeta.rowData[16]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[17])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={"%"}
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[18])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[19])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[20])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[21])}
                                                            // value={Number(String(tableMeta.rowData[21]).substr(0, String(tableMeta.rowData[21]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[22])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[23])}
                                                            // value={Number(String(tableMeta.rowData[23]).substr(0, String(tableMeta.rowData[23]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `TPAT`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{`YTD ${Number(this.props.periode)}`}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"FY"}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`OL ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`MB ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1" style={{ padding: 0, left: -15 }} >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[24])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[25])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[26])}
                                                            // value={Number(String(tableMeta.rowData[16]).substr(0, String(tableMeta.rowData[16]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[27])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[28])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[29])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[30])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[31])}
                                                            // value={Number(String(tableMeta.rowData[21]).substr(0, String(tableMeta.rowData[21]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[32])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[33])}
                                                            // value={Number(String(tableMeta.rowData[23]).substr(0, String(tableMeta.rowData[23]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `NPAT`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{`YTD ${Number(this.props.periode)}`}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{"Act"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"MB"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"FY"}</span>
                                    </div>
                                    <div className="grid grid-5x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`OL ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{`MB ${Number(this.props.periode)}`}</span>
                                        </div>
                                        <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#37b5e6', height: 40, color: '#000000c4' }}>
                                            <span>{"% of MB"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                        <div className="column-5" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#008bffc4', height: 40 }}>
                                            <span>{`% of ${Number(this.props.periode) - 1}`}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1" style={{ padding: 0, left: -15 }} >
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[34])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[35])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[36])}
                                                            // value={Number(String(tableMeta.rowData[16]).substr(0, String(tableMeta.rowData[16]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[37])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[38])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div className="grid grid-5x content-center">
                                            <div className="col-1">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[39])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-2">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[40])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-3">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[41])}
                                                            // value={Number(String(tableMeta.rowData[21]).substr(0, String(tableMeta.rowData[21]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-4">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.formattingNumber(tableMeta.rowData[42])}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                            <div className="col-5">
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                suffix={"%"}
                                                                value={this.formattingNumber(tableMeta.rowData[43])}
                                                            // value={Number(String(tableMeta.rowData[23]).substr(0, String(tableMeta.rowData[23]).length - 1)).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `YTD ${Number(this.props.periode)} (OPTIONAL)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="column-5" style={{ ...style2, display: 'flex', backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', height: 65, width: 685 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25 }}>
                                        <span>{"Cash Flow"}</span>
                                    </div>
                                    <div className="grid grid-4x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CFO"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CFI"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CFF"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Net CF"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65, width: 685 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25, color: '#000000c4' }}>
                                        <span>{"OS Bank Loan"}</span>
                                    </div>
                                    <div className="grid grid-4x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"KI"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"WC"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Others"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Total"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', width: 200, alignItems: 'center', backgroundColor: '#07a7d0', height: 65 }}>
                                    <span>{"OS SHL"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65, width: 685 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25, color: '#000000c4' }}>
                                        <span>{"Balance Sheet"}</span>
                                    </div>
                                    <div className="grid grid-4x" style={{ height: 25 }}>
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Cash & Bank"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CA"}</span>
                                        </div>
                                        <div className="column-3" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"CL"}</span>
                                        </div>
                                        <div className="column-4" style={{ borderLeft: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                            <span>{"Equity"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#37b5e6', height: 65, width: 887 }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', color: 'white', height: 25, color: '#000000c4' }}>
                                        <span>{"Financial Ratio"}</span>
                                    </div>
                                    <div className="grid grid-2x" style={{ height: 25 }}>
                                        <div className="column-1 grid grid-4x" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0' }}>
                                            <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"CR"}</span>
                                            </div>
                                            <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"DER"}</span>
                                            </div>
                                            <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"Debt to EBITDA"}</span>
                                            </div>
                                            <div className="column-4" style={{ width: 125, justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"EBITDA to Interest"}</span>
                                            </div>
                                        </div>
                                        <div className="column-2 grid grid-4x" style={{ justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0' }}>
                                            <div className="column-1" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"AR Days"}</span>
                                            </div>
                                            <div className="column-2" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"Inv Days"}</span>
                                            </div>
                                            <div className="column-3" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"AP Days"}</span>
                                            </div>
                                            <div className="column-4" style={{ borderRight: '1px #fff solid', justifyContent: 'center', display: 'flex', alignItems: 'center', backgroundColor: '#07a7d0', height: 40 }}>
                                                <span>{"CCC"}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[46])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={(tableMeta.rowData[47])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[48])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[49])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[50])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[51])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[52])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[53])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'grid', width: 150 }}>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[54])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[55])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[56])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[57])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[58])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', width: 860, justifyContent: 'space-between' }}>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[59])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[60])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[61])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[62])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[63])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[64])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[65])}
                                                    />
                                                }
                                            />
                                        </div>
                                        <div >
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.getInputColor({ val: tableMeta.rowData }), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[66])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                },
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }
        ]

        const columnHistorical = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {
                                    tableMeta.rowData[2] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[2]) }}>
                                            <span style={{ fontSize: 12 }}>{val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Revenue`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 10}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 9}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 8}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 7}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 6}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 5}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 4}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 3}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 2}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 1}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[4])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[5])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[6])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[7])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[8])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[9])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[10])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[11])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[12])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[13])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `EBITDA`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 10}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 9}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 8}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 7}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 6}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 5}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 4}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 3}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 2}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 1}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[15])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[16])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[17])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[18])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[19])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[20])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[21])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[22])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[23])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[24])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `TPAT`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 10}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 9}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 8}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 7}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 6}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 5}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 4}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 3}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 2}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 1}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[26])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[27])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[28])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[29])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[30])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[31])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[32])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[33])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[34])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[35])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `NPAT`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 10}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 9}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 8}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 7}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 6}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 5}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 4}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 3}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 2}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 1}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[37])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[38])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[39])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[40])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[41])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[42])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[43])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[44])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[45])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[46])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `Total Asset`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 10}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 9}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 8}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 7}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 6}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 5}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 4}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 3}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 2}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 1}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[48])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[49])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[50])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[51])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[52])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[53])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[54])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[55])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[56])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[57])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `Total Equity`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 10}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 9}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 8}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 7}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 6}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 5}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 4}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 3}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 2}</span>
                                    </div>
                                    <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid" }}>
                                        <span>{Number(this.props.periode) - 1}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[59])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[60])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[61])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[62])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[63])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                    <div style={{ display: 'flex', width: 640, justifyContent: 'space-between' }}>
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[64])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-3"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[65])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-4"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[66])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-1"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[67])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                        {/* <div className="col-2"> */}
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.formattingNumber(tableMeta.rowData[68])}
                                                    />
                                                }
                                            />
                                        </div>
                                        {/* </div> */}
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
        ]

        const columnCPSM = [
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {
                                    tableMeta.rowData[2] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[2]) }}>
                                            <span style={{ fontSize: 12 }}>{val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Revenue`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{`${Number(this.props.periode) - 1}`}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`OL ${Number(this.props.periode)}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`MB ${Number(this.props.periode)}`}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{"% of MB"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 1}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 2}`}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 86, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[4]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[5]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[6]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            suffix={'%'}
                                                            value={tableMeta.rowData[7]}
                                                        // value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `EBITDA`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{`${Number(this.props.periode) - 1}`}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`OL ${Number(this.props.periode)}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`MB ${Number(this.props.periode)}`}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{"% of MB"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 1}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 2}`}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            suffix={'%'}
                                                            value={tableMeta.rowData[13]}
                                                        // value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `TPAT`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', top: 0, color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{`${Number(this.props.periode) - 1}`}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`OL ${Number(this.props.periode)}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`MB ${Number(this.props.periode)}`}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{"% of MB"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 1}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 2}`}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 80, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[16]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[17]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[18]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            suffix={'%'}
                                                            value={tableMeta.rowData[19]}
                                                        // value={Number(tableMeta.rowData[19]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[20]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[21]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `NPAT`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                        <span>{`${Number(this.props.periode) - 1}`}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`OL ${Number(this.props.periode)}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{`MB ${Number(this.props.periode)}`}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                        <span>{"% of MB"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 1}`}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                        <span>{`${Number(this.props.periode) + 2}`}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 86, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[22]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[23]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[24]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                    <div className="grid grid-3x content-center">
                                        <div className="col-1">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            suffix={'%'}
                                                            disabled={true}
                                                            value={tableMeta.rowData[25]}
                                                        // value={Number(tableMeta.rowData[25]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-2">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[26]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                        <div className="col-3">
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[27]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `ROIC`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                    <span>{`OL ${Number(this.props.periode)}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 1}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 2}`}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(tableMeta.rowData[28]).toFixed(2)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(tableMeta.rowData[29]).toFixed(2)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(tableMeta.rowData[30]).toFixed(2)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `EBITDA Margin`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                    <span>{`OL ${Number(this.props.periode)}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 1}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 2}`}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={(tableMeta.rowData[31])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={(tableMeta.rowData[32])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={(tableMeta.rowData[33])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `TPAT Margin`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                    <span>{`OL ${Number(this.props.periode)}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 1}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 2}`}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={(tableMeta.rowData[34])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={(tableMeta.rowData[35])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={(tableMeta.rowData[36])}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `% Revenue YoY`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                    <span>{`OL ${Number(this.props.periode)}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 1}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 2}`}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        suffix={'%'}
                                                        value={tableMeta.rowData[37]}
                                                    // value={Number(tableMeta.rowData[37]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[38]}
                                                    // value={Number(tableMeta.rowData[38]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        suffix={'%'}
                                                        placeholder=""
                                                        disabled={true}
                                                        value={tableMeta.rowData[39]}
                                                    // value={Number(tableMeta.rowData[39]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `% EBITDA YoY`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                    <span>{`OL ${Number(this.props.periode)}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 1}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 2}`}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[40]}
                                                    // value={Number(tableMeta.rowData[40]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[41]}
                                                    // value={Number(tableMeta.rowData[41]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[42]}
                                                    // value={Number(tableMeta.rowData[42]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `% TPAT YoY`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                    <span>{`OL ${Number(this.props.periode)}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 1}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 2}`}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[43]}
                                                    // value={Number(tableMeta.rowData[43]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[44]}
                                                    // value={Number(tableMeta.rowData[44]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[45]}
                                                    // value={Number(tableMeta.rowData[45]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: `% NPAT YoY`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, top: 0, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#37b5e6' }}>
                                    <span>{`OL ${Number(this.props.periode)}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 1}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) + 2}`}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[46]}
                                                    // value={Number(tableMeta.rowData[46]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[47]}
                                                    // value={Number(tableMeta.rowData[47]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: (tableMeta.rowData[2] !== 0 && tableMeta.rowData[2] !== 1) && !tableMeta.rowData[49] ? '#5198ea' : '#000000de', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        suffix={'%'}
                                                        disabled={true}
                                                        value={tableMeta.rowData[48]}
                                                    // value={Number(tableMeta.rowData[48]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            },
        ]

        const columns = []

        return (
            <div>
                <div style={{ padding: '0px 20px 20px 20px', width: this.props.width - (this.props.open === true ? 350 : 100) }}>
                    <MuiThemeProvider theme={getMuiTheme()}>
                        <MUIDataTable
                            data={dataTable2}
                            columns={this.props.type === 1 ? columnMTD : this.props.type === 2 ? columnYTD : this.props.type === 3 ? columnCPSM : this.props.type === 4 ? columnHistorical : columns}
                            options={options}
                        />
                    </MuiThemeProvider>
                </div>
            </div>
        )
    }
}
