import React from 'react';
import { TextField, Checkbox } from '@material-ui/core';
import { Autocomplete } from '@material-ui/lab';
import CheckBoxOutlineBlankIcon from '@material-ui/icons/CheckBoxOutlineBlank';
import CheckBoxIcon from '@material-ui/icons/CheckBox';
import CircularProgress from '@material-ui/core/CircularProgress';

const icon = <CheckBoxOutlineBlankIcon fontSize="small" />;
const checkedIcon = <CheckBoxIcon fontSize="small" />;

const AutocompleteField = ({
    options = [],
    value,
    onChange,
    label,
    id = "autocomplete-field",
    name,
    style = { width: 250 },
    margin = 'normal',
    disabled = false,
    required = false,
    error = false,
    helperText,
    disableClearable = true,
    renderInput,
    noOptionsText = "No options available",
    multiple = false,
    showCheckbox = false,
    isLoading = false,
    minSizeBox = false,
    ...props
}) => {
    const defaultRenderInput = (params) => (
        <TextField
            {...params}
            label={label}
            margin={minSizeBox ? 'none' : margin}
            style={minSizeBox ? {} : { marginTop: 7 }}
            disabled={disabled}
            required={required}
            error={error}
            helperText={helperText}
            fullWidth
            InputLabelProps={minSizeBox ? {
                style: {
                    fontSize: 11,
                    color: '#7e8085'
                }
            } : {}}
            InputProps={{
                ...params.InputProps,
                style: minSizeBox ? { fontSize: 11 } : {},
                endAdornment: (
                    <>
                        {isLoading ? (
                            <CircularProgress color="inherit" size={20} />
                        ) : null}
                        {params.InputProps.endAdornment}
                    </>
                ),
            }}
        />
    );

    // Custom renderOption untuk checkbox
    const renderOptionWithCheckbox = (option, state) => {
        // Manually check if option is selected
        const isSelected = multiple && Array.isArray(value)
            ? value.some(v => v.id === option.id)
            : false;

        return (
            <div
                style={{
                    display: 'flex',
                    alignItems: 'center',
                    width: '100%',
                    padding: '6px 10px',
                    cursor: 'pointer',
                }}
            >
                <Checkbox
                    icon={icon}
                    checkedIcon={checkedIcon}
                    checked={isSelected}
                    style={{ marginRight: 8 }}
                    color="primary"
                />
                {option.name}
            </div>
        );
    };

    return (
        <Autocomplete
            multiple={multiple}
            options={options}
            onChange={onChange}
            value={multiple ? (value || []) : (value || null)}
            id={id}
            disableClearable={disableClearable}
            disableCloseOnSelect={multiple}
            style={style}
            disabled={disabled}
            renderInput={renderInput || defaultRenderInput}
            getOptionLabel={(option) => option?.name || ""}
            noOptionsText={noOptionsText}
            isOptionEqualToValue={(option, value) => {
                if (!option || !value) return false;
                return option.id === value.id;
            }}
            renderOption={showCheckbox && multiple ? renderOptionWithCheckbox : undefined}
            loadingText="Loading..."
            {...props}
        />
    );
};

export default AutocompleteField;