import { createMuiTheme, FormControlLabel, Input, MuiThemeProvider, Paper, Snackbar, TableCell, Tooltip, Typography, withStyles } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react';
import NumberFormat from 'react-number-format';
import { PropagateLoader } from 'react-spinners';
import ReactTooltip from 'react-tooltip';
import api from '../../api';
import * as R from 'ramda';
import Images from '../../assets/Images';
import Constant from '../../library/Constant';
import { ExcelRenderer } from 'react-excel-renderer';
import UploadFile from "../../library/Upload";
import { Alert } from '@material-ui/lab';
import { fixNumber, titleCase } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

const LightTooltipError = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(255, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class OperatingIndicatorMR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            visibleOI: true,
            minValue: 0,
            maxValue: 0,
            updateBy: [],
            notesUpdate: '-',
            disabledSave: true,
            editable: true,
            emptyData: false,
            templateNull: true,
            judulColumn: null,
            saveDraft: true,
            viewOnly: true,
            get_for: 'view',
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        // this.getItemHierarki()
        this.getSettingControl()
        this.handleViewOnly()
        // this.getLatestUpdate()
    }

    handleViewOnly() {
        let checkCreate = this.props.permission.create
        let checkEdit = this.props.permission.edit
        let checkStatus = true

        if (String(this.props.data.status).toLocaleUpperCase() === 'CLOSED') {
            checkStatus = false
        }

        this.setState({ viewOnly: checkCreate && checkEdit && checkStatus })
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getSettingControl()
            // this.getLatestUpdate()
        })
    }

    getLatestUpdate() {
        let payload = {
            "operating_indicator_id": this.state.operatingIndIDMonthly,
            "report_id": this.props.data.report_id,
            "company_id": this.props.data.company.company_id,
            "periode": this.props.data.periode,
            "months": this.props.months
        }
        // console.log(payload);
        api.create().getLastestUpdateMROI(payload).then(response => {
            // console.log(response.data)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notesUpdate: response.data.data.notes_update === null ? '-' : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_VARIANCE',
            company_id: this.props.company.company_id,
            type: 'BALANCE_SHEET',
            currency_id: this.props.defaultCurrency.id,
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        minValue: response.data.data[0] ? Number(response.data.data[0].min_value) : -5,
                        maxValue: response.data.data[0] ? Number(response.data.data[0].max_value) : 5,
                    }, () => {
                        this.getOperatingIDMonthly()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getOperatingIDMonthly() {
        // console.log(this.props.data.operatingIndID);
        let payload = {
            "company_id": this.props.data.company.company_id,
            "periode": this.props.data.periode,
            "months": this.props.months,
            "currency_id": this.props.defaultCurrency.id,
        }
        console.log(payload);
        api.create().getMonthlyOI(payload).then(response => {
            console.log(response);
            if (response) {
                if (response.data.data) {
                    this.setState({ operatingIndIDMonthly: response.data.data.operating_indicator_id }, () => {
                        this.getItemHierarki()
                        this.getLatestUpdate()
                    })
                } else {
                    this.setState({ operatingIndIDMonthly: null }, () => {
                        this.getItemHierarki()
                        this.getLatestUpdate()
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                        setTimeout(() => {
                            localStorage.removeItem(Constant.TOKEN)
                            window.location.reload();
                        }, 1000);
                    }
                })
            }
        })
    }

    getItemHierarki() {
        this.setState({ loading: true })
        let payload = {
            "operating_indicator_id": this.state.operatingIndIDMonthly,
            "report_id": this.props.data.report_id,
            "company_id": this.props.data.company.company_id,
            "periode": this.props.data.periode,
            "months": this.props.months,
            "get_for": this.state.get_for,
            "currency_id": this.props.defaultCurrency.id,
        }
        console.log(payload);
        api.create().getHierarkiMontlyReportOI(payload).then(response => {
            console.log(response);
            let dataTable = []
            let err = false

            if (response.data) {
                let res = response.data.data
                const handlePushChild = (item) => {
                    let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                    if (item.type_report_id === 3) {

                        if (item.monthly_report.mtd_vs_mb === "" && (Number(item.monthly_report.percent_act_vs_mb) < this.state.minValue || Number(item.monthly_report.percent_act_vs_mb) > this.state.maxValue)) {
                            err = true
                        }
                        if (item.monthly_report.mtd_vs_rb === "" && (Number(item.monthly_report.percent_act_vs_rb) < this.state.minValue || Number(item.monthly_report.percent_act_vs_rb) > this.state.maxValue)) {
                            console.log('msk 2');
                            err = true
                        }
                    }
                    if (indexIDzz === -1) {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.uom === "" ? null : item.uom,
                            item.monthly_report.rolling_outlook === null ? "0.0" : item.monthly_report.rolling_outlook === "" ? "0.0" : item.monthly_report.rolling_outlook,
                            item.monthly_report.master_budget === null ? "0.0" : item.monthly_report.master_budget === "" ? "0.0" : item.monthly_report.master_budget,
                            item.monthly_report.rolling_budget === null ? "0.0" : item.monthly_report.rolling_budget === "" ? "0.0" : item.monthly_report.rolling_budget,
                            item.monthly_report.actual === null ? "0.0" : item.monthly_report.actual === "" ? "0.0" : item.monthly_report.actual,
                            item.monthly_report.amount_act_vs_mb === null ? "0.0" : item.monthly_report.amount_act_vs_mb === "" ? "0.0" : item.monthly_report.amount_act_vs_mb,
                            item.monthly_report.percent_act_vs_mb === null ? "0.0" : item.monthly_report.percent_act_vs_mb === "" ? "0.0" : item.monthly_report.percent_act_vs_mb,
                            item.monthly_report.amount_act_vs_rb === null ? "0.0" : item.monthly_report.amount_act_vs_rb === "" ? "0.0" : item.monthly_report.amount_act_vs_rb,
                            item.monthly_report.percent_act_vs_rb === null ? "0.0" : item.monthly_report.percent_act_vs_rb === "" ? "0.0" : item.monthly_report.percent_act_vs_rb,
                            item.monthly_report.mtd_vs_mb === null ? "" : item.monthly_report.mtd_vs_mb,
                            item.monthly_report.mtd_vs_rb === null ? "" : item.monthly_report.mtd_vs_rb,
                            item.order,
                        ])
                    }
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                }
                res.map((item, index) => {
                    if (item.type_report_id === 3) {

                        if (item.monthly_report.mtd_vs_mb === "" && (Number(item.monthly_report.percent_act_vs_mb) < this.state.minValue || Number(item.monthly_report.percent_act_vs_mb) > this.state.maxValue)) {
                            err = true
                        }
                        if (item.monthly_report.mtd_vs_rb === "" && (Number(item.monthly_report.percent_act_vs_rb) < this.state.minValue || Number(item.monthly_report.percent_act_vs_rb) > this.state.maxValue)) {
                            console.log('msk 2');
                            err = true
                        }
                    }
                    dataTable.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        item.description,
                        item.uom === "" ? null : item.uom,
                        item.monthly_report.rolling_outlook === null ? "0.0" : item.monthly_report.rolling_outlook === "" ? "0.0" : item.monthly_report.rolling_outlook,
                        item.monthly_report.master_budget === null ? "0.0" : item.monthly_report.master_budget === "" ? "0.0" : item.monthly_report.master_budget,
                        item.monthly_report.rolling_budget === null ? "0.0" : item.monthly_report.rolling_budget === "" ? "0.0" : item.monthly_report.rolling_budget,
                        item.monthly_report.actual === null ? "0.0" : item.monthly_report.actual === "" ? "0.0" : item.monthly_report.actual,
                        item.monthly_report.amount_act_vs_mb === null ? "0.0" : item.monthly_report.amount_act_vs_mb === "" ? "0.0" : item.monthly_report.amount_act_vs_mb,
                        item.monthly_report.percent_act_vs_mb === null ? "0.0" : item.monthly_report.percent_act_vs_mb === "" ? "0.0" : item.monthly_report.percent_act_vs_mb,
                        item.monthly_report.amount_act_vs_rb === null ? "0.0" : item.monthly_report.amount_act_vs_rb === "" ? "0.0" : item.monthly_report.amount_act_vs_rb,
                        item.monthly_report.percent_act_vs_rb === null ? "0.0" : item.monthly_report.percent_act_vs_rb === "" ? "0.0" : item.monthly_report.percent_act_vs_rb,
                        item.monthly_report.mtd_vs_mb === null ? "" : item.monthly_report.mtd_vs_mb,
                        item.monthly_report.mtd_vs_rb === null ? "" : item.monthly_report.mtd_vs_rb,
                        item.order,
                    ])
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                })
                if (err === true) {
                    this.setState({ bebas: true })
                }
                this.setState({ dataTable, loading: false, buttonError: true, saveDraft: true }, () => {
                    if (this.state.dataTable.length == 0) {
                        this.setState({ emptyData: true })
                    }
                })
            }
            console.log(dataTable);
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/monthly_report/download_template?report_id=${this.props.data.report_id}&&company_id=${this.props.data.company.company_id}&&year=${this.props.data.periode}&&months=${this.props.months}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report Operating Indicator.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        // console.log(this.props.months);
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/monthly_report/export_monthly_report?operating_indicator_id=${this.props.data.operatingIndID == null ? "" : this.props.data.operatingIndID}&&report_id=${this.props.data.report_id}&&company_id=${this.props.data.company.company_id}&&year=${this.props.data.periode}&&months=${this.props.months}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/monthly_report/export_monthly_report?operating_indicator_id=${this.props.data.operatingIndID === null ? "" : this.props.data.operatingIndID}&&report_id=${this.props.data.report_id}&&company_id=${this.props.data.company.company_id}&&year=${this.props.data.periode}&&months=${this.props.months}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report Operating Indicator.xlsx';
            a.click();
        }
    }

    createData(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                "item_report_id": i[1],
                "uom": i[6],
                "rolling_outlook": i[7],
                "master_budget": i[8],
                "rolling_budget": i[9],
                "actual": i[10],
                "amount_act_vs_mb": i[11],
                "percent_act_vs_mb": i[12],
                "amount_act_vs_rb": i[13],
                "percent_act_vs_rb": i[14],
                "mtd_vs_mb": i[15],
                "mtd_vs_rb": i[16]
            })
        })
        let payload = {
            "operating_indicator_id": this.state.operatingIndIDMonthly,
            "report_id": this.props.data.report_id,
            "company_id": this.props.data.company.company_id,
            "currency_id": this.props.defaultCurrency.id,
            "periode": this.props.data.periode,
            "status": type,
            "months": this.props.months,
            "monthly_report": data
        }
        console.log(payload);
        // // console.log('=========================')
        console.log(JSON.stringify(payload))
        this.props.saveMonthlyOI(payload)
        // this.props.onClickClose()
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            console.log(resp)
            if (err) {
                // // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // // console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            order: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report_id: i[1] === undefined ? "" : String(i[1]).trim(),
                            item_report: i[2] === undefined ? "" : String(i[2]).trim(),
                            uom: i[3] === undefined ? "" : String(i[3]).trim(),
                            actual: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            mtd_vs_mb: i[5] === undefined ? "" : String(i[5]).trim(),
                            mtd_vs_rb: i[6] === undefined ? "" : String(i[6]).trim(),
                        })
                    }
                })
                let body = {
                    company_id: this.props.data.company.company_id,
                    periode: this.props.data.periode,
                    report_id: this.props.data.report_id,
                    months: this.props.months,
                    status: 'submitted',
                    monthly_report: payload
                }
                console.log(body)
                console.log(JSON.stringify(body));
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkUploadMonthlyReportOI(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleOI: false, loading: true })
                    let total = 0
                    let err = false
                    let dataTable = response.data.data.map((item, index) => {
                        console.log(item);
                        if (item.type_report_id != null) {
                            total += 1
                        }
                        // if (item.type_report_id === 3) {

                        //     if (item.mtd_vs_mb === "" && (Number(item.percent_act_vs_mb) < this.state.minValue || Number(item.percent_act_vs_mb) > this.state.maxValue)) {
                        //         err = true
                        //     } 
                        //     if (item.mtd_vs_rb === "" && (Number(item.percent_act_vs_rb) < this.state.minValue || Number(item.percent_act_vs_rb) > this.state.maxValue)) {
                        //         console.log('msk 2');
                        //         err = true
                        //     }
                        // }
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.uom,
                            item.rolling_outlook,
                            item.master_budget,
                            item.rolling_budget,
                            item.actual,
                            // 0,
                            // 0,
                            // 0,
                            // 0,
                            item.amount_act_vs_mb,
                            item.percent_act_vs_mb,
                            item.amount_act_vs_rb,
                            item.percent_act_vs_rb,
                            item.mtd_vs_mb,
                            item.mtd_vs_rb,
                            item.order,
                            item.error
                        ]
                    })
                    console.log(dataTable);
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, templateNull: total > 0 ? true : false })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadOI(type) {
        let data = []
        // console.log(this.state.dataTable)
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    uom: String(i[6]),
                    rolling_outlook: String(Number(i[7])),
                    master_budget: String(Number(i[8])),
                    rolling_budget: String(Number(i[9])),
                    actual: String(Number(i[10])),
                    amount_act_vs_mb: String(Number(i[11])),
                    percent_act_vs_mb: String(Number(i[12])),
                    amount_act_vs_rb: String(Number(i[13])),
                    percent_act_vs_rb: String(Number(i[14])),
                    mtd_vs_mb: String(i[15]),
                    mtd_vs_rb: String(i[16]),
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    uom: String(i[6]),
                    rolling_outlook: String(fixNumber(Number(i[7]), 1)),
                    master_budget: String(fixNumber(Number(i[8]), 1)),
                    rolling_budget: String(fixNumber(Number(i[9]), 1)),
                    actual: String(fixNumber(Number(i[10]), 1)),
                    amount_act_vs_mb: String(fixNumber(Number(i[11]), 1)),
                    percent_act_vs_mb: String(fixNumber(Number(i[12]), 1)),
                    amount_act_vs_rb: String(fixNumber(Number(i[13]), 1)),
                    percent_act_vs_rb: String(fixNumber(Number(i[14]), 1)),
                    mtd_vs_mb: String(i[15]),
                    mtd_vs_rb: String(i[16]),
                })
            })
        }

        let body = {
            company_id: this.props.data.company.company_id,
            operating_indicator_id: this.state.operatingIndIDMonthly,
            periode: this.props.data.periode,
            report_id: this.props.data.report_id,
            status: type,
            months: this.props.months,
            currency_id: this.props.defaultCurrency.id,
            monthly_report: data
        }
        // console.log(body);
        // console.log(JSON.stringify(body))
        api.create('UPLOAD').uploadMonthlyReportOI(body).then(response => {
            // // console.log(response);
            this.setState({ loading: false })
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.onClickClose()
                    this.props.getReport()
                } else {
                    if (response.data.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true, loading: false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                }
            } else {
                alert(response.problem)
            }
        })
    }

    handleValidate() {
        let data = []
        let err = false
        this.state.dataTable.map((i, index) => {
            if (i[0] === 3) {
                if (i[15] === "" && (Number(i[12]) < this.state.minValue || Number(i[12]) > this.state.maxValue)) {
                    console.log('msk 1');
                    err = true
                } else if (i[16] === "" && (Number(i[14]) < this.state.minValue || Number(i[14]) > this.state.maxValue)) {
                    console.log('msk 2');
                    err = true
                }
            }
            data.push({
                "item_report_id": i[1],
                "uom": i[6],
                "rolling_outlook": i[7],
                "master_budget": i[8],
                "rolling_budget": i[9],
                "actual": i[10],
                "amount_act_vs_mb": i[11],
                "percent_act_vs_mb": i[12],
                "amount_act_vs_rb": i[13],
                "percent_act_vs_rb": i[14],
                "mtd_vs_mb": i[15],
                "mtd_vs_rb": i[16]
            })
        })

        // console.log(JSON.stringify(data))
        let payload = {
            "operating_indicator_id": this.state.operatingIndIDMonthly,
            "report_id": this.props.data.report_id,
            "company_id": this.props.data.company.company_id,
            "periode": this.props.data.periode,
            "status": "submitted",
            "months": this.props.months,
            "currency_id": this.props.defaultCurrency.id,
            "monthly_report": data
        }
        // console.log(JSON.stringify(payload));
        api.create().validateSubmitReportOI(payload).then((response) => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    if (response.data.data.result && err === false) {
                        this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
                    } else {
                        this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable

        const handleText = (value, tableMeta, type) => {
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = value
        }

        const handleValue = (data, type) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] === item[2]) {
                    let itemVal = item[data.columnIndex + type].value !== undefined ? Number(item[data.columnIndex + type].value) : Number(item[data.columnIndex + type])
                    total = item[data.columnIndex + type] === undefined ? Number(total) + 0 : Number(total) + itemVal
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[data.rowIndex][2])
            dataTable2[data.rowIndex][data.columnIndex + type] = this.props.defaultCurrency == 1 ? fixNumber(Number(total), 1) : Number(total)
            // console.log(indexParent);
            return total
        }

        const handleChange = (value, tableMeta, type) => {
            console.log(dataTable2);
            let val = String(value).split(",").join("")
            if (type === "actual") {
                dataTable2[tableMeta.rowIndex][10] = this.props.defaultCurrency == 1 ? fixNumber(Number(val), 1) : Number(val)
            } else {
                let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[tableMeta.rowIndex][2])
                if (indexParent > 0) {
                    dataTable2[tableMeta.rowIndex][10] = this.props.defaultCurrency == 1 ? fixNumber(Number(val), 1) : Number(val)
                    let jagain = this.props.defaultCurrency == 1 ? fixNumber(Number(dataTable2[indexParent][10]), 1) : Number(dataTable2[indexParent][10])
                    dataTable2[indexParent][10] = this.props.defaultCurrency == 1 ? (jagain === undefined ? fixNumber((0 + Number(val)), 1) : Number(Number(jagain) + fixNumber(Number(val)), 1)) : (jagain === undefined ? (0 + Number(val)) : Number(Number(jagain) + Number(val)))

                } else {
                    dataTable2[tableMeta.rowIndex][10] = this.props.defaultCurrency == 1 ? fixNumber(Number(val), 1) : Number(val)
                }
            }
        }

        const handleVariance = (tableMeta, dex, type) => {
            let total = 0
            if (dex === 1) {
                total = Number(tableMeta.rowData[10]) - (this.props.defaultCurrency == 1 ? fixNumber(Number(tableMeta.rowData[8]), 1) : Number(tableMeta.rowData[8]))
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = this.props.defaultCurrency == 1 ? fixNumber(Number(total), 1) : Number(total)
            } else if (dex === 2) {
                total = Number(tableMeta.rowData[10]) - (this.props.defaultCurrency == 1 ? fixNumber(Number(tableMeta.rowData[9]), 1) : Number(tableMeta.rowData[9]))
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = this.props.defaultCurrency == 1 ? fixNumber(Number(total), 1) : Number(total)
            }
            return total
        }

        const handleVariancePercent = (tableMeta, dex, type) => {
            let total = 0
            if (dex === 1) {
                total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100), NaN) ? '0' : R.equals(Number((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100), Infinity) ? '0' : Number((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100 == "-Infinity" ? '0' : (Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = this.props.defaultCurrency == 1 ? fixNumber(Number(total), 1) : Number(total)
            } else if (dex === 2) {
                total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100), NaN) ? '0' : R.equals(Number((Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100), Infinity) ? '0' : Number((Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100 == "-Infinity" ? '0' : (Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = this.props.defaultCurrency == 1 ? fixNumber(Number(total), 1) : Number(total)
            }
            return total
        }

        const handleFormula = (data, tableMeta, type) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayJumlah = []
            let tambahan = false
            let opet = ""

            arrayFormula.map((item, indexs) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*') {
                    arrayJumlah.push(item)
                } else {
                    let index = dataTable2.findIndex((val) => val[17] == item)
                    if (tambahan) {
                        if (item == '-' || item == '+' || item == '/' || item == '*') {
                            opet = item
                        } else {
                            arrayJumlah.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                            tambahan = false
                            opet = ""
                        }
                    } else {
                        if (index != -1) {
                            arrayJumlah.push(dataTable2[index][tableMeta.columnIndex + type])
                        }
                    }
                }
            })

            let array = arrayJumlah
            let total = 0
            let opt = ""

            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                        // if (tableMeta.rowData[22] === 3) {
                        //     console.log(dataTable2[tableMeta.rowIndex]);
                        //     console.log(total);
                        //     console.log(item);
                        //     console.log(arrayJumlah);
                        // }
                    } else if (opt == "bagi") {
                        total = R.equals((Number(total) / Number(item)), NaN) ? '0' : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            })

            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total)
            console.log(tableMeta.columnIndex + type)
            return a

        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[0] === null ?
                                    tableMeta.rowData[4] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "UOM",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#07a7d0', width: 96, borderLeft: '1px #fff solid', borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ? val :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                // value={val}
                                                control={
                                                    <Input
                                                        disableUnderline={true}
                                                        style={{ color: "#000", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        defaultValue={val}
                                                    // onBlur={(event) => {
                                                    //     // updateValue(event.target.value)
                                                    //     handleNotes(event.target.value, tableMeta)
                                                    //     // console.log(dataTable2)
                                                    // }}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Rolling Outlook (FY${this.props.data.periode})`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#07a7d0', width: 96, borderLeft: '1px #fff solid', borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            //decimalScale={1}
                                            value={fixNumber(Number(val), 1) == 0 ?"0.0" : Number(val)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    //decimalScale={1}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta, 0)), 1) : Number(handleValue(tableMeta, 0)) == 0 ? "0.0" : Number(handleValue(tableMeta, 0))}
                                                />
                                            </span> :
                                            // tableMeta.rowData[0] === 6 ?
                                            // <div style={{ flex: 1 }}>
                                            //     <FormControlLabel
                                            //         style={{ margin: 0 }}
                                            //         value={tableMeta.rowData[7]}
                                            //         //decimalScale={1}
                                            //         control={
                                            //             <NumberFormat
                                            //                 thousandSeparator={true}
                                            //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            //                 type="text"
                                            //                 placeholder=""
                                            //                 disabled={true}
                                            //                 value={Number(handleFormula(val, tableMeta, 0)).toFixed(1)}
                                            //             />
                                            //         }
                                            //     />
                                            // </div> 
                                            // :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ?"0.0" : Number(val)}
                                                            ///decimalScale={1}
                                                        />
                                                    }
                                                />
                                            </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: `Month To Date (MTD)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                  <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                              </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 40, fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Master Budget (MB)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Rolling Budget (RB)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Actual"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(tableMeta.rowData[8]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[8]), 1)}
                                                        //decimalScale={1}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta, 0)), 1) :  Number(handleValue(tableMeta, 0)) == 0 ? "0.0" : Number(handleValue(tableMeta, 0))}
                                                                //decimalScale={1}
                                                            />
                                                        </span>
                                                        // :
                                                        // tableMeta.rowData[0] === 6 ?
                                                        // <div style={{ flex: 1 }}>
                                                        //     <FormControlLabel
                                                        //         style={{ margin: 0 }}
                                                        //         value={ Number(tableMeta.rowData[8]).toFixed(1)}
                                                        //         control={
                                                        //             <NumberFormat
                                                        //                 thousandSeparator={true}
                                                        //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        //                 type="text"
                                                        //                 placeholder=""
                                                        //                 disabled={true}
                                                        //                 value={Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                        //                 //decimalScale={1}
                                                        //             />
                                                        //         }
                                                        //     />
                                                        // </div> 
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={tableMeta.rowData[8]}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[8]), 1) : Number(tableMeta.rowData[8]) == 0 ? "0.0" : Number(tableMeta.rowData[8])}
                                                                        //decimalScale={1}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(tableMeta.rowData[9]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[9]), 1)}
                                                        //decimalScale={1}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta, 1)), 1) : Number(handleValue(tableMeta, 1)) == 0 ? "0.0" : Number(handleValue(tableMeta), 1)}
                                                                //decimalScale={1}
                                                            />
                                                        </span>
                                                        // :
                                                        // tableMeta.rowData[0] === 6 ?
                                                        // <div style={{ flex: 1 }}>
                                                        //     <FormControlLabel
                                                        //         style={{ margin: 0 }}
                                                        //         value={tableMeta.rowData[9]}
                                                        //         control={
                                                        //             <NumberFormat
                                                        //                 thousandSeparator={true}
                                                        //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        //                 type="text"
                                                        //                 placeholder=""
                                                        //                 disabled={true}
                                                        //                 value={Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                        //                 //decimalScale={1}
                                                        //             />
                                                        //         }
                                                        //     />
                                                        // </div> 
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={fixNumber(Number(tableMeta.rowData[9]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[9]), 1)}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[9]), 1) : Number(tableMeta.rowData[9]) == 0 ? "0.0" : Number(tableMeta.rowData[9])}
                                                                        //decimalScale={1}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                null
                                                :
                                                this.state.get_for == 'view' ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(tableMeta.rowData[10]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[10]), 1)}
                                                        //decimalScale={1}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta, 2)), 1) : Number(handleValue(tableMeta, 2)) == 0? "0.0" : Number(handleValue(tableMeta, 2))}
                                                                //decimalScale={1}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[0] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            //decimalScale={1}
                                                                            fixedDecimalScale={1}
                                                                            disabled={!this.props.permission.create || !this.props.permission.edit || this.state.get_for == 'view'}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[10]), 1) : Number(tableMeta.rowData[10]) == 0 ? "0.0" : Number(tableMeta.rowData[10])}
                                                                            onBlur={(event) => {
                                                                                handleChange(event.target.value, tableMeta)
                                                                            }}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                            :
                                                            tableMeta.rowData[0] === 6 ?
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={fixNumber(Number(tableMeta.rowData[8]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[8]), 1)}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                //decimalScale={1}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormula(val, tableMeta, 2)), 1) : Number(handleFormula(val, tableMeta, 2)) == 0 ? "0.0" : Number(handleFormula(val, tableMeta, 2))}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                                :
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={tableMeta.rowData[10]}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[10]), 1) : Number(tableMeta.rowData[10]) == 0 ? "0.0" : Number(tableMeta.rowData[10])}
                                                                                //decimalScale={1}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: `Variance`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 40 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#07a7d0' }}>
                                    <div style={{ borderBottom: '1px #fff solid' }}>
                                        <span>{"Act vs MB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#07a7d0' }}>
                                    <div style={{ borderBottom: '1px #fff solid' }}>
                                        <span>{"Act vs RB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="column-1">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[11]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[11]), 1)}
                                                                //decimalScale={1}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={fixNumber(Number(tableMeta.rowData[11]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[11]), 1)}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariance(tableMeta, 1, 0)), 1) : Number(handleVariance(tableMeta, 1, 0)) == 0 ? "0.0" : Number(handleVariance(tableMeta, 1, 0))}
                                                                            //decimalScale={1}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[12]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[12]), 1)}
                                                                //decimalScale={1}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? 'red' : '#000000b0', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            suffix={'%'}
                                                                            disabled={true}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariancePercent(tableMeta, 1, 1)), 1) : Number(handleVariancePercent(tableMeta, 1, 1)) == 0 ? "0.0" : Number(handleVariancePercent(tableMeta, 1), 1)}
                                                                            //decimalScale={1}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="column-2">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[13]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13]), 1)}
                                                                //decimalScale={1}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={fixNumber(Number(tableMeta.rowData[13]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13]), 1)}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariance(tableMeta, 2, 2)), 1) : Number(handleVariance(tableMeta, 2, 2)) == 0 ? "0.0" : Number(handleVariance(tableMeta, 2, 2))}
                                                                            //decimalScale={1}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[14]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[14]), 1)}
                                                                //decimalScale={1}
                                                            />
                                                            :
                                                            <div style={{ flex: 1, width: 120 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? 'red' : '#000000b0', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            suffix={'%'}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariancePercent(tableMeta, 2, 3)), 1) : Number(handleVariancePercent(tableMeta, 2, 3)) == 0 ? "0.0" : Number(handleVariancePercent(tableMeta, 2, 3))}
                                                                            //decimalScale={1}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: `MTD Explanation`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 40 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs MB"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs RB"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 3 ?
                                                    this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            multiline={true}
                                                            disabled={true}
                                                            defaultValue={tableMeta.rowData[15]}
                                                            inputProps={{
                                                                style: {
                                                                    color: Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? "#000000b0" : '#000000b0',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                            onBlur={(event) => {
                                                                handleText(event.target.value, tableMeta, 0)
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={tableMeta.rowData[15]}
                                                            control={
                                                                tableMeta.rowData[15] === "" && (Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue) ?
                                                                    <LightTooltipError title={"MTD Explanation vs MB is Reqiured"} arrow>
                                                                        <Input
                                                                            disableUnderline={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', minHeight: 30, padding: 0 }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            multiline={true}
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            // value={tableMeta.rowData[15]}
                                                                            defaultValue={tableMeta.rowData[15]}
                                                                            inputProps={{
                                                                                style: {
                                                                                    color: "#5198ea",
                                                                                    textAlign: 'left',
                                                                                    backgroundColor: '#ffac99',
                                                                                    minHeight: 30,
                                                                                    padding: 0
                                                                                }
                                                                            }}
                                                                            onBlur={(event) => {
                                                                                handleText(event.target.value, tableMeta, 0)
                                                                            }}
                                                                        />
                                                                    </LightTooltipError>
                                                                    :
                                                                    <Input
                                                                        disableUnderline={true}
                                                                        style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        multiline={true}
                                                                        disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                        defaultValue={tableMeta.rowData[15]}
                                                                        inputProps={{
                                                                            style: {
                                                                                color: Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? "#5198ea" : '#5198ea',
                                                                                textAlign: 'left'
                                                                            }
                                                                        }}
                                                                        onBlur={(event) => {
                                                                            handleText(event.target.value, tableMeta, 0)
                                                                        }}
                                                                    />
                                                            }
                                                        />
                                                    :
                                                    null
                                                }
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 3 ?
                                                    this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            multiline={true}
                                                            disabled={true}
                                                            defaultValue={tableMeta.rowData[16]}
                                                            inputProps={{
                                                                style: {
                                                                    color: Number(tableMeta.rowData[14]) < this.state.minValue || Number(tableMeta.rowData[14]) > this.state.maxValue ? "#000000b0" : '#000000b0',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                            onBlur={(event) => {
                                                                handleText(event.target.value, tableMeta, 1)
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={tableMeta.rowData[16]}
                                                            control={
                                                                tableMeta.rowData[16] === "" && (Number(tableMeta.rowData[14]) < this.state.minValue || Number(tableMeta.rowData[14]) > this.state.maxValue) ?
                                                                    <LightTooltipError title={"MTD Explanation vs RB is Reqiured"} arrow>
                                                                        <Input
                                                                            disableUnderline={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', minHeight: 30, padding: 0 }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            multiline={true}
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            // value={tableMeta.rowData[16]}
                                                                            defaultValue={tableMeta.rowData[16]}
                                                                            inputProps={{
                                                                                style: {
                                                                                    color: "#5198ea",
                                                                                    textAlign: 'left',
                                                                                    backgroundColor: '#ffac99',
                                                                                    minHeight: 30,
                                                                                    padding: 0
                                                                                }
                                                                            }}
                                                                            onBlur={(event) => {
                                                                                handleText(event.target.value, tableMeta, 1)
                                                                            }}
                                                                        />
                                                                    </LightTooltipError>
                                                                    :
                                                                    <Input
                                                                        disableUnderline={true}
                                                                        style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        multiline={true}
                                                                        disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                        defaultValue={tableMeta.rowData[16]}
                                                                        inputProps={{
                                                                            style: {
                                                                                color: Number(tableMeta.rowData[14]) < this.state.minValue || Number(tableMeta.rowData[14]) > this.state.maxValue ? "#5198ea" : '#5198ea',
                                                                                textAlign: 'left'
                                                                            }
                                                                        }}
                                                                        onBlur={(event) => {
                                                                            handleText(event.target.value, tableMeta, 1)
                                                                        }}
                                                                    />
                                                            }
                                                        />
                                                    :
                                                    null
                                                }
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleOI === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Operating Indicator</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                {!this.state.emptyData && <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>
                                            Period : {
                                                this.props.months === 1 ? 'JAN' :
                                                    this.props.months === 2 ? 'FEB' :
                                                        this.props.months === 3 ? 'MAR' :
                                                            this.props.months === 4 ? 'APR' :
                                                                this.props.months === 5 ? 'MAY' :
                                                                    this.props.months === 6 ? 'JUN' :
                                                                        this.props.months === 7 ? 'JUL' :
                                                                            this.props.months === 8 ? 'AUG' :
                                                                                this.props.months === 9 ? 'SEP' :
                                                                                    this.props.months === 10 ? 'OCT' :
                                                                                        this.props.months === 11 ? 'NOV' :
                                                                                            this.props.months === 12 ? 'DEC' : ""} {this.props.data.periode}
                                        </Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            {this.state.get_for == 'edit' && (this.props.permission.create || this.props.permission.edit) && <a data-tip={'Download Template'} data-for="template">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.downloadTemplate()}
                                                >
                                                    <img src={Images.template} />
                                                </button>
                                            </a>}
                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                            {this.state.get_for == 'edit' && (this.props.permission.create || this.props.permission.edit) && <a data-tip={'Upload'} data-for="upload">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.setState({ visibleUpload: true, editable: true })}
                                                >
                                                    <img src={Images.upload} />
                                                </button>
                                            </a>}
                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                            {/* <a data-tip={'Download'} data-for="download">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.downloadAllData()}
                                                >
                                                    <img src={Images.download} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                        </div>
                                    </div>
                                </div>}

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    {!this.state.loading &&
                                        <MuiThemeProvider theme={getMuiTheme()}>

                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    }
                                    {this.state.get_for == 'view' && this.state.viewOnly && <div style={{ color: '#000', marginTop: 10, fontSize: 12 }}>(*) There may be discrepancies in amount due to rounding</div>}
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.state.notesUpdate}</Typography>
                            </div>
                            <div className="grid grid-2x">
                                <div className="col-1" style={{ paddingLeft: 20 }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                        }}
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                                this.props.getReport()
                                            }, 100);
                                        })}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {!this.state.emptyData && (this.props.permission.create || this.props.permission.edit) && <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 2 }}>
                                    {this.state.get_for == 'view' && this.state.viewOnly && <button
                                        type="button"
                                        onClick={() => {
                                            this.setState({ loading: true }, () => {
                                                this.handleGetFor('edit')
                                            })
                                        }}
                                        style={{ marginRight: 21 }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for == 'edit' && <button
                                        type="button"
                                        onClick={() =>
                                            this.setState({ loading: true, editable: false }, () => {
                                                setTimeout(() => {
                                                    this.handleValidate()
                                                    // this.setState({ loading: false, buttonError: false })
                                                }, 100);
                                            })
                                        }
                                        style={{ marginRight: 20 }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for == 'edit' && <button
                                        className="button"
                                        type="button"
                                        // disabled={this.state.editable}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() =>
                                            this.state.saveDraft === true ?
                                                this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                :
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        this.createData("draft")
                                                    }, 100);
                                                })}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for == 'edit' && <button
                                        type="button"
                                        // disabled={this.state.editable}
                                        onClick={() =>
                                            this.state.editable === true ?
                                                this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                :
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        this.createData("submitted")
                                                    }, 100);
                                                })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>}
                                </div>}
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>
                                            Period : {
                                                this.props.months === 1 ? 'JAN' :
                                                    this.props.months === 2 ? 'FEB' :
                                                        this.props.months === 3 ? 'MAR' :
                                                            this.props.months === 4 ? 'APR' :
                                                                this.props.months === 5 ? 'MAY' :
                                                                    this.props.months === 6 ? 'JUN' :
                                                                        this.props.months === 7 ? 'JUL' :
                                                                            this.props.months === 8 ? 'AUG' :
                                                                                this.props.months === 9 ? 'SEP' :
                                                                                    this.props.months === 10 ? 'OCT' :
                                                                                        this.props.months === 11 ? 'NOV' :
                                                                                            this.props.months === 12 ? 'DEC' : ""} {this.props.data.periode}
                                        </Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                <div className="grid grid-2x" style={{ marginLeft: 10 }}>
                                    <div className="col-1">
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                            }}
                                            onClick={() =>
                                                this.setState({ loading: true, visibleOI: true }, () => {
                                                    setTimeout(() => {
                                                        this.getItemHierarki()
                                                    }, 100)
                                                })}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    {!this.state.emptyData && this.state.templateNull && <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            type="button"
                                            onClick={() =>
                                                this.setState({ loading: true, editable: false }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                        // this.setState({ loading: false, buttonError: false })
                                                    }, 100);
                                                })
                                            }
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            // disabled={this.state.editable}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadOI("draft")
                                                        }, 100);
                                                    })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            className="button"
                                            type="button"
                                            // disabled={this.state.editable}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadOI("submitted")
                                                        }, 100);
                                                    })}

                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>}
                                </div>
                            </div>
                        </Paper>}
                </div>

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") && String(this.state.judul).includes("OPERATING") && String(this.state.judul).includes("INDICATOR") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        );
    }
}
