import React, { Component } from 'react';
import { createMuiTheme, FormControlLabel, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, withStyles, Input, ThemeProvider, TextareaAutosize } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import Constant from '../../library/Constant';
import { titleCase } from '../../library/Utils';
import { Autocomplete } from '@material-ui/lab';
import { PropagateLoader } from 'react-spinners';
import ReactTooltip from 'react-tooltip';
import { DatePicker } from '@material-ui/pickers';
import { format } from 'date-fns';
import { BorderStyle } from '@material-ui/icons';
import { includes } from 'ramda';
import Snackbar from '@material-ui/core/Snackbar';
import MuiAlert from '@material-ui/lab/Alert';
import { makeStyles } from '@material-ui/core/styles';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { fixNumber, roundMath } from "../../library/Utils";

function Alert(props) {
    return <MuiAlert elevation={6} variant="filled" {...props} />;
}

const useStyles = makeStyles((theme) => ({
    root: {
        width: '100%',
        '& > * + *': {
            marginTop: theme.spacing(2),
        },
    },
}));

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);
var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());
const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};

const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

const theme = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea',
                marginTop: -10,
                textAlign: 'center'
            }
        }
    },
});

const theme2 = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea',
                textAlign: 'center'
            }
        }
    },
});

const theme3 = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#black',
                textAlign: 'center'
            }
        }
    },
});

export default class ListOfCreditFacilities extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            bankNameList: [],
            typeOfCreditList: [],
            loading: false,
            dataTableRatio: [],
            currentDate: format(new Date(), 'yyyy-MM-dd'),
            totalOutStand: 0,
            diff: 0,
            perBS: 0,
            snekbar: false,
            snekbarMsg: '',
            visibleLOCFMR: true,
            saveDraft: true,
            saveComp: true,
            get_for: 'view',
            updateBy: [],
            notes: "",
            viewOnly: true,
            dataDelete: [],
            saveTambahan: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getPerBS()
        this.getBankData()
        this.getTypeOfCredit()
        this.getSubmission()
        this.getLatestUpdate()
        this.handleViewOnly()
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getPerBS()
            this.getBankData()
            this.getTypeOfCredit()
            this.getSubmission()
            this.getLatestUpdate()
        })
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({viewOnly: true})
    }

    getItemHierarki() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "get_for": this.state.get_for
        }
        api.create().getHierarkiMontlyReportLOCF(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable = []
            if (response.data) {
                let res = response.data.data
                // const handlePushChild = (item) => {
                //     let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                //     if (indexIDzz === -1) {
                //         dataTable.push([
                //             item.type_report_id,
                //             item.id,
                //             item.parent,
                //             item.formula,
                //             item.level,
                //             item.description,
                //             item.locf.borrower_comp_name === null ? "0.0" : item.locf.borrower_comp_name === "" ? "0.0" : item.locf.borrower_comp_name,
                //             item.locf.bank_name === null ? "0.0" : item.locf.bank_name === "" ? "0.0" : item.locf.bank_name,
                //             item.locf.type_of_credit === null ? "0.0" : item.locf.type_of_credit === "" ? "0.0" : item.locf.type_of_credit,
                //             item.locf.remarks === null ? "0.0" : item.locf.remarks === "" ? "0.0" : item.locf.remarks,
                //             item.locf.loan_maturity_date === null ? "0.0" : item.locf.loan_maturity_date === "" ? "0.0" : item.locf.loan_maturity_date,
                //             item.locf.interest === null ? "0.0" : item.locf.interest === "" ? "0.0" : item.locf.interest,
                //             item.locf.currency === null ? "0.0" : item.locf.currency === "" ? "0.0" : item.locf.currency,
                //             item.locf.loan_plafond_amount_ori === null ? "0.0" : item.locf.loan_plafond_amount_ori === "" ? "0.0" : item.locf.loan_plafond_amount_ori,
                //             item.locf.loan_plafond_amount_idr === null ? "0.0" : item.locf.loan_plafond_amount_idr === "" ? "0.0" : item.locf.loan_plafond_amount_idr,
                //             item.locf.out_loan_ki_amount_ori === null ? "0.0" : item.locf.out_loan_ki_amount_ori === "" ? "0.0" : item.locf.out_loan_ki_amount_ori,
                //             item.locf.out_loan_ki_amount_idr === null ? "0.0" : item.locf.out_loan_ki_amount_idr === "" ? "0.0" : item.locf.out_loan_ki_amount_idr,
                //             item.locf.out_loan_kmk_amount_ori === null ? "0.0" : item.locf.out_loan_kmk_amount_ori === "" ? "0.0" : item.locf.out_loan_kmk_amount_ori,
                //             item.locf.out_loan_kmk_amount_idr === null ? "0.0" : item.locf.out_loan_kmk_amount_idr === "" ? "0.0" : item.locf.out_loan_kmk_amount_idr,
                //             // item.locf.mtd_vs_previous_month === null ? "0.0" : item.locf.mtd_vs_previous_month === "" ? "0.0" : item.locf.mtd_vs_previous_month,
                //             item.locf.out_loan_other_type === null ? "0.0" : item.locf.out_loan_other_type === "" ? "0.0" : item.locf.out_loan_other_type,
                //             item.locf.out_loan_other_amount_ori === null ? "0.0" : item.locf.out_loan_other_amount_ori === "" ? "0.0" : item.locf.out_loan_other_amount_ori,
                //             item.locf.out_loan_other_amount_idr === null ? "0.0" : item.locf.out_loan_other_amount_idr === "" ? "0.0" : item.locf.out_loan_other_amount_idr,
                //             item.locf.total_out_loan_ori === null ? "0.0" : item.locf.total_out_loan_ori === "" ? "0.0" : item.locf.total_out_loan_ori,
                //             item.locf.total_out_loan_idr === null ? "0.0" : item.locf.total_out_loan_idr === "" ? "0.0" : item.locf.total_out_loan_idr,
                //             item.locf.remaining_plafond_ori === null ? "0.0" : item.locf.remaining_plafond_ori === "" ? "0.0" : item.locf.remaining_plafond_ori,
                //             item.locf.remaining_plafond_idr === null ? "0.0" : item.locf.remaining_plafond_idr === "" ? "0.0" : item.locf.remaining_plafond_idr,
                //             item.locf.current_ratio_financial === null ? "0.0" : item.locf.current_ratio_financial === "" ? "0.0" : item.locf.current_ratio_financial,
                //             item.locf.current_ratio_current === null ? "0.0" : item.locf.current_ratio_current === "" ? "0.0" : item.locf.current_ratio_current,
                //             item.locf.der_financial === null ? "0.0" : item.locf.der_financial === "" ? "0.0" : item.locf.der_financial,
                //             item.locf.der_current === null ? "0.0" : item.locf.der_current === "" ? "0.0" : item.locf.der_current,
                //             item.locf.debt_to_ebitda_financial === null ? "0.0" : item.locf.debt_to_ebitda_financial === "" ? "0.0" : item.locf.debt_to_ebitda_financial,
                //             item.locf.debt_to_ebitda_current === null ? "0.0" : item.locf.debt_to_ebitda_current === "" ? "0.0" : item.locf.debt_to_ebitda_current,
                //             item.locf.ebitda_to_interest_financial === null ? "0.0" : item.locf.ebitda_to_interest_financial === "" ? "0.0" : item.locf.ebitda_to_interest_financial,
                //             item.locf.ebitda_to_interest_current === null ? "0.0" : item.locf.ebitda_to_interest_current === "" ? "0.0" : item.locf.ebitda_to_interest_current,
                //             item.locf.other_ratio1_ratio_name === null ? "0.0" : item.locf.other_ratio1_ratio_name === "" ? "0.0" : item.locf.other_ratio1_ratio_name,
                //             item.locf.other_ratio1_financial === null ? "0.0" : item.locf.other_ratio1_financial === "" ? "0.0" : item.locf.other_ratio1_financial,
                //             item.locf.other_ratio1_current === null ? "0.0" : item.locf.other_ratio1_current === "" ? "0.0" : item.locf.other_ratio1_current,
                //             item.locf.other_ratio2_ratio_name === null ? "0.0" : item.locf.other_ratio2_ratio_name === "" ? "0.0" : item.locf.other_ratio2_ratio_name,
                //             item.locf.other_ratio2_financial === null ? "0.0" : item.locf.other_ratio2_financial === "" ? "0.0" : item.locf.other_ratio2_financial,
                //             item.locf.other_ratio2_current === null ? "0.0" : item.locf.other_ratio2_current === "" ? "0.0" : item.locf.other_ratio2_current,
                //             item.locf.other_ratio3_ratio_name === null ? "0.0" : item.locf.other_ratio3_ratio_name === "" ? "0.0" : item.locf.other_ratio3_ratio_name,
                //             item.locf.other_ratio3_financial === null ? "0.0" : item.locf.other_ratio3_financial === "" ? "0.0" : item.locf.other_ratio3_financial,
                //             item.locf.other_ratio3_current === null ? "0.0" : item.locf.other_ratio3_current === "" ? "0.0" : item.locf.other_ratio3_current,
                //             item.locf.other_ratio4_ratio_name === null ? "0.0" : item.locf.other_ratio4_ratio_name === "" ? "0.0" : item.locf.other_ratio4_ratio_name,
                //             item.locf.other_ratio4_financial === null ? "0.0" : item.locf.other_ratio4_financial === "" ? "0.0" : item.locf.other_ratio4_financial,
                //             item.locf.other_ratio4_current === null ? "0.0" : item.locf.other_ratio4_current === "" ? "0.0" : item.locf.other_ratio4_current,
                //             item.notes,
                //             // item.locf.per_bs === null ? "0.0" : item.locf.per_bs === "" ? "0.0" : item.locf.per_bs,
                //             // item.locf.diff === null ? "0.0" : item.locf.diff === "" ? "0.0" : item.locf.diff,
                //         ])
                //     }
                //     if (item.children !== null) {
                //         if (item.children.length > 0) {
                //             item.children.map((items, indexs) => {
                //                 handlePushChild(items)
                //             })
                //         }
                //     }
                // }
                res.map((item, index) => {
                    let tgl = String(item.locf.loan_maturity_date).split('-')
                    if (index == res.length - 1) {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            // item.description,
                            item.locf.borrower_comp_name === null || item.locf.borrower_comp_name === "" ? this.props.company.company_name : item.locf.borrower_comp_name,
                            item.locf.bank_name === null ? null : item.locf.bank_name === "" ? null : { value: item.locf.bank_name },
                            item.locf.type_of_credit === null ? null : item.locf.type_of_credit === "" ? null : { value: item.locf.type_of_credit },
                            item.locf.remarks === null || item.locf.remarks === "" ? "" : item.locf.remarks,
                            item.locf.loan_maturity_date == null || item.locf.loan_maturity_date == "" ? null : (item.locf.loan_maturity_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.locf.loan_maturity_date) : null),
                            item.locf.interest === null || item.locf.interest === "" ? "0.00" : item.locf.interest,
                            item.locf.currency === null || item.locf.currency === "" ? "" : item.locf.currency,
                            item.locf.loan_plafond_amount_ori,
                            item.locf.loan_plafond_amount_idr === null ? "0.0" : item.locf.loan_plafond_amount_idr === "" ? "0.0" : item.locf.loan_plafond_amount_idr,
                            item.locf.out_loan_ki_amount_ori,
                            item.locf.out_loan_ki_amount_idr === null ? "0.0" : item.locf.out_loan_ki_amount_idr === "" ? "0.0" : item.locf.out_loan_ki_amount_idr,
                            item.locf.out_loan_kmk_amount_ori,
                            item.locf.out_loan_kmk_amount_idr === null ? "0.0" : item.locf.out_loan_kmk_amount_idr === "" ? "0.0" : item.locf.out_loan_kmk_amount_idr,
                            // item.locf.mtd_vs_previous_month === null ? "0.0" : item.locf.mtd_vs_previous_month === "" ? "0.0" : item.locf.mtd_vs_previous_month,
                            item.locf.out_loan_other_type,
                            item.locf.out_loan_other_amount_ori,
                            item.locf.out_loan_other_amount_idr === null ? "0.0" : item.locf.out_loan_other_amount_idr === "" ? "0.0" : item.locf.out_loan_other_amount_idr,
                            item.locf.total_out_loan_ori === null ? "0.0" : item.locf.total_out_loan_ori === "" ? "0.0" : item.locf.total_out_loan_ori,
                            item.locf.total_out_loan_idr === null ? "0.0" : item.locf.total_out_loan_idr === "" ? "0.0" : item.locf.total_out_loan_idr,
                            item.locf.remaining_plafond_ori === null ? "0.0" : item.locf.remaining_plafond_ori === "" ? "0.0" : item.locf.remaining_plafond_ori,
                            item.locf.remaining_plafond_idr === null ? "0.0" : item.locf.remaining_plafond_idr === "" ? "0.0" : item.locf.remaining_plafond_idr,
                            item.locf.current_ratio_financial,
                            item.locf.current_ratio_current === null ? "0.0" : item.locf.current_ratio_current === "" ? "0.0" : item.locf.current_ratio_current,
                            item.locf.der_financial,
                            item.locf.der_current === null ? "0.0" : item.locf.der_current === "" ? "0.0" : item.locf.der_current,
                            item.locf.debt_to_ebitda_financial,
                            item.locf.debt_to_ebitda_current === null ? "0.0" : item.locf.debt_to_ebitda_current === "" ? "0.0" : item.locf.debt_to_ebitda_current,
                            item.locf.ebitda_to_interest_financial,
                            item.locf.ebitda_to_interest_current === null ? "0.0" : item.locf.ebitda_to_interest_current === "" ? "0.0" : item.locf.ebitda_to_interest_current,
                            item.locf.other_ratio1_ratio_name,
                            item.locf.other_ratio1_financial,
                            item.locf.other_ratio1_current === null ? "0.0" : item.locf.other_ratio1_current === "" ? "0.0" : item.locf.other_ratio1_current,
                            item.locf.other_ratio2_ratio_name,
                            item.locf.other_ratio2_financial,
                            item.locf.other_ratio2_current === null ? "0.0" : item.locf.other_ratio2_current === "" ? "0.0" : item.locf.other_ratio2_current,
                            item.locf.other_ratio3_ratio_name,
                            item.locf.other_ratio3_financial,
                            item.locf.other_ratio3_current === null ? "0.0" : item.locf.other_ratio3_current === "" ? "0.0" : item.locf.other_ratio3_current,
                            item.locf.other_ratio4_ratio_name,
                            item.locf.other_ratio4_financial,
                            item.locf.other_ratio4_current === null ? "0.0" : item.locf.other_ratio4_current === "" ? "0.0" : item.locf.other_ratio4_current,
                            item.locf.notes,
                            // item.per_bs === null ? "0.0" : item.locf.per_bs === "" ? "0.0" : item.locf.per_bs,
                            // item.diff === null ? "0.0" : item.locf.diff === "" ? "0.0" : item.locf.diff,
                            index
                        ],
                            [9, "", "", "", "", "", { value: "Grand Total" }, null, "", "", "", "0", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "notes", 999999],
                        )
                    } else {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            // item.description,
                            item.locf.borrower_comp_name === null || item.locf.borrower_comp_name === "" ? this.props.company.company_name : item.locf.borrower_comp_name,
                            item.locf.bank_name === null ? null : item.locf.bank_name === "" ? null : { value: item.locf.bank_name },
                            item.locf.type_of_credit === null ? null : item.locf.type_of_credit === "" ? null : { value: item.locf.type_of_credit },
                            item.locf.remarks === null || item.locf.remarks === "" ? "" : item.locf.remarks,
                            item.locf.loan_maturity_date == null || item.locf.loan_maturity_date == "" ? null : (item.locf.loan_maturity_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.locf.loan_maturity_date) : null),
                            item.locf.interest === null || item.locf.interest === "" ? "0.00" : item.locf.interest,
                            item.locf.currency === null || item.locf.currency === "" ? "" : item.locf.currency,
                            item.locf.loan_plafond_amount_ori,
                            item.locf.loan_plafond_amount_idr === null ? "0.0" : item.locf.loan_plafond_amount_idr === "" ? "0.0" : item.locf.loan_plafond_amount_idr,
                            item.locf.out_loan_ki_amount_ori,
                            item.locf.out_loan_ki_amount_idr === null ? "0.0" : item.locf.out_loan_ki_amount_idr === "" ? "0.0" : item.locf.out_loan_ki_amount_idr,
                            item.locf.out_loan_kmk_amount_ori,
                            item.locf.out_loan_kmk_amount_idr === null ? "0.0" : item.locf.out_loan_kmk_amount_idr === "" ? "0.0" : item.locf.out_loan_kmk_amount_idr,
                            // item.locf.mtd_vs_previous_month === null ? "0.0" : item.locf.mtd_vs_previous_month === "" ? "0.0" : item.locf.mtd_vs_previous_month,
                            item.locf.out_loan_other_type,
                            item.locf.out_loan_other_amount_ori,
                            item.locf.out_loan_other_amount_idr === null ? "0.0" : item.locf.out_loan_other_amount_idr === "" ? "0.0" : item.locf.out_loan_other_amount_idr,
                            item.locf.total_out_loan_ori === null ? "0.0" : item.locf.total_out_loan_ori === "" ? "0.0" : item.locf.total_out_loan_ori,
                            item.locf.total_out_loan_idr === null ? "0.0" : item.locf.total_out_loan_idr === "" ? "0.0" : item.locf.total_out_loan_idr,
                            item.locf.remaining_plafond_ori === null ? "0.0" : item.locf.remaining_plafond_ori === "" ? "0.0" : item.locf.remaining_plafond_ori,
                            item.locf.remaining_plafond_idr === null ? "0.0" : item.locf.remaining_plafond_idr === "" ? "0.0" : item.locf.remaining_plafond_idr,
                            item.locf.current_ratio_financial,
                            item.locf.current_ratio_current === null ? "0.0" : item.locf.current_ratio_current === "" ? "0.0" : item.locf.current_ratio_current,
                            item.locf.der_financial,
                            item.locf.der_current === null ? "0.0" : item.locf.der_current === "" ? "0.0" : item.locf.der_current,
                            item.locf.debt_to_ebitda_financial,
                            item.locf.debt_to_ebitda_current === null ? "0.0" : item.locf.debt_to_ebitda_current === "" ? "0.0" : item.locf.debt_to_ebitda_current,
                            item.locf.ebitda_to_interest_financial,
                            item.locf.ebitda_to_interest_current === null ? "0.0" : item.locf.ebitda_to_interest_current === "" ? "0.0" : item.locf.ebitda_to_interest_current,
                            item.locf.other_ratio1_ratio_name,
                            item.locf.other_ratio1_financial,
                            item.locf.other_ratio1_current === null ? "0.0" : item.locf.other_ratio1_current === "" ? "0.0" : item.locf.other_ratio1_current,
                            item.locf.other_ratio2_ratio_name,
                            item.locf.other_ratio2_financial,
                            item.locf.other_ratio2_current === null ? "0.0" : item.locf.other_ratio2_current === "" ? "0.0" : item.locf.other_ratio2_current,
                            item.locf.other_ratio3_ratio_name,
                            item.locf.other_ratio3_financial,
                            item.locf.other_ratio3_current === null ? "0.0" : item.locf.other_ratio3_current === "" ? "0.0" : item.locf.other_ratio3_current,
                            item.locf.other_ratio4_ratio_name,
                            item.locf.other_ratio4_financial,
                            item.locf.other_ratio4_current === null ? "0.0" : item.locf.other_ratio4_current === "" ? "0.0" : item.locf.other_ratio4_current,
                            item.locf.notes,
                            index
                            // item.per_bs === null ? "0.0" : item.locf.per_bs === "" ? "0.0" : item.locf.per_bs,
                            // item.diff === null ? "0.0" : item.locf.diff === "" ? "0.0" : item.locf.diff,
                        ])
                    }

                    // if (item.children !== null) {
                    //     if (item.children.length > 0) {
                    //         item.children.map((items, indexs) => {
                    //             handlePushChild(items)
                    //         })
                    //     }
                    // }
                })
                // console.log(dataTable);
                if (dataTable.length == 0 && this.state.get_for == 'edit') {
                    dataTable.push(
                        [3, "", "", "", "", this.props.company.company_name, null, null, "", null, "0.00", "", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "", 0],
                        [9, "", "", "", "", "", { value: "Grand Total" }, null, "", "", "", "0", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "notes", 999999],
                    )
                }
                console.log(dataTable)
                this.setState({ dataTable, loading: false, visibleLOCFMR: true }, () => {
                    this.handleCalculate()
                })
            }
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        // console.log(payload)
        api.create().getLastestUpdateMR(payload).then(response => {
            console.log(JSON.stringify(response))
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, typeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                // console.log('brrrrrrrr')
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        let excelDate = i[5]
                        let excelBaseDate = new Date('1900-01-01');
                        let javascriptBaseDate = new Date('1970-01-01');
                        let daysBetween = excelDate - 1;
                        let javascriptDate = new Date(excelBaseDate.getTime() + (daysBetween * 24 * 60 * 60 * 1000));
                        let tgl = String(i[5]).split('-')
                        console.log(i[5])
                        console.log(tgl)
                        console.log(javascriptDate);
                        payload.push({
                            "item_report_id": i[1],
                            "borrower_comp_name": this.props.company.company_name,
                            "bank_name": i[2],
                            "type_of_credit": i[3],
                            "remarks": i[4],
                            "loan_maturity_date": i[5] !== undefined ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : null,
                            "interest": i[6],
                            "currency": i[7],
                            "loan_plafond_amount_ori": i[8] !== undefined ? Number(i[8]) : i[8],
                            "loan_plafond_amount_idr": i[9] !== undefined ? Number(i[9]) : i[9],
                            "out_loan_ki_amount_ori": i[10] !== undefined ? Number(i[10]) : i[10],
                            "out_loan_ki_amount_idr": i[11] !== undefined ? Number(i[11]) : i[11],
                            "out_loan_kmk_amount_ori": i[12] !== undefined ? Number(i[12]) : i[12],
                            "out_loan_kmk_amount_idr": i[13] !== undefined ? Number(i[13]) : i[13],
                            "out_loan_other_type": i[14],
                            "out_loan_other_amount_ori": i[15] !== undefined ? Number(i[15]) : i[15],
                            "out_loan_other_amount_idr": i[16] !== undefined ? Number(i[16]) : i[16],
                            // "total_out_loan_ori": i[18],
                            // "total_out_loan_idr": i[19],
                            // "remaining_plafond_ori": i[20],
                            // "remaining_plafond_idr": i[21],
                            "current_ratio_financial": i[17],
                            "der_financial": i[18],
                            "debt_to_ebitda_financial": i[19],
                            "ebitda_to_interest_financial": i[20],
                            "other_ratio1_ratio_name": i[21],
                            "other_ratio1_financial": i[22],
                            "other_ratio1_current": i[23],
                            "other_ratio2_ratio_name": i[24],
                            "other_ratio2_financial": i[25],
                            "other_ratio2_current": i[26],
                            "other_ratio3_ratio_name": i[27],
                            "other_ratio3_financial": i[28],
                            "other_ratio3_current": i[29],
                            "other_ratio4_ratio_name": i[30],
                            "other_ratio4_financial": i[31],
                            "other_ratio4_current": i[32],
                            "notes": i[33],
                        })
                    }
                })
                let body = {
                    "monthly_report_id": this.props.monthlyReportId,
                    "company_id": this.props.company.company_id,
                    "periode": this.props.periode,
                    "report_id": this.props.report_id,
                    "status": 'submitted',
                    "months": this.props.month.month_id,
                    "locf": payload,
                    "per_bs": this.state.perBS,
                    "diff": this.state.diff,
                    "total_loan": this.state.perBS
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }


    deleteReport() {
        let payload = { "item_report_id": this.state.dataDelete, "periode": this.props.periode, "months": this.props.month.month_id }

        if (this.state.dataDelete.length > 0) {
            api.create().deleteAllItemReportLOCF(payload).then((response) => {
                console.log(response)
            })
        }
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        let dataDelete = []
        api.create().getIdDeleteFromExcelLOCF(payload).then((response) => {
            console.log(response)
            // if (response.data) {
            //     // // // // // console.log(response.data)
            //     let idDelete = response.data.data.item_report_id
            //     if (idDelete.length > 0) {
            //         idDelete.map((item, index) => {
            //             dataDelete.push(item)
            //         })
            //         this.setState({ dataDelete })
            //     }
            // }
        })

        api.create().checkUploadMonthlyReportLOCF(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, loading: true, visibleLOCFMR: false, totalOutStand: 0, diff: 0 })
                    let dataTable = []
                    response.data.data.map((item, index) => {
                        if (index == response.data.data.length - 1) {
                            dataTable.push([
                                3,
                                item.item_report_id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.borrower_comp_name === null ? this.props.company.company_name : item.borrower_comp_name === "" ? this.props.company.company_name : item.borrower_comp_name,
                                item.bank_name === null ? null : item.bank_name === "" ? null : { value: item.bank_name },
                                item.type_of_credit === null ? null : item.type_of_credit === "" ? null : { value: item.type_of_credit },
                                item.remarks === null ? "" : item.remarks === "" ? "" : item.remarks,
                                item.loan_maturity_date === null || item.loan_maturity_date === "" ? null : item.loan_maturity_date,
                                item.interest === null || item.interest === "" ? "0.00" : item.interest,
                                item.currency === null || item.currency === "" ? "" : item.currency,
                                item.loan_plafond_amount_ori == null ? "" : item.loan_plafond_amount_ori,
                                item.loan_plafond_amount_idr === null ? "0.0" : item.loan_plafond_amount_idr === "" ? "0.0" : item.loan_plafond_amount_idr,
                                item.type_of_credit == "Investment Loan" ? item.out_loan_ki_amount_ori : "0.0",
                                item.type_of_credit == "Investment Loan" ? (item.out_loan_ki_amount_idr === null ? "0.0" : item.out_loan_ki_amount_idr === "" ? "0.0" : item.out_loan_ki_amount_idr) : "0.0",
                                item.type_of_credit == "Revolving Loan (KMK)" ? item.out_loan_kmk_amount_ori : "0.0",
                                item.type_of_credit == "Revolving Loan (KMK)" ? (item.out_loan_kmk_amount_idr === null ? "0.0" : item.out_loan_kmk_amount_idr === "" ? "0.0" : item.out_loan_kmk_amount_idr) : "0.0",
                                item.type_of_credit == "Others" ? item.out_loan_other_type : "",
                                item.type_of_credit == "Others" ? item.out_loan_other_amount_ori : "0.0",
                                item.type_of_credit == "Others" ? (item.out_loan_other_amount_idr === null ? "0.0" : item.out_loan_other_amount_idr === "" ? "0.0" : item.out_loan_other_amount_idr) : "0.0",
                                item.total_out_loan_ori === null ? "0.0" : item.total_out_loan_ori === "" ? "0.0" : item.total_out_loan_ori === 0 ? "0.0" : item.total_out_loan_ori,
                                item.total_out_loan_idr === null ? "0.0" : item.total_out_loan_idr === "" ? "0.0" : item.total_out_loan_idr,
                                item.remaining_plafond_ori === null ? "0.0" : item.remaining_plafond_ori === "" ? "0.0" : item.remaining_plafond_ori,
                                item.remaining_plafond_idr === null ? "0.0" : item.remaining_plafond_idr === "" ? "0.0" : item.remaining_plafond_idr,
                                item.current_ratio_financial == null ? "" : item.current_ratio_financial,
                                item.current_ratio_current === null ? "0.0" : item.current_ratio_current === "" ? "0.0" : item.current_ratio_current,
                                item.der_financial == null ? "" : item.der_financial,
                                item.der_current === null ? "0.0" : item.der_current === "" ? "0.0" : item.der_current,
                                item.debt_to_ebitda_financial == null ? "" : item.debt_to_ebitda_financial,
                                item.debt_to_ebitda_current === null ? "0.0" : item.debt_to_ebitda_current === "" ? "0.0" : item.debt_to_ebitda_current,
                                item.ebitda_to_interest_financial == null ? "" : item.ebitda_to_interest_financial,
                                item.ebitda_to_interest_current === null ? "0.0" : item.ebitda_to_interest_current === "" ? "0.0" : item.ebitda_to_interest_current,
                                item.other_ratio1_ratio_name == null ? "" : item.other_ratio1_ratio_name,
                                item.other_ratio1_financial === null ? "0.0" : item.other_ratio1_financial === "" ? "0.0" : item.other_ratio1_financial,
                                item.other_ratio1_current === null ? "0.0" : item.other_ratio1_current === "" ? "0.0" : item.other_ratio1_current,
                                item.other_ratio2_ratio_name == null ? "" : item.other_ratio2_ratio_name,
                                item.other_ratio2_financial === null ? "0.0" : item.other_ratio2_financial === "" ? "0.0" : item.other_ratio2_financial,
                                item.other_ratio2_current === null ? "0.0" : item.other_ratio2_current === "" ? "0.0" : item.other_ratio2_current,
                                item.other_ratio3_ratio_name == null ? "" : item.other_ratio3_ratio_name,
                                item.other_ratio3_financial === null ? "0.0" : item.other_ratio3_financial === "" ? "0.0" : item.other_ratio3_financial,
                                item.other_ratio3_current === null ? "0.0" : item.other_ratio3_current === "" ? "0.0" : item.other_ratio3_current,
                                item.other_ratio4_ratio_name == null ? "" : item.other_ratio4_ratio_name,
                                item.other_ratio4_financial === null ? "0.0" : item.other_ratio4_financial === "" ? "0.0" : item.other_ratio4_financial,
                                item.other_ratio4_current === null ? "0.0" : item.other_ratio4_current === "" ? "0.0" : item.other_ratio4_current,
                                item.notes,
                            ],
                                [9, "", "", "", "", "", { value: "Grand Total" }, null, "", "", "", "0", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "notes", 999999],
                            )
                        } else {
                            dataTable.push([
                                3,
                                item.item_report_id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.borrower_comp_name === null ? this.props.company.company_name : item.borrower_comp_name === "" ? this.props.company.company_name : item.borrower_comp_name,
                                item.bank_name === null ? null : item.bank_name === "" ? null : { value: item.bank_name },
                                item.type_of_credit === null ? null : item.type_of_credit === "" ? null : { value: item.type_of_credit },
                                item.remarks === null ? "" : item.remarks === "" ? "" : item.remarks,
                                item.loan_maturity_date === null || item.loan_maturity_date === "" ? null : item.loan_maturity_date,
                                item.interest === null || item.interest === "" ? "0.00" : item.interest,
                                item.currency === null || item.currency === "" ? "" : item.currency,
                                item.loan_plafond_amount_ori == null ? "" : item.loan_plafond_amount_ori,
                                item.loan_plafond_amount_idr === null ? "0.0" : item.loan_plafond_amount_idr === "" ? "0.0" : item.loan_plafond_amount_idr,
                                item.type_of_credit == "Investment Loan" ? item.out_loan_ki_amount_ori : "0.0",
                                item.type_of_credit == "Investment Loan" ? (item.out_loan_ki_amount_idr === null ? "0.0" : item.out_loan_ki_amount_idr === "" ? "0.0" : item.out_loan_ki_amount_idr) : "0.0",
                                item.type_of_credit == "Revolving Loan (KMK)" ? item.out_loan_kmk_amount_ori : "0.0",
                                item.type_of_credit == "Revolving Loan (KMK)" ? (item.out_loan_kmk_amount_idr === null ? "0.0" : item.out_loan_kmk_amount_idr === "" ? "0.0" : item.out_loan_kmk_amount_idr) : "0.0",
                                item.type_of_credit == "Others" ? item.out_loan_other_type : "",
                                item.type_of_credit == "Others" ? item.out_loan_other_amount_ori : "0.0",
                                item.type_of_credit == "Others" ? (item.out_loan_other_amount_idr === null ? "0.0" : item.out_loan_other_amount_idr === "" ? "0.0" : item.out_loan_other_amount_idr) : "0.0",
                                item.total_out_loan_ori === null ? "0.0" : item.total_out_loan_ori === "" ? "0.0" : item.total_out_loan_ori,
                                item.total_out_loan_idr === null ? "0.0" : item.total_out_loan_idr === "" ? "0.0" : item.total_out_loan_idr,
                                item.remaining_plafond_ori === null ? "0.0" : item.remaining_plafond_ori === "" ? "0.0" : item.remaining_plafond_ori,
                                item.remaining_plafond_idr === null ? "0.0" : item.remaining_plafond_idr === "" ? "0.0" : item.remaining_plafond_idr,
                                item.current_ratio_financial == null ? "" : item.current_ratio_financial,
                                item.current_ratio_current === null ? "0.0" : item.current_ratio_current === "" ? "0.0" : item.current_ratio_current,
                                item.der_financial == null ? "" : item.der_financial,
                                item.der_current === null ? "0.0" : item.der_current === "" ? "0.0" : item.der_current,
                                item.debt_to_ebitda_financial == null ? "" : item.debt_to_ebitda_financial,
                                item.debt_to_ebitda_current === null ? "0.0" : item.debt_to_ebitda_current === "" ? "0.0" : item.debt_to_ebitda_current,
                                item.ebitda_to_interest_financial == null ? "" : item.ebitda_to_interest_financial,
                                item.ebitda_to_interest_current === null ? "0.0" : item.ebitda_to_interest_current === "" ? "0.0" : item.ebitda_to_interest_current,
                                item.other_ratio1_ratio_name == null ? "" : item.other_ratio1_ratio_name,
                                item.other_ratio1_financial === null ? "0.0" : item.other_ratio1_financial === "" ? "0.0" : item.other_ratio1_financial,
                                item.other_ratio1_current === null ? "0.0" : item.other_ratio1_current === "" ? "0.0" : item.other_ratio1_current,
                                item.other_ratio2_ratio_name == null ? "" : item.other_ratio2_ratio_name,
                                item.other_ratio2_financial === null ? "0.0" : item.other_ratio2_financial === "" ? "0.0" : item.other_ratio2_financial,
                                item.other_ratio2_current === null ? "0.0" : item.other_ratio2_current === "" ? "0.0" : item.other_ratio2_current,
                                item.other_ratio3_ratio_name == null ? "" : item.other_ratio3_ratio_name,
                                item.other_ratio3_financial === null ? "0.0" : item.other_ratio3_financial === "" ? "0.0" : item.other_ratio3_financial,
                                item.other_ratio3_current === null ? "0.0" : item.other_ratio3_current === "" ? "0.0" : item.other_ratio3_current,
                                item.other_ratio4_ratio_name == null ? "" : item.other_ratio4_ratio_name,
                                item.other_ratio4_financial === null ? "0.0" : item.other_ratio4_financial === "" ? "0.0" : item.other_ratio4_financial,
                                item.other_ratio4_current === null ? "0.0" : item.other_ratio4_current === "" ? "0.0" : item.other_ratio4_current,
                                item.notes,
                            ])
                        }

                        // if (item.children !== null) {
                        //     if (item.children.length > 0) {
                        //         item.children.map((items, indexs) => {
                        //             handlePushChild(items)
                        //         })
                        //     }
                        // }
                    })
                    console.log(dataTable);
                    if (dataTable.length == 0) {
                        dataTable.push(
                            [3, "", "", "", "", this.props.company.company_name, null, null, "", null, "0.00", "", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "", 0],
                            [9, "", "", "", "", "", { value: "Grand Total" }, null, "", "", "", "0", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "notes", 999999],
                        )
                    }

                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, dataDelete: [] }, () => {
                        this.handleCalculate()
                        this.state.dataTable.map(item => {
                            if (item[23].length > 0) {
                                // console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true })
                            }
                        })
                        // console.log(this.state.buttonError)
                    })
                    // console.log(dataTable);
                }
            }
        })
    }

    uploadLOCF(type) {
        let data = []
        let error = false
        this.deleteReport()
        this.state.dataTable.map(i => {
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[8] == "" || i[9] == "" || i[10] == "" || i[11] == "") {
                    error = true
                }

                if (i[7].value == 'Others' && i[18] == '') {
                    error = true
                }
                let tgl = String(i[9]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[10] == "" ? "0.00" : i[10],
                        "currency": i[11],
                        "loan_plafond_amount_ori": Number(i[12]) == "" ? "0.0" : Number(i[12]),
                        "loan_plafond_amount_idr": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "out_loan_ki_amount_ori": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_idr": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_kmk_amount_ori": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_idr": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[18],
                        "out_loan_other_amount_ori": Number(i[19]) == "" ? "0.0" : Number(i[19]),
                        "out_loan_other_amount_idr": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "total_out_loan_ori": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_idr": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "remaining_plafond_ori": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_idr": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "current_ratio_financial": Number(i[25]) == "" ? "0.00" : Number(i[25]),
                        "current_ratio_current": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "der_financial": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_current": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "debt_to_ebitda_financial": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_current": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "ebitda_to_interest_financial": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_current": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "other_ratio1_ratio_name": i[33],
                        "other_ratio1_financial": Number(i[34]) == "" ? "0.00" : Number(i[34]),
                        "other_ratio1_current": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio2_ratio_name": i[36],
                        "other_ratio2_financial": Number(i[37]) == "" ? "0.00" : Number(i[37]),
                        "other_ratio2_current": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio3_ratio_name": i[39],
                        "other_ratio3_financial": Number(i[40]) == "" ? "0.00" : Number(i[40]),
                        "other_ratio3_current": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio4_ratio_name": i[42],
                        "other_ratio4_financial": Number(i[43]) == "" ? "0.00" : Number(i[43]),
                        "other_ratio4_current": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "notes": i[45],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[10] == "" ? "0.00" : i[10],
                        "currency": i[11],
                        "loan_plafond_amount_ori": fixNumber(Number(i[12]), 1) == "" ? "0.0" : fixNumber(Number(i[12]), 1),
                        "loan_plafond_amount_idr": fixNumber(Number(i[13]), 1) == "" ? "0.0" : fixNumber(Number(i[13]), 1),
                        "out_loan_ki_amount_ori": fixNumber(Number(i[14]), 1) == "" ? "0.0" : fixNumber(Number(i[14]), 1),
                        "out_loan_ki_amount_idr": fixNumber(Number(i[15]), 1) == "" ? "0.0" : fixNumber(Number(i[15]), 1),
                        "out_loan_kmk_amount_ori": fixNumber(Number(i[16]), 1) == "" ? "0.0" : fixNumber(Number(i[16]), 1),
                        "out_loan_kmk_amount_idr": fixNumber(Number(i[17]), 1) == "" ? "0.0" : fixNumber(Number(i[17]), 1),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[18],
                        "out_loan_other_amount_ori": fixNumber(Number(i[19]), 1) == "" ? "0.0" : fixNumber(Number(i[19]), 1),
                        "out_loan_other_amount_idr": fixNumber(Number(i[20]), 1) == "" ? "0.0" : fixNumber(Number(i[20]), 1),
                        "total_out_loan_ori": fixNumber(Number(i[21]), 1) == "" ? "0.0" : fixNumber(Number(i[21]), 1),
                        "total_out_loan_idr": fixNumber(Number(i[22]), 1) == "" ? "0.0" : fixNumber(Number(i[22]), 1),
                        "remaining_plafond_ori": fixNumber(Number(i[23]), 1) == "" ? "0.0" : fixNumber(Number(i[23]), 1),
                        "remaining_plafond_idr": fixNumber(Number(i[24]), 1) == "" ? "0.0" : fixNumber(Number(i[24]), 1),
                        "current_ratio_financial": fixNumber(Number(i[25]), 2) == "" ? "0.00" : fixNumber(Number(i[25]), 2),
                        "current_ratio_current": fixNumber(Number(i[26]), 2) == "" ? "0.00" : fixNumber(Number(i[26]), 2),
                        "der_financial": fixNumber(Number(i[27]), 2) == "" ? "0.00" : fixNumber(Number(i[27]), 2),
                        "der_current": fixNumber(Number(i[28]), 2) == "" ? "0.00" : fixNumber(Number(i[28]), 2),
                        "debt_to_ebitda_financial": fixNumber(Number(i[29]), 2) == "" ? "0.00" : fixNumber(Number(i[29]), 2),
                        "debt_to_ebitda_current": fixNumber(Number(i[30]), 2) == "" ? "0.00" : fixNumber(Number(i[30]), 2),
                        "ebitda_to_interest_financial": fixNumber(Number(i[31]), 2) == "" ? "0.00" : fixNumber(Number(i[31]), 2),
                        "ebitda_to_interest_current": fixNumber(Number(i[32]), 2) == "" ? "0.00" : fixNumber(Number(i[32]), 2),
                        "other_ratio1_ratio_name": i[33],
                        "other_ratio1_financial": fixNumber(Number(i[34]), 2) == "" ? "0.00" : fixNumber(Number(i[34]), 2),
                        "other_ratio1_current": fixNumber(Number(i[35]), 2) == "" ? "0.00" : fixNumber(Number(i[35]), 2),
                        "other_ratio2_ratio_name": i[36],
                        "other_ratio2_financial": fixNumber(Number(i[37]), 2) == "" ? "0.00" : fixNumber(Number(i[37]), 2),
                        "other_ratio2_current": fixNumber(Number(i[38]), 2) == "" ? "0.00" : fixNumber(Number(i[38]), 2),
                        "other_ratio3_ratio_name": i[39],
                        "other_ratio3_financial": fixNumber(Number(i[40]), 2) == "" ? "0.00" : fixNumber(Number(i[40]), 2),
                        "other_ratio3_current": fixNumber(Number(i[41]), 2) == "" ? "0.00" : fixNumber(Number(i[41]), 2),
                        "other_ratio4_ratio_name": i[42],
                        "other_ratio4_financial": fixNumber(Number(i[43]), 2) == "" ? "0.00" : fixNumber(Number(i[43]), 2),
                        "other_ratio4_current": fixNumber(Number(i[44]), 2) == "" ? "0.00" : fixNumber(Number(i[44]), 2),
                        "notes": i[45],
                    })
                }

            }
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "locf": data,
            "per_bs": this.state.perBS,
            "diff": this.state.diff,
            "total_loan": this.state.perBS
        }
        console.log(JSON.stringify(body));
        if (error && type == 'submitted') {
            this.setState({ handleDoubleClick: 0, saveDraft: false, saveComp: true, loading: false, snekbar: true, snekbarMsg: 'Data Incomplete', handleDoubleClick: 0 })
        } else {
            api.create('UPLOAD').uploadMonthlyReportLOCF(body).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === "success") {
                            this.props.saveToMonthlyReport('LOCF')
                            // this.props.onClickClose()
                            // this.props.getReport()
                        } else {
                            if (response.data?.message == "Please Set Up Rate Currency First") {
                                this.setState({ visibleAlertSave: true })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                            // alert(response.data.status)
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                }
                this.setState({ handleDoubleClick: 0 })
            })
        }
    }

    getBankData() {
        let body = {
            group: 'BANK',
            company_id: this.props.company.company_id,
            type: 'BANK_NAME',
            currency_id: this.props.defaultCurrency.id,
        }
        this.setState({ dataLoaded: false })
        api.create().getAllSettingByType(body).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        // // // console.log(data)
                        let inputBank = []

                        data.map((item) => {
                            inputBank.push({
                                value: `${item.value}`
                            })
                        })
                        let defaultProps = {
                            options: inputBank,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // // // console.log(defaultProps)
                        this.setState({ bankNameList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getTypeOfCredit() {
        let body = {
            group: 'BANK',
            company_id: this.props.company.company_id,
            type: 'TYPE_OF_CREDIT',
            currency_id: this.props.defaultCurrency.id,
        }
        api.create().getAllSettingByType(body).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        // // // console.log(data)
                        let inputTypeOfCredit = []

                        data.map((item) => {
                            inputTypeOfCredit.push({
                                value: item.value
                            })
                        })
                        let defaultProps = {
                            options: inputTypeOfCredit,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // // // console.log(defaultProps)
                        this.setState({ typeOfCreditList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/locf/monthly_report/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&months=${this.props.month.month_id}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // console.log(this.props.report_id)
        // console.log(this.props.company.company_id)
        // console.log(this.props.periode)
        // console.log(this.props.month.month_id)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report List of Credit Facilities.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/locf/monthly_report/export_monthly_report?monthly_report_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        let urls = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/locf/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        // console.log(url);
        // console.log(urls);
        let res = await fetch(
            this.props.monthlyReportId == null ? url : urls
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report List of Credit Facilities.xlsx';
            a.click();
        }
    }

    getSubmission() {
        this.setState({ loading: true })
        let payload = {
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "is_approver": true
        }
        api.create().getSubmission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        submissionID: response.data.data.submission_id,
                        lastRevision: response.data.data.last_revision,
                    }, () => {
                        this.getDataRatio()
                    })
                } else {
                    this.setState({ submissionID: null, loading: false })
                }
            }
        })
    }

    getPerBS() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
        }
        api.create().getPerBSiMontlyReportLOCF(payload).then((response) => {
            console.log(response)
            // if (this.state.get_for == 'view') {
            //     this.setState({perBS: "0.0"})
            // } else {
            if (response.data.status == "success") {
                this.setState({
                    perBS: this.props.defaultCurrency.id == 1 ? (response.data.data.per_bs == null || response.data.data.per_bs == '' ? fixNumber(Number(0), 1) : fixNumber(Number(response.data.data.per_bs), 1)) : (response.data.data.per_bs == null || response.data.data.per_bs == '' ? Number(0) : Number(response.data.data.per_bs)),
                    totalOutStand: response.data.data.total_loan,
                    diff: response.data.data.diff
                })
            }
            // }
        })
    }

    getDataRatio() {
        let payload = {
            "report": 'ratio',
            "monthlyReportId": this.props.monthlyReportId,
            "periode": this.props.periode,
            "companyId": this.props.company.company_id,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
        }
        api.create().getRatioLOCF(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable = []
            if (response.data) {
                if (response.data.status === 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.uom,
                                item.ratio.total_actual_before === null ? "0.0" : item.ratio.total_actual_before === "" ? "0.0" : item.ratio.total_actual_before,
                                // Number(item.ratio.monthly_january).toFixed(2),
                                Number(item.ratio.monthly_january),
                                Number(item.ratio.monthly_february),
                                Number(item.ratio.monthly_march),
                                Number(item.ratio.monthly_april),
                                Number(item.ratio.monthly_may),
                                Number(item.ratio.monthly_june),
                                Number(item.ratio.monthly_july),
                                Number(item.ratio.monthly_august),
                                Number(item.ratio.monthly_september),
                                Number(item.ratio.monthly_october),
                                Number(item.ratio.monthly_november),
                                Number(item.ratio.monthly_december),
                                Number(item.ratio.total_next_year),
                                Number(item.ratio.total_more_year),
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.oum,
                            item.ratio.total_actual_before === null ? "0.0" : item.ratio.total_actual_before === "" ? "0.0" : item.ratio.total_actual_before,
                            Number(item.ratio.monthly_january),
                            Number(item.ratio.monthly_february),
                            Number(item.ratio.monthly_march),
                            Number(item.ratio.monthly_april),
                            Number(item.ratio.monthly_may),
                            Number(item.ratio.monthly_june),
                            Number(item.ratio.monthly_july),
                            Number(item.ratio.monthly_august),
                            Number(item.ratio.monthly_september),
                            Number(item.ratio.monthly_october),
                            Number(item.ratio.monthly_november),
                            Number(item.ratio.monthly_december),
                            Number(item.ratio.total_next_year),
                            Number(item.ratio.total_more_year),
                            item.order,
                            item.condition_it_should_be,
                            item.condition_if_wrong
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    console.log(dataTable)
                    this.setState({ dataTableRatio: dataTable }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    backToMonthlyReport(type) {
        // this.setState({ loading: true })
        let data = []
        let error = false
        this.deleteReport()
        this.state.dataTable.map(i => {
            console.log(i);
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[8] == "" || i[9] == "" || i[10] == "" || i[11] == "") {
                    error = true
                }
                if (i[7].value == 'Others' && i[18] == '') {
                    error = true
                }
                let tgl = String(i[9]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "loan_maturity_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        // "loan_maturity_date":  i[9],
                        "interest": i[10] == "" ? "0.00" : i[10],
                        "currency": i[11],
                        "loan_plafond_amount_ori": Number(i[12]) == "" ? "0.0" : Number(i[12]),
                        "loan_plafond_amount_idr": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "out_loan_ki_amount_ori": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_idr": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_kmk_amount_ori": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_idr": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[18],
                        "out_loan_other_amount_ori": Number(i[19]) == "" ? "0.0" : Number(i[19]),
                        "out_loan_other_amount_idr": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "total_out_loan_ori": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_idr": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "remaining_plafond_ori": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_idr": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "current_ratio_financial": Number(i[25]) == "" ? "0.00" : Number(i[25]),
                        "current_ratio_current": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "der_financial": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_current": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "debt_to_ebitda_financial": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_current": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "ebitda_to_interest_financial": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_current": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "other_ratio1_ratio_name": i[33],
                        "other_ratio1_financial": Number(i[34]) == "" ? "0.00" : Number(i[34]),
                        "other_ratio1_current": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio2_ratio_name": i[36],
                        "other_ratio2_financial": Number(i[37]) == "" ? "0.00" : Number(i[37]),
                        "other_ratio2_current": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio3_ratio_name": i[39],
                        "other_ratio3_financial": Number(i[40]) == "" ? "0.00" : Number(i[40]),
                        "other_ratio3_current": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio4_ratio_name": i[42],
                        "other_ratio4_financial": Number(i[43]) == "" ? "0.00" : Number(i[43]),
                        "other_ratio4_current": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "notes": i[45],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "loan_maturity_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        // "loan_maturity_date":  i[9],
                        "interest": i[10] == "" ? "0.00" : i[10],
                        "currency": i[11],
                        "loan_plafond_amount_ori": fixNumber(Number(i[12]), 1) == "" ? "0.0" : fixNumber(Number(i[12]), 1),
                        "loan_plafond_amount_idr": fixNumber(Number(i[13]), 1) == "" ? "0.0" : fixNumber(Number(i[13]), 1),
                        "out_loan_ki_amount_ori": fixNumber(Number(i[14]), 1) == "" ? "0.0" : fixNumber(Number(i[14]), 1),
                        "out_loan_ki_amount_idr": fixNumber(Number(i[15]), 1) == "" ? "0.0" : fixNumber(Number(i[15]), 1),
                        "out_loan_kmk_amount_ori": fixNumber(Number(i[16]), 1) == "" ? "0.0" : fixNumber(Number(i[16]), 1),
                        "out_loan_kmk_amount_idr": fixNumber(Number(i[17]), 1) == "" ? "0.0" : fixNumber(Number(i[17]), 1),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[18],
                        "out_loan_other_amount_ori": fixNumber(Number(i[19]), 1) == "" ? "0.0" : fixNumber(Number(i[19]), 1),
                        "out_loan_other_amount_idr": fixNumber(Number(i[20]), 1) == "" ? "0.0" : fixNumber(Number(i[20]), 1),
                        "total_out_loan_ori": fixNumber(Number(i[21]), 1) == "" ? "0.0" : fixNumber(Number(i[21]), 1),
                        "total_out_loan_idr": fixNumber(Number(i[22]), 1) == "" ? "0.0" : fixNumber(Number(i[22]), 1),
                        "remaining_plafond_ori": fixNumber(Number(i[23]), 1) == "" ? "0.0" : fixNumber(Number(i[23]), 1),
                        "remaining_plafond_idr": fixNumber(Number(i[24]), 1) == "" ? "0.0" : fixNumber(Number(i[24]), 1),
                        "current_ratio_financial": fixNumber(Number(i[25]), 2) == "" ? "0.00" : fixNumber(Number(i[25]), 2),
                        "current_ratio_current": fixNumber(Number(i[26]), 2) == "" ? "0.00" : fixNumber(Number(i[26]), 2),
                        "der_financial": fixNumber(Number(i[27]), 2) == "" ? "0.00" : fixNumber(Number(i[27]), 2),
                        "der_current": fixNumber(Number(i[28]), 2) == "" ? "0.00" : fixNumber(Number(i[28]), 2),
                        "debt_to_ebitda_financial": fixNumber(Number(i[29]), 2) == "" ? "0.00" : fixNumber(Number(i[29]), 2),
                        "debt_to_ebitda_current": fixNumber(Number(i[30]), 2) == "" ? "0.00" : fixNumber(Number(i[30]), 2),
                        "ebitda_to_interest_financial": fixNumber(Number(i[31]), 2) == "" ? "0.00" : fixNumber(Number(i[31]), 2),
                        "ebitda_to_interest_current": fixNumber(Number(i[32]), 2) == "" ? "0.00" : fixNumber(Number(i[32]), 2),
                        "other_ratio1_ratio_name": i[33],
                        "other_ratio1_financial": fixNumber(Number(i[34]), 2) == "" ? "0.00" : fixNumber(Number(i[34]), 2),
                        "other_ratio1_current": fixNumber(Number(i[35]), 2) == "" ? "0.00" : fixNumber(Number(i[35]), 2),
                        "other_ratio2_ratio_name": i[36],
                        "other_ratio2_financial": fixNumber(Number(i[37]), 2) == "" ? "0.00" : fixNumber(Number(i[37]), 2),
                        "other_ratio2_current": fixNumber(Number(i[38]), 2) == "" ? "0.00" : fixNumber(Number(i[38]), 2),
                        "other_ratio3_ratio_name": i[39],
                        "other_ratio3_financial": fixNumber(Number(i[40]), 2) == "" ? "0.00" : fixNumber(Number(i[40]), 2),
                        "other_ratio3_current": fixNumber(Number(i[41]), 2) == "" ? "0.00" : fixNumber(Number(i[41]), 2),
                        "other_ratio4_ratio_name": i[42],
                        "other_ratio4_financial": fixNumber(Number(i[43]), 2) == "" ? "0.00" : fixNumber(Number(i[43]), 2),
                        "other_ratio4_current": fixNumber(Number(i[44]), 2) == "" ? "0.00" : fixNumber(Number(i[44]), 2),
                        "notes": i[45],
                    })
                }

            }
        })
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "locf": data,
            "per_bs": this.state.perBS,
            "diff": this.state.diff,
            "total_loan": this.state.perBS
        }

        console.log(JSON.stringify(payload))

        if (error && type == 'submitted') {
            this.setState({ handleDoubleClick: 0, saveDraft: false, saveComp: true, loading: false, snekbar: true, snekbarMsg: 'Data Incomplete', handleDoubleClick: 0 })
        } else {
            api.create('UPLOAD').createMonthlyReportLOCF(payload).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.data.status === "success") {
                        this.props.saveToMonthlyReport('LOCF')
                    } else {
                        if (response.data?.message == "Please Set Up Rate Currency First") {
                            this.setState({ visibleAlertSave: true })
                        } else {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                document.body.style.overflow = 'unset';
                                if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                    setTimeout(() => {
                                        localStorage.removeItem(Constant.TOKEN)
                                        window.location.reload();
                                    }, 1000);
                                }
                                this.props.saveToMonthlyReport()
                            })
                        }
                    }
                    // else {
                    //     this.setState({ loading: false }, () => {
                    //         this.props.saveToMonthlyReport()
                    //     })
                    // }
                } else {
                    this.setState({ loading: false }, () => {
                        // this.getSubmission()
                        document.body.style.overflow = 'unset';
                    })
                }
                this.setState({ handleDoubleClick: 0 })
            })
        }
    }


    handleCalculate = () => {
        let dataTable2 = this.state.dataTable
        this.setState({ loading: true }, () => {
            let bankPrev = ""
            let idPrev = 0
            let newData = []
            let dataCoba = []
            let bankNameEmpty = false
            let totalLoan = 0
            console.log(dataTable2);
            dataTable2.map((item, index) => {
                if (item[0] !== 8) {
                    if (item[6] == null) {
                        bankNameEmpty = true
                    } else {
                        let groupName = String(item[6].value).split("-")
                        let indexAS = dataCoba.findIndex((val) => item[6].value.includes(val.groupName))
                        if (indexAS == -1) {
                            dataCoba.push({
                                groupName: groupName[groupName.length - 1],
                                data: [item]
                            })
                        } else {
                            let indexDD = dataCoba[indexAS].data.length - 1 == -1 ? 0 : dataCoba[indexAS].data.length - 1
                            if (String(dataCoba[indexAS].data[indexDD]).includes('Total')) {
                                let dataAwal = []
                                let dataAkhir = []
                                dataAwal = dataCoba[indexAS].data.splice(0, dataCoba[indexAS].data.length - 2)
                                dataAkhir = dataCoba[indexAS].data.splice(dataCoba[indexAS].data.length - 1, 1)
                                dataAwal.push(item)
                                dataCoba[indexAS].data = dataAwal.concat(dataAkhir)
                            } else {
                                dataCoba[indexAS].data.push(item)
                            }
                        }
                    }
                }
            })
            console.log(dataCoba);
            let dataGabung = []
            if (!bankNameEmpty) {
                dataCoba.map((item, index) => {
                    item.data.map((items, index) => {
                        dataGabung.push(items)
                    })
                })
                console.log(dataGabung);
                dataGabung.map((items, index) => {
                    console.log(items);
                    if (items[0] == 3) {
                        console.log(Number(totalLoan));
                        this.props.defaultCurrency.id == 1 ? totalLoan += items[22] : totalLoan += items[21]
                    }
                    if (bankPrev != "") {
                        if (items[6].value !== bankPrev) {
                            bankPrev = items[6].value
                            if (items[6].value == 'Grand Total') {
                                // if (dataTable2.length > 2) {
                                //     newData.push(items)
                                // } else { 
                                if (String(dataGabung[index - 1][6].value).includes('Total ')) {
                                    newData.push(items)
                                } else {
                                    // if (String(dataGabung[index][6].value).includes('Total ')) {
                                    //     newData.push(items)
                                    // } else { 
                                    // items[46] = index + 1
                                    let nameTotal = String(dataGabung[index - 1][6].value).split("-")
                                    newData.push([
                                        8,
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        { value: 'Total ' + nameTotal[nameTotal.length - 1] },
                                        null,
                                        "",
                                        null,
                                        "0.00",
                                        "",
                                        "",
                                        "0",
                                        "",
                                        "0",
                                        "",
                                        "0",
                                        "",
                                        "",
                                        "0",
                                        "0",
                                        "0",
                                        "0",
                                        "0",
                                        "",
                                        "0",
                                        "",
                                        "0",
                                        "",
                                        "0",
                                        "",
                                        "0",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "",
                                        index],
                                        items,
                                    )
                                    // }
                                }
                                // }
                            } else {
                                if (String(dataGabung[index - 1][6].value).includes('Total ')) {
                                    newData.push(items)
                                } else {
                                    if (String(dataGabung[index][6].value).includes('Total ')) {
                                        newData.push(items)
                                    } else {
                                        items[46] = index + 1
                                        let nameTotal = String(dataGabung[index - 1][6].value).split("-")
                                        newData.push([
                                            8,
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            { value: 'Total ' + nameTotal[nameTotal.length - 1] },
                                            null,
                                            "",
                                            null,
                                            "0.00",
                                            "",
                                            "",
                                            "0",
                                            "",
                                            "0",
                                            "",
                                            "0",
                                            "",
                                            "",
                                            "0",
                                            "0",
                                            "0",
                                            "0",
                                            "0",
                                            "",
                                            "0",
                                            "",
                                            "0",
                                            "",
                                            "0",
                                            "",
                                            "0",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            "",
                                            index],
                                            items,
                                        )
                                    }

                                }
                            }
                        }
                        else {
                            newData.push(items)
                        }
                    } else {
                        bankPrev = items[6].value
                        idPrev = items[0]
                        newData.push(items)
                    }
                })
            } else {
                if (this.state.get_for == 'edit') {
                    this.setState({ snekbar: true, snekbarMsg: 'Bank Names Cannot be Empty' })
                }
            }

            setTimeout(() => {
                // console.log(dataCoba)
                // console.log(dataGabung)
                console.log(newData)
                // console.log(dataTampungBank)
                console.log(totalLoan);
                console.log(this.state.perBS)
                console.log(this.state.diff)
                console.log(bankNameEmpty)
                // dataTable: newData, totalOutStand: newData[newData.length-1][22]
                if (bankNameEmpty) {
                    if (this.state.get_for == 'view') {
                        this.setState({ loading: false, dataTable: this.state.dataTable, diff: this.state.diff == null ? "0.0" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(0 - this.state.perBS), 1) : Number(0 - this.state.perBS), perBS: this.state.totalOutStand == null ? "0.0" : this.state.totalOutStand, saveDraft: false, saveComp: true })
                    } else {
                        this.setState({ loading: false, dataTable: this.state.dataTable, diff: this.props.defaultCurrency.id == 1 ? fixNumber(Number(0 - this.state.perBS), 1) : Number(0 - this.state.perBS), saveDraft: false, saveComp: true })
                    }
                } else {
                    if (this.state.get_for == 'view') {
                        if (this.props.defaultCurrency.id == 1) {
                            this.setState({ loading: false, dataTable: newData, diff: this.state.diff == null ? "0.0" : fixNumber(Number(fixNumber(Number(totalLoan), 1) - this.state.perBS), 1), perBS: this.state.totalOutStand == null ? "0.0" : this.state.totalOutStand })
                        } else {
                            this.setState({ loading: false, dataTable: newData, diff: this.state.diff == null ? "0.0" : fixNumber(Number(Number(totalLoan) - this.state.perBS),1), perBS: this.state.totalOutStand == null ? "0.0" : this.state.totalOutStand })
                        }

                    } else {
                        if (this.props.defaultCurrency.id == 1) {
                            this.setState({ loading: false, dataTable: newData, diff: fixNumber(Number(fixNumber(Number(totalLoan), 1) - this.state.perBS), 1), saveDraft: false, saveComp: Number(fixNumber(Number(totalLoan), 1) - this.state.perBS) == 0 || fixNumber(Number(fixNumber(Number(totalLoan), 1) - this.state.perBS),1) == "-0.0" ? false : true })
                        } else {
                            this.setState({ loading: false, dataTable: newData, diff: fixNumber(Number(Number(totalLoan) - this.state.perBS),1), saveDraft: false, saveComp: Number(Number(totalLoan) - this.state.perBS) == 0 || fixNumber(Number(Number(totalLoan) - this.state.perBS),1) == "-0.0" ? false : true })
                        }

                    }
                }
            }, 100);
        })
    }


    render() {
        let dataTable2 = this.state.dataTable
        let loading = this.state.loading
        let dataTampungBank = []
        let indexNyasar = false
        let totalLoan = 0

        // const formatSeparator = (num) => {
        //    return String(num).replace(/(?<!\..*)(\d)(?=(?:\d{3})+(?:\.|$))/g, '$1,')

        // return num
        // }

        const handleAction = (typeReport, tableMeta, typeButton) => {
            // console.log(typeReport)
            if (typeReport == 3) {
                if (dataTable2.length == 2) {
                    if (typeButton == 'add') {
                        return true
                    } else {
                        return false
                    }
                } else {
                    return true
                }
            } else {
                return false
            }
        }

        const handleChange = (value, tableMeta, column, typeChange, typeDrop) => {
            let val = ''
            if (typeChange == 'date') {
                dataTable2[tableMeta.rowIndex][column] = format(value, 'yyyy-MM-dd')
                this.setState({ loading: true }, () => {
                    this.setState({ loading: false })
                })
            } else {
                if (column != 8 && column != 11 && column != 18 && column != 25 && column != 27 && column != 29 && column != 31 && column != 33 && column != 36 && column != 39 && column != 42 && column != 45) {
                    val = String(value).split(",").join("")
                    val = this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 2) : Number(val)
                } else {
                    val = String(value).split(",").join("")

                }

                if (value.value !== undefined) {
                    if (value.value == 'Investment Loan') {
                        dataTable2[tableMeta.rowIndex][16] = 0
                        dataTable2[tableMeta.rowIndex][17] = 0
                        dataTable2[tableMeta.rowIndex][18] = ""
                        dataTable2[tableMeta.rowIndex][19] = 0
                        dataTable2[tableMeta.rowIndex][20] = 0
                    } else if (value.value == 'Revolving Loan (KMK)') {
                        dataTable2[tableMeta.rowIndex][14] = 0
                        dataTable2[tableMeta.rowIndex][15] = 0
                        dataTable2[tableMeta.rowIndex][18] = ""
                        dataTable2[tableMeta.rowIndex][19] = 0
                        dataTable2[tableMeta.rowIndex][20] = 0
                    } else if (value.value == 'others') {
                        dataTable2[tableMeta.rowIndex][14] = 0
                        dataTable2[tableMeta.rowIndex][15] = 0
                        dataTable2[tableMeta.rowIndex][16] = 0
                        dataTable2[tableMeta.rowIndex][17] = 0
                    }
                    dataTable2[tableMeta.rowIndex][column] = value
                } else {
                    dataTable2[tableMeta.rowIndex][column] = val
                }
            }
            console.log(dataTable2[tableMeta.rowIndex][column]);
            console.log(value)
            console.log(String(value).split(",").join(""))
        }

        const handleValueDropDown = (value, type, tableMeta) => {
            let data = type == 'bankName' ? this.state.bankNameList.options : this.state.typeOfCreditList.options
            let index = 0
            if (type == 'bankName' && dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] != null && dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] != "") {
                indexNyasar = true
            }
            if (value == null) {
                index = -1
            } else {
                index = data.findIndex((val) => String(val.value) == String(value.value))
            }
            if (index == -1) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = null
                return null
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
                return value
            }
        }

        const handleTableRatio = (value, tableMeta, column, reportName) => {
            let dataTableRatio = this.state.dataTableRatio
            let indexId = dataTableRatio.findIndex((val) => String(val[5]).toLocaleLowerCase() == String(reportName).toLocaleLowerCase())
            let valuez = 0
            if (indexId != -1) {
                valuez = dataTableRatio[indexId][Number(this.props.month.month_id) + 7]
                // console.log(valuez)
                if (String(valuez).includes('infinity')) {
                    valuez = 0
                }
            }
            dataTable2[tableMeta.rowIndex][column] = valuez
            return valuez
        }

        const handleFormulaHardcode = (value, tableMeta, column) => {
            // console.log("------------coba------------------");
            // console.log(tableMeta);
            // console.log(tableMeta.rowData[0]);
            let valuez = 0
            if (tableMeta.rowData[0] == 8) {
                dataTable2.map((item, index) => {
                    if (item[6].value.includes(String(tableMeta.rowData[6].value).substr(6, tableMeta.rowData[6].length)) && item[0] != 8) {
                        valuez += Number(item[column])
                    }
                })
            } else if (tableMeta.rowData[0] == 9) {
                dataTable2.map((item, index) => {
                    if (item[0] == 8) {
                        valuez += Number(item[column])
                    }
                })
                if (column == 22) {
                    totalLoan = valuez
                }
            } else {
                if (column == 21) {
                    valuez = Number(tableMeta.rowData[14]) + Number(tableMeta.rowData[16]) + Number(tableMeta.rowData[19])
                } else if (column == 22) {
                    valuez = Number(tableMeta.rowData[15]) + Number(tableMeta.rowData[17]) + Number(tableMeta.rowData[20])
                } else if (column == 23) {
                    valuez = Number(tableMeta.rowData[12]) - Number(tableMeta.rowData[21])
                } else if (column == 24) {
                    valuez = Number(tableMeta.rowData[13]) - Number(tableMeta.rowData[22])
                }

            }
            dataTable2[tableMeta.rowIndex][column] = valuez
            return valuez
        }

        const handleTambah = (data, rowIndex) => {
            // // console.log(dataTable2)
            let newData = []
            let indexxx = 0
            dataTable2.map((item, index) => {
                indexxx = index
                if (item[6] == "Grand Total") {
                    item[46] = 999999
                } else {
                    item[46] = indexxx
                }
                newData.push(item)
                if (index == rowIndex) {
                    indexxx = index + 1
                    newData.push([
                        3,
                        "",
                        "",
                        "",
                        "",
                        this.props.company.company_name,
                        item[6],
                        null,
                        "",
                        null,
                        "0.00",
                        "",
                        "",
                        "0",
                        "",
                        "0",
                        "",
                        "0",
                        "",
                        "",
                        "0",
                        "0",
                        "0",
                        "0",
                        "0",
                        "",
                        "0",
                        "",
                        "0",
                        "",
                        "0",
                        "",
                        "0",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        indexxx],
                    )

                }
            })
            dataTable2 = newData.sort((a, b) => a[46] - b[46])
            this.setState({ dataTable: dataTable2 }, () => {
                setTimeout(() => {
                    this.setState({ loading: false })
                    console.log(dataTable2)
                }, 500)
            })
        }

        const handleDelete = (index) => {
            let dataDelete = this.state.dataDelete
            let berapaInput = 0
            dataTable2.map((items, indexs) => {
                if (items[0] == 3) {
                    berapaInput += 1
                }
            })

            dataDelete.push(dataTable2[index][1])

            let prevData = dataTable2[index - 1] == undefined ? null : dataTable2[index - 1][6]
            let currentData = dataTable2[index][6]
            let nextData = dataTable2[index + 1] == undefined ? null : dataTable2[index + 1][6]

            if (nextData == null) {
                dataTable2.splice(index, 1)
            } else if (nextData.value.includes('Total')) {
                if (prevData !== null && currentData == null) {
                    dataTable2.splice(index, 1)
                } else if (prevData !== null && prevData.value == currentData.value) {
                    dataTable2.splice(index, 1)
                } else if (dataTable2.length > 3) {
                    if (prevData == null) {
                        if (nextData.value.includes('Grand')) {
                            dataTable2.splice(index, 1)
                        } else {
                            dataTable2.splice(index, 2)
                        }
                    } else {
                        dataTable2.splice(index, 2)
                    }
                } else if (dataTable2.length == 3) {
                    if (prevData == null) {
                        if (nextData.value.includes('Grand')) {
                            dataTable2.splice(index, 1)
                        } else {
                            dataTable2.splice(index, 3)
                            dataTable2.push(
                                [3, "", "", "", "", this.props.company.company_name, null, null, "", null, "0.00", "", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "", 0],
                                [9, "", "", "", "", "", { value: "Grand Total" }, null, "", "", "", "0", "", "0", "", "0", "", "0", "", "", "0", "0", "0", "0", "0", "", "0", "", "0", "", "0", "", "0", "", "", "", "", "", "", "", "", "", "", "", "", "notes", 999999],
                            )
                        }
                    } else {
                        dataTable2.splice(index, 1)
                    }
                }
            } else {
                dataTable2.splice(index, 1)
            }

            this.setState({ dataTable: dataTable2, dataDelete }, () => {
                setTimeout(() => {
                    console.log(this.state.dataDelete)
                    this.setState({ loading: false })
                }, 100)
            })
        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    filter: false,
                    display: this.state.get_for == 'view' ? false : true,
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 99, backgroundColor: '#dbdbdb' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            // handleAction(tableMeta.rowData[2]) && 
                            <div style={{ display: 'flex' }}>
                                {/* {tableMeta.rowData[6] === "Active" ? */}
                                {handleAction(tableMeta.rowData[0], tableMeta, 'add') && <span>
                                    <LightTooltip title={'Add'} arrow>
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                            }}
                                            // onClick={() => // // console.log(tableMeta.rowData[1])}
                                            onClick={() => {
                                                this.setState({ loading: true })
                                                handleTambah(tableMeta.rowData[1], tableMeta.rowIndex)
                                            }}
                                        >
                                            <img src={Images.add} />
                                        </button>
                                    </LightTooltip>
                                </span>}
                                {handleAction(tableMeta.rowData[0], tableMeta, 'delete') && <span>
                                    <LightTooltip title={'Delete'} arrow>
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                marginLeft: 5
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true })
                                                handleDelete(tableMeta.rowIndex)
                                            }}
                                        >
                                            <img src={Images.delete} style={{ width: 37, height: 37 }} />
                                        </button>
                                    </LightTooltip>
                                </span>}
                            </div >
                        );
                    }
                }
            }, {
                name: "Borrower (Company) Name",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'center', width: 90 }}>
                                {tableMeta.rowData[0] === 4 ?
                                    null :
                                    val
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Bank Name",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ width: 150 }}>
                                {tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 || tableMeta.rowData[0] === 4 ?
                                    <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{val.value}</Typography>
                                    :
                                    <Autocomplete
                                        {...this.state.bankNameList}
                                        id="bankNameList"
                                        onChange={(event, newInputValue) => handleChange(newInputValue, tableMeta, tableMeta.columnIndex)}
                                        debug
                                        disableClearable
                                        disabled={this.state.get_for == 'view'}
                                        // disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                        value={handleValueDropDown(val, 'bankName', tableMeta)}
                                        style={{ padding: 0, margin: 0 }}
                                        renderInput={(params) =>
                                            <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                                <textarea style={{ borderColor: 'white', width: 150, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[6] == null && this.state.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" {...params.inputProps} />
                                            </div>
                                        }
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Type Of Credit",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <Autocomplete
                                        {...this.state.typeOfCreditList}
                                        id="typeOfCreditList"
                                        onChange={(event, newInputValue) => handleChange(newInputValue, tableMeta, tableMeta.columnIndex)}
                                        debug
                                        value={handleValueDropDown(val, 'typeOfCreditList', tableMeta)}
                                        disableClearable
                                        disabled={this.state.get_for == 'view'}
                                        // disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                        style={{ padding: 0, margin: 0 }}
                                        renderInput={(params) =>
                                            <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                                <textarea style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[7] == null && this.state.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" {...params.inputProps} />
                                            </div>
                                        }
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Remarks",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'left', width: 90 }}>
                                {tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                    null :
                                    <div style={{ padding: 0, margin: 0 }}>
                                        <textarea disabled={this.state.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[8] == '' && this.state.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" defaultValue={tableMeta.rowData[8]}
                                            onBlur={(event) => handleChange(event.target.value, tableMeta, tableMeta.columnIndex)} />
                                    </div>
                                    // <Input
                                    //     disableUnderline={true}
                                    //     style={{ fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                    //     type="text"
                                    //     disabled={tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9 || this.state.get_for == 'view'? true : false}
                                    //     defaultValue={tableMeta.rowData[8]}
                                    //     // disabled={false}
                                    //     multiline={true}
                                    //     inputProps={{
                                    //         style: {
                                    //             color: this.state.get_for == 'view'? "black" : "#5198ea",
                                    //             textAlign: 'center',
                                    //             backgroundColor: 'white'
                                    //         }
                                    //     }}
                                    // />

                                    //  <ThemeProvider theme={theme}>

                                    //     <Input
                                    //         disableUnderline={true}
                                    //         style={{color: this.state.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginBottom: -105 }}
                                    //         type="text"
                                    //         placeholder=""
                                    //         disabled={tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9? true : false}
                                    //         defaultValue={tableMeta.rowData[8]}
                                    //         multiline
                                    //         rowsMax={3}
                                    //         onBlur={(event) => {
                                    //             // // // console.log(event.target.value)
                                    //             // updateValue(event.target.value)
                                    //             handleChange(event.target.value, tableMeta, tableMeta.columnIndex)
                                    //             // // // console.log(dataTable2)
                                    //         }}
                                    //     />
                                    // </ThemeProvider>
                                }

                            </div>
                        )
                    }
                }
            }, {
                name: "Loan Maturity Date",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9 ?
                                    null :
                                    <DatePicker
                                        margin="normal"
                                        id="loanMatureDate"
                                        // label="Valid To"
                                        format="dd-MM-yyyy"
                                        value={val}
                                        disabled={this.state.get_for == 'view'}
                                        onChange={(e) => handleChange(e, tableMeta, tableMeta.columnIndex, 'date')}
                                        // minDate={this.state.startDate}
                                        KeyboardButtonProps={{
                                            'aria-label': 'change date',
                                        }}
                                        inputProps={{
                                            style: {
                                                marginTop: -10,
                                                textAlign: 'center',
                                                fontSize: 11,
                                                fontFamily: 'Nunito Sans, sans-serif',
                                                color: this.state.get_for == 'view' ? "black" : '#5198ea',
                                                backgroundColor: (tableMeta.rowData[9] == null || tableMeta.rowData[9] == '') && this.state.get_for == 'edit' ? '#ffac99' : 'white'
                                            }
                                        }}
                                        InputLabelProps={{
                                            style: {
                                                fontSize: 11,
                                                color: '#5198ea',
                                                fontFamily: 'Nunito Sans, sans-serif',
                                            }
                                        }}

                                        style={{ padding: 0, margin: 0, width: '100%' }}
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Interest (%)",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9 ?
                                    null :
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        value={value}
                                        control={
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: (tableMeta.rowData[10] == '0.00' || tableMeta.rowData[10] == '') && this.state.get_for == 'edit' ? '#ffac99' : 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                value={this.state.get_for == 'view' ? fixNumber(Number(value), 2) : this.props.defaultCurrency.id == 1 ? fixNumber(Number(value), 2) : Number(value) == 0 ? "0.0" : Number(value)}
                                                disabled={this.state.get_for == 'view'}
                                                // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                onBlur={(event) => {
                                                    // updateValue(event.target.value)
                                                    handleChange(event.target.value, tableMeta, tableMeta.columnIndex)
                                                    // // // // console.log(tableMeta.rowData[0])
                                                }}
                                            />
                                        }
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Currency",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9 ?
                                    null :
                                    <div style={{ padding: 0, margin: 0 }}>
                                        <textarea disabled={this.state.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[11] == '' && this.state.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" defaultValue={tableMeta.rowData[11]}
                                            onBlur={(event) => handleChange(event.target.value, tableMeta, tableMeta.columnIndex)} />
                                    </div>
                                    // <ThemeProvider theme={this.state.get_for == 'view'? theme3 : theme2}>
                                    //     <Input
                                    //         disableUnderline={true}
                                    //         style={{ width: 96, color: this.state.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent', backgroundColor: tableMeta.rowData[11] == '' && this.state.get_for == 'edit'? '#ffac99' : 'white' }}
                                    //         type="text"
                                    //         placeholder=""
                                    //         disabled={this.state.get_for == 'view'}
                                    //         defaultValue={tableMeta.rowData[11]}
                                    //         onBlur={(event) => {
                                    //             // // // console.log(event.target.value)
                                    //             // updateValue(event.target.value)
                                    //             handleChange(event.target.value, tableMeta, tableMeta.columnIndex)
                                    //             // // // console.log(dataTable2)
                                    //         }}
                                    //     />
                                    // </ThemeProvider>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Loan Plafond`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                  <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                              </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount Original (Currency)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount (IDR Equivalent)"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[12], tableMeta, 12)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[12], tableMeta, 12)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[12], tableMeta, 12))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    disabled={this.state.get_for == 'view'}
                                                                    value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(tableMeta.rowData[12]), 1) == 0.0 ? "0.0" : fixNumber(Number(tableMeta.rowData[12]), 1)) : (Number(tableMeta.rowData[12]) == 0.0 ? "0.0" : Number(tableMeta.rowData[12]))}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 12)
                                                                    }}

                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[13], tableMeta, 13)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[13], tableMeta, 13)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[13], tableMeta, 13))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={this.state.get_for == 'view'}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[13]), 1) : Number(tableMeta.rowData[13]) == 0 ? "0.0" : Number(tableMeta.rowData[13])}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 13)
                                                                    }}

                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Outstanding Loan (KI)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                  <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                              </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount Original (Currency)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount (IDR Equivalent)"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[14], tableMeta, 14)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[14], tableMeta, 14)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[14], tableMeta, 14))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : (tableMeta.rowData[7] == null ? "black" : tableMeta.rowData[7].value == 'Investment Loan' ? "#5198ea" : "black"), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={this.state.get_for == 'view' ? true : tableMeta.rowData[7] == null ? true : tableMeta.rowData[7].value == 'Investment Loan' ? false : true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[14]), 1) : Number(tableMeta.rowData[14]) == 0 ? "0.0" : Number(tableMeta.rowData[14])}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 14)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[15], tableMeta, 15)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[15], tableMeta, 15)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[15], tableMeta, 15))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : (tableMeta.rowData[7] == null ? "black" : tableMeta.rowData[7].value == 'Investment Loan' ? "#5198ea" : "black"), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={this.state.get_for == 'view' ? true : tableMeta.rowData[7] == null ? true : tableMeta.rowData[7].value == 'Investment Loan' ? false : true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[15]), 1) : Number(tableMeta.rowData[15]) == 0 ? "0.0" : Number(tableMeta.rowData[15])}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 15)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Outstanding Loan (KMK)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                  <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                              </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount Original (Currency)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount (IDR Equivalent)"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[16], tableMeta, 16)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[16], tableMeta, 16)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[16], tableMeta, 16))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : (tableMeta.rowData[7] == null ? "black" : tableMeta.rowData[7].value == 'Revolving Loan (KMK)' ? "#5198ea" : "black"), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={this.state.get_for == 'view' ? true : tableMeta.rowData[7] == null ? true : tableMeta.rowData[7].value == 'Revolving Loan (KMK)' ? false : true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[16]), 1) : Number(tableMeta.rowData[16]) == 0 ? "0.0" : Number(tableMeta.rowData[16])}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 16)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[17], tableMeta, 17)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[17], tableMeta, 17)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[17], tableMeta, 17))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : (tableMeta.rowData[7] == null ? "black" : tableMeta.rowData[7].value == 'Revolving Loan (KMK)' ? "#5198ea" : "black"), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={this.state.get_for == 'view' ? true : tableMeta.rowData[7] == null ? true : tableMeta.rowData[7].value == 'Revolving Loan (KMK)' ? false : true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[17]), 1) : Number(tableMeta.rowData[17]) == 0 ? "0.0" : Number(tableMeta.rowData[17])}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 17)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Outstanding Loan (Others)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                  <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                              </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6 }}>
                                    <span>{"Type"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, borderLeft: "1px #fff solid", borderRight: "1px #fff solid" }}>
                                    <span>{"Amount Original (Currency)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, width: 120 }}>
                                    <span>{"Amount (IDR Equivalent)"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center" style={{ alignItems: 'center' }}>
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    null
                                                    // <div style={{ flex: 1 }}>
                                                    //     <FormControlLabel
                                                    //         style={{ margin: 0 }}
                                                    //         value={val}
                                                    //         control={
                                                    //             <NumberFormat
                                                    //                 thousandSeparator={true}
                                                    //                 style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    //                 type="text"
                                                    //                 placeholder=""
                                                    //                 disabled={true}
                                                    //                 value={tableMeta.rowData[18]}
                                                    //             />
                                                    //         }
                                                    //     />
                                                    // </div>
                                                    :
                                                    <div style={{ padding: 0, margin: 0 }}>
                                                        <textarea disabled={this.state.get_for == 'view' ? true : tableMeta.rowData[7] == null ? true : tableMeta.rowData[7].value == 'Others' ? false : true} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? 'black' : tableMeta.rowData[7] == null ? 'black' : tableMeta.rowData[7].value == 'Others' ? '#5198ea' : 'black', backgroundColor: this.state.get_for == 'view' ? 'white' : tableMeta.rowData[7] == null ? 'white' : (tableMeta.rowData[18] == '' && tableMeta.rowData[7].value == 'Others' ? '#ffac99' : 'white') }} type="text" defaultValue={tableMeta.rowData[18]}
                                                            onBlur={(event) => handleChange(event.target.value, tableMeta, 18)} />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[19], tableMeta, 19)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[19], tableMeta, 19)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[19], tableMeta, 19))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : (tableMeta.rowData[7] == null ? "black" : tableMeta.rowData[7].value == 'Others' ? "#5198ea" : "black"), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={this.state.get_for == 'view' ? true : tableMeta.rowData[7] == null ? true : tableMeta.rowData[7].value == 'Others' ? false : true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[19]), 1) : Number(tableMeta.rowData[19]) == 0 ? "0.0" : Number(tableMeta.rowData[19])}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 19)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[20], tableMeta, 20)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[20], tableMeta, 20)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[20], tableMeta, 20))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: this.state.get_for == 'view' ? "black" : (tableMeta.rowData[7] == null ? "black" : tableMeta.rowData[7].value == 'Others' ? "#5198ea" : "black"), fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={this.state.get_for == 'view' ? true : tableMeta.rowData[7] == null ? true : tableMeta.rowData[7].value == 'Others' ? false : true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[20]), 1) : Number(tableMeta.rowData[20]) == 0 ? "0.0" : Number(tableMeta.rowData[20])}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 20)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Total Outstanding Loan`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount Original (Currency)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount (IDR Equivalent)"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[21], tableMeta, 21)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[21], tableMeta, 21)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[21], tableMeta, 21))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[21], tableMeta, 21)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[21], tableMeta, 21)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[21], tableMeta, 21))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[22], tableMeta, 22)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[22], tableMeta, 22)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[22], tableMeta, 22))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[22], tableMeta, 22)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[22], tableMeta, 22)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[22], tableMeta, 22))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Remaining Plafond`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount Original (Currency)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, paddingBottom: dataTable2.length == 0 ? 5 : 6, backgroundColor: '#07a7d0' }}>
                                    <span>{"Amount (IDR Equivalent)"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[23], tableMeta, 23)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[23], tableMeta, 23)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[23], tableMeta, 23))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[23], tableMeta, 23)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[23], tableMeta, 23)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[23], tableMeta, 23))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 ?
                                                null :
                                                tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "black", fontSize: 12, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[24], tableMeta, 24)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[24], tableMeta, 24)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[24], tableMeta, 24))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[24], tableMeta, 24)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[24], tableMeta, 24)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[24], tableMeta, 24))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Current Ratio`,
                options: {
                    customHeadRender: (columnMeta, tableMeta) => {
                        // console.log(columnMeta)
                        // console.log(tableMeta)
                        return (
                            <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                                <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                                <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", height: 43, display: 'grid', alignItems: 'center', backgroundColor: '#07a7d0', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                        <span>{"Financial Covenant"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                        <span>{"Current Testing"}</span>
                                    </div>
                                </div>
                            </th>
                        )
                    },
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[25]), 2) : Number(tableMeta.rowData[25]) == 0 ? "0.0" : Number(tableMeta.rowData[25])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 25)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(handleTableRatio(tableMeta.rowData[26], tableMeta, 26, "Current Ratio")), 1)) : (Number(handleTableRatio(tableMeta.rowData[26], tableMeta, 26, "Current Ratio")) == 0 ? "0.0" : Number(handleTableRatio(tableMeta.rowData[26], tableMeta, 26, "Current Ratio")))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `DER`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", height: 43, display: 'grid', alignItems: 'center', backgroundColor: '#07a7d0', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                    <span>{"Financial Covenant"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                    <span>{"Current Testing"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[27]), 2) : Number(tableMeta.rowData[27]) == 0 ? "0.0" : Number(tableMeta.rowData[27])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 27)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(handleTableRatio(tableMeta.rowData[28], tableMeta, 28, "Debt to Equity Ratio")), 2)) : (Number(handleTableRatio(tableMeta.rowData[28], tableMeta, 28, "Debt to Equity Ratio")) == 0 ? "0.0" : Number(handleTableRatio(tableMeta.rowData[28], tableMeta, 28, "Debt to Equity Ratio")))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Debt to EBITDA`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", height: 43, display: 'grid', alignItems: 'center', backgroundColor: '#07a7d0', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                    <span>{"Financial Covenant"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                    <span>{"Current Testing"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[29]), 2) : Number(tableMeta.rowData[29]) == 0 ? "0.0" : Number(tableMeta.rowData[29])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 29)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(handleTableRatio(tableMeta.rowData[30], tableMeta, 30, "Debt to EBITDA - YTD")), 2)) : (Number(handleTableRatio(tableMeta.rowData[30], tableMeta, 30, "Debt to EBITDA - YTD")) == 0 ? "0.0" : Number(handleTableRatio(tableMeta.rowData[30], tableMeta, 30, "Debt to EBITDA - YTD")))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `EBITDA to Interest (ISCR)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", height: 43, display: 'grid', alignItems: 'center', backgroundColor: '#07a7d0', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                    <span>{"Financial Covenant"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 14 : 6 }}>
                                    <span>{"Current Testing"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[31]), 2) : Number(tableMeta.rowData[31]) == 0 ? "0.0" : Number(tableMeta.rowData[31])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 31)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(handleTableRatio(tableMeta.rowData[32], tableMeta, 32, "EBITDA to Interest - YTD")), 2)) : (Number(handleTableRatio(tableMeta.rowData[32], tableMeta, 32, "EBITDA to Interest - YTD")) == 0 ? "0.0" : Number(handleTableRatio(tableMeta.rowData[32], tableMeta, 32, "EBITDA to Interest - YTD")))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Other Ratio 1`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Ratio Name"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Financial Covenant"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Current Testing"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center" style={{ alignItems: 'center' }}>
                                    <div className="col-1">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                // <div style={{ flex: 1 }}>
                                                <div style={{ padding: 0, margin: 0 }}>
                                                    <textarea disabled={this.state.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: 'transparent' }} type="text" defaultValue={tableMeta.rowData[33]}
                                                        onBlur={(event) => handleChange(event.target.value, tableMeta, 33)} />
                                                </div>
                                                // <ThemeProvider theme={this.state.get_for == 'view'? theme3 : theme}>
                                                //     <Input
                                                //         disableUnderline={true}
                                                //         style={{ color: this.state.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //         type="text"
                                                //         placeholder=""
                                                //         disabled={this.state.get_for == 'view'}
                                                //         defaultValue={tableMeta.rowData[33]}
                                                //         multiline={true}
                                                //         onBlur={(event) => {
                                                //             // // // console.log(event.target.value)
                                                //             // updateValue(event.target.value)
                                                //             handleChange(event.target.value, tableMeta, 33)
                                                //             // // // console.log(dataTable2)
                                                //         }}
                                                //     />
                                                // </ThemeProvider>
                                                // </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[34]), 2) : Number(tableMeta.rowData[34]) == 0 ? "0.0" : Number(tableMeta.rowData[34])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 34)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[35]), 2) : Number(tableMeta.rowData[35]) == 0 ? "0.0" : Number(tableMeta.rowData[35])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 35)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Other Ratio 2`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Ratio Name"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Financial Covenant"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Current Testing"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center" style={{ alignItems: 'center' }}>
                                    <div className="col-1">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ padding: 0, margin: 0 }}>
                                                    <textarea disabled={this.state.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: 'transparent' }} type="text" defaultValue={tableMeta.rowData[36]}
                                                        onBlur={(event) => handleChange(event.target.value, tableMeta, 36)} />
                                                </div>
                                                // <div style={{ flex: 1 }}>
                                                // <ThemeProvider theme={this.state.get_for == 'view'? theme3 : theme}>
                                                //     <Input
                                                //         disableUnderline={true}
                                                //         style={{ color: this.state.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //         type="text"
                                                //         placeholder=""
                                                //         disabled={this.state.get_for == 'view'}
                                                //         defaultValue={tableMeta.rowData[36]}
                                                //         multiline={true}
                                                //         onBlur={(event) => {
                                                //             // // // console.log(event.target.value)
                                                //             // updateValue(event.target.value)
                                                //             handleChange(event.target.value, tableMeta, 36)
                                                //             // // // console.log(dataTable2)
                                                //         }}
                                                //     />
                                                // </ThemeProvider>
                                                // </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[37]), 2) : Number(tableMeta.rowData[37]) == 0 ? "0.0" : Number(tableMeta.rowData[37])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 37)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[38]), 2) : Number(tableMeta.rowData[38]) == 0 ? "0.0" : Number(tableMeta.rowData[38])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 38)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Other Ratio 3`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Ratio Name"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Financial Covenant"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Current Testing"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center" style={{ alignItems: 'center' }}>
                                    <div className="col-1">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ padding: 0, margin: 0 }}>
                                                    <textarea disabled={this.state.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: 'transparent' }} type="text" defaultValue={tableMeta.rowData[39]}
                                                        onBlur={(event) => handleChange(event.target.value, tableMeta, 39)} />
                                                </div>
                                                // <div style={{ flex: 1 }}>
                                                // <ThemeProvider theme={this.state.get_for == 'view'? theme3 : theme}>
                                                //     <Input
                                                //         disableUnderline={true}
                                                //         style={{ color: this.state.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //         type="text"
                                                //         placeholder=""
                                                //         disabled={this.state.get_for == 'view'}
                                                //         multiline={true}
                                                //         defaultValue={tableMeta.rowData[39]}
                                                //         onBlur={(event) => {
                                                //             // // // console.log(event.target.value)
                                                //             // updateValue(event.target.value)
                                                //             handleChange(event.target.value, tableMeta, 39)
                                                //             // // // console.log(dataTable2)
                                                //         }}
                                                //     />
                                                // </ThemeProvider>
                                                // </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[40]), 2) : Number(tableMeta.rowData[40]) == 0 ? "0.0" : Number(tableMeta.rowData[40])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 40)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[41]), 2) : Number(tableMeta.rowData[41]) == 0 ? "0.0" : Number(tableMeta.rowData[41])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 41)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Other Ratio 4`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 43, fontSize: 12, fontWeight: 'bold', padding: 5, textAlign: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Ratio Name"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Financial Covenant"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0', height: 43, display: 'grid', alignItems: 'center', padding: dataTable2.length == 0 ? 13 : 5, paddingBottom: dataTable2.length == 0 ? 48 : 5 }}>
                                    <span>{"Current Testing"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center" style={{ alignItems: 'center' }}>
                                    <div className="col-1">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ padding: 0, margin: 0 }}>
                                                    <textarea disabled={this.state.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: 'transparent' }} type="text" defaultValue={tableMeta.rowData[42]}
                                                        onBlur={(event) => handleChange(event.target.value, tableMeta, 42)} />
                                                </div>
                                                // <div style={{ flex: 1 }}>
                                                // <ThemeProvider theme={this.state.get_for == 'view'? theme3 : theme}>
                                                //     <Input
                                                //         disableUnderline={true}
                                                //         style={{ color: this.state.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                //         type="text"
                                                //         placeholder=""
                                                //         disabled={this.state.get_for == 'view'}
                                                //         multiline={true}
                                                //         defaultValue={tableMeta.rowData[42]}
                                                //         onBlur={(event) => {
                                                //             // // // console.log(event.target.value)
                                                //             // updateValue(event.target.value)
                                                //             handleChange(event.target.value, tableMeta, 42)
                                                //             // // // console.log(dataTable2)
                                                //         }}
                                                //     />
                                                // </ThemeProvider>
                                                // </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={this.state.get_for == 'view'}
                                                                fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                                // decimalScale={2}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[43]), 2) : Number(tableMeta.rowData[43]) == 0 ? "0.0" : Number(tableMeta.rowData[43])}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta, 43)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                                null :
                                                // <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={this.state.get_for == 'view'}
                                                            fixedDecimalScale={this.props.defaultCurrency.id == 1 ? true : false}
                                                            // decimalScale={2}
                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[44]), 2) : Number(tableMeta.rowData[44]) == 0 ? "0.0" : Number(tableMeta.rowData[44])}
                                                            onBlur={(event) => {
                                                                handleChange(event.target.value, tableMeta, 44)
                                                            }}
                                                        />
                                                    }
                                                />
                                                // </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "Notes",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, height: 42, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'left', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                    null :
                                    <div style={{ padding: 0, margin: 0 }}>
                                        <textarea disabled={this.state.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.state.get_for == 'view' ? "black" : "#5198ea", backgroundColor: 'transparent' }} type="text" defaultValue={tableMeta.rowData[45]}
                                            onBlur={(event) => handleChange(event.target.value, tableMeta, 45)} />
                                    </div>
                                    // <FormControlLabel
                                    //     style={{ margin: 0 }}
                                    //     control={
                                    //         <ThemeProvider theme={theme}>
                                    //             <Input
                                    //                 disableUnderline={true}
                                    //                 style={{ color: this.state.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 75, backgroundColor: 'transparent' }}
                                    //                 type="text"
                                    //                 placeholder=""
                                    //                 multiline={true}
                                    //                 defaultValue={tableMeta.rowData[45]}
                                    //                 disabled={this.state.get_for == 'view'}
                                    //                 onBlur={(event) => {
                                    //                     handleChange(event.target.value, tableMeta, 45)
                                    //                 }}
                                    //             />
                                    //         </ThemeProvider>
                                    //     }
                                    // />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            },
        ]

        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        const handleClose = (event, reason) => {
            if (reason === 'clickaway') {
                return;
            }

            this.setState({
                snekbar: false,
                snekbarMsg: ''
            })
        };

        return (
            <div>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report</Typography>
                </div>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleLOCFMR ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <Snackbar open={this.state.snekbar} autoHideDuration={3000} onClose={handleClose}>
                                <Alert onClose={handleClose} severity="error">
                                    {this.state.snekbarMsg}
                                </Alert>
                            </Snackbar>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - List Of Credit Facilities</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            {(this.state.get_for == 'edit' &&
                                                <div>
                                                    <a data-tip={'Download Template'} data-for="template">
                                                        <button
                                                            style={{
                                                                backgroundColor: 'transparent',
                                                                cursor: 'pointer',
                                                                borderColor: 'transparent',
                                                                margin: 5
                                                            }}
                                                            onClick={() => this.downloadTemplate()}
                                                        >
                                                            <img src={Images.template} />
                                                        </button>
                                                    </a>
                                                    <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                </div>
                                            )}
                                            {(this.state.get_for == 'edit' &&
                                                <div>
                                                    <a data-tip={'Upload'} data-for="upload">
                                                        <button
                                                            style={{
                                                                backgroundColor: 'transparent',
                                                                cursor: 'pointer',
                                                                borderColor: 'transparent',
                                                                margin: 5
                                                            }}
                                                            onClick={() =>
                                                                this.setState({ visibleUpload: true })
                                                            }
                                                        >
                                                            <img src={Images.upload} />
                                                        </button>
                                                    </a>
                                                    <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                </div>
                                            )}
                                            {/* <a data-tip={'Download'} data-for="download">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => 
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.downloadAllData()
                                                        }, 100);
                                                    })
                                                }
                                            >
                                                <img src={Images.download} />
                                            </button>
                                        </a>
                                        <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                        </div>
                                        {/* } */}
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    {!this.state.loading && <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>}
                                    {this.state.get_for == 'view' && this.state.viewOnly && <div style={{ color: '#000', marginTop: 10, fontSize: 12 }}>(*) There may be discrepancies in amount due to rounding</div>}
                                </div>

                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15, marginTop: 5 }}>
                                    <div>
                                        <div style={{ display: 'flex' }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                            <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                                {
                                                    this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                        return (
                                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                        )
                                                    }) :
                                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                                }
                                            </div>
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Total Outstanding Loan</Typography>
                                        </div>
                                        <div style={{ border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            <Typography style={{ fontSize: '14px', color: '#4b4b4b' }}><NumberFormat value={this.state.perBS} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                        </div>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <div>
                                        <Typography style={{ fontSize: '12px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.state.notes}</Typography>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Diff</Typography>
                                        </div>
                                        <div style={{ borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            <Typography style={{ fontSize: '14px', color: Number(this.state.diff) > 0 ? 'red' : '#4b4b4b' }}><NumberFormat value={this.state.diff} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                        </div>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, fontWeight: 'bold', textDecorationLine: 'underline' }}>Keterangan:</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>1. Current ratio = Current Assets / Current Liabilities</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>2. DER = Interest Bearing Debt / Total Equity (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder)</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>3. Debt to EBITDA = Interest Bearing Debt / EBITDA (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginLeft: 10 }}>& EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>4. EBITDA to Interest (ISCR) = EBITDA / Interest Expenses (dimana EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                                </div>

                                {/* <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15, marginTop: 5}}>
                                <div style={{display: 'flex', flexDirection: 'row'}}>
                                    <div style={{padding: 5}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Total Outstanding Loan</Typography>
                                    </div>
                                    <div style={{border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{formatSeparator(this.state.totalOutStand)}</Typography>
                                    </div>
                                </div>
                            </div>
                            <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15}}>
                                <div style={{display: 'flex', flexDirection: 'row'}}>
                                    <div style={{padding: 5}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Diff</Typography>
                                    </div>
                                    <div style={{borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{formatSeparator(this.state.diff)}</Typography>
                                    </div>
                                </div>
                            </div> */}
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginLeft: 10 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {/* (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}

                                {this.props.isApprover === true ? null :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => this.setState({ totalOutStand: totalLoan, saveTambahan: false }, () => {
                                                this.handleCalculate()
                                            })}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            onClick={() =>
                                                this.state.saveDraft === true || this.state.saveTambahan ?
                                                    this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.backToMonthlyReport('draft')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.saveComp || this.state.saveTambahan ?
                                                    this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete / Diff must be 0' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.backToMonthlyReport('submitted')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 20 }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>}
                                {/* : null } */}
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <Snackbar open={this.state.snekbar} autoHideDuration={6000} onClose={handleClose}>
                                <Alert onClose={handleClose} severity="error">
                                    {this.state.snekbarMsg}
                                </Alert>
                            </Snackbar>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - List Of Credit Facilities</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                    {this.props.defaultCurrency.id === 1 ?
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                        :
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                    }
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    {this.state.dataLoaded && !this.state.loading && <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>}
                                </div>

                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15, marginTop: 5 }}>
                                    <div>
                                        <div style={{ display: 'flex' }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                            <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                                {
                                                    this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                        return (
                                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                        )
                                                    }) :
                                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                                }
                                            </div>
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Total Outstanding Loan</Typography>
                                        </div>
                                        <div style={{ border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            <Typography style={{ fontSize: '14px', color: '#4b4b4b' }}><NumberFormat value={this.state.perBS} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                        </div>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <div>
                                        <Typography style={{ fontSize: '12px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.state.notes}</Typography>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Diff</Typography>
                                        </div>
                                        <div style={{ borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            <Typography style={{ fontSize: '14px', color: Number(this.state.diff) > 0 ? 'red' : '#4b4b4b' }}><NumberFormat value={this.state.diff} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                        </div>
                                    </div>
                                </div>

                                <div style={{ display: 'flex', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, fontWeight: 'bold', textDecorationLine: 'underline' }}>Keterangan:</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>1. Current ratio = Current Assets / Current Liabilities</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>2. DER = Interest Bearing Debt / Total Equity (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder)</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>3. Debt to EBITDA = Interest Bearing Debt / EBITDA (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginLeft: 10 }}>& EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>4. EBITDA to Interest (ISCR) = EBITDA / Interest Expenses (dimana EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                                </div>

                                {/* <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15, marginTop: 5}}>
                                <div style={{display: 'flex', flexDirection: 'row'}}>
                                    <div style={{padding: 5}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Total Outstanding Loan</Typography>
                                    </div>
                                    <div style={{border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{formatSeparator(this.state.totalOutStand)}</Typography>
                                    </div>
                                </div>
                            </div>
                            <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15}}>
                                <div style={{display: 'flex', flexDirection: 'row'}}>
                                    <div style={{padding: 5}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Diff</Typography>
                                    </div>
                                    <div style={{borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{(formatSeparator(this.state.diff))}</Typography>
                                    </div>
                                </div>
                            </div> */}
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => {
                                            this.getBankData()
                                            this.getTypeOfCredit()
                                            this.getSubmission()
                                        }
                                        }
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginLeft: 10 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}
                                <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => this.setState({ totalOutStand: totalLoan, saveTambahan: false }, () => {
                                            this.handleCalculate()
                                        })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>
                                    <button
                                        className="button"
                                        type="button"
                                        onClick={() =>
                                            this.state.saveDraft === true || this.state.saveTambahan ?
                                                this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadLOCF('draft')
                                                        }, 100);
                                                    })
                                        }
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>
                                    <button
                                        type="button"
                                        // disabled={this.state.buttonError}
                                        onClick={() =>
                                            this.state.saveComp || this.state.saveTambahan ?
                                                this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete / Diff must be 0' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadLOCF('submitted')
                                                        }, 100);
                                                    })
                                        }
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 20 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>
                                </div>
                                {/* : null } */}
                            </div>
                        </Paper>}
                </div>

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("LIST") && String(this.state.judul).includes("CREDIT") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") ?
                                            this.checkUpload() :
                                            this.setState({ snekbar: true, snekbarMsg: 'Invalid Template', tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        )
    }

}
