import React, { Component } from 'react';
import { createMuiTheme, MuiThemeProvider } from '@material-ui/core/styles';
import Images from '../../../assets/Images';
import MUIDataTable from "mui-datatables";
import { InputBase, Snackbar, withStyles, Typography, Tooltip } from "@material-ui/core";
import MuiAlert from '@material-ui/lab/Alert';
import CreateParameter from '../Parameter/CreateParameter';
import api from '../../../api';
import PopUpFailedSave from "../../../library/PopUpFailedSave";
import ReactTooltip from 'react-tooltip';
import UploadFile from "../../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import Constant from '../../../library/Constant';
import PopUpDelete from '../../../library/PopUpDelete';
import { css } from "@emotion/core";
import PropagateLoader from "react-spinners/PropagateLoader"

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());
const options = ct.customOptions();
const options2 = ct.customOptions2();

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class Parameter extends Component {
    constructor(props) {
        super(props)
        this.state = {
            visibleCreate: false,
            visibleEdit: false,
            visibleParameter: true,
            popupError: false,
            data: [],
            dataTable: [],
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            create: false,
            edit: false,
            delete: false,
            load: false,
            judul: '',
            loading: false,
            sizeUpload: "1"
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getAllParameter()
        this.getPermission()
        this.getSizeUpload()
    }

    getSizeUpload() {
        let body = {
            group: 'MAX_FILE_SIZE',
            company_id: 0,
            type: 'MAX_FILE_SIZE'
        }
        api.create().getAllSettingByType(body).then(response => {
            // console.log(response.data.data[0]);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        sizeUpload: response.data.data[0] ? response.data.data[0].value === undefined ? "1" : response.data.data[0].value : "1"
                    })
                }
            }
        })
    }

    getPermission() {
        let payload = {
            menu: "parameters"
        }
        api.create().getPermission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        create: response.data.data.create,
                        edit: response.data.data.edit,
                        delete: response.data.data.delete,
                        load: true
                    })
                } else {
                    this.setState({ load: true })
                }
            }
        })
    }

    getAllParameter() {
        this.setState({ loading: true })
        api.create().getAllParameter().then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        console.log(response);
                        let data = response.data.data
                        let listData = data.map((item, index) => {
                            return [
                                item.setting_id,
                                item.setting_id,
                                item.setting_group,
                                item.setting_type,
                                item.company_name,
                                item.description,
                                item.order,
                                item.setting_group === "CURRENCY" ? Number(item.value) * 1000 : item.value, // convert IDR mn to IDR
                                item.min_value,
                                item.max_value,
                                item.status
                            ]
                        })
                        this.setState({ dataTable: listData, data: response.data.data }, () => {
                            setTimeout(() => {
                                this.setState({ loading: false })
                            }, 2000);
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    openPopUp(rowData, type) {
        if (type === 'edit') {
            this.setState({
                rowData: rowData,
                visibleEdit: true
            })
        } else if (type === 'delete') {
            this.setState({
                rowData: rowData,
                visibleDelete: true
            })
        } else {
            this.setState({
                rowData: rowData,
                visibleCreate: true
            })
        }
    }

    updateParameter = (payload) => {
        this.setState({ visibleEdit: false })
        api.create().updateParameter(payload).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getAllParameter()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    createParameter = (payload) => {
        this.setState({ visibleCreate: false })
        api.create().createParameter(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getAllParameter()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    downloadFile = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/attachment/download_file?fileName=ParameterTemplate&&fileType=xlsx`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Parameter.xlsx';
            a.click();
        }
    }

    downloadDataTable = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/setting/export_setting`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Parameter.xlsx';
            a.click();
        }
    }

    handleInputChange(e) {
        this.setState({ search: e })
        let body = {
            "keyword": e
        }
        api.create().searchParameter(body).then(response => {
            // console.log(response.data);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.map((item, index) => {
                            return [
                                item.setting_id,
                                item.setting_id,
                                item.setting_group,
                                item.setting_type,
                                item.company_name,
                                item.description,
                                item.order,
                                item.value,
                                item.min_value,
                                item.max_value,
                                item.status
                            ]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                // let judul = resp.rows[2]
                let isi = resp.rows.slice(3)
                console.log(isi);
                let payload = []
                isi.map((item, index) => {
                    if (item.length > 0) {
                        payload.push({
                            id: index + 1,
                            group: item[0] === undefined ? "" : item[0],
                            parameter: item[1] === undefined ? "" : item[1],
                            company: item[2] === undefined ? "" : item[2],
                            reference: item[3] === undefined ? "" : item[3],
                            description: item[4] === undefined ? "" : item[4],
                            orders: item[5] === undefined ? "" : item[5],
                            value: item[6] === undefined ? "" : item[6],
                            min_value: item[7] === undefined ? "" : item[7],
                            max_value: item[8] === undefined ? "" : item[8],
                            start_date: item[9] === undefined ? "" : item[9],
                            end_date: item[10] === undefined ? "" : item[10],
                        })
                    }
                })
                let body = {
                    setting: payload
                }
                console.log(body);
                // console.log(resp.rows[1]);
                this.setState({ payload: body, buttonError: false, judul: resp.rows[1] === undefined ? "" : resp.rows[1][0] })
            }
        });
    }

    checkUpload() {
        api.create().checkUploadParameter(this.state.payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        let dataRow = response.data.data.map((item, index) => {
                            return [
                                index + 1,
                                item.group,
                                item.parameter,
                                item.company,
                                item.reference,
                                item.description,
                                item.orders,
                                item.value,
                                item.min_value,
                                item.max_value,
                                item.start_date,
                                item.end_date,
                                item.error,
                            ]
                        })
                        let columns = [
                            "Data",
                            {
                                name: "Group",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        console.log(tableMeta);
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('group'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Parameter",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('parameter'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Company",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('company'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Type Report",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('type_report'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Description",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('description'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Order",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('order'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Value",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('value'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Min Value",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('min_value'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Max Value",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('max_value'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid To",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('start_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid From",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[12] != null) {
                                            check = tableMeta.rowData[12].findIndex((val) => val.field.includes('end_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[12] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[12][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "",
                                options: {
                                    display: false
                                }
                            }
                        ]

                        // console.log(dataRow);
                        this.setState({
                            dataLoaded: true,
                            cols: columns,
                            rows: dataRow,
                            visibleUpload: false,
                            visibleParameter: false
                        });
                    } else {
                        this.setState({ dataLoaded: true, cols: [], rows: [], alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({
                        alert: true, messageAlert: response.data.message, tipeAlert: 'error',
                        dataLoaded: true,
                        cols: [],
                        rows: []
                    });
                }
            } else {
                this.setState({
                    alert: true, messageAlert: response.problem, tipeAlert: 'error',
                    dataLoaded: true,
                    cols: [],
                    rows: []
                });
            }

        })
    }

    uploadParameter() {
        let payload = this.state.payload
        let arr = []
        for (let index = 0; index < payload.setting.length; index++) {
            let item = payload.setting[index]
            arr.push({
                ...item,
                value: item?.group === 'CURRENCY' ? Number(item?.value)/1000 : item?.value
            })
        }
        payload = {
            setting: arr
        }
        api.create().uploadParameter(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.getAllParameter()
                        this.setState({ visibleParameter: true, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    deleteParameter(payload) {
        let id = String(payload[1])
        api.create().deleteParameter(id).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.getAllParameter()
                        this.setState({ visibleDelete: false, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    render() {
        const columns = [{
            name: "Action",
            options: {
                sort: false,
                filter: false,
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            {this.state.edit &&
                                <span>
                                    <a data-tip={'Edit'} data-for="edit">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                marginRight: 15
                                            }}
                                            // onClick={() => console.log(tableMeta)}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'edit')}
                                        >
                                            <img src={Images.editCopy} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="edit" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                            {this.state.delete &&
                                <span>
                                    <a data-tip={'Delete'} data-for="delete">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                            }}
                                            // onClick={() => console.log(tableMeta)}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'delete')}
                                        >
                                            <img src={Images.delete} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="delete" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                        </div >

                    );
                }
            }
        }, {
            name: "ID",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Group",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Parameter",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Company",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Description",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Order",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Value",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Min Value",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Max Value",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Status",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[10] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }]
        const data = [
            ["", "LAPORAN_BULANAN", "BALANCE_SHEET", "Default", "Range Periode Lap", "1", "-", "1", "10", "Aktif"],
            ["", "LAPORAN_BULANAN", "BALANCE_SHEET", "Puninar Group", "Range Periode Lap", "2", "-", "1", "15", "Aktif"],
            ["", "LAPORAN_BULANAN", "BALANCE_SHEET", "TAP Group", "Range Periode Lap", "3", "-", "1", "15", "Aktif"],
            ["", "LAPORAN_BULANAN", "BALANCE_SHEET", "Daya Group", "Range Periode Lap", "4", "-", "1", "20", "Non Aktif"],
            ["", "-", "-", "-", "-", "-"]
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );
        return (
            <div style={{ height: this.props.height }}>
                {/* <Row> */}
                <div className={"main-color"} style={{ height: 195, width: '100%' }} />
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {this.state.visibleParameter === true ?
                    <div>
                        {this.state.load && (
                            <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -182 }}>
                                <label style={{ color: 'white', fontSize: 16, alignSelf: 'center', width: '40%', }}>Parameter</label>
                                {/* <div style={{ color: 'white', width: '50%', height: 37, display: 'flex', backgroundColor: 'white', borderWidth: 2, alignItems: 'center', borderRadius: 6, paddingLeft: 5, paddingRight: 5, alignSelf: 'center' }}>
                                    <img src={Images.searchBlack} style={{ marginRight: 10 }} />
                                    <InputBase
                                        style={{ width: '100%' }}
                                        placeholder="Search"
                                        value={this.state.search}
                                        onChange={(e) => this.handleInputChange(e.target.value)}
                                        inputProps={{ 'aria-label': 'naked' }}
                                    />
                                </div> */}
                                <div style={{ width: '40%', justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                    <a data-tip={'Download Template'} data-for="template">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadFile()}
                                        >
                                            <img src={Images.template} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                    {this.state.create && (
                                        <a data-tip={'Upload'} data-for="upload">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => this.setState({ visibleUpload: true })}
                                            >
                                                <img src={Images.upload} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                    <a data-tip={'Download'} data-for="download">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadDataTable()}
                                        >
                                            <img src={Images.download} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                    {this.state.create && (
                                        <a data-tip={'Add New'} data-for="create">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5,
                                                    marginRight: 20
                                                }}
                                                onClick={() => this.setState({ visibleCreate: true })}
                                            >
                                                <img src={Images.add} />
                                            </button>
                                        </a>
                                    )}

                                    <ReactTooltip multiline={false} border={true} id="create" place="bottom" type="light" effect="solid" />
                                </div>
                            </div>

                        )}
                        <div style={{ padding: 25 }}>
                            {this.state.loading && loadingComponent}
                            <MuiThemeProvider theme={getMuiTheme()}>
                                <MUIDataTable
                                    theme={getMuiTheme()}
                                    data={this.state.dataTable}
                                    columns={columns}
                                    options={options}
                                />
                            </MuiThemeProvider>

                        </div>
                    </div>
                    :
                    <div>
                        <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -150 }}>
                            <label style={{ color: 'white', fontSize: 16, alignSelf: 'center' }}>Preview Data</label>
                        </div>
                        <div style={{ padding: 25 }}>
                            {this.state.dataLoaded && (
                                <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        theme={getMuiTheme()}
                                        data={this.state.rows}
                                        columns={this.state.cols}
                                        options={options2}
                                    />
                                </MuiThemeProvider>
                            )}
                        </div>
                        <div style={{ display: 'flex', width: '100%', placeContent: 'flex-end', padding: 20 }}>
                            <button
                                type="button"
                                onClick={() => this.setState({ visibleParameter: true, judul: "" })}
                                style={{ marginRight: 20 }}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                            <button
                                type="button"
                                disabled={this.state.buttonError ? true : false}
                                onClick={() => this.uploadParameter()}
                                style={{}}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                }
                {this.state.visibleCreate && (
                    <CreateParameter
                        onClickClose={() => this.setState({ visibleCreate: false })}
                        createParameter={this.createParameter.bind(this)}
                    />
                )}

                {this.state.visibleEdit && (
                    <CreateParameter
                        type={"edit"}
                        onClickClose={() => this.setState({ visibleEdit: false })}
                        data={this.state.rowData}
                        updateParameter={this.updateParameter.bind(this)}
                    />
                )}
                {this.state.popupError && (
                    <PopUpFailedSave onClickClose={() => this.setState({ popupError: false })} />
                )}
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                sizeUpload={Number(this.state.sizeUpload)}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => {
                                    String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("DATA") && String(this.state.judul).includes("PARAMETER") ?
                                        this.checkUpload() :
                                        this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                }}
                            />
                        </div>
                    </div>
                )}

                {this.state.visibleDelete && (
                    <PopUpDelete
                        rowData={this.state.rowData}
                        intent={'parameter'}
                        onClickClose={() => this.setState({ visibleDelete: false })}
                        onClickDelete={this.deleteParameter.bind(this)}
                    />
                )}

            </div>
        );
    }
}