import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, MuiThemeProvider, TableCell, FormControlLabel, TextField, Input, Tooltip, withStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import api from '../../api';
import AddIcon from '@material-ui/icons/Add';
import { values } from 'ramda';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { Alert, Autocomplete } from '@material-ui/lab';
import * as R from 'ramda';
import Constant from '../../library/Constant';
import { fixNumber } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class TaxPlanning extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            visibleTP: true,
            disabledSave: true,
            editable: false,
            buttonError: false,
            judulColumn: null,
            updateBy: [],
            buttonDraft: true,
            handleDoubleClick: 0,
            saveDraft: true,
            minValue: "0.0",
            maxValue: "0.0",
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,

        }
        this.handleValue = this.handleValue.bind(this)
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getLatestUpdate()
        this.getSettingControl()
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_CONTROL',
            company_id: this.props.company.company_id,
            type: 'TAX_PLANNING',
            currency_id: this.props.defaultCurrency.id,
        }

        api.create().getAllSettingByType(body).then(response => {
            // console.log(response);
            this.setState({
                minValue: response.data.data[0] ? response.data.data[0].min_value : null,
                maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
            }, () => {
                this.getItemHierarki()
            })
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
        }
        api.create().getLastestUpdateMB(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        this.setState({ loading: true, judulColumn: null })
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            "currency_id": this.props.defaultCurrency.id
        }
        api.create().getDetailReportMB(payload).then(response => {
            console.log(response);
            let dataTable = []
            if (response.data) {
                if (response.data.status == 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.type_report_tax.value_tbc.type_report_id,
                                item.type_report_tax.value_fc.type_report_id,
                                item.type_report_tax.value_tbf.type_report_id,
                                item.id,
                                item.parent,
                                { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                                item.level,
                                item.description,
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.january?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.january === null ? "0.0" : item.tax_planning.january.tbc, formula: item.tax_planning.january_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.january?.tbc,
                                    fcp: item.tax_planning.january === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.january?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.january?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.january === null ? "0.0" : item.tax_planning.january.tbc, formula: item.tax_planning.january_formula } : item.tax_planning.january?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.january?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.january?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.january === null ? "0.0" : item.tax_planning.january.tbc, formula: item.tax_planning.january_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.january?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.february?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.february === null ? "0.0" : item.tax_planning.february?.tbc, formula: item.tax_planning.february_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.february?.tbc,
                                    fcp: item.tax_planning.february === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.february?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.february?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.february?.fcp, formula: item.tax_planning.february_formula } : item.tax_planning.february?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.february?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.february?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.february === null ? "0.0" : item.tax_planning.february.tbc, formula: item.tax_planning.february_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.february?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.march?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.march === null ? "0.0" : item.tax_planning.march?.tbc, formula: item.tax_planning.march_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.march?.tbc,
                                    fcp: item.tax_planning.march === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.march?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.march?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.march?.fcp, formula: item.tax_planning.march_formula } : item.tax_planning.march?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.march?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.march?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.march === null ? "0.0" : item.tax_planning.march?.tbf, formula: item.tax_planning.march_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.march?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.april?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.april === null ? "0.0" : item.tax_planning.april?.tbc, formula: item.tax_planning.april_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.april?.tbc,
                                    fcp: item.tax_planning.april === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.april?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.april?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.april?.fcp, formula: item.tax_planning.april_formula } : item.tax_planning.april?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.april?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.april?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.april === null ? "0.0" : item.tax_planning.april?.tbf, formula: item.tax_planning.april_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.april?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.may?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.may === null ? "0.0" : item.tax_planning.may?.tbc, formula: item.tax_planning.may_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.may?.tbc,
                                    fcp: item.tax_planning.may === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.may?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.may?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.may?.fcp, formula: item.tax_planning.may_formula } : item.tax_planning.may?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.may?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.may?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.may === null ? "0.0" : item.tax_planning.may?.tbf, formula: item.tax_planning.may_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.may?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.june?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.june === null ? "0.0" : item.tax_planning.june?.tbc, formula: item.tax_planning.june_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.june?.tbc,
                                    fcp: item.tax_planning.june === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.june?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.june?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.june?.fcp, formula: item.tax_planning.june_formula } : item.tax_planning.june?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.june?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.june?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.june === null ? "0.0" : item.tax_planning.june?.tbf, formula: item.tax_planning.june_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.june?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.july?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.july === null ? "0.0" : item.tax_planning.july?.tbc, formula: item.tax_planning.july_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.july?.tbc,
                                    fcp: item.tax_planning.july === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.july?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.july?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.july?.fcp, formula: item.tax_planning.july_formula } : item.tax_planning.july?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.july?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.july?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.july === null ? "0.0" : item.tax_planning.july?.tbf, formula: item.tax_planning.july_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.july?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.august?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.august === null ? "0.0" : item.tax_planning.august?.tbc, formula: item.tax_planning.august_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.august?.tbc === null ? "0.0" : item.tax_planning.august?.tbc === "" ? "0.0" : item.tax_planning.august?.tbc,
                                    fcp: item.tax_planning.august === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.august?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.august?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.august?.fcp, formula: item.tax_planning.august_formula } : item.tax_planning.august?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.august?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.august?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.august === null ? "0.0" : item.tax_planning.august?.tbf, formula: item.tax_planning.august_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.august?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.september?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.september === null ? "0.0" : item.tax_planning.september?.tbc, formula: item.tax_planning.september_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.september?.tbc,
                                    fcp: item.tax_planning.september === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.september?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.september?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.september?.fcp, formula: item.tax_planning.september_formula } : item.tax_planning.september?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.september?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.september?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.september === null ? "0.0" : item.tax_planning.september?.tbf, formula: item.tax_planning.september_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.september?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.october?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.october === null ? "0.0" : item.tax_planning.october?.tbc, formula: item.tax_planning.october_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.october?.tbc,
                                    fcp: item.tax_planning.october === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.october?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.october?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.october?.fcp, formula: item.tax_planning.october_formula } : item.tax_planning.october?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.october?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.october?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.october === null ? "0.0" : item.tax_planning.october?.tbf, formula: item.tax_planning.october_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.october?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.november?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november === null ? "0.0" : item.tax_planning.november?.tbc, formula: item.tax_planning.november_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.november?.tbc,
                                    fcp: item.tax_planning.november === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.november?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.november?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.november?.fcp, formula: item.tax_planning.november_formula } : item.tax_planning.november?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.november?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.november?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.november === null ? "0.0" : item.tax_planning.november?.tbf, formula: item.tax_planning.november_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.november?.tbf
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.december?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december === null ? "0.0" : item.tax_planning.december?.tbc, formula: item.tax_planning.december_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.december?.tbc,
                                    fcp: item.tax_planning.december === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.december?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.december?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.december?.fcp, formula: item.tax_planning.december_formula } : item.tax_planning.december?.fcp,
                                    tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.december?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.december?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.december === null ? "0.0" : item.tax_planning.december?.tbf, formula: item.tax_planning.december_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? "0.0" : item.tax_planning.december?.tbf
                                },
                                item.type_report_tax.value_tbf.type_report_id == 3 ? fixNumber(Number(item.tax_planning.total_current_year), 12) : fixNumber(Number(item.tax_planning.total_current_year), 1),
                                // { tbc: item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.total_next_year.tbc } : item.tax_planning.total_next_year.tbc, fcp: item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.total_next_year.fcp } : item.tax_planning.total_next_year.fcp, tbf: item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.total_next_year.tbf } : item.tax_planning.total_next_year.tbf },
                                {
                                    tbc: item.tax_planning.total_next_year === null ? '0.0' : item.tax_planning.total_next_year.tbc,
                                    fcp: item.tax_planning.total_next_year === null ? '0.0' : item.tax_planning.total_next_year.fcp,
                                    tbf: item.tax_planning.total_next_year === null ? '0.0' : item.tax_planning.total_next_year.tbf
                                },
                                {
                                    tbc: item.tax_planning.total_more_year === null ? '0.0' : item.tax_planning.total_more_year.tbc,
                                    fcp: item.tax_planning.total_more_year === null ? '0.0' : item.tax_planning.total_more_year.fcp,
                                    tbf: item.tax_planning.total_more_year === null ? '0.0' : item.tax_planning.total_more_year.tbf
                                },
                                item.order,
                                { tbc: item.condition_it_should_be_tax.value_tbc, fcp: item.condition_it_should_be_tax.value_fc, tbf: item.condition_it_should_be_tax.value_tbf },
                                { tbc: item.condition_if_wrong_tax.value_tbc, fcp: item.condition_if_wrong_tax.value_fc, tbf: item.condition_if_wrong_tax.value_tbf },
                                item.tax_planning.forecast_tbc_formula,
                                item.tax_planning.forecast_fcp_formula,
                                item.tax_planning.forecast_tbf_formula,
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    console.log()
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.type_report_tax.value_tbc.type_report_id,
                            item.type_report_tax.value_fc.type_report_id,
                            item.type_report_tax.value_tbf.type_report_id,
                            item.id,
                            item.parent,
                            { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                            item.level,
                            item.description,
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.january?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.january === null ? "0.0" : item.tax_planning.january.tbc, formula: item.tax_planning.january_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.january?.tbc,
                                fcp: item.tax_planning.january === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.january?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.january?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.january === null ? "0.0" : item.tax_planning.january.tbc, formula: item.tax_planning.january_formula } : item.tax_planning.january?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.january?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.january?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.january === null ? "0.0" : item.tax_planning.january.tbc, formula: item.tax_planning.january_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.january?.tbf : item.tax_planning.january?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.february?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.february === null ? "0.0" : item.tax_planning.february?.tbc, formula: item.tax_planning.february_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.february?.tbc,
                                fcp: item.tax_planning.february === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.february?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.february?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.february?.fcp, formula: item.tax_planning.february_formula } : item.tax_planning.february?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.february?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.february?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.february === null ? "0.0" : item.tax_planning.february.tbc, formula: item.tax_planning.february_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.february?.tbf : item.tax_planning.february?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.march?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.march === null ? "0.0" : item.tax_planning.march?.tbc, formula: item.tax_planning.march_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.march?.tbc,
                                fcp: item.tax_planning.march === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.march?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.march?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.march?.fcp, formula: item.tax_planning.march_formula } : item.tax_planning.march?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.march?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.march?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.march === null ? "0.0" : item.tax_planning.march?.tbf, formula: item.tax_planning.march_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.march?.tbf : item.tax_planning.march?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.april?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.april === null ? "0.0" : item.tax_planning.april?.tbc, formula: item.tax_planning.april_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.april?.tbc,
                                fcp: item.tax_planning.april === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.april?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.april?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.april?.fcp, formula: item.tax_planning.april_formula } : item.tax_planning.april?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.april?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.april?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.april === null ? "0.0" : item.tax_planning.april?.tbf, formula: item.tax_planning.april_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.april?.tbf : item.tax_planning.april?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.may?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.may === null ? "0.0" : item.tax_planning.may?.tbc, formula: item.tax_planning.may_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.may?.tbc,
                                fcp: item.tax_planning.may === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.may?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.may?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.may?.fcp, formula: item.tax_planning.may_formula } : item.tax_planning.may?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.may?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.may?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.may === null ? "0.0" : item.tax_planning.may?.tbf, formula: item.tax_planning.may_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.may?.tbf : item.tax_planning.may?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.june?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.june === null ? "0.0" : item.tax_planning.june?.tbc, formula: item.tax_planning.june_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.june?.tbc,
                                fcp: item.tax_planning.june === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.june?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.june?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.june?.fcp, formula: item.tax_planning.june_formula } : item.tax_planning.june?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.june?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.june?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.june === null ? "0.0" : item.tax_planning.june?.tbf, formula: item.tax_planning.june_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.june?.tbf : item.tax_planning.june?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.july?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.july === null ? "0.0" : item.tax_planning.july?.tbc, formula: item.tax_planning.july_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.july?.tbc,
                                fcp: item.tax_planning.july === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.july?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.july?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.july?.fcp, formula: item.tax_planning.july_formula } : item.tax_planning.july?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.july?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.july?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.july === null ? "0.0" : item.tax_planning.july?.tbf, formula: item.tax_planning.july_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.july?.tbf : item.tax_planning.july?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.august?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.august === null ? "0.0" : item.tax_planning.august?.tbc, formula: item.tax_planning.august_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.august?.tbc === null ? "0.0" : item.tax_planning.august?.tbc === "" ? "0.0" : item.tax_planning.august?.tbc,
                                fcp: item.tax_planning.august === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.august?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.august?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.august?.fcp, formula: item.tax_planning.august_formula } : item.tax_planning.august?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.august?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.august?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.august === null ? "0.0" : item.tax_planning.august?.tbf, formula: item.tax_planning.august_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.august?.tbf : item.tax_planning.august?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.september?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.september === null ? "0.0" : item.tax_planning.september?.tbc, formula: item.tax_planning.september_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.september?.tbc,
                                fcp: item.tax_planning.september === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.september?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.september?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.september?.fcp, formula: item.tax_planning.september_formula } : item.tax_planning.september?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.september?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.september?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.september === null ? "0.0" : item.tax_planning.september?.tbf, formula: item.tax_planning.september_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.september?.tbf : item.tax_planning.september?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.october?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.october === null ? "0.0" : item.tax_planning.october?.tbc, formula: item.tax_planning.october_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.october?.tbc,
                                fcp: item.tax_planning.october === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.october?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.october?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.october?.fcp, formula: item.tax_planning.october_formula } : item.tax_planning.october?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.october?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.october?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.october === null ? "0.0" : item.tax_planning.october?.tbf, formula: item.tax_planning.october_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.october?.tbf : item.tax_planning.october?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.november?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november === null ? "0.0" : item.tax_planning.november?.tbc, formula: item.tax_planning.november_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.november?.tbc,
                                fcp: item.tax_planning.november === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.november?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.november?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.november?.fcp, formula: item.tax_planning.november_formula } : item.tax_planning.november?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.november?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.november?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.november === null ? "0.0" : item.tax_planning.november?.tbf, formula: item.tax_planning.november_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? item.tax_planning.november?.tbf : item.tax_planning.november?.tbf
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.december?.tbc), 1) : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december === null ? "0.0" : item.tax_planning.december?.tbc, formula: item.tax_planning.december_formula } : item.type_report_tax.value_tbc.type_report_id == 1 || item.type_report_tax.value_tbc.type_report_id == 2 || item.type_report_tax.value_tbc.type_report_id == 3 || item.type_report_tax.value_tbc.type_report_id == 4 ? "0.0" : item.tax_planning.december?.tbc,
                                fcp: item.tax_planning.december === null ? '0.0' : this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.december?.fcp), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.december?.fcp), 1) : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.december?.fcp, formula: item.tax_planning.december_formula } : item.tax_planning.december?.fcp,
                                tbf: this.props.status === 'CLOSED' && String(item.description).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(item.tax_planning.december?.tbf), 2) : this.props.status === 'CLOSED' ? fixNumber(Number(item.tax_planning.december?.tbf), 1) : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.december === null ? "0.0" : item.tax_planning.december?.tbf, formula: item.tax_planning.december_formula } : item.type_report_tax.value_tbf.type_report_id == 1 || item.type_report_tax.value_tbf.type_report_id == 2 || item.type_report_tax.value_tbf.type_report_id == 3 || item.type_report_tax.value_tbf.type_report_id == 4 ? Number(item.tax_planning.december?.tbf) : Number(item.tax_planning.december?.tbf)
                            },
                            item.type_report_tax.value_tbf.type_report_id == 3 ? fixNumber(Number(item.tax_planning.total_current_year), 12) : fixNumber(Number(item.tax_planning.total_current_year), 1),
                            // { tbc: item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.total_next_year.tbc } : item.tax_planning.total_next_year.tbc, fcp: item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.total_next_year.fcp } : item.tax_planning.total_next_year.fcp, tbf: item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.total_next_year.tbf } : item.tax_planning.total_next_year.tbf },
                            {
                                tbc: item.tax_planning.total_next_year === null ? '0.0' : item.tax_planning.total_next_year.tbc,
                                fcp: item.tax_planning.total_next_year === null ? '0.0' : item.tax_planning.total_next_year.fcp,
                                tbf: item.tax_planning.total_next_year === null ? '0.0' : item.tax_planning.total_next_year.tbf
                            },
                            {
                                tbc: item.tax_planning.total_more_year === null ? '0.0' : item.tax_planning.total_more_year.tbc,
                                fcp: item.tax_planning.total_more_year === null ? '0.0' : item.tax_planning.total_more_year.fcp,
                                tbf: item.tax_planning.total_more_year === null ? '0.0' : item.tax_planning.total_more_year.tbf
                            },
                            item.order,
                            { tbc: item.condition_it_should_be_tax.value_tbc, fcp: item.condition_it_should_be_tax.value_fc, tbf: item.condition_it_should_be_tax.value_tbf },
                            { tbc: item.condition_if_wrong_tax.value_tbc, fcp: item.condition_if_wrong_tax.value_fc, tbf: item.condition_if_wrong_tax.value_tbf },
                            item.tax_planning.forecast_tbc_formula,
                            item.tax_planning.forecast_fcp_formula,
                            item.tax_planning.forecast_tbf_formula
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    console.log(dataTable)
                    this.setState({ dataTable, loading: false, buttonError: true, editable: true })
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ dataTable, loading: false, buttonError: true, editable: true, alert: true, messageAlert: 'Connection Timeout, please check your Connection', tipeAlert: 'error' })
            }
        })
    }

    handleValue(data) {
        let total = 0
        this.state.dataTable.map((item, index) => {
            if (data.rowData[4] == item[5]) {
                total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
            }
        })
        let indexParent = this.state.dataTable.findIndex((val) => val[4] === this.state.dataTable[data.rowIndex][5])
        let a = this.state.dataTable[data.rowIndex][data.columnIndex] = total
        // console.log(indexParent);
        return a
    }

    handleChange(value, tableMeta) {
        let val = String(value).split(",").join("")
        let data = this.state.dataTable
        let indexParent = data.findIndex((val) => val[4] === data[tableMeta.rowIndex][5])
        if (indexParent > 0) {
            // console.log(indexParent)
            let a = data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            let jagain = data[indexParent][tableMeta.columnIndex]
            a = data[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
        } else {
            data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
        // this.forceUpdate()
        // console.log(this.state.dataTable)
        // this.setState({
        //     data: a,
        // }, () => console.log(this.state.dataTable))
    }

    backToMasterBudget(type) {
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbc: i[1] === 3 && i[9].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[9].tbc.value) : String(i[9].tbc),
                        fcp: i[2] === 3 && i[9].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[9].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].fcp)) : String(Number(i[9].fcp)),
                        tbf: i[3] === 3 && i[9].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[9].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].tbf)) : String(Number(i[9].tbf))
                    },
                    february: {
                        tbc: i[1] === 3 && i[10].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[10].tbc.value) : String(i[10].tbc),
                        fcp: i[2] === 3 && i[10].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[10].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10].fcp)) : String(Number(i[10].fcp)),
                        tbf: i[3] === 3 && i[10].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[10].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10].tbf)) : String(Number(i[10].tbf))
                    },
                    march: {
                        tbc: i[1] === 3 && i[11].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[11].tbc.value) : String(i[11].tbc),
                        fcp: i[2] === 3 && i[11].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[11].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11].fcp)) : String(Number(i[11].fcp)),
                        tbf: i[3] === 3 && i[11].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[11].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11].tbf)) : String(Number(i[11].tbf))
                    },
                    april: {
                        tbc: i[1] === 3 && i[12].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[12].tbc.value) : String(i[12].tbc),
                        fcp: i[2] === 3 && i[12].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[12].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[12].fcp)) : String(Number(i[12].fcp)),
                        tbf: i[3] === 3 && i[12].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[12].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[12].tbf)) : String(Number(i[12].tbf))
                    },
                    may: {
                        tbc: i[1] === 3 && i[13].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[13].tbc.value) : String(i[13].tbc),
                        fcp: i[2] === 3 && i[13].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[13].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[13].fcp)) : String(Number(i[13].fcp)),
                        tbf: i[3] === 3 && i[13].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[13].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[13].tbf)) : String(Number(i[13].tbf))
                    },
                    june: {
                        tbc: i[1] === 3 && i[14].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[14].tbc.value) : String(i[14].tbc),
                        fcp: i[2] === 3 && i[14].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[14].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[14].fcp)) : String(Number(i[14].fcp)),
                        tbf: i[3] === 3 && i[14].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[14].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[14].tbf)) : String(Number(i[14].tbf))
                    },
                    july: {
                        tbc: i[1] === 3 && i[15].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[15].tbc.value) : String(i[15].tbc),
                        fcp: i[2] === 3 && i[15].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[15].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[15].fcp)) : String(Number(i[15].fcp)),
                        tbf: i[3] === 3 && i[15].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[15].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[15].tbf)) : String(Number(i[15].tbf))
                    },
                    august: {
                        tbc: i[1] === 3 && i[16].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[16].tbc.value) : String(i[16].tbc),
                        fcp: i[2] === 3 && i[16].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[16].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[16].fcp)) : String(Number(i[16].fcp)),
                        tbf: i[3] === 3 && i[16].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[16].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[16].tbf)) : String(Number(i[16].tbf))
                    },
                    september: {
                        tbc: i[1] === 3 && i[17].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[17].tbc.value) : String(i[17].tbc),
                        fcp: i[2] === 3 && i[17].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[17].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[17].fcp)) : String(Number(i[17].fcp)),
                        tbf: i[3] === 3 && i[17].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[17].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[17].tbf)) : String(Number(i[17].tbf))
                    },
                    october: {
                        tbc: i[1] === 3 && i[18].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[18].tbc.value) : String(i[18].tbc),
                        fcp: i[2] === 3 && i[18].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[18].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[18].fcp)) : String(Number(i[18].fcp)),
                        tbf: i[3] === 3 && i[18].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[18].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[18].tbf)) : String(Number(i[18].tbf))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[19].fcp)) : String(Number(i[19].fcp)),
                        tbf: i[3] === 3 && i[19].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[19].tbf)) : String(Number(i[19].tbf))
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[20].fcp)) : String(Number(i[20].fcp)),
                        tbf: i[3] === 3 && i[20].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[20].tbf)) : String(Number(i[20].tbf))
                    },
                    total_current_year: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[21])) : String(Number(i[21])),
                    total_next_year: {
                        tbc: String(Number(i[22].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[22].fcp)) : String(Number(i[22].fcp)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[22].tbf)) : String(Number(i[22].tbf))
                    },
                    total_more_year: {
                        tbc: String(Number(i[23].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[23].fcp)) : String(Number(i[23].fcp)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[23].tbf)) : String(Number(i[23].tbf))
                    }
                })
            })

        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbc: i[1] === 3 && i[9].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[9].tbc.value) : String(i[9].tbc),
                        fcp: i[2] === 3 && i[9].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[9].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[9].fcp), 2)) : String(fixNumber(Number(i[9].fcp), 1)),
                        tbf: i[3] === 3 && i[9].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[9].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[9].tbf), 2)) : String(fixNumber(Number(i[9].tbf), 1))
                    },
                    february: {
                        tbc: i[1] === 3 && i[10].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[10].tbc.value) : String(i[10].tbc),
                        fcp: i[2] === 3 && i[10].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[10].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[10].fcp), 2)) : String(fixNumber(Number(i[10].fcp), 1)),
                        tbf: i[3] === 3 && i[10].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[10].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[10].tbf), 2)) : String(fixNumber(Number(i[10].tbf), 1))
                    },
                    march: {
                        tbc: i[1] === 3 && i[11].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[11].tbc.value) : String(i[11].tbc),
                        fcp: i[2] === 3 && i[11].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[11].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[11].fcp), 2)) : String(fixNumber(Number(i[11].fcp), 1)),
                        tbf: i[3] === 3 && i[11].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[11].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[11].tbf), 2)) : String(fixNumber(Number(i[11].tbf), 1))
                    },
                    april: {
                        tbc: i[1] === 3 && i[12].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[12].tbc.value) : String(i[12].tbc),
                        fcp: i[2] === 3 && i[12].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[12].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[12].fcp), 2)) : String(fixNumber(Number(i[12].fcp), 1)),
                        tbf: i[3] === 3 && i[12].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[12].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[12].tbf), 2)) : String(fixNumber(Number(i[12].tbf), 1))
                    },
                    may: {
                        tbc: i[1] === 3 && i[13].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[13].tbc.value) : String(i[13].tbc),
                        fcp: i[2] === 3 && i[13].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[13].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[13].fcp), 2)) : String(fixNumber(Number(i[13].fcp), 1)),
                        tbf: i[3] === 3 && i[13].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[13].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[13].tbf), 2)) : String(fixNumber(Number(i[13].tbf), 1))
                    },
                    june: {
                        tbc: i[1] === 3 && i[14].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[14].tbc.value) : String(i[14].tbc),
                        fcp: i[2] === 3 && i[14].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[14].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[14].fcp), 2)) : String(fixNumber(Number(i[14].fcp), 1)),
                        tbf: i[3] === 3 && i[14].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[14].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[14].tbf), 2)) : String(fixNumber(Number(i[14].tbf), 1))
                    },
                    july: {
                        tbc: i[1] === 3 && i[15].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[15].tbc.value) : String(i[15].tbc),
                        fcp: i[2] === 3 && i[15].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[15].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[15].fcp), 2)) : String(fixNumber(Number(i[15].fcp), 1)),
                        tbf: i[3] === 3 && i[15].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[15].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[15].tbf), 2)) : String(fixNumber(Number(i[15].tbf), 1))
                    },
                    august: {
                        tbc: i[1] === 3 && i[16].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[16].tbc.value) : String(i[16].tbc),
                        fcp: i[2] === 3 && i[16].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[16].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[16].fcp), 2)) : String(fixNumber(Number(i[16].fcp), 1)),
                        tbf: i[3] === 3 && i[16].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[16].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[16].tbf), 2)) : String(fixNumber(Number(i[16].tbf), 1))
                    },
                    september: {
                        tbc: i[1] === 3 && i[17].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[17].tbc.value) : String(i[17].tbc),
                        fcp: i[2] === 3 && i[17].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[17].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[17].fcp), 2)) : String(fixNumber(Number(i[17].fcp), 1)),
                        tbf: i[3] === 3 && i[17].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[17].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[17].tbf), 2)) : String(fixNumber(Number(i[17].tbf), 1))
                    },
                    october: {
                        tbc: i[1] === 3 && i[18].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[18].tbc.value) : String(i[18].tbc),
                        fcp: i[2] === 3 && i[18].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[18].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[18].fcp), 2)) : String(fixNumber(Number(i[18].fcp), 1)),
                        tbf: i[3] === 3 && i[18].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[18].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[18].tbf), 2)) : String(fixNumber(Number(i[18].tbf), 1))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[19].fcp), 2)) : String(fixNumber(Number(i[19].fcp), 1)),
                        tbf: i[3] === 3 && i[19].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[19].tbf), 2)) : String(fixNumber(Number(i[19].tbf), 1))
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[20].fcp), 2)) : String(fixNumber(Number(i[20].fcp), 1)),
                        tbf: i[3] === 3 && i[20].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[20].tbf), 2)) : String(fixNumber(Number(i[20].tbf), 1))
                    },
                    total_current_year: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[21]), 2)) : String(fixNumber(Number(i[21]), 1)),
                    total_next_year: {
                        tbc: String(fixNumber(Number(i[22].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[22].fcp), 2)) : String(fixNumber(Number(i[22].fcp), 1)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[22].tbf), 2)) : String(fixNumber(Number(i[22].tbf), 1))
                    },
                    total_more_year: {
                        tbc: String(fixNumber(Number(i[23].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[23].fcp), 2)) : String(fixNumber(Number(i[23].fcp), 1)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[23].tbf), 2)) : String(fixNumber(Number(i[23].tbf), 1))
                    }
                })
            })
        }
        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "status": type,
            "tax_planning": data
        }
        console.log(payload);
        // console.log(JSON.stringify(data))
        this.props.saveToMasterBudget(payload)
        this.props.onClickClose()
        if (type == 'submitted') {
            this.props.saveToMasterBudget(payload, 'TP')
        } else {
            this.props.saveToMasterBudget(payload, 'DraftTP')
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                let isi = resp.rows.slice(4)
                // console.log(resp.rows[2]);
                // console.log(resp.rows);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            item_report_id: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                            january: {
                                tbc: i[2] === undefined ? "0.0" : reg.test(String(i[2])) === false ? "0.0" : String(i[2]).trim(),
                                fcp: i[3] === undefined ? "0.0" : reg.test(String(i[3])) === false ? "0.0" : String(Number(String(i[3]).trim())),
                                tbf: i[4] === undefined ? "0.0" : reg.test(String(i[4])) === false ? "0.0" : String(Number(String(i[4]).trim())),
                            },
                            february: {
                                tbc: i[5] === undefined ? "0.0" : reg.test(String(i[5])) === false ? "0.0" : String(i[5]).trim(),
                                fcp: i[6] === undefined ? "0.0" : reg.test(String(i[6])) === false ? "0.0" : String(Number(String(i[6]).trim())),
                                tbf: i[7] === undefined ? "0.0" : reg.test(String(i[7])) === false ? "0.0" : String(Number(String(i[7]).trim())),
                            },
                            march: {
                                tbc: i[8] === undefined ? "0.0" : reg.test(String(i[8])) === false ? "0.0" : String(i[8]).trim(),
                                fcp: i[9] === undefined ? "0.0" : reg.test(String(i[9])) === false ? "0.0" : String(Number(String(i[9]).trim())),
                                tbf: i[10] === undefined ? "0.0" : reg.test(String(i[10])) === false ? "0.0" : String(Number(String(i[10]).trim())),
                            },
                            april: {
                                tbc: i[11] === undefined ? "0.0" : reg.test(String(i[11])) === false ? "0.0" : String(i[11]).trim(),
                                fcp: i[12] === undefined ? "0.0" : reg.test(String(i[12])) === false ? "0.0" : String(Number(String(i[12]).trim())),
                                tbf: i[13] === undefined ? "0.0" : reg.test(String(i[13])) === false ? "0.0" : String(Number(String(i[13]).trim())),
                            },
                            may: {
                                tbc: i[14] === undefined ? "0.0" : reg.test(String(i[14])) === false ? "0.0" : String(i[14]).trim(),
                                fcp: i[15] === undefined ? "0.0" : reg.test(String(i[15])) === false ? "0.0" : String(Number(String(i[15]).trim())),
                                tbf: i[16] === undefined ? "0.0" : reg.test(String(i[16])) === false ? "0.0" : String(Number(String(i[16]).trim())),
                            },
                            june: {
                                tbc: i[17] === undefined ? "0.0" : reg.test(String(i[17])) === false ? "0.0" : String(i[17]).trim(),
                                fcp: i[18] === undefined ? "0.0" : reg.test(String(i[18])) === false ? "0.0" : String(Number(String(i[18]).trim())),
                                tbf: i[19] === undefined ? "0.0" : reg.test(String(i[19])) === false ? "0.0" : String(Number(String(i[19]).trim())),
                            },
                            july: {
                                tbc: i[20] === undefined ? "0.0" : reg.test(String(i[20])) === false ? "0.0" : String(i[20]).trim(),
                                fcp: i[21] === undefined ? "0.0" : reg.test(String(i[21])) === false ? "0.0" : String(Number(String(i[21]).trim())),
                                tbf: i[22] === undefined ? "0.0" : reg.test(String(i[22])) === false ? "0.0" : String(Number(String(i[22]).trim())),
                            },
                            august: {
                                tbc: i[23] === undefined ? "0.0" : reg.test(String(i[23])) === false ? "0.0" : String(i[23]).trim(),
                                fcp: i[24] === undefined ? "0.0" : reg.test(String(i[24])) === false ? "0.0" : String(Number(String(i[24]).trim())),
                                tbf: i[25] === undefined ? "0.0" : reg.test(String(i[25])) === false ? "0.0" : String(Number(String(i[25]).trim())),
                            },
                            september: {
                                tbc: i[26] === undefined ? "0.0" : reg.test(String(i[26])) === false ? "0.0" : String(i[26]).trim(),
                                fcp: i[27] === undefined ? "0.0" : reg.test(String(i[27])) === false ? "0.0" : String(Number(String(i[27]).trim())),
                                tbf: i[28] === undefined ? "0.0" : reg.test(String(i[28])) === false ? "0.0" : String(Number(String(i[28]).trim())),
                            },
                            october: {
                                tbc: i[29] === undefined ? "0.0" : reg.test(String(i[29])) === false ? "0.0" : String(i[29]).trim(),
                                fcp: i[30] === undefined ? "0.0" : reg.test(String(i[30])) === false ? "0.0" : String(Number(String(i[30]).trim())),
                                tbf: i[31] === undefined ? "0.0" : reg.test(String(i[31])) === false ? "0.0" : String(Number(String(i[31]).trim())),
                            },
                            november: {
                                tbc: i[32] === undefined ? "0.0" : reg.test(String(i[32])) === false ? "0.0" : String(i[32]).trim(),
                                fcp: i[33] === undefined ? "0.0" : reg.test(String(i[33])) === false ? "0.0" : String(Number(String(i[33]).trim())),
                                tbf: i[34] === undefined ? "0.0" : reg.test(String(i[34])) === false ? "0.0" : String(Number(String(i[34]).trim())),
                            },
                            december: {
                                tbc: i[35] === undefined ? "0.0" : reg.test(String(i[35])) === false ? "0.0" : String(i[35]).trim(),
                                fcp: i[36] === undefined ? "0.0" : reg.test(String(i[36])) === false ? "0.0" : String(Number(String(i[36]).trim())),
                                tbf: i[37] === undefined ? "0.0" : reg.test(String(i[37])) === false ? "0.0" : String(Number(String(i[37]).trim())),
                            },
                            total_current_year: i[38] === undefined ? "" : String(i[38]).trim(),
                            total_next_year: {
                                tbc: i[39] === undefined ? "0.0" : reg.test(String(i[39])) === false ? "0.0" : String(i[39]).trim(),
                                fcp: i[40] === undefined ? "0.0" : reg.test(String(i[40])) === false ? "0.0" : String(Number(String(i[40]).trim())),
                                tbf: i[41] === undefined ? "0.0" : reg.test(String(i[41])) === false ? "0.0" : String(Number(String(i[41]).trim())),
                            },
                            total_more_year: {
                                tbc: i[42] === undefined ? "0.0" : reg.test(String(i[42])) === false ? "0.0" : String(i[42]).trim(),
                                fcp: i[43] === undefined ? "0.0" : reg.test(String(i[43])) === false ? "0.0" : String(Number(String(i[43]).trim())),
                                tbf: i[44] === undefined ? "0.0" : reg.test(String(i[44])) === false ? "0.0" : String(Number(String(i[44]).trim())),
                            }
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    tax_planning: payload,
                    status: 'submitted'
                }
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[2] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        console.log(payload);
        api.create().checkUploadMB(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleTP: false, loading: true })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            // item.type_report_id,
                            0,
                            Number(item.type_report_id.tbc),
                            Number(item.type_report_id.fcp),
                            Number(item.type_report_id.tbf),
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            // {tbc: item.formula.tbc, fcp: item.formula.fcp, tbf: item.formula.tbf},
                            item.level,
                            item.item_report,
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.january.tbc, formula: item.january_formula } : Number(item.january.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 || item.type_report_id.fcp == 7 ? { value: item.january.fcp, formula: item.january_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.january.fcp) : Number(item.january.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 || item.type_report_id.tbf == 7 ? { value: item.january.tbf, formula: item.january_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.january.tbf) : Number(item.january.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.february.tbc, formula: item.february_formula } : Number(item.february.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.february.fcp, formula: item.february_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.february.fcp) : Number(item.february.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.february.tbf, formula: item.february_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.february.tbf) : Number(item.february.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.march.tbc, formula: item.march_formula } : Number(item.march.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.march.fcp, formula: item.march_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.march.fcp) : Number(item.march.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.march.tbf, formula: item.march_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.march.tbf) : Number(item.march.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.april.tbc, formula: item.april_formula } : Number(item.april.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.april.fcp, formula: item.april_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.april.fcp) : Number(item.april.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.april.tbf, formula: item.april_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.april.tbf) : Number(item.april.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.may.tbc, formula: item.may_formula } : Number(item.may.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.may.fcp, formula: item.may_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.may.fcp) : Number(item.may.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.may.tbf, formula: item.may_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.may.tbf) : Number(item.may.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.june.tbc, formula: item.june_formula } : Number(item.june.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.june.fcp, formula: item.june_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.june.fcp) : Number(item.june.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.june.tbf, formula: item.june_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.june.tbf) : Number(item.june.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.july.tbc, formula: item.july_formula } : Number(item.july.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.july.fcp, formula: item.july_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.july.fcp) : Number(item.july.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.july.tbf, formula: item.july_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.july.tbf) : Number(item.july.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.august.tbc, formula: item.august_formula } : item.august.tbc === null ? "0.0" : item.august.tbc === "" ? "0.0" : Number(item.august.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.august.fcp, formula: item.august_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.august.fcp) : Number(item.august.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.august.tbf, formula: item.august_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.august.tbf) : Number(item.august.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.september.tbc, formula: item.september_formula } : Number(item.september.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.september.fcp, formula: item.september_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.september.fcp) : Number(item.september.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.september.tbf, formula: item.september_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.september.tbf) : Number(item.september.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.october.tbc, formula: item.october_formula } : Number(item.october.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.october.fcp, formula: item.october_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.october.fcp) : Number(item.october.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.october.tbf, formula: item.october_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.october.tbf) : Number(item.october.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.november.tbc, formula: item.november_formula } : Number(item.november.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.november.fcp, formula: item.november_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.november.fcp) : Number(item.november.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.november.tbf, formula: item.november_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.november.tbf) : Number(item.november.tbf) },
                            { tbc: item.type_report_id.tbc == 5 || item.type_report_id.tbc == 6 || item.type_report_id.tbc == 7 ? { value: item.december.tbc, formula: item.december_formula } : Number(item.december.tbc), fcp: item.type_report_id.fcp == 5 || item.type_report_id.fcp == 6 || item.type_report_id.fcp == 7 ? { value: item.december.fcp, formula: item.december_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.december.fcp) : Number(item.december.fcp), tbf: item.type_report_id.tbf == 5 || item.type_report_id.tbf == 6 || item.type_report_id.tbf == 7 ? { value: item.december.tbf, formula: item.december_formula } : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.december.tbf) : Number(item.december.tbf) },
                            String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.total_current_year) : Number(item.total_current_year),
                            {
                                tbc: Number(item.type_report_id.tbc) === 3 && item.total_next_year.tbc === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.total_next_year.tbc) : Number(item.total_next_year.tbc),
                                fcp: Number(item.type_report_id.fcp) === 3 && item.total_next_year.fcp === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.total_next_year.fcp) : Number(item.total_next_year.fcp),
                                tbf: Number(item.type_report_id.tbf) === 3 && item.total_next_year.tbf === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.total_next_year.tbf) : Number(item.total_next_year.tbf)
                            },
                            {
                                tbc: Number(item.type_report_id.tbc) === 3 && item.total_more_year.tbc === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.total_more_year.tbc) : Number(item.total_more_year.tbc),
                                fcp: Number(item.type_report_id.fcp) === 3 && item.total_more_year.fcp === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.total_more_year.fcp) : Number(item.total_more_year.fcp),
                                tbf: Number(item.type_report_id.tbf) === 3 && item.total_more_year.tbf === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.total_more_year.tbf) : Number(item.total_more_year.tbf)
                            },
                            item.orders,
                            { tbc: item.condition_it_should_be.tbc, fcp: item.condition_it_should_be.fcp, tbf: item.condition_it_should_be.tbf },
                            { tbc: item.condition_if_wrong.tbc, fcp: item.condition_if_wrong.fcp, tbf: item.condition_if_wrong.tbf },
                            item.forecast_tbc_formula,
                            item.forecast_fcp_formula,
                            item.forecast_tbf_formula,
                            item.error
                        ]
                    })
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true, saveDraft: true }, () => {
                        this.state.dataTable.map(item => {
                            if (item[27].length > 0) {
                                // console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true, editable: true, saveDraft: true })
                            }
                        })
                        // console.log(this.state.dataTable);
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadTP(type) {
        let data = []
        if (this.state.defaultCurrencyUpload?.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbc: i[1] === 3 && i[9].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[9].tbc.value) : String(i[9].tbc),
                        fcp: i[2] === 3 && i[9].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[9].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].fcp)) : String(Number(i[9].fcp)),
                        tbf: i[3] === 3 && i[9].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[9].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].tbf)) : String(Number(i[9].tbf))
                    },
                    february: {
                        tbc: i[1] === 3 && i[10].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[10].tbc.value) : String(i[10].tbc),
                        fcp: i[2] === 3 && i[10].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[10].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10].fcp)) : String(Number(i[10].fcp)),
                        tbf: i[3] === 3 && i[10].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[10].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10].tbf)) : String(Number(i[10].tbf))
                    },
                    march: {
                        tbc: i[1] === 3 && i[11].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[11].tbc.value) : String(i[11].tbc),
                        fcp: i[2] === 3 && i[11].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[11].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11].fcp)) : String(Number(i[11].fcp)),
                        tbf: i[3] === 3 && i[11].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[11].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11].tbf)) : String(Number(i[11].tbf))
                    },
                    april: {
                        tbc: i[1] === 3 && i[12].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[12].tbc.value) : String(i[12].tbc),
                        fcp: i[2] === 3 && i[12].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[12].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[12].fcp)) : String(Number(i[12].fcp)),
                        tbf: i[3] === 3 && i[12].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[12].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[12].tbf)) : String(Number(i[12].tbf))
                    },
                    may: {
                        tbc: i[1] === 3 && i[13].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[13].tbc.value) : String(i[13].tbc),
                        fcp: i[2] === 3 && i[13].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[13].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[13].fcp)) : String(Number(i[13].fcp)),
                        tbf: i[3] === 3 && i[13].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[13].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[13].tbf)) : String(Number(i[13].tbf))
                    },
                    june: {
                        tbc: i[1] === 3 && i[14].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[14].tbc.value) : String(i[14].tbc),
                        fcp: i[2] === 3 && i[14].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[14].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[14].fcp)) : String(Number(i[14].fcp)),
                        tbf: i[3] === 3 && i[14].tbc === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[14].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[14].tbf)) : String(Number(i[14].tbf))
                    },
                    july: {
                        tbc: i[1] === 3 && i[15].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[15].tbc.value) : String(i[15].tbc),
                        fcp: i[2] === 3 && i[15].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[15].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[15].fcp)) : String(Number(i[15].fcp)),
                        tbf: i[3] === 3 && i[15].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[15].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[15].tbf)) : String(Number(i[15].tbf))
                    },
                    august: {
                        tbc: i[1] === 3 && i[16].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[16].tbc.value) : String(i[16].tbc),
                        fcp: i[2] === 3 && i[16].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[16].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[16].fcp)) : String(Number(i[16].fcp)),
                        tbf: i[3] === 3 && i[16].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[16].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[16].tbf)) : String(Number(i[16].tbf))
                    },
                    september: {
                        tbc: i[1] === 3 && i[17].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[17].tbc.value) : String(i[17].tbc),
                        fcp: i[2] === 3 && i[17].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[17].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[17].fcp)) : String(Number(i[17].fcp)),
                        tbf: i[3] === 3 && i[17].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[17].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[17].tbf)) : String(Number(i[17].tbf))
                    },
                    october: {
                        tbc: i[1] === 3 && i[18].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[18].tbc.value) : String(i[18].tbc),
                        fcp: i[2] === 3 && i[18].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[18].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[18].fcp)) : String(Number(i[18].fcp)),
                        tbf: i[3] === 3 && i[18].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[18].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[18].tbf)) : String(Number(i[18].tbf))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[19].fcp)) : String(Number(i[19].fcp)),
                        tbf: i[3] === 3 && i[19].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[19].tbf)) : String(Number(i[19].tbf))
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[20].fcp)) : String(Number(i[20].fcp)),
                        tbf: i[3] === 3 && i[20].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[20].tbf)) : String(Number(i[20].tbf))
                    },
                    total_current_year: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[21])) : String(Number(i[21])),
                    total_next_year: {
                        tbc: String(Number(i[22].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[22].fcp)) : String(Number(i[22].fcp)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[22].tbf)) : String(Number(i[22].tbf))
                    },
                    total_more_year: {
                        tbc: String(Number(i[23].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[23].fcp)) : String(Number(i[23].fcp)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[23].tbf)) : String(Number(i[23].tbf))
                    }
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbc: i[1] === 3 && i[9].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[9].tbc.value) : String(i[9].tbc),
                        fcp: i[2] === 3 && i[9].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[9].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[9].fcp), 2)) : String(fixNumber(Number(i[9].fcp), 1)),
                        tbf: i[3] === 3 && i[9].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[9].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[9].tbf), 2)) : String(fixNumber(Number(i[9].tbf), 1))
                    },
                    february: {
                        tbc: i[1] === 3 && i[10].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[10].tbc.value) : String(i[10].tbc),
                        fcp: i[2] === 3 && i[10].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[10].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[10].fcp), 2)) : String(fixNumber(Number(i[10].fcp), 1)),
                        tbf: i[3] === 3 && i[10].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[10].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[10].tbf), 2)) : String(fixNumber(Number(i[10].tbf), 1))
                    },
                    march: {
                        tbc: i[1] === 3 && i[11].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[11].tbc.value) : String(i[11].tbc),
                        fcp: i[2] === 3 && i[11].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[11].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[11].fcp), 2)) : String(fixNumber(Number(i[11].fcp), 1)),
                        tbf: i[3] === 3 && i[11].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[11].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[11].tbf), 2)) : String(fixNumber(Number(i[11].tbf), 1))
                    },
                    april: {
                        tbc: i[1] === 3 && i[12].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[12].tbc.value) : String(i[12].tbc),
                        fcp: i[2] === 3 && i[12].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[12].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[12].fcp), 2)) : String(fixNumber(Number(i[12].fcp), 1)),
                        tbf: i[3] === 3 && i[12].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[12].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[12].tbf), 2)) : String(fixNumber(Number(i[12].tbf), 1))
                    },
                    may: {
                        tbc: i[1] === 3 && i[13].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[13].tbc.value) : String(i[13].tbc),
                        fcp: i[2] === 3 && i[13].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[13].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[13].fcp), 2)) : String(fixNumber(Number(i[13].fcp), 1)),
                        tbf: i[3] === 3 && i[13].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[13].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[13].tbf), 2)) : String(fixNumber(Number(i[13].tbf), 1))
                    },
                    june: {
                        tbc: i[1] === 3 && i[14].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[14].tbc.value) : String(i[14].tbc),
                        fcp: i[2] === 3 && i[14].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[14].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[14].fcp), 2)) : String(fixNumber(Number(i[14].fcp), 1)),
                        tbf: i[3] === 3 && i[14].tbc === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[14].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[14].tbf), 2)) : String(fixNumber(Number(i[14].tbf), 1))
                    },
                    july: {
                        tbc: i[1] === 3 && i[15].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[15].tbc.value) : String(i[15].tbc),
                        fcp: i[2] === 3 && i[15].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[15].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[15].fcp), 2)) : String(fixNumber(Number(i[15].fcp), 1)),
                        tbf: i[3] === 3 && i[15].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[15].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[15].tbf), 2)) : String(fixNumber(Number(i[15].tbf), 1))
                    },
                    august: {
                        tbc: i[1] === 3 && i[16].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[16].tbc.value) : String(i[16].tbc),
                        fcp: i[2] === 3 && i[16].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[16].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[16].fcp), 2)) : String(fixNumber(Number(i[16].fcp), 1)),
                        tbf: i[3] === 3 && i[16].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[16].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[16].tbf), 2)) : String(fixNumber(Number(i[16].tbf), 1))
                    },
                    september: {
                        tbc: i[1] === 3 && i[17].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[17].tbc.value) : String(i[17].tbc),
                        fcp: i[2] === 3 && i[17].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[17].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[17].fcp), 2)) : String(fixNumber(Number(i[17].fcp), 1)),
                        tbf: i[3] === 3 && i[17].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[17].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[17].tbf), 2)) : String(fixNumber(Number(i[17].tbf), 1))
                    },
                    october: {
                        tbc: i[1] === 3 && i[18].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[18].tbc.value) : String(i[18].tbc),
                        fcp: i[2] === 3 && i[18].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[18].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[18].fcp), 2)) : String(fixNumber(Number(i[18].fcp), 1)),
                        tbf: i[3] === 3 && i[18].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[18].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[18].tbf), 2)) : String(fixNumber(Number(i[18].tbf), 1))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[19].fcp), 2)) : String(fixNumber(Number(i[19].fcp), 1)),
                        tbf: i[3] === 3 && i[19].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[19].tbf), 2)) : String(fixNumber(Number(i[19].tbf), 1))
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[20].fcp), 2)) : String(fixNumber(Number(i[20].fcp), 1)),
                        tbf: i[3] === 3 && i[20].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[20].tbf), 2)) : String(fixNumber(Number(i[20].tbf), 1))
                    },
                    total_current_year: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[21]), 2)) : String(fixNumber(Number(i[21]), 1)),
                    total_next_year: {
                        tbc: String(fixNumber(Number(i[22].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[22].fcp), 2)) : String(fixNumber(Number(i[22].fcp), 1)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[22].tbf), 2)) : String(fixNumber(Number(i[22].tbf), 1))
                    },
                    total_more_year: {
                        tbc: String(fixNumber(Number(i[23].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[23].fcp), 2)) : String(fixNumber(Number(i[23].fcp), 1)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[23].tbf), 2)) : String(fixNumber(Number(i[23].tbf), 1))
                    }
                })
            })
        }

        let body = {
            submission_id: this.props.submissionID,
            company_id: this.props.company.company_id,
            periode: this.props.periode,
            report_id: this.props.report_id,
            currency_id: this.state.defaultCurrencyUpload?.id,
            tax_planning: data,
            status: type
        }
        console.log(body);
        api.create('UPLOAD').uploadMasterBudget(body).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.onClickClose()
                    this.props.getReport()
                } else {
                    if (response.data.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true })
                    } else {
                        this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                    // alert(response.data.status)
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error' })
            }
        })
    }

    handleValidate() {
        let data = []
        console.log(this.state.dataTable)
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                // console.log(i[0])
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbc: i[1] === 3 && i[9].tbc === "" || i[9].tbc === "0.0" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[9].tbc.value) : String(i[9].tbc),
                        fcp: i[2] === 3 && i[9].fcp === "" || i[9].fcp === "0.0" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[9].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].fcp)) : String(Number(i[9].fcp)),
                        tbf: i[3] === 3 && i[9].tbf === "" || i[9].tbf === "0.0" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[9].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].tbf)) : String(Number(i[9].tbf))
                    },
                    february: {
                        tbc: i[1] === 3 && i[10].tbc === "" || i[10].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[10].tbc.value) : String(i[10].tbc),
                        fcp: i[2] === 3 && i[10].fcp === "" || i[10].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[10].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10].fcp)) : String(Number(i[10].fcp)),
                        tbf: i[3] === 3 && i[10].tbf === "" || i[10].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[10].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10].tbf)) : String(Number(i[10].tbf))
                    },
                    march: {
                        tbc: i[1] === 3 && i[11].tbc === "" || i[11].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[11].tbc.value) : String(i[11].tbc),
                        fcp: i[2] === 3 && i[11].fcp === "" || i[11].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[11].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11].fcp)) : String(Number(i[11].fcp)),
                        tbf: i[3] === 3 && i[11].tbf === "" || i[11].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[11].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11].tbf)) : String(Number(i[11].tbf))
                    },
                    april: {
                        tbc: i[1] === 3 && i[12].tbc === "" || i[12].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[12].tbc.value) : String(i[12].tbc),
                        fcp: i[2] === 3 && i[12].fcp === "" || i[12].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[12].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[12].fcp)) : String(Number(i[12].fcp)),
                        tbf: i[3] === 3 && i[12].tbf === "" || i[12].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[12].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[12].tbf)) : String(Number(i[12].tbf))
                    },
                    may: {
                        tbc: i[1] === 3 && i[13].tbc === "" || i[13].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[13].tbc.value) : String(i[13].tbc),
                        fcp: i[2] === 3 && i[13].fcp === "" || i[13].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[13].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[13].fcp)) : String(Number(i[13].fcp)),
                        tbf: i[3] === 3 && i[13].tbf === "" || i[13].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[13].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[13].tbf)) : String(Number(i[13].tbf))
                    },
                    june: {
                        tbc: i[1] === 3 && i[14].tbc === "" || i[14].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[14].tbc.value) : String(i[14].tbc),
                        fcp: i[2] === 3 && i[14].fcp === "" || i[14].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[14].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[14].fcp)) : String(Number(i[14].fcp)),
                        tbf: i[3] === 3 && i[14].tbc === "" || i[14].tbc === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[14].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[14].tbf)) : String(Number(i[14].tbf))
                    },
                    july: {
                        tbc: i[1] === 3 && i[15].tbc === "" || i[15].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[15].tbc.value) : String(i[15].tbc),
                        fcp: i[2] === 3 && i[15].fcp === "" || i[15].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[15].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[15].fcp)) : String(Number(i[15].fcp)),
                        tbf: i[3] === 3 && i[15].tbf === "" || i[15].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[15].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[15].tbf)) : String(Number(i[15].tbf))
                    },
                    august: {
                        tbc: i[1] === 3 && i[16].tbc === "" || i[16].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[16].tbc.value) : String(i[16].tbc),
                        fcp: i[2] === 3 && i[16].fcp === "" || i[16].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[16].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[16].fcp)) : String(Number(i[16].fcp)),
                        tbf: i[3] === 3 && i[16].tbf === "" || i[16].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[16].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[16].tbf)) : String(Number(i[16].tbf))
                    },
                    september: {
                        tbc: i[1] === 3 && i[17].tbc === "" || i[17].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[17].tbc.value) : String(i[17].tbc),
                        fcp: i[2] === 3 && i[17].fcp === "" || i[17].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[17].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[17].fcp)) : String(Number(i[17].fcp)),
                        tbf: i[3] === 3 && i[17].tbf === "" || i[17].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[17].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[17].tbf)) : String(Number(i[17].tbf))
                    },
                    october: {
                        tbc: i[1] === 3 && i[18].tbc === "" || i[18].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[18].tbc.value) : String(i[18].tbc),
                        fcp: i[2] === 3 && i[18].fcp === "" || i[18].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[18].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[18].fcp)) : String(Number(i[18].fcp)),
                        tbf: i[3] === 3 && i[18].tbf === "" || i[18].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[18].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[18].tbf)) : String(Number(i[18].tbf))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" || i[19].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" || i[19].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[19].fcp)) : String(Number(i[19].fcp)),
                        tbf: i[3] === 3 && i[19].tbf === "" || i[19].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[19].tbf)) : String(Number(i[19].tbf))
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" || i[20].tbc === 0 ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" || i[20].fcp === 0 ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[20].fcp)) : String(Number(i[20].fcp)),
                        tbf: i[3] === 3 && i[20].tbf === "" || i[20].tbf === 0 ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[20].tbf)) : String(Number(i[20].tbf))
                    },
                    total_current_year: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[21])) : String(Number(i[21])),
                    total_next_year: {
                        tbc: String(Number(i[22].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[22].fcp)) : String(Number(i[22].fcp)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[22].tbf)) : String(Number(i[22].tbf))
                    },
                    total_more_year: {
                        tbc: String(Number(i[23].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[23].fcp)) : String(Number(i[23].fcp)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[23].tbf)) : String(Number(i[23].tbf))
                    }
                })
            })
        } else {
            this.state.dataTable.map(i => {
                // console.log(i[0])
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbc: i[1] === 3 && i[9].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[9].tbc.value) : String(i[9].tbc),
                        fcp: i[2] === 3 && i[9].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[9].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[9].fcp), 2)) : String(fixNumber(Number(i[9].fcp), 1)),
                        tbf: i[3] === 3 && i[9].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[9].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[9].tbf), 2)) : String(fixNumber(Number(i[9].tbf), 1))
                    },
                    february: {
                        tbc: i[1] === 3 && i[10].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[10].tbc.value) : String(i[10].tbc),
                        fcp: i[2] === 3 && i[10].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[10].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[10].fcp), 1)) : String(fixNumber(Number(i[10].fcp), 1)),
                        tbf: i[3] === 3 && i[10].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[10].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[10].tbf), 1)) : String(fixNumber(Number(i[10].tbf), 1))
                    },
                    march: {
                        tbc: i[1] === 3 && i[11].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[11].tbc.value) : String(i[11].tbc),
                        fcp: i[2] === 3 && i[11].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[11].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[11].fcp), 1)) : String(fixNumber(Number(i[11].fcp), 1)),
                        tbf: i[3] === 3 && i[11].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[11].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[11].tbf), 1)) : String(fixNumber(Number(i[11].tbf), 1))
                    },
                    april: {
                        tbc: i[1] === 3 && i[12].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[12].tbc.value) : String(i[12].tbc),
                        fcp: i[2] === 3 && i[12].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[12].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[12].fcp), 1)) : String(fixNumber(Number(i[12].fcp), 1)),
                        tbf: i[3] === 3 && i[12].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[12].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[12].tbf), 1)) : String(fixNumber(Number(i[12].tbf), 1))
                    },
                    may: {
                        tbc: i[1] === 3 && i[13].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[13].tbc.value) : String(i[13].tbc),
                        fcp: i[2] === 3 && i[13].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[13].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[13].fcp), 1)) : String(fixNumber(Number(i[13].fcp), 1)),
                        tbf: i[3] === 3 && i[13].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[13].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[13].tbf), 1)) : String(fixNumber(Number(i[13].tbf), 1))
                    },
                    june: {
                        tbc: i[1] === 3 && i[14].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[14].tbc.value) : String(i[14].tbc),
                        fcp: i[2] === 3 && i[14].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[14].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[14].fcp), 1)) : String(fixNumber(Number(i[14].fcp), 1)),
                        tbf: i[3] === 3 && i[14].tbc === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[14].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[14].tbf), 1)) : String(fixNumber(Number(i[14].tbf), 1))
                    },
                    july: {
                        tbc: i[1] === 3 && i[15].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[15].tbc.value) : String(i[15].tbc),
                        fcp: i[2] === 3 && i[15].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[15].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[15].fcp), 1)) : String(fixNumber(Number(i[15].fcp), 1)),
                        tbf: i[3] === 3 && i[15].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[15].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[15].tbf), 1)) : String(fixNumber(Number(i[15].tbf), 1))
                    },
                    august: {
                        tbc: i[1] === 3 && i[16].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[16].tbc.value) : String(i[16].tbc),
                        fcp: i[2] === 3 && i[16].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[16].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[16].fcp), 1)) : String(fixNumber(Number(i[16].fcp), 1)),
                        tbf: i[3] === 3 && i[16].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[16].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[16].tbf), 1)) : String(fixNumber(Number(i[16].tbf), 1))
                    },
                    september: {
                        tbc: i[1] === 3 && i[17].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[17].tbc.value) : String(i[17].tbc),
                        fcp: i[2] === 3 && i[17].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[17].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[17].fcp), 1)) : String(fixNumber(Number(i[17].fcp), 1)),
                        tbf: i[3] === 3 && i[17].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[17].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[17].tbf), 1)) : String(fixNumber(Number(i[17].tbf), 1))
                    },
                    october: {
                        tbc: i[1] === 3 && i[18].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[18].tbc.value) : String(i[18].tbc),
                        fcp: i[2] === 3 && i[18].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[18].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[18].fcp), 1)) : String(fixNumber(Number(i[18].fcp), 1)),
                        tbf: i[3] === 3 && i[18].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[18].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[18].tbf), 1)) : String(fixNumber(Number(i[18].tbf), 1))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[19].fcp), 1)) : String(fixNumber(Number(i[19].fcp), 1)),
                        tbf: i[3] === 3 && i[19].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[19].tbf), 1)) : String(fixNumber(Number(i[19].tbf), 1))
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" ? "0.0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" ? "0.0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[20].fcp), 1)) : String(fixNumber(Number(i[20].fcp), 1)),
                        tbf: i[3] === 3 && i[20].tbf === "" ? "0.0" : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[20].tbf), 1)) : String(fixNumber(Number(i[20].tbf), 1))
                    },
                    total_current_year: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[21]), 2)) : String(fixNumber(Number(i[21]), 1)),
                    total_next_year: {
                        tbc: String(fixNumber(Number(i[22].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[22].fcp), 2)) : String(fixNumber(Number(i[22].fcp), 1)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[22].tbf), 2)) : String(fixNumber(Number(i[22].tbf), 1))
                    },
                    total_more_year: {
                        tbc: String(fixNumber(Number(i[23].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[23].fcp), 2)) : String(fixNumber(Number(i[23].fcp), 1)),
                        tbf: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[23].tbf), 2)) : String(fixNumber(Number(i[23].tbf), 1))
                    }
                })
            })
        }

        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "tax_planning": data,
            "status": "submitted"
        }
        // console.log(JSON.stringify(payload));
        api.create().validateSubmitReport(payload).then((response) => {
            console.log(response)
            if (response.data) {
                if (response.data.data.result) {
                    this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
                    // alert("Type Input Can't be Empty")
                } else {
                    this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: 'Error 500', tipeAlert: 'warning' })
            }
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&currency_id=${this.props.defaultCurrency.id}`
        )
        console.log(res)
        res = await res.blob()
        console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Master Budget Tax Planning.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${this.props.submissionID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        let sub_null = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        // console.log(url);
        let res = await fetch(
            this.props.submissionID == null ? sub_null : url
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Master Budget Tax Planning.xlsx';
            a.click();
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        let dataTableData = this.state.dataTableData
        let dataFormula = []
        let id = 0
        let double = false
        const handleNewFormula = (tableMeta, dex, newFormula) => {
            let splitFormula = String(newFormula).split('@')
            let baru = []
            let anjay = []
            splitFormula.map((item) => {
                let re = /^[a-zA-Z0-9_]+$/;
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                // if (tableMeta.rowData[24] === 96) {
                //     console.log(item, items);
                // }
                if (item !== "") {
                    if (!re.test(items)) {
                        if (items === '(') {
                            baru.push(String(item).substr(0, Number(String(item).length) - 2))
                            baru.push(String(item).substr(Number(String(item).length) - 2, 1))
                            baru.push(items)
                        } else {
                            baru.push(subForm)
                            baru.push(items)
                        }
                    } else {
                        baru.push(String(item))
                    }
                }
            })
            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        let splitform = String(item).split('#')
                        if (splitform[1] == 'TP1' || splitform[1] == 'TP2' || splitform[1] == 'TP3') {
                            let indexID = dataTable2.findIndex((val) => val[24] == splitform[0])
                            if (indexID !== -1) {
                                let data = dataTable2[indexID][20].fcp
                                // console.log(dataTable2[indexID][20]);
                                // let data = splitform[1] == 'TP1' ? dataTable2[indexID][tableMeta.columnIndex].tbc : splitform[1] == 'TP2' ? dataTable2[indexID][tableMeta.columnIndex].fcp : dataTable2[indexID][tableMeta.columnIndex].tbf
                                // let valuezz = data.value == undefined ? data : data.value
                                anjay.push(data == "" ? 0 : data)
                            }
                        }
                        // else {
                        //     if (forecast !== undefined) {
                        //         forecast.map((item, index) => {
                        //             if (periode == item.periode) {
                        //                 totalShldBeNil += Number(item.value)
                        //             }
                        //         })
                        //         anjay.push(totalShldBeNil)
                        //     } else if (String(item).includes('[M-1]')) {
                        //         let tst = String(item).replace('[M-1]', '')
                        //         let data = tableMeta.columnIndex == 9 ? 20 : tableMeta.columnIndex - 1
                        //         let dataSub = dex == 1 ? tableMeta.rowData[data].tbc : dex == 2 ? tableMeta.rowData[data].fcp : tableMeta.rowData[data].tbf
                        //         let period = data == 20 ? Number(this.props.periode) - 1 : this.props.periode
                        //         let indexID = dataSub.formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                        //         if (indexID !== -1) {
                        //             let valuezz = tableMeta.rowData[data].formula[indexID].value
                        //             anjay.push(valuezz == "" ? 0 : valuezz)
                        //         }
                        //     } else {
                        //         let data = dex == 1 ? value.tbc : dex == 2 ? value.fcp : value.tbf
                        //         // console.log(data);
                        //         let indexID = data.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                        //         if (indexID !== -1) {
                        //             let valuezz = data.formula[indexID].value
                        //             anjay.push(valuezz == "" ? 0 : valuezz)
                        //         }
                        //     }
                        // }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[24] == item)
                        if (indexID !== -1) {
                            if (dataTable2[indexID][24] == tableMeta.rowData[24]) {
                                anjay.push(0)
                            } else {
                                let data = dataTable2[indexID][tableMeta.columnIndex]
                                // let data = dex == 1 ? dataTable2[indexID][tableMeta.columnIndex].tbc : dex == 2 ? dataTable2[indexID][tableMeta.columnIndex].fcp : dataTable2[indexID][tableMeta.columnIndex].tbf
                                // let valuezz = data == undefined ? data : data.value
                                anjay.push(data == "" ? 0 : data)
                            }

                        }
                    }
                }
            })
            let total = 0
            let total2 = 0
            let opt = ""
            let opt2 = ""
            let prio = false
            let simpen2 = ""
            anjay.map((item, index) => {
                if (item == "+") {
                    if (prio) {
                        opt2 = "tambah"
                    } else {
                        opt = "tambah"
                    }
                } else if (item == "-") {
                    if (prio) {
                        opt2 = "kurang"
                    } else {
                        opt = "kurang"
                    }
                } else if (item == "*") {
                    if (prio) {
                        opt2 = "kali"
                    } else {
                        opt = "kali"
                    }
                } else if (item == "/") {
                    if (prio) {
                        opt2 = "bagi"
                    } else {
                        opt = "bagi"
                    }
                } else if (item == "(") {
                    prio = true
                    simpen2 = "active"
                } else if (item == ")") {
                    prio = false
                }
                else {
                    if (prio) {
                        if (opt2 == "tambah") {
                            total2 = Number(total2) + Number(item)
                        } else if (opt2 == "kurang") {
                            total2 = Number(total2) - Number(item)
                        } else if (opt2 == "kali") {
                            total2 = Number(total2) * Number(item)
                        } else if (opt2 == "bagi") {
                            total2 = Number(total2) / Number(item) == NaN ? 0 : Number(total2) / Number(item)
                        } else {
                            total2 += Number(item)
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            if (simpen2 == "active") {
                if (opt == "tambah") {
                    total = Number(total) + Number(total2)
                } else if (opt == "kurang") {
                    total = Number(total) - Number(total2)
                } else if (opt == "kali") {
                    total = Number(total) * Number(total2)
                } else if (opt == "bagi") {
                    total = Number(total) / Number(total2) == NaN ? 0 : Number(total) / Number(total2)
                }
            }

            // console.log(tableMeta.rowData[8], baru, anjay, total);
            if (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX") {
                total = R.equals(total, NaN) ? "0.00" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 2) : Number(total)
                if (total < 0) {
                    total = 0
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
                    return total
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
                    return total
                }
            } else {
                total = R.equals(total, NaN) ? "0.0" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
                return total
            }
        }

        const handleValueFormula = (value, tableMeta, dex, xntd, forecast, periode) => {
            // console.log(xntd)
            // console.log(dex);
            let form = dex === 1 ? tableMeta.rowData[6].tbc : dex === 2 ? tableMeta.rowData[6].fcp : tableMeta.rowData[6].tbf
            let splitFormula = String(form).split('@')
            let baru = []
            let anjay = []
            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let re = /^[a-zA-Z0-9_]+$/;
                let asd = ''
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(String(item).substr(0, Number(String(item).length) - 1))
                        baru.push(String(item).substr(Number(String(item).length) - 1, 1))
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            // console.log(baru);

            // if (forecast !== undefined) {
            //     console.log(splitFormula)
            // }

            if (tableMeta.rowData[8] == "Under payment  /(Over Payment ) Income Tax Art.  29" || forecast !== undefined) {
                // form.replace("(", "")
                // form.replace(")", "")
                let opgab = []
                baru.map((item, index) => {
                    if (item.length > 1 && (item.includes("+") || item.includes("-") || item.includes("*") || item.includes("/"))) {
                        opgab.push(String(item).substr(0, Number(String(item).length) - 1))
                        opgab.push(String(item).substr(Number(String(item).length) - 1, 1))
                    } else {
                        opgab.push(item)
                    }
                })
                if (opgab.length > 0) {
                    baru = opgab
                }
            }

            let totalShldBeNil = 0
            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        let splitform = String(item).split('#')
                        if (splitform[1] == 'TP1' || splitform[1] == 'TP2' || splitform[1] == 'TP3') {
                            let indexID = dataTable2.findIndex((val) => val[24] == splitform[0])
                            if (indexID !== -1) {
                                let data = splitform[1] == 'TP1' ? dataTable2[indexID][tableMeta.columnIndex].tbc : splitform[1] == 'TP2' ? dataTable2[indexID][tableMeta.columnIndex].fcp : dataTable2[indexID][tableMeta.columnIndex].tbf
                                let valuezz = data?.value == undefined ? data : data.value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            if (forecast !== undefined) {
                                forecast.map((item, index) => {
                                    if (periode == item.periode) {
                                        totalShldBeNil += Number(item.value)
                                    }
                                })
                                anjay.push(totalShldBeNil)
                            } else if (String(item).includes('[M-1]')) {
                                let tst = String(item).replace('[M-1]', '')
                                let data = tableMeta.columnIndex == 9 ? 20 : tableMeta.columnIndex - 1
                                let dataSub = dex == 1 ? tableMeta.rowData[data].tbc : dex == 2 ? tableMeta.rowData[data].fcp : tableMeta.rowData[data].tbf
                                let period = data == 20 ? Number(this.props.periode) - 1 : this.props.periode
                                let indexID = dataSub.formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                                if (indexID !== -1) {
                                    let valuezz = tableMeta.rowData[data].formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            } else {
                                let data = dex == 1 ? value.tbc : dex == 2 ? value.fcp : value.tbf
                                // console.log(dex);
                                // console.log(value);
                                // console.log(data);
                                let indexID = data?.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = data?.formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[24] == item)
                        if (indexID !== -1) {
                            if (dataTable2[indexID][24] == tableMeta.rowData[24]) {
                                anjay.push(0)
                            } else {
                                let data = dex == 1 ? dataTable2[indexID][tableMeta.columnIndex].tbc : dex == 2 ? dataTable2[indexID][tableMeta.columnIndex].fcp : dataTable2[indexID][tableMeta.columnIndex].tbf
                                let valuezz = data.value == undefined ? data : data.value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }

                        }
                    }
                }
            })

            let total = 0
            let total2 = 0
            let opt = ""
            let opt2 = ""
            let prio = false
            let simpen2 = ""
            anjay.map((item, index) => {
                if (item == "+") {
                    if (prio) {
                        opt2 = "tambah"
                    } else {
                        opt = "tambah"
                    }
                } else if (item == "-") {
                    if (prio) {
                        opt2 = "kurang"
                    } else {
                        opt = "kurang"
                    }
                } else if (item == "*") {
                    if (prio) {
                        opt2 = "kali"
                    } else {
                        opt = "kali"
                    }
                } else if (item == "/") {
                    if (prio) {
                        opt2 = "bagi"
                    } else {
                        opt = "bagi"
                    }
                } else if (item == "(") {
                    prio = true
                    simpen2 = "active"
                } else if (item == ")") {
                    prio = false
                }
                else {
                    if (prio) {
                        if (opt2 == "tambah") {
                            total2 = Number(total2) + Number(item)
                        } else if (opt2 == "kurang") {
                            total2 = Number(total2) - Number(item)
                        } else if (opt2 == "kali") {
                            total2 = Number(total2) * Number(item)
                        } else if (opt2 == "bagi") {
                            total2 = Number(total2) / Number(item) == NaN ? 0 : Number(total2) / Number(item)
                        } else {
                            total2 += Number(item)
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            if (simpen2 == "active") {
                if (opt == "tambah") {
                    total = Number(total) + Number(total2)
                } else if (opt == "kurang") {
                    total = Number(total) - Number(total2)
                } else if (opt == "kali") {
                    total = Number(total) * Number(total2)
                } else if (opt == "bagi") {
                    total = Number(total) / Number(total2) == NaN ? 0 : Number(total) / Number(total2)
                }
            }

            if (tableMeta.rowData[8] == "Control (should be nil)") {
                total = R.equals(total, NaN) ? "0.0" : (Number(total))
                if (tableMeta.rowData[4] == 3163752 && tableMeta.columnIndex == 10) {
                    // console.log(total);
                }
            } else {
                total = R.equals(total, NaN) ? "0.0" : total
            }
            // if (tableMeta.rowData[8] == "Corporate Income Tax") {
            //     console.log(tableMeta.rowData[8])
            //             // console.log(splitFormula)
            //             console.log(xntd)
            //             console.log(baru)
            //             console.log(anjay)
            //             console.log(total)
            //             console.log(total2)
            //     }
            //     console.log(opt)
            // }

            // let dataSub = dex == 1? dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc : dex == 2? dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp : dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf
            if (dex == 1) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)
                }
            } else if (dex == 2) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)
                }
            } else {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)
                } else {
                    if (tableMeta.rowData[8] == "Corporate Income Tax") {
                        if (total < 0) {
                            total = 0
                            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)
                        } else {
                            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 2)
                        }
                    } else {
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)

                    }
                }
            }
            // if (tableMeta.rowData[8] == "Corporate Income Tax" && tableMeta.columnIndex == 9 && dex == 3) {
            //     console.log(total);
            //     console.log(Number(total).toFixed(1));
            // }

            return total
        }

        const handleForecast = (tableMeta, periode, dex) => {
            let total = 0
            let data = dex == 1 ? dataTable2[tableMeta.rowIndex][6].tbc : dex == 2 ? dataTable2[tableMeta.rowIndex][6].fcp : dataTable2[tableMeta.rowIndex][6].tbf
            let forecast = dex == 1 ? dataTable2[tableMeta.rowIndex][27] : dex == 2 ? dataTable2[tableMeta.rowIndex][28] : dataTable2[tableMeta.rowIndex][29]
            if (data.includes('#PL')) {
                if (tableMeta.rowData[8] == "Control (should be nil)") {
                    total = handleValueFormula(5, tableMeta, dex, data, forecast, periode)
                } else {
                    forecast.map((item, index) => {
                        if (periode == item.periode) {
                            total += Number(item.value)
                        }
                    })
                }
            } else {
                total = handleValueFormula(5, tableMeta, dex, data)
            }

            if (dex == 1) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = total
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value = total
                }
            } else if (dex == 2) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = total
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value = total
                }
            } else {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value == undefined) {
                    if (tableMeta.rowData[8] == "Corporate Income Tax") {
                        if (total < 0) {
                            total = 0
                            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(total)
                        } else {
                            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(total)
                        }
                    } else {
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(total)

                    }
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value = Number(total)

                }
            }

            return total
        }

        const handleChange = (value, tableMeta, indexChilds) => {
            if (tableMeta.rowData[8] == "Adjustment") {
                console.log(value)
            }
            let val = String(value).split(",").join("")
            // let data = this.state.dataTable2
            let indexParent = dataTable2.findIndex((val) => val[4] === dataTable2[tableMeta.rowIndex][5])
            // ini buat input untuk perhitungan parent nya
            if (indexParent > 0) {
                if (indexChilds == 1) {
                    let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = Number(val)
                    let jagain = dataTable2[indexParent][tableMeta.columnIndex].fcp
                    a = dataTable2[indexParent][tableMeta.columnIndex].fcp = jagain === undefined ? (0 + Number(val)) : (Number(jagain) + Number(val))
                }
            } else {
                if (indexChilds == 0) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = Number(val)
                }
                else if (indexChilds == 1) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = Number(val)
                }
                else if (indexChilds == 2) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(val)
                } else if (indexChilds == 3) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                }
            }
        }
        const handleTotalControl = (tableMeta, dex, periode) => {
            let total = 0
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index >= 9 && index <= 20) {
                    if (this.props.status === 'CLOSED') {
                        let indexChild = item.tbf
                        if (indexChild !== -1) {
                            total += Number(item.tbf)
                        }
                    } else {
                        let indexChild = item.tbf.formula.findIndex((val) => val.periode === periode)
                        if (indexChild !== -1) {
                            total += Number(item.tbf.formula[indexChild].value)
                        }
                        // console.log("masuk" + indexChild + "total :" + total)
                    }
                }
            })

            // console.log("DataTabel2 : " + Number(dataTable2[tableMeta.rowIndex][21]))
            // console.log("Number total: " + Number(total))
            // console.log("nilai : " + Number(dataTable2[88][21]))
            // console.log(JSON.stringify(tableMeta.tableData))

            let nilai = 0
            console.log(this.props.defaultCurrency.id)
            console.log(Number(dataTable2[tableMeta.rowIndex-9][21]))
            console.log(Number(dataTable2[tableMeta.rowIndex-10][21]))
            if (this.props.defaultCurrency.id == 1 ){
                nilai = Number(total) + Number(dataTable2[tableMeta.rowIndex-9][21])
            }else {
                nilai = Number(total) + Number(dataTable2[tableMeta.rowIndex-10][21])
            }
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = nilai
            // console.log("niali :" + Number(dataTable2[88][21]));
            return nilai
        }

        const handleTotal = (tableMeta, dex, periode) => {
            let total = 0
            let totalfcp = 0
            if (String(tableMeta.rowData[8]).toLowerCase() === "fiscal correction positive / (negative) year to date") {
                dataTable2[tableMeta.rowIndex - 2].map((item, index) => {
                    if (index >= 9 && index <= 20) {
                        if (dataTable2[tableMeta.rowIndex - 2][2] === 5 || dataTable2[tableMeta.rowIndex - 2][2] === 6 || dataTable2[tableMeta.rowIndex - 2][2] === 7) {
                            let valItem = item.fcp.value == undefined || item.fcp.value == "" || item.fcp.value == "undefined" ? 0.0 : item.fcp.value
                            total += Number(valItem)
                        } else {
                            let valItem = item.fcp == undefined || item.fcp == "" || item.fcp == "undefined" ? 0.0 : item.fcp
                            total += Number(valItem)
                        }
                    }
                })
            } else {
                dataTable2[tableMeta.rowIndex].map((item, index) => {
                    if (index >= 9 && index <= 20) {
                        if (tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 7) {
                            let valItem = item.tbf.value == undefined || item.tbf.value == "" || item.tbf.value == "undefined" ? 0.0 : item.tbf.value
                            total += Number(valItem)
                        } else {
                            let valItem = item.tbf == undefined || item.tbf == "" || item.tbf == "undefined" ? 0.0 : item.tbf
                            total += Number(valItem)
                        }
                    }
                })
            }

            dataTable2[tableMeta.rowIndex][21] = this.props.defaultCurrency.id == 2 ? Number(total) : fixNumber(Number(total), 1)
            return total
        }
        const handleValue = (data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[4] === item[5]) {
                    total = item[data.columnIndex] === undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex].fcp))
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[4] === dataTable2[data.rowIndex][5])
            let a = dataTable2[data.rowIndex][data.columnIndex].fcp = Number(total)
            return a
        }

        const handleFormula = (data, tableMeta, month, rowColumn) => {
            let rilFormula = String(rowColumn == 0 ? tableMeta.rowData[6].tbc : tableMeta.rowData[6].tbf)
            if (rilFormula.includes('#')) {
                if (this.props.status === "not-yet") {
                    let splitOrder = String(rowColumn == 0 ? tableMeta.rowData[6].tbc : tableMeta.rowData[6].tbf).split('@')
                    for (let index = 0; index < splitOrder.length; index++) {
                        if (splitOrder[index] === "") {
                        } else {
                            if (splitOrder[index].includes('#')) {

                            } else {
                                let splitOperator = splitOrder[index].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
                                let reg = /^\d+$/
                                splitOperator.map((item) => {
                                    if (reg.test(item) === true) {
                                        let i = dataTable2.findIndex((val) => val[24] == item)
                                        if (i > 0) {
                                            rilFormula = rilFormula.replace(item, dataTable2[i][tableMeta.columnIndex] === "" ? "0.0" : dataTable2[i][tableMeta.columnIndex])
                                        }
                                    }
                                })
                            }
                        }
                    }
                    let body = {
                        "submission_id": null,
                        "company_id": this.props.company.company_id,
                        "report_id": this.props.report_id,
                        "year": this.props.periode,
                        "month": month,
                        "formula": rilFormula
                    }
                    api.create().countingFormula(body).then(response => {
                        // console.log(response);
                    })
                } else {
                    let body = {
                        "submission_id": this.props.submissionID,
                        "company_id": this.props.company.company_id,
                        "report_id": this.props.report_id,
                        "year": this.props.periode,
                        "month": month,
                        "formula": rilFormula
                    }
                    api.create().countingFormula(body).then(response => {
                        if (response.data) {
                            if (response.data.status === "success") {
                                return response.data.data.result
                            }
                        }
                    })
                }
            } else {
                let kondisi = rowColumn == 0 ? tableMeta.rowData[6].tbc : tableMeta.rowData[6].tbf
                let arrayFormula = kondisi.match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
                let arrayJumlah = []
                arrayFormula.map((item, indexs) => {
                    let index = dataTable2.findIndex((val) => val[24] == item)
                    if (index > 0) {
                        arrayJumlah.push(dataTable2[index][tableMeta.columnIndex])
                    } else {
                        arrayJumlah.push(item)
                    }
                    // if (indexs % 2 !== 0) {
                    //     operator.push(item)
                    // }
                })
                let array = arrayJumlah
                let total = 0
                let opt = ""
                array.map((item, index) => {
                    if (item == "+") {
                        opt = "tambah"
                    } else if (item == "-") {
                        opt = "kurang"
                    } else if (item == "*") {
                        opt = "kali"
                    } else if (item == "/") {
                        opt = "bagi"
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item)
                        } else {
                            total += item
                        }
                    }
                })
                if (R.equals(Number(total), NaN)) {
                    total = { tbc: "", fcp: "", tbf: "" }
                } else {
                    total = Number(total)
                }
                let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
                return a
            }

        }

        const handleParent = (tableMeta, type) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (item[5] == tableMeta.rowData[4]) {
                    total += Number(type == 1 ?
                        item[tableMeta.columnIndex].tbc.value == undefined ? Number(item[tableMeta.columnIndex].tbc == "" || item[tableMeta.columnIndex].tbc == "0.0" ? 0 : item[tableMeta.columnIndex].tbc) : Number(item[tableMeta.columnIndex].tbc.value == "" || item[tableMeta.columnIndex].tbc.value == "0.0" ? 0 : item[tableMeta.columnIndex].tbc.value)
                        :
                        (type == 2 ?
                                item[tableMeta.columnIndex].fcp.value == undefined ? Number(item[tableMeta.columnIndex].fcp == "" || item[tableMeta.columnIndex].fcp == "0.0" ? 0 : item[tableMeta.columnIndex].fcp) : Number(item[tableMeta.columnIndex].fcp.value == "" || item[tableMeta.columnIndex].fcp.value == "0.0" ? 0 : item[tableMeta.columnIndex].fcp.value)
                                :
                                item[tableMeta.columnIndex].tbf.value == undefined ? Number(item[tableMeta.columnIndex].tbf == "" || item[tableMeta.columnIndex].tbf == "0.0" ? 0 : item[tableMeta.columnIndex].tbf) : Number(item[tableMeta.columnIndex].tbf.value == "" || item[tableMeta.columnIndex].tbf.value == "0.0" ? 0 : item[tableMeta.columnIndex].tbf.value)
                        )
                    )
                }
            })

            if (type == 1) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = total
            } else if (type == 2) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = total
            }
            return total
        }

        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {tableMeta.rowData[30] ?
                                tableMeta.rowData[30].length > 0 ?
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </LightTooltip>
                                    </div>
                                    :
                                    tableMeta.rowData[7] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[7]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                :
                                tableMeta.rowData[7] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[7]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Commercial) MTD"}</span>
                            </div>
                            <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Fiscal Correction Positive /(Negative)"}</span>
                            </div>
                            <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {
                                            this.props.status === 'CLOSED' ?
                                                tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                    null
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                                :
                                                tableMeta.rowData[1] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    decimalSeparator={"."}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                    value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                    onBlur={(event) => {
                                                                        // updateValue(event.target.value)
                                                                        handleChange(event.target.value, tableMeta, 0)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[1] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[1] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[1] === 6 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                />
                                                                :
                                                                tableMeta.rowData[1] === 5 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 1 ?
                                                                        // value[0] === "" ?
                                                                        //     null :
                                                                        //     <NumberFormat
                                                                        //         thousandSeparator={true}
                                                                        //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        //         type="text"
                                                                        //         placeholder=""
                                                                        //         disabled={true}
                                                                        //         value={Number(value[0])}
                                                                        //     />
                                                                        null
                                                                        :
                                                                        tableMeta.rowData[1] === 7 ?
                                                                            (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'black'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                /> :
                                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'red'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    />
                                                                                </LightTooltip>
                                                                            :
                                                                            null
                                        }
                                    </div>
                                </div>
                                <div className="col-2">
                                    <div style={{ textAlign: 'right' }}>
                                        {
                                            this.props.status === 'CLOSED' ?
                                                tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                    null
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                                :
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[0] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        // disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                                />
                                                            </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                        }
                                    </div>
                                </div>
                                <div className="col-3">
                                    <div style={{ textAlign: 'right' }}>
                                        {
                                            this.props.status === 'CLOSED' ?
                                                tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                    null
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                                :
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[0] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                                />
                                                            </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Feb ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Commercial) MTD"}</span>
                            </div>
                            <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Fiscal Correction Positive /(Negative)"}</span>
                            </div>
                            <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {
                                            this.props.status === 'CLOSED' ?
                                                tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                    null
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                                :
                                                tableMeta.rowData[1] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                    value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                    onBlur={(event) => {
                                                                        // updateValue(event.target.value)
                                                                        handleChange(event.target.value, tableMeta, 0)

                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[1] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[1] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[1] === 6 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                />
                                                                :
                                                                tableMeta.rowData[1] === 5 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 1 ?
                                                                        // value[0] === "" ?
                                                                        //     null :
                                                                        //     <NumberFormat
                                                                        //         thousandSeparator={true}
                                                                        //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        //         type="text"
                                                                        //         placeholder=""
                                                                        //         disabled={true}
                                                                        //         value={Number(value[0])}
                                                                        //     />
                                                                        null
                                                                        :
                                                                        tableMeta.rowData[1] === 7 ?
                                                                            (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'black'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                /> :
                                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'red'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    />
                                                                                </LightTooltip>
                                                                            :
                                                                            null
                                        }
                                    </div>
                                </div>
                                <div className="col-2">
                                    <div style={{ textAlign: 'right' }}>
                                        {
                                            this.props.status === 'CLOSED' ?
                                                tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                    null
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                                :
                                                tableMeta.rowData[2] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 1)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[2] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[2] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[2] === 6 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                />
                                                                :
                                                                tableMeta.rowData[2] === 5 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 1 ?
                                                                        // value[1] === "" ?
                                                                        //     null :
                                                                        //     <NumberFormat
                                                                        //         thousandSeparator={true}
                                                                        //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        //         type="text"
                                                                        //         placeholder=""
                                                                        //         disabled={true}
                                                                        //         value={Number(value.fcp)}
                                                                        //     />
                                                                        null
                                                                        :
                                                                        tableMeta.rowData[2] === 7 ?
                                                                            (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'black'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                /> :
                                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'red'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    />
                                                                                </LightTooltip>
                                                                            :
                                                                            null
                                        }
                                    </div>
                                </div>
                                <div className="col-3">
                                    <div style={{ textAlign: 'right' }}>
                                        {
                                            this.props.status === 'CLOSED' ?
                                                tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                    null
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                                :
                                                tableMeta.rowData[3] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                    value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 2)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[3] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[3] === 4 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[3] === 6 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[3] === 5 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={false}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 1 ?
                                                                        // value[2] === "" ?
                                                                        //     null :
                                                                        //     <NumberFormat
                                                                        //         thousandSeparator={true}
                                                                        //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        //         type="text"
                                                                        //         placeholder=""
                                                                        //         disabled={true}
                                                                        //         value={Number(value[2])}
                                                                        //     />
                                                                        null
                                                                        :
                                                                        tableMeta.rowData[3] === 7 ?
                                                                            (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'black'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                /> :
                                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'red'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    />
                                                                                </LightTooltip>
                                                                            :
                                                                            null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        },
            {
                name: `Mar ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={Number(value.tbc)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Apr ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `May ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>

                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Jun ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Jul ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Aug ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Sep ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>

                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Oct ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Nov ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Dec ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[1] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[2] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2)) : (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1))}
                                                                    />
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={false}
                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 3)),  1) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                            <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal)"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        // console.log(dataTable2);
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    {/* <div className="col-1"> */}
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[8] == "Tax Loss Carry Forward" ||
                                        tableMeta.rowData[8] === "Adjustment" ||
                                        tableMeta.rowData[8] === "Inc Tax Art 22" ||
                                        tableMeta.rowData[8] === "Inc Tax Art 23" ||
                                        tableMeta.rowData[8] === "Inc Tax Art 24" ||
                                        tableMeta.rowData[8] === "Inc Tax Art 25"
                                            ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder="input"
                                                            disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                            value={this.props.status === 'CLOSED' ? fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1) :fixNumber(Number(value), 12) == 0 ? "0.0" : fixNumber(Number(value), 12)}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta, 3)
                                                                // console.log(dataTable2)
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            tableMeta.rowData[8] === "Income Before Tax (NPBT)" ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder="input"
                                                                disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleNewFormula(tableMeta, 3, "@11-@13-@35+@53+@60")), 1) == 0 ? "0.0" : fixNumber(Number(handleNewFormula(tableMeta, 3, "@11-@13-@35+@53+@60")), 1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[8] === "Taxable Income" ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                    value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleNewFormula(tableMeta, 3, "@77-@81")), 1) ==0 ? "0.0" : fixNumber(Number(handleNewFormula(tableMeta, 3, "@77-@81")), 1))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    tableMeta.rowData[8] === "Corporate Income Tax" ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 2) == 0 ? "0.0" : fixNumber(Number(value), 2)) : (fixNumber(Number(handleNewFormula(tableMeta, 3, "@83*@87#TP2")), 2) == 0 ? "0.0" : fixNumber(Number(handleNewFormula(tableMeta, 3, "@83*@87#TP2")), 2))}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                                        :
                                                        tableMeta.rowData[8] === "Corporate Income Tax  after adjustment" ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder="input"
                                                                            disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                            value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleNewFormula(tableMeta, 3, "@87+@88")), 1) == 0 ? "0.0" : fixNumber(Number(handleNewFormula(tableMeta, 3, "@87+@88")), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                            :
                                                            tableMeta.rowData[8] === "Under payment  /(Over Payment ) Income Tax Art.  29" ?
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={value}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder="input"
                                                                                disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                                value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleNewFormula(tableMeta, 3, "@89-(@92+@93+@94+@95)")), 1) == 0 ? "0.0" : fixNumber(Number(handleNewFormula(tableMeta, 3, "@89-(@92+@93+@94+@95)")), 1))}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                                :
                                                                tableMeta.rowData[8] === "Control (should be nil)" ?
                                                                    (Number(this.props.status === 'CLOSED' ? fixNumber(Number(value), 1) : fixNumber(handleTotalControl(tableMeta, 1, this.props.periode), 1)) >= Number(this.state.minValue) && Number(this.props.status === 'CLOSED' ? fixNumber(Number(value), 1) : fixNumber(handleTotalControl(tableMeta, 1, this.props.periode), 1)) <= Number(this.state.maxValue)) ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: 'black', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotalControl(tableMeta, 1, this.props.periode)), 1) == 0 ?"0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleTotalControl(tableMeta, 1, this.props.periode)), 11) : fixNumber(Number(handleTotalControl(tableMeta, 1, this.props.periode)), 12))}
                                                                        /> :
                                                                        <LightTooltip title={this.state.minValue === null ? `Value Should be 0` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', color: 'red' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotalControl(tableMeta, 1, this.props.periode)), 1) == 0 ?"0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleTotalControl(tableMeta, 1, this.props.periode)), 11) : fixNumber(Number(handleTotalControl(tableMeta, 1, this.props.periode)), 12))}
                                                                            />
                                                                        </LightTooltip>

                                                                    :
                                                                    String(tableMeta.rowData[8]).toLowerCase() === "fiscal correction positive / (negative) year to date" ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotal(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta, 1)), 1))}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 3 ?
                                                                            <div style={{ flex: 1 }}>
                                                                                <FormControlLabel
                                                                                    style={{ margin: 0 }}
                                                                                    value={value}
                                                                                    control={
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                            type="text"
                                                                                            placeholder="input"
                                                                                            disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                                            value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotal(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta, 3)), 1))}
                                                                                        />
                                                                                    }
                                                                                />
                                                                            </div> :
                                                                            tableMeta.rowData[3] === 2 ?
                                                                                <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotal(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta, 2)), 1))}
                                                                                />
                                                                            </span>
                                                                                :
                                                                                tableMeta.rowData[3] === 4 ?
                                                                                    null
                                                                                    :
                                                                                    tableMeta.rowData[3] === 6 ?
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotal(tableMeta, 6)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta, 6)), 1))}
                                                                                        />
                                                                                        :
                                                                                        tableMeta.rowData[3] === 5 ?
                                                                                            <NumberFormat
                                                                                                thousandSeparator={true}
                                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                                type="text"
                                                                                                placeholder=""
                                                                                                disabled={true}
                                                                                                value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotal(tableMeta, 5)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta, 5)), 1))}
                                                                                            />
                                                                                            :
                                                                                            tableMeta.rowData[3] === 1 ?
                                                                                                null
                                                                                                :
                                                                                                tableMeta.rowData[3] === 7 ?
                                                                                                    (Number(this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : handleTotal(tableMeta, 1)) >= Number(this.state.minValue) && Number(this.props.status === 'CLOSED' ? fixNumber(Number(value), 1) : handleTotal(tableMeta, 1)) <= Number(this.state.maxValue)) ?
                                                                                                        <NumberFormat
                                                                                                            thousandSeparator={true}
                                                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                                            type="text"
                                                                                                            placeholder=""
                                                                                                            disabled={true}
                                                                                                            value={this.props.status === 'CLOSED' ? (fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)) : (fixNumber(Number(handleTotal(tableMeta, 1, this.props.periode)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta, 1, this.props.periode)), 1))}
                                                                                                        /> :
                                                                                                        <LightTooltip title={this.state.minValue === null ? `Value Should be 0` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                                            <NumberFormat
                                                                                                                thousandSeparator={true}
                                                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', color: 'red' }}
                                                                                                                type="text"
                                                                                                                placeholder=""
                                                                                                                disabled={true}
                                                                                                                value={fixNumber(Number(handleTotal(tableMeta, 1, this.props.periode)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta, 1, this.props.periode)), 1)}
                                                                                                            />
                                                                                                        </LightTooltip>
                                                                                                    :
                                                                                                    null
                                        }
                                    </div>
                                    {/* </div> */}
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `${Number(this.props.periode) + 1}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) YTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) YTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 1)), 1)}
                                                                    />
                                                                    // null
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 1)), 1)}
                                                                        />
                                                                        // null
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            // tableMeta.rowData[1] === 7 ?
                                                                            //     Number(handleValueFormula(value, tableMeta, 1)).toFixed(1) === Number(tableMeta.rowData[25].tbc === "" ? "0.0" : tableMeta.rowData[25].tbc).toFixed(1) ?
                                                                            //         <NumberFormat
                                                                            //             thousandSeparator={true}
                                                                            //             style={{
                                                                            //                 fontSize: 12,
                                                                            //                 textAlign: 'right',
                                                                            //                 borderColor: 'transparent',
                                                                            //                 margin: 0,
                                                                            //                 width: 96,
                                                                            //                 backgroundColor: 'transparent',
                                                                            //                 color: 'black'
                                                                            //             }}
                                                                            //             type="text"
                                                                            //             placeholder=""
                                                                            //             disabled={true}
                                                                            //             value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                            //         /> : tableMeta.rowData[26].tbc === "STOPPER" ?
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip> :
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip>
                                                                            //     :
                                                                            null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 2)), 1)}
                                                                    />
                                                                    // null
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            // tableMeta.rowData[2] === 7 ?
                                                                            //     Number(handleValueFormula(value, tableMeta, 2)).toFixed(1) === Number(tableMeta.rowData[25].fcp === "" ? "0.0" : tableMeta.rowData[25].fcp).toFixed(1) ?
                                                                            //         <NumberFormat
                                                                            //             thousandSeparator={true}
                                                                            //             style={{
                                                                            //                 fontSize: 12,
                                                                            //                 textAlign: 'right',
                                                                            //                 borderColor: 'transparent',
                                                                            //                 margin: 0,
                                                                            //                 width: 96,
                                                                            //                 backgroundColor: 'transparent',
                                                                            //                 color: 'black'
                                                                            //             }}
                                                                            //             type="text"
                                                                            //             placeholder=""
                                                                            //             disabled={true}
                                                                            //             value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                            //         /> : tableMeta.rowData[26].fcp === "STOPPER" ?
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip> :
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip>
                                                                            //     :
                                                                            null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            tableMeta.rowData[3] === 7 ?
                                                                (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'black'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={value.tbf}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 2)) : (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1))}
                                                                    />
                                                                    // null
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 2)) : (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1))}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)),1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)),1) : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)),1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)),1) : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 1, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `${Number(this.props.periode) + 2}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#37b5e6', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) YTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) YTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {

                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[1] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbc}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbc), 1) == 0 ? "0.0" : fixNumber(Number(value.tbc), 1)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 0)
                                                                            // console.log(event.target.value)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[1] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 1)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[1] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[1] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 1)), 1)}
                                                                    />
                                                                    // null
                                                                    :
                                                                    tableMeta.rowData[1] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 1)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[1] === 1 ?
                                                                            // value[0] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[0])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            // tableMeta.rowData[1] === 7 ?
                                                                            //     Number(handleValueFormula(value, tableMeta, 1)).toFixed(1) === Number(tableMeta.rowData[25].tbc === "" ? "0.0" : tableMeta.rowData[25].tbc).toFixed(1) ?
                                                                            //         <NumberFormat
                                                                            //             thousandSeparator={true}
                                                                            //             style={{
                                                                            //                 fontSize: 12,
                                                                            //                 textAlign: 'right',
                                                                            //                 borderColor: 'transparent',
                                                                            //                 margin: 0,
                                                                            //                 width: 96,
                                                                            //                 backgroundColor: 'transparent',
                                                                            //                 color: 'black'
                                                                            //             }}
                                                                            //             type="text"
                                                                            //             placeholder=""
                                                                            //             disabled={true}
                                                                            //             value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                            //         /> : tableMeta.rowData[26].tbc === "STOPPER" ?
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip> :
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip>
                                                                            //     :
                                                                            null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    :
                                                    tableMeta.rowData[2] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.fcp}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.fcp), 2) == 0 ? "0.0" : fixNumber(Number(value.fcp), 2)) : (fixNumber(Number(value.fcp), 1) == 0 ? "0.0" : fixNumber(Number(value.fcp), 1))}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 1)
                                                                            // console.log(dataTable2)

                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[2] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 2)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[2] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[2] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 2)), 1)}
                                                                    />
                                                                    // null
                                                                    :
                                                                    tableMeta.rowData[2] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 2)), 1)}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[2] === 1 ?
                                                                            // value[1] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value.fcp)}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            // tableMeta.rowData[2] === 7 ?
                                                                            //     Number(handleValueFormula(value, tableMeta, 2)).toFixed(1) === Number(tableMeta.rowData[25].fcp === "" ? "0.0" : tableMeta.rowData[25].fcp).toFixed(1) ?
                                                                            //         <NumberFormat
                                                                            //             thousandSeparator={true}
                                                                            //             style={{
                                                                            //                 fontSize: 12,
                                                                            //                 textAlign: 'right',
                                                                            //                 borderColor: 'transparent',
                                                                            //                 margin: 0,
                                                                            //                 width: 96,
                                                                            //                 backgroundColor: 'transparent',
                                                                            //                 color: 'black'
                                                                            //             }}
                                                                            //             type="text"
                                                                            //             placeholder=""
                                                                            //             disabled={true}
                                                                            //             value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                            //         /> : tableMeta.rowData[26].fcp === "STOPPER" ?
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip> :
                                                                            //             <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            //                 <NumberFormat
                                                                            //                     thousandSeparator={true}
                                                                            //                     style={{
                                                                            //                         fontSize: 12,
                                                                            //                         textAlign: 'right',
                                                                            //                         borderColor: 'transparent',
                                                                            //                         margin: 0,
                                                                            //                         width: 96,
                                                                            //                         backgroundColor: 'transparent',
                                                                            //                         color: 'red'
                                                                            //                     }}
                                                                            //                     type="text"
                                                                            //                     placeholder=""
                                                                            //                     disabled={true}
                                                                            //                     value={fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1)}
                                                                            //                 />
                                                                            //             </LightTooltip>
                                                                            //     :
                                                                            null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right' }}>
                                            {
                                                this.props.status === 'CLOSED' ?
                                                    tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                        null
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            tableMeta.rowData[3] === 7 ?
                                                                (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'black'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={value.tbf}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(value.tbf), 2) == 0 ? "0.0" : fixNumber(Number(value.tbf), 2)) : (fixNumber(Number(value.tbf), 1) == 0 ? "0.0" : fixNumber(Number(value.tbf), 1))}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                    :
                                                    tableMeta.rowData[3] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value.tbf}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder="input"
                                                                        disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                                        value={fixNumber(Number(value.tbf), 12) == 0 ? "0.0" : fixNumber(Number(value.tbf), 12)}
                                                                        onBlur={(event) => {
                                                                            // updateValue(event.target.value)
                                                                            handleChange(event.target.value, tableMeta, 2)
                                                                            // console.log(dataTable2)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[3] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(handleParent(tableMeta, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta, 3)), 1)}
                                                            />
                                                        </span>
                                                            :
                                                            tableMeta.rowData[3] === 4 ?
                                                                null
                                                                :
                                                                tableMeta.rowData[3] === 6 ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 2)) : (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1))}
                                                                    />
                                                                    // null
                                                                    :
                                                                    tableMeta.rowData[3] === 5 ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 2) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 2)) : (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1))}
                                                                        />
                                                                        :
                                                                        tableMeta.rowData[3] === 1 ?
                                                                            // value[2] === "" ?
                                                                            //     null :
                                                                            //     <NumberFormat
                                                                            //         thousandSeparator={true}
                                                                            //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            //         type="text"
                                                                            //         placeholder=""
                                                                            //         disabled={true}
                                                                            //         value={Number(value[2])}
                                                                            //     />
                                                                            null
                                                                            :
                                                                            tableMeta.rowData[3] === 7 ?
                                                                                (fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                                    <NumberFormat
                                                                                        thousandSeparator={true}
                                                                                        style={{
                                                                                            fontSize: 12,
                                                                                            textAlign: 'right',
                                                                                            borderColor: 'transparent',
                                                                                            margin: 0,
                                                                                            width: 96,
                                                                                            backgroundColor: 'transparent',
                                                                                            color: 'black'
                                                                                        }}
                                                                                        type="text"
                                                                                        placeholder=""
                                                                                        disabled={true}
                                                                                        value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 12)}
                                                                                    /> :
                                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                        <NumberFormat
                                                                                            thousandSeparator={true}
                                                                                            style={{
                                                                                                fontSize: 12,
                                                                                                textAlign: 'right',
                                                                                                borderColor: 'transparent',
                                                                                                margin: 0,
                                                                                                width: 96,
                                                                                                backgroundColor: 'transparent',
                                                                                                color: 'red'
                                                                                            }}
                                                                                            type="text"
                                                                                            placeholder=""
                                                                                            disabled={true}
                                                                                            value={fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 12) == 0 ? "0.0" : this.props.defaultCurrency.id === 1 ? fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 1) : fixNumber(Number(handleForecast(tableMeta, Number(this.props.periode) + 2, 3)), 12)}
                                                                                        />
                                                                                    </LightTooltip>
                                                                                :
                                                                                null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Master Budget Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {/* {this.state.loading && loadingComponent} */}
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleTP === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Master Budget - Tax Planning</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                            {this.state.dataTable.length == 0 ? null : this.props.isApprover == true ?
                                                null
                                                // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                //     <a data-tip={'Download'} data-for="download">
                                                //         <button
                                                //             style={{
                                                //                 backgroundColor: 'transparent',
                                                //                 cursor: 'pointer',
                                                //                 borderColor: 'transparent',
                                                //                 margin: 5
                                                //             }}
                                                //             onClick={() =>
                                                //                 this.setState({ loading: true }, () => {
                                                //                     setTimeout(() => {
                                                //                         this.downloadAllData()
                                                //                     }, 100);
                                                //                 })}
                                                //         >
                                                //             <img src={Images.download} />
                                                //         </button>
                                                //     </a>
                                                //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                                // </div>
                                                :
                                                <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                    {((!this.props.truelyApprover) && (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && (
                                                        <div>
                                                            <a data-tip={'Download Template'} data-for="template">
                                                                <button
                                                                    style={{
                                                                        backgroundColor: 'transparent',
                                                                        cursor: 'pointer',
                                                                        borderColor: 'transparent',
                                                                        margin: 5
                                                                    }}
                                                                    onClick={() => this.downloadTemplate()}
                                                                >
                                                                    <img src={Images.template} />
                                                                </button>
                                                            </a>
                                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                        </div>
                                                    )}
                                                    {((!this.props.truelyApprover) && (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) && (
                                                        <div>
                                                            <a data-tip={'Upload'} data-for="upload">
                                                                <button
                                                                    style={{
                                                                        backgroundColor: 'transparent',
                                                                        cursor: 'pointer',
                                                                        borderColor: 'transparent',
                                                                        margin: 5
                                                                    }}
                                                                    onClick={() => this.setState({ visibleUpload: true })}
                                                                >
                                                                    <img src={Images.upload} />
                                                                </button>
                                                            </a>
                                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                        </div>
                                                    )}
                                                    {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                    return (
                                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                    )
                                                }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                    (!this.props.truelyApprover) && (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ?
                                        <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => {
                                                    this.setState({ loading: true, buttonDraft: false }, () => {
                                                        setTimeout(() => {
                                                            // this.setState({ loading: false, buttonError: false, editable: true })
                                                            this.handleValidate()
                                                        }, 100);
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                                </div>
                                            </button>
                                            <button
                                                className="button"
                                                type="button"
                                                onClick={() =>
                                                    this.state.saveDraft === true ?
                                                        null :
                                                        this.state.handleDoubleClick == 1 ? null :
                                                            this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.backToMasterBudget('draft')
                                                                }, 100);
                                                            })
                                                }
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.saveDraft !== true ? 'pointer' : 'default',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                                </div>
                                            </button>
                                            <button
                                                type="button"
                                                disabled={this.state.buttonError}
                                                onClick={() => this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            setTimeout(() => {
                                                                this.backToMasterBudget('submitted')
                                                            }, 100);
                                                        })}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none'
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 20 }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                                </div>
                                            </button>
                                        </div>
                                        : null
                                }
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1">
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visibleTP: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                // this.forceUpdate()
                                                this.setState({ loading: true, buttonDraft: false }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.saveDraft !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => this.state.saveDraft === true ?
                                                null
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadTP('draft')
                                                        }, 100);
                                                    })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                            onClick={() => this.state.editable === true ?
                                                null
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadTP('submitted')
                                                        }, 100);
                                                    })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>
                    }
                </div>

                {
                    this.state.visibleUpload && (
                        <div className="test app-popup-show">
                            <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                                <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                    <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                        <div className="popup-title">
                                            <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                        </div>
                                    </div>
                                    <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                        <button
                                            type="button"
                                            className="btn btn-circle btn-white"
                                            onClick={() => this.setState({ visibleUpload: false })}
                                        >
                                            <img src={Images.close} />
                                        </button>
                                    </div>
                                </div>
                                <div style={{ padding: '25px 30px' }}>
                                    <UploadFile
                                        type={this.state.uploadStatus}
                                        percentage={this.state.percentage}
                                        result={this.state.result}
                                        acceptedFiles={["xlsx"]}
                                        onHandle={(dt) => {
                                            this.fileHandler(dt)
                                            this.setState({ uploadStatus: 'idle', percentage: '0' })
                                        }}
                                        onUpload={() => {
                                            String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("BUDGET") && String(this.state.judul).includes("TAX") && String(this.state.judul).includes("PLANNING") ?
                                                this.checkUpload() :
                                                this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                        }}
                                    />
                                </div>
                                <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>

                            </div>
                        </div>
                    )
                }

                {
                    this.state.visibleAlertSave && (
                        <div className="test app-popup-show">
                            <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                                <div style={{ margin: 30 }}>
                                    <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                        <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                           