import React, { Component } from 'react';
import { TextField, Typography } from '@material-ui/core';
import Autocomplete from '@material-ui/lab/Autocomplete';
import api from '../../../api';
import { DatePicker } from '@material-ui/pickers';
import { format } from 'date-fns';
import * as R from 'ramda'
import Images from '../../../assets/Images';
import Constant from '../../../library/Constant';
import PopUpInformation from '../../../library/PopUpInformation';
import { fixNumber, roundMath } from '../../../library/Utils';

export default class CreateParameter extends Component {
    constructor(props) {
        super(props)
        this.state = {
            enableParameter: false,
            enableReportName: false,
            enableFormat: false,
            enableThreshold: false,
            id: '',
            description: '',
            value: '',
            order: null,
            minValue: '',
            maxValue: '',
            startDate: '',
            endDate: null,
            date: new Date(),
            approvedBy: null,
            getApprovedBy: null,
            types: null,
            getTypes: null,
            perusahaan: null,
            reportName: null,
            formatCurrency: null,
            thresholdCurrency: null,
            getReportName: null,
            getFormatData: null,
            getThresholdCurrency: null,
            getPerusahaan: null,
            parameter: null,
            getParameter: null,
            operators: null,
            getOperators: null,
            tempData: null,
            tesValue: null,
            errorParameter: false,
            errorDeskripsi: false,
            errorReportName: false,
            errorFormatValue: false,
            errorThresholdCurrency: false,
            errorValue: false,
            errorMinValue: false,
            errorOrder: false,
            errorMaxValue: false,
            errorStartDate: false,
            errorEndDate: false,
            errorGroup: false,
            errorPerusahaan: false,
            msgErrorPerusahaan: '',
            msgErrorGroup: '',
            msgErrorParameter: '',
            msgErrorDeskripsi: '',
            msgErrorReportName: '',
            msgErrorFormatValue: '',
            msgErrorThresholdCurrency: '',
            msgErrorValue: '',
            msgErrorMinValue: '',
            msgErrorOrder: '',
            msgErrorMaxValue: '',
            msgErrorStartDate: '',
            msgErrorEndDate: '',
            regexValue: "",
            valueLength: "",
            minMaxRegex: "",
            minLength: "",
            maxLength: "",
            visiblePopupInformation: false,
        }
    }

    componentDidMount() {
        if (this.props.type === 'edit') {
            this.getDetailParameter()
        } else {
            let date = format(new Date, 'yyyy-MM-dd')
            this.setState({
                startDate: date,
                endDate: date
            })
            this.getDataGroup()
            this.getDataPerusahaan()
            this.getDataReportName()
            this.getDataFormat()
            this.getDataCurrencyThreshold()
        }
    }

    getDetailParameter() {
        api.create().getDetailParameter(this.props.data[0]).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        this.setState({
                            tempData: response.data.data,
                            getSettingGroupID: response.data.data.setting_group_id,
                            getCompanyID: data.company_id,
                            settingType: data.setting_type,
                            getSettingTypeID: data.setting_type_id,
                            typeReport: data.setting_type_name,
                            getTypeReportID: data.setting_type_id,
                            enableReportName: data.setting_group === "CURRENCY" ? true : false,
                            enableFormat: data.setting_group === "CURRENCY_MONEY_FORMAT" ? true : false,
                            enableThreshold: data.setting_group === "THRESHOLD_CONTROL" ? true : false,
                            tesValue: response.data.data.setting_group === "CURRENCY" ? Number(response.data.data.value) * 1000 : response.data.data.value

                        }, () => {
                            this.getAllGroup()
                            this.getPerusahaan()
                            this.getReport()
                            this.getFormat()
                            this.getCurrencyByThreshold()
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getAllGroup() {
        api.create().getAllGroup().then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                setting_group_id: item.setting_group_id,
                                setting_group_name: item.setting_group_name
                            }
                        })
                        let index = typeData.findIndex((val) => val.setting_group_id == this.state.getSettingGroupID)
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.setting_group_name,
                        };
                        this.setState({ types: typeProps, typeData: response.data.data, getTypes: index == -1 ? typeData[0] : typeData[index] }, () => {
                            this.getParameterByGroup(this.state.getTypes.setting_group_id, this.state.getTypes.setting_group_name)
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getPerusahaan() {
        api.create().getPerusahaanActive().then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let perusahaanData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name
                            }
                        })
                        perusahaanData.push({
                            company_id: 0,
                            company_name: 'Default'
                        })
                        let index = perusahaanData.sort((a, b) => a.company_id - b.company_id).findIndex((val) => val.company_id == this.state.getCompanyID)
                        let typeProps = {
                            options: perusahaanData,
                            getOptionLabel: (option) => option.company_name,
                        };
                        this.setState({ perusahaan: typeProps, perusahaanData: response.data.data, getPerusahaan: index == -1 ? null : perusahaanData[index], msgErrorPerusahaan: index === -1 ? 'Company has been Inactive' : "", errorPerusahaan: index === -1 ? true : false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getReport() {
        api.create().getDataReport().then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let reportData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let index = reportData.findIndex((val) => val.setting_type_id == this.state.tempData.reference_id)
                        let reportProps = {
                            options: reportData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ reportName: reportProps, reportData: response.data.data, getReportName: index == -1 ? reportData[0] : reportData[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getFormat() {
        api.create().getFormatValue().then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let formatData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let index = formatData.findIndex((val) => val.setting_type_id == this.state.tempData.reference_id)
                        let formatProps = {
                            options: formatData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ formatCurrency: formatProps, formatData: response.data.data, getFormatData: index == -1 ? formatData[0] : formatData[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getCurrencyByThreshold() {
        api.create().getThreshold().then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let currencyData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let index = currencyData.findIndex((val) => val.setting_type_id == this.state.tempData.reference_id)
                        let currencyProps = {
                            options: currencyData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ thresholdCurrency: currencyProps, currencyData: response.data.data, getThresholdCurrency: index == -1 ? currencyData[0] : currencyData[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getDataGroup() {
        api.create().getAllGroup().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                setting_group_id: item.setting_group_id,
                                setting_group_name: item.setting_group_name
                            }
                        })
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.setting_group_name,
                        };
                        this.setState({ types: typeProps, typeData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getDataPerusahaan() {
        api.create().getPerusahaanActive().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name
                            }
                        })
                        typeData.push({
                            company_id: 0,
                            company_name: 'Default'
                        })
                        let typeProps = {
                            options: typeData.sort((a, b) => a.company_id - b.company_id),
                            getOptionLabel: (option) => option.company_name,
                        };
                        this.setState({ perusahaan: typeProps, perusahaanData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getParameterByGroup(id, name) {
        if (name === "CURRENCY") {
            this.setState({ enableReportName: true, enableFormat: false, enableThreshold: false })
        } else if (name === "CURRENCY_MONEY_FORMAT") {
            this.setState({ enableFormat: true, enableReportName: false, enableThreshold: false })
        } else if (name === "THRESHOLD_CONTROL") {
            this.setState({ enableThreshold: true, enableFormat: false, enableReportName: false })
        } else {
            this.setState({ enableReportName: false, enableFormat: false, enableThreshold: false })
        }
        api.create().getParameterByGroup(id).then(response => {
            // console.log(id, response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let index = typeData.findIndex((val) => val.setting_type_id == this.state.getSettingTypeID)
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ enableParameter: true, parameter: typeProps, parameterData: response.data.data, getParameter: index == -1 ? null : typeData[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getDataReportName() {
        api.create().getDataReport().then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let reportData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let reportProps = {
                            options: reportData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ reportName: reportProps, reportData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
        // let reportData = [
        //     {
        //         "type_report_id": 1,
        //         "report_name": "Master Budget"
        //     },
        //     {
        //         "type_report_id": 2,
        //         "report_name": "Monthly Report"
        //     },
        //     {
        //         "type_report_id": 3,
        //         "report_name": "Rolling Outlook"
        //     },
        //     {checkUpload
        //         "type_report_id": 4,
        //         "report_name": "Outlook PA"
        //     },
        //     {
        //         "type_report_id": 5,
        //         "report_name": "Operating Indicator"
        //     }
        // ]

        // let reportProps = {
        //     options: reportData.sort((a, b) => a.report_id - b.report_id),
        //     getOptionLabel: (option) => option.report_name,
        // };
        // this.setState({ reportName: reportProps })
    }

    getDataFormat() {
        api.create().getFormatValue().then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let formatData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let formatProps = {
                            options: formatData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ formatCurrency: formatProps, formatData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getDataCurrencyThreshold() {
        api.create().getThreshold().then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let currencyData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let currencyProps = {
                            options: currencyData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ thresholdCurrency: currencyProps, currencyData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({
                ...data, tempData: { ...this.state.tempData, start_date: format(e, 'yyyy-MM-dd'), end_date: null },
                errorParameter: false,
                errorDeskripsi: false,
                errorReportName: false,
                errorFormatValue: false,
                errorValue: false,
                errorMinValue: false,
                errorOrder: false,
                errorMaxValue: false,
                errorStartDate: false,
                errorEndDate: false,
                errorGroup: false,
                errorPerusahaan: false,
                errorThresholdCurrency: false,
                msgErrorThresholdCurrency: '',
                msgErrorPerusahaan: '',
                msgErrorGroup: '',
                msgErrorParameter: '',
                msgErrorDeskripsi: '',
                msgErrorReportName: '',
                msgErrorFormatValue: '',
                msgErrorValue: '',
                msgErrorMinValue: '',
                msgErrorOrder: '',
                msgErrorMaxValue: '',
                msgErrorStartDate: '',
                msgErrorEndDate: ''
            })
        } else if (isDate && type == 'end_date') {
            this.setState({
                ...data, tempData: { ...this.state.tempData, end_date: format(e, 'yyyy-MM-dd') },
                errorParameter: false,
                errorDeskripsi: false,
                errorReportName: false,
                errorFormatValue: false,
                errorValue: false,
                errorMinValue: false,
                errorOrder: false,
                errorMaxValue: false,
                errorStartDate: false,
                errorEndDate: false,
                errorGroup: false,
                errorPerusahaan: false,
                errorThresholdCurrency: false,
                msgErrorThresholdCurrency: '',
                msgErrorPerusahaan: '',
                msgErrorGroup: '',
                msgErrorParameter: '',
                msgErrorDeskripsi: '',
                msgErrorReportName: '',
                msgErrorFormatValue: '',
                msgErrorValue: '',
                msgErrorMinValue: '',
                msgErrorOrder: '',
                msgErrorMaxValue: '',
                msgErrorStartDate: '',
                msgErrorEndDate: ''
            })
        } else {
            this.setState({
                ...data,
                tempData: { ...this.state.tempData, [e.target.name]: e.target.value },
                errorParameter: false,
                errorDeskripsi: false,
                errorReportName: false,
                errorFormatValue: false,
                errorValue: false,
                errorMinValue: false,
                errorOrder: false,
                errorMaxValue: false,
                errorStartDate: false,
                errorEndDate: false,
                errorGroup: false,
                errorPerusahaan: false,
                errorThresholdCurrency: false,
                msgErrorThresholdCurrency: '',
                msgErrorPerusahaan: '',
                msgErrorGroup: '',
                msgErrorParameter: '',
                msgErrorDeskripsi: '',
                msgErrorReportName: '',
                msgErrorFormatValue: '',
                msgErrorValue: '',
                msgErrorMinValue: '',
                msgErrorOrder: '',
                msgErrorMaxValue: '',
                msgErrorStartDate: '',
                msgErrorEndDate: ''
            })
        }
    }

    clearMessage() {
        this.setState({
            errorParameter: false,
            errorDeskripsi: false,
            errorValue: false,
            errorMinValue: false,
            errorOrder: false,
            errorReportName: false,
            errorFormatValue: false,
            errorMaxValue: false,
            errorStartDate: false,
            errorEndDate: false,
            errorGroup: false,
            errorPerusahaan: false,
            errorThresholdCurrency: false,
            msgErrorThresholdCurrency: '',
            msgErrorPerusahaan: '',
            msgErrorGroup: '',
            msgErrorParameter: '',
            msgErrorDeskripsi: '',
            msgErrorValue: '',
            msgErrorMinValue: '',
            msgErrorOrder: '',
            msgErrorMaxValue: '',
            msgErrorStartDate: '',
            msgErrorEndDate: '',
            msgErrorReportName: '',
            msgErrorFormatValue: '',
            regexValue: "",
            valueLength: "",
            minMaxRegex: "",
            minLength: "",
            maxLength: "",
        })
    }

    handleChangeCreate(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({ startDate: format(e, 'yyyy-MM-dd'), endDate: null }, () => {
                // console.log(this.state.startDate)
            })
        } else if (isDate && type == 'end_date') {
            this.setState({ endDate: format(e, 'yyyy-MM-dd') }, () => {
                // console.log(this.state.endDate)
            })
        } else {
            this.setState({ ...data, [e.target.name]: e.target.value }, () => this.clearMessage())
        }
    }

    // validasi() {
    //     if (R.isNil(this.state.getTypes)) {
    //
    //     } else if (R.isNil(this.state.getParameter)) {
    //
    //     } else if (R.isNil(this.state.getPerusahaan)) {
    //        this.setState({ errorPerusahaan: true, msgErrorPerusahaan: 'Company Cannot be Empty' })
    //         // } else if (R.isEmpty(this.state.tempData.description)) {
    //         //     this.setState({ errorDeskripsi: true, msgErrorDeskripsi: 'Deskripsi tidak boleh kosong' })
    //     } else if (this.state.getTypes.setting_group_name === "CURRENCY" && R.isNil(this.state.getReportName)) {
    //         this.setState({ errorReportName: true, msgErrorReportName: 'Type Report Cannot be Empty' })
    //     } else if (this.state.getTypes.setting_group_name === "CURRENCY_MONEY_FORMAT" && R.isNil(this.state.getFormatData)) {
    //
    //     } else if (R.isEmpty(this.state.tempData.value) && R.isEmpty(this.state.tempData.min_value) && R.isEmpty(this.state.tempData.max_value)) {
    //
    //     } else if ((!R.isEmpty(this.state.tempData.max_value) && R.isEmpty(this.state.tempData.min_value))) {
    //        this.validasiMinResponse()
    //     } else if (R.isNil(this.state.tempData.start_date)) {
    //
    //         // } else if (R.isNil(this.state.tempData.order)) {
    //         //     this.setState({ errorOrder: true, msgErrorOrder: 'Order tidak boleh kosong' })
    //     } else if ((!R.isEmpty(this.state.tempData.min_value) && R.isEmpty(this.state.tempData.max_value))) {
    //        this.validasiMaxResponse()
    //     } else if (R.isNil(this.state.tempData.end_date)) {
    //         this.setState({ errorEndDate: true, msgErrorEndDate: 'Valid To Cannot be Empty' })
    //     } else {
    //         this.updateParameter()
    //     }
    // }

    async validasiValueResponse() {
        let data = await this.validasiValueData()
        if (R.isNil(this.state.getTypes)) {
        } else {
            if (this.state.getTypes.setting_group_name == "REPORT_SUBMIT_PERIOD") {
                if (R.isEmpty(data.value)) {
                    if (R.isNil(this.state.getPerusahaan)) {
                    } else {
                        if (this.state.getPerusahaan.company_name == "Default") {
                        } else {
                            this.setState({ errorValue: true, msgErrorValue: 'Value Cannot be Empty' })
                        }
                    }
                } else {
                    if (R.isNil(this.state.getParameter)) {
                    } else {
                        switch (this.state.getParameter.setting_type_name) {
                            case "MASTER_BUDGET":
                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : 2023' })
                                break
                            case "MONTHLY_REPORT":
                                this.setState({
                                    errorValue: true,
                                    msgErrorValue: 'Incorrect value format, example : Jan 2023'
                                })
                                break
                            case "OUTLOOK_Q1":
                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : Q1 2023' })
                                break
                            case "OUTLOOK_Q2":
                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : Q2 2023' })
                                break
                            case "OUTLOOK_Q3":
                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : Q3 2023' })
                                break
                            case "OUTLOOK_PA":
                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : 2023' })
                                break
                            default:
                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : 2023' })
                        }
                    }
                }
            } else if (this.state.getTypes.setting_group_name == "CURRENCY") {
                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : 15000' })
            } else if (this.state.getTypes.setting_group_name == "DAY_OFF") {
                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, example : 2023' })
            }
        }
    }

    async validasiCreateEdit() {
        let data = await this.validasiValueData()
        let response = await this.validasiRegexValue()
        let minMaxValidasi = await this.validasiMinMaxValue()
        console.log("Masuk ke menu creat : " + R.isNil(this.state.getFormatData))
        if (this.props.type === "edit") {
            if (R.isNil(this.state.getTypes)) {
            } else {
                if (this.state.getTypes.setting_group_name == "CURRENCY_MONEY_FORMAT") {
                    if (R.isNil(this.state.getParameter)) {
                    } else {
                        if (R.isNil(this.state.getPerusahaan)) {
                        } else {
                            if (R.isNil(this.state.getFormatData)) {
                            } else {
                                this.updateParameterCurrebcyMoneyFormat()
                            }
                        }
                    }
                } else if (this.state.getTypes.setticonng_group_name == "CURRENCY") {
                    if (R.isNil(this.state.getReportName)) {
                    } else {
                        if (R.isEmpty(data.value)) {
                        } else {
                            if (data.value.match(response.regexValue) && data.value.length <= response.valueLength) {
                                if (R.isEmpty(data.minValue)) {
                                } else {
                                    if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                        if (R.isEmpty(data.maxValue)) {
                                        } else {
                                            if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                                this.updateParameter()
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (this.state.getTypes.setting_group_name == "THRESHOLD_VARIANCE" || this.state.getTypes.setting_group_name == "THRESHOLD_CONTROL") {
                    if (R.isEmpty(data.minValue)) {
                    } else {
                        if (data.minValue.match(minMaxValidasi.minMaxRegex) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.minValue.substring(0,1) != "0" : true )  && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.minValue.length <= minMaxValidasi.minLength : true )) {
                            if (R.isEmpty(data.maxValue)) {
                            } else {
                                if (data.maxValue.match(minMaxValidasi.minMaxRegex) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.maxValue.substring(0,1) != "0" : true ) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.maxValue.length <= minMaxValidasi.maxLength : true )) {
                                    this.updateParameterThreshold()
                                }
                            }
                        }
                    }
                } else if (this.state.getTypes.setting_group_name == "REPORT_SUBMIT_PERIOD") {
                    if (R.isEmpty(data.value)) {
                        if (this.state.getPerusahaan.company_name == "Default") {
                            if (R.isEmpty(data.minValue)) {
                            } else {
                                if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                    if (R.isEmpty(data.maxValue)) {
                                    } else {
                                        if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                            this.updateParameter()
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        if (data.value.match(response.regexValue) && data.value.length <= response.valueLength) {
                            if (R.isEmpty(data.minValue)) {
                            } else {
                                if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                    if (R.isEmpty(data.maxValue)) {
                                    } else {
                                        if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                            this.updateParameter()
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (this.state.getTypes.setting_group_name == "DAY_OFF"){
                    console.log(this.state.errorMaxValue)
                    if (R.isEmpty(data.value)) {
                    }else {
                        if (data.value.match(response.regexValue) && data.value.length <= response.valueLength) {
                            if (R.isEmpty(data.minValue)) {
                            } else {
                                if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                    if (R.isEmpty(data.maxValue)) {
                                    } else {
                                        if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                            if (data.maxValue.slice(-4)==data.value){
                                                this.updateParameter()
                                            }else {
                                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, value must same with a year of max value' })
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    if (R.isNil(this.state.getParameter)) {
                    } else {
                        if (R.isNil(this.state.getPerusahaan)) {
                        } else {
                            this.updateParameter()
                        }
                    }
                }
            }
        } else {
            if (R.isNil(this.state.getTypes)) {
            } else {
                if (this.state.getTypes.setting_group_name == "CURRENCY_MONEY_FORMAT") {
                    if (R.isNil(this.state.getParameter)) {
                    } else {
                        if (R.isNil(this.state.getPerusahaan)) {
                        } else {
                            console.log()
                            if (R.isNil(this.state.getFormatData)) {
                            } else {
                                this.createParameterCurrebcyMoneyFormat()
                            }
                        }
                    }
                } else if (this.state.getTypes.setting_group_name == "CURRENCY") {
                    if (R.isNil(this.state.getReportName)) {
                    } else {
                        if (R.isEmpty(data.value)) {
                        } else {
                            if (data.value.match(response.regexValue) && data.value.length <= response.valueLength) {
                                if (R.isEmpty(data.minValue)) {
                                } else {
                                    if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                        if (R.isEmpty(data.maxValue)) {
                                        } else {
                                            if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                                this.createParameter()
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (this.state.getTypes.setting_group_name == "THRESHOLD_VARIANCE" || this.state.getTypes.setting_group_name == "THRESHOLD_CONTROL") {
                    if (R.isEmpty(data.minValue)) {
                    } else {
                        if (data.minValue.match(minMaxValidasi.minMaxRegex) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.minValue.substring(0,1) != "0" : true )  && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.minValue.length <= minMaxValidasi.minLength : true )) {
                            if (R.isEmpty(data.maxValue)) {
                            } else {
                                if (data.maxValue.match(minMaxValidasi.minMaxRegex) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.maxValue.substring(0,1) != "0" : true ) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.maxValue.length <= minMaxValidasi.maxLength : true )) {
                                    this.createParameterThreshold()
                                }
                            }
                        }
                    }
                } else if (this.state.getTypes.setting_group_name == "REPORT_SUBMIT_PERIOD") {
                    if (R.isEmpty(data.value)) {
                        if (this.state.getPerusahaan.company_name == "Default") {
                            if (R.isEmpty(data.minValue)) {
                            } else {
                                if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                    if (R.isEmpty(data.maxValue)) {
                                    } else {
                                        if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                            this.createParameter()
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        if (data.value.match(response.regexValue) && data.value.length <= response.valueLength) {
                            if (R.isEmpty(data.minValue)) {
                            } else {
                                if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                    if (R.isEmpty(data.maxValue)) {
                                    } else {
                                        if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                            this.createParameter()
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (this.state.getTypes.setting_group_name == "DAY_OFF"){
                    console.log(this.state.errorMaxValue)
                    if (R.isEmpty(data.value)) {
                    }else {
                        if (data.value.match(response.regexValue) && data.value.length <= response.valueLength) {
                            if (R.isEmpty(data.minValue)) {
                            } else {
                                if (data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0, 1) != "0" && data.minValue.length <= minMaxValidasi.minLength) {
                                    if (R.isEmpty(data.maxValue)) {
                                    } else {
                                        if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0, 1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                                            if (data.maxValue.slice(-4)==data.value){
                                                this.createParameter()
                                            }else {
                                                this.setState({ errorValue: true, msgErrorValue: 'Incorrect value format, value must same with a year of max value' })
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    if (R.isNil(this.state.getParameter)) {
                    } else {
                        if (R.isNil(this.state.getPerusahaan)) {
                        } else {
                            this.createParameter()
                        }
                    }
                }
            }
        }
    }

    validasiFormatResponse() {
        if (R.isNil(this.state.getTypes)) {
        } else {
            if (this.state.getTypes.setting_group_name == "CURRENCY_MONEY_FORMAT") {
                if (R.isNil(this.state.getFormatData)) {
                    this.setState({ errorFormatValue: true, msgErrorFormatValue: 'Format Cannot be Empty' })
                }
            }
        }
    }

    validasiRegexValue() {
        let obj = null
        if (R.isNil(this.state.getTypes)) {
            obj = { regexValue: (/null.*$/), valueLength: 0 }
        } else {
            if (this.state.getTypes.setting_group_name === "CURRENCY") {
                obj = { regexValue: (/\d+(\.\d+)?/), valueLength: 20 }
            } else if (this.state.getTypes.setting_group_name === "REPORT_SUBMIT_PERIOD") {
                if (R.isNil(this.state.getParameter)) {
                    obj = { regexValue: (/\b\d{4}\b/), valueLength: 4 }
                } else {
                    switch (this.state.getParameter.setting_type_name) {
                        case "MASTER_BUDGET":
                            obj = { regexValue: (/\b\d{4}\b/), valueLength: 4 }
                            break
                        case "MONTHLY_REPORT":
                            obj = {
                                regexValue: (/^(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s\d{4}$/),
                                valueLength: 8
                            }
                            break
                        case "OUTLOOK_Q1":
                            obj = { regexValue: (/Q1\s\d{4}/), valueLength: 7 }
                            break
                        case "OUTLOOK_Q2":
                            obj = { regexValue: (/Q2\s\d{4}/), valueLength: 7 }
                            break
                        case "OUTLOOK_Q3":
                            obj = { regexValue: (/Q3\s\d{4}/), valueLength: 7 }
                            break
                        case "OUTLOOK_PA":
                            obj = { regexValue: (/\b\d{4}\b/), valueLength: 4 }
                            break
                        default:
                            obj = { regexValue: (/Q1\s\d{4}/), valueLength: 7 }
                    }
                }
            }else if (this.state.getTypes.setting_group_name === "DAY_OFF"){
                obj = {regexValue: (/\b\d{4}\b/), valueLength: 4}
            }else{
                obj = { regexValue: (/null.*$/), valueLength: 20 }
            }
        }
        return obj;
    }

    validasiMaxResponse() {
        if (R.isNil(this.state.getTypes)) {
        } else {
            switch (this.state.getTypes.setting_group_name) {
                case "REPORT_SUBMIT_PERIOD":
                    this.setState({
                        errorMaxValue: true,
                        msgErrorMaxValue: 'Incorrect max value format, example : 31 Jan 2023'
                    })
                    break
                case "CURRENCY":
                    this.setState({
                        errorMaxValue: true,
                        msgErrorMaxValue: 'Incorrect max value format, example : 31 Jan 2023'
                    })
                    break
                case "THRESHOLD_CONTROL":
                    this.setState({ errorMaxValue: true, msgErrorMaxValue: 'Incorrect max value format, example : 99999999' })
                    break
                case "THRESHOLD_VARIANCE":
                    this.setState({ errorMaxValue: true, msgErrorMaxValue: 'Incorrect max value format, example : 99999999' })
                    break
                case "DAY_OFF":
                    this.setState({
                        errorMaxValue: true,
                        msgErrorMaxValue: 'Incorrect max value format, example : 31 Jan 2023'
                    })
                    break
                default:
                    this.setState({ errorMaxValue: false, msgErrorMaxValue: '' })
            }
        }
    }

    validasiMinResponse() {
        if (R.isNil(this.state.getTypes)) {
        } else {
            switch (this.state.getTypes.setting_group_name) {
                case "REPORT_SUBMIT_PERIOD":
                    this.setState({
                        errorMinValue: true,
                        msgErrorMinValue: 'Incorrect min value format, example : 1 Jan 2023'
                    })
                    break
                case "CURRENCY":
                    this.setState({
                        errorMinValue: true,
                        msgErrorMinValue: 'Incorrect min value format, example : 1 Jan 2023'
                    })
                    break
                case "THRESHOLD_CONTROL":
                    this.setState({ errorMinValue: true, msgErrorMinValue: 'Incorrect min value format, example : -99999999' })
                    break
                case "THRESHOLD_VARIANCE":
                    this.setState({ errorMinValue: true, msgErrorMinValue: 'Incorrect min value format, example : -99999999' })
                    break
                case "DAY_OFF":
                    this.setState({ errorMinValue: true, msgErrorMinValue: 'Incorrect min value format, example : 1 Jan 2023' })
                    break
                default:
                    this.setState({ errorMinValue: false, msgErrorMinValue: '' })
            }
        }
    }

    validasiMinMaxValue() {
        let obj = null
        if (R.isNil(this.state.getTypes)) {
            obj = { minMaxRegex: (/^-?\d+\.?\d+$/), minLength: this.state.minValue.length, maxLength: this.state.maxValue.length }
        } else {
            switch (this.state.getTypes.setting_group_name) {
                case "CURRENCY":
                    obj = { minMaxRegex: (/\b\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s\d{4}\b/), minLength: 11, maxLength: 11, regexValue: (/^\d+$/) }
                    break
                case "REPORT_SUBMIT_PERIOD":
                    if (R.isNil(this.state.getPerusahaan)) {
                        obj = {
                            minMaxRegex: (/\b\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s\d{4}\b/),
                            minLength: 11, maxLength: 11
                        }
                    } else {
                        if (this.state.getPerusahaan.company_name == "Default") {
                            if (R.isNil(this.state.getParameter)) {
                                obj = {
                                    minMaxRegex: (/\b\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s\d{4}\b/),
                                    minLength: 11, maxLength: 11
                                }
                            } else {
                                switch (this.state.getParameter.setting_type_name) {
                                    case "MASTER_BUDGET":
                                        obj = {
                                            minMaxRegex: (/^(\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec))(?:\s\d{4})?$/),
                                            minLength: 11, maxLength: 11
                                        }
                                        break
                                    case "MONTHLY_REPORT":
                                        obj = {
                                            minMaxRegex: (/^(?:\d{1,2}|(\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s\d{4}))$/),
                                            minLength: 11, maxLength: 11
                                        }
                                        break
                                    case "OUTLOOK_Q1":
                                        obj = {
                                            minMaxRegex: (/^(\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec))(?:\s\d{4})?$/),
                                            minLength: 11, maxLength: 11
                                        }
                                        break
                                    case "OUTLOOK_Q2":
                                        obj = {
                                            minMaxRegex: (/^(\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec))(?:\s\d{4})?$/),
                                            minLength: 11, maxLength: 11
                                        }
                                        break
                                    case "OUTLOOK_Q3":
                                        obj = {
                                            minMaxRegex: (/^(\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec))(?:\s\d{4})?$/),
                                            minLength: 11, maxLength: 11
                                        }
                                        break
                                    case "OUTLOOK_PA":
                                        obj = {
                                            minMaxRegex: (/^(\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec))(?:\s\d{4})?$/),
                                            minLength: 11, maxLength: 11
                                        }
                                        break
                                    default:
                                        obj = {
                                            minMaxRegex: (/^(\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec))(?:\s\d{4})?$/),
                                            minLength: 11, maxLength: 11
                                        }
                                }
                            }
                        } else {
                            obj = {
                                minMaxRegex: (/\b\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s\d{4}\b/),
                                minLength: 11, maxLength: 11
                            }
                        }
                    }
                    break
                case "THRESHOLD_CONTROL":
                    obj = { minMaxRegex: (/^-?\d+(\.\d+)?$/), minLength: this.state.minValue.length, maxLength: this.state.maxValue.length }
                    break
                case "DAY_OFF":
                    obj = {
                        minMaxRegex: (/\b\d{1,2}\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s\d{4}\b/),
                        minLength: 11, maxLength: 11
                    }
                default:
                    obj = { regexValue: null, minLength: 11, maxLength: 11 }
            }
        }
        return obj;
    }

    validasiValueData() {
        let obj = null
        if (this.props.type === "edit") {
            obj = { value: this.state.tempData.value.toString(), minValue: this.state.tempData.min_value, maxValue: this.state.tempData.max_value, endDate: this.state.tempData.end_date, startDate: this.state.tempData.start_date }
        } else {
            obj = { value: this.state.value, minValue: this.state.minValue, maxValue: this.state.maxValue, endDate: this.state.endDate, startDate: this.state.startDate }
        }
        return obj;
    }

    validasiCurrencyTC(){
        if (R.isNil(this.state.getThresholdCurrency)){
            this.setState({ errorThresholdCurrency: true, msgErrorThresholdCurrency: 'Currency Cannot be Empty' })
        }
    }

    async validasiMaxValue() {
        let data = await this.validasiValueData()
        let minMaxValidasi = await this.validasiMinMaxValue()
        if (R.isEmpty(data.maxValue)) {
            this.validasiMaxResponse()
            this.validasiCurrencyTC()
        } else {
            if (R.isNil(this.state.getTypes)){
                if (data.maxValue.match(minMaxValidasi.minMaxRegex) && data.maxValue.substring(0,1) != "0" && data.maxValue.length <= minMaxValidasi.maxLength) {
                    this.validasiCurrencyTC()
                } else {
                    this.validasiMaxResponse()
                    this.validasiCurrencyTC()
                }
            }else {
                if (data.maxValue.match(minMaxValidasi.minMaxRegex) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.maxValue.substring(0,1) != "0" : true ) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.maxValue.length <= minMaxValidasi.maxLength : true ) ) {
                    this.validasiCurrencyTC()
                } else {
                    this.validasiMaxResponse()
                    this.validasiCurrencyTC()
                }
            }
        }
    }

    validasiFormatData() {
        if (R.isNil(this.state.getFormatData)) {
            this.validasiFormatResponse()
            this.validasiMaxValue()
        } else {
            this.validasiMaxValue()
        }
    }

    async validsiMinValue() {
        let data = await this.validasiValueData()
        let minMaxValidasi = await this.validasiMinMaxValue()
        if (R.isEmpty(data.minValue)) {
            this.validasiMinResponse()
            this.validasiFormatData()
        } else {
            if (R.isNil(this.state.getTypes)){
                if(data.minValue.match(minMaxValidasi.minMaxRegex) && data.minValue.substring(0,1) != "0" && data.minValue.length <= minMaxValidasi.minLength){
                    this.validasiFormatData()
                } else {
                    this.validasiMinResponse()
                    this.validasiFormatData()
                }
            }else {
                if(data.minValue.match(minMaxValidasi.minMaxRegex) && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.minValue.substring(0,1) != "0" : true )  && (this.state.getTypes.setting_group_name != "THRESHOLD_CONTROL" ? data.minValue.length <= minMaxValidasi.minLength : true )){
                    this.validasiFormatData()
                } else {
                    this.validasiMinResponse()
                    this.validasiFormatData()
                }
            }
        }
    }

    async validasiValue() {
        let data = await this.validasiValueData()
        let response = await this.validasiRegexValue()
        if (R.isEmpty(data.value)) {
            this.validasiValueResponse()
            this.validsiMinValue()
        } else {
            if (data.value.match(response.regexValue) && data.value.length <= response.valueLength) {
                this.validsiMinValue()
            } else {
                this.validasiValueResponse()
                this.validsiMinValue()
            }
        }
    }

    validasiReportName() {
        if (R.isNil(this.state.getReportName)) {
            this.setState({ errorReportName: true, msgErrorReportName: 'Report Cannot be Empty' })
            this.validasiValue()
        } else {
            this.validasiValue()
        }
    }

    validasiPerusahaan() {
        if (R.isNil(this.state.getPerusahaan)) {
            this.setState({ errorPerusahaan: true, msgErrorPerusahaan: 'Company Cannot be Empty' })
            this.validasiReportName()
        } else {
            this.validasiReportName()
            this.validasiCreateEdit()
        }
    }

    validasiParameter() {
        if (R.isNil(this.state.getParameter)) {
            this.setState({ errorParameter: true, msgErrorParameter: 'Parameter Cannot be Empty' })
            this.validasiPerusahaan()
        } else {
            this.validasiPerusahaan()
        }
    }

    validasiGroup() {
        if (R.isNil(this.state.getTypes)) {
            this.setState({ errorGroup: true, msgErrorGroup: 'Group Cannot be Empty' })
            this.validasiParameter()
        } else {
            this.validasiParameter()
        }
    }

    validasiCreate() {
        this.validasiGroup()
    }

    validasiFormat() {
        this.state.getTypes.setting_group_name === "CURRENCY_MONEY_FORMAT" && R.isNil(this.state.getFormatData)
    }

    updateParameter() {
        // let char = this.state.value
        // let arrayChar = char.split('');
        // console.log(char);
        let body = {
            "setting_id": this.state.tempData.setting_id,
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getReportName == null ? null : this.state.getReportName.setting_type_id,
            "description": this.state.tempData.description,
            "orders": this.state.tempData.order,
            "value": this.state.tempData.value,
            "max_value": this.state.tempData.max_value,
            "min_value": this.state.tempData.min_value,
            "start_date": this.state.tempData.start_date,
            "end_date": this.state.tempData.end_date
        }
        console.log(body);
        this.props.updateParameter(body)
    }

    updateParameterThreshold() {
        // let char = this.state.value
        // let arrayChar = char.split('');
        // console.log(char);
        let body = {
            "setting_id": this.state.tempData.setting_id,
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getThresholdCurrency == null ? null : this.state.getThresholdCurrency.setting_type_id,
            "description": this.state.tempData.description,
            "orders": this.state.tempData.order,
            "value": this.state.tempData.value,
            "max_value": this.state.tempData.max_value,
            "min_value": this.state.tempData.min_value,
            "start_date": this.state.tempData.start_date,
            "end_date": this.state.tempData.end_date
        }
        console.log(body);
        this.props.updateParameter(body)
    }

    updateParameterCurrebcyMoneyFormat() {
        // let char = this.state.value
        // let arrayChar = char.split('');
        // console.log(char);
        let body = {
            "setting_id": this.state.tempData.setting_id,
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getFormatData == null ? null : this.state.getFormatData.setting_type_id,
            "description": this.state.tempData.description,
            "orders": this.state.tempData.order,
            "value": this.state.tempData.value,
            "max_value": this.state.tempData.max_value,
            "min_value": this.state.tempData.min_value,
            "start_date": this.state.tempData.start_date,
            "end_date": this.state.tempData.end_date
        }
        console.log(body);
        this.props.updateParameter(body)
    }

    createParameter() {
        let char = this.state.value
        let arrayChar = char.split('');
        console.log(char);
        let body = {
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getReportName == null ? null : this.state.getReportName.setting_type_id,
            "description": this.state.description,
            "orders": this.state.order,
            "value": this.state.value,
            // convert IDR to IDR mn
            "value": this.state.enableReportName ? this.state.value.includes(".") || arrayChar.length == 2 ? this.state.value : this.state.value / 1000 : this.state.value,
            "max_value": this.state.maxValue,
            "min_value": this.state.minValue,
            "start_date": this.state.startDate,
            "end_date": this.state.endDate
        }
        console.log(body);
        this.props.createParameter(body)
    }

    createParameterThreshold() {
        let char = this.state.value
        let arrayChar = char.split('');
        console.log(char);
        let body = {
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getThresholdCurrency == null ? null : this.state.getThresholdCurrency.setting_type_id,
            "description": this.state.description,
            "orders": this.state.order,
            "value": this.state.value,
            // convert IDR to IDR mn
            "value": this.state.enableReportName ? this.state.value.includes(".") || arrayChar.length == 2 ? this.state.value : this.state.value / 1000 : this.state.value,
            "max_value": this.state.maxValue,
            "min_value": this.state.minValue,
            "start_date": this.state.startDate,
            "end_date": this.state.endDate
        }
        console.log(body);
        this.props.createParameter(body)
    }

    createParameterCurrebcyMoneyFormat() {
        let char = this.state.value
        let arrayChar = char.split('');
        console.log(char);
        let body = {
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getFormatData == null ? null : this.state.getFormatData.setting_type_id,
            "description": this.state.description,
            "orders": this.state.order,
            "value": this.state.value,
            // convert IDR to IDR mn
            "value": this.state.enableReportName ? this.state.value.includes(".") || arrayChar.length == 2 ? this.state.value : this.state.value / 1000 : this.state.value,
            "max_value": this.state.maxValue,
            "min_value": this.state.minValue,
            "start_date": this.state.startDate,
            "end_date": this.state.endDate
        }
        console.log(body);
        this.props.createParameter(body)
    }

    openPopUp() {
        if (!R.isNil(this.state.getTypes)) {
            if (this.state.getTypes.setting_group_name == "CURRENCY") {
                if (!R.isNil(this.state.getReportName)) {
                    this.setState({
                        visiblePopupInformation: true
                    })
                }
            }
        }
    }

    render() {
        let { type } = this.props
        return type === 'edit' ? this.renderEdit() : this.renderCreate()
    }

    renderEdit() {
        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Ubah Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>


                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '20px 20px 0px' }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.tempData === null ? '' : this.state.tempData.setting_id}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.types}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getTypes: newInputValue }, () => newInputValue === null ? this.setState({ enableParameter: false, enableReportName: false, enableFormat: false, enableThreshold: false, getParameter: null, getReportName: null }, () => this.clearMessage()) : this.getParameterByGroup(newInputValue.setting_group_id, newInputValue.setting_group_name), this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            error={this.state.errorGroup}
                                            helperText={this.state.msgErrorGroup}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Group" />}
                                    value={this.state.getTypes}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.parameter}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getParameter: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Parameter"
                                            error={this.state.errorParameter}
                                            helperText={this.state.msgErrorParameter}
                                        />}
                                    value={this.state.getParameter}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.perusahaan}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getPerusahaan: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField {...params}
                                                   error={this.state.errorPerusahaan}
                                                   helperText={this.state.msgErrorPerusahaan}
                                                   InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                   InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                   label="Company Name" />}
                                    value={this.state.getPerusahaan}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="description"
                                    label="Description"
                                    value={this.state.tempData === null ? '' : this.state.tempData.description}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="description"
                                    onChange={(e) => this.handleChange(e, '')}
                                    // error={this.state.errorDeskripsi}
                                    // helperText={this.state.msgErrorDeskripsi}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="order"
                                    label="Order"
                                    value={this.state.tempData === null ? '' : this.state.tempData.order}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="order"
                                    onChange={(e) => {
                                        let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                order: coba
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    // error={this.state.errorOrder}
                                    // helperText={this.state.msgErrorOrder}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="value"
                                    label={"Value"}
                                    // get data IDR by IDR mn
                                    value={this.state.tempData === null ? '' : this.state.tempData.setting_group === "CURRENCY" ? fixNumber(Number(this.state.tempData.value) * 1000) : this.state.tempData.value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="value"
                                    onChange={(e) => {
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                value: this.state.tempData.setting_group === "CURRENCY" ? e.target.value / 1000 : e.target.value
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorValue}
                                    helperText={this.state.msgErrorValue}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            {this.state.enableReportName == true ?
                                <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.reportName}
                                        debug
                                        id="report"
                                        onChange={(event, newInputValue) => this.setState({ getReportName: newInputValue }, () => {
                                            this.clearMessage()
                                            this.openPopUp()
                                        })}
                                        renderInput={(params) =>
                                            <TextField
                                                {...params}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                label="Type Report"
                                                // error={this.state.errorPerusahaan}
                                                // helperText={this.state.msgErrorPerusahaan}
                                            />}
                                        value={this.state.getReportName}
                                    />
                                </div>
                                :
                                this.state.enableFormat == true ?
                                    <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            {...this.state.formatCurrency}
                                            debug
                                            id="report"
                                            onChange={(event, newInputValue) => this.setState({ getFormatData: newInputValue }, () =>
                                                this.clearMessage())}
                                            renderInput={(params) =>
                                                <TextField
                                                    {...params}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                    InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                    label="Format"
                                                    error={this.state.errorFormatValue}
                                                    helperText={this.state.msgErrorFormatValue}
                                                />}
                                            value={this.state.getFormatData}
                                        />
                                    </div>
                                    :
                                    this.state.enableThreshold == true ?
                                        <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                            <Autocomplete
                                                {...this.state.thresholdCurrency}
                                                debug
                                                id="report"
                                                onChange={(event, newInputValue) => this.setState({ getThresholdCurrency: newInputValue }, () =>
                                                    this.clearMessage())}
                                                renderInput={(params) =>
                                                    <TextField
                                                        {...params}
                                                        InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                        InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                        label="Currency"
                                                        error={this.state.errorThresholdCurrency}
                                                        helperText={this.state.msgErrorThresholdCurrency}
                                                    />}
                                                value={this.state.getThresholdCurrency}
                                            />
                                        </div>
                                        :
                                        null
                            }
                            {/* {this.state.enableFormat == true ?
                                <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.formatCurrency}
                                        debug
                                        id="report"
                                        onChange={(event, newInputValue) => this.setState({ getFormatData: newInputValue }, () => this.clearMessage())}
                                        renderInput={(params) =>
                                            <TextField
                                                {...params}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                label="Format"
                                                error={this.state.errorFormatValue}
                                                helperText={this.state.msgErrorFormatValue}
                                            />}
                                        value={this.state.getFormatData}
                                    />
                                </div> : null
                            } */}
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="min_value"
                                    label="Min Value"
                                    value={this.state.tempData === null ? '' : this.state.tempData.min_value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="min_value"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                min_value: e.target.value
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMinValue}
                                    helperText={this.state.msgErrorMinValue}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="max_value"
                                    label="Max Value"
                                    value={this.state.tempData === null ? '' : this.state.tempData.max_value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="max_value"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                max_value: e.target.value
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMaxValue}
                                    helperText={this.state.msgErrorMaxValue}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="start_date"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.tempData === null ? '' : this.state.tempData.start_date}
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorStartDate}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="end_date"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorEndDate}
                                    minDate={this.state.tempData === null ? null : this.state.tempData.start_date}
                                    value={this.state.tempData === null ? '' : this.state.tempData.end_date}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="status"
                                    label="Status"
                                    value={this.state.tempData === null ? '' : this.state.tempData.status}
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>
                        <div className="column-2">

                        </div>
                    </div>

                    <div className="border-bottom margin-top-10px" style={{ padding: '0px 20px 20px 20px', borderRadius: 5 }}>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Created By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.tempData === null ? "" : this.state.tempData.created}</Typography>
                        </div>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Updated By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.tempData === null ? "" : this.state.tempData.updated === null ? "" : this.state.tempData.updated}</Typography>
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasiCreate()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
                {this.state.visiblePopupInformation && (
                    <PopUpInformation
                        onClickClose={() => this.setState({ visiblePopupInformation: false })}
                        reportName={this.state.getReportName.setting_type_name}
                    />
                )}
            </div>
        )
    }

    renderCreate() {
        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Create Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '20px 20px 0px' }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.tempData === null ? '' : this.state.tempData.setting_id}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.types}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getTypes: newInputValue }, () => newInputValue === null ? this.setState({ enableParameter: false, enableReportName: false, enableFormat: false, enableThreshold: false, getParameter: null, getReportName: null }, () => this.clearMessage()) : this.getParameterByGroup(newInputValue.setting_group_id, newInputValue.setting_group_name), this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Group"
                                            error={this.state.errorGroup}
                                            helperText={this.state.msgErrorGroup}
                                        />}
                                    value={this.state.getTypes}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.parameter}
                                    debug
                                    disabled={!this.state.enableParameter}
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getParameter: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Parameter"
                                            error={this.state.errorParameter}
                                            helperText={this.state.msgErrorParameter}
                                        />}
                                    value={this.state.getParameter}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.perusahaan}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getPerusahaan: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Company Name"
                                            error={this.state.errorPerusahaan}
                                            helperText={this.state.msgErrorPerusahaan}
                                        />}
                                    value={this.state.getPerusahaan}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="description"
                                    label="Description"
                                    value={this.state.description === '' ? '' : this.state.description}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="description"
                                    onChange={(e) => this.handleChangeCreate(e, '')}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="order"
                                    label="Order"
                                    value={this.state.order === null ? '' : this.state.order}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="order"
                                    onChange={(e) => {
                                        let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            order: coba
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    // error={this.state.errorOrder}
                                    // helperText={this.state.msgErrorOrder}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="value"
                                    label={"Value"}
                                    value={this.state.value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="value"
                                    onChange={(e) => {
                                        this.setState({
                                            value: e.target.value
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorValue}
                                    helperText={this.state.msgErrorValue}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            {this.state.enableReportName == true ?
                                <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.reportName}
                                        debug
                                        id="report"
                                        onChange={(event, newInputValue) => this.setState({ getReportName: newInputValue }, () => {
                                            this.clearMessage()
                                            this.openPopUp()
                                        })}
                                        renderInput={(params) =>
                                            <TextField
                                                {...params}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                label="Type Report"
                                                error={this.state.errorReportName}
                                                helperText={this.state.msgErrorReportName}
                                            />}
                                        value={this.state.getReportName}
                                    />
                                </div>
                                :
                                this.state.enableFormat == true ?
                                    <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            {...this.state.formatCurrency}
                                            debug
                                            id="report"
                                            onChange={(event, newInputValue) => this.setState({ getFormatData: newInputValue }, () => this.clearMessage())}
                                            renderInput={(params) =>
                                                <TextField
                                                    {...params}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                    InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                    label="Format"
                                                    error={this.state.errorFormatValue}
                                                    helperText={this.state.msgErrorFormatValue}
                                                />}
                                            value={this.state.getFormatData}
                                        />
                                    </div>
                                    :
                                    this.state.enableThreshold == true ?
                                        <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                            <Autocomplete
                                                {...this.state.thresholdCurrency}
                                                debug
                                                id="report"
                                                onChange={(event, newInputValue) => this.setState({ getThresholdCurrency: newInputValue }, () => this.clearMessage())}
                                                renderInput={(params) =>
                                                    <TextField
                                                        {...params}
                                                        InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                        InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                        label="Currency"
                                                        error={this.state.errorThresholdCurrency}
                                                        helperText={this.state.msgErrorThresholdCurrency}
                                                    />}
                                                value={this.state.getThresholdCurrency}
                                            />
                                        </div>
                                        :
                                        null
                            }

                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="min_value"
                                    label="Min Value"
                                    value={this.state.minValue}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="minValue"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            minValue: e.target.value
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMinValue}
                                    helperText={this.state.msgErrorMinValue}

                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="max_value"
                                    label="Max Value"
                                    value={this.state.maxValue}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="maxValue"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            maxValue: e.target.value
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMaxValue}
                                    helperText={this.state.msgErrorMaxValue}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorStartDate}
                                    value={this.state.startDate == "" ? null : this.state.startDate}
                                    onChange={(e) => this.handleChangeCreate(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorEndDate}
                                    minDate={this.state.startDate}
                                    value={this.state.endDate == "" ? null : this.state.endDate}
                                    onChange={(e) => this.handleChangeCreate(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: '5px 20px' }}>
                        <div className="column-1">
                            <div className="" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    defaultValue={"Active"}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Created By	: </Typography>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Updated By	: </Typography>
                            </div>
                        </div>
                        <div className="column-2">

                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasiCreate()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
                {this.state.visiblePopupInformation && (
                    <PopUpInformation
                        onClickClose={() => this.setState({ visiblePopupInformation: false })}
                        reportName={this.state.getReportName.setting_type_name}
                    />
                )}
            </div>
        )
    }
}