import React, { Component, useRef } from 'react';
import { Typography, Paper, TextField, Snackbar, withStyles, Switch, FormControlLabel, InputAdornment } from '@material-ui/core';
import Images from '../../assets/Images';
import Constant from '../../library/Constant';
import api from '../../api';
import { PropagateLoader } from 'react-spinners';
import { format } from 'date-fns';
import Autocomplete from '@material-ui/lab/Autocomplete';
import { Alert } from '@material-ui/lab';
import ReactTooltip from "react-tooltip";
import SunEditor, { buttonList } from "suneditor-react";
import 'suneditor/dist/css/suneditor.min.css'; // Import Sun Editor's CSS File
import CloudDownloadIcon from '@material-ui/icons/CloudDownload';
import moment from 'moment';
import CheckCircleOutlineIcon from '@material-ui/icons/CheckCircleOutline';
import CheckCircleIcon from '@material-ui/icons/CheckCircle';
import SearchIcon from '@material-ui/icons/Search';


const IOSSwitch = withStyles((theme) => ({
    root: {
        width: 55,
        height: 31,
        padding: 0,
        margin: theme.spacing(1),
    },
    switchBase: {
        padding: 3,
        marginLeft: 1,
        '&$checked': {
            transform: 'translateX(16px)',
            color: theme.palette.common.white,
            paddingLeft: 11,
            '& + $track': {
                backgroundColor: '#52d869',
                opacity: 1,
                border: 'none',
            },
        },
        '&$focusVisible $thumb': {
            color: '#52d869',
            border: '6px solid #fff',
        },
    },
    thumb: {
        width: 25,
        height: 25,
    },
    track: {
        borderRadius: 30 / 2,
        border: `1px solid ${theme.palette.grey[400]}`,
        backgroundColor: 'red',
        opacity: 1,
        transition: theme.transitions.create(['background-color', 'border']),
    },
    checked: {},
    focusVisible: {},
}))(({ classes, ...props }) => {
    return (
        <Switch
            focusVisibleClassName={classes.focusVisible}
            disableRipple
            classes={{
                root: classes.root,
                switchBase: classes.switchBase,
                thumb: classes.thumb,
                track: classes.track,
                checked: classes.checked,
            }}
            {...props}
        />
    );
});


class DownloadReport extends Component {
    constructor(props) {
        super(props)
        this.editorRef = React.createRef();
        this.editorRefEmail = React.createRef();
        // this.handleChange = this.handleChange.bind(this)
        this.state = {
            load: false,
            loading: false,
            listDownload: [],
            oldListDownload: [],
            search: "",
            isSearch: false
        }
    }


    componentDidMount() {
        const interval = setInterval(() => {
            this.getListDownload()
        }, 500);
        return () => clearInterval(interval);
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    getListDownload() {
        api.create().getListDownload().then((response) => {
            // console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        // console.log(data);
                        let arr = [];
                        var groups = this.groupItems(data, "created_at"); // array will be grouped by 'date' property

                        for (var key in groups) {
                            if (this.state.search.length == 0) {
                                arr.push({
                                    time: key,
                                    items: groups[key],
                                });
                            } else {
                                let itmDtl = []
                                // console.log(groups);
                                groups[key].forEach((d) => {
                                    let dtS = d.download_file_report_name;
                                    let kS = this.state.search;
                                    if (dtS.toLowerCase().includes(kS.toLowerCase())) {
                                        itmDtl.push(d);
                                    }
                                })

                                let itm = {
                                    time: key,
                                    items: itmDtl
                                }

                                if (itmDtl.length > 0) {
                                    arr.push(itm)
                                }
                            }                         
                        }
                        this.setState({ listDownload: arr, oldListDownload: arr })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    groupItems(array, property) {
        return array.reduce(function (groups, item) {
            var reference = moment(item.created_at).format("DD-MM-YYYY");
            var pastDate = moment(reference, "DD-MM-YYYY");
            var todayDate = moment(moment().format("DD-MM-YYYY"), "DD-MM-YYYY");
            let dDiff = todayDate.diff(pastDate, "days");
            var name = item.status === 0 ? "" : (dDiff === 0 ? "Today" : dDiff === 1 ? "Yesterday" : "Days Ago");
            var group = groups[name] || (groups[name] = []);
            group.push(item);
            return groups;
        }, {});
    }

    async handleDownload(idFile, name) {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/download/zip-files?downloadedFileReportId=${idFile}`
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/download/zip-files?downloadedFileReportId=${idFile}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = `${name}.zip`;
            a.click();
        }
    }

    handleChange(e, type) {
        this.setState({ search: e.target.value }, () => {
            if (this.state.search.length == 0) {
                this.setState({ listDownload: this.state.oldListDownload })
            }
        })
    }

    // handleSearch(key) {
    //     this.setState({ isSearch: true }, () => {
    //         let newListDownload = []
    //         console.log(this.state.oldListDownload);
    //         this.state.oldListDownload.forEach((i) => {
    //             let itmDtl = []
    //             i.items.forEach((d) => {
    //                 let dtS = d.download_file_report_name;
    //                 let kS = this.state.search;
    //                 if (dtS.toLowerCase().includes(kS.toLowerCase())) {
    //                     itmDtl.push(d);
    //                 }
    //             })

    //             let itm = {
    //                 time: i.time,
    //                 items: itmDtl
    //             }
                
    //             if (itmDtl.length > 0) {
    //                 newListDownload.push(itm)
    //             }
    //         })
    //         console.log(newListDownload);
    //         this.setState({ listDownload: newListDownload, isSearch: false })
    //     })
    // }

    render() {
        let { listDownload, messageAlert, pageEmpty } = this.state
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ flex: 1, backgroundColor: '#f8f8f8', minHeight: this.props.height, boxShadow: 'none' }}>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {messageAlert}
                    </Alert>
                </Snackbar>
                <div>
                    {this.state.loading && loadingComponent}
                    <div className={"main-color"} style={{ height: 78, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                        <Typography style={{ fontSize: '16px', color: 'white' }}>Download Report</Typography>
                    </div>

                    {listDownload.length > 0 || this.state.search.length != 0 ?
                        <div style={{ padding: 20, width: '100%' }}>
                            <Paper style={{ paddingTop: 10, minHeight: this.props.height, paddingBottom: 50, background: '#d9d9d91c' }}>
                                <div style={{ margin: '40px 100px', background: '#fff', borderRadius: 10, minHeight: this.props.height, padding: 45 }}>
                                    <div style={{ display: 'flex', justifyContent: 'flex-end', marginBottom: 10 }}>
                                        <TextField
                                            variant="outlined"
                                            id="search"
                                            name="search"
                                            value={this.state.search}
                                            onChange={(e) => this.handleChange(e, '')}
                                            size="small"
                                            InputProps={{
                                                style: { borderRadius: 7 },
                                                endAdornment: <InputAdornment position="end"><SearchIcon /></InputAdornment>,
                                            }}
                                        />
                                    </div>
                                    {!this.state.isSearch && (
                                    listDownload.map((listItem) => {
                                        return (
                                            <div>
                                                <div style={{ fontSize: 18, fontWeight: 700, color: '#273B80', marginLeft: 5, marginBottom: 10 }}>{listItem.time}</div>
                                                {listItem.items.length > 0 &&
                                                    listItem.items.map((item) => {
                                                        return (
                                                            <div>
                                                                {item.status == 0 ?
                                                                    null
                                                                    :
                                                                    <div style={{ display: 'flex' }}>
                                                                        <div style={{ background: '#D9D9D9', borderRadius: 10, marginBottom: 15, marginRight: 2, borderBottomRightRadius: 0, borderTopRightRadius: 0 }}>
                                                                            <div style={{ alignItems: 'center', display: 'flex' }}>
                                                                                <img src={Images.zip} style={{ width: 80, margin: 9 }} />
                                                                            </div>
                                                                        </div>
                                                                        <div style={{ display: 'flex', justifyContent: 'space-between', width: '100%', background: '#D9D9D9', borderRadius: 10, marginBottom: 15, borderBottomLeftRadius: 0, borderTopLeftRadius: 0 }}>
                                                                            <div style={{ marginRight: 10 }}>
                                                                                <Typography style={{ fontSize: 18, color: '#273B80', fontWeight: 700, marginTop: 10, marginLeft: 10 }}>{item.download_file_report_name}</Typography>
                                                                                <Typography style={{ marginLeft: 10, marginTop: 5, fontSize: 11, marginBottom: 10 }}>Last Download by: {item.created_by}  -  {item.created_at}</Typography>
                                                                            </div>
                                                                            <div style={{ display: 'flex', justifyContent: 'center', marginRight: 20 }}>
                                                                                {item.status === 1 ?
                                                                                    <button
                                                                                        type="button"
                                                                                        disabled={true}
                                                                                        onClick={() => null}
                                                                                        style={{
                                                                                            backgroundColor: 'transparent',
                                                                                            borderColor: 'transparent',
                                                                                            outline: 'none',
                                                                                        }}
                                                                                    >
                                                                                        <div style={{ backgroundColor: '#939497de', width: 140, height: 40, borderRadius: 10, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                                                            <Typography style={{ fontSize: '16px', color: '#fff', textAlign: 'center' }}>In Progress</Typography>
                                                                                        </div>
                                                                                    </button>
                                                                                    :
                                                                                    item.status === 2 ?
                                                                                        <button
                                                                                            type="button"
                                                                                            // disabled={this.state.buttonError}
                                                                                            onClick={() => this.handleDownload(item.download_file_report_id, item.download_file_report_name)}
                                                                                            style={{
                                                                                                backgroundColor: 'transparent',
                                                                                                borderColor: 'transparent',
                                                                                                outline: 'none',
                                                                                            }}
                                                                                        >
                                                                                            <div style={{ backgroundColor: '#354960', width: 140, height: 40, borderRadius: 10, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                                                                <Typography style={{ fontSize: '16px', color: '#fff', textAlign: 'center' }}>Download</Typography>
                                                                                            </div>
                                                                                        </button>
                                                                                        :
                                                                                        item.status === 3 ?
                                                                                            <button
                                                                                                type="button"
                                                                                                // disabled={this.state.buttonError}
                                                                                                onClick={() => this.handleDownload(item.download_file_report_id, item.download_file_report_name)}
                                                                                                style={{
                                                                                                    backgroundColor: 'transparent',
                                                                                                    borderColor: 'transparent',
                                                                                                    outline: 'none',
                                                                                                }}
                                                                                            >
                                                                                                <div style={{ backgroundColor: '#354960', width: 140, height: 40, borderRadius: 10, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                                                                    <Typography style={{ fontSize: '16px', color: '#fff', textAlign: 'center' }}>Download <span><CheckCircleIcon fontSize='small' style={{ marginBottom: 1, marginLeft: 7 }} /></span></Typography>
                                                                                                </div>
                                                                                            </button>
                                                                                            :
                                                                                            null
                                                                                }

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                }
                                                            </div>

                                                        )
                                                    })}
                                            </div>

                                        )
                                    })
                                    )}
                                    <div style={{ fontSize: this.state.listDownload.length > 0 ? 12 : 18, fontWeight: 700, color: this.state.listDownload.length > 0 ? 'red' : 'black', marginLeft: 5, marginBottom: 10 }}>{this.state.listDownload.length > 0 ? 'Note : File download akan hilang dalam 3 hari setelah di generate.' : 'Data not found.'}</div>
                                </div>
                            </Paper>
                        </div>
                        :
                        <div style={{ flex: 1, height: '100vh', alignItems: 'center', justifyContent: 'center', display: 'flex' }}>
                            <div style={{ flexDirection: 'column', textAlign: 'center' }}>
                                <CloudDownloadIcon style={{ fontSize: 50, color: 'grey' }} />
                                <h3 style={{ marginTop: 5, color: 'grey' }}>
                                    Download Report Empty
                                </h3>
                            </div>
                        </div>
                    }

                    {/* {this.state.pageEmpty &&
                        <div style={{ flex: 1, height: '100vh', alignItems: 'center', justifyContent: 'center', display: 'flex' }}>
                            <div style={{ flexDirection: 'column', textAlign: 'center' }}>
                                <CloudDownloadIcon style={{ fontSize: 50, color: 'grey' }} />
                                <h3 style={{ marginTop: 5, color: 'grey' }}>
                                    Download Report Empty
                                </h3>
                            </div>
                        </div>
                    } */}

                </div>
            </div>
        );

    }
}

export default DownloadReport;
