import React, { Component } from 'react';
import Images from '../../assets/Images';
import { Typography } from '@material-ui/core';
import api from "../../api";
import Constant from '../../library/Constant';

export default class PopUpKonfirmasi extends Component {
    constructor(props) {
        super(props)
        this.state = {
        }
    }

    componentDidMount() {
    }
    onClickUpload() {
        let payload = this.props.data
        this.props.uploadDocId(payload)
    }
    
    render() {
        return (
            <div className="test app-popup-show" style={{ zIndex: 2500}}>
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div style={{ display: 'flex', justifyContent: 'center', paddingTop: 20 }}>
                        <img src={Images.failed} />
                    </div>
                    <div style={{ display: 'grid', justifyContent: 'center', marginTop: 20, paddingBottom: 20 }}>
                        <span style={{ textAlign: 'center', fontSize: 14, fontWeight: 'bold', fontFamily: 'Nunito Sans, sans-serif' }}>
                            The Document Already Exists in The System, <br />
                            Do You Want to Overwrite It?
                        </span>
                    </div>
                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClosePopUp()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={()=> this.onClickUpload()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Rewrite</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}
