import React, { Component } from 'react';
import { createMuiTheme, FormControlLabel, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, withStyles, Input, ThemeProvider, TextareaAutosize } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import Constant from '../../library/Constant';
import { titleCase } from '../../library/Utils';
import { Autocomplete } from '@material-ui/lab';
import { PropagateLoader } from 'react-spinners';
import ReactTooltip from 'react-tooltip';
import { DatePicker } from '@material-ui/pickers';
import { format } from 'date-fns';
import { BorderStyle } from '@material-ui/icons';
import { includes, update } from 'ramda';
import Snackbar from '@material-ui/core/Snackbar';
import MuiAlert from '@material-ui/lab/Alert';
import { makeStyles } from '@material-ui/core/styles';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { fixNumber, roundMath } from "../../library/Utils";
import LOCF from './LOCFMR';
import LOV from './LOVMR';
import PopUpValidationLOV from '../../library/PopUpValidationLOV';

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

// function Alert(props) {
//     return <MuiAlert elevation={6} variant="filled" {...props} />;
// }

const useStyles = makeStyles((theme) => ({
    root: {
        width: '100%',
        '& > * + *': {
            marginTop: theme.spacing(2),
        },
    },
}));

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);
var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());
const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};

const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

const theme = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea',
                marginTop: -10,
                textAlign: 'center'
            }
        }
    },
});

const theme2 = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea',
                textAlign: 'center'
            }
        }
    },
});

const theme3 = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#black',
                textAlign: 'center'
            }
        }
    },
});

export default class ListOfCreditFacilities extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            dataTableLOV: [],
            dataTableLOCF: [],
            datas: null,
            lastArrayLOCF: null,
            lastArrayLOV: null,
            bankNameList: [],
            typeOfCreditList: [],
            loading: false,
            loadingChild: false,
            dataTableRatio: [],
            currentDate: format(new Date(), 'yyyy-MM-dd'),
            totalOutStand: 0,
            diffLOCF: 0,
            perBSLOCF: 0,
            totalLoanLOCF: 0,
            diffLOV: 0,
            perBSLOV: 0,
            totalLoanLOV: 0,
            snekbar: false,
            snekbarMsg: '',
            visibleParent: true,
            buttonError: false,
            saveDraft: true,
            saveComp: true,
            saveCompLOV: true,
            get_for: 'view',
            updateBy: [],
            notes: "",
            viewOnly: true,
            dataDelete: [],
            saveTambahan: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            emptyData: false,
        }
    }

    componentDidMount() {
        // this.getperBSLOCF()
        // this.getBankData()
        // this.getTypeOfCredit()
        this.getSubmission()
        this.getLatestUpdate()
        this.handleViewOnly()
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            // this.getperBSLOCF()
            // this.getBankData()
            // this.getTypeOfCredit()
            // this.getSubmission()
            // this.getLatestUpdate()
        })
    }

    dataTableForChild(data, array, params, type, visibleView, updateData) {
        // console.log(visibleView);
        // console.log(type);
        switch (params) {
            case "LOV":
                console.log(data);
                this.setState({ dataTableLOV: data, diffLOV: array[16], totalLoanLOV: array[17], perBSLOV: array[18], tambahLOV: type, visibleParent: visibleView == undefined ? true : visibleView, updateData: updateData })
                break;
            case "LOCF":
                this.setState({ dataTableLOCF: data, diffLOCF: array[47], totalLoanLOCF: array[48], perBSLOCF: array[49], tambah: type, visibleParent: visibleView == undefined ? true : visibleView, updateDataLOCF: updateData })
                break
            default:
                break;
        }
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({viewOnly: true})
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        // console.log(payload)
        api.create().getLastestUpdateMR(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, typeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                // console.log('brrrrrrrr')
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }



    deleteReport() {
        let payload = { "item_report_id": this.state.dataDelete, "periode": this.props.periode, "months": this.props.month.month_id }

        if (this.state.dataDelete.length > 0) {
            api.create().deleteAllItemReportLOCF(payload).then((response) => {
                console.log(response)
            })
        }
    }

    getSubmission() {
        this.setState({ loading: true })
        let payload = {
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "is_approver": true
        }
        api.create().getSubmission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        submissionID: response.data.data.submission_id,
                        lastRevision: response.data.data.last_revision,
                    }, () => {
                        // this.getDataRatio()

                    })
                } else {
                    this.setState({ submissionID: null, loading: false })
                }
            }
        })
    }

    backToMonthlyReportLOCF(type) {
        console.log('masoook LOCF');
        let dataTable2 = (this.state.dataTablelocf !== undefined && this.state.tambah == 'upload') ? this.state.dataTablelocf : (this.state.dataTablelocf == undefined || this.state.tambah == 'tambah' || this.state.tambah == 'upload') ? this.state.dataTableLOCF : this.state.dataTablelocf
        let data = []
        let error = false
        // this.deleteReport()
        console.log(dataTable2);
        dataTable2.map(i => {
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[8] == "" || i[10] == "" || i[11] == "" || i[12] == "") {
                    error = true
                }

                if (i[7].value == 'Others' && i[19] == '') {
                    error = true
                }
                let tgl = String(i[10]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "remarks2": i[9] == null ? i[9] : i[9].value,
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[10] == undefined || i[10] == "null" || i[10] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[10])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[11] == "" ? "0.00" : i[11],
                        "currency": i[12],
                        "loan_plafond_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "loan_plafond_amount_idr": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_ori": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_ki_amount_idr": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_ori": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        "out_loan_kmk_amount_idr": Number(i[18]) == "" ? "0.0" : Number(i[18]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[19],
                        "out_loan_other_amount_ori": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "out_loan_other_amount_idr": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_ori": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "total_out_loan_idr": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_ori": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "remaining_plafond_idr": Number(i[25]) == "" ? "0.0" : Number(i[25]),
                        "current_ratio_financial": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "current_ratio_current": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_financial": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "der_current": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_financial": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "debt_to_ebitda_current": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_financial": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "ebitda_to_interest_current": Number(i[33]) == "" ? "0.00" : Number(i[33]),
                        "other_ratio1_ratio_name": i[34],
                        "other_ratio1_financial": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio1_current": Number(i[36]) == "" ? "0.00" : Number(i[36]),
                        "other_ratio2_ratio_name": i[37],
                        "other_ratio2_financial": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio2_current": Number(i[39]) == "" ? "0.00" : Number(i[39]),
                        "other_ratio3_ratio_name": i[40],
                        "other_ratio3_financial": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio3_current": Number(i[42]) == "" ? "0.00" : Number(i[42]),
                        "other_ratio4_ratio_name": i[43],
                        "other_ratio4_financial": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "other_ratio4_current": Number(i[45]) == "" ? "0.00" : Number(i[45]),
                        "notes": i[46],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "remarks2": i[9] == null ? i[9] : i[9].value,
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[10] == undefined || i[10] == "null" || i[10] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[10])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[11] == "" ? "0.00" : i[11],
                        "currency": i[12],
                        "loan_plafond_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "loan_plafond_amount_idr": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_ori": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_ki_amount_idr": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_ori": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        "out_loan_kmk_amount_idr": Number(i[18]) == "" ? "0.0" : Number(i[18]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[19],
                        "out_loan_other_amount_ori": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "out_loan_other_amount_idr": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_ori": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "total_out_loan_idr": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_ori": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "remaining_plafond_idr": Number(i[25]) == "" ? "0.0" : Number(i[25]),
                        "current_ratio_financial": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "current_ratio_current": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_financial": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "der_current": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_financial": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "debt_to_ebitda_current": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_financial": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "ebitda_to_interest_current": Number(i[33]) == "" ? "0.00" : Number(i[33]),
                        "other_ratio1_ratio_name": i[34],
                        "other_ratio1_financial": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio1_current": Number(i[36]) == "" ? "0.00" : Number(i[36]),
                        "other_ratio2_ratio_name": i[37],
                        "other_ratio2_financial": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio2_current": Number(i[39]) == "" ? "0.00" : Number(i[39]),
                        "other_ratio3_ratio_name": i[40],
                        "other_ratio3_financial": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio3_current": Number(i[42]) == "" ? "0.00" : Number(i[42]),
                        "other_ratio4_ratio_name": i[43],
                        "other_ratio4_financial": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "other_ratio4_current": Number(i[45]) == "" ? "0.00" : Number(i[45]),
                        "notes": i[46],
                    })
                }

            }
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "locf": data,
            "per_bs": this.state.perBSLOCF,
            "diff": this.state.diffLOCF,
            "total_loan": this.state.totalLoanLOCF
        }
        console.log(body);
        console.log(error);
        if (error && type == 'submitted') {
            this.setState({ handleDoubleClick: 0, saveDraft: false, saveComp: true, loadingChild: false, snekbar: true, snekbarMsg: 'Data Incomplete', handleDoubleClick: 0 })
        } else {
            api.create('UPLOAD').createMonthlyReportLOCF(body).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === "success") {
                            this.backToMonthlyReportLOV(type)
                        } else {
                            if (response.data?.message == "Please Set Up Rate Currency First") {
                                this.setState({ visibleAlertSave: true })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                            // alert(response.data.status)
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                }
                this.setState({ handleDoubleClick: 0 })
            })
        }
    }

    backToMonthlyReportLOV(type) {
        console.log('masoook LOV');
        let dataTable2 = []
        let data = []
        let error = false
        // this.deleteReport()
        if (this.state.dataTablelov !== undefined && this.state.tambahLOV == undefined) {
            dataTable2 = this.state.dataTablelov
        } else {
            dataTable2 = this.state.dataTableLOV
            this.setState({ updateTambah: true, updateData: false })
            if (this.state.tambahLOV = 'tambah' && this.state.updateData == false) {
                dataTable2 = this.state.dataTablelov
            } else {
                dataTable2 = this.state.dataTableLOV
            }

        }
        console.log(dataTable2);
        dataTable2.map(i => {
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[9] == "" || i[10] == "" || i[11] == "" || i[12] == "") {
                    console.log('masuk sini');
                    error = true
                }
                console.log(i[7]?.value);

                if ((i[7].value == 'Government bonds' && i[8] == '') || (i[7].value == 'Stocks' && i[8] == '') || (i[7].value == 'Mutual funds' && i[8] == '') || (i[7].value == 'Investment in associate' && i[8] == '') || (i[7].value == 'Investment in joint venture' && i[8] == '') || (i[7].value == 'Investment in subsidiary' && i[8] == '') || (i[7].value == 'Corporate bonds' && i[8] == '') || (i[7].value == 'Others' && i[8] == '')) {
                    error = true
                } else {
                    error = false
                }
                let tgl = String(i[9]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "company_name": i[5],
                        "institution_name": i[6],
                        "type_of_investment": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "placement_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        "tenor": i[10],
                        "expected_return": i[11] == "" ? "0.00" : i[11],
                        // "currency": i[12] == null ? i[12] : i[12].value,
                        "currency": i[12],
                        "investment_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "investment_amount_cur": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "notes": i[15],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "company_name": i[5],
                        "institution_name": i[6],
                        "type_of_investment": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "placement_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        "tenor": i[10],
                        "expected_return": i[11] == "" ? "0.00" : i[11],
                        // "currency": i[12] == null ? i[12] : i[12].value,
                        "currency": i[12],
                        "investment_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "investment_amount_cur": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "notes": i[15],
                    })
                }

            }
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "lov": data,
            "per_bs": this.state.perBSLOV,
            "diff": this.state.diffLOV,
            "total_loan": this.state.totalLoanLOV
        }
        console.log(body);
        console.log(error);
        if (error && type == 'submitted') {
            this.setState({ handleDoubleClick: 0, saveDraft: false, saveComp: true, loadingChild: false, snekbar: true, snekbarMsg: 'Data Incomplete', handleDoubleClick: 0 })
        } else {
            api.create('UPLOAD').createMonthlyReportLOV(body).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === "success") {
                            this.props.saveToMonthlyReport('LOCF')
                            this.setState({ loadingChild: false })
                        } else {
                            if (response.data?.message == "Please Set Up Rate Currency First") {
                                this.setState({ visibleAlertSave: true })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loadingChild: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                            // alert(response.data.status)
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loadingChild: false, handleDoubleClick: 0 })
                    }
                } else {
                    console.log(response.problem);
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loadingChild: false, handleDoubleClick: 0 })
                }
                this.setState({ handleDoubleClick: 0 })
            })
        }
    }

    handleCalculateLOCF = () => {
        this.setState({ loading: true })
        // console.log(this.state.dataTableLOCF);
        // console.log(this.state.dataTablelocf);
        // console.log(this.state.tambah);
        let dataTable2 = (this.state.dataTablelocf !== undefined && this.state.tambah == 'upload') ? this.state.dataTablelocf : (this.state.dataTablelocf == undefined || this.state.tambah == 'tambah' || this.state.tambah == 'upload') ? this.state.dataTableLOCF : this.state.dataTablelocf
        let data = []
        let error = false
        let bankNameEmpty = false
        console.log(dataTable2);
        dataTable2.map(i => {
            if (i[6] == null) {
                bankNameEmpty = true
            }
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[8] == "" || i[10] == "" || i[11] == "" || i[12] == "") {
                    error = true
                }

                if (i[7].value == 'Others' && i[18] == '') {
                    error = true
                }
                let tgl = String(i[10]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "remarks2": i[9] == null ? i[9] : i[9].value,
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[10] == undefined || i[10] == "null" || i[10] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[10])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[11] == "" ? "0.00" : i[11],
                        "currency": i[12],
                        "loan_plafond_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "loan_plafond_amount_idr": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_ori": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_ki_amount_idr": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_ori": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        "out_loan_kmk_amount_idr": Number(i[18]) == "" ? "0.0" : Number(i[18]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[19],
                        "out_loan_other_amount_ori": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "out_loan_other_amount_idr": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_ori": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "total_out_loan_idr": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_ori": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "remaining_plafond_idr": Number(i[25]) == "" ? "0.0" : Number(i[25]),
                        "current_ratio_financial": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "current_ratio_current": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_financial": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "der_current": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_financial": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "debt_to_ebitda_current": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_financial": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "ebitda_to_interest_current": Number(i[33]) == "" ? "0.00" : Number(i[33]),
                        "other_ratio1_ratio_name": i[34],
                        "other_ratio1_financial": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio1_current": Number(i[36]) == "" ? "0.00" : Number(i[36]),
                        "other_ratio2_ratio_name": i[37],
                        "other_ratio2_financial": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio2_current": Number(i[39]) == "" ? "0.00" : Number(i[39]),
                        "other_ratio3_ratio_name": i[40],
                        "other_ratio3_financial": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio3_current": Number(i[42]) == "" ? "0.00" : Number(i[42]),
                        "other_ratio4_ratio_name": i[43],
                        "other_ratio4_financial": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "other_ratio4_current": Number(i[45]) == "" ? "0.00" : Number(i[45]),
                        "notes": i[46],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "remarks2": i[9] == null ? i[9] : i[9].value,
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[10] == undefined || i[10] == "null" || i[10] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[10])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[11] == "" ? "0.00" : i[11],
                        "currency": i[12],
                        "loan_plafond_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "loan_plafond_amount_idr": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_ori": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_ki_amount_idr": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_ori": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        "out_loan_kmk_amount_idr": Number(i[18]) == "" ? "0.0" : Number(i[18]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[19],
                        "out_loan_other_amount_ori": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "out_loan_other_amount_idr": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_ori": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "total_out_loan_idr": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_ori": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "remaining_plafond_idr": Number(i[25]) == "" ? "0.0" : Number(i[25]),
                        "current_ratio_financial": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "current_ratio_current": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_financial": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "der_current": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_financial": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "debt_to_ebitda_current": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_financial": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "ebitda_to_interest_current": Number(i[33]) == "" ? "0.00" : Number(i[33]),
                        "other_ratio1_ratio_name": i[34],
                        "other_ratio1_financial": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio1_current": Number(i[36]) == "" ? "0.00" : Number(i[36]),
                        "other_ratio2_ratio_name": i[37],
                        "other_ratio2_financial": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio2_current": Number(i[39]) == "" ? "0.00" : Number(i[39]),
                        "other_ratio3_ratio_name": i[40],
                        "other_ratio3_financial": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio3_current": Number(i[42]) == "" ? "0.00" : Number(i[42]),
                        "other_ratio4_ratio_name": i[43],
                        "other_ratio4_financial": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "other_ratio4_current": Number(i[45]) == "" ? "0.00" : Number(i[45]),
                        "notes": i[46],
                    })
                }

            }
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": 'submitted',
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "locf": data,
            "per_bs": this.state.perBSLOCF,
            "diff": this.state.diffLOCF,
            "total_loan": this.state.totalLoanLOCF
        }
        console.log(body);
        api.create().validateSaveLOCF(body).then((response) => {
            console.log(response);
            let dataTablelocf = []
            if (response.data) {
                if (response.data.status == 'success') {

                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTablelocf.findIndex((val) => val[1] === item.id)
                        let tgl = String(item.locf.loan_maturity_date).split('-')
                        if (indexIDzz === -1) {
                            dataTablelocf.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                String(item.locf.bank_name).includes('Total') ? null : item.locf.borrower_comp_name === null || item.locf.borrower_comp_name === "" ? this.props.company.company_name : item.locf.borrower_comp_name,
                                item.locf.bank_name === null ? null : item.locf.bank_name === "" ? null : { value: item.locf.bank_name },
                                item.locf.type_of_credit === null ? null : item.locf.type_of_credit === "" ? null : { value: item.locf.type_of_credit },
                                item.locf.remarks === null || item.locf.remarks === "" ? "" : item.locf.remarks,
                                item.locf.remarks2 === null ? null : item.locf.remarks2 === "" ? null : { value: item.locf.remarks2 },
                                item.locf.loan_maturity_date == null || item.locf.loan_maturity_date == "" ? null : (item.locf.loan_maturity_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.locf.loan_maturity_date) : null),
                                item.locf.interest === null || item.locf.interest === "" ? "0.00" : item.locf.interest,
                                item.locf.currency === null || item.locf.currency === "" ? "" : item.locf.currency,
                                item.locf.loan_plafond_amount_ori,
                                item.locf.loan_plafond_amount_idr === null ? "0.0" : item.locf.loan_plafond_amount_idr === "" ? "0.0" : item.locf.loan_plafond_amount_idr,
                                item.locf.out_loan_ki_amount_ori,
                                item.locf.out_loan_ki_amount_idr === null ? "0.0" : item.locf.out_loan_ki_amount_idr === "" ? "0.0" : item.locf.out_loan_ki_amount_idr,
                                item.locf.out_loan_kmk_amount_ori,
                                item.locf.out_loan_kmk_amount_idr === null ? "0.0" : item.locf.out_loan_kmk_amount_idr === "" ? "0.0" : item.locf.out_loan_kmk_amount_idr,
                                item.locf.out_loan_other_type,
                                item.locf.out_loan_other_amount_ori,
                                item.locf.out_loan_other_amount_idr === null ? "0.0" : item.locf.out_loan_other_amount_idr === "" ? "0.0" : item.locf.out_loan_other_amount_idr,
                                item.locf.total_out_loan_ori === null ? "0.0" : item.locf.total_out_loan_ori === "" ? "0.0" : item.locf.total_out_loan_ori,
                                item.locf.total_out_loan_idr === null ? "0.0" : item.locf.total_out_loan_idr === "" ? "0.0" : item.locf.total_out_loan_idr,
                                item.locf.remaining_plafond_ori === null ? "0.0" : item.locf.remaining_plafond_ori === "" ? "0.0" : item.locf.remaining_plafond_ori,
                                item.locf.remaining_plafond_idr === null ? "0.0" : item.locf.remaining_plafond_idr === "" ? "0.0" : item.locf.remaining_plafond_idr,
                                item.locf.current_ratio_financial,
                                item.locf.current_ratio_current === null ? "0.0" : item.locf.current_ratio_current === "" ? "0.0" : item.locf.current_ratio_current,
                                item.locf.der_financial,
                                item.locf.der_current === null ? "0.0" : item.locf.der_current === "" ? "0.0" : item.locf.der_current,
                                item.locf.debt_to_ebitda_financial,
                                item.locf.debt_to_ebitda_current === null ? "0.0" : item.locf.debt_to_ebitda_current === "" ? "0.0" : item.locf.debt_to_ebitda_current,
                                item.locf.ebitda_to_interest_financial,
                                item.locf.ebitda_to_interest_current === null ? "0.0" : item.locf.ebitda_to_interest_current === "" ? "0.0" : item.locf.ebitda_to_interest_current,
                                item.locf.other_ratio1_ratio_name,
                                item.locf.other_ratio1_financial,
                                item.locf.other_ratio1_current === null ? "0.0" : item.locf.other_ratio1_current === "" ? "0.0" : item.locf.other_ratio1_current,
                                item.locf.other_ratio2_ratio_name,
                                item.locf.other_ratio2_financial,
                                item.locf.other_ratio2_current === null ? "0.0" : item.locf.other_ratio2_current === "" ? "0.0" : item.locf.other_ratio2_current,
                                item.locf.other_ratio3_ratio_name,
                                item.locf.other_ratio3_financial,
                                item.locf.other_ratio3_current === null ? "0.0" : item.locf.other_ratio3_current === "" ? "0.0" : item.locf.other_ratio3_current,
                                item.locf.other_ratio4_ratio_name,
                                item.locf.other_ratio4_financial,
                                item.locf.other_ratio4_current === null ? "0.0" : item.locf.other_ratio4_current === "" ? "0.0" : item.locf.other_ratio4_current,
                                item.locf.notes,
                                item.diff,
                                item.total_loan,
                                item.per_bs
                                // index
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        let tgl = String(item.locf.loan_maturity_date).split('-')
                        dataTablelocf.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            String(item.locf.bank_name).includes('Total') ? null : item.locf.borrower_comp_name === null || item.locf.borrower_comp_name === "" ? this.props.company.company_name : item.locf.borrower_comp_name,
                            item.locf.bank_name === null ? null : item.locf.bank_name === "" ? null : { value: item.locf.bank_name },
                            item.locf.type_of_credit === null ? null : item.locf.type_of_credit === "" ? null : { value: item.locf.type_of_credit },
                            item.locf.remarks === null || item.locf.remarks === "" ? "" : item.locf.remarks,
                            item.locf.remarks2 === null ? null : item.locf.remarks2 === "" ? null : { value: item.locf.remarks2 },
                            item.locf.loan_maturity_date == null || item.locf.loan_maturity_date == "" ? null : (item.locf.loan_maturity_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.locf.loan_maturity_date) : null),
                            item.locf.interest === null || item.locf.interest === "" ? "0.00" : item.locf.interest,
                            item.locf.currency === null || item.locf.currency === "" ? "" : item.locf.currency,
                            item.locf.loan_plafond_amount_ori,
                            item.locf.loan_plafond_amount_idr === null ? "0.0" : item.locf.loan_plafond_amount_idr === "" ? "0.0" : item.locf.loan_plafond_amount_idr,
                            item.locf.out_loan_ki_amount_ori,
                            item.locf.out_loan_ki_amount_idr === null ? "0.0" : item.locf.out_loan_ki_amount_idr === "" ? "0.0" : item.locf.out_loan_ki_amount_idr,
                            item.locf.out_loan_kmk_amount_ori,
                            item.locf.out_loan_kmk_amount_idr === null ? "0.0" : item.locf.out_loan_kmk_amount_idr === "" ? "0.0" : item.locf.out_loan_kmk_amount_idr,
                            item.locf.out_loan_other_type,
                            item.locf.out_loan_other_amount_ori,
                            item.locf.out_loan_other_amount_idr === null ? "0.0" : item.locf.out_loan_other_amount_idr === "" ? "0.0" : item.locf.out_loan_other_amount_idr,
                            item.locf.total_out_loan_ori === null ? "0.0" : item.locf.total_out_loan_ori === "" ? "0.0" : item.locf.total_out_loan_ori,
                            item.locf.total_out_loan_idr === null ? "0.0" : item.locf.total_out_loan_idr === "" ? "0.0" : item.locf.total_out_loan_idr,
                            item.locf.remaining_plafond_ori === null ? "0.0" : item.locf.remaining_plafond_ori === "" ? "0.0" : item.locf.remaining_plafond_ori,
                            item.locf.remaining_plafond_idr === null ? "0.0" : item.locf.remaining_plafond_idr === "" ? "0.0" : item.locf.remaining_plafond_idr,
                            item.locf.current_ratio_financial,
                            item.locf.current_ratio_current === null ? "0.0" : item.locf.current_ratio_current === "" ? "0.0" : item.locf.current_ratio_current,
                            item.locf.der_financial,
                            item.locf.der_current === null ? "0.0" : item.locf.der_current === "" ? "0.0" : item.locf.der_current,
                            item.locf.debt_to_ebitda_financial,
                            item.locf.debt_to_ebitda_current === null ? "0.0" : item.locf.debt_to_ebitda_current === "" ? "0.0" : item.locf.debt_to_ebitda_current,
                            item.locf.ebitda_to_interest_financial,
                            item.locf.ebitda_to_interest_current === null ? "0.0" : item.locf.ebitda_to_interest_current === "" ? "0.0" : item.locf.ebitda_to_interest_current,
                            item.locf.other_ratio1_ratio_name,
                            item.locf.other_ratio1_financial,
                            item.locf.other_ratio1_current === null ? "0.0" : item.locf.other_ratio1_current === "" ? "0.0" : item.locf.other_ratio1_current,
                            item.locf.other_ratio2_ratio_name,
                            item.locf.other_ratio2_financial,
                            item.locf.other_ratio2_current === null ? "0.0" : item.locf.other_ratio2_current === "" ? "0.0" : item.locf.other_ratio2_current,
                            item.locf.other_ratio3_ratio_name,
                            item.locf.other_ratio3_financial,
                            item.locf.other_ratio3_current === null ? "0.0" : item.locf.other_ratio3_current === "" ? "0.0" : item.locf.other_ratio3_current,
                            item.locf.other_ratio4_ratio_name,
                            item.locf.other_ratio4_financial,
                            item.locf.other_ratio4_current === null ? "0.0" : item.locf.other_ratio4_current === "" ? "0.0" : item.locf.other_ratio4_current,
                            item.locf.notes,
                            item.diff,
                            item.total_loan,
                            item.per_bs
                            // index
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })

                    let lastArrayLOCF = dataTablelocf[res.length - 1]
                    let roundDataDiff = fixNumber(Number(lastArrayLOCF[47]), 1)
                    let roundDataLoan = fixNumber(Number(lastArrayLOCF[48]), 1)
                    let roundDataPerBS = fixNumber(Number(lastArrayLOCF[49]), 1)
                    console.log(dataTablelocf);
                    if (bankNameEmpty) {
                        if (this.state.get_for == 'view') {
                            this.setState({ saveDraft: false, saveComp: true })
                        } else {
                            this.setState({ saveDraft: false, saveComp: true })
                        }
                    } else {
                        if (this.state.get_for == 'view') {
                            console.log("view");
                        } else {
                            this.setState({ saveDraft: false, saveComp: roundDataDiff == 0 || roundDataDiff == '0.0' || roundDataDiff == "-0.0" ? false : true })
                        }
                    }
                    this.setState({ dataTablelocf, diffLOCF: roundDataDiff, totalLoanLOCF: roundDataLoan, perBSLOCF: roundDataPerBS, loading: false }, () => {
                        this.handleCalculateLOV()
                    })
                }
            }

        })
    }

    handleCalculateLOV = () => {
        this.setState({ loading: true })
        // console.log(this.state.dataTablelov);
        // console.log(this.state.dataTableLOV);
        // console.log(this.state.tambahLOV);
        // console.log(this.state.visibleParent);

        let dataTable2 = []
        let data = []
        let error = false
        let bankNameEmpty = false

        if (this.state.visibleParent == false) {
            if (this.state.dataTablelov == undefined) {
                dataTable2 = this.state.dataTableLOV
            } else {
                if (this.state.tambahLOV = 'upload') {
                    this.setState({ updateTambah: true })
                    if (this.state.updateData == true) {
                        dataTable2 = this.state.dataTableLOV
                        this.setState({ cekTambah: true })
                        if (this.state.updateTambah == true && this.state.updateData == true) {
                            dataTable2 = this.state.dataTablelov
                            if (this.state.cekTambah == undefined) {
                                dataTable2 = this.state.dataTableLOV
                            }
                        }
                    } else {
                        dataTable2 = this.state.dataTablelov
                    }
                    this.setState({ updateData: true })
                } else if (this.state.tambahLOV = 'tambah') {
                    if (this.state.updateData == true) {
                        dataTable2 = this.state.dataTablelov
                    } else {
                        dataTable2 = this.state.dataTableLOV
                    }
                }
            }
        } else {
            if (this.state.dataTablelov !== undefined && this.state.tambahLOV == undefined) {
                console.log('1');
                dataTable2 = this.state.dataTablelov
            } else {
                console.log('2');
                dataTable2 = this.state.dataTableLOV
                this.setState({ updateTambah: true, updateData: false })
                if (this.state.tambahLOV = 'tambah' && this.state.updateData == false) {
                    console.log('3');
                    dataTable2 = this.state.dataTablelov
                } else {
                    console.log('4')
                    dataTable2 = this.state.dataTableLOV
                }

            }
        }

        console.log(dataTable2);
        dataTable2.map(i => {
            if (i[6] == null) {
                bankNameEmpty = true
            }
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[9] == "" || i[10] == "" || i[11] == "" || i[12] == "") {
                    error = true
                    this.setState({ emptyData: true})
                }

                if ((i[7]?.value == 'Government bonds' && i[8] == '') || (i[7]?.value == 'Stocks' && i[8] == '') || (i[7]?.value == 'Mutual funds' && i[8] == '') || (i[7]?.value == 'Investment in associate' && i[8] == '') || (i[7]?.value == 'Investment in joint venture' && i[8] == '') || (i[7]?.value == 'Investment in subsidiary' && i[8] == '') || (i[7]?.value == 'Corporate bonds' && i[8] == '') || (i[7]?.value == 'Others' && i[8] == '')) {
                    error = true
                }else {
                    if ((i[7].value == 'Government bonds' && i[8] == '') || (i[7].value == 'Stocks' && i[8] == '') || (i[7].value == 'Mutual funds' && i[8] == '') || (i[7].value == 'Investment in associate' && i[8] == '') || (i[7].value == 'Investment in joint venture' && i[8] == '') || (i[7].value == 'Investment in subsidiary' && i[8] == '') || (i[7].value == 'Corporate bonds' && i[8] == '') || (i[7].value == 'Others' && i[8] == '')) {
                        error = true
                        this.setState({ emptyData: true})
                    } else {
                        error = false
                    }
                }
                // if (i[7].value == 'Government bonds' || i[7].value == 'Stocks' || i[7].value == 'Mutual funds' || i[7].value == 'Investment in associate' || i[7].value == 'Investment in joint venture' || i[7].value == 'Investment in subsidiary' || i[7].value == 'Corporate bonds' || i[7].value == 'Others' && i[8] == '' ) {
                //     error = true
                // }
                let tgl = String(i[9]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "company_name": i[5],
                        "institution_name": i[6],
                        "type_of_investment": i[7] == null ? i[7] : i[7]?.value,
                        "remarks": i[8],
                        "placement_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        "tenor": i[10],
                        "expected_return": i[11] == "" ? "0.00" : i[11],
                        // "currency": i[12] == null ? i[12] : i[12].value,
                        "currency": i[12],
                        "investment_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "investment_amount_cur": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "notes": i[15],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "company_name": i[5],
                        "institution_name": i[6],
                        "type_of_investment": i[7] == null ? i[7] : i[7]?.value,
                        "remarks": i[8],
                        "placement_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        "tenor": i[10],
                        "expected_return": i[11] == "" ? "0.00" : i[11],
                        // "currency": i[12] == null ? i[12] : i[12].value,
                        "currency": i[12],
                        "investment_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "investment_amount_cur": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "notes": i[15],
                    })
                }

            }
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": 'submitted',
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "lov": data,
            "per_bs": this.state.perBSLOV,
            "diff": this.state.diffLOV,
            "total_loan": this.state.totalLoanLOV
        }
        console.log(body);
        console.log(error);
        api.create().validateSaveLOV(body).then((response) => {
            console.log(response);
            let dataTablelov = []
            if (response.data) {
                let res = response.data.data
                const handlePushChild = (item) => {
                    let indexIDzz = dataTablelov.findIndex((val) => val[1] === item.id)
                    let tgl = String(item.lov.placement_date).split('-')
                    if (indexIDzz === -1) {
                        dataTablelov.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            String(item.lov.institution_name).includes('Total') ? null : item.lov.company_name === null || item.lov.company_name === "" ? this.props.company.company_name : item.lov.company_name,
                            item.lov.institution_name === null || item.lov.institution_name === "" ? "" : item.lov.institution_name,
                            item.lov.type_of_investment === null ? null : item.lov.type_of_investment === "" ? null : { value: item.lov.type_of_investment },
                            item.lov.remarks === null || item.lov.remarks === "" ? "" : item.lov.remarks,
                            item.lov.placement_date == null || item.lov.placement_date == "" ? null : (item.lov.placement_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.lov.placement_date) : null),
                            item.lov.tenor === null || item.lov.tenor === "" ? "" : item.lov.tenor,
                            item.lov.expected_return === null || item.lov.expected_return === "" ? "0.0" : item.lov.expected_return,
                            // item.lov.currency === null ? null : item.lov.currency === "" ? null : { value: item.lov.currency },
                            item.lov.currency === null || item.lov.currency === "" ? "" : item.lov.currency,
                            item.lov.investment_amount_ori === null ? "0.0" : item.lov.investment_amount_ori === "" ? "0.0" : item.lov.investment_amount_ori,
                            item.lov.investment_amount_cur === null ? "0.0" : item.lov.investment_amount_cur === "" ? "0.0" : item.lov.investment_amount_cur,
                            item.lov.notes,
                            item.diff,
                            item.total_loan,
                            item.per_bs
                            // index
                        ])
                    }
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                }
                res.map((item, index) => {
                    let tgl = String(item.lov.placement_date).split('-')
                    dataTablelov.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        String(item.lov.institution_name).includes('Total') ? null : item.lov.company_name === null || item.lov.company_name === "" ? this.props.company.company_name : item.lov.company_name,
                        item.lov.institution_name === null || item.lov.institution_name === "" ? "" : item.lov.institution_name,
                        item.lov.type_of_investment === null ? null : item.lov.type_of_investment === "" ? null : { value: item.lov.type_of_investment },
                        item.lov.remarks === null || item.lov.remarks === "" ? "" : item.lov.remarks,
                        item.lov.placement_date == null || item.lov.placement_date == "" ? null : (item.lov.placement_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.lov.placement_date) : null),
                        item.lov.tenor === null || item.lov.tenor === "" ? "" : item.lov.tenor,
                        item.lov.expected_return === null || item.lov.expected_return === "" ? "0.0" : item.lov.expected_return,
                        // item.lov.currency === null ? null : item.lov.currency === "" ? null : { value: item.lov.currency },
                        item.lov.currency === null || item.lov.currency === "" ? "" : item.lov.currency,
                        item.lov.investment_amount_ori === null ? "0.0" : item.lov.investment_amount_ori === "" ? "0.0" : item.lov.investment_amount_ori,
                        item.lov.investment_amount_cur === null ? "0.0" : item.lov.investment_amount_cur === "" ? "0.0" : item.lov.investment_amount_cur,
                        item.lov.notes,
                        item.diff,
                        item.total_loan,
                        item.per_bs
                        // index
                    ])
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                })
                let lastArrayLOV = dataTablelov[res.length - 1]
                if (bankNameEmpty) {
                    if (this.state.get_for == 'view') {
                        this.setState({ saveDraft: false, saveCompLOV: true })
                    } else {
                        this.setState({ saveDraft: false, saveCompLOV: true })
                    }
                } else {
                    if (this.state.get_for == 'view') {
                        console.log("view");
                    } else {
                        this.setState({ saveDraft: false, saveCompLOV: lastArrayLOV[16] == 0 || lastArrayLOV[16] == '0.0' || lastArrayLOV[16] == "-0.0" ? false : true })
                    }
                }
                this.setState({ dataTablelov, diffLOV: lastArrayLOV[16], totalLoanLOV: lastArrayLOV[17], perBSLOV: lastArrayLOV[18], loading: false, loadingChild: false }, () => {
                    // this.handleCalculateLOV()
                })
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }

        })
    }

    uploadLOCF(type) {
        console.log('masoook LOCF');
        let dataTable2 = (this.state.dataTablelocf !== undefined && this.state.tambah == 'upload') ? this.state.dataTablelocf : (this.state.dataTablelocf == undefined || this.state.tambah == 'tambah' || this.state.tambah == 'upload') ? this.state.dataTableLOCF : this.state.dataTablelocf
        let data = []
        let error = false
        // this.deleteReport()
        console.log(dataTable2);
        dataTable2.map(i => {
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[8] == "" || i[10] == "" || i[11] == "" || i[12] == "") {
                    error = true
                }

                if (i[7].value == 'Others' && i[18] == '') {
                    error = true
                }
                let tgl = String(i[10]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "remarks2": i[9] == null ? i[9] : i[9].value,
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[10] == undefined || i[10] == "null" || i[10] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[10])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[11] == "" ? "0.00" : i[11],
                        "currency": i[12],
                        "loan_plafond_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "loan_plafond_amount_idr": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_ori": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_ki_amount_idr": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_ori": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        "out_loan_kmk_amount_idr": Number(i[18]) == "" ? "0.0" : Number(i[18]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[19],
                        "out_loan_other_amount_ori": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "out_loan_other_amount_idr": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_ori": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "total_out_loan_idr": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_ori": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "remaining_plafond_idr": Number(i[25]) == "" ? "0.0" : Number(i[25]),
                        "current_ratio_financial": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "current_ratio_current": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_financial": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "der_current": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_financial": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "debt_to_ebitda_current": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_financial": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "ebitda_to_interest_current": Number(i[33]) == "" ? "0.00" : Number(i[33]),
                        "other_ratio1_ratio_name": i[34],
                        "other_ratio1_financial": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio1_current": Number(i[36]) == "" ? "0.00" : Number(i[36]),
                        "other_ratio2_ratio_name": i[37],
                        "other_ratio2_financial": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio2_current": Number(i[39]) == "" ? "0.00" : Number(i[39]),
                        "other_ratio3_ratio_name": i[40],
                        "other_ratio3_financial": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio3_current": Number(i[42]) == "" ? "0.00" : Number(i[42]),
                        "other_ratio4_ratio_name": i[43],
                        "other_ratio4_financial": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "other_ratio4_current": Number(i[45]) == "" ? "0.00" : Number(i[45]),
                        "notes": i[46],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "borrower_comp_name": i[5],
                        "bank_name": i[6] == null ? [6] : i[6].value,
                        "type_of_credit": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "remarks2": i[9] == null ? i[9] : i[9].value,
                        // "loan_maturity_date": i[9],
                        "loan_maturity_date": i[10] == undefined || i[10] == "null" || i[10] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[10])),
                        // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
                        "interest": i[11] == "" ? "0.00" : i[11],
                        "currency": i[12],
                        "loan_plafond_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "loan_plafond_amount_idr": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "out_loan_ki_amount_ori": Number(i[15]) == "" ? "0.0" : Number(i[15]),
                        "out_loan_ki_amount_idr": Number(i[16]) == "" ? "0.0" : Number(i[16]),
                        "out_loan_kmk_amount_ori": Number(i[17]) == "" ? "0.0" : Number(i[17]),
                        "out_loan_kmk_amount_idr": Number(i[18]) == "" ? "0.0" : Number(i[18]),
                        // "mtd_vs_previous_month": i[18],
                        "out_loan_other_type": i[19],
                        "out_loan_other_amount_ori": Number(i[20]) == "" ? "0.0" : Number(i[20]),
                        "out_loan_other_amount_idr": Number(i[21]) == "" ? "0.0" : Number(i[21]),
                        "total_out_loan_ori": Number(i[22]) == "" ? "0.0" : Number(i[22]),
                        "total_out_loan_idr": Number(i[23]) == "" ? "0.0" : Number(i[23]),
                        "remaining_plafond_ori": Number(i[24]) == "" ? "0.0" : Number(i[24]),
                        "remaining_plafond_idr": Number(i[25]) == "" ? "0.0" : Number(i[25]),
                        "current_ratio_financial": Number(i[26]) == "" ? "0.00" : Number(i[26]),
                        "current_ratio_current": Number(i[27]) == "" ? "0.00" : Number(i[27]),
                        "der_financial": Number(i[28]) == "" ? "0.00" : Number(i[28]),
                        "der_current": Number(i[29]) == "" ? "0.00" : Number(i[29]),
                        "debt_to_ebitda_financial": Number(i[30]) == "" ? "0.00" : Number(i[30]),
                        "debt_to_ebitda_current": Number(i[31]) == "" ? "0.00" : Number(i[31]),
                        "ebitda_to_interest_financial": Number(i[32]) == "" ? "0.00" : Number(i[32]),
                        "ebitda_to_interest_current": Number(i[33]) == "" ? "0.00" : Number(i[33]),
                        "other_ratio1_ratio_name": i[34],
                        "other_ratio1_financial": Number(i[35]) == "" ? "0.00" : Number(i[35]),
                        "other_ratio1_current": Number(i[36]) == "" ? "0.00" : Number(i[36]),
                        "other_ratio2_ratio_name": i[37],
                        "other_ratio2_financial": Number(i[38]) == "" ? "0.00" : Number(i[38]),
                        "other_ratio2_current": Number(i[39]) == "" ? "0.00" : Number(i[39]),
                        "other_ratio3_ratio_name": i[40],
                        "other_ratio3_financial": Number(i[41]) == "" ? "0.00" : Number(i[41]),
                        "other_ratio3_current": Number(i[42]) == "" ? "0.00" : Number(i[42]),
                        "other_ratio4_ratio_name": i[43],
                        "other_ratio4_financial": Number(i[44]) == "" ? "0.00" : Number(i[44]),
                        "other_ratio4_current": Number(i[45]) == "" ? "0.00" : Number(i[45]),
                        "notes": i[46],
                    })
                }

            }
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "locf": data,
            "per_bs": this.state.perBSLOCF,
            "diff": this.state.diffLOCF,
            "total_loan": this.state.totalLoanLOCF
        }
        console.log(body);
        if (error && type == 'submitted') {
            this.setState({ handleDoubleClick: 0, saveDraft: false, saveComp: true, loadingChild: false, snekbar: true, snekbarMsg: 'Data Incomplete', handleDoubleClick: 0 })
        } else {
            api.create('UPLOAD').uploadMonthlyReportLOCF(body).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === "success") {
                            this.uploadLOV(type)
                            // this.props.saveToMonthlyReport('LOCF')
                            // this.props.onClickClose()
                            // this.props.getReport()
                        } else {
                            if (response.data?.message == "Please Set Up Rate Currency First") {
                                this.setState({ visibleAlertSave: true })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                            // alert(response.data.status)
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                }
                this.setState({ handleDoubleClick: 0 })
            })
        }
    }

    uploadLOV(type) {
        console.log('masoook LOV');
        let dataTable2 = []
        let data = []
        let error = false
        // this.deleteReport()
        if (this.state.dataTablelov == undefined) {
            dataTable2 = this.state.dataTableLOV
        } else {
            if (this.state.tambahLOV = 'upload') {
                this.setState({ updateTambah: true })
                if (this.state.updateData == true) {
                    dataTable2 = this.state.dataTableLOV
                    this.setState({ cekTambah: true })
                    if (this.state.updateTambah == true && this.state.updateData == true) {
                        dataTable2 = this.state.dataTablelov
                        if (this.state.cekTambah == undefined) {
                            dataTable2 = this.state.dataTableLOV
                        }
                    }
                } else {
                    dataTable2 = this.state.dataTablelov
                }
                this.setState({ updateData: true })
            } else if (this.state.tambahLOV = 'tambah') {
                if (this.state.updateData == true) {
                    dataTable2 = this.state.dataTablelov
                } else {
                    dataTable2 = this.state.dataTableLOV
                }
            }
        }
        console.log(dataTable2);
        dataTable2.map(i => {
            if (i[0] == 3) {
                if (i[6] == null || i[7] == null || i[8] == "" || i[9] == "" || i[10] == "" || i[11] == "" || i[12] == "") {
                    error = true
                }

                if ((i[7].value == 'Government bonds' && i[8] == '') || (i[7].value == 'Stocks' && i[8] == '') || (i[7].value == 'Mutual funds' && i[8] == '') || (i[7].value == 'Investment in associate' && i[8] == '') || (i[7].value == 'Investment in joint venture' && i[8] == '') || (i[7].value == 'Investment in subsidiary' && i[8] == '') || (i[7].value == 'Corporate bonds' && i[8] == '') || (i[7].value == 'Others' && i[8] == '')) {
                    error = true
                } else {
                    error = false
                }
                let tgl = String(i[9]).split('-')
                let checkUndifined = tgl.findIndex((val) => val == undefined)
                if (this.props.defaultCurrency.id == 2) {
                    data.push({
                        "item_report_id": i[1],
                        "company_name": i[5],
                        "institution_name": i[6],
                        "type_of_investment": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "placement_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        "tenor": i[10],
                        "expected_return": i[11] == "" ? "0.00" : i[11],
                        // "currency": i[12] == null ? i[12] : i[12].value,
                        "currency": i[12],
                        "investment_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "investment_amount_cur": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "notes": i[15],
                    })
                } else {
                    data.push({
                        "item_report_id": i[1],
                        "company_name": i[5],
                        "institution_name": i[6],
                        "type_of_investment": i[7] == null ? i[7] : i[7].value,
                        "remarks": i[8],
                        "placement_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
                        "tenor": i[10],
                        "expected_return": i[11] == "" ? "0.00" : i[11],
                        // "currency": i[12] == null ? i[12] : i[12].value,
                        "currency": i[12],
                        "investment_amount_ori": Number(i[13]) == "" ? "0.0" : Number(i[13]),
                        "investment_amount_cur": Number(i[14]) == "" ? "0.0" : Number(i[14]),
                        "notes": i[15],
                    })
                }

            }
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "lov": data,
            "per_bs": this.state.perBSLOV,
            "diff": this.state.diffLOV,
            "total_loan": this.state.totalLoanLOV
        }
        console.log(body);
        if (error && type == 'submitted') {
            this.setState({ handleDoubleClick: 0, saveDraft: false, saveComp: true, loadingChild: false, snekbar: true, snekbarMsg: 'Data Incomplete', handleDoubleClick: 0 })
        } else {
            api.create('UPLOAD').createMonthlyReportLOV(body).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === "success") {
                            this.props.saveToMonthlyReport('LOCF')
                            this.setState({ loadingChild: false })
                            // this.props.onClickClose()
                            // this.props.getReport()
                        } else {
                            if (response.data?.message == "Please Set Up Rate Currency First") {
                                this.setState({ visibleAlertSave: true })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                            // alert(response.data.status)
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                }
                this.setState({ handleDoubleClick: 0 })
            })
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        let loading = this.state.loading

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        const handleClose = (event, reason) => {
            if (reason === 'clickaway') {
                return;
            }

            this.setState({
                snekbar: false,
                snekbarMsg: ''
            })
        };

        return (
            <div>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report</Typography>
                </div>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleParent ?
                        < Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                                <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                                    {this.state.messageAlert}
                                </Alert>
                            </Snackbar>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - List Of Credit Facilities and Investment</Typography>
                            </div>

                            <LOCF
                                company={this.props.company}
                                month={this.props.month}
                                periode={this.props.periode}
                                revision={this.props.revision}
                                defaultCurrency={this.props.defaultCurrency}
                                get_for={this.state.get_for}
                                monthlyReportId={this.props.monthlyReportId}
                                report_id={this.props.report_id}
                                updateBy={this.state.updateBy}
                                notes={this.state.notes}
                                open={this.props.open}
                                height={this.props.height}
                                width={this.props.width}
                                sendToParent={this.dataTableForChild.bind(this)}
                                dataTablelocf={this.state.dataTablelocf}
                                loadingChild={this.state.loadingChild}
                            />
                            <hr />
                            <LOV
                                company={this.props.company}
                                month={this.props.month}
                                periode={this.props.periode}
                                revision={this.props.revision}
                                defaultCurrency={this.props.defaultCurrency}
                                get_for={this.state.get_for}
                                monthlyReportId={this.props.monthlyReportId}
                                report_id={this.props.report_id}
                                updateBy={this.state.updateBy}
                                notes={this.state.notes}
                                open={this.props.open}
                                height={this.props.height}
                                width={this.props.width}
                                sendToParent={this.dataTableForChild.bind(this)}
                                dataTablelov={this.state.dataTablelov}
                                loadingChild={this.state.loadingChild}
                            />
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginLeft: 10 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {/* (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}

                                {this.props.isApprover === true ? null :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => this.setState({ saveTambahan: false, loadingChild: true }, () => {
                                                setTimeout(() => {
                                                    this.handleCalculateLOCF()
                                                }, 100);
                                            })}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            onClick={() =>
                                                this.state.saveDraft === true || this.state.saveTambahan ?
                                                    this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loadingChild: true }, () => {
                                                            setTimeout(() => {
                                                                this.backToMonthlyReportLOCF('draft')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.saveComp || this.state.saveCompLOV || this.state.saveTambahan ?
                                                    this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete / Diff must be 0' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loadingChild: true }, () => {
                                                            setTimeout(() => {
                                                                this.backToMonthlyReportLOCF('submitted')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 20 }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>}
                                {/* : null } */}
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <Snackbar open={this.state.snekbar} autoHideDuration={6000} onClose={handleClose}>
                                <Alert onClose={handleClose} severity="error">
                                    {this.state.snekbarMsg}
                                </Alert>
                            </Snackbar>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - List Of Credit Facilities and Investment</Typography>
                            </div>
                            <LOCF
                                company={this.props.company}
                                month={this.props.month}
                                periode={this.props.periode}
                                revision={this.props.revision}
                                defaultCurrency={this.props.defaultCurrency}
                                get_for={this.state.get_for}
                                monthlyReportId={this.props.monthlyReportId}
                                report_id={this.props.report_id}
                                updateBy={this.state.updateBy}
                                notes={this.state.notes}
                                open={this.props.open}
                                height={this.props.height}
                                width={this.props.width}
                                sendToParent={this.dataTableForChild.bind(this)}
                                dataTablelocf={this.state.dataTablelocf}
                                loadingChild={this.state.loadingChild}
                            />
                            <hr />
                            <LOV
                                company={this.props.company}
                                month={this.props.month}
                                periode={this.props.periode}
                                revision={this.props.revision}
                                defaultCurrency={this.props.defaultCurrency}
                                get_for={this.state.get_for}
                                monthlyReportId={this.props.monthlyReportId}
                                report_id={this.props.report_id}
                                updateBy={this.state.updateBy}
                                notes={this.state.notes}
                                open={this.props.open}
                                height={this.props.height}
                                width={this.props.width}
                                sendToParent={this.dataTableForChild.bind(this)}
                                dataTablelov={this.state.dataTablelov}
                                loadingChild={this.state.loadingChild}
                            />
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginLeft: 10 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}
                                <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => this.setState({ saveTambahan: false, loadingChild: true }, () => {
                                            this.handleCalculateLOCF()
                                        })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>
                                    <button
                                        className="button"
                                        type="button"
                                        onClick={() =>
                                            this.state.saveDraft === true || this.state.saveTambahan ?
                                                this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loadingChild: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadLOCF('draft')
                                                        }, 100);
                                                    })
                                        }
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>
                                    <button
                                        type="button"
                                        // disabled={this.state.buttonError}
                                        onClick={() =>
                                            this.state.saveComp || this.state.saveCompLOV || this.state.saveTambahan ?
                                                this.setState({ snekbar: true, snekbarMsg: 'Data Incomplete / Diff must be 0' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loadingChild: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadLOCF('submitted')
                                                        }, 100);
                                                    })
                                        }
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 20 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>
                                </div>
                                {/* : null } */}
                            </div>
                        </Paper>}
                </div>
                {this.state.emptyData && (
                    <PopUpValidationLOV
                        onClickClose={() => this.setState({ emptyData: false })}
                    />
                )}
                {
                    this.state.visibleAlertSave && (
                        <div className="test app-popup-show">
                            <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                                <div style={{ margin: 30 }}>
                                    <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                        <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                            <img src={Images.warning} />
                                        </div>
                                        <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                            <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                background: '#F6F7F9',
                                                cursor: 'pointer',
                                                border: '1px solid #3549609e',
                                                outline: 'none',
                                                marginRight: 20,
                                                borderRadius: 9
                                            }}
                                            onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                                <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            </div >
        )
    }

}