import React, { Component } from 'react';
import { createMuiTheme, FormControlLabel, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, withStyles, Input, ThemeProvider, TextareaAutosize } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import Constant from '../../library/Constant';
import { titleCase } from '../../library/Utils';
import { Autocomplete } from '@material-ui/lab';
import { PropagateLoader } from 'react-spinners';
import ReactTooltip from 'react-tooltip';
import { DatePicker } from '@material-ui/pickers';
import { format } from 'date-fns';
import { BorderStyle } from '@material-ui/icons';
import { includes } from 'ramda';
import Snackbar from '@material-ui/core/Snackbar';
import MuiAlert from '@material-ui/lab/Alert';
import { makeStyles } from '@material-ui/core/styles';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { fixNumber, roundMath } from "../../library/Utils";

function Alert(props) {
    return <MuiAlert elevation={6} variant="filled" {...props} />;
}

const useStyles = makeStyles((theme) => ({
    root: {
        width: '100%',
        '& > * + *': {
            marginTop: theme.spacing(2),
        },
    },
}));

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

const LightTooltipError = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(255, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());
const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};

const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

const theme = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea',
                marginTop: -10,
                textAlign: 'center'
            }
        }
    },
});

const theme2 = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea',
                textAlign: 'center'
            }
        }
    },
});

const theme3 = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#black',
                textAlign: 'center'
            }
        }
    },
});

export default class LOV extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            typeOfInvestmentList: [],
            currencyList: [],
            loading: false,
            dataTableRatio: [],
            currentDate: format(new Date(), 'yyyy-MM-dd'),
            totalOutStand: 0,
            diff: 0,
            perBS: 0,
            snekbar: false,
            snekbarMsg: '',
            visibleLOVMR: true,
            saveDraft: true,
            saveComp: true,
            get_for: 'view',
            updateBy: [],
            notes: "",
            viewOnly: true,
            dataDelete: [],
            saveTambahan: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        // this.getPerBS()
        this.getTypeOfInvesment()
        this.getListCurrency()
        this.getSubmission()
        this.getLatestUpdate()
        this.handleViewOnly()
    }

    componentDidUpdate(prevProps) {
        if (this.props.get_for !== prevProps.get_for) {
            // this.getPerBS()
            this.getTypeOfInvesment()
            this.getListCurrency()
            this.getSubmission()
            this.getLatestUpdate()
            this.handleViewOnly()
        }
        if (this.props.dataTablelov !== prevProps.dataTablelov) {
            let array = this.props.dataTablelov
            let datas = array[array.length - 1]
            console.log(datas);
            this.setState({ dataTable: this.props.dataTablelov, diff: datas[16], loanTotal: datas[17], perBS: datas[18] })
        }
        if (this.props.loadingChild !== prevProps.loadingChild) {
            this.setState({ loading: this.props.loadingChild })
        }
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getPerBS()
            this.getTypeOfInvesment()
            this.getListCurrency()
            this.getSubmission()
            this.getLatestUpdate()
        })
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({viewOnly: true})
    }

    getItemHierarkiLOV() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "get_for": this.props.get_for
        }
        console.log(payload);
        api.create().getHierarkiMontlyReportInvesment(payload).then(response => {
            console.log(response);
            let dataTable = []
            if (response.data) {
                let res = response.data.data
                const handlePushChild = (item) => {
                    let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                    let tgl = String(item.lov.placement_date).split('-')
                    if (indexIDzz === -1) {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            String(item.lov.institution_name).includes('Total') ? null : item.lov.company_name === null || item.lov.company_name === "" ? this.props.company.company_name : item.lov.company_name,
                            item.lov.institution_name === null || item.lov.institution_name === "" ? "" : item.lov.institution_name,
                            item.lov.type_of_investment === null ? null : item.lov.type_of_investment === "" ? null : { value: item.lov.type_of_investment },
                            item.lov.remarks === null || item.lov.remarks === "" ? "" : item.lov.remarks,
                            item.lov.placement_date == null || item.lov.placement_date == "" ? null : (item.lov.placement_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.lov.placement_date) : null),
                            item.lov.tenor === null || item.lov.tenor === "" ? "" : item.lov.tenor,
                            item.lov.expected_return === null || item.lov.expected_return === "" || item.lov.expected_return === "0.0" ? "0.00" : item.lov.expected_return,
                            // item.lov.currency === null ? null : item.lov.currency === "" ? null : { value: item.lov.currency },
                            item.lov.currency === null || item.lov.currency === "" ? "" : item.lov.currency,
                            item.lov.investment_amount_ori === null ? "0.0" : item.lov.investment_amount_ori === "" ? "0.0" : item.lov.investment_amount_ori,
                            item.lov.investment_amount_cur === null ? "0.0" : item.lov.investment_amount_cur === "" ? "0.0" : item.lov.investment_amount_cur,
                            item.lov.notes,
                            item.diff,
                            item.total_loan,
                            item.per_bs
                            // index
                        ])
                    }
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                }
                res.map((item, index) => {
                    let tgl = String(item.lov.placement_date).split('-')
                    dataTable.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        String(item.lov.institution_name).includes('Total') ? null : item.lov.company_name === null || item.lov.company_name === "" ? this.props.company.company_name : item.lov.company_name,
                        item.lov.institution_name === null || item.lov.institution_name === "" ? "" : item.lov.institution_name,
                        item.lov.type_of_investment === null ? null : item.lov.type_of_investment === "" ? null : { value: item.lov.type_of_investment },
                        item.lov.remarks === null || item.lov.remarks === "" ? "" : item.lov.remarks,
                        item.lov.placement_date == null || item.lov.placement_date == "" ? null : (item.lov.placement_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.lov.placement_date) : null),
                        item.lov.tenor === null || item.lov.tenor === "" ? "" : item.lov.tenor,
                        item.lov.expected_return === null || item.lov.expected_return === "" ? "0.0" : item.lov.expected_return,
                        // item.lov.currency === null ? null : item.lov.currency === "" ? null : { value: item.lov.currency },
                        item.lov.currency === null || item.lov.currency === "" ? "" : item.lov.currency,
                        item.lov.investment_amount_ori === null ? "0.0" : item.lov.investment_amount_ori === "" ? "0.0" : item.lov.investment_amount_ori,
                        item.lov.investment_amount_cur === null ? "0.0" : item.lov.investment_amount_cur === "" ? "0.0" : item.lov.investment_amount_cur,
                        item.lov.notes,
                        item.diff,
                        item.total_loan,
                        item.per_bs
                        // index
                    ])
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                })
                console.log(dataTable)
                let lastArray = dataTable[res.length - 1]
                console.log(lastArray);
                this.setState({ dataTable, diff: lastArray[16], loanTotal: lastArray[17], perBS: lastArray[18], loading: false, visibleLOVMR: true }, () => {
                    this.props.sendToParent(dataTable, lastArray, 'LOV')


                })
            }
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        // console.log(payload)
        api.create().getLastestUpdateMR(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, typeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                // console.log('brrrrrrrr')
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp.rows[0][0])
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        let tgl = String(i[6]).split('-')
                        // console.log(tgl);
                        payload.push({
                            "item_report_id": i[1],
                            "company_name": this.props.company.company_name,
                            "institution_name": i[3] !== undefined ? (i[3]) : "",
                            "type_of_investment": i[4] !== undefined ? (i[4]) : "",
                            "remarks": i[5] !== undefined ? (i[5]) : "",
                            "placement_date": i[6] !== undefined ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : "",
                            "tenor": i[7] !== undefined ? (i[7]) : "",
                            "expected_return": i[8] !== undefined ? (i[8]) : "",
                            "currency": i[9] !== undefined ? (i[9]) : "",
                            "investment_amount_ori": i[10] !== undefined ? Number(i[10]) : "",
                            "investment_amount_cur": i[11] !== undefined ? Number(i[11]) : "",
                            "notes": i[12],
                        })
                    }
                })
                let body = {
                    "monthly_report_id": this.props.monthlyReportId,
                    "company_id": this.props.company.company_id,
                    "periode": this.props.periode,
                    "report_id": this.props.report_id,
                    "status": 'submitted',
                    "months": this.props.month.month_id,
                    "lov": payload,
                    "per_bs": this.state.perBS,
                    "diff": this.state.diff,
                    "total_loan": this.state.loanTotal
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }


    deleteReport() {
        let payload = { "item_report_id": this.state.dataDelete, "periode": this.props.periode, "months": this.props.month.month_id }

        if (this.state.dataDelete.length > 0) {
            api.create().deleteAllItemReportLOCF(payload).then((response) => {
                console.log(response)
            })
        }
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        console.log(payload);
        let dataDelete = []
        api.create().getIdDeleteFromExcelLOV(payload).then((response) => {
            console.log(response)
        })

        api.create().checkUploadMonthlyReportLOV(payload).then(response => {
            console.log(response)
            let dataTable = []
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, loading: true, visibleLOVMR: false })
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        let tgl = String(item.lov.placement_date).split('-')
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                String(item.lov.institution_name).includes('Total') ? null : item.lov.company_name === null || item.lov.company_name === "" ? this.props.company.company_name : item.lov.company_name,
                                item.lov.institution_name === null || item.lov.institution_name === "" ? "" : item.lov.institution_name,
                                item.lov.type_of_investment === null ? null : item.lov.type_of_investment === "" ? null : { value: item.lov.type_of_investment },
                                item.lov.remarks === null || item.lov.remarks === "" ? "" : item.lov.remarks,
                                item.lov.placement_date == null || item.lov.placement_date == "" ? null : (item.lov.placement_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.lov.placement_date) : null),
                                item.lov.tenor === null || item.lov.tenor === "" ? "" : item.lov.tenor,
                                item.lov.expected_return === null || item.lov.expected_return === "" ? "0.0" : item.lov.expected_return,
                                // item.lov.currency === null ? null : item.lov.currency === "" ? null : { value: item.lov.currency },
                                item.lov.currency === null || item.lov.currency === "" ? "" : item.lov.currency,
                                item.lov.investment_amount_ori === null ? "0.0" : item.lov.investment_amount_ori === "" ? "0.0" : item.lov.investment_amount_ori,
                                item.lov.investment_amount_cur === null ? "0.0" : item.lov.investment_amount_cur === "" ? "0.0" : item.lov.investment_amount_cur,
                                item.lov.notes,
                                item.diff,
                                item.total_loan,
                                item.per_bs
                                // index
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        let tgl = String(item.lov.placement_date).split('-')
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            String(item.lov.institution_name).includes('Total') ? null : item.lov.company_name === null || item.lov.company_name === "" ? this.props.company.company_name : item.lov.company_name,
                            item.lov.institution_name === null || item.lov.institution_name === "" ? "" : item.lov.institution_name,
                            item.lov.type_of_investment === null ? null : item.lov.type_of_investment === "" ? null : { value: item.lov.type_of_investment },
                            item.lov.remarks === null || item.lov.remarks === "" ? "" : item.lov.remarks,
                            item.lov.placement_date == null || item.lov.placement_date == "" ? null : (item.lov.placement_date !== "null" ? String(tgl[2]).length > 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(item.lov.placement_date) : null),
                            item.lov.tenor === null || item.lov.tenor === "" ? "" : item.lov.tenor,
                            item.lov.expected_return === null || item.lov.expected_return === "" ? "0.0" : item.lov.expected_return,
                            // item.lov.currency === null ? null : item.lov.currency === "" ? null : { value: item.lov.currency },
                            item.lov.currency === null || item.lov.currency === "" ? "" : item.lov.currency,
                            item.lov.investment_amount_ori === null ? "0.0" : item.lov.investment_amount_ori === "" ? "0.0" : item.lov.investment_amount_ori,
                            item.lov.investment_amount_cur === null ? "0.0" : item.lov.investment_amount_cur === "" ? "0.0" : item.lov.investment_amount_cur,
                            item.lov.notes,
                            item.diff,
                            item.total_loan,
                            item.per_bs
                            // index
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    console.log(dataTable)
                    let lastArray = dataTable[dataTable.length - 1]
                    this.setState({ dataTable, diff: lastArray[16], loanTotal: lastArray[17], perBS: lastArray[18], dataLoaded: true, loading: false, buttonError: false, dataDelete: [] }, () => {
                        this.props.sendToParent(dataTable, lastArray, 'LOV', 'upload', this.state.visibleLOVMR)
                    })
                    console.log(this.state.visibleLOVMR);
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, typeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    // uploadLOCF(type) {
    //     let data = []
    //     let error = false
    //     this.deleteReport()
    //     this.state.dataTable.map(i => {
    //         if (i[0] == 3) {
    //             if (i[6] == null || i[7] == null || i[8] == "" || i[9] == "" || i[10] == "" || i[11] == "") {
    //                 error = true
    //             }

    //             if (i[7].value == 'Others' && i[18] == '') {
    //                 error = true
    //             }
    //             let tgl = String(i[9]).split('-')
    //             let checkUndifined = tgl.findIndex((val) => val == undefined)
    //             if (this.props.defaultCurrency.id == 2) {
    //                 data.push({
    //                     "item_report_id": i[1],
    //                     "borrower_comp_name": i[5],
    //                     "bank_name": i[6] == null ? [6] : i[6].value,
    //                     "type_of_credit": i[7] == null ? i[7] : i[7].value,
    //                     "remarks": i[8],
    //                     // "loan_maturity_date": i[9],
    //                     "loan_maturity_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
    //                     // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
    //                     "interest": i[10] == "" ? "0.00" : i[10],
    //                     "currency": i[11],
    //                     "loan_plafond_amount_ori": Number(i[12]) == "" ? "0.0" : Number(i[12]),
    //                     "loan_plafond_amount_idr": Number(i[13]) == "" ? "0.0" : Number(i[13]),
    //                     "out_loan_ki_amount_ori": Number(i[14]) == "" ? "0.0" : Number(i[14]),
    //                     "out_loan_ki_amount_idr": Number(i[15]) == "" ? "0.0" : Number(i[15]),
    //                     "out_loan_kmk_amount_ori": Number(i[16]) == "" ? "0.0" : Number(i[16]),
    //                     "out_loan_kmk_amount_idr": Number(i[17]) == "" ? "0.0" : Number(i[17]),
    //                     // "mtd_vs_previous_month": i[18],
    //                     "out_loan_other_type": i[18],
    //                     "out_loan_other_amount_ori": Number(i[19]) == "" ? "0.0" : Number(i[19]),
    //                     "out_loan_other_amount_idr": Number(i[20]) == "" ? "0.0" : Number(i[20]),
    //                     "total_out_loan_ori": Number(i[21]) == "" ? "0.0" : Number(i[21]),
    //                     "total_out_loan_idr": Number(i[22]) == "" ? "0.0" : Number(i[22]),
    //                     "remaining_plafond_ori": Number(i[23]) == "" ? "0.0" : Number(i[23]),
    //                     "remaining_plafond_idr": Number(i[24]) == "" ? "0.0" : Number(i[24]),
    //                     "current_ratio_financial": Number(i[25]) == "" ? "0.00" : Number(i[25]),
    //                     "current_ratio_current": Number(i[26]) == "" ? "0.00" : Number(i[26]),
    //                     "der_financial": Number(i[27]) == "" ? "0.00" : Number(i[27]),
    //                     "der_current": Number(i[28]) == "" ? "0.00" : Number(i[28]),
    //                     "debt_to_ebitda_financial": Number(i[29]) == "" ? "0.00" : Number(i[29]),
    //                     "debt_to_ebitda_current": Number(i[30]) == "" ? "0.00" : Number(i[30]),
    //                     "ebitda_to_interest_financial": Number(i[31]) == "" ? "0.00" : Number(i[31]),
    //                     "ebitda_to_interest_current": Number(i[32]) == "" ? "0.00" : Number(i[32]),
    //                     "other_ratio1_ratio_name": i[33],
    //                     "other_ratio1_financial": Number(i[34]) == "" ? "0.00" : Number(i[34]),
    //                     "other_ratio1_current": Number(i[35]) == "" ? "0.00" : Number(i[35]),
    //                     "other_ratio2_ratio_name": i[36],
    //                     "other_ratio2_financial": Number(i[37]) == "" ? "0.00" : Number(i[37]),
    //                     "other_ratio2_current": Number(i[38]) == "" ? "0.00" : Number(i[38]),
    //                     "other_ratio3_ratio_name": i[39],
    //                     "other_ratio3_financial": Number(i[40]) == "" ? "0.00" : Number(i[40]),
    //                     "other_ratio3_current": Number(i[41]) == "" ? "0.00" : Number(i[41]),
    //                     "other_ratio4_ratio_name": i[42],
    //                     "other_ratio4_financial": Number(i[43]) == "" ? "0.00" : Number(i[43]),
    //                     "other_ratio4_current": Number(i[44]) == "" ? "0.00" : Number(i[44]),
    //                     "notes": i[45],
    //                 })
    //             } else {
    //                 data.push({
    //                     "item_report_id": i[1],
    //                     "borrower_comp_name": i[5],
    //                     "bank_name": i[6] == null ? [6] : i[6].value,
    //                     "type_of_credit": i[7] == null ? i[7] : i[7].value,
    //                     "remarks": i[8],
    //                     // "loan_maturity_date": i[9],
    //                     "loan_maturity_date": i[9] == undefined || i[9] == "null" || i[9] == null ? "" : (String(tgl[2]).length <= 2 ? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])),
    //                     // "loan_maturity_date":  i[9] !== undefined || i[9] !== "null" || i[9] !== null? (String(tgl[2]).length <= 2? tgl[2] + '-' + tgl[1] + '-' + tgl[0] : String(i[9])) : "",
    //                     "interest": i[10] == "" ? "0.00" : i[10],
    //                     "currency": i[11],
    //                     "loan_plafond_amount_ori": fixNumber(Number(i[12]), 1) == "" ? "0.0" : fixNumber(Number(i[12]), 1),
    //                     "loan_plafond_amount_idr": fixNumber(Number(i[13]), 1) == "" ? "0.0" : fixNumber(Number(i[13]), 1),
    //                     "out_loan_ki_amount_ori": fixNumber(Number(i[14]), 1) == "" ? "0.0" : fixNumber(Number(i[14]), 1),
    //                     "out_loan_ki_amount_idr": fixNumber(Number(i[15]), 1) == "" ? "0.0" : fixNumber(Number(i[15]), 1),
    //                     "out_loan_kmk_amount_ori": fixNumber(Number(i[16]), 1) == "" ? "0.0" : fixNumber(Number(i[16]), 1),
    //                     "out_loan_kmk_amount_idr": fixNumber(Number(i[17]), 1) == "" ? "0.0" : fixNumber(Number(i[17]), 1),
    //                     // "mtd_vs_previous_month": i[18],
    //                     "out_loan_other_type": i[18],
    //                     "out_loan_other_amount_ori": fixNumber(Number(i[19]), 1) == "" ? "0.0" : fixNumber(Number(i[19]), 1),
    //                     "out_loan_other_amount_idr": fixNumber(Number(i[20]), 1) == "" ? "0.0" : fixNumber(Number(i[20]), 1),
    //                     "total_out_loan_ori": fixNumber(Number(i[21]), 1) == "" ? "0.0" : fixNumber(Number(i[21]), 1),
    //                     "total_out_loan_idr": fixNumber(Number(i[22]), 1) == "" ? "0.0" : fixNumber(Number(i[22]), 1),
    //                     "remaining_plafond_ori": fixNumber(Number(i[23]), 1) == "" ? "0.0" : fixNumber(Number(i[23]), 1),
    //                     "remaining_plafond_idr": fixNumber(Number(i[24]), 1) == "" ? "0.0" : fixNumber(Number(i[24]), 1),
    //                     "current_ratio_financial": fixNumber(Number(i[25]), 2) == "" ? "0.00" : fixNumber(Number(i[25]), 2),
    //                     "current_ratio_current": fixNumber(Number(i[26]), 2) == "" ? "0.00" : fixNumber(Number(i[26]), 2),
    //                     "der_financial": fixNumber(Number(i[27]), 2) == "" ? "0.00" : fixNumber(Number(i[27]), 2),
    //                     "der_current": fixNumber(Number(i[28]), 2) == "" ? "0.00" : fixNumber(Number(i[28]), 2),
    //                     "debt_to_ebitda_financial": fixNumber(Number(i[29]), 2) == "" ? "0.00" : fixNumber(Number(i[29]), 2),
    //                     "debt_to_ebitda_current": fixNumber(Number(i[30]), 2) == "" ? "0.00" : fixNumber(Number(i[30]), 2),
    //                     "ebitda_to_interest_financial": fixNumber(Number(i[31]), 2) == "" ? "0.00" : fixNumber(Number(i[31]), 2),
    //                     "ebitda_to_interest_current": fixNumber(Number(i[32]), 2) == "" ? "0.00" : fixNumber(Number(i[32]), 2),
    //                     "other_ratio1_ratio_name": i[33],
    //                     "other_ratio1_financial": fixNumber(Number(i[34]), 2) == "" ? "0.00" : fixNumber(Number(i[34]), 2),
    //                     "other_ratio1_current": fixNumber(Number(i[35]), 2) == "" ? "0.00" : fixNumber(Number(i[35]), 2),
    //                     "other_ratio2_ratio_name": i[36],
    //                     "other_ratio2_financial": fixNumber(Number(i[37]), 2) == "" ? "0.00" : fixNumber(Number(i[37]), 2),
    //                     "other_ratio2_current": fixNumber(Number(i[38]), 2) == "" ? "0.00" : fixNumber(Number(i[38]), 2),
    //                     "other_ratio3_ratio_name": i[39],
    //                     "other_ratio3_financial": fixNumber(Number(i[40]), 2) == "" ? "0.00" : fixNumber(Number(i[40]), 2),
    //                     "other_ratio3_current": fixNumber(Number(i[41]), 2) == "" ? "0.00" : fixNumber(Number(i[41]), 2),
    //                     "other_ratio4_ratio_name": i[42],
    //                     "other_ratio4_financial": fixNumber(Number(i[43]), 2) == "" ? "0.00" : fixNumber(Number(i[43]), 2),
    //                     "other_ratio4_current": fixNumber(Number(i[44]), 2) == "" ? "0.00" : fixNumber(Number(i[44]), 2),
    //                     "notes": i[45],
    //                 })
    //             }

    //         }
    //     })
    //     let body = {
    //         "monthly_report_id": this.props.monthlyReportId,
    //         "company_id": this.props.company.company_id,
    //         "periode": this.props.periode,
    //         "report_id": this.props.report_id,
    //         "status": type,
    //         "months": this.props.month.month_id,
    //         "currency_id": this.props.defaultCurrency.id,
    //         "locf": data,
    //         "per_bs": this.state.perBS,
    //         "diff": this.state.diff,
    //         "total_loan": this.state.perBS
    //     }
    //     console.log(JSON.stringify(body));
    //     if (error && type == 'submitted') {
    //         this.setState({ handleDoubleClick: 0, saveDraft: false, saveComp: true, loading: false, snekbar: true, snekbarMsg: 'Data Incomplete', handleDoubleClick: 0 })
    //     } else {
    //         api.create('UPLOAD').uploadMonthlyReportLOCF(body).then(response => {
    //             console.log(response);
    //             if (response.data) {
    //                 if (response.ok) {
    //                     if (response.data.status === "success") {
    //                         this.props.saveToMonthlyReport('LOCF')
    //                         // this.props.onClickClose()
    //                         // this.props.getReport()
    //                     } else {
    //                         if (response.data?.message == "Please Set Up Rate Currency First") {
    //                             this.setState({ visibleAlertSave: true })
    //                         } else {
    //                             this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
    //                                 if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
    //                                     setTimeout(() => {
    //                                         localStorage.removeItem(Constant.TOKEN)
    //                                         window.location.reload();
    //                                     }, 1000);
    //                                 }
    //                             })
    //                         }
    //                         // alert(response.data.status)
    //                     }
    //                 } else {
    //                     this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
    //                 }
    //             } else {
    //                 this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
    //             }
    //             this.setState({ handleDoubleClick: 0 })
    //         })
    //     }
    // }

    getListCurrency() {
        // this.setState({ dataLoaded: false })
        api.create().getDataCurrency().then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inpuCurrency = []

                        data.map((item) => {
                            inpuCurrency.push({
                                value: `${item.currency_name}`
                            })
                        })
                        let defaultProps = {
                            options: inpuCurrency,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // // // console.log(defaultProps)
                        this.setState({ currencyList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getTypeOfInvesment() {
        let body = {
            group: 'INVESTMENT',
            company_id: this.props.company.company_id,
            type: 'TYPE_OF_INVESTMENT',
            currency_id: this.props.defaultCurrency.id,
        }
        this.setState({ dataLoaded: false })
        api.create().getAllSettingByType(body).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        // // // console.log(data)
                        let inpuTypeOfInvestment = []

                        data.map((item) => {
                            inpuTypeOfInvestment.push({
                                value: `${item.value}`
                            })
                        })
                        console.log(data);
                        let defaultProps = {
                            options: inpuTypeOfInvestment,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // // // console.log(defaultProps)
                        this.setState({ typeOfInvestmentList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/lov/monthly_report/download_template?report_id=${this.props.report_id}&company_id=${this.props.company.company_id}&year=${this.props.periode}&months=${this.props.month.month_id}&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // console.log(this.props.report_id)
        // console.log(this.props.company.company_id)
        // console.log(this.props.periode)
        // console.log(this.props.month.month_id)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report List of Investment.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/locf/monthly_report/export_monthly_report?monthly_report_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        let urls = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/locf/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        // console.log(url);
        // console.log(urls);
        let res = await fetch(
            this.props.monthlyReportId == null ? url : urls
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report List of Credit Facilities.xlsx';
            a.click();
        }
    }

    getSubmission() {
        this.setState({ loading: true })
        let payload = {
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "is_approver": true
        }
        api.create().getSubmission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        submissionID: response.data.data.submission_id,
                        lastRevision: response.data.data.last_revision,
                    }, () => {
                        this.getItemHierarkiLOV()
                    })
                } else {
                    this.setState({ submissionID: null, loading: false })
                }
            }
        })
    }


    render() {
        let dataTable2 = this.state.dataTable
        let loading = this.state.loading
        let dataTampungBank = []
        let indexNyasar = false
        let totalLoan = 0

        // const formatSeparator = (num) => {
        //    return String(num).replace(/(?<!\..*)(\d)(?=(?:\d{3})+(?:\.|$))/g, '$1,')

        // return num
        // }

        const handleAction = (typeReport, tableMeta, typeButton) => {
            if (typeReport == 3) {
                if (dataTable2.length == 2) {
                    if (typeButton == 'add') {
                        return true
                    } else {
                        return false
                    }
                } else {
                    return true
                }
            } else {
                return false
            }
        }

        const handleChange = (value, tableMeta, column, typeChange, typeDrop) => {
            console.log(column, value);
            let val = ''
            if (typeChange == 'date') {
                dataTable2[tableMeta.rowIndex][column] = format(value, 'yyyy-MM-dd')
                this.setState({ loading: true }, () => {
                    this.setState({ loading: false })
                })
            } else {
                dataTable2[tableMeta.rowIndex][column] = value
                if (column != 6 && column != 7 && column != 8 && column != 10 && column != 12 && column != 15) {
                    val = String(value).split(",").join("")
                    val = this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 2) : Number(val)
                } else {
                    val = String(value).split(",").join("")

                }

                if (value.value !== undefined) {
                    this.setState({ loading: true })
                    if (value.value == 'Government bonds') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Stocks') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Mutual funds') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Investment in associate') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Investment in joint venture') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Investment in subsidiary') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Time deposit') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Corporate bonds') {
                        this.setState({ loading: false })
                    } else if (value.value == 'Others') {
                        this.setState({ loading: false })
                    } else if (value.value == 'N/A') {
                        this.setState({ loading: false })
                    }
                    this.setState({ loading: false })
                    dataTable2[tableMeta.rowIndex][column] = value
                } else {
                    dataTable2[tableMeta.rowIndex][column] = val
                }
            }
            console.log(dataTable2[tableMeta.rowIndex][column]);
            console.log(value)
            console.log(String(value).split(",").join(""))
        }

        const handleValueDropDown = (value, type, tableMeta) => {
            let data = type == 'typeOfInvestmentList' ? this.state.typeOfInvestmentList.options : this.state.currencyList.options
            let index = 0
            if (type == 'typeOfInvestmentList' && dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] != null && dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] != "") {
                indexNyasar = true
            }
            if (value == null) {
                index = -1
            } else {
                if (type == 'currencyList') {
                    index = data.findIndex((val) => String(val.currency_name) == String(value.currency_name))
                } else {
                    index = data.findIndex((val) => String(val.value) == String(value.value))
                }
            }
            if (index == -1) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = null
                return null
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
                return value
            }
            // console.log(value);
        }

        const handleFormulaHardcode = (value, tableMeta, column) => {
            let valuez = 0
            if (tableMeta.rowData[0] == 8) {
                dataTable2.map((item, index) => {
                    if (item[6].value.includes(String(tableMeta.rowData[6].value).substr(6, tableMeta.rowData[6].length)) && item[0] != 8) {
                        valuez += Number(item[column])
                    }
                })
            } else {
                dataTable2.map((item, index) => {
                    if (item[0] == 8) {
                        valuez += Number(item[column])
                    }
                })
            }
            dataTable2[tableMeta.rowIndex][column] = valuez
            return valuez
        }

        const handleTambah = (data, rowIndex) => {
            // // console.log(dataTable2)
            let newData = []
            let indexxx = 0
            console.log(dataTable2);
            dataTable2.map((item, index) => {
                indexxx = index
                if (item[6] == "Grand Total") {
                    item[16] = 999999
                } else {
                    item[16] = indexxx
                }
                newData.push(item)
                if (index == rowIndex) {
                    indexxx = index + 1
                    newData.push([
                        3,
                        "",
                        "",
                        "",
                        "",
                        this.props.company.company_name,
                        "",
                        null,
                        "",
                        null,
                        "",
                        "",
                        "",
                        "0",
                        "",
                        "",
                        indexxx],
                    )

                }
            })
            dataTable2 = newData.sort((a, b) => a[16] - b[16])
            let lastArray = dataTable2[dataTable2.length - 1]
            if (this.state.visibleLOVMR == false) {
                if (this.props.dataTablelov) {
                    if (this.props.dataTablelov.length !== dataTable2.length) {
                        this.setState({ updateData: true })
                    }
                }
            } else {
                if (this.props.dataTablelov) {
                    if (this.props.dataTablelov.length !== dataTable2.length) {
                        this.setState({ updateData: true })
                    }
                }
            }
            this.setState({ dataTable: dataTable2 }, () => {
                setTimeout(() => {
                    this.setState({ loading: false })
                    this.props.sendToParent(dataTable2, lastArray, 'LOV', 'tambah', this.state.visibleLOVMR, this.state.updateData)
                }, 500)
            })
        }

        const handleDelete = (index) => {
            let dataDelete = this.state.dataDelete
            let berapaInput = 0
            dataTable2.map((items, indexs) => {
                if (items[0] == 3) {
                    berapaInput += 1
                }
            })

            dataDelete.push(dataTable2[index][1])

            let prevData = dataTable2[index - 1] == undefined ? null : dataTable2[index - 1][6]
            let currentData = dataTable2[index][6]
            let nextData = dataTable2[index + 1] == undefined ? null : dataTable2[index + 1][6]

            if (nextData == null) {
                dataTable2.splice(index, 1)
            } else if (nextData.includes('Total')) {
                if (prevData !== null && currentData == null) {
                    dataTable2.splice(index, 1)
                } else if (prevData !== null && prevData == currentData) {
                    dataTable2.splice(index, 1)
                } else if (dataTable2.length > 3) {
                    if (prevData == null) {
                        if (nextData.includes('Grand')) {
                            dataTable2.splice(index, 1)
                        } else {
                            dataTable2.splice(index, 2)
                        }
                    } else {
                        dataTable2.splice(index, 2)
                    }
                } else if (dataTable2.length == 3) {
                    if (prevData == null) {
                        if (nextData.includes('Grand')) {
                            dataTable2.splice(index, 1)
                        } else {
                            dataTable2.splice(index, 3)
                            dataTable2.push(
                                [3, "", "", "", "", this.props.company.company_name, "", null, "", null, "0.0", "0.0", "", "", "", "", 0],
                                [9, "", "", "", "", "", { value: "Grand Total" }, "", "", "", "", "", "", "", "", "notes", 999999],
                            )
                        }
                    } else {
                        dataTable2.splice(index, 1)
                    }
                }
            } else {
                dataTable2.splice(index, 1)
            }

            this.setState({ dataTable: dataTable2, dataDelete }, () => {
                setTimeout(() => {
                    console.log(this.state.dataDelete)
                    this.setState({ loading: false })
                }, 100)
            })
        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    filter: false,
                    display: this.props.get_for == 'view' ? false : true,
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 99, backgroundColor: '#dbdbdb' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {handleAction(tableMeta.rowData[0], tableMeta, 'add') && <span>
                                    <LightTooltip title={'Add'} arrow>
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                            }}
                                            // onClick={() => // // console.log(tableMeta.rowData[1])}
                                            onClick={() => {
                                                this.setState({ loading: true })
                                                handleTambah(tableMeta.rowData[1], tableMeta.rowIndex)
                                            }}
                                        >
                                            <img src={Images.add} />
                                        </button>
                                    </LightTooltip>
                                </span>}
                                {handleAction(tableMeta.rowData[0], tableMeta, 'delete') && <span>
                                    <LightTooltip title={'Delete'} arrow>
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                marginLeft: 5
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true })
                                                handleDelete(tableMeta.rowIndex)
                                            }}
                                        >
                                            <img src={Images.delete} style={{ width: 37, height: 37 }} />
                                        </button>
                                    </LightTooltip>
                                </span>}
                            </div >
                        );
                    }
                }
            }, {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'center', width: 90 }}>
                                {tableMeta.rowData[0] === 4 ?
                                    null :
                                    val
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Institution Name",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ display: 'flex', justifyContent: 'center' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] == 8 ?
                                    <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{val.value}</Typography>
                                    :
                                    tableMeta.rowData[0] == 9 ?
                                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{val}</Typography>
                                        :
                                        <div style={{ padding: 0, margin: 0 }}>
                                            <textarea disabled={this.props.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[6] == '' && this.props.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" defaultValue={tableMeta.rowData[6]}
                                                onBlur={(event) => handleChange(event.target.value, tableMeta, tableMeta.columnIndex)} />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Type Of Investment",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <Autocomplete
                                        {...this.state.typeOfInvestmentList}
                                        id="typeOfInvestmentList"
                                        onChange={(event, newInputValue) => handleChange(newInputValue, tableMeta, tableMeta.columnIndex)}
                                        debug
                                        value={handleValueDropDown(val, 'typeOfInvestmentList', tableMeta)}
                                        disableClearable
                                        disabled={this.props.get_for == 'view'}
                                        // disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                        style={{ padding: 0, margin: 0 }}
                                        renderInput={(params) =>
                                            <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                                <textarea style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[7] == null && this.props.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" {...params.inputProps} />
                                            </div>
                                        }
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Remarks",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'left', width: 90 }}>
                                {tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                    null :
                                    <div style={{ padding: 0, margin: 0 }}>
                                        <textarea disabled={this.props.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: this.props.get_for == 'view' ? 'white' : tableMeta.rowData[8] !== '' ? 'white' : tableMeta.rowData[7] == null ? '#ffac99' : (tableMeta.rowData[8] == '' && tableMeta.rowData[7].value == 'Time deposit' || tableMeta.rowData[7].value == 'N/A') ? 'white' : '#ffac99' }} type="text" defaultValue={tableMeta.rowData[8]}
                                            onBlur={(event) => handleChange(event.target.value, tableMeta, tableMeta.columnIndex)} />
                                    </div>
                                }

                            </div>
                        )
                    }
                }
            }, {
                name: "Placement Date",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9 ?
                                    null :
                                    <DatePicker
                                        margin="normal"
                                        id="loanMatureDate"
                                        // label="Valid To"
                                        format="dd-MM-yyyy"
                                        value={val}
                                        disabled={this.props.get_for == 'view'}
                                        onChange={(e) => handleChange(e, tableMeta, tableMeta.columnIndex, 'date')}
                                        // minDate={this.state.startDate}
                                        KeyboardButtonProps={{
                                            'aria-label': 'change date',
                                        }}
                                        inputProps={{
                                            style: {
                                                marginTop: -20,
                                                textAlign: 'center',
                                                fontSize: 11,
                                                height: 20,
                                                paddingBottom: 11,
                                                fontFamily: 'Nunito Sans, sans-serif',
                                                color: this.props.get_for == 'view' ? "black" : '#5198ea',
                                                backgroundColor: (tableMeta.rowData[9] == null || tableMeta.rowData[9] == '') && this.props.get_for == 'edit' ? '#ffac99' : 'white'
                                            }
                                        }}
                                        InputLabelProps={{
                                            style: {
                                                fontSize: 11,
                                                color: '#5198ea',
                                                fontFamily: 'Nunito Sans, sans-serif',
                                            }
                                        }}

                                        style={{ padding: 0, margin: 0, width: '100%' }}
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Tenor",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'left', width: 90 }}>
                                {tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                    null :
                                    <div style={{ padding: 0, margin: 0 }}>
                                        {/* {tableMeta.rowData[10] == '' || tableMeta.rowData[10] == 0.0 || tableMeta.rowData[10] == 0 && this.props.get_for == 'edit' ?
                                            <LightTooltipError title={"Data belum sesuai"} arrow>
                                                <textarea disabled={this.props.get_for == 'view'} style={{ fontSize: 12, borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[10] == '' || tableMeta.rowData[10] == 0.0 || tableMeta.rowData[10] == 0 && this.props.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" defaultValue={tableMeta.rowData[10]}
                                                    onBlur={(event) => handleChange(event.target.value, tableMeta, tableMeta.columnIndex)} />
                                            </LightTooltipError>
                                            : */}
                                        <textarea disabled={this.props.get_for == 'view'} style={{ fontSize: 12, borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: (this.props.get_for == 'edit' && tableMeta.rowData[10] == '' )|| (this.props.get_for == 'edit' && tableMeta.rowData[10] == 0.0) || (this.props.get_for == 'edit' && tableMeta.rowData[10] == 0) ? '#ffac99' : 'white' }} type="text" defaultValue={tableMeta.rowData[10]}
                                            onBlur={(event) => handleChange(event.target.value, tableMeta, tableMeta.columnIndex)} />
                                        {/* } */}
                                    </div>
                                }

                            </div>
                        )
                    }
                }
            }, {
                name: "Expected Return/Interest (%)",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9 ?
                                    null :
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        value={value}
                                        control={
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ color: this.props.get_for == 'view' ? "black" : "#5198ea", fontSize: 13, textAlign: 'center', paddingBottom: 18, borderColor: 'transparent', margin: 0, width: 96, backgroundColor: (this.props.get_for == 'edit' && tableMeta.rowData[11] == 0.00) || (this.props.get_for == 'edit' && tableMeta.rowData[11] == '') ? '#ffac99' : 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                decimalScale={this.props.defaultCurrency.id == 1 ? 2 : 16}
                                                disabled={this.props.get_for == 'view'}
                                                value={fixNumber(Number(tableMeta.rowData[11]), 2) == "0.0" ? "0.00" : fixNumber(Number(tableMeta.rowData[11]), 2)}
                                                onBlur={(event) => {
                                                    handleChange(event.target.value, tableMeta, 11)
                                                }}

                                            />
                                        }
                                    />
                                }
                            </div>
                        )
                    }
                }
            },
            // {
            //     name: "Currency",
            //     options: {
            //         customHeadRender: (columnMeta) => (
            //             <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
            //                 <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
            //             </TableCell>
            //         ),
            //         setCellProps: () => ({ style2 }),
            //         customBodyRender: (val, tableMeta, updateValue) => {
            //             return (
            //                 <div style={{ textAlign: 'right', width: 90 }}>
            //                     {tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 || tableMeta.rowData[0] === 4 ?
            //                         null :
            //                         <Autocomplete
            //                             {...this.state.currencyList}
            //                             id="currencyList"
            //                             onChange={(event, newInputValue) => handleChange(newInputValue, tableMeta, tableMeta.columnIndex)}
            //                             debug
            //                             value={handleValueDropDown(val, 'currencyList', tableMeta)}
            //                             disableClearable
            //                             disabled={this.props.get_for == 'view'}
            //                             style={{ padding: 0, margin: 0 }}
            //                             renderInput={(params) =>
            //                                 <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
            //                                     <textarea style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[12] == null && this.props.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" {...params.inputProps} />
            //                                 </div>
            //                             }
            //                         />
            //                     }
            //                 </div>
            //             )
            //         }
            //     }
            // }, 
            {
                name: "Currency",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] == 8 || tableMeta.rowData[0] == 9 ?
                                    null :
                                    <div style={{ padding: 0, margin: 0 }}>
                                        <textarea maxLength={3} disabled={this.props.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: tableMeta.rowData[12] == '' && this.props.get_for == 'edit' ? '#ffac99' : 'white' }} type="text" defaultValue={tableMeta.rowData[12]}
                                            onBlur={(event) => handleChange(event.target.value, tableMeta, tableMeta.columnIndex)} />
                                    </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Investment Amount (Original Currency)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div className="col-1">
                                <div style={{ textAlign: 'right', width: 90 }}>
                                    {tableMeta.rowData[0] === 4 ?
                                        null :
                                        tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "black", fontSize: 12, paddingBottom: 18, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[13]), 1) : Number(tableMeta.rowData[13]) == 0 ? "0.0" : Number(tableMeta.rowData[13])}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: this.props.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, paddingBottom: 18, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            disabled={this.props.get_for == 'view'}
                                                            value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(tableMeta.rowData[13]), 1) == 0.0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13]), 1)) : (Number(tableMeta.rowData[13]) == 0.0 ? "0.0" : Number(tableMeta.rowData[13]))}
                                                            onBlur={(event) => {
                                                                handleChange(event.target.value, tableMeta, 13)
                                                            }}

                                                        />
                                                    }
                                                />
                                            </div>
                                    }
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Investment Amount (Reporting Currency)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div className="col-1">
                                <div style={{ textAlign: 'right', width: 90 }}>
                                    {tableMeta.rowData[0] === 4 ?
                                        null :
                                        tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "black", fontSize: 12, paddingBottom: 18, textAlign: 'right', fontWeight: 'bold', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            // value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormulaHardcode(tableMeta.rowData[14], tableMeta, 14)), 1) : Number(handleFormulaHardcode(tableMeta.rowData[14], tableMeta, 14)) == 0 ? "0.0" : Number(handleFormulaHardcode(tableMeta.rowData[14], tableMeta, 14))}
                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[14]), 1) : Number(tableMeta.rowData[14]) == 0 ? "0.0" : Number(tableMeta.rowData[14])}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: this.props.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, paddingBottom: 18, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            disabled={this.props.get_for == 'view'}
                                                            value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(tableMeta.rowData[14]), 1) == 0.0 ? "0.0" : fixNumber(Number(tableMeta.rowData[14]), 1)) : (Number(tableMeta.rowData[14]) == 0.0 ? "0.0" : Number(tableMeta.rowData[14]))}
                                                            onBlur={(event) => {
                                                                handleChange(event.target.value, tableMeta, 14)
                                                            }}

                                                        />
                                                    }
                                                />
                                            </div>
                                    }
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "Notes",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, height: 42, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'left', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 8 || tableMeta.rowData[0] === 9 ?
                                    null :
                                    <div style={{ padding: 0, margin: 0 }}>
                                        <textarea disabled={this.props.get_for == 'view'} style={{ borderColor: 'white', width: 96, textAlign: 'center', justifyContent: 'center', padding: 0, margin: 0, color: this.props.get_for == 'view' ? "black" : "#5198ea", backgroundColor: 'transparent' }} type="text" defaultValue={tableMeta.rowData[15]}
                                            onBlur={(event) => handleChange(event.target.value, tableMeta, 45)} />
                                    </div>
                                    // <FormControlLabel
                                    //     style={{ margin: 0 }}
                                    //     control={
                                    //         <ThemeProvider theme={theme}>
                                    //             <Input
                                    //                 disableUnderline={true}
                                    //                 style={{ color: this.props.get_for == 'view'? "black" : "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 75, backgroundColor: 'transparent' }}
                                    //                 type="text"
                                    //                 placeholder=""
                                    //                 multiline={true}
                                    //                 defaultValue={tableMeta.rowData[45]}
                                    //                 disabled={this.props.get_for == 'view'}
                                    //                 onBlur={(event) => {
                                    //                     handleChange(event.target.value, tableMeta, 45)
                                    //                 }}
                                    //             />
                                    //         </ThemeProvider>
                                    //     }
                                    // />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }
        ]

        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        const handleClose = (event, reason) => {
            if (reason === 'clickaway') {
                return;
            }

            this.setState({
                snekbar: false,
                snekbarMsg: ''
            })
        };

        return (
            <div>
                {this.state.visibleLOVMR ?
                    <div style={{ padding: 20 }}>
                        <Snackbar open={this.state.snekbar} autoHideDuration={6000} onClose={handleClose}>
                            <Alert onClose={handleClose} severity="error">
                                {this.state.snekbarMsg}
                            </Alert>
                        </Snackbar>
                        <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                            <div>
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', fontWeight: 'bold' }}>List Of Investment</Typography>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                {this.props.defaultCurrency.id === 1 ?
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    :
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                }
                            </div>
                            <div style={{ width: '50%' }}>
                                <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                    {(this.props.get_for == 'edit' &&
                                        <div>
                                            <a data-tip={'Download Template'} data-for="template">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.downloadTemplate()}
                                                >
                                                    <img src={Images.template} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                        </div>
                                    )}
                                    {(this.props.get_for == 'edit' &&
                                        <div>
                                            <a data-tip={'Upload'} data-for="upload">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() =>
                                                        this.setState({ visibleUpload: true })
                                                    }
                                                >
                                                    <img src={Images.upload} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                        </div>
                                    )}
                                    {/* <a data-tip={'Download'} data-for="download">
                                 <button
                                     style={{
                                         backgroundColor: 'transparent',
                                         cursor: 'pointer',
                                         borderColor: 'transparent',
                                         margin: 5
                                     }}
                                     onClick={() => 
                                         this.setState({ loading: true }, () => {
                                             setTimeout(() => {
                                                 this.downloadAllData()
                                             }, 100);
                                         })
                                     }
                                 >
                                     <img src={Images.download} />
                                 </button>
                             </a>
                             <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                </div>
                                {/* } */}
                            </div>
                        </div>

                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                            {this.state.loading && loadingComponent}
                            {!this.state.loading && <MuiThemeProvider theme={getMuiTheme()}>
                                <MUIDataTable
                                    data={dataTable2}
                                    columns={columns}
                                    options={options}
                                />
                            </MuiThemeProvider>}
                            {this.props.get_for == 'view' && this.state.viewOnly && <div style={{ color: '#000', marginTop: 10, fontSize: 12 }}>(*) There may be discrepancies in amount due to rounding</div>}
                        </div>

                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15, marginTop: 5 }}>
                            <div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.props.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.props.updateBy.length > 0 ? this.props.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                        }
                                    </div>
                                </div>
                            </div>
                            <div style={{ display: 'flex', flexDirection: 'row' }}>
                                <div style={{ padding: 5 }}>
                                    <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Total Investment</Typography>
                                </div>
                                <div style={{ border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                    <Typography style={{ fontSize: '14px', color: '#4b4b4b' }}><NumberFormat value={this.state.perBS} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                </div>
                            </div>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <div>
                                {/* <Typography style={{ fontSize: '12px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.props.notes}</Typography> */}
                            </div>
                            <div style={{ display: 'flex', flexDirection: 'row' }}>
                                <div style={{ padding: 5 }}>
                                    <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Diff</Typography>
                                </div>
                                <div style={{ borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                    <Typography style={{ fontSize: '14px', color: Number(this.state.diff) > '0.0' || Number(this.state.diff) < '0.0' ? 'red' : '#4b4b4b' }}><NumberFormat value={this.state.diff == 0 ? "0.0" : this.state.diff} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                </div>
                            </div>
                        </div>
                        {/* <div style={{ display: 'flex', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, fontWeight: 'bold', textDecorationLine: 'underline' }}>Keterangan:</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>1. Current ratio = Current Assets / Current Liabilities</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>2. DER = Interest Bearing Debt / Total Equity (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder)</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>3. Debt to EBITDA = Interest Bearing Debt / EBITDA (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginLeft: 10 }}>& EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>4. EBITDA to Interest (ISCR) = EBITDA / Interest Expenses (dimana EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                        </div> */}

                        {/* <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15, marginTop: 5}}>
                     <div style={{display: 'flex', flexDirection: 'row'}}>
                         <div style={{padding: 5}}>
                             <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Total Outstanding Loan</Typography>
                         </div>
                         <div style={{border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                             <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{formatSeparator(this.state.totalOutStand)}</Typography>
                         </div>
                     </div>
                 </div>
                 <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15}}>
                     <div style={{display: 'flex', flexDirection: 'row'}}>
                         <div style={{padding: 5}}>
                             <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Diff</Typography>
                         </div>
                         <div style={{borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                             <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{formatSeparator(this.state.diff)}</Typography>
                         </div>
                     </div>
                 </div> */}
                    </div>
                    :
                    <div style={{ padding: 20 }}>
                        <div>
                            <Typography style={{ fontSize: '12px', color: '#4b4b4b', fontWeight: 'bold' }}>List Of Investment</Typography>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                            {this.props.defaultCurrency.id === 1 ?
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                :
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                            }
                        </div>

                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                            {this.state.loading && loadingComponent}
                            {this.state.dataLoaded && !this.state.loading && <MuiThemeProvider theme={getMuiTheme()}>
                                <MUIDataTable
                                    data={dataTable2}
                                    columns={columns}
                                    options={options}
                                />
                            </MuiThemeProvider>}
                        </div>

                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15, marginTop: 5 }}>
                            <div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.props.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.props.updateBy.length > 0 ? this.props.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                        }
                                    </div>
                                </div>
                            </div>
                            <div style={{ display: 'flex', flexDirection: 'row' }}>
                                <div style={{ padding: 5 }}>
                                    <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Total Outstanding Loan</Typography>
                                </div>
                                <div style={{ border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                    <Typography style={{ fontSize: '14px', color: '#4b4b4b' }}><NumberFormat value={this.state.perBS} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                </div>
                            </div>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <div>
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.props.notes}</Typography>
                            </div>
                            <div style={{ display: 'flex', flexDirection: 'row' }}>
                                <div style={{ padding: 5 }}>
                                    <Typography style={{ fontSize: '12px', color: '#4b4b4b' }}>Diff</Typography>
                                </div>
                                <div style={{ borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                    <Typography style={{ fontSize: '14px', color: Number(this.state.diff) > '0.0' || Number(this.state.diff) < '0.0' ? 'red' : '#4b4b4b' }}><NumberFormat value={this.state.diff} displayType={'text'} thousandSeparator={true} prefix={''} /></Typography>
                                </div>
                            </div>
                        </div>

                        <div style={{ display: 'flex', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, fontWeight: 'bold', textDecorationLine: 'underline' }}>Keterangan:</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>1. Current ratio = Current Assets / Current Liabilities</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>2. DER = Interest Bearing Debt / Total Equity (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder)</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>3. Debt to EBITDA = Interest Bearing Debt / EBITDA (dimana Interest Bearing Debt = Short term loan + Current maturities of long term debt + Long term loan + Due to affiliated companies + Due to shareholder</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginLeft: 10 }}>& EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 5, paddingRight: 15 }}>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>4. EBITDA to Interest (ISCR) = EBITDA / Interest Expenses (dimana EBITDA = Income from operations 2 (EBIT 2) + depreciation)</Typography>
                        </div>

                        {/* <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15, marginTop: 5}}>
                            <div style={{display: 'flex', flexDirection: 'row'}}>
                                <div style={{padding: 5}}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Total Outstanding Loan</Typography>
                                </div>
                                <div style={{border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{formatSeparator(this.state.perBS)}</Typography>
                                </div>
                            </div>
                        </div>
                        <div style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingLeft: 15, paddingRight: 15}}>
                            <div style={{display: 'flex', flexDirection: 'row'}}>
                                <div style={{padding: 5}}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Diff</Typography>
                                </div>
                                <div style={{borderStyle: 'solid', borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end'}}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{(formatSeparator(this.state.diff))}</Typography>
                                </div>
                            </div>
                        </div> */}
                    </div>
                }

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File List Of Investment</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("LIST") && String(this.state.judul).includes("INVESTMENT") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") ?
                                            this.checkUpload() :
                                            this.setState({ snekbar: true, snekbarMsg: 'Invalid Template', tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}
            </div>
        )
    }

}