import { createMuiTheme, FormControlLabel, Input, MuiThemeProvider, Paper, Snackbar, TableCell, Tooltip, Typography, withStyles } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import ReactTooltip from 'react-tooltip';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import * as R from 'ramda';
import { PropagateLoader } from 'react-spinners';
import { ExcelRenderer } from 'react-excel-renderer';
import Constant from '../../library/Constant';
import UploadFile from "../../library/Upload";
import { Alert } from '@material-ui/lab';
import { fixNumber, roundMath } from "../../library/Utils";

const LightTooltip = withStyles((theme) => ({
    tooltip: {

        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};
const stylenotes = {
    position: "sticky",
    background: "white",
    zIndex: 101,
    left: 350
};

const styleNotesEmpty = {
    position: "sticky",
    background: "white",
    zIndex: 99,
    left: 0
}
// const StyledButton = withStyles({
//     root: {
//       background: 'linear-gradient(45deg, #FE6B8B 30%, #FF8E53 90%)',
//       borderRadius: 3,
//       border: 0,
//       color: 'white',
//       height: 48,
//       padding: '0 30px',
//       boxShadow: '0 3px 5px 2px rgba(255, 105, 135, .3)',
//     },
//     label: {
//       textTransform: 'capitalize',
//     },
//   })(Input);

export default class ProfitLossROO extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            visiblePLRO: true,
            minValue: 0,
            maxValue: 0,
            updateBy: [],
            notesUpdate: '-',
            bebas: false,
            judulColumn: null,
            handleDoubleClick: 0,
            saveDraft: true,
            buttonError: true,
            viewOnly: true,
            get_for: 'view',
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false

        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getItemHierarki()
        this.getLatestUpdate()
        // this.getSettingControl()
        // this.handleViewOnly()
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            // this.getLatestUpdate()
            // this.getSettingControl()
            this.getItemHierarki()

        })
    }

    // getSettingControl() {
    //     let body = {
    //         group: 'THRESHOLD_VARIANCE',
    //         company_id: this.props.company.company_id,
    //         type: 'PNL'
    //     }

    //     api.create().getAllSettingByType(body).then(response => {
    //         console.log(response);
    //         if (response.data) {
    //             if (response.data.status === 'success') {
    //                 this.setState({
    //                     // valueThreshold: response.data.data[0] ? response.data.data[0].value : null,
    //                     minValue: response.data.data[0] ? Number(response.data.data[0].min_value) : -10,
    //                     maxValue: response.data.data[0] ? Number(response.data.data[0].max_value) : 10,

    //                 }, () => {
    //                     this.getItemHierarki()
    //                 })
    //             } else {
    //                 this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
    //                     if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
    //                         setTimeout(() => {
    //                             localStorage.removeItem(Constant.TOKEN)
    //                             window.location.reload();
    //                         }, 1000);
    //                     }
    //                 })
    //             }
    //         } else {
    //             this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
    //         }
    //     })
    // }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "rolling_outlook_id": this.props.rollingOutlookID,
            "quartal": this.props.quarter
        }
        api.create().getRollingOutlookLastUpdate(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? '-' : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        let payload = {
            "company_id": this.props.company.company_id,
            "get_for": this.state.get_for,
            "quartal": this.props.quarter,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "rolling_outlook_id": this.props.rollingOutlookID,
            "currency_id": this.props.defaultCurrency.id
        }
        console.log("getItemHierarki payload", payload);
        api.create().getRollingOutlookPL(payload).then(response => {
            console.log("getItemHierarki getRollingOutlookPL", response);
            let dataTable = []
            let err = false

            if (response.data) {
                if (response.data.status === 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_loss.notes,
                                item.profit_loss.last_year_total === "" ? "0" : item.profit_loss.last_year_total,
                                item.profit_loss.january === "" ? "0" : item.profit_loss.january,
                                item.profit_loss.february === "" ? "0" : item.profit_loss.february,
                                item.profit_loss.march === "" ? "0" : item.profit_loss.march,
                                item.profit_loss.april === "" ? "0" : item.profit_loss.april,
                                item.profit_loss.may === "" ? "0" : item.profit_loss.may,
                                item.profit_loss.june === "" ? "0" : item.profit_loss.june,
                                item.profit_loss.july === "" ? "0" : item.profit_loss.july,
                                item.profit_loss.august === "" ? "0" : item.profit_loss.august,
                                item.profit_loss.september === "" ? "0" : item.profit_loss.september,
                                item.profit_loss.october === "" ? "0" : item.profit_loss.october,
                                item.profit_loss.november === "" ? "0" : item.profit_loss.november,
                                item.profit_loss.december === "" ? "0" : item.profit_loss.december,
                                item.profit_loss.current_year_total === "" ? "0" : item.profit_loss.current_year_total,
                                "",
                                item.order,
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.profit_loss.notes,
                            item.profit_loss.last_year_total === "" ? "0" : item.profit_loss.last_year_total,
                            item.profit_loss.january === "" ? "0" : item.profit_loss.january,
                            item.profit_loss.february === "" ? "0" : item.profit_loss.february,
                            item.profit_loss.march === "" ? "0" : item.profit_loss.march,
                            item.profit_loss.april === "" ? "0" : item.profit_loss.april,
                            item.profit_loss.may === "" ? "0" : item.profit_loss.may,
                            item.profit_loss.june === "" ? "0" : item.profit_loss.june,
                            item.profit_loss.july === "" ? "0" : item.profit_loss.july,
                            item.profit_loss.august === "" ? "0" : item.profit_loss.august,
                            item.profit_loss.september === "" ? "0" : item.profit_loss.september,
                            item.profit_loss.october === "" ? "0" : item.profit_loss.october,
                            item.profit_loss.november === "" ? "0" : item.profit_loss.november,
                            item.profit_loss.december === "" ? "0" : item.profit_loss.december,
                            item.profit_loss.current_year_total === "" ? "0" : item.profit_loss.current_year_total,
                            "",
                            item.order,
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    // if (err === true) {
                    //     this.setState({ bebas: true })
                    // }
                    this.setState({ dataTable, loading: false, buttonError: true, saveDraft: true, refresh: false })
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ dataTable, loading: false, buttonError: true, saveDraft: true, refresh: false })
            }
            console.log("getItemHierarki dataTable", dataTable);
        })
    }

    downloadTemplate = async () => {
        // alert('Coming Soon ...')
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/profit_loss/rolling_outlook/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&quartal=${this.props.quarter}`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Rolling Outlook Profit Loss.xlsx';
            a.click();
        }
        setTimeout(() => {
            this.setState({ loading: false })
        }, 500);
    }

    async downloadAllData() {
        // alert('Coming Soon ...')
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/profit_loss/rolling_outlook/export_rolling_outlook?rolling_outlook_id=${this.props.rollingOutlookID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&quartal=${this.props.quarter}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/profit_loss/rolling_outlook/export_rolling_outlook?rolling_outlook_id=${this.props.rollingOutlookID === null ? "" : this.props.rollingOutlookID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&quartal=${this.props.quarter}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Rolling Outlook Profit Loss.xlsx';
            a.click();
        }
        setTimeout(() => {
            this.setState({ loading: false })
        }, 500);
    }

    backToRollingOutlook(type) {
        console.log('test');
        // this.setState({ loading: true })
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                "item_report_id": i[1],
                "notes": String(i[6]),
                "last_year_total": String(Number(i[7]).toFixed(1)),
                "january": String(Number(i[8]).toFixed(1)),
                "february": String(Number(i[9]).toFixed(1)),
                "march": String(Number(i[10]).toFixed(1)),
                "april": String(Number(i[11]).toFixed(1)),
                "may": String(Number(i[12]).toFixed(1)),
                "june": String(Number(i[13]).toFixed(1)),
                "july": String(Number(i[14]).toFixed(1)),
                "august": String(Number(i[15]).toFixed(1)),
                "september": String(Number(i[16]).toFixed(1)),
                "october": String(Number(i[17]).toFixed(1)),
                "november": String(Number(i[18]).toFixed(1)),
                "december": String(Number(i[19]).toFixed(1)),
                "current_year_total": String(Number(i[20]).toFixed(1)),
            })
        })
        let payload = {
            "rolling_outlook_id": this.props.rollingOutlookID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "quartal": this.props.quarter,
            "status": type,
            "profit_loss": data
        }
        console.log("backToRollingOutlook payload", payload);
        // console.log(JSON.stringify(payload));
        api.create('UPLOAD').createRollingOutlookPL(payload).then(response => {
            console.log("backToRollingOutlook createRollingOutlookPL", response);
            if (response.data) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.refresh('PL')
                    } else {
                        this.props.refresh()
                    }
                    this.props.onClickClose()
                } else {
                    this.setState({ visibleAlertSave: true, alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                        document.body.style.overflow = 'unset';
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                        // this.props.saveToMonthlyReport()
                        this.props.onClickClose()
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(resp.rows[2]);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            orders: i[0] === undefined ? "" : String(i[0]).trim(),
                            "item_report_id": i[1] === undefined ? 0 : i[1],
                            "item_report": i[2] === undefined ? "" : String(i[2]).trim(),
                            "notes": i[3] === undefined ? "" : reg.test(String(i[3])) === false ? "" : String(i[3]).trim(),
                            "january": i[5] === undefined ? "0" : reg.test(String(fixNumber(Number(i[5]), 1))) === false ? "0" : String(fixNumber(Number(i[5]), 1)).trim(),
                            "february": i[6] === undefined ? "0" : reg.test(String(fixNumber(Number(i[6]), 1))) === false ? "0" : String(fixNumber(Number(i[6]), 1)).trim(),
                            "march": i[7] === undefined ? "0" : reg.test(String(fixNumber(Number(i[7]), 1))) === false ? "0" : String(fixNumber(Number(i[7]), 1)).trim(),
                            "april": i[8] === undefined ? "0" : reg.test(String(fixNumber(Number(i[8]), 1))) === false ? "0" : String(fixNumber(Number(i[8]), 1)).trim(),
                            "may": i[9] === undefined ? "0" : reg.test(String(fixNumber(Number(i[9]), 1))) === false ? "0" : String(fixNumber(Number(i[9]), 1)).trim(),
                            "june": i[10] === undefined ? "0" : reg.test(String(fixNumber(Number(i[10]), 1))) === false ? "0" : String(fixNumber(Number(i[10]), 1)).trim(),
                            "july": i[11] === undefined ? "0" : reg.test(String(fixNumber(Number(i[11]), 1))) === false ? "0" : String(fixNumber(Number(i[11]), 1)).trim(),
                            "august": i[12] === undefined ? "0" : reg.test(String(fixNumber(Number(i[12]), 1))) === false ? "0" : String(fixNumber(Number(i[12]), 1)).trim(),
                            "september": i[13] === undefined ? "0" : reg.test(String(fixNumber(Number(i[13]), 1))) === false ? "0" : String(fixNumber(Number(i[13]), 1)).trim(),
                            "october": i[14] === undefined ? "0" : reg.test(String(fixNumber(Number(i[14]), 1))) === false ? "0" : String(fixNumber(Number(i[14]), 1)).trim(),
                            "november": i[15] === undefined ? "0" : reg.test(String(fixNumber(Number(i[15]), 1))) === false ? "0" : String(fixNumber(Number(i[15]), 1)).trim(),
                            "december": i[16] === undefined ? "0" : reg.test(String(fixNumber(Number(i[16]), 1))) === false ? "0" : String(fixNumber(Number(i[16]), 1)).trim(),
                        })
                    }
                })
                console.log("fileHandler payload", payload)
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    quartal: this.props.quarter,
                    rolling_outlook_id: this.props.rollingOutlookID,
                    status: 'submitted',
                    profit_loss: payload
                }
                console.log("fileHandler body", body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkImportRollingOutlookPL(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log("checkUpload Response", response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visiblePLRO: false, loading: true })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.notes,
                            item.last_year_total === "" ? "0" : item.last_year_total,
                            item.january === "" ? "0" : item.january,
                            item.february === "" ? "0" : item.february,
                            item.march === "" ? "0" : item.march,
                            item.april === "" ? "0" : item.april,
                            item.may === "" ? "0" : item.may,
                            item.june === "" ? "0" : item.june,
                            item.july === "" ? "0" : item.july,
                            item.august === "" ? "0" : item.august,
                            item.september === "" ? "0" : item.september,
                            item.october === "" ? "0" : item.october,
                            item.november === "" ? "0" : item.november,
                            item.december === "" ? "0" : item.december,
                            item.current_year_total === "" ? "0" : item.current_year_total,
                            "",
                            item.order,
                        ]
                    })
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false }, () => {
                        this.state.dataTable.map(item => {
                            // if (item[24].length > 0) {
                            //     // console.log('masuk')
                            //     this.setState({ buttonError: true, errorPreview: true })
                            // }
                        })
                        // console.log(this.state.buttonError)
                    })
                    console.log("checkUpload DataTable", dataTable);
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadProfitLossRO(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                "item_report_id": i[1],
                "item_report": i[5],
                "notes": String(i[6]),
                "last_year_total": String(Number(i[7]).toFixed(1)),
                "january": String(Number(i[8]).toFixed(1)),
                "february": String(Number(i[9]).toFixed(1)),
                "march": String(Number(i[10]).toFixed(1)),
                "april": String(Number(i[11]).toFixed(1)),
                "may": String(Number(i[12]).toFixed(1)),
                "june": String(Number(i[13]).toFixed(1)),
                "july": String(Number(i[14]).toFixed(1)),
                "august": String(Number(i[15]).toFixed(1)),
                "september": String(Number(i[16]).toFixed(1)),
                "october": String(Number(i[17]).toFixed(1)),
                "november": String(Number(i[18]).toFixed(1)),
                "december": String(Number(i[19]).toFixed(1)),
                "current_year_total": String(Number(i[20]).toFixed(1)),
            })
        })
        console.log("uploadProfitLossRO Data", data)
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            currency_id: this.state.defaultCurrencyUpload?.id,
            "quartal": this.props.quarter,
            "rolling_outlook_id": this.props.rollingOutlookID,
            "status": type,
            "profit_loss": data
        }
        console.log("uploadProfitLossRO Body", body);
        api.create('UPLOAD').importRollingOutlookPL(body).then(response => {
            console.log("uploadProfitLossRO importRollingOutlookPL", response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.props.onClickClose()
                        if (type == 'submitted') {
                            this.props.refresh('PL')
                        } else {
                            this.props.refresh()
                        }
                        // this.props.onClickClose()
                        // this.props.getReport()
                    } else {
                        this.setState({ visibleAlertSave: true, alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                            this.props.onClickClose()
                            this.props.refresh()
                        })
                        // alert(response.data.status)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    handleValidate() {
        // let data = []
        // let err = false
        // this.state.dataTable.map((i, index) => {
        //     data.push({
        //         "item_report_id": i[1],
        //         "notes": i[6],
        //         "rolling_outlook": i[7],
        //         "master_budget": i[8],
        //         "rolling_budget": i[9],
        //         "actual": i[10],
        //         "ytd_actual": i[11],
        //         "actual_previous_month": i[12],
        //         "amount_act_vs_previous_month": i[13],
        //         "percent_act_vs_previous_month": i[14],
        //         "amount_act_vs_mb": i[15],
        //         "percent_act_vs_mb": i[16],
        //         "amount_act_vs_rb": i[17],
        //         "percent_act_vs_rb": i[18],
        //         "mtd_vs_mb": i[19],
        //         "mtd_vs_rb": i[20],
        //         "mtd_vs_previous_month": i[21],
        //     })
        // })

        // console.log(this.state.dataTable);
        // console.log(JSON.stringify(data))
        // let payload = {
        //     "monthly_report_id": this.props.monthlyReportId,
        //     "company_id": this.props.company.company_id,
        //     "periode": this.props.periode,
        //     "report_id": this.props.report_id,
        //     "status": "submitted",
        //     "months": this.props.month.month_id,
        //     "profit_loss": data
        // }
        // console.log(JSON.stringify(payload));
        // api.create().validateSubmitReportPL(payload).then((response) => {
        //     console.log(response.data.data.result)
        //     console.log(err);
        //     if (response.data) {
        //         if (response.data.status === "success") {
        //             if (response.data.data.result && err === false) {
        this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
        //             } else {
        //                 this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
        //             }
        //         } else {
        //             this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
        //                 if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
        //                     setTimeout(() => {
        //                         localStorage.removeItem(Constant.TOKEN)
        //                         window.location.reload();
        //                     }, 1000);
        //                 }
        //             })
        //         }
        //     } else {
        //         this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
        //     }
        // })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable

        const handleNotes = (value, tableMeta) => {
            // console.log(value)
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
            // console.log(dataTable2[tableMeta.rowIndex]);
        }

        const handleChange = (value, tableMeta, type) => {
            console.log(dataTable2);
            let val = String(value).split(",").join("")
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            console.log("handleChange ", val)
        }

        const handleValue = (value, data) => {
            let total = 0
            // console.log(data);
            // console.log(dataTable2);
            dataTable2.map((item, index) => {
                if (data.rowData[1] == item[2]) {
                    total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(String(item[data.columnIndex]).includes('-') ? Number(String(item[data.columnIndex]).substr(1, String(item[data.columnIndex]).length)) * -1 : Number(item[data.columnIndex])))
                    // if (data.rowData[5] == "Revenue") {
                    //     console.log(total);
                    //     // console.log(a);
                    // }
                }
            })
            // console.log(total);
            let indexParent = dataTable2.findIndex((val) => val[1] == dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex] = Number(total)

            return a
        }

        const handleFormula = (data, tableMeta, month) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayJumlah = []
            let tambahan = false
            let opet = ""
            arrayFormula.map((item, indexs) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*') {
                    arrayJumlah.push(item)
                } else {
                    let index = dataTable2.findIndex((val) => val[22] == item)
                    if (tambahan) {
                        if (item == '-' || item == '+' || item == '/' || item == '*') {
                            opet = item
                        } else {
                            arrayJumlah.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                            tambahan = false
                            opet = ""
                        }
                    } else {
                        if (index != -1) {
                            if (item === String(tableMeta.rowData[23])) {
                                arrayJumlah.push(0)
                            } else {
                                arrayJumlah.push(dataTable2[index][tableMeta.columnIndex])
                            }
                        }
                    }
                }

                // if (indexs % 2 !== 0) {
                //     operator.push(item)
                // }
            })
            // if (String(tableMeta.rowData[5]) == "Net Trading Profit (TPAT)") {
            // console.log(tableMeta.rowData[3])
            // console.log(arrayFormula)
            // console.log(arrayJumlah)
            // }

            let array = arrayJumlah
            let total = 0
            let opt = ""
            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = fixNumber(Number(total), 1) * fixNumber(Number(item), 1)// angka yg diupload menjadi bilangan bulat
                    } else if (opt == "bagi") {
                        total = R.equals((Number(total) / Number(item)), NaN) ? '0' : (R.equals((Number(total) / Number(item)), Infinity) ? '0' : (Number(total) / Number(item) == "-Infinity") ? "0.0" : Number(total) / Number(item))
                    } else {
                        total += Number(item)
                    }
                }
            })
            total = R.equals(total, NaN) ? "0.0" : (R.equals(total, Infinity) ? "0.0" : (total == "-Infinity" ? "0.0" : total))
            // if (tableMeta.rowData[1] === 20092) {
            //     console.log(total);
            //     console.log(arrayJumlah);
            // }
            // if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] === "" || dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] === undefined || dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] === null) {
            // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total).toFixed(1)
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = fixNumber(Number(total), 1)//hasil dari penjumlahan/kali/pembagian menjadi bilangan bulat

            // }

            return Number(total)


        }

        const handleTotal = (val, tableMeta) => {
            let total = 0
            tableMeta.rowData.map((item, index) => {
                if (index >= 8 && index <= 19) {
                    total += Number(item)
                }
            })

            if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "sales price") {
                let value = Number(dataTable2[tableMeta.rowIndex - 2][20]) / Number(dataTable2[tableMeta.rowIndex - 1][20])
                dataTable2[tableMeta.rowIndex][20] = R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
                return R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
            }
            // else if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "total man power") {
            //     let totalTMP = dataTable2[tableMeta.rowIndex][20] = dataTable2[tableMeta.rowIndex][19]
            //     return totalTMP
            // } else if (indexParent !== -1 && String(dataTable2[indexParent][5]).toLocaleUpperCase() == "GROSS PROFIT MARGIN (% OF REVENUE)") {
            //     return handleFormula(0, tableMeta, 0)
            // }
            else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
                return total
            }
            // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            // if (String(tableMeta.rowData[5]).toLocaleLowerCase === "sales volume") {
            // console.log(total);
            // }
            // return total
        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[0] === null ?
                                    tableMeta.rowData[4] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Notes",
                options: {
                    customHeadRender: (columnMeta) => (
                        dataTable2.length > 0 ?
                            <TableCell style={{ ...stylenotes, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> :
                            <TableCell style={{ ...styleNotesEmpty, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell>
                    ),
                    setCellProps: () => ({
                        style: {
                            position: "sticky",
                            background: "white",
                            zIndex: 101,
                            left: 350
                        }
                    }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                <div style={{ flex: 1 }}>
                                    {tableMeta.rowData[0] === 4 ? null : tableMeta.rowData[4] === 0 ? null : tableMeta.rowData[4] === 1 ? null :
                                        this.state.get_for == 'view' ?
                                            <Input
                                                disableUnderline={true}
                                                style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                disabled={true}
                                                defaultValue={value}
                                            />
                                            :
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                // value={value}
                                                control={
                                                    <Input
                                                        disableUnderline={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        defaultValue={value}
                                                        inputProps={{
                                                            style: {
                                                                color: "#5198ea"
                                                            }
                                                        }}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleNotes(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />}
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `${Number(this.props.periode) - 1} Total Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        // tableMeta.rowData[0] === 2 ?
                                        //     <span style={{ fontSize: 12, textAlign: 'right' }}>
                                        //         <NumberFormat
                                        //             thousandSeparator={true}
                                        //             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //             type="text"
                                        //             placeholder=""
                                        //             disabled={true}
                                        //             // value={Number(val).toFixed(1)}
                                        //             value={Number(handleValue(val, tableMeta)).toFixed(1)}
                                        //         />
                                        //     </span>
                                        //     :
                                        //     tableMeta.rowData[0] === 3 ?
                                        //         <div style={{ flex: 1 }}>
                                        //             <FormControlLabel
                                        //                 style={{ margin: 0 }}
                                        //                 value={val}
                                        //                 control={
                                        //                     <NumberFormat
                                        //                         thousandSeparator={true}
                                        //                         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                         type="text"
                                        //                         placeholder=""
                                        //                         // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                        //                         disabled={true}
                                        //                         value={Number(val).toFixed(1)}
                                        //                         onBlur={(event) => {
                                        //                             handleChange(event.target.value, tableMeta)
                                        //                         }}
                                        //                     />
                                        //                 }
                                        //             />
                                        //         </div>
                                        //         :
                                        //         tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                        //             <div style={{ flex: 1 }}>
                                        //                 <FormControlLabel
                                        //                     style={{ margin: 0 }}
                                        //                     value={val}
                                        //                     control={
                                        //                         <NumberFormat
                                        //                             thousandSeparator={true}
                                        //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                             type="text"
                                        //                             placeholder=""
                                        //                             disabled={true}
                                        //                             value={Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                        //                         />
                                        //                     }
                                        //                 />
                                        //             </div>
                                        //             :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(val).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Jan ${this.props.periode} Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        // tableMeta.rowData[0] === 2 ?
                                        //     <span style={{ fontSize: 12, textAlign: 'right' }}>
                                        //         <NumberFormat
                                        //             thousandSeparator={true}
                                        //             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //             type="text"
                                        //             placeholder=""
                                        //             disabled={true}
                                        //             // value={Number(val).toFixed(1)}
                                        //             value={val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)}
                                        //         />
                                        //     </span>
                                        //     :
                                        //     tableMeta.rowData[0] === 3 ?
                                        //         <div style={{ flex: 1 }}>
                                        //             <FormControlLabel
                                        //                 style={{ margin: 0 }}
                                        //                 value={val}
                                        //                 control={
                                        //                     <NumberFormat
                                        //                         thousandSeparator={true}
                                        //                         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                         type="text"
                                        //                         placeholder=""
                                        //                         // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                        //                         disabled={true}
                                        //                         value={val === "0" ? "" : Number(val).toFixed(1)}
                                        //                         onBlur={(event) => {
                                        //                             handleChange(event.target.value, tableMeta)
                                        //                         }}
                                        //                     />
                                        //                 }
                                        //             />
                                        //         </div>
                                        //         :
                                        //         tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                        //             <div style={{ flex: 1 }}>
                                        //                 <FormControlLabel
                                        //                     style={{ margin: 0 }}
                                        //                     value={val}
                                        //                     control={
                                        //                         <NumberFormat
                                        //                             thousandSeparator={true}
                                        //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                             type="text"
                                        //                             placeholder=""
                                        //                             disabled={true}
                                        //                             value={val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                        //                         />
                                        //                     }
                                        //                 />
                                        //             </div>
                                        //             :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={val === "0" ? "" : Number(val).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Feb ${this.props.periode} Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        // tableMeta.rowData[0] === 2 ?
                                        //     <span style={{ fontSize: 12, textAlign: 'right' }}>
                                        //         <NumberFormat
                                        //             thousandSeparator={true}
                                        //             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //             type="text"
                                        //             placeholder=""
                                        //             disabled={true}
                                        //             // value={Number(val).toFixed(1)}
                                        //             value={val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)}
                                        //         />
                                        //     </span>
                                        //     :
                                        //     tableMeta.rowData[0] === 3 ?
                                        //         <div style={{ flex: 1 }}>
                                        //             <FormControlLabel
                                        //                 style={{ margin: 0 }}
                                        //                 value={val}
                                        //                 control={
                                        //                     <NumberFormat
                                        //                         thousandSeparator={true}
                                        //                         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                         type="text"
                                        //                         placeholder=""
                                        //                         // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                        //                         disabled={true}
                                        //                         value={val === "0" ? "" : Number(val).toFixed(1)}
                                        //                         onBlur={(event) => {
                                        //                             handleChange(event.target.value, tableMeta)
                                        //                         }}
                                        //                     />
                                        //                 }
                                        //             />
                                        //         </div>
                                        //         :
                                        //         tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                        //             <div style={{ flex: 1 }}>
                                        //                 <FormControlLabel
                                        //                     style={{ margin: 0 }}
                                        //                     value={val}
                                        //                     control={
                                        //                         <NumberFormat
                                        //                             thousandSeparator={true}
                                        //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                             type="text"
                                        //                             placeholder=""
                                        //                             disabled={true}
                                        //                             value={val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                        //                         />
                                        //                     }
                                        //                 />
                                        //             </div>
                                        //             :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={val === "0" ? "" : Number(val).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Mar ${this.props.periode} Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        // tableMeta.rowData[0] === 2 ?
                                        //     <span style={{ fontSize: 12, textAlign: 'right' }}>
                                        //         <NumberFormat
                                        //             thousandSeparator={true}
                                        //             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //             type="text"
                                        //             placeholder=""
                                        //             disabled={true}
                                        //             // value={Number(val).toFixed(1)}
                                        //             value={val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)}
                                        //         />
                                        //     </span>
                                        //     :
                                        //     tableMeta.rowData[0] === 3 ?
                                        //         <div style={{ flex: 1 }}>
                                        //             <FormControlLabel
                                        //                 style={{ margin: 0 }}
                                        //                 value={val}
                                        //                 control={
                                        //                     <NumberFormat
                                        //                         thousandSeparator={true}
                                        //                         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                         type="text"
                                        //                         placeholder=""
                                        //                         // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                        //                         disabled={true}
                                        //                         value={val === "0" ? "" : Number(val).toFixed(1)}
                                        //                         onBlur={(event) => {
                                        //                             handleChange(event.target.value, tableMeta)
                                        //                         }}
                                        //                     />
                                        //                 }
                                        //             />
                                        //         </div>
                                        //         :
                                        //         tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                        //             <div style={{ flex: 1 }}>
                                        //                 <FormControlLabel
                                        //                     style={{ margin: 0 }}
                                        //                     value={val}
                                        //                     control={
                                        //                         <NumberFormat
                                        //                             thousandSeparator={true}
                                        //                             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                             type="text"
                                        //                             placeholder=""
                                        //                             disabled={true}
                                        //                             value={val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                        //                         />
                                        //                     }
                                        //                 />
                                        //             </div>
                                        //             :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={val === "0" ? "" : Number(val).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q2' || this.props.quarter == 'q3' ? `Apr ${this.props.periode} Actual` : `Apr ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' || this.props.quarter == 'q2' || this.props.quarter == 'q3' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)) : Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' ? false : true}
                                                                value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)) : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q2' || this.props.quarter == 'q3' ? `May ${this.props.periode} Actual` : `May ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' || this.props.quarter == 'q2' || this.props.quarter == 'q3' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)) : Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' ? false : true}
                                                                value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)) : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q2' || this.props.quarter == 'q3' ? `Jun ${this.props.periode} Actual` : `Jun ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' || this.props.quarter == 'q2' || this.props.quarter == 'q3' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)) : Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' ? false : true}
                                                                value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)) : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q3' ? `Jul ${this.props.periode} Actual` : `Jul ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' || this.props.quarter == 'q3' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)) : Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' || this.props.quarter == 'q2' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' || this.props.quarter == 'q2' ? false : true}
                                                                value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)) : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: this.props.quarter == 'q3' ? `Aug ${this.props.periode} Actual` : `Aug ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' || this.props.quarter == 'q3' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)) : Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' || this.props.quarter == 'q2' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' || this.props.quarter == 'q2' ? false : true}
                                                                value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)) : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: this.props.quarter == 'q3' ? `Sep ${this.props.periode} Actual` : `Sep ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' || this.props.quarter == 'q3' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleValue(val, tableMeta)).toFixed(1)) : Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' || this.props.quarter == 'q2' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' || this.props.quarter == 'q2' ? false : true}
                                                                value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(handleFormula(val, tableMeta, 1)).toFixed(1)) : Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.quarter == 'q3' ? (val === "0" ? "" : Number(val).toFixed(1)) : Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            },

            {
                name: `Oct ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={false}
                                                                value={Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            },

            {
                name: `Nov ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={false}
                                                                value={Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Dec ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={Number(val).toFixed(1)}
                                                    value={Number(handleValue(val, tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={false}
                                                                value={Number(val).toFixed(1)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(handleFormula(val, tableMeta, 1)).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(val).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `${this.props.periode} Total Outlook`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(handleTotal(val, tableMeta)).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                {this.state.loading && loadingComponent}
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Rolling Outlook & Revision CAT</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visiblePLRO ?
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Rolling Outlook - Profit Loss</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} {String(this.props.quarter).toLocaleUpperCase()} (rev.{this.props.revision})</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.props.isApprover === true || this.state.get_for == 'view' ?
                                            null
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            // </div> 
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ loading: true }, () => {
                                                            this.downloadTemplate()
                                                        })}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                this.downloadAllData()
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {!this.state.refresh && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>

                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5 }}>Notes : {this.state.notesUpdate}</Typography>
                            </div>
                            {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                            (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}
                            <div className="grid grid-2x" style={{ padding: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly &&
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => {
                                                    this.setState({ loading: true, refresh: true }, () => {
                                                        this.handleGetFor('edit')
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                                </div>
                                            </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToRollingOutlook('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToRollingOutlook('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete3</Typography>
                                                {/*save & complete ini muncul setelah pencet tombol edit, kemudian setelah upload suatu file*/}
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                            {/* : null
                            } */}
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Rolling Outlook - Profit Loss</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} {String(this.props.quarter).toLocaleUpperCase()} (rev.{this.props.revision}) </Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                </div>
                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.dataLoaded && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>
                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1" style={{ paddingLeft: 0 }}>
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visiblePLRO: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        // this.setState({ loading: false })
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadProfitLossRO('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadProfitLossRO('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                                {/*save & complete ini muncul setelah pencet tombol edit, kemudian setelah upload suatu file*/}
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>}
                </div>

                {this.state.visibleUpload && (
                    // alert("Coming Soon...")
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("ROLLING") && String(this.state.judul).includes("OUTLOOK") && String(this.state.judul).includes("PROFIT") && String(this.state.judul).includes("LOSS") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data is <b>{this.props.defaultCurrency.id == 1 ? "IDR" : "USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        )
    }
}