import React, { Component } from 'react'
// import { Paper, Typography } from '@material-ui/core'
import Images from '../../assets/Images'
import { GridList, Paper, Typography, GridListTile, FormControl, FormControlLabel, Radio } from '@material-ui/core'

export default class StrategiMap extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataStrategy: this.props.data.strategy_map.category,
            radioValue: true
        }
    }

    componentDidMount() {
        console.log(this.props.data.strategy_map);

    }

    render() {
        return (
            <div style={{ padding: 20 }}>
                <div style={{ display: 'flex' }}>
                    <FormControl component="fieldset">
                        <FormControlLabel value="end" control={<Radio color="primary" checked={this.state.radioValue} onClick={() => this.setState({ radioValue: true })} />} label="Actual vs Prev. Month" />
                    </FormControl>
                    <FormControl component="fieldset">
                        <FormControlLabel value="end" control={<Radio color="primary" checked={!this.state.radioValue} onClick={() => this.setState({ radioValue: false })} />} label="YOY" />
                    </FormControl>
                </div>
                <Paper style={{ borderRadius: 10, boxShadow: '0 0 4px 0 rgba(0, 0, 0, 0.5)', width: '100%' }}>
                    <div style={{ height: 56, borderTopLeftRadius: 10, borderTopRightRadius: 10, backgroundColor: '#f1f1f1', display: 'flex' }}>
                        <div style={{ width: '25%', borderRight: 'solid 1px #d8d8d8', display: 'grid', alignContent: 'center', paddingLeft: 20 }}>
                            <Typography style={{ color: '#656565', fontWeight: 'bold', fontSize: 12 }}>Category</Typography>
                        </div>
                        <div style={{ width: '75%', borderRight: 'solid 1px #d8d8d8', display: 'grid', alignContent: 'center', paddingLeft: 20 }}>
                            <Typography style={{ color: '#656565', fontWeight: 'bold', fontSize: 12 }}>KPI</Typography>
                        </div>
                    </div>

                    {this.state.dataStrategy.map((item, index) => {
                        return (
                            <div style={{ display: 'flex' }}>
                                <div style={{ width: '25%', borderRight: 'solid 1px #d8d8d8', display: 'grid', paddingLeft: 20, paddingTop: 20 }}>
                                    <div style={{ borderBottom: 'solid 1px #d8d8d8' }}>
                                        <Typography style={{ color: '#656565', fontWeight: 'bold', fontSize: 14, fontFamily: 'Nunito Sans, sans-serif' }}>{item.category_name}</Typography>
                                    </div>
                                </div>
                                <div style={{ width: '75%', borderRight: 'solid 1px #d8d8d8', paddingRight: 20 }}>
                                    <div style={{ display: 'flex', alignContent: 'center', padding: 20, borderBottom: 'solid 1px #d8d8d8' }}>
                                        <GridList cellHeight={100} cols={3}>
                                            {item.nodes.length < 1 ?
                                                <div style={{ height: 75 }} />
                                                :
                                                item.nodes.map((items, indexs) => {
                                                    return (
                                                        <GridListTile key={items} cols={item.nodes.length == 1 ? 3 : item.nodes.length == 2 ? 2 : 1} style={{}}>
                                                            <div style={{ display: 'flex', minWidth: 220, borderRadius: 6, marginLeft: 10 }}>
                                                                <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 155, borderTopLeftRadius: 6, borderBottomLeftRadius: 6, padding: 10 }}>
                                                                    <Typography style={{ color: '#fff', fontSize: 12, textAlign: 'center' }}>{items.item_name}</Typography>
                                                                </div>
                                                                <div style={{ backgroundColor: this.state.radioValue ? (items.is_higher_actual == '-' ? '#d8d8d8' : (items.is_higher_actual == 'true' ? '#cbf4a8' : '#faaaaa')) : (items.is_higher_yoy == '-' ? '#d8d8d8' : (items.is_higher_yoy == 'true' ? '#cbf4a8' : '#faaaaa')), width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                                                    {items.is_higher_actual == '-' ?
                                                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'-'}</Typography>
                                                                        :
                                                                        <img src={this.state.radioValue ? (items.is_higher_actual == 'true' ? Images.up : Images.down) : (items.is_higher_yoy == 'true' ? Images.up : Images.down)} />
                                                                    }
                                                                    <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                                                    <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{this.state.radioValue ? 'Last Month' : 'YOY'}</Typography>
                                                                </div>
                                                            </div>
                                                        </GridListTile>
                                                    )
                                                })}
                                        </GridList>
                                    </div>
                                </div>
                            </div>
                        )
                    })}

                    {/* <div style={{ display: 'flex' }}>
                        <div style={{ width: '25%', borderRight: 'solid 1px #d8d8d8', display: 'grid', paddingLeft: 20, paddingTop: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #d8d8d8' }}>
                                <Typography style={{ color: '#656565', fontWeight: 'bold', fontSize: 14, fontFamily: 'Nunito Sans, sans-serif' }}>Customer Perspective</Typography>
                            </div>
                        </div>
                        <div style={{ width: '75%', borderRight: 'solid 1px #d8d8d8', paddingRight: 20 }}>
                            <div style={{ display: 'flex', alignContent: 'center', padding: 20, borderBottom: 'solid 1px #d8d8d8' }}>
                                <div style={{ display: 'flex', width: 220, borderRadius: 6 }}>
                                    <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 152, borderTopLeftRadius: 6, borderBottomLeftRadius: 6 }}>
                                        <Typography style={{ color: '#fff', fontSize: 12, justifySelf: 'center' }}>Part Service Rate</Typography>
                                    </div>
                                    <div style={{ backgroundColor: '#cbf4a8', width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                        <img src={Images.up} />
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'Last Month'}</Typography>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', width: 220, borderRadius: 6, marginLeft: 20 }}>
                                    <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 152, borderTopLeftRadius: 6, borderBottomLeftRadius: 6 }}>
                                        <Typography style={{ color: '#fff', fontSize: 12, textAlign: 'center' }}>CSI (Customer Satisfactiomn Index)</Typography>
                                    </div>
                                    <div style={{ backgroundColor: '#fffba5', width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                        <img src={Images.down} />
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'Last Month'}</Typography>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', width: 220, borderRadius: 6, marginLeft: 20 }}>
                                    <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 152, borderTopLeftRadius: 6, borderBottomLeftRadius: 6 }}>
                                        <Typography style={{ color: '#fff', fontSize: 12, justifySelf: 'center' }}>Dealer Productivity</Typography>
                                    </div>
                                    <div style={{ backgroundColor: '#faaaaa', width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                        <img src={Images.down} />
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'Last Month'}</Typography>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div style={{ display: 'flex' }}>
                        <div style={{ width: '25%', borderRight: 'solid 1px #d8d8d8', display: 'grid', paddingLeft: 20, paddingTop: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #d8d8d8' }}>
                                <Typography style={{ color: '#656565', fontWeight: 'bold', fontSize: 14, fontFamily: 'Nunito Sans, sans-serif' }}>INTERNAL BUSINESS PROCESS PERSPECTIVE</Typography>
                            </div>
                        </div>
                        <div style={{ width: '75%', borderRight: 'solid 1px #d8d8d8', paddingRight: 20 }}>
                            <div style={{ display: 'flex', alignContent: 'center', padding: 20, borderBottom: 'solid 1px #d8d8d8' }}>
                                <div style={{ display: 'flex', width: 220, borderRadius: 6 }}>
                                    <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 152, borderTopLeftRadius: 6, borderBottomLeftRadius: 6 }}>
                                        <Typography style={{ color: '#fff', fontSize: 12, textAlign: 'center' }}>NSI (Network Satisfaction Index)</Typography>
                                    </div>
                                    <div style={{ backgroundColor: '#cbf4a8', width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                        <img src={Images.up} />
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'Last Month'}</Typography>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', width: 220, borderRadius: 6, marginLeft: 20 }}>
                                    <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 152, borderTopLeftRadius: 6, borderBottomLeftRadius: 6 }}>
                                        <Typography style={{ color: '#fff', fontSize: 12, textAlign: 'center' }}>DEP (Dealer Evaluation Program)</Typography>
                                    </div>
                                    <div style={{ backgroundColor: '#cbf4a8', width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                        <img src={Images.up} />
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'Last Month'}</Typography>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', width: 220, borderRadius: 6, marginLeft: 20 }}>
                                    <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 152, borderTopLeftRadius: 6, borderBottomLeftRadius: 6 }}>
                                        <Typography style={{ color: '#fff', fontSize: 12, textAlign: 'center' }}>AEP  (AHASS Evaluation Program)</Typography>
                                    </div>
                                    <div style={{ backgroundColor: '#cbf4a8', width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                        <img src={Images.up} />
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'Last Month'}</Typography>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', width: 220, borderRadius: 6, marginLeft: 20 }}>
                                    <div style={{ display: 'grid', alignContent: 'center', backgroundColor: '#6885a6', width: 152, borderTopLeftRadius: 6, borderBottomLeftRadius: 6 }}>
                                        <Typography style={{ color: '#fff', fontSize: 12, justifySelf: 'center' }}>TPAT</Typography>
                                    </div>
                                    <div style={{ backgroundColor: '#faaaaa', width: 68, borderTopRightRadius: 6, borderBottomRightRadius: 6, textAlign: 'center', paddingTop: 10, paddingBottom: 10 }}>
                                        <img src={Images.down} />
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'vs'}</Typography>
                                        <Typography style={{ color: '#4b4b4b', fontSize: 10, textAlign: 'center' }}>{'Last Month'}</Typography>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> */}

                </Paper>
            </div>
        )
    }
}
