import React, { Component } from "react";
import { createMuiTheme, FormControlLabel, Input, MuiThemeProvider, Snackbar, TableCell, Typography, withStyles } from "@material-ui/core";
import MUIDataTable from "mui-datatables";
import api from '../../api';
import Constant from '../../library/Constant';
import { PropagateLoader } from "react-spinners";
import Images from "../../assets/Images";
import MuiAlert from '@material-ui/lab/Alert';

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    // background: "white",
    zIndex: 100
};

export default class TableProgressReport extends Component {
    constructor(props) {
        super(props)
        this.state = {
            visiblePopup: false,
            idCompany: null,
            companyName: "",
            month: "",
            alert: false,
            tipeAlert: '',
            messageAlert: '',
        }
    }

    handleShowPopup(id, data) {
        console.log(this.props);
        let item = this.props
        let bulan = item.month == 1 ? "Jan" : item.month == 2 ? "Feb" : item.month == 3 ? "Mar" : item.month == 4 ? "Apr" : item.month == 5 ? "May" : item.month == 6 ? "Jun" : item.month == 7 ? "Jul" : item.month == 8 ? "Aug" : item.month == 9 ? "Sep" : item.month == 10 ? "Oct" : item.month == 11 ? "Nov" : item.month == 12 ? "Dec" : null
        this.setState({ visiblePopup: true, idCompany: id, companyName: data[0], month: bulan })
    }

    handleSendEmail() {
        this.setState({ loading: true, visiblePopup: false, })
        let data = this.props
        let q1 = data.reportType === 2 && data.quarter === "Q1"
        let q2 = data.reportType === 2 && data.quarter === "Q2"
        let q3 = data.reportType === 2 && data.quarter === "Q3"
        let payload = {
            "company_id": this.state.idCompany,
            "setting_type_name": data.reportType === 0 ? "master_budget" : data.reportType === 1 ? "monthly_report" : q1 ? "outlook_q1" : q2 ? "outlook_q2" : q3 ? "outlook_q3" : data.reportType === 3 ? "outlook_pa" : null,
            "year": data.year,
            "month": data.reportType === 1 ? data.month : null
        }
        let payloadGetData = {
            "year": data.year,
            "month": data.month,
            "quarter": data.quarter === "Q1" ? "q1" : data.quarter === "Q2" ? "q2" : data.quarter === "Q3" ? "q3" : null

        }
        api.create().sendEmail(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    this.setState({ loading: false })
                    if (response.data.status == 'success') {
                        if (data.reportType === 0) {
                            this.props.getMonitoringMB(payloadGetData)
                        } else if (data.reportType === 1) {
                            this.props.getMonitoringMR(payloadGetData)
                        } else if (data.reportType === 2) {
                            this.props.getMonitoringRO(payloadGetData)
                        } else if (data.reportType === 3) {
                            this.props.getMonitoringOLPA(payloadGetData)
                        }
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success', loading: false })
                        // this.setState({ visiblePopup: false, alert: true, messageAlert: response.data.message, tipeAlert: 'success' }, () => {
                        //     setTimeout(() => {
                        //         if (data.reportType === 0 ) {
                        //             this.props.getMonitoringMB(payloadGetData)
                        //         } else if (data.reportType === 1 ) {
                        //             this.props.getMonitoringMR(payloadGetData)
                        //         } else if (data.reportType === 2 ) {
                        //             this.props.getMonitoringRO(payloadGetData)
                        //         } else if (data.reportType === 3 ) {
                        //             this.props.getMonitoringOLPA(payloadGetData)
                        //         }
                        //         this.setState({ loading: false })
                        //     }, 1000)
                        // })
                        // this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {

        let dataTable2 = this.props.dataTable;
        // console.log(dataTable2);
        const handleValue = (tableMeta, itemName) => {
            let value = tableMeta.rowData[1].filter((val) => val.report_name == itemName)
            // console.log(itemName)
            // console.log(tableMeta.rowData)
            // console.log(value)
            return value[0].status_report == null || value[0].status_report == '' ? 'N/A' : value[0].status_report
        }
        const columnMB = [
            {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 200, borderRight: "1px solid rgb(255, 255, 255)" }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 200 }}>
                                {val}
                            </div>
                        )
                    }
                }
            },
            {
                name: `INPUT MASTER BUDGET`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, borderRight: "1px solid rgb(255, 255, 255)" }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-4x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Profit Loss"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Tax Planning"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Balance Sheet"}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Fixed Assets Movement"}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-4x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Cash Flow"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"CAT"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#cc2929', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Submission Status"}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Operating Indicator"}</span>
                                    </div>
                                </div>
                                <div className="column-3 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: 'sticky' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Automatic Reminder"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'right', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Manual Reminder"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Last Manual Reminder"}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div className="grid grid-3x">
                                <div className="column-1 grid grid-4x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Profit Loss')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Tax Planning')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Balance Sheet')}</div>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Fixed Assets Movement')}</div>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-4x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Cash Flow')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'CAT')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Submission Status')}</div>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Operating Indicator')}</div>
                                    </div>
                                </div>
                                <div className="column-3 grid grid-3x" style={{ ...style2, fontSize: 12, left: 27, position: 'relative' }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[2]}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        {tableMeta.rowData[5] === "OPEN" ?
                                            <div style={{ textAlign: 'center' }}>
                                                <button
                                                    type="button"
                                                    style={{ background: 'white' }}
                                                    onClick={() => this.handleShowPopup(tableMeta.rowData[7], tableMeta.rowData)}
                                                >
                                                    <div style={{ width: 85, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                        <span style={{ color: '#fff', fontSize: 11 }}>{tableMeta.rowData[3] === null || tableMeta.rowData[3] === 0 ? "Send Email" : "Sent"}</span>
                                                    </div>
                                                </button>
                                            </div>
                                            :
                                            "-"
                                        }

                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[4]}</div>
                                    </div>
                                </div>
                            </div>
                        )
                    },
                },
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ];

        const columnMR = [
            {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 200, borderRight: "1px solid rgb(255, 255, 255)" }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {val}
                            </div>
                        )
                    }
                }
            },
            {
                name: `INPUT MONTHLY REPORT`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, borderRight: "1px solid rgb(255, 255, 255)" }}>{columnMeta.name}</div>
                            <div className="grid grid-4x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Profit Loss"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Tax Planning"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Balance Sheet"}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Fixed Assets Movement"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"LOCF"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Cash Flow"}</span>
                                    </div>
                                </div>
                                <div className="column-3 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"CAT"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#cc2929', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Monthly Status"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Operating Indicator"}</span>
                                    </div>
                                </div>
                                <div className="column-4 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Automatic Reminder"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Manual Reminder"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Last Manual Reminder"}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div className="grid grid-4x">
                                <div className="column-1 grid grid-3x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Profit Loss')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Profit Loss')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Balance Sheet')}</div>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Fixed Assets Movement')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'List of Credit Facilities')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Cash Flow')}</div>
                                    </div>
                                </div>
                                <div className="column-3 grid grid-3x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'CAT')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Monthly Status')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Operating Indicator')}</div>
                                    </div>
                                </div>
                                <div className="column-4 grid grid-3x" style={{ ...style2, fontSize: 12, position: "relative", left: 15 }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center' }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[2]}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        {tableMeta.rowData[5] === "OPEN" ?
                                            <div style={{ textAlign: 'center' }}>
                                                <button
                                                    type="button"
                                                    style={{ background: 'white' }}
                                                    onClick={() => this.handleShowPopup(tableMeta.rowData[7], tableMeta.rowData)}
                                                >
                                                    <div style={{ position: 'relative', width: 85, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                        <span style={{ color: '#fff', fontSize: 11 }}>{tableMeta.rowData[3] === null || tableMeta.rowData[3] === 0 ? "Send Email" : "Sent"}</span>
                                                    </div>
                                                </button>
                                            </div>
                                            :
                                            "-"
                                        }

                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[4]}</div>
                                    </div>
                                </div>
                            </div>
                        )
                    },
                },
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ];

        const columnRO = [
            {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 200, borderRight: "1px solid rgb(255, 255, 255)" }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {val}
                            </div>
                        )
                    }
                },
            },
            {
                name: `INPUT ROLLING OUTLOOK`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, borderRight: "1px solid rgb(255, 255, 255)" }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-4x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Profit Loss"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Tax Planning"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Balance Sheet"}</span>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Cash Flow"}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"CAT"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#cc2929', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Rolling Status"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Operating Indicator"}</span>
                                    </div>
                                </div>
                                <div className="column-3 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Automatic Reminder"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Manual Reminder"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Last Manual Reminder"}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div className="grid grid-3x">
                                <div className="column-1 grid grid-4x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Profit Loss')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Profit Loss')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Balance Sheet')}</div>
                                    </div>
                                    <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Cash Flow')}</div>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'CAT')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Rolling Status')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Operating Indicator')}</div>
                                    </div>
                                </div>
                                <div className="column-3 grid grid-3x" style={{ ...style2, fontSize: 12, position: "relative", left: 19 }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[2]}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        {tableMeta.rowData[5] === "OPEN" ?
                                            <div style={{ textAlign: 'center' }}>
                                                <button
                                                    type="button"
                                                    style={{ background: 'white' }}
                                                    onClick={() => this.handleShowPopup(tableMeta.rowData[7], tableMeta.rowData)}
                                                >
                                                    <div style={{ width: 85, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                        <span style={{ color: '#fff', fontSize: 11 }}>{tableMeta.rowData[3] === null || tableMeta.rowData[3] === 0 ? "Send Email" : "Sent"}</span>
                                                    </div>
                                                </button>
                                            </div>
                                            :
                                            "-"
                                        }

                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[4]}</div>
                                    </div>
                                </div>
                            </div>
                        )
                    },
                },
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ];

        const columnOLPA = [
            {
                name: "Company",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 200, borderRight: "1px solid rgb(255, 255, 255)" }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {val}
                            </div>
                        )
                    }
                },
            },
            {
                name: `INPUT OUTLOOK PA`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, borderRight: "1px solid rgb(255, 255, 255)" }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Profit Loss"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Tax Planning"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Balance Sheet"}</span>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Cash Flow"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"CAT"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#cc2929', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"OLPA Status"}</span>
                                    </div>
                                    {/* <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Operating Indicator"}</span>
                                    </div> */}
                                </div>
                                <div className="column-3 grid grid-3x" style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Automatic Reminder"}</span>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Manual Reminder"}</span>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45, width: 150 }}>
                                        <span>{"Last Manual Reminder"}</span>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div className="grid grid-3x">
                                <div className="column-1 grid grid-3x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Profit Loss')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Tax Planning')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Balance Sheet')}</div>
                                    </div>
                                </div>
                                <div className="column-2 grid grid-3x" style={{ ...style2, fontSize: 12, position: "sticky" }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Cash Flow')}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'CAT')}</div>
                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'OLPA Status')}</div>
                                    </div>
                                    {/* <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{handleValue(tableMeta, 'Operating Indicator')}</div>
                                    </div> */}
                                </div>
                                <div className="column-3 grid grid-3x" style={{ ...style2, fontSize: 12, position: "relative", left: 20 }}>
                                    <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[2]}</div>
                                    </div>
                                    <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        {tableMeta.rowData[5] === "OPEN" ?
                                            <div style={{ textAlign: 'center' }}>
                                                <button
                                                    type="button"
                                                    style={{ background: 'white' }}
                                                    onClick={() => this.handleShowPopup(tableMeta.rowData[7], tableMeta.rowData)}
                                                >
                                                    <div style={{ width: 85, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                                        <span style={{ color: '#fff', fontSize: 11 }}>{tableMeta.rowData[3] === null || tableMeta.rowData[3] === 0 ? "Send Email" : "Sent"}</span>
                                                    </div>
                                                </button>
                                            </div>
                                            :
                                            "-"
                                        }

                                    </div>
                                    <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, width: 143 }}>
                                        <div style={{ textAlign: 'center' }}>{tableMeta.rowData[4]}</div>
                                    </div>
                                </div>
                            </div>
                        )
                    },
                },
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ];

        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ padding: "0px 20px 20px 20px", width: this.props.width - (this.props.open === true ? 350 : 100) }}>
                    {this.state.loading && loadingComponent}
                    <MuiThemeProvider theme={getMuiTheme()}>
                        <MUIDataTable
                            data={dataTable2}
                            columns={this.props.typeReport.includes("MASTER") ? columnMB : this.props.typeReport.includes("MONTHLY") ? columnMR : this.props.typeReport.includes("ROLLING") ? columnRO : columnOLPA}
                            options={options}

                        />
                    </MuiThemeProvider>
                </div>
                {this.state.visiblePopup && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div style={{ display: 'flex', justifyContent: 'center', paddingTop: 20 }}>
                                <img src={Images.failed} />
                            </div>
                            {this.props.reportType === 1 ?
                                <div style={{ marginTop: 20, paddingBottom: 20 }}>
                                    <Typography style={{ fontSize: 18, justifyContent: 'center', margin: 20, textAlign: 'center' }}>Apakah anda yakin ingin mengirimkan email Reminder Submission <b>{this.props.typeReport} {this.state.month} {this.props.year}</b> ke perusahaan <b>{this.state.companyName}</b>?</Typography>
                                </div>
                                :
                                this.props.reportType === 2 ?
                                    <div style={{ marginTop: 20, paddingBottom: 20 }}>
                                        <Typography style={{ fontSize: 18, justifyContent: 'center', margin: 20, textAlign: 'center' }}>Apakah anda yakin ingin mengirimkan email Reminder Submission <b>{this.props.typeReport} {this.props.quarter} {this.props.year}</b> ke perusahaan <b>{this.state.companyName}</b>?</Typography>
                                    </div>
                                    :
                                    <div style={{ marginTop: 20, paddingBottom: 20 }}>
                                        <Typography style={{ fontSize: 18, justifyContent: 'center', margin: 20, textAlign: 'center' }}>Apakah anda yakin ingin mengirimkan email Reminder Submission <b>{this.props.typeReport} {this.props.year}</b> ke perusahaan <b>{this.state.companyName}</b>?</Typography>
                                    </div>
                            }
                            <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1" style={{ alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ visiblePopup: false })}
                                    >
                                        <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                        </div>
                                    </button>
                                </div>
                                <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                                    <button
                                        type="button"
                                        onClick={() => this.handleSendEmail()}
                                    >
                                        <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                            <span style={{ color: '#fff', fontSize: 11 }}>Send</span>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        );
    }
}
