import React, { Component } from 'react'
import { Typography, Paper, createMuiTheme, ThemeProvider, MuiThemeProvider, TableCell, FormControlLabel, Input, withStyles, makeStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables'
import api from '../../api';
import NumberFormat from 'react-number-format';
import * as R from 'ramda';
import { PropagateLoader } from 'react-spinners';
import { ExcelRenderer } from 'react-excel-renderer';
import Constant from '../../library/Constant';
import UploadFile from "../../library/Upload";
import { Alert, Autocomplete } from '@material-ui/lab';
import { titleCase, roundMath } from '../../library/Utils';
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import Tooltip from '@material-ui/core/Tooltip';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);
var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};

const theme = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea'
            }
        }
    },
});

export default class CorporateAnnualTargetRO extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            uomList: [],
            formulaYtdList: {
                options: [{ value: 'SUM' }, { value: 'AVG' }, { value: 'LAST' }, { value: 'FORMULA' }],
                getOptionLabel: (option) => titleCase(option.value),
            },
            kpiTypeList: [],
            maxAchList: [],
            visibleCATRO: true,
            buttonError: true,
            dataDelete: [],
            dataReal: [],
            buttonDraft: true,
            updateBy: [],
            handleDoubleClick: 0,
            editable: false,
            get_for: 'view',
            viewOnly: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false

        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getKPIType()
        this.getMaxAch()
        this.getLatestUpdate()
        this.handleViewOnly()
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false
        console.log('skuy');
        // console.log(this.props.isApprover)
        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({viewOnly: true})
    }

    getItemHierarki() {
        let payload = {
            "company_id": this.props.company.company_id,
            "get_for": this.state.get_for,
            "quartal": 'q1',
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "currency_id": this.props.defaultCurrency.id,
            // "rolling_outlook_id": this.props.rollingOutlookID,
            "outlook_pa_id": this.props.outlook_pa_id,
        }
        console.log(payload);
        api.create().getDetailReportOLPACAT(payload).then(response => {
            let dataTable = []
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                let parentTrue = item.parent_name == 'INTERNAL BUSINESS PROCESS PERSPECTIVE' || item.parent_name == 'CUSTOMER PERSPECTIVE'
                                let weight = String(item.cat.weight).substr(0, String(item.cat.weight).length - 1)
                                dataTable.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.cat.weight == "" ? Number(0).toFixed(1) : Number(weight).toFixed(1),
                                    item.uom,
                                    item.kpi_type == "" ? null : { value: item.kpi_type },
                                    item.max_ach == "" ? null : { value: titleCase(item.max_ach) },
                                    item.formula_ytd == "" ? null : { value: item.formula_ytd },
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.january == "" ? item.cat.january : String(item.cat.january).indexOf(".") == -1 ? Number(item.cat.january) : Number(item.cat.january).toFixed(1)) : { value: item.cat.january, formula: item.cat.january_formula } : (item.cat.january == "" ? item.cat.january : String(item.cat.january).indexOf(".") == -1 ? Number(item.cat.january) : Number(item.cat.january).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.february == "" ? item.cat.february : String(item.cat.february).indexOf(".") == -1 ? Number(item.cat.february) : Number(item.cat.february).toFixed(1)) : { value: item.cat.february, formula: item.cat.february_formula } : (item.cat.february == "" ? item.cat.february : String(item.cat.february).indexOf(".") == -1 ? Number(item.cat.february) : Number(item.cat.february).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.march == "" ? item.cat.march : String(item.cat.march).indexOf(".") == -1 ? Number(item.cat.march) : Number(item.cat.march).toFixed(1)) : { value: item.cat.march, formula: item.cat.march_formula } : (item.cat.march == "" ? item.cat.march : String(item.cat.march).indexOf(".") == -1 ? Number(item.cat.march) : Number(item.cat.march).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.april == "" ? item.cat.april : String(item.cat.april).indexOf(".") == -1 ? Number(item.cat.april) : Number(item.cat.april).toFixed(1)) : { value: item.cat.april, formula: item.cat.april_formula } : (item.cat.april == "" ? item.cat.april : String(item.cat.april).indexOf(".") == -1 ? Number(item.cat.april) : Number(item.cat.april).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.may == "" ? item.cat.may : String(item.cat.may).indexOf(".") == -1 ? Number(item.cat.may) : Number(item.cat.may).toFixed(1)) : { value: item.cat.may, formula: item.cat.may_formula } : (item.cat.may == "" ? item.cat.may : String(item.cat.may).indexOf(".") == -1 ? Number(item.cat.may) : Number(item.cat.may).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.june == "" ? item.cat.june : String(item.cat.june).indexOf(".") == -1 ? Number(item.cat.june) : Number(item.cat.june).toFixed(1)) : { value: item.cat.june, formula: item.cat.june_formula } : (item.cat.june == "" ? item.cat.june : String(item.cat.june).indexOf(".") == -1 ? Number(item.cat.june) : Number(item.cat.june).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.july == "" ? item.cat.july : String(item.cat.july).indexOf(".") == -1 ? Number(item.cat.july) : Number(item.cat.july).toFixed(1)) : { value: item.cat.july, formula: item.cat.july_formula } : (item.cat.july == "" ? item.cat.july : String(item.cat.july).indexOf(".") == -1 ? Number(item.cat.july) : Number(item.cat.july).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.august == "" ? item.cat.august : String(item.cat.august).indexOf(".") == -1 ? Number(item.cat.august) : Number(item.cat.august).toFixed(1)) : { value: item.cat.august, formula: item.cat.august_formula } : (item.cat.august == "" ? item.cat.august : String(item.cat.august).indexOf(".") == -1 ? Number(item.cat.august) : Number(item.cat.august).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.september == "" ? item.cat.september : String(item.cat.september).indexOf(".") == -1 ? Number(item.cat.september) : Number(item.cat.september).toFixed(1)) : { value: item.cat.september, formula: item.cat.september_formula } : (item.cat.september == "" ? item.cat.september : String(item.cat.september).indexOf(".") == -1 ? Number(item.cat.september) : Number(item.cat.september).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.october == "" ? item.cat.october : String(item.cat.october).indexOf(".") == -1 ? Number(item.cat.october) : Number(item.cat.october).toFixed(1)) : { value: item.cat.october, formula: item.cat.october_formula } : (item.cat.october == "" ? item.cat.october : String(item.cat.october).indexOf(".") == -1 ? Number(item.cat.october) : Number(item.cat.october).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.november == "" ? item.cat.november : String(item.cat.november).indexOf(".") == -1 ? Number(item.cat.november) : Number(item.cat.november).toFixed(1)) : { value: item.cat.november, formula: item.cat.november_formula } : (item.cat.november == "" ? item.cat.november : String(item.cat.november).indexOf(".") == -1 ? Number(item.cat.november) : Number(item.cat.november).toFixed(1)),
                                    item.parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? (item.cat.december == "" ? item.cat.december : String(item.cat.december).indexOf(".") == -1 ? Number(item.cat.december) : Number(item.cat.december).toFixed(1)) : { value: item.cat.december, formula: item.cat.december_formula } : (item.cat.december == "" ? item.cat.december : String(item.cat.december).indexOf(".") == -1 ? Number(item.cat.december) : Number(item.cat.december).toFixed(1)),
                                    item.cat.total_current_year == "" ? "0" : String(item.cat.total_current_year).indexOf(".") == -1 ? Number(item.cat.total_current_year) : Number(item.cat.total_current_year).toFixed(1),
                                    item.cat.strategic,
                                    item.cat.pic,
                                    item.order
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.weight == '' ? Number(0).toFixed(1) : Number(Number(item.weight) * 100).toFixed(1),
                                item.uom,
                                item.kpi_type == "" ? null : { value: item.kpi_type },
                                item.max_ach == "" ? null : { value: titleCase(item.max_ach) },
                                item.formula == "" ? null : { value: item.formula_ytd },
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.january, formula: item.cat.january_formula } : (item.cat.january == "" ? item.cat.january : String(item.cat.january).indexOf(".") == -1 ? Number(item.cat.january) : Number(item.cat.january).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.february, formula: item.cat.february_formula } : (item.cat.february == "" ? item.cat.february : String(item.cat.february).indexOf(".") == -1 ? Number(item.cat.february) : Number(item.cat.february).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.march, formula: item.cat.march_formula } : (item.cat.march == "" ? item.cat.march : String(item.cat.march).indexOf(".") == -1 ? Number(item.cat.march) : Number(item.cat.march).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.april, formula: item.cat.april_formula } : (item.cat.april == "" ? item.cat.april : String(item.cat.april).indexOf(".") == -1 ? Number(item.cat.april) : Number(item.cat.april).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.may, formula: item.cat.may_formula } : (item.cat.may == "" ? item.cat.may : String(item.cat.may).indexOf(".") == -1 ? Number(item.cat.may) : Number(item.cat.may).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.june, formula: item.cat.june_formula } : (item.cat.june == "" ? item.cat.june : String(item.cat.june).indexOf(".") == -1 ? Number(item.cat.june) : Number(item.cat.june).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.july, formula: item.cat.july_formula } : (item.cat.july == "" ? item.cat.july : String(item.cat.july).indexOf(".") == -1 ? Number(item.cat.july) : Number(item.cat.july).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.august, formula: item.cat.august_formula } : (item.cat.august == "" ? item.cat.august : String(item.cat.august).indexOf(".") == -1 ? Number(item.cat.august) : Number(item.cat.august).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.september, formula: item.cat.september_formula } : (item.cat.september == "" ? item.cat.september : String(item.cat.september).indexOf(".") == -1 ? Number(item.cat.september) : Number(item.cat.september).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.october, formula: item.cat.october_formula } : (item.cat.october == "" ? item.cat.october : String(item.cat.october).indexOf(".") == -1 ? Number(item.cat.october) : Number(item.cat.october).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.november, formula: item.cat.november_formula } : (item.cat.november == "" ? item.cat.november : String(item.cat.november).indexOf(".") == -1 ? Number(item.cat.november) : Number(item.cat.november).toFixed(1)),
                                item.parent_name == "FINANCIAL PERSPECTIVE" ? { value: item.cat.december, formula: item.cat.december_formula } : (item.cat.december == "" ? item.cat.december : String(item.cat.december).indexOf(".") == -1 ? Number(item.cat.december) : Number(item.cat.december).toFixed(1)),
                                item.cat.total_current_year == "" ? 0 : String(item.cat.total_current_year).indexOf(".") == -1 ? Number(item.cat.total_current_year) : Number(item.cat.total_current_year).toFixed(1),
                                item.cat.strategic,
                                item.cat.pic,
                                item.order
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dataTable)
                        this.setState({ dataTable, loading: false, dataReal: res, editable: true }, () => {
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    };
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Connection Timeout, please check your Connection', tipeAlert: 'error', loading: false })
            }


        })
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getLatestUpdate()
            this.getItemHierarki()
        })
    }

    getKPIType() {
        let body = {
            group: 'CAT',
            company_id: this.props.company.company_id,
            type: 'KPI_TYPE'
        }
        api.create().getAllSettingByType(body).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        // console.log(data)
                        let inputKPI = []

                        data.map((item) => {
                            inputKPI.push({
                                value: item.value
                            })
                        })
                        let defaultProps = {
                            options: inputKPI,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // console.log(defaultProps)
                        this.setState({ kpiTypeList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getMaxAch() {
        let body = {
            group: 'CAT',
            company_id: this.props.company.company_id,
            type: 'MAX_ACHIEVEMENT'
        }
        api.create().getAllSettingByType(body).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputMaxAch = data.map((item) => {
                            return {
                                value: item.value
                            }
                        })
                        let defaultProps = {
                            options: inputMaxAch,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        this.setState({ maxAchList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
            this.getItemHierarki()
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}`
        )
        res = await res.blob()
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Outlook Performance Appraisal - Corporate Annual Target.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/export_outlook_pa?outlook_pa_id=${this.props.outlook_pa_id}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/export_outlook_pa?outlook_pa_id=${this.props.outlook_pa_id}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Outlook Performance Appraisal - Corporate Annual Target.xlsx';
            a.click();
        }
    }

    backToOutlookPA(type) {
        let data = []
        let stateFR = false
        console.log(this.state.dataTable)
        this.state.dataTable.map(i => {
            if (i[2] !== null) {
                let indexID = this.state.dataTable.findIndex((val) => val[1] == i[2])
                // console.log(indexID)
                // console.log(i[2])
                if (indexID !== -1) {
                    // console.log(dataTableBaru[indexID][6])
                    if (this.state.dataTable[indexID][5] === 'FINANCIAL PERSPECTIVE') {
                        stateFR = true
                    } else {
                        stateFR = false
                    }
                }
            } else {
                stateFR = false
            }
            // console.log(i[9] == null? "" : i[9].value)
            data.push({
                "item_report_id": i[1] == "" || i[1] == null ? 0 : i[1],
                // "item_name": String(i[5]),
                // "parent": i[2] == "" ? null : i[2],
                "weight": String(i[6]),
                "uom": String(i[7]),
                "kpi_type": i[8] == null ? "" : i[8].value,
                "max_ach": i[9] == null ? "" : i[9].value,
                "formula": i[10] == null ? "" : i[10].value,
                "january": stateFR ? i[0] == 3 ? String(i[11]) : String(Number(i[11].value).toFixed(1)) : String(i[11]),
                "february": stateFR ? i[0] == 3 ? String(i[12]) : String(Number(i[12].value).toFixed(1)) : String(i[12]),
                "march": stateFR ? i[0] == 3 ? String(i[13]) : String(Number(i[13].value).toFixed(1)) : String(i[13]),
                "april": stateFR ? i[0] == 3 ? String(i[14]) : String(Number(i[14].value).toFixed(1)) : String(i[14]),
                "may": stateFR ? i[0] == 3 ? String(i[15]) : String(Number(i[15].value).toFixed(1)) : String(i[15]),
                "june": stateFR ? i[0] == 3 ? String(i[16]) : String(Number(i[16].value).toFixed(1)) : String(i[16]),
                "july": stateFR ? i[0] == 3 ? String(i[17]) : String(Number(i[17].value).toFixed(1)) : String(i[17]),
                "august": stateFR ? i[0] == 3 ? String(i[18]) : String(Number(i[18].value).toFixed(1)) : String(i[18]),
                "september": stateFR ? i[0] == 3 ? String(i[19]) : String(Number(i[19].value).toFixed(1)) : String(i[19]),
                "october": stateFR ? i[0] == 3 ? String(i[20]) : String(Number(i[20].value).toFixed(1)) : String(i[20]),
                "november": stateFR ? i[0] == 3 ? String(i[21]) : String(Number(i[21].value).toFixed(1)) : String(i[21]),
                "december": stateFR ? i[0] == 3 ? String(i[22]) : String(Number(i[22].value).toFixed(1)) : String(i[22]),
                "total_current_year": String(Number(i[23]).toFixed(1)) == "" ? "0.0" : String(Number(i[23]).toFixed(1)),
                "strategic": String(i[24]),
                "pic": String(i[25])
            })
        })
        // console.log(JSON.stringify(data))
        let payload = {
            // "rolling_outlook_id": this.props.rollingOutlookID,
            "outlook_pa_id": this.props.outlook_pa_id,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "quartal": 'q1',
            "status": type,
            "cat": data,
            "balance_sheet": [],
            "profit_loss": [],
            "tax_planning": [],
        }
        // console.log(JSON.stringify(payload));
        api.create('UPLOAD').createReportOLPA(payload).then(response => {
            console.log(payload);
            console.log(response);
            console.log(JSON.stringify(payload))
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.onClickClose()
                    // this.props.refresh()
                    this.props.getReport()
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                        document.body.style.overflow = 'unset';
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                        this.props.onClickClose()
                        // this.props.refresh()
                        this.props.getReport()
                    })
                }
                // else {
                //     this.setState({ loading: false, handleDoubleClick: 0 }, () => {
                //         this.props.onClickClose()
                //         this.props.refresh()
                //     })
                // }
            } else {
                this.setState({ loading: false, handleDoubleClick: 0 })
            }
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            item_report_id: i[0] === undefined ? 0 : reg.test(String(i[0])) === false ? 0 : String(i[0]).trim(),
                            item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                            weight: i[2] === undefined ? "" : String(i[2]).trim(),
                            uom: i[3] === undefined ? "" : String(i[3]).trim(),
                            kpi_type: i[4] === undefined ? "" : String(i[4]).trim(),
                            max_ach: i[5] === undefined ? "" : String(i[5]).toLocaleLowerCase() !== 'unlimited' ? (String(i[5]).includes('%') ? String(i[5].trim()) : String(Number(i[5] * 100) + '%')) : String(i[5]).trim(),
                            formula_ytd: i[6] === undefined ? "" : String(i[6]).trim(),
                            january: i[7] === undefined ? "0.0" : reg.test(String(i[7])) === false ? "0.0" : String(roundMath(Number(i[7]), 1)).trim(),
                            february: i[8] === undefined ? "0.0" : reg.test(String(i[8])) === false ? "0.0" : String(roundMath(Number(i[8]), 1)).trim(),
                            march: i[9] === undefined ? "0.0" : reg.test(String(i[9])) === false ? "0.0" : String(roundMath(Number(i[9]), 1)).trim(),
                            april: i[10] === undefined ? "0.0" : reg.test(String(i[10])) === false ? "0.0" : String(roundMath(Number(i[10]), 1)).trim(),
                            may: i[11] === undefined ? "0.0" : reg.test(String(i[11])) === false ? "0.0" : String(roundMath(Number(i[11]), 1)).trim(),
                            june: i[12] === undefined ? "0.0" : reg.test(String(i[12])) === false ? "0.0" : String(roundMath(Number(i[12]), 1)).trim(),
                            july: i[13] === undefined ? "0.0" : reg.test(String(i[13])) === false ? "0.0" : String(roundMath(Number(i[13]), 1)).trim(),
                            august: i[14] === undefined ? "0.0" : reg.test(String(i[14])) === false ? "0.0" : String(roundMath(Number(i[14]), 1)).trim(),
                            september: i[15] === undefined ? "0.0" : reg.test(String(i[15])) === false ? "0.0" : String(roundMath(Number(i[15]), 1)).trim(),
                            october: i[16] === undefined ? "0.0" : reg.test(String(i[16])) === false ? "0.0" : String(roundMath(Number(i[16]), 1)).trim(),
                            november: i[17] === undefined ? "0.0" : reg.test(String(i[17])) === false ? "0.0" : String(roundMath(Number(i[17]), 1)).trim(),
                            december: i[18] === undefined ? "0.0" : reg.test(String(i[18])) === false ? "0.0" : String(roundMath(Number(i[18]), 1)).trim(),
                            strategic_initiative: i[20] === undefined ? "" : String(i[20]).trim(),
                            pic: i[21] === undefined ? "" : String(i[21]).trim()
                        })
                    }
                })
                // console.log(payload)
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    cat: payload,
                    outlook_pa_id: this.props.outlook_pa_id,
                    quartal: 'q1',
                    status: 'submitted',
                    balance_sheet: [],
                    profit_loss: [],
                    tax_planning: [],
                }
                // console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        this.setState({ loading: true, dataTable: [] })
        api.create().checkUploadOLPA(payload).then(response => {
            console.log(JSON.stringify(this.state.payload));
            console.log(this.state.payload)
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ visibleUpload: false, visibleCATRO: false })
                        let dataTable = []
                        response.data.data.map((item, index) => {
                            let indexID = dataTable.findIndex((val) => val[1] == item.parent)
                            let parent_name = ""
                            if (indexID != -1) {
                                parent_name = dataTable[indexID][5]
                            }
                            dataTable.push([
                                item.type_report_id,
                                item.item_report_id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.item_report,
                                Number(String(item.weight).substr(0, String(item.weight).length - 1)),
                                item.uom,
                                item.kpi_type == "" || item.kpi_type == null ? null : { value: item.kpi_type },
                                item.max_ach == "" || item.max_ach == null ? null : { value: titleCase(item.max_ach) },
                                item.formula_ytd == "" || item.formula_ytd == null ? null : { value: item.formula_ytd },
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.january).toFixed(1) : { value: item.january, formula: item.january_formula } : item.january == "" ? item.january : String(item.january).indexOf(".") == -1 ? Number(item.january) : Number(item.january).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.february).toFixed(1) : { value: item.february, formula: item.february_formula } : item.february == "" ? item.february : String(item.february).indexOf(".") == -1 ? Number(item.february) : Number(item.february).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.march).toFixed(1) : { value: item.march, formula: item.march_formula } : item.march == "" ? item.march : String(item.march).indexOf(".") == -1 ? Number(item.march) : Number(item.march).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.april).toFixed(1) : { value: item.april, formula: item.april_formula } : item.april == "" ? item.april : String(item.april).indexOf(".") == -1 ? Number(item.april) : Number(item.april).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.may).toFixed(1) : { value: item.may, formula: item.may_formula } : item.may == "" ? item.may : String(item.may).indexOf(".") == -1 ? Number(item.may) : Number(item.may).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.june).toFixed(1) : { value: item.june, formula: item.june_formula } : item.june == "" ? item.june : String(item.june).indexOf(".") == -1 ? Number(item.june) : Number(item.june).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.july).toFixed(1) : { value: item.july, formula: item.july_formula } : item.july == "" ? item.july : String(item.july).indexOf(".") == -1 ? Number(item.july) : Number(item.july).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.august).toFixed(1) : { value: item.august, formula: item.august_formula } : item.august == "" ? item.august : String(item.august).indexOf(".") == -1 ? Number(item.august) : Number(item.august).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.september).toFixed(1) : { value: item.september, formula: item.september_formula } : item.september == "" ? item.september : String(item.september).indexOf(".") == -1 ? Number(item.september) : Number(item.september).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.october).toFixed(1) : { value: item.october, formula: item.october_formula } : item.october == "" ? item.october : String(item.october).indexOf(".") == -1 ? Number(item.october) : Number(item.october).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.november).toFixed(1) : { value: item.november, formula: item.november_formula } : item.november == "" ? item.november : String(item.november).indexOf(".") == -1 ? Number(item.november) : Number(item.november).toFixed(1),
                                parent_name == "FINANCIAL PERSPECTIVE" ? item.type_report_id == 3 ? Number(item.december).toFixed(1) : { value: item.december, formula: item.december_formula } : item.december == "" ? item.december : String(item.december).indexOf(".") == -1 ? Number(item.december) : Number(item.december).toFixed(1),
                                item.total_current_year == "" ? item.total_current_year : String(item.total_current_year).indexOf(".") == -1 ? Number(item.total_current_year) : Number(item.total_current_year).toFixed(1),
                                item.strategic,
                                item.pic,
                                item.order,
                                item.error
                            ])
                        })
                        // console.log(this.state.buttonError)
                        console.log(dataTable)
                        this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true }, () => {
                            this.state.dataTable.map(item => {
                                if (item[27].length > 0) {
                                    console.log('masuk')
                                    this.setState({ buttonError: true, errorPreview: true, editable: true })
                                }
                            })
                            // console.log(this.state.dataTable);
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    uploadCATOLPA(type) {
        let data = []
        let stateFR = false
        console.log(this.state.dataTable)
        this.state.dataTable.map(i => {
            if (i[2] !== null) {
                let indexID = this.state.dataTable.findIndex((val) => val[1] == i[2])
                if (indexID !== -1) {
                    if (this.state.dataTable[indexID][5] === 'FINANCIAL PERSPECTIVE') {
                        stateFR = true
                    } else {
                        stateFR = false
                    }
                }
            } else {
                stateFR = false
            }

            data.push({
                "item_report_id": i[1] == "" || i[1] == null ? 0 : i[1],
                "item_report": String(i[5]),
                "weight": String(i[6]),
                "uom": String(i[7]),
                "kpi_type": i[8] == null ? "" : i[8].value,
                "max_ach": i[9] == null ? "" : i[9].value,
                "formula_ytd": i[10] == null ? "" : i[10].value,
                "january": stateFR ? i[0] == 3 ? String(i[11]) : String(Number(i[11].value).toFixed(1)) : String(i[11]),
                "february": stateFR ? i[0] == 3 ? String(i[12]) : String(Number(i[12].value).toFixed(1)) : String(i[12]),
                "march": stateFR ? i[0] == 3 ? String(i[13]) : String(Number(i[13].value).toFixed(1)) : String(i[13]),
                "april": stateFR ? i[0] == 3 ? String(i[14]) : String(Number(i[14].value).toFixed(1)) : String(i[14]),
                "may": stateFR ? i[0] == 3 ? String(i[15]) : String(Number(i[15].value).toFixed(1)) : String(i[15]),
                "june": stateFR ? i[0] == 3 ? String(i[16]) : String(Number(i[16].value).toFixed(1)) : String(i[16]),
                "july": stateFR ? i[0] == 3 ? String(i[17]) : String(Number(i[17].value).toFixed(1)) : String(i[17]),
                "august": stateFR ? i[0] == 3 ? String(i[18]) : String(Number(i[18].value).toFixed(1)) : String(i[18]),
                "september": stateFR ? i[0] == 3 ? String(i[19]) : String(Number(i[19].value).toFixed(1)) : String(i[19]),
                "october": stateFR ? i[0] == 3 ? String(i[20]) : String(Number(i[20].value).toFixed(1)) : String(i[20]),
                "november": stateFR ? i[0] == 3 ? String(i[21]) : String(Number(i[21].value).toFixed(1)) : String(i[21]),
                "december": stateFR ? i[0] == 3 ? String(i[22]) : String(Number(i[22].value).toFixed(1)) : String(i[22]),
                "total_current_year": String(Number(i[23]).toFixed(1)) == "" ? "0.0" : String(Number(i[23]).toFixed(1)),
                "strategic": i[24] == null ? "" : String(i[24]),
                "pic": String(i[25])
            })
        })
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            // "rolling_outlook_id": this.props.rollingOutlookID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.state.defaultCurrencyUpload?.id,
            "quartal": 'q1',
            "status": type,
            "cat": data,
            "balance_sheet": [],
            "profit_loss": [],
            "tax_planning": [],
        }
        // console.log(data);
        // console.log(JSON.stringify(body))
        api.create('UPLOAD').uploadOLPA(payload).then(response => {
            console.log(payload);
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.props.onClickClose()
                        // this.props.refresh()
                        this.props.getReport()
                    } else {
                        this.setState({ visibleAlertSave: true, alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    handleValidate() {
        this.setState({ loading: false, buttonError: false, editable: false, buttonDraft: false })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            // "rolling_outlook_id": this.props.rollingOutlookID,
            "outlook_pa_id": this.props.outlook_pa_id,
            "currency_id": this.props.defaultCurrency.id,
            "quartal": 'q1'
        }
        api.create().getLastestUpdateOLPA(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? '-' : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        const handleChange = (value, tableMeta) => {
            let val = String(value).split(",").join("")
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }

        const handleValueFormula = (value, tableMeta, column, periode, forecast) => {
            // loading = true
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else if (item == '' || item == '@') {

                } else if (item == "CurrMonth") {
                    anjay.push(String(column))
                } else if (item.includes('[CM]SUM')) {
                    let columnStart = 13
                    let indexX = String(item).indexOf('[')
                    let formulaAwal = String(item).substr(0, indexX)
                    let columnEnd = 24
                    let month = column - 1
                    let total = 0
                    // // // console.log(formulaAwal)
                    if (forecast == undefined) {
                        dataTable2[tableMeta.rowIndex].map((itemz, indexz) => {
                            if (indexz >= columnStart && indexz <= columnStart + month) {
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${formulaAwal}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = Number(value.formula[indexID].value)
                                    total += valuezz
                                }
                            }
                        })
                    } else {

                    }
                    anjay.push(String(total))
                } else if (item.includes('[CM]AVG')) {
                    if (forecast == undefined) {
                        anjay.push('/')
                        anjay.push(column)
                    }
                } else if (item.includes('X')) {
                    let indexX = String(item).indexOf('X')
                    // console.log(item)
                    if (indexX == 0) {
                        anjay.push(String(item).substr(1, String(item).length))
                    } else {
                        let formulaAwal = String(item).substr(0, indexX - 1)
                        let operatorX = String(item).substr(indexX - 1, 1)
                        let nilaiX = String(item).substr(indexX + 1, String(item).length)

                        if (forecast == undefined) {
                            let convertID = -1
                            // console.log(tableMeta)
                            if (tableMeta.rowData[10].value == 'FORMULA') {
                                // let indexIDReport = dataTable2.findIndex((val) => val[1] == formulaAwal)
                                // convertID = dataTable2[indexIDReport][31]
                                // let indexID = dataTable2.findIndex((val) => val[31] == (convertID == -1 ? item : convertID))
                                // let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                                // anjay.push(valuezz == "" ? 0 : valuezz)
                            } else {
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${formulaAwal}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = value.formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        } else {
                            // // // console.log(dataTable2[tableMeta.rowIndex][30])
                            let array = dataTable2[tableMeta.rowIndex][30].filter((val) => val.periode == Number(column))
                            let valuezz = array[0].value
                            // // // console.log(valuezz)
                            anjay.push(valuezz == "" ? 0 : valuezz)
                            // let indexID = dataTable2[tableMeta.rowIndex][30].findIndex((val) => val.periode == Number(this.props.periode))
                            // if (indexID !== -1) {
                            //     let valuezz = value.formula[indexID].value
                            //     anjay.push(valuezz == "" ? 0 : valuezz)
                            // }
                        }

                        anjay.push(operatorX)
                        anjay.push(nilaiX)
                    }
                } else {
                    if (String(item).includes('#')) {
                        // console.log(item)
                        if (forecast == undefined) {
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                            if (indexID !== -1) {
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" || valuezz == null ? "0" : valuezz)
                            }
                        }

                    } else {
                        let convertID = -1
                        if (tableMeta.rowData[11].value == 'FORMULA') {
                            let indexIDReport = dataTable2.findIndex((val) => val[1] == item)
                            convertID = dataTable2[indexIDReport][31]
                        }
                        let indexID = dataTable2.findIndex((val) => val[31] == (convertID == -1 ? item : convertID))
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                            if (item == dataTable2[tableMeta.rowIndex][31]) {
                                anjay.push(0)
                            } else {
                                anjay.push(valuezz == "" ? "0" : valuezz)
                            }
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                        }
                    }
                }
            })
            // if (tableMeta.rowData[11].value == 'FORMULA') {
            //     console.log(anjay)
            //     console.log(column)

            // }

            let anjay2 = []
            let kurung = false
            let item1 = []
            let brpKurung = 0
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                    // brpKurung += 1
                } else if (item == ")") {
                    // brpKurung -= 1
                    // if (brpKurung == 0) {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                    // }
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            // if (dataTable2[tableMeta.rowIndex][6] == "ROIC") {
            //     if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
            //         dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = "0"
            //     } else {
            //         dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = "0"
            //     }
            // } else {
            if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = total
            }
            // }

            return total
        }

        // const handleValueForecast = (value, tableMeta, periode) => {
        //     return handleValueFormula(value, tableMeta, periode, periode, 'forecast')
        // }
        const handleChangeDropdown = (value, tableMeta) => {
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
            let valz = value.value
            let total = 0
            let lastValz = 0
            if (valz == 'SUM' || valz == 'AVG' || valz == 'LAST') {
                dataTable2[tableMeta.rowIndex].map((item, index) => {
                    if (index >= 13 && index <= 24) {
                        let valItem = item == undefined || item == "" ? 0 : item
                        total += Number(valItem)
                        if (index == 24) {
                            lastValz += Number(valItem)
                        }
                    }
                })
                dataTable2[tableMeta.rowIndex][25] = (valz == 'SUM' ? total : (valz == 'AVG' ? (total / 12) : lastValz))
            }
        }
        const handleValueDropdown = (value, type, tableMeta) => {
            let data = type == 'KPI' ? this.state.kpiTypeList.options : (type == 'MAX' ? this.state.maxAchList.options : this.state.formulaYtdList.options)
            let index = 0
            if (value == null) {
                index = -1
            } else {
                index = data.findIndex((val) => val.value == value.value)
            }
            if (index == -1) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = null
                return null
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
                return value
            }
        }

        const handleChangePercentage = (value, tableMeta) => {
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value

        }

        const handleChangeText = (value, tableMeta) => {
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
        }

        const handleAction = (idParent, typeReport, tableMeta) => {
            if (this.props.isApprover) {
                return false
            } else {
                if ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) {
                    if (idParent !== null) {
                        let indexsss = dataTable2.findIndex((val) => val[1] == idParent)
                        if (dataTable2[indexsss][6] == 'CUSTOMER PERSPECTIVE' || dataTable2[indexsss][6] == 'INTERNAL BUSINESS PROCESS PERSPECTIVE') {
                            return true
                        } else {
                            return false
                        }
                    } else {
                        if (typeReport == null || typeReport == 3) {
                            return true
                        } else if (tableMeta !== undefined && tableMeta.rowData[0] == 1) {
                            let indexID = dataTable2.findIndex((val) => val[2] == tableMeta.rowData[1])
                            if (indexID !== -1) {
                                return false
                            } else {
                                return true
                            }
                        } else {
                            return false
                        }
                    }
                } else {
                    return false
                }
            }

        }

        const handleReturnFormula = (idParent, tableMeta) => {
            if (idParent !== null) {
                let indexsss = dataTable2.findIndex((val) => val[1] == idParent)
                // console.log(indexsss);
                if (dataTable2[indexsss][5] == 'FINANCIAL PERSPECTIVE') {
                    if (tableMeta.rowData[0] == 3) {
                        return false
                    } else {
                        return true
                    }
                } else {
                    return false
                }
            } else {
                return false
            }
        }

        const handleTotal = (tableMeta, type) => {
            // let val = String(value).split(",").join("")
            let total = 0
            let lastValz = 0
            let valItem = 0
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index >= 11 && index <= 22) {
                    // console.log(item.value);
                    if (item.value !== undefined) {
                        valItem = item.value == "" ? 0 : item.value
                        total += Number(valItem)
                        if (index == 22) {
                            lastValz += Number(valItem)
                        }
                    } else {
                        valItem = item == undefined || item == "" ? 0 : item
                        total += Number(valItem)
                        if (index == 22) {
                            lastValz += Number(valItem)
                        }
                    }
                }
            })
            let valz = dataTable2[tableMeta.rowIndex][10] == null ? 'SUM' : dataTable2[tableMeta.rowIndex][10].value
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = (valz == 'SUM' ? total : (valz == 'AVG' ? (total / 12) : lastValz))
            return (valz == 'SUM' ? total : (valz == 'AVG' ? (total / 12) : lastValz))
            // }
        }

        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Key Performance Indicator",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {tableMeta.rowData[32] ?
                                tableMeta.rowData[32].length > 0 ?
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </LightTooltip>
                                    </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        tableMeta.rowData[1] == null ?
                                            <div style={{ paddingLeft: 20 }}>
                                                <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </div>
                                            :
                                            <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </div>
                                :
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    tableMeta.rowData[1] == null ?
                                        <div style={{ paddingLeft: 20 }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Weight",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'center' }}>
                            {tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <div style={{ flex: 1 }}>
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        value={value}
                                        control={
                                            <NumberFormat
                                                thousandSeparator={true}
                                                suffix={"%"}
                                                style={{ color: 'black', fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                value={Number(value).toFixed(1)}
                                                disabled={true}
                                                decimalScale={1}
                                            />
                                        }
                                    />
                                </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "UOM",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'center' }}>
                            <div style={{ textAlign: 'center', width: 60 }}>
                                {value}
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "KPI Type",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <Autocomplete
                                    {...this.state.kpiTypeList}
                                    id="kpiType"
                                    onChange={(event, newInputValue) => handleChangeDropdown(newInputValue, tableMeta)}
                                    debug
                                    disableClearable
                                    disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                    value={handleValueDropdown(val, 'KPI', tableMeta)}
                                    style={{ padding: 0, margin: 0 }}
                                    renderInput={(params) =>
                                        <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                            <input style={{ borderColor: 'white', width: 96, textAlign: 'center', padding: 0, margin: 0, color: handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) ? "#5198ea" : "black" }} type="text" {...params.inputProps} />
                                        </div>
                                    }
                                />
                            }

                        </div>
                    )
                }
            }
        }, {
            name: "Max Ach.",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <Autocomplete
                                    {...this.state.maxAchList}
                                    id="maxAchList"
                                    onChange={(event, newInputValue) => handleChangeDropdown(newInputValue, tableMeta)}
                                    debug
                                    disableClearable
                                    value={handleValueDropdown(val, 'MAX', tableMeta)}
                                    style={{ padding: 0, margin: 0 }}
                                    disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                    renderInput={(params) =>
                                        <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                            <input style={{ borderColor: 'white', width: 96, textAlign: 'center', padding: 0, margin: 0, color: handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) ? "#5198ea" : "black" }} type="text" {...params.inputProps} />
                                        </div>
                                    }
                                // value={this.state.parent}
                                />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Formula YTD",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div style={{ width: 96 }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                <Autocomplete
                                    {...this.state.formulaYtdList}
                                    id="formulaYtdList"
                                    onChange={(event, newInputValue) => {
                                        // updateValue(newInputValue)
                                        handleChangeDropdown(newInputValue, tableMeta)
                                    }
                                    }
                                    debug
                                    disableClearable
                                    value={handleValueDropdown(val, 'FORMULA', tableMeta)}
                                    disabled={!handleAction(tableMeta.rowData[2], tableMeta.rowData[0])}
                                    style={{ padding: 0, margin: 0 }}
                                    renderInput={(params) =>
                                        <div ref={params.InputProps.ref} style={{ padding: 0, margin: 0 }}>
                                            <input style={{ borderColor: 'white', width: 96, textAlign: 'center', padding: 0, margin: 0, color: handleAction(tableMeta.rowData[2], tableMeta.rowData[0]) ? "#5198ea" : "black" }} type="text" {...params.inputProps} />
                                        </div>
                                    }
                                // value={this.state.parent}
                                />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    // console.log(tableMeta.rowData[0])
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Feb ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Mar ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Apr ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `May ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jun ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jul ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Aug ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Sep ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Oct ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Nov ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    this.state.get_for == "view" ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                        />
                                        :
                                        (handleReturnFormula(tableMeta.rowData[2], tableMeta) ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={Number(handleValueFormula(value, tableMeta, 11)).toFixed(1)}
                                                            disabled={true}
                                                            decimalScale={1}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7 ?
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={Number(handleValueFormula(value, tableMeta, 11)).toFixed(1)}
                                                                // value={Number(value).toFixed(1)}
                                                                disabled={true}
                                                                decimalScale={1}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={Number(value).toFixed(1)}
                                                                disabled={false}
                                                                decimalScale={1}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                        )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Dec ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    this.state.get_for == "view" ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={tableMeta.rowData[0] === 6 ? Number(value.value).toFixed(1) : Number(value).toFixed(1)}
                                        />
                                        :
                                        (handleReturnFormula(tableMeta.rowData[2], tableMeta) ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={Number(handleValueFormula(value, tableMeta, 12)).toFixed(1)}
                                                            disabled={true}
                                                            decimalScale={1}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7 ?
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={Number(handleValueFormula(value, tableMeta, 12)).toFixed(1)}
                                                                // value={Number(value).toFixed(1)}
                                                                disabled={true}
                                                                decimalScale={1}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={Number(value).toFixed(1)}
                                                                disabled={false}
                                                                decimalScale={1}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                }
                                            </div>
                                        )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${this.props.periode} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ width: 96 }}>
                            {
                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    this.state.get_for == "view" ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(value).toFixed(1)}
                                        />
                                        :
                                        (handleReturnFormula(tableMeta.rowData[2], tableMeta) ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            value={Number(handleTotal(tableMeta)).toFixed(1)}
                                                            disabled={true}
                                                            decimalScale={1}
                                                            onBlur={(event) => {
                                                                // updateValue(event.target.value)
                                                                handleChange(event.target.value, tableMeta)
                                                                // console.log(tableMeta.rowData[0])
                                                            }}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7 ?
                                                    // null
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // value={Number(handleValueFormula(value, tableMeta, 13)).toFixed(1)}
                                                                value={Number(value).toFixed(1)}
                                                                disabled
                                                                decimalScale={1}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />
                                                    :
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                value={Number(handleTotal(tableMeta)).toFixed(1)}
                                                                disabled={true}
                                                                decimalScale={1}
                                                                onBlur={(event) => {
                                                                    // updateValue(event.target.value)
                                                                    handleChange(event.target.value, tableMeta)
                                                                    // console.log(tableMeta.rowData[0])
                                                                }}
                                                            />
                                                        }
                                                    />}
                                            </div>
                                        )
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Strategic Initiative",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                this.state.get_for == "view" ?
                                    <Input
                                        disableUnderline={true}
                                        style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        defaultValue={value}
                                    />
                                    :
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        // value={value}
                                        control={
                                            <ThemeProvider theme={theme}>
                                                <Input
                                                    disableUnderline={true}
                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginBottom: -5 }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={false}
                                                    defaultValue={value}
                                                    onBlur={(event) => {
                                                        // console.log(event.target.value)
                                                        // updateValue(event.target.value)
                                                        handleChangeText(event.target.value, tableMeta)
                                                        // console.log(dataTable2)
                                                    }}
                                                />
                                            </ThemeProvider>

                                        }
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "PIC",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                customBodyRender: (value, tableMeta) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                null :
                                this.state.get_for == "view" ?
                                    <Input
                                        disableUnderline={true}
                                        style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        defaultValue={value}
                                    />
                                    :
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        // value={value}
                                        control={
                                            <ThemeProvider theme={theme}>
                                                <Input
                                                    disableUnderline={true}
                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginBottom: -5 }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={false}
                                                    defaultValue={value}
                                                    onBlur={(event) => {
                                                        // console.log(event.target.value)
                                                        // updateValue(event.target.value)
                                                        handleChangeText(event.target.value, tableMeta)
                                                        // console.log(dataTable2)
                                                    }}
                                                />
                                            </ThemeProvider>

                                        }
                                    />
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        },
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 1500, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Outlook Performance Appraisal & Revision CAT</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleCATRO ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Corporate Annual Target - Revision</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.props.isApprover === true || this.state.get_for == 'view' ?
                                            null
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            // </div> 
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.downloadTemplate()}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>

                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Notes : {this.state.notes}</Typography>
                            </div>
                            <div className="grid grid-2x" style={{ padding: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly &&
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    // marginRight: 20
                                                }}
                                                onClick={() => {
                                                    this.setState({ loading: true }, () => {
                                                        this.handleGetFor('edit')
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                                </div>
                                            </button>
                                        }
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToOutlookPA('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToOutlookPA('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Corporate Annual Target - Revision</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    <div style={{ width: '50%' }} />
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Notes : {this.state.notes}</Typography>
                            </div>
                            <div className="grid grid-2x" style={{ padding: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.setState({ visibleCATRO: true, visibleUpload: false }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadCATOLPA('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.uploadCATOLPA('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                        </Paper>
                    }
                </div>
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("PA") && String(this.state.judul).includes("OUTLOOK") && String(this.state.judul).includes("CAT") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                                <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data is <b>{this.props.defaultCurrency.id == 1 ? "IDR" : "USD"}</b></div>
                            </div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        )
    }
}
