import { createMuiTheme, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, FormControlLabel, withStyles, Snackbar } from '@material-ui/core'
import { Alert } from '@material-ui/lab';
import MUIDataTable from 'mui-datatables'
import React, { Component } from 'react'
import NumberFormat from 'react-number-format';
import { PropagateLoader } from 'react-spinners';
import ReactTooltip from 'react-tooltip';
import api from '../../api';
import Images from '../../assets/Images';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import * as R from 'ramda';
import Constant from '../../library/Constant';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};

export default class BalanceSheetOLPA extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            visibleBalanceSheet: true,
            disabledSave: true,
            editable: false,
            buttonError: false,
            judulColumn: null,
            updateBy: [],
            handleDoubleClick: 0,
            viewOnly: true,
            get_for: 'view',
            minValue: "0",
            maxValue: "0",
            kansas: 0,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false
        }
        this.handleValue = this.handleValue.bind(this)
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getLatestUpdate()
        this.handleViewOnly()
        this.getSettingControl()
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getLatestUpdate()
            this.getSettingControl()
        })
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_CONTROL',
            company_id: this.props.company.company_id,
            type: 'BALANCE_SHEET'
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        minValue: response.data.data[0] ? response.data.data[0].min_value : null,
                        maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
                    }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getLatestUpdate() {
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            "report_id": this.props.report_id,
            "revision": this.props.revision,
            "get_for": this.state.get_for,
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "currency_id": this.props.defaultCurrency.id
        }
        api.create().getLastestUpdateOLPA(payload).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? '-' : response.data.data.detail
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    async getItemHierarki() {
        this.setState({ loading: true, judulColumn: null })
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            "report_id": this.props.report_id,
            "revision": this.props.revision,
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "get_for": this.state.get_for,
            "currency_id": this.props.defaultCurrency.id
        }
        let response = await api.create().getDetailReportOLPA(payload)
        console.log(payload);
        console.log(response);
        let dataTable = []
        if (response.data) {
            let res = response.data.data
            const handlePushChild = (item) => {
                let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                if (indexIDzz === -1) {
                    dataTable.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        item.description,
                        item.balance_sheet.total_actual_before === null ? "0" : item.balance_sheet.total_actual_before === "" ? "0" : item.balance_sheet.total_actual_before,
                        Number(item.balance_sheet.january).toFixed(1),
                        Number(item.balance_sheet.february).toFixed(1),
                        Number(item.balance_sheet.march).toFixed(1),
                        Number(item.balance_sheet.april).toFixed(1),
                        Number(item.balance_sheet.may).toFixed(1),
                        Number(item.balance_sheet.june).toFixed(1),
                        Number(item.balance_sheet.july).toFixed(1),
                        Number(item.balance_sheet.august).toFixed(1),
                        Number(item.balance_sheet.september).toFixed(1),
                        Number(item.balance_sheet.october).toFixed(1),
                        this.props.status === 'CLOSED' ? Number(item.balance_sheet.november).toFixed(1) : item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: Number(item.balance_sheet.november).toFixed(1), formula: item.balance_sheet.november_formula } : Number(item.balance_sheet.november).toFixed(1),
                        this.props.status === 'CLOSED' ? Number(item.balance_sheet.december).toFixed(1) : item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: Number(item.balance_sheet.december).toFixed(1), formula: item.balance_sheet.december_formula } : Number(item.balance_sheet.december).toFixed(1),
                        Number(item.balance_sheet.total_current_year).toFixed(1),
                        item.order,
                        item.condition_it_should_be,
                        item.condition_if_wrong,
                        item.balance_sheet.forecast_formula == null ? [] : item.balance_sheet.forecast_formula
                    ])
                }
                if (item.children !== null) {
                    if (item.children.length > 0) {
                        item.children.map((items, indexs) => {
                            handlePushChild(items)
                        })
                    }
                }
            }
            res.map((item, index) => {
                dataTable.push([
                    item.type_report_id,
                    item.id,
                    item.parent,
                    item.formula,
                    item.level,
                    item.description,
                    item.balance_sheet.total_actual_before === null ? "0" : item.balance_sheet.total_actual_before === "" ? "0" : item.balance_sheet.total_actual_before,
                    Number(item.balance_sheet.january).toFixed(1),
                    Number(item.balance_sheet.february).toFixed(1),
                    Number(item.balance_sheet.march).toFixed(1),
                    Number(item.balance_sheet.april).toFixed(1),
                    Number(item.balance_sheet.may).toFixed(1),
                    Number(item.balance_sheet.june).toFixed(1),
                    Number(item.balance_sheet.july).toFixed(1),
                    Number(item.balance_sheet.august).toFixed(1),
                    Number(item.balance_sheet.september).toFixed(1),
                    Number(item.balance_sheet.october).toFixed(1),
                    this.props.status === 'CLOSED' ? Number(item.balance_sheet.november).toFixed(1) : item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: Number(item.balance_sheet.november).toFixed(1), formula: item.balance_sheet.november_formula } : Number(item.balance_sheet.november).toFixed(1),
                    this.props.status === 'CLOSED' ? Number(item.balance_sheet.december).toFixed(1) : item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: Number(item.balance_sheet.december).toFixed(1), formula: item.balance_sheet.december_formula } : Number(item.balance_sheet.december).toFixed(1),
                    Number(item.balance_sheet.total_current_year).toFixed(1),
                    item.order,
                    item.condition_it_should_be,
                    item.condition_if_wrong,
                    item.balance_sheet.forecast_formula == null ? [] : item.balance_sheet.forecast_formula
                ])
                if (item.children !== null) {
                    if (item.children.length > 0) {
                        item.children.map((items, indexs) => {
                            handlePushChild(items)
                        })
                    }
                }
            })
            console.log(dataTable);
            this.setState({ dataTable, loading: false, buttonError: true, editable: true, saveDraft: true })
        } else {
            this.setState({ dataTable, loading: false, buttonError: true, editable: true, saveDraft: true })
        }
    }

    handleValue(data) {
        let total = 0
        this.state.dataTable.map((item, index) => {
            if (data.rowData[1] == item[2]) {
                total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
            }
        })
        let indexParent = this.state.dataTable.findIndex((val) => val[1] == this.state.dataTable[data.rowIndex][2])
        let a = this.state.dataTable[data.rowIndex][data.columnIndex] = total
        // console.log(indexParent);
        return a
    }

    handleChange(value, tableMeta) {
        let val = String(value).split(",").join("")
        let data = this.state.dataTable
        let indexParent = data.findIndex((val) => val[1] == data[tableMeta.rowIndex][2])
        if (indexParent > 0) {
            // console.log(indexParent)
            let a = data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            let jagain = data[indexParent][tableMeta.columnIndex]
            a = data[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
        } else {
            data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
    }

    backToOLPA(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                total_actual_before: String(Number(i[6]).toFixed(1)),
                january: i[0] === 3 && i[7] === "" ? "0.0" : String(Number(i[7]).toFixed(1)),
                february: i[0] === 3 && i[8] === "" ? "0.0" : String(Number(i[8]).toFixed(1)),
                march: i[0] === 3 && i[9] === "" ? "0.0" : String(Number(i[9]).toFixed(1)),
                april: i[0] === 3 && i[10] === "" ? "0.0" : String(Number(i[10]).toFixed(1)),
                may: i[0] === 3 && i[11] === "" ? "0.0" : String(Number(i[11]).toFixed(1)),
                june: i[0] === 3 && i[12] === "" ? "0.0" : String(Number(i[12]).toFixed(1)),
                july: i[0] === 3 && i[13] === "" ? "0.0" : String(Number(i[13]).toFixed(1)),
                august: i[0] === 3 && i[14] === "" ? "0.0" : String(Number(i[14]).toFixed(1)),
                september: i[0] === 3 && i[15] === "" ? "0.0" : String(Number(i[15]).toFixed(1)),
                october: i[0] === 3 && i[16] === "" ? "0.0" : String(Number(i[16]).toFixed(1)),
                november: i[0] === 3 && i[17] === "" ? "0.0" : (i[0] === 5 || i[0] === 6 || i[0] === 7 ? String(Number(i[17].value).toFixed(1)) : String(Number(i[17]).toFixed(1))),
                december: i[0] === 3 && i[18] === "" ? "0.0" : (i[0] === 5 || i[0] === 6 || i[0] === 7 ? String(Number(i[18].value).toFixed(1)) : String(Number(i[18]).toFixed(1))),
                total_current_year: i[0] === 3 && i[19] === "" ? "0.0" : String(Number(i[19]).toFixed(1)),
            })
        })
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "status": type,
            "balance_sheet": data
        }
        console.log(data);
        this.setState({ loading: false })
        if (type == 'submitted') {
            this.props.saveToOLPA(payload, 'BS')
            // let bodyRatioOLPA = {
            //     "report": 'ratio',
            //     "outlookPaId": this.props.outlook_pa_id,
            //     "companyId": this.props.company.company_id,
            //     "periode": this.props.periode
            // }
            // api.create().triggerRatioOLPA(bodyRatioOLPA).then((res) => {
            //     console.log(res)
            //     this.setState({ loading: false })
            // })
            this.props.onClickClose()
        } else {
            this.props.saveToOLPA(payload)
            this.props.onClickClose()
        }

    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Outlook PA Balance Sheet.xlsx';
            a.click();
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(resp.rows[2]);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            item_report_id: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                            total_actual_before: i[2] === undefined ? "0" : reg.test(String(i[2])) === false ? "0" : String(i[2]).trim(),
                            january: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[3]).trim(),
                            february: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            march: i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[5]).trim(),
                            april: i[6] === undefined ? "0" : reg.test(String(i[6])) === false ? "0" : String(i[6]).trim(),
                            may: i[7] === undefined ? "0" : reg.test(String(i[7])) === false ? "0" : String(i[7]).trim(),
                            june: i[8] === undefined ? "0" : reg.test(String(i[8])) === false ? "0" : String(i[8]).trim(),
                            july: i[9] === undefined ? "0" : reg.test(String(i[9])) === false ? "0" : String(i[9]).trim(),
                            august: i[10] === undefined ? "0" : reg.test(String(i[10])) === false ? "0" : String(i[10]).trim(),
                            september: i[11] === undefined ? "0" : reg.test(String(i[11])) === false ? "0" : String(i[11]).trim(),
                            october: i[12] === undefined ? "0" : reg.test(String(i[12])) === false ? "0" : String(i[12]).trim(),
                            november: i[13] === undefined ? "0" : reg.test(String(i[13])) === false ? "0" : String(i[13]).trim(),
                            december: i[14] === undefined ? "0" : reg.test(String(i[14])) === false ? "0" : String(i[14]).trim(),
                            total_current_year: i[15] === undefined ? "0" : reg.test(String(i[15])) === false ? "0" : String(i[15]).trim(),
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    balance_sheet: payload
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[2] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkUploadOLPA(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleBalanceSheet: false, loading: true })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.total_actual_before,
                            Number(item.january).toFixed(1),
                            Number(item.february).toFixed(1),
                            Number(item.march).toFixed(1),
                            Number(item.april).toFixed(1),
                            Number(item.may).toFixed(1),
                            Number(item.june).toFixed(1),
                            Number(item.july).toFixed(1),
                            Number(item.august).toFixed(1),
                            Number(item.september).toFixed(1),
                            Number(item.october).toFixed(1),
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: Number(item.november).toFixed(1), formula: item.november_formula } : Number(item.november).toFixed(1),
                            item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: Number(item.december).toFixed(1), formula: item.december_formula } : Number(item.december).toFixed(1),
                            Number(item.total_current_year).toFixed(1),
                            item.orders,
                            item.condition_it_should_be,
                            item.condition_if_wrong,
                            item.forecast_formula == null ? [] : item.forecast_formula,
                            item.error
                        ]
                    })
                    console.log(this.state.dataTable);
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true }, () => {
                        this.state.dataTable.map(item => {
                            if (item[24].length > 0) {
                                console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true, editable: true })
                            }
                        })
                        console.log(this.state.dataTable);
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadBalanceSheet(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                total_actual_before: String(Number(i[6]).toFixed(1)),
                january: i[0] === 3 && i[7] === "" ? "0.0" : String(Number(i[7]).toFixed(1)),
                february: i[0] === 3 && i[8] === "" ? "0.0" : String(Number(i[8]).toFixed(1)),
                march: i[0] === 3 && i[9] === "" ? "0.0" : String(Number(i[9]).toFixed(1)),
                april: i[0] === 3 && i[10] === "" ? "0.0" : String(Number(i[10]).toFixed(1)),
                may: i[0] === 3 && i[11] === "" ? "0.0" : String(Number(i[11]).toFixed(1)),
                june: i[0] === 3 && i[12] === "" ? "0.0" : String(Number(i[12]).toFixed(1)),
                july: i[0] === 3 && i[13] === "" ? "0.0" : String(Number(i[13]).toFixed(1)),
                august: i[0] === 3 && i[14] === "" ? "0.0" : String(Number(i[14]).toFixed(1)),
                september: i[0] === 3 && i[15] === "" ? "0.0" : String(Number(i[15]).toFixed(1)),
                october: i[0] === 3 && i[16] === "" ? "0.0" : String(Number(i[16]).toFixed(1)),
                november: i[0] === 3 && i[17] === "" ? "0.0" : (i[0] === 5 || i[0] === 6 || i[0] === 7 ? String(Number(i[17].value).toFixed(1)) : String(Number(i[17]).toFixed(1))),
                december: i[0] === 3 && i[18] === "" ? "0.0" : (i[0] === 5 || i[0] === 6 || i[0] === 7 ? String(Number(i[18].value).toFixed(1)) : String(Number(i[18]).toFixed(1))),
                total_current_year: i[0] === 3 && i[19] === "" ? "0.0" : String(Number(i[19]).toFixed(1)),
            })
        })
        let body = {
            outlook_pa_id: this.props.outlook_pa_id,
            company_id: this.props.company.company_id,
            periode: this.props.periode,
            report_id: this.props.report_id,
            currency_id: this.props.defaultCurrency.id,
            balance_sheet: data,
            status: type
        }
        // console.log(JSON.stringify(body));
        api.create('UPLOAD').uploadOLPA(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.onClickClose()
                        this.props.getReport()
                        let bodyRatioOLPA = {
                            "report": 'ratio',
                            "outlookPaId": this.props.outlook_pa_id,
                            "companyId": this.props.company.company_id,
                            "periode": this.props.periode,
                            "currency_id": this.props.defaultCurrency.id,

                        }
                        api.create().triggerRatioOLPA(bodyRatioOLPA).then((res) => {
                            console.log(res)
                            this.setState({ loading: false })
                        })
                    } else {
                        this.props.onClickClose()
                        this.props.getReport()
                    }
                } else {
                    this.setState({ visibleAlertSave: true, alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ loading: false })
                alert(response.problem)
            }
        })
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/export_outlook_pa?outlook_pa_id=${this.props.outlook_pa_id}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        // console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/export_outlook_pa?outlook_pa_id=${this.props.outlook_pa_id === null ? "" : this.props.outlook_pa_id}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Outlook PA Balance Sheet.xlsx';
            a.click();
        }
    }

    handleValidate() {
        let data = []
        let err = false
        let dataTable = this.state.dataTable
        let kansas = this.state.kansas
        // console.log(this.state.dataTable)
        dataTable.map((i, index) => {
            if (String(i[5]) == "Control (should be nil)") {
                console.log(this.state.minValue)
                console.log(this.state.maxValue)
                console.log(Number(i[17].value).toFixed(1))
                console.log(Number(i[18].value).toFixed(1))
                console.log(Number(i[19]).toFixed(1))

                if ((Number(i[17].value).toFixed(1) < Number(this.state.minValue)) || (Number(i[17].value).toFixed(1) > Number(this.state.maxValue))) {
                    console.log("masuk selisih control 1")
                    err = true
                } else if ((Number(i[18].value).toFixed(1) < Number(this.state.minValue)) || (Number(i[18].value).toFixed(1) > Number(this.state.maxValue))) {
                    console.log("masuk selisih control 2")
                    err = true
                } else if ((Number(i[19]).toFixed(1) < Number(this.state.minValue)) || (Number(i[19]).toFixed(1) > Number(this.state.maxValue))) {
                    console.log("masuk selisih control 3")
                    err = true
                }
            }

            data.push({
                item_report_id: i[1],
                total_actual_before: String(i[6]),
                january: i[0] === 3 && i[7] === "" ? "0.0" : String(Number(i[7]).toFixed(1)),
                february: i[0] === 3 && i[8] === "" ? "0.0" : String(Number(i[8]).toFixed(1)),
                march: i[0] === 3 && i[9] === "" ? "0.0" : String(Number(i[9]).toFixed(1)),
                april: i[0] === 3 && i[10] === "" ? "0.0" : String(Number(i[10]).toFixed(1)),
                may: i[0] === 3 && i[11] === "" ? "0.0" : String(Number(i[11]).toFixed(1)),
                june: i[0] === 3 && i[12] === "" ? "0.0" : String(Number(i[12]).toFixed(1)),
                july: i[0] === 3 && i[13] === "" ? "0.0" : String(Number(i[13]).toFixed(1)),
                august: i[0] === 3 && i[14] === "" ? "0.0" : String(Number(i[14]).toFixed(1)),
                september: i[0] === 3 && i[15] === "" ? "0.0" : String(Number(i[15]).toFixed(1)),
                october: i[0] === 3 && i[16] === "" ? "0.0" : String(Number(i[16]).toFixed(1)),
                november: i[0] === 3 && i[17] === "" ? "0.0" : String(Number(i[17]).toFixed(1)),
                december: i[0] === 3 && i[18] === "" ? "0.0" : String(Number(i[18]).toFixed(1)),
                total_current_year: i[0] === 3 && i[19] === "" ? "0.0" : String(Number(i[19]).toFixed(1)),
            })
        })
        console.log(JSON.stringify(data))
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "balance_sheet": data,
            "status": "submitted"
        }
        api.create().validateSubmitReportOLPA(payload).then((response) => {
            // console.log(response)
            // console.log(response.data.data.result)
            // console.log(err);
            if (response.data) {
                if (response.data.status === "success") {
                    if (response.data.data.result && err === false) {
                        this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
                        if (kansas == 0) {
                            this.setState({ kansas: 1, loading: true }, () => {
                                this.handleValidate()
                            })
                        } else {
                            this.setState({ kansas: 0 })
                        }
                    } else {
                        this.setState({ loading: false, buttonError: true, editable: true, saveDraft: true })
                        if (kansas == 0) {
                            this.setState({ kansas: 1, loading: true }, () => {
                                this.handleValidate()
                            })
                        } else {
                            this.setState({ kansas: 0 })
                        }
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        const handleChange = (value, tableMeta, type) => {
            console.log(dataTable2);
            let val = String(value).split(",").join("")
            if (type === "actual") {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            } else {
                let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[tableMeta.rowIndex][2])
                if (indexParent > 0) {
                    // console.log(indexParent)
                    let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                    let jagain = dataTable2[indexParent][tableMeta.columnIndex]
                    a = dataTable2[indexParent][tableMeta.columnIndex] = jagain === undefined ? (0 + Number(val)) : (jagain + Number(val))
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                }
            }
        }

        const handleValue = (data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] === item[2]) {
                    let itemVal = item[data.columnIndex].value !== undefined ? Number(item[data.columnIndex].value) : Number(item[data.columnIndex])
                    total = item[data.columnIndex] === undefined ? Number(total) + 0 : Number(total) + itemVal
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex] = Number(total)
            // console.log(indexParent);
            return a
        }

        const handleTotal = (tableMeta) => {
            let total = 0
            tableMeta.rowData.map((item, index) => {
                if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd") {
                    // console.log(index)
                    if (index >= 7 && index <= 18) {
                        // console.log(item.value + "aaa")
                        if (item.value == undefined) {
                            total += Number(item)
                        } else {
                            total += Number(item.value)
                        }
                    }
                }
            })
            if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                // console.log([tableMeta.rowIndex][tableMeta.columnIndex])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = total
            }
            // console.log(total)
            return total
        }

        const handleValueFormula = (value, tableMeta, column, periode, forecast) => {
            // console.log(value)
            // console.log(tableMeta.rowData[5])
            let splitFormula = String(tableMeta.rowData[3]).split('@')
            let baru = []
            let anjay = []
            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let re = /^[a-zA-Z0-9]+$/;
                let asd = ''
                if (item !== "") {
                    if (!re.test(items)) {
                        if (String(item).substr(Number(String(item).length) - 1, 1) === ']') {
                            baru.push(String(item))
                        } else {
                            baru.push(String(item).substr(0, Number(String(item).length) - 1))
                            baru.push(String(item).substr(Number(String(item).length) - 1, 1))
                        }
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (forecast !== undefined) {
                            let forecastt = 0
                            forecast.map((items, index) => {
                                if (items.periode == periode) {
                                    forecastt += Number(items.value)
                                }
                            })
                            anjay.push(forecastt)
                        } else if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let data = tableMeta.columnIndex == 7 ? 18 : tableMeta.columnIndex - 1
                            let period = data == 18 ? Number(this.props.periode) - 1 : this.props.periode
                            // console.log(tableMeta.columnIndex)
                            let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                            // console.log(indexID)
                            if (indexID !== -1) {
                                let valuezz = tableMeta.rowData[data].formula[indexID].value
                                // baru.push(valuezz)
                                anjay.push(valuezz == "" ? 0 : valuezz)
                                // console.log(valuezz)
                            }
                        } else {
                            // console.log(baru);
                            // console.log(value);
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                            // console.log(indexID)
                            if (indexID !== -1) {
                                // console.log(value.formula[indexID].value)
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    } else if (String(item).includes('[M-1]')) {
                        let tst = String(item).replace('[M-1]', '')
                        if (tableMeta.columnIndex === 7 || tableMeta.columnIndex === 19) {
                            let indexID = dataTable2.findIndex((val) => val[20] == tst)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][6]
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            let data = tableMeta.columnIndex - 1
                            let indexID = dataTable2.findIndex((val) => val[20] == tst)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][data].value !== undefined ? dataTable2[indexID][data].value : dataTable2[indexID][data]
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                            // if (tableMeta.rowData[5] == 'R/E (Cummulative)') {
                            // console.log(tst, data, tableMeta.rowData[data]);}
                        }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[20] == item)
                        // console.log(dataTable2[indexID])
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                            anjay.push(valuezz == "" ? 0 : valuezz)
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                            // console.log(item);

                        }
                    }
                }
            })
            // console.log(baru)
            // console.log(anjay)
            // if (tableMeta.rowData[5] == 'R/E (Cummulative)') {
            //     console.log(splitFormula)
            //     console.log(baru)
            //     console.log(anjay)
            // }
            let total = 0
            let opt = ""
            anjay.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    item = item == "" ? 0 : item
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            })
            total = R.equals(total, NaN) ? "0.0" : total

            if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                // console.log([tableMeta.rowIndex][tableMeta.columnIndex])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = total
            }

            return total
        }

        const handleValidation = (data, tableMeta) => {
            let a = handleValueFormula(data, tableMeta)
            return a
        }

        const handleForecast = (tableMeta, periode, column) => {
            let total = 0
            if (column == 19 && String(tableMeta.rowData[5]).toLocaleLowerCase() == "r/e (cummulative)") {
                total = tableMeta.rowData[7]
                dataTable2[tableMeta.rowIndex][column] = tableMeta.rowData[7]
            } else {
                total = handleValueFormula(dataTable2[tableMeta.rowIndex][column], tableMeta, column, periode, dataTable2[tableMeta.rowIndex][23])
            }
            // console.log(total)
            return total
        }

        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {tableMeta.rowData[4] == 0 ?
                                <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                :
                                <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                    <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.periode) - 1} Actual`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    // <div style={{ flex: 1 }}>
                                    //     <FormControlLabel
                                    //         style={{ margin: 0 }}
                                    //         value={value}
                                    //         control={
                                    //             <NumberFormat
                                    //                 thousandSeparator={true}
                                    //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                    //                 type="text"
                                    //                 placeholder=""
                                    //                 disabled={true}
                                    //                 value={Number(value).toFixed(1)}
                                    //             />
                                    //         }
                                    //     />
                                    // </div>
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                    value={Number(value).toFixed(1)}
                                                    onBlur={(event) => {
                                                        handleChange(event.target.value, tableMeta)
                                                        // console.log(dataTable2)
                                                    }}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Feb ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Mar ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Apr ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `May ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jun ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jul ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Aug ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Sep ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Oct ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(value).toFixed(1)}
                                                    decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Nov ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null
                                :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={this.props.status === 'CLOSED' ? Number(value).toFixed(1) : (tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7 ? Number(value.value).toFixed(1) : Number(value).toFixed(1))}
                                    />
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        disabled={this.props.isApprover ? true : false}
                                                        value={Number(value).toFixed(1)}
                                                        onBlur={(event) => {
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(handleValue(tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(handleValueFormula(value, tableMeta)).toFixed(1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(handleValueFormula(value, tableMeta)).toFixed(1)}
                                                        />
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 7 ?
                                                                (Number(handleValidation(value, tableMeta)).toFixed(1) >= Number(this.state.minValue) && Number(handleValidation(value, tableMeta)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(handleValidation(value, tableMeta)).toFixed(1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleValidation(value, tableMeta)).toFixed(1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Dec ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null
                                :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={this.props.status === 'CLOSED' ? Number(value).toFixed(1) : (tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 7 ? Number(value.value).toFixed(1) : Number(value).toFixed(1))}
                                    />
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        disabled={this.props.isApprover ? true : false}
                                                        value={Number(value).toFixed(1)}
                                                        onBlur={(event) => {
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(handleValue(tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(handleValueFormula(value, tableMeta)).toFixed(1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(handleValueFormula(value, tableMeta)).toFixed(1)}
                                                        />
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 7 ?
                                                                (Number(handleValidation(value, tableMeta)).toFixed(1) >= Number(this.state.minValue) && Number(handleValidation(value, tableMeta)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(handleValidation(value, tableMeta)).toFixed(1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleValidation(value, tableMeta)).toFixed(1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${this.props.periode} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null
                                :
                                this.state.get_for == 'view' ?
                                    <NumberFormat
                                        thousandSeparator={true}
                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        type="text"
                                        placeholder=""
                                        disabled={true}
                                        value={Number(value).toFixed(1)}
                                    />
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // disabled={this.props.isApprover == true ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        disabled={this.props.isApprover ? true : false}
                                                        value={Number(value).toFixed(1)}
                                                        onBlur={(event) => {
                                                            handleChange(event.target.value, tableMeta)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(handleValue(tableMeta)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(handleTotal(tableMeta)).toFixed(1) : Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)).toFixed(1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 5 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)).toFixed(1)}
                                                        />
                                                        :
                                                        tableMeta.rowData[0] === 1 ?
                                                            null
                                                            :
                                                            tableMeta.rowData[0] === 7 ?
                                                                (Number(handleValidation(value, tableMeta)).toFixed(1) >= Number(this.state.minValue) && Number(handleValidation(value, tableMeta)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(handleValidation(value, tableMeta)).toFixed(1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleValidation(value, tableMeta)).toFixed(1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                null
                            }
                        </div>
                    )
                }
            }
        },
        {
            name: "",
            options: {
                display: false
            }
        },
        {
            name: "",
            options: {
                display: false
            }
        }]

        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Outlook Performance Appraisal Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {/* {this.state.loading && loadingComponent} */}
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleBalanceSheet === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Outlook Performance Appraisal - Balance Sheet</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {/* {this.props.isApprover == true || this.state.dataTable.length == 0 ? null : */}
                                        {this.props.isApprover == true || this.state.get_for == 'view' ?
                                            null
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                            // </div> 
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.downloadTemplate()}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5 }}>Notes : {this.state.notes}</Typography>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, refresh: true }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToOLPA('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' &&
                                            <button
                                                type="button"
                                                disabled={this.state.buttonError}
                                                onClick={() => this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.backToOLPA('submitted')
                                                        })}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                                </div>
                                            </button>}
                                    </div>
                                }
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>

                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1">
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visibleBalanceSheet: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadBalanceSheet('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' &&
                                            <button
                                                type="button"
                                                // disabled={this.state.buttonError}
                                                onClick={() => this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.uploadBalanceSheet('submitted')
                                                        })}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                                </div>
                                            </button>}
                                    </div>
                                </div>
                            </div>
                        </Paper>}
                </div>

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judul).includes("OUTLOOK") && String(this.state.judul).includes("PA") && String(this.state.judul).includes("BALANCE") && String(this.state.judul).includes("SHEET") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data is <b>{this.props.defaultCurrency.id == 1 ? "IDR" : "USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        )
    }
}
