import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, MuiThemeProvider, TableCell, FormControlLabel, Tooltip, withStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import api from '../../api';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { Alert } from '@material-ui/lab';
import * as R from 'ramda';
import Constant from '../../library/Constant';
import { roundMath } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class TaxPlanningMR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            visibleTP: true,
            disabledSave: true,
            editable: false,
            judulColumn: null,
            updateBy: [],
            notesUpdate: "",
            buttonDraft: true,
            handleDoubleClick: 0,
            saveDraft: true,
            buttonError: true,
            get_for: "view",
            viewOnly: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false

        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getSettingControl()
        // this.getItemHierarki()
        this.getLatestUpdate()
        this.handleViewOnly()
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getSettingControl()
            this.getLatestUpdate()
        })
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_CONTROL',
            company_id: this.props.company.company_id,
            type: 'TAX_PLANNING'
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        minValue: response.data.data[0] ? response.data.data[0].min_value : null,
                        maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
                    }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        api.create().getLastestUpdateMR(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notesUpdate: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    getItemHierarki() {
        this.setState({ loading: true, judulColumn: null })
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "get_for": this.state.get_for
        }
        api.create().getHierarkiMontlyReportTP(payload).then(response => {
            console.log(response);
            console.log(payload);
            let dataTable = []
            if (response.data) {
                if (response.data.status == 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.type_report_tax.value_tbc.type_report_id,
                                item.type_report_tax.value_fc.type_report_id,
                                item.type_report_tax.value_tbf.type_report_id,
                                item.id,
                                item.parent,
                                { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                                item.level,
                                item.description,
                                {
                                    tbc: item.tax_planning.trial_balance_commercial === null ? "0.0" : item.tax_planning.trial_balance_commercial === "" ? "0.0" : item.tax_planning.trial_balance_commercial,
                                    fcp: item.tax_planning.fiscal_correction === null ? "0.0" : item.tax_planning.fiscal_correction === "" ? "0.0" : item.tax_planning.fiscal_correction,
                                    tbf: item.tax_planning.trial_balance_fiscal === null ? "0.0" : item.tax_planning.trial_balance_fiscal === "" ? "0.0" : item.tax_planning.trial_balance_fiscal,
                                },
                                0,
                                item.tax_planning.trial_balance_fiscal_mb === null ? "0.0" : item.tax_planning.trial_balance_fiscal_mb === "" ? "0.0" : item.tax_planning.trial_balance_fiscal_mb,
                                item.tax_planning.actual_formula,
                                item.order,
                                { tbc: item.condition_it_should_be_tax.value_tbc, fcp: item.condition_it_should_be_tax.value_fc, tbf: item.condition_it_should_be_tax.value_tbf },
                                { tbc: item.condition_if_wrong_tax.value_tbc, fcp: item.condition_if_wrong_tax.value_fc, tbf: item.condition_if_wrong_tax.value_tbf },
                                item.tax_planning.trial_balance_fiscal_actual === null ? "0.0" : item.tax_planning.trial_balance_fiscal_actual === "" ? "0.0" : item.tax_planning.trial_balance_fiscal_actual,

                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.type_report_tax.value_tbc.type_report_id,
                            item.type_report_tax.value_fc.type_report_id,
                            item.type_report_tax.value_tbf.type_report_id,
                            item.id,
                            item.parent,
                            { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                            item.level,
                            item.description,
                            {
                                tbc: item.tax_planning.trial_balance_commercial === null ? "0.0" : item.tax_planning.trial_balance_commercial === "" ? "0.0" : item.tax_planning.trial_balance_commercial,
                                fcp: item.tax_planning.fiscal_correction === null ? "0.0" : item.tax_planning.fiscal_correction === "" ? "0.0" : item.tax_planning.fiscal_correction,
                                tbf: item.tax_planning.trial_balance_fiscal === null ? "0.0" : item.tax_planning.trial_balance_fiscal === "" ? "0.0" : item.tax_planning.trial_balance_fiscal,
                            },
                            0,
                            item.tax_planning.trial_balance_fiscal_mb === null ? "0.0" : item.tax_planning.trial_balance_fiscal_mb === "" ? "0.0" : item.tax_planning.trial_balance_fiscal_mb,
                            item.tax_planning.actual_formula,
                            item.order,
                            { tbc: item.condition_it_should_be_tax.value_tbc, fcp: item.condition_it_should_be_tax.value_fc, tbf: item.condition_it_should_be_tax.value_tbf },
                            { tbc: item.condition_if_wrong_tax.value_tbc, fcp: item.condition_if_wrong_tax.value_fc, tbf: item.condition_if_wrong_tax.value_tbf },
                            item.tax_planning.trial_balance_fiscal_actual === null ? "0.0" : item.tax_planning.trial_balance_fiscal_actual === "" ? "0.0" : item.tax_planning.trial_balance_fiscal_actual,
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    this.setState({ dataTable, loading: false, editable: true })
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ dataTable, loading: false, editable: true })
            }
            console.log(this.state.dataTable)
        })
    }

    handleChange(value, tableMeta) {
        let val = String(value).split(",").join("")
        let data = this.state.dataTable
        let indexParent = data.findIndex((val) => val[4] === data[tableMeta.rowIndex][5])
        if (indexParent > 0) {
            // console.log(indexParent)
            let a = data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            let jagain = data[indexParent][tableMeta.columnIndex]
            a = data[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
        } else {
            data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
        // this.forceUpdate()
        // console.log(this.state.dataTable)
        // this.setState({
        //     data: a,
        // }, () => console.log(this.state.dataTable))
    }

    backToMonthlyReport(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[4],
                trial_balance_commercial: String(Number(i[9].tbc).toFixed(1)),
                fiscal_correction: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].fcp).toFixed(2)) : String(Number(i[9].fcp).toFixed(1)),
                trial_balance_fiscal: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].tbf).toFixed(2)) : String(Number(i[9].tbf).toFixed(1)),
                trial_balance_fiscal_actual: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10]).toFixed(2)) : String(Number(i[10]).toFixed(1)),
                trial_balance_fiscal_mb: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11]).toFixed(2)) : String(Number(i[11]).toFixed(1))
            })
        })
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "tax_planning": data
        }

        api.create('UPLOAD').createMonthlyReportTP(payload).then(response => {
            console.log(payload);
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.saveToMonthlyReport()
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        document.body.style.overflow = 'unset';
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                        this.props.saveToMonthlyReport()
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(resp.rows[2]);
                // console.log(resp.rows);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            order: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report_id: i[1] === undefined ? "" : String(i[1]).trim(),
                            item_report_name: i[2] === undefined ? "" : String(i[2]).trim(),
                            trial_balance_commercial: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[2]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(roundMath(Number(String(i[3]).trim()), 2)) : String(roundMath(Number(String(i[3]).trim()), 1)),
                            fiscal_correction: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[2]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(roundMath(Number(String(i[4]).trim()), 2)) : String(roundMath(Number(String(i[4]).trim()), 1)),
                            trial_balance_fiscal: i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[2]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(roundMath(Number(String(i[5]).trim()), 2)) : String(roundMath(Number(String(i[5]).trim()), 1)),
                            trial_balance_fiscal_actual: "",
                            trial_balance_fiscal_mb: "",
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    months: this.props.month.month_id,
                    tax_planning: payload,
                    status: "submitted"
                }
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
                // console.log(this.state.judulColumn)
                // console.log(this.state.judul)
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkUploadMonthlyReportTP(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(this.state.payload)
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleTP: false, loading: true })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            0,
                            Number(item.type_report_id.tbc),
                            Number(item.type_report_id.fcp),
                            Number(item.type_report_id.tbf),
                            item.item_report_id,
                            item.parent,
                            { tbc: item.formula.tbc, fcp: item.formula.fcp, tbf: item.formula.tbf },
                            item.level,
                            item.item_report,
                            {
                                tbc: item.trial_balance_commercial === null ? "0.0" : item.trial_balance_commercial === "" ? "0.0" : item.trial_balance_commercial,
                                fcp: item.fiscal_correction === null ? "0.0" : item.fiscal_correction === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.fiscal_correction).toFixed(2) : Number(item.fiscal_correction).toFixed(1),
                                tbf: item.trial_balance_fiscal === null ? "0.0" : item.trial_balance_fiscal === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.trial_balance_fiscal).toFixed(2) : Number(item.trial_balance_fiscal).toFixed(1),
                            },
                            0,
                            item.trial_balance_fiscal_mb === null ? "0.0" : item.trial_balance_fiscal_mb === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.trial_balance_fiscal_mb).toFixed(2) : Number(item.trial_balance_fiscal_mb).toFixed(1),
                            item.actual_formula,
                            item.orders,
                            { tbc: item.condition_it_should_be.tbc, fcp: item.condition_it_should_be.fcp, tbf: item.condition_it_should_be.tbf },
                            { tbc: item.condition_if_wrong.tbc, fcp: item.condition_if_wrong.fcp, tbf: item.condition_if_wrong.tbf },
                            item.trial_balance_fiscal_actual === null ? "0.0" : item.trial_balance_fiscal_actual === "" ? "0.0" : String(item.item_report).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(item.trial_balance_fiscal_actual).toFixed(2) : Number(item.trial_balance_fiscal_actual).toFixed(1),
                            item.error
                        ]
                    })
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true, saveDraft: true }, () => {
                        this.state.dataTable.map(item => {
                            if (item[17].length > 0) {
                                // console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true, editable: true, saveDraft: true })
                            }
                        })
                        // console.log(this.state.dataTable);
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadTP(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[4],
                trial_balance_commercial: String(Number(i[9].tbc).toFixed(1)),
                fiscal_correction: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].fcp).toFixed(2)) : String(Number(i[9].fcp).toFixed(1)),
                trial_balance_fiscal: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].tbf).toFixed(2)) : String(Number(i[9].tbf).toFixed(1)),
                trial_balance_fiscal_actual: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10]).toFixed(2)) : String(Number(i[10]).toFixed(1)),
                trial_balance_fiscal_mb: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11]).toFixed(2)) : String(Number(i[11]).toFixed(1))
            })
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "tax_planning": data
        }
        // console.log(data);
        api.create('UPLOAD').uploadMonthlyReportTP(body).then(response => {
            // console.log(body);
            // console.log(JSON.stringify(body));
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.saveToMonthlyReport()
                } else {
                    this.setState({ visibleAlertSave: true, loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                        this.props.saveToMonthlyReport()
                    })
                    // alert(response.data.status)
                }
            } else {
                this.setState({ loading: false, alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    handleValidate(dataTable2) {
        let data = []
        let errorContrl = this.state.buttonError
        let editAble = this.state.editAble
        console.log(this.state.dataTable)
        console.log(dataTable2)
        dataTable2.map(i => {
            console.log(i)
            // this.setState({ loading: false })
            console.log(i[9].tbf)
            if (String(i[8]) === "Control (should be nil)") {
                console.log(i[9].tbf)
                console.log(this.state.minValue)
                console.log(this.state.maxValue)
                if (Number(i[9].tbf) < Number(this.state.minValue) || Number(i[9].tbf) > Number(this.state.maxValue)) {
                    errorContrl = true
                    editAble = true
                } else {
                    errorContrl = false
                    editAble = false
                }
            }

            data.push({
                item_report_id: i[4],
                trial_balance_commercial: String(Number(i[9].tbc).toFixed(1)),
                fiscal_correction: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].fcp).toFixed(2)) : String(Number(i[9].fcp).toFixed(1)),
                trial_balance_fiscal: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[9].tbf).toFixed(2)) : String(Number(i[9].tbf).toFixed(1)),
                trial_balance_fiscal_actual: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[10]).toFixed(2)) : String(Number(i[10]).toFixed(1)),
                trial_balance_fiscal_mb: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[11]).toFixed(2)) : String(Number(i[11]).toFixed(1))
            })
        })
        // this.setState({ loading: false, buttonError: errorContrl, editable: editAble, saveDraft: false })
        console.log(errorContrl)
        let i = this.state.dataTable
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": "submitted",
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "tax_planning": data
        }
        api.create().validateSubmitReportMRTP(payload).then((response) => {
            console.log(payload)
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    if (response.data.data.result && errorContrl === false && editAble === false) {
                        this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
                    } else {
                        this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/tax_planning/monthly_report/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report Tax Planning.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/tax_planning/monthly_report/export_monthly_report?monthly_report_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        let urls = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/tax_planning/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        // console.log(url);
        console.log(urls);
        let res = await fetch(
            this.props.monthlyReportId == null ? url : urls
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report Tax Planning.xlsx';
            a.click();
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        const handleValueFormula = (value, tableMeta, dex, xntd, forecast, periode) => {
            let form = dex === 1 ? tableMeta.rowData[6].tbc : dex === 2 ? tableMeta.rowData[6].fcp : dex === 3 ? tableMeta.rowData[6].tbf : tableMeta.rowData[6].tbf
            let splitFormula = String(form).split('@')
            let baru = []
            let anjay = []
            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let re = /^[a-zA-Z0-9_]+$/;
                let asd = ''
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(String(item).substr(0, Number(String(item).length) - 1))
                        baru.push(String(item).substr(Number(String(item).length) - 1, 1))
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            if (tableMeta.rowData[8] == "Under payment  /(Over Payment ) Income Tax Art.  29" || forecast !== undefined) {
                let opgab = []
                baru.map((item, index) => {
                    if (item.length > 1 && (item.includes("+") || item.includes("-") || item.includes("*") || item.includes("/"))) {
                        opgab.push(String(item).substr(0, Number(String(item).length) - 1))
                        opgab.push(String(item).substr(Number(String(item).length) - 1, 1))
                    } else {
                        opgab.push(item)
                    }
                })
                if (opgab.length > 0) {
                    baru = opgab
                }
            }

            let totalShldBeNil = 0
            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        let splitform = String(item).split('#')
                        if (splitform[1] == 'TP1' || splitform[1] == 'TP2' || splitform[1] == 'TP3') {
                            let indexID = dataTable2.findIndex((val) => val[13] == splitform[0])
                            if (indexID !== -1) {
                                let data = splitform[1] == 'TP1' ? dataTable2[indexID][tableMeta.columnIndex].tbc : splitform[1] == 'TP2' ? dataTable2[indexID][tableMeta.columnIndex].fcp : dataTable2[indexID][tableMeta.columnIndex].tbf
                                let valuezz = data.value == undefined ? data : data.value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            if (forecast !== undefined) {
                                forecast.map((item, index) => {
                                    if (periode == item.periode) {
                                        totalShldBeNil += Number(item.value)
                                    }
                                })
                                anjay.push(totalShldBeNil)
                            } else if (String(item).includes('[M-1]')) {
                                let tst = String(item).replace('[M-1]', '[M1]')
                                // let data = tableMeta.columnIndex == 9 ? 20 : tableMeta.columnIndex - 1
                                let data = tableMeta.columnIndex
                                let dataSub = dex == 1 ? tableMeta.rowData[data].tbc : dex == 2 ? tableMeta.rowData[data].fcp : tableMeta.rowData[data].tbf
                                let period = data == 20 ? Number(this.props.periode) - 1 : this.props.periode
                                let indexID = dataSub.formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                                if (indexID !== -1) {
                                    let valuezz = tableMeta.rowData[data].formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            } else {
                                let data = tableMeta.rowData[12] === null ? [] : tableMeta.rowData[12]
                                let indexID = data.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = data[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[13] == item)
                        if (indexID !== -1) {
                            if (dataTable2[indexID][13] == tableMeta.rowData[13]) {
                                anjay.push(0)
                            } else {
                                let data = dex == 1 ? dataTable2[indexID][tableMeta.columnIndex].tbc : dex == 2 ? dataTable2[indexID][tableMeta.columnIndex].fcp : dex == 3 ? dataTable2[indexID][tableMeta.columnIndex].tbf : dataTable2[indexID][tableMeta.columnIndex]
                                let valuezz = data.value == undefined ? data : data.value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }

                        }
                    }
                }
            })

            let total = 0
            let total2 = 0
            let opt = ""
            let opt2 = ""
            let prio = false
            let simpen2 = ""
            anjay.map((item, index) => {
                if (item == "+") {
                    if (prio) {
                        opt2 = "tambah"
                    } else {
                        opt = "tambah"
                    }
                } else if (item == "-") {
                    if (prio) {
                        opt2 = "kurang"
                    } else {
                        opt = "kurang"
                    }
                } else if (item == "*") {
                    if (prio) {
                        opt2 = "kali"
                    } else {
                        opt = "kali"
                    }
                } else if (item == "/") {
                    if (prio) {
                        opt2 = "bagi"
                    } else {
                        opt = "bagi"
                    }
                } else if (item == "(") {
                    prio = true
                    simpen2 = "active"
                } else if (item == ")") {
                    prio = false
                }
                else {
                    if (prio) {
                        if (opt2 == "tambah") {
                            total2 = Number(total2) + Number(item)
                        } else if (opt2 == "kurang") {
                            total2 = Number(total2) - Number(item)
                        } else if (opt2 == "kali") {
                            total2 = Number(total2) * Number(item)
                        } else if (opt2 == "bagi") {
                            total2 = Number(total2) / Number(item) == NaN ? 0 : Number(total2) / Number(item)
                        } else {
                            total2 += Number(item)
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            if (simpen2 == "active") {
                if (opt == "tambah") {
                    total = Number(total) + Number(total2)
                } else if (opt == "kurang") {
                    total = Number(total) - Number(total2)
                } else if (opt == "kali") {
                    total = Number(total) * Number(total2)
                } else if (opt == "bagi") {
                    total = Number(total) / Number(total2) == NaN ? 0 : Number(total) / Number(total2)
                }
            }

            total = R.equals(total, NaN) ? "0.0" : total

            if (dex == 1) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = Number(total).toFixed(1)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value = Number(total).toFixed(1)
                }
            } else if (dex == 2) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = Number(total).toFixed(1)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value = Number(total).toFixed(1)
                }
            } else if (dex == 3) {
                if (tableMeta.rowData[8] == "Corporate Income Tax") {
                    if (total < 0) {
                        total = 0
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(total).toFixed(2)
                    } else {
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(total).toFixed(2)
                    }
                } else if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(total).toFixed(1)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value = Number(total).toFixed(1)
                }
            } else {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total).toFixed(1)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = Number(total).toFixed(1)
                }
            }

            return tableMeta.rowData[8] == "Corporate Income Tax" ? Number(total).toFixed(2) : Number(total).toFixed(1)
        }

        const handleChange = (value, tableMeta, indexChilds) => {
            let val = String(value).split(",").join("")
            // let data = this.state.dataTable2
            let indexParent = dataTable2.findIndex((val) => val[4] === dataTable2[tableMeta.rowIndex][5])
            // ini buat input untuk perhitungan parent nya
            if (indexParent > 0) {
                if (indexChilds == 1) {
                    let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = Number(val)
                    let jagain = dataTable2[indexParent][tableMeta.columnIndex].fcp
                    a = dataTable2[indexParent][tableMeta.columnIndex].fcp = jagain === undefined ? (0 + Number(val)) : (Number(jagain) + Number(val))
                }
            } else {
                if (indexChilds == 0) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = Number(val)
                }
                else if (indexChilds == 1) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = Number(val)
                }
                else if (indexChilds == 2) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(val)
                }
            }
            console.log(dataTable2)
        }
        const handleTotal = (value, tableMeta, dex) => {
            // console.log(tableMeta)
            let total = 0
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index == 9) {
                    let valItemTBF = item.tbf == undefined || item.tbf == "" || item.tbf == "undefined" ? 0.0 : item.tbf
                    total = Number(tableMeta.rowData[16]) + Number(valItemTBF)
                }
            })

            dataTable2[tableMeta.rowIndex][10] = Number(total)
            return total
        }

        const handleParent = (tableMeta, type) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (item[5] == tableMeta.rowData[4]) {
                    total += Number(type == 1 ?
                        item[tableMeta.columnIndex].tbc.value == undefined ? Number(item[tableMeta.columnIndex].tbc == "" || item[tableMeta.columnIndex].tbc == "0.0" ? 0 : item[tableMeta.columnIndex].tbc) : Number(item[tableMeta.columnIndex].tbc.value == "" || item[tableMeta.columnIndex].tbc.value == "0.0" ? 0 : item[tableMeta.columnIndex].tbc.value)
                        :
                        (type == 2 ?
                            item[tableMeta.columnIndex].fcp.value == undefined ? Number(item[tableMeta.columnIndex].fcp == "" || item[tableMeta.columnIndex].fcp == "0.0" ? 0 : item[tableMeta.columnIndex].fcp) : Number(item[tableMeta.columnIndex].fcp.value == "" || item[tableMeta.columnIndex].fcp.value == "0.0" ? 0 : item[tableMeta.columnIndex].fcp.value)
                            :
                            (type == 3 ?
                                item[tableMeta.columnIndex].tbf.value == undefined ? Number(item[tableMeta.columnIndex].tbf == "" || item[tableMeta.columnIndex].tbf == "0.0" ? 0 : item[tableMeta.columnIndex].tbf) : Number(item[tableMeta.columnIndex].tbf.value == "" || item[tableMeta.columnIndex].tbf.value == "0.0" ? 0 : item[tableMeta.columnIndex].tbf.value)
                                :
                                item[tableMeta.columnIndex].value == undefined ? Number(item[tableMeta.columnIndex] == "" || item[tableMeta.columnIndex] == "0.0" ? 0 : item[tableMeta.columnIndex]) : Number(item[tableMeta.columnIndex].value == "" || item[tableMeta.columnIndex].value == "0.0" ? 0 : item[tableMeta.columnIndex].value)
                            )
                        )
                    )
                }
            })

            if (type == 1) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = total
            } else if (type == 2) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = total
            } else if (type == 3) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            }
            return total
        }

        const columns = [
            {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[0] === null ?
                                    tableMeta.rowData[7] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[7]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                    :
                                    tableMeta.rowData[7] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[7]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `MTD`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Commercial) MTD"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Fiscal Correction Positive /(Negative)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                    <span>{"Trial Balance (Fiscal) MTD"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbc).toFixed(2) : Number(value.tbc).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    tableMeta.rowData[1] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(handleParent(tableMeta, 1)).toFixed(1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[1] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbc}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            decimalSeparator={"."}
                                                                            style={{ color: this.props.isApprover || this.state.get_for == 'view' ? 'black' : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder="input"
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            value={Number(value.tbc).toFixed(1)}
                                                                            onBlur={(event) => {
                                                                                handleChange(event.target.value, tableMeta, 0)
                                                                                // console.log(dataTable2)
                                                                            }}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                            :
                                                            tableMeta.rowData[1] === 5 || tableMeta.rowData[1] === 6 ?
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={value.tbc}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={Number(handleValueFormula(value, tableMeta, 1)).toFixed(1)}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                                :
                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                                null
                                                :
                                                this.state.get_for == 'view' ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.fcp).toFixed(2) : Number(value.fcp).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    tableMeta.rowData[2] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(handleParent(tableMeta, 2)).toFixed(1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[2] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.fcp}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: this.props.isApprover || this.state.get_for == 'view' ? 'black' : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            placeholder="input"
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.fcp).toFixed(2) : Number(value.fcp).toFixed(1)}
                                                                            onBlur={(event) => {
                                                                                handleChange(event.target.value, tableMeta, 1)
                                                                                // console.log(dataTable2)
                                                                            }}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                            :
                                                            tableMeta.rowData[2] === 5 || tableMeta.rowData[2] === 6 ?
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={value.tbc}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={Number(handleValueFormula(value, tableMeta, 2)).toFixed(1)}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                                :
                                                                null
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf).toFixed(2) : Number(value.tbf).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    tableMeta.rowData[3] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(handleParent(tableMeta, 3)).toFixed(1)}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[3] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value.tbf}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: this.props.isApprover || this.state.get_for == 'view' ? 'black' : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            placeholder="input"
                                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf).toFixed(2) : Number(value.tbf).toFixed(1)}
                                                                            onBlur={(event) => {
                                                                                handleChange(event.target.value, tableMeta, 2)
                                                                                // console.log(dataTable2)
                                                                            }}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                            :
                                                            tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 6 ?
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={value.tbc}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleValueFormula(value, tableMeta, 3)).toFixed(2) : Number(handleValueFormula(value, tableMeta, 3)).toFixed(1)}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                                :
                                                                tableMeta.rowData[3] === 7 ?
                                                                    (Number(handleValueFormula(value, tableMeta, 3)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 3)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'black'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleValueFormula(value, tableMeta, 3)).toFixed(1)}
                                                                        /> :
                                                                        <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[14].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'red'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={Number(handleValueFormula(value, tableMeta, 3)).toFixed(1)}
                                                                            />
                                                                        </LightTooltip>
                                                                    :
                                                                    null
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Trial Balance (Fiscal) Actual YTD`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                            {/* <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) Actual MTD"}</span>
                            </div>
                        </div> */}
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 || tableMeta.rowData[3] === 7 ?
                                    null
                                    :
                                    this.state.get_for == 'view' ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(tableMeta.rowData[16]).toFixed(2) : Number(tableMeta.rowData[16]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        tableMeta.rowData[3] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(handleParent(tableMeta, 4)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            // tableMeta.rowData[3] === 7 ?
                                            //     (Number(handleValueFormula(value, tableMeta, 4)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 4)).toFixed(1) <= Number(this.state.maxValue)) ?
                                            //     // (Number(value).toFixed(1) >= Number(this.state.minValue) && Number(value).toFixed(1) <= Number(this.state.maxValue)) ?
                                            //         <NumberFormat
                                            //             thousandSeparator={true}
                                            //             style={{
                                            //                 fontSize: 12,
                                            //                 textAlign: 'right',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 0,
                                            //                 width: 96,
                                            //                 backgroundColor: 'transparent',
                                            //                 color: 'black'
                                            //             }}
                                            //             type="text"
                                            //             placeholder=""
                                            //             disabled={true}
                                            //             // value={Number(handleValueFormula(value, tableMeta, 3)).toFixed(1)}
                                            //             value={Number(value).toFixed(1)}
                                            //         /> :
                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[14].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                            //             <NumberFormat
                                            //                 thousandSeparator={true}
                                            //                 style={{
                                            //                     fontSize: 12,
                                            //                     textAlign: 'right',
                                            //                     borderColor: 'transparent',
                                            //                     margin: 0,
                                            //                     width: 96,
                                            //                     backgroundColor: 'transparent',
                                            //                     color: 'red'
                                            //                 }}
                                            //                 type="text"
                                            //                 placeholder=""
                                            //                 disabled={true}
                                            //                 // value={Number(handleValueFormula(value, tableMeta, 4)).toFixed(1)}
                                            //                 value={Number(value).toFixed(1)}
                                            //             />
                                            //         </LightTooltip>
                                            //         :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleTotal(value, tableMeta, 4)).toFixed(2) : Number(handleTotal(value, tableMeta, 4)).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>

                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Trial Balance (Fiscal) MB YTD`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                            {/* <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) Actual MTD"}</span>
                            </div>
                        </div> */}
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 || tableMeta.rowData[3] === 7 ?
                                    null
                                    :
                                    this.state.get_for == 'view' ?
                                        // Number(value).toFixed(1)
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(tableMeta.rowData[11]).toFixed(2) : Number(tableMeta.rowData[11]).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        tableMeta.rowData[3] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(handleParent(tableMeta, 4)).toFixed(1)}
                                                />
                                            </span>
                                            :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value).toFixed(2) : Number(value).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {/* {this.state.loading && loadingComponent} */}
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleTP === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Tax Planning</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()}, {this.props.periode} (rev.{this.props.revision})</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.props.isApprover === true || this.state.get_for == 'view' ?
                                            null
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            // </div>
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.downloadTemplate()}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    {!this.state.loading && <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>}
                                    {/* )} */}
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5 }}>Notes : {this.state.notesUpdate}</Typography>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginLeft: 10 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                    (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, buttonDraft: false }, () => {
                                                    setTimeout(() => {
                                                        this.setState({ loading: false, buttonError: false, editable: true })
                                                        this.handleValidate(dataTable2)
                                                    }, 100);
                                                })
                                            }
                                            }
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.backToMonthlyReport('draft')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.backToMonthlyReport('submitted')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 10 }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()}, {this.props.periode} (rev.{this.props.revision})</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            {!this.state.loading && <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>}
                                        </div>
                                    )}
                                </div>
                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1">
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visibleTP: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{ marginRight: 20, marginLeft: 10 }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                // this.forceUpdate()
                                                this.setState({ loading: true, buttonDraft: false }, () => {
                                                    setTimeout(() => {
                                                        this.setState({ loading: false, buttonError: false, editable: true })
                                                        this.handleValidate(dataTable2)
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => this.state.saveDraft === true ?
                                                this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadTP('draft')
                                                        }, 100);
                                                    })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                            onClick={() => this.state.editable === true ?
                                                this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadTP('submitted')
                                                        }, 100);
                                                    })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 10 }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>
                    }
                </div>
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("TAX") && String(this.state.judul).includes("PLANNING") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data is <b>{this.props.defaultCurrency.id == 1 ? "IDR" : "USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        );
    }
}
