import { createMuiTheme, FormControlLabel, Input, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, withStyles } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import ReactTooltip from 'react-tooltip';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import * as R from 'ramda';
import { PropagateLoader } from 'react-spinners';
import { ExcelRenderer } from 'react-excel-renderer';
import Constant from '../../library/Constant';
import UploadFile from "../../library/Upload";

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class CashFlowMR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: false,
            visibleCFMR: true,
            // valueThreshold: 0,
            minValue: 0,
            maxValue: 0,
            viewOnly: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false
        }
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }
        // console.log(this.props.status)
        // console.log(this.props.lastStatus)
        // console.log(checkStatus)
        // console.log(checkLastStatus)
        // console.log(checkApprover)
        // console.log(checkPrevRev)
        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({viewOnly: true})
    }

    componentDidMount() {
        // this.getItemHierarki()
        console.log(this.props.PLBSFAMSubmitted)
        this.handleViewOnly()
        this.getSettingControl()
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_CONTROL',
            company_id: this.props.company.company_id,
            type: 'CASH_FLOW'
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        minValue: response.data.data[0] ? response.data.data[0].min_value : null,
                        maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
                    }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "get_for": "edit"
        }

        api.create().getHierarkiMontlyReportCF(payload).then(response => {
            console.log(response);
            let dataTable = []
            if (response.data) {
                let res = response.data.data
                const handlePushChild = (item) => {
                    let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                    if (indexIDzz === -1) {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            { value: item.cash_flow.actual, formula: item.cash_flow.actual_formula },
                            item.order,
                        ])
                    }
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                }
                res.map((item, index) => {
                    dataTable.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        item.description,
                        { value: item.cash_flow.actual, formula: item.cash_flow.actual_formula },
                        item.order,
                    ])
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                })
                console.log(dataTable)
                this.setState({ dataTable, loading: false })
            }
        })
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cash_flow/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId === null ? "" : this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report Cash Flow.xlsx';
            a.click();
        }
    }

    payloadCF(dataTable2) {
        let listCF = []
        console.log(dataTable2)
        dataTable2.map((item, index) => {
            // if (item[6].value == "" || item[6].value == 0 || item[6].value == "0.0") {
            //     item[6].value = this.handleValueFormula(item, index)
            listCF.push({
                "item_report_id": item[1],
                "actual": item[0] == 1 ? "" : Number(item[6].value).toFixed(1)
            })
            // } else {
            //     listCF.push({
            //         "item_report_id": item[1],
            //         "actual": item[0] == 1 ? "" : Number(item[6].value).toFixed(1)
            //     })
            // }

        })
        this.createCashFlow(listCF)
    }

    createCashFlow(listCF) {
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": 13,
            "status": "submitted",
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "cash_flow": listCF
        }
        this.props.createCashFlow(payload)
    }

    render() {
        let dataTable2 = this.state.dataTable

        const handleValueFormula = (tableMeta, colIdx) => {
            // loading = true
            // console.log(tableMeta);
            // "@44[M-1]#BS"
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []
            // console.log(splitFormula);
            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                // console.log(item);
                // console.log(items);
                // console.log(subForm);

                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (items == ']') {
                        baru.push(String(item))
                    } else if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            // console.log(baru);
            let tambahan = false
            let opet = ""
            baru.map((item, index) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (String(item).includes('[M-1]')) {
                            let tst = '@' + String(item).replace('[M-1]', '[M1]')
                            // console.log(dataTable2[tableMeta.rowIndex]);
                            // console.log(tableMeta);
                            // console.log(tst);
                            let indexID = dataTable2[tableMeta.rowIndex][6].formula.findIndex((val) => val.item_formula == tst)
                            // console.log(indexID);

                            if (indexID !== -1) {
                                let valuezz = dataTable2[tableMeta.rowIndex][6].formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                                // console.log(valuezz);
                            }
                        } else {
                            let data = tableMeta.rowData[6].formula == null ? [] : tableMeta.rowData[6].formula
                            // console.log(data)
                            let indexID = data.findIndex((val) => val.item_formula == String(`@${item}`))
                            if (indexID !== -1) {
                                let valuezz = data[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    } else {
                        if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let indexID = dataTable2.findIndex((val) => val[7] == tst)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][8]
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            let indexID = dataTable2.findIndex((val) => val[7] == item)
                            if (item == 'X-1') {
                                anjay.push(-1)
                            } else if (tambahan) {
                                if (item == '-' || item == '+' || item == '/' || item == '*') {
                                    opet = item
                                } else {
                                    anjay.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                                    tambahan = false
                                    opet = ""
                                }
                            } else {
                                if (indexID !== -1) {
                                    let valuezz = dataTable2[indexID][colIdx].value
                                    if (item == dataTable2[tableMeta.rowIndex][7]) {
                                        anjay.push(0)
                                    } else {
                                        anjay.push(valuezz == "" ? 0 : valuezz)
                                    }
                                } else {
                                    if (item === '(-1)') {
                                        anjay.push(-1)
                                    }
                                }
                            }
                        }
                    }
                }
            })



            let anjay2 = []
            let kurung = false
            let item1 = []
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                } else if (item == ")") {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    // if (index == anjay2.length - 1) {
                    //     if (opt == "tambah") {
                    //         total = Number(total) + Number(totalPrio)
                    //     } else if (opt == "kurang") {
                    //         total = Number(total) - Number(totalPrio)
                    //     } else if (opt == "kali") {
                    //         total = Number(total) * Number(totalPrio)
                    //     } else if (opt == "bagi") {
                    //         total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                    //     } else {
                    //         total += Number(totalPrio)
                    //     }
                    // }

                    // if (opt == "") {
                    //     total = Number(Number(total) + Number(totalPrio))
                    // } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                            totalPrio = 0
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                            totalPrio = 0
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                            totalPrio = 0
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            totalPrio = 0
                        }
                    // }
                    // if (tableMeta.rowData[5] == '3.2 Movement of SHL and intercompany loan (nett)') {
                    //     console.log(totalPrio)
                    //     console.log(opt)
                    //     console.log(total)
                    // }
                } else {
                    // const handleReturn = (x,y) => {
                        
                    //     return Number(totalXYZ)
                    // }
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            // total = handleReturn()
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            // total = handleReturn()
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            // total = handleReturn()
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            // total = handleReturn()
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            // if (tableMeta.rowData[5] == '3.2 Movement of SHL and intercompany loan (nett)' || tableMeta.rowData[5] == '3.6 Other') {
                // console.log(tableMeta.rowData[5])
                // console.log(splitFormula)
                // console.log(baru)
                // console.log(anjay)
                // console.log(anjay2)
                // console.log(total)
            // }

            dataTable2[tableMeta.rowIndex][6].value = total

            return total
        }


        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[0] === null ?
                                    tableMeta.rowData[4] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Actual",
                options: {
                    customHeadRender: (columnMeta) => (
                        // dataTable2.length > 0 ?
                        //     <TableCell style={{ ...style2, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96 }}>
                        //         <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        //     </TableCell> :
                        <TableCell style={{ ...style2, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({
                        style: {
                            position: "sticky",
                            background: "white",
                            zIndex: 101,
                            left: 350
                        }
                    }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                    <span style={{ fontSize: 12, textAlign: 'right' }}>
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={this.props.PLBSFAMSubmitted ? Number(tableMeta.rowData[6].value).toFixed(1) : Number(handleValueFormula(tableMeta, 6)).toFixed(1)}
                                        />
                                    </span>
                                    :
                                    tableMeta.rowData[0] === 7 ?
                                        // <span style={{ fontSize: 12, textAlign: 'right' }}>
                                        //     <NumberFormat
                                        //         thousandSeparator={true}
                                        //         style={{ color: Number(handleValueFormula(tableMeta, 6)).toFixed(1) > Number(this.state.minValue) || Number(handleValueFormula(tableMeta, 6)).toFixed(1) < Number(this.state.maxValue) ? 'red' : 'black' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //         type="text"
                                        //         placeholder=""
                                        //         disabled={true}
                                        //         value={Number(handleValueFormula(tableMeta, 6)).toFixed(1)}
                                        //     />
                                        // </span> 
                                        (Number(handleValueFormula(tableMeta, 6)).toFixed(1) > Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 6)).toFixed(1) < Number(this.state.maxValue)) ?
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{
                                                    fontSize: 12,
                                                    textAlign: 'right',
                                                    borderColor: 'transparent',
                                                    margin: 0,
                                                    width: 96,
                                                    backgroundColor: 'transparent',
                                                    color: 'black'
                                                }}
                                                type="text"
                                                placeholder=""
                                                disabled={true}
                                                value={this.props.PLBSFAMSubmitted ? Number(tableMeta.rowData[6].value).toFixed(1) : Number(handleValueFormula(tableMeta, 6)).toFixed(1)}
                                            /> :
                                            <LightTooltip title={this.state.minValue === null ? null : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{
                                                        fontSize: 12,
                                                        textAlign: 'right',
                                                        borderColor: 'transparent',
                                                        margin: 0,
                                                        width: 96,
                                                        backgroundColor: 'transparent',
                                                        color: 'red'
                                                    }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.PLBSFAMSubmitted ? Number(tableMeta.rowData[6].value).toFixed(1) : Number(handleValueFormula(tableMeta, 6)).toFixed(1)}
                                                />
                                            </LightTooltip>
                                        : null}
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                {this.state.loading && loadingComponent}
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report</Typography>
                </div>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    <Paper style={{ paddingTop: 10 }}>
                        <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                            <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Cash Flow</Typography>
                        </div>
                        <div style={{ padding: 20 }}>
                            <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                </div>
                                {/* <div style={{ width: '50%' }}>
                                    <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                        <a data-tip={'Download'} data-for="download">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() =>
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.downloadAllData()
                                                        }, 100);
                                                    })}
                                            >
                                                <img src={Images.download} />
                                            </button>
                                        </a>
                                        <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                    </div>
                                </div> */}
                            </div>

                            <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                {!this.state.loading && (
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                )}
                            </div>
                            {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.state.viewOnly &&
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                // this.state.buttonError ?
                                                //     this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                //     :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1 }, () => {
                                                        this.payloadCF(dataTable2)
                                                    })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                }
                            </div>
                        </div>
                    </Paper>
                </div>
            </div>
        );
    }
}
