import React, { Component } from 'react';
import { TextField, Typography, withStyles, Snackbar } from '@material-ui/core';
import { DatePicker } from '@material-ui/pickers';
import format from "date-fns/format";
import Autocomplete from '@material-ui/lab/Autocomplete';
import MuiAlert from '@material-ui/lab/Alert';
import api from '../../../api';
import * as R from 'ramda'
import { titleCase } from '../../../library/Utils';
import Images from '../../../assets/Images';
import Constant from '../../../library/Constant';
const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class EditReportItems extends Component {
    constructor(props) {
        super(props)
        this.state = {

            tempData: null,
            InputType: null,
            company: null,
            parent: null,
            reportType: null,
            startDate: null,
            endDate: null,
            order: null,
            description: '',
            uom: '',
            weight: "",
            formula: '',
            realVal: '',
            condition: null,
            date: new Date(),
            listInputType: null,
            listCompany: null,
            listReportType: null,
            listParent: null,
            listKPI: null,
            listMaxAch: null,
            MaxAchValue: null,
            KPIValue: null,
            errorOrder: false,
            errorDesc: false,
            errorFormula: false,
            errorRV: false,
            errorStartDate: false,
            errorEndDate: false,
            errorJenisLaporan: false,
            errorPerusahaan: false,
            msgErrorJenisLaporan: '',
            msgErrorPerusahaan: '',
            msgErrorOrder: '',
            msgErrorDesc: '',
            msgErrorFormula: '',
            errorTipeData: false,
            msgErrorTipeData: '',
            errorCondition: false,
            msgErrorCondition: '',
            msgErrorRV: '',
            msgErrorSD: '',
            msgErrorED: '',
            disabledFormula: true,
            disabledCondt: true,
            disabledValue: true,
            options: ['WARNING', 'STOPPER'],
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            kpiType: ['HIG', 'HIB'],
            maxAch: ['50%', '100%', 'Unlimited'],
            formulaYtd: ['SUM', 'AVG', 'LAST', 'FORMULA'],
            kpiTypeValue: null,
            maxAchValue: null,
            formulaYTDValue: null,
            convertible: null,
            listConvert: [
                {
                    "id": 0,
                    "value": "No"
                },
                {
                    "id": 1,
                    "value": "Yes"
                }
            ],

        }
    }

    componentDidMount() {
        this.getDetailReportItems();

    }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type === 'start_date') {
            this.setState({
                ...data, tempData: { ...this.state.tempData, start_date: format(e, 'yyyy-MM-dd'), end_date: null },
                errorOrder: false,
                errorDesc: false,
                errorFormula: false,
                errorRV: false,
                errorStartDate: false,
                errorEndDate: false,
                msgErrorOrder: '',
                msgErrorDesc: '',
                msgErrorFormula: '',
                msgErrorRV: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        } else if (isDate && type === 'end_date') {
            this.setState({
                ...data, tempData: { ...this.state.tempData, end_date: format(e, 'yyyy-MM-dd') },
                errorOrder: false,
                errorDesc: false,
                errorFormula: false,
                errorRV: false,
                errorStartDate: false,
                errorEndDate: false,
                msgErrorOrder: '',
                msgErrorDesc: '',
                msgErrorFormula: '',
                msgErrorRV: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        } else {
            this.setState({
                ...data, tempData: { ...this.state.tempData, [e.target.name]: e.target.value },
                errorOrder: false,
                errorDesc: false,
                errorFormula: false,
                errorRV: false,
                errorStartDate: false,
                errorEndDate: false,
                msgErrorOrder: '',
                msgErrorDesc: '',
                msgErrorFormula: '',
                msgErrorRV: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        }
    }

    validasi() {
        // alert('coba ya')
        if (R.isNil(this.state.reportType)) {
            this.setState({ errorJenisLaporan: true, msgErrorJenisLaporan: 'Report Type Cannot be Empty' })
        } else if (R.isNil(this.state.company)) {
            this.setState({ errorPerusahaan: true, msgErrorPerusahaan: 'Company Name Cannot be Empty' })
        } else if (R.isEmpty(this.state.tempData.order)) {
            this.setState({ errorOrder: true, msgErrorOrder: 'Order Cannot be Empty' })
        } else if (R.isEmpty(this.state.tempData.description)) {
            this.setState({ errorDesc: true, msgErrorDesc: 'Description Cannot be Empty' })
        } else if (R.isNil(this.state.InputType)) {
            this.setState({ errorTipeData: true, msgErrorTipeData: 'Data Type Cannot be Empty' })
        } else if ((this.state.InputType.type_item_report_name === 'Formula' && R.isEmpty(this.state.tempData.formula)) || (this.state.InputType.type_item_report_name === 'Validation' && R.isEmpty(this.state.tempData.formula))) {
            this.setState({ errorFormula: true, msgErrorFormula: 'Formula Cannot be Empty' })
        } else if (this.state.InputType.type_item_report_name === 'Validation' && R.isEmpty(this.state.tempData.condition_it_should_be)) {
            this.setState({ errorRV: true, msgErrorRV: 'True Value Cannot be Empty' })
        } else if (this.state.InputType.type_item_report_name === 'Validation' && R.isNil(this.state.tempData.condition_if_wrong)) {
            this.setState({ errorCondition: true, msgErrorCondition: 'False Condition Cannot be Empty' })
        } else if (R.isNil(this.state.tempData.start_date)) {
            this.setState({ errorStartDate: true, msgErrorSD: 'Valid From Cannot be Empty' })
        } else if (R.isNil(this.state.tempData.end_date)) {
            this.setState({ errorEndDate: true, msgErrorED: 'Valid To Cannot be Empty' })
        } else {
            this.updateReportItems()
        }

    }

    updateReportItems() {
        // alert('test')
        let payload = {
            "item_report_id": this.state.tempData.item_report_id,
            "report_id": this.state.reportType == null ? this.state.tempData.report_id : this.state.reportType.report_id,
            "company_id": this.state.company == null ? this.state.tempData.company_id : this.state.company.company_id,
            "description": this.state.tempData.description,
            "orders": this.state.tempData.order,
            "parent": this.state.parent == null ? null : this.state.parent.item_report_id,
            "type_report_id": this.state.InputType == null ? this.state.tempData.type_item_report_id : this.state.InputType.type_item_report_id,
            "formula": this.state.tempData.formula,
            "uom": this.state.tempData.uom,
            "weight": this.state.tempData.weight == null ? "" : this.state.tempData.weight,
            "condition_if_wrong": this.state.tempData.condition_if_wrong,
            "condition_it_should_be": this.state.tempData.condition_it_should_be,
            "type_kpi": this.state.tempData.kpi_type,
            "max_ach": this.state.tempData.max_ach,
            "formula_ytd": this.state.tempData.formula_ytd,
            "start_date": this.state.tempData.start_date,
            "end_date": this.state.tempData.end_date,
            "is_can_convert_value": this.state.convertible.id
        }
        // console.log(payload)
        this.props.updateReportItems(payload)
    }

    getDetailReportItems() {
        api.create().getDetailReportItems(this.props.data[1]).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let index = this.state.listConvert.findIndex((val) => val.id === data.is_can_convert_value)
                        this.setState({
                            tempData: response.data.data,
                            getCompanyID: data.company_id,
                            convertible: index === -1 ? null : this.state.listConvert[index]
                        }, () => this.getInputType(),
                            this.getPerusahaan(),
                            this.getReportType())
                        // console.log(this.state.convertible)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getInputType() {
        api.create().getInputType().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputData = data.map((item) => {
                            return {
                                type_item_report_id: item.type_item_report_id,
                                type_item_report_name: item.type_item_report_name
                            }
                        })
                        let defaultProps = {
                            options: inputData,
                            getOptionLabel: (option) => titleCase(option.type_item_report_name),
                        };

                        let index = inputData.findIndex((val) => val.type_item_report_id === this.state.tempData.type_item_report_id)
                        this.setState({ listInputType: defaultProps, InputType: index === -1 ? null : inputData[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getPerusahaan() {
        api.create().getPerusahaanActive().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let companyData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name
                            }
                        })
                        companyData.push({
                            company_id: 0,
                            company_name: 'Default'
                        })
                        let index = companyData.sort((a, b) => a.company_id - b.company_id).findIndex((val) => val.company_id == this.state.getCompanyID)
                        let defaultProps = {
                            options: companyData,
                            getOptionLabel: (option) => option.company_name,
                        };
                        // let index = companyData.findIndex((val) => val.company_id === this.state.tempData.company_id)
                        this.setState({ listCompany: defaultProps, companyData: response.data.data, company: index === -1 ? null : companyData[index], msgErrorPerusahaan: index === -1 ? 'Company has been Inactive.' : "", errorPerusahaan: index === -1 ? true : false }, () => {
                            this.getParent()
                            this.getKPIType()
                            this.getMaxAch()
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getKPIType() {
        let body = {
            group: 'CAT',
            company_id: this.state.company.company_id,
            type: 'KPI_TYPE'
        }
        api.create().getAllSettingByType(body).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputKPI = data.map((item) => {
                            return {
                                value: item.value
                            }
                        })
                        let defaultProps = {
                            options: inputKPI,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        let index = inputKPI.findIndex((val) => val.value === this.state.tempData.kpi_type)
                        this.setState({ listKPI: defaultProps, inputKPI: response.data.data, KPIValue: index === -1 ? null : inputKPI[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getMaxAch() {
        let body = {
            group: 'CAT',
            company_id: this.state.company.company_id,
            type: 'MAX_ACHIEVEMENT'
        }
        api.create().getAllSettingByType(body).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputMaxAch = data.map((item) => {
                            return {
                                value: item.value
                            }
                        })
                        let defaultProps = {
                            options: inputMaxAch,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        let index = inputMaxAch.findIndex((val) => val.value === this.state.tempData.max_ach)
                        this.setState({ listMaxAch: defaultProps, inputMaxAch: response.data.data, MaxAchValue: index === -1 ? null : inputMaxAch[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getReportType() {
        api.create().getReportType().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let reportTypeData = data.map((item) => {
                            return {
                                report_id: item.report_id,
                                report_name: item.report_name,
                            }
                        })
                        let defaultProps = {
                            options: reportTypeData,
                            getOptionLabel: (option) => titleCase(option.report_name),
                        };

                        let index = reportTypeData.findIndex((val) => val.report_id === this.state.tempData.report_id)
                        this.setState({ listReportType: defaultProps, reportType: index === -1 ? null : reportTypeData[index] }, () => this.getParent())
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getParent() {
        if (this.state.reportType !== null && this.state.company !== null) {
            // console.log(this.state.tempData.item_report_id)
            let payload = {
                "report_id": this.state.reportType.report_id,
                "company_id": this.state.company.company_id
            }
            api.create().getReportParent(payload).then((response) => {
                // console.log(response)
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === 'success') {
                            let data = response.data.data
                            let currentIndex = null
                            let parentData = data.map((item, index) => {
                                if (this.state.tempData.item_report_id !== item.item_report_id) {
                                    return {
                                        item_report_id: item.item_report_id,
                                        description: item.description
                                    }
                                } else {
                                    currentIndex = index
                                }
                            })
                            if (currentIndex !== null) {
                                parentData.splice(currentIndex, 1)
                            }
                            // console.log(parentData)
                            let defaultProps = {
                                options: parentData,
                                getOptionLabel: (option) => titleCase(option.description),
                            };
                            let index = parentData.findIndex((val) => val.item_report_id === this.state.tempData.parent)
                            this.setState({ listParent: defaultProps, parent: index == -1 ? null : parentData[index] })
                        } else {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                                if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                    setTimeout(() => {
                                        localStorage.removeItem(Constant.TOKEN)
                                        window.location.reload();
                                    }, 1000);
                                }
                            })
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
                }
            })
        }
    }

    clearMessage() {
        this.setState({
            errorFormula: false, msgErrorFormula: '',
            errorTipeData: false, msgErrorTipeData: '',
            errorCondition: false, msgErrorCondition: '',
            errorRV: false, msgErrorRV: '',
            errorJenisLaporan: false, msgErrorJenisLaporan: '',
            errorPerusahaan: false, msgErrorPerusahaan: ''
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {

        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Edit Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>
                    <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                        <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                            {this.state.messageAlert}
                        </Alert>
                    </Snackbar>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.tempData === null ? '' : this.state.tempData.item_report_id}
                                    id="ID"
                                    label="ID"
                                    disabled
                                    onChange={(e) => null}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10 }}>
                                <Autocomplete
                                    {...this.state.listReportType}
                                    id="reportType"
                                    onChange={(event, newInputValue) => this.setState({ reportType: newInputValue }, () =>
                                        newInputValue == null || (newInputValue.report_name !== 'CAT') ? this.setState({ tempData: { ...this.state.tempData, kpi_type: null, max_ach: null, formula_ytd: null } }, () => this.getParent(), this.clearMessage())
                                            : this.getParent(), this.clearMessage()
                                    )}
                                    debug
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Report Type"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            error={this.state.errorJenisLaporan}
                                            helperText={this.state.msgErrorJenisLaporan}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.reportType}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10 }} >
                                <Autocomplete
                                    {...this.state.listCompany}
                                    id="company"
                                    onChange={(event, newInputValue) => this.setState({ company: newInputValue }, () => this.getParent(), this.clearMessage())}
                                    debug
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Company Name"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            error={this.state.errorPerusahaan}
                                            helperText={this.state.msgErrorPerusahaan}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.company}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="order"
                                    label="Order"
                                    name="order"
                                    type="number"
                                    value={this.state.tempData === null ? '' : this.state.tempData.order}
                                    error={this.state.errorOrder}
                                    helperText={this.state.msgErrorOrder}
                                    onChange={(e) => this.handleChange(e, '')}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="description"
                                    label="Description"
                                    name="description"
                                    error={this.state.errorDesc}
                                    helperText={this.state.msgErrorDesc}
                                    onChange={(e) => this.handleChange(e, '')}
                                    value={this.state.tempData === null ? '' : this.state.tempData.description}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10 }} >
                                <Autocomplete
                                    {...this.state.listParent}
                                    id="parentId"
                                    onChange={(event, newInputValue) => this.setState({ parent: newInputValue })}
                                    disabled={this.state.reportType == null || this.state.company == null}
                                    debug
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Parent ID"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.parent}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="uom"
                                    label="UOM"
                                    name="uom"
                                    onChange={(e) => this.handleChange(e, '')}
                                    value={this.state.tempData === null ? '' : this.state.tempData.uom}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="weight"
                                    label="Weight"
                                    name="weight"
                                    onChange={(e) => this.handleChange(e, '')}
                                    value={this.state.tempData === null ? '' : this.state.tempData.weight}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10 }}>
                                <Autocomplete
                                    {...this.state.listInputType}
                                    id="inputType"
                                    onChange={(event, newInputValue) =>
                                        this.setState({
                                            InputType: newInputValue,
                                            tempData: { ...this.state.tempData, formula: '', condition_it_should_be: '', condition_if_wrong: '' },
                                        },
                                            () => console.log(this.state.InputType), this.clearMessage())}
                                    debug
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Data Type"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            error={this.state.errorTipeData}
                                            helperText={this.state.msgErrorTipeData}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.InputType}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="formula"
                                    label="Formula"
                                    disabled={this.state.InputType == null ? true : (this.state.InputType.type_item_report_name === 'Formula' || this.state.InputType.type_item_report_name === 'Validation' || this.state.InputType.type_item_report_name === 'Formula - Summary' ? false : true)}
                                    name="formula"
                                    error={this.state.errorFormula}
                                    helperText={this.state.msgErrorFormula}
                                    onChange={(e) => this.handleChange(e, '')}
                                    value={this.state.tempData === null ? '' : this.state.tempData.formula}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="condition_it_should_be"
                                    label="True Value"
                                    error={this.state.errorRV}
                                    helperText={this.state.msgErrorRV}
                                    disabled={this.state.InputType == null ? true : (this.state.InputType.type_item_report_name === 'Validation' ? false : true)}
                                    name="condition_it_should_be"
                                    onChange={(e) => this.handleChange(e, '')}
                                    value={this.state.tempData === null ? '' : this.state.tempData.condition_it_should_be}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10 }}>
                                <Autocomplete
                                    value={this.state.tempData === null ? "" : this.state.tempData.condition_if_wrong}
                                    id="isWrongCondition"
                                    disabled={this.state.InputType == null ? true : (this.state.InputType.type_item_report_name === 'Validation' ? false : true)}
                                    onChange={(event, newValue) => {
                                        this.setState({ tempData: { ...this.state.tempData, condition_if_wrong: newValue } }, () => this.clearMessage());
                                    }}
                                    options={this.state.options}
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="False Condition"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            error={this.state.errorCondition}
                                            helperText={this.state.msgErrorCondition}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                />
                            </div>
                        </div>
                    </div>

                    {this.state.reportType !== null && (
                        this.state.reportType.report_name === 'CAT' && (
                            <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1">
                                    <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            {...this.state.listKPI}
                                            value={this.state.KPIValue}
                                            id="kpiType"
                                            onChange={(event, newValue) => {
                                                this.setState({ tempData: { ...this.state.tempData, kpi_type: newValue.value }, KPIValue: newValue }, () => this.clearMessage());
                                            }}
                                            renderInput={(params) =>
                                                <TextField {...params}
                                                    label="KPI Type"
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            fontFamily: 'Nunito Sans, sans-serif',
                                                            color: '#7e8085'
                                                        }
                                                    }}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                                />}
                                        />
                                    </div>
                                </div>
                                <div className="column-2">
                                    <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            {...this.state.listMaxAch}
                                            value={this.state.MaxAchValue}
                                            id="maxAch"
                                            onChange={(event, newValue) => {
                                                this.setState({ tempData: { ...this.state.tempData, max_ach: newValue.value }, MaxAchValue: newValue }, () => this.clearMessage());
                                            }}
                                            renderInput={(params) =>
                                                <TextField {...params}
                                                    label="Max Achievement"
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            fontFamily: 'Nunito Sans, sans-serif',
                                                            color: '#7e8085'
                                                        }
                                                    }}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                                />}
                                        />
                                    </div>
                                </div>
                            </div>
                        ))}

                    {this.state.reportType !== null && (
                        this.state.reportType.report_name === 'CAT' && (
                            <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1">
                                    <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            value={this.state.tempData === null ? "" : this.state.tempData.formula_ytd}
                                            id="kpiType"
                                            onChange={(event, newValue) => {
                                                this.setState({ tempData: { ...this.state.tempData, formula_ytd: newValue } }, () => this.clearMessage());
                                            }}
                                            options={this.state.formulaYtd}
                                            renderInput={(params) =>
                                                <TextField {...params}
                                                    label="Formula YTD"
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            fontFamily: 'Nunito Sans, sans-serif',
                                                            color: '#7e8085'
                                                        }
                                                    }}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                                />}
                                        />
                                    </div>
                                </div>
                            </div>
                        ))}

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.tempData === null ? null : this.state.tempData.start_date}
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorSD}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085',
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    value={this.state.tempData === null ? null : this.state.tempData.end_date}
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorED}
                                    minDate={this.state.tempData === null ? null : this.state.tempData.start_date}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085',
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    debug
                                    id="tipe"
                                    options={this.state.listConvert}
                                    getOptionLabel={(option) => option.value}
                                    value={this.state.convertible}
                                    onChange={(event, newInputValue) => this.setState({ convertible: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            label="Convertible"
                                            margin="normal"
                                            style={{ marginTop: 7 }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                        />
                                    }

                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.tempData === null ? '' : this.state.tempData.status}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif'
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>
                    </div>
                    <div className="margin-top-10px" style={{ paddingTop: 10, paddingBottom: 30, paddingRight: 30, paddingLeft: 30 }}>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Created By</Typography>
                            <Typography style={{ fontSize: 11 }}>:  {this.state.tempData === null ? "" : this.state.tempData.created}</Typography>
                        </div>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Updated By</Typography>
                            <Typography style={{ fontSize: 11 }}>:  {this.state.tempData === null ? "" : this.state.tempData.updated}</Typography>
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button onClick={() => this.validasi()}>
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        )
    }
}
