import React, { Component } from 'react';
import { TextField, Typography, Snackbar, withStyles } from '@material-ui/core';
import * as R from 'ramda';
import api from '../../../api';
import Autocomplete from '@material-ui/lab/Autocomplete';
import { titleCase } from '../../../library/Utils';
import format from "date-fns/format";
import { DatePicker } from '@material-ui/pickers';
import Images from '../../../assets/Images';
import MuiAlert from '@material-ui/lab/Alert';
import Constant from '../../../library/Constant';
const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class CreateReportItems extends Component {
    constructor(props) {
        super(props)
        this.state = {
            InputType: null,
            company: null,
            parent: null,
            reportType: null,
            startDate: null,
            endDate: null,
            order: '',
            description: '',
            uom: '',
            weight: '',
            formula: '',
            formulasum: '',
            realVal: '',
            condition: null,
            date: new Date(),
            listInputType: null,
            listCompany: null,
            listReportType: null,
            listParent: null,
            listKPI: null,
            listMaxAch: null,
            errorOrder: false,
            errorDesc: false,
            errorFormula: false,
            errorRV: false,
            errorStartDate: false,
            errorEndDate: false,
            errorTipeData: false,
            errorCondition: false,
            errorJenisLaporan: false,
            errorPerusahaan: false,
            msgErrorJenisLaporan: '',
            msgErrorPerusahaan: '',
            msgErrorTipeData: '',
            msgErrorCondition: '',
            msgErrorOrder: '',
            msgErrorDesc: '',
            msgErrorFormula: '',
            msgErrorRV: '',
            msgErrorSD: '',
            msgErrorED: '',
            disabledFormula: true,
            disabledFormulaSum: true,
            disabledCondt: true,
            disabledValue: true,
            options: ['WARNING', 'STOPPER'],
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            kpiType: ['HIG', 'HIB'],
            maxAch: ['50%', '100%', 'Unlimited'],
            formulaYtd: ['SUM', 'AVG', 'LAST', 'FORMULA'],
            kpiTypeValue: null,
            maxAchValue: null,
            formulaYTDValue: null,
            kpiDisable: true,
            maxAchDisable: true,
            convertible: null,
            listConvert: [
                {
                    "id": 0,
                    "value": "No"
                },
                {
                    "id": 1,
                    "value": "Yes"
                }
            ],
        }
    }

    componentDidMount() {
        this.getInputType()
        this.getPerusahaan()
        this.getReportType()
        // this.getParent()
        let date = format(new Date, 'yyyy-MM-dd')
        // console.log(date);
        this.setState({
            startDate: date,
            endDate: date
        })
    }


    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type === 'start_date') {
            this.setState({
                ...data, startDate: format(e, 'yyyy-MM-dd'), endDate: null,
                errorOrder: false,
                errorDesc: false,
                errorFormula: false,
                errorRV: false,
                errorStartDate: false,
                errorEndDate: false,
                errorTipeData: false,
                errorCondition: false,
                msgErrorTipeData: '',
                msgErrorCondition: '',
                msgErrorOrder: '',
                msgErrorDesc: '',
                msgErrorFormula: '',
                msgErrorRV: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        } else if (isDate && type === 'end_date') {
            this.setState({
                ...data, endDate: format(e, 'yyyy-MM-dd'),
                errorOrder: false,
                errorDesc: false,
                errorFormula: false,
                errorRV: false,
                errorStartDate: false,
                errorEndDate: false,
                errorTipeData: false,
                errorCondition: false,
                msgErrorTipeData: '',
                msgErrorCondition: '',
                msgErrorOrder: '',
                msgErrorDesc: '',
                msgErrorFormula: '',
                msgErrorRV: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        } else {
            this.setState({
                ...data, [e.target.name]: e.target.value,
                errorOrder: false,
                errorDesc: false,
                errorFormula: false,
                errorRV: false,
                errorStartDate: false,
                errorEndDate: false,
                errorTipeData: false,
                errorCondition: false,
                msgErrorTipeData: '',
                msgErrorCondition: '',
                msgErrorOrder: '',
                msgErrorDesc: '',
                msgErrorFormula: '',
                msgErrorRV: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        }
    }

    validasi() {
        // alert('coba ya')
        if (R.isNil(this.state.reportType)) {
            this.setState({ errorJenisLaporan: true, msgErrorJenisLaporan: 'Report Type Cannot be Empty' })
        } else if (R.isNil(this.state.company)) {
            this.setState({ errorPerusahaan: true, msgErrorPerusahaan: 'Company Name Cannot be Empty' })
        } else if (R.isEmpty(this.state.order)) {
            this.setState({ errorOrder: true, msgErrorOrder: 'Order Cannot be Empty' })
        }
        else if (R.isEmpty(this.state.description)) {
            this.setState({ errorDesc: true, msgErrorDesc: 'Description Cannot be Empty' })
        }
        else if (R.isNil(this.state.InputType)) {
            this.setState({ errorTipeData: true, msgErrorTipeData: 'Data Type Cannot be Empty' })
        }
        else if (this.state.disabledFormula === false && R.isEmpty(this.state.formula)) {
            this.setState({ errorFormula: true, msgErrorFormula: 'Formula Cannot be Empty' })
        }
        else if (this.state.disabledValue === false && R.isEmpty(this.state.realVal)) {
            this.setState({ errorRV: true, msgErrorRV: 'True Value Cannot be Empty' })
        }
        else if (this.state.disabledCondt === false && R.isEmpty(this.state.condition)) {
            this.setState({ errorCondition: true, msgErrorCondition: 'False Condition Cannot be Empty' })
        }
        else if (R.isNil(this.state.startDate)) {
            this.setState({ errorStartDate: true, msgErrorSD: 'Valid From Cannot be Empty' })
        }
        else if (R.isNil(this.state.endDate)) {
            this.setState({ errorEndDate: true, msgErrorED: 'Valid To Cannot be Empty' })
        }
        else {
            this.addReportItems()
        }
    }

    addReportItems() {
        // alert("test")
        let payload = {
            "report_id": this.state.reportType.report_id,
            "company_id": this.state.company.company_id,
            "description": this.state.description,
            "orders": this.state.order,
            "parent": this.state.parent === null ? null : this.state.parent.item_report_id,
            "type_report_id": this.state.InputType.type_item_report_id,
            "formula": this.state.formula,
            "uom": this.state.uom,
            "weight": this.state.weight,
            "condition_if_wrong": this.state.condition,
            "condition_it_should_be": this.state.realVal,
            "type_kpi": this.state.kpiTypeValue ? this.state.kpiTypeValue.value : null,
            "max_ach": this.state.maxAchValue ? this.state.maxAchValue.value : null,
            "formula_ytd": this.state.formulaYTDValue,
            "start_date": this.state.startDate,
            "end_date": this.state.endDate,
            "is_can_convert_value": this.state.convertible.id
        }
        // console.log(payload)
        this.props.createReportItems(payload)
    }

    getKPIType() {
        let body = {
            group: 'CAT',
            company_id: this.state.company.company_id,
            type: 'KPI_TYPE'
        }
        api.create().getAllSettingByType(body).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputKPI = data.map((item) => {
                            return {
                                value: item.value
                            }
                        })
                        let defaultProps = {
                            options: inputKPI,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        this.setState({ listKPI: defaultProps, inputKPI: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getMaxAch() {
        let body = {
            group: 'CAT',
            company_id: this.state.company.company_id,
            type: 'MAX_ACHIEVEMENT'
        }
        api.create().getAllSettingByType(body).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputMaxAch = data.map((item) => {
                            return {
                                value: item.value
                            }
                        })
                        let defaultProps = {
                            options: inputMaxAch,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        this.setState({ listMaxAch: defaultProps, inputMaxAch: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getInputType() {
        api.create().getInputType().then((response) => {
            // console.log(response.data)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputData = data.map((item) => {
                            return {
                                type_item_report_id: item.type_item_report_id,
                                type_item_report_name: item.type_item_report_name
                            }
                        })
                        let defaultProps = {
                            options: inputData,
                            getOptionLabel: (option) => titleCase(option.type_item_report_name),
                        };
                        this.setState({ listInputType: defaultProps, inputData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getPerusahaan() {
        api.create().getPerusahaanActive().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let companyData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name
                            }
                        })
                        companyData.push({
                            company_id: 0,
                            company_name: 'Default'
                        })
                        let typeProps = {
                            options: companyData.sort((a, b) => a.company_id - b.company_id),
                            getOptionLabel: (option) => option.company_name,
                        };
                        this.setState({ listCompany: typeProps, companyData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getReportType() {
        api.create().getReportType().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let reportTypeData = data.map((item) => {
                            return {
                                report_id: item.report_id,
                                report_name: item.report_name,
                            }
                        })
                        let defaultProps = {
                            options: reportTypeData,
                            getOptionLabel: (option) => titleCase(option.report_name),
                        };
                        this.setState({ listReportType: defaultProps, reportTypeData: response.data.data })
                    } else {
                        // alert(response.data.message)
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getParent() {
        if (this.state.reportType !== null && this.state.company !== null) {
            let payload = {
                "report_id": this.state.reportType.report_id,
                "company_id": this.state.company.company_id
            }
            api.create().getReportParent(payload).then((response) => {
                // console.log(response)
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === 'success') {
                            let data = response.data.data
                            let parentData = data.map((item) => {
                                return {
                                    item_report_id: item.item_report_id,
                                    description: item.description
                                }
                            })
                            let defaultProps = {
                                options: parentData,
                                getOptionLabel: (option) => titleCase(option.description),
                            };
                            this.setState({ listParent: defaultProps, parentData: response.data.data })
                        } else {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                                if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                    setTimeout(() => {
                                        localStorage.removeItem(Constant.TOKEN)
                                        window.location.reload();
                                    }, 1000);
                                }
                            })
                            // alert(response.data.message)
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
                }
            })
        }
    }

    handleDate(item) {
        let value = format(item, 'dd MMMM yyyy')
        return value
    }

    clearMessage() {
        this.setState({
            errorFormula: false, msgErrorFormula: '',
            errorTipeData: false,
            errorCondition: false,
            msgErrorTipeData: '',
            msgErrorCondition: '',
            errorRV: false, msgErrorRV: '',
            errorJenisLaporan: false, msgErrorJenisLaporan: '',
            errorPerusahaan: false, msgErrorPerusahaan: ''
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {

        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Create Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>
                    <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                        <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                            {this.state.messageAlert}
                        </Alert>
                    </Snackbar>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={'-'}
                                    id="ID"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.listReportType}
                                    id="reportType"
                                    onChange={(event, newInputValue) => this.setState({ reportType: newInputValue, kpiDisable: true, maxAchDisable: true }, () => {
                                        newInputValue == null || (newInputValue.report_name !== 'CAT') ? this.setState({ kpiTypeValue: null, maxAchValue: null, formulaYTDValue: null }, () => this.clearMessage())
                                            : this.clearMessage();
                                    })}
                                    debug
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Report Type"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            error={this.state.errorJenisLaporan}
                                            helperText={this.state.msgErrorJenisLaporan}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.reportType}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }} >
                                <Autocomplete
                                    {...this.state.listCompany}
                                    id="company"
                                    onChange={(event, newInputValue) => this.setState({ company: newInputValue, kpiDisable: false, maxAchDisable: false }, () => {
                                        this.getParent()
                                        this.clearMessage()
                                        this.getKPIType()
                                        this.getMaxAch()
                                    })}
                                    debug
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Company Name"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            error={this.state.errorPerusahaan}
                                            helperText={this.state.msgErrorPerusahaan}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.company}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="orders"
                                    name="order"
                                    label="Order"
                                    type="number"
                                    onChange={(e) => this.handleChange(e, null)}
                                    value={this.state.order}
                                    error={this.state.errorOrder}
                                    helperText={this.state.msgErrorOrder}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="description"
                                    label="Description"
                                    name="description"
                                    value={this.state.description}
                                    error={this.state.errorDesc}
                                    helperText={this.state.msgErrorDesc}
                                    onChange={(e) => this.handleChange(e, '')}
                                    // value={this.props.data.business_unit_name}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }} >
                                <Autocomplete
                                    {...this.state.listParent}
                                    id="parentId"
                                    onChange={(event, newInputValue) => this.setState({ parent: newInputValue })}
                                    debug
                                    disabled={this.state.reportType == null || this.state.company == null}
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Parent ID"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.parent}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="uom"
                                    name="uom"
                                    label="UOM"
                                    value={this.state.uom}
                                    onChange={(e) => this.handleChange(e, '')}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="weight"
                                    label="Weight"
                                    name="weight"
                                    value={this.state.weight}
                                    onChange={(e) => this.handleChange(e, '')}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.listInputType}
                                    id="inputType"
                                    onChange={(event, newInputValue) => this.setState({ InputType: newInputValue },
                                        () => newInputValue === null ? this.setState({ disabledFormula: true, disabledCondt: true, disabledValue: true, formula: '', condition: '', realVal: '' })
                                            : newInputValue.type_item_report_name === 'Formula' ?
                                                this.setState({
                                                    disabledFormula: false,
                                                    disabledCondt: true,
                                                    disabledValue: true,
                                                    formula: '',
                                                    condition: '',
                                                    realVal: ''
                                                }, () => this.clearMessage())
                                                : newInputValue.type_item_report_name === 'Validation' ?
                                                    this.setState({
                                                        disabledFormula: false,
                                                        disabledCondt: false,
                                                        disabledValue: false,
                                                        formula: '',
                                                        condition: '',
                                                        realVal: ''
                                                    }, () => this.clearMessage())
                                                    : newInputValue.type_item_report_name === 'Formula - Summary' ?
                                                    this.setState({
                                                        disabledFormula: false,
                                                        disabledCondt: true,
                                                        disabledValue: true,
                                                        formula: '',
                                                        condition: '',
                                                        realVal: ''
                                                    }, () => this.clearMessage())
                                                    : this.setState({
                                                        disabledFormula: true,
                                                        disabledCondt: true,
                                                        disabledValue: true,
                                                        formula: '',
                                                        condition: '',
                                                        realVal: ''
                                                    }, () => this.clearMessage())
                                    )}
                                    debug
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            label="Data Type"
                                            error={this.state.errorTipeData}
                                            helperText={this.state.msgErrorTipeData}
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            error={this.state.errorTipeData}
                                            helperText={this.state.msgErrorTipeData}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                    value={this.state.InputType}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="formula"
                                    label="Formula"
                                    name="formula"
                                    disabled={this.state.disabledFormula}
                                    value={this.state.formula}
                                    error={this.state.errorFormula}
                                    helperText={this.state.msgErrorFormula}
                                    onChange={(e) => this.handleChange(e, '')}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="realVal"
                                    label="True Value"
                                    name="realVal"
                                    disabled={this.state.disabledValue}
                                    value={this.state.realVal}
                                    error={this.state.errorRV}
                                    helperText={this.state.msgErrorRV}
                                    onChange={(e) => this.handleChange(e, '')}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    value={this.state.condition}
                                    id="isWrongCondition"
                                    disabled={this.state.disabledCondt}
                                    onChange={(event, newValue) => {
                                        this.setState({ condition: newValue }, () => this.clearMessage());
                                    }}
                                    options={this.state.options}
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            error={this.state.errorCondition}
                                            helperText={this.state.msgErrorCondition}
                                            label="False Condition"
                                            InputLabelProps={{
                                                style: {
                                                    fontSize: 11,
                                                    fontFamily: 'Nunito Sans, sans-serif',
                                                    color: '#7e8085'
                                                }
                                            }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                        />}
                                />
                            </div>
                        </div>
                    </div>

                    {this.state.reportType !== null && (
                        this.state.reportType.report_name === 'CAT' && (
                            <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1">
                                    <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            {...this.state.listKPI}
                                            value={this.state.kpiTypeValue}
                                            id="kpiType"
                                            onChange={(event, newValue) => {
                                                this.setState({ kpiTypeValue: newValue }, () => this.clearMessage());
                                            }}
                                            disabled={this.state.kpiDisable}
                                            renderInput={(params) =>
                                                <TextField {...params}
                                                    label="KPI Type"
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            fontFamily: 'Nunito Sans, sans-serif',
                                                            color: '#7e8085'
                                                        }
                                                    }}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                                />}
                                        />
                                    </div>
                                </div>
                                <div className="column-2">
                                    <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            {...this.state.listMaxAch}
                                            value={this.state.maxAchValue}
                                            id="maxAch"
                                            onChange={(event, newValue) => {
                                                this.setState({ maxAchValue: newValue }, () => this.clearMessage());
                                            }}
                                            disabled={this.state.maxAchDisable}
                                            renderInput={(params) =>
                                                <TextField {...params}
                                                    label="Max Achievement"
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            fontFamily: 'Nunito Sans, sans-serif',
                                                            color: '#7e8085'
                                                        }
                                                    }}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                                />}
                                        />
                                    </div>
                                </div>
                            </div>
                        ))}

                    {this.state.reportType !== null && (
                        this.state.reportType.report_name === 'CAT' && (
                            <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                                <div className="column-1">
                                    <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                        <Autocomplete
                                            value={this.state.formulaYTDValue}
                                            id="formulaYTD"
                                            onChange={(event, newValue) => {
                                                this.setState({ formulaYTDValue: newValue }, () => this.clearMessage());
                                            }}
                                            options={this.state.formulaYtd}
                                            renderInput={(params) =>
                                                <TextField {...params}
                                                    label="Formula YTD"
                                                    InputLabelProps={{
                                                        style: {
                                                            fontSize: 11,
                                                            fontFamily: 'Nunito Sans, sans-serif',
                                                            color: '#7e8085'
                                                        }
                                                    }}
                                                    InputProps={{ ...params.InputProps, style: { fontSize: 11, fontFamily: 'Nunito Sans, sans-serif' } }}
                                                />}
                                        />
                                    </div>
                                </div>
                            </div>
                        ))}

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.startDate == "" ? null : this.state.startDate}
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorSD}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085',
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                        <div className="column-2">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    value={this.state.endDate == "" ? null : this.state.endDate}
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorED}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    minDate={this.state.startDate}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085',
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    debug
                                    id="tipe"
                                    options={this.state.listConvert}
                                    getOptionLabel={(option) => option.value}
                                    onChange={(event, newInputValue) => this.setState({ convertible: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            label="Convertible"
                                            margin="normal"
                                            style={{ marginTop: 7 }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                        />
                                    }

                                />
                            </div>
                        </div>
                        <div className="column-2" style={{ marginTop: 7}}>
                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    defaultValue={"active"}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="margin-top-10px" style={{ paddingTop: 10, paddingBottom: 30, paddingRight: 30, paddingLeft: 30 }}>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '13%' }}>Created By :</Typography>
                            {/* <Typography style={{ fontSize: 11 }}>: </Typography> */}
                        </div>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '13%' }}>Updated By :</Typography>
                            {/* <Typography style={{ fontSize: 11 }}>: </Typography> */}
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasi()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        )
    }
}
