import React, { Component } from 'react';
import { TextField, Typography, withStyles, Snackbar } from '@material-ui/core';
import * as R from 'ramda';
import { DatePicker } from "@material-ui/pickers";
import format from "date-fns/format";
import Autocomplete from '@material-ui/lab/Autocomplete';
import MuiAlert from '@material-ui/lab/Alert';
import api from '../../../api';
import Images from '../../../assets/Images';
import Constant from '../../../library/Constant';
import { DataUsage } from '@material-ui/icons';

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class CreatePerusahaan extends Component {
    constructor(props) {
        super(props)
        this.state = {
            id: '',
            company: '',
            companyID: '',
            parentCompany: '',
            unitBisnis: '',
            totalReport: '',
            startDate: '',
            endDate: '',
            status: '',
            types: null,
            dataCurrency: [],
            currency: [],
            currencies: [],
            defaultCurrency: null,
            getTypes: null,
            perusahaan: null,
            getPerusahaan: null,
            errorNP: false,
            errorPC: false,
            errorSD: false,
            errorED: false,
            errorJL: false,
            errorUB: false,
            errorCur: false,
            errorDefCur: false,
            msgErrorNP: '',
            msgErrorPC: '',
            msgErrorSD: '',
            msgErrorED: '',
            msgErrorJL: '',
            msgErrorUB: '',
            msgErrorCur: '',
            msgErrorDefCur: '',
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            optionCurrecy: []
        }
    }

    render() {
        let { type } = this.props
        return type === 'edit' ? this.renderEdit() : this.renderCreate()
    }

    componentDidMount() {
        if (this.props.type === 'edit') {
            this.getDetailPerusahaan()
            this.getListCurrency()
            // console.log(this.props.data);
        } else {
            this.getCompanyActive()
            this.getAllUnitBisnis()
            this.getListCurrency()
            let date = format(new Date, 'yyyy-MM-dd')
            // console.log(date);
            this.setState({
                startDate: date,
                endDate: date
            })
        }
    }

    getDetailPerusahaan() {
        api.create().getDetailPerusahaan(this.props.data[1]).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        let datas = []
                        if (response.data.data.currency.length > 0) {
                            response.data.data.currency.map((item) => {
                                console.log(item);
                                datas.push({
                                    id: item.currencyId,
                                    value: item.currencyName
                                })

                            })
                            // console.log(response.data.data.default_currency, datas);
                        }
                        let index = datas.findIndex((val) => val.id == response.data.data.default_currency)
                        let findIdx = datas.findIndex(e => e.id === 2)
                        let bizpar = findIdx >= 0 ? datas.filter(e => e.id === 2) : datas
                        console.log(bizpar);
                        this.setState({
                            businessID: response.data.data.business_unit_id,
                            companyID: response.data.data.company_id,
                            status: response.data.data.status,
                            company: response.data.data.company_name,
                            parentID: response.data.data.parent,
                            parent: response.data.data.parent_name,
                            startDate: response.data.data.start_date,
                            endDate: response.data.data.end_date,
                            totalReport: response.data.data.total_report,
                            created: response.data.data.created,
                            updated: response.data.data.updated === null ? "" : response.data.data.updated,
                            defaultCurrencyID: response.data.data.default_currency,
                            currency: datas,
                            defaultCurrency: index == -1 ? null : datas[index],
                            optionCurrecy: bizpar,
                        }, () => {
                            // setTimeout(() => {
                            this.getAllUnitBisnis()
                            this.getCompanyActive()
                            // }, 1000);
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getCompanyActive() {
        console.log(this.state.company)
        if (this.state.company !== null) {
            console.log(this.state.company)
            let payload = {
                "company_id": this.state.company.company_id
            }
            api.create().getPerusahaanActive(payload).then(response => {
                console.log(response)
                if (response.data) {
                    if (response.ok) {
                        if (response.data.status === 'success') {
                            let data = response.data.data
                            let currentIndex = null
                            let perusahaanData = data.map((item, index) => {
                                if (this.state.companyID !== item.company_id) {
                                    return {
                                        company_id: item.company_id,
                                        company_name: item.company_name
                                    }
                                } else {
                                    currentIndex = index
                                }
                            })
                            if (currentIndex !== null) {
                                perusahaanData.splice(currentIndex, 1)
                            }
                            let index = perusahaanData.sort((a, b) => a.company_id - b.company_id).findIndex((val) => val.company_id == this.state.parentID)
                            let typeProps = {
                                options: perusahaanData,
                                getOptionLabel: (option) => option.company_name,
                            };
                            if (this.props.type === 'edit') {
                                this.setState({ perusahaan: typeProps, perusahaanData: response.data.data, getPerusahaan: index == -1 ? null : perusahaanData[index], msgErrorPC: index === -1 ? 'Company has been Inactive' : "", errorPC: index === -1 ? true : false })
                            } else {
                                this.setState({ perusahaan: typeProps, perusahaanData: response.data.data, getPerusahaan: index == -1 ? null : perusahaanData[index] })
                            }
                        } else {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                                if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                    setTimeout(() => {
                                        localStorage.removeItem(Constant.TOKEN)
                                        window.location.reload();
                                    }, 1000);
                                }
                            })
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
                }
            })
        }
    }

    getAllUnitBisnis() {
        api.create().getUnitBisnisActive().then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                business_unit_id: item.business_unit_id,
                                business_unit_name: item.business_unit_name
                            }
                        })
                        console.log(typeData)
                        let index = typeData.findIndex((val) => val.business_unit_id == this.state.businessID)
                        console.log(index)
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.business_unit_name,
                        };
                        if (this.props.type === 'edit') {
                            this.setState({ types: typeProps, typeData: response.data.data, getTypes: index == -1 ? null : typeData[index], msgErrorUB: index === -1 ? 'Business Unit has been Inactive' : "", errorUB: index === -1 ? true : false })
                        } else {
                            this.setState({ types: typeProps, typeData: response.data.data, getTypes: index == -1 ? null : typeData[index] })
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getListCurrency() {
        api.create().getDataCurrency().then(response => {
            console.log(response);
            if (response.data) {
                let arrayCurrency = []
                response.data.data.map(item => {
                    arrayCurrency.push({
                        id: item.currency_id,
                        value: item.currency_name
                    })
                })
                this.setState({ dataCurrency: arrayCurrency })
            }
        })
    }

    // getParentCompany() {
    //     api.create().getPerusahaanActive().then((response) => {
    //         if (response.data.status === 'success') {
    //             let data = response.data.data
    //             let typeData = data.map((item) => {
    //                 return {
    //                     company_id: item.company_id,
    //                     company_name: item.company_name
    //                 }
    //             })
    //             let typeProps = {
    //                 options: typeData.sort((a, b) => a.company_id - b.company_id),
    //                 getOptionLabel: (option) => option.company_name,
    //             };
    //             this.setState({ perusahaan: typeProps, perusahaanData: response.data.data })
    //         } else {
    //             alert(response.data.message)
    //         }
    //     })
    // }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({ startDate: format(e, 'yyyy-MM-dd'), endDate: null }, () => {
                this.clearError()
                console.log(this.state.startDate)
            })
        } else if (isDate && type == 'end_date') {
            this.setState({ endDate: format(e, 'yyyy-MM-dd') }, () => {
                this.clearError()
                console.log(this.state.endDate)
            })
        } else {
            // this.setState({...data, tempData: {...this.state.tempData, [e.target.name] :  e.target.value}})
        }

    }

    clearError() {
        this.setState({
            errorNP: false,
            errorPC: false,
            errorSD: false,
            errorED: false,
            errorJL: false,
            errorUB: false,
            errorCur: false,
            errorDefCur: false,
            msgErrorNP: '',
            msgErrorPC: '',
            msgErrorSD: '',
            msgErrorED: '',
            msgErrorJL: '',
            msgErrorUB: '',
            msgErrorCur: '',
            msgErrorDefCur: ''
        })
    }

    validasiEdit() {
        if (R.isEmpty(this.state.company)) {
            this.setState({ errorNP: true, msgErrorNP: 'Company Name Cannot be Empty' })
        } else if (R.isNil(this.state.getTypes)) {
            this.setState({ errorUB: true, msgErrorUB: 'Business Unit Cannot be Empty' })
        } else if (R.isNil(this.state.getPerusahaan)) {
            this.setState({ errorPC: true, msgErrorPC: 'Parent Company Cannot be Empty' })
        } else if (this.state.currency.length === 0) {
            this.setState({ errorCur: true, msgErrorCur: 'Currency Cannot be Empty' })
        } else if (R.isNil(this.state.defaultCurrency)) {
            this.setState({ errorDefCur: true, msgErrorDefCur: 'Default Currency Cannot be Empty' })
        } else if (R.isNil(this.state.startDate)) {
            this.setState({ errorSD: true, msgErrorSD: 'Valid From Cannot be Empty' })
        } else if (R.isNil(this.state.endDate)) {
            this.setState({ errorED: true, msgErrorED: 'Valid To Cannot be Empty' })
        } else {
            let currencyID = []
            if (this.state.currency.length > 0) {
                this.state.currency.map(item => {
                    currencyID.push(item.id)
                })
            }

            // OPSI 1
            // if (this.state.currency.length > 0) {
            //     this.state.currency.map(item => {
            //         currencyID.push({
            //             "currency_id" : item.id,
            //             "status" : true
            //         })
            //     })
            // }

            // OPSI 2
            // let finalCurrency = []
            // console.log(this.state.dataCurrency);
            // this.state.dataCurrency.map(item => {
            //     let index = this.state.currency.findIndex((val) => val.id == item.id)
            //     console.log(index);
            //     finalCurrency.push({
            //         "currency_id" : item.id,
            //         "status" : index == 0 || index == 1 ? true : false
            //     })
            // })


            let payload = {
                "company_id": this.state.companyID,
                "company_name": this.state.company,
                "business_unit_id": this.state.getTypes.business_unit_id,
                // "parent": this.state.getPerusahaan == null ? null : this.state.getPerusahaan.company_id,
                "parent": this.state.getPerusahaan.company_id,
                "start_date": this.state.startDate,
                "end_date": this.state.endDate,
                "currency": currencyID,
                "default_currency": this.state.defaultCurrency.id
            }
            console.log(payload);
            // this.props.updatePerusahaan(payload)
        }
    }

    validasi() {
        console.log(this.state.currency.length);
        if (R.isEmpty(this.state.company)) {
            this.setState({ errorNP: true, msgErrorNP: 'Company Name Cannot be Empty.' })
        } else if (R.isNil(this.state.getTypes)) {
            this.setState({ errorUB: true, msgErrorUB: 'Business Unit Cannot be Empty' })
        } else if (R.isNil(this.state.getPerusahaan)) {
            this.setState({ errorPC: true, msgErrorPC: 'Parent Company Cannot be Empty' })
        } else if (this.state.currency.length === 0) {
            this.setState({ errorCur: true, msgErrorCur: 'Currency Cannot be Empty' })
        } else if (R.isNil(this.state.defaultCurrency)) {
            this.setState({ errorDefCur: true, msgErrorDefCur: 'Default Currency Cannot be Empty' })
        } else if (R.isNil(this.state.startDate)) {
            this.setState({ errorSD: true, msgErrorSD: 'Valid From Cannot be Empty.' })
        } else if (R.isNil(this.state.endDate)) {
            this.setState({ errorED: true, msgErrorED: 'Valid To Cannot be Empty.' })
        }
        else {
            let currencyID = []
            if (this.state.currency.length > 0) {
                this.state.currency.map(item => {
                    currencyID.push(item.id)
                })
            }
            let payload = {
                "company_name": this.state.company,
                // "parent": this.state.getPerusahaan == null ? null : this.state.getPerusahaan.company_id,
                "parent": this.state.getPerusahaan.company_id,
                "business_unit_id": this.state.getTypes.business_unit_id,
                "start_date": this.state.startDate,
                "end_date": this.state.endDate,
                "currency": currencyID,
                "default_currency": this.state.defaultCurrency.id,
            }
            // console.log(payload);
            this.props.createPerusahaan(payload)
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    renderEdit() {
        return (
            <div className="test app-popup-show">
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Edit Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>


                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.companyID}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.types}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getTypes: newInputValue }, () => this.clearError())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Business Unit"
                                            error={this.state.errorUB}
                                            helperText={this.state.msgErrorUB}
                                        />
                                    }
                                    value={this.state.getTypes}
                                />
                            </div>
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    multiple
                                    options={this.state.dataCurrency}
                                    getOptionLabel={(option) => option.value}
                                    getOptionSelected={(option, value) => option.id === value.id}
                                    onChange={(event, newInputValue) => {
                                        let findIdx = newInputValue.findIndex(e => e.id === 2)
                                        let bizpar = findIdx >= 0 ? this.state.dataCurrency.filter(e => e.id === 2) : newInputValue
                                        this.setState({
                                            optionCurrecy: bizpar,
                                            currency: newInputValue
                                        }, () => {
                                            if (this.state.defaultCurrency) {
                                                const result = this.state.currency.find((elem) => elem.id === this.state.defaultCurrency.id)
                                                this.setState({ defaultCurrency: result })

                                            }
                                        })
                                        this.clearError()
                                    }}
                                    renderInput={(params) => (
                                        <TextField
                                            {...params}
                                            variant="standard"
                                            label="Currency"
                                            margin="normal"
                                            style={{ marginTop: 0 }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            error={this.state.errorCur}
                                            helperText={this.state.msgErrorCur}
                                        />
                                    )}
                                    value={this.state.currency}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.startDate}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorSD}
                                    helperText={this.state.msgErrorSD}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.status}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>

                        <div className="column-2">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="perusahaan"
                                    label="Company Name"
                                    value={this.state.company}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorNP}
                                    helperText={this.state.msgErrorNP}
                                    onChange={(e) => this.setState({ company: e.target.value }, () => this.clearError())}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.perusahaan}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getPerusahaan: newInputValue }, () => this.clearError())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            label="Parent Company"
                                            error={this.state.errorPC}
                                            helperText={this.state.msgErrorPC}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                        />
                                    }
                                    value={this.state.getPerusahaan}
                                />
                            </div>
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    debug
                                    id="tipe"
                                    options={this.state.optionCurrecy}
                                    getOptionLabel={(option) => option.value}
                                    value={this.state.defaultCurrency}
                                    disableClearable={!this.state.defaultCurrency}
                                    onChange={(event, newInputValue) => this.setState({ defaultCurrency: newInputValue }, () => this.clearError())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            label="Default Currency"
                                            margin="normal"
                                            style={{ marginTop: 7 }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            error={this.state.errorDefCur}
                                            helperText={this.state.msgErrorDefCur}
                                        />
                                    }

                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    value={this.state.endDate}
                                    minDate={this.state.startDate}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                    error={this.state.errorED}
                                    helperText={this.state.msgErrorED}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="border-bottom margin-top-10px" style={{ padding: '0px 20px 20px 20px', borderRadius: 5 }}>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Created By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.created}</Typography>
                        </div>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Updated By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.updated}</Typography>
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasiEdit()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        )
    }

    renderCreate() {
        return (
            <div className="test app-popup-show" style={{ paddingTop: 100 }}>
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Create Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>


                    <div className="border-bottom grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.types}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getTypes: newInputValue }, () => this.clearError())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            label="Business Unit"
                                            margin="normal"
                                            style={{ marginTop: 7 }}
                                            error={this.state.errorUB}
                                            helperText={this.state.msgErrorUB}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                        />
                                    }
                                    value={this.state.types}

                                />
                            </div>
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    multiple
                                    options={this.state.dataCurrency}
                                    getOptionLabel={(option) => option.value}
                                    renderInput={(params) => (
                                        <TextField
                                            {...params}
                                            variant="standard"
                                            label="Currency"
                                            margin="normal"
                                            style={{ marginTop: 0 }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            error={this.state.errorCur}
                                            helperText={this.state.msgErrorCur}
                                        />
                                    )}
                                    value={this.state.currency}
                                    onChange={(event, newInputValue) => {
                                        let findIdx = newInputValue.findIndex(e => e.id === 2)
                                        let bizpar = findIdx >= 0 ? this.state.dataCurrency.filter(e => e.id === 2) : newInputValue
                                        this.setState({
                                            optionCurrecy: bizpar,
                                            currency: newInputValue
                                        }, () => {
                                            if (this.state.defaultCurrency) {
                                                const result = this.state.currency.find((elem) => elem.id === this.state.defaultCurrency.id)
                                                this.setState({ defaultCurrency: result })

                                            }
                                            this.clearError()
                                        })
                                    }}
                                />
                            </div>
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.startDate == "" ? null : this.state.startDate}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5, backgroundColor: '#e8e8e8', }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    defaultValue={"Active"}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Created By : </Typography>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Updated By : </Typography>
                            </div>
                        </div>

                        <div className="column-2">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="perusahaan"
                                    label="Company Name"
                                    value={this.state.company}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorNP}
                                    helperText={this.state.msgErrorNP}
                                    onChange={(e) => this.setState({ company: e.target.value }, () => this.clearError())}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.perusahaan}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getPerusahaan: newInputValue }, () => this.clearError())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            label="Parent Company"
                                            error={this.state.errorPC}
                                            helperText={this.state.msgErrorPC}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                        />
                                    }
                                    value={this.state.perusahaan}
                                />
                            </div>

                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    debug
                                    id="tipe"
                                    options={this.state.optionCurrecy}
                                    getOptionLabel={(option) => option.value}
                                    value={this.state.defaultCurrency}
                                    disableClearable={!this.state.defaultCurrency}
                                    onChange={(event, newInputValue) => this.setState({ defaultCurrency: newInputValue }, () => this.clearError())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            label="Default Currency"
                                            margin="normal"
                                            style={{ marginTop: 7 }}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            error={this.state.errorDefCur}
                                            helperText={this.state.msgErrorDefCur}
                                        />
                                    }

                                />
                            </div>
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorED}
                                    helperText={this.state.msgErrorED}
                                    minDate={this.state.startDate}
                                    value={this.state.endDate}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>

                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasi()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}
