// a library to wrap and simplify api calls
import apisauce from 'apisauce'
import Constant from '../library/Constant'

// our "constructor"
const create = (type = "") => {
  let api;
  // ------
  // STEP 1
  // ------
  //
  // Create and configure an apisauce-based api object.
  //
  const baseURL = `${process.env.REACT_APP_URL_MAIN_BE}/public/`
  switch (type) {
    case '':
      api = apisauce.create({
        // base URL is read from the "constructor"
        baseURL,
        // here are some default headers
        headers: {
          'Cache-Control': 'no-cache',
          Accept: 'application/json',
          'Content-Type': 'application/json',
        },
        // 3 mins timeout...
        // timeout: 180000
        // 5 mins timeout...
        timeout: 300000
      })
      break;
    case 'UPLOAD':
      api = apisauce.create({
        // base URL is read from the "constructor"
        baseURL,
        // here are some default headers
        headers: {
          'Cache-Control': 'no-cache',
          Accept: 'application/json',
          'Content-Type': 'application/json',
        },
        // 40 second timeout...
        timeout: 180000
      })
      break;
    default:
      break;
  }

  api.addAsyncRequestTransform(request => async () => {
    var token
    try {
      const res = await localStorage.getItem(Constant.TOKEN)
      if (token != null) {
        token = res
        // alert(url)
        // api.setBaseURL(`${url}/api/`)
      } else {
        token = res
        // url = Constant.BASE_URL.MASTER + '/api/'
        // alert(url)
        // api.setBaseURL(`${url}/api/`)
      }
    } catch (error) {
      // console.tron.log(error)
    }
    // console.log(token)
    request.headers['token'] = token
    // console.tron.log(url)
  })

  // ------
  // STEP 2
  // ------
  //
  // Define some functions that call the api.  The goal is to provide
  // a thin wrapper of the api layer providing nicer feeling functions
  // rather than "get", "post" and friends.
  //
  // I generally don't like wrapping the output at this level because
  // sometimes specific actions need to be take on `403` or `401`, etc.
  //
  // Since we can't hide from that, we embrace it by getting out of the
  // way at this level.
  //
  const getRoot = () => api.get('')

  //Auth
  const login = (body) => api.post('auth/login', body)
  const resetPassword = (body) => api.post('auth/reset_password', body)
  const verification = (body) => api.post('email/reset_password', body)
  const isResetPassword = (userId) => api.post(`auth/is_reset_password/${userId}`)

  //Role
  const getRole = () => api.get('role/get_all_role')
  const getRoleActive = () => api.get('role/get_all_role_active')
  const getDetailRole = (roleId) => api.get(`role/get_role_by_id/${roleId}`)
  const searchRole = (body) => api.post('/role/search_role', body)
  const addRole = (body) => api.post('role/create_role', body)
  const editRole = (body) => api.post('role/update_role', body)
  const deleteRole = (roleId) => api.post(`role/delete_role/${roleId}`)

  //Menu
  const getMenu = () => api.get('menu/get_menu_hierarki')
  const getMenuByRole = () => api.get('menu/get_menu_hierarki_by_role')
  const getMenuByUser = () => api.get('menu/get_menu')
  const getPermission = (body) => api.post('permission/get_permission', body)

  //UNIT BISNIS
  const getUnitBisnis = () => api.get('business_unit/get_all_business_unit')
  const createUnitBisnis = (body) => api.post('/business_unit/create_business_unit', body)
  const updateUnitBisnis = (body) => api.post('/business_unit/update_business_unit', body)
  const searchUnitBisnis = (body) => api.post('/business_unit/search_business_unit', body)
  const checkUploadUnitBisnis = (body) => api.post('/business_unit/check_import', body)
  const uploadUnitBisnis = (body) => api.post('/business_unit/import_business_unit', body)
  const getUnitBisnisActive = () => api.get('business_unit/get_all_business_unit_active')
  const getDetailUnitBisnis = (id) => api.get(`business_unit/get_business_unit_by_id/${id}`)
  const deleteUnitBisnis = (id) => api.post(`business_unit/delete_business_unit/${id}`)

  // Perusahaan
  const getPerusahaan = () => api.get('company/get_all_company')
  const getPerusahaanActive = () => api.get('company/get_all_company_active')
  const createPerusahaan = (body) => api.post('/company/create_company', body)
  const updatePerusahaan = (body) => api.post('/company/update_company', body)
  const getPerusahaanHierarki = () => api.get('company/get_company_hierarki')
  const saveVisualisasiPerusahaan = (body) => api.post('company/save_visualization', body)
  const checkUploadPerusahaan = (body) => api.post('company/check_import', body)
  const getDetailPerusahaan = (id) => api.get(`company/get_company_by_id/${id}`)
  const uploadPerusahaan = (body) => api.post('company/import_company', body)
  const searchPerusahaan = (body) => api.post('company/search_company', body)
  const deletePerusahaan = (id) => api.post(`company/delete_company/${id}`)
  const getDataCurrency = () => api.get('multi_currency/get_all_currency')


  // APPROVAL MATRIX
  const getAM = () => api.get('approval_matrix/get_all_approval_matrix')
  const getApprovedByAM = () => api.get('approval_matrix/get_all_approver')
  const getTypeAM = () => api.get('approval_type/get_all_approval_type')
  const getOperatorAM = () => api.get('operator_type/get_all_operator_type')
  const getDetailAM = (id) => api.get(`approval_matrix/get_approval_matrix_by_id/${id}`)
  const searchAM = (body) => api.post('/approval_matrix/search_approval_matrix', body)
  const createAM = (body) => api.post('/approval_matrix/create_approval_matrix', body)
  const updateAM = (body) => api.post('/approval_matrix/update_approval_matrix', body)
  const updateVAM = (body) => api.post('/approval_matrix/save_visualization', body)
  const checkUploadAM = (body) => api.post('/approval_matrix/check_import', body)
  const uploadAM = (body) => api.post('approval_matrix/import_approval_matrix', body)
  const deleteAM = (id) => api.post(`approval_matrix/delete_approval_matrix/${id}`)

  //User
  const getUser = () => api.get('user/get_all_user')
  const getDetailUser = (userId) => api.get(`user/get_user_by_id/${userId}`)
  const searchUser = (body) => api.post('user/search_user', body)
  const createUser = (body) => api.post('user/create_user', body)
  const updateUser = (body) => api.post('user/update_user', body)
  const deleteUser = (userId) => api.post(`user/delete_user/${userId}`)
  const changePassword = (body) => api.post('/user/change_password', body)
  const checkUploadUser = (body) => api.post('/user/check_import', body)
  const uploadUser = (body) => api.post('/user/import_user', body)

  //Report Items
  const getReportItems = () => api.get('item_report/get_all_item_report')
  const getInputType = () => api.get('type_item_report/get_all_type_item_report')
  const getReportType = () => api.get('report/get_all_report')
  const getDetailReportItems = (userId) => api.get(`item_report/get_item_report_by_id/${userId}`)
  const searchReportItems = (body) => api.post('/item_report/search_item_report', body)
  const createReportItems = (body) => api.post('/item_report/create_item_report', body)
  const updateReportItems = (body) => api.post('/item_report/update_item_report', body)
  const checkUploadReportItems = (body) => api.post('/item_report/check_import', body)
  const uploadReportItems = (body) => api.post('/item_report/import_item_report', body)
  const getItemReportHierarki = (body) => api.post('item_report/get_item_report_hierarki', body)
  const saveVisualisasiReport = (body) => api.post('item_report/save_visualization', body)
  const getReportParent = (body) => api.post('item_report/get_parent_item_report', body)
  const deleteReportItems = (id) => api.post(`item_report/delete_item_report/${id}`)
  const getAllSettingByType = (body) => api.post('setting/get_all_setting_by_type', body)
  const createAllItemReport = (body) => api.post('item_report/create_all_item_report', body)
  const deleteAllItemReport = (body) => api.post('/item_report/delete_all_item_report', body)
  const deleteAllItemReportLOCF = (body) => api.post('/item_report/delete_all_item_report_locf', body)

  //PARAMETER
  const getAllParameter = () => api.get('/setting/get_all_setting')
  const getDetailParameter = (id) => api.get(`setting/get_setting_by_id/${id}`)
  const getAllGroup = () => api.get('/setting_group/get_all_setting_group')
  const getParameterByGroup = (groupID) => api.get(`/setting_type/get_all_setting_type_by_group/${groupID}`)
  const getParameterByGroupName = (groupName) => api.post(`/setting/get_all_setting_by_group_name`, groupName)
  const createParameter = (body) => api.post('setting/create_setting', body)
  const updateParameter = (body) => api.post('setting/update_setting', body)
  const checkUploadParameter = (body) => api.post('setting/check_import', body)
  const uploadParameter = (body) => api.post('/setting/import_setting', body)
  const searchParameter = (body) => api.post('setting/search_setting', body)
  const deleteParameter = (id) => api.post(`setting/delete_setting/${id}`)
  const getDataReport = () => api.get('setting_type/get_all_setting_type_by_report_submit_period_group')
  const getFormatValue = () => api.get('setting_type/get_all_setting_type_by_money_format_group')
  const getThreshold = () => api.get('/setting_type/get_all_setting_type_by_threshold_control')

  // MASTER DATA - CAT
  const getAllMasterDataCat = () => api.get('item_report_company/get_all_item_report_company')
  const getParentItemReport = (body) => api.post('item_report/get_parent_item_report_default', body)
  const saveMasterDataCat = (body) => api.post('item_report_company/create_item_report_company', body)
  const getDetailMasterDataCat = (idCompany, years) => api.get(`item_report_company/get_item_report_company_by_company_id_years/${idCompany}/${years}`)
  const deleteMasterDataCat = (idCompany, years) => api.post(`item_report_company/delete_item_report_company/${idCompany}/${years}`)
  const updateMasterDataCat = (body) => api.post('item_report_company/update_item_report_company', body)

  //Transaction
  const getReportTypeBody = (body) => api.post('transaction/master_budget/get_all_report', body)
  const getMasterBudgetAtt = (body) => api.post('transaction/master_budget/get_report_attachment', body)
  const uploadAttachment = (body) => api.post('transaction/master_budget/upload_attachment', body)
  const getRevision = (body) => api.post('transaction/master_budget/get_revision', body)
  const getPeriodeTransaction = () => api.get('transaction/get_periode')
  const getMonthTransaction = () => api.get('transaction/get_default_month')
  const deleteAttachment = (id) => api.post(`transaction/master_budget/delete_attachment/${id}`)
  const getDetailReportMB = (body) => api.post('/transaction/master_budget/get_report_hierarki', body)
  const getLastestUpdateMB = (body) => api.post('/transaction/master_budget/get_latest_update', body)
  const createSubmitReport = (body) => api.post('transaction/master_budget/create_submission_report', body)
  const getSubmission = (body) => api.post('transaction/master_budget/get_submission_id', body)
  const checkUploadMB = (body) => api.post('transaction/master_budget/check_import', body)
  const uploadMasterBudget = (body) => api.post('transaction/master_budget/import_master_budget', body)
  const validateSubmitReport = (body) => api.post('transaction/master_budget/validate_save', body)
  const countingFormula = (body) => api.post('transaction/counting_formula', body)
  const submitMasterBudget = (body) => api.post('transaction/master_budget/submit_master_budget', body)
  const checkIsSubmit = (body) => api.post('transaction/master_budget/is_can_submit', body)
  const checkApprover = () => api.get('transaction/master_budget/is_approver')
  const approvalSubmission = (body) => api.post('transaction/master_budget/approval_submission', body)
  const getCompanySubmitted = (body) => api.post('transaction/master_budget/get_company_submitted', body)
  const getLastPeriod = (idCompany) => api.get(`transaction/master_budget/get_last_periode/${idCompany}`)
  const getSubmitMasterBudget = (body) => api.post('transaction/master_budget/get_latest_periode_submit', body)
  const getSubmitMonthlyReport = (body) => api.post('transaction/monthly_report/get_latest_periode_submit', body)
  const createPeriodeRevision = (body) => api.post('transaction/master_budget/create_periode_revision', body)
  const getIdDeleteFromExcel = (body) => api.post('transaction/master_budget/delete_from_excel', body)
  const getIdDeleteFromExcelLOCF = (body) => api.post('transaction/locf/monthly_report/delete_from_excel', body)
  const getDashboard = (body) => api.get('transaction/get_dashboard')
  const historyApproval = (body) => api.post('transaction/master_budget/history_approval', body)
  const getDashboardUser = () => api.get('transaction/get_dashboard_sub_co')
  const getDashboardMB = (body) => api.get('transaction/get_dashboard_table')
  const getReportHierarkiFRMB = (body) => api.post('transaction/db_ratio/master_budget/get_report_hierarki', body)
  const getReportHierarkiFRMR = (body) => api.post('transaction/db_ratio/monthly_report/get_report_hierarki', body)
  const getDetailHierarkiCF = (body) => api.post('transaction/master_budget/get_report_hierarki_cashflow', body)

  const getOpetratingIndID = (body) => api.post('transaction/operating_indicator/get_operating_indicator_id', body)
  const getSubmitOI = (body) => api.post('transaction/operating_indicator/get_latest_periode_submit', body)
  const getLastPeriodOI = (idCompany) => api.get(`transaction/operating_indicator/get_last_periode/${idCompany}`)
  const getAllOperatingInd = (body) => api.post('transaction/operating_indicator/get_all_report', body)
  const getOperatingIndDetail = (body) => api.post('transaction/operating_indicator/master_budget/get_report_hierarki', body)
  const createOpetaingInd = (body) => api.post('transaction/operating_indicator/master_budget/create_submission_report', body)
  const checkUploadOperatingInd = (body) => api.post('transaction/operating_indicator/master_budget/check_import', body)
  const uploadOperatingInd = (body) => api.post('transaction/operating_indicator/master_budget/import_master_budget', body)
  const getLastestUpdateOI = (body) => api.post('transaction/operating_indicator/get_latest_update', body)
  const getLastPeriodeOI = (idCompany) => api.post(`transaction/master_budget/get_last_periode/${idCompany}`)
  const getReportHierarkiPL = (body) => api.post('transaction/db_profit_loss_detail/get_report_hierarki', body)
  const getLastestUpdateMROI = (body) => api.post('transaction/operating_indicator/monthly_report/get_latest_update', body)

  // Rolling Outlook
  const getRollingOutlookID = (body) => api.post('transaction/rolling_outlook/get_rolling_outlook_id', body)
  const getRollingOutlookAttachment = (body) => api.post('transaction/rolling_outlook/get_report_attachment', body)
  const uploadRollingOutlookAttachment = (body) => api.post('transaction/rolling_outlook/upload_attachment', body)
  const deleteRollingOutlookAttachment = (body) => api.post(`transaction/rolling_outlook/delete_attachment/${body}`)
  const getRollingOutlookReport = (body) => api.post('transaction/rolling_outlook/get_all_report', body)
  const getRollingOutlookLastUpdate = (body) => api.post('transaction/rolling_outlook/get_latest_update', body)
  const getRollingOutlookRevision = (body) => api.post('transaction/rolling_outlook/get_revision', body)
  const getRollingOutlookIsApprover = (body) => api.get('transaction/rolling_outlook/is_approver', body)
  const uploadAttachmentRO = (body) => api.post('transaction/rolling_outlook/upload_attachment', body)
  const deleteAttachmentRO = (id) => api.post(`transaction/rolling_outlook/delete_attachment/${id}`)
  const approvalRolling = (body) => api.post('transaction/rolling_outlook/approval_rolling', body)
  const createPeriodeRevisionRO = (body) => api.post('transaction/rolling_outlook/create_periode_revision', body)
  const historyApprovalRO = (body) => api.post('transaction/rolling_outlook/history_approval', body)

  const getRollingOutlookBS = (body) => api.post('transaction/balance_sheet/rolling_outlook/get_report_hierarki', body)
  const checkImportRollingOutlookBS = (body) => api.post('transaction/balance_sheet/rolling_outlook/check_import', body)
  const importRollingOutlookBS = (body) => api.post('transaction/balance_sheet/rolling_outlook/import_rolling_outlook', body)
  const createRollingOutlookBS = (body) => api.post('transaction/balance_sheet/rolling_outlook/create_rolling_outlook', body)
  const getRollingOutlookPL = (body) => api.post('transaction/profit_loss/rolling_outlook/get_report_hierarki', body)
  const createRollingOutlookPL = (body) => api.post('transaction/profit_loss/rolling_outlook/create_rolling_outlook', body)
  const checkImportRollingOutlookPL = (body) => api.post('transaction/profit_loss/rolling_outlook/check_import', body)
  const importRollingOutlookPL = (body) => api.post('transaction/profit_loss/rolling_outlook/import_rolling_outlook', body)
  const getRollingOutlookTP = (body) => api.post('transaction/tax_planning/rolling_outlook/get_report_hierarki', body)
  const createRollingOutlookTP = (body) => api.post('transaction/tax_planning/rolling_outlook/create_rolling_outlook', body)
  const checkImportRollingOutlookTP = (body) => api.post('transaction/tax_planning/rolling_outlook/check_import', body)
  const importRollingOutlookTP = (body) => api.post('transaction/tax_planning/rolling_outlook/import_rolling_outlook', body)
  const getRollingOutlookCAT = (body) => api.post('transaction/cat/rolling_outlook/get_report_hierarki', body)
  const createRollingOutlookCAT = (body) => api.post('transaction/cat/rolling_outlook/create_rolling_outlook', body)
  const checkImportRollingOutlookCAT = (body) => api.post('transaction/cat/rolling_outlook/check_import', body)
  const importRollingOutlookCAT = (body) => api.post('transaction/cat/rolling_outlook/import_rolling_outlook', body)
  const getSubmitRollingOutlook = (body) => api.post('transaction/rolling_outlook/get_latest_periode_submit', body)
  const getRollingOI = (body) => api.post('transaction/operating_indicator/rolling_outlook/get_operating_indicator_id', body)
  const getHierarkiRollingOI = (body) => api.post('transaction/operating_indicator/rolling_outlook/get_report_hierarki', body)
  const createRollingOI = (body) => api.post('transaction/operating_indicator/rolling_outlook/create_rolling_outlook', body)
  const getLastestUpdateROOI = (body) => api.post('transaction/operating_indicator/rolling_outlook/get_latest_update', body)
  const checkUploadRollingOutlookOI = (body) => api.post('transaction/operating_indicator/rolling_outlook/check_import', body)
  const uploadRollingOutlookOI = (body) => api.post('transaction/operating_indicator/rolling_outlook/import_rolling_outlook', body)
  const submitRollingOutlook = (body) => api.post('transaction/rolling_outlook/submit_rolling_outlook', body)
  const getRollingOutlookCompanySubmitted = (body) => api.post('transaction/rolling_outlook/get_company_submitted', body)
  const getRollingOutlookCF = (body) => api.post('transaction/cash_flow/rolling_outlook/get_report_hierarki', body)
  const createRollingOutlookCF = (body) => api.post('transaction/cash_flow/rolling_outlook/create_rolling_outlook', body)

  //REPORT NEW
  const getAllReportBS = (body) => api.post('/transaction/db_balance_sheet/get_report_hierarki', body)
  const getReportBSMB = (body) => api.post('/transaction/db_balance_sheet/master_budget/get_report_hierarki', body)
  const getReportBSMR = (body) => api.post('/transaction/db_balance_sheet/monthly_report/get_report_hierarki', body)
  const getAllReportPLDetail = (body) => api.post('/transaction/db_profit_loss_detail/get_report_hierarki', body)
  const getReportPLDetailMB = (body) => api.post('/transaction/db_profit_loss_detail/master_budget/get_report_hierarki', body)
  const getReportPLDetailMR = (body) => api.post('/transaction/db_profit_loss_detail/monthly_report/get_report_hierarki', body)
  const getReportPL = (body) => api.post('/transaction/db_profit_loss/get_report_hierarki', body)
  const getReportFR = (body) => api.post('/transaction/db_ratio/get_report_hierarki', body)
  const getHierarkiCreateReportPLMB = (body) => api.post('/transaction/db_profit_loss/master_budget/get_report_hierarki', body)
  const getHierarkiCreateReportPLMR = (body) => api.post('/transaction/db_profit_loss/monthly_report/get_report_hierarki', body)
  const createReportPLMB = (body) => api.post('/transaction/db_profit_loss/master_budget/create_submission_report', body)
  const createReportPLMR = (body) => api.post('/transaction/db_profit_loss/monthly_report/create_monthly_report', body)
  const getPLID = (body) => api.post('/transaction/db_profit_loss/get_profit_loss_id', body)
  const getHierarkiCreateReportFRMB = (body) => api.post('/transaction/db_ratio/master_budget/get_report_hierarki', body)
  const getHierarkiCreateReportFRMR = (body) => api.post('/transaction/db_ratio/monthly_report/get_report_hierarki', body)
  const getFRID = (body) => api.post('/transaction/db_ratio/get_ratio_id', body)
  const createReportFRMB = (body) => api.post('/transaction/db_ratio/master_budget/create_submission_report', body)
  const createReportFRMR = (body) => api.post('/transaction/db_ratio/monthly_report/create_monthly_report', body)
  // const getReportPLMB = (body) => api.post('/transaction/db_profit_loss/get_report_hierarki', body)
  // const getReportPLMB = (body) => api.post('/transaction/db_profit_loss/get_report_hierarki', body)
  const getReportPLMR = (body) => api.post('/transaction/db_profit_loss/monthly_report/get_report_hierarki', body)
  const getReportTPMB = (body) => api.post('/transaction/db_tax_planning/master_budget/get_report_hierarki', body)
  const getReportTPMR = (body) => api.post('/transaction/db_tax_planning/monthly_report/get_report_hierarki', body)
  const getReportTP = (body) => api.post('/transaction/db_tax_planning/get_report_hierarki', body)
  const getAllReportOI = (body) => api.post('/transaction/db_operating_indicator/get_report_hierarki', body)
  const getReportOIMB = (body) => api.post('/transaction/db_operating_indicator/master_budget/get_report_hierarki', body)
  const getReportOIMR = (body) => api.post('/transaction/db_operating_indicator/monthly_report/get_report_hierarki', body)
  const getReportCFSumaMB = (body) => api.post('/transaction/summary_cash_flow/master_budget/get_report_hierarki', body)
  const getReportCFSumaMR = (body) => api.post('/transaction/summary_cash_flow/monthly_report/get_report_hierarki', body)
  const getReportCFSuma = (body) => api.post('/transaction/summary_cash_flow/summary/get_report_hierarki', body)
  const getReportPLSuma = (body) => api.post('/transaction/summary_profit_loss/summary/get_report_hierarki', body)
  const getReportPLSummary = (body) => api.post('/transaction/summary_profit_loss/summary/get_report_hierarki_summary', body)
  const getReportFRSuma = (body) => api.post('/transaction/summary_ratio/summary/get_report_hierarki', body)
  const getReportFRMB = (body) => api.post('/transaction/summary_ratio/master_budget/get_report_hierarki', body)
  const getReportFRMR = (body) => api.post('/transaction/summary_ratio/monthly_report/get_report_hierarki', body)
  const getReportFRLastMR = (body) => api.post('/transaction/summary_ratio/monthly_report_last_year/get_report_hierarki', body)
  const getReportBSSuma = (body) => api.post('/transaction/summary_balance_sheet/summary/get_report_hierarki', body)
  const getDashboardCAT = (body) => api.post('/transaction/dashboard/get_dashboard_cat', body)
  const getListChildDashboardCAT = (periode, month) => api.get(`/transaction/dashboard/get_home_cat/${periode}/${month}`)
  const getDashboardCATDetail = (body) => api.post('/transaction/dashboard/get_dashboard_cat_detail', body)
  const getHierarkiReportYtd = (body) => api.post('/transaction/summary_ytd/summary/get_report_hierarki', body)
  const getHierarkiReportHistorical = (body) => api.post('/transaction/summary_historical/summary/get_report_hierarki', body)
  const getHierarkiReportMTD = (body) => api.post('/transaction/summary_mtd/summary/get_report_hierarki', body)
  const getHierarkiReportCPSM = (body) => api.post('/transaction/summary_cpsm/summary/get_report_hierarki', body)
  const getFullApproveMB = (body) => api.post('/transaction/master_budget/get_approved_submit', body)
  const getFullApproveMonthly = (body) => api.post('/transaction/monthly_report/get_approved_submit', body)
  const getDashboardFinancial = (body) => api.post('/transaction/dashboard/get_dashboard_financial', body)
  const getReportCATPA = (body) => api.post('/transaction/cat/performance_appraisal', body)
  const getReportCATPQ = (body) => api.post('/transaction/cat/quarterly/get_report_hierarki', body)

  //CASH FLOW
  const getDetailReportCF = (body) => api.post('/transaction/cash_flow/master_budget/get_report_hierarki', body)
  const createReportCF = (body) => api.post('transaction/cash_flow/master_budget/create_submission_report', body)
  const createReportCFSimulasi = (body) => api.post('transaction/cash_flow/master_budget/create_submission_report/other_currency', body)

  //OUTLOOK PA
  const getOutlookPAID = (body) => api.post('transaction/outlook_pa/get_outlook_pa_id', body)
  const getLastPeriodOLPA = (idCompany) => api.get(`/transaction/outlook_pa/get_last_periode/${idCompany}`)
  const getCompanySubmittedOLPA = (body) => api.post('transaction/outlook_pa/get_company_submitted', body)
  const getRevisionOLPA = (body) => api.post('transaction/outlook_pa/get_revision', body)
  const historyApprovalOLPA = (body) => api.post('transaction/outlook_pa/history_approval', body)
  const getSubmitOLPA = (body) => api.post('transaction/outlook_pa/get_latest_periode_submit', body)
  const getOLPAAtt = (body) => api.post('transaction/outlook_pa/get_report_attachment', body)
  const submitOLPA = (body) => api.post('transaction/outlook_pa/submit_outlook_pa', body)
  const getDetailReportOLPA = (body) => api.post('transaction/outlook_pa/get_report_hierarki', body)
  const getLastestUpdateOLPA = (body) => api.post('transaction/outlook_pa/get_latest_update', body)
  const createReportOLPA = (body) => api.post('transaction/outlook_pa/create_outlook_report', body)
  const checkUploadOLPA = (body) => api.post('transaction/outlook_pa/check_import', body)
  const validateSubmitReportOLPA = (body) => api.post('transaction/outlook_pa/validate_save', body)
  const uploadOLPA = (body) => api.post('transaction/outlook_pa/import_outlook_pa', body)
  const uploadAttOLPA = (body) => api.post('transaction/outlook_pa/upload_attachment', body)
  const deleteAttOLPA = (id) => api.post(`transaction/outlook_pa/delete_attachment/${id}`)
  const getReportOLPA = (body) => api.post('transaction/outlook_pa/get_all_report', body)
  const approvalSubmissionOLPA = (body) => api.post('transaction/outlook_pa/approval_outlook', body)
  const checkApproverOLPA = () => api.get('transaction/outlook_pa/is_approver')
  const createPeriodeRevisionOLPA = (body) => api.post('transaction/outlook_pa/create_periode_revision', body)
  const getHierarkiCFOLPA = (body) => api.post('transaction/cash_flow/outlook_pa/get_report_hierarki', body)
  const createCFOLPA = (body) => api.post('transaction/cash_flow/outlook_pa/create_outlook_report', body)
  const getHierarkiDBPLOLPA = (body) => api.post('transaction/db_profit_loss/outlook_pa/get_report_hierarki', body)
  const createDBPLOLPA = (body) => api.post('transaction/db_profit_loss/outlook_pa/create_outlook_report', body)
  const getHierarkiDBPLRO = (body) => api.post('transaction/db_profit_loss/rolling_outlook/get_report_hierarki', body)
  const createDBPLRO = (body) => api.post('transaction/db_profit_loss/rolling_outlook/create_rolling_outlook', body)
  // const getDetailReportOLPACAT = (body) => api.post('transaction/cat/outlook_pa/get_report_hierarki', body)
  const getDetailReportOLPACAT = (body) => api.post('transaction/outlook_pa/get_report_hierarki', body)
  const createCATOLPA = (body) => api.post('transaction/outlook_pa/create_outlook_pa', body)

  // Monthly
  const getMonthlyReport = (body) => api.post('transaction/monthly_report/get_all_report', body)
  const submitMonthlyReport = (body) => api.post('transaction/monthly_report/submit_monthly_report', body)
  const approvalMonthly = (body) => api.post('transaction/monthly_report/approval_monthly', body)
  const createPeriodeRevisionMonthly = (body) => api.post('transaction/monthly_report/create_periode_revision', body)
  const getMonthlyOI = (body) => api.post('transaction/operating_indicator/monthly_report/get_operating_indicator_id', body)
  const getMonthlyReportID = (body) => api.post('transaction/monthly_report/get_monthly_report_id', body)
  // const getHierarkiMontlyReportBS = (body) => api.post('transaction/monthly_report_bs/get_report_hierarki', body)
  const getHierarkiMontlyReportBS = (body) => api.post('transaction/balance_sheet/monthly_report/get_report_hierarki', body)
  const getHierarkiMontlyReportOI = (body) => api.post('transaction/operating_indicator/monthly_report/get_report_hierarki', body)
  const getLastestUpdateMR = (body) => api.post('/transaction/monthly_report/get_latest_update', body)
  // const getHierarkiMontlyReportTP = (body) => api.post('transaction/monthly_report_tp/get_report_hierarki', body)
  const getHierarkiMontlyReportTP = (body) => api.post('transaction/tax_planning/monthly_report/get_report_hierarki', body)
  const getHierarkiMontlyReportLOCF = (body) => api.post('transaction/locf/monthly_report/get_report_hierarki', body)
  const getHierarkiMontlyReportFAM = (body) => api.post('transaction/fam/monthly_report/get_report_hierarki', body)
  const getHierarkiMontlyReportCF = (body) => api.post('transaction/cash_flow/monthly_report/get_report_hierarki', body)
  const getHierarkiMontlyReportCAT = (body) => api.post('/transaction/cat/monthly_report/get_report_hierarki', body)
  const getLastPeriodMonthly = (idCompany) => api.get(`transaction/monthly_report/get_last_periode/${idCompany}`)
  const checkApproverMonthly = () => api.get('transaction/monthly_report/is_approver')
  const getCompanySubmittedMonthly = (body) => api.post('transaction/monthly_report/get_company_submitted', body)
  const historyApprovalMonthly = (body) => api.post('transaction/monthly_report/history_approval', body)
  const getMontlyReportAtt = (body) => api.post('transaction/monthly_report/get_report_attachment', body)
  const uploadAttachmentMonthly = (body) => api.post('transaction/monthly_report/upload_attachment', body)
  const deleteAttachmentMonthly = (id) => api.post(`transaction/monthly_report/delete_attachment/${id}`)
  // const createMonthlyReportBS = (body) => api.post('transaction/monthly_report_bs/create_monthly_report', body)
  const createMonthlyReportBS = (body) => api.post('transaction/balance_sheet/monthly_report/create_monthly_report', body)
  const createMonthlyReportLOCF = (body) => api.post('transaction/locf/monthly_report/create_monthly_report', body)
  // const createMonthlyReportTP = (body) => api.post('transaction/monthly_report_tp/create_monthly_report', body)
  const createMonthlyReportTP = (body) => api.post('transaction/tax_planning/monthly_report/create_monthly_report', body)
  const createMonthlyReportFAM = (body) => api.post('transaction/fam/monthly_report/create_monthly_report', body)
  const createMonthlyReportOI = (body) => api.post('transaction/operating_indicator/monthly_report/create_monthly_report', body)
  const createMonthlyReportCAT = (body) => api.post('transaction/cat/monthly_report/create_monthly_report', body)
  const createMonthlyReportCF = (body) => api.post('transaction/cash_flow/monthly_report/create_monthly_report', body)
  // const checkUploadMonthlyReportTP = (body) => api.post('transaction/monthly_report_tp/check_import', body)
  const checkUploadMonthlyReportTP = (body) => api.post('transaction/tax_planning/monthly_report/check_import', body)
  const checkUploadMonthlyReportFAM = (body) => api.post('transaction/fam/monthly_report/check_import', body)
  // const checkUploadMonthlyReportBS = (body) => api.post('transaction/monthly_report_bs/check_import', body)
  const checkUploadMonthlyReportBS = (body) => api.post('transaction/balance_sheet/monthly_report/check_import', body)
  const checkUploadMonthlyReportOI = (body) => api.post('transaction/operating_indicator/monthly_report/check_import', body)
  const checkUploadMonthlyReportCAT = (body) => api.post('transaction/cat/monthly_report/check_import', body)
  // const uploadMonthlyReportBS = (body) => api.post('transaction/monthly_report_bs/import_monthly_report', body)
  const uploadMonthlyReportBS = (body) => api.post('transaction/balance_sheet/monthly_report/import_monthly_report', body)
  const uploadMonthlyReportFAM = (body) => api.post('transaction/fam/monthly_report/import_monthly_report', body)
  // const uploadMonthlyReportTP = (body) => api.post('transaction/monthly_report_tp/import_monthly_report', body)
  const uploadMonthlyReportTP = (body) => api.post('transaction/tax_planning/monthly_report/import_monthly_report', body)
  const uploadMonthlyReportOI = (body) => api.post('transaction/operating_indicator/monthly_report/import_monthly_report', body)
  const uploadMonthlyReportCAT = (body) => api.post('transaction/cat/monthly_report/import_monthly_report', body)
  // const validateSubmitReportBS = (body) => api.post('transaction/monthly_report_bs/validate_save', body)
  const validateSubmitReportBS = (body) => api.post('transaction/balance_sheet/monthly_report/validate_save', body)
  const validateSubmitReportMR = (body) => api.post('transaction/monthly_report/validate_save', body)
  // const validateSubmitReportMRTP = (body) => api.post('transaction/monthly_report_tp/validate_save', body)
  const validateSubmitReportMRTP = (body) => api.post('transaction/tax_planning/monthly_report/validate_save', body)
  const getPerBSiMontlyReportLOCF = (body) => api.post('transaction/locf/monthly_report/get_per_bs', body)
  const checkUploadMonthlyReportLOCF = (body) => api.post('transaction/locf/monthly_report/check_import', body)
  const uploadMonthlyReportLOCF = (body) => api.post('transaction/locf/monthly_report/import_monthly_report', body)
  const validateSubmitReportOI = (body) => api.post('transaction/operating_indicator/monthly_report/validate_save', body)
  const validateSubmitReportFAM = (body) => api.post('transaction/fam/monthly_report/validate_save', body)

  const getListUserSubcoMB = (periode) => api.get(`transaction/get_dashboard_sub_co/master_budget/${periode}`)
  const getListUserSubcoMR = (months, periode) => api.get(`transaction/get_dashboard_sub_co/monthly_report/${periode}/${months}`)
  const getListUserSubcoRO = (periode, quartal) => api.get(`transaction/get_dashboard_sub_co/rolling_outlook/${periode}/${quartal}`)
  const getListUserSubcoOL = (periode) => api.get(`transaction/get_dashboard_sub_co/outlook_pa/${periode}`)

  // Cronjob
  const getHierarkiCronJobMBPL = () => api.get('/transaction/report/get_hierarki_master_budget/profit_loss')
  const getHierarkiCronJobMBCF = () => api.get('/transaction/report/get_hierarki_master_budget/cash_flow')
  const getHierarkiCronJobMBRatio = () => api.get('/transaction/report/get_hierarki_master_budget/ratio')
  const getHierarkiCronJobMRPL = () => api.get('/transaction/report/get_hierarki_monthly_report/profit_loss')
  const getHierarkiCronJobMRCF = () => api.get('/transaction/report/get_hierarki_monthly_report/cash_flow')
  const getHierarkiCronJobMRRatio = () => api.get('/transaction/report/get_hierarki_monthly_report/ratio')

  // Ratio X LOCF 
  const getRatioLOCF = (body) => api.get(`/transaction/cronjob/create_monthly_report/${body.report}/${body.monthlyReportId}/${body.companyId}/${body.months}/${body.periode}/${body.currency_id}`)
  const triggerRatioFromLOCF = (body) => api.get(`/transaction/cronjob/create_monthly_report_company/${body.report}/${body.monthlyReportId}/${body.companyId}/${body.months}/${body.periode}/${body.currency_id}`)

  const triggerRatioMB = (body) => api.get(`/transaction/cronjob/create_master_budget_company/${body.report}/${body.submissionId}/${body.companyId}/${body.periode}/${body.currency_id}`)
  const triggerRatioRO = (body) => api.get(`/transaction/cronjob/create_rolling_outlook_company/${body.report}/${body.rollingOutlookId}/${body.companyId}/${body.quartal}/${body.periode}/${body.currency_id}`)
  const triggerRatioOLPA = (body) => api.get(`/transaction/cronjob/create_outlook_pa_company/${body.report}/${body.outlookPaId}/${body.companyId}/${body.periode}/${body.currency_id}`)
  const triggerHistoricalRatio = (body) => api.get(`/transaction/cronjob/create_historical_company/${body.report}/${body.companyId}/${body.periode}/${body.currency_id}/${body.months}`)

  // MonthlyPL
  // const getHierarkiMontlyReportPL = (body) => api.post('transaction/monthly_report_pl/get_report_hierarki', body)
  // const createMonthlyReportPL = (body) => api.post('transaction/monthly_report_pl/create_monthly_report', body)
  // const checkUploadMonthlyReportPL = (body) => api.post('transaction/monthly_report_pl/check_import', body)
  // const uploadMonthlyReportPL = (body) => api.post('transaction/monthly_report_pl/import_monthly_report', body)
  // const validateSubmitReportPL = (body) => api.post('transaction/monthly_report_pl/validate_save', body)
  const getHierarkiMontlyReportPL = (body) => api.post('transaction/profit_loss/monthly_report/get_report_hierarki', body)
  const createMonthlyReportPL = (body) => api.post('transaction/profit_loss/monthly_report/create_monthly_report', body)
  const checkUploadMonthlyReportPL = (body) => api.post('transaction/profit_loss/monthly_report/check_import', body)
  const uploadMonthlyReportPL = (body) => api.post('transaction/profit_loss/monthly_report/import_monthly_report', body)
  const validateSubmitReportPL = (body) => api.post('transaction/profit_loss/monthly_report/validate_save', body)
  //Template
  const downloadTemplate = (fileName, fileType) => api.get(`attachment/download_file?fileName=${fileName}&&fileType=${fileType}`)

  // UPLOAD FOTO
  const uploadFoto = (body) => api.post('attachment/upload_foto', body)

  // MANAGEMENT DOCUMENT
  // const getDocumentCategory = (body) => api.post('setting/get_all_setting_document_category', body)
  const getDocumentCategory = () => api.get('setting/get_all_setting_document_category')
  const getCarfmDocumentBySubmenu = (body) => api.post('document/get_cafrm_document_by_submenu', body);
  const getAllDocument = (body) => api.post('document/get_all_document', body)
  const uploadDocument = (body) => api.post('document/upload_document', body)
  const updateDocument = (body) => api.post('document/update_document', body)
  const downloadDocument = (body) => api.post('document/download_document', body)
  const getPerusahaanUserActive = () => api.get('company/get_all_user_company_active')
  const getDetailDocument = (id) => api.get(`document/get_document_by_id/${id}`)
  const deleteDocument = (id) => api.post(`document/delete_document/${id}`)
  const uploadCarfmDocument = (body) => api.post('document/upload_cafrm_document', body)


  // Monitoring
  const getMonitoringMB = (body) => api.get(`transaction/monitoring/submission/${body.year}`)
  const getMonitoringMR = (body) => api.get(`transaction/monitoring/monthly_report/${body.year}/${body.month}`)
  const getMonitoringRO = (body) => api.get(`transaction/monitoring/rolling_outlook/${body.year}/${body.quarter}`)
  const getMonitoringOLPA = (body) => api.get(`transaction/monitoring/outlook/${body.year}`)
  const getMonitoringCafrm = (body) => api.get(`transaction/monitoring/cafrm/${body.year}/${body.month}/${body.status}`)

  // Maintenance
  const getDetailMaintenanceMode = () => api.get('maintenance/mode/get_maintenance_mode')
  const createMaintenanceMode = (body) => api.post('maintenance/mode/create_maintenance_mode', body)
  const updateMaintenanceMode = (body) => api.post('maintenance/mode/update_maintenance_mode', body)

  // Reminder Manual
  const sendEmail = (body) => api.post('transaction/monitoring/reminder_progress_report', body)

  // Download Report
  const createDownloadFile = (body) => api.post('transaction/create/download-files-report', body)
  const createZipReport = (id) => api.get(`transaction/zip-files?downloadedFileReportId=${id}`)
  const getListDownload = () => api.get('transaction/download-files')
  const downloadZipReport = (id) => api.get(`transaction/download/zip-files?downloadedFileReportId=${id}`)
  // const createZipReport = (body) => api.post('transaction/monthly_report/export_selected_report', body)

  // Simulasi upload data last year
  // MB
  const uploadSimulasiMB = (body) => api.post('transaction/master_budget/import_master_budget/other_currency_existing', body)
  const createReportPLMBSimulasi = (body) => api.post('/transaction/db_profit_loss/master_budget/create_submission_report/other_currency_existing', body)
  const triggerRatioMBSimulasi = (body) => api.get(`/transaction/cronjob/create_master_budget_company/other_currency/${body.report}/${body.submissionId}/${body.companyId}/${body.periode}/${body.currency_id}`)
  // MR
  const uploadSimulasiMRPL = (body) => api.post('transaction/profit_loss/monthly_report/import_monthly_report/other_currency_existing', body)
  const uploadSimulasiMRTP = (body) => api.post('transaction/tax_planning/monthly_report/import_monthly_report/other_currency_existing', body)
  const uploadSimulasiMRBS = (body) => api.post('transaction/balance_sheet/monthly_report/import_monthly_report/other_currency_existing', body)
  const uploadSimulasiMRFAM = (body) => api.post('transaction/fam/monthly_report/import_monthly_report/other_currency_existing', body)
  const uploadSimulasiMRLOCF = (body) => api.post('transaction/locf/monthly_report/import_monthly_report//other_currency_existing', body)
  const uploadSimulasiMRCAT = (body) => api.post('transaction/cat/monthly_report/import_monthly_report/other_currency_existing', body)
  const uploadSimulasiMRCF = (body) => api.post('transaction/cash_flow/monthly_report/create_monthly_report/other_currency', body)
  const createSimulasiReportPLMR = (body) => api.post('/transaction/db_profit_loss/monthly_report/create_monthly_report/other_currency_existing', body)
  const triggerHistoricalRatioSimulasi = (body) => api.get(`/transaction/cronjob/create_historical_company/other_currency/${body.report}/${body.companyId}/${body.periode}/${body.currency_id}`)
  const triggerRatioFromLOCFSimulasi = (body) => api.get(`/transaction/cronjob/create_monthly_report_company/other_currency/${body.report}/${body.monthlyReportId}/${body.companyId}/${body.months}/${body.periode}/${body.currency_id}`)
  // RO
  const uploadSimulasiROPL = (body) => api.post('transaction/profit_loss/rolling_outlook/import_rolling_outlook/other_currency_existing', body)
  const uploadSimulasiROTP = (body) => api.post('transaction/tax_planning/rolling_outlook/import_rolling_outlook/other_currency_existing', body)
  const uploadSimulasiROBS = (body) => api.post('transaction/balance_sheet/rolling_outlook/import_rolling_outlook/other_currency_existing', body)
  const uploadSimulasiROCAT = (body) => api.post('transaction/cat/rolling_outlook/import_rolling_outlook/other_currency_existing', body)
  const createRollingOutlookCFSimulasi = (body) => api.post('transaction/cash_flow/rolling_outlook/create_rolling_outlook/other_currency_existing', body)
  const createDBPLROSimulasi = (body) => api.post('transaction/db_profit_loss/rolling_outlook/create_rolling_outlook/other_currency_existing', body)
  const triggerRatioROSimulasi = (body) => api.get(`/transaction/cronjob/create_rolling_outlook_company/other_currency/${body.report}/${body.rollingOutlookId}/${body.companyId}/${body.quartal}/${body.periode}/${body.currency_id}`)
  // OLPA
  const uploadSimulasiOLPA = (body) => api.post('transaction/outlook_pa/import_outlook_pa/other_currency_existing', body)
  const createDBPLOLPASimulasi = (body) => api.post('transaction/db_profit_loss/outlook_pa/create_outlook_report/other_currency_existing', body)
  const triggerRatioOLPASimulasi = (body) => api.get(`/transaction/cronjob/create_outlook_pa_company/other_currency/${body.report}/${body.outlookPaId}/${body.companyId}/${body.periode}/${body.currency_id}`)
  const createSimulasiOLPACF = (body) => api.post('transaction/cash_flow/outlook_pa/create_outlook_report/other_currency', body)
  // OI
  const uploadSimulasiOperatingInd = (body) => api.post('transaction/operating_indicator/master_budget/import_master_budget/other_currency_existing', body)
  const uploadSimulasiMROI = (body) => api.post('transaction/operating_indicator/monthly_report/import_monthly_report/other_currency_existing', body)
  const uploadSimulasiROOI = (body) => api.post('transaction/operating_indicator/rolling_outlook/import_rolling_outlook/other_currency_existing', body)

  // Superadmin Approve
  const getListApprover = (report, monthlyReportId) => api.get(`transaction/${report}/get_approver/${monthlyReportId}`)
  const getIdToken = (userId) => api.get(`transaction/get_token/${userId}`)
  // ------
  // STEP 3
  // ------
  //
  // Return back a collection of functions that we would consider our
  // interface.  Most of the time it'll be just the list of all the
  // methods in step 2.
  //
  // Notice we're not returning back the `api` created in step 1?  That's
  // because it is scoped privately.  This is one way to create truly
  // private scoped goodies in JavaScript.
  //
  return {
    // a list of the API functions from step 2
    getRoot,
    login,
    verification,
    resetPassword,
    isResetPassword,
    getRole,
    getDetailRole,
    searchRole,
    addRole,
    editRole,
    deleteRole,
    getMenu,
    getUnitBisnis,
    createUnitBisnis,
    updateUnitBisnis,
    searchUnitBisnis,
    getPerusahaan,
    createPerusahaan,
    updatePerusahaan,
    getAM,
    getApprovedByAM,
    getTypeAM,
    getOperatorAM,
    getDetailAM,
    searchAM,
    createAM,
    updateAM,
    updateVAM,
    checkUploadAM,
    uploadAM,
    deleteAM,
    getUser,
    getDetailUser,
    searchUser,
    createUser,
    updateUser,
    deleteUser,
    downloadTemplate,
    checkUploadUnitBisnis,
    uploadUnitBisnis,
    changePassword,
    getPerusahaanHierarki,
    checkUploadUser,
    uploadUser,
    getReportItems,
    searchReportItems,
    createReportItems,
    updateReportItems,
    getDetailReportItems,
    getInputType,
    getReportType,
    checkUploadReportItems,
    uploadReportItems,
    getAllParameter,
    getAllGroup,
    getParameterByGroup,
    getDetailParameter,
    updateParameter,
    createParameter,
    getPerusahaanActive,
    getRoleActive,
    checkUploadParameter,
    uploadParameter,
    getItemReportHierarki,
    getMenuByRole,
    saveVisualisasiReport,
    saveVisualisasiPerusahaan,
    getReportParent,
    searchParameter,
    checkUploadPerusahaan,
    getDetailPerusahaan,
    uploadPerusahaan,
    searchPerusahaan,
    getUnitBisnisActive,
    getMenuByUser,
    getDetailUnitBisnis,
    uploadFoto,
    getReportTypeBody,
    getPermission,
    getMasterBudgetAtt,
    uploadAttachment,
    getPeriodeTransaction,
    getMonthTransaction,
    getRevision,
    deleteAttachment,
    getDetailReportMB,
    deleteUnitBisnis,
    deleteParameter,
    getDataReport,
    getFormatValue,
    getThreshold,
    deletePerusahaan,
    getDataCurrency,
    deleteReportItems,
    getCarfmDocumentBySubmenu,
    getDocumentCategory,
    getAllDocument,
    uploadDocument,
    uploadCarfmDocument,
    updateDocument,
    downloadDocument,
    getPerusahaanUserActive,
    getDetailDocument,
    deleteDocument,
    createSubmitReport,
    createMonthlyReportBS,
    createMonthlyReportLOCF,
    createMonthlyReportTP,
    createMonthlyReportPL,
    createMonthlyReportFAM,
    createMonthlyReportOI,
    createMonthlyReportCAT,
    checkUploadMonthlyReportPL,
    getSubmission,
    checkUploadMB,
    getAllOperatingInd,
    getOperatingIndDetail,
    createOpetaingInd,
    uploadMasterBudget,
    getAllSettingByType,
    getOpetratingIndID,
    createAllItemReport,
    deleteAllItemReport,
    validateSubmitReport,
    checkUploadOperatingInd,
    uploadOperatingInd,
    getLastestUpdateMB,
    getLastestUpdateMR,
    getLastestUpdateMROI,
    countingFormula,
    submitMasterBudget,
    checkIsSubmit,
    getIdDeleteFromExcel,
    getDashboard,
    historyApproval,
    getDashboardMB,
    checkApprover,
    approvalSubmission,
    getCompanySubmitted,
    getLastPeriod,
    getLastPeriodMonthly,
    checkApproverMonthly,
    getCompanySubmittedMonthly,
    historyApprovalMonthly,
    uploadAttachmentMonthly,
    getMontlyReportAtt,
    deleteAttachmentMonthly,
    getSubmitMasterBudget,
    createPeriodeRevision,
    getLastestUpdateOI,
    getOutlookPAID,
    getLastPeriodOLPA,
    getCompanySubmittedOLPA,
    getRevisionOLPA,
    historyApprovalOLPA,
    getSubmitOLPA,
    getOLPAAtt,
    submitOLPA,
    getLastestUpdateOLPA,
    createReportOLPA,
    checkUploadOLPA,
    uploadOLPA,
    validateSubmitReportOLPA,
    getDetailReportOLPA,
    uploadAttOLPA,
    deleteAttOLPA,
    getReportOLPA,
    approvalSubmissionOLPA,
    checkApproverOLPA,
    getLastPeriodeOI,
    getSubmitOI,
    getLastPeriodOI,
    getDashboardUser,
    getHierarkiMontlyReportBS,
    getHierarkiMontlyReportOI,
    getHierarkiMontlyReportTP,
    getDetailReportCF,
    getReportHierarkiPL,
    getMonthlyReportID,
    getReportHierarkiFRMB,
    getReportHierarkiFRMR,
    getDetailHierarkiCF,
    getHierarkiMontlyReportPL,
    getHierarkiMontlyReportLOCF,
    getHierarkiMontlyReportFAM,
    getHierarkiMontlyReportCAT,
    checkUploadMonthlyReportTP,
    checkUploadMonthlyReportFAM,
    checkUploadMonthlyReportOI,
    checkUploadMonthlyReportCAT,
    uploadMonthlyReportPL,
    getMonthlyReport,
    checkUploadMonthlyReportBS,
    uploadMonthlyReportBS,
    uploadMonthlyReportFAM,
    uploadMonthlyReportTP,
    uploadMonthlyReportOI,
    uploadMonthlyReportCAT,
    getHierarkiMontlyReportCF,
    validateSubmitReportMR,
    validateSubmitReportMRTP,
    validateSubmitReportBS,
    validateSubmitReportPL,
    getPerBSiMontlyReportLOCF,
    checkUploadMonthlyReportLOCF,
    uploadMonthlyReportLOCF,
    validateSubmitReportOI,
    getMonthlyOI,
    getParameterByGroupName,
    getSubmitMonthlyReport,
    getIdDeleteFromExcelLOCF,
    deleteAllItemReportLOCF,
    submitMonthlyReport,
    approvalMonthly,
    createPeriodeRevisionMonthly,
    getListUserSubcoMB,
    getListUserSubcoMR,
    getListUserSubcoRO,
    getListUserSubcoOL,
    validateSubmitReportFAM,
    createMonthlyReportCF,
    getReportBSMB,
    getReportBSMR,
    getReportPLDetailMB,
    getReportPLDetailMR,
    // getReportPLMB,
    // getReportPLMR,
    getReportTPMB,
    getReportTPMR,
    getReportTP,
    getReportOIMB,
    getReportOIMR,
    getReportCFSumaMB,
    getReportCFSumaMR,
    createReportCF,
    createReportCFSimulasi,
    getReportCFSuma,
    getReportPLSuma,
    getReportPLSummary,
    getAllReportBS,
    getAllReportPLDetail,
    getAllReportOI,
    getReportFRSuma,
    getReportFRMB,
    getReportFRMR,
    getReportFRLastMR,
    getReportBSSuma,
    getDashboardCAT,
    getReportPL,
    getReportFR,
    getHierarkiCreateReportPLMB,
    getHierarkiCreateReportPLMR,
    createReportPLMB,
    createReportPLMR,
    getPLID,
    getFRID,
    getHierarkiReportHistorical,
    getHierarkiReportMTD,
    getHierarkiReportYtd,
    getHierarkiReportCPSM,
    getHierarkiCreateReportFRMB,
    getHierarkiCreateReportFRMR,
    createReportFRMB,
    createReportFRMR,
    getFullApproveMB,
    getFullApproveMonthly,
    getDashboardFinancial,
    getReportCATPA,
    getReportCATPQ,
    getHierarkiCronJobMBPL,
    getHierarkiCronJobMBCF,
    getHierarkiCronJobMBRatio,
    getHierarkiCronJobMRPL,
    getHierarkiCronJobMRCF,
    getHierarkiCronJobMRRatio,
    getRollingOutlookID,
    getRollingOutlookBS,
    createRollingOutlookBS,
    getRollingOutlookTP,
    createRollingOutlookTP,
    checkImportRollingOutlookTP,
    importRollingOutlookTP,
    getAllMasterDataCat,
    getParentItemReport,
    saveMasterDataCat,
    updateMasterDataCat,
    getDetailMasterDataCat,
    deleteMasterDataCat,
    getListChildDashboardCAT,
    getDashboardCATDetail,
    getRollingOutlookPL,
    getRollingOutlookAttachment,
    uploadRollingOutlookAttachment,
    deleteRollingOutlookAttachment,
    getRollingOutlookReport,
    getRollingOutlookLastUpdate,
    getRollingOutlookRevision,
    getRollingOutlookIsApprover,
    uploadAttachmentRO,
    deleteAttachmentRO,
    checkImportRollingOutlookBS,
    importRollingOutlookBS,
    getRollingOutlookCAT,
    createRollingOutlookCAT,
    checkImportRollingOutlookCAT,
    importRollingOutlookCAT,
    createRollingOutlookPL,
    checkImportRollingOutlookPL,
    importRollingOutlookPL,
    getSubmitRollingOutlook,
    getRollingOI,
    getHierarkiRollingOI,
    createRollingOI,
    getLastestUpdateROOI,
    checkUploadRollingOutlookOI,
    uploadRollingOutlookOI,
    submitRollingOutlook,
    getRollingOutlookCompanySubmitted,
    createPeriodeRevisionOLPA,
    approvalRolling,
    createPeriodeRevisionRO,
    historyApprovalRO,
    getRollingOutlookCF,
    createRollingOutlookCF,
    getHierarkiCFOLPA,
    createCFOLPA,
    getHierarkiDBPLOLPA,
    createDBPLOLPA,
    getHierarkiDBPLRO,
    createDBPLRO,
    getDetailReportOLPACAT,
    createCATOLPA,
    getRatioLOCF,
    triggerRatioFromLOCF,
    triggerRatioMB,
    triggerRatioRO,
    triggerRatioOLPA,
    getMonitoringMB,
    getMonitoringMR,
    getMonitoringRO,
    getMonitoringOLPA,
    getMonitoringCafrm,
    getListApprover,
    getIdToken,
    triggerHistoricalRatio,
    getDetailMaintenanceMode,
    createMaintenanceMode,
    updateMaintenanceMode,
    createZipReport,
    createDownloadFile,
    getListDownload,
    downloadZipReport,
    sendEmail,
    uploadSimulasiMB,
    createReportPLMBSimulasi,
    triggerRatioMBSimulasi,
    uploadSimulasiMRPL,
    uploadSimulasiMRTP,
    uploadSimulasiMRBS,
    uploadSimulasiMRFAM,
    uploadSimulasiMRLOCF,
    uploadSimulasiMRCAT,
    uploadSimulasiMRCF,
    createSimulasiReportPLMR,
    triggerHistoricalRatioSimulasi,
    triggerRatioFromLOCFSimulasi,
    uploadSimulasiROPL,
    uploadSimulasiROTP,
    uploadSimulasiROBS,
    uploadSimulasiROCAT,
    createRollingOutlookCFSimulasi,
    createDBPLROSimulasi,
    triggerRatioROSimulasi,
    uploadSimulasiOLPA,
    createDBPLOLPASimulasi,
    triggerRatioOLPASimulasi,
    createSimulasiOLPACF,
    uploadSimulasiOperatingInd,
    uploadSimulasiMROI,
    uploadSimulasiROOI,

  }
}

// let's return back our create method as the default.
export default {
  create
}
