import React from 'react';

var mainColor = "#fff"
var secondColor = "#f6f6f6"

export function customTable() {
  return {
    typography: {
      useNextVariants: true,
    },
    overrides: {
      MUIDataTable: {
        paper: {
          position: 'relative',
          // width: '100% !important',
          boxShadow: "0 0 0 0 rgba(154,161,171,.15)",
          border: "1px rgba(0,0,0,0.1) solid",
          borderRadius: "10px",
          overflow: "hidden",
        },
        // responsiveScroll: {
        //   position: 'relative',
        //   width: '100% !important',
        // }
        responsiveScrollMaxHeight: {
          height: 'calc(100vh - 250px)',
          maxHeight: 'calc(100vh - 250px)'
        },
      },
      MuiToolbar: {
        root: {
          position: 'relative',
        }
      },
      MUIDataTableToolbar: {
        root: {
          position: 'relative',
          padding: "0px 15px",
          backgroundColor: '#f2f6fa', //'rgba(0,76,151,0.05)',
        },
        titleText: {
          color: "#555"
        },
        icon: {
          color: "#555 !important"
        },
        iconActive: {
          color: "#555 !important"
        },
        left: {
          flex: "0 0 auto !important"
        },
        actions: {
          flex: "1 0 auto !important"
        }
      },
      MUIDataTableSearch: {
        main: {
          position: 'absolute',
          top: "2px",
          right: "2px",
          width: "350px !important",
          backgroundColor: "#f2f6fa",
          zIndex: "10",
          textAlign: "right",
          display: "block",
        },
        searchIcon: {
          width: "50px !important",
          color: "#555 !important",
          display: "inline-block",
          textAlign: "center",
          verticalAlign: "top",
        },
        searchText: {
          width: "calc(100% - 120px) !important",
          marginRight: "10px",
          color: "#555 !important",
          display: "inline-block",
          verticalAlign: "top",
        },
        clearIcon: {
          width: "50px !important",
          color: "#555 !important",
          display: "inline-block",
          verticalAlign: "top",
        },
      },
      MuiTableCell: {
        root: {
          display: 'table-cell',
          padding: 15,
          paddingLeft: 25,
          fontSize: '0.875rem',
          textAlign: 'left',
          fontFamily: "Roboto, Helvetica, Arial, sans-serif",
          fontWeight: 400,
          lineHeight: 1.43,
          borderBottom: '1px solid rgba(224, 224, 224, 1)',
          letterSpacing: '0.01071em',
          verticalAlign: 'inherit',
        }
      },
      MuiPopover: {
        paper: {
          outline: 0,
          position: 'absolute',
          maxWidth: 'calc(100% -32px)',
          minWidth: 199,
          maxHeight: 'calc(100% -32px)',
          minHeight: 16,
          overflowX: 'hidden',
          overflowY: 'auto',
          width: 400
        }
      },
      MUIDataTableFilterList: {
        root: {
          backgroundColor: "#f2f6fa",
          margin: "0px 0px 0px 0px",
          padding: "0px 16px 0px 16px"
        },
        chip: {
          margin: "8px 8px 8px 0px",
          color: "#555",
        }
      },
      MUIDataTableHead: {
        main: {
          position: 'relative',
          backgroundColor: mainColor,
          color: "#555",
          // display: "flex",
          // alignItems: "stretch"
        },
        fixedHeader: {
          // position: "relative",
          borderBottom: "1px rgba(0,0,0,0.1) solid",
          backgroundColor: '#f2f6fa', //'rgba(0,76,151,0.05)',
          color: "#555",
          padding: "10px 20px",
          height: "auto"
          ,
          marginTop: "10px"
        },
      },
      MUIDataTableHeadRow: {
        root: {
          position: 'relative',
          backgroundColor: mainColor,
        }
      },
      MUIDataTableHeadCell: {
        root: {
          fontSize: "10pt",
          fontWeight: "500",
          color: "#555",
          backgroundColor: secondColor,
        },
        fixedHeader: {
          // position: "relative",
          borderBottom: "1px rgba(0,0,0,0.1) solid",
          backgroundColor: '#f2f6fa', //'rgba(0,76,151,0.05)',
          color: "#555",
          padding: "10px 25px",
          height: "auto"
        },
        toolButton: {
          display: "flex",
          height: "auto",
          whiteSpace: 'nowrap'
        },
        data: {
          display: "inline-block",
          verticalAlign: "top",
        },
        sortActive: {
          color: "#555"
        },
        sortAction: {
          color: "#555",
          display: "inline-block",
          verticalAlign: "top",
          MuiButtonBase: {
            color: "#555",
            root: {
              color: "#555",
            }
          }
        }
      },
      MUIDataTableBodyCell: {
        root: {
          position: 'relative',
          fontSize: "13px",
        }
      },
      MUIDataTableSelectCell: {
        headerCell: {
          backgroundColor: secondColor,
          checkboxRoot: {
            color: "#555",
          }
        },
        checkboxRoot: {
          color: "#555"
        }
      },
      MuiInput: {
        root: {
          top: "5px",
          color: "#555 !important",
        },
        underline: {
          borderBottom: "1px #555 solid !important",
        }
      },
      MuiSelect: {
        root: {
          top: "0",
          color: "#555 !important",
        },
      }
      // MuiIconButton: {
      //   root: {
      //     color: "#fff !important",
      //   }
      // }
    }
  }
}

export function customTable2() {
  return {
    typography: {
      useNextVariants: true,
    },
    overrides: {
      MUIDataTable: {
        root: {
          backgroundColor: secondColor,
        },
        paper: {
          boxShadow: "0 0 30px 0 rgba(154,161,171,.15)",
          border: "1px rgba(0,0,0,0.1) solid",
          borderRadius: "5px",
          overflow: "hidden",
        },
      },
      MuiToolbar: {
        root: {
          left: {
            flex: "0 0 auto !important"
          },
          actions: {
            flex: "0 0 auto !important"
          }
        }
      },
      MUIDataTableToolbar: {
        root: {
          backgroundColor: secondColor,
        },
        titleText: {
          color: "#555"
        },
        icon: {
          color: "#555"
        },
      },
      MUIDataTableSearch: {
        searchIcon: {
          color: "#555"
        },
        searchText: {
          color: "#555",
        },
        clearIcon: {
          color: "#555"
        },
      },
      MUIDataTableHead: {
        main: {
          backgroundColor: mainColor,
          color: "#555"
        }
      },
      MUIDataTableHeadRow: {
        root: {
          backgroundColor: mainColor,
        }
      },
      MUIDataTableHeadCell: {
        root: {
          fontSize: "10pt",
          fontWeight: "500",
          color: mainColor,
        },
        fixedHeader: {
          position: "relative",
          backgroundColor: secondColor,
          color: "#555",
          padding: "10px",
          height: "auto",
        },
        toolButton: {
          display: "flex",
          height: "auto"
        },
        data: {
          display: "inline-block",
          verticalAlign: "top",
        },
        sortActive: {
          color: "#555"
        },
        sortAction: {
          color: "#555",
          display: "inline-block",
          verticalAlign: "top",
          MuiButtonBase: {
            color: "#555",
            root: {
              color: "#555",
            }
          }
        }
      },
      MUIDataTableBodyCell: {
        root: {
          fontSize: "10pt",
          padding: "10px"
        }
      },
      MUIDataTableSelectCell: {
        headerCell: {
          backgroundColor: secondColor,
          checkboxRoot: {
            color: "#fff",
          }
        },
        checkboxRoot: {
          color: "#555"
        }
      },
    }
  }
}

export function customTable3() {
  return {
    typography: {
      useNextVariants: true,
    },
    overrides: {
      MUIDataTable: {
        root: {
          backgroundColor: secondColor,
        },
        paper: {
          boxShadow: "0 0 30px 0 rgba(154,161,171,.15)",
          border: "1px rgba(0,0,0,0.1) solid",
          borderRadius: "5px",
          overflow: "hidden",
        },
      },
      responsiveScrollMaxHeight: {
      },
      MuiToolbar: {
        root: {
          left: {
            flex: "0 0 auto !important"
          },
          actions: {
            flex: "0 0 auto !important"
          }
        }
      },
      MUIDataTableToolbar: {
        root: {
          backgroundColor: secondColor,
        },
        titleText: {
          color: "#555"
        },
        icon: {
          color: "#555"
        },
      },
      MUIDataTableSearch: {
        searchIcon: {
          color: "#555"
        },
        searchText: {
          color: "#555",
        },
        clearIcon: {
          color: "#555"
        },
      },
      MUIDataTableHead: {
        main: {
          backgroundColor: mainColor,
          color: "#555"
        }
      },
      MUIDataTableHeadRow: {
        root: {
          backgroundColor: mainColor,
        }
      },
      MUIDataTableHeadCell: {
        root: {
          fontSize: "10pt",
          fontWeight: "500",
          color: mainColor,
        },
        fixedHeader: {
          position: "relative",
          backgroundColor: secondColor,
          color: "#555",
          padding: "10px",
          height: "auto",
        },
        toolButton: {
          display: "flex",
          height: "auto"
        },
        data: {
          display: "inline-block",
          verticalAlign: "top",
        },
        sortActive: {
          color: "#555"
        },
        sortAction: {
          color: "#555",
          display: "inline-block",
          verticalAlign: "top",
          MuiButtonBase: {
            color: "#555",
            root: {
              color: "#555",
            }
          }
        }
      },
      MUIDataTableBodyCell: {
        root: {
          fontSize: "10pt"
        }
      },
      ColorPallete3: {
        backgroundColor: '#37b5e6'
      },
      MuiTableCell: {
        root: {
          display: 'table-cell',
          padding: 7,
          paddingLeft: 25,
          paddingRight: 25,
          fontSize: '0.875rem',
          textAlign: 'left',
          fontFamily: "Roboto, Helvetica, Arial, sans-serif",
          fontWeight: 400,
          lineHeight: 1.43,
          borderBottom: '1px solid rgba(224, 224, 224, 1)',
          letterSpacing: '0.01071em',
          verticalAlign: 'inherit',
        }
      },
      MUIDataTableSelectCell: {
        headerCell: {
          backgroundColor: secondColor,
          checkboxRoot: {
            color: "#fff",
          }
        },
        checkboxRoot: {
          color: "#555"
        }
      },
    }
  }
}

export function customTable4() {
  return {
    typography: {
      useNextVariants: true,
    },
    overrides: {
      MUIDataTable: {
        root: {
          backgroundColor: secondColor,
        },
        paper: {
          boxShadow: "0 0 30px 0 rgba(154,161,171,.15)",
          border: "1px rgba(0,0,0,0.1) solid",
          borderRadius: "5px",
          overflow: "hidden",
        },
        responsiveScrollMaxHeight: {
          maxHeight: '700px !important'
        },
      },
      MuiToolbar: {
        root: {
          left: {
            flex: "0 0 auto !important"
          },
          actions: {
            flex: "0 0 auto !important"
          }
        }
      },
      MUIDataTableToolbar: {
        root: {
          backgroundColor: secondColor,
        },
        titleText: {
          color: "#555"
        },
        icon: {
          color: "#555"
        },
      },
      MUIDataTableSearch: {
        searchIcon: {
          color: "#555"
        },
        searchText: {
          color: "#555",
        },
        clearIcon: {
          color: "#555"
        },
      },
      MUIDataTableHead: {
        main: {
          backgroundColor: mainColor,
          color: "#555"
        }
      },
      MUIDataTableHeadRow: {
        root: {
          backgroundColor: mainColor,
        }
      },
      MUIDataTableHeadCell: {
        root: {
          fontSize: "10pt",
          fontWeight: "500",
          color: mainColor,
        },
        fixedHeader: {
          position: "relative",
          backgroundColor: secondColor,
          color: "#555",
          padding: "10px",
          height: "auto",
        },
        toolButton: {
          display: "flex",
          height: "auto"
        },
        data: {
          display: "inline-block",
          verticalAlign: "top",
        },
        sortActive: {
          color: "#555"
        },
        sortAction: {
          color: "#555",
          display: "inline-block",
          verticalAlign: "top",
          MuiButtonBase: {
            color: "#555",
            root: {
              color: "#555",
            }
          }
        }
      },
      MUIDataTableBodyCell: {
        root: {
          fontSize: "10pt"
        }
      },
      ColorPallete3: {
        backgroundColor: '#37b5e6'
      },
      MuiTableCell: {
        root: {
          display: 'table-cell',
          padding: 7,
          paddingLeft: 0,
          paddingRight: 0,
          fontSize: '0.875rem',
          textAlign: 'left',
          fontFamily: "Roboto, Helvetica, Arial, sans-serif",
          fontWeight: 400,
          lineHeight: 1.43,
          borderBottom: '1px solid rgba(224, 224, 224, 1)',
          letterSpacing: '0.01071em',
          verticalAlign: 'inherit',
        }
      },
      MUIDataTableSelectCell: {
        headerCell: {
          backgroundColor: secondColor,
          checkboxRoot: {
            color: "#fff",
          }
        },
        checkboxRoot: {
          color: "#555"
        }
      },
    }
  }
}

export function customTable6() {
  return {
    typography: {
      useNextVariants: true,
    },
    overrides: {
      MUIDataTable: {
        paper: {
          position: 'relative',
          // width: '100% !important',
          boxShadow: "0 0 0 0 rgba(154,161,171,.15)",
          border: "1px rgba(0,0,0,0.1) solid",
          borderRadius: "10px",
          overflow: "hidden",
        },
        responsiveScroll: {
          position: 'relative',
          width: '100% !important',
        },
        responsiveScrollMaxHeight: {
          height: 'calc(200vh - 250px)',
          maxHeight: 'calc(200vh - 250px)'
        },
      },
      MuiToolbar: {
        root: {
          position: 'relative',
        }
      },
      MUIDataTableToolbar: {
        root: {
          position: 'relative',
          padding: "0px 15px",
          backgroundColor: '#f2f6fa', //'rgba(0,76,151,0.05)',
        },
        titleText: {
          color: "#555"
        },
        icon: {
          color: "#555 !important"
        },
        iconActive: {
          color: "#555 !important"
        },
        left: {
          flex: "0 0 auto !important"
        },
        actions: {
          flex: "1 0 auto !important"
        }
      },
      MUIDataTableSearch: {
        main: {
          position: 'absolute',
          top: "2px",
          right: "2px",
          width: "350px !important",
          backgroundColor: "#f2f6fa",
          zIndex: "10",
          textAlign: "right",
          display: "block",
        },
        searchIcon: {
          width: "50px !important",
          color: "#555 !important",
          display: "inline-block",
          textAlign: "center",
          verticalAlign: "top",
        },
        searchText: {
          width: "calc(100% - 120px) !important",
          marginRight: "10px",
          color: "#555 !important",
          display: "inline-block",
          verticalAlign: "top",
        },
        clearIcon: {
          width: "50px !important",
          color: "#555 !important",
          display: "inline-block",
          verticalAlign: "top",
        },
      },
      MuiTableCell: {
        root: {
          display: 'table-cell',
          padding: 10,
          paddingLeft: 25,
          paddingRight: 25,
          fontSize: '0.875rem',
          textAlign: 'left',
          fontFamily: "Roboto, Helvetica, Arial, sans-serif",
          fontWeight: 400,
          lineHeight: 1.43,
          borderBottom: '1px solid rgba(224, 224, 224, 1)',
          letterSpacing: '0.01071em',
          verticalAlign: 'inherit',
        }
      },
      MuiPopover: {
        paper: {
          outline: 0,
          position: 'absolute',
          maxWidth: 'calc(100% -32px)',
          minWidth: 199,
          maxHeight: 'calc(100% -32px)',
          minHeight: 16,
          overflowX: 'hidden',
          overflowY: 'auto',
          width: 400
        }
      },
      MUIDataTableFilterList: {
        root: {
          backgroundColor: "#f2f6fa",
          margin: "0px 0px 0px 0px",
          padding: "0px 16px 0px 16px"
        },
        chip: {
          margin: "8px 8px 8px 0px",
          color: "#555",
        }
      },
      MUIDataTableHead: {
        main: {
          position: 'relative',
          backgroundColor: mainColor,
          color: "#555",
          // display: "flex",
          // alignItems: "stretch"
        },
        fixedHeader: {
          // position: "relative",
          borderBottom: "1px rgba(0,0,0,0.1) solid",
          backgroundColor: '#f2f6fa', //'rgba(0,76,151,0.05)',
          color: "#555",
          padding: "10px 20px",
          height: "auto"
          ,
          marginTop: "10px"
        },
      },
      MUIDataTableHeadRow: {
        root: {
          position: 'relative',
          backgroundColor: mainColor,
        }
      },
      MUIDataTableHeadCell: {
        root: {
          fontSize: "10pt",
          fontWeight: "500",
          color: "#555",
          backgroundColor: secondColor,
        },
        fixedHeader: {
          // position: "relative",
          borderBottom: "1px rgba(0,0,0,0.1) solid",
          backgroundColor: '#f2f6fa', //'rgba(0,76,151,0.05)',
          color: "#555",
          padding: "10px 25px",
          height: "auto"
        },
        toolButton: {
          display: "flex",
          height: "auto",
          whiteSpace: 'nowrap'
        },
        data: {
          display: "inline-block",
          verticalAlign: "top",
        },
        sortActive: {
          color: "#555"
        },
        sortAction: {
          color: "#555",
          display: "inline-block",
          verticalAlign: "top",
          MuiButtonBase: {
            color: "#555",
            root: {
              color: "#555",
            }
          }
        }
      },
      MUIDataTableBodyCell: {
        root: {
          position: 'relative',
          fontSize: "13px",
        }
      },
      MUIDataTableSelectCell: {
        headerCell: {
          backgroundColor: secondColor,
          checkboxRoot: {
            color: "#555",
          }
        },
        checkboxRoot: {
          color: "#555"
        }
      },
      MuiInput: {
        root: {
          top: "5px",
          color: "#555 !important",
        },
        underline: {
          borderBottom: "1px #555 solid !important",
        }
      },
      MuiSelect: {
        root: {
          top: "0",
          color: "#555 !important",
        },
      }
      // MuiIconButton: {
      //   root: {
      //     color: "#fff !important",
      //   }
      // }
    }
  }
}

export function customOptions() {
  return {
    // selectableRows: false,
    selectableRows: 'none',
    filterType: 'multiselect',
    responsive: 'scroll',
    viewColumns: true,
    rowsPerPage: 5,
    rowsPerPageOptions: [5, 10, 20, 50],
    print: false,
    download: false,
    elevation: 5,
    filter: true,
    search: true,
  }
}

export function customOptions2() {
  return {
    // selectableRows: false,
    selectableRows: 'none',
    filterType: 'multiselect',
    responsive: 'scrollMaxHeight',
    rowsPerPage: 5,
    rowsPerPageOptions: [5, 10, 20, 50],
    print: false,
    download: false,
    elevation: 5,
  }
}

export function customOptionsFixedColumn() {
  return {
    // selectableRows: false,
    selectableRows: 'none',
    filterType: false,
    filter: false,
    sort: false,
    responsive: 'scrollMaxHeight',
    viewColumns: false,
    // overflowX: 'auto',
    print: false,
    download: false,
    elevation: 5,
    search: false,
    pagination: false
  }
}

export function customOptionsManagementDocument() {
  return {
    // selectableRows: false,
    selectableRows: 'none',
    filterType: 'multiselect',
    responsive: 'scroll',
    viewColumns: true,
    rowsPerPage: 10,
    rowsPerPageOptions: [10, 20, 30, 50],
    print: false,
    download: false,
    elevation: 5,
    filter: true,
    search: true,
  }
}

export function customOptionsFixedColumnMonitoring() {
  return {
    selectableRows: false,
    selectableRows: 'none',
    filterType: false,
    filter: false,
    sort: true,
    responsive: 'scrollMaxHeight',
    viewColumns: false,
    // overflowX: 'auto',
    print: false,
    download: false,
    elevation: 5,
    search: true,
    pagination: true,
    rowsPerPage: 25,
    rowsPerPageOptions: [25, 50, 100, 200],
  }
}