import { createMuiTheme, FormControlLabel, Input, MuiThemeProvider, TableCell, Typography } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import api from '../../api'
import NumberFormat from 'react-number-format';
import * as R from 'ramda'


var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};
const stylenotes = {
    position: "sticky",
    background: "white",
    zIndex: 101,
    left: 350
};

const styleNotesEmpty = {
    position: "sticky",
    background: "white",
    zIndex: 99,
    left: 0
}

export default class TableSubHolding extends Component {
    constructor(props) {
        super(props)
        this.state = {
            performanceScoreColor: '#fff',
            performanceScoreColorQuarterly: '#fff',
            performanceScoreColorFy: '#fff',
            parameterScore: [],
            totalScore: 0,
            totalScoreQuarterly: 0,
            totalScoreFy: 0,
            performanceScore: '',
            performanceScoreQuarterly: '',
            performanceScoreFy: '',
            parameterPerfom: [],
        }
    }

    componentDidMount() {
        if (this.props.type === 10 || this.props.type === 11) {
            this.getParameterGroup()
            this.getParameterGroupPerfom()    
        }        
    }

    getParameterGroup() {
        api.create().getParameterByGroupName({
            "group_name": 'ACHIEVEMENT_KPI'
        }).then((response) => {
            // console.log(response.data)
            if (response.data) {
                this.setState({ parameterScore: response.data.data })
            }
        })
    }

    getParameterGroupPerfom() {
        api.create().getParameterByGroupName({
            "group_name": "PERFORMANCE_KPI"
        }).then((response) => {
            // console.log(response.data)
            if (response.data) {
                this.setState({ parameterPerfom: response.data.data }, () => { 
                    this.handleTotalScore(this.props.dataTable)
                })
            }
        })
    }

    handleTotalScore(dataTable2) {
        // console.log(dataTable2);
        this.setState({ loading: true }, () => {
            let totalWeight = 0
            let total = 0
            let score = 0
            let totalWeightQuarterly = 0
            let totalWeightFy = 0
            let totalQuarterly = 0
            let totalFy = 0
            let scoreQuarterly = 0
            let scoreFy = 0
            let performanceScore = ''
            let performanceScoreQuarterly = ''
            let performanceScoreFy = ''
            dataTable2.map((item, index) => {
                // console.log(item[6])
                //total weight
                if (this.props.type === 10) {
                    if (item[0] !== 1 && item[0] !== 4) {
                        if (item[12] == '' || String(item[12]) == '0' || String(item[12]) == '0.0') {
                            totalWeight += Number(0)
                        } else {
                            totalWeight += Number(item[6])
                        }
                    }
                    if (item[0] !== 1 && item[0] !== 4) {
                        total += Number(item[15])
                    }
                } else {
                    if (item[0] !== 1 && item[0] !== 4) {
                        // Quarterly
                        if (item[13] == '' || String(item[13]) == '0' || String(item[13]) == '0.0') {
                            totalWeightQuarterly += Number(0)
                        } else {
                            totalWeightQuarterly += Number(item[6])
                        }
                        // FY
                        if (item[22] == '' || String(item[22]) == '0' || String(item[22]) == '0.0') {
                            totalWeightFy += Number(0)
                        } else {
                            totalWeightFy += Number(item[6])
                        }
                    }
                    if (item[0] !== 1 && item[0] !== 4) {
                        totalQuarterly += Number(item[18])
                        totalFy += Number(item[26])
                    }
                }
            })
            totalWeight = Number(totalWeight) / 100
            totalWeightQuarterly = Number(totalWeightQuarterly) / 100
            totalWeightFy = Number(totalWeightFy) / 100
            // console.log(total);
            // console.log(totalWeight);
            score = Number(Number(total).toFixed(2) / Number(totalWeight)).toFixed(2)
            scoreQuarterly = Number(Number(totalQuarterly).toFixed(2) / Number(totalWeightQuarterly)).toFixed(2)
            scoreFy = Number(Number(totalFy).toFixed(2) / Number(totalWeightFy)).toFixed(2)
            
            let lastTotal = isNaN(score) ? "0.0" : score
            let lastTotalQuarterly = isNaN(scoreQuarterly) ? "0.0" : scoreQuarterly
            let lastTotalFy = isNaN(scoreFy) ? "0.0" : scoreFy

            let indexPerform = this.state.parameterPerfom.findIndex((val) => val.company_id == this.props.company.company_id)
            let listPerfomanceDefault = []
            if (indexPerform == -1) {
                listPerfomanceDefault = this.state.parameterPerfom.filter((val) => String(val.company_name).toLocaleLowerCase() == "default")
            } else {
                listPerfomanceDefault = this.state.parameterPerfom.filter((val) => val.company_id == this.props.company.company_id)
            }
            let performanceScoreColor = '#fff'
            let performanceScoreColorQuarterly = '#fff'
            let performanceScoreColorFy = '#fff'
            if (listPerfomanceDefault.length > 0) {
                listPerfomanceDefault.map((item, index) => {
                    // console.log(Number(lastTotal))
                    // console.log(Number(item.min_value))
                    // console.log(Number(item.max_value))
                    if (this.props.type === 10) {
                        if (Number(lastTotal) >= Number(item.min_value) && Number(lastTotal) <= Number(item.max_value)) {
                            console.log('masuk appraisal')
                            performanceScore = item.description
                            performanceScoreColor = item.value
                        }
                    } else {
                        if (Number(lastTotalQuarterly) >= Number(item.min_value) && Number(lastTotalQuarterly) <= Number(item.max_value)) {
                            // console.log('masuk quarterly')
                            performanceScoreQuarterly = item.description
                            performanceScoreColorQuarterly = item.value
                        }
                        if (Number(lastTotalFy) >= Number(item.min_value) && Number(lastTotalFy) <= Number(item.max_value)) {
                            // console.log('masuk fy')
                            performanceScoreFy = item.description
                            performanceScoreColorFy = item.value
                        }
                    }                    
                })
            }
            // console.log(performanceScoreColor)
            // console.log(this.state.parameterPerfom)
            // console.log(listPerfomanceDefault)
            // console.log(performanceScore)
            // console.log(performanceScoreColor)

            setTimeout(() => {
                this.setState({ totalScore: lastTotal, totalScoreQuarterly: lastTotalQuarterly, totalScoreFy: lastTotalFy, performanceScore, performanceScoreQuarterly, performanceScoreFy, loading: false, performanceScoreColor, performanceScoreColorQuarterly, performanceScoreColorFy }, () => {
                    this.setState({ loading: true })
                    setTimeout(() => {
                        this.setState({ loading: false })
                    }, 500);
                })
            }, 500);
        })
    }

    render() {
        let dataTable2 = this.props.dataTable
        const handleChangeBS = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            if (type === "actual") {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val).toFixed(1)
            } else {
                let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[tableMeta.rowIndex][2])
                if (indexParent > 0) {
                    // console.log(indexParent)
                    let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                    let jagain = dataTable2[indexParent][tableMeta.columnIndex]
                    a = dataTable2[indexParent][tableMeta.columnIndex] = jagain === undefined ? (0 + Number(val)).toFixed(1) : Number(jagain + Number(val)).toFixed(1)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val).toFixed(1)
                }
            }
        }
        const handleValueBS = (data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] === item[2]) {
                    total = item[data.columnIndex] === undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex] = Number(total).toFixed(1)
            // console.log(indexParent);
            return a
        }
        const handleFormulaBS = (data, tableMeta) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayJumlah = []
            arrayFormula.map((item, indexs) => {
                let index = dataTable2.findIndex((val) => val[22] == item)
                if (index > 0) {
                    arrayJumlah.push(dataTable2[index][tableMeta.columnIndex])
                } else {
                    arrayJumlah.push(item)
                }
                // if (indexs % 2 !== 0) {
                //     operator.push(item)
                // }
            })
            let array = arrayJumlah
            let total = 0
            let opt = ""
            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item)
                    } else {
                        total += item
                    }
                }
            })
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total).toFixed(1)
            return a

        }
        const handleValidationBS = (data, tableMeta) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayJumlah = []
            arrayFormula.map((item, indexs) => {
                let index = dataTable2.findIndex((val) => val[22] == item)
                if (index > 0) {
                    arrayJumlah.push(dataTable2[index][tableMeta.columnIndex])
                } else {
                    arrayJumlah.push(item)
                }
                // if (indexs % 2 !== 0) {
                //     operator.push(item)
                // }
            })
            let array = arrayJumlah
            let total = 0
            let opt = ""
            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item)
                    } else {
                        total += item
                    }
                }
            })
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total).toFixed(1)
            return a
        }

        const handleNotes = (value, tableMeta) => {
            // console.log(value)
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
            // console.log(dataTable2[tableMeta.rowIndex]);
        }
        const handleChangePLDetail = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            if (type === "actual") {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            } else {
                // let indexParent = dataTable2.findIndex((val) => val[1] == dataTable2[tableMeta.rowIndex][2])
                // if (indexParent > 0) {
                //     // // console.log(indexParent)
                //     let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                //     let jagain = dataTable2[indexParent][tableMeta.columnIndex]
                //     a = dataTable2[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (Number(jagain) + Number(val))
                // } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                // }

            }
        }
        const handleTotalPLDetail = (tableMeta) => {
            let total = 0
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index >= 8 && index <= 19) {
                    let valItem = item == undefined || item == "" ? 0 : item
                    total += Number(valItem)
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] == tableMeta.rowData[2])
            if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "sales price") {
                let value = Number(dataTable2[tableMeta.rowIndex - 2][20]) / Number(dataTable2[tableMeta.rowIndex - 1][20])
                dataTable2[tableMeta.rowIndex][20] = R.equals(value, NaN) ? "0.0" : value
                return R.equals(value, NaN) ? "0.0" : value
            } else if (indexParent !== -1 && String(dataTable2[indexParent][5]).toLocaleUpperCase() == "GROSS PROFIT MARGIN (% OF REVENUE)") {
                return handleFormulaPLDetail(0, tableMeta, 0)
            }
            else {

                dataTable2[tableMeta.rowIndex][20] = total
                return total
            }
            // console.log(total);
        }
        const handleValuePLDetail = (data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] == item[2]) {
                    total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] == dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex] = Number(total)
            // console.log(indexParent);
            return a
        }
        const handleFormulaPLDetail = (data, tableMeta, month) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayJumlah = []
            arrayFormula.map((item, indexs) => {
                let index = dataTable2.findIndex((val) => val[23] == item)
                if (index > 0) {
                    arrayJumlah.push(dataTable2[index][tableMeta.columnIndex])
                } else {
                    arrayJumlah.push(item)
                }
                // if (indexs % 2 !== 0) {
                //     operator.push(item)
                // }
            })
            let array = arrayJumlah
            let total = 0
            let opt = ""
            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = R.equals((Number(total) / Number(item)), NaN) ? '0' : Number(total) / Number(item)
                    } else {
                        total += item
                    }
                }
            })
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total)
            return a

        }

        const handleValueFormulaDBPL = (value, tableMeta, column, periode, forecast) => {
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            // let splitFormula = String(tableMeta.rowData[3]).split('@')
            let baru = []
            let anjay = []

            // if (forecast !== undefined) {
            //     console.log(tableMeta)
            // }

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                let asd = ''
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (forecast !== undefined) {
                            let forecastt = 0
                            forecast.map((items, index) => {
                                if (items.periode == periode) {
                                    forecastt += Number(items.value)
                                }
                            })
                            anjay.push(forecastt)
                        } else {
                            if (String(item).includes('[M-1]')) {
                                let tst = String(item).replace('[M-1]', '')
                                let data = column == 7 ? 18 : column - 1
                                let period = data == 18 ? Number(this.props.periode) - 1 : this.props.periode
                                let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                                if (indexID !== -1) {
                                    let valuezz = tableMeta.rowData[data].formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            } else {
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = value.formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        }

                    } else {
                        let indexID = dataTable2.findIndex((val) => val[22] == item)
                        if (indexID !== -1) {
                            // if (forecast !== undefined) {
                            //     console.log(dataTable2[indexID])
                            //     console.log(column)
                            //     console.log(dataTable2[indexID][column])

                            // }
                            if (forecast != undefined) {
                                // console.log(dataTable2[indexID][column])
                            }
                            let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                            anjay.push(valuezz == "" ? 0 : valuezz)
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                        }
                    }
                }
            })

            let anjay2 = []
            let kurung = false
            let item1 = []
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                } else if (item == ")") {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            // if (tableMeta.rowData[5] == "1.0 Cash inflow/ (outflow)  from Operating Activities") {
            //     console.log(anjay2)
            // }

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    // console.log(item.length)
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            // // total = R.equals(total, NaN) ? "0.0" : total
            // // console.log(dataTable2[tableMeta.rowIndex][22])
            // // console.log(tableMeta.rowData[5])   
            // // if (tableMeta.rowData[5] == 'Beginning Balance') {
            // console.log(baru)
            // console.log(anjay)
            // console.log(anjay2)
            // console.log(total)
            // }

            if (dataTable2[tableMeta.rowIndex][column].value == undefined) {
                // console.log([tableMeta.rowIndex][tableMeta.columnIndex])
                dataTable2[tableMeta.rowIndex][column] = total
            } else {
                dataTable2[tableMeta.rowIndex][column].value = total
            }

            return total
        }

        const handleValueFormulaDBPLMR = (value, tableMeta, column, periode, forecast) => {
            let splitFormula = String(tableMeta.rowData[26]).split(/([()@])/)
            // let splitFormula = String(tableMeta.rowData[3]).split('@')
            let baru = []
            let anjay = []
            let colIndex = tableMeta.columnIndex + column
            // if (forecast !== undefined) {
            //     console.log(tableMeta)
            // }

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                let asd = ''
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (forecast !== undefined) {
                            let forecastt = 0
                            forecast.map((items, index) => {
                                if (items.periode == periode) {
                                    forecastt += Number(items.value)
                                }
                            })
                            anjay.push(forecastt)
                        } else {
                            if (String(item).includes('[M-1]')) {
                                // let tst = String(item).replace('[M-1]', '')
                                // let data = column == 7 ? 18 : column - 1
                                // let period = data == 18 ? Number(this.props.periode) - 1 : this.props.periode
                                // let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                                // if (indexID !== -1) {
                                //     let valuezz = tableMeta.rowData[data].formula[indexID].value
                                //     anjay.push(valuezz == "" ? 0 : valuezz)
                                // }
                            } else {
                                // console.log(item)
                                // console.log(value.formula)
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = value.formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        }

                    } else {
                        let indexID = dataTable2.findIndex((val) => val[22] == item)
                        if (indexID !== -1) {
                            // if (forecast !== undefined) {
                            //     console.log(dataTable2[indexID])
                            //     console.log(column)
                            //     console.log(dataTable2[indexID][column])

                            // }
                            if (forecast != undefined) {
                                // console.log(dataTable2[indexID][column])
                            }
                            let valuezz = dataTable2[indexID][colIndex].value == undefined ? dataTable2[indexID][colIndex] : dataTable2[indexID][colIndex].value
                            anjay.push(valuezz == "" ? 0 : valuezz)
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                        }
                    }
                }
            })

            let anjay2 = []
            let kurung = false
            let item1 = []
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                } else if (item == ")") {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            // if (tableMeta.rowData[5] == "1.0 Cash inflow/ (outflow)  from Operating Activities") {
            //     console.log(anjay2)
            // }

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    // console.log(item.length)
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            // // total = R.equals(total, NaN) ? "0.0" : total
            // // console.log(dataTable2[tableMeta.rowIndex][22])
            // // console.log(tableMeta.rowData[5])   
            // if (colIndex == 39) {
            //     console.log(baru)
            //     console.log(anjay)
            //     console.log(anjay2)
            //     console.log(total)
            //     console.log(tableMeta.rowData)
            // }

            if (dataTable2[tableMeta.rowIndex][colIndex].value == undefined) {
                // console.log([tableMeta.rowIndex][tableMeta.columnIndex])
                dataTable2[tableMeta.rowIndex][colIndex] = total
            } else {
                dataTable2[tableMeta.rowIndex][colIndex].value = total
            }

            return total

        }

        const handleForecastDBPL = (tableMeta, periode, column) => {
            let total = 0

            if (tableMeta.rowData[3].includes('#PL')) {
                dataTable2[tableMeta.rowIndex][25].map((item, index) => {
                    if (item.periode == periode) {
                        total += Number(item.value)
                    }
                })
            } else {
                total = handleValueFormulaDBPL(dataTable2[tableMeta.rowIndex][column], tableMeta, column, periode, dataTable2[tableMeta.rowIndex][25])
            }

            // console.log(column)
            // console.log(tableMeta.rowIndex)
            // console.log(total)
            dataTable2[tableMeta.rowIndex][column] = total
            // total = handleValueFormulaDBPL(dataTable2[tableMeta.rowIndex][column], tableMeta, column, periode, dataTable2[tableMeta.rowIndex][25])
            // console.log(total)
            return total
        }

        const handleFormulaRatio = (value, tableMeta, month) => {
            // console.log(dataTable2)
            let total = 0
            if (month > 12) {
                total = Number(dataTable2[35][7 + month])
            } else {
                for (let index = 0; index < month; index++) {
                    total += Number(dataTable2[35][8 + index])
                    // console.log(index);
                }
                total = total/month
            }
            let hasil = Number(value) / total
            // console.log(hasil, value, total);
            return Number(hasil).toFixed(1)
        }

        const handleFormulaRatioMR = (value, tableMeta, month) => {
            // console.log(dataTable2)
            let total = 0
            if (month > 12) {
                total = Number(dataTable2[35][21 + month])
            } else {
                for (let index = 0; index < month; index++) {
                    total += Number(dataTable2[35][22 + index])
                    // console.log(index);
                }
                total = total/month
            }
            let hasil = Number(value) / total
            // console.log(hasil, value, total);
            return Number(hasil).toFixed(2)
        }

        const handleValueFormulaCF = (value, tableMeta, column, periode, forecast) => {
            // loading = true
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            let handledoubleFC = 0
            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (String(item).includes('[M-1]')) {
                            if (forecast !== undefined) {
                                let forecastt = 0
                                if (column == 20) {
                                    let tst = String(item).replace('[M-1]', '')
                                    let data = 18
                                    let period = this.props.periode
                                    let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                                    if (indexID !== -1) {
                                        let valuezz = tableMeta.rowData[data].formula[indexID].value
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                    }
                                }

                                if (column == 21) {
                                    let tst = String(item).replace('[M-1]', '')
                                    let period = Number(this.props.periode) + 1
                                    let indexID = forecast.findIndex((val) => String(val.item_formula).replace('forecast_', '') == String(`@${tst}`) && val.periode == period)
                                    if (indexID !== -1) {
                                        let valuezz = forecast[indexID].value
                                        forecastt += Number(valuezz == "" ? 0 : valuezz)
                                    }
                                }

                                anjay.push(forecastt)
                            } else {
                                let tst = String(item).replace('[M-1]', '')
                                let data = column == 7 ? 18 : column - 1
                                let period = data == 18 ? Number(this.props.periode) - 1 : this.props.periode
                                let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)

                                if (indexID !== -1) {
                                    let valuezz = tableMeta.rowData[data].formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        } else {
                            if (forecast !== undefined) {
                                let indexID = forecast.findIndex((val) => String(val.item_formula).replace('forecast_', '') == String(`@${item}`) && val.periode == Number(periode))
                                if (indexID !== -1) {
                                    let valuezz = forecast[indexID].value
                                    anjay.push(valuezz == "" ? 0 : Number(valuezz))
                                }
                            } else {
                                let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = value.formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[22] == item)
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                            if (item == dataTable2[tableMeta.rowIndex][22]) {
                                anjay.push(0)
                            } else {
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                        }
                    }
                }
            })

            let anjay2 = []
            let kurung = false
            let item1 = []
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                } else if (item == ")") {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            let optPrev = ""
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    optPrev = opt
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
                // if (String(tableMeta.rowData[5]).toLocaleUpperCase() == "4.0 CASH FLOW MOVEMENT" && column == 7) {
                //     console.log(item)
                //     console.log(totalPrio)
                //     console.log(total)
                // }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            // // total = R.equals(total, NaN) ? "0.0" : total
            // // console.log(dataTable2[tableMeta.rowIndex][22])
            // // console.log(tableMeta.rowData[5])
            // if (tableMeta.rowData[5] == "1.5 Other non-current assets") {
            // if (forecast !== undefined) {
                // if (String(tableMeta.rowData[5]).toLocaleUpperCase() == "4.0 CASH FLOW MOVEMENT" && column == 7) {
                //     console.log(splitFormula)
                //     console.log(baru)
                //     console.log(anjay)
                //     console.log(anjay2)
                //     console.log(total)
                //     console.log(dataTable2[tableMeta.rowIndex])
                // }
            // }

            if (dataTable2[tableMeta.rowIndex][column].value == undefined) {
                dataTable2[tableMeta.rowIndex][column] = total
            } else {
                dataTable2[tableMeta.rowIndex][column].value = total
            }
            // loading = false
            return total
        }

        const handleForecastCF = (tableMeta, periode, column) => {
            let total = 0
            total = handleValueFormulaCF(dataTable2[tableMeta.rowIndex][column], tableMeta, column, periode, dataTable2[tableMeta.rowIndex][25])
            return total
        }

        const columnDBBS = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            // DB Balance Sheet
            name: `MB ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[16]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[17]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[18]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `${Number(this.props.periode) + 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[20]).toFixed(1)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) + 2}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', fontSize: 13, top: 0, zIndex: 102, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[21]).toFixed(1)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[25]) === "" ? "" : Number(tableMeta.rowData[25]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[26]) === "" ? "" : Number(tableMeta.rowData[26]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[27]) === "" ? "" : Number(tableMeta.rowData[27]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[28]) === "" ? "" : Number(tableMeta.rowData[28]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[29]) === "" ? "" : Number(tableMeta.rowData[29]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[30]) === "" ? "" : Number(tableMeta.rowData[30]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[31]) === "" ? "" : Number(tableMeta.rowData[31]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[32]) === "" ? "" : Number(tableMeta.rowData[32]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[33]) === "" ? "" : Number(tableMeta.rowData[33]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[34]) === "" ? "" : Number(tableMeta.rowData[34]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[35]) === "" ? "" : Number(tableMeta.rowData[35]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[36]) === "" ? "" : Number(tableMeta.rowData[36]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual Last Year ${Number(this.props.periode) - 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[37]) === "" ? "" : Number(tableMeta.rowData[37]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[38]) === "" ? "" : Number(tableMeta.rowData[38]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[39]) === "" ? "" : Number(tableMeta.rowData[39]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[40]) === "" ? "" : Number(tableMeta.rowData[40]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[41]) === "" ? "" : Number(tableMeta.rowData[41]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[42]) === "" ? "" : Number(tableMeta.rowData[42]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[43]) === "" ? "" : Number(tableMeta.rowData[43]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[44]) === "" ? "" : Number(tableMeta.rowData[44]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[45]) === "" ? "" : Number(tableMeta.rowData[45]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[46]) === "" ? "" : Number(tableMeta.rowData[46]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[47]) === "" ? "" : Number(tableMeta.rowData[47]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[48]) === "" ? "" : Number(tableMeta.rowData[48]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Rolling Outlook - Full Year ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[49]) === "" ? "" : Number(tableMeta.rowData[49]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[50]) === "" ? "" : Number(tableMeta.rowData[50]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[51]) === "" ? "" : Number(tableMeta.rowData[51]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[52]) === "" ? "" : Number(tableMeta.rowData[52]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[53]) === "" ? "" : Number(tableMeta.rowData[53]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[54]) === "" ? "" : Number(tableMeta.rowData[54]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[55]) === "" ? "" : Number(tableMeta.rowData[55]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[56]) === "" ? "" : Number(tableMeta.rowData[56]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[57]) === "" ? "" : Number(tableMeta.rowData[57]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[58]) === "" ? "" : Number(tableMeta.rowData[58]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[59]) === "" ? "" : Number(tableMeta.rowData[59]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[60]) === "" ? "" : Number(tableMeta.rowData[60]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q1 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[61]) === "" ? "" : Number(tableMeta.rowData[61]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[62]) === "" ? "" : Number(tableMeta.rowData[62]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[63]) === "" ? "" : Number(tableMeta.rowData[63]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[64]) === "" ? "" : Number(tableMeta.rowData[64]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[65]) === "" ? "" : Number(tableMeta.rowData[65]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[66]) === "" ? "" : Number(tableMeta.rowData[66]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[67]) === "" ? "" : Number(tableMeta.rowData[67]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[68]) === "" ? "" : Number(tableMeta.rowData[68]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[69]) === "" ? "" : Number(tableMeta.rowData[69]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[70]) === "" ? "" : Number(tableMeta.rowData[70]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[71]) === "" ? "" : Number(tableMeta.rowData[71]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[72]) === "" ? "" : Number(tableMeta.rowData[72]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q2 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[73]) === "" ? "" : Number(tableMeta.rowData[73]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[74]) === "" ? "" : Number(tableMeta.rowData[74]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[75]) === "" ? "" : Number(tableMeta.rowData[75]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[76]) === "" ? "" : Number(tableMeta.rowData[76]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[77]) === "" ? "" : Number(tableMeta.rowData[77]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[78]) === "" ? "" : Number(tableMeta.rowData[78]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[79]) === "" ? "" : Number(tableMeta.rowData[79]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[80]) === "" ? "" : Number(tableMeta.rowData[80]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[81]) === "" ? "" : Number(tableMeta.rowData[81]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[82]) === "" ? "" : Number(tableMeta.rowData[82]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[83]) === "" ? "" : Number(tableMeta.rowData[83]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[84]) === "" ? "" : Number(tableMeta.rowData[84]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q3 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[85]) === "" ? "" : Number(tableMeta.rowData[85]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[86]) === "" ? "" : Number(tableMeta.rowData[86]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[87]) === "" ? "" : Number(tableMeta.rowData[87]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[88]) === "" ? "" : Number(tableMeta.rowData[88]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[89]) === "" ? "" : Number(tableMeta.rowData[89]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[90]) === "" ? "" : Number(tableMeta.rowData[90]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[91]) === "" ? "" : Number(tableMeta.rowData[91]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[92]) === "" ? "" : Number(tableMeta.rowData[92]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[93]) === "" ? "" : Number(tableMeta.rowData[93]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[94]) === "" ? "" : Number(tableMeta.rowData[94]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[95]) === "" ? "" : Number(tableMeta.rowData[95]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[96]) === "" ? "" : Number(tableMeta.rowData[96]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL PA ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[97]) === "" ? "" : Number(tableMeta.rowData[97]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[98]) === "" ? "" : Number(tableMeta.rowData[98]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[99]) === "" ? "" : Number(tableMeta.rowData[99]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[100]) === "" ? "" : Number(tableMeta.rowData[100]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[101]) === "" ? "" : Number(tableMeta.rowData[101]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[102]) === "" ? "" : Number(tableMeta.rowData[102]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[103]) === "" ? "" : Number(tableMeta.rowData[103]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[104]) === "" ? "" : Number(tableMeta.rowData[104]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[105]) === "" ? "" : Number(tableMeta.rowData[105]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[106]) === "" ? "" : Number(tableMeta.rowData[106]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[107]) === "" ? "" : Number(tableMeta.rowData[107]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[108]) === "" ? "" : Number(tableMeta.rowData[108]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Historical`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#1c71b8' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 10}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 9}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 8}`}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 7}`}</span>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 6}`}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#1c71b8' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 5}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 4}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 3}`}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 2}`}</span>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 1}`}</span>
                                </div>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(tableMeta)
                    return (
                        <div>
                            <div className="grid grid-2x content-center">
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 80, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[109]) === "" ? "" : Number(tableMeta.rowData[109]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][0]) === "0" ? "" : Number(tableMeta.rowData[109][0]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[110]) === "" ? "" : Number(tableMeta.rowData[110]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][1]) === "0" ? "" : Number(tableMeta.rowData[109][1]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[111]) === "" ? "" : Number(tableMeta.rowData[111]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][2]) === "0" ? "" : Number(tableMeta.rowData[109][2]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[112]) === "" ? "" : Number(tableMeta.rowData[112]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][3]) === "0" ? "" : Number(tableMeta.rowData[109][3]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-5">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[113]) === "" ? "" : Number(tableMeta.rowData[113]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][4]) === "0" ? "" : Number(tableMeta.rowData[109][4]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[114]) === "" ? "" : Number(tableMeta.rowData[114]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][5]) === "0" ? "" : Number(tableMeta.rowData[109][5]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[115]) === "" ? "" : Number(tableMeta.rowData[115]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][6]) === "0" ? "" : Number(tableMeta.rowData[109][6]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[116]) === "" ? "" : Number(tableMeta.rowData[116]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][7]) === "0" ? "" : Number(tableMeta.rowData[109][7]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[117]) === "" ? "" : Number(tableMeta.rowData[117]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][8]) === "0" ? "" : Number(tableMeta.rowData[109][8]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-5">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[118]) === "" ? "" : Number(tableMeta.rowData[118]).toFixed(1)}
                                                                // value={tableMeta.rowData[109] == null ? "" : (String(tableMeta.rowData[109][9]) === "0" ? "" : Number(tableMeta.rowData[109][9]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }
        ]

        const columnDBPLDetail = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Notes",
            options: {
                customHeadRender: (columnMeta) => (
                    dataTable2.length > 0 ?
                        <TableCell style={{ ...stylenotes, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> :
                        <TableCell style={{ ...styleNotesEmpty, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                ),
                setCellProps: () => ({
                    style: {
                        position: "sticky",
                        background: "white",
                        zIndex: 101,
                        left: 350
                    }
                }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            <div style={{ flex: 1 }}>
                                {tableMeta.rowData[0] === 4 ? null : tableMeta.rowData[4] === 0 ? null : tableMeta.rowData[4] === 1 ? null :
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            // value={tableMeta.rowData[47]}
                                            control={
                                                <Input
                                                    disableUnderline={true}
                                                    style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={tableMeta.rowData[47]}
                                                    defaultValue={tableMeta.rowData[47]}
                                                    inputProps={{
                                                        style: {
                                                            color: this.props.approvedMB ? '#000000de' : '#5198ea'
                                                        }
                                                    }}
                                                    // onBlur={(event) => {
                                                    //     handleNotes(event.target.value, tableMeta, 0)
                                                    // }}
                                                />
                                            }
                                        />
                                        }
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `MB ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[16]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[17]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[18]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `${Number(this.props.periode) + 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[20]).toFixed(1)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) + 2}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', fontSize: 13, top: 0, zIndex: 102, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 ?
                                null
                                : tableMeta.rowData[0] === 1 ?
                                    null :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[21]).toFixed(1)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[23]) === "" ? "" : Number(tableMeta.rowData[23]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[24]) === "" ? "" : Number(tableMeta.rowData[24]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[25]) === "" ? "" : Number(tableMeta.rowData[25]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[26]) === "" ? "" : Number(tableMeta.rowData[26]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[27]) === "" ? "" : Number(tableMeta.rowData[27]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[28]) === "" ? "" : Number(tableMeta.rowData[28]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[29]) === "" ? "" : Number(tableMeta.rowData[29]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[30]) === "" ? "" : Number(tableMeta.rowData[30]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[31]) === "" ? "" : Number(tableMeta.rowData[31]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[32]) === "" ? "" : Number(tableMeta.rowData[32]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[33]) === "" ? "" : Number(tableMeta.rowData[33]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[34]) === "" ? "" : Number(tableMeta.rowData[34]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual Last Year ${Number(this.props.periode) - 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[35]) === "" ? "" : Number(tableMeta.rowData[35]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[36]) === "" ? "" : Number(tableMeta.rowData[36]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[37]) === "" ? "" : Number(tableMeta.rowData[37]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[38]) === "" ? "" : Number(tableMeta.rowData[38]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[39]) === "" ? "" : Number(tableMeta.rowData[39]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[40]) === "" ? "" : Number(tableMeta.rowData[40]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[41]) === "" ? "" : Number(tableMeta.rowData[41]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[42]) === "" ? "" : Number(tableMeta.rowData[42]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[43]) === "" ? "" : Number(tableMeta.rowData[43]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[44]) === "" ? "" : Number(tableMeta.rowData[44]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[45]) === "" ? "" : Number(tableMeta.rowData[45]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[46]) === "" ? "" : Number(tableMeta.rowData[46]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Rolling Outlook Full Year ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[48]) === "" ? "" : Number(tableMeta.rowData[48]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[49]) === "" ? "" : Number(tableMeta.rowData[49]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[50]) === "" ? "" : Number(tableMeta.rowData[50]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[51]) === "" ? "" : Number(tableMeta.rowData[51]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[52]) === "" ? "" : Number(tableMeta.rowData[52]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[53]) === "" ? "" : Number(tableMeta.rowData[53]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[54]) === "" ? "" : Number(tableMeta.rowData[54]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[55]) === "" ? "" : Number(tableMeta.rowData[55]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[56]) === "" ? "" : Number(tableMeta.rowData[56]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[57]) === "" ? "" : Number(tableMeta.rowData[57]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[58]) === "" ? "" : Number(tableMeta.rowData[58]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[59]) === "" ? "" : Number(tableMeta.rowData[59]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q1 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[60]) === "" ? "" : Number(tableMeta.rowData[60]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[61]) === "" ? "" : Number(tableMeta.rowData[61]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[62]) === "" ? "" : Number(tableMeta.rowData[62]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[63]) === "" ? "" : Number(tableMeta.rowData[63]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[64]) === "" ? "" : Number(tableMeta.rowData[64]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[65]) === "" ? "" : Number(tableMeta.rowData[65]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[66]) === "" ? "" : Number(tableMeta.rowData[66]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[67]) === "" ? "" : Number(tableMeta.rowData[67]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[68]) === "" ? "" : Number(tableMeta.rowData[68]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[69]) === "" ? "" : Number(tableMeta.rowData[69]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[70]) === "" ? "" : Number(tableMeta.rowData[70]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[71]) === "" ? "" : Number(tableMeta.rowData[71]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q2 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[72]) === "" ? "" : Number(tableMeta.rowData[72]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[73]) === "" ? "" : Number(tableMeta.rowData[73]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[74]) === "" ? "" : Number(tableMeta.rowData[74]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[75]) === "" ? "" : Number(tableMeta.rowData[75]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[76]) === "" ? "" : Number(tableMeta.rowData[76]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[77]) === "" ? "" : Number(tableMeta.rowData[77]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[78]) === "" ? "" : Number(tableMeta.rowData[78]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[79]) === "" ? "" : Number(tableMeta.rowData[79]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[80]) === "" ? "" : Number(tableMeta.rowData[80]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[81]) === "" ? "" : Number(tableMeta.rowData[81]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[82]) === "" ? "" : Number(tableMeta.rowData[82]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[83]) === "" ? "" : Number(tableMeta.rowData[83]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q3 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[84]) === "" ? "" : Number(tableMeta.rowData[84]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[85]) === "" ? "" : Number(tableMeta.rowData[85]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[86]) === "" ? "" : Number(tableMeta.rowData[86]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[87]) === "" ? "" : Number(tableMeta.rowData[87]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[88]) === "" ? "" : Number(tableMeta.rowData[88]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[89]) === "" ? "" : Number(tableMeta.rowData[89]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[90]) === "" ? "" : Number(tableMeta.rowData[90]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[91]) === "" ? "" : Number(tableMeta.rowData[91]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[92]) === "" ? "" : Number(tableMeta.rowData[92]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[93]) === "" ? "" : Number(tableMeta.rowData[93]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[94]) === "" ? "" : Number(tableMeta.rowData[94]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[95]) === "" ? "" : Number(tableMeta.rowData[95]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL PA ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[96]) === "" ? "" : Number(tableMeta.rowData[96]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[97]) === "" ? "" : Number(tableMeta.rowData[97]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[98]) === "" ? "" : Number(tableMeta.rowData[98]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[99]) === "" ? "" : Number(tableMeta.rowData[99]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[100]) === "" ? "" : Number(tableMeta.rowData[100]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[101]) === "" ? "" : Number(tableMeta.rowData[101]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[102]) === "" ? "" : Number(tableMeta.rowData[102]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[103]) === "" ? "" : Number(tableMeta.rowData[103]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[104]) === "" ? "" : Number(tableMeta.rowData[104]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[105]) === "" ? "" : Number(tableMeta.rowData[105]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[106]) === "" ? "" : Number(tableMeta.rowData[106]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[107]) === "" ? "" : Number(tableMeta.rowData[107]).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Historical`,
            options: {
                // display: false,
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#1c71b8' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 10}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 9}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 8}`}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 7}`}</span>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 6}`}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#1c71b8' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 5}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 4}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 3}`}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 2}`}</span>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 1}`}</span>
                                </div>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(tableMeta)
                    return (
                        <div>
                            <div className="grid grid-2x content-center">
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 80, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[108]) === "" ? "" : Number(tableMeta.rowData[108]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][0]) === "0" ? "" : Number(tableMeta.rowData[108][0]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[109]) === "" ? "" : Number(tableMeta.rowData[109]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][1]) === "0" ? "" : Number(tableMeta.rowData[108][1]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[110]) === "" ? "" : Number(tableMeta.rowData[110]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][2]) === "0" ? "" : Number(tableMeta.rowData[108][2]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[111]) === "" ? "" : Number(tableMeta.rowData[111]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][3]) === "0" ? "" : Number(tableMeta.rowData[108][3]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-5">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[112]) === "" ? "" : Number(tableMeta.rowData[112]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][4]) === "0" ? "" : Number(tableMeta.rowData[108][4]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[113]) === "" ? "" : Number(tableMeta.rowData[113]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][5]) === "0" ? "" : Number(tableMeta.rowData[108][5]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[114]) === "" ? "" : Number(tableMeta.rowData[114]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][6]) === "0" ? "" : Number(tableMeta.rowData[108][6]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[115]) === "" ? "" : Number(tableMeta.rowData[115]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][7]) === "0" ? "" : Number(tableMeta.rowData[108][7]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[116]) === "" ? "" : Number(tableMeta.rowData[116]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][8]) === "0" ? "" : Number(tableMeta.rowData[108][8]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-5">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[117]) === "" ? "" : Number(tableMeta.rowData[117]).toFixed(1)}
                                                                // value={tableMeta.rowData[108] == null ? "" : (String(tableMeta.rowData[108][9]) === "0" ? "" : Number(tableMeta.rowData[108][9]).toFixed(1))}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }
        ]

        const columnDBPL = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Notes",
            options: {
                customHeadRender: (columnMeta) => (
                    dataTable2.length > 0 ?
                        <TableCell style={{ ...stylenotes, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> :
                        <TableCell style={{ ...styleNotesEmpty, top: 0, zIndex: 103, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                ),
                setCellProps: () => ({
                    style: {
                        position: "sticky",
                        background: "white",
                        zIndex: 101,
                        left: 350
                    }
                }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            <div style={{ flex: 1 }}>
                                {tableMeta.rowData[0] === 4 ? null : tableMeta.rowData[4] === 0 ? null : tableMeta.rowData[4] === 1 ? null :
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            // value={tableMeta.rowData[51]}
                                            control={
                                                <Input
                                                    disableUnderline={true}
                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    // value={tableMeta.rowData[51]}
                                                    defaultValue={tableMeta.rowData[51]}
                                                    inputProps={{
                                                        style: {
                                                            color: "#5198ea"
                                                        }
                                                    }}
                                                    // onBlur={(event) => {
                                                    //     handleNotes(event.target.value, tableMeta, 0)
                                                    // }}
                                                />
                                            }
                                        />
                                        }
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `MB ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[7], tableMeta, 7).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[8], tableMeta, 8).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[9], tableMeta, 9).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[10], tableMeta, 10).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[11], tableMeta, 11).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[12], tableMeta, 12).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[13], tableMeta, 13).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[14], tableMeta, 14).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[15], tableMeta, 15).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[16], tableMeta, 16).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[17], tableMeta, 17).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[18], tableMeta, 18).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `${Number(this.props.periode) + 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null
                                :
                                <div style={{ flex: 1 }}>
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        value={value}
                                        control={
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                disabled={true}
                                                // value={Number(handleForecastDBPL(tableMeta, `${Number(this.props.periode) + 1}`, 20)).toFixed(1)}
                                                value={Number(tableMeta.rowData[20], tableMeta, 20).toFixed(1)}
                                            />
                                        }
                                    />
                                </div>}
                        </div>
                    )
                }
            }
        },
        {
            name: `${Number(this.props.periode) + 2}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', fontSize: 13, top: 0, zIndex: 102, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null
                                :
                                <div style={{ flex: 1 }}>
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        value={value}
                                        control={
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                disabled={true}
                                                // value={Number(handleForecastDBPL(tableMeta, `${Number(this.props.periode) + 2}`, 21)).toFixed(1)}
                                                value={Number(tableMeta.rowData[21], tableMeta, 21).toFixed(1)}
                                            />
                                        }
                                    />
                                </div>}
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        },{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[27]) === "" ? "" : Number(tableMeta.rowData[27], tableMeta, 27).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[28]) === "" ? "" : Number(tableMeta.rowData[28], tableMeta, 28).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[29]) === "" ? "" : Number(tableMeta.rowData[29], tableMeta, 29).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[30]) === "" ? "" : Number(tableMeta.rowData[30], tableMeta, 30).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[31]) === "" ? "" : Number(tableMeta.rowData[31], tableMeta, 31).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[32]) === "" ? "" : Number(tableMeta.rowData[32], tableMeta, 32).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[33]) === "" ? "" : Number(tableMeta.rowData[33], tableMeta, 33).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[34]) === "" ? "" : Number(tableMeta.rowData[34], tableMeta, 34).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[35]) === "" ? "" :Number(tableMeta.rowData[35], tableMeta, 35).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[36]) === "" ? "" : Number(tableMeta.rowData[36], tableMeta, 36).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[37]) === "" ? "" : Number(tableMeta.rowData[37], tableMeta, 37).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[38]) === "" ? "" : Number(tableMeta.rowData[38], tableMeta, 38).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual Last Year ${Number(this.props.periode) - 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[39]) === "" ? "" : Number(tableMeta.rowData[39], tableMeta, 39).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[40]) === "" ? "" : Number(tableMeta.rowData[40], tableMeta, 40).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[41]) === "" ? "" : Number(tableMeta.rowData[41], tableMeta, 41).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[42]) === "" ? "" : Number(tableMeta.rowData[42], tableMeta, 42).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[43]) === "" ? "" : Number(tableMeta.rowData[43], tableMeta, 43).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[44]) === "" ? "" : Number(tableMeta.rowData[44], tableMeta, 44).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[45]) === "" ? "" :Number(tableMeta.rowData[45], tableMeta, 45).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[46]) === "" ? "" : Number(tableMeta.rowData[46], tableMeta, 46).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[47]) === "" ? "" : Number(tableMeta.rowData[47], tableMeta, 47).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[48]) === "" ? "" : Number(tableMeta.rowData[48], tableMeta, 48).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[49]) === "" ? "" : Number(tableMeta.rowData[49], tableMeta, 49).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                    {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[50]) === "" ? "" : Number(tableMeta.rowData[50], tableMeta, 50).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Rolling OUtlook Full Year ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[52]) === "" ? "" : Number(tableMeta.rowData[52], tableMeta, 52).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[53]) === "" ? "" : Number(tableMeta.rowData[53], tableMeta, 53).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[54]) === "" ? "" : Number(tableMeta.rowData[54], tableMeta, 54).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[55]) === "" ? "" : Number(tableMeta.rowData[55], tableMeta, 55).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[56]) === "" ? "" : Number(tableMeta.rowData[56], tableMeta, 56).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[57]) === "" ? "" : Number(tableMeta.rowData[57], tableMeta, 57).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[58]) === "" ? "" : Number(tableMeta.rowData[58], tableMeta, 58).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[59]) === "" ? "" : Number(tableMeta.rowData[59], tableMeta, 59).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[60]) === "" ? "" :Number(tableMeta.rowData[60], tableMeta, 60).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[61]) === "" ? "" : Number(tableMeta.rowData[61], tableMeta, 61).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[62]) === "" ? "" : Number(tableMeta.rowData[62], tableMeta, 62).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[63]) === "" ? "" : Number(tableMeta.rowData[63], tableMeta, 63).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q1 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[64]) === "" ? "" : Number(tableMeta.rowData[64], tableMeta, 64).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[65]) === "" ? "" : Number(tableMeta.rowData[65], tableMeta, 65).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[66]) === "" ? "" : Number(tableMeta.rowData[66], tableMeta, 66).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[67]) === "" ? "" : Number(tableMeta.rowData[67], tableMeta, 67).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[68]) === "" ? "" : Number(tableMeta.rowData[68], tableMeta, 68).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[69]) === "" ? "" : Number(tableMeta.rowData[69], tableMeta, 69).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[70]) === "" ? "" : Number(tableMeta.rowData[70], tableMeta, 70).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[71]) === "" ? "" : Number(tableMeta.rowData[71], tableMeta, 71).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[72]) === "" ? "" :Number(tableMeta.rowData[72], tableMeta, 72).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[73]) === "" ? "" : Number(tableMeta.rowData[73], tableMeta, 73).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[74]) === "" ? "" : Number(tableMeta.rowData[74], tableMeta, 74).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[75]) === "" ? "" : Number(tableMeta.rowData[75], tableMeta, 75).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q2 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[76]) === "" ? "" : Number(tableMeta.rowData[76], tableMeta, 76).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[77]) === "" ? "" : Number(tableMeta.rowData[77], tableMeta, 77).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[78]) === "" ? "" : Number(tableMeta.rowData[78], tableMeta, 78).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[79]) === "" ? "" : Number(tableMeta.rowData[79], tableMeta, 79).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[80]) === "" ? "" : Number(tableMeta.rowData[80], tableMeta, 80).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[81]) === "" ? "" : Number(tableMeta.rowData[81], tableMeta, 81).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[82]) === "" ? "" : Number(tableMeta.rowData[82], tableMeta, 82).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[83]) === "" ? "" : Number(tableMeta.rowData[83], tableMeta, 83).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[84]) === "" ? "" :Number(tableMeta.rowData[84], tableMeta, 84).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[85]) === "" ? "" : Number(tableMeta.rowData[85], tableMeta, 85).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[86]) === "" ? "" : Number(tableMeta.rowData[86], tableMeta, 86).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[87]) === "" ? "" : Number(tableMeta.rowData[87], tableMeta, 87).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL Q3 ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[88]) === "" ? "" : Number(tableMeta.rowData[88], tableMeta, 88).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[89]) === "" ? "" : Number(tableMeta.rowData[89], tableMeta, 89).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[90]) === "" ? "" : Number(tableMeta.rowData[90], tableMeta, 90).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[91]) === "" ? "" : Number(tableMeta.rowData[91], tableMeta, 91).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[92]) === "" ? "" : Number(tableMeta.rowData[92], tableMeta, 92).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[93]) === "" ? "" : Number(tableMeta.rowData[93], tableMeta, 93).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[94]) === "" ? "" : Number(tableMeta.rowData[94], tableMeta, 94).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[95]) === "" ? "" : Number(tableMeta.rowData[95], tableMeta, 95).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[96]) === "" ? "" :Number(tableMeta.rowData[96], tableMeta, 96).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[97]) === "" ? "" : Number(tableMeta.rowData[97], tableMeta, 97).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[98]) === "" ? "" : Number(tableMeta.rowData[98], tableMeta, 98).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[99]) === "" ? "" : Number(tableMeta.rowData[99], tableMeta, 99).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `OL PA ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (val, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[100]) === "" ? "" : Number(tableMeta.rowData[100], tableMeta, 100).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[101]) === "" ? "" : Number(tableMeta.rowData[101], tableMeta, 101).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[102]) === "" ? "" : Number(tableMeta.rowData[102], tableMeta, 102).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[103]) === "" ? "" : Number(tableMeta.rowData[103], tableMeta, 103).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[104]) === "" ? "" : Number(tableMeta.rowData[104], tableMeta, 104).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[105]) === "" ? "" : Number(tableMeta.rowData[105], tableMeta, 105).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[106]) === "" ? "" : Number(tableMeta.rowData[106], tableMeta, 106).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[107]) === "" ? "" : Number(tableMeta.rowData[107], tableMeta, 107).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[108]) === "" ? "" :Number(tableMeta.rowData[108], tableMeta, 108).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[109]) === "" ? "" : Number(tableMeta.rowData[109], tableMeta, 109).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[110]) === "" ? "" : Number(tableMeta.rowData[110], tableMeta, 110).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea' , fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[111]) === "" ? "" : Number(tableMeta.rowData[111], tableMeta, 111).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Historical`,
            options: {
                // display: false,
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-2x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#1c71b8' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 10}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 9}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 8}`}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 7}`}</span>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 6}`}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-5x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#1c71b8' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 5}`}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 4}`}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 3}`}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 2}`}</span>
                                </div>
                                <div className="column-5" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#1c71b8' }}>
                                    <span>{`${Number(this.props.periode) - 1}`}</span>
                                </div>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(tableMeta)
                    return (
                        <div>
                            <div className="grid grid-2x content-center">
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 80, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[121]) === "" ? "" : Number(tableMeta.rowData[121], tableMeta, 121).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[120]) === "" ? "" : Number(tableMeta.rowData[120], tableMeta, 120).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[119]) === "" ? "" : Number(tableMeta.rowData[119], tableMeta, 119).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[118]) === "" ? "" : Number(tableMeta.rowData[118], tableMeta, 118).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-5">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[117]) === "" ? "" : Number(tableMeta.rowData[117], tableMeta, 117).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-5x content-center">
                                    <div className="col-1">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[116]) === "" ? "" : Number(tableMeta.rowData[116], tableMeta, 116).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[115]) === "" ? "" : Number(tableMeta.rowData[115], tableMeta, 115).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[114]) === "" ? "" : Number(tableMeta.rowData[114], tableMeta, 114).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[113]) === "" ? "" : Number(tableMeta.rowData[113], tableMeta, 113).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                    <div className="col-5">
                                        {tableMeta.rowData[0] === 4 ?
                                            null
                                            : tableMeta.rowData[0] === 1 ?
                                                null :
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={String(tableMeta.rowData[112]) === "" ? "" : Number(tableMeta.rowData[112], tableMeta, 112).toFixed(1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }
        ]

        const columnDBFR = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 103, backgroundColor: '#1c71b8' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Unit",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', borderRight: '1px solid #fff', borderLeft: '1px solid #fff' }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ width: 90, textAlign: 'center' }}>
                            {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 4 ?
                                null :
                                <div>
                                    <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : value}</span>
                                </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `MB ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[8], tableMeta, 1)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[8]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[9], tableMeta, 2)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[9]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[10], tableMeta, 3)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[10]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[11], tableMeta, 4)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[11]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[12], tableMeta, 5)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[12]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[13], tableMeta, 6)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[13]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[14], tableMeta, 7)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[14]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[15], tableMeta, 8)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[15]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[16], tableMeta, 9)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[16]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[17], tableMeta, 10)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[17]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[18], tableMeta, 11)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[18]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={handleFormulaRatio(tableMeta.rowData[19], tableMeta, 12)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approvedMB ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[19]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `${Number(this.props.periode) + 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                //     <div style={{ flex: 1 }}>
                                //         <FormControlLabel
                                //             style={{ margin: 0 }}
                                //             value={value}
                                //             control={
                                //                 <NumberFormat
                                //                     thousandSeparator={true}
                                //                     style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                //                     type="text"
                                //                     placeholder=""
                                //                     disabled={true}
                                //                     value={handleFormulaRatio(tableMeta.rowData[20], tableMeta, 13)}
                                //                 />
                                //             }
                                //         />
                                //     </div> :
                                    tableMeta.rowData[0] === 4 ?
                                        null
                                        : tableMeta.rowData[0] === 1 ?
                                            null :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[20]).toFixed(2)}
                                                        />
                                                    }
                                                />
                                            </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `${Number(this.props.periode) + 2}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', fontSize: 13, top: 0, zIndex: 102, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-1x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                <span>{"Forecast"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                //     <div style={{ flex: 1 }}>
                                //         <FormControlLabel
                                //             style={{ margin: 0 }}
                                //             value={value}
                                //             control={
                                //                 <NumberFormat
                                //                     thousandSeparator={true}
                                //                     style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                //                     type="text"
                                //                     placeholder=""
                                //                     disabled={true}
                                //                     value={handleFormulaRatio(tableMeta.rowData[21], tableMeta, 14)}
                                //                 />
                                //             }
                                //         />
                                //     </div> :
                                    tableMeta.rowData[0] === 4 ?
                                        null
                                        : tableMeta.rowData[0] === 1 ?
                                            null :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[21]).toFixed(2)}
                                                        />
                                                    }
                                                />
                                            </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={String(tableMeta.rowData[22]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[22], tableMeta, 1)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[22]) === "" ? "" : Number(tableMeta.rowData[22]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[23]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[23], tableMeta, 2)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[23]) === "" ? "" : Number(tableMeta.rowData[23]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     // value={0.0}
                                            //                     disabled={true}
                                            //                     value={String(tableMeta.rowData[24]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[24], tableMeta, 3)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[24]) === "" ? "" : Number(tableMeta.rowData[24]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[25]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[25], tableMeta, 4)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[25]) === "" ? "" : Number(tableMeta.rowData[25]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[26]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[26], tableMeta, 5)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[26]) === "" ? "" : Number(tableMeta.rowData[26]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[27]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[27], tableMeta, 6)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[27]) === "" ? "" : Number(tableMeta.rowData[27]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[28]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[28], tableMeta, 7)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[28]) === "" ? "" : Number(tableMeta.rowData[28]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[29]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[29], tableMeta, 8)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[29]) === "" ? "" : Number(tableMeta.rowData[29]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[30]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[30], tableMeta, 9)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[30]) === "" ? "" : Number(tableMeta.rowData[30]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[31]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[31], tableMeta, 10)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[31]) === "" ? "" : Number(tableMeta.rowData[31]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[32]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[32], tableMeta, 11)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[32]) === "" ? "" : Number(tableMeta.rowData[32]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[33]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[33], tableMeta, 12)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[33]) === "" ? "" : Number(tableMeta.rowData[33]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        },
        {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: `Actual Last Year ${Number(this.props.periode) - 1}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, color: '#fff', backgroundColor: '#07a7d0', top: 0, zIndex: 102, fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"1"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"2"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"3"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"4"}</span>
                                </div>
                            </div>
                            <div className="column-2 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"5"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"6"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"7"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"8"}</span>
                                </div>

                            </div>
                            <div className="column-3 grid grid-4x" style={{ placeSelf: 'center', textAlign: 'center', backgroundColor: '#07a7d0' }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"9"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"10"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0' }}>
                                    <span>{"11"}</span>
                                </div>
                                <div className="column-4" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0' }}>
                                    <span>{"12"}</span>
                                </div>
                            </div>

                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     value={String(tableMeta.rowData[34]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[34], tableMeta, 1)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={String(tableMeta.rowData[34]) === "" ? "" : Number(tableMeta.rowData[34]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[35]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[35], tableMeta, 2)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[35]) === "" ? "" : Number(tableMeta.rowData[35]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     // value={0.0}
                                            //                     disabled={true}
                                            //                     value={String(tableMeta.rowData[36]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[36], tableMeta, 3)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[36]) === "" ? "" : Number(tableMeta.rowData[36]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[37]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[37], tableMeta, 4)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[37]) === "" ? "" : Number(tableMeta.rowData[37]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[38]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[38], tableMeta, 5)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[38]) === "" ? "" : Number(tableMeta.rowData[38]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[39]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[39], tableMeta, 6)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[39]) === "" ? "" : Number(tableMeta.rowData[39]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[40]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[40], tableMeta, 7)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[40]) === "" ? "" : Number(tableMeta.rowData[40]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-4">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[41]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[41], tableMeta, 8)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[41]) === "" ? "" : Number(tableMeta.rowData[41]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                </div>
                                <div className="grid grid-4x content-center">
                                    <div className="col-1">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[42]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[42], tableMeta, 9)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[42]) === "" ? "" : Number(tableMeta.rowData[42]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-2">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[43]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[43], tableMeta, 10)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[43]) === "" ? "" : Number(tableMeta.rowData[43]).toFixed(2)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                        }
                                    </div>
                                    <div className="col-3">
                                        {
                                            // tableMeta.rowData[6] === "Return on Invested Capital - YTD (ROIC)" ?
                                            //     <div style={{ flex: 1 }}>
                                            //         <FormControlLabel
                                            //             style={{ margin: 0 }}
                                            //             value={value}
                                            //             control={
                                            //                 <NumberFormat
                                            //                     thousandSeparator={true}
                                            //                     style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                            //                     type="text"
                                            //                     placeholder=""
                                            //                     disabled={true}
                                            //                     // value={0.0}
                                            //                     value={String(tableMeta.rowData[44]) === "" ? "" : handleFormulaRatioMR(tableMeta.rowData[44], tableMeta, 11)}
                                            //                 />
                                            //             }
                                            //         />
                                            //     </div> :
                                                tableMeta.rowData[0] === 4 ?
                                                    null
                                                    : tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={value}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.approveMonthly ? '#000000de' : '#5198ea', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        // value={0.0}
                                                                        value={String(tableMeta.rowData[44]) === "" ? "" : Number(tableMeta.rowData[44]).toFixed(2)}
                                                                    />
                                                                }
                                  