import React, { Component } from 'react'
import { Typography, TextField, Paper, Snackbar, withStyles } from '@material-ui/core'
import Constant from '../../library/Constant'
import api from '../../api'
import { titleCase } from '../../library/Utils'
import { Autocomplete } from '@material-ui/lab'
import TableSubHolding from './TableSubHolding'
import { PropagateLoader } from 'react-spinners'
import ReactTooltip from 'react-tooltip'
import Images from '../../assets/Images'
import MuiAlert from '@material-ui/lab/Alert';
import { format } from 'date-fns';

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class SubHolding extends Component {
    constructor(props) {
        super(props)
        this.state = {
            periode: '2020',
            perusahaan: 'TAP Group',
            laporan: 'Balance Sheet - Montly',
            tab: 0,
            listCompany: null,
            company: null,
            listPeriode: null,
            periode: null,
            reportType: [
                { value: 2, label: 'DB Balance Sheet' },
                { value: 3, label: 'DB Profit & Loss' },
                { value: 1, label: 'DB Profit & Loss Detail' },
                { value: 4, label: 'DB Ratio' },
                { value: 5, label: 'DB Tax Planning' },
                { value: 21, label: 'DB Operating Indicator' },
                { value: 6, label: 'Cash Flow - Summary' },
                { value: 7, label: 'Balance Sheet - Summary' },
                { value: 8, label: 'Profit Loss - Summary' },
                { value: 9, label: 'Financial Ratio - Summary' },
                { value: 11, label: 'CAT Performance Quarterly' },
                { value: 10, label: 'CAT Performance Appraisal' },
            ],
            report: null,
            loading: false,
            previewTable: false,
            OPID: null,
            listMonths: null,
            listUom: null,
            listQuarter: null,
            month: null,
            quarter: null,
            uom: null,
            approveMB: false,
            approveMonthly: false
        }
    }

    selectTab = (event, newEvent) => {
        this.setState({ tab: newEvent })
    }

    componentDidMount() {
        this.getDetailUser()
        this.setState({ report: this.state.reportType[0], loading: true })
        // this.getApproveMB()
    }

    getDetailUser() {
        let userId = localStorage.getItem(Constant.USER)
        api.create().getDetailUser(userId).then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ userCompany: response.data.data.company }, () => {
                            this.getCompanyActive()
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
                }
            }
        })
    }

    getApproveMB() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
        }
        api.create().getFullApproveMB(payload).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.data.status == "success") {
                    this.setState({ approveMB: response.data.data.is_master_budget_approve })
                }

            }
        })
    }

    getApproveMonthly() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
        }
        api.create().getFullApproveMonthly(payload).then((response) => {
            console.log(payload);
            console.log(response);
            if (response.data) {
                if (response.data.status == "success") {
                    console.log(response.data.data);
                    let approveMonthly =
                        this.state.month.month_id == 1 ?
                            response.data.data.januari.is_approve :
                            this.state.month.month_id == 2 ?
                                response.data.data.februari.is_approve :
                                this.state.month.month_id == 3 ?
                                    response.data.data.march.is_approve :
                                    this.state.month.month_id == 4 ?
                                        response.data.data.april.is_approve :
                                        this.state.month.month_id == 5 ?
                                            response.data.data.may.is_approve :
                                            this.state.month.month_id == 6 ?
                                                response.data.data.june.is_approve :
                                                this.state.month.month_id == 7 ?
                                                    response.data.data.july.is_approve :
                                                    this.state.month.month_id == 8 ?
                                                        response.data.data.august.is_approve :
                                                        this.state.month.month_id == 9 ?
                                                            response.data.data.september.is_approve :
                                                            this.state.month.month_id == 10 ?
                                                                response.data.data.october.is_approve :
                                                                this.state.month.month_id == 11 ?
                                                                    response.data.data.november.is_approve :
                                                                    response.data.data.december.is_approve

                    this.setState({ approveMonthly })
                }

            }
        })
    }

    getCompanyActive() {
        api.create().getPerusahaanActive().then((response) => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    let data = response.data.data
                    let comID = this.state.rawData ? this.state.rawData.company_id : 0
                    let companyData = data.map((item) => {
                        return {
                            company_id: item.company_id,
                            company_name: item.company_name,
                        }
                    })

                    let arrayBaru = []
                    this.state.userCompany.map((item, index) => {
                        let indexID = companyData.findIndex((val) => val.company_id == item)
                        if (indexID !== -1) {
                            arrayBaru.push(companyData[indexID])
                        }
                    })

                    if (arrayBaru.length > 0) {
                        arrayBaru = arrayBaru.sort((a, b) => a.company_name.localeCompare(b.company_name))
                    }

                    let defaultProps = {
                        options: arrayBaru,
                        getOptionLabel: (option) => titleCase(option.company_name),
                    };
                    let index = arrayBaru.findIndex((val) => val.company_id == comID)
                    this.setState({ listCompany: defaultProps, company: arrayBaru.length < 1 ? companyData[0] : (index == -1 ? arrayBaru[0] : arrayBaru[index]) }, () => {
                        this.getLastPeriod()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', listCompany: null, company: null })
            }
        })
    }

    getLastPeriod() {
        api.create().getLastPeriod(this.state.company.company_id).then(response => {
            console.log(response);
            if (response.data.status === "success") {
                this.setState({ lastPeriod: response.data.data.last_periode, latestPeriode: response.data.data.latest_periode }, () => {
                    this.getPeriode()
                })
            }
        })
    }

    getPeriode() {
        api.create().getPeriodeTransaction().then(response => {
            let currentYear = new Date().getFullYear()
            // console.log(currentYear)
            if (response.data) {
                if (response.data.status === "success") {
                    let data = []
                    let listMonths = []
                    response.data.data.map((item) => {
                        if (this.state.isApprover) {
                            if (item >= 2000 && item <= (Number(currentYear) + 1)) {
                                data.push(item)
                            }
                        } else {
                            if ((item >= 2000) && (item == this.state.lastPeriod || item < this.state.lastPeriod)) {
                                data.push(item)
                            }
                        }
                    })
                    let periodeData = data.map((item) => {
                        return {
                            periode: item,
                        }
                    })
                    let defaultProps = {
                        options: periodeData,
                        getOptionLabel: (option) => option.periode,
                    };
                    console.log(this.state.lastPeriod)
                    let periode = (this.state.lastPeriod == "" ? String(Number(currentYear)) : this.state.latestPeriode)
                    let dateNow = new Date()
                    dateNow.setMonth(dateNow.getMonth() - 1);
                    let yearNow = dateNow.getFullYear()
                    console.log(yearNow)
                    console.log(periode)
                    let index = data.sort((a, b) => a - b).findIndex((val) => val == (String(this.state.report.label).toLocaleLowerCase().includes('summary') ? yearNow : periode))

                    // console.log(data)
                    // console.log(this.state.latestPeriode)
                    // console.log(periodeData)
                    console.log(index)
                    this.setState({ listPeriode: defaultProps, periode: index === -1 ? periodeData[0] : periodeData[index] }, () => {
                        // this.getDataTable()
                        // this.getSubmission()
                        this.getMonth()
                        // if (this.state.isApprover === true) {
                        //     this.getCompanySubmitted()
                        // } else {
                        //     this.getRevision()
                        // }
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    getMonth() {
        api.create().getMonthTransaction().then(response => {
            let dateNow = new Date()
            dateNow.setMonth(dateNow.getMonth() - 1);
            let month = format(dateNow, 'MMMM')
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    // console.log(response);
                    let data = response.data.data
                    let monthData = data.map((item) => {
                        return {
                            month_id: item.id,
                            month_value: String(item.month_name).substr(0, 3)
                        }
                    })
                    let defaultProps = {
                        options: monthData,
                        getOptionLabel: (option) => option.month_value,
                    };
                    let index = data.findIndex((val) => val.month_name == month)

                    let listQuarter = [
                        { name: 'Q1', value: '3' },
                        { name: 'Q2', value: '6' },
                        { name: 'Q3', value: '9' },
                        { name: 'Q4', value: '12' },
                    ]

                    let listUom = [{ value: 'Mio IDR' }]

                    let defaultPropsQuarter = {
                        options: listQuarter,
                        getOptionLabel: (option) => option.name,
                    };

                    let defaultPropsUom = {
                        options: listUom,
                        getOptionLabel: (option) => option.value,
                    };
                    // console.log(month)
                    // console.log(index)
                    this.setState({ listMonths: defaultProps, month: index == -1 ? monthData[0] : monthData[index], listQuarter: defaultPropsQuarter, quarter: listQuarter[0], listUom: defaultPropsUom, uom: listUom[0] }, () => {
                        // if (this.state.isApprover === true) {
                        //     if (this.state.submittedOnly) {
                        //         console.log('masuk cuk')
                        //         this.getPeriode()
                        //     } else {
                        //         this.getLastPeriod()
                        //     }
                        // this.getPeriode()
                        this.getReportType()
                        // } else {
                        // this.getLastPeriod()
                        // this.getPeriode()
                        // }
                    })
                } else {
                    // this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                    //     if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                    //         setTimeout(() => {
                    //             localStorage.removeItem(Constant.TOKEN)
                    //             window.location.reload();
                    //         }, 1000);
                    //     }
                    // })
                }
            } else {
                // this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
            }
        })
    }

    getReportType() {
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "report_type": "Master Budget",
        }
        this.getApproveMB()
        this.getApproveMonthly()
        api.create().getReportTypeBody(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    if (this.state.report.value === 2) {
                        response.data.data.map((item, index) => {
                            if (item.report_name === 'Balance Sheet') {
                                this.setState({ revisionType: item.revision }, () => {
                                    this.getSubmission()
                                })
                            }
                        })
                    } else if (this.state.report.value === 1) {
                        response.data.data.map((item, index) => {
                            if (item.report_name === 'Profit Loss') {
                                this.setState({ revisionType: item.revision }, () => {
                                    this.getSubmission()
                                })
                            }
                        })
                    } else if (this.state.report.value === 5) {
                        response.data.data.map((item, index) => {
                            if (item.report_name === 'Tax Planning') {
                                this.setState({ revisionType: item.revision }, () => {
                                    this.getSubmission()
                                })
                            }
                        })
                    } else {
                        this.setState({ revisionType: 0 }, () => {
                            this.getSubmission()
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getSubmission() {
        this.setState({ loading: true })
        let payload = {
            "company_id": this.state.company.company_id,
            "periode": this.state.periode.periode,
            "is_approver": true
        }
        api.create().getSubmission(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        submissionID: response.data.data.submission_id,
                        lastRevision: response.data.data.last_revision,
                    }, () => {
                        this.getDataTable()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ submissionID: null, loading: false })
            }
        })
    }

    getDataTable() {
        let payload = {
            "report_id": this.state.report.value,
            "revision": this.state.revisionType,
            "periode": this.state.periode.periode,
            "company_id": this.state.company.company_id,
            "submission_id": this.state.submissionID
        }
        if (this.state.report.value === 1) {
            api.create().getAllReportPLDetail(payload).then(response => {
                console.log(response);
                console.log(payload);
                let dataTable = []
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                dataTable.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.profit_loss.total_actual_before === null ? "0" : item.profit_loss.total_actual_before === "" ? "0" : item.profit_loss.total_actual_before,
                                    item.profit_loss.january,
                                    item.profit_loss.february,
                                    item.profit_loss.march,
                                    item.profit_loss.april,
                                    item.profit_loss.may,
                                    item.profit_loss.june,
                                    item.profit_loss.july,
                                    item.profit_loss.august,
                                    item.profit_loss.september,
                                    item.profit_loss.october,
                                    item.profit_loss.november,
                                    item.profit_loss.december,
                                    item.profit_loss.total_current_year,
                                    item.profit_loss.total_next_year,
                                    item.profit_loss.total_more_year,
                                    item.order,
                                    item.profit_loss.monthly_january,
                                    item.profit_loss.monthly_february,
                                    item.profit_loss.monthly_march,
                                    item.profit_loss.monthly_april,
                                    item.profit_loss.monthly_may,
                                    item.profit_loss.monthly_june,
                                    item.profit_loss.monthly_july,
                                    item.profit_loss.monthly_august,
                                    item.profit_loss.monthly_september,
                                    item.profit_loss.monthly_october,
                                    item.profit_loss.monthly_november,
                                    item.profit_loss.monthly_december,
                                    item.profit_loss.monthly_last_year_january,
                                    item.profit_loss.monthly_last_year_february,
                                    item.profit_loss.monthly_last_year_march,
                                    item.profit_loss.monthly_last_year_april,
                                    item.profit_loss.monthly_last_year_may,
                                    item.profit_loss.monthly_last_year_june,
                                    item.profit_loss.monthly_last_year_july,
                                    item.profit_loss.monthly_last_year_august,
                                    item.profit_loss.monthly_last_year_september,
                                    item.profit_loss.monthly_last_year_october,
                                    item.profit_loss.monthly_last_year_november,
                                    item.profit_loss.monthly_last_year_december,
                                    item.profit_loss.notes,
                                    item.profit_loss.ro_full_year_january,
                                    item.profit_loss.ro_full_year_february,
                                    item.profit_loss.ro_full_year_march,
                                    item.profit_loss.ro_full_year_april,
                                    item.profit_loss.ro_full_year_may,
                                    item.profit_loss.ro_full_year_june,
                                    item.profit_loss.ro_full_year_july,
                                    item.profit_loss.ro_full_year_august,
                                    item.profit_loss.ro_full_year_september,
                                    item.profit_loss.ro_full_year_october,
                                    item.profit_loss.ro_full_year_november,
                                    item.profit_loss.ro_full_year_december,
                                    item.profit_loss.ol_q1_january,
                                    item.profit_loss.ol_q1_february,
                                    item.profit_loss.ol_q1_march,
                                    item.profit_loss.ol_q1_april,
                                    item.profit_loss.ol_q1_may,
                                    item.profit_loss.ol_q1_june,
                                    item.profit_loss.ol_q1_july,
                                    item.profit_loss.ol_q1_august,
                                    item.profit_loss.ol_q1_september,
                                    item.profit_loss.ol_q1_october,
                                    item.profit_loss.ol_q1_november,
                                    item.profit_loss.ol_q1_december,
                                    item.profit_loss.ol_q2_january,
                                    item.profit_loss.ol_q2_february,
                                    item.profit_loss.ol_q2_march,
                                    item.profit_loss.ol_q2_april,
                                    item.profit_loss.ol_q2_may,
                                    item.profit_loss.ol_q2_june,
                                    item.profit_loss.ol_q2_july,
                                    item.profit_loss.ol_q2_august,
                                    item.profit_loss.ol_q2_september,
                                    item.profit_loss.ol_q2_october,
                                    item.profit_loss.ol_q2_november,
                                    item.profit_loss.ol_q2_december,
                                    item.profit_loss.ol_q3_january,
                                    item.profit_loss.ol_q3_february,
                                    item.profit_loss.ol_q3_march,
                                    item.profit_loss.ol_q3_april,
                                    item.profit_loss.ol_q3_may,
                                    item.profit_loss.ol_q3_june,
                                    item.profit_loss.ol_q3_july,
                                    item.profit_loss.ol_q3_august,
                                    item.profit_loss.ol_q3_september,
                                    item.profit_loss.ol_q3_october,
                                    item.profit_loss.ol_q3_november,
                                    item.profit_loss.ol_q3_december,
                                    item.profit_loss.ol_pa_january,
                                    item.profit_loss.ol_pa_february,
                                    item.profit_loss.ol_pa_march,
                                    item.profit_loss.ol_pa_april,
                                    item.profit_loss.ol_pa_may,
                                    item.profit_loss.ol_pa_june,
                                    item.profit_loss.ol_pa_july,
                                    item.profit_loss.ol_pa_august,
                                    item.profit_loss.ol_pa_september,
                                    item.profit_loss.ol_pa_october,
                                    item.profit_loss.ol_pa_november,
                                    item.profit_loss.ol_pa_december,
                                    // item.profit_loss.historialLast10YearList,
                                    item.profit_loss.history_last_nine_year,
                                    item.profit_loss.history_last_eight_year,
                                    item.profit_loss.history_last_seven_year,
                                    item.profit_loss.history_last_six_year,
                                    item.profit_loss.history_last_five_year,
                                    item.profit_loss.history_last_four_year,
                                    item.profit_loss.history_last_three_year,
                                    item.profit_loss.history_last_two_year,
                                    item.profit_loss.history_last_year,
                                    item.profit_loss.history_current_year,

                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_loss.total_actual_before === null ? "0" : item.profit_loss.total_actual_before === "" ? "0" : item.profit_loss.total_actual_before,
                                item.profit_loss.january,
                                item.profit_loss.february,
                                item.profit_loss.march,
                                item.profit_loss.april,
                                item.profit_loss.may,
                                item.profit_loss.june,
                                item.profit_loss.july,
                                item.profit_loss.august,
                                item.profit_loss.september,
                                item.profit_loss.october,
                                item.profit_loss.november,
                                item.profit_loss.december,
                                item.profit_loss.total_current_year,
                                item.profit_loss.total_next_year,
                                item.profit_loss.total_more_year,
                                item.order,
                                item.profit_loss.monthly_january,
                                item.profit_loss.monthly_february,
                                item.profit_loss.monthly_march,
                                item.profit_loss.monthly_april,
                                item.profit_loss.monthly_may,
                                item.profit_loss.monthly_june,
                                item.profit_loss.monthly_july,
                                item.profit_loss.monthly_august,
                                item.profit_loss.monthly_september,
                                item.profit_loss.monthly_october,
                                item.profit_loss.monthly_november,
                                item.profit_loss.monthly_december,
                                item.profit_loss.monthly_last_year_january,
                                item.profit_loss.monthly_last_year_february,
                                item.profit_loss.monthly_last_year_march,
                                item.profit_loss.monthly_last_year_april,
                                item.profit_loss.monthly_last_year_may,
                                item.profit_loss.monthly_last_year_june,
                                item.profit_loss.monthly_last_year_july,
                                item.profit_loss.monthly_last_year_august,
                                item.profit_loss.monthly_last_year_september,
                                item.profit_loss.monthly_last_year_october,
                                item.profit_loss.monthly_last_year_november,
                                item.profit_loss.monthly_last_year_december,
                                item.profit_loss.notes,
                                item.profit_loss.ro_full_year_january,
                                item.profit_loss.ro_full_year_february,
                                item.profit_loss.ro_full_year_march,
                                item.profit_loss.ro_full_year_april,
                                item.profit_loss.ro_full_year_may,
                                item.profit_loss.ro_full_year_june,
                                item.profit_loss.ro_full_year_july,
                                item.profit_loss.ro_full_year_august,
                                item.profit_loss.ro_full_year_september,
                                item.profit_loss.ro_full_year_october,
                                item.profit_loss.ro_full_year_november,
                                item.profit_loss.ro_full_year_december,
                                item.profit_loss.ol_q1_january,
                                item.profit_loss.ol_q1_february,
                                item.profit_loss.ol_q1_march,
                                item.profit_loss.ol_q1_april,
                                item.profit_loss.ol_q1_may,
                                item.profit_loss.ol_q1_june,
                                item.profit_loss.ol_q1_july,
                                item.profit_loss.ol_q1_august,
                                item.profit_loss.ol_q1_september,
                                item.profit_loss.ol_q1_october,
                                item.profit_loss.ol_q1_november,
                                item.profit_loss.ol_q1_december,
                                item.profit_loss.ol_q2_january,
                                item.profit_loss.ol_q2_february,
                                item.profit_loss.ol_q2_march,
                                item.profit_loss.ol_q2_april,
                                item.profit_loss.ol_q2_may,
                                item.profit_loss.ol_q2_june,
                                item.profit_loss.ol_q2_july,
                                item.profit_loss.ol_q2_august,
                                item.profit_loss.ol_q2_september,
                                item.profit_loss.ol_q2_october,
                                item.profit_loss.ol_q2_november,
                                item.profit_loss.ol_q2_december,
                                item.profit_loss.ol_q3_january,
                                item.profit_loss.ol_q3_february,
                                item.profit_loss.ol_q3_march,
                                item.profit_loss.ol_q3_april,
                                item.profit_loss.ol_q3_may,
                                item.profit_loss.ol_q3_june,
                                item.profit_loss.ol_q3_july,
                                item.profit_loss.ol_q3_august,
                                item.profit_loss.ol_q3_september,
                                item.profit_loss.ol_q3_october,
                                item.profit_loss.ol_q3_november,
                                item.profit_loss.ol_q3_december,
                                item.profit_loss.ol_pa_january,
                                item.profit_loss.ol_pa_february,
                                item.profit_loss.ol_pa_march,
                                item.profit_loss.ol_pa_april,
                                item.profit_loss.ol_pa_may,
                                item.profit_loss.ol_pa_june,
                                item.profit_loss.ol_pa_july,
                                item.profit_loss.ol_pa_august,
                                item.profit_loss.ol_pa_september,
                                item.profit_loss.ol_pa_october,
                                item.profit_loss.ol_pa_november,
                                item.profit_loss.ol_pa_december,
                                // item.profit_loss.historialLast10YearList
                                item.profit_loss.history_last_nine_year,
                                item.profit_loss.history_last_eight_year,
                                item.profit_loss.history_last_seven_year,
                                item.profit_loss.history_last_six_year,
                                item.profit_loss.history_last_five_year,
                                item.profit_loss.history_last_four_year,
                                item.profit_loss.history_last_three_year,
                                item.profit_loss.history_last_two_year,
                                item.profit_loss.history_last_year,
                                item.profit_loss.history_current_year,
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dataTable)
                        // this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })
                        this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })

                        // this.setState({ dataTable }, () => {
                        //     console.log(this.state.dataTable)
                        //     this.getPLDetailMR(payload)
                        // })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ dataTable: [], previewTable: false, loading: false, previewDownload: false })
                }
            })
        } else if (this.state.report.value === 2) {
            api.create().getAllReportBS(payload).then(response => {
                console.log(payload);
                console.log(response);
                let dataTable = []
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                dataTable.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.balance_sheet.total_actual_before === null ? "0.0" : item.balance_sheet.total_actual_before === "" ? "0.0" : item.balance_sheet.total_actual_before,
                                    Number(item.balance_sheet.january).toFixed(1),
                                    Number(item.balance_sheet.february).toFixed(1),
                                    Number(item.balance_sheet.march).toFixed(1),
                                    Number(item.balance_sheet.april).toFixed(1),
                                    Number(item.balance_sheet.may).toFixed(1),
                                    Number(item.balance_sheet.june).toFixed(1),
                                    Number(item.balance_sheet.july).toFixed(1),
                                    Number(item.balance_sheet.august).toFixed(1),
                                    Number(item.balance_sheet.september).toFixed(1),
                                    Number(item.balance_sheet.october).toFixed(1),
                                    Number(item.balance_sheet.november).toFixed(1),
                                    Number(item.balance_sheet.december).toFixed(1),
                                    Number(item.balance_sheet.total_current_year).toFixed(1),
                                    Number(item.balance_sheet.total_next_year).toFixed(1),
                                    Number(item.balance_sheet.total_more_year).toFixed(1),
                                    item.order,
                                    item.condition_it_should_be,
                                    item.condition_if_wrong,
                                    item.balance_sheet.monthly_january,
                                    item.balance_sheet.monthly_february,
                                    item.balance_sheet.monthly_march,
                                    item.balance_sheet.monthly_april,
                                    item.balance_sheet.monthly_may,
                                    item.balance_sheet.monthly_june,
                                    item.balance_sheet.monthly_july,
                                    item.balance_sheet.monthly_august,
                                    item.balance_sheet.monthly_september,
                                    item.balance_sheet.monthly_october,
                                    item.balance_sheet.monthly_november,
                                    item.balance_sheet.monthly_december,
                                    item.balance_sheet.monthly_last_year_january,
                                    item.balance_sheet.monthly_last_year_february,
                                    item.balance_sheet.monthly_last_year_march,
                                    item.balance_sheet.monthly_last_year_april,
                                    item.balance_sheet.monthly_last_year_may,
                                    item.balance_sheet.monthly_last_year_june,
                                    item.balance_sheet.monthly_last_year_july,
                                    item.balance_sheet.monthly_last_year_august,
                                    item.balance_sheet.monthly_last_year_september,
                                    item.balance_sheet.monthly_last_year_october,
                                    item.balance_sheet.monthly_last_year_november,
                                    item.balance_sheet.monthly_last_year_december,
                                    item.balance_sheet.ro_january,
                                    item.balance_sheet.ro_february,
                                    item.balance_sheet.ro_march,
                                    item.balance_sheet.ro_april,
                                    item.balance_sheet.ro_may,
                                    item.balance_sheet.ro_june,
                                    item.balance_sheet.ro_july,
                                    item.balance_sheet.ro_august,
                                    item.balance_sheet.ro_september,
                                    item.balance_sheet.ro_october,
                                    item.balance_sheet.ro_november,
                                    item.balance_sheet.ro_december,
                                    item.balance_sheet.ro_q1_january,
                                    item.balance_sheet.ro_q1_february,
                                    item.balance_sheet.ro_q1_march,
                                    item.balance_sheet.ro_q1_april,
                                    item.balance_sheet.ro_q1_may,
                                    item.balance_sheet.ro_q1_june,
                                    item.balance_sheet.ro_q1_july,
                                    item.balance_sheet.ro_q1_august,
                                    item.balance_sheet.ro_q1_september,
                                    item.balance_sheet.ro_q1_october,
                                    item.balance_sheet.ro_q1_november,
                                    item.balance_sheet.ro_q1_december,
                                    item.balance_sheet.ro_q2_january,
                                    item.balance_sheet.ro_q2_february,
                                    item.balance_sheet.ro_q2_march,
                                    item.balance_sheet.ro_q2_april,
                                    item.balance_sheet.ro_q2_may,
                                    item.balance_sheet.ro_q2_june,
                                    item.balance_sheet.ro_q2_july,
                                    item.balance_sheet.ro_q2_august,
                                    item.balance_sheet.ro_q2_september,
                                    item.balance_sheet.ro_q2_october,
                                    item.balance_sheet.ro_q2_november,
                                    item.balance_sheet.ro_q2_december,
                                    item.balance_sheet.ro_q3_january,
                                    item.balance_sheet.ro_q3_february,
                                    item.balance_sheet.ro_q3_march,
                                    item.balance_sheet.ro_q3_april,
                                    item.balance_sheet.ro_q3_may,
                                    item.balance_sheet.ro_q3_june,
                                    item.balance_sheet.ro_q3_july,
                                    item.balance_sheet.ro_q3_august,
                                    item.balance_sheet.ro_q3_september,
                                    item.balance_sheet.ro_q3_october,
                                    item.balance_sheet.ro_q3_november,
                                    item.balance_sheet.ro_q3_december,
                                    item.balance_sheet.ol_pa_january,
                                    item.balance_sheet.ol_pa_february,
                                    item.balance_sheet.ol_pa_march,
                                    item.balance_sheet.ol_pa_april,
                                    item.balance_sheet.ol_pa_may,
                                    item.balance_sheet.ol_pa_june,
                                    item.balance_sheet.ol_pa_july,
                                    item.balance_sheet.ol_pa_august,
                                    item.balance_sheet.ol_pa_september,
                                    item.balance_sheet.ol_pa_october,
                                    item.balance_sheet.ol_pa_november,
                                    item.balance_sheet.ol_pa_december,
                                    // item.balance_sheet.historial_last_10_years_list,
                                    item.balance_sheet.history_last_nine_year,
                                    item.balance_sheet.history_last_eight_year,
                                    item.balance_sheet.history_last_seven_year,
                                    item.balance_sheet.history_last_six_year,
                                    item.balance_sheet.history_last_five_year,
                                    item.balance_sheet.history_last_four_year,
                                    item.balance_sheet.history_last_three_year,
                                    item.balance_sheet.history_last_two_year,
                                    item.balance_sheet.history_last_year,
                                    item.balance_sheet.history_current_year,


                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.balance_sheet.total_actual_before === null ? "0.0" : item.balance_sheet.total_actual_before === "" ? "0.0" : item.balance_sheet.total_actual_before,
                                Number(item.balance_sheet.january).toFixed(1),
                                Number(item.balance_sheet.february).toFixed(1),
                                Number(item.balance_sheet.march).toFixed(1),
                                Number(item.balance_sheet.april).toFixed(1),
                                Number(item.balance_sheet.may).toFixed(1),
                                Number(item.balance_sheet.june).toFixed(1),
                                Number(item.balance_sheet.july).toFixed(1),
                                Number(item.balance_sheet.august).toFixed(1),
                                Number(item.balance_sheet.september).toFixed(1),
                                Number(item.balance_sheet.october).toFixed(1),
                                Number(item.balance_sheet.november).toFixed(1),
                                Number(item.balance_sheet.december).toFixed(1),
                                Number(item.balance_sheet.total_current_year).toFixed(1),
                                Number(item.balance_sheet.total_next_year).toFixed(1),
                                Number(item.balance_sheet.total_more_year).toFixed(1),
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.balance_sheet.monthly_january,
                                item.balance_sheet.monthly_february,
                                item.balance_sheet.monthly_march,
                                item.balance_sheet.monthly_april,
                                item.balance_sheet.monthly_may,
                                item.balance_sheet.monthly_june,
                                item.balance_sheet.monthly_july,
                                item.balance_sheet.monthly_august,
                                item.balance_sheet.monthly_september,
                                item.balance_sheet.monthly_october,
                                item.balance_sheet.monthly_november,
                                item.balance_sheet.monthly_december,
                                item.balance_sheet.monthly_last_year_january,
                                item.balance_sheet.monthly_last_year_february,
                                item.balance_sheet.monthly_last_year_march,
                                item.balance_sheet.monthly_last_year_april,
                                item.balance_sheet.monthly_last_year_may,
                                item.balance_sheet.monthly_last_year_june,
                                item.balance_sheet.monthly_last_year_july,
                                item.balance_sheet.monthly_last_year_august,
                                item.balance_sheet.monthly_last_year_september,
                                item.balance_sheet.monthly_last_year_october,
                                item.balance_sheet.monthly_last_year_november,
                                item.balance_sheet.monthly_last_year_december,
                                item.balance_sheet.ro_january,
                                item.balance_sheet.ro_february,
                                item.balance_sheet.ro_march,
                                item.balance_sheet.ro_april,
                                item.balance_sheet.ro_may,
                                item.balance_sheet.ro_june,
                                item.balance_sheet.ro_july,
                                item.balance_sheet.ro_august,
                                item.balance_sheet.ro_september,
                                item.balance_sheet.ro_october,
                                item.balance_sheet.ro_november,
                                item.balance_sheet.ro_december,
                                item.balance_sheet.ro_q1_january,
                                item.balance_sheet.ro_q1_february,
                                item.balance_sheet.ro_q1_march,
                                item.balance_sheet.ro_q1_april,
                                item.balance_sheet.ro_q1_may,
                                item.balance_sheet.ro_q1_june,
                                item.balance_sheet.ro_q1_july,
                                item.balance_sheet.ro_q1_august,
                                item.balance_sheet.ro_q1_september,
                                item.balance_sheet.ro_q1_october,
                                item.balance_sheet.ro_q1_november,
                                item.balance_sheet.ro_q1_december,
                                item.balance_sheet.ro_q2_january,
                                item.balance_sheet.ro_q2_february,
                                item.balance_sheet.ro_q2_march,
                                item.balance_sheet.ro_q2_april,
                                item.balance_sheet.ro_q2_may,
                                item.balance_sheet.ro_q2_june,
                                item.balance_sheet.ro_q2_july,
                                item.balance_sheet.ro_q2_august,
                                item.balance_sheet.ro_q2_september,
                                item.balance_sheet.ro_q2_october,
                                item.balance_sheet.ro_q2_november,
                                item.balance_sheet.ro_q2_december,
                                item.balance_sheet.ro_q3_january,
                                item.balance_sheet.ro_q3_february,
                                item.balance_sheet.ro_q3_march,
                                item.balance_sheet.ro_q3_april,
                                item.balance_sheet.ro_q3_may,
                                item.balance_sheet.ro_q3_june,
                                item.balance_sheet.ro_q3_july,
                                item.balance_sheet.ro_q3_august,
                                item.balance_sheet.ro_q3_september,
                                item.balance_sheet.ro_q3_october,
                                item.balance_sheet.ro_q3_november,
                                item.balance_sheet.ro_q3_december,
                                item.balance_sheet.ol_pa_january,
                                item.balance_sheet.ol_pa_february,
                                item.balance_sheet.ol_pa_march,
                                item.balance_sheet.ol_pa_april,
                                item.balance_sheet.ol_pa_may,
                                item.balance_sheet.ol_pa_june,
                                item.balance_sheet.ol_pa_july,
                                item.balance_sheet.ol_pa_august,
                                item.balance_sheet.ol_pa_september,
                                item.balance_sheet.ol_pa_october,
                                item.balance_sheet.ol_pa_november,
                                item.balance_sheet.ol_pa_december,
                                // item.balance_sheet.historial_last_10_years_list
                                item.balance_sheet.history_last_nine_year,
                                item.balance_sheet.history_last_eight_year,
                                item.balance_sheet.history_last_seven_year,
                                item.balance_sheet.history_last_six_year,
                                item.balance_sheet.history_last_five_year,
                                item.balance_sheet.history_last_four_year,
                                item.balance_sheet.history_last_three_year,
                                item.balance_sheet.history_last_two_year,
                                item.balance_sheet.history_last_year,
                                item.balance_sheet.history_current_year,

                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })
                        // this.setState({ dataTable }, () => {
                        // console.log(this.state.dataTable)
                        //     this.getBalanceSheetMR(payload)
                        // })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }

                } else {
                    this.setState({ dataTable: [], previewTable: false, loading: false, previewDownload: false })
                }
                console.log(dataTable);
            })
        } else if (this.state.report.value === 3) {
            let PLID = null
            let payloadID = {
                "periode": this.state.periode.periode,
                "company_id": this.state.company.company_id
            }
            // console.log(payloadID);
            api.create().getPLID(payloadID).then(response => {
                console.log(response);
                if (response) {
                    PLID = response.data.data == null ? null : response.data.data.profit_loss_id
                    // PLID = response.data.data.profit_loss_id 
                } else {
                    PLID = null
                }
                this.setState({ PLID }, () => {
                    let payloads = { ...payload, report_id: 28, submission_id: this.state.PLID, months: this.state.month.month_id, quarter: 0 }
                    console.log(payloads);
                    api.create().getReportPL(payloads).then(response => {
                        console.log(response);
                        if (response.data) {
                            if (response.data.status === 'success') {
                                let dataTable = []
                                console.log(response)
                                let res = response.data.data
                                const handlePushChild = (item) => {
                                    dataTable.push([
                                        item.type_report_id,
                                        item.id,
                                        item.parent,
                                        item.formula,
                                        item.level,
                                        item.description,
                                        item.profit_loss.total_actual_before === null ? "0" : item.profit_loss.total_actual_before === "" ? "0" : item.profit_loss.total_actual_before,
                                        item.profit_loss.january,
                                        item.profit_loss.february,
                                        item.profit_loss.march,
                                        item.profit_loss.april,
                                        item.profit_loss.may,
                                        item.profit_loss.june,
                                        item.profit_loss.july,
                                        item.profit_loss.august,
                                        item.profit_loss.september,
                                        item.profit_loss.october,
                                        item.profit_loss.november,
                                        item.profit_loss.december,
                                        item.profit_loss.total_current_year,
                                        item.profit_loss.total_next_year,
                                        item.profit_loss.total_more_year,
                                        item.order,
                                        item.condition_it_should_be,
                                        item.condition_if_wrong,
                                        [],
                                        "",
                                        item.profit_loss.monthly_january,
                                        item.profit_loss.monthly_february,
                                        item.profit_loss.monthly_march,
                                        item.profit_loss.monthly_april,
                                        item.profit_loss.monthly_may,
                                        item.profit_loss.monthly_june,
                                        item.profit_loss.monthly_july,
                                        item.profit_loss.monthly_august,
                                        item.profit_loss.monthly_september,
                                        item.profit_loss.monthly_october,
                                        item.profit_loss.monthly_november,
                                        item.profit_loss.monthly_december,
                                        item.profit_loss.monthly_last_year_january,
                                        item.profit_loss.monthly_last_year_february,
                                        item.profit_loss.monthly_last_year_march,
                                        item.profit_loss.monthly_last_year_april,
                                        item.profit_loss.monthly_last_year_may,
                                        item.profit_loss.monthly_last_year_june,
                                        item.profit_loss.monthly_last_year_july,
                                        item.profit_loss.monthly_last_year_august,
                                        item.profit_loss.monthly_last_year_september,
                                        item.profit_loss.monthly_last_year_october,
                                        item.profit_loss.monthly_last_year_november,
                                        item.profit_loss.monthly_last_year_december,
                                        item.profit_loss.notes,
                                        item.profit_loss.ro_full_year_january,
                                        item.profit_loss.ro_full_year_february,
                                        item.profit_loss.ro_full_year_march,
                                        item.profit_loss.ro_full_year_april,
                                        item.profit_loss.ro_full_year_may,
                                        item.profit_loss.ro_full_year_june,
                                        item.profit_loss.ro_full_year_july,
                                        item.profit_loss.ro_full_year_august,
                                        item.profit_loss.ro_full_year_september,
                                        item.profit_loss.ro_full_year_october,
                                        item.profit_loss.ro_full_year_november,
                                        item.profit_loss.ro_full_year_december,
                                        item.profit_loss.ol_q1_january,
                                        item.profit_loss.ol_q1_february,
                                        item.profit_loss.ol_q1_march,
                                        item.profit_loss.ol_q1_april,
                                        item.profit_loss.ol_q1_may,
                                        item.profit_loss.ol_q1_june,
                                        item.profit_loss.ol_q1_july,
                                        item.profit_loss.ol_q1_august,
                                        item.profit_loss.ol_q1_september,
                                        item.profit_loss.ol_q1_october,
                                        item.profit_loss.ol_q1_november,
                                        item.profit_loss.ol_q1_december,
                                        item.profit_loss.ol_q2_january,
                                        item.profit_loss.ol_q2_february,
                                        item.profit_loss.ol_q2_march,
                                        item.profit_loss.ol_q2_april,
                                        item.profit_loss.ol_q2_may,
                                        item.profit_loss.ol_q2_june,
                                        item.profit_loss.ol_q2_july,
                                        item.profit_loss.ol_q2_august,
                                        item.profit_loss.ol_q2_september,
                                        item.profit_loss.ol_q2_october,
                                        item.profit_loss.ol_q2_november,
                                        item.profit_loss.ol_q2_december,
                                        item.profit_loss.ol_q3_january,
                                        item.profit_loss.ol_q3_february,
                                        item.profit_loss.ol_q3_march,
                                        item.profit_loss.ol_q3_april,
                                        item.profit_loss.ol_q3_may,
                                        item.profit_loss.ol_q3_june,
                                        item.profit_loss.ol_q3_july,
                                        item.profit_loss.ol_q3_august,
                                        item.profit_loss.ol_q3_september,
                                        item.profit_loss.ol_q3_october,
                                        item.profit_loss.ol_q3_november,
                                        item.profit_loss.ol_q3_december,
                                        item.profit_loss.ol_pa_january,
                                        item.profit_loss.ol_pa_february,
                                        item.profit_loss.ol_pa_march,
                                        item.profit_loss.ol_pa_april,
                                        item.profit_loss.ol_pa_may,
                                        item.profit_loss.ol_pa_june,
                                        item.profit_loss.ol_pa_july,
                                        item.profit_loss.ol_pa_august,
                                        item.profit_loss.ol_pa_september,
                                        item.profit_loss.ol_pa_october,
                                        item.profit_loss.ol_pa_november,
                                        item.profit_loss.ol_pa_december,
                                        item.profit_loss.history_current_year,
                                        item.profit_loss.history_last_year,
                                        item.profit_loss.history_last_two_year,
                                        item.profit_loss.history_last_three_year,
                                        item.profit_loss.history_last_four_year,
                                        item.profit_loss.history_last_five_year,
                                        item.profit_loss.history_last_six_year,
                                        item.profit_loss.history_last_seven_year,
                                        item.profit_loss.history_last_eight_year,
                                        item.profit_loss.history_last_nine_year,
                                    ])

                                    if (item.children !== null) {
                                        if (item.children.length > 0) {
                                            item.children.map((items, indexs) => {
                                                handlePushChild(items)
                                            })
                                        }
                                    }
                                }
                                res.map((item, index) => {
                                    dataTable.push([
                                        item.type_report_id,
                                        item.id,
                                        item.parent,
                                        item.formula,
                                        item.level,
                                        item.description,
                                        item.profit_loss.total_actual_before === null ? "0" : item.profit_loss.total_actual_before === "" ? "0" : item.profit_loss.total_actual_before,
                                        item.profit_loss.january,
                                        item.profit_loss.february,
                                        item.profit_loss.march,
                                        item.profit_loss.april,
                                        item.profit_loss.may,
                                        item.profit_loss.june,
                                        item.profit_loss.july,
                                        item.profit_loss.august,
                                        item.profit_loss.september,
                                        item.profit_loss.october,
                                        item.profit_loss.november,
                                        item.profit_loss.december,
                                        item.profit_loss.total_current_year,
                                        item.profit_loss.total_next_year,
                                        item.profit_loss.total_more_year,
                                        item.order,
                                        item.condition_it_should_be,
                                        item.condition_if_wrong,
                                        [],
                                        "",
                                        item.profit_loss.monthly_january,
                                        item.profit_loss.monthly_february,
                                        item.profit_loss.monthly_march,
                                        item.profit_loss.monthly_april,
                                        item.profit_loss.monthly_may,
                                        item.profit_loss.monthly_june,
                                        item.profit_loss.monthly_july,
                                        item.profit_loss.monthly_august,
                                        item.profit_loss.monthly_september,
                                        item.profit_loss.monthly_october,
                                        item.profit_loss.monthly_november,
                                        item.profit_loss.monthly_december,
                                        item.profit_loss.monthly_last_year_january,
                                        item.profit_loss.monthly_last_year_february,
                                        item.profit_loss.monthly_last_year_march,
                                        item.profit_loss.monthly_last_year_april,
                                        item.profit_loss.monthly_last_year_may,
                                        item.profit_loss.monthly_last_year_june,
                                        item.profit_loss.monthly_last_year_july,
                                        item.profit_loss.monthly_last_year_august,
                                        item.profit_loss.monthly_last_year_september,
                                        item.profit_loss.monthly_last_year_october,
                                        item.profit_loss.monthly_last_year_november,
                                        item.profit_loss.monthly_last_year_december,
                                        item.profit_loss.notes,
                                        item.profit_loss.ro_full_year_january,
                                        item.profit_loss.ro_full_year_february,
                                        item.profit_loss.ro_full_year_march,
                                        item.profit_loss.ro_full_year_april,
                                        item.profit_loss.ro_full_year_may,
                                        item.profit_loss.ro_full_year_june,
                                        item.profit_loss.ro_full_year_july,
                                        item.profit_loss.ro_full_year_august,
                                        item.profit_loss.ro_full_year_september,
                                        item.profit_loss.ro_full_year_october,
                                        item.profit_loss.ro_full_year_november,
                                        item.profit_loss.ro_full_year_december,
                                        item.profit_loss.ol_q1_january,
                                        item.profit_loss.ol_q1_february,
                                        item.profit_loss.ol_q1_march,
                                        item.profit_loss.ol_q1_april,
                                        item.profit_loss.ol_q1_may,
                                        item.profit_loss.ol_q1_june,
                                        item.profit_loss.ol_q1_july,
                                        item.profit_loss.ol_q1_august,
                                        item.profit_loss.ol_q1_september,
                                        item.profit_loss.ol_q1_october,
                                        item.profit_loss.ol_q1_november,
                                        item.profit_loss.ol_q1_december,
                                        item.profit_loss.ol_q2_january,
                                        item.profit_loss.ol_q2_february,
                                        item.profit_loss.ol_q2_march,
                                        item.profit_loss.ol_q2_april,
                                        item.profit_loss.ol_q2_may,
                                        item.profit_loss.ol_q2_june,
                                        item.profit_loss.ol_q2_july,
                                        item.profit_loss.ol_q2_august,
                                        item.profit_loss.ol_q2_september,
                                        item.profit_loss.ol_q2_october,
                                        item.profit_loss.ol_q2_november,
                                        item.profit_loss.ol_q2_december,
                                        item.profit_loss.ol_q3_january,
                                        item.profit_loss.ol_q3_february,
                                        item.profit_loss.ol_q3_march,
                                        item.profit_loss.ol_q3_april,
                                        item.profit_loss.ol_q3_may,
                                        item.profit_loss.ol_q3_june,
                                        item.profit_loss.ol_q3_july,
                                        item.profit_loss.ol_q3_august,
                                        item.profit_loss.ol_q3_september,
                                        item.profit_loss.ol_q3_october,
                                        item.profit_loss.ol_q3_november,
                                        item.profit_loss.ol_q3_december,
                                        item.profit_loss.ol_pa_january,
                                        item.profit_loss.ol_pa_february,
                                        item.profit_loss.ol_pa_march,
                                        item.profit_loss.ol_pa_april,
                                        item.profit_loss.ol_pa_may,
                                        item.profit_loss.ol_pa_june,
                                        item.profit_loss.ol_pa_july,
                                        item.profit_loss.ol_pa_august,
                                        item.profit_loss.ol_pa_september,
                                        item.profit_loss.ol_pa_october,
                                        item.profit_loss.ol_pa_november,
                                        item.profit_loss.ol_pa_december,
                                        item.profit_loss.history_current_year,
                                        item.profit_loss.history_last_year,
                                        item.profit_loss.history_last_two_year,
                                        item.profit_loss.history_last_three_year,
                                        item.profit_loss.history_last_four_year,
                                        item.profit_loss.history_last_five_year,
                                        item.profit_loss.history_last_six_year,
                                        item.profit_loss.history_last_seven_year,
                                        item.profit_loss.history_last_eight_year,
                                        item.profit_loss.history_last_nine_year,
                                    ])
                                    if (item.children !== null) {
                                        if (item.children.length > 0) {
                                            item.children.map((items, indexs) => {
                                                handlePushChild(items)
                                            })
                                        }
                                    }
                                })
                                this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })
                                // this.setState({ dataTable , loading: false}, () => {
                                console.log(this.state.dataTable)
                                // this.getReportPLMR(payload)
                                // })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                        } else {
                            this.setState({ dataTable: [], previewTable: false, loading: false, previewDownload: false })
                        }
                    })
                })
            })
        } else if (this.state.report.value === 4) {
            let FRID = null
            let payloadFRID = {
                "periode": this.state.periode.periode,
                "company_id": this.state.company.company_id
            }
            api.create().getFRID(payloadFRID).then(response => {
                console.log(response);
                if (response) {
                    FRID = response.data.data == null ? null : response.data.data.ratio_id
                } else {
                    FRID = null
                }
                this.setState({ FRID }, () => {
                    let payloads = { ...payload, report_id: 29, submission_id: this.state.FRID, months: this.state.month.month_id, quarter: 0 }
                    api.create().getReportFR(payloads).then(response => {
                        console.log(payload);
                        console.log(response);
                        let dataTable = []
                        if (response.data) {
                            if (response.data.status === 'success') {
                                let res = response.data.data
                                const handlePushChild = (item) => {
                                    let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                                    if (indexIDzz === -1) {
                                        dataTable.push([
                                            item.type_report_id,
                                            item.id,
                                            item.parent,
                                            item.formula,
                                            item.level,
                                            item.description,
                                            item.uom,
                                            0,
                                            item.ratio.january,
                                            item.ratio.february,
                                            item.ratio.march,
                                            item.ratio.april,
                                            item.ratio.may,
                                            item.ratio.june,
                                            item.ratio.july,
                                            item.ratio.august,
                                            item.ratio.september,
                                            item.ratio.october,
                                            item.ratio.november,
                                            item.ratio.december,
                                            item.ratio.total_next_year,
                                            item.ratio.total_more_year,
                                            item.ratio.monthly_january,
                                            item.ratio.monthly_february,
                                            item.ratio.monthly_march,
                                            item.ratio.monthly_april,
                                            item.ratio.monthly_may,
                                            item.ratio.monthly_june,
                                            item.ratio.monthly_july,
                                            item.ratio.monthly_august,
                                            item.ratio.monthly_september,
                                            item.ratio.monthly_october,
                                            item.ratio.monthly_november,
                                            item.ratio.monthly_december,
                                            item.ratio.monthly_last_year_january,
                                            item.ratio.monthly_last_year_february,
                                            item.ratio.monthly_last_year_march,
                                            item.ratio.monthly_last_year_april,
                                            item.ratio.monthly_last_year_may,
                                            item.ratio.monthly_last_year_june,
                                            item.ratio.monthly_last_year_july,
                                            item.ratio.monthly_last_year_august,
                                            item.ratio.monthly_last_year_september,
                                            item.ratio.monthly_last_year_october,
                                            item.ratio.monthly_last_year_november,
                                            item.ratio.monthly_last_year_december,
                                            item.ratio.ro_ol_january,
                                            item.ratio.ro_ol_february,
                                            item.ratio.ro_ol_march,
                                            item.ratio.ro_ol_april,
                                            item.ratio.ro_ol_may,
                                            item.ratio.ro_ol_june,
                                            item.ratio.ro_ol_july,
                                            item.ratio.ro_ol_august,
                                            item.ratio.ro_ol_september,
                                            item.ratio.ro_ol_october,
                                            item.ratio.ro_ol_november,
                                            item.ratio.ro_ol_december,
                                            item.ratio.q1_january,
                                            item.ratio.q1_february,
                                            item.ratio.q1_march,
                                            item.ratio.q1_april,
                                            item.ratio.q1_may,
                                            item.ratio.q1_june,
                                            item.ratio.q1_july,
                                            item.ratio.q1_august,
                                            item.ratio.q1_september,
                                            item.ratio.q1_october,
                                            item.ratio.q1_november,
                                            item.ratio.q1_december,
                                            item.ratio.q2_january,
                                            item.ratio.q2_february,
                                            item.ratio.q2_march,
                                            item.ratio.q2_april,
                                            item.ratio.q2_may,
                                            item.ratio.q2_june,
                                            item.ratio.q2_july,
                                            item.ratio.q2_august,
                                            item.ratio.q2_september,
                                            item.ratio.q2_october,
                                            item.ratio.q2_november,
                                            item.ratio.q2_december,
                                            item.ratio.q3_january,
                                            item.ratio.q3_february,
                                            item.ratio.q3_march,
                                            item.ratio.q3_april,
                                            item.ratio.q3_may,
                                            item.ratio.q3_june,
                                            item.ratio.q3_july,
                                            item.ratio.q3_august,
                                            item.ratio.q3_september,
                                            item.ratio.q3_october,
                                            item.ratio.q3_november,
                                            item.ratio.q3_december,
                                            item.ratio.ol_january,
                                            item.ratio.ol_february,
                                            item.ratio.ol_march,
                                            item.ratio.ol_april,
                                            item.ratio.ol_may,
                                            item.ratio.ol_june,
                                            item.ratio.ol_july,
                                            item.ratio.ol_august,
                                            item.ratio.ol_september,
                                            item.ratio.ol_october,
                                            item.ratio.ol_november,
                                            item.ratio.ol_december,
                                            item.ratio.history_last_nine_year,
                                            item.ratio.history_last_eight_year,
                                            item.ratio.history_last_seven_year,
                                            item.ratio.history_last_six_year,
                                            item.ratio.history_last_five_year,
                                            item.ratio.history_last_four_year,
                                            item.ratio.history_last_three_year,
                                            item.ratio.history_last_two_year,
                                            item.ratio.history_last_year,
                                            item.ratio.history_current_year,

                                        ])
                                    }
                                    if (item.children !== null) {
                                        if (item.children.length > 0) {
                                            item.children.map((items, indexs) => {
                                                handlePushChild(items)
                                            })
                                        }
                                    }
                                }
                                res.map((item, index) => {
                                    dataTable.push([
                                        item.type_report_id,
                                        item.id,
                                        item.parent,
                                        item.formula,
                                        item.level,
                                        item.description,
                                        item.oum,
                                        0,
                                        item.ratio.january,
                                        item.ratio.february,
                                        item.ratio.march,
                                        item.ratio.april,
                                        item.ratio.may,
                                        item.ratio.june,
                                        item.ratio.july,
                                        item.ratio.august,
                                        item.ratio.september,
                                        item.ratio.october,
                                        item.ratio.november,
                                        item.ratio.december,
                                        item.ratio.total_next_year,
                                        item.ratio.total_more_year,
                                        item.ratio.monthly_january,
                                        item.ratio.monthly_february,
                                        item.ratio.monthly_march,
                                        item.ratio.monthly_april,
                                        item.ratio.monthly_may,
                                        item.ratio.monthly_june,
                                        item.ratio.monthly_july,
                                        item.ratio.monthly_august,
                                        item.ratio.monthly_september,
                                        item.ratio.monthly_october,
                                        item.ratio.monthly_november,
                                        item.ratio.monthly_december,
                                        item.ratio.monthly_last_year_january,
                                        item.ratio.monthly_last_year_february,
                                        item.ratio.monthly_last_year_march,
                                        item.ratio.monthly_last_year_april,
                                        item.ratio.monthly_last_year_may,
                                        item.ratio.monthly_last_year_june,
                                        item.ratio.monthly_last_year_july,
                                        item.ratio.monthly_last_year_august,
                                        item.ratio.monthly_last_year_september,
                                        item.ratio.monthly_last_year_october,
                                        item.ratio.monthly_last_year_november,
                                        item.ratio.monthly_last_year_december,
                                        item.ratio.ro_ol_january,
                                        item.ratio.ro_ol_february,
                                        item.ratio.ro_ol_march,
                                        item.ratio.ro_ol_april,
                                        item.ratio.ro_ol_may,
                                        item.ratio.ro_ol_june,
                                        item.ratio.ro_ol_july,
                                        item.ratio.ro_ol_august,
                                        item.ratio.ro_ol_september,
                                        item.ratio.ro_ol_october,
                                        item.ratio.ro_ol_november,
                                        item.ratio.ro_ol_december,
                                        item.ratio.q1_january,
                                        item.ratio.q1_february,
                                        item.ratio.q1_march,
                                        item.ratio.q1_april,
                                        item.ratio.q1_may,
                                        item.ratio.q1_june,
                                        item.ratio.q1_july,
                                        item.ratio.q1_august,
                                        item.ratio.q1_september,
                                        item.ratio.q1_october,
                                        item.ratio.q1_november,
                                        item.ratio.q1_december,
                                        item.ratio.q2_january,
                                        item.ratio.q2_february,
                                        item.ratio.q2_march,
                                        item.ratio.q2_april,
                                        item.ratio.q2_may,
                                        item.ratio.q2_june,
                                        item.ratio.q2_july,
                                        item.ratio.q2_august,
                                        item.ratio.q2_september,
                                        item.ratio.q2_october,
                                        item.ratio.q2_november,
                                        item.ratio.q2_december,
                                        item.ratio.q3_january,
                                        item.ratio.q3_february,
                                        item.ratio.q3_march,
                                        item.ratio.q3_april,
                                        item.ratio.q3_may,
                                        item.ratio.q3_june,
                                        item.ratio.q3_july,
                                        item.ratio.q3_august,
                                        item.ratio.q3_september,
                                        item.ratio.q3_october,
                                        item.ratio.q3_november,
                                        item.ratio.q3_december,
                                        item.ratio.ol_january,
                                        item.ratio.ol_february,
                                        item.ratio.ol_march,
                                        item.ratio.ol_april,
                                        item.ratio.ol_may,
                                        item.ratio.ol_june,
                                        item.ratio.ol_july,
                                        item.ratio.ol_august,
                                        item.ratio.ol_september,
                                        item.ratio.ol_october,
                                        item.ratio.ol_november,
                                        item.ratio.ol_december,
                                        item.ratio.history_last_nine_year,
                                        item.ratio.history_last_eight_year,
                                        item.ratio.history_last_seven_year,
                                        item.ratio.history_last_six_year,
                                        item.ratio.history_last_five_year,
                                        item.ratio.history_last_four_year,
                                        item.ratio.history_last_three_year,
                                        item.ratio.history_last_two_year,
                                        item.ratio.history_last_year,
                                        item.ratio.history_current_year,
                                    ])
                                    if (item.children !== null) {
                                        if (item.children.length > 0) {
                                            item.children.map((items, indexs) => {
                                                handlePushChild(items)
                                            })
                                        }
                                    }
                                })
                                this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })
                                console.log(this.state.dataTable)
                                // this.setState({ dataTable }, () => {
                                //     console.log(this.state.dataTable)
                                //     this.getRatioMR(payload)
                                // })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                        } else {
                            this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                        }
                    })
                })
            })
        } else if (this.state.report.value === 5) {
            api.create().getReportTP(payload).then(response => {
                console.log(payload);
                console.log(response);
                let dataTable = []
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                dataTable.push([
                                    item.type_report_id,
                                    // item.type_report_tax.value_tbc.type_report_id,
                                    // item.type_report_tax.value_fc.type_report_id,
                                    // item.type_report_tax.value_tbf.type_report_id,
                                    0,
                                    0,
                                    0,
                                    item.id,
                                    item.parent,
                                    { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                                    item.level,
                                    item.description,
                                    item.tax_planning_report.january,
                                    item.tax_planning_report.february,
                                    item.tax_planning_report.march,
                                    item.tax_planning_report.april,
                                    item.tax_planning_report.may,
                                    item.tax_planning_report.june,
                                    item.tax_planning_report.july,
                                    item.tax_planning_report.august,
                                    item.tax_planning_report.september,
                                    item.tax_planning_report.october,
                                    item.tax_planning_report.november,
                                    item.tax_planning_report.december,
                                    item.order,
                                    item.tax_planning_report.monthly_january,
                                    item.tax_planning_report.monthly_february,
                                    item.tax_planning_report.monthly_march,
                                    item.tax_planning_report.monthly_april,
                                    item.tax_planning_report.monthly_may,
                                    item.tax_planning_report.monthly_june,
                                    item.tax_planning_report.monthly_july,
                                    item.tax_planning_report.monthly_august,
                                    item.tax_planning_report.monthly_september,
                                    item.tax_planning_report.monthly_october,
                                    item.tax_planning_report.monthly_november,
                                    item.tax_planning_report.monthly_december,
                                    item.tax_planning_report.monthly_full_year,
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                // item.type_report_tax.value_tbc.type_report_id,
                                // item.type_report_tax.value_fc.type_report_id,
                                // item.type_report_tax.value_tbf.type_report_id,
                                0,
                                0,
                                0,
                                item.id,
                                item.parent,
                                { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                                item.level,
                                item.description,
                                item.tax_planning_report.january,
                                item.tax_planning_report.february,
                                item.tax_planning_report.march,
                                item.tax_planning_report.april,
                                item.tax_planning_report.may,
                                item.tax_planning_report.june,
                                item.tax_planning_report.july,
                                item.tax_planning_report.august,
                                item.tax_planning_report.september,
                                item.tax_planning_report.october,
                                item.tax_planning_report.november,
                                item.tax_planning_report.december,
                                item.order,
                                item.tax_planning_report.monthly_january,
                                item.tax_planning_report.monthly_february,
                                item.tax_planning_report.monthly_march,
                                item.tax_planning_report.monthly_april,
                                item.tax_planning_report.monthly_may,
                                item.tax_planning_report.monthly_june,
                                item.tax_planning_report.monthly_july,
                                item.tax_planning_report.monthly_august,
                                item.tax_planning_report.monthly_september,
                                item.tax_planning_report.monthly_october,
                                item.tax_planning_report.monthly_november,
                                item.tax_planning_report.monthly_december,
                                item.tax_planning_report.monthly_full_year,
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dataTable)
                        this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })
                        // this.setState({ dataTable }, () => {
                        //     this.getTaxPlanMR(payload)
                        // })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                }
            })
        } else if (this.state.report.value === 21) {
            let OPID = null
            let payload = {
                "company_id": this.state.company.company_id,
                "periode": this.state.periode.periode
            }
            api.create().getOpetratingIndID(payload).then(response => {
                console.log(response);
                if (response) {
                    // console.log(response.data.data)
                    if (response.data.data) {
                        OPID = response.data.data.operating_indicator_id
                    } else {
                        OPID = null
                    }
                    this.setState({ OPID }, () => {
                        let payloadOI = {
                            "company_id": this.state.company.company_id,
                            "operating_indicator_id": this.state.OPID,
                            "periode": this.state.periode.periode,
                            "report_id": 21
                        }

                        api.create().getAllReportOI(payloadOI).then(response => {
                            // console.log(payload);
                            console.log(response);
                            let dataTable = []
                            if (response.data) {
                                if (response.data.status === 'success') {
                                    let res = response.data.data
                                    // // // console.log(res) 
                                    const handlePushChild = (item) => {
                                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                                        if (indexIDzz === -1) {
                                            dataTable.push([
                                                item.type_report_id,
                                                item.id,
                                                item.parent,
                                                item.formula,
                                                item.level,
                                                item.description,
                                                item.uom,
                                                item.master_budget.total_actual_before == "" ? item.master_budget.total_actual_before : String(item.master_budget.total_actual_before).indexOf(".") == -1 ? Number(item.master_budget.total_actual_before) : Number(item.master_budget.total_actual_before).toFixed(1),
                                                item.master_budget.january == "" ? item.master_budget.january : String(item.master_budget.january).indexOf(".") == -1 ? Number(item.master_budget.january) : Number(item.master_budget.january).toFixed(1),
                                                item.master_budget.february == "" ? item.master_budget.february : String(item.master_budget.february).indexOf(".") == -1 ? Number(item.master_budget.february) : Number(item.master_budget.february).toFixed(1),
                                                item.master_budget.march == "" ? item.master_budget.march : String(item.master_budget.march).indexOf(".") == -1 ? Number(item.master_budget.march) : Number(item.master_budget.march).toFixed(1),
                                                item.master_budget.april == "" ? item.master_budget.april : String(item.master_budget.april).indexOf(".") == -1 ? Number(item.master_budget.april) : Number(item.master_budget.april).toFixed(1),
                                                item.master_budget.may == "" ? item.master_budget.may : String(item.master_budget.may).indexOf(".") == -1 ? Number(item.master_budget.may) : Number(item.master_budget.may).toFixed(1),
                                                item.master_budget.june == "" ? item.master_budget.june : String(item.master_budget.june).indexOf(".") == -1 ? Number(item.master_budget.june) : Number(item.master_budget.june).toFixed(1),
                                                item.master_budget.july == "" ? item.master_budget.july : String(item.master_budget.july).indexOf(".") == -1 ? Number(item.master_budget.july) : Number(item.master_budget.july).toFixed(1),
                                                item.master_budget.august == "" ? item.master_budget.august : String(item.master_budget.august).indexOf(".") == -1 ? Number(item.master_budget.august) : Number(item.master_budget.august).toFixed(1),
                                                item.master_budget.september == "" ? item.master_budget.september : String(item.master_budget.september).indexOf(".") == -1 ? Number(item.master_budget.september) : Number(item.master_budget.september).toFixed(1),
                                                item.master_budget.october == "" ? item.master_budget.october : String(item.master_budget.october).indexOf(".") == -1 ? Number(item.master_budget.october) : Number(item.master_budget.october).toFixed(1),
                                                item.master_budget.november == "" ? item.master_budget.november : String(item.master_budget.november).indexOf(".") == -1 ? Number(item.master_budget.november) : Number(item.master_budget.november).toFixed(1),
                                                item.master_budget.december == "" ? item.master_budget.december : String(item.master_budget.december).indexOf(".") == -1 ? Number(item.master_budget.december) : Number(item.master_budget.december).toFixed(1),
                                                item.master_budget.total_current_year == "" ? item.master_budget.total_current_year : String(item.master_budget.total_current_year).indexOf(".") == -1 ? Number(item.master_budget.total_current_year) : Number(item.master_budget.total_current_year).toFixed(1),
                                                item.order,
                                                item.master_budget.monthly_january == "" ? item.master_budget.monthly_january : String(item.master_budget.monthly_january).indexOf(".") == -1 ? Number(item.master_budget.monthly_january) : Number(item.master_budget.monthly_january).toFixed(1),
                                                item.master_budget.monthly_february == "" ? item.master_budget.monthly_february : String(item.master_budget.monthly_february).indexOf(".") == -1 ? Number(item.master_budget.monthly_february) : Number(item.master_budget.monthly_february).toFixed(1),
                                                item.master_budget.monthly_march == "" ? item.master_budget.monthly_march : String(item.master_budget.monthly_march).indexOf(".") == -1 ? Number(item.master_budget.monthly_march) : Number(item.master_budget.monthly_march).toFixed(1),
                                                item.master_budget.monthly_april == "" ? item.master_budget.monthly_april : String(item.master_budget.monthly_april).indexOf(".") == -1 ? Number(item.master_budget.monthly_april) : Number(item.master_budget.monthly_april).toFixed(1),
                                                item.master_budget.monthly_may == "" ? item.master_budget.monthly_may : String(item.master_budget.monthly_may).indexOf(".") == -1 ? Number(item.master_budget.monthly_may) : Number(item.master_budget.monthly_may).toFixed(1),
                                                item.master_budget.monthly_june == "" ? item.master_budget.monthly_june : String(item.master_budget.monthly_june).indexOf(".") == -1 ? Number(item.master_budget.monthly_june) : Number(item.master_budget.monthly_june).toFixed(1),
                                                item.master_budget.monthly_july == "" ? item.master_budget.monthly_july : String(item.master_budget.monthly_july).indexOf(".") == -1 ? Number(item.master_budget.monthly_july) : Number(item.master_budget.monthly_july).toFixed(1),
                                                item.master_budget.monthly_august == "" ? item.master_budget.monthly_august : String(item.master_budget.monthly_august).indexOf(".") == -1 ? Number(item.master_budget.monthly_august) : Number(item.master_budget.monthly_august).toFixed(1),
                                                item.master_budget.monthly_september == "" ? item.master_budget.monthly_september : String(item.master_budget.monthly_september).indexOf(".") == -1 ? Number(item.master_budget.monthly_september) : Number(item.master_budget.monthly_september).toFixed(1),
                                                item.master_budget.monthly_october == "" ? item.master_budget.monthly_october : String(item.master_budget.monthly_october).indexOf(".") == -1 ? Number(item.master_budget.monthly_october) : Number(item.master_budget.monthly_october).toFixed(1),
                                                item.master_budget.monthly_november == "" ? item.master_budget.monthly_november : String(item.master_budget.monthly_november).indexOf(".") == -1 ? Number(item.master_budget.monthly_november) : Number(item.master_budget.monthly_november).toFixed(1),
                                                item.master_budget.monthly_december == "" ? item.master_budget.monthly_december : String(item.master_budget.monthly_december).indexOf(".") == -1 ? Number(item.master_budget.monthly_december) : Number(item.master_budget.monthly_december).toFixed(1),
                                            ])
                                        }
                                        if (item.children !== null) {
                                            if (item.children.length > 0) {
                                                item.children.map((items, indexs) => {
                                                    handlePushChild(items)
                                                })
                                            }
                                        }
                                    }
                                    res.map((item, index) => {
                                        dataTable.push([
                                            item.type_report_id,
                                            item.id,
                                            item.parent,
                                            item.formula,
                                            item.level,
                                            item.description,
                                            item.uom,
                                            item.master_budget.total_actual_before == "" ? item.master_budget.total_actual_before : String(item.master_budget.total_actual_before).indexOf(".") == -1 ? Number(item.master_budget.total_actual_before) : Number(item.master_budget.total_actual_before).toFixed(1),
                                            item.master_budget.january == "" ? item.master_budget.january : String(item.master_budget.january).indexOf(".") == -1 ? Number(item.master_budget.january) : Number(item.master_budget.january).toFixed(1),
                                            item.master_budget.february == "" ? item.master_budget.february : String(item.master_budget.february).indexOf(".") == -1 ? Number(item.master_budget.february) : Number(item.master_budget.february).toFixed(1),
                                            item.master_budget.march == "" ? item.master_budget.march : String(item.master_budget.march).indexOf(".") == -1 ? Number(item.master_budget.march) : Number(item.master_budget.march).toFixed(1),
                                            item.master_budget.april == "" ? item.master_budget.april : String(item.master_budget.april).indexOf(".") == -1 ? Number(item.master_budget.april) : Number(item.master_budget.april).toFixed(1),
                                            item.master_budget.may == "" ? item.master_budget.may : String(item.master_budget.may).indexOf(".") == -1 ? Number(item.master_budget.may) : Number(item.master_budget.may).toFixed(1),
                                            item.master_budget.june == "" ? item.master_budget.june : String(item.master_budget.june).indexOf(".") == -1 ? Number(item.master_budget.june) : Number(item.master_budget.june).toFixed(1),
                                            item.master_budget.july == "" ? item.master_budget.july : String(item.master_budget.july).indexOf(".") == -1 ? Number(item.master_budget.july) : Number(item.master_budget.july).toFixed(1),
                                            item.master_budget.august == "" ? item.master_budget.august : String(item.master_budget.august).indexOf(".") == -1 ? Number(item.master_budget.august) : Number(item.master_budget.august).toFixed(1),
                                            item.master_budget.september == "" ? item.master_budget.september : String(item.master_budget.september).indexOf(".") == -1 ? Number(item.master_budget.september) : Number(item.master_budget.september).toFixed(1),
                                            item.master_budget.october == "" ? item.master_budget.october : String(item.master_budget.october).indexOf(".") == -1 ? Number(item.master_budget.october) : Number(item.master_budget.october).toFixed(1),
                                            item.master_budget.november == "" ? item.master_budget.november : String(item.master_budget.november).indexOf(".") == -1 ? Number(item.master_budget.november) : Number(item.master_budget.november).toFixed(1),
                                            item.master_budget.december == "" ? item.master_budget.december : String(item.master_budget.december).indexOf(".") == -1 ? Number(item.master_budget.december) : Number(item.master_budget.december).toFixed(1),
                                            item.master_budget.total_current_year == "" ? item.master_budget.total_current_year : String(item.master_budget.total_current_year).indexOf(".") == -1 ? Number(item.master_budget.total_current_year) : Number(item.master_budget.total_current_year).toFixed(1),
                                            item.order,
                                            item.master_budget.monthly_january == "" ? item.master_budget.monthly_january : String(item.master_budget.monthly_january).indexOf(".") == -1 ? Number(item.master_budget.monthly_january) : Number(item.master_budget.monthly_january).toFixed(1),
                                            item.master_budget.monthly_february == "" ? item.master_budget.monthly_february : String(item.master_budget.monthly_february).indexOf(".") == -1 ? Number(item.master_budget.monthly_february) : Number(item.master_budget.monthly_february).toFixed(1),
                                            item.master_budget.monthly_march == "" ? item.master_budget.monthly_march : String(item.master_budget.monthly_march).indexOf(".") == -1 ? Number(item.master_budget.monthly_march) : Number(item.master_budget.monthly_march).toFixed(1),
                                            item.master_budget.monthly_april == "" ? item.master_budget.monthly_april : String(item.master_budget.monthly_april).indexOf(".") == -1 ? Number(item.master_budget.monthly_april) : Number(item.master_budget.monthly_april).toFixed(1),
                                            item.master_budget.monthly_may == "" ? item.master_budget.monthly_may : String(item.master_budget.monthly_may).indexOf(".") == -1 ? Number(item.master_budget.monthly_may) : Number(item.master_budget.monthly_may).toFixed(1),
                                            item.master_budget.monthly_june == "" ? item.master_budget.monthly_june : String(item.master_budget.monthly_june).indexOf(".") == -1 ? Number(item.master_budget.monthly_june) : Number(item.master_budget.monthly_june).toFixed(1),
                                            item.master_budget.monthly_july == "" ? item.master_budget.monthly_july : String(item.master_budget.monthly_july).indexOf(".") == -1 ? Number(item.master_budget.monthly_july) : Number(item.master_budget.monthly_july).toFixed(1),
                                            item.master_budget.monthly_august == "" ? item.master_budget.monthly_august : String(item.master_budget.monthly_august).indexOf(".") == -1 ? Number(item.master_budget.monthly_august) : Number(item.master_budget.monthly_august).toFixed(1),
                                            item.master_budget.monthly_september == "" ? item.master_budget.monthly_september : String(item.master_budget.monthly_september).indexOf(".") == -1 ? Number(item.master_budget.monthly_september) : Number(item.master_budget.monthly_september).toFixed(1),
                                            item.master_budget.monthly_october == "" ? item.master_budget.monthly_october : String(item.master_budget.monthly_october).indexOf(".") == -1 ? Number(item.master_budget.monthly_october) : Number(item.master_budget.monthly_october).toFixed(1),
                                            item.master_budget.monthly_november == "" ? item.master_budget.monthly_november : String(item.master_budget.monthly_november).indexOf(".") == -1 ? Number(item.master_budget.monthly_november) : Number(item.master_budget.monthly_november).toFixed(1),
                                            item.master_budget.monthly_december == "" ? item.master_budget.monthly_december : String(item.master_budget.monthly_december).indexOf(".") == -1 ? Number(item.master_budget.monthly_december) : Number(item.master_budget.monthly_december).toFixed(1),
                                        ])
                                        if (item.children !== null) {
                                            if (item.children.length > 0) {
                                                item.children.map((items, indexs) => {
                                                    handlePushChild(items)
                                                })
                                            }
                                        }
                                    })
                                    this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })

                                    // this.setState({ dataTable }, () => {
                                    //     console.log(this.state.dataTable)
                                    //     this.getOIMR(payloadOI)
                                    // })
                                } else {
                                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                            setTimeout(() => {
                                                localStorage.removeItem(Constant.TOKEN)
                                                window.location.reload();
                                            }, 1000);
                                        }
                                    })
                                }
                            } else {
                                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                            }
                        })
                    })
                }
            })
        } else if (this.state.report.value === 6) {
            let dbSumaCF = []
            let paylodCF = { ...payload, months: this.state.month.month_id }
            console.log(paylodCF);
            api.create().getReportCFSuma(paylodCF).then(response => {
                console.log(response)
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        console.log(res)
                        const handlePushChild = (item) => {
                            let indexIDzz = dbSumaCF.findIndex((val) => val[0] === item.id)
                            if (indexIDzz === -1) {
                                let mtd_actual = item.cash_flow.mtd_actual == '' ? 0 : Number(item.cash_flow.mtd_actual)
                                let mtd = item.cash_flow.mtd == '' ? 0 : Number(item.cash_flow.mtd)
                                // console.log(mtd)
                                // let persenMtd = Number(mtd_actual / mtd)
                                let persenMtd = 0
                                if (mtd < 0) {
                                    if (mtd_actual >= mtd) {
                                        persenMtd = ((mtd - mtd_actual) / mtd + 1)
                                    } else {
                                        persenMtd = ((mtd - mtd_actual) / mtd)
                                    }
                                }
                                else {
                                    persenMtd = Number(mtd_actual / mtd)
                                }

                                let ytd_actual = item.cash_flow.ytd_actual == '' ? 0 : Number(item.cash_flow.ytd_actual)
                                let ytd = item.cash_flow.ytd == '' ? 0 : Number(item.cash_flow.ytd)

                                // let persenYtd = Number(ytd_actual / ytd)
                                let persenYtd = 0
                                if (ytd < 0) {
                                    if (ytd_actual >= ytd) {
                                        persenYtd = ((ytd - ytd_actual) / ytd + 1)
                                    } else {
                                        persenYtd = ((ytd - ytd_actual) / ytd)
                                    }
                                }
                                else {
                                    persenYtd = Number(ytd_actual / ytd)
                                }

                                let quarter_actual = item.cash_flow.quarter_actual == '' ? 0 : Number(item.cash_flow.quarter_actual)
                                let quarter = item.cash_flow.quarter_mb == '' ? 0 : Number(item.cash_flow.quarter_mb)
                                // let persenQuarter = Number(quarter_actual / quarter)
                                let persenQuarter = 0
                                if (quarter < 0) {
                                    if (quarter_actual >= quarter) {
                                        persenQuarter = (quarter - quarter_actual) / quarter + 1
                                    } else {
                                        persenQuarter = (quarter - quarter_actual) / quarter
                                    }
                                }
                                else {
                                    persenQuarter = quarter_actual / quarter
                                }

                                let fy_actual = item.cash_flow.fy_actual == '' ? 0 : Number(item.cash_flow.fy_actual)
                                let fy = item.cash_flow.fy == '' ? 0 : Number(item.cash_flow.fy)
                                // let persenFy = Number(fy_actual / fy)
                                // console.log(fy_actual);
                                let persenFy = 0
                                if (fy < 0) {
                                    if (fy_actual >= fy) {
                                        persenFy = (fy - fy_actual) / fy + 1
                                    } else {
                                        persenFy = (fy - fy_actual) / fy
                                    }
                                }
                                else {
                                    persenFy = fy_actual / fy
                                }
                                let ol = item.cash_flow.fy_ol == '' ? 0 : Number(item.cash_flow.fy_ol)
                                let persenOL = 0
                                if (fy < 0) {
                                    if (ol >= fy) {
                                        persenOL = (fy - ol) / fy + 1
                                    } else {
                                        persenOL = (fy - ol) / fy
                                    }
                                }
                                else {
                                    persenOL = ol / fy
                                }

                                dbSumaCF.push([
                                    item.id,
                                    item.cash_flow.mtd_actual,
                                    item.cash_flow.mtd,
                                    isNaN(persenMtd) || persenMtd == 'Infinity' || persenMtd == '-Infinity' ? (item.cash_flow.mtd == '' || item.cash_flow.mtd == 0 ? -0 : 0) : (item.cash_flow.mtd == '' || item.cash_flow.mtd == 0 ? persenMtd * -100 : persenMtd * 100),
                                    item.cash_flow.mtd_last_year,
                                    item.cash_flow.ytd_actual,
                                    item.cash_flow.ytd,
                                    isNaN(persenYtd) || persenYtd == 'Infinity' || persenYtd == '-Infinity' ? (item.cash_flow.ytd == '' || item.cash_flow.ytd == 0 ? -0 : 0) : (item.cash_flow.ytd == '' || item.cash_flow.ytd == 0 ? persenYtd * -100 : persenYtd * 100),
                                    // isNaN(persenYtd)? 0 : persenYtd * 100,
                                    item.cash_flow.ytd_last_year,
                                    item.cash_flow.quarter_actual,
                                    item.cash_flow.quarter_mb,
                                    isNaN(persenQuarter) || persenQuarter == 'Infinity' || persenQuarter == '-Infinity' ? (item.cash_flow.quarter_mb == '' || item.cash_flow.quarter_mb == 0 ? -0 : 0) : (item.cash_flow.quarter_mb == '' || item.cash_flow.quarter_mb == 0 ? persenQuarter * -100 : persenQuarter * 100),
                                    // isNaN(persenQuarter)? 0 : persenQuarter * 100,
                                    item.cash_flow.quarter_last_year,
                                    item.cash_flow.fy_actual,
                                    item.cash_flow.fy,
                                    isNaN(persenFy) || persenFy == 'Infinity' || persenFy == '-Infinity' ? (item.cash_flow.fy == '' || item.cash_flow.fy == 0 ? -0 : 0) : (item.cash_flow.fy == '' || item.cash_flow.fy == 0 ? persenFy * -100 : persenFy * 100),
                                    item.cash_flow.fy_ol,
                                    isNaN(persenOL) || persenOL == 'Infinity' || persenOL == '-Infinity' ? (item.cash_flow.fy_ol == '' || item.cash_flow.fy_ol == 0 ? -0 : 0) : (item.cash_flow.fy_ol == '' || item.cash_flow.fy_ol == 0 ? persenOL * -100 : persenOL * 100),
                                    // isNaN(persenFy)? 0 : persenFy * 100,
                                    item.cash_flow.fy_last_year,
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            let mtd_actual = item.cash_flow.mtd_actual == '' ? 0 : Number(item.cash_flow.mtd_actual)
                            let mtd = item.cash_flow.mtd == '' ? 0 : Number(item.cash_flow.mtd)
                            // console.log(mtd)
                            // let persenMtd = Number(mtd_actual / mtd)
                            let persenMtd = 0
                            if (mtd < 0) {
                                if (mtd_actual >= mtd) {
                                    persenMtd = ((mtd - mtd_actual) / mtd + 1)
                                } else {
                                    persenMtd = ((mtd - mtd_actual) / mtd)
                                }
                            }
                            else {
                                persenMtd = Number(mtd_actual / mtd)
                            }

                            let ytd_actual = item.cash_flow.ytd_actual == '' ? 0 : Number(item.cash_flow.ytd_actual)
                            let ytd = item.cash_flow.ytd == '' ? 0 : Number(item.cash_flow.ytd)
                            // let persenYtd = Number(ytd_actual / ytd)
                            let persenYtd = 0
                            if (ytd < 0) {
                                if (ytd_actual >= ytd) {
                                    persenYtd = ((ytd - ytd_actual) / ytd + 1)
                                } else {
                                    persenYtd = ((ytd - ytd_actual) / ytd)
                                }
                            }
                            else {
                                persenYtd = Number(ytd_actual / ytd)
                            }

                            let quarter_actual = item.cash_flow.quarter_actual == '' ? 0 : Number(item.cash_flow.quarter_actual)
                            let quarter = item.cash_flow.quarter_mb == '' ? 0 : Number(item.cash_flow.quarter_mb)
                            // let persenQuarter = Number(quarter_actual / quarter)
                            let persenQuarter = 0
                            if (quarter < 0) {
                                if (quarter_actual >= quarter) {
                                    persenQuarter = (quarter - quarter_actual) / quarter + 1
                                } else {
                                    persenQuarter = (quarter - quarter_actual) / quarter
                                }
                            }
                            else {
                                persenQuarter = quarter_actual / quarter
                            }

                            let fy_actual = item.cash_flow.fy_actual == '' ? 0 : Number(item.cash_flow.fy_actual)
                            let fy = item.cash_flow.fy == '' ? 0 : Number(item.cash_flow.fy)
                            // let persenFy = Number(fy_actual / fy)
                            let persenFy = 0
                            if (fy < 0) {
                                if (fy_actual >= fy) {
                                    persenFy = (fy - fy_actual) / fy + 1
                                } else {
                                    persenFy = (fy - fy_actual) / fy
                                }
                            }
                            else {
                                persenFy = fy_actual / fy
                            }
                            let ol = item.cash_flow.fy_ol == '' ? 0 : Number(item.cash_flow.fy_ol)
                            let persenOl = 0
                            if (fy < 0) {
                                if (ol >= fy) {
                                    persenOl = (fy - ol) / fy + 1
                                } else {
                                    persenOl = (fy - ol) / fy
                                }
                            }
                            else {
                                persenOl = ol / fy
                            }

                            dbSumaCF.push([
                                item.id,
                                item.cash_flow.mtd_actual,
                                item.cash_flow.mtd,
                                isNaN(persenMtd) || persenMtd == 'Infinity' || persenMtd == '-Infinity' ? (item.cash_flow.mtd == '' || item.cash_flow.mtd == 0 ? -0 : 0) : (item.cash_flow.mtd == '' || item.cash_flow.mtd == 0 ? persenMtd * -100 : persenMtd * 100),
                                item.cash_flow.mtd_last_year,
                                item.cash_flow.ytd_actual,
                                item.cash_flow.ytd,
                                isNaN(persenYtd) || persenYtd == 'Infinity' || persenYtd == '-Infinity' ? (item.cash_flow.ytd == '' || item.cash_flow.ytd == 0 ? -0 : 0) : (item.cash_flow.ytd == '' || item.cash_flow.ytd == 0 ? persenYtd * -100 : persenYtd * 100),
                                // isNaN(persenYtd)? 0 : persenYtd * 100,
                                item.cash_flow.ytd_last_year,
                                item.cash_flow.quarter_actual,
                                item.cash_flow.quarter_mb,
                                isNaN(persenQuarter) || persenQuarter == 'Infinity' || persenQuarter == '-Infinity' ? (item.cash_flow.quarter_mb == '' || item.cash_flow.quarter_mb == 0 ? -0 : 0) : (item.cash_flow.quarter_mb == '' || item.cash_flow.quarter_mb == 0 ? persenQuarter * -100 : persenQuarter * 100),
                                // isNaN(persenQuarter)? 0 : persenQuarter * 100,
                                item.cash_flow.quarter_last_year,
                                item.cash_flow.fy_actual,
                                item.cash_flow.fy,
                                isNaN(persenFy) || persenFy == 'Infinity' || persenFy == '-Infinity' ? (item.cash_flow.fy == '' || item.cash_flow.fy == 0 ? -0 : 0) : (item.cash_flow.fy == '' || item.cash_flow.fy == 0 ? persenFy * -100 : persenFy * 100),
                                item.cash_flow.fy_ol,
                                isNaN(persenOl) || persenOl == 'Infinity' || persenOl == '-Infinity' ? (item.cash_flow.fy_ol == '' || item.cash_flow.fy_ol == 0 ? -0 : 0) : (item.cash_flow.fy_ol == '' || item.cash_flow.fy_ol == 0 ? persenOl * -100 : persenOl * 100),
                                // isNaN(persenFy)? 0 : persenFy * 100,
                                item.cash_flow.fy_last_year,
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dbSumaCF)
                        this.setState({ dbSumaCF }, () => {
                            api.create().getReportCFSumaMB(payload).then(response => {
                                // console.log(payload);
                                console.log(response);
                                let dataTable = []
                                if (response.data) {
                                    if (response.data.status === 'success') {
                                        let res = response.data.data
                                        console.log(res)
                                        const handlePushChild = (item) => {
                                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                                            let indexIDSuma = dbSumaCF.findIndex((val) => val[0] === item.id)
                                            if (indexIDzz === -1) {
                                                dataTable.push([
                                                    item.type_report_id,
                                                    item.id,
                                                    item.parent,
                                                    item.formula,
                                                    item.level,
                                                    item.description,
                                                    item.cash_flow.total_actual_before,
                                                    item.cash_flow.january,
                                                    item.cash_flow.february,
                                                    item.cash_flow.march,
                                                    item.cash_flow.april,
                                                    item.cash_flow.may,
                                                    item.cash_flow.june,
                                                    item.cash_flow.july,
                                                    item.cash_flow.august,
                                                    item.cash_flow.september,
                                                    item.cash_flow.october,
                                                    item.cash_flow.november,
                                                    item.cash_flow.december,
                                                    item.cash_flow.total_current_year,
                                                    item.cash_flow.total_next_year,
                                                    item.cash_flow.total_more_year,
                                                    item.order,
                                                    item.condition_it_should_be,
                                                    item.condition_if_wrong,
                                                    item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula,
                                                    item.cash_flow.olpa_january,
                                                    item.cash_flow.olpa_february,
                                                    item.cash_flow.olpa_march,
                                                    item.cash_flow.olpa_april,
                                                    item.cash_flow.olpa_may,
                                                    item.cash_flow.olpa_june,
                                                    item.cash_flow.olpa_july,
                                                    item.cash_flow.olpa_august,
                                                    item.cash_flow.olpa_september,
                                                    item.cash_flow.olpa_october,
                                                    item.cash_flow.olpa_november,
                                                    item.cash_flow.olpa_december,
                                                    item.cash_flow.olpa_total_current_year,
                                                    ...dbSumaCF[indexIDSuma]

                                                ])
                                            }
                                            if (item.children !== null) {
                                                if (item.children.length > 0) {
                                                    item.children.map((items, indexs) => {
                                                        handlePushChild(items)
                                                    })
                                                }
                                            }
                                        }
                                        res.map((item, index) => {
                                            let indexIDSuma = dbSumaCF.findIndex((val) => val[0] === item.id)
                                            dataTable.push([
                                                item.type_report_id,
                                                item.id,
                                                item.parent,
                                                item.formula,
                                                item.level,
                                                item.description,
                                                item.cash_flow.total_actual_before,
                                                item.cash_flow.january,
                                                item.cash_flow.february,
                                                item.cash_flow.march,
                                                item.cash_flow.april,
                                                item.cash_flow.may,
                                                item.cash_flow.june,
                                                item.cash_flow.july,
                                                item.cash_flow.august,
                                                item.cash_flow.september,
                                                item.cash_flow.october,
                                                item.cash_flow.november,
                                                item.cash_flow.december,
                                                item.cash_flow.total_current_year,
                                                item.cash_flow.total_next_year,
                                                item.cash_flow.total_more_year,
                                                item.order,
                                                item.condition_it_should_be,
                                                item.condition_if_wrong,
                                                item.cash_flow.forecast_formula == null ? [] : item.cash_flow.forecast_formula,
                                                item.cash_flow.olpa_january,
                                                item.cash_flow.olpa_february,
                                                item.cash_flow.olpa_march,
                                                item.cash_flow.olpa_april,
                                                item.cash_flow.olpa_may,
                                                item.cash_flow.olpa_june,
                                                item.cash_flow.olpa_july,
                                                item.cash_flow.olpa_august,
                                                item.cash_flow.olpa_september,
                                                item.cash_flow.olpa_october,
                                                item.cash_flow.olpa_november,
                                                item.cash_flow.olpa_december,
                                                item.cash_flow.olpa_total_current_year,
                                                ...dbSumaCF[indexIDSuma]
                                            ])
                                            if (item.children !== null) {
                                                if (item.children.length > 0) {
                                                    item.children.map((items, indexs) => {
                                                        handlePushChild(items)
                                                    })
                                                }
                                            }
                                        })
                                        this.setState({ dataTable }, () => {
                                            console.log(this.state.dataTable)
                                            this.getCFSumaMR(paylodCF, dbSumaCF)
                                        })
                                    } else {
                                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                                setTimeout(() => {
                                                    localStorage.removeItem(Constant.TOKEN)
                                                    window.location.reload();
                                                }, 1000);
                                            }
                                        })
                                    }
                                } else {
                                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                                }
                                console.log(dataTable);
                            })
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                }
            })
        } else if (this.state.report.value === 7) {
            let dbSumaBS = []
            let payloadBS = { ...payload, report_id: 2, months: this.state.month.month_id, quarter: 0 }
            api.create().getReportBSSuma(payloadBS).then(response => {
                // console.log(payloadBS);
                console.log(response);
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dbSumaBS.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                let mtd_actual = item.balance_sheet.mtd_actual == '' ? 0 : item.balance_sheet.mtd_actual
                                let mtd_ol = item.balance_sheet.mtd_ol == '' ? 0 : item.balance_sheet.mtd_ol
                                let mtd_mb = item.balance_sheet.mtd_mb == '' ? 0 : item.balance_sheet.mtd_mb
                                let persenMtd = 0
                                let persenOL = 0

                                if (mtd_mb < 0) {
                                    if (parseFloat(mtd_actual) < parseFloat(mtd_mb)) {
                                        persenMtd = Number((mtd_mb - mtd_actual) / mtd_mb)
                                    } else {
                                        persenMtd = Number((mtd_mb - mtd_actual) / mtd_mb) + 1
                                    }
                                } else {
                                    persenMtd = Number(mtd_actual / mtd_mb)
                                }

                                if (mtd_ol < 0) {
                                    if (parseFloat(mtd_actual) < parseFloat(mtd_ol)) {
                                        persenOL = Number((mtd_ol - mtd_actual) / mtd_ol)
                                    } else {
                                        persenOL = Number((mtd_ol - mtd_actual) / mtd_ol) + 1
                                    }
                                } else {
                                    persenOL = Number(mtd_actual / mtd_ol)
                                }

                                dbSumaBS.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.balance_sheet.mtd_last_month,
                                    item.balance_sheet.mtd_actual,
                                    item.balance_sheet.mtd_mb,
                                    isNaN(persenMtd) || persenMtd == 'Infinity' || persenMtd == '-Infinity' ? (item.balance_sheet.mtd_mb == '' || item.balance_sheet.mtd_mb == 0 ? -0 : 0) : (item.balance_sheet.mtd_mb == '' || item.balance_sheet.mtd_mb == 0 ? persenMtd * -100 : persenMtd * 100),
                                    item.balance_sheet.mtd_ol,
                                    isNaN(persenOL) || persenOL == 'Infinity' || persenOL == '-Infinity' ? (item.balance_sheet.mtd_ol == '' || item.balance_sheet.mtd_ol == 0 ? -0 : 0) : (item.balance_sheet.mtd_ol == '' || item.balance_sheet.mtd_ol == 0 ? persenOL * -100 : persenOL * 100),
                                    item.balance_sheet.mtd_last_year,
                                    item.balance_sheet.forecast_next_year,
                                    item.balance_sheet.forecast_more_year,
                                    item.order
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            let mtd_actual = item.balance_sheet.mtd_actual == '' ? 0 : item.balance_sheet.mtd_actual
                            let mtd_ol = item.balance_sheet.mtd_ol == '' ? 0 : item.balance_sheet.mtd_ol
                            let mtd_mb = item.balance_sheet.mtd_mb == '' ? 0 : item.balance_sheet.mtd_mb
                            let persenMtd = 0
                            let persenOL = 0

                            if (mtd_mb < 0) {
                                if (parseFloat(mtd_actual) < parseFloat(mtd_mb)) {
                                    persenMtd = Number((mtd_mb - mtd_actual) / mtd_mb)
                                } else {
                                    persenMtd = Number((mtd_mb - mtd_actual) / mtd_mb) + 1
                                }
                            } else {
                                persenMtd = Number(mtd_actual / mtd_mb)
                            }

                            if (mtd_ol < 0) {
                                if (parseFloat(mtd_actual) < parseFloat(mtd_ol)) {
                                    persenOL = Number((mtd_ol - mtd_actual) / mtd_ol)
                                } else {
                                    persenOL = Number((mtd_ol - mtd_actual) / mtd_ol) + 1
                                }
                            } else {
                                persenOL = Number(mtd_actual / mtd_ol)
                            }

                            dbSumaBS.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.balance_sheet.mtd_last_month,
                                item.balance_sheet.mtd_actual,
                                item.balance_sheet.mtd_mb,
                                isNaN(persenMtd) || persenMtd == 'Infinity' || persenMtd == '-Infinity' ? (item.balance_sheet.mtd_mb == '' || item.balance_sheet.mtd_mb == 0 ? -0 : 0) : (item.balance_sheet.mtd_mb == '' || item.balance_sheet.mtd_mb == 0 ? persenMtd * -100 : persenMtd * 100),
                                item.balance_sheet.mtd_ol,
                                isNaN(persenOL) || persenOL == 'Infinity' || persenOL == '-Infinity' ? (item.balance_sheet.mtd_ol == '' || item.balance_sheet.mtd_ol == 0 ? -0 : 0) : (item.balance_sheet.mtd_ol == '' || item.balance_sheet.mtd_ol == 0 ? persenOL * -100 : persenOL * 100),
                                item.balance_sheet.mtd_last_year,
                                item.balance_sheet.forecast_next_year,
                                item.balance_sheet.forecast_more_year,
                                item.order
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        this.setState({ dataTable: dbSumaBS, previewTable: true, loading: false, previewDownload: true })
                        console.log(this.state.dataTable)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                }
            })

        } else if (this.state.report.value === 8) {
            let dbSumaPL = []
            let payloadPL = { ...payload, report_id: 28, months: this.state.month.month_id }
            api.create().getReportPLSuma(payloadPL).then(response => {
                console.log(response);
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        console.log(res)
                        const handlePushChild = (item) => {
                            let indexIDzz = dbSumaPL.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                let month = this.state.month.month_value;
                                let mtd_actual = item.profit_loss.mtd_actual == '' ? 0 : Number(item.profit_loss.mtd_actual)
                                let mtd_mb = item.profit_loss.mtd_mb == '' ? 0 : Number(item.profit_loss.mtd_mb)
                                let mtd_last_year = item.profit_loss.mtd_last_year == '' ? 0 : Number(item.profit_loss.mtd_last_year)
                                let persenMtd = 0
                                if (mtd_mb < 0) {
                                    if (mtd_actual >= mtd_mb) {
                                        persenMtd = (mtd_mb - mtd_actual) / mtd_mb + 1
                                    } else {
                                        persenMtd = (mtd_mb - mtd_actual) / mtd_mb
                                    }
                                }
                                else {
                                    persenMtd = mtd_actual / mtd_mb
                                }

                                let persenMtdLY = 0
                                if (mtd_last_year < 0) {
                                    if (mtd_actual >= mtd_last_year) {
                                        persenMtdLY = (mtd_last_year - mtd_actual) / mtd_last_year + 1
                                    } else {
                                        persenMtdLY = (mtd_last_year - mtd_actual) / mtd_last_year
                                    }
                                }
                                else {
                                    persenMtdLY = mtd_actual / mtd_last_year
                                }


                                let ytd_actual = item.profit_loss.ytd_actual == '' ? 0 : Number(item.profit_loss.ytd_actual)
                                let ytd_mb = item.profit_loss.ytd_mb == '' ? 0 : Number(item.profit_loss.ytd_mb)
                                let ytd_last_year = item.profit_loss.ytd_last_year == '' ? 0 : Number(item.profit_loss.ytd_last_year)
                                let persenYtdMB = 0
                                if (ytd_mb < 0) {
                                    if (ytd_actual >= ytd_mb) {
                                        persenYtdMB = (ytd_mb - ytd_actual) / ytd_mb + 1
                                    } else {
                                        persenYtdMB = (ytd_mb - ytd_actual) / ytd_mb
                                    }
                                }
                                else {
                                    persenYtdMB = ytd_actual / ytd_mb
                                }

                                let persenYtdLY = 0
                                if (ytd_last_year < 0) {
                                    if (ytd_actual >= ytd_last_year) {
                                        persenYtdLY = (ytd_last_year - ytd_actual) / ytd_last_year + 1
                                    } else {
                                        persenYtdLY = (ytd_last_year - ytd_actual) / ytd_last_year
                                    }
                                }
                                else {
                                    persenYtdLY = ytd_actual / ytd_last_year
                                }

                                // let q1_actual = item.profit_loss.q1_actual == ''? 0 : Number(item.profit_loss.q1_actual)
                                let q_actual = month == "Mar" ? item.profit_loss.q1_actual == '' ? 0 : Number(item.profit_loss.q1_actual) : month == "Jun" ? item.profit_loss.q2_actual == '' ? 0 : Number(item.profit_loss.q2_actual) : month == "Sep" ? item.profit_loss.q3_actual == '' ? 0 : Number(item.profit_loss.q3_actual) : 0
                                // let q1_mb = item.profit_loss.q1_mb == ''? 0 : Number(item.profit_loss.q1_mb)
                                let q_mb = month == "Mar" ? item.profit_loss.q1_mb == '' ? 0 : Number(item.profit_loss.q1_mb) : month == "Jun" ? item.profit_loss.q2_mb == '' ? 0 : Number(item.profit_loss.q2_mb) : month == "Sep" ? item.profit_loss.q3_mb == '' ? 0 : Number(item.profit_loss.q3_mb) : 0
                                // let q1_last_year = item.profit_loss.q1_last_year == ''? 0 : Number(item.profit_loss.q1_last_year)
                                let q_last_year = month == "Mar" ? item.profit_loss.q1_last_year == '' ? 0 : Number(item.profit_loss.q1_last_year) : month == "Jun" ? item.profit_loss.q2_last_year == '' ? 0 : Number(item.profit_loss.q2_last_year) : month == "Sep" ? item.profit_loss.q3_last_year == '' ? 0 : Number(item.profit_loss.q3_last_year) : 0
                                let persenQuarterMB = 0
                                if (q_mb < 0) {
                                    if (q_actual >= q_mb) {
                                        persenQuarterMB = (q_mb - q_actual) / q_mb + 1
                                    } else {
                                        persenQuarterMB = (q_mb - q_actual) / q_mb
                                    }
                                }
                                else {
                                    persenQuarterMB = q_actual / q_mb
                                }

                                let persenQuarterLY = 0
                                if (q_last_year < 0) {
                                    if (q_actual >= q_last_year) {
                                        persenQuarterLY = (q_last_year - q_actual) / q_last_year + 1
                                    } else {
                                        persenQuarterLY = (q_last_year - q_actual) / q_last_year
                                    }
                                }
                                else {
                                    persenQuarterLY = q_actual / q_last_year
                                }

                                let fy_actual = item.profit_loss.fy_actual == '' ? 0 : Number(item.profit_loss.fy_actual)
                                let fy_mb = item.profit_loss.fy_mb == '' ? 0 : Number(item.profit_loss.fy_mb)
                                let fy_ol = item.profit_loss.fy_ol == '' ? 0 : Number(item.profit_loss.fy_ol)
                                let fy_last_year = item.profit_loss.fy_last_year == '' ? 0 : Number(item.profit_loss.fy_last_year)
                                let persenFyMB = 0
                                if (fy_mb < 0) {
                                    if (fy_actual >= fy_mb) {
                                        persenFyMB = (fy_mb - fy_actual) / fy_mb + 1
                                    } else {
                                        persenFyMB = (fy_mb - fy_actual) / fy_mb
                                    }
                                }
                                else {
                                    persenFyMB = fy_actual / fy_mb
                                }

                                let persenFyOL = 0
                                if (fy_ol < 0) {
                                    if (fy_actual >= fy_ol) {
                                        persenFyOL = (fy_ol - fy_actual) / fy_ol + 1
                                    } else {
                                        persenFyOL = (fy_ol - fy_actual) / fy_ol
                                    }
                                }
                                else {
                                    persenFyOL = fy_actual / fy_ol
                                }

                                let persenFyLY = 0
                                if (fy_last_year < 0) {
                                    if (fy_actual >= fy_last_year) {
                                        persenFyLY = (fy_last_year - fy_actual) / fy_last_year + 1
                                    } else {
                                        persenFyLY = (fy_last_year - fy_actual) / fy_last_year
                                    }
                                }
                                else {
                                    persenFyLY = fy_actual / fy_last_year
                                }

                                // if (item.id === 3297327) {
                                //     console.log(fy_actual);
                                //     console.log(fy_last_year);
                                //     console.log(persenFyLY);
                                // }

                                // let persenFyOLMB = Number(fy_ol/fy_mb)
                                // if (fy_mb  < 0) {
                                //     if (fy_ol >= fy_mb) {
                                //         persenFyLY = (fy_mb - fy_ol) / fy_mb + 1  
                                //     }  else {
                                //         persenFyLY = (fy_mb - fy_ol) / fy_mb 
                                //     }
                                // }
                                // else {
                                //     persenFyLY = fy_ol / fy_mb 
                                // }

                                let persenFyOLMB = 0
                                if (fy_mb < 0) {
                                    if (fy_ol >= fy_mb) {
                                        persenFyOLMB = (fy_mb - fy_ol) / fy_mb + 1
                                    } else {
                                        persenFyOLMB = (fy_mb - fy_ol) / fy_mb
                                    }
                                }
                                else {
                                    persenFyOLMB = fy_ol / fy_mb
                                }

                                dbSumaPL.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.profit_loss.mtd_actual,
                                    item.profit_loss.mtd_mb,
                                    isNaN(persenMtd) || persenMtd == 'Infinity' || persenMtd == '-Infinity' ? (item.profit_loss.mtd_mb == '' || item.profit_loss.mtd_mb == 0 ? -0 : 0) : (item.profit_loss.mtd_mb == '' || item.profit_loss.mtd_mb == 0 ? persenMtd * -100 : persenMtd * 100),
                                    item.profit_loss.mtd_last_year,
                                    isNaN(persenMtdLY) || persenMtdLY == 'Infinity' || persenMtdLY == '-Infinity' ? (item.profit_loss.mtd_last_year == '' || item.profit_loss.mtd_last_year == 0 ? -0 : 0) : (item.profit_loss.mtd_last_year == '' || item.profit_loss.mtd_last_year == 0 ? persenMtdLY * -100 : persenMtdLY * 100),
                                    item.profit_loss.ytd_actual,
                                    item.profit_loss.ytd_mb,
                                    isNaN(persenYtdMB) || persenYtdMB == 'Infinity' || persenYtdMB == '-Infinity' ? (item.profit_loss.ytd_mb == '' || item.profit_loss.ytd_mb == 0 ? -0 : 0) : (item.profit_loss.ytd_mb == '' || item.profit_loss.ytd_mb == 0 ? persenYtdMB * -100 : persenYtdMB * 100),
                                    item.profit_loss.ytd_last_year,
                                    isNaN(persenYtdLY) || persenYtdLY == 'Infinity' || persenYtdLY == '-Infinity' ? (item.profit_loss.ytd_last_year == '' || item.profit_loss.ytd_last_year == 0 ? -0 : 0) : (item.profit_loss.ytd_last_year == '' || item.profit_loss.ytd_last_year == 0 ? persenYtdLY * -100 : persenYtdLY * 100),
                                    month == "Mar" ? item.profit_loss.q1_actual :
                                        month == "Jun" ? item.profit_loss.q2_actual :
                                            month == "Sep" ? item.profit_loss.q3_actual :
                                                month == "Dec" ? item.profit_loss.q4_actual : 0,
                                    month == "Mar" ? item.profit_loss.q1_mb :
                                        month == "Jun" ? item.profit_loss.q2_mb :
                                            month == "Sep" ? item.profit_loss.q3_mb :
                                                month == "Dec" ? item.profit_loss.q4_mb : 0,
                                    isNaN(persenQuarterMB) || persenQuarterMB == 'Infinity' || persenQuarterMB == '-Infinity' ? (q_mb == '' || q_mb == 0 ? -0 : 0) : (q_mb == '' || q_mb == 0 ? persenQuarterMB * -100 : persenQuarterMB * 100),
                                    // isNaN(persenQuarterMB) || persenQuarterMB == 'Infinity' || persenQuarterMB == '-Infinity'? (item.profit_loss.q1_mb == '' || item.profit_loss.q1_mb == 0? -0 : 0) : (item.profit_loss.q1_mb == '' || item.profit_loss.q1_mb == 0? persenQuarterMB * -100 : persenQuarterMB * 100),
                                    month == "Mar" ? item.profit_loss.q1_last_year :
                                        month == "Jun" ? item.profit_loss.q2_last_year :
                                            month == "Sep" ? item.profit_loss.q3_last_year :
                                                month == "Dec" ? item.profit_loss.q4_last_year : 0,
                                    isNaN(persenQuarterLY) || persenQuarterLY == 'Infinity' || persenQuarterLY == '-Infinity' ? (q_last_year == '' || q_last_year == 0 ? -0 : 0) : (q_last_year == '' || q_last_year == 0 ? persenQuarterLY * -100 : persenQuarterLY * 100),
                                    // isNaN(persenQuarterLY) || persenQuarterLY == 'Infinity' || persenQuarterLY == '-Infinity'? (item.profit_loss.q1_last_year == '' || item.profit_loss.q1_last_year == 0? -0 : 0) : (item.profit_loss.q1_last_year == '' || item.profit_loss.q1_last_year == 0? persenQuarterLY * -100 : persenQuarterLY * 100),
                                    item.profit_loss.fy_actual,
                                    item.profit_loss.fy_mb,
                                    isNaN(persenFyMB) || persenFyMB == 'Infinity' || persenFyMB == '-Infinity' ? (item.profit_loss.fy_mb == '' || item.profit_loss.fy_mb == 0 ? -0 : 0) : (item.profit_loss.fy_mb == '' || item.profit_loss.fy_mb == 0 ? persenFyMB * -100 : persenFyMB * 100),
                                    item.profit_loss.fy_ol,
                                    isNaN(persenFyOL) || persenFyOL == 'Infinity' || persenFyOL == '-Infinity' ? (item.profit_loss.fy_ol == '' || item.profit_loss.fy_ol == 0 ? -0 : 0) : (item.profit_loss.fy_ol == '' || item.profit_loss.fy_ol == 0 ? persenFyOL * -100 : persenFyOL * 100),
                                    item.profit_loss.fy_last_year,
                                    isNaN(persenFyLY) || persenFyLY == 'Infinity' || persenFyLY == '-Infinity' ? (item.profit_loss.fy_last_year == '' || item.profit_loss.fy_last_year == 0 ? -0 : 0) : (item.profit_loss.fy_last_year == '' || item.profit_loss.fy_last_year == 0 ? persenFyLY * -100 : persenFyLY * 100),
                                    isNaN(persenFyOLMB) || persenFyOLMB == 'Infinity' || persenFyOLMB == '-Infinity' ? (item.profit_loss.fy_percent_ach_ol_to_mb == '' || item.profit_loss.fy_percent_ach_ol_to_mb == 0 ? -0 : 0) : (item.profit_loss.fy_percent_ach_ol_to_mb == '' || item.profit_loss.fy_percent_ach_ol_to_mb == 0 ? persenFyOLMB * -100 : persenFyOLMB * 100),
                                    item.profit_loss.forecast_next_year,
                                    item.profit_loss.forecast_more_year,
                                    item.profit_loss.notes,
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            let month = this.state.month.month_value;
                            let mtd_actual = item.profit_loss.mtd_actual == '' ? 0 : Number(item.profit_loss.mtd_actual)
                            let mtd_mb = item.profit_loss.mtd_mb == '' ? 0 : Number(item.profit_loss.mtd_mb)
                            let mtd_last_year = item.profit_loss.mtd_last_year == '' ? 0 : Number(item.profit_loss.mtd_last_year)
                            let persenMtd = 0
                            if (mtd_mb < 0) {
                                if (mtd_actual >= mtd_mb) {
                                    persenMtd = (mtd_mb - mtd_actual) / mtd_mb + 1
                                } else {
                                    persenMtd = (mtd_mb - mtd_actual) / mtd_mb
                                }
                            }
                            else {
                                persenMtd = mtd_actual / mtd_mb
                            }

                            let persenMtdLY = 0
                            if (mtd_last_year < 0) {
                                if (mtd_actual >= mtd_last_year) {
                                    persenMtdLY = (mtd_last_year - mtd_actual) / mtd_last_year + 1
                                } else {
                                    persenMtdLY = (mtd_last_year - mtd_actual) / mtd_last_year
                                }
                            }
                            else {
                                persenMtdLY = mtd_actual / mtd_last_year
                            }


                            let ytd_actual = item.profit_loss.ytd_actual == '' ? 0 : Number(item.profit_loss.ytd_actual)
                            let ytd_mb = item.profit_loss.ytd_mb == '' ? 0 : Number(item.profit_loss.ytd_mb)
                            let ytd_last_year = item.profit_loss.ytd_last_year == '' ? 0 : Number(item.profit_loss.ytd_last_year)
                            let persenYtdMB = 0
                            if (ytd_mb < 0) {
                                if (ytd_actual >= ytd_mb) {
                                    persenYtdMB = (ytd_mb - ytd_actual) / ytd_mb + 1
                                } else {
                                    persenYtdMB = (ytd_mb - ytd_actual) / ytd_mb
                                }
                            }
                            else {
                                persenYtdMB = ytd_actual / ytd_mb
                            }

                            let persenYtdLY = 0
                            if (ytd_last_year < 0) {
                                if (ytd_actual >= ytd_last_year) {
                                    persenYtdLY = (ytd_last_year - ytd_actual) / ytd_last_year + 1
                                } else {
                                    persenYtdLY = (ytd_last_year - ytd_actual) / ytd_last_year
                                }
                            }
                            else {
                                persenYtdLY = ytd_actual / ytd_last_year
                            }

                            // let q1_actual = item.profit_loss.q1_actual == ''? 0 : Number(item.profit_loss.q1_actual)
                            // let q1_mb = item.profit_loss.q1_mb == ''? 0 : Number(item.profit_loss.q1_mb)
                            // let q1_last_year = item.profit_loss.q1_last_year == ''? 0 : Number(item.profit_loss.q1_last_year)
                            // let persenQuarterMB = 0
                            // if (q1_mb  < 0) {
                            //     if (q1_actual >= q1_mb) {
                            //         persenQuarterMB = (q1_mb - q1_actual) / q1_mb + 1  
                            //     }  else {
                            //         persenQuarterMB = (q1_mb - q1_actual) / q1_mb 
                            //     }
                            // }
                            // else {
                            //     persenQuarterMB = q1_actual / q1_mb 
                            // }

                            // let persenQuarterLY = 0
                            // if (q1_last_year  < 0) {
                            //     if (q1_actual >= q1_last_year) {
                            //         persenQuarterLY = (q1_last_year - q1_actual) / q1_last_year + 1  
                            //     }  else {
                            //         persenQuarterLY = (q1_last_year - q1_actual) / q1_last_year 
                            //     }
                            // }
                            // else {
                            //     persenQuarterLY = q1_actual / q1_last_year 
                            // }

                            let q_actual = month == "Mar" ? item.profit_loss.q1_actual == '' ? 0 : Number(item.profit_loss.q1_actual) : month == "Jun" ? item.profit_loss.q2_actual == '' ? 0 : Number(item.profit_loss.q2_actual) : month == "Sep" ? item.profit_loss.q3_actual == '' ? 0 : Number(item.profit_loss.q3_actual) : 0
                            let q_mb = month == "Mar" ? item.profit_loss.q1_mb == '' ? 0 : Number(item.profit_loss.q1_mb) : month == "Jun" ? item.profit_loss.q2_mb == '' ? 0 : Number(item.profit_loss.q2_mb) : month == "Sep" ? item.profit_loss.q3_mb == '' ? 0 : Number(item.profit_loss.q3_mb) : 0
                            let q_last_year = month == "Mar" ? item.profit_loss.q1_last_year == '' ? 0 : Number(item.profit_loss.q1_last_year) : month == "Jun" ? item.profit_loss.q2_last_year == '' ? 0 : Number(item.profit_loss.q2_last_year) : month == "Sep" ? item.profit_loss.q3_last_year == '' ? 0 : Number(item.profit_loss.q3_last_year) : 0
                            let persenQuarterMB = 0
                            if (q_mb < 0) {
                                if (q_actual >= q_mb) {
                                    persenQuarterMB = (q_mb - q_actual) / q_mb + 1
                                } else {
                                    persenQuarterMB = (q_mb - q_actual) / q_mb
                                }
                            }
                            else {
                                persenQuarterMB = q_actual / q_mb
                            }

                            let persenQuarterLY = 0
                            if (q_last_year < 0) {
                                if (q_actual >= q_last_year) {
                                    persenQuarterLY = (q_last_year - q_actual) / q_last_year + 1
                                } else {
                                    persenQuarterLY = (q_last_year - q_actual) / q_last_year
                                }
                            }
                            else {
                                persenQuarterLY = q_actual / q_last_year
                            }

                            let fy_actual = item.profit_loss.fy_actual == '' ? 0 : Number(item.profit_loss.fy_actual)
                            let fy_mb = item.profit_loss.fy_mb == '' ? 0 : Number(item.profit_loss.fy_mb)
                            let fy_ol = item.profit_loss.fy_ol == '' ? 0 : Number(item.profit_loss.fy_ol)
                            let fy_last_year = item.profit_loss.fy_last_year == '' ? 0 : Number(item.profit_loss.fy_last_year)
                            let persenFyMB = 0
                            if (fy_mb < 0) {
                                if (fy_actual >= fy_mb) {
                                    persenFyMB = (fy_mb - fy_actual) / fy_mb + 1
                                } else {
                                    persenFyMB = (fy_mb - fy_actual) / fy_mb
                                }
                            }
                            else {
                                persenFyMB = fy_actual / fy_mb
                            }

                            let persenFyOL = 0
                            if (fy_ol < 0) {
                                if (fy_actual >= fy_ol) {
                                    persenFyOL = (fy_ol - fy_actual) / fy_ol + 1
                                } else {
                                    persenFyOL = (fy_ol - fy_actual) / fy_ol
                                }
                            }
                            else {
                                persenFyOL = fy_actual / fy_ol
                            }

                            let persenFyLY = 0
                            if (fy_last_year < 0) {
                                if (fy_actual >= fy_last_year) {
                                    persenFyLY = (fy_last_year - fy_actual) / fy_last_year + 1
                                } else {
                                    persenFyLY = (fy_last_year - fy_actual) / fy_last_year
                                }
                            }
                            else {
                                persenFyLY = fy_actual / fy_last_year
                            }

                            // let persenFyOLMB = Number(fy_ol/fy_mb)
                            // if (fy_mb  < 0) {
                            //     if (fy_ol >= fy_mb) {
                            //         persenFyLY = (fy_mb - fy_ol) / fy_mb + 1  
                            //     }  else {
                            //         persenFyLY = (fy_mb - fy_ol) / fy_mb 
                            //     }
                            // }
                            // else {
                            //     persenFyLY = fy_ol / fy_mb 
                            // }

                            let persenFyOLMB = 0
                            if (fy_mb < 0) {
                                if (fy_ol >= fy_mb) {
                                    persenFyOLMB = (fy_mb - fy_ol) / fy_mb + 1
                                } else {
                                    persenFyOLMB = (fy_mb - fy_ol) / fy_mb
                                }
                            }
                            else {
                                persenFyOLMB = fy_ol / fy_mb
                            }

                            dbSumaPL.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_loss.mtd_actual,
                                item.profit_loss.mtd_mb,
                                isNaN(persenMtd) || persenMtd == 'Infinity' || persenMtd == '-Infinity' ? (item.profit_loss.mtd_mb == '' || item.profit_loss.mtd_mb == 0 ? -0 : 0) : (item.profit_loss.mtd_mb == '' || item.profit_loss.mtd_mb == 0 ? persenMtd * -100 : persenMtd * 100),
                                item.profit_loss.mtd_last_year,
                                isNaN(persenMtdLY) || persenMtdLY == 'Infinity' || persenMtdLY == '-Infinity' ? (item.profit_loss.mtd_last_year == '' || item.profit_loss.mtd_last_year == 0 ? -0 : 0) : (item.profit_loss.mtd_last_year == '' || item.profit_loss.mtd_last_year == 0 ? persenMtdLY * -100 : persenMtdLY * 100),
                                item.profit_loss.ytd_actual,
                                item.profit_loss.ytd_mb,
                                isNaN(persenYtdMB) || persenYtdMB == 'Infinity' || persenYtdMB == '-Infinity' ? (item.profit_loss.ytd_mb == '' || item.profit_loss.ytd_mb == 0 ? -0 : 0) : (item.profit_loss.ytd_mb == '' || item.profit_loss.ytd_mb == 0 ? persenYtdMB * -100 : persenYtdMB * 100),
                                item.profit_loss.ytd_last_year,
                                isNaN(persenYtdLY) || persenYtdLY == 'Infinity' || persenYtdLY == '-Infinity' ? (item.profit_loss.ytd_last_year == '' || item.profit_loss.ytd_last_year == 0 ? -0 : 0) : (item.profit_loss.ytd_last_year == '' || item.profit_loss.ytd_last_year == 0 ? persenYtdLY * -100 : persenYtdLY * 100),
                                month == "Mar" ? item.profit_loss.q1_actual :
                                    month == "Jun" ? item.profit_loss.q2_actual :
                                        month == "Sep" ? item.profit_loss.q3_actual :
                                            month == "Dec" ? item.profit_loss.q4_actual : 0,
                                month == "Mar" ? item.profit_loss.q1_mb :
                                    month == "Jun" ? item.profit_loss.q2_mb :
                                        month == "Sep" ? item.profit_loss.q3_mb :
                                            month == "Dec" ? item.profit_loss.q4_mb : 0,
                                isNaN(persenQuarterMB) || persenQuarterMB == 'Infinity' || persenQuarterMB == '-Infinity' ? (q_mb == '' || q_mb == 0 ? -0 : 0) : (q_mb == '' || q_mb == 0 ? persenQuarterMB * -100 : persenQuarterMB * 100),
                                month == "Mar" ? item.profit_loss.q1_last_year :
                                    month == "Jun" ? item.profit_loss.q2_last_year :
                                        month == "Sep" ? item.profit_loss.q3_last_year :
                                            month == "Dec" ? item.profit_loss.q4_last_year : 0,
                                isNaN(persenQuarterLY) || persenQuarterLY == 'Infinity' || persenQuarterLY == '-Infinity' ? (q_last_year == '' || q_last_year == 0 ? -0 : 0) : (q_last_year == '' || q_last_year == 0 ? persenQuarterLY * -100 : persenQuarterLY * 100),
                                item.profit_loss.fy_actual,
                                item.profit_loss.fy_mb,
                                isNaN(persenFyMB) || persenFyMB == 'Infinity' || persenFyMB == '-Infinity' ? (item.profit_loss.fy_mb == '' || item.profit_loss.fy_mb == 0 ? -0 : 0) : (item.profit_loss.fy_mb == '' || item.profit_loss.fy_mb == 0 ? persenFyMB * -100 : persenFyMB * 100),
                                item.profit_loss.fy_ol,
                                isNaN(persenFyOL) || persenFyOL == 'Infinity' || persenFyOL == '-Infinity' ? (item.profit_loss.fy_ol == '' || item.profit_loss.fy_ol == 0 ? -0 : 0) : (item.profit_loss.fy_ol == '' || item.profit_loss.fy_ol == 0 ? persenFyOL * -100 : persenFyOL * 100),
                                item.profit_loss.fy_last_year,
                                isNaN(persenFyLY) || persenFyLY == 'Infinity' || persenFyLY == '-Infinity' ? (item.profit_loss.fy_last_year == '' || item.profit_loss.fy_last_year == 0 ? -0 : 0) : (item.profit_loss.fy_last_year == '' || item.profit_loss.fy_last_year == 0 ? persenFyLY * -100 : persenFyLY * 100),
                                isNaN(persenFyOLMB) || persenFyOLMB == 'Infinity' || persenFyOLMB == '-Infinity' ? (item.profit_loss.fy_percent_ach_ol_to_mb == '' || item.profit_loss.fy_percent_ach_ol_to_mb == 0 ? -0 : 0) : (item.profit_loss.fy_percent_ach_ol_to_mb == '' || item.profit_loss.fy_percent_ach_ol_to_mb == 0 ? persenFyOLMB * -100 : persenFyOLMB * 100),
                                item.profit_loss.forecast_next_year,
                                item.profit_loss.forecast_more_year,
                                item.profit_loss.notes,
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dbSumaPL);
                        this.setState({ dataTable: dbSumaPL, loading: false, previewTable: true, previewDownload: true })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                }

            })
        } else if (this.state.report.value === 9) {
            let FRID = null
            let payloadFRID = {
                "periode": this.state.periode.periode,
                "company_id": this.state.company.company_id
            }
            api.create().getFRID(payloadFRID).then(response => {
                console.log(response);
                if (response) {
                    FRID = response.data.data == null ? null : response.data.data.ratio_id
                } else {
                    FRID = null
                }
                this.setState({ FRID }, () => {
                    let paylodFR = { ...payload, report_id: 29, submission_id: this.state.FRID, months: this.state.month.month_id, quarter: 0 }
                    api.create().getReportFRSuma(paylodFR).then(response => {
                        console.log(paylodFR);
                        console.log(response);
                        // console.log(JSON.stringify(response));
                        let dataTable = []
                        if (response.data) {
                            if (response.data.status === 'success') {
                                let res = response.data.data
                                const handlePushChild = (item) => {
                                    let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                                    if (indexIDzz === -1) {
                                        let mtd_actual = item.ratio.mtd_actual == '' ? 0 : Number(item.ratio.mtd_actual)
                                        let mtd_mb = item.ratio.mtd_mb == '' ? 0 : Number(item.ratio.mtd_mb)
                                        let mtdPersenMB = 0
                                        if (mtd_mb < 0) {
                                            if (mtd_actual >= mtd_mb) {
                                                mtdPersenMB = ((mtd_mb - mtd_actual) / mtd_mb + 1)
                                            } else {
                                                mtdPersenMB = ((mtd_mb - mtd_actual) / mtd_mb)
                                            }
                                        }
                                        else {
                                            mtdPersenMB = Number(mtd_actual / mtd_mb)
                                        }

                                        let fy_actual = item.ratio.fy_actual == '' ? 0 : Number(item.ratio.fy_actual)
                                        let fy_mb = item.ratio.fy_mb == '' ? 0 : Number(item.ratio.fy_mb)
                                        let fyPersenMB = 0
                                        if (fy_mb < 0) {
                                            if (fy_actual >= fy_mb) {
                                                fyPersenMB = ((fy_mb - fy_actual) / fy_mb + 1)
                                            } else {
                                                fyPersenMB = ((fy_mb - fy_actual) / fy_mb)
                                            }
                                        }
                                        else {
                                            fyPersenMB = Number(fy_actual / fy_mb)
                                        }

                                        // let fy_actual = item.ratio.fy_actual == '' ? 0 : Number(item.ratio.fy_actual)
                                        let fy_ol = item.ratio.fy_ol == '' ? 0 : Number(item.ratio.fy_ol)
                                        let fyPersenOL = 0
                                        if (fy_ol < 0) {
                                            if (fy_actual >= fy_ol) {
                                                fyPersenOL = ((fy_ol - fy_actual) / fy_ol + 1)
                                            } else {
                                                fyPersenOL = ((fy_ol - fy_actual) / fy_ol)
                                            }
                                        }
                                        else {
                                            fyPersenOL = Number(fy_actual / fy_ol)
                                        }

                                        // let fy_actual = item.ratio.fy_actual == '' ? 0 : Number(item.ratio.fy_actual)
                                        let fy_last_year = item.ratio.fy_last_year == '' ? 0 : Number(item.ratio.fy_last_year)
                                        let fyPersenLY = 0
                                        if (fy_last_year < 0) {
                                            if (fy_actual >= fy_last_year) {
                                                fyPersenLY = ((fy_last_year - fy_actual) / fy_last_year + 1)
                                            } else {
                                                fyPersenLY = ((fy_last_year - fy_actual) / fy_last_year)
                                            }
                                        }
                                        else {
                                            fyPersenLY = Number(fy_actual / fy_last_year)
                                        }

                                        dataTable.push([
                                            item.type_report_id,
                                            item.id,
                                            item.parent,
                                            item.formula,
                                            item.level,
                                            item.description,
                                            item.uom,
                                            item.ratio.mtd_actual,
                                            item.ratio.mtd_mb,
                                            isNaN(mtdPersenMB) || mtdPersenMB == 'Infinity' || mtdPersenMB == '-Infinity' ? (item.ratio.mtd_mb == '' || item.ratio.mtd_mb == 0 ? -0 : 0) : (item.ratio.mtd_mb == '' || item.ratio.mtd_mb == 0 ? mtdPersenMB * -100 : mtdPersenMB * 100),
                                            item.ratio.mtd_last_year,
                                            item.ratio.fy_actual,
                                            item.ratio.fy_mb,
                                            isNaN(fyPersenMB) || fyPersenMB == 'Infinity' || fyPersenMB == '-Infinity' ? (item.ratio.fy_mb == '' || item.ratio.fy_mb == 0 ? -0 : 0) : (item.ratio.fy_mb == '' || item.ratio.fy_mb == 0 ? fyPersenMB * -100 : fyPersenMB * 100),
                                            item.ratio.fy_ol,
                                            isNaN(fyPersenOL) || fyPersenOL == 'Infinity' || fyPersenOL == '-Infinity' ? (item.ratio.fy_ol == '' || item.ratio.fy_ol == 0 ? -0 : 0) : (item.ratio.fy_ol == '' || item.ratio.fy_ol == 0 ? fyPersenOL * -100 : fyPersenOL * 100),
                                            item.ratio.fy_last_year,
                                            isNaN(fyPersenLY) || fyPersenLY == 'Infinity' || fyPersenLY == '-Infinity' ? (item.ratio.fy_last_year == '' || item.ratio.fy_last_year == 0 ? -0 : 0) : (item.ratio.fy_last_year == '' || item.ratio.fy_last_year == 0 ? fyPersenLY * -100 : fyPersenLY * 100),
                                            item.ratio.forecast_next_year,
                                            item.ratio.forecast_more_year
                                        ])
                                    }
                                    if (item.children !== null) {
                                        if (item.children.length > 0) {
                                            item.children.map((items, indexs) => {
                                                handlePushChild(items)
                                            })
                                        }
                                    }
                                }
                                res.map((item, index) => {
                                    let mtd_actual = item.ratio.mtd_actual == '' ? 0 : Number(item.ratio.mtd_actual)
                                    let mtd_mb = item.ratio.mtd_mb == '' ? 0 : Number(item.ratio.mtd_mb)
                                    let mtdPersenMB = 0
                                    if (mtd_mb < 0) {
                                        if (mtd_actual >= mtd_mb) {
                                            mtdPersenMB = ((mtd_mb - mtd_actual) / mtd_mb + 1)
                                        } else {
                                            mtdPersenMB = ((mtd_mb - mtd_actual) / mtd_mb)
                                        }
                                    }
                                    else {
                                        mtdPersenMB = Number(mtd_actual / mtd_mb)
                                    }

                                    let fy_actual = item.ratio.fy_actual == '' ? 0 : Number(item.ratio.fy_actual)
                                    let fy_mb = item.ratio.fy_mb == '' ? 0 : Number(item.ratio.fy_mb)
                                    let fyPersenMB = 0
                                    if (fy_mb < 0) {
                                        if (fy_actual >= fy_mb) {
                                            fyPersenMB = ((fy_mb - fy_actual) / fy_mb + 1)
                                        } else {
                                            fyPersenMB = ((fy_mb - fy_actual) / fy_mb)
                                        }
                                    }
                                    else {
                                        fyPersenMB = Number(fy_actual / fy_mb)
                                    }

                                    // let fy_actual = item.ratio.fy_actual == '' ? 0 : Number(item.ratio.fy_actual)
                                    let fy_ol = item.ratio.fy_ol == '' ? 0 : Number(item.ratio.fy_ol)
                                    let fyPersenOL = 0
                                    if (fy_ol < 0) {
                                        if (fy_actual >= fy_ol) {
                                            fyPersenOL = ((fy_ol - fy_actual) / fy_ol + 1)
                                        } else {
                                            fyPersenOL = ((fy_ol - fy_actual) / fy_ol)
                                        }
                                    }
                                    else {
                                        fyPersenOL = Number(fy_actual / fy_ol)
                                    }

                                    // let fy_actual = item.ratio.fy_actual == '' ? 0 : Number(item.ratio.fy_actual)
                                    let fy_last_year = item.ratio.fy_last_year == '' ? 0 : Number(item.ratio.fy_last_year)
                                    let fyPersenLY = 0
                                    if (fy_last_year < 0) {
                                        if (fy_actual >= fy_last_year) {
                                            fyPersenLY = ((fy_last_year - fy_actual) / fy_last_year + 1)
                                        } else {
                                            fyPersenLY = ((fy_last_year - fy_actual) / fy_last_year)
                                        }
                                    }
                                    else {
                                        fyPersenLY = Number(fy_actual / fy_last_year)
                                    }

                                    dataTable.push([
                                        item.type_report_id,
                                        item.id,
                                        item.parent,
                                        item.formula,
                                        item.level,
                                        item.description,
                                        item.uom,
                                        item.ratio.mtd_actual,
                                        item.ratio.mtd_mb,
                                        isNaN(mtdPersenMB) || mtdPersenMB == 'Infinity' || mtdPersenMB == '-Infinity' ? (item.ratio.mtd_mb == '' || item.ratio.mtd_mb == 0 ? -0 : 0) : (item.ratio.mtd_mb == '' || item.ratio.mtd_mb == 0 ? mtdPersenMB * -100 : mtdPersenMB * 100),
                                        item.ratio.mtd_last_year,
                                        item.ratio.fy_actual,
                                        item.ratio.fy_mb,
                                        isNaN(fyPersenMB) || fyPersenMB == 'Infinity' || fyPersenMB == '-Infinity' ? (item.ratio.fy_mb == '' || item.ratio.fy_mb == 0 ? -0 : 0) : (item.ratio.fy_mb == '' || item.ratio.fy_mb == 0 ? fyPersenMB * -100 : fyPersenMB * 100),
                                        item.ratio.fy_ol,
                                        isNaN(fyPersenOL) || fyPersenOL == 'Infinity' || fyPersenOL == '-Infinity' ? (item.ratio.fy_ol == '' || item.ratio.fy_ol == 0 ? -0 : 0) : (item.ratio.fy_ol == '' || item.ratio.fy_ol == 0 ? fyPersenOL * -100 : fyPersenOL * 100),
                                        item.ratio.fy_last_year,
                                        isNaN(fyPersenLY) || fyPersenLY == 'Infinity' || fyPersenLY == '-Infinity' ? (item.ratio.fy_last_year == '' || item.ratio.fy_last_year == 0 ? -0 : 0) : (item.ratio.fy_last_year == '' || item.ratio.fy_last_year == 0 ? fyPersenLY * -100 : fyPersenLY * 100),
                                        item.ratio.forecast_next_year,
                                        item.ratio.forecast_more_year
                                    ])
                                    if (item.children !== null) {
                                        if (item.children.length > 0) {
                                            item.children.map((items, indexs) => {
                                                handlePushChild(items)
                                            })
                                        }
                                    }
                                })
                                this.setState({ dataTable, previewTable: true, loading: false, previewDownload: true })
                                console.log(this.state.dataTable)
                                // this.setState({ dataTable }, () => {
                                //     console.log(this.state.dataTable)
                                //     this.getRatioMR(payload)
                                // })
                            } else {
                                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                                    if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                        setTimeout(() => {
                                            localStorage.removeItem(Constant.TOKEN)
                                            window.location.reload();
                                        }, 1000);
                                    }
                                })
                            }
                        } else {
                            this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                        }
                        // this.setState({ previewTable: true, loading: false, previewDownload: true })
                    })
                })
            })
        } else if (this.state.report.value === 11) {
            let dbCATPQ = [];
            let payloadCATPQ = { ...payload, report_id: 10, quarter: this.state.quarter.name }
            api.create().getReportCATPQ(payloadCATPQ).then(response => {
                console.log(payloadCATPQ);
                console.log(response);
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dbCATPQ.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                let parentTrue = item.parent_name == 'INTERNAL BUSINESS PROCESS PERSPECTIVE' || item.parent_name == 'CUSTOMER PERSPECTIVE'
                                let weight = String(item.corporate_annual_target.weight).substr(0, String(item.corporate_annual_target.weight).length - 1)
                                let percentVar = Number(item.corporate_annual_target.thisYearOlFy) / Number(item.corporate_annual_target.thisYearBudgetFy)
                                percentVar = String(percentVar) == 'NaN' || String(percentVar) == 'Infinity' || String(percentVar) == '-Infinity' ? 0 : percentVar
                                dbCATPQ.push([
                                    item.typeItemReportId,
                                    item.itemReportId,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.itemName,
                                    item.corporate_annual_target.weight == "" ? Number(0).toFixed(1) : Number(weight).toFixed(1),
                                    parentTrue ? item.corporate_annual_target.uom : item.uom,
                                    parentTrue ? item.corporate_annual_target.kpiType : item.typeKpi,
                                    parentTrue ? titleCase(item.corporate_annual_target.maxAch) : titleCase(item.maxAch),
                                    parentTrue ? item.corporate_annual_target.formulaYtd : item.formulaYtd,

                                    item.corporate_annual_target.lastYearActualQx,
                                    item.corporate_annual_target.lastYearActualFy,

                                    item.corporate_annual_target.thisYearbudgetQx,
                                    item.corporate_annual_target.thisYearActualQx,
                                    item.corporate_annual_target.thisYearPercentAch,
                                    item.corporate_annual_target.thisYearPercentGrowthYoy,
                                    item.corporate_annual_target.thisYearScore === null ? "0" : item.corporate_annual_target.thisYearScore,
                                    item.corporate_annual_target.thisYearScoreXWeight,

                                    item.corporate_annual_target.thisYearBudgetYtd,
                                    item.corporate_annual_target.thisYearActualYtd,
                                    item.corporate_annual_target.thisYearPercentAchYtd,

                                    item.corporate_annual_target.thisYearBudgetFy,
                                    item.corporate_annual_target.thisYearOlFy,
                                    item.corporate_annual_target.thisYearPercentAchFy,
                                    item.corporate_annual_target.thisYearScoreFy === null ? "0" : item.corporate_annual_target.thisYearScoreFy,
                                    item.corporate_annual_target.thisYearScoreXWeightFy,

                                    item.orders
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dbCATPQ.push([
                                item.typeItemReportId,
                                item.itemReportId,
                                item.parent,
                                item.formula,
                                item.level,
                                item.itemName,
                                item.weight == '' ? Number(0).toFixed(1) : Number(Number(item.weight) * 100).toFixed(1),
                                item.uom,
                                item.typeKpi,
                                item.maxAch,
                                item.formulaYtd,

                                item.corporate_annual_target.lastYearActualQx,
                                item.corporate_annual_target.lastYearActualFy,

                                item.corporate_annual_target.thisYearbudgetQx,
                                item.corporate_annual_target.thisYearActualQx,
                                item.corporate_annual_target.thisYearPercentAch,
                                item.corporate_annual_target.thisYearPercentGrowthYoy,
                                item.corporate_annual_target.thisYearScore,
                                item.corporate_annual_target.thisYearScoreXWeight,

                                item.corporate_annual_target.thisYearBudgetYtd,
                                item.corporate_annual_target.thisYearActualYtd,
                                item.corporate_annual_target.thisYearPercentAchYtd,

                                item.corporate_annual_target.thisYearBudgetFy,
                                item.corporate_annual_target.thisYearOlFy,
                                item.corporate_annual_target.thisYearPercentAchFy,
                                item.corporate_annual_target.thisYearScoreFy,
                                item.corporate_annual_target.thisYearScoreXWeightFy,

                                item.orders
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        this.setState({ dataTable: dbCATPQ, previewTable: true, loading: false, previewDownload: true })
                        console.log(this.state.dataTable)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                }
            })
        } else if (this.state.report.value === 10) {
            let dbCATPA = []
            let payloadCATPA = { ...payload, months: this.state.month.month_id, get_for: "view" }
            api.create().getReportCATPA(payloadCATPA).then(response => {
                console.log(payloadCATPA);
                console.log(response);
                if (response.data) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dbCATPA.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                let parentTrue = item.parent_name == 'INTERNAL BUSINESS PROCESS PERSPECTIVE' || item.parent_name == 'CUSTOMER PERSPECTIVE'
                                let weight = String(item.corporate_annual_target.weight).substr(0, String(item.corporate_annual_target.weight).length - 1)

                                dbCATPA.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.corporate_annual_target.weight == "" ? Number(0).toFixed(1) : Number(weight).toFixed(1),
                                    parentTrue ? item.corporate_annual_target.uom : item.uom,
                                    parentTrue ? item.corporate_annual_target.jenis_kpi == "" ? null : item.corporate_annual_target.jenis_kpi : item.jenis_kpi == "" ? null : item.kpi_type,
                                    parentTrue ? item.corporate_annual_target.max_ach == "" ? null : titleCase(item.corporate_annual_target.max_ach) : item.max_ach == "" ? null : titleCase(item.max_ach),
                                    item.corporate_annual_target.formula_ytd == "" ? null : item.corporate_annual_target.formula_ytd,
                                    item.corporate_annual_target.actual_ytd,
                                    item.corporate_annual_target.target_ytd,
                                    item.corporate_annual_target.achivement_ytd,
                                    item.corporate_annual_target.score,
                                    item.corporate_annual_target.score_x_weight,
                                    item.order
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dbCATPA.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.weight == '' ? Number(0).toFixed(1) : Number(Number(item.weight) * 100).toFixed(1),
                                item.uom,
                                item.kpi_type,
                                item.max_ach,
                                item.formula_ytd,
                                item.corporate_annual_target.actual_ytd,
                                item.corporate_annual_target.target_ytd,
                                item.corporate_annual_target.achivement_ytd,
                                item.corporate_annual_target.score,
                                item.corporate_annual_target.score_x_weight,
                                item.order
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        this.setState({ dataTable: dbCATPA, previewTable: true, loading: false, previewDownload: true })
                        console.log(this.state.dataTable)
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
                }
            })
        }

    }

    getCFSumaMR(payload, dbSumaCF) {
        let payloadLast = { ...payload, "periode": Number(this.state.periode.periode) - 1 }
        // let payloadLast = {
        //     "report_id": this.state.report.value,
        //     "revision": this.state.revisionType,
        //     "periode": Number(this.state.periode.periode) -1,
        //     "months" : this.state.
        //     "company_id": this.state.company.company_id,
        //     "submission_id": this.state.submissionID
        // }
        api.create().getReportCFSumaMR(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable = this.state.dataTable
            let dataTable2 = []
            if (response.data) {
                let res = response.data.data
                res.map((item, index) => {
                    let indexID = dataTable.findIndex((val) => val[1] == item.id)
                    if (indexID != -1) {
                        const handlePushChild = (items) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === items.id)
                            // console.log(indexIDzz)
                            if (indexIDzz != -1) {
                                dataTable2.push([...dataTable[indexIDzz],
                                items.cash_flow.january,
                                items.cash_flow.february,
                                items.cash_flow.march,
                                items.cash_flow.april,
                                items.cash_flow.may,
                                items.cash_flow.june,
                                items.cash_flow.july,
                                items.cash_flow.august,
                                items.cash_flow.september,
                                items.cash_flow.october,
                                items.cash_flow.november,
                                items.cash_flow.december,
                                items.cash_flow.total_current_year,
                                items.cash_flow.q1_january,
                                items.cash_flow.q1_february,
                                items.cash_flow.q1_march,
                                items.cash_flow.q1_april,
                                items.cash_flow.q1_may,
                                items.cash_flow.q1_june,
                                items.cash_flow.q1_july,
                                items.cash_flow.q1_august,
                                items.cash_flow.q1_september,
                                items.cash_flow.q1_october,
                                items.cash_flow.q1_november,
                                items.cash_flow.q1_december,
                                items.cash_flow.q1_total_current_year,
                                items.cash_flow.q2_january,
                                items.cash_flow.q2_february,
                                items.cash_flow.q2_march,
                                items.cash_flow.q2_april,
                                items.cash_flow.q2_may,
                                items.cash_flow.q2_june,
                                items.cash_flow.q2_july,
                                items.cash_flow.q2_august,
                                items.cash_flow.q2_september,
                                items.cash_flow.q2_october,
                                items.cash_flow.q2_november,
                                items.cash_flow.q2_december,
                                items.cash_flow.q2_total_current_year,
                                items.cash_flow.q3_january,
                                items.cash_flow.q3_february,
                                items.cash_flow.q3_march,
                                items.cash_flow.q3_april,
                                items.cash_flow.q3_may,
                                items.cash_flow.q3_june,
                                items.cash_flow.q3_july,
                                items.cash_flow.q3_august,
                                items.cash_flow.q3_september,
                                items.cash_flow.q3_october,
                                items.cash_flow.q3_november,
                                items.cash_flow.q3_december,
                                items.cash_flow.q3_total_current_year,
                                items.cash_flow.history_current_year,
                                items.cash_flow.history_last_year,
                                items.cash_flow.history_last_two_year,
                                items.cash_flow.history_last_three_year,
                                items.cash_flow.history_last_four_year,
                                items.cash_flow.history_last_five_year,
                                items.cash_flow.history_last_six_year,
                                items.cash_flow.history_last_seven_year,
                                items.cash_flow.history_last_eight_year,
                                items.cash_flow.history_last_nine_year,
                                ])
                            }
                            if (items.children !== null) {
                                if (items.children.length > 0) {
                                    items.children.map((itemss, indexss) => {
                                        handlePushChild(itemss)
                                    })
                                }
                            }
                        }

                        dataTable2.push([...dataTable[indexID],
                        item.cash_flow.january,
                        item.cash_flow.february,
                        item.cash_flow.march,
                        item.cash_flow.april,
                        item.cash_flow.may,
                        item.cash_flow.june,
                        item.cash_flow.july,
                        item.cash_flow.august,
                        item.cash_flow.september,
                        item.cash_flow.october,
                        item.cash_flow.november,
                        item.cash_flow.december,
                        item.cash_flow.total_current_year,
                        item.cash_flow.q1_january,
                        item.cash_flow.q1_february,
                        item.cash_flow.q1_march,
                        item.cash_flow.q1_april,
                        item.cash_flow.q1_may,
                        item.cash_flow.q1_june,
                        item.cash_flow.q1_july,
                        item.cash_flow.q1_august,
                        item.cash_flow.q1_september,
                        item.cash_flow.q1_october,
                        item.cash_flow.q1_november,
                        item.cash_flow.q1_december,
                        item.cash_flow.q1_total_current_year,
                        item.cash_flow.q2_january,
                        item.cash_flow.q2_february,
                        item.cash_flow.q2_march,
                        item.cash_flow.q2_april,
                        item.cash_flow.q2_may,
                        item.cash_flow.q2_june,
                        item.cash_flow.q2_july,
                        item.cash_flow.q2_august,
                        item.cash_flow.q2_september,
                        item.cash_flow.q2_october,
                        item.cash_flow.q2_november,
                        item.cash_flow.q2_december,
                        item.cash_flow.q2_total_current_year,
                        item.cash_flow.q3_january,
                        item.cash_flow.q3_february,
                        item.cash_flow.q3_march,
                        item.cash_flow.q3_april,
                        item.cash_flow.q3_may,
                        item.cash_flow.q3_june,
                        item.cash_flow.q3_july,
                        item.cash_flow.q3_august,
                        item.cash_flow.q3_september,
                        item.cash_flow.q3_october,
                        item.cash_flow.q3_november,
                        item.cash_flow.q3_december,
                        item.cash_flow.q3_total_current_year,
                        item.cash_flow.history_current_year,
                        item.cash_flow.history_last_year,
                        item.cash_flow.history_last_two_year,
                        item.cash_flow.history_last_three_year,
                        item.cash_flow.history_last_four_year,
                        item.cash_flow.history_last_five_year,
                        item.cash_flow.history_last_six_year,
                        item.cash_flow.history_last_seven_year,
                        item.cash_flow.history_last_eight_year,
                        item.cash_flow.history_last_nine_year,
                        ])

                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }

                    }

                })
                this.setState({ dataTable2 }, () => {
                    // console.log(this.state.dataTable2)
                    this.getCFSumaLastMR(payloadLast, dbSumaCF)
                })
                console.log(dataTable2)
                // this.setState({ dataTable: dataTable2, previewTable: true, loading: false, previewDownload: false })
            } else {
                this.setState({ dataTable: [], previewTable: false, loading: false, previewDownload: false })
            }
        })
    }

    getCFSumaLastMR(payload, dbSumaCF) {
        console.log(dbSumaCF)
        console.log(this.state.dbSumaCF)
        api.create().getReportCFSumaMR(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable2 = this.state.dataTable2
            let dataTable3 = []
            if (response.data) {
                let res = response.data.data
                res.map((item, index) => {
                    let indexID = dataTable2.findIndex((val) => val[1] == item.id)
                    let indexIDSuma = dbSumaCF.findIndex((val) => val[0] == item.id)
                    if (indexID != -1) {
                        const handlePushChild = (items) => {
                            let indexIDzz = dataTable2.findIndex((val) => val[1] === items.id)
                            let indexIDSumaChild = dbSumaCF.findIndex((val) => val[0] == items.id)
                            if (indexIDzz != -1) {
                                dataTable3.push([...dataTable2[indexIDzz],
                                items.cash_flow.january,
                                items.cash_flow.february,
                                items.cash_flow.march,
                                items.cash_flow.april,
                                items.cash_flow.may,
                                items.cash_flow.june,
                                items.cash_flow.july,
                                items.cash_flow.august,
                                items.cash_flow.september,
                                items.cash_flow.october,
                                items.cash_flow.november,
                                items.cash_flow.december,
                                items.cash_flow.total_current_year
                                ])
                            }
                            if (items.children !== null) {
                                if (items.children.length > 0) {
                                    items.children.map((itemss, indexss) => {
                                        handlePushChild(itemss)
                                    })
                                }
                            }
                        }

                        dataTable3.push([...dataTable2[indexID],
                        item.cash_flow.january,
                        item.cash_flow.february,
                        item.cash_flow.march,
                        item.cash_flow.april,
                        item.cash_flow.may,
                        item.cash_flow.june,
                        item.cash_flow.july,
                        item.cash_flow.august,
                        item.cash_flow.september,
                        item.cash_flow.october,
                        item.cash_flow.november,
                        item.cash_flow.december,
                        item.cash_flow.total_current_year
                        ])

                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }

                    }

                })

                console.log(dataTable3);

                this.setState({ dataTable: dataTable3, previewTable: true, loading: false, previewDownload: true })
            } else {
                this.setState({ dataTable: [], previewTable: false, loading: false, previewDownload: false })
            }
        })
    }

    getReportPLMR(payload) {
        let payloadLast = {
            "report_id": this.state.report.value,
            "revision": this.state.revisionType,
            "periode": Number(this.state.periode.periode) - 1,
            "company_id": this.state.company.company_id,
            "submission_id": this.state.submissionID
        }
        api.create().getReportPLMR(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable = this.state.dataTable
            let dataTable2 = []
            if (response.data) {
                let res = response.data.data
                res.map((item, index) => {
                    let indexID = dataTable.findIndex((val) => val[1] == item.id)
                    if (indexID != -1) {
                        const handlePushChild = (items) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === items.id)
                            // console.log(indexIDzz)
                            if (indexIDzz != -1) {
                                dataTable2.push([...dataTable[indexIDzz],
                                items.formula,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.january, formula: items.profit_detail.january_formula } : items.profit_detail.january,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.february, formula: items.profit_detail.february_formula } : items.profit_detail.february,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.march, formula: items.profit_detail.march_formula } : items.profit_detail.march,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.april, formula: items.profit_detail.april_formula } : items.profit_detail.april,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.may, formula: items.profit_detail.may_formula } : items.profit_detail.may,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.june, formula: items.profit_detail.june_formula } : items.profit_detail.june,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.july, formula: items.profit_detail.july_formula } : items.profit_detail.july,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.august, formula: items.profit_detail.august_formula } : items.profit_detail.august,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.september, formula: items.profit_detail.september_formula } : items.profit_detail.september,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.october, formula: items.profit_detail.october_formula } : items.profit_detail.october,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.november, formula: items.profit_detail.november_formula } : items.profit_detail.november,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.december, formula: items.profit_detail.december_formula } : items.profit_detail.december,
                                ])
                            }
                            if (items.children !== null) {
                                if (items.children.length > 0) {
                                    items.children.map((itemss, indexss) => {
                                        handlePushChild(itemss)
                                    })
                                }
                            }
                        }

                        dataTable2.push([...dataTable[indexID],
                        item.formula,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.january, formula: item.profit_detail.january_formula } : item.profit_detail.january,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.february, formula: item.profit_detail.february_formula } : item.profit_detail.february,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.march, formula: item.profit_detail.march_formula } : item.profit_detail.march,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.april, formula: item.profit_detail.april_formula } : item.profit_detail.april,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.may, formula: item.profit_detail.may_formula } : item.profit_detail.may,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.june, formula: item.profit_detail.june_formula } : item.profit_detail.june,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.july, formula: item.profit_detail.july_formula } : item.profit_detail.july,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.august, formula: item.profit_detail.august_formula } : item.profit_detail.august,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.september, formula: item.profit_detail.september_formula } : item.profit_detail.september,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.october, formula: item.profit_detail.october_formula } : item.profit_detail.october,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.november, formula: item.profit_detail.november_formula } : item.profit_detail.november,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.december, formula: item.profit_detail.december_formula } : item.profit_detail.december,
                        ])

                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }

                    }

                })
                console.log(dataTable2)
                // this.setState({ dataTable: dataTable2, previewTable: true, loading: false, previewDownload: true })
                this.setState({ dataTable2 }, () => {
                    // console.log(this.state.dataTable2)
                    this.getProfitLossLastMR(payloadLast)
                })
            } else {
                this.setState({ dataTable: [], previewTable: false, loading: false, previewDownload: false })
            }
        })
    }

    getProfitLossLastMR(payload) {
        api.create().getReportPLMR(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable2 = this.state.dataTable2
            let dataTable3 = []
            if (response.data) {
                let res = response.data.data
                res.map((item, index) => {
                    let indexID = dataTable2.findIndex((val) => val[1] == item.id)
                    if (indexID != -1) {
                        const handlePushChild = (items) => {
                            let indexIDzz = dataTable2.findIndex((val) => val[1] === items.id)
                            // console.log(indexIDzz)
                            if (indexIDzz != -1) {
                                dataTable3.push([...dataTable2[indexIDzz],
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.january, formula: items.profit_detail.january_formula } : items.profit_detail.january,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.february, formula: items.profit_detail.february_formula } : items.profit_detail.february,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.march, formula: items.profit_detail.march_formula } : items.profit_detail.march,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.april, formula: items.profit_detail.april_formula } : items.profit_detail.april,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.may, formula: items.profit_detail.may_formula } : items.profit_detail.may,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.june, formula: items.profit_detail.june_formula } : items.profit_detail.june,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.july, formula: items.profit_detail.july_formula } : items.profit_detail.july,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.august, formula: items.profit_detail.august_formula } : items.profit_detail.august,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.september, formula: items.profit_detail.september_formula } : items.profit_detail.september,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.october, formula: items.profit_detail.october_formula } : items.profit_detail.october,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.november, formula: items.profit_detail.november_formula } : items.profit_detail.november,
                                items.type_report_id == 5 || items.type_report_id == 6 || items.type_report_id == 7 ? { value: items.profit_detail.december, formula: items.profit_detail.december_formula } : items.profit_detail.december,
                                ])
                            }
                            if (items.children !== null) {
                                if (items.children.length > 0) {
                                    items.children.map((itemss, indexss) => {
                                        handlePushChild(itemss)
                                    })
                                }
                            }
                        }

                        dataTable3.push([...dataTable2[indexID],
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.january, formula: item.profit_detail.january_formula } : item.profit_detail.january,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.february, formula: item.profit_detail.february_formula } : item.profit_detail.february,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.march, formula: item.profit_detail.march_formula } : item.profit_detail.march,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.april, formula: item.profit_detail.april_formula } : item.profit_detail.april,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.may, formula: item.profit_detail.may_formula } : item.profit_detail.may,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.june, formula: item.profit_detail.june_formula } : item.profit_detail.june,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.july, formula: item.profit_detail.july_formula } : item.profit_detail.july,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.august, formula: item.profit_detail.august_formula } : item.profit_detail.august,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.september, formula: item.profit_detail.september_formula } : item.profit_detail.september,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.october, formula: item.profit_detail.october_formula } : item.profit_detail.october,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.november, formula: item.profit_detail.november_formula } : item.profit_detail.november,
                        item.type_report_id == 5 || item.type_report_id == 6 || item.type_report_id == 7 ? { value: item.profit_detail.december, formula: item.profit_detail.december_formula } : item.profit_detail.december,
                        ])

                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }

                    }

                })
                console.log(dataTable3)
                this.setState({ dataTable: dataTable3, previewTable: true, loading: false, previewDownload: true })
            } else {
                this.setState({ dataTable: [], previewTable: false, loading: false, previewDownload: false })
            }
        })
    }

    getRatioMR(payload) {
        let payloadLast = {
            "report_id": this.state.report.value,
            "revision": this.state.revisionType,
            "periode": Number(this.state.periode.periode) - 1,
            "company_id": this.state.company.company_id,
            "submission_id": this.state.submissionID
        }
        api.create().getReportHierarkiFRMR(payload).then(response => {
            // console.log(payload);
            console.log(response);
            let dataTable = this.state.dataTable
            let dataTable2 = []
            if (response.data) {
                if (response.data.status === 'success') {
                    let res = response.data.data
                    res.map((item, index) => {
                        let indexID = dataTable.findIndex((val) => val[1] == item.id)
                        if (indexID != -1) {
                            const handlePushChild = (items) => {
                                let indexIDzz = dataTable.findIndex((val) => val[1] === items.id)
                                // console.log(indexIDzz)
                                if (indexIDzz != -1) {
                                    dataTable2.push([...dataTable[indexIDzz],
                                    // String(items.ratio.monthly_january) == "" ? "" : Number(items.ratio.monthly_january).toFixed(2),
                                    // String(items.ratio.monthly_february) == "" ? "" : Number(items.ratio.monthly_february).toFixed(2),
                                    // String(items.ratio.monthly_march) == "" ? "" : Number(items.ratio.monthly_march).toFixed(2),
                                    // String(items.ratio.monthly_april) == "" ? "" : Number(items.ratio.monthly_april).toFixed(2),
                                    // String(items.ratio.monthly_may) == "" ? "" : Number(items.ratio.monthly_may).toFixed(2),
                                    // String(items.ratio.monthly_june) == "" ? "" : Number(items.ratio.monthly_june).toFixed(2),
                                    // String(items.ratio.monthly_july) == "" ? "" : Number(items.ratio.monthly_july).toFixed(2),
                                    // String(items.ratio.monthly_august) == "" ? "" : Number(items.ratio.monthly_august).toFixed(2),
                                    // String(items.ratio.monthly_september) == "" ? "" : Number(items.ratio.monthly_september).toFixed(2),
                                    // String(items.ratio.monthly_october) == "" ? "" : Number(items.ratio.monthly_october).toFixed(2),
                                    // String(items.ratio.monthly_november) == "" ? "" : Number(items.ratio.monthly_november).toFixed(2),
                                    // String(items.ratio.monthly_december) == "" ? "" : Number(items.ratio.monthly_december).toFixed(2),
                                    items.ratio.monthly_january,
                                    items.ratio.monthly_february,
                                    items.ratio.monthly_march,
                                    items.ratio.monthly_april,
                                    items.ratio.monthly_may,
                                    items.ratio.monthly_june,
                                    items.ratio.monthly_july,
                                    items.ratio.monthly_august,
                                    items.ratio.monthly_september,
                                    items.ratio.monthly_october,
                                    items.ratio.monthly_november,
                                    items.ratio.monthly_december
                                    ])
                                }
                                if (items.children !== null) {
                                    if (items.children.length > 0) {
                                        items.children.map((itemss, indexss) => {
                                            handlePushChild(itemss)
                                        })
                                    }
                                }
                            }

                            dataTable2.push([...dataTable[indexID],
                            // String(item.ratio.monthly_january) == "" ? "" : Number(item.ratio.monthly_january).toFixed(2),
                            // String(item.ratio.monthly_february) == "" ? "" : Number(item.ratio.monthly_february).toFixed(2),
                            // String(item.ratio.monthly_march) == "" ? "" : Number(item.ratio.monthly_march).toFixed(2),
                            // String(item.ratio.monthly_april) == "" ? "" : Number(item.ratio.monthly_april).toFixed(2),
                            // String(item.ratio.monthly_may) == "" ? "" : Number(item.ratio.monthly_may).toFixed(2),
                            // String(item.ratio.monthly_june) == "" ? "" : Number(item.ratio.monthly_june).toFixed(2),
                            // String(item.ratio.monthly_july) == "" ? "" : Number(item.ratio.monthly_july).toFixed(2),
                            // String(item.ratio.monthly_august) == "" ? "" : Number(item.ratio.monthly_august).toFixed(2),
                            // String(item.ratio.monthly_september) == "" ? "" : Number(item.ratio.monthly_september).toFixed(2),
                            // String(item.ratio.monthly_october) == "" ? "" : Number(item.ratio.monthly_october).toFixed(2),
                            // String(item.ratio.monthly_november) == "" ? "" : Number(item.ratio.monthly_november).toFixed(2),
                            // String(item.ratio.monthly_december) == "" ? "" : Number(item.ratio.monthly_december).toFixed(2),
                            item.ratio.monthly_january,
                            item.ratio.monthly_february,
                            item.ratio.monthly_march,
                            item.ratio.monthly_april,
                            item.ratio.monthly_may,
                            item.ratio.monthly_june,
                            item.ratio.monthly_july,
                            item.ratio.monthly_august,
                            item.ratio.monthly_september,
                            item.ratio.monthly_october,
                            item.ratio.monthly_november,
                            item.ratio.monthly_december
                            ])

                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }

                        }

                    })
                    console.log(dataTable2)
                    // this.setState({ dataTable: dataTable2, previewTable: true, loading: false, previewDownload: true })
                    this.setState({ dataTable2 }, () => {
                        console.log(this.state.dataTable2)
                        this.getRatioLastMR(payloadLast)
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getRatioLastMR(payloadLast) {
        api.create().getReportHierarkiFRMR(payloadLast).then(response => {
            console.log(payloadLast);
            console.log(response);
            let dataTable2 = this.state.dataTable2
            let dataTable3 = []
            if (response.data) {
                if (response.data.status === 'success') {
                    let res = response.data.data
                    res.map((item, index) => {
                        let indexID = dataTable2.findIndex((val) => val[1] == item.id)
                        if (indexID != -1) {
                            const handlePushChild = (items) => {
                                let indexIDzz = dataTable2.findIndex((val) => val[1] === items.id)
                                // console.log(indexIDzz)
                                if (indexIDzz != -1) {
                                    dataTable3.push([...dataTable2[indexIDzz],
                                    // Number(items.ratio.monthly_january).toFixed(2),
                                    // Number(items.ratio.monthly_february).toFixed(2),
                                    // Number(items.ratio.monthly_march).toFixed(2),
                                    // Number(items.ratio.monthly_april).toFixed(2),
                                    // Number(items.ratio.monthly_may).toFixed(2),
                                    // Number(items.ratio.monthly_june).toFixed(2),
                                    // Number(items.ratio.monthly_july).toFixed(2),
                                    // Number(items.ratio.monthly_august).toFixed(2),
                                    // Number(items.ratio.monthly_september).toFixed(2),
                                    // Number(items.ratio.monthly_october).toFixed(2),
                                    // Number(items.ratio.monthly_november).toFixed(2),
                                    // Number(items.ratio.monthly_december).toFixed(2),
                                    items.ratio.monthly_january_last_year,
                                    items.ratio.monthly_february_last_year,
                                    items.ratio.monthly_march_last_year,
                                    items.ratio.monthly_april_last_year,
                                    items.ratio.monthly_may_last_year,
                                    items.ratio.monthly_june_last_year,
                                    items.ratio.monthly_july_last_year,
                                    items.ratio.monthly_august_last_year,
                                    items.ratio.monthly_september_last_year,
                                    items.ratio.monthly_october_last_year,
                                    items.ratio.monthly_november_last_year,
                                    items.ratio.monthly_december_last_year,
                                    ])
                                }
                                if (items.children !== null) {
                                    if (items.children.length > 0) {
                                        items.children.map((itemss, indexss) => {
                                            handlePushChild(itemss)
                                        })
                                    }
                                }
                            }

                            dataTable3.push([...dataTable2[indexID],
                            // Number(item.ratio.monthly_january).toFixed(2),
                            // Number(item.ratio.monthly_february).toFixed(2),
                            // Number(item.ratio.monthly_march).toFixed(2),
                            // Number(item.ratio.monthly_april).toFixed(2),
                            // Number(item.ratio.monthly_may).toFixed(2),
                            // Number(item.ratio.monthly_june).toFixed(2),
                            // Number(item.ratio.monthly_july).toFixed(2),
                            // Number(item.ratio.monthly_august).toFixed(2),
                            // Number(item.ratio.monthly_september).toFixed(2),
                            // Number(item.ratio.monthly_october).toFixed(2),
                            // Number(item.ratio.monthly_november).toFixed(2),
                            // Number(item.ratio.monthly_december).toFixed(2),
                            item.ratio.monthly_january_last_year,
                            item.ratio.monthly_february_last_year,
                            item.ratio.monthly_march_last_year,
                            item.ratio.monthly_april_last_year,
                            item.ratio.monthly_may_last_year,
                            item.ratio.monthly_june_last_year,
                            item.ratio.monthly_july_last_year,
                            item.ratio.monthly_august_last_year,
                            item.ratio.monthly_september_last_year,
                            item.ratio.monthly_october_last_year,
                            item.ratio.monthly_november_last_year,
                            item.ratio.monthly_december_last_year,
                            ])

                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }

                        }

                    })
                    console.log(dataTable3)
                    this.setState({ dataTable: dataTable3, previewTable: true, loading: false, previewDownload: true })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    async downloadAllData() {
        let { company, periode, month, quarter } = this.state
        if (this.state.report.value === 1) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_profit_loss_detail/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=${this.state.report.value}&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report DB Profit & Loss Detail ${company.company_name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 2) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_balance_sheet/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=${this.state.report.value}&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}`
            )
            console.log(res);
            res = await res.blob()
            console.log(res);
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report DB Balance Sheet ${company.company_name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 3) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_profit_loss/export_report?submission_id=${this.state.PLID === null ? "" : this.state.PLID}&&report_id=28&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report DB Profit & Loss ${company.company_name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 4) {
            let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_ratio/export_report?submission_id=${this.state.FRID === null ? "" : this.state.FRID}&&report_id=29&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}`
            console.log(url);
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_ratio/export_report?submission_id=${this.state.FRID === null ? "" : this.state.FRID}&&report_id=29&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report DB Financial Ratio ${company.company_name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 5) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_tax_planning/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=${this.state.report.value}&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report DB Tax Planning ${company.company_name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 21) {
            let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_operating_indicator/export_report?operating_indicator_id=${this.state.OPID === null ? "" : this.state.OPID}&&report_id=${this.state.report.value}&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}`
            console.log(url);
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/db_operating_indicator/export_report?operating_indicator_id=${this.state.OPID === null ? "" : this.state.OPID}&&report_id=${this.state.report.value}&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report DB Operating Indicator ${company.company_name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 6) {
            let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/summary_cash_flow/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=6&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}&&months=${this.state.month.month_id}&&quarter=1`
            console.log(url);
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/summary_cash_flow/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=6&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}&&months=${this.state.month.month_id}&&quarter=1`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report Cash Flow - Summary ${company.company_name} ${month.month_value} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 7) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/summary_balance_sheet/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=2&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}&&months=${this.state.month.month_id}&&quarter=1`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report Balance Sheet - Summary ${company.company_name} ${month.month_value} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 8) {
            let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/summary_profit_loss/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=28&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}&&months=${this.state.month.month_id}&&quarter=1`
            console.log(url);
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/summary_profit_loss/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=28&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}&&months=${this.state.month.month_id}&&quarter=1`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report Profit & Loss - Summary ${company.company_name} ${month.month_value} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 9) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/summary_ratio/export_report?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=1&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}&&months=${this.state.month.month_id}&&quarter=1`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report Financial Ratio - Summary ${company.company_name} ${month.month_value} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 11) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cat/quarterly/export_report?report_id=10&&company_id=${this.state.company.company_id}&&periode=${this.state.periode.periode}&&quarter=${this.state.quarter.name}`
            )
            console.log(res);
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report CAT Performance Quarterly ${company.company_name} ${quarter.name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else if (this.state.report.value === 10) {
            let res = await fetch(
                `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cat/performance_appraisal/export?submission_id=${this.state.submissionID === null ? "" : this.state.submissionID}&&report_id=${this.state.report.value}&&company_id=${this.state.company.company_id}&&year=${this.state.periode.periode}&&revision=${this.state.revisionType}`
            )
            res = await res.blob()
            this.setState({ loading: false })
            if (res.size > 0) {
                let url = window.URL.createObjectURL(res);
                let a = document.createElement('a');
                a.href = url;
                a.download = `Report CAT Performance Appraisal ${company.company_name} ${periode.periode}.xlsx`;
                a.click();
            }
        } else {
            setTimeout(() => {
                this.setState({ loading: false })
            }, 1000);
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );
        return (
            <div style={{ flex: 1, backgroundColor: '#f8f8f8' }} ref={this.myRef}>
                <div>
                    <div className={"main-color"} style={{ height: 78, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                        <Typography style={{ fontSize: '16px', color: 'white' }}>Sub Holding Report</Typography>
                    </div>
                    <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                        <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                            {this.state.messageAlert}
                        </Alert>
                    </Snackbar>
                    <div style={{ padding: 20, width: '100%' }}>
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Sub Holding</Typography>
                            </div>
                            <div style={{ minWidth: 'max-content', padding: '20px 20px 0px 20px' }}>
                                <div style={{ marginTop: 15, display: 'flex' }}>
                                    <Autocomplete
                                        options={this.state.reportType}
                                        getOptionLabel={(option) => titleCase(option.label)}
                                        id="typereport"
                                        onChange={(event, newInputValue) => this.setState({ report: newInputValue, loading: true, previewTable: false }, () => {
                                            console.log('sini deh')
                                            let data = this.state.listPeriode.options
                                            let currentYear = new Date().getFullYear()
                                            let periode = (this.state.lastPeriod == "" ? String(Number(currentYear) + 1) : this.state.lastPeriod)
                                            let dateNow = new Date()
                                            dateNow.setMonth(dateNow.getMonth() - 1);
                                            let yearNow = dateNow.getFullYear()
                                            // console.log(data)
                                            // console.log(yearNow)
                                            // console.log(periode)
                                            if (String(this.state.report.label).toLocaleLowerCase().includes('summary')) {
                                                let index = data.sort((a, b) => a - b).findIndex((val) => val.periode == yearNow - 1)
                                                // console.log(index)
                                                this.setState({ periode: data[index] }, () => {
                                                    this.getReportType()
                                                })
                                            } else {
                                                this.getReportType()
                                            }
                                        })}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) => <TextField {...params} label="Report Type" margin="normal" style={{ marginTop: 7 }} />}
                                        value={this.state.report}
                                    />
                                    <Autocomplete
                                        {...this.state.listPeriode}
                                        id="periode"
                                        onChange={(event, newInputValue) => this.setState({ periode: newInputValue, loading: true, previewTable: false }, () => {
                                            this.getReportType()
                                        })}
                                        disabled={this.state.intent === 'Home' ? true : false}
                                        disableClearable
                                        style={{ width: 250, marginLeft: 20 }}
                                        renderInput={(params) =>
                                            <TextField {...params} label="Period" margin="normal" style={{ marginTop: 7 }}
                                            />}
                                        value={this.state.periode}
                                    />
                                </div>
                                <div style={{ marginTop: 15, display: 'flex' }}>
                                    <Autocomplete
                                        {...this.state.listCompany}
                                        id="company"
                                        disabled={this.state.intent === 'Home' ? true : false}
                                        onChange={(event, newInputValue) => this.setState({ company: newInputValue, loading: true, previewTable: false }, () => {
                                            this.getReportType()
                                        })}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) => <TextField {...params} label="Company" margin="normal" style={{ marginTop: 7 }} />}
                                        value={this.state.company}
                                    />
                                    {this.state.report != null ? String(this.state.report.label).toLocaleLowerCase().includes('summary') ?
                                        <Autocomplete
                                            {...this.state.listMonths}
                                            // getOptionLabel={(option) => titleCase(option.label)}
                                            id="months"
                                            onChange={(event, newInputValue) => this.setState({ month: newInputValue, loading: true, previewTable: false }, () => {
                                                this.getReportType()
                                            })}
                                            disableClearable
                                            style={{ width: 250, marginLeft: 20 }}
                                            renderInput={(params) => <TextField {...params} label="Months" margin="normal" style={{ marginTop: 7 }} />}
                                            value={this.state.month}
                                        /> : null : null}
                                    {/* {this.state.report != null ? String(this.state.report.label).toLocaleLowerCase().includes('summary') ? <Autocomplete
                                        {...this.state.listUom}
                                        // getOptionLabel={(option) => titleCase(option.label)}
                                        id="uom"
                                        onChange={(event, newInputValue) => this.setState({ uom: newInputValue, loading: true, previewTable: false }, () => {
                                            this.getReportType()
                                        })}
                                        disableClearable
                                        style={{ width: 250, marginLeft: 10 }}
                                        renderInput={(params) => <TextField {...params} label="Uom" margin="normal" style={{ marginTop: 7 }} />}
                                        value={this.state.uom}
                                    /> : null : null} */}
                                </div>
                                {/* <div style={{ marginTop: 15, display: 'flex' }}>
                                    <Autocomplete
                                        {...this.state.listPeriode}
                                        id="periode"
                                        onChange={(event, newInputValue) => this.setState({ periode: newInputValue, loading: true, previewTable: false }, () => {
                                            this.getReportType()
                                        })}
                                        disabled={this.state.intent === 'Home' ? true : false}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) =>
                                            <TextField {...params} label="Period" margin="normal" style={{ marginTop: 7 }}
                                            />}
                                        value={this.state.periode}
                                    />
                                </div> */}
                                {this.state.report != null ? String(this.state.report.label).toLocaleLowerCase().includes('quarterly') ? <div style={{ marginTop: 15, display: 'flex' }}>
                                    <Autocomplete
                                        {...this.state.listQuarter}
                                        // getOptionLabel={(option) => titleCase(option.label)}
                                        id="quarter"
                                        onChange={(event, newInputValue) => this.setState({ quarter: newInputValue, loading: true, previewTable: false }, () => {
                                            this.getReportType()
                                        })}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) => <TextField {...params} label="Quarter" margin="normal" style={{ marginTop: 7 }} />}
                                        value={this.state.quarter}
                                    />
                                </div> : null : null}
                                {/* {this.state.report != null ? String(this.state.report.label).toLocaleLowerCase().includes('summary') ? <div style={{ marginTop: 15, display: 'flex' }}>
                                    <Autocomplete
                                        {...this.state.listMonths}
                                        // getOptionLabel={(option) => titleCase(option.label)}
                                        id="months"
                                        onChange={(event, newInputValue) => this.setState({ month: newInputValue, loading: true, previewTable: false }, () => {
                                            this.getReportType()
                                        })}
                                        disableClearable
                                        style={{ width: 250 }}
                                        renderInput={(params) => <TextField {...params} label="Months" margin="normal" style={{ marginTop: 7 }} />}
                                        value={this.state.month}
                                    />
                                </div> : null : null} */}
                            </div>
                            <div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', padding: '0px 20px 10px 20px' }}>
                                    <div></div>
                                    {this.state.previewDownload && (
                                        <div style={{ width: '50%', justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            <a data-tip={'Download'} data-for="download">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5,
                                                        outline: 'none'
                                                    }}
                                                    onClick={() => this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.downloadAllData()
                                                        }, 100);
                                                    })}
                                                >
                                                    <img src={Images.download} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                        </div>
                                    )}
                                </div>
                                {this.state.loading && loadingComponent}
                                {this.state.previewTable && (
                                    <TableSubHolding
                                        width={this.props.width}
                                        height={this.props.height}
                                        open={this.props.open}
                                        month={this.state.month.month_value}
                                        approvedMB={this.state.approveMB}
                                        approveMonthly={this.state.approveMonthly}
                                        type={this.state.report ? this.state.report.value : 1}
                                        dataTable={this.state.dataTable}
                                        periode={this.state.periode ? this.state.periode.periode : null}
                                        quarter={this.state.quarter.name}
                                        company={this.state.company}
                                    />
                                )}
                            </div>
                        </Paper>
                    </div>
                </div>
            </div>
        )
    }
}
