import React, { Component } from 'react';
import { createMuiTheme, FormControlLabel, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, withStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import api from '../../api';
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import NumberFormat from 'react-number-format';
import { PropagateLoader } from 'react-spinners';
import UploadFile from '../../library/Upload';
import { ExcelRenderer } from 'react-excel-renderer';
import * as R from 'ramda'
import Constant from '../../library/Constant';
import { Alert } from '@material-ui/lab';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class FixedAssetsMovementMR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            visibleFAMMR: true,
            updateBy: [],
            notesUpdate: '-',
            get_for: 'view',
            saveDraft: true,
            buttonError: true,
            viewOnly: true
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getItemHierarki()
        this.getLatestUpdate()
        this.handleViewOnly()
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getItemHierarki()
            this.getLatestUpdate()
        })
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        api.create().getLastestUpdateMR(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notesUpdate: response.data.data.notes_update === null ? '-' : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, typeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "get_for": this.state.get_for
        }
        api.create().getHierarkiMontlyReportFAM(payload).then(response => {
            // console.log(payload);
            console.log(response);
            let dataTable = []
            if (response.data) {
                if (response.data.status === 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.fixed_asset_movement.mtd_mb === "" ? "0.0" : item.fixed_asset_movement.mtd_mb,
                                item.fixed_asset_movement.mtd_rb === "" ? "0.0" : item.fixed_asset_movement.mtd_rb,
                                item.fixed_asset_movement.mtd_actual === "" ? "0.0" : item.fixed_asset_movement.mtd_actual,
                                item.fixed_asset_movement.act_vs_mb_amount === "" ? "0.0" : item.fixed_asset_movement.act_vs_mb_amount,
                                item.fixed_asset_movement.act_vs_mb_percent === "" ? "0.0" : item.fixed_asset_movement.act_vs_mb_percent,
                                item.fixed_asset_movement.act_vs_rb_amount === "" ? "0.0" : item.fixed_asset_movement.act_vs_rb_amount,
                                item.fixed_asset_movement.act_vs_rb_percent === "" ? "0.0" : item.fixed_asset_movement.act_vs_rb_percent,
                                item.fixed_asset_movement.actual_formula,
                                item.order
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.fixed_asset_movement.mtd_mb === "" ? "0.0" : item.fixed_asset_movement.mtd_mb,
                            item.fixed_asset_movement.mtd_rb === "" ? "0.0" : item.fixed_asset_movement.mtd_rb,
                            item.fixed_asset_movement.mtd_actual === "" ? "0.0" : item.fixed_asset_movement.mtd_actual,
                            item.fixed_asset_movement.act_vs_mb_amount === "" ? "0.0" : item.fixed_asset_movement.act_vs_mb_amount,
                            item.fixed_asset_movement.act_vs_mb_percent === "" ? "0.0" : item.fixed_asset_movement.act_vs_mb_percent,
                            item.fixed_asset_movement.act_vs_rb_amount === "" ? "0.0" : item.fixed_asset_movement.act_vs_rb_amount,
                            item.fixed_asset_movement.act_vs_rb_percent === "" ? "0.0" : item.fixed_asset_movement.act_vs_rb_percent,
                            item.fixed_asset_movement.actual_formula,
                            item.order
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    console.log(dataTable);
                    this.setState({ dataTable, loading: false, refresh: false, buttonError: true, saveDraft: true }, () => {
                        this.setState({ loading: true, refresh: true })
                        setTimeout(() => {
                            this.setState({ loading: false, refresh: false, buttonError: true, saveDraft: true })
                        }, 200);

                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, refresh: false, buttonError: true, saveDraft: true })
            }
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/fam/monthly_report/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&months=${this.props.month.month_id}`
        )
        res = await res.blob()
        console.log(res);
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report Fixed Assets Movement.xlsx'
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/fam/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/fam/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId === null ? "" : this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report Fixed Assets Movement.xlsx';
            a.click();
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            orders: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report_id: i[1] === undefined ? "" : String(i[1]).trim(),
                            item_report: i[2] === undefined ? "" : String(i[2]).trim(),
                            mtd_actual: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[3]).trim(),
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    months: this.props.month.month_id,
                    fixed_asset_movement: payload,
                    status: 'submitted'
                }
                // console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        api.create().checkUploadMonthlyReportFAM(this.state.payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            // console.log(this.state.payload)
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, loading: true, visibleFAMMR: false, refresh: true })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.mtd_mb,
                            item.mtd_rb,
                            item.mtd_actual,
                            item.act_vs_mb_amount,
                            item.act_vs_mb_percent,
                            item.act_vs_rb_amount,
                            item.act_vs_rb_percent,
                            item.actual_formula,
                            item.order,
                            item.error
                        ]
                    })
                    console.log(dataTable)
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: true, editable: true, refresh: false }, () => {
                        this.state.dataTable.map(item => {
                            if (item[15].length > 0) {
                                console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true, editable: true, loading: true, refresh: true })
                                setTimeout(() => {
                                    this.setState({ loading: false, refresh: false })
                                }, 200);
                            }
                        })
                        // console.log(this.state.dataTable);
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadFAMMR(type) {
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                item_report: String(i[5]),
                mtd_mb: i[0] === 5 || i[0] === 6 ? String(Number(i[6]).toFixed(1)) : i[0] === 3 && i[6] === "" ? "0.0" : String(Number(i[6]).toFixed(1)),
                mtd_rb: i[0] === 5 || i[0] === 6 ? String(Number(i[7]).toFixed(1)) : i[0] === 3 && i[7] === "" ? "0.0" : String(Number(i[7]).toFixed(1)),
                mtd_actual: i[0] === 5 || i[0] === 6 ? String(Number(i[8]).toFixed(1)) : i[0] === 3 && i[8] === "" ? "0.0" : String(Number(i[8]).toFixed(1)),
                act_vs_mb_amount: i[0] === 5 || i[0] === 6 ? String(Number(i[9]).toFixed(1)) : i[0] === 3 && i[9] === "" ? "0.0" : String(Number(i[9]).toFixed(1)),
                act_vs_mb_percent: i[0] === 5 || i[0] === 6 ? String(Number(i[10]).toFixed(1)) : i[0] === 3 && i[10] === "" ? "0.0" : String(Number(i[10]).toFixed(1)),
                act_vs_rb_amount: i[0] === 5 || i[0] === 6 ? String(Number(i[11]).toFixed(1)) : i[0] === 3 && i[11] === "" ? "0.0" : String(Number(i[11]).toFixed(1)),
                act_vs_rb_percent: i[0] === 5 || i[0] === 6 ? String(Number(i[12]).toFixed(1)) : i[0] === 3 && i[12] === "" ? "0.0" : String(Number(i[12]).toFixed(1)),
            })
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "fixed_asset_movement": data
        }
        console.log(data);
        api.create('UPLOAD').uploadMonthlyReportFAM(body).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    // this.props.onClickClose()
                    if (type == 'submitted') {
                        this.props.saveToMonthlyReport('FAM')
                    } else {
                        this.props.saveToMonthlyReport()
                    }
                    // this.props.getReport()
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    backToMonthlyReport(type) {
        this.setState({ loading: true })
        // console.log(this.state.dataTable);
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                "item_report_id": i[1],
                "mtd_mb": String(Number(i[6]).toFixed(1)),
                "mtd_rb": String(Number(i[7]).toFixed(1)),
                "mtd_actual": String(Number(i[8]).toFixed(1)),
                "act_vs_mb_amount": String(i[9]) === 'NaN' || String(i[9]) === 'Infinity' || String(i[9]) === '-Infinity' ? '0.0' : String(Number(i[9]).toFixed(1)),
                "act_vs_mb_percent": String(i[10]) === 'NaN' || String(i[10]) === 'Infinity' || String(i[10]) === '-Infinity' ? '0.0' : String(Number(i[10]).toFixed(1)),
                "act_vs_rb_amount": String(i[11]) === 'NaN' || String(i[11]) === 'Infinity' || String(i[11]) === '-Infinity' ? '0.0' : String(Number(i[11]).toFixed(1)),
                "act_vs_rb_percent": String(i[12]) === 'NaN' || String(i[12]) === 'Infinity' || String(i[12]) === '-Infinity' ? '0.0' : String(Number(i[12]).toFixed(1))
            })
        })
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "fixed_asset_movement": data
        }
        // console.log(JSON.stringify(payload));

        api.create('UPLOAD').createMonthlyReportFAM(payload).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.saveToMonthlyReport('FAM')
                    } else {
                        this.props.saveToMonthlyReport()
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        document.body.style.overflow = 'unset';
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                        this.props.saveToMonthlyReport()
                    })
                }
                // else {
                //     this.setState({ loading: false }, () => {
                //         this.props.saveToMonthlyReport()
                //     })
                // }
            } else {
                this.setState({ loading: false }, () => {
                    this.getSubmission()
                    document.body.style.overflow = 'unset';
                })
            }
        })
    }

    handleValidate() {
        let data = []
        let err = false
        this.state.dataTable.map((i, index) => {

            data.push({
                "item_report_id": i[1],
                "mtd_mb": i[6],
                "mtd_rb": i[7],
                "mtd_actual": i[8],
                "act_vs_mb_amount": String(i[9]) === 'NaN' || String(i[9]) === 'Infinity' || String(i[9]) === '-Infinity' ? '0.0' : String(i[9]),
                "act_vs_mb_percent": String(i[10]) === 'NaN' || String(i[10]) === 'Infinity' || String(i[10]) === '-Infinity' ? '0.0' : String(i[10]),
                "act_vs_rb_amount": String(i[11]) === 'NaN' || String(i[11]) === 'Infinity' || String(i[11]) === '-Infinity' ? '0.0' : String(i[11]),
                "act_vs_rb_percent": String(i[12]) === 'NaN' || String(i[12]) === 'Infinity' || String(i[12]) === '-Infinity' ? '0.0' : String(i[12])
            })
        })


        // console.log(JSON.stringify(data))
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": "submitted",
            "months": this.props.month.month_id,
            "fixed_asset_movement": data
        }
        // console.log(JSON.stringify(payload));
        api.create().validateSubmitReportFAM(payload).then((response) => {
            console.log(response.data.data.result)
            console.log(err);
            if (response.data) {
                if (response.data.status === "success") {
                    if (response.data.data.result && err === false) {
                        this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
                    } else {
                        this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable

        const handleValueFormula = (tableMeta, colIdx) => {
            // loading = true
            // console.log(tableMeta);
            // "@44[M-1]#BS"
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []
            // console.log(splitFormula);
            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                // console.log(item);
                // console.log(items);
                // console.log(subForm);

                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (items == ']') {
                        baru.push(String(item))
                    } else if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            // console.log(baru);
            let tambahan = false
            let opet = ""
            baru.map((item, index) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (String(item).includes('[M-1]')) {
                            let tst = '@' + String(item).replace('[M-1]', '[M1]')
                            // console.log(dataTable2[tableMeta.rowIndex]);
                            // console.log(tableMeta);
                            console.log(tst);
                            let indexID = dataTable2[tableMeta.rowIndex][13].findIndex((val) => val.item_formula == tst)
                            // console.log(indexID);

                            if (indexID !== -1) {
                                let valuezz = dataTable2[tableMeta.rowIndex][13][indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                                // console.log(valuezz);
                            }
                        } else {
                            let data = tableMeta.rowData[13] == null ? [] : tableMeta.rowData[13]
                            let indexID = data.findIndex((val) => val.item_formula == String(`@${item}`))
                            if (indexID !== -1) {
                                let valuezz = data[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    } else {
                        if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let indexID = dataTable2.findIndex((val) => val[14] == tst)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][8]
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            let indexID = dataTable2.findIndex((val) => val[14] == item)
                            if (item == 'X-1') {
                                anjay.push(-1)
                            } else if (tambahan) {
                                if (item == '-' || item == '+' || item == '/' || item == '*') {
                                    opet = item
                                } else {
                                    anjay.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                                    tambahan = false
                                    opet = ""
                                }
                            } else {
                                if (indexID !== -1) {
                                    let valuezz = dataTable2[indexID][colIdx]
                                    if (item == dataTable2[tableMeta.rowIndex][28]) {
                                        anjay.push(0)
                                    } else {
                                        anjay.push(valuezz == "" ? 0 : valuezz)
                                    }
                                } else {
                                    if (item === '(-1)') {
                                        anjay.push(-1)
                                    }
                                }
                            }
                        }
                    }
                }
            })

            let anjay2 = []
            let kurung = false
            let item1 = []
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                } else if (item == ")") {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            dataTable2[tableMeta.rowIndex][colIdx] = total
            return total
        }

        const handleChange = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            dataTable2[tableMeta.rowIndex][type] = val
            // console.log(dataTable2)
            // console.log(dataTable2[tableMeta.rowIndex][type]);
            // console.log(value);
        }

        const handleValue = (data, type) => {
            // console.log(data, type);            
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] === item[2]) {
                    let itemVal = item[data.columnIndex + type].value !== undefined ? Number(item[data.columnIndex + type].value) : Number(item[data.columnIndex + type])
                    total = item[data.columnIndex + type] === undefined ? Number(total) + 0 : Number(total) + itemVal
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex + type] = Number(total).toFixed(1)
            // console.log(indexParent);
            return a
        }

        const handleVariance = (tableMeta, dex, type) => {
            let total = 0
            // if (dex === 1) {
            //     total = Number(tableMeta.rowData[8]) - Number(tableMeta.rowData[9]) == NaN? "0.0" : Number(tableMeta.rowData[8]) - Number(tableMeta.rowData[9])
            //     dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            // console.log(tableMeta.rowData[8]);
            // console.log(tableMeta.rowData[9]);
            // console.log(total)
            if (dex === 2) {
                total = Number(tableMeta.rowData[8]) - Number(tableMeta.rowData[6]) == NaN ? "0.0" : Number(tableMeta.rowData[8]) - Number(tableMeta.rowData[6])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
                // console.log(tableMeta.rowData[8]);
                // console.log(tableMeta.rowData[6]);
                // console.log(total)
            } else if (dex === 3) {
                total = Number(tableMeta.rowData[8]) - Number(tableMeta.rowData[7]) == NaN ? "0.0" : Number(tableMeta.rowData[8]) - Number(tableMeta.rowData[7])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
                // console.log(tableMeta.rowData[8]);
                // console.log(tableMeta.rowData[7]);
                // console.log(total)
            }
            // console.log(dex)
            // console.log(Number(tableMeta.columnIndex) + Number(type))
            // console.log(total);
            // console.log(dataTable2);
            return total
        }

        const handleVariancePercent = (tableMeta, dex, type) => {
            let total = 0
            // if (tableMeta.rowData[5] === "Disposal (negative value)") {
            //     console.log(dataTable2);
            //     console.log(tableMeta);
            // }
            // value={Number(handleVariancePercent(tableMeta, 1, 3)).toFixed(1)}
            // dataTable2[5][11]
            // if (dex === 1) {
            //     total = R.equals((Number(dataTable2[tableMeta.rowIndex][10]) / Number(dataTable2[tableMeta.rowIndex][9])), NaN) ? '0' : R.equals((Number(dataTable2[tableMeta.rowIndex][10]) / Number(dataTable2[tableMeta.rowIndex][9])), Infinity) ? "0" : R.equals((Number(dataTable2[tableMeta.rowIndex][10]) / Number(dataTable2[tableMeta.rowIndex][9])), -Infinity) ? "0" : Number(dataTable2[tableMeta.rowIndex][10]) / Number(dataTable2[tableMeta.rowIndex][9])
            //     dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            // if (tableMeta.rowData[5] === "Cash and cash equivalent") {
            // console.log(total);
            // console.log(Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][10]));
            //     console.log(dataTable2[tableMeta.rowIndex]);
            // }
            if (dex === 2) {
                total = R.equals((Number(dataTable2[tableMeta.rowIndex][9]) / Number(dataTable2[tableMeta.rowIndex][6])), NaN) ? '0' : R.equals((Number(dataTable2[tableMeta.rowIndex][9]) / Number(dataTable2[tableMeta.rowIndex][6])), Infinity) ? "0" : R.equals((Number(dataTable2[tableMeta.rowIndex][9]) / Number(dataTable2[tableMeta.rowIndex][6])), -Infinity) ? "0" : Number(dataTable2[tableMeta.rowIndex][9]) / Number(dataTable2[tableMeta.rowIndex][6])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            } else if (dex === 3) {
                total = R.equals((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][7])), NaN) ? '0' : R.equals((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][7])), Infinity) ? "0" : R.equals((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][7])), -Infinity) ? "0" : Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][7])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
                // console.log(total);
            }
            // console.log(dex)
            // console.log(Number(tableMeta.columnIndex) + Number(type))
            return total * 100
        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (value, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[24] ?
                                    tableMeta.rowData[24].length > 0 ?
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : value}</span>
                                            </LightTooltip>
                                        </div>
                                        :
                                        tableMeta.rowData[4] === 0 ?
                                            <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : value).toUpperCase()}</span>
                                            :
                                            <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : value}</span>
                                            </div>
                                    :
                                    tableMeta.rowData[4] === 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : value).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : value}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Month To Date (MTD)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 45 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 45, display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
                                    <span>{"Master Budget (MB)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0', height: 45, display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
                                    <span>{"Rolling Budget (RB)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#07a7d0', height: 45, display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
                                    <span>{"Actual"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {
                                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 4 ?
                                                    null :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(tableMeta.rowData[6]).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {
                                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 4 ?
                                                    null :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 120 }}>
                                            {
                                                tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 4 ?
                                                    null :
                                                    this.state.get_for == 'view' ?
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                        :
                                                        tableMeta.rowData[0] === 3 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={value}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            // style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            style={{ color: this.props.isApprover || this.state.get_for == 'view' ? 'black' : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                                            onBlur={(event) => {
                                                                                handleChange(event.target.value, tableMeta, 8)
                                                                            }}
                                                                            fixedDecimalScale={1}
                                                                            decimalScale={1}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                                <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: String(tableMeta.rowData[5]).toLocaleLowerCase() == "beginning balance" && this.props.periode == 2021 && this.props.month.month_id == 1 ? "#5198ea" : "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={String(tableMeta.rowData[5]).toLocaleLowerCase() == "beginning balance" && this.props.periode == 2021 && this.props.month.month_id == 1 ? false : true}
                                                                        value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "beginning balance" && this.props.periode == 2021 && this.props.month.month_id == 1 ? Number(tableMeta.rowData[8]).toFixed(1) : Number(handleValueFormula(tableMeta, 8)).toFixed(1)}
                                                                        onBlur={(event) => {
                                                                            handleChange(event.target.value, tableMeta, 8)
                                                                        }}
                                                                        fixedDecimalScale={1}
                                                                        decimalScale={1}
                                                                    />
                                                                </span> :
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={value}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Variance`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderLeft: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 45, display: 'flex', justifyContent: 'center', alignItems: 'center' }}>{columnMeta.name}</div>
                            <div className="grid grid-2x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', borderBottom: '1px solid #37b5e6' }}>
                                    <div style={{ borderBottom: '1px #fff solid', padding: 2.5, backgroundColor: '#37b5e6' }}>
                                        <span>{"Act vs MB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', padding: 2.5, backgroundColor: '#37b5e6' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ padding: 2.5, backgroundColor: '#37b5e6' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', border: '1px #fff solid', backgroundColor: '#07a7d0', borderBottom: '1px solid #37b5e6' }}>
                                    <div style={{ borderBottom: '1px #fff solid', padding: 2.5, backgroundColor: '#37b5e6' }}>
                                        <span>{"Act vs RB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', padding: 2.5, backgroundColor: '#37b5e6' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ padding: 2.5, backgroundColor: '#37b5e6' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 10
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-2x content-center">
                                    <div className="column-1">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                                    />
                                                                }
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleVariance(tableMeta, 2, 2)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        suffix={'%'}
                                                                        value={Number(Number(tableMeta.rowData[10]) * 100).toFixed(1)}
                                                                    />
                                                                }
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            suffix={'%'}
                                                                            // value={0}
                                                                            value={Number(handleVariancePercent(tableMeta, 2, 3)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="column-2">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                                    />
                                                                }
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleVariance(tableMeta, 3, 4)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 90, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        suffix={'%'}
                                                                        value={Number(Number(tableMeta.rowData[10]) * 100).toFixed(1)}
                                                                    />
                                                                }
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            suffix={'%'}
                                                                            // value={0}
                                                                            value={Number(handleVariancePercent(tableMeta, 3, 5)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }]

        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                {this.state.loading && loadingComponent}
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleFAMMR ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Fixed Assets Movement</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.props.isApprover === true || this.state.get_for == 'view' ?
                                            null
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            // </div> 
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.downloadTemplate()}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {!this.state.refresh && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5 }}>Notes : {this.state.notesUpdate}</Typography>
                            </div>
                            <div className="grid grid-2x" style={{ padding: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2"></div>
                                    :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, refresh: true }, () => {
                                                    this.handleGetFor('edit')
                                                    // setTimeout(() => {
                                                    //     this.setState({ loading: false })
                                                    // }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        // this.setState({ loading: false })
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick === 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.backToMonthlyReport('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick === 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.backToMonthlyReport('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                        </Paper> :
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Fixed Assets Movement</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                </div>
                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {!this.state.refresh && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>
                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1" style={{ paddingLeft: 0 }}>
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visibleFAMMR: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                        (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === "draft" || this.props.status === 'submitted') ? */}
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        // this.setState({ loading: false })
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick === 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadFAMMR('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick === 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadFAMMR('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>
                    }
                </div>
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => {
                                    String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("FIXED") && String(this.state.judul).includes("ASSETS") && String(this.state.judul).includes("MOVEMENT") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") ?
                                        this.checkUpload() :
                                        this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                }}
                            />
                        </div>
                    </div>
                )}
            </div>
        )
    }
}