import { createMuiTheme, FormControlLabel, Input, Snackbar, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, withStyles } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import ReactTooltip from 'react-tooltip';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import { type } from 'ramda';
import { PropagateLoader } from 'react-spinners';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import Constant from '../../library/Constant';
import * as R from 'ramda';
import { Alert } from '@material-ui/lab';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class BalanceSheetMR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            visibleBSMR: true,
            valueThreshold: 0,
            minValue: 0,
            maxValue: 0,
            updateBy: [],
            notes: "",
            judulColumn: null,
            get_for: "view",
            viewOnly: true,
            kansas: 0
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getSettingControl()
        this.getLatestUpdate()
        this.handleViewOnly()
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({viewOnly: true})
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        api.create().getLastestUpdateMR(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_VARIANCE',
            company_id: this.props.company.company_id,
            type: 'BALANCE_SHEET'
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        minValue: response.data.data[0] ? Number(response.data.data[0].min_value) : -5,
                        maxValue: response.data.data[0] ? Number(response.data.data[0].max_value) : 5,
                    }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "get_for": this.state.get_for
        }
        api.create().getHierarkiMontlyReportBS(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable = []
            let err = false

            if (response.data) {
                let res = response.data.data
                const handlePushChild = (item) => {
                    let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                    if (item.type_report_id === 3) {
                        // if (item.balance_sheet.mtd_vs_previous_month == "" &&  Number(item.balance_sheet.percent_act_vs_previous_month) < this.state.minValue || Number(item.balance_sheet.percent_act_vs_previous_month) > this.state.maxValue) {
                        //     err = true
                        // } 
                        if (item.balance_sheet.mtd_vs_mb == "" && Number(item.balance_sheet.percent_act_vs_mb).toFixed(1) < this.state.minValue || Number(item.balance_sheet.percent_act_vs_mb).toFixed(1) > this.state.maxValue) {
                            err = true
                        }
                        // if (item.balance_sheet.mtd_vs_rb == "" &&  Number(item.balance_sheet.percent_act_vs_rb) < this.state.minValue || Number(item.balance_sheet.percent_act_vs_rb) > this.state.maxValue) {
                        //     err = true
                        // }
                    }
                    if (indexIDzz === -1) {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.balance_sheet.rolling_outlook === null ? "0" : item.balance_sheet.rolling_outlook === "" ? "0" : item.balance_sheet.rolling_outlook,
                            item.balance_sheet.master_budget === "" ? "0" : item.balance_sheet.master_budget,
                            item.balance_sheet.rolling_budget === "" ? "0" : item.balance_sheet.rolling_budget,
                            item.balance_sheet.actual === "" ? "0" : item.balance_sheet.actual,
                            item.balance_sheet.actual_previous_month === null ? "0.0" : item.balance_sheet.actual_previous_month === "" ? "0.0" : item.balance_sheet.actual_previous_month,
                            item.balance_sheet.amount_act_vs_previous_month === "" ? "0" : item.balance_sheet.amount_act_vs_previous_month,
                            item.balance_sheet.percent_act_vs_previous_month === "" ? "0" : item.balance_sheet.percent_act_vs_previous_month,
                            item.balance_sheet.amount_act_vs_mb === "" ? "0" : item.balance_sheet.amount_act_vs_mb,
                            item.balance_sheet.percent_act_vs_mb === "" ? "0" : item.balance_sheet.percent_act_vs_mb,
                            item.balance_sheet.amount_act_vs_rb === "" ? "0" : item.balance_sheet.amount_act_vs_rb,
                            item.balance_sheet.percent_act_vs_rb === "" ? "0" : item.balance_sheet.percent_act_vs_rb,
                            item.balance_sheet.mtd_vs_previous_month === null ? "" : item.balance_sheet.mtd_vs_previous_month,
                            item.balance_sheet.mtd_vs_mb === null ? "" : item.balance_sheet.mtd_vs_mb,
                            item.balance_sheet.mtd_vs_rb === null ? "" : item.balance_sheet.mtd_vs_rb,
                            item.balance_sheet.actual_formula,
                            item.order,
                            item.condition_it_should_be,
                            item.condition_if_wrong
                        ])
                    }
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                }
                res.map((item, index) => {
                    if (item.type_report_id === 3) {
                        // if (item.balance_sheet.mtd_vs_previous_month == "" &&  Number(item.balance_sheet.percent_act_vs_previous_month) < this.state.minValue || Number(item.balance_sheet.percent_act_vs_previous_month) > this.state.maxValue) {
                        //     err = true
                        // } 
                        if (item.balance_sheet.mtd_vs_mb == "" && Number(item.balance_sheet.percent_act_vs_mb).toFixed(1) < this.state.minValue || Number(item.balance_sheet.percent_act_vs_mb).toFixed(1) > this.state.maxValue) {
                            err = true
                        }
                        // if (item.balance_sheet.mtd_vs_rb == "" &&  Number(item.balance_sheet.percent_act_vs_rb) < this.state.minValue || Number(item.balance_sheet.percent_act_vs_rb) > this.state.maxValue) {
                        //     err = true
                        // }
                    }
                    dataTable.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        item.description,
                        item.balance_sheet.rolling_outlook === null ? "0" : item.balance_sheet.rolling_outlook === "" ? "0" : item.balance_sheet.rolling_outlook,
                        item.balance_sheet.master_budget === "" ? "0" : item.balance_sheet.master_budget,
                        item.balance_sheet.rolling_budget === "" ? "0" : item.balance_sheet.rolling_budget,
                        item.balance_sheet.actual === "" ? "0" : item.balance_sheet.actual,
                        item.balance_sheet.actual_previous_month === null ? "0.0" : item.balance_sheet.actual_previous_month === "" ? "0.0" : item.balance_sheet.actual_previous_month,
                        item.balance_sheet.amount_act_vs_previous_month === "" ? "0" : item.balance_sheet.amount_act_vs_previous_month,
                        item.balance_sheet.percent_act_vs_previous_month === "" ? "0" : item.balance_sheet.percent_act_vs_previous_month,
                        item.balance_sheet.amount_act_vs_mb === "" ? "0" : item.balance_sheet.amount_act_vs_mb,
                        item.balance_sheet.percent_act_vs_mb === "" ? "0" : item.balance_sheet.percent_act_vs_mb,
                        item.balance_sheet.amount_act_vs_rb === "" ? "0" : item.balance_sheet.amount_act_vs_rb,
                        item.balance_sheet.percent_act_vs_rb === "" ? "0" : item.balance_sheet.percent_act_vs_rb,
                        item.balance_sheet.mtd_vs_previous_month === null ? "" : item.balance_sheet.mtd_vs_previous_month,
                        item.balance_sheet.mtd_vs_mb === null ? "" : item.balance_sheet.mtd_vs_mb,
                        item.balance_sheet.mtd_vs_rb === null ? "" : item.balance_sheet.mtd_vs_rb,
                        item.balance_sheet.actual_formula,
                        item.order,
                        item.condition_it_should_be,
                        item.condition_if_wrong
                    ])
                    if (item.children !== null) {
                        if (item.children.length > 0) {
                            item.children.map((items, indexs) => {
                                handlePushChild(items)
                            })
                        }
                    }
                })
                if (err === true) {
                    this.setState({ bebas: true })
                }
                this.setState({ dataTable, loading: false, buttonError: true, saveDraft: true })
            }
            console.log(dataTable);
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/balance_sheet/monthly_report/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&months=${this.props.month.month_id}`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report Balance Sheet.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/balance_sheet/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/balance_sheet/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId === null ? "" : this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report Balance Sheet.xlsx';
            a.click();
        }
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getSettingControl()
            this.getLatestUpdate()
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(resp.rows[2]);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            orders: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report_id: i[1] === undefined ? "" : String(i[1]).trim(),
                            item_report: i[2] === undefined ? "" : String(i[2]).trim(),
                            actual: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[3]).trim(),
                            mtd_vs_previous_month: i[4] === undefined ? "" : String(i[4]).trim(),
                            mtd_vs_mb: i[5] === undefined ? "" : String(i[5]).trim(),
                            mtd_vs_rb: i[6] === undefined ? "" : String(i[6]).trim(),
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    balance_sheet: payload,
                    months: this.props.month.month_id,
                    status: 'submitted'
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        api.create().checkUploadMonthlyReportBS(this.state.payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleBSMR: false, loading: true })
                    let err = false
                    let dataTable = response.data.data.map((item, index) => {
                        if (item.type_report_id === 3) {
                            if (item.mtd_vs_mb == "" && Number(item.percent_act_vs_mb).toFixed(1) < this.state.minValue || Number(item.percent_act_vs_mb).toFixed(1) > this.state.maxValue) {
                                err = true
                            }
                        }
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.rolling_outlook === null ? "" : item.rolling_outlook === "" ? "" : item.rolling_outlook,
                            item.master_budget === "" ? "" : item.master_budget,
                            item.rolling_budget === "" ? "" : item.rolling_budget,
                            item.actual === "" ? "" : item.actual,
                            item.actual_previous_month === null ? "0.0" : item.actual_previous_month === "" ? "0.0" : item.actual_previous_month,
                            item.amount_act_vs_previous_month === "" ? "0.0" : item.amount_act_vs_previous_month,
                            item.percent_act_vs_previous_month === "" ? "0.0" : item.percent_act_vs_previous_month,
                            item.amount_act_vs_mb === "" ? "0.0" : item.amount_act_vs_mb,
                            item.percent_act_vs_mb === "" ? "0.0" : item.percent_act_vs_mb,
                            item.amount_act_vs_rb === "" ? "0.0" : item.amount_act_vs_rb,
                            item.percent_act_vs_rb === "" ? "0.0" : item.percent_act_vs_rb,
                            // 0,
                            // 0,
                            // 0,
                            // 0,
                            // 0,
                            // 0,
                            item.mtd_vs_previous_month === null ? "" : item.mtd_vs_previous_month === undefined ? "" : item.mtd_vs_previous_month,
                            item.mtd_vs_mb === null ? "" : item.mtd_vs_mb === undefined ? "" : item.mtd_vs_mb,
                            item.mtd_vs_rb === null ? "" : item.mtd_vs_rb === undefined ? "" : item.mtd_vs_rb,
                            item.actual_formula,
                            item.order,
                            item.condition_it_should_be,
                            item.condition_if_wrong,
                            item.error
                        ]
                    })
                    console.log(dataTable)
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: true, isUpload: true }, () => {
                        this.state.dataTable.map(item => {
                            if (item[24].length > 0) {
                                // console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true })
                            }
                        })
                        // console.log(this.state.buttonError)
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadBalanceSheet(type) {
        let data = []
        this.setState({ loading: true })
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                item_report: String(i[5]),
                rolling_outlook: i[0] === 5 || i[0] === 6 ? String(Number(i[6]).toFixed(1)) : i[0] === 3 && i[6] === "" ? "0.0" : String(Number(i[6]).toFixed(1)),
                master_budget: i[0] === 5 || i[0] === 6 ? String(Number(i[7]).toFixed(1)) : i[0] === 3 && i[7] === "" ? "0.0" : String(Number(i[7]).toFixed(1)),
                rolling_budget: i[0] === 5 || i[0] === 6 ? String(Number(i[8]).toFixed(1)) : i[0] === 3 && i[8] === "" ? "0.0" : String(Number(i[8]).toFixed(1)),
                actual: i[0] === 5 || i[0] === 6 ? String(Number(i[9]).toFixed(1)) : i[0] === 3 && i[9] === "" ? "0.0" : String(Number(i[9]).toFixed(1)),
                actual_previous_month: i[0] === 5 || i[0] === 6 ? String(Number(i[10]).toFixed(1)) : i[0] === 3 && i[10] === "" ? "0.0" : String(Number(i[10]).toFixed(1)),
                amount_act_vs_previous_month: i[0] === 5 || i[0] === 6 ? String(Number(i[11]).toFixed(1)) : i[0] === 3 && i[11] === "" ? "0.0" : String(Number(i[11]).toFixed(1)),
                percent_act_vs_previous_month: i[0] === 5 || i[0] === 6 ? String(Number(i[12]).toFixed(1)) : i[0] === 3 && i[12] === "" ? "0.0" : String(Number(i[12]).toFixed(1)),
                amount_act_vs_mb: i[0] === 5 || i[0] === 6 ? String(Number(i[13]).toFixed(1)) : i[0] === 3 && i[13] === "" ? "0.0" : String(Number(i[13]).toFixed(1)),
                percent_act_vs_mb: i[0] === 5 || i[0] === 6 ? String(Number(i[14]).toFixed(1)) : i[0] === 3 && i[14] === "" ? "0.0" : String(Number(i[14]).toFixed(1)),
                amount_act_vs_rb: i[0] === 5 || i[0] === 6 ? String(Number(i[15]).toFixed(1)) : i[0] === 3 && i[15] === "" ? "0.0" : String(Number(i[15]).toFixed(1)),
                percent_act_vs_rb: i[0] === 5 || i[0] === 6 ? String(Number(i[16]).toFixed(1)) : i[0] === 3 && i[16] === "" ? "0.0" : String(Number(i[16]).toFixed(1)),
                mtd_vs_previous_month: String(i[17]),
                mtd_vs_mb: String(i[18]),
                mtd_vs_rb: String(i[19])
            })
        })
        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "balance_sheet": data
        }
        console.log(body);
        console.log(JSON.stringify(body));
        console.log(body)
        api.create('UPLOAD').uploadMonthlyReportBS(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    // this.props.onClickClose()
                    if (type == 'submitted') {
                        this.props.saveToMonthlyReport('BS')
                        // let bodyRatioBs = {
                        //     "report": 'ratio',
                        //     "monthlyReportId": this.props.monthlyReportId,
                        //     "periode": this.props.periode,
                        //     "companyId": this.props.company.company_id,
                        //     "months": this.props.month.month_id
                        // }
                        // api.create().triggerRatioFromLOCF(bodyRatioBs).then((res) => {
                        //     console.log(res)
                        //     this.setState({ loading: false })
                        // })
                    } else {
                        this.props.saveToMonthlyReport()
                    }
                    this.setState({ loading: false, handleDoubleClick: 0 })
                    // this.props.getReport()
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    backToMonthlyReport(type) {
        this.setState({ loading: true })
        let data = []
        this.state.dataTable.map(i => {
            data.push({
                "item_report_id": i[1],
                "rolling_outlook": String(Number(i[6]).toFixed(1)),
                "master_budget": String(Number(i[7]).toFixed(1)),
                "rolling_budget": String(Number(i[8]).toFixed(1)),
                "actual": String(Number(i[9]).toFixed(1)),
                "actual_previous_month": String(Number(i[10]).toFixed(1)),
                "amount_act_vs_previous_month": String(Number(i[11]).toFixed(1)),
                "percent_act_vs_previous_month": String(Number(i[12]).toFixed(1)),
                "amount_act_vs_mb": String(Number(i[13]).toFixed(1)),
                "percent_act_vs_mb": i[14],
                "amount_act_vs_rb": String(Number(i[15]).toFixed(1)),
                "percent_act_vs_rb": i[16],
                "mtd_vs_previous_month": i[17],
                "mtd_vs_mb": i[18],
                "mtd_vs_rb": i[19]
            })
        })
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "balance_sheet": data
        }
        api.create('UPLOAD').createMonthlyReportBS(payload).then(response => {
            console.log(payload);
            console.log(response);
            console.log(JSON.stringify(payload))
            if (response.data) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.saveToMonthlyReport('BS')
                        // let bodyRatioBs = {
                        //     "report": 'ratio',
                        //     "monthlyReportId": this.props.monthlyReportId,
                        //     "periode": this.props.periode,
                        //     "companyId": this.props.company.company_id,
                        //     "months": this.props.month.month_id
                        // }
                        // api.create().triggerRatioFromLOCF(bodyRatioBs).then((res) => {
                        //     console.log(res)
                        //     this.setState({ loading: false })
                        // })
                    } else {
                        this.props.saveToMonthlyReport()
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                        document.body.style.overflow = 'unset';
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                        this.props.saveToMonthlyReport()
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    handleValidate() {
        let data = []
        let err = false
        let errorContrl = false
        let editAble = this.state.editAble
        let dataTable = this.state.dataTable
        let kansas = this.state.kansas
        console.log(dataTable[dataTable.length - 1])
        dataTable.map((i, index) => {
            if (i[0] === 3) {
                // console.log(i);
                // if ( i[17] === "" && (Number(i[12]) < this.state.minValue || Number(i[12]) > this.state.maxValue)) {
                //     console.log('msk 1');
                //     // console.log(i);
                //     err = true
                // } else 
                if (i[18] === "" && (Number(i[14]).toFixed(1) < this.state.minValue || Number(i[14]).toFixed(1) > this.state.maxValue)) {
                    console.log('msk 2');
                    err = true
                }
            }

            if (String(i[5]) == "Control (should be nil)") {
                if (Number(i[9]).toFixed(1) < this.state.minValue || Number(i[9]).toFixed(1) > this.state.maxValue) {
                    errorContrl = true
                    editAble = true
                }
            }

            data.push({
                "item_report_id": i[1],
                "rolling_outlook": i[6],
                "master_budget": i[7],
                "rolling_budget": i[8],
                "actual": i[9],
                "actual_previous_month": i[10],
                "amount_act_vs_previous_month": i[11],
                "percent_act_vs_previous_month": i[12],
                "amount_act_vs_mb": i[13],
                "percent_act_vs_mb": i[14],
                "amount_act_vs_rb": i[15],
                "percent_act_vs_rb": i[16],
                "mtd_vs_previous_month": i[17],
                "mtd_vs_mb": i[18],
                "mtd_vs_rb": i[19]
            })
        })
        // console.log(JSON.stringify(data));
        // data.map(i => {
        //     if (i.mtd_vs_previous_month === "" && (Number(i.percent_act_vs_previous_month) < this.state.minValue || Number(i.percent_act_vs_previous_month) > this.state.maxValue)) {
        //         console.log('msk 1');
        //         console.log(i);
        //         err = true
        //     } else if (i.mtd_vs_mb === "" && (Number(i.percent_act_vs_mb) < this.state.minValue || Number(i.percent_act_vs_mb) > this.state.maxValue)) {
        //         console.log('msk 2');
        //         err = true
        //     } else if (i.mtd_vs_rb === "" && (Number(i.percent_act_vs_rb) < this.state.minValue || Number(i.percent_act_vs_rb) > this.state.maxValue)) {
        //         console.log('msk 3');
        //         err = true
        //     }
        // })
        // if (err === true) {
        //     console.log('error');
        //     this.setState({ loading: false, buttonError: true, saveDraft: false })
        // } else {
        //     console.log('g error');
        //     this.setState({ loading: false, buttonError: false, saveDraft: false })
        // }

        // console.log(JSON.stringify(data))
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": "submitted",
            "months": this.props.month.month_id,
            "balance_sheet": data
        }
        // console.log(JSON.stringify(payload));
        // console.log(this.state.dataTable)
        api.create().validateSubmitReportBS(payload).then((response) => {
            console.log(response.data.data.result)
            console.log(err);
            console.log(errorContrl);
            if (response.data) {
                if (response.data.status === "success") {
                    if (response.data.data.result && err === false && errorContrl === false) {
                        this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
                        if (kansas == 0) {
                            this.setState({ kansas: 1, loading: true }, () => {
                                this.handleValidate()
                            })
                        } else {
                            this.setState({ kansas: 0 })
                        }
                    } else {
                        this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
                        if (kansas == 0) {
                            this.setState({ kansas: 1, loading: true }, () => {
                                this.handleValidate()
                            })
                        } else {
                            this.setState({ kansas: 0 })
                        }
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        const handleText = (value, tableMeta, type) => {
            dataTable2[tableMeta.rowIndex][type] = value
            // console.log(dataTable2[tableMeta.rowIndex]);
        }
        const handleChange = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            if (type === "actual") {
                dataTable2[tableMeta.rowIndex][9] = Number(val).toFixed(1)
                console.log(dataTable2);
            } else {
                let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[tableMeta.rowIndex][2])
                if (indexParent > 0) {
                    // console.log(indexParent)
                    dataTable2[tableMeta.rowIndex][9] = Number(val).toFixed(1)
                    let jagain = Number(dataTable2[indexParent][9]).toFixed(1)
                    dataTable2[indexParent][9] = jagain === undefined ? (0 + Number(val)).toFixed(1) : Number(Number(jagain) + Number(val)).toFixed(1)
                    // if (tableMeta.rowData[5] === 'Cash & Bank Balance') {
                    //     console.log(value);
                    //     console.log(a);
                    //     console.log(jagain);
                    //     console.log(dataTable2[indexParent]);
                    // }
                } else {
                    dataTable2[tableMeta.rowIndex][9] = Number(val).toFixed(1)
                }
            }
            console.log(dataTable2);
        }

        const handleValue = (data, type) => {
            let total = 0
            dataTable2.map((item, index) => {
                // if (item[2] !== null) {
                if (data.rowData[1] === item[2]) {
                    // console.log(item[data.columnIndex + type])
                    let itemVal = item[data.columnIndex + type].value !== undefined ? Number(item[data.columnIndex + type].value) : Number(item[data.columnIndex + type])
                    total = item[data.columnIndex + type] === undefined ? Number(total) + 0 : Number(total) + itemVal
                }
                // }

            })
            let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[data.rowIndex][2])
            dataTable2[data.rowIndex][data.columnIndex + type] = Number(total).toFixed(1)
            // console.log(indexParent);
            return total
        }

        const handleVariance = (tableMeta, dex, type) => {
            let total = 0
            if (dex === 1) {
                total = Number(tableMeta.rowData[9]) - Number(tableMeta.rowData[10])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            } else if (dex === 2) {
                total = Number(tableMeta.rowData[9]) - Number(tableMeta.rowData[7])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            } else if (dex === 3) {
                total = Number(tableMeta.rowData[9]) - Number(tableMeta.rowData[8])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            }
            return total
        }

        const handleVariancePercent = (tableMeta, dex, type) => {
            let total = 0
            // if (tableMeta.rowData[5] === "Cash and cash equivalent") {
            //     console.log(dataTable2);
            //     console.log(tableMeta);
            // }
            if (dex === 1) {
                let selisih = Number(dataTable2[tableMeta.rowIndex][11])
                let prevMonth = Number(String(dataTable2[tableMeta.rowIndex][10]).includes('-') ? Number(dataTable2[tableMeta.rowIndex][10]) * -1 : dataTable2[tableMeta.rowIndex][10])
                total = R.equals(selisih / prevMonth, 0)
                    || R.equals(selisih / prevMonth, NaN)
                    || R.equals(selisih / prevMonth, Infinity)
                    || R.equals(selisih / prevMonth, -Infinity) ? 0 : (selisih / prevMonth) * 100

                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = String(selisih).includes('-') ? Number(total * -1).toFixed(1) : Number(total).toFixed(1)

                // total = String(selisih).includes('-')  && Number(tableMeta.rowData[9]) < Number(tableMeta.rowData[10])? Number(total * -1).toFixed(1) : Number(total).toFixed(1)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = total

                // total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][10])) * 100), NaN) ? '0' : R.equals(Number((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][10])) * 100), Infinity) ? '0' : Number((Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][10])) * 100 == "-Infinity" ? '0' : (Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][10])) * 100)
                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
                // if (tableMeta.rowData[5] === "Cash and cash equivalent") {
                // console.log(total);
                // console.log(Number(dataTable2[tableMeta.rowIndex][11]) / Number(dataTable2[tableMeta.rowIndex][10]));
                //     console.log(dataTable2[tableMeta.rowIndex]);
                // }
            } else if (dex === 2) {
                let selisih = Number(dataTable2[tableMeta.rowIndex][13])
                let prevMonth = Number(String(dataTable2[tableMeta.rowIndex][7]).includes('-') ? Number(dataTable2[tableMeta.rowIndex][7]) * -1 : dataTable2[tableMeta.rowIndex][7])
                total = R.equals(selisih / prevMonth, 0)
                    || R.equals(selisih / prevMonth, NaN)
                    || R.equals(selisih / prevMonth, Infinity)
                    || R.equals(selisih / prevMonth, -Infinity) ? 0 : (selisih / prevMonth) * 100

                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = String(selisih).includes('-') ? Number(total * -1).toFixed(1) : Number(total).toFixed(1)
                // total = String(selisih).includes('-') && Number(tableMeta.rowData[9]) < Number(tableMeta.rowData[7]) ? Number(total * -1).toFixed(1) : Number(total).toFixed(1)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = total
                // total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][7])) * 100), NaN) ? '0' : R.equals(Number((Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][7])) * 100), Infinity) ? '0' : Number((Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][7])) * 100 == "-Infinity" ? '0' : (Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][7])) * 100)
                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            } else if (dex === 3) {
                let selisih = Number(dataTable2[tableMeta.rowIndex][15])
                let prevMonth = Number(String(dataTable2[tableMeta.rowIndex][8]).includes('-') ? Number(dataTable2[tableMeta.rowIndex][8]) * -1 : dataTable2[tableMeta.rowIndex][8])
                total = R.equals(selisih / prevMonth, 0)
                    || R.equals(selisih / prevMonth, NaN)
                    || R.equals(selisih / prevMonth, Infinity)
                    || R.equals(selisih / prevMonth, -Infinity) ? 0 : (selisih / prevMonth) * 100

                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = String(selisih).includes('-') ? Number(total * -1).toFixed(1) : Number(total).toFixed(1)
                // total = String(selisih).includes('-') && Number(tableMeta.rowData[9]) < Number(tableMeta.rowData[8])? Number(total * -1).toFixed(1) : Number(total).toFixed(1)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = total
                // total = R.equals((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])), NaN) ? '0' : R.equals((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])), Infinity) ? "0" : Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])
                // total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100), NaN) ? '0' : R.equals(Number((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100), Infinity) ? '0' : Number((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100 == "-Infinity" ? '0' : (Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100)
                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
                // console.log(total);
            }
            return total
        }

        const handleValueFormula = (tableMeta, colIdx) => {
            // loading = true
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (items == ']') {
                        baru.push(String(item))
                    } else if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            // let indexID = dataTable2.findIndex((val) => val[21] == tst)
                            let data = tableMeta.rowData[20] == null ? [] : tableMeta.rowData[20]
                            let indexID = data.findIndex((val) => val.item_formula == String(`${item}`))
                            if (indexID !== -1) {
                                let valuezz = data[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            let data = tableMeta.rowData[20] == null ? [] : tableMeta.rowData[20]
                            let indexID = data.findIndex((val) => val.item_formula == String(`@${item}`))
                            if (indexID !== -1) {
                                // console.log(tableMeta)
                                let valuezz = data[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    } else {
                        if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let indexID = dataTable2.findIndex((val) => val[21] == tst)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][10]
                                if (item == dataTable2[tableMeta.rowIndex][21]) {
                                    anjay.push(0)
                                } else {
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        } else {
                            let indexID = dataTable2.findIndex((val) => val[21] == item)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][colIdx]
                                if (item == dataTable2[tableMeta.rowIndex][21]) {
                                    anjay.push(0)
                                } else {
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            } else {
                                if (item === '(-1)') {
                                    anjay.push(-1)
                                }
                            }
                        }
                    }
                }
            })

            let anjay2 = []
            let kurung = false
            let item1 = []
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                } else if (item == ")") {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            let optPrev = ""
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    optPrev = opt
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            if (optPrev == "tambah") {
                                total = Number(total) + Number(totalPrio)
                            } else if (optPrev == "kurang") {
                                total = Number(total) - Number(totalPrio)
                            } else if (optPrev == "kali") {
                                total = Number(total) * Number(totalPrio)
                            } else if (optPrev == "bagi") {
                                total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                            } else {
                                total += Number(totalPrio)
                            }
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            // // // total = R.equals(total, NaN) ? "0.0" : total
            // // // console.log(dataTable2[tableMeta.rowIndex][22])
            // // // console.log(tableMeta.rowData[5])
            // // if (tableMeta.rowData[5] == "1.5 Other non-current assets") {
            // // if (forecast !== undefined) {
            // //     if (String(tableMeta.rowData[5]) == "Depreciation & amortisation") {
            // console.log(splitFormula)
            // console.log(baru)
            // console.log(anjay)
            // console.log(anjay2)
            // console.log(total)
            // //         console.log(dataTable2[tableMeta.rowIndex])
            // //     }
            // // }

            // if (dataTable2[tableMeta.rowIndex][colIdx].value == undefined) {
            dataTable2[tableMeta.rowIndex][colIdx] = total
            // } else {
            //     dataTable2[tableMeta.rowIndex][column].value = total
            // }
            // loading = false
            return total
        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[0] === null ?
                                    tableMeta.rowData[4] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: `Rolling Outlook (FY${this.props.periode})`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#07a7d0', width: 96, borderLeft: '1px #fff solid', borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(val).toFixed(1)}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(val).toFixed(1)}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: `Month To Date (MTD)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 40 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Master Budget (MB)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Rolling Budget (RB)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Actual"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                null :
                                                // this.state.get_for == 'view'?
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                />
                                                // :
                                                // tableMeta.rowData[0] === 2 ?
                                                //     <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //         <NumberFormat
                                                //             thousandSeparator={true}
                                                //             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                //             type="text"
                                                //             placeholder=""
                                                //             disabled={true}
                                                //             value={Number(handleValue(tableMeta, 0)).toFixed(1)}
                                                //         />
                                                //     </span> :
                                                //     tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                //         <div style={{ flex: 1 }}>
                                                //             <FormControlLabel
                                                //                 style={{ margin: 0 }}
                                                //                 value={val}
                                                //                 control={
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(handleValueFormula(tableMeta, 7)).toFixed(1)}
                                                //                     />
                                                //                 }
                                                //             />
                                                //         </div> :
                                                // tableMeta.rowData[0] === 7 ?
                                                //     (Number(handleValueFormula(tableMeta, 7)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 7)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //         <NumberFormat
                                                //             thousandSeparator={true}
                                                //             style={{
                                                //                 fontSize: 12,
                                                //                 textAlign: 'right',
                                                //                 borderColor: 'transparent',
                                                //                 margin: 0,
                                                //                 width: 96,
                                                //                 backgroundColor: 'transparent'
                                                //             }}
                                                //             type="text"
                                                //             placeholder=""
                                                //             disabled={true}
                                                //             value={Number(handleValueFormula(tableMeta, 7)).toFixed(1)}
                                                //         /> :
                                                //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //             <NumberFormat
                                                //                 thousandSeparator={true}
                                                //                 style={{
                                                //                     fontSize: 12,
                                                //                     textAlign: 'right',
                                                //                     borderColor: 'transparent',
                                                //                     margin: 0,
                                                //                     width: 96,
                                                //                     backgroundColor: 'transparent',
                                                //                     color: 'red'
                                                //                 }}
                                                //                 type="text"
                                                //                 placeholder=""
                                                //                 disabled={true}
                                                //                 value={Number(handleValueFormula(tableMeta, 7)).toFixed(1)}
                                                //             />
                                                //         </LightTooltip>
                                                //         :
                                                // <div style={{ flex: 1 }}>
                                                //     <FormControlLabel
                                                //         style={{ margin: 0 }}
                                                //         value={val}
                                                //         control={
                                                //             <NumberFormat
                                                //                 thousandSeparator={true}
                                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                //                 type="text"
                                                //                 placeholder=""
                                                //                 disabled={true}
                                                //                 value={Number(tableMeta.rowData[7]).toFixed(1)}
                                                //             />
                                                //         }
                                                //     />
                                                // </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                null :
                                                // this.state.get_for == 'view'?
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                />
                                                // :
                                                // tableMeta.rowData[0] === 2 ?
                                                //     <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                //         <NumberFormat
                                                //             thousandSeparator={true}
                                                //             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                //             type="text"
                                                //             placeholder=""
                                                //             disabled={true}
                                                //             value={Number(handleValue(tableMeta, 1)).toFixed(1)}
                                                //         />
                                                //     </span> :
                                                //     tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                //         <div style={{ flex: 1 }}>
                                                //             <FormControlLabel
                                                //                 style={{ margin: 0 }}
                                                //                 value={val}
                                                //                 control={
                                                //                     <NumberFormat
                                                //                         thousandSeparator={true}
                                                //                         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                //                         type="text"
                                                //                         placeholder=""
                                                //                         disabled={true}
                                                //                         value={Number(handleValueFormula(tableMeta, 8)).toFixed(1)}
                                                //                     />
                                                //                 }
                                                //             />
                                                //         </div> :
                                                // tableMeta.rowData[0] === 7 ?
                                                //     (Number(handleValueFormula(tableMeta, 8)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 8)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                //         <NumberFormat
                                                //             thousandSeparator={true}
                                                //             style={{
                                                //                 fontSize: 12,
                                                //                 textAlign: 'right',
                                                //                 borderColor: 'transparent',
                                                //                 margin: 0,
                                                //                 width: 96,
                                                //                 backgroundColor: 'transparent'
                                                //             }}
                                                //             type="text"
                                                //             placeholder=""
                                                //             disabled={true}
                                                //             value={Number(handleValueFormula(tableMeta, 8)).toFixed(1)}
                                                //         /> :
                                                //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                //             <NumberFormat
                                                //                 thousandSeparator={true}
                                                //                 style={{
                                                //                     fontSize: 12,
                                                //                     textAlign: 'right',
                                                //                     borderColor: 'transparent',
                                                //                     margin: 0,
                                                //                     width: 96,
                                                //                     backgroundColor: 'transparent',
                                                //                     color: 'red'
                                                //                 }}
                                                //                 type="text"
                                                //                 placeholder=""
                                                //                 disabled={true}
                                                //                 value={Number(handleValueFormula(tableMeta, 8)).toFixed(1)}
                                                //             />
                                                //         </LightTooltip>
                                                //         :
                                                // <div style={{ flex: 1 }}>
                                                //     <FormControlLabel
                                                //         style={{ margin: 0 }}
                                                //         value={val}
                                                //         control={
                                                //             <NumberFormat
                                                //                 thousandSeparator={true}
                                                //                 style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                //                 type="text"
                                                //                 placeholder=""
                                                //                 disabled={true}
                                                //                 value={Number(tableMeta.rowData[8]).toFixed(1)}
                                                //             />
                                                //         }
                                                //     />
                                                // </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.isApprover || this.state.get_for == 'view' ? 'black' : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                        value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                                        onBlur={(event) => {
                                                                            handleChange(event.target.value, tableMeta)
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: String(tableMeta.rowData[5]).toLocaleLowerCase() == "r/e (cummulative)" && this.props.periode == 2021 && this.props.month.month_id == 1 ? "#5198ea" : "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={String(tableMeta.rowData[5]).toLocaleLowerCase() == "r/e (cummulative)" && this.props.periode == 2021 && this.props.month.month_id == 1 ? false : true}
                                                                            value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "r/e (cummulative)" && this.props.periode == 2021 && this.props.month.month_id == 1 ? Number(tableMeta.rowData[9]).toFixed(1) : Number(handleValueFormula(tableMeta, 9)).toFixed(1)}
                                                                            onBlur={(event) => {
                                                                                handleChange(event.target.value, tableMeta)
                                                                            }}
                                                                        />
                                                                    }
                                                                />
                                                            </div> :
                                                            tableMeta.rowData[0] === 2 ?
                                                                <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(handleValue(tableMeta, 2)).toFixed(1)}
                                                                    />
                                                                </span> :
                                                                tableMeta.rowData[0] === 7 ?
                                                                    (Number(handleValueFormula(tableMeta, 9)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 9)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleValueFormula(tableMeta, 9)).toFixed(1)}
                                                                        /> :
                                                                        <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'red'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={Number(handleValueFormula(tableMeta, 9)).toFixed(1)}
                                                                            />
                                                                        </LightTooltip>
                                                                    :
                                                                    <div style={{ flex: 1 }}>
                                                                        <FormControlLabel
                                                                            style={{ margin: 0 }}
                                                                            value={val}
                                                                            control={
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={Number(tableMeta.rowData[9]).toFixed(1)}
                                                                                />
                                                                            }
                                                                        />
                                                                    </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "Actual Previous Month",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={Number(tableMeta.rowData[10]).toFixed(1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={Number(handleValue(tableMeta, 2)).toFixed(1)}
                                                />
                                            </span> :
                                            // tableMeta.rowData[0] === 7 ?
                                            //     (Number(handleValueFormula(tableMeta, 10)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 10)).toFixed(1) <= Number(this.state.maxValue)) ?
                                            //         <NumberFormat
                                            //             thousandSeparator={true}
                                            //             style={{
                                            //                 fontSize: 12,
                                            //                 textAlign: 'right',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 0,
                                            //                 width: 96,
                                            //                 backgroundColor: 'transparent'
                                            //             }}
                                            //             type="text"
                                            //             placeholder=""
                                            //             disabled={true}
                                            //             value={Number(handleValueFormula(tableMeta, 10)).toFixed(1)}
                                            //         /> :
                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                            //             <NumberFormat
                                            //                 thousandSeparator={true}
                                            //                 style={{
                                            //                     fontSize: 12,
                                            //                     textAlign: 'right',
                                            //                     borderColor: 'transparent',
                                            //                     margin: 0,
                                            //                     width: 96,
                                            //                     backgroundColor: 'transparent',
                                            //                     color: 'red'
                                            //                 }}
                                            //                 type="text"
                                            //                 placeholder=""
                                            //                 disabled={true}
                                            //                 value={Number(handleValueFormula(tableMeta, 10)).toFixed(1)}
                                            //             />
                                            //         </LightTooltip>
                                            //         :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={val}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[10]).toFixed(1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: `Variance`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 40 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                        <span>{"Act vs Previous Month"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#07a7d0' }}>
                                    <div style={{ borderBottom: '1px #fff solid' }}>
                                        <span>{"Act vs MB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#07a7d0' }}>
                                    <div style={{ borderBottom: '1px #fff solid' }}>
                                        <span>{"Act vs RB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 10
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="column-1">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[11]).toFixed(1)}
                                                            />
                                                            :
                                                            // tableMeta.rowData[0] === 7 ?
                                                            //     (Number(handleValueFormula(tableMeta, 11)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 11)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                            //         <NumberFormat
                                                            //             thousandSeparator={true}
                                                            //             style={{
                                                            //                 fontSize: 12,
                                                            //                 textAlign: 'right',
                                                            //                 borderColor: 'transparent',
                                                            //                 margin: 0,
                                                            //                 width: 96,
                                                            //                 backgroundColor: 'transparent'
                                                            //             }}
                                                            //             type="text"
                                                            //             placeholder=""
                                                            //             disabled={true}
                                                            //             value={Number(handleValueFormula(tableMeta, 11)).toFixed(1)}
                                                            //         /> :
                                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                            //             <NumberFormat
                                                            //                 thousandSeparator={true}
                                                            //                 style={{
                                                            //                     fontSize: 12,
                                                            //                     textAlign: 'right',
                                                            //                     borderColor: 'transparent',
                                                            //                     margin: 0,
                                                            //                     width: 96,
                                                            //                     backgroundColor: 'transparent',
                                                            //                     color: 'red'
                                                            //                 }}
                                                            //                 type="text"
                                                            //                 placeholder=""
                                                            //                 disabled={true}
                                                            //                 value={Number(handleValueFormula(tableMeta, 11)).toFixed(1)}
                                                            //             />
                                                            //         </LightTooltip>
                                                            //         :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleVariance(tableMeta, 1, 2)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[12]).toFixed(1)}
                                                            />
                                                            // :
                                                            // tableMeta.rowData[0] === 7 ?
                                                            //     (Number(handleValueFormula(tableMeta, 12)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 12)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                            //         <NumberFormat
                                                            //             thousandSeparator={true}
                                                            //             style={{
                                                            //                 fontSize: 12,
                                                            //                 textAlign: 'right',
                                                            //                 borderColor: 'transparent',
                                                            //                 margin: 0,
                                                            //                 width: 96,
                                                            //                 backgroundColor: 'transparent'
                                                            //             }}
                                                            //             type="text"
                                                            //             placeholder=""
                                                            //             disabled={true}
                                                            //             value={Number(handleValueFormula(tableMeta, 12)).toFixed(1)}
                                                            //         /> :
                                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                            //             <NumberFormat
                                                            //                 thousandSeparator={true}
                                                            //                 style={{
                                                            //                     fontSize: 12,
                                                            //                     textAlign: 'right',
                                                            //                     borderColor: 'transparent',
                                                            //                     margin: 0,
                                                            //                     width: 96,
                                                            //                     backgroundColor: 'transparent',
                                                            //                     color: 'red'
                                                            //                 }}
                                                            //                 type="text"
                                                            //                 placeholder=""
                                                            //                 disabled={true}
                                                            //                 value={Number(handleValueFormula(tableMeta, 12)).toFixed(1)}
                                                            //             />
                                                            //         </LightTooltip>
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: Number(tableMeta.rowData[12]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[12]).toFixed(1) > this.state.maxValue ? 'red' : 'black', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            suffix={'%'}
                                                                            disabled={true}
                                                                            value={Number(handleVariancePercent(tableMeta, 1, 3)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="column-2">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[13]).toFixed(1)}
                                                            />
                                                            // :
                                                            // tableMeta.rowData[0] === 7 ?
                                                            //     (Number(handleValueFormula(tableMeta, 13)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 13)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                            //         <NumberFormat
                                                            //             thousandSeparator={true}
                                                            //             style={{
                                                            //                 fontSize: 12,
                                                            //                 textAlign: 'right',
                                                            //                 borderColor: 'transparent',
                                                            //                 margin: 0,
                                                            //                 width: 96,
                                                            //                 backgroundColor: 'transparent'
                                                            //             }}
                                                            //             type="text"
                                                            //             placeholder=""
                                                            //             disabled={true}
                                                            //             value={Number(handleValueFormula(tableMeta, 13)).toFixed(1)}
                                                            //         /> :
                                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                            //             <NumberFormat
                                                            //                 thousandSeparator={true}
                                                            //                 style={{
                                                            //                     fontSize: 12,
                                                            //                     textAlign: 'right',
                                                            //                     borderColor: 'transparent',
                                                            //                     margin: 0,
                                                            //                     width: 96,
                                                            //                     backgroundColor: 'transparent',
                                                            //                     color: 'red'
                                                            //                 }}
                                                            //                 type="text"
                                                            //                 placeholder=""
                                                            //                 disabled={true}
                                                            //                 value={Number(handleValueFormula(tableMeta, 13)).toFixed(1)}
                                                            //             />
                                                            //         </LightTooltip>
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleVariance(tableMeta, 2, 4)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[14]).toFixed(1)}
                                                            />
                                                            :
                                                            // tableMeta.rowData[0] === 7 ?
                                                            //     (Number(handleValueFormula(tableMeta, 14)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 14)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                            //         <NumberFormat
                                                            //             thousandSeparator={true}
                                                            //             style={{
                                                            //                 fontSize: 12,
                                                            //                 textAlign: 'right',
                                                            //                 borderColor: 'transparent',
                                                            //                 margin: 0,
                                                            //                 width: 96,
                                                            //                 backgroundColor: 'transparent'
                                                            //             }}
                                                            //             type="text"
                                                            //             placeholder=""
                                                            //             disabled={true}
                                                            //             value={Number(handleValueFormula(tableMeta, 14)).toFixed(1)}
                                                            //         /> :
                                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                            //             <NumberFormat
                                                            //                 thousandSeparator={true}
                                                            //                 style={{
                                                            //                     fontSize: 12,
                                                            //                     textAlign: 'right',
                                                            //                     borderColor: 'transparent',
                                                            //                     margin: 0,
                                                            //                     width: 96,
                                                            //                     backgroundColor: 'transparent',
                                                            //                     color: 'red'
                                                            //                 }}
                                                            //                 type="text"
                                                            //                 placeholder=""
                                                            //                 disabled={true}
                                                            //                 value={Number(handleValueFormula(tableMeta, 14)).toFixed(1)}
                                                            //             />
                                                            //         </LightTooltip>
                                                            //         :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: Number(tableMeta.rowData[14]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[14]).toFixed(1) > this.state.maxValue ? 'red' : 'black', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            suffix={'%'}
                                                                            value={Number(handleVariancePercent(tableMeta, 2, 5)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="column-3">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[15]).toFixed(1)}
                                                            />
                                                            :
                                                            // tableMeta.rowData[0] === 7 ?
                                                            //     (Number(handleValueFormula(tableMeta, 15)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 15)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                            //         <NumberFormat
                                                            //             thousandSeparator={true}
                                                            //             style={{
                                                            //                 fontSize: 12,
                                                            //                 textAlign: 'right',
                                                            //                 borderColor: 'transparent',
                                                            //                 margin: 0,
                                                            //                 width: 96,
                                                            //                 backgroundColor: 'transparent'
                                                            //             }}
                                                            //             type="text"
                                                            //             placeholder=""
                                                            //             disabled={true}
                                                            //             value={Number(handleValueFormula(tableMeta, 15)).toFixed(1)}
                                                            //         /> :
                                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                            //             <NumberFormat
                                                            //                 thousandSeparator={true}
                                                            //                 style={{
                                                            //                     fontSize: 12,
                                                            //                     textAlign: 'right',
                                                            //                     borderColor: 'transparent',
                                                            //                     margin: 0,
                                                            //                     width: 96,
                                                            //                     backgroundColor: 'transparent',
                                                            //                     color: 'red'
                                                            //                 }}
                                                            //                 type="text"
                                                            //                 placeholder=""
                                                            //                 disabled={true}
                                                            //                 value={Number(handleValueFormula(tableMeta, 15)).toFixed(1)}
                                                            //             />
                                                            //         </LightTooltip>
                                                            //         :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleVariance(tableMeta, 3, 6)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 7 ?
                                                        null :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                suffix={'%'}
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(tableMeta.rowData[16]).toFixed(1)}
                                                            />
                                                            :
                                                            // tableMeta.rowData[0] === 7 ?
                                                            //     (Number(handleValueFormula(tableMeta, 16)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 16)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                            //         <NumberFormat
                                                            //             thousandSeparator={true}
                                                            //             style={{
                                                            //                 fontSize: 12,
                                                            //                 textAlign: 'right',
                                                            //                 borderColor: 'transparent',
                                                            //                 margin: 0,
                                                            //                 width: 96,
                                                            //                 backgroundColor: 'transparent'
                                                            //             }}
                                                            //             type="text"
                                                            //             placeholder=""
                                                            //             disabled={true}
                                                            //             value={Number(handleValueFormula(tableMeta, 16)).toFixed(1)}
                                                            //         /> :
                                                            //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                            //             <NumberFormat
                                                            //                 thousandSeparator={true}
                                                            //                 style={{
                                                            //                     fontSize: 12,
                                                            //                     textAlign: 'right',
                                                            //                     borderColor: 'transparent',
                                                            //                     margin: 0,
                                                            //                     width: 96,
                                                            //                     backgroundColor: 'transparent',
                                                            //                     color: 'red'
                                                            //                 }}
                                                            //                 type="text"
                                                            //                 placeholder=""
                                                            //                 disabled={true}
                                                            //                 value={Number(handleValueFormula(tableMeta, 16)).toFixed(1)}
                                                            //             />
                                                            //         </LightTooltip>
                                                            //         :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: Number(tableMeta.rowData[16]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[16]).toFixed(1) > this.state.maxValue ? 'red' : 'black', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            suffix={'%'}
                                                                            value={Number(handleVariancePercent(tableMeta, 3, 7)).toFixed(1)}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: `MTD Explanation`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 40 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs Prev Month"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs MB"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs RB"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] !== 3 ?
                                                    null :
                                                    (this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            // disabled={Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? false : true}
                                                            disabled={true}
                                                            multiline={true}
                                                            defaultValue={tableMeta.rowData[17]}
                                                            inputProps={{
                                                                style: {
                                                                    color: 'black',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={value}
                                                            control={
                                                                // tableMeta.rowData[17] === "" && (Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue) ?
                                                                //     <LightTooltip title={"MTD Explanation vs Prev Month is Reqiured"} arrow>
                                                                //         <Input
                                                                //             disableUnderline={true}
                                                                //             style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                //             type="text"
                                                                //             placeholder=""
                                                                //             disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                //             // disabled={false}
                                                                //             multiline={true}
                                                                //             defaultValue={tableMeta.rowData[17]}
                                                                //             inputProps={{
                                                                //                 style: {
                                                                //                     color: "#5198ea",
                                                                //                     textAlign: 'left',
                                                                //                     backgroundColor: '#ffac99'
                                                                //                 }
                                                                //             }}
                                                                //             onBlur={(event) => {
                                                                //                 handleText(event.target.value, tableMeta, 17)
                                                                //             }}
                                                                //         />
                                                                //     </LightTooltip>
                                                                //     :
                                                                // tableMeta.rowData[0] === 7 ?
                                                                //     (Number(handleValueFormula(tableMeta, 17)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 17)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                //         <NumberFormat
                                                                //             thousandSeparator={true}
                                                                //             style={{
                                                                //                 fontSize: 12,
                                                                //                 textAlign: 'right',
                                                                //                 borderColor: 'transparent',
                                                                //                 margin: 0,
                                                                //                 width: 96,
                                                                //                 backgroundColor: 'transparent'
                                                                //             }}
                                                                //             type="text"
                                                                //             placeholder=""
                                                                //             disabled={true}
                                                                //             value={Number(handleValueFormula(tableMeta, 17)).toFixed(1)}
                                                                //         /> :
                                                                //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                //             <NumberFormat
                                                                //                 thousandSeparator={true}
                                                                //                 style={{
                                                                //                     fontSize: 12,
                                                                //                     textAlign: 'right',
                                                                //                     borderColor: 'transparent',
                                                                //                     margin: 0,
                                                                //                     width: 96,
                                                                //                     backgroundColor: 'transparent',
                                                                //                     color: 'red'
                                                                //                 }}
                                                                //                 type="text"
                                                                //                 placeholder=""
                                                                //                 disabled={true}
                                                                //                 value={Number(handleValueFormula(tableMeta, 17)).toFixed(1)}
                                                                //             />
                                                                //         </LightTooltip>
                                                                //         :
                                                                <Input
                                                                    disableUnderline={true}
                                                                    style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    // disabled={Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? false : true}
                                                                    disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                    multiline={true}
                                                                    defaultValue={tableMeta.rowData[17]}
                                                                    inputProps={{
                                                                        style: {
                                                                            color: Number(tableMeta.rowData[12]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[12]).toFixed(1) > this.state.maxValue ? "#5198ea" : '#5198ea',
                                                                            textAlign: 'left'
                                                                        }
                                                                    }}
                                                                    onBlur={(event) => {
                                                                        handleText(event.target.value, tableMeta, 17)
                                                                    }}
                                                                />
                                                            }
                                                        />)}
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] !== 3 ? null :
                                                    (this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            // disabled={Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? false : true}
                                                            disabled={true}
                                                            multiline={true}
                                                            defaultValue={tableMeta.rowData[18]}
                                                            inputProps={{
                                                                style: {
                                                                    color: 'black',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={value}
                                                            control={
                                                                tableMeta.rowData[18] === "" && (Number(tableMeta.rowData[14]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[14]).toFixed(1) > this.state.maxValue) ?
                                                                    <LightTooltip title={"MTD Explanation vs MB is Reqiured"} arrow>
                                                                        <Input
                                                                            disableUnderline={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', minHeight: 30, padding: 0 }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            multiline={true}
                                                                            // disabled={false}
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            defaultValue={tableMeta.rowData[18]}
                                                                            inputProps={{
                                                                                style: {
                                                                                    color: "#5198ea",
                                                                                    textAlign: 'left',
                                                                                    backgroundColor: '#ffac99',
                                                                                    minHeight: 30,
                                                                                    padding: 0
                                                                                }
                                                                            }}
                                                                            onBlur={(event) => {
                                                                                handleText(event.target.value, tableMeta, 18)
                                                                            }}
                                                                        />
                                                                    </LightTooltip>
                                                                    :
                                                                    // tableMeta.rowData[0] === 7 ?
                                                                    //     (Number(handleValueFormula(tableMeta, 18)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 18)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                    //         <NumberFormat
                                                                    //             thousandSeparator={true}
                                                                    //             style={{
                                                                    //                 fontSize: 12,
                                                                    //                 textAlign: 'right',
                                                                    //                 borderColor: 'transparent',
                                                                    //                 margin: 0,
                                                                    //                 width: 96,
                                                                    //                 backgroundColor: 'transparent'
                                                                    //             }}
                                                                    //             type="text"
                                                                    //             placeholder=""
                                                                    //             disabled={true}
                                                                    //             value={Number(handleValueFormula(tableMeta, 18)).toFixed(1)}
                                                                    //         /> :
                                                                    //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    //             <NumberFormat
                                                                    //                 thousandSeparator={true}
                                                                    //                 style={{
                                                                    //                     fontSize: 12,
                                                                    //                     textAlign: 'right',
                                                                    //                     borderColor: 'transparent',
                                                                    //                     margin: 0,
                                                                    //                     width: 96,
                                                                    //                     backgroundColor: 'transparent',
                                                                    //                     color: 'red'
                                                                    //                 }}
                                                                    //                 type="text"
                                                                    //                 placeholder=""
                                                                    //                 disabled={true}
                                                                    //                 value={Number(handleValueFormula(tableMeta, 18)).toFixed(1)}
                                                                    //             />
                                                                    //         </LightTooltip>
                                                                    //         :
                                                                    <Input
                                                                        disableUnderline={true}
                                                                        style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        multiline={true}
                                                                        placeholder=""
                                                                        // disabled={Number(tableMeta.rowData[14]) < this.state.minValue || Number(tableMeta.rowData[14]) > this.state.maxValue ? false : true}
                                                                        disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                        defaultValue={tableMeta.rowData[18]}
                                                                        inputProps={{
                                                                            style: {
                                                                                color: Number(tableMeta.rowData[14]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[14]).toFixed(1) > this.state.maxValue ? "#5198ea" : '#5198ea',
                                                                                textAlign: 'left'
                                                                            }
                                                                        }}
                                                                        onBlur={(event) => {
                                                                            handleText(event.target.value, tableMeta, 18)
                                                                        }}
                                                                    />
                                                            }
                                                        />)}
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] !== 3 ? null :
                                                    (this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            // disabled={Number(tableMeta.rowData[12]) < this.state.minValue || Number(tableMeta.rowData[12]) > this.state.maxValue ? false : true}
                                                            disabled={true}
                                                            multiline={true}
                                                            defaultValue={tableMeta.rowData[19]}
                                                            inputProps={{
                                                                style: {
                                                                    color: 'black',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={value}
                                                            control={
                                                                // tableMeta.rowData[19] === "" && (Number(tableMeta.rowData[16]) < this.state.minValue || Number(tableMeta.rowData[16]) > this.state.maxValue) ?
                                                                //     <LightTooltip title={"MTD Explanation vs RB is Reqiured"} arrow>
                                                                //         <Input
                                                                //             disableUnderline={true}
                                                                //             style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                //             type="text"
                                                                //             multiline={true}
                                                                //             placeholder=""
                                                                //             // disabled={false}
                                                                //             disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                //             defaultValue={tableMeta.rowData[19]}
                                                                //             inputProps={{
                                                                //                 style: {
                                                                //                     color: "#5198ea",
                                                                //                     textAlign: 'left',
                                                                //                     backgroundColor: '#ffac99'
                                                                //                 }
                                                                //             }}
                                                                //             onBlur={(event) => {
                                                                //                 handleText(event.target.value, tableMeta, 19)
                                                                //             }}
                                                                //         />
                                                                //     </LightTooltip>
                                                                //     :
                                                                // tableMeta.rowData[0] === 7 ?
                                                                //     (Number(handleValueFormula(tableMeta, 19)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(tableMeta, 19)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                //         <NumberFormat
                                                                //             thousandSeparator={true}
                                                                //             style={{
                                                                //                 fontSize: 12,
                                                                //                 textAlign: 'right',
                                                                //                 borderColor: 'transparent',
                                                                //                 margin: 0,
                                                                //                 width: 96,
                                                                //                 backgroundColor: 'transparent'
                                                                //             }}
                                                                //             type="text"
                                                                //             placeholder=""
                                                                //             disabled={true}
                                                                //             value={Number(handleValueFormula(tableMeta, 19)).toFixed(1)}
                                                                //         /> :
                                                                //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[23]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                //             <NumberFormat
                                                                //                 thousandSeparator={true}
                                                                //                 style={{
                                                                //                     fontSize: 12,
                                                                //                     textAlign: 'right',
                                                                //                     borderColor: 'transparent',
                                                                //                     margin: 0,
                                                                //                     width: 96,
                                                                //                     backgroundColor: 'transparent',
                                                                //                     color: 'red'
                                                                //                 }}
                                                                //                 type="text"
                                                                //                 placeholder=""
                                                                //                 disabled={true}
                                                                //                 value={Number(handleValueFormula(tableMeta, 19)).toFixed(1)}
                                                                //             />
                                                                //         </LightTooltip>
                                                                //         :
                                                                <Input
                                                                    disableUnderline={true}
                                                                    style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    multiline={true}
                                                                    placeholder=""
                                                                    // disabled={Number(tableMeta.rowData[16]) < this.state.minValue || Number(tableMeta.rowData[16]) > this.state.maxValue ? false : true}
                                                                    disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                    defaultValue={tableMeta.rowData[19]}
                                                                    inputProps={{
                                                                        style: {
                                                                            color: Number(tableMeta.rowData[16]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[16]).toFixed(1) > this.state.maxValue ? "#5198ea" : '#5198ea',
                                                                            textAlign: 'left'
                                                                        }
                                                                    }}
                                                                    onBlur={(event) => {
                                                                        handleText(event.target.value, tableMeta, 19)
                                                                    }}
                                                                />
                                                            }
                                                        />)}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            }, {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                {this.state.loading && loadingComponent}
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleBSMR ? <Paper style={{ paddingTop: 10 }}>
                        <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                            <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Balance Sheet</Typography>
                        </div>
                        <div style={{ padding: 20 }}>
                            <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                </div>
                                <div style={{ width: '50%' }}>
                                    {this.props.isApprover === true || this.state.get_for == 'view' ?
                                        null
                                        // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                        //     <a data-tip={'Download'} data-for="download">
                                        //         <button
                                        //             style={{
                                        //                 backgroundColor: 'transparent',
                                        //                 cursor: 'pointer',
                                        //                 borderColor: 'transparent',
                                        //                 margin: 5
                                        //             }}
                                        //             onClick={() =>
                                        //                 this.setState({ loading: true }, () => {
                                        //                     setTimeout(() => {
                                        //                         this.downloadAllData()
                                        //                     }, 100);
                                        //                 })}
                                        //         >
                                        //             <img src={Images.download} />
                                        //         </button>
                                        //     </a>
                                        //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                        // </div> 
                                        :
                                        <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            <a data-tip={'Download Template'} data-for="template">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.downloadTemplate()}
                                                >
                                                    <img src={Images.template} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                            <a data-tip={'Upload'} data-for="upload">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.setState({ visibleUpload: true })}
                                                >
                                                    <img src={Images.upload} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                            {/* <a data-tip={'Download'} data-for="download">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() =>
                                                        this.setState({ loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.downloadAllData()
                                                            }, 100);
                                                        })}
                                                >
                                                    <img src={Images.download} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                        </div>
                                    }
                                </div>
                            </div>

                            <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                {!this.state.loading && (
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                )}
                            </div>

                            <div style={{ display: 'flex' }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                    {
                                        this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                            return (
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                            )
                                        }) :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                    }
                                </div>
                            </div>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Notes : {this.state.notes}</Typography>

                            <div style={{ display: 'flex', maxWidth: '100%', paddingRight: 15 }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, textDecorationLine: 'underline' }}>Notes:</Typography>
                            </div>
                            <div style={{ display: 'flex', maxWidth: '100%', paddingRight: 15 }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, fontWeight: 'bold' }}>Rolling Outlook (Full Year) or Rolling Budget (RB)</Typography>
                            </div>
                            <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Jan-Mar = MB figures</Typography>
                            </div>
                            <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Apr-Jun = OL Q1 figures or MB figures (if OL Q1 not available)</Typography>
                            </div>
                            <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Jul-Sep = OL Q2 figures or OL Q1 (if OL Q2 not available) or MB (if OL Q2 and OL Q1 not available)</Typography>
                            </div>
                            <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Oct-Dec = OL Q3 figures or OL Q2 (if OL Q3 not available) and consecutive to the MB</Typography>
                            </div>

                        </div>
                        {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}
                        <div className="grid grid-2x" style={{ padding: 20 }}>
                            <div className="col-1" style={{ paddingLeft: 0 }}>
                                <button
                                    type="button"
                                    onClick={() => this.setState({ loading: true }, () => {
                                        setTimeout(() => {
                                            this.props.onClickClose()
                                        }, 100);
                                    })}
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: 'pointer',
                                        borderColor: 'transparent',
                                        outline: 'none',
                                    }}
                                >
                                    <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                        <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                    </div>
                                </button>
                            </div>
                            {this.props.isApprover === true ?
                                <div className="col-2">
                                </div> :
                                <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                    {this.state.get_for == 'view' && this.state.viewOnly && <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => {
                                            this.setState({ loading: true }, () => {
                                                this.handleGetFor('edit')
                                            })
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for == 'edit' && <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => {
                                            this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                setTimeout(() => {
                                                    this.handleValidate()
                                                }, 100);
                                            })
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for === 'edit' && <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() =>
                                            this.state.saveDraft ?
                                                this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        this.backToMonthlyReport('draft')
                                                    })
                                        }
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for === 'edit' && <button
                                        type="button"
                                        // disabled={this.state.buttonError}
                                        onClick={() =>
                                            this.state.buttonError ?
                                                this.setState({ alert: true, messageAlert: 'Data incomplete !', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1 }, () => {
                                                        this.backToMonthlyReport('submitted')
                                                    })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>}
                                </div>
                            }
                        </div>
                        {/* : null
                            } */}
                    </Paper> :
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Balance Sheet</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                </div>
                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.dataLoaded && !this.state.loading && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 10, padding: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true, visibleBSMR: true }, () => {
                                            setTimeout(() => {
                                                this.getItemHierarki()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => {
                                            this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                setTimeout(() => {
                                                    this.handleValidate()
                                                }, 100);
                                            })
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() =>
                                            this.state.saveDraft === true ?
                                                this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1 }, () => {
                                                        this.uploadBalanceSheet('draft')
                                                    })
                                        }
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>
                                    <button
                                        type="button"
                                        // disabled={this.state.buttonError}
                                        onClick={() =>
                                            this.state.buttonError ?
                                                this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1 }, () => {
                                                        this.uploadBalanceSheet('submitted')
                                                    })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </Paper>
                    }
                </div>
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => {
                                    String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") && String(this.state.judul).includes("BALANCE") && String(this.state.judul).includes("SHEET") ?
                                        this.checkUpload() :
                                        this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                }}
                            />
                        </div>
                    </div>
                )}
            </div>
        )
    }
}
