import React, { Component } from "react";
import { Container, Row, Col } from "react-bootstrap";
import { makeStyles, createMuiTheme, MuiThemeProvider } from '@material-ui/core/styles';
import SearchIcon from '@material-ui/icons/Search';
import Images from "../../../assets/Images";
import UploadFile from "../../../library/Upload";
import MUIDataTable from "mui-datatables";
import CreateUnitBisnis from "./CreateUnitBisnis";
import ReactTooltip from 'react-tooltip';
import MuiAlert from '@material-ui/lab/Alert';
import { TextField, InputBase, Snackbar, withStyles, LinearProgress, Tooltip } from "@material-ui/core";
import { ExcelRenderer } from 'react-excel-renderer';
import api from "../../../api";
import { isThisSecond } from "date-fns";
import PopUpFailedSave from "../../../library/PopUpFailedSave";
import PopUpDelete from "../../../library/PopUpDelete";
import Constant from "../../../library/Constant";
import { css } from "@emotion/core";
import PropagateLoader from "react-spinners/PropagateLoader"

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable());
const options = ct.customOptions();
const options2 = ct.customOptions2();

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class UnitBisnis extends Component {
    constructor(props) {
        super(props)
        this.state = {
            visibleCreate: false,
            visibleEdit: false,
            visibleDelete: false,
            dataTable: [],
            listData: [],
            data: [],
            search: "",
            visibleUnitBisnis: true,
            cols: null,
            rows: null,
            dataLoaded: false,
            popupError: false,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            create: false,
            edit: false,
            delete: false,
            load: false,
            judul: '',
            rowData: [],
            unitBisnisName: '',
            // visibleLoad: true,
            loading: false,
            sizeUpload: "1"
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                console.log(isi);
                let payload = []
                isi.map((item, index) => {
                    if (item.length > 0) {
                        payload.push({
                            id: index + 1,
                            business_unit_name: item[0] === undefined ? "" : item[0],
                            start_date: item[1] == undefined ? "" : item[1],
                            end_date: item[2] === undefined ? "" : item[2],
                        })
                    }
                })
                let body = {
                    business_unit: payload
                }
                console.log(resp.rows[1])
                this.setState({ payload: body, buttonError: false, judul: resp.rows[1][0] })
            }
        });
    }

    checkUpload() {
        api.create().checkUploadUnitBisnis(this.state.payload).then(response => {
            // console.log(response)
            let dataRow = []
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        dataRow = response.data.data.map((item, index) => {
                            return [
                                item.business_unit_name,
                                item.start_date,
                                item.end_date,
                                item.error
                            ]
                        })
                        let columns = [
                            {
                                name: "Business Unit",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[3] != null) {
                                            check = tableMeta.rowData[3].findIndex((val) => val.field.includes('business_unit_name'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[3] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[3][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid From",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[3] != null) {
                                            check = tableMeta.rowData[3].findIndex((val) => val.field.includes('start_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[3] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[3][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "Valid To",
                                options: {
                                    customBodyRender: (val, tableMeta) => {
                                        let check = null
                                        if (tableMeta.rowData[3] != null) {
                                            check = tableMeta.rowData[3].findIndex((val) => val.field.includes('end_date'))
                                            if (check > -1) {
                                                this.setState({ buttonError: true })
                                            }
                                        }
                                        return (
                                            <div style={{ display: 'flex' }}>
                                                {tableMeta.rowData[3] != null && check > -1 ?
                                                    <LightTooltip title={tableMeta.rowData[3][check].message} arrow>
                                                        <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                    </LightTooltip> :
                                                    <span style={{ color: check != null && check > -1 ? "red" : 'black' }}>{val === "" ? "Empty" : val}</span>
                                                }
                                            </div >
                                        );
                                    }
                                }
                            },
                            {
                                name: "",
                                options: {
                                    display: false
                                }
                            }
                        ]

                        // console.log(dataRow);
                        this.setState({
                            dataLoaded: true,
                            cols: columns,
                            rows: dataRow, visibleUpload: false,
                            visibleUnitBisnis: false
                        });
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({
                    dataLoaded: false,
                    alert: true, messageAlert: response.problem, tipeAlert: 'error'
                });
            }
        })
    }

    componentDidMount() {
        this.getData()
        this.getPermission()
        this.getSizeUpload()
    }

    getSizeUpload(){
        let body = {
            group: 'MAX_FILE_SIZE',
            company_id: 0,
            type: 'MAX_FILE_SIZE'
        }
        api.create().getAllSettingByType(body).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        sizeUpload: response.data.data[0] ? response.data.data[0].value === undefined ? "1" : response.data.data[0].value : "1"
                    })
                }
            }
        })
    }

    getPermission() {
        let payload = {
            menu: "business unit"
        }
        api.create().getPermission(payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        create: response.data.data.create,
                        edit: response.data.data.edit,
                        delete: response.data.data.delete,
                        load: true
                    })
                } else {
                    this.setState({
                        load: true
                    })
                }
            } else {
                this.setState({ load: true })
            }
        })
    }

    getData() {
        this.setState({loading: true})
        api.create().getUnitBisnis().then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.sort((a, b) => a.business_unit_id - b.business_unit_id).map((item, index) => {
                            return [index, item.business_unit_id, item.business_unit_name, item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data }, () => {
                            setTimeout(() => {
                              this.setState({loading: false})
                            }, 2000);
                          })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    openPopUp(rowData, type) {
        if (type === 'edit') {
            this.setState({
                rowData: rowData,
                visibleEdit: true
            })
        } else if (type === 'delete') {
            this.setState({
                rowData: rowData,
                unitBisnisName: String(rowData[2]),
                visibleDelete: true
            })
        } else {
            this.setState({
                rowData: rowData,
                visibleCreate: true
            })
        }
    }

    handleInputChange(e) {
        this.setState({ search: e })
        let body = {
            "keyword": e
        }
        api.create().searchUnitBisnis(body).then(response => {
            // console.log(response.data);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let listData = data.map((item, index) => {
                            return [index, item.business_unit_id, item.business_unit_name, item.status]
                        })
                        this.setState({ dataTable: listData, listData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    updateUnitBisnis = (payload) => {
        this.setState({ visibleEdit: false })
        api.create().updateUnitBisnis(payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }

        })
    }

    createUnitBisnis = (payload) => {
        this.setState({ visibleCreate: false })
        api.create().createUnitBisnis(payload).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        this.getData()
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    downloadFile = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/attachment/download_file?fileName=BusinessUnitTemplate&&fileType=xlsx`
        )
        res = await res.blob()
        console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Business Unit.xlsx';
            a.click();
        }
    }

    downloadDataTable = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/business_unit/export_business_unit`
        )
        res = await res.blob()
        console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Business Unit.xlsx';
            a.click();
        }
    }

    uploadUnitBisnis() {
        api.create().uploadUnitBisnis(this.state.payload).then(response => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.getData()
                        this.setState({ visibleUnitBisnis: true, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    deleteUnitBisnis(payload) {
        // console.log(payload);
        let id = String(payload[1])
        api.create().deleteUnitBisnis(id).then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.getData()
                        this.setState({ visibleDelete: false, alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    render() {
        const columns = [{
            name: "Action",
            options: {
                filter: false,
                sort: false,
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            {this.state.edit && 
                                <span>
                                    <a data-tip={'Edit'} data-for="edit">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                marginRight: 15
                                            }}
                                            // onClick={() => console.log(tableMeta)}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'edit')}
                                        >
                                            <img src={Images.editCopy} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="edit" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                            {this.state.delete && 
                                <span>
                                    <a data-tip={'Delete'} data-for="delete">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                            }}
                                            // onClick={() => console.log(tableMeta)}
                                            onClick={() => this.openPopUp(tableMeta.rowData, 'delete')}
                                        >
                                            <img src={Images.delete} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="delete" place="bottom" type="light" effect="solid" />
                                </span>
                            }
                        </div >
                    );
                }
            }
        }, {
            name: "ID",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[3] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Business Unit",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[3] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }, {
            name: "Status",
            options: {
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ display: 'flex' }}>
                            <span style={{ color: tableMeta.rowData[3] === "Active" ? "#656565" : 'rgba(0, 0, 0, 0.25)' }}>{val}</span>
                        </div >
                    );
                }
            }
        }]
        const data = [
            ["", "1", "Agribisnis", "Aktif"],
            ["", "2", "Manufacturing", "Aktif"],
            ["", "3", "Trading", "Aktif"],
            ["", "4", "Service", "Non Aktif"],
            ["", "-", "-", "-"],
        ]
        const loadingComponent = (
            <div style={{position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)'}}>
              <PropagateLoader
                // css={override}
                size={20}
                color={"#274B80"}
                loading={this.state.loading}
              />
            </div>
          );
        return (
            <div style={{ height: this.props.height }}>
                {/* <Row> */}
                <div style={{ height: 195, width: '100%' }} className={"main-color"} />
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {this.state.visibleUnitBisnis === true ?
                    this.state.load && (
                        <div>
                            <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -182 }}>
                                <label style={{ color: 'white', fontSize: 16, alignSelf: 'center', width: '50%', }}>Master Data - Business Unit</label>
                                {/* <div style={{ color: 'white', width: '50%', height: 37, display: 'flex', backgroundColor: 'white', borderWidth: 2, alignItems: 'center', borderRadius: 6, paddingLeft: 5, paddingRight: 5, alignSelf: 'center' }}>
                                    <img src={Images.searchBlack} style={{ marginRight: 10 }} />
                                    <InputBase
                                        style={{ width: '100%' }}
                                        placeholder="Search"
                                        value={this.state.search}
                                        onChange={(e) => this.handleInputChange(e.target.value)}
                                        inputProps={{ 'aria-label': 'naked' }}
                                    />
                                </div> */}
                                <div style={{ width: '50%', justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                    <a data-tip={'Download Template'} data-for="template">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadFile()}
                                        >
                                            <img src={Images.template} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                    {this.state.create && (
                                        <a data-tip={'Upload'} data-for="upload">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() => this.setState({ visibleUpload: true })}
                                            >
                                                <img src={Images.upload} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                    <a data-tip={'Download'} data-for="download">
                                        <button
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                margin: 5
                                            }}
                                            onClick={() => this.downloadDataTable()}
                                        >
                                            <img src={Images.download} />
                                        </button>
                                    </a>
                                    <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                    {this.state.create && (
                                        <a data-tip={'Add New'} data-for="create">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5,
                                                    marginRight: 20
                                                }}
                                                onClick={() => this.setState({ visibleCreate: true })}
                                            >
                                                <img src={Images.add} />
                                            </button>
                                        </a>
                                    )}
                                    <ReactTooltip border={true} id="create" place="bottom" type="light" effect="solid" />
                                </div>
                            </div>
                            <div style={{ padding: 25 }}>
                            {this.state.loading && loadingComponent}
                                <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        theme={getMuiTheme()}
                                        data={this.state.dataTable}
                                        columns={columns}
                                        options={options}
                                    />
                                </MuiThemeProvider>
                            </div>
                        </div>
                    )
                    :
                    <div>
                        <div style={{ display: 'flex', flexDirection: 'row', justifyContent: 'space-between', paddingRight: 25, paddingLeft: 25, marginTop: -150 }}>
                            <label style={{ color: 'white', fontSize: 16, alignSelf: 'center' }}>Preview Data</label>
                        </div>
                        <div style={{ padding: 25 }}>
                            {this.state.dataLoaded && (
                                <MuiThemeProvider theme={getMuiTheme()}>
                                    <MUIDataTable
                                        theme={getMuiTheme()}
                                        data={this.state.rows}
                                        columns={this.state.cols}
                                        options={options}
                                    />
                                </MuiThemeProvider>
                            )}
                        </div>
                        <div style={{ display: 'flex', width: '100%', placeContent: 'flex-end', padding: 20 }}>
                            <button
                                type="button"
                                onClick={() => this.setState({ visibleUnitBisnis: true })}
                                style={{ marginRight: 20 }}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                            <button
                                type="button"
                                disabled={this.state.buttonError == true ? true : false}
                                onClick={() => this.uploadUnitBisnis()}
                                style={{}}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                }

                {this.state.visibleCreate && (
                    <CreateUnitBisnis
                        onClickClose={() => this.setState({ visibleCreate: false })}
                        type={"create"}
                        createUnitBisnis={this.createUnitBisnis.bind(this)}
                    />
                )}

                {this.state.visibleEdit && (
                    <CreateUnitBisnis
                        type={"edit"}
                        onClickClose={() => this.setState({ visibleEdit: false })}
                        data={this.state.rowData}
                        updateUnitBisnis={this.updateUnitBisnis.bind(this)}
                    />
                )}
                {this.state.popupError && (
                    <PopUpFailedSave onClickClose={() => this.setState({ popupError: false })} />
                )}

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <UploadFile
                                type={this.state.uploadStatus}
                                percentage={this.state.percentage}
                                result={this.state.result}
                                sizeUpload={Number(this.state.sizeUpload)}
                                acceptedFiles={["xlsx"]}
                                onHandle={(dt) => {
                                    this.fileHandler(dt)
                                    this.setState({ uploadStatus: 'idle', percentage: '0' })
                                }}
                                onUpload={() => {
                                    String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("DATA") && String(this.state.judul).includes("BUSINESS") && String(this.state.judul).includes("UNIT") ?
                                        this.checkUpload() :
                                        this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                }}
                            />
                        </div>
                    </div>
                )}

                {this.state.visibleDelete && (
                    <PopUpDelete
                        rowData={this.state.rowData}
                        name={this.state.unitBisnisName}
                        onClickClose={() => this.setState({ visibleDelete: false })}
                        onClickDelete={this.deleteUnitBisnis.bind(this)}
                    />
                )}


                {/* {this.state.visibleLoad && (
                    <div className="test app-popup-show">
                        <div className="popup-content" style={{ textAlign: 'center'}}>
                            <img src={Images.triputraLogo} style={{ height: 100, width: 100}}/>
                        </div>
                    </div>
                )} */}
            </div>
        );
    }
}
