import React, { Component } from 'react';
import { TextField, Typography } from '@material-ui/core';
import Autocomplete from '@material-ui/lab/Autocomplete';
import api from '../../../api';
import { DatePicker } from '@material-ui/pickers';
import { format } from 'date-fns';
import * as R from 'ramda'
import Images from '../../../assets/Images';
import Constant from '../../../library/Constant';

export default class CreateParameter extends Component {
    constructor(props) {
        super(props)
        this.state = {
            enableParameter: false,
            enableReportName: false,
            id: '',
            description: '',
            value: '',
            order: null,
            minValue: '',
            maxValue: '',
            startDate: '',
            endDate: null,
            date: new Date(),
            approvedBy: null,
            getApprovedBy: null,
            types: null,
            getTypes: null,
            perusahaan: null,
            reportName: null,
            getReportName: null,
            getPerusahaan: null,
            parameter: null,
            getParameter: null,
            operators: null,
            getOperators: null,
            tempData: null,
            errorParameter: false,
            errorDeskripsi: false,
            errorReportName: false,
            errorValue: false,
            errorMinValue: false,
            errorOrder: false,
            errorMaxValue: false,
            errorStartDate: false,
            errorEndDate: false,
            errorGroup: false,
            errorPerusahaan: false,
            msgErrorPerusahaan: '',
            msgErrorGroup: '',
            msgErrorParameter: '',
            msgErrorDeskripsi: '',
            msgErrorReportName: '',
            msgErrorValue: '',
            msgErrorMinValue: '',
            msgErrorOrder: '',
            msgErrorMaxValue: '',
            msgErrorStartDate: '',
            msgErrorEndDate: ''
        }
    }

    componentDidMount() {
        if (this.props.type === 'edit') {
            this.getDetailParameter()
        } else {
            let date = format(new Date, 'yyyy-MM-dd')
            this.setState({
                startDate: date,
                endDate: date
            })
            this.getDataGroup()
            this.getDataPerusahaan()
            this.getDataReportName()
        }
    }

    getDetailParameter() {
        api.create().getDetailParameter(this.props.data[0]).then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        this.setState({
                            tempData: response.data.data,
                            getSettingGroupID: response.data.data.setting_group_id,
                            getCompanyID: data.company_id,
                            settingType: data.setting_type,
                            getSettingTypeID: data.setting_type_id,
                            typeReport: data.setting_type_name,
                            getTypeReportID: data.setting_type_id,
                            enableReportName: data.setting_group === "CURRENCY" ? true : false

                        }, () => {
                            this.getAllGroup()
                            this.getPerusahaan()
                            this.getReport()
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getAllGroup() {
        api.create().getAllGroup().then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                setting_group_id: item.setting_group_id,
                                setting_group_name: item.setting_group_name
                            }
                        })
                        let index = typeData.findIndex((val) => val.setting_group_id == this.state.getSettingGroupID)
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.setting_group_name,
                        };
                        this.setState({ types: typeProps, typeData: response.data.data, getTypes: index == -1 ? typeData[0] : typeData[index] }, () => {
                            this.getParameterByGroup(this.state.getTypes.setting_group_id, this.state.getTypes.setting_group_name)
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getPerusahaan() {
        api.create().getPerusahaanActive().then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let perusahaanData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name
                            }
                        })
                        perusahaanData.push({
                            company_id: 0,
                            company_name: 'Default'
                        })
                        let index = perusahaanData.sort((a, b) => a.company_id - b.company_id).findIndex((val) => val.company_id == this.state.getCompanyID)
                        let typeProps = {
                            options: perusahaanData,
                            getOptionLabel: (option) => option.company_name,
                        };
                        this.setState({ perusahaan: typeProps, perusahaanData: response.data.data, getPerusahaan: index == -1 ? null : perusahaanData[index], msgErrorPerusahaan: index === -1 ? 'Company has been Inactive' : "", errorPerusahaan: index === -1 ? true : false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getReport() {
        api.create().getDataReport().then(response => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let reportData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let index = reportData.findIndex((val) => val.setting_type_id == this.state.getTypeReportID)
                        let reportProps = {
                            options: reportData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ reportName: reportProps, reportData: response.data.data, getReportName: index == -1 ? reportData[0] : reportData[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getDataGroup() {
        api.create().getAllGroup().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                setting_group_id: item.setting_group_id,
                                setting_group_name: item.setting_group_name
                            }
                        })
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.setting_group_name,
                        };
                        this.setState({ types: typeProps, typeData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getDataPerusahaan() {
        api.create().getPerusahaanActive().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                company_id: item.company_id,
                                company_name: item.company_name
                            }
                        })
                        typeData.push({
                            company_id: 0,
                            company_name: 'Default'
                        })
                        let typeProps = {
                            options: typeData.sort((a, b) => a.company_id - b.company_id),
                            getOptionLabel: (option) => option.company_name,
                        };
                        this.setState({ perusahaan: typeProps, perusahaanData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getParameterByGroup(id, name) {
        if (name === "CURRENCY") {
            this.setState({ enableReportName: true })
        } else {
            this.setState({ enableReportName: false })
        }
        api.create().getParameterByGroup(id).then(response => {
            // console.log(id, response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let typeData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let index = typeData.findIndex((val) => val.setting_type_id == this.state.getSettingTypeID)
                        let typeProps = {
                            options: typeData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ enableParameter: true, parameter: typeProps, parameterData: response.data.data, getParameter: index == -1 ? null : typeData[index] })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getDataReportName() {
        api.create().getDataReport().then((response) => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status == 'success') {
                        let data = response.data.data
                        let reportData = data.map((item) => {
                            return {
                                setting_type_id: item.setting_type_id,
                                setting_type_name: item.setting_type_name
                            }
                        })
                        let reportProps = {
                            options: reportData,
                            getOptionLabel: (option) => option.setting_type_name,
                        };
                        this.setState({ reportName: reportProps, reportData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
        // let reportData = [
        //     {
        //         "type_report_id": 1,
        //         "report_name": "Master Budget"
        //     },
        //     {
        //         "type_report_id": 2,
        //         "report_name": "Monthly Report"
        //     },
        //     {
        //         "type_report_id": 3,
        //         "report_name": "Rolling Outlook"
        //     },
        //     {
        //         "type_report_id": 4,
        //         "report_name": "Outlook PA"
        //     },
        //     {
        //         "type_report_id": 5,
        //         "report_name": "Operating Indicator"
        //     }
        // ]

        // let reportProps = {
        //     options: reportData.sort((a, b) => a.report_id - b.report_id),
        //     getOptionLabel: (option) => option.report_name,
        // };
        // this.setState({ reportName: reportProps })
    }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({
                ...data, tempData: { ...this.state.tempData, start_date: format(e, 'yyyy-MM-dd'), end_date: null },
                errorParameter: false,
                errorDeskripsi: false,
                errorReportName: false,
                errorValue: false,
                errorMinValue: false,
                errorOrder: false,
                errorMaxValue: false,
                errorStartDate: false,
                errorEndDate: false,
                errorGroup: false,
                errorPerusahaan: false,
                msgErrorPerusahaan: '',
                msgErrorGroup: '',
                msgErrorParameter: '',
                msgErrorDeskripsi: '',
                msgErrorReportName: '',
                msgErrorValue: '',
                msgErrorMinValue: '',
                msgErrorOrder: '',
                msgErrorMaxValue: '',
                msgErrorStartDate: '',
                msgErrorEndDate: ''
            })
        } else if (isDate && type == 'end_date') {
            this.setState({
                ...data, tempData: { ...this.state.tempData, end_date: format(e, 'yyyy-MM-dd') },
                errorParameter: false,
                errorDeskripsi: false,
                errorReportName: false,
                errorValue: false,
                errorMinValue: false,
                errorOrder: false,
                errorMaxValue: false,
                errorStartDate: false,
                errorEndDate: false,
                errorGroup: false,
                errorPerusahaan: false,
                msgErrorPerusahaan: '',
                msgErrorGroup: '',
                msgErrorParameter: '',
                msgErrorDeskripsi: '',
                msgErrorReportName: '',
                msgErrorValue: '',
                msgErrorMinValue: '',
                msgErrorOrder: '',
                msgErrorMaxValue: '',
                msgErrorStartDate: '',
                msgErrorEndDate: ''
            })
        } else {
            this.setState({
                ...data,
                tempData: { ...this.state.tempData, [e.target.name]: e.target.value },
                errorParameter: false,
                errorDeskripsi: false,
                errorReportName: false,
                errorValue: false,
                errorMinValue: false,
                errorOrder: false,
                errorMaxValue: false,
                errorStartDate: false,
                errorEndDate: false,
                errorGroup: false,
                errorPerusahaan: false,
                msgErrorPerusahaan: '',
                msgErrorGroup: '',
                msgErrorParameter: '',
                msgErrorDeskripsi: '',
                msgErrorReportName: '',
                msgErrorValue: '',
                msgErrorMinValue: '',
                msgErrorOrder: '',
                msgErrorMaxValue: '',
                msgErrorStartDate: '',
                msgErrorEndDate: ''
            })
        }
    }

    clearMessage() {
        this.setState({
            errorParameter: false,
            errorDeskripsi: false,
            errorValue: false,
            errorMinValue: false,
            errorOrder: false,
            errorReportName: false,
            errorMaxValue: false,
            errorStartDate: false,
            errorEndDate: false,
            errorGroup: false,
            errorPerusahaan: false,
            msgErrorPerusahaan: '',
            msgErrorGroup: '',
            msgErrorParameter: '',
            msgErrorDeskripsi: '',
            msgErrorValue: '',
            msgErrorMinValue: '',
            msgErrorOrder: '',
            msgErrorMaxValue: '',
            msgErrorStartDate: '',
            msgErrorEndDate: '',
            msgErrorReportName: ''
        })
    }

    handleChangeCreate(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({ startDate: format(e, 'yyyy-MM-dd'), endDate: null }, () => {
                // console.log(this.state.startDate)
            })
        } else if (isDate && type == 'end_date') {
            this.setState({ endDate: format(e, 'yyyy-MM-dd') }, () => {
                // console.log(this.state.endDate)
            })
        } else {
            this.setState({ ...data, [e.target.name]: e.target.value }, () => this.clearMessage())
        }
    }

    validasi() {
        if (R.isNil(this.state.getTypes)) {
            this.setState({ errorGroup: true, msgErrorGroup: 'Group Cannot be Empty' })
        } else if (R.isNil(this.state.getParameter)) {
            this.setState({ errorParameter: true, msgErrorParameter: 'Parameter Cannot be Empty' })
        } else if (R.isNil(this.state.getPerusahaan)) {
            this.setState({ errorPerusahaan: true, msgErrorPerusahaan: 'Company Cannot be Empty' })
            // } else if (R.isEmpty(this.state.tempData.description)) {
            //     this.setState({ errorDeskripsi: true, msgErrorDeskripsi: 'Deskripsi tidak boleh kosong' })
        } else if (this.state.getTypes.setting_group_name === "CURRENCY" && R.isNil(this.state.getReportName)) {
            this.setState({ errorReportName: true, msgErrorReportName: 'Report Name Cannot be Empty' })
        } else if (R.isEmpty(this.state.tempData.value) && R.isEmpty(this.state.tempData.min_value) && R.isEmpty(this.state.tempData.max_value)) {
            this.setState({ errorValue: true, msgErrorValue: 'Value Cannot be Empty' })
        } else if ((!R.isEmpty(this.state.tempData.max_value) && R.isEmpty(this.state.tempData.min_value))) {
            this.setState({ errorMinValue: true, msgErrorMinValue: 'Min Value Cannot be Empty' })
        } else if (R.isNil(this.state.tempData.start_date)) {
            this.setState({ errorStartDate: true, msgErrorStartDate: 'Valid From Cannot be Empty' })
            // } else if (R.isNil(this.state.tempData.order)) {
            //     this.setState({ errorOrder: true, msgErrorOrder: 'Order tidak boleh kosong' })
        } else if ((!R.isEmpty(this.state.tempData.min_value) && R.isEmpty(this.state.tempData.max_value))) {
            this.setState({ errorMaxValue: true, msgErrorMaxValue: 'Max Value Cannot be Empty' })
        } else if (R.isNil(this.state.tempData.end_date)) {
            this.setState({ errorEndDate: true, msgErrorEndDate: 'Valid To Cannot be Empty' })
        } else {
            this.updateParameter()
        }
    }

    validasiCreate() {
        console.log(this.state.getTypes);
        if (R.isNil(this.state.getTypes)) {
            this.setState({ errorGroup: true, msgErrorGroup: 'Group Cannot be Empty' })
        } else if (R.isNil(this.state.getParameter)) {
            this.setState({ errorParameter: true, msgErrorParameter: 'Parameter Cannot be Empty' })
        } else if (R.isNil(this.state.getPerusahaan)) {
            this.setState({ errorPerusahaan: true, msgErrorPerusahaan: 'Company Cannot be Empty' })
            // } else if (R.isEmpty(this.state.description)) {
            //     this.setState({ errorDeskripsi: true, msgErrorDeskripsi: 'Deskripsi tidak boleh kosong' })
        } else if (this.state.getTypes.setting_group_name === "CURRENCY" && R.isNil(this.state.getReportName)) {
            this.setState({ errorReportName: true, msgErrorReportName: 'Report Name Cannot be Empty' })
        } else if ((R.isEmpty(this.state.value) && R.isEmpty(this.state.maxValue) && R.isEmpty(this.state.minValue))) {
            this.setState({ errorValue: true, msgErrorValue: 'Value Cannot be Empty' })
        } else if ((!R.isEmpty(this.state.maxValue) && R.isEmpty(this.state.minValue))) {
            this.setState({ errorMinValue: true, msgErrorMinValue: 'Min Value Cannot be Empty' })
        } else if (R.isNil(this.state.startDate)) {
            this.setState({ errorStartDate: true, msgErrorStartDate: 'Valid From Cannot be Empty' })
            // } else if (R.isNil(this.state.order)) {
            //     this.setState({ errorOrder: true, msgErrorOrder: 'Order tidak boleh kosong' })
        } else if ((!R.isEmpty(this.state.minValue) && R.isEmpty(this.state.maxValue))) {
            this.setState({ errorMaxValue: true, msgErrorMaxValue: 'Max Value Cannot be Empty' })
        } else if (R.isNil(this.state.endDate)) {
            this.setState({ errorEndDate: true, msgErrorEndDate: 'Valid To Cannot be Empty' })
        } else {
            this.createParameter()
        }
    }

    updateParameter() {
        let body = {
            "setting_id": this.state.tempData.setting_id,
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getReportName.setting_type_id,
            "description": this.state.tempData.description,
            "orders": this.state.tempData.order,
            "value": this.state.tempData.value,
            "max_value": this.state.tempData.max_value,
            "min_value": this.state.tempData.min_value,
            "start_date": this.state.tempData.start_date,
            "end_date": this.state.tempData.end_date
        }
        // console.log(body);
        this.props.updateParameter(body)
    }

    createParameter() {
        let body = {
            "setting_group_id": this.state.getTypes.setting_group_id,
            "setting_type_id": this.state.getParameter.setting_type_id,
            "company_id": this.state.getPerusahaan.company_id,
            "reference_id": this.state.getReportName.setting_type_id,
            "description": this.state.description,
            "orders": this.state.order,
            "value": this.state.value,
            "max_value": this.state.maxValue,
            "min_value": this.state.minValue,
            "start_date": this.state.startDate,
            "end_date": this.state.endDate
        }
        // console.log(body);
        this.props.createParameter(body)
    }

    render() {
        let { type } = this.props
        return type === 'edit' ? this.renderEdit() : this.renderCreate()
    }

    renderEdit() {
        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Ubah Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>


                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.tempData === null ? '' : this.state.tempData.setting_id}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.parameter}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getParameter: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Parameter"
                                            error={this.state.errorParameter}
                                            helperText={this.state.msgErrorParameter}
                                        />}
                                    value={this.state.getParameter}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="description"
                                    label="Description"
                                    value={this.state.tempData === null ? '' : this.state.tempData.description}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="description"
                                    onChange={(e) => this.handleChange(e, '')}
                                // error={this.state.errorDeskripsi}
                                // helperText={this.state.msgErrorDeskripsi}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="value"
                                    label="Value"
                                    value={this.state.tempData === null ? '' : this.state.tempData.value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="value"
                                    onChange={(e) => {
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                value: e.target.value
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorValue}
                                    helperText={this.state.msgErrorValue}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="min_value"
                                    label="Min Value"
                                    value={this.state.tempData === null ? '' : this.state.tempData.min_value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="min_value"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                min_value: e.target.value
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMinValue}
                                    helperText={this.state.msgErrorMinValue}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="start_date"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.tempData === null ? '' : this.state.tempData.start_date}
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorStartDate}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="status"
                                    label="Status"
                                    value={this.state.tempData === null ? '' : this.state.tempData.status}
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                        </div>

                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.types}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getTypes: newInputValue }, () => newInputValue === null ? this.setState({ enableParameter: false, enableReportName: false, getParameter: null, getReportName: null }, () => this.clearMessage()) : this.getParameterByGroup(newInputValue.setting_group_id, newInputValue.setting_group_name), this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            error={this.state.errorGroup}
                                            helperText={this.state.msgErrorGroup}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Group" />}
                                    value={this.state.getTypes}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.perusahaan}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getPerusahaan: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField {...params}
                                            error={this.state.errorPerusahaan}
                                            helperText={this.state.msgErrorPerusahaan}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Company Name" />}
                                    value={this.state.getPerusahaan}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="order"
                                    label="Order"
                                    value={this.state.tempData === null ? '' : this.state.tempData.order}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="order"
                                    onChange={(e) => {
                                        let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                order: coba
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                // error={this.state.errorOrder}
                                // helperText={this.state.msgErrorOrder}
                                >
                                </TextField>
                            </div>

                            {this.state.enableReportName &&
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.reportName}
                                        debug
                                        id="report"
                                        onChange={(event, newInputValue) => this.setState({ getReportName: newInputValue }, () => this.clearMessage())}
                                        renderInput={(params) =>
                                            <TextField
                                                {...params}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                label="Report Name"
                                            // error={this.state.errorPerusahaan}
                                            // helperText={this.state.msgErrorPerusahaan}
                                            />}
                                        value={this.state.getReportName}
                                    />
                                </div>
                            }

                            <div style={{ marginTop: '80px', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="max_value"
                                    label="Max Value"
                                    value={this.state.tempData === null ? '' : this.state.tempData.max_value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="max_value"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            tempData: {
                                                ...this.state.tempData,
                                                max_value: e.target.value
                                            }
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMaxValue}
                                    helperText={this.state.msgErrorMaxValue}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="end_date"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorEndDate}
                                    minDate={this.state.tempData === null ? null : this.state.tempData.start_date}
                                    value={this.state.tempData === null ? '' : this.state.tempData.end_date}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="border-bottom margin-top-10px" style={{ padding: '0px 20px 20px 20px', borderRadius: 5 }}>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Created By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.tempData === null ? "" : this.state.tempData.created}</Typography>
                        </div>
                        <div style={{ display: 'flex' }}>
                            <Typography style={{ fontSize: 11, width: '12%' }}>Updated By</Typography>
                            <Typography style={{ fontSize: 11 }}>: {this.state.tempData === null ? "" : this.state.tempData.updated === null ? "" : this.state.tempData.updated}</Typography>
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasi()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        )
    }

    renderCreate() {
        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Create Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>


                    <div className="border-bottom grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.tempData === null ? '' : this.state.tempData.setting_id}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.parameter}
                                    debug
                                    disabled={!this.state.enableParameter}
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getParameter: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Parameter"
                                            error={this.state.errorParameter}
                                            helperText={this.state.msgErrorParameter}
                                        />}
                                    value={this.state.getParameter}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="description"
                                    label="Description"
                                    value={this.state.description === '' ? '' : this.state.description}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="description"
                                    onChange={(e) => this.handleChangeCreate(e, '')}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="value"
                                    label="Value"
                                    value={this.state.value}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}

                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="value"
                                    onChange={(e) => {
                                        this.setState({
                                            value: e.target.value
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorValue}
                                    helperText={this.state.msgErrorValue}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="min_value"
                                    label="Min Value"
                                    value={this.state.minValue}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="minValue"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            minValue: e.target.value
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMinValue}
                                    helperText={this.state.msgErrorMinValue}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorStartDate}
                                    value={this.state.startDate == "" ? null : this.state.startDate}
                                    onChange={(e) => this.handleChangeCreate(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    defaultValue={"Active"}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Created By	: </Typography>
                                <Typography style={{ fontSize: 11, width: '25%' }}>Updated By	: </Typography>
                            </div>
                        </div>

                        <div className="column-2">
                            <div className="" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.types}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getTypes: newInputValue }, () => newInputValue === null ? this.setState({ enableParameter: false, enableReportName: false, getParameter: null, getReportName: null }, () => this.clearMessage()) : this.getParameterByGroup(newInputValue.setting_group_id, newInputValue.setting_group_name), this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Group"
                                            error={this.state.errorGroup}
                                            helperText={this.state.msgErrorGroup}
                                        />}
                                    value={this.state.getTypes}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.perusahaan}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getPerusahaan: newInputValue }, () => this.clearMessage())}
                                    renderInput={(params) =>
                                        <TextField
                                            {...params}
                                            InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                            InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                            label="Company Name"
                                            error={this.state.errorPerusahaan}
                                            helperText={this.state.msgErrorPerusahaan}
                                        />}
                                    value={this.state.getPerusahaan}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="order"
                                    label="Order"
                                    value={this.state.order === null ? '' : this.state.order}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="order"
                                    onChange={(e) => {
                                        let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            order: coba
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                // error={this.state.errorOrder}
                                // helperText={this.state.msgErrorOrder}
                                >
                                </TextField>
                            </div>

                            {this.state.enableReportName &&
                                <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                    <Autocomplete
                                        {...this.state.reportName}
                                        debug
                                        id="report"
                                        onChange={(event, newInputValue) => this.setState({ getReportName: newInputValue }, () => this.clearMessage())}
                                        renderInput={(params) =>
                                            <TextField
                                                {...params}
                                                InputProps={{ ...params.InputProps, style: { fontSize: 11 } }}
                                                InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }}
                                                label="Report Name"
                                                error={this.state.errorReportName}
                                                helperText={this.state.msgErrorReportName}
                                            />}
                                        value={this.state.getReportName}
                                    />
                                </div>
                            }

                            <div style={{ marginTop: '80px', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="max_value"
                                    label="Max Value"
                                    value={this.state.maxValue}
                                    inputProps={{
                                        min: 0,
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    name="maxValue"
                                    onChange={(e) => {
                                        // let coba = String(e.target.value).replace(/[^\d]/g, '');
                                        this.setState({
                                            maxValue: e.target.value
                                        })
                                        this.clearMessage()
                                    }
                                        // this.handleChange(coba, 'value')}
                                    }
                                    error={this.state.errorMaxValue}
                                    helperText={this.state.msgErrorMaxValue}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorEndDate}
                                    minDate={this.state.startDate}
                                    value={this.state.endDate == "" ? null : this.state.endDate}
                                    onChange={(e) => this.handleChangeCreate(e, 'end_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasiCreate()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        )
    }
}