import React, { Component } from 'react'
import { TextField, Typography } from '@material-ui/core'
import { DatePicker } from '@material-ui/pickers'
import * as R from 'ramda'
import api from '../../../api'
import Autocomplete from '@material-ui/lab/Autocomplete'
import { format } from 'date-fns'
import Images from '../../../assets/Images'

export default class EditPerusahaan extends Component {
    constructor(props) {
        super(props)
        this.state = {
            id: '',
            company: '',
            companyID: '',
            parent: '',
            unitBisnis: '',
            totalReport: '',
            startDate: '',
            endDate: '',
            status: '',
            types: null,
            getTypes: null,
            perusahaan: null,
            getPerusahaan: null,
            errorNP: false,
            errorPC: false,
            errorSD: false,
            errorED: false,
            errorJL: false,
            msgErrorNP: '',
            msgErrorPC: '',
            msgErrorSD: '',
            msgErrorED: '',
            msgErrorJL: '',
        }
    }

    componentDidMount() {
        let data = this.props.data
        this.getDetailPerusahaan(data.company_id,)
        // this.getAllUnitBisnis()
    }

    getDetailPerusahaan(id) {
        api.create().getDetailPerusahaan(id).then(response => {
            if (response.data.status === "success") {
                console.log(response);
                this.setState({
                    businessID: response.data.data.business_unit_id,
                    companyID: response.data.data.company_id,
                    status: response.data.data.status,
                    company: response.data.data.company_name,
                    parentID: response.data.data.parent,
                    parent: response.data.data.parent_name,
                    startDate: response.data.data.start_date,
                    endDate: response.data.data.end_date,
                    totalReport: response.data.data.total_report,
                    created: response.data.data.created,
                    updated: response.data.data.updated === null ? "" : response.data.data.updated
                }, () => this.getAllUnitBisnis(), this.getCompanyActive())
            }
        })
    }

    getAllUnitBisnis() {
        api.create().getUnitBisnisActive().then(response => {
            console.log(response);
            if (response.data.status == 'success') {
                let data = response.data.data
                let typeData = data.map((item) => {
                    return {
                        business_unit_id: item.business_unit_id,
                        business_unit_name: item.business_unit_name
                    }
                })
                let index = typeData.findIndex((val) => val.business_unit_id == this.state.businessID)
                let typeProps = {
                    options: typeData,
                    getOptionLabel: (option) => option.business_unit_name,
                };
                this.setState({ types: typeProps, typeData: response.data.data, getTypes: index == -1 ? typeData[0] : typeData[index] })
            } else {
                alert(response.data.message)
            }
        })
    }

    getCompanyActive() {
        api.create().getPerusahaanActive().then(response => {
            if (response.data.status == 'success') {
                let data = response.data.data
                let perusahaanData = data.map((item) => {
                    return {
                        company_id: item.company_id,
                        company_name: item.company_name
                    }
                })
                let index = perusahaanData.sort((a, b) => a.company_id - b.company_id).findIndex((val) => val.company_id == this.state.parentID)
                let typeProps = {
                    options: perusahaanData,
                    getOptionLabel: (option) => option.company_name,
                };
                this.setState({ perusahaan: typeProps, perusahaanData: response.data.data, getPerusahaan: index == -1 ? perusahaanData[0] : perusahaanData[index] })
            } else {
                alert(response.data.message)
            }
        })
    }

    clearError() {
        this.setState({
            errorNP: false,
            errorPC: false,
            errorSD: false,
            errorED: false,
            errorJL: false,
            msgErrorNP: '',
            msgErrorPC: '',
            msgErrorSD: '',
            msgErrorED: '',
            msgErrorJL: '',
        })
    }

    validasi() {
        if (R.isEmpty(this.state.company)) {
            this.setState({ errorNP: true, msgErrorNP: 'Nama perusahaan harus diisi' })
        } else if (R.isEmpty(this.state.totalReport)) {
            this.setState({ errorJL: true, msgErrorJL: 'Total Report harus diisi' })
        } else if (R.isNil(this.state.startDate)) {
            this.setState({ errorSD: true, msgErrorSD: 'Start Date tidak boleh kosong' })
        } else if (R.isNil(this.state.endDate)) {
            this.setState({ errorED: true, msgErrorED: 'End Date tidak boleh kosong' })
        }
        let payload = {
            "company_id": this.state.companyID,
            "company_name": this.state.company,
            "business_unit_id": this.state.getTypes.business_unit_id,
            "parent": this.state.getPerusahaan == null ? null : this.state.getPerusahaan.company_id,
            "total_report": this.state.totalReport,
            "start_date": this.state.startDate,
            "end_date": this.state.endDate
        }
        // console.log(payload);
        this.props.updatePerusahaan(payload)
    }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type == 'start_date') {
            this.setState({ startDate: format(e, 'yyyy-MM-dd'), endDate: null }, () => {
                console.log(this.state.startDate)
            })
        } else if (isDate && type == 'end_date') {
            this.setState({ endDate: format(e, 'yyyy-MM-dd') }, () => {
                console.log(this.state.endDate)
            })
        } else {
            // this.setState({...data, tempData: {...this.state.tempData, [e.target.name] :  e.target.value}})
        }

    }

    render() {
        return (
            <div className="test app-popup-show">
                <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Ubah Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close}/>
                            </button>
                        </div>
                    </div>


                    <div className="border-bottom grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.companyID}
                                    id="id"
                                    label="ID"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <Autocomplete
                                    {...this.state.types}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getTypes: newInputValue })}
                                    renderInput={(params) => <TextField {...params} InputProps={{ ...params.InputProps, style: { fontSize: 11 } }} InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }} label="Unit Bisnis" />}
                                    value={this.state.getTypes}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Berlaku Mulai"
                                    format="dd MMMM yyyy"
                                    value={this.state.startDate}
                                    onChange={(e) => this.handleChange(e, 'start_date'), () => this.clearError()}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    error={this.state.errorSD}
                                    helperText={this.state.msgErrorSD}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ backgroundColor: '#e8e8e8', padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    value={this.state.status}
                                    id="status"
                                    label="Status"
                                    disabled
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                />
                            </div>

                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: 11, width: '20%' }}>Dibuat</Typography>
                                    <Typography style={{ fontSize: 11 }}>: {this.state.created}</Typography>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: 11, width: '20%' }}>Diubah</Typography>
                                    <Typography style={{ fontSize: 11 }}>: {this.state.updated == - null ? "" : this.props.data.updated}</Typography>
                                </div>
                            </div>
                        </div>

                        <div className="column-2">
                            <div style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="perusahaan"
                                    label="Nama Perusahaan"
                                    value={this.state.company}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    onChange={(e) => this.setState({ company: e.target.value }, () => this.clearError())}
                                    error={this.state.errorNP}
                                    helperText={this.state.msgErrorNP}
                                >
                                </TextField>
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                            <Autocomplete
                                    {...this.state.perusahaan}
                                    debug
                                    id="tipe"
                                    onChange={(event, newInputValue) => this.setState({ getPerusahaan: newInputValue })}
                                    renderInput={(params) => <TextField {...params} InputProps={{ ...params.InputProps, style: { fontSize: 11 } }} InputLabelProps={{ style: { fontSize: 11, color: '#7e8085' } }} label="Parent Company" />}
                                    value={this.state.getPerusahaan}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Berlaku Hingga"
                                    format="dd MMMM yyyy"
                                    value={this.state.endDate}
                                    minDate={this.state.startDate}
                                    onChange={(e) => this.handleChange(e, 'end_date'), () => this.clearError()}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                    error={this.state.errorED}
                                    helperText={this.state.msgErrorED}
                                />
                            </div>
                            <div className="margin-top-10px" style={{ padding: 10, borderRadius: 5 }}>
                                <TextField
                                    style={{ width: '100%' }}
                                    id="report"
                                    label="Jumlah Laporan"
                                    value={this.state.totalReport}
                                    inputProps={{
                                        style: {
                                            fontSize: 11
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085'
                                        }
                                    }}
                                    onChange={(e) => this.setState({ totalReport: e.target.value }, () => this.clearError())}
                                    error={this.state.errorJL}
                                    helperText={this.state.msgErrorJL}
                                >
                                </TextField>
                            </div>
                        </div>
                    </div>

                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Batal</span>
                                </div>
                            </button>
                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasi()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Simpan</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        )
    }
}
