import { createMuiTheme, FormControlLabel, Input, MuiThemeProvider, Paper, Snackbar, TableCell, Tooltip, Typography, withStyles } from '@material-ui/core'
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import ReactTooltip from 'react-tooltip';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import * as R from 'ramda';
import { PropagateLoader } from 'react-spinners';
import { ExcelRenderer } from 'react-excel-renderer';
import Constant from '../../library/Constant';
import UploadFile from "../../library/Upload";
import { Alert } from '@material-ui/lab';
import { color } from 'echarts';
import { fixNumber, titleCase } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {

        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

const LightTooltipError = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(255, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};
const stylenotes = {
    position: "sticky",
    background: "white",
    zIndex: 101,
    left: 350
};

const styleNotesEmpty = {
    position: "sticky",
    background: "white",
    zIndex: 99,
    left: 0
}
// const StyledButton = withStyles({
//     root: {
//       background: 'linear-gradient(45deg, #FE6B8B 30%, #FF8E53 90%)',
//       borderRadius: 3,
//       border: 0,
//       color: 'white',
//       height: 48,
//       padding: '0 30px',
//       boxShadow: '0 3px 5px 2px rgba(255, 105, 135, .3)',
//     },
//     label: {
//       textTransform: 'capitalize',
//     },
//   })(Input);

export default class ProfitLossMR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            visiblePLMR: true,
            minValue: 0,
            maxValue: 0,
            updateBy: [],
            notesUpdate: '-',
            bebas: false,
            judulColumn: null,
            handleDoubleClick: 0,
            saveDraft: true,
            buttonError: true,
            viewOnly: true,
            get_for: 'view',
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false

        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        // this.getItemHierarki()
        this.getLatestUpdate()
        this.getSettingControl()
        this.handleViewOnly()
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({ viewOnly: true })
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getLatestUpdate()
            this.getSettingControl()
        })
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_VARIANCE',
            company_id: this.props.company.company_id,
            type: 'PNL',
            currency_id: this.props.defaultCurrency.id,
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        // valueThreshold: response.data.data[0] ? response.data.data[0].value : null,
                        minValue: response.data.data[0] ? Number(response.data.data[0].min_value) : -10,
                        maxValue: response.data.data[0] ? Number(response.data.data[0].max_value) : 10,

                    }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        api.create().getLastestUpdateMR(payload).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notesUpdate: response.data.data.notes_update === null ? '-' : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "get_for": this.state.get_for
        }
        console.log(payload);
        api.create().getHierarkiMontlyReportPL(payload).then(response => {
            console.log(response);
            let dataTable = []
            let err = false

            if (response.data) {
                if (response.data.status === 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (item.type_report_id === 3) {
                            if (item.profit_loss.mtd_vs_mb == "" && Number(item.profit_loss.percent_act_vs_mb) < this.state.minValue || Number(item.profit_loss.percent_act_vs_mb) > this.state.maxValue) {
                                err = true
                            }
                        }
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.profit_loss.notes == null || item.profit_loss.notes == "null" ? "" : item.profit_loss.notes,
                                item.profit_loss.rolling_outlook === null ? "0.0" : item.profit_loss.rolling_outlook === "" ? "0.0" : item.profit_loss.rolling_outlook === "0" ? "0.0" : item.profit_loss.rolling_outlook,
                                item.profit_loss.master_budget === null ? "0.0" : item.profit_loss.master_budget === "" ? "0.0" : item.profit_loss.master_budget,
                                item.profit_loss.rolling_budget === null ? "0.0" : item.profit_loss.rolling_budget === "" ? "0.0" : item.profit_loss.rolling_budget,
                                item.profit_loss.actual === null ? "0.0" : item.profit_loss.actual === "" ? "0.0" : item.profit_loss.actual,
                                0,
                                item.profit_loss.actual_previous_month === null ? "0.0" : item.profit_loss.actual_previous_month === "" ? "0.0" : item.profit_loss.actual_previous_month,
                                item.profit_loss.amount_act_vs_previous_month === null ? "0.0" : item.profit_loss.amount_act_vs_previous_month === "" ? "0.0" : item.profit_loss.amount_act_vs_previous_month,
                                item.profit_loss.percent_act_vs_previous_month === null ? "0.0" : item.profit_loss.percent_act_vs_previous_month === "" ? "0.0" : item.profit_loss.percent_act_vs_previous_month,
                                item.profit_loss.amount_act_vs_mb === null ? "0.0" : item.profit_loss.amount_act_vs_mb === "" ? "0.0" : item.profit_loss.amount_act_vs_mb,
                                item.profit_loss.percent_act_vs_mb === null ? "0.0" : item.profit_loss.percent_act_vs_mb === "" ? "0.0" : item.profit_loss.percent_act_vs_mb,
                                item.profit_loss.amount_act_vs_rb === null ? "0.0" : item.profit_loss.amount_act_vs_rb === "" ? "0.0" : item.profit_loss.amount_act_vs_rb,
                                item.profit_loss.percent_act_vs_rb === null ? "0.0" : item.profit_loss.percent_act_vs_rb === "" ? "0.0" : item.profit_loss.percent_act_vs_rb,
                                item.profit_loss.mtd_vs_mb === null ? "" : item.profit_loss.mtd_vs_mb,
                                item.profit_loss.mtd_vs_rb === null ? "" : item.profit_loss.mtd_vs_rb,
                                item.profit_loss.mtd_vs_previous_month === null ? "" : item.profit_loss.mtd_vs_previous_month,
                                item.order,
                                item.profit_loss.ytd_actual === null ? "0.0" : item.profit_loss.ytd_actual === "" ? "0.0" : item.profit_loss.ytd_actual,
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        if (item.type_report_id === 3) {
                            if (item.profit_loss.mtd_vs_mb == "" && Number(item.profit_loss.percent_act_vs_mb) < this.state.minValue || Number(item.profit_loss.percent_act_vs_mb) > this.state.maxValue) {
                                err = true
                            }
                        }
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.profit_loss.notes == null || item.profit_loss.notes == "null" ? "" : item.profit_loss.notes,
                            item.profit_loss.rolling_outlook === null ? "0.0" : item.profit_loss.rolling_outlook === "" ? "0.0" : item.profit_loss.rolling_outlook,
                            item.profit_loss.master_budget === null ? "0.0" : item.profit_loss.master_budget === "" ? "0.0" : item.profit_loss.master_budget,
                            item.profit_loss.rolling_budget === null ? "0.0" : item.profit_loss.rolling_budget === "" ? "0.0" : item.profit_loss.rolling_budget,
                            item.profit_loss.actual === null ? "0.0" : item.profit_loss.actual === "" ? "0.0" : item.profit_loss.actual,
                            0,
                            item.profit_loss.actual_previous_month === null ? "0.0" : item.profit_loss.actual_previous_month === "" ? "0.0" : item.profit_loss.actual_previous_month,
                            item.profit_loss.amount_act_vs_previous_month === null ? "0.0" : item.profit_loss.amount_act_vs_previous_month === "" ? "0.0" : item.profit_loss.amount_act_vs_previous_month,
                            item.profit_loss.percent_act_vs_previous_month === null ? "0.0" : item.profit_loss.percent_act_vs_previous_month === "" ? "0.0" : item.profit_loss.percent_act_vs_previous_month,
                            item.profit_loss.amount_act_vs_mb === null ? "0.0" : item.profit_loss.amount_act_vs_mb === "" ? "0.0" : item.profit_loss.amount_act_vs_mb,
                            item.profit_loss.percent_act_vs_mb === null ? "0.0" : item.profit_loss.percent_act_vs_mb === "" ? "0.0" : item.profit_loss.percent_act_vs_mb,
                            item.profit_loss.amount_act_vs_rb === null ? "0.0" : item.profit_loss.amount_act_vs_rb === "" ? "0.0" : item.profit_loss.amount_act_vs_rb,
                            item.profit_loss.percent_act_vs_rb === null ? "0.0" : item.profit_loss.percent_act_vs_rb === "" ? "0.0" : item.profit_loss.percent_act_vs_rb,
                            item.profit_loss.mtd_vs_mb === null ? "" : item.profit_loss.mtd_vs_mb,
                            item.profit_loss.mtd_vs_rb === null ? "" : item.profit_loss.mtd_vs_rb,
                            item.profit_loss.mtd_vs_previous_month === null ? "" : item.profit_loss.mtd_vs_previous_month,
                            item.order,
                            item.profit_loss.ytd_actual === null ? "0.0" : item.profit_loss.ytd_actual === "" ? "0.0" : item.profit_loss.ytd_actual,
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    // if (err === true) {
                    //     this.setState({ bebas: true })
                    // }
                    console.log(dataTable);
                    this.setState({ dataTable, loading: false, buttonError: true, saveDraft: true, refresh: false })
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ dataTable, loading: false, buttonError: true, saveDraft: true, refresh: false })
            }
            console.log(dataTable);
        })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/profit_loss/monthly_report/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report Profit Loss.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/profit_loss/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/profit_loss/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId === null ? "" : this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report Profit Loss.xlsx';
            a.click();
        }
    }

    backToMonthlyReport(type) {
        console.log('test');
        // this.setState({ loading: true })
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "notes": String(i[6]),
                    "rolling_outlook": String(Number(i[7])),
                    "master_budget": String(Number(i[8])),
                    "rolling_budget": String(Number(i[9])),
                    "actual": String(Number(i[10])),
                    "ytd_actual": String(Number(i[11])),
                    "actual_previous_month": String(Number(i[12])),
                    "amount_act_vs_previous_month": String(Number(i[13])),
                    "percent_act_vs_previous_month": i[14],
                    "amount_act_vs_mb": String(Number(i[15])),
                    "percent_act_vs_mb": i[16],
                    "amount_act_vs_rb": String(Number(i[17])),
                    "percent_act_vs_rb": i[18],
                    "mtd_vs_mb": String(i[19]),
                    "mtd_vs_rb": String(i[20]),
                    "mtd_vs_previous_month": String(i[21]),
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "notes": String(i[6]),
                    "rolling_outlook": String(fixNumber(Number(i[7]), 1)),
                    "master_budget": String(fixNumber(Number(i[8]), 1)),
                    "rolling_budget": String(fixNumber(Number(i[9]), 1)),
                    "actual": String(fixNumber(Number(i[10]), 1)),
                    "ytd_actual": String(fixNumber(Number(i[11]), 1)),
                    "actual_previous_month": String(fixNumber(Number(i[12]), 1)),
                    "amount_act_vs_previous_month": String(fixNumber(Number(i[13]), 1)),
                    "percent_act_vs_previous_month": i[14],
                    "amount_act_vs_mb": String(fixNumber(Number(i[15]), 1)),
                    "percent_act_vs_mb": i[16],
                    "amount_act_vs_rb": String(fixNumber(Number(i[17]), 1)),
                    "percent_act_vs_rb": i[18],
                    "mtd_vs_mb": String(i[19]),
                    "mtd_vs_rb": String(i[20]),
                    "mtd_vs_previous_month": String(i[21]),
                })
            })
        }
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "profit_loss": data
        }
        console.log(payload);
        // console.log(JSON.stringify(payload));
        api.create('UPLOAD').createMonthlyReportPL(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.saveToMonthlyReport('PL')
                    } else {
                        this.props.saveToMonthlyReport()
                    }
                } else {
                    if (response.data?.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                            document.body.style.overflow = 'unset';
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                            this.props.saveToMonthlyReport()
                        })
                    }
                }
            } else {
                this.setState({ alert: true, messageAlert: "Error saving data. Please try again", tipeAlert: 'warning', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // console.log(resp.rows[2]);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            orders: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report_id: i[1] === undefined ? "" : String(i[1]).trim(),
                            item_report: i[2] === undefined ? "" : String(i[2]).trim(),
                            notes: i[3] === undefined ? "" : String(i[3]).trim(),
                            actual: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            mtd_vs_mb: i[5] === undefined ? "" : String(i[5]).trim(),
                            mtd_vs_rb: i[6] === undefined ? "" : String(i[6]).trim(),
                            mtd_vs_previous_month: i[7] === undefined ? "" : String(i[7]).trim(),
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    months: this.props.month.month_id,
                    status: 'submitted',
                    profit_loss: payload
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        console.log(this.props.monthlyReportId);
        api.create().checkUploadMonthlyReportPL(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visiblePLMR: false, loading: true })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.notes == null || item.notes == "null" ? "" : item.notes,
                            item.rolling_outlook === null ? "" : item.rolling_outlook === "" ? "" : item.rolling_outlook,
                            item.master_budget === "" ? "" : item.master_budget,
                            item.rolling_budget === "" ? "" : item.rolling_budget,
                            item.actual === "" ? "" : Number(item.actual),
                            0,
                            item.actual_previous_month === null ? "" : item.actual_previous_month === "" ? "" : item.actual_previous_month,
                            // 0,
                            // 0,
                            // 0,
                            // 0,
                            // 0,
                            // 0,
                            item.amount_act_vs_previous_month,
                            item.percent_act_vs_previous_month,
                            item.amount_act_vs_mb,
                            item.percent_act_vs_mb,
                            item.amount_act_vs_rb,
                            item.percent_act_vs_rb,
                            item.mtd_vs_mb,
                            item.mtd_vs_rb,
                            item.mtd_vs_previous_month,
                            item.orders,
                            item.ytd_actual === null ? "" : item.ytd_actual === "" ? "" : item.ytd_actual,
                            item.error
                        ]
                    })
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false }, () => {
                        this.state.dataTable.map(item => {
                            if (item[24].length > 0) {
                                // console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true })
                            }
                        })
                        // console.log(this.state.buttonError)
                    })
                    console.log(dataTable);
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadProfitLossMR(type) {
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    notes: String(i[6]),
                    rolling_outlook: String(Number(i[7])),
                    master_budget: String(Number(i[8])),
                    rolling_budget: String(Number(i[9])),
                    actual: String(Number(i[10])),
                    ytd_actual: String(Number(i[11])),
                    actual_previous_month: String(Number(i[12])),
                    amount_act_vs_previous_month: String(Number(i[13])),
                    percent_act_vs_previous_month: i[14],
                    amount_act_vs_mb: String(Number(i[15])),
                    percent_act_vs_mb: i[16],
                    amount_act_vs_rb: String(Number(i[17])),
                    percent_act_vs_rb: i[18],
                    mtd_vs_mb: String(i[19]),
                    mtd_vs_rb: String(i[20]),
                    mtd_vs_previous_month: String(i[21]),
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    notes: String(i[6]),
                    rolling_outlook: String(fixNumber(Number(i[7]), 1)),
                    master_budget: String(fixNumber(Number(i[8]), 1)),
                    rolling_budget: String(fixNumber(Number(i[9]), 1)),
                    actual: String(fixNumber(Number(i[10]), 1)),
                    ytd_actual: String(fixNumber(Number(i[11]), 1)),
                    actual_previous_month: String(fixNumber(Number(i[12]), 1)),
                    amount_act_vs_previous_month: String(fixNumber(Number(i[13]), 1)),
                    percent_act_vs_previous_month: i[14],
                    amount_act_vs_mb: String(fixNumber(Number(i[15]), 1)),
                    percent_act_vs_mb: i[16],
                    amount_act_vs_rb: String(fixNumber(Number(i[17]), 1)),
                    percent_act_vs_rb: i[18],
                    mtd_vs_mb: String(i[19]),
                    mtd_vs_rb: String(i[20]),
                    mtd_vs_previous_month: String(i[21]),
                })
            })
        }

        let body = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "status": type,
            "profit_loss": data
        }
        console.log(data);
        api.create('UPLOAD').uploadMonthlyReportPL(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        if (type == 'submitted') {
                            this.props.saveToMonthlyReport('PL')
                        } else {
                            this.props.saveToMonthlyReport()
                        }
                        this.props.onClickClose()
                        // this.props.getReport()
                    } else {
                        if (response.data?.message == "Please Set Up Rate Currency First") {
                            this.setState({ visibleAlertSave: true })
                        } else {
                            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                                if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                    setTimeout(() => {
                                        localStorage.removeItem(Constant.TOKEN)
                                        window.location.reload();
                                    }, 1000);
                                }
                            })
                        }
                        // alert(response.data.status)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error', loading: false, handleDoubleClick: 0 })
            }
        })
    }

    handleValidate() {
        let data = []
        let err = false
        this.state.dataTable.map((i, index) => {
            if (i[0] === 3) {
                // console.log(i);
                if (i[19] === "" && (fixNumber(Number(i[16]), 1) < this.state.minValue || fixNumber(Number(i[16]), 1) > this.state.maxValue)) {
                    console.log('msk 1');
                    err = true
                }
                // if (i[19] === "" && (this.props.defaultCurrency.id == 1 ? fixNumber(Number(i[16]), 1) : Number(i[16]) < this.state.minValue || this.props.defaultCurrency.id == 1 ? fixNumber(Number(i[16]), 1) : Number(i[16]) > this.state.maxValue)) {
                //     console.log('msk 1');
                //     // console.log(i);
                //     err = true
                // }
                // else if ( i[20] === "" && (Number(i[16]) < this.state.minValue || Number(i[16]) > this.state.maxValue)) {
                //     console.log('msk 2');
                //     err = true
                // } else if ( i[21] === "" && (Number(i[18]) < this.state.minValue || Number(i[18]) > this.state.maxValue)) {
                //     console.log('msk 3');
                //     err = true
                // } 
            }
            data.push({
                "item_report_id": i[1],
                "notes": i[6],
                "rolling_outlook": i[7],
                "master_budget": i[8],
                "rolling_budget": i[9],
                "actual": i[10],
                "ytd_actual": i[11],
                "actual_previous_month": i[12],
                "amount_act_vs_previous_month": i[13],
                "percent_act_vs_previous_month": i[14],
                "amount_act_vs_mb": i[15],
                "percent_act_vs_mb": i[16],
                "amount_act_vs_rb": i[17],
                "percent_act_vs_rb": i[18],
                "mtd_vs_mb": i[19],
                "mtd_vs_rb": i[20],
                "mtd_vs_previous_month": i[21],
            })
        })

        console.log(this.state.dataTable);
        // console.log(JSON.stringify(data))
        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": "submitted",
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "profit_loss": data
        }
        console.log(JSON.stringify(payload));
        api.create().validateSubmitReportPL(payload).then((response) => {
            console.log(response)
            console.log(err);
            if (response.data) {
                if (response.data.status === "success") {
                    if (response.data.data.result && err === false) {
                        this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
                    } else {
                        this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable

        const handleText = (value, tableMeta, type) => {
            // dataTable2[tableMeta.rowIndex][type] = value
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = value
            // console.log(dataTable2);
            // console.log(dataTable2[tableMeta.rowIndex]);
        }
        const handleChange = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            if (type === "actual") {
                // console.log(val);
                dataTable2[tableMeta.rowIndex][10] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val)
            }
            // else {
            //     let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[tableMeta.rowIndex][2])
            //     if (indexParent > 0) {
            //         dataTable2[tableMeta.rowIndex][10] = Number(val).toFixed(1)
            //         let jagain = Number(dataTable2[indexParent][10]).toFixed(1)
            //         dataTable2[indexParent][10] = jagain === undefined ? (0 + Number(val)).toFixed(1) : Number(Number(jagain) + Number(val)).toFixed(1)

            //     } else {
            //         dataTable2[tableMeta.rowIndex][10] = Number(val).toFixed(1)
            //     }
            // }
        }
        const handleValue = (value, data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] == item[2] && item[0] != 4) {
                    total = item[10] == undefined ? (Number(total) + 0) : (Number(total) + Number(String(item[10]).includes('-') ? Number(String(item[10]).substr(1, String(item[10]).length)) * -1 : Number(item[10])))
                }
            })
            // if (data.rowData[5] == 'Revenue') {
            //     console.log(total)
            // }
            let indexParent = dataTable2.findIndex((val) => val[1] == dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][10] = Number(total)
            return a
        }
        const handleFormula = (data, tableMeta, type) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayJumlah = []
            let tambahan = false
            let opet = ""

            arrayFormula.map((item, indexs) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*') {
                    arrayJumlah.push(item)
                } else {
                    let index = dataTable2.findIndex((val) => val[22] == item)
                    if (tambahan) {
                        if (item == '-' || item == '+' || item == '/' || item == '*') {
                            opet = item
                        } else {
                            arrayJumlah.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                            tambahan = false
                            opet = ""
                        }
                    } else {
                        if (index != -1) {
                            arrayJumlah.push(dataTable2[index][tableMeta.columnIndex + type])
                        }
                    }
                }
            })

            let array = arrayJumlah
            let total = 0
            let opt = ""

            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                        // if (tableMeta.rowData[22] === 3) {
                        //     console.log(dataTable2[tableMeta.rowIndex]);
                        //     console.log(total);
                        //     console.log(item);
                        //     console.log(arrayJumlah);
                        // }
                    } else if (opt == "bagi") {
                        total = R.equals((Number(total) / Number(item)), NaN) ? '0' : R.equals((Number(total) / Number(item)), Infinity) ? '0' : (Number(total) / Number(item) == "-Infinity" ? '0' : Number(total) / Number(item))
                    } else {
                        total += Number(item)
                    }
                }
            })



            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total)

            return a

        }
        const handleVariance = (tableMeta, dex, type) => {
            let total = 0
            if (dex === 1) {
                total = Number(tableMeta.rowData[10]) - Number(tableMeta.rowData[12])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
            } else if (dex === 2) {
                total = Number(tableMeta.rowData[10]) - Number(tableMeta.rowData[8])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
            } else if (dex === 3) {
                total = Number(tableMeta.rowData[10]) - Number(tableMeta.rowData[9])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
            }
            return total
        }

        const handleVariancePercent = (tableMeta, dex, type) => {
            let total = 0
            if (dex === 1) {
                let selisih = Number(dataTable2[tableMeta.rowIndex][13])
                let prevMonth = Number(String(dataTable2[tableMeta.rowIndex][12]).includes('-') ? Number(dataTable2[tableMeta.rowIndex][12]) * -1 : dataTable2[tableMeta.rowIndex][12])
                total = (R.equals(selisih / prevMonth, 0)
                    || R.equals(selisih / prevMonth, NaN)
                    || R.equals(selisih / prevMonth, Infinity)
                    || R.equals(selisih / prevMonth, -Infinity)) ? 0 : (selisih / prevMonth) * 100

                // total = (Number(tableMeta.rowData[10]) > Number(tableMeta.rowData[12]))? (String(total).includes('-')? Number(total * -1).toFixed(1) : Number(total).toFixed(1)) : Number(total).toFixed(1)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = total
                // if (String(tableMeta.rowData[5]).toLocaleUpperCase() == 'CORPORATE INCOME TAX') {
                //     console.log(Number(tableMeta.rowData[10]))
                //     console.log(Number(tableMeta.rowData[12]))
                //     console.log(selisih)
                //     console.log(prevMonth)
                //     console.log(total)
                // }
                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = String(selisih).includes('-') ? Number(total * -1).toFixed(1) : Number(total).toFixed(1)
                // total = Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][12])
                // total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][13]) / 
                // Number(dataTable2[tableMeta.rowIndex][12])) * 100), NaN) ? '0' : 
                // R.equals(Number((Number(dataTable2[tableMeta.rowIndex][13]) / 
                // Number(dataTable2[tableMeta.rowIndex][12])) * 100), Infinity) ? '0' : 
                // Number((Number(dataTable2[tableMeta.rowIndex][13]) / 
                // Number(dataTable2[tableMeta.rowIndex][12])) * 100 == "-Infinity" ? '0' : 
                // (Number(dataTable2[tableMeta.rowIndex][13]) / Number(dataTable2[tableMeta.rowIndex][12])) * 100)
            } else if (dex === 2) {
                let selisih = Number(dataTable2[tableMeta.rowIndex][15])
                let prevMonth = Number(String(dataTable2[tableMeta.rowIndex][8]).includes('-') ? Number(dataTable2[tableMeta.rowIndex][8]) * -1 : dataTable2[tableMeta.rowIndex][8])
                total = R.equals(selisih / prevMonth, 0)
                    || R.equals(selisih / prevMonth, NaN)
                    || R.equals(selisih / prevMonth, Infinity)
                    || R.equals(selisih / prevMonth, -Infinity) ? 0 : (selisih / prevMonth) * 100

                // total = (Number(tableMeta.rowData[10]) > Number(tableMeta.rowData[8]))? (String(total).includes('-')? Number(total * -1).toFixed(1) : Number(total).toFixed(1)) : Number(total).toFixed(1)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = total
                // if (String(tableMeta.rowData[5]).toLocaleLowerCase() == 'corporate income tax') {
                //     console.log(String(selisih).includes('-'))
                //     console.log(selisih)
                //     console.log(prevMonth)
                //     console.log(total)
                // }
                // total = Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])
                // total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100), NaN) ? '0' : R.equals(Number((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100), Infinity) ? '0' : Number((Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100 == "-Infinity" ? '0' : (Number(dataTable2[tableMeta.rowIndex][15]) / Number(dataTable2[tableMeta.rowIndex][8])) * 100)
                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            } else if (dex === 3) {
                let selisih = Number(dataTable2[tableMeta.rowIndex][17])
                let prevMonth = Number(String(dataTable2[tableMeta.rowIndex][9]).includes('-') ? Number(dataTable2[tableMeta.rowIndex][9]) * -1 : dataTable2[tableMeta.rowIndex][9])
                total = R.equals(selisih / prevMonth, 0)
                    || R.equals(selisih / prevMonth, NaN)
                    || R.equals(selisih / prevMonth, Infinity)
                    || R.equals(selisih / prevMonth, -Infinity) ? 0 : (selisih / prevMonth) * 100

                // total = (Number(tableMeta.rowData[10]) > Number(tableMeta.rowData[9])) ? (String(total).includes('-')? Number(total * -1).toFixed(1) : Number(total).toFixed(1)) : Number(total).toFixed(1)
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = total
                // total = Number(dataTable2[tableMeta.rowIndex][17]) / Number(dataTable2[tableMeta.rowIndex][9])
                // total = R.equals(Number((Number(dataTable2[tableMeta.rowIndex][17]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100), NaN) ? '0' : R.equals(Number((Number(dataTable2[tableMeta.rowIndex][17]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100), Infinity) ? '0' : Number((Number(dataTable2[tableMeta.rowIndex][17]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100 == "-Infinity" ? '0' : (Number(dataTable2[tableMeta.rowIndex][17]) / Number(dataTable2[tableMeta.rowIndex][9])) * 100)
                // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex + type] = Number(total).toFixed(1)
            }
            return total
        }

        const handleTotal = (value, tableMeta) => {
            let total = 0

            // if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "sales price") {
            //     let value = Number(dataTable2[tableMeta.rowIndex - 2][11]) / Number(dataTable2[tableMeta.rowIndex - 1][11])
            //     dataTable2[tableMeta.rowIndex][11] = R.equals(value, NaN) ? "0.0" :  (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
            //     return R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
            // } else {
            //     dataTable2[tableMeta.rowIndex].map((item, index) => {
            //         if (index == 10) {
            //             let itemActual = item == undefined || item == "" || item == "undefined" ? 0.0 : item
            //             total = Number(tableMeta.rowData[23]) + Number(itemActual)
            //         }
            //     })
            // }
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index == 10) {
                    // ytd = ytd actual balikan be + actual
                    let itemActual = item == undefined || item == "" || item == "undefined" ? 0.0 : item
                    total = Number(tableMeta.rowData[23]) + Number(itemActual)
                }
            })

            if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "sales price") {
                // Sales Price = Unit Business / Sales Volume
                let value = Number(dataTable2[tableMeta.rowIndex - 2][11]) / Number(dataTable2[tableMeta.rowIndex - 1][11])
                dataTable2[tableMeta.rowIndex][11] = R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
                return R.equals(value, NaN) ? "0.0" : (R.equals(value, Infinity) ? "0.0" : (value == "-Infinity" ? "0.0" : value))
            } else {
                dataTable2[tableMeta.rowIndex][11] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total),) : Number(total)
                return total
            }
        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[0] === null ?
                                    tableMeta.rowData[4] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Notes",
                options: {
                    customHeadRender: (columnMeta) => (
                        dataTable2.length > 0 ?
                            <TableCell style={{ ...stylenotes, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> :
                            <TableCell style={{ ...styleNotesEmpty, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell>
                    ),
                    setCellProps: () => ({
                        style: {
                            position: "sticky",
                            background: "white",
                            zIndex: 101,
                            left: 350
                        }
                    }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                <div style={{ flex: 1 }}>
                                    {tableMeta.rowData[0] === 4 ? null : tableMeta.rowData[4] === 0 ? null : tableMeta.rowData[4] === 1 ? null :
                                        this.state.get_for == 'view' ?
                                            <Input
                                                disableUnderline={true}
                                                style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                disabled={true}
                                                defaultValue={tableMeta.rowData[6]}
                                            />
                                            :
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                // value={tableMeta.rowData[6]}
                                                control={
                                                    <Input
                                                        disableUnderline={true}
                                                        style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // value={tableMeta.rowData[6]}
                                                        defaultValue={tableMeta.rowData[6]}
                                                        inputProps={{
                                                            style: {
                                                                color: "#5198ea"
                                                            }
                                                        }}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleText(event.target.value, tableMeta, 0)
                                                            // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />}
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: `Rolling Outlook (FY ${this.props.periode})`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#07a7d0', width: 96, borderLeft: '1px #fff solid', borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null
                                    :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={fixNumber(Number(tableMeta.rowData[7]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[7]), 1)}
                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                        />
                                        :
                                        // tableMeta.rowData[0] === 6 ?
                                        //     <div style={{ flex: 1 }}>
                                        //         <FormControlLabel
                                        //             style={{ margin: 0 }}
                                        //             value={tableMeta.rowData[7]}
                                        //             control={
                                        //                 <NumberFormat
                                        //                     thousandSeparator={true}
                                        //                     style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                        //                     type="text"
                                        //                     placeholder=""
                                        //                     disabled={true}
                                        //                     value={Number(handleFormula(val, tableMeta, 0)).toFixed(1)}
                                        //                     decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                        //                 />
                                        //             }
                                        //         />
                                        //     </div>
                                        //     :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[7]), 1) : Number(tableMeta.rowData[7]) == 0 ? "0.0" : Number(tableMeta.rowData[7])}
                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: `Month To Date (MTD)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, color: '#fff', backgroundColor: '#1c71b8', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                  <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                              </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", backgroundColor: '#1c71b8', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 40, fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Master Budget (MB)"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", backgroundColor: '#07a7d0', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Rolling Budget (RB)"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, backgroundColor: '#37b5e6', justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"Actual"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(tableMeta.rowData[8]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[8]), 1)}
                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    />
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={tableMeta.rowData[8]}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[8]), 1) : Number(tableMeta.rowData[8]) == 0 ? "0.0" : Number(tableMeta.rowData[8])}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(tableMeta.rowData[9]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[9]), 1)}
                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    />
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={tableMeta.rowData[9]}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[9]), 1) : Number(tableMeta.rowData[9]) == 0 ? "0.0" : Number(tableMeta.rowData[9])}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                            }
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'right', width: 90 }}>
                                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                null :
                                                this.state.get_for == 'view' ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                        value={fixNumber(Number(tableMeta.rowData[10]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[10]), 1)}
                                                    // decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 3 ?
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={tableMeta.rowData[10]}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ color: this.props.isApprover || this.state.get_for == 'view' ? 'black' : "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[10]), 1) : Number(tableMeta.rowData[10]) == 0 ? "0.0" : Number(tableMeta.rowData[10])}
                                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        onBlur={(event) => {
                                                                            handleChange(event.target.value, tableMeta, "actual")
                                                                        }}
                                                                    />
                                                                }
                                                            />
                                                        </div> :
                                                        tableMeta.rowData[0] === 2 ?
                                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(value, tableMeta)), 1) : Number(handleValue(value, tableMeta)) == 0 ? "0.0" : Number(handleValue(value, tableMeta))}
                                                                // value={Number(handleValue(tableMeta, 2)).toFixed(1)}
                                                                />
                                                            </span> :
                                                            tableMeta.rowData[0] === 6 || tableMeta.rowData[0] === 5 ?
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={tableMeta.rowData[10]}
                                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleFormula(value, tableMeta, 2)), 1) : Number(handleFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleFormula(value, tableMeta, 2))}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                                                :
                                                                <div style={{ flex: 1 }}>
                                                                    <FormControlLabel
                                                                        style={{ margin: 0 }}
                                                                        value={tableMeta.rowData[10]}
                                                                        control={
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[10]), 1) : Number(tableMeta.rowData[10]) == 0 ? "0.0" : Number(tableMeta.rowData[10])}
                                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                            />
                                                                        }
                                                                    />
                                                                </div>
                                            }
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "YTD Actual",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={fixNumber(Number(tableMeta.rowData[23]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[23]), 1)}
                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleTotal(tableMeta.rowData[11], tableMeta)), 1) : Number(handleTotal(tableMeta.rowData[11], tableMeta)) == 0 ? "0.0" : Number(handleTotal(tableMeta.rowData[11], tableMeta))}
                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: "Actual Previous Month",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValuvale) => {
                        return (
                            <div style={{ textAlign: 'right', width: 90 }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={fixNumber(Number(tableMeta.rowData[12]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[12]), 1)}
                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(tableMeta.rowData[12]), 1) : Number(tableMeta.rowData[12]) == 0 ? "0.0" : Number(tableMeta.rowData[12])}
                                                        decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: `Variance`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                            <div style={{ borderBottom: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 40 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                    <div style={{ borderBottom: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                        <span>{"Act vs Previous Month"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid', backgroundColor: '#37b5e6' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#07a7d0' }}>
                                    <div style={{ borderBottom: '1px #fff solid' }}>
                                        <span>{"Act vs MB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, border: '1px #fff solid', backgroundColor: '#07a7d0' }}>
                                    <div style={{ borderBottom: '1px #fff solid' }}>
                                        <span>{"Act vs RB"}</span>
                                    </div>
                                    <div className="grid grid-2x">
                                        <div className="column-1" style={{ borderRight: '1px #fff solid' }}>
                                            <span>{"Amount"}</span>
                                        </div>
                                        <div className="column-2" style={{ borderLeft: '1px #fff solid' }}>
                                            <span>{"%"}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 10
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        // console.log(tableMeta);
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="column-1">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[13]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[13]), 1)}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariance(tableMeta, 1, 0)), 1) : Number(handleVariance(tableMeta, 1, 0)) == 0 ? "0.0" : Number(handleVariance(tableMeta, 1, 0))}
                                                                            // value={Number(tableMeta.rowData[13]) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariance(tableMeta, 1, 0)), 1) : Number(handleVariance(tableMeta, 1, 0))}
                                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[14]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[14]), 1)}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: Number(tableMeta.rowData[14]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[14]).toFixed(1) > this.state.maxValue ? 'red' : '#000000b0', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            suffix={'%'}
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleVariancePercent(tableMeta, 1, 1)), 1) == 0 ? "0.0" : fixNumber(Number(handleVariancePercent(tableMeta, 1, 1)), 1)}
                                                                            // value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariancePercent(tableMeta, 1, 1)), 1) : Number(handleVariancePercent(tableMeta, 1, 1))}
                                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        // value={11}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="column-2">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[15]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[15]), 1)}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariance(tableMeta, 2, 2)), 1) : Number(handleVariance(tableMeta, 2, 2)) == 0 ? "0.0" : Number(handleVariance(tableMeta, 2, 2))}
                                                                            // value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariance(tableMeta, 2, 2)), 1) : Number(handleVariance(tableMeta, 2, 2))}
                                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[16]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[16]), 1)}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ color: Number(tableMeta.rowData[16]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[16]).toFixed(1) > this.state.maxValue ? 'red' : '#000000b0', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            suffix={'%'}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleVariancePercent(tableMeta, 2, 3)), 1) == 0 ? "0.0" : fixNumber(Number(handleVariancePercent(tableMeta, 2, 3)), 1)}
                                                                            // value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariancePercent(tableMeta, 2, 3)), 1) : Number(handleVariancePercent(tableMeta, 2, 3))}
                                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="column-3">
                                        <div className="grid grid-2x content-center">
                                            <div className="column-1">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[17]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[17]), 1)}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleVariance(tableMeta, 3, 4)), 1) : Number(handleVariance(tableMeta, 3, 4)) == 0 ? "0.0" : Number(handleVariance(tableMeta, 3, 4))}
                                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                            <div className="column-2">
                                                <div style={{ textAlign: 'right', width: 120 }}>
                                                    {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        this.state.get_for == 'view' ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                suffix={'%'}
                                                                disabled={true}
                                                                value={fixNumber(Number(tableMeta.rowData[18]), 1) == 0 ? "0.0" : fixNumber(Number(tableMeta.rowData[18]), 1)}
                                                                decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                            />
                                                            :
                                                            <div style={{ flex: 1 }}>
                                                                <FormControlLabel
                                                                    style={{ margin: 0 }}
                                                                    value={val}
                                                                    control={
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            // style={{ color: 'red', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            style={{ color: Number(tableMeta.rowData[18]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[18]).toFixed(1) > this.state.maxValue ? 'red' : '#000000b0', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                            suffix={'%'}
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleVariancePercent(tableMeta, 3, 5)), 1) == 0 ? "0.0" : fixNumber(Number(handleVariancePercent(tableMeta, 3, 5)), 1)}
                                                                            decimalScale={this.props.defaultCurrency.id == 1 ? 1 : 16}
                                                                        />
                                                                    }
                                                                />
                                                            </div>
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: `MTD Explanation`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)", padding: 0 }} >
                            {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                                <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                            </TableCell> */}
                            <div style={{ borderBottom: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, height: 40 }}>{columnMeta.name}</div>
                            <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                                <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs MB"}</span>
                                </div>
                                <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, borderRight: "1px #fff solid", justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs RB"}</span>
                                </div>
                                <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5, justifyContent: 'center', display: 'flex', alignItems: 'center', height: 45 }}>
                                    <span>{"vs Prev Month"}</span>
                                </div>
                            </div>
                        </th>
                    ),
                    setCellProps: () => ({
                        style: {
                            paddingLeft: 0,
                            paddingRight: 0
                        }
                    }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div>
                                <div className="grid grid-3x content-center">
                                    <div className="col-1">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 3 ?
                                                    this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            multiline={true}
                                                            disabled={true}
                                                            defaultValue={tableMeta.rowData[19]}
                                                            inputProps={{
                                                                style: {
                                                                    color: Number(tableMeta.rowData[16]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[16]).toFixed(1) > this.state.maxValue ? "#5198ea" : '#5198ea',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                            onBlur={(event) => {
                                                                handleText(event.target.value, tableMeta, 0)
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={tableMeta.rowData[19]}
                                                            control={
                                                                tableMeta.rowData[19] === "" && (Number(tableMeta.rowData[16]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[16]).toFixed(1) > this.state.maxValue) ?
                                                                    <LightTooltipError title={"MTD Explanation vs MB is Reqiured"} arrow>
                                                                        <Input
                                                                            disableUnderline={true}
                                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', minHeight: 30, padding: 0 }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            multiline={true}
                                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                            // value={tableMeta.rowData[19]}
                                                                            defaultValue={tableMeta.rowData[19]}
                                                                            inputProps={{
                                                                                style: {
                                                                                    color: "#5198ea",
                                                                                    textAlign: 'left',
                                                                                    backgroundColor: '#ffac99',
                                                                                    minHeight: 30,
                                                                                    padding: 0
                                                                                }
                                                                            }}
                                                                            onBlur={(event) => {
                                                                                handleText(event.target.value, tableMeta, 0)
                                                                            }}
                                                                        />
                                                                    </LightTooltipError>
                                                                    :
                                                                    <Input
                                                                        disableUnderline={true}
                                                                        style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        multiline={true}
                                                                        disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                        defaultValue={tableMeta.rowData[19]}
                                                                        inputProps={{
                                                                            style: {
                                                                                color: Number(tableMeta.rowData[16]).toFixed(1) < this.state.minValue || Number(tableMeta.rowData[16]).toFixed(1) > this.state.maxValue ? "#5198ea" : '#5198ea',
                                                                                textAlign: 'left'
                                                                            }
                                                                        }}
                                                                        onBlur={(event) => {
                                                                            handleText(event.target.value, tableMeta, 0)
                                                                        }}
                                                                    />
                                                            }
                                                        />
                                                    :
                                                    null
                                                }
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-2">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 3 ?
                                                    this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            multiline={true}
                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                            defaultValue={tableMeta.rowData[20]}
                                                            inputProps={{
                                                                style: {
                                                                    color: '#5198ea',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                            onBlur={(event) => {
                                                                handleText(event.target.value, tableMeta, 1)
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={value}
                                                            control={
                                                                <Input
                                                                    disableUnderline={true}
                                                                    style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    multiline={true}
                                                                    disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                    defaultValue={tableMeta.rowData[20]}
                                                                    inputProps={{
                                                                        style: {
                                                                            color: '#5198ea',
                                                                            textAlign: 'left'
                                                                        }
                                                                    }}
                                                                    onBlur={(event) => {
                                                                        handleText(event.target.value, tableMeta, 1)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    :
                                                    null
                                                }
                                            </div>
                                        </div>
                                    </div>
                                    <div className="col-3">
                                        <div style={{ textAlign: 'left', width: 90 }}>
                                            <div style={{ flex: 1 }}>
                                                {tableMeta.rowData[0] === 3 ?
                                                    this.state.get_for == 'view' ?
                                                        <Input
                                                            disableUnderline={true}
                                                            style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            multiline={true}
                                                            disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                            defaultValue={tableMeta.rowData[21]}
                                                            inputProps={{
                                                                style: {
                                                                    color: '#5198ea',
                                                                    textAlign: 'left'
                                                                }
                                                            }}
                                                            onBlur={(event) => {
                                                                handleText(event.target.value, tableMeta, 2)
                                                            }}
                                                        />
                                                        :
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            // value={value}
                                                            control={
                                                                <Input
                                                                    disableUnderline={true}
                                                                    style={{ fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    multiline={true}
                                                                    disabled={this.props.isApprover ? true : (this.state.get_for == 'view' ? true : false)}
                                                                    defaultValue={tableMeta.rowData[21]}
                                                                    inputProps={{
                                                                        style: {
                                                                            color: '#5198ea',
                                                                            textAlign: 'left'
                                                                        }
                                                                    }}
                                                                    onBlur={(event) => {
                                                                        handleText(event.target.value, tableMeta, 2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    :
                                                    null
                                                }
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                {this.state.loading && loadingComponent}
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visiblePLMR ?
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Profit Loss</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.month.month_value} {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.props.isApprover === true || this.state.get_for == 'view' ?
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            // </div> 
                                            null
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.downloadTemplate()}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>
                                                {/* <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {!this.state.refresh && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                    {this.state.get_for == 'view' && this.state.viewOnly && <div style={{ color: '#000', marginTop: 10, fontSize: 12 }}>(*) There may be discrepancies in amount due to rounding</div>}
                                </div>

                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5 }}>Notes : {this.state.notesUpdate}</Typography>

                                <div style={{ display: 'flex', maxWidth: '100%', paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, textDecorationLine: 'underline' }}>Notes:</Typography>
                                </div>
                                <div style={{ display: 'flex', maxWidth: '100%', paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5, fontWeight: 'bold' }}>Rolling Outlook (Full Year) or Rolling Budget (RB)</Typography>
                                </div>
                                <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Jan-Mar = MB figures</Typography>
                                </div>
                                <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Apr-Jun = OL Q1 figures or MB figures (if OL Q1 not available)</Typography>
                                </div>
                                <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Jul-Sep = OL Q2 figures or OL Q1 (if OL Q2 not available) or MB (if OL Q2 and OL Q1 not available)</Typography>
                                </div>
                                <div style={{ display: 'flex', paddingLeft: 10, justifyContent: 'space-between', maxWidth: '100%', paddingRight: 15 }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 0 }}>Period Oct-Dec = OL Q3 figures or OL Q2 (if OL Q3 not available) and consecutive to the MB</Typography>
                                </div>
                            </div>
                            {/* {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                            (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? */}
                            <div className="grid grid-2x" style={{ padding: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly &&
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => {
                                                    this.setState({ loading: true, refresh: true }, () => {
                                                        this.handleGetFor('edit')
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                                </div>
                                            </button>
                                        }
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToMonthlyReport('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToMonthlyReport('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                            {/* : null
                            } */}
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Profit Loss</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.month.month_value} {this.props.periode} (rev.{this.props.revision})</Typography>
                                    {this.props.defaultCurrency.id === 1 ?
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                        :
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                    }
                                </div>
                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.dataLoaded && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>
                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1" style={{ paddingLeft: 0 }}>
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visiblePLMR: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        // this.setState({ loading: false })
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadProfitLossMR('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadProfitLossMR('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>}
                </div>

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") && String(this.state.judul).includes("PROFIT") && String(this.state.judul).includes("LOSS") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, loading: false, handleDoubleClick: 0 })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        )
    }
}